/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.schema;

import com.ibm.wsdl.extensions.schema.SchemaImportImpl;
import com.ibm.wsdl.extensions.schema.SchemaReferenceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SchemaImpl
implements Schema {
    private QName elementType = null;
    private Boolean required = null;
    private Element element = null;
    public static final long serialVersionUID = 1L;
    private final Map<String, List<SchemaImport>> imports = new HashMap<String, List<SchemaImport>>();
    private final List<SchemaReference> includes = new ArrayList<SchemaReference>();
    private final List<SchemaReference> redefines = new ArrayList<SchemaReference>();
    private String documentBaseURI = null;

    @Override
    public Map<String, List<SchemaImport>> getImports() {
        return this.imports;
    }

    @Override
    public SchemaImport createImport() {
        return new SchemaImportImpl();
    }

    @Override
    public void addImport(SchemaImport importSchema) {
        String namespaceURI = importSchema.getNamespaceURI();
        List importList = this.imports.computeIfAbsent(namespaceURI, key -> new ArrayList());
        importList.add(importSchema);
    }

    @Override
    public List<SchemaReference> getIncludes() {
        return this.includes;
    }

    @Override
    public SchemaReference createInclude() {
        return new SchemaReferenceImpl();
    }

    @Override
    public void addInclude(SchemaReference includeSchema) {
        this.includes.add(includeSchema);
    }

    @Override
    public List<SchemaReference> getRedefines() {
        return this.redefines;
    }

    @Override
    public SchemaReference createRedefine() {
        return new SchemaReferenceImpl();
    }

    @Override
    public void addRedefine(SchemaReference redefineSchema) {
        this.redefines.add(redefineSchema);
    }

    public String toString() {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("SchemaExtensibilityElement (" + String.valueOf(this.elementType) + "):");
        strBuf.append("\nrequired=" + this.required);
        if (this.element != null) {
            strBuf.append("\nelement=" + String.valueOf(this.element));
        }
        return strBuf.toString();
    }

    @Override
    public void setElementType(QName elementType) {
        this.elementType = elementType;
    }

    @Override
    public QName getElementType() {
        return this.elementType;
    }

    @Override
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public void setDocumentBaseURI(String documentBaseURI) {
        this.documentBaseURI = documentBaseURI;
    }

    @Override
    public String getDocumentBaseURI() {
        return this.documentBaseURI;
    }
}

