/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.List;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;

public abstract class GenericLoader<T extends Assembler>
implements Loader<T> {
    protected AssemblerBrokerService ab;
    private final Class<T> assemblerClass;
    private final IntSupplier cacheSizeSupplier;
    private boolean reload = false;
    private static final String TURBINE_PACKAGE = "org.apache.turbine.modules";
    private static List<String> TURBINE_PACKAGES = null;

    public GenericLoader(Class<T> assemblerClass, IntSupplier cacheSizeSupplier) {
        this.assemblerClass = assemblerClass;
        this.cacheSizeSupplier = cacheSizeSupplier;
        this.ab = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
    }

    public abstract void exec(PipelineData var1, String var2) throws Exception;

    public boolean reload() {
        return this.reload;
    }

    public GenericLoader<T> setReload(boolean reload) {
        this.reload = reload;
        return this;
    }

    public static String getBasePackage() {
        return TURBINE_PACKAGE;
    }

    public static List<String> getPackages() {
        List<String> packages;
        if (TURBINE_PACKAGES == null) {
            List turbinePackages = Turbine.getConfiguration().getList("module.packages").stream().map(o -> (String)o).collect(Collectors.toList());
            TURBINE_PACKAGES = turbinePackages;
        }
        if (!(packages = TURBINE_PACKAGES).contains(TURBINE_PACKAGE)) {
            packages.add(TURBINE_PACKAGE);
        }
        return packages;
    }

    @Override
    public T getAssembler(String name) throws Exception {
        return this.getAssembler(this.assemblerClass, name);
    }

    protected T getAssembler(Class<T> type, String name) throws Exception {
        T asm = null;
        try {
            if (this.ab != null) {
                asm = this.ab.getAssembler(type, name);
            }
        }
        catch (ClassCastException cce) {
            asm = null;
        }
        if (asm == null) {
            List<String> packages = GenericLoader.getPackages();
            throw new ClassNotFoundException("\n\n\tRequested " + String.valueOf(type) + " not found: " + name + "\n\tTurbine looked in the following modules.packages path: \n\t" + packages.toString() + "\n");
        }
        return asm;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSizeSupplier.getAsInt();
    }
}

