/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.management.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.scr.management.ServiceComponentRuntimeMBean;
import org.apache.karaf.scr.management.codec.JmxProperty;
import org.apache.karaf.scr.management.codec.JmxSvcReference;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;

public class JmxComponentConfiguration {
    public static final CompositeType COMPONENT_CONFIGURATION = JmxComponentConfiguration.createComponentConfigurationType();
    public static final TabularType COMPONENT_TABLE = JmxComponentConfiguration.createComponentTableType();
    private final CompositeData data;

    public JmxComponentConfiguration(ComponentConfigurationDTO component) {
        try {
            String[] itemNames = ServiceComponentRuntimeMBean.COMPONENT_CONFIGURATION;
            Object[] itemValues = new Object[itemNames.length];
            itemValues[0] = component.description.bundle.id;
            itemValues[1] = component.description.name;
            itemValues[2] = this.getState(component);
            itemValues[3] = component.id;
            itemValues[4] = JmxProperty.tableFrom(component.properties);
            itemValues[5] = JmxSvcReference.tableFrom(component.satisfiedReferences);
            itemValues[6] = JmxSvcReference.tableFrom(component.unsatisfiedReferences);
            this.data = new CompositeDataSupport(COMPONENT_CONFIGURATION, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form feature open data", e);
        }
    }

    private String getState(ComponentConfigurationDTO component) {
        switch (component.state) {
            case 1: {
                return "Unsatisfied configuration";
            }
            case 2: {
                return "Unstatisfied reference";
            }
            case 4: {
                return "Statisfied";
            }
            case 8: {
                return "Active";
            }
        }
        return "Unknown";
    }

    public CompositeData asCompositeData() {
        return this.data;
    }

    public static TabularData tableFrom(ComponentConfigurationDTO ... components) {
        return JmxComponentConfiguration.tableFrom(Arrays.asList(components));
    }

    public static TabularData tableFrom(Collection<ComponentConfigurationDTO> components) {
        return JmxComponentConfiguration.tableFrom(components.stream());
    }

    public static TabularData tableFrom(Stream<ComponentConfigurationDTO> components) {
        return components.map(JmxComponentConfiguration::new).map(JmxComponentConfiguration::asCompositeData).collect(() -> new TabularDataSupport(COMPONENT_TABLE), TabularDataSupport::put, TabularDataSupport::putAll);
    }

    private static CompositeType createComponentConfigurationType() {
        try {
            String description = "This type encapsulates Scr references";
            String[] itemNames = ServiceComponentRuntimeMBean.COMPONENT_CONFIGURATION;
            OpenType[] itemTypes = new OpenType[itemNames.length];
            String[] itemDescriptions = new String[itemNames.length];
            itemTypes[0] = SimpleType.LONG;
            itemTypes[1] = SimpleType.STRING;
            itemTypes[2] = SimpleType.STRING;
            itemTypes[3] = SimpleType.LONG;
            itemTypes[4] = JmxProperty.PROPERTY_TABLE;
            itemTypes[5] = JmxSvcReference.SVC_REFERENCE_TABLE;
            itemTypes[6] = JmxSvcReference.SVC_REFERENCE_TABLE;
            itemDescriptions[0] = "The bundle id of the component";
            itemDescriptions[1] = "The name of the component";
            itemDescriptions[2] = "The state of the component";
            itemDescriptions[3] = "The id of the component";
            itemDescriptions[4] = "The properties of the component";
            itemDescriptions[5] = "The references of the component";
            itemDescriptions[6] = "The references of the component";
            return new CompositeType("Component", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build component type", e);
        }
    }

    private static TabularType createComponentTableType() {
        try {
            return new TabularType("Configuration", "The table of component configurations", COMPONENT_CONFIGURATION, ServiceComponentRuntimeMBean.COMPONENT_CONFIGURATION);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build components table type", e);
        }
    }
}

