/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.route;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.unomi.router.core.processor.ImportRouteCompletionProcessor;
import org.apache.unomi.router.core.processor.UnomiStorageProcessor;
import org.apache.unomi.router.core.route.RouterAbstractRouteBuilder;
import org.apache.unomi.router.core.strategy.ArrayListAggregationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileImportToUnomiRouteBuilder
extends RouterAbstractRouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProfileImportToUnomiRouteBuilder.class.getName());
    private UnomiStorageProcessor unomiStorageProcessor;
    private ImportRouteCompletionProcessor importRouteCompletionProcessor;

    public ProfileImportToUnomiRouteBuilder(Map<String, String> kafkaProps, String configType) {
        super(kafkaProps, configType);
    }

    public void configure() throws Exception {
        LOGGER.info("Configure Recurrent Route 'To Target'");
        RouteDefinition rtDef = "kafka".equals(this.configType) ? this.from((Endpoint)((KafkaEndpoint)this.getEndpointURI("to", "direct:depositImportBuffer"))) : this.from((String)this.getEndpointURI("to", "direct:depositImportBuffer"));
        ((AggregateDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)rtDef.choice().when(this.header("failedMessage").isNull()).unmarshal((DataFormat)this.jacksonDataFormat)).process((Processor)this.unomiStorageProcessor)).otherwise().log(LoggingLevel.WARN, "Failed message, skip processing!")).end().aggregate((Expression)this.constant(true), (AggregationStrategy)new ArrayListAggregationStrategy()).completionPredicate(this.exchangeProperty("CamelSplitComplete").isEqualTo((Object)"true")).eagerCheckCompletion().process((Processor)this.importRouteCompletionProcessor)).to("log:org.apache.unomi.router?level=DEBUG");
    }

    public void setUnomiStorageProcessor(UnomiStorageProcessor unomiStorageProcessor) {
        this.unomiStorageProcessor = unomiStorageProcessor;
    }

    public void setImportRouteCompletionProcessor(ImportRouteCompletionProcessor importRouteCompletionProcessor) {
        this.importRouteCompletionProcessor = importRouteCompletionProcessor;
    }
}

