/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.shell.group;

import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.cellar.shell.group.GroupSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="group-delete", description="Delete a cluster group")
@Service
public class GroupDeleteCommand
extends GroupSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;

    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        if (group.getNodes() != null && !group.getNodes().isEmpty()) {
            System.err.println("Cluster group " + this.groupName + " is not empty");
            return null;
        }
        this.groupManager.deleteGroup(this.groupName);
        return null;
    }
}

