﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppSync {
namespace Model {

/**
 * <p>Describes the ARNs and IDs of associations, Merged APIs, and source
 * APIs.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/SourceApiAssociationSummary">AWS
 * API Reference</a></p>
 */
class SourceApiAssociationSummary {
 public:
  AWS_APPSYNC_API SourceApiAssociationSummary() = default;
  AWS_APPSYNC_API SourceApiAssociationSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPSYNC_API SourceApiAssociationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPSYNC_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID generated by the AppSync service for the source API association.</p>
   */
  inline const Aws::String& GetAssociationId() const { return m_associationId; }
  inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }
  template <typename AssociationIdT = Aws::String>
  void SetAssociationId(AssociationIdT&& value) {
    m_associationIdHasBeenSet = true;
    m_associationId = std::forward<AssociationIdT>(value);
  }
  template <typename AssociationIdT = Aws::String>
  SourceApiAssociationSummary& WithAssociationId(AssociationIdT&& value) {
    SetAssociationId(std::forward<AssociationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the source API association.</p>
   */
  inline const Aws::String& GetAssociationArn() const { return m_associationArn; }
  inline bool AssociationArnHasBeenSet() const { return m_associationArnHasBeenSet; }
  template <typename AssociationArnT = Aws::String>
  void SetAssociationArn(AssociationArnT&& value) {
    m_associationArnHasBeenSet = true;
    m_associationArn = std::forward<AssociationArnT>(value);
  }
  template <typename AssociationArnT = Aws::String>
  SourceApiAssociationSummary& WithAssociationArn(AssociationArnT&& value) {
    SetAssociationArn(std::forward<AssociationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the AppSync source API.</p>
   */
  inline const Aws::String& GetSourceApiId() const { return m_sourceApiId; }
  inline bool SourceApiIdHasBeenSet() const { return m_sourceApiIdHasBeenSet; }
  template <typename SourceApiIdT = Aws::String>
  void SetSourceApiId(SourceApiIdT&& value) {
    m_sourceApiIdHasBeenSet = true;
    m_sourceApiId = std::forward<SourceApiIdT>(value);
  }
  template <typename SourceApiIdT = Aws::String>
  SourceApiAssociationSummary& WithSourceApiId(SourceApiIdT&& value) {
    SetSourceApiId(std::forward<SourceApiIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the AppSync Source API.</p>
   */
  inline const Aws::String& GetSourceApiArn() const { return m_sourceApiArn; }
  inline bool SourceApiArnHasBeenSet() const { return m_sourceApiArnHasBeenSet; }
  template <typename SourceApiArnT = Aws::String>
  void SetSourceApiArn(SourceApiArnT&& value) {
    m_sourceApiArnHasBeenSet = true;
    m_sourceApiArn = std::forward<SourceApiArnT>(value);
  }
  template <typename SourceApiArnT = Aws::String>
  SourceApiAssociationSummary& WithSourceApiArn(SourceApiArnT&& value) {
    SetSourceApiArn(std::forward<SourceApiArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the AppSync Merged API.</p>
   */
  inline const Aws::String& GetMergedApiId() const { return m_mergedApiId; }
  inline bool MergedApiIdHasBeenSet() const { return m_mergedApiIdHasBeenSet; }
  template <typename MergedApiIdT = Aws::String>
  void SetMergedApiId(MergedApiIdT&& value) {
    m_mergedApiIdHasBeenSet = true;
    m_mergedApiId = std::forward<MergedApiIdT>(value);
  }
  template <typename MergedApiIdT = Aws::String>
  SourceApiAssociationSummary& WithMergedApiId(MergedApiIdT&& value) {
    SetMergedApiId(std::forward<MergedApiIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>
   */
  inline const Aws::String& GetMergedApiArn() const { return m_mergedApiArn; }
  inline bool MergedApiArnHasBeenSet() const { return m_mergedApiArnHasBeenSet; }
  template <typename MergedApiArnT = Aws::String>
  void SetMergedApiArn(MergedApiArnT&& value) {
    m_mergedApiArnHasBeenSet = true;
    m_mergedApiArn = std::forward<MergedApiArnT>(value);
  }
  template <typename MergedApiArnT = Aws::String>
  SourceApiAssociationSummary& WithMergedApiArn(MergedApiArnT&& value) {
    SetMergedApiArn(std::forward<MergedApiArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description field.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  SourceApiAssociationSummary& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_associationId;

  Aws::String m_associationArn;

  Aws::String m_sourceApiId;

  Aws::String m_sourceApiArn;

  Aws::String m_mergedApiId;

  Aws::String m_mergedApiArn;

  Aws::String m_description;
  bool m_associationIdHasBeenSet = false;
  bool m_associationArnHasBeenSet = false;
  bool m_sourceApiIdHasBeenSet = false;
  bool m_sourceApiArnHasBeenSet = false;
  bool m_mergedApiIdHasBeenSet = false;
  bool m_mergedApiArnHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppSync
}  // namespace Aws
