/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.storage.BytesContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.data.IStreamValueEditor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.editors.binary.BinaryContent;
import org.jkiss.dbeaver.ui.editors.binary.HexEditControl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class BinaryPanelEditor
implements IStreamValueEditor<HexEditControl> {
    private static final Log log = Log.getLog(BinaryPanelEditor.class);
    private IValueController valueController;

    public HexEditControl createControl(IValueController valueController) {
        this.valueController = valueController;
        final HexEditControl hControl = new HexEditControl(valueController.getEditPlaceholder(), 2056);
        DBPPreferenceListener preferencesChangeListener = new DBPPreferenceListener(){

            public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
                if ("default.hex.width".equals(event.getProperty())) {
                    String defValue = (String)event.getNewValue();
                    hControl.setDefWidth(Integer.parseInt(defValue));
                }
            }
        };
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.addPropertyChangeListener(preferencesChangeListener);
        hControl.addDisposeListener(e -> store.removePropertyChangeListener(preferencesChangeListener));
        DBCExecutionContext executionContext = valueController.getExecutionContext();
        if (executionContext != null) {
            DBPDataSourceContainer container = executionContext.getDataSource().getContainer();
            DBPEventListener listener = e -> hControl.setReadOnly(container.isConnectionReadOnly() || valueController.isReadOnly());
            DBPDataSourceRegistry registry = container.getRegistry();
            registry.addDataSourceListener(listener);
            hControl.addDisposeListener(e -> {
                boolean bl = registry.removeDataSourceListener(listener);
            });
        }
        return hControl;
    }

    public void primeEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull HexEditControl control, @NotNull DBDContent value) throws DBException {
        monitor.beginTask("Prime content value", 1);
        try {
            ByteBuffer byteBuffer;
            DBDContentStorage data = value.getContents(monitor);
            String charset = null;
            monitor.subTask("Read binary value");
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            if (data != null) {
                Throwable throwable = null;
                Object var8_10 = null;
                try (InputStream contentStream = data.getContentStream();){
                    ContentUtils.copyStreams((InputStream)contentStream, (long)-1L, (OutputStream)buffer, (DBRProgressMonitor)monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                charset = data.getCharset();
            } else {
                charset = DBValueFormatting.getDefaultBinaryFileEncoding((DBPDataSource)value.getDataSource());
            }
            String finalCharset = charset;
            byte[] byteData = buffer.toByteArray();
            BinaryContent content = control.getContent();
            if (content != null && content.length() == (long)byteData.length && Arrays.equals((byteBuffer = ByteBuffer.allocate(byteData.length)).array(), byteData)) {
                return;
            }
            try {
                UIUtils.syncExec(() -> {
                    control.setContent(byteData, finalCharset, false);
                    control.setReadOnly(value.getDataSource().getContainer().isConnectionReadOnly() || this.valueController.isReadOnly());
                });
            }
            catch (IOException e) {
                throw new DBException("Error reading stream value", (Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void extractEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull HexEditControl control, @NotNull DBDContent value) throws DBException {
        BinaryContent binaryContent = control.getContent();
        if (binaryContent != null) {
            ByteBuffer buffer = ByteBuffer.allocate((int)binaryContent.length());
            try {
                binaryContent.get(buffer, 0L);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            value.updateContents(monitor, (DBDContentStorage)new BytesContentStorage(buffer.array(), GeneralUtils.getDefaultFileEncoding()));
        }
    }

    public void contributeActions(@NotNull IContributionManager manager, final @NotNull HexEditControl control) throws DBCException {
        manager.add((IAction)new Action("Switch Insert/Overwrite mode", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CURSOR)){

            public void run() {
                control.redrawCaret(true);
            }
        });
    }

    public void contributeSettings(@NotNull IContributionManager manager, @NotNull HexEditControl control) throws DBCException {
    }
}

