/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.util.NoSuchElementException;
import java.util.function.Function;
import org.jetbrains.kotlin.io.vavr.collection.AbstractIterator;
import org.jetbrains.kotlin.io.vavr.collection.Array;
import org.jetbrains.kotlin.io.vavr.collection.Iterator;
import org.jetbrains.kotlin.io.vavr.collection.Seq;
import org.jetbrains.kotlin.io.vavr.collection.Set;

interface IteratorModule {

    public static final class CachedIterator<T>
    extends AbstractIterator<T> {
        private final Iterator<T> that;
        private T next;
        private boolean cached = false;

        CachedIterator(Iterator<T> that) {
            this.that = that;
        }

        @Override
        public boolean hasNext() {
            return this.cached || this.that.hasNext();
        }

        @Override
        public T getNext() {
            if (this.cached) {
                T result2 = this.next;
                this.next = null;
                this.cached = false;
                return result2;
            }
            return (T)this.that.next();
        }

        T touch() {
            this.next = this.next();
            this.cached = true;
            return this.next;
        }
    }

    public static final class GroupedIterator<T>
    implements Iterator<Seq<T>> {
        private final Iterator<T> that;
        private final int size;
        private final int step;
        private final int gap;
        private final int preserve;
        private Object[] buffer;

        GroupedIterator(Iterator<T> that, int size, int step) {
            if (size < 1 || step < 1) {
                throw new IllegalArgumentException("size (" + size + ") and step (" + step + ") must both be positive");
            }
            this.that = that;
            this.size = size;
            this.step = step;
            this.gap = Math.max(step - size, 0);
            this.preserve = Math.max(size - step, 0);
            this.buffer = GroupedIterator.take(that, new Object[size], 0, size);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.length > 0;
        }

        @Override
        public Seq<T> next() {
            if (this.buffer.length == 0) {
                throw new NoSuchElementException();
            }
            Object[] result2 = this.buffer;
            if (this.that.hasNext()) {
                this.buffer = new Object[this.size];
                if (this.preserve > 0) {
                    System.arraycopy(result2, this.step, this.buffer, 0, this.preserve);
                }
                if (this.gap > 0) {
                    GroupedIterator.drop(this.that, this.gap);
                    this.buffer = GroupedIterator.take(this.that, this.buffer, this.preserve, this.size);
                } else {
                    this.buffer = GroupedIterator.take(this.that, this.buffer, this.preserve, this.step);
                }
            } else {
                this.buffer = new Object[0];
            }
            return Array.wrap(result2);
        }

        private static void drop(Iterator<?> source, int count) {
            for (int i2 = 0; i2 < count && source.hasNext(); ++i2) {
                source.next();
            }
        }

        private static Object[] take(Iterator<?> source, Object[] target, int offset, int count) {
            int i2;
            for (i2 = offset; i2 < count + offset && source.hasNext(); ++i2) {
                target[i2] = source.next();
            }
            if (i2 < target.length) {
                Object[] result2 = new Object[i2];
                System.arraycopy(target, 0, result2, 0, i2);
                return result2;
            }
            return target;
        }
    }

    public static final class EmptyIterator
    implements Iterator<Object> {
        static final EmptyIterator INSTANCE = new EmptyIterator();

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException(this.stringPrefix() + ".next()");
        }

        @Override
        public String stringPrefix() {
            return "EmptyIterator";
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }
    }

    public static final class DistinctIterator<T, U>
    extends AbstractIterator<T> {
        private final Iterator<? extends T> that;
        private Set<U> known;
        private final Function<? super T, ? extends U> keyExtractor;
        private boolean nextDefined = false;
        private T next;

        DistinctIterator(Iterator<? extends T> that, Set<U> set, Function<? super T, ? extends U> keyExtractor) {
            this.that = that;
            this.known = set;
            this.keyExtractor = keyExtractor;
        }

        @Override
        public boolean hasNext() {
            return this.nextDefined || this.searchNext();
        }

        private boolean searchNext() {
            while (this.that.hasNext()) {
                Object elem = this.that.next();
                U key = this.keyExtractor.apply(elem);
                if (this.known.contains(key)) continue;
                this.known = this.known.add(key);
                this.nextDefined = true;
                this.next = elem;
                return true;
            }
            return false;
        }

        @Override
        public T getNext() {
            T result2 = this.next;
            this.nextDefined = false;
            this.next = null;
            return result2;
        }
    }

    public static final class ConcatIterator<T>
    extends AbstractIterator<T> {
        private Iterator<T> curr;
        private Cell<T> tail;
        private Cell<T> last;
        private boolean hasNextCalculated;

        void append(java.util.Iterator<? extends T> that) {
            Iterator<? extends T> it = Iterator.ofAll(that);
            if (this.tail == null) {
                this.last = Cell.of(it);
                this.tail = this.last;
            } else {
                this.last = this.last.append(it);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.hasNextCalculated) {
                return this.curr != null;
            }
            this.hasNextCalculated = true;
            block0: while (true) {
                if (this.curr != null) {
                    if (this.curr.hasNext()) {
                        return true;
                    }
                    this.curr = null;
                }
                if (this.tail == null) {
                    return false;
                }
                this.curr = this.tail.it;
                this.tail = this.tail.next;
                while (true) {
                    if (!(this.curr instanceof ConcatIterator)) continue block0;
                    ConcatIterator it = (ConcatIterator)this.curr;
                    this.curr = it.curr;
                    it.last.next = this.tail;
                    this.tail = it.tail;
                }
                break;
            }
        }

        @Override
        public T getNext() {
            this.hasNextCalculated = false;
            return (T)this.curr.next();
        }

        private static class Cell<T> {
            Iterator<T> it;
            Cell<T> next;

            private Cell() {
            }

            static <T> Cell<T> of(Iterator<T> it) {
                Cell<T> cell = new Cell<T>();
                cell.it = it;
                return cell;
            }

            Cell<T> append(Iterator<T> it) {
                Cell<T> cell = Cell.of(it);
                this.next = cell;
                return cell;
            }
        }
    }
}

