/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.ide.troubleshooting.CompositeGeneralTroubleInfoCollector;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class StatisticCollector {
    private final Project project;

    public StatisticCollector(Project project) {
        this.project = project;
    }

    @NotNull
    private Holder analyzeFiles() {
        Holder holder = new Holder();
        ProjectFileIndex.getInstance((Project)this.project).iterateContent(fileOrDir -> {
            if (fileOrDir.is(VFileProperty.SYMLINK) && !fileOrDir.is(VFileProperty.HIDDEN)) {
                holder.setSymlink();
            }
            if (!fileOrDir.isDirectory()) {
                holder.increaseByOne();
            }
            return true;
        });
        Holder holder2 = holder;
        if (holder2 == null) {
            StatisticCollector.$$$reportNull$$$0(0);
        }
        return holder2;
    }

    public String collectMetrics(boolean addGeneralInfo) {
        StringBuilder output = new StringBuilder();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        VirtualFile baseDir = ProjectUtil.guessProjectDir((Project)this.project);
        if (baseDir != null) {
            Holder holder = this.analyzeFiles();
            output.append("Filesystem Info:\n");
            output.append("File system is case sensitive: ").append(baseDir.getFileSystem().isCaseSensitive()).append('\n');
            output.append("File is case sensitive: ").append(baseDir.isCaseSensitive()).append('\n');
            output.append("Are there symlinks: ").append(holder.isSymlink()).append('\n');
            output.append("Number of files: ").append(holder.getNumOfFiles()).append('\n');
            output.append('\n');
        }
        output.append("Project Info:\n");
        output.append("Number of opened files: ").append(fileEditorManager.getOpenFiles().length).append('\n');
        ReadAction.run(() -> {
            Editor selectedTextEditor = fileEditorManager.getSelectedTextEditor(true);
            if (selectedTextEditor != null) {
                Document document = selectedTextEditor.getDocument();
                output.append("File size (in lines): ").append(document.getLineCount()).append('\n');
                output.append("File size in characters: ").append(document.getTextLength()).append('\n');
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(document);
                if (psiFile != null) {
                    output.append("Number of injections: ").append(InjectedLanguageManager.getInstance((Project)this.project).getCachedInjectedDocumentsInRange(psiFile, psiFile.getTextRange()).size()).append('\n');
                }
            }
        });
        if (addGeneralInfo) {
            output.append('\n');
            output.append(new CompositeGeneralTroubleInfoCollector().collectInfo(this.project));
        }
        return output.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/performancePlugin/utils/StatisticCollector", "analyzeFiles"));
    }

    private static class Holder {
        private boolean isSymlink;
        private int numOfFiles;

        private Holder() {
        }

        public boolean isSymlink() {
            return this.isSymlink;
        }

        public void setSymlink() {
            this.isSymlink = true;
        }

        public int getNumOfFiles() {
            return this.numOfFiles;
        }

        public void increaseByOne() {
            ++this.numOfFiles;
        }
    }
}

