/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.backend;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.backend.InlineBreakpointVariantIdType;
import com.intellij.platform.debugger.impl.backend.InlineBreakpointVariantModel;
import com.intellij.platform.debugger.impl.backend.InlineBreakpointsIdManager;
import com.intellij.platform.debugger.impl.rpc.XInlineBreakpointVariantId;
import com.intellij.platform.kernel.ids.BackendGlobalIdsKt;
import com.intellij.platform.kernel.ids.BackendValueIdType;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n0\u0011R\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tj\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/debugger/impl/backend/InlineBreakpointsIdManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "trackedDocuments", "Ljava/util/HashMap;", "Lcom/intellij/openapi/editor/Document;", "", "Lcom/intellij/platform/debugger/impl/backend/InlineBreakpointVariantModel;", "Lkotlin/collections/HashMap;", "createId", "Lcom/intellij/platform/debugger/impl/rpc/XInlineBreakpointVariantId;", "variant", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "document", "(Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;Lcom/intellij/openapi/editor/Document;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.debugger.impl.backend"})
public final class InlineBreakpointsIdManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final HashMap<Document, Set<InlineBreakpointVariantModel>> trackedDocuments;

    public InlineBreakpointsIdManager(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.trackedDocuments = new HashMap();
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                this.editorLinksChanged(editor, 1);
            }

            public void editorReleased(EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                this.editorLinksChanged(editor, -1);
            }

            /*
             * WARNING - void declaration
             */
            public final void editorLinksChanged(Editor editor, int delta) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Set set = (Set)trackedDocuments.get(editor.getDocument());
                if (set == null) {
                    return;
                }
                Set models = set;
                Iterable $this$filter$iv = models;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    InlineBreakpointVariantModel it = (InlineBreakpointVariantModel)element$iv$iv;
                    boolean bl = false;
                    if (!it.shouldBeDisposedOnEditorCountChange(delta)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Set toRemove = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                models.removeAll(toRemove);
                if (models.isEmpty()) {
                    trackedDocuments.remove(editor.getDocument());
                }
            }
        }, (Disposable)this.project);
    }

    @Nullable
    public final Object createId(@NotNull XLineBreakpointType.XLineBreakpointVariant variant, @NotNull Document document, @NotNull Continuation<? super XInlineBreakpointVariantId> $completion) {
        return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super XInlineBreakpointVariantId>, Object>(document, this, variant, null){
            int label;
            final /* synthetic */ Document $document;
            final /* synthetic */ InlineBreakpointsIdManager this$0;
            final /* synthetic */ XLineBreakpointType.XLineBreakpointVariant $variant;
            {
                this.$document = $document;
                this.this$0 = $receiver;
                this.$variant = $variant;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        int initialEditorsCount = (int)EditorFactory.getInstance().editors(this.$document, InlineBreakpointsIdManager.access$getProject$p(this.this$0)).count();
                        CoroutineScope scope = CoroutineScopeKt.childScope$default((CoroutineScope)InlineBreakpointsIdManager.access$getCs$p(this.this$0), (String)"InlineBreakpointVariantModel", null, (boolean)false, (int)6, null);
                        InlineBreakpointVariantModel model = new InlineBreakpointVariantModel(this.$variant, scope, initialEditorsCount);
                        InlineBreakpointsIdManager.access$getTrackedDocuments$p(this.this$0).computeIfAbsent(this.$document, arg_0 -> createId.2.invokeSuspend$lambda$1(createId.2::invokeSuspend$lambda$0, arg_0)).add(model);
                        return BackendGlobalIdsKt.storeValueGlobally((CoroutineScope)model.getCs(), (Object)model, (BackendValueIdType)InlineBreakpointVariantIdType.INSTANCE);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super XInlineBreakpointVariantId> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Set invokeSuspend$lambda$0(Document it) {
                return new HashSet<E>();
            }

            private static final Set invokeSuspend$lambda$1(Function1 $tmp0, Object p0) {
                return (Set)$tmp0.invoke(p0);
            }
        }), $completion);
    }

    @JvmStatic
    @NotNull
    public static final InlineBreakpointsIdManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getProject$p(InlineBreakpointsIdManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ CoroutineScope access$getCs$p(InlineBreakpointsIdManager $this) {
        return $this.cs;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/debugger/impl/backend/InlineBreakpointsIdManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/debugger/impl/backend/InlineBreakpointsIdManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.debugger.impl.backend"})
    @SourceDebugExtension(value={"SMAP\nInlineBreakpointsIdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineBreakpointsIdManager.kt\ncom/intellij/platform/debugger/impl/backend/InlineBreakpointsIdManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,85:1\n30#2,2:86\n*S KotlinDebug\n*F\n+ 1 InlineBreakpointsIdManager.kt\ncom/intellij/platform/debugger/impl/backend/InlineBreakpointsIdManager$Companion\n*L\n59#1:86,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InlineBreakpointsIdManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<InlineBreakpointsIdManager> serviceClass$iv = InlineBreakpointsIdManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (InlineBreakpointsIdManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

