/**
 ******************************************************************************
 * @file  HC32F460.h
 * @brief Headerfile for HC32F460 series MCU
 @verbatim
   Change Logs:
   Date             Author          Notes
   2021-10-13       CDT          First version
 @endverbatim
 ******************************************************************************
 * Copyright (C) 2020, Huada Semiconductor Co., Ltd. All rights reserved.
 *
 * This software component is licensed by HDSC under BSD 3-Clause license
 * (the "License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                    opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 **/

#ifndef __HC32F460_H__
#define __HC32F460_H__

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
 * Configuration of the Cortex-M4 Processor and Core Peripherals
 ******************************************************************************/
#define __CM4_REV                 1       /*!< Core revision r0p1                                   */
#define __MPU_PRESENT             1       /*!< HC32F460 provides an MPU                             */
#define __NVIC_PRIO_BITS          4       /*!< HC32F460 uses 4 Bits for the Priority Levels         */
#define __Vendor_SysTickConfig    0       /*!< Set to 1 if different SysTick Config is used         */
#define __FPU_PRESENT             1       /*!< FPU present                                          */

/*******************************************************************************
 * Interrupt Number Definition
 ******************************************************************************/
typedef enum IRQn
{
    NMI_IRQn                    = -14, /*  2 Non Maskable                            */
    HardFault_IRQn              = -13, /*  3 Hard Fault                              */
    MemManageFault_IRQn         = -12, /*  4 MemManage Fault                         */
    BusFault_IRQn               = -11, /*  5 Bus Fault                               */
    UsageFault_IRQn             = -10, /*  6 Usage Fault                             */
    SVC_IRQn                    = -5,  /* 11 SV Call                                 */
    DebugMonitor_IRQn           = -4,  /* 12 Debug Monitor                           */
    PendSV_IRQn                 = -2,  /* 14 Pend SV                                 */
    SysTick_IRQn                = -1,  /* 15 System Tick                             */
    Int000_IRQn                 = 0,
    Int001_IRQn                 = 1,
    Int002_IRQn                 = 2,
    Int003_IRQn                 = 3,
    Int004_IRQn                 = 4,
    Int005_IRQn                 = 5,
    Int006_IRQn                 = 6,
    Int007_IRQn                 = 7,
    Int008_IRQn                 = 8,
    Int009_IRQn                 = 9,
    Int010_IRQn                 = 10,
    Int011_IRQn                 = 11,
    Int012_IRQn                 = 12,
    Int013_IRQn                 = 13,
    Int014_IRQn                 = 14,
    Int015_IRQn                 = 15,
    Int016_IRQn                 = 16,
    Int017_IRQn                 = 17,
    Int018_IRQn                 = 18,
    Int019_IRQn                 = 19,
    Int020_IRQn                 = 20,
    Int021_IRQn                 = 21,
    Int022_IRQn                 = 22,
    Int023_IRQn                 = 23,
    Int024_IRQn                 = 24,
    Int025_IRQn                 = 25,
    Int026_IRQn                 = 26,
    Int027_IRQn                 = 27,
    Int028_IRQn                 = 28,
    Int029_IRQn                 = 29,
    Int030_IRQn                 = 30,
    Int031_IRQn                 = 31,
    Int032_IRQn                 = 32,
    Int033_IRQn                 = 33,
    Int034_IRQn                 = 34,
    Int035_IRQn                 = 35,
    Int036_IRQn                 = 36,
    Int037_IRQn                 = 37,
    Int038_IRQn                 = 38,
    Int039_IRQn                 = 39,
    Int040_IRQn                 = 40,
    Int041_IRQn                 = 41,
    Int042_IRQn                 = 42,
    Int043_IRQn                 = 43,
    Int044_IRQn                 = 44,
    Int045_IRQn                 = 45,
    Int046_IRQn                 = 46,
    Int047_IRQn                 = 47,
    Int048_IRQn                 = 48,
    Int049_IRQn                 = 49,
    Int050_IRQn                 = 50,
    Int051_IRQn                 = 51,
    Int052_IRQn                 = 52,
    Int053_IRQn                 = 53,
    Int054_IRQn                 = 54,
    Int055_IRQn                 = 55,
    Int056_IRQn                 = 56,
    Int057_IRQn                 = 57,
    Int058_IRQn                 = 58,
    Int059_IRQn                 = 59,
    Int060_IRQn                 = 60,
    Int061_IRQn                 = 61,
    Int062_IRQn                 = 62,
    Int063_IRQn                 = 63,
    Int064_IRQn                 = 64,
    Int065_IRQn                 = 65,
    Int066_IRQn                 = 66,
    Int067_IRQn                 = 67,
    Int068_IRQn                 = 68,
    Int069_IRQn                 = 69,
    Int070_IRQn                 = 70,
    Int071_IRQn                 = 71,
    Int072_IRQn                 = 72,
    Int073_IRQn                 = 73,
    Int074_IRQn                 = 74,
    Int075_IRQn                 = 75,
    Int076_IRQn                 = 76,
    Int077_IRQn                 = 77,
    Int078_IRQn                 = 78,
    Int079_IRQn                 = 79,
    Int080_IRQn                 = 80,
    Int081_IRQn                 = 81,
    Int082_IRQn                 = 82,
    Int083_IRQn                 = 83,
    Int084_IRQn                 = 84,
    Int085_IRQn                 = 85,
    Int086_IRQn                 = 86,
    Int087_IRQn                 = 87,
    Int088_IRQn                 = 88,
    Int089_IRQn                 = 89,
    Int090_IRQn                 = 90,
    Int091_IRQn                 = 91,
    Int092_IRQn                 = 92,
    Int093_IRQn                 = 93,
    Int094_IRQn                 = 94,
    Int095_IRQn                 = 95,
    Int096_IRQn                 = 96,
    Int097_IRQn                 = 97,
    Int098_IRQn                 = 98,
    Int099_IRQn                 = 99,
    Int100_IRQn                 = 100,
    Int101_IRQn                 = 101,
    Int102_IRQn                 = 102,
    Int103_IRQn                 = 103,
    Int104_IRQn                 = 104,
    Int105_IRQn                 = 105,
    Int106_IRQn                 = 106,
    Int107_IRQn                 = 107,
    Int108_IRQn                 = 108,
    Int109_IRQn                 = 109,
    Int110_IRQn                 = 110,
    Int111_IRQn                 = 111,
    Int112_IRQn                 = 112,
    Int113_IRQn                 = 113,
    Int114_IRQn                 = 114,
    Int115_IRQn                 = 115,
    Int116_IRQn                 = 116,
    Int117_IRQn                 = 117,
    Int118_IRQn                 = 118,
    Int119_IRQn                 = 119,
    Int120_IRQn                 = 120,
    Int121_IRQn                 = 121,
    Int122_IRQn                 = 122,
    Int123_IRQn                 = 123,
    Int124_IRQn                 = 124,
    Int125_IRQn                 = 125,
    Int126_IRQn                 = 126,
    Int127_IRQn                 = 127,
    Int128_IRQn                 = 128,
    Int129_IRQn                 = 129,
    Int130_IRQn                 = 130,
    Int131_IRQn                 = 131,
    Int132_IRQn                 = 132,
    Int133_IRQn                 = 133,
    Int134_IRQn                 = 134,
    Int135_IRQn                 = 135,
    Int136_IRQn                 = 136,
    Int137_IRQn                 = 137,
    Int138_IRQn                 = 138,
    Int139_IRQn                 = 139,
    Int140_IRQn                 = 140,
    Int141_IRQn                 = 141,
    Int142_IRQn                 = 142,
    Int143_IRQn                 = 143,

}IRQn_Type;

#include <core_cm4.h>
#include <stdint.h>

/**
 *******************************************************************************
 ** \brief Event number enumeration
 ******************************************************************************/
typedef enum en_event_src
{
    EVT_SWI_IRQ0            = 0U,
    EVT_SWI_IRQ1            = 1U,
    EVT_SWI_IRQ2            = 2U,
    EVT_SWI_IRQ3            = 3U,
    EVT_SWI_IRQ4            = 4U,
    EVT_SWI_IRQ5            = 5U,
    EVT_SWI_IRQ6            = 6U,
    EVT_SWI_IRQ7            = 7U,
    EVT_SWI_IRQ8            = 8U,
    EVT_SWI_IRQ9            = 9U,
    EVT_SWI_IRQ10           = 10U,
    EVT_SWI_IRQ11           = 11U,
    EVT_SWI_IRQ12           = 12U,
    EVT_SWI_IRQ13           = 13U,
    EVT_SWI_IRQ14           = 14U,
    EVT_SWI_IRQ15           = 15U,
    EVT_SWI_IRQ16           = 16U,
    EVT_SWI_IRQ17           = 17U,
    EVT_SWI_IRQ18           = 18U,
    EVT_SWI_IRQ19           = 19U,
    EVT_SWI_IRQ20           = 20U,
    EVT_SWI_IRQ21           = 21U,
    EVT_SWI_IRQ22           = 22U,
    EVT_SWI_IRQ23           = 23U,
    EVT_SWI_IRQ24           = 24U,
    EVT_SWI_IRQ25           = 25U,
    EVT_SWI_IRQ26           = 26U,
    EVT_SWI_IRQ27           = 27U,
    EVT_SWI_IRQ28           = 28U,
    EVT_SWI_IRQ29           = 29U,
    EVT_SWI_IRQ30           = 30U,
    EVT_SWI_IRQ31           = 31U,

    /* External Interrupt. */
    EVT_PORT_EIRQ0          = 0U,
    EVT_PORT_EIRQ1          = 1U,
    EVT_PORT_EIRQ2          = 2U,
    EVT_PORT_EIRQ3          = 3U,
    EVT_PORT_EIRQ4          = 4U,
    EVT_PORT_EIRQ5          = 5U,
    EVT_PORT_EIRQ6          = 6U,
    EVT_PORT_EIRQ7          = 7U,
    EVT_PORT_EIRQ8          = 8U,
    EVT_PORT_EIRQ9          = 9U,
    EVT_PORT_EIRQ10         = 10U,
    EVT_PORT_EIRQ11         = 11U,
    EVT_PORT_EIRQ12         = 12U,
    EVT_PORT_EIRQ13         = 13U,
    EVT_PORT_EIRQ14         = 14U,
    EVT_PORT_EIRQ15         = 15U,

    /* DMAC */
    EVT_DMA1_TC0            = 32U,
    EVT_DMA1_TC1            = 33U,
    EVT_DMA1_TC2            = 34U,
    EVT_DMA1_TC3            = 35U,
    EVT_DMA2_TC0            = 36U,
    EVT_DMA2_TC1            = 37U,
    EVT_DMA2_TC2            = 38U,
    EVT_DMA2_TC3            = 39U,
    EVT_DMA1_BTC0           = 40U,
    EVT_DMA1_BTC1           = 41U,
    EVT_DMA1_BTC2           = 42U,
    EVT_DMA1_BTC3           = 43U,
    EVT_DMA2_BTC0           = 44U,
    EVT_DMA2_BTC1           = 45U,
    EVT_DMA2_BTC2           = 46U,
    EVT_DMA2_BTC3           = 47U,

    /* EFM */
    EVT_EFM_OPTEND          = 52U,

    /* USB SOF */
    EVT_USBFS_SOF           = 53U,

    /* DCU */
    EVT_DCU1                = 55U,
    EVT_DCU2                = 56U,
    EVT_DCU3                = 57U,
    EVT_DCU4                = 58U,

    /* TIMER 0 */
    EVT_TMR01_GCMA          = 64U,
    EVT_TMR01_GCMB          = 65U,
    EVT_TMR02_GCMA          = 66U,
    EVT_TMR02_GCMB          = 67U,

    /* RTC */
    EVT_RTC_ALM             = 81U,
    EVT_RTC_PRD             = 82U,

    /* TIMER 6 */
    EVT_TMR61_GCMA          = 96U,
    EVT_TMR61_GCMB          = 97U,
    EVT_TMR61_GCMC          = 98U,
    EVT_TMR61_GCMD          = 99U,
    EVT_TMR61_GCME          = 100U,
    EVT_TMR61_GCMF          = 101U,
    EVT_TMR61_GOVF          = 102U,
    EVT_TMR61_GUDF          = 103U,
    EVT_TMR61_SCMA          = 107U,
    EVT_TMR61_SCMB          = 108U,
    EVT_TMR62_GCMA          = 112U,
    EVT_TMR62_GCMB          = 113U,
    EVT_TMR62_GCMC          = 114U,
    EVT_TMR62_GCMD          = 115U,
    EVT_TMR62_GCME          = 116U,
    EVT_TMR62_GCMF          = 117U,
    EVT_TMR62_GOVF          = 118U,
    EVT_TMR62_GUDF          = 119U,
    EVT_TMR62_SCMA          = 123U,
    EVT_TMR62_SCMB          = 124U,
    EVT_TMR63_GCMA          = 128U,
    EVT_TMR63_GCMB          = 129U,
    EVT_TMR63_GCMC          = 130U,
    EVT_TMR63_GCMD          = 131U,
    EVT_TMR63_GCME          = 132U,
    EVT_TMR63_GCMF          = 133U,
    EVT_TMR63_GOVF          = 134U,
    EVT_TMR63_GUDF          = 135U,
    EVT_TMR63_SCMA          = 139U,
    EVT_TMR63_SCMB          = 140U,

    /* TIMER A */
    EVT_TMRA1_OVF           = 256U,
    EVT_TMRA1_UDF           = 257U,
    EVT_TMRA1_CMP           = 258U,
    EVT_TMRA2_OVF           = 259U,
    EVT_TMRA2_UDF           = 260U,
    EVT_TMRA2_CMP           = 261U,
    EVT_TMRA3_OVF           = 262U,
    EVT_TMRA3_UDF           = 263U,
    EVT_TMRA3_CMP           = 264U,
    EVT_TMRA4_OVF           = 265U,
    EVT_TMRA4_UDF           = 266U,
    EVT_TMRA4_CMP           = 267U,
    EVT_TMRA5_OVF           = 268U,
    EVT_TMRA5_UDF           = 269U,
    EVT_TMRA5_CMP           = 270U,
    EVT_TMRA6_OVF           = 272U,
    EVT_TMRA6_UDF           = 273U,
    EVT_TMRA6_CMP           = 274U,

    /* USART */
    EVT_USART1_EI           = 278U,
    EVT_USART1_RI           = 279U,
    EVT_USART1_TI           = 280U,
    EVT_USART1_TCI          = 281U,
    EVT_USART1_RTO          = 282U,
    EVT_USART2_EI           = 283U,
    EVT_USART2_RI           = 284U,
    EVT_USART2_TI           = 285U,
    EVT_USART2_TCI          = 286U,
    EVT_USART2_RTO          = 287U,
    EVT_USART3_EI           = 288U,
    EVT_USART3_RI           = 289U,
    EVT_USART3_TI           = 290U,
    EVT_USART3_TCI          = 291U,
    EVT_USART3_RTO          = 292U,
    EVT_USART4_EI           = 293U,
    EVT_USART4_RI           = 294U,
    EVT_USART4_TI           = 295U,
    EVT_USART4_TCI          = 296U,
    EVT_USART4_RTO          = 297U,

    /* SPI */
    EVT_SPI1_SPRI           = 299U,
    EVT_SPI1_SPTI           = 300U,
    EVT_SPI1_SPII           = 301U,
    EVT_SPI1_SPEI           = 302U,
    EVT_SPI1_SPTEND         = 303U,
    EVT_SPI2_SPRI           = 304U,
    EVT_SPI2_SPTI           = 305U,
    EVT_SPI2_SPII           = 306U,
    EVT_SPI2_SPEI           = 307U,
    EVT_SPI2_SPTEND         = 308U,
    EVT_SPI3_SPRI           = 309U,
    EVT_SPI3_SPTI           = 310U,
    EVT_SPI3_SPII           = 311U,
    EVT_SPI3_SPEI           = 312U,
    EVT_SPI3_SPTEND         = 313U,
    EVT_SPI4_SPRI           = 314U,
    EVT_SPI4_SPTI           = 315U,
    EVT_SPI4_SPII           = 316U,
    EVT_SPI4_SPEI           = 317U,
    EVT_SPI4_SPTEND         = 318U,

    /* AOS */
    EVT_AOS_STRG            = 319U,

    /* TIMER 4 */
    EVT_TMR41_SCMUH         = 368U,
    EVT_TMR41_SCMUL         = 369U,
    EVT_TMR41_SCMVH         = 370U,
    EVT_TMR41_SCMVL         = 371U,
    EVT_TMR41_SCMWH         = 372U,
    EVT_TMR41_SCMWL         = 373U,
    EVT_TMR42_SCMUH         = 374U,
    EVT_TMR42_SCMUL         = 375U,
    EVT_TMR42_SCMVH         = 376U,
    EVT_TMR42_SCMVL         = 377U,
    EVT_TMR42_SCMWH         = 378U,
    EVT_TMR42_SCMWL         = 379U,
    EVT_TMR43_SCMUH         = 384U,
    EVT_TMR43_SCMUL         = 385U,
    EVT_TMR43_SCMVH         = 386U,
    EVT_TMR43_SCMVL         = 387U,
    EVT_TMR43_SCMWH         = 388U,
    EVT_TMR43_SCMWL         = 389U,

    /* EVENT PORT */
    EVT_EVENT_PORT1         = 394U,
    EVT_EVENT_PORT2         = 395U,
    EVT_EVENT_PORT3         = 396U,
    EVT_EVENT_PORT4         = 397U,

    /* I2S */
    EVT_I2S1_TXIRQOUT       = 400U,
    EVT_I2S1_RXIRQOUT       = 401U,
    EVT_I2S2_TXIRQOUT       = 403U,
    EVT_I2S2_RXIRQOUT       = 404U,
    EVT_I2S3_TXIRQOUT       = 406U,
    EVT_I2S3_RXIRQOUT       = 407U,
    EVT_I2S4_TXIRQOUT       = 409U,
    EVT_I2S4_RXIRQOUT       = 410U,

    /* COMPARATOR */
    EVT_ACMP1               = 416U,
    EVT_ACMP2               = 417U,
    EVT_ACMP3               = 418U,

    /* I2C */
    EVT_I2C1_RXI            = 420U,
    EVT_I2C1_TXI            = 421U,
    EVT_I2C1_TEI            = 422U,
    EVT_I2C1_EEI            = 423U,
    EVT_I2C2_RXI            = 424U,
    EVT_I2C2_TXI            = 425U,
    EVT_I2C2_TEI            = 426U,
    EVT_I2C2_EEI            = 427U,
    EVT_I2C3_RXI            = 428U,
    EVT_I2C3_TXI            = 429U,
    EVT_I2C3_TEI            = 430U,
    EVT_I2C3_EEI            = 431U,

    /* PVD */
    EVT_PVD_PVD1            = 433U,
    EVT_PVD_PVD2            = 434U,

    /* OTS */
    EVT_OTS                 = 435U,

    /* WDT */
    EVT_WDT_REFUDF          = 439U,

    /* ADC */
    EVT_ADC1_EOCA           = 448U,
    EVT_ADC1_EOCB           = 449U,
    EVT_ADC1_CHCMP          = 450U,
    EVT_ADC1_SEQCMP         = 451U,
    EVT_ADC2_EOCA           = 452U,
    EVT_ADC2_EOCB           = 453U,
    EVT_ADC2_CHCMP          = 454U,
    EVT_ADC2_SEQCMP         = 455U,

    /* TRNG */
    EVT_TRNG_END            = 456U,

    /* SDIO */
    EVT_SDIOC1_DMAR         = 480U,
    EVT_SDIOC1_DMAW         = 481U,
    EVT_SDIOC2_DMAR         = 483U,
    EVT_SDIOC2_DMAW         = 484U,
    EVT_MAX                 = 511U,
}en_event_src_t;

/**
 *******************************************************************************
 ** \brief Interrupt number enumeration
 ******************************************************************************/
typedef enum en_int_src
{
    INT_SWI_IRQ0            = 0U,
    INT_SWI_IRQ1            = 1U,
    INT_SWI_IRQ2            = 2U,
    INT_SWI_IRQ3            = 3U,
    INT_SWI_IRQ4            = 4U,
    INT_SWI_IRQ5            = 5U,
    INT_SWI_IRQ6            = 6U,
    INT_SWI_IRQ7            = 7U,
    INT_SWI_IRQ8            = 8U,
    INT_SWI_IRQ9            = 9U,
    INT_SWI_IRQ10           = 10U,
    INT_SWI_IRQ11           = 11U,
    INT_SWI_IRQ12           = 12U,
    INT_SWI_IRQ13           = 13U,
    INT_SWI_IRQ14           = 14U,
    INT_SWI_IRQ15           = 15U,
    INT_SWI_IRQ16           = 16U,
    INT_SWI_IRQ17           = 17U,
    INT_SWI_IRQ18           = 18U,
    INT_SWI_IRQ19           = 19U,
    INT_SWI_IRQ20           = 20U,
    INT_SWI_IRQ21           = 21U,
    INT_SWI_IRQ22           = 22U,
    INT_SWI_IRQ23           = 23U,
    INT_SWI_IRQ24           = 24U,
    INT_SWI_IRQ25           = 25U,
    INT_SWI_IRQ26           = 26U,
    INT_SWI_IRQ27           = 27U,
    INT_SWI_IRQ28           = 28U,
    INT_SWI_IRQ29           = 29U,
    INT_SWI_IRQ30           = 30U,
    INT_SWI_IRQ31           = 31U,

    /* External Interrupt. */
    INT_PORT_EIRQ0          = 0U,
    INT_PORT_EIRQ1          = 1U,
    INT_PORT_EIRQ2          = 2U,
    INT_PORT_EIRQ3          = 3U,
    INT_PORT_EIRQ4          = 4U,
    INT_PORT_EIRQ5          = 5U,
    INT_PORT_EIRQ6          = 6U,
    INT_PORT_EIRQ7          = 7U,
    INT_PORT_EIRQ8          = 8U,
    INT_PORT_EIRQ9          = 9U,
    INT_PORT_EIRQ10         = 10U,
    INT_PORT_EIRQ11         = 11U,
    INT_PORT_EIRQ12         = 12U,
    INT_PORT_EIRQ13         = 13U,
    INT_PORT_EIRQ14         = 14U,
    INT_PORT_EIRQ15         = 15U,

    /* DMAC */
    INT_DMA1_TC0            = 32U,
    INT_DMA1_TC1            = 33U,
    INT_DMA1_TC2            = 34U,
    INT_DMA1_TC3            = 35U,
    INT_DMA2_TC0            = 36U,
    INT_DMA2_TC1            = 37U,
    INT_DMA2_TC2            = 38U,
    INT_DMA2_TC3            = 39U,
    INT_DMA1_BTC0           = 40U,
    INT_DMA1_BTC1           = 41U,
    INT_DMA1_BTC2           = 42U,
    INT_DMA1_BTC3           = 43U,
    INT_DMA2_BTC0           = 44U,
    INT_DMA2_BTC1           = 45U,
    INT_DMA2_BTC2           = 46U,
    INT_DMA2_BTC3           = 47U,
    INT_DMA1_ERR            = 48U,
    INT_DMA2_ERR            = 49U,

    /* EFM */
    INT_EFM_PEERR           = 50U,
    INT_EFM_COLERR          = 51U,
    INT_EFM_OPTEND          = 52U,

    /* QSPI */
    INT_QSPI_INTR           = 54U,

    /* DCU */
    INT_DCU1                = 55U,
    INT_DCU2                = 56U,
    INT_DCU3                = 57U,
    INT_DCU4                = 58U,

    /* TIMER 0 */
    INT_TMR01_GCMA          = 64U,
    INT_TMR01_GCMB          = 65U,
    INT_TMR02_GCMA          = 66U,
    INT_TMR02_GCMB          = 67U,

    /* RTC */
    INT_RTC_ALM             = 81U,
    INT_RTC_PRD             = 82U,

    /* XTAL32 stop */
    INT_XTAL32_STOP         = 84U,

    /* XTAL stop */
    INT_XTAL_STOP           = 85U,

    /* wake-up timer */
    INT_WKTM_PRD            = 86U,

    /* SWDT */
    INT_SWDT_REFUDF         = 87U,

    /* TIMER 6 */
    INT_TMR61_GCMA          = 96U,
    INT_TMR61_GCMB          = 97U,
    INT_TMR61_GCMC          = 98U,
    INT_TMR61_GCMD          = 99U,
    INT_TMR61_GCME          = 100U,
    INT_TMR61_GCMF          = 101U,
    INT_TMR61_GOVF          = 102U,
    INT_TMR61_GUDF          = 103U,
    INT_TMR61_GDTE          = 104U,
    INT_TMR61_SCMA          = 107U,
    INT_TMR61_SCMB          = 108U,
    INT_TMR62_GCMA          = 112U,
    INT_TMR62_GCMB          = 113U,
    INT_TMR62_GCMC          = 114U,
    INT_TMR62_GCMD          = 115U,
    INT_TMR62_GCME          = 116U,
    INT_TMR62_GCMF          = 117U,
    INT_TMR62_GOVF          = 118U,
    INT_TMR62_GUDF          = 119U,
    INT_TMR62_GDTE          = 120U,
    INT_TMR62_SCMA          = 123U,
    INT_TMR62_SCMB          = 124U,
    INT_TMR63_GCMA          = 128U,
    INT_TMR63_GCMB          = 129U,
    INT_TMR63_GCMC          = 130U,
    INT_TMR63_GCMD          = 131U,
    INT_TMR63_GCME          = 132U,
    INT_TMR63_GCMF          = 133U,
    INT_TMR63_GOVF          = 134U,
    INT_TMR63_GUDF          = 135U,
    INT_TMR63_GDTE          = 136U,
    INT_TMR63_SCMA          = 139U,
    INT_TMR63_SCMB          = 140U,

    /* TIMER A */
    INT_TMRA1_OVF           = 256U,
    INT_TMRA1_UDF           = 257U,
    INT_TMRA1_CMP           = 258U,
    INT_TMRA2_OVF           = 259U,
    INT_TMRA2_UDF           = 260U,
    INT_TMRA2_CMP           = 261U,
    INT_TMRA3_OVF           = 262U,
    INT_TMRA3_UDF           = 263U,
    INT_TMRA3_CMP           = 264U,
    INT_TMRA4_OVF           = 265U,
    INT_TMRA4_UDF           = 266U,
    INT_TMRA4_CMP           = 267U,
    INT_TMRA5_OVF           = 268U,
    INT_TMRA5_UDF           = 269U,
    INT_TMRA5_CMP           = 270U,
    INT_TMRA6_OVF           = 272U,
    INT_TMRA6_UDF           = 273U,
    INT_TMRA6_CMP           = 274U,

    /* USB FS */
    INT_USBFS_GLB           = 275U,

    /* USRAT */
    INT_USART1_EI           = 278U,
    INT_USART1_RI           = 279U,
    INT_USART1_TI           = 280U,
    INT_USART1_TCI          = 281U,
    INT_USART1_RTO          = 282U,
    INT_USART1_WUPI         = 432U,
    INT_USART2_EI           = 283U,
    INT_USART2_RI           = 284U,
    INT_USART2_TI           = 285U,
    INT_USART2_TCI          = 286U,
    INT_USART2_RTO          = 287U,
    INT_USART3_EI           = 288U,
    INT_USART3_RI           = 289U,
    INT_USART3_TI           = 290U,
    INT_USART3_TCI          = 291U,
    INT_USART3_RTO          = 292U,
    INT_USART4_EI           = 293U,
    INT_USART4_RI           = 294U,
    INT_USART4_TI           = 295U,
    INT_USART4_TCI          = 296U,
    INT_USART4_RTO          = 297U,

    /* SPI */
    INT_SPI1_SPRI           = 299U,
    INT_SPI1_SPTI           = 300U,
    INT_SPI1_SPII           = 301U,
    INT_SPI1_SPEI           = 302U,
    INT_SPI2_SPRI           = 304U,
    INT_SPI2_SPTI           = 305U,
    INT_SPI2_SPII           = 306U,
    INT_SPI2_SPEI           = 307U,
    INT_SPI3_SPRI           = 309U,
    INT_SPI3_SPTI           = 310U,
    INT_SPI3_SPII           = 311U,
    INT_SPI3_SPEI           = 312U,
    INT_SPI4_SPRI           = 314U,
    INT_SPI4_SPTI           = 315U,
    INT_SPI4_SPII           = 316U,
    INT_SPI4_SPEI           = 317U,

    /* TIMER 4 */
    INT_TMR41_GCMUH         = 320U,
    INT_TMR41_GCMUL         = 321U,
    INT_TMR41_GCMVH         = 322U,
    INT_TMR41_GCMVL         = 323U,
    INT_TMR41_GCMWH         = 324U,
    INT_TMR41_GCMWL         = 325U,
    INT_TMR41_GOVF          = 326U,
    INT_TMR41_GUDF          = 327U,
    INT_TMR41_RLOU          = 328U,
    INT_TMR41_RLOV          = 329U,
    INT_TMR41_RLOW          = 330U,
    INT_TMR42_GCMUH         = 336U,
    INT_TMR42_GCMUL         = 337U,
    INT_TMR42_GCMVH         = 338U,
    INT_TMR42_GCMVL         = 339U,
    INT_TMR42_GCMWH         = 340U,
    INT_TMR42_GCMWL         = 341U,
    INT_TMR42_GOVF          = 342U,
    INT_TMR42_GUDF          = 343U,
    INT_TMR42_RLOU          = 344U,
    INT_TMR42_RLOV          = 345U,
    INT_TMR42_RLOW          = 346U,
    INT_TMR43_GCMUH         = 352U,
    INT_TMR43_GCMUL         = 353U,
    INT_TMR43_GCMVH         = 354U,
    INT_TMR43_GCMVL         = 355U,
    INT_TMR43_GCMWH         = 356U,
    INT_TMR43_GCMWL         = 357U,
    INT_TMR43_GOVF          = 358U,
    INT_TMR43_GUDF          = 359U,
    INT_TMR43_RLOU          = 360U,
    INT_TMR43_RLOV          = 361U,
    INT_TMR43_RLOW          = 362U,

    /* EMB */
    INT_EMB_GR0             = 390U,
    INT_EMB_GR1             = 391U,
    INT_EMB_GR2             = 392U,
    INT_EMB_GR3             = 393U,

    /* EVENT PORT */
    INT_EVENT_PORT1         = 394U,
    INT_EVENT_PORT2         = 395U,
    INT_EVENT_PORT3         = 396U,
    INT_EVENT_PORT4         = 397U,

    /* I2S */
    INT_I2S1_TXIRQOUT       = 400U,
    INT_I2S1_RXIRQOUT       = 401U,
    INT_I2S1_ERRIRQOUT      = 402U,
    INT_I2S2_TXIRQOUT       = 403U,
    INT_I2S2_RXIRQOUT       = 404U,
    INT_I2S2_ERRIRQOUT      = 405U,
    INT_I2S3_TXIRQOUT       = 406U,
    INT_I2S3_RXIRQOUT       = 407U,
    INT_I2S3_ERRIRQOUT      = 408U,
    INT_I2S4_TXIRQOUT       = 409U,
    INT_I2S4_RXIRQOUT       = 410U,
    INT_I2S4_ERRIRQOUT      = 411U,

    /* COMPARATOR */
    INT_ACMP1               = 416U,
    INT_ACMP2               = 417U,
    INT_ACMP3               = 418U,

    /* I2C */
    INT_I2C1_RXI            = 420U,
    INT_I2C1_TXI            = 421U,
    INT_I2C1_TEI            = 422U,
    INT_I2C1_EEI            = 423U,
    INT_I2C2_RXI            = 424U,
    INT_I2C2_TXI            = 425U,
    INT_I2C2_TEI            = 426U,
    INT_I2C2_EEI            = 427U,
    INT_I2C3_RXI            = 428U,
    INT_I2C3_TXI            = 429U,
    INT_I2C3_TEI            = 430U,
    INT_I2C3_EEI            = 431U,

    /* PVD */
    INT_PVD_PVD1            = 433U,
    INT_PVD_PVD2            = 434U,

    /* Temp. sensor */
    INT_OTS                 = 435U,

    /* FCM */
    INT_FCMFERRI            = 436U,
    INT_FCMMENDI            = 437U,
    INT_FCMCOVFI            = 438U,

    /* WDT */
    INT_WDT_REFUDF          = 439U,

    /* ADC */
    INT_ADC1_EOCA           = 448U,
    INT_ADC1_EOCB           = 449U,
    INT_ADC1_CHCMP          = 450U,
    INT_ADC1_SEQCMP         = 451U,
    INT_ADC2_EOCA           = 452U,
    INT_ADC2_EOCB           = 453U,
    INT_ADC2_CHCMP          = 454U,
    INT_ADC2_SEQCMP         = 455U,

    /* TRNG */
    INT_TRNG_END            = 456U,

    /* SDIOC */
    INT_SDIOC1_SD           = 482U,
    INT_SDIOC2_SD           = 485U,

    /* CAN */
    INT_CAN_INT             = 486U,

    INT_MAX                 = 511U,
}en_int_src_t;

/******************************************************************************/
/*                Device Specific Peripheral Registers structures             */
/******************************************************************************/

#if defined ( __CC_ARM   )
#pragma anon_unions
#endif

typedef struct
{
    __IO uint8_t STRT                       : 1;
    uint8_t RESERVED1                       : 7;
} stc_adc_str_field_t;

typedef struct
{
    __IO uint16_t MS                        : 2;
    uint16_t RESERVED2                      : 2;
    __IO uint16_t ACCSEL                    : 2;
    __IO uint16_t CLREN                     : 1;
    __IO uint16_t DFMT                      : 1;
    __IO uint16_t AVCNT                     : 3;
    uint16_t RESERVED11                     : 5;
} stc_adc_cr0_field_t;

typedef struct
{
    uint16_t RESERVED0                      : 2;
    __IO uint16_t RSCHSEL                   : 1;
    uint16_t RESERVED3                      :13;
} stc_adc_cr1_field_t;

typedef struct
{
    __IO uint16_t TRGSELA                   : 3;
    uint16_t RESERVED3                      : 4;
    __IO uint16_t TRGENA                    : 1;
    __IO uint16_t TRGSELB                   : 3;
    uint16_t RESERVED11                     : 4;
    __IO uint16_t TRGENB                    : 1;
} stc_adc_trgsr_field_t;

typedef struct
{
    __IO uint16_t CHSELA16                  : 1;
    uint16_t RESERVED1                      :15;
} stc_adc_chselra1_field_t;

typedef struct
{
    __IO uint16_t CHSELB16                  : 1;
    uint16_t RESERVED1                      :15;
} stc_adc_chselrb1_field_t;

typedef struct
{
    __IO uint16_t AVCHSEL16                 : 1;
    uint16_t RESERVED1                      :15;
} stc_adc_avchselr1_field_t;

typedef struct
{
    __IO uint16_t CH00MUX                   : 4;
    __IO uint16_t CH01MUX                   : 4;
    __IO uint16_t CH02MUX                   : 4;
    __IO uint16_t CH03MUX                   : 4;
} stc_adc_chmuxr0_field_t;

typedef struct
{
    __IO uint16_t CH04MUX                   : 4;
    __IO uint16_t CH05MUX                   : 4;
    __IO uint16_t CH06MUX                   : 4;
    __IO uint16_t CH07MUX                   : 4;
} stc_adc_chmuxr1_field_t;

typedef struct
{
    __IO uint16_t CH08MUX                   : 4;
    __IO uint16_t CH09MUX                   : 4;
    __IO uint16_t CH10MUX                   : 4;
    __IO uint16_t CH11MUX                   : 4;
} stc_adc_chmuxr2_field_t;

typedef struct
{
    __IO uint16_t CH12MUX                   : 4;
    __IO uint16_t CH13MUX                   : 4;
    __IO uint16_t CH14MUX                   : 4;
    __IO uint16_t CH15MUX                   : 4;
} stc_adc_chmuxr3_field_t;

typedef struct
{
    __IO uint8_t EOCAF                      : 1;
    __IO uint8_t EOCBF                      : 1;
    uint8_t RESERVED2                       : 6;
} stc_adc_isr_field_t;

typedef struct
{
    __IO uint8_t EOCAIEN                    : 1;
    __IO uint8_t EOCBIEN                    : 1;
    uint8_t RESERVED2                       : 6;
} stc_adc_icr_field_t;

typedef struct
{
    __IO uint16_t SYNCEN                    : 1;
    uint16_t RESERVED1                      : 3;
    __IO uint16_t SYNCMD                    : 3;
    uint16_t RESERVED7                      : 1;
    __IO uint16_t SYNCDLY                   : 8;
} stc_adc_synccr_field_t;

typedef struct
{
    __IO uint16_t AWDEN                     : 1;
    uint16_t RESERVED1                      : 3;
    __IO uint16_t AWDMD                     : 1;
    uint16_t RESERVED5                      : 1;
    __IO uint16_t AWDSS                     : 2;
    __IO uint16_t AWDIEN                    : 1;
    uint16_t RESERVED9                      : 7;
} stc_adc_awdcr_field_t;

typedef struct
{
    __IO uint16_t AWDCH16                   : 1;
    uint16_t RESERVED1                      :15;
} stc_adc_awdchsr1_field_t;

typedef struct
{
    __IO uint16_t AWDF16                    : 1;
    uint16_t RESERVED1                      :15;
} stc_adc_awdsr1_field_t;

typedef struct
{
    __IO uint16_t PGACTL                    : 4;
    uint16_t RESERVED4                      :12;
} stc_adc_pgacr_field_t;

typedef struct
{
    __IO uint16_t GAIN                      : 4;
    uint16_t RESERVED4                      :12;
} stc_adc_pgagsr_field_t;

typedef struct
{
    __IO uint16_t PGAINSEL                  : 9;
    uint16_t RESERVED9                      : 7;
} stc_adc_pgainsr0_field_t;

typedef struct
{
    __IO uint16_t PGAVSSEN                  : 1;
    uint16_t RESERVED1                      :15;
} stc_adc_pgainsr1_field_t;

typedef struct
{
    __IO uint32_t START                     : 1;
    __IO uint32_t MODE                      : 1;
    uint32_t RESERVED2                      :30;
} stc_aes_cr_field_t;

typedef struct
{
    __O  uint32_t STRG                      : 1;
    uint32_t RESERVED1                      :31;
} stc_aos_int_sfttrg_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_dcu1_trgsel_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_dcu2_trgsel_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_dcu3_trgsel_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_dcu4_trgsel_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_dma1_trgsel_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_dma1_trgsel3_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_dma2_trgsel_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_dma_trgselrc_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_tmr6_htssr_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_tmr0_htssr_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_pevnttrgsr12_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_pevnttrgsr34_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_tmra_htssr_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_ots_trg_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_adc1_itrgselr_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :21;
    __IO uint32_t COMTRG_EN                 : 2;
} stc_aos_adc2_itrgselr_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :23;
} stc_aos_comtrg1_field_t;

typedef struct
{
    __IO uint32_t TRGSEL                    : 9;
    uint32_t RESERVED9                      :23;
} stc_aos_comtrg2_field_t;

typedef struct
{
    __IO uint32_t PDIR00                    : 1;
    __IO uint32_t PDIR01                    : 1;
    __IO uint32_t PDIR02                    : 1;
    __IO uint32_t PDIR03                    : 1;
    __IO uint32_t PDIR04                    : 1;
    __IO uint32_t PDIR05                    : 1;
    __IO uint32_t PDIR06                    : 1;
    __IO uint32_t PDIR07                    : 1;
    __IO uint32_t PDIR08                    : 1;
    __IO uint32_t PDIR09                    : 1;
    __IO uint32_t PDIR10                    : 1;
    __IO uint32_t PDIR11                    : 1;
    __IO uint32_t PDIR12                    : 1;
    __IO uint32_t PDIR13                    : 1;
    __IO uint32_t PDIR14                    : 1;
    __IO uint32_t PDIR15                    : 1;
    uint32_t RESERVED16                     :16;
} stc_aos_pevntdirr_field_t;

typedef struct
{
    __I  uint32_t PIN00                     : 1;
    __I  uint32_t PIN01                     : 1;
    __I  uint32_t PIN02                     : 1;
    __I  uint32_t PIN03                     : 1;
    __I  uint32_t PIN04                     : 1;
    __I  uint32_t PIN05                     : 1;
    __I  uint32_t PIN06                     : 1;
    __I  uint32_t PIN07                     : 1;
    __I  uint32_t PIN08                     : 1;
    __I  uint32_t PIN09                     : 1;
    __I  uint32_t PIN10                     : 1;
    __I  uint32_t PIN11                     : 1;
    __I  uint32_t PIN12                     : 1;
    __I  uint32_t PIN13                     : 1;
    __I  uint32_t PIN14                     : 1;
    __I  uint32_t PIN15                     : 1;
    uint32_t RESERVED16                     :16;
} stc_aos_pevntidr_field_t;

typedef struct
{
    __IO uint32_t POUT00                    : 1;
    __IO uint32_t POUT01                    : 1;
    __IO uint32_t POUT02                    : 1;
    __IO uint32_t POUT03                    : 1;
    __IO uint32_t POUT04                    : 1;
    __IO uint32_t POUT05                    : 1;
    __IO uint32_t POUT06                    : 1;
    __IO uint32_t POUT07                    : 1;
    __IO uint32_t POUT08                    : 1;
    __IO uint32_t POUT09                    : 1;
    __IO uint32_t POUT10                    : 1;
    __IO uint32_t POUT11                    : 1;
    __IO uint32_t POUT12                    : 1;
    __IO uint32_t POUT13                    : 1;
    __IO uint32_t POUT14                    : 1;
    __IO uint32_t POUT15                    : 1;
    uint32_t RESERVED16                     :16;
} stc_aos_pevntodr_field_t;

typedef struct
{
    __IO uint32_t POR00                     : 1;
    __IO uint32_t POR01                     : 1;
    __IO uint32_t POR02                     : 1;
    __IO uint32_t POR03                     : 1;
    __IO uint32_t POR04                     : 1;
    __IO uint32_t POR05                     : 1;
    __IO uint32_t POR06                     : 1;
    __IO uint32_t POR07                     : 1;
    __IO uint32_t POR08                     : 1;
    __IO uint32_t POR09                     : 1;
    __IO uint32_t POR10                     : 1;
    __IO uint32_t POR11                     : 1;
    __IO uint32_t POR12                     : 1;
    __IO uint32_t POR13                     : 1;
    __IO uint32_t POR14                     : 1;
    __IO uint32_t POR15                     : 1;
    uint32_t RESERVED16                     :16;
} stc_aos_pevntorr_field_t;

typedef struct
{
    __IO uint32_t POS00                     : 1;
    __IO uint32_t POS01                     : 1;
    __IO uint32_t POS02                     : 1;
    __IO uint32_t POS03                     : 1;
    __IO uint32_t POS04                     : 1;
    __IO uint32_t POS05                     : 1;
    __IO uint32_t POS06                     : 1;
    __IO uint32_t POS07                     : 1;
    __IO uint32_t POS08                     : 1;
    __IO uint32_t POS09                     : 1;
    __IO uint32_t POS10                     : 1;
    __IO uint32_t POS11                     : 1;
    __IO uint32_t POS12                     : 1;
    __IO uint32_t POS13                     : 1;
    __IO uint32_t POS14                     : 1;
    __IO uint32_t POS15                     : 1;
    uint32_t RESERVED16                     :16;
} stc_aos_pevntosr_field_t;

typedef struct
{
    __IO uint32_t RIS00                     : 1;
    __IO uint32_t RIS01                     : 1;
    __IO uint32_t RIS02                     : 1;
    __IO uint32_t RIS03                     : 1;
    __IO uint32_t RIS04                     : 1;
    __IO uint32_t RIS05                     : 1;
    __IO uint32_t RIS06                     : 1;
    __IO uint32_t RIS07                     : 1;
    __IO uint32_t RIS08                     : 1;
    __IO uint32_t RIS09                     : 1;
    __IO uint32_t RIS10                     : 1;
    __IO uint32_t RIS11                     : 1;
    __IO uint32_t RIS12                     : 1;
    __IO uint32_t RIS13                     : 1;
    __IO uint32_t RIS14                     : 1;
    __IO uint32_t RIS15                     : 1;
    uint32_t RESERVED16                     :16;
} stc_aos_pevntrisr_field_t;

typedef struct
{
    __IO uint32_t FAL00                     : 1;
    __IO uint32_t FAL01                     : 1;
    __IO uint32_t FAL02                     : 1;
    __IO uint32_t FAL03                     : 1;
    __IO uint32_t FAL04                     : 1;
    __IO uint32_t FAL05                     : 1;
    __IO uint32_t FAL06                     : 1;
    __IO uint32_t FAL07                     : 1;
    __IO uint32_t FAL08                     : 1;
    __IO uint32_t FAL09                     : 1;
    __IO uint32_t FAL10                     : 1;
    __IO uint32_t FAL11                     : 1;
    __IO uint32_t FAL12                     : 1;
    __IO uint32_t FAL13                     : 1;
    __IO uint32_t FAL14                     : 1;
    __IO uint32_t FAL15                     : 1;
    uint32_t RESERVED16                     :16;
} stc_aos_pevntfal_field_t;

typedef struct
{
    __IO uint32_t NFEN1                     : 1;
    __IO uint32_t DIVS1                     : 2;
    uint32_t RESERVED3                      : 5;
    __IO uint32_t NFEN2                     : 1;
    __IO uint32_t DIVS2                     : 2;
    uint32_t RESERVED11                     : 5;
    __IO uint32_t NFEN3                     : 1;
    __IO uint32_t DIVS3                     : 2;
    uint32_t RESERVED19                     : 5;
    __IO uint32_t NFEN4                     : 1;
    __IO uint32_t DIVS4                     : 2;
    uint32_t RESERVED27                     : 5;
} stc_aos_pevntnfcr_field_t;

typedef struct
{
    __IO uint8_t BUSOFF                     : 1;
    __I  uint8_t TACTIVE                    : 1;
    __I  uint8_t RACTIVE                    : 1;
    __IO uint8_t TSSS                       : 1;
    __IO uint8_t TPSS                       : 1;
    __IO uint8_t LBMI                       : 1;
    __IO uint8_t LBME                       : 1;
    __IO uint8_t RESET                      : 1;
} stc_can_cfg_stat_field_t;

typedef struct
{
    __IO uint8_t TSA                        : 1;
    __IO uint8_t TSALL                      : 1;
    __IO uint8_t TSONE                      : 1;
    __IO uint8_t TPA                        : 1;
    __IO uint8_t TPE                        : 1;
    uint8_t RESERVED5                       : 1;
    __IO uint8_t LOM                        : 1;
    __IO uint8_t TBSEL                      : 1;
} stc_can_tcmd_field_t;

typedef struct
{
    __I  uint8_t TSSTAT                     : 2;
    uint8_t RESERVED2                       : 2;
    __IO uint8_t TTTBM                      : 1;
    __IO uint8_t TSMODE                     : 1;
    __IO uint8_t TSNEXT                     : 1;
    uint8_t RESERVED7                       : 1;
} stc_can_tctrl_field_t;

typedef struct
{
    __I  uint8_t RSTAT                      : 2;
    uint8_t RESERVED2                       : 1;
    __IO uint8_t RBALL                      : 1;
    __IO uint8_t RREL                       : 1;
    __I  uint8_t ROV                        : 1;
    __IO uint8_t ROM                        : 1;
    __IO uint8_t SACK                       : 1;
} stc_can_rctrl_field_t;

typedef struct
{
    __I  uint8_t TSFF                       : 1;
    __IO uint8_t EIE                        : 1;
    __IO uint8_t TSIE                       : 1;
    __IO uint8_t TPIE                       : 1;
    __IO uint8_t RAFIE                      : 1;
    __IO uint8_t RFIE                       : 1;
    __IO uint8_t ROIE                       : 1;
    __IO uint8_t RIE                        : 1;
} stc_can_rtie_field_t;

typedef struct
{
    __IO uint8_t AIF                        : 1;
    __IO uint8_t EIF                        : 1;
    __IO uint8_t TSIF                       : 1;
    __IO uint8_t TPIF                       : 1;
    __IO uint8_t RAFIF                      : 1;
    __IO uint8_t RFIF                       : 1;
    __IO uint8_t ROIF                       : 1;
    __IO uint8_t RIF                        : 1;
} stc_can_rtif_field_t;

typedef struct
{
    __IO uint8_t BEIF                       : 1;
    __IO uint8_t BEIE                       : 1;
    __IO uint8_t ALIF                       : 1;
    __IO uint8_t ALIE                       : 1;
    __IO uint8_t EPIF                       : 1;
    __IO uint8_t EPIE                       : 1;
    __I  uint8_t EPASS                      : 1;
    __I  uint8_t EWARN                      : 1;
} stc_can_errint_field_t;

typedef struct
{
    __IO uint8_t EWL                        : 4;
    __IO uint8_t AFWL                       : 4;
} stc_can_limit_field_t;

typedef struct
{
    __IO uint32_t SEG_1                     : 8;
    __IO uint32_t SEG_2                     : 7;
    uint32_t RESERVED15                     : 1;
    __IO uint32_t SJW                       : 7;
    uint32_t RESERVED23                     : 1;
    __IO uint32_t PRESC                     : 8;
} stc_can_bt_field_t;

typedef struct
{
    __I  uint8_t ALC                        : 5;
    __I  uint8_t KOER                       : 3;
} stc_can_ealcap_field_t;

typedef struct
{
    __IO uint8_t ACFADR                     : 4;
    uint8_t RESERVED4                       : 1;
    __IO uint8_t SELMASK                    : 1;
    uint8_t RESERVED6                       : 2;
} stc_can_acfctrl_field_t;

typedef struct
{
    __IO uint8_t AE_1                       : 1;
    __IO uint8_t AE_2                       : 1;
    __IO uint8_t AE_3                       : 1;
    __IO uint8_t AE_4                       : 1;
    __IO uint8_t AE_5                       : 1;
    __IO uint8_t AE_6                       : 1;
    __IO uint8_t AE_7                       : 1;
    __IO uint8_t AE_8                       : 1;
} stc_can_acfen_field_t;

typedef struct
{
    __IO uint32_t ACODEORAMASK              :29;
    __IO uint32_t AIDE                      : 1;
    __IO uint32_t AIDEE                     : 1;
    uint32_t RESERVED31                     : 1;
} stc_can_acf_field_t;

typedef struct
{
    __IO uint8_t TBPTR                      : 6;
    __IO uint8_t TBF                        : 1;
    __IO uint8_t TBE                        : 1;
} stc_can_tbslot_field_t;

typedef struct
{
    __IO uint8_t TTEN                       : 1;
    __IO uint8_t T_PRESC                    : 2;
    __IO uint8_t TTIF                       : 1;
    __IO uint8_t TTIE                       : 1;
    __IO uint8_t TEIF                       : 1;
    __IO uint8_t WTIF                       : 1;
    __IO uint8_t WTIE                       : 1;
} stc_can_ttcfg_field_t;

typedef struct
{
    __IO uint32_t REF_ID                    :29;
    uint32_t RESERVED29                     : 2;
    __IO uint32_t REF_IDE                   : 1;
} stc_can_ref_msg_field_t;

typedef struct
{
    __IO uint16_t TTPTR                     : 6;
    uint16_t RESERVED6                      : 2;
    __IO uint16_t TTYPE                     : 3;
    uint16_t RESERVED11                     : 1;
    __IO uint16_t TEW                       : 4;
} stc_can_trg_cfg_field_t;

typedef struct
{
    __IO uint16_t FLTSL                     : 3;
    uint16_t RESERVED3                      : 2;
    __IO uint16_t EDGSL                     : 2;
    __IO uint16_t IEN                       : 1;
    __IO uint16_t CVSEN                     : 1;
    uint16_t RESERVED9                      : 3;
    __IO uint16_t OUTEN                     : 1;
    __IO uint16_t INV                       : 1;
    __IO uint16_t CMPOE                     : 1;
    __IO uint16_t CMPON                     : 1;
} stc_cmp_ctrl_field_t;

typedef struct
{
    __IO uint16_t RVSL                      : 4;
    uint16_t RESERVED4                      : 4;
    __IO uint16_t CVSL                      : 4;
    __IO uint16_t C4SL                      : 3;
    uint16_t RESERVED15                     : 1;
} stc_cmp_vltsel_field_t;

typedef struct
{
    __I  uint16_t OMON                      : 1;
    uint16_t RESERVED1                      : 7;
    __I  uint16_t CVST                      : 4;
    uint16_t RESERVED12                     : 4;
} stc_cmp_outmon_field_t;

typedef struct
{
    __IO uint16_t STB                       : 4;
    uint16_t RESERVED4                      :12;
} stc_cmp_cvsstb_field_t;

typedef struct
{
    __IO uint16_t PRD                       : 8;
    uint16_t RESERVED8                      : 8;
} stc_cmp_cvsprd_field_t;

typedef struct
{
    __IO uint16_t DATA                      : 8;
    uint16_t RESERVED8                      : 8;
} stc_cmp_cr_dadr1_field_t;

typedef struct
{
    __IO uint16_t DATA                      : 8;
    uint16_t RESERVED8                      : 8;
} stc_cmp_cr_dadr2_field_t;

typedef struct
{
    __IO uint16_t DA1EN                     : 1;
    __IO uint16_t DA2EN                     : 1;
    uint16_t RESERVED2                      :14;
} stc_cmp_cr_dacr_field_t;

typedef struct
{
    __IO uint16_t DA1SW                     : 1;
    __IO uint16_t DA2SW                     : 1;
    uint16_t RESERVED2                      : 2;
    __IO uint16_t VREFSW                    : 1;
    uint16_t RESERVED5                      : 3;
    __IO uint16_t WPRT                      : 8;
} stc_cmp_cr_rvadc_field_t;

typedef struct
{
    uint32_t RESERVED0                      : 1;
    __IO uint32_t CRC_SEL                   : 1;
    __IO uint32_t REFIN                     : 1;
    __IO uint32_t REFOUT                    : 1;
    __IO uint32_t XOROUT                    : 1;
    uint32_t RESERVED5                      :27;
} stc_crc_cr_field_t;

typedef struct
{
    __IO uint32_t CRC_REG                   :16;
    __I  uint32_t CRCFLAG_16                : 1;
    uint32_t RESERVED17                     :15;
} stc_crc_reslt_field_t;

typedef struct
{
    __I  uint32_t FLAG                      : 1;
    uint32_t RESERVED1                      :31;
} stc_crc_flg_field_t;

typedef struct
{
    __IO uint32_t AUTH                      : 1;
    __IO uint32_t REMVLOCK                  : 1;
    __IO uint32_t SAFTYLOCK1                : 1;
    __IO uint32_t SAFTYLOCK2                : 1;
    uint32_t RESERVED4                      : 4;
    __IO uint32_t CPUSTOP                   : 1;
    __IO uint32_t CPUSLEEP                  : 1;
    uint32_t RESERVED10                     :22;
} stc_dbgc_mcustat_field_t;

typedef struct
{
    __IO uint32_t EDBGRQ                    : 1;
    __IO uint32_t RESTART                   : 1;
    uint32_t RESERVED2                      : 6;
    __IO uint32_t DIRQ                      : 1;
    uint32_t RESERVED9                      :23;
} stc_dbgc_mcuctl_field_t;

typedef struct
{
    __IO uint32_t ERASEREQ                  : 1;
    __IO uint32_t ERASEACK                  : 1;
    __IO uint32_t ERASEERR                  : 1;
    uint32_t RESERVED3                      :29;
} stc_dbgc_fmcctl_field_t;

typedef struct
{
    __IO uint32_t CDBGPWRUPREQ              : 1;
    __IO uint32_t CDBGPWRUPACK              : 1;
    uint32_t RESERVED2                      :30;
} stc_dbgc_mcudbgstat_field_t;

typedef struct
{
    __IO uint32_t SWDTSTP                   : 1;
    __IO uint32_t WDTSTP                    : 1;
    __IO uint32_t RTCSTP                    : 1;
    __IO uint32_t PVD0STP                   : 1;
    __IO uint32_t PVD1STP                   : 1;
    __IO uint32_t PVD2STP                   : 1;
    uint32_t RESERVED6                      : 8;
    __IO uint32_t TMR01STP                  : 1;
    __IO uint32_t TMR02STP                  : 1;
    uint32_t RESERVED16                     : 4;
    __IO uint32_t TMR41STP                  : 1;
    __IO uint32_t TMR42STP                  : 1;
    __IO uint32_t TMR43STP                  : 1;
    __IO uint32_t TM61STP                   : 1;
    __IO uint32_t TM62STP                   : 1;
    __IO uint32_t TMR63STP                  : 1;
    __IO uint32_t TMRA1STP                  : 1;
    __IO uint32_t TMRA2STP                  : 1;
    __IO uint32_t TMRA3STP                  : 1;
    __IO uint32_t TMRA4STP                  : 1;
    __IO uint32_t TMRA5STP                  : 1;
    __IO uint32_t TMRA6STP                  : 1;
} stc_dbgc_mcustpctl_field_t;

typedef struct
{
    __IO uint32_t TRACEMODE                 : 2;
    __IO uint32_t TRACEIOEN                 : 1;
    uint32_t RESERVED3                      :29;
} stc_dbgc_mcutracectl_field_t;

typedef struct
{
    __IO uint32_t MODE                      : 3;
    __IO uint32_t DATASIZE                  : 2;
    uint32_t RESERVED5                      : 3;
    __IO uint32_t COMP_TRG                  : 1;
    uint32_t RESERVED9                      :22;
    __IO uint32_t INTEN                     : 1;
} stc_dcu_ctl_field_t;

typedef struct
{
    __I  uint32_t FLAG_OP                   : 1;
    __I  uint32_t FLAG_LS2                  : 1;
    __I  uint32_t FLAG_EQ2                  : 1;
    __I  uint32_t FLAG_GT2                  : 1;
    __I  uint32_t FLAG_LS1                  : 1;
    __I  uint32_t FLAG_EQ1                  : 1;
    __I  uint32_t FLAG_GT1                  : 1;
    uint32_t RESERVED7                      :25;
} stc_dcu_flag_field_t;

typedef struct
{
    __O  uint32_t CLR_OP                    : 1;
    __O  uint32_t CLR_LS2                   : 1;
    __O  uint32_t CLR_EQ2                   : 1;
    __O  uint32_t CLR_GT2                   : 1;
    __O  uint32_t CLR_LS1                   : 1;
    __O  uint32_t CLR_EQ1                   : 1;
    __O  uint32_t CLR_GT1                   : 1;
    uint32_t RESERVED7                      :25;
} stc_dcu_flagclr_field_t;

typedef struct
{
    __IO uint32_t INT_OP                    : 1;
    __IO uint32_t INT_LS2                   : 1;
    __IO uint32_t INT_EQ2                   : 1;
    __IO uint32_t INT_GT2                   : 1;
    __IO uint32_t INT_LS1                   : 1;
    __IO uint32_t INT_EQ1                   : 1;
    __IO uint32_t INT_GT1                   : 1;
    __IO uint32_t INT_WIN                   : 2;
    uint32_t RESERVED9                      :23;
} stc_dcu_intsel_field_t;

typedef struct
{
    __IO uint32_t EN                        : 1;
    uint32_t RESERVED1                      :31;
} stc_dma_en_field_t;

typedef struct
{
    __I  uint32_t TRNERR                    : 4;
    uint32_t RESERVED4                      :12;
    __I  uint32_t REQERR                    : 4;
    uint32_t RESERVED20                     :12;
} stc_dma_intstat0_field_t;

typedef struct
{
    __I  uint32_t TC                        : 4;
    uint32_t RESERVED4                      :12;
    __I  uint32_t BTC                       : 4;
    uint32_t RESERVED20                     :12;
} stc_dma_intstat1_field_t;

typedef struct
{
    __IO uint32_t MSKTRNERR                 : 4;
    uint32_t RESERVED4                      :12;
    __IO uint32_t MSKREQERR                 : 4;
    uint32_t RESERVED20                     :12;
} stc_dma_intmask0_field_t;

typedef struct
{
    __IO uint32_t MSKTC                     : 4;
    uint32_t RESERVED4                      :12;
    __IO uint32_t MSKBTC                    : 4;
    uint32_t RESERVED20                     :12;
} stc_dma_intmask1_field_t;

typedef struct
{
    __O  uint32_t CLRTRNERR                 : 4;
    uint32_t RESERVED4                      :12;
    __O  uint32_t CLRREQERR                 : 4;
    uint32_t RESERVED20                     :12;
} stc_dma_intclr0_field_t;

typedef struct
{
    __O  uint32_t CLRTC                     : 4;
    uint32_t RESERVED4                      :12;
    __O  uint32_t CLRBTC                    : 4;
    uint32_t RESERVED20                     :12;
} stc_dma_intclr1_field_t;

typedef struct
{
    __IO uint32_t CHEN                      : 4;
    uint32_t RESERVED4                      :28;
} stc_dma_chen_field_t;

typedef struct
{
    __I  uint32_t CHREQ                     : 4;
    uint32_t RESERVED4                      :11;
    __I  uint32_t RCFGREQ                   : 1;
    uint32_t RESERVED16                     :16;
} stc_dma_reqstat_field_t;

typedef struct
{
    __I  uint32_t DMAACT                    : 1;
    __I  uint32_t RCFGACT                   : 1;
    uint32_t RESERVED2                      :14;
    __I  uint32_t CHACT                     : 4;
    uint32_t RESERVED20                     :12;
} stc_dma_chstat_field_t;

typedef struct
{
    __IO uint32_t RCFGEN                    : 1;
    __IO uint32_t RCFGLLP                   : 1;
    uint32_t RESERVED2                      : 6;
    __IO uint32_t RCFGCHS                   : 4;
    uint32_t RESERVED12                     : 4;
    __IO uint32_t SARMD                     : 2;
    __IO uint32_t DARMD                     : 2;
    __IO uint32_t CNTMD                     : 2;
    uint32_t RESERVED22                     :10;
} stc_dma_rcfgctl_field_t;

typedef struct
{
    __IO uint32_t BLKSIZE                   :10;
    uint32_t RESERVED10                     : 6;
    __IO uint32_t CNT                       :16;
} stc_dma_dtctl_field_t;

typedef struct
{
    __IO uint32_t SRPT                      :10;
    uint32_t RESERVED10                     : 6;
    __IO uint32_t DRPT                      :10;
    uint32_t RESERVED26                     : 6;
} stc_dma_rpt_field_t;

typedef struct
{
    __IO uint32_t SRPTB                     :10;
    uint32_t RESERVED10                     : 6;
    __IO uint32_t DRPTB                     :10;
    uint32_t RESERVED26                     : 6;
} stc_dma_rptb_field_t;

typedef struct
{
    __IO uint32_t SOFFSET                   :20;
    __IO uint32_t SNSCNT                    :12;
} stc_dma_snseqctl_field_t;

typedef struct
{
    __IO uint32_t SNSDIST                   :20;
    __IO uint32_t SNSCNTB                   :12;
} stc_dma_snseqctlb_field_t;

typedef struct
{
    __IO uint32_t DOFFSET                   :20;
    __IO uint32_t DNSCNT                    :12;
} stc_dma_dnseqctl_field_t;

typedef struct
{
    __IO uint32_t DNSDIST                   :20;
    __IO uint32_t DNSCNTB                   :12;
} stc_dma_dnseqctlb_field_t;

typedef struct
{
    uint32_t RESERVED0                      : 2;
    __IO uint32_t LLP                       :30;
} stc_dma_llp_field_t;

typedef struct
{
    __IO uint32_t SINC                      : 2;
    __IO uint32_t DINC                      : 2;
    __IO uint32_t SRPTEN                    : 1;
    __IO uint32_t DRPTEN                    : 1;
    __IO uint32_t SNSEQEN                   : 1;
    __IO uint32_t DNSEQEN                   : 1;
    __IO uint32_t HSIZE                     : 2;
    __IO uint32_t LLPEN                     : 1;
    __IO uint32_t LLPRUN                    : 1;
    __IO uint32_t IE                        : 1;
    uint32_t RESERVED13                     :19;
} stc_dma_chctl_field_t;

typedef struct
{
    __I  uint32_t BLKSIZE                   :10;
    uint32_t RESERVED10                     : 6;
    __I  uint32_t CNT                       :16;
} stc_dma_mondtctl_field_t;

typedef struct
{
    __I  uint32_t SRPT                      :10;
    uint32_t RESERVED10                     : 6;
    __I  uint32_t DRPT                      :10;
    uint32_t RESERVED26                     : 6;
} stc_dma_monrpt_field_t;

typedef struct
{
    __I  uint32_t SOFFSET                   :20;
    __I  uint32_t SNSCNT                    :12;
} stc_dma_monsnseqctl_field_t;

typedef struct
{
    __I  uint32_t DOFFSET                   :20;
    __I  uint32_t DNSCNT                    :12;
} stc_dma_mondnseqctl_field_t;

typedef struct
{
    __IO uint32_t FAPRT                     :16;
    uint32_t RESERVED16                     :16;
} stc_efm_faprt_field_t;

typedef struct
{
    __IO uint32_t FSTP                      : 1;
    uint32_t RESERVED1                      :31;
} stc_efm_fstp_field_t;

typedef struct
{
    __IO uint32_t SLPMD                     : 1;
    uint32_t RESERVED1                      : 3;
    __IO uint32_t FLWT                      : 4;
    __IO uint32_t LVM                       : 1;
    uint32_t RESERVED9                      : 7;
    __IO uint32_t CACHE                     : 1;
    uint32_t RESERVED17                     : 7;
    __IO uint32_t CRST                      : 1;
    uint32_t RESERVED25                     : 7;
} stc_efm_frmc_field_t;

typedef struct
{
    __IO uint32_t PEMODE                    : 1;
    uint32_t RESERVED1                      : 3;
    __IO uint32_t PEMOD                     : 3;
    uint32_t RESERVED7                      : 1;
    __IO uint32_t BUSHLDCTL                 : 1;
    uint32_t RESERVED9                      :23;
} stc_efm_fwmc_field_t;

typedef struct
{
    __I  uint32_t PEWERR                    : 1;
    __I  uint32_t PEPRTERR                  : 1;
    __I  uint32_t PGSZERR                   : 1;
    __I  uint32_t PGMISMTCH                 : 1;
    __I  uint32_t OPTEND                    : 1;
    __I  uint32_t COLERR                    : 1;
    uint32_t RESERVED6                      : 2;
    __I  uint32_t RDY                       : 1;
    uint32_t RESERVED9                      :23;
} stc_efm_fsr_field_t;

typedef struct
{
    __IO uint32_t PEWERRCLR                 : 1;
    __IO uint32_t PEPRTERRCLR               : 1;
    __IO uint32_t PGSZERRCLR                : 1;
    __IO uint32_t PGMISMTCHCLR              : 1;
    __IO uint32_t OPTENDCLR                 : 1;
    __IO uint32_t COLERRCLR                 : 1;
    uint32_t RESERVED6                      :26;
} stc_efm_fsclr_field_t;

typedef struct
{
    __IO uint32_t PEERRITE                  : 1;
    __IO uint32_t OPTENDITE                 : 1;
    __IO uint32_t COLERRITE                 : 1;
    uint32_t RESERVED3                      :29;
} stc_efm_fite_field_t;

typedef struct
{
    __I  uint32_t FSWP                      : 1;
    uint32_t RESERVED1                      :31;
} stc_efm_fswp_field_t;

typedef struct
{
    __IO uint32_t FPMTSW                    :19;
    uint32_t RESERVED19                     :13;
} stc_efm_fpmtsw_field_t;

typedef struct
{
    __IO uint32_t FPMTEW                    :19;
    uint32_t RESERVED19                     :13;
} stc_efm_fpmtew_field_t;

typedef struct
{
    __IO uint32_t REMPRT                    :16;
    uint32_t RESERVED16                     :16;
} stc_efm_mmf_remprt_field_t;

typedef struct
{
    __IO uint32_t RM0SIZE                   : 5;
    uint32_t RESERVED5                      : 7;
    __IO uint32_t RM0TADDR                  :17;
    uint32_t RESERVED29                     : 2;
    __IO uint32_t EN0                       : 1;
} stc_efm_mmf_remcr0_field_t;

typedef struct
{
    __IO uint32_t RM1SIZE                   : 5;
    uint32_t RESERVED5                      : 7;
    __IO uint32_t RM1TADDR                  :17;
    uint32_t RESERVED29                     : 2;
    __IO uint32_t EN1                       : 1;
} stc_efm_mmf_remcr1_field_t;

typedef struct
{
    uint32_t RESERVED0                      : 1;
    __IO uint32_t FRANDS                    :14;
    uint32_t RESERVED15                     : 1;
    __IO uint32_t FRANDFG                   : 1;
    uint32_t RESERVED17                     :15;
} stc_efm_frands_field_t;

typedef struct
{
    __IO uint32_t PORTINEN                  : 1;
    __IO uint32_t CMPEN                     : 3;
    uint32_t RESERVED4                      : 1;
    __IO uint32_t OSCSTPEN                  : 1;
    __IO uint32_t PWMSEN                    : 3;
    uint32_t RESERVED9                      :19;
    __IO uint32_t NFSEL                     : 2;
    __IO uint32_t NFEN                      : 1;
    __IO uint32_t INVSEL                    : 1;
} stc_emb_ctl_field_t;

typedef struct
{
    __IO uint32_t PWMLV                     : 3;
    uint32_t RESERVED3                      :29;
} stc_emb_pwmlv_field_t;

typedef struct
{
    __IO uint32_t SOE                       : 1;
    uint32_t RESERVED1                      :31;
} stc_emb_soe_field_t;

typedef struct
{
    __I  uint32_t PORTINF                   : 1;
    __I  uint32_t PWMSF                     : 1;
    __I  uint32_t CMPF                      : 1;
    __I  uint32_t OSF                       : 1;
    __I  uint32_t PORTINST                  : 1;
    __I  uint32_t PWMST                     : 1;
    uint32_t RESERVED6                      :26;
} stc_emb_stat_field_t;

typedef struct
{
    __O  uint32_t PORTINFCLR                : 1;
    __O  uint32_t PWMSFCLR                  : 1;
    __O  uint32_t CMPFCLR                   : 1;
    __O  uint32_t OSFCLR                    : 1;
    uint32_t RESERVED4                      :28;
} stc_emb_statclr_field_t;

typedef struct
{
    __IO uint32_t PORTINTEN                 : 1;
    __IO uint32_t PWMINTEN                  : 1;
    __IO uint32_t CMPINTEN                  : 1;
    __IO uint32_t OSINTEN                   : 1;
    uint32_t RESERVED4                      :28;
} stc_emb_inten_field_t;

typedef struct
{
    __IO uint32_t LVR                       :16;
    uint32_t RESERVED16                     :16;
} stc_fcm_lvr_field_t;

typedef struct
{
    __IO uint32_t UVR                       :16;
    uint32_t RESERVED16                     :16;
} stc_fcm_uvr_field_t;

typedef struct
{
    __I  uint32_t CNTR                      :16;
    uint32_t RESERVED16                     :16;
} stc_fcm_cntr_field_t;

typedef struct
{
    __IO uint32_t START                     : 1;
    uint32_t RESERVED1                      :31;
} stc_fcm_str_field_t;

typedef struct
{
    __IO uint32_t MDIVS                     : 2;
    uint32_t RESERVED2                      : 2;
    __IO uint32_t MCKS                      : 4;
    uint32_t RESERVED8                      :24;
} stc_fcm_mccr_field_t;

typedef struct
{
    __IO uint32_t RDIVS                     : 2;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t RCKS                      : 4;
    __IO uint32_t INEXS                     : 1;
    __IO uint32_t DNFS                      : 2;
    uint32_t RESERVED10                     : 2;
    __IO uint32_t EDGES                     : 2;
    uint32_t RESERVED14                     : 1;
    __IO uint32_t EXREFE                    : 1;
    uint32_t RESERVED16                     :16;
} stc_fcm_rccr_field_t;

typedef struct
{
    __IO uint32_t ERRIE                     : 1;
    __IO uint32_t MENDIE                    : 1;
    __IO uint32_t OVFIE                     : 1;
    uint32_t RESERVED3                      : 1;
    __IO uint32_t ERRINTRS                  : 1;
    uint32_t RESERVED5                      : 2;
    __IO uint32_t ERRE                      : 1;
    uint32_t RESERVED8                      :24;
} stc_fcm_rier_field_t;

typedef struct
{
    __I  uint32_t ERRF                      : 1;
    __I  uint32_t MENDF                     : 1;
    __I  uint32_t OVF                       : 1;
    uint32_t RESERVED3                      :29;
} stc_fcm_sr_field_t;

typedef struct
{
    __O  uint32_t ERRFCLR                   : 1;
    __O  uint32_t MENDFCLR                  : 1;
    __O  uint32_t OVFCLR                    : 1;
    uint32_t RESERVED3                      :29;
} stc_fcm_clr_field_t;

typedef struct
{
    __IO uint32_t START                     : 1;
    __IO uint32_t FST_GRP                   : 1;
    uint32_t RESERVED2                      :30;
} stc_hash_cr_field_t;

typedef struct
{
    __IO uint32_t PE                        : 1;
    __IO uint32_t SMBUS                     : 1;
    __IO uint32_t SMBALRTEN                 : 1;
    __IO uint32_t SMBDEFAULTEN              : 1;
    __IO uint32_t SMBHOSTEN                 : 1;
    uint32_t RESERVED5                      : 1;
    __IO uint32_t ENGC                      : 1;
    __IO uint32_t RESTART                   : 1;
    __IO uint32_t START                     : 1;
    __IO uint32_t STOP                      : 1;
    __IO uint32_t ACK                       : 1;
    uint32_t RESERVED11                     : 4;
    __IO uint32_t SWRST                     : 1;
    uint32_t RESERVED16                     :16;
} stc_i2c_cr1_field_t;

typedef struct
{
    __IO uint32_t STARTIE                   : 1;
    __IO uint32_t SLADDR0IE                 : 1;
    __IO uint32_t SLADDR1IE                 : 1;
    __IO uint32_t TENDIE                    : 1;
    __IO uint32_t STOPIE                    : 1;
    uint32_t RESERVED5                      : 1;
    __IO uint32_t RFULLIE                   : 1;
    __IO uint32_t TEMPTYIE                  : 1;
    uint32_t RESERVED8                      : 1;
    __IO uint32_t ARLOIE                    : 1;
    uint32_t RESERVED10                     : 2;
    __IO uint32_t NACKIE                    : 1;
    uint32_t RESERVED13                     : 1;
    __IO uint32_t TMOUTIE                   : 1;
    uint32_t RESERVED15                     : 5;
    __IO uint32_t GENCALLIE                 : 1;
    __IO uint32_t SMBDEFAULTIE              : 1;
    __IO uint32_t SMBHOSTIE                 : 1;
    __IO uint32_t SMBALRTIE                 : 1;
    uint32_t RESERVED24                     : 8;
} stc_i2c_cr2_field_t;

typedef struct
{
    __IO uint32_t TMOUTEN                   : 1;
    __IO uint32_t LTMOUT                    : 1;
    __IO uint32_t HTMOUT                    : 1;
    uint32_t RESERVED3                      : 4;
    __IO uint32_t FACKEN                    : 1;
    uint32_t RESERVED8                      :24;
} stc_i2c_cr3_field_t;

typedef struct
{
    uint32_t RESERVED0                      :10;
    __IO uint32_t BUSWAIT                   : 1;
    uint32_t RESERVED11                     :21;
} stc_i2c_cr4_field_t;

typedef struct
{
    __IO uint32_t SLADDR0                   :10;
    uint32_t RESERVED10                     : 2;
    __IO uint32_t SLADDR0EN                 : 1;
    uint32_t RESERVED13                     : 2;
    __IO uint32_t ADDRMOD0                  : 1;
    uint32_t RESERVED16                     :16;
} stc_i2c_slr0_field_t;

typedef struct
{
    __IO uint32_t SLADDR1                   :10;
    uint32_t RESERVED10                     : 2;
    __IO uint32_t SLADDR1EN                 : 1;
    uint32_t RESERVED13                     : 2;
    __IO uint32_t ADDRMOD1                  : 1;
    uint32_t RESERVED16                     :16;
} stc_i2c_slr1_field_t;

typedef struct
{
    __IO uint32_t TOUTLOW                   :16;
    __IO uint32_t TOUTHIGH                  :16;
} stc_i2c_sltr_field_t;

typedef struct
{
    __IO uint32_t STARTF                    : 1;
    __IO uint32_t SLADDR0F                  : 1;
    __IO uint32_t SLADDR1F                  : 1;
    __IO uint32_t TENDF                     : 1;
    __IO uint32_t STOPF                     : 1;
    uint32_t RESERVED5                      : 1;
    __IO uint32_t RFULLF                    : 1;
    __IO uint32_t TEMPTYF                   : 1;
    uint32_t RESERVED8                      : 1;
    __IO uint32_t ARLOF                     : 1;
    __IO uint32_t ACKRF                     : 1;
    uint32_t RESERVED11                     : 1;
    __IO uint32_t NACKF                     : 1;
    uint32_t RESERVED13                     : 1;
    __IO uint32_t TMOUTF                    : 1;
    uint32_t RESERVED15                     : 1;
    __IO uint32_t MSL                       : 1;
    __IO uint32_t BUSY                      : 1;
    __IO uint32_t TRA                       : 1;
    uint32_t RESERVED19                     : 1;
    __IO uint32_t GENCALLF                  : 1;
    __IO uint32_t SMBDEFAULTF               : 1;
    __IO uint32_t SMBHOSTF                  : 1;
    __IO uint32_t SMBALRTF                  : 1;
    uint32_t RESERVED24                     : 8;
} stc_i2c_sr_field_t;

typedef struct
{
    __O  uint32_t STARTFCLR                 : 1;
    __O  uint32_t SLADDR0FCLR               : 1;
    __O  uint32_t SLADDR1FCLR               : 1;
    __O  uint32_t TENDFCLR                  : 1;
    __O  uint32_t STOPFCLR                  : 1;
    uint32_t RESERVED5                      : 1;
    __O  uint32_t RFULLFCLR                 : 1;
    __O  uint32_t TEMPTYFCLR                : 1;
    uint32_t RESERVED8                      : 1;
    __O  uint32_t ARLOFCLR                  : 1;
    uint32_t RESERVED10                     : 2;
    __O  uint32_t NACKFCLR                  : 1;
    uint32_t RESERVED13                     : 1;
    __O  uint32_t TMOUTFCLR                 : 1;
    uint32_t RESERVED15                     : 5;
    __O  uint32_t GENCALLFCLR               : 1;
    __O  uint32_t SMBDEFAULTFCLR            : 1;
    __O  uint32_t SMBHOSTFCLR               : 1;
    __O  uint32_t SMBALRTFCLR               : 1;
    uint32_t RESERVED24                     : 8;
} stc_i2c_clr_field_t;

typedef struct
{
    __O  uint8_t DT                         : 8;
} stc_i2c_dtr_field_t;

typedef struct
{
    __I  uint8_t DR                         : 8;
} stc_i2c_drr_field_t;

typedef struct
{
    __IO uint32_t SLOWW                     : 5;
    uint32_t RESERVED5                      : 3;
    __IO uint32_t SHIGHW                    : 5;
    uint32_t RESERVED13                     : 3;
    __IO uint32_t FREQ                      : 3;
    uint32_t RESERVED19                     :13;
} stc_i2c_ccr_field_t;

typedef struct
{
    __IO uint32_t DNF                       : 2;
    uint32_t RESERVED2                      : 2;
    __IO uint32_t DNFEN                     : 1;
    __IO uint32_t ANFEN                     : 1;
    uint32_t RESERVED6                      :26;
} stc_i2c_fltr_field_t;

typedef struct
{
    __IO uint32_t TXE                       : 1;
    __IO uint32_t TXIE                      : 1;
    __IO uint32_t RXE                       : 1;
    __IO uint32_t RXIE                      : 1;
    __IO uint32_t EIE                       : 1;
    __IO uint32_t WMS                       : 1;
    __IO uint32_t ODD                       : 1;
    __IO uint32_t MCKOE                     : 1;
    __IO uint32_t TXBIRQWL                  : 3;
    uint32_t RESERVED11                     : 1;
    __IO uint32_t RXBIRQWL                  : 3;
    uint32_t RESERVED15                     : 1;
    __IO uint32_t FIFOR                     : 1;
    __IO uint32_t CODECRC                   : 1;
    __IO uint32_t I2SPLLSEL                 : 1;
    __IO uint32_t SDOE                      : 1;
    __IO uint32_t LRCKOE                    : 1;
    __IO uint32_t CKOE                      : 1;
    __IO uint32_t DUPLEX                    : 1;
    __IO uint32_t CLKSEL                    : 1;
    uint32_t RESERVED24                     : 8;
} stc_i2s_ctrl_field_t;

typedef struct
{
    __I  uint32_t TXBA                      : 1;
    __I  uint32_t RXBA                      : 1;
    __I  uint32_t TXBE                      : 1;
    __I  uint32_t TXBF                      : 1;
    __I  uint32_t RXBE                      : 1;
    __I  uint32_t RXBF                      : 1;
    uint32_t RESERVED6                      :26;
} stc_i2s_sr_field_t;

typedef struct
{
    __IO uint32_t TXERR                     : 1;
    __IO uint32_t RXERR                     : 1;
    uint32_t RESERVED2                      :30;
} stc_i2s_er_field_t;

typedef struct
{
    __IO uint32_t I2SSTD                    : 2;
    __IO uint32_t DATLEN                    : 2;
    __IO uint32_t CHLEN                     : 1;
    __IO uint32_t PCMSYNC                   : 1;
    uint32_t RESERVED6                      :26;
} stc_i2s_cfgr_field_t;

typedef struct
{
    __IO uint32_t I2SDIV                    : 8;
    uint32_t RESERVED8                      :24;
} stc_i2s_pr_field_t;

typedef struct
{
    __I  uint32_t SWDTAUTS                  : 1;
    __I  uint32_t SWDTITS                   : 1;
    __I  uint32_t SWDTPERI                  : 2;
    __I  uint32_t SWDTCKS                   : 4;
    __I  uint32_t SWDTWDPT                  : 4;
    __I  uint32_t SWDTSLPOFF                : 1;
    uint32_t RESERVED13                     : 3;
    __I  uint32_t WDTAUTS                   : 1;
    __I  uint32_t WDTITS                    : 1;
    __I  uint32_t WDTPERI                   : 2;
    __I  uint32_t WDTCKS                    : 4;
    __I  uint32_t WDTWDPT                   : 4;
    __I  uint32_t WDTSLPOFF                 : 1;
    uint32_t RESERVED29                     : 3;
} stc_icg_icg0_field_t;

typedef struct
{
    __I  uint32_t HRCFREQSEL                : 1;
    uint32_t RESERVED1                      : 7;
    __I  uint32_t HRCSTOP                   : 1;
    uint32_t RESERVED9                      : 7;
    __I  uint32_t BOR_LEV                   : 2;
    __I  uint32_t BORDIS                    : 1;
    uint32_t RESERVED19                     : 7;
    __I  uint32_t SMPCLK                    : 2;
    __I  uint32_t NMITRG                    : 1;
    __I  uint32_t NMIENR                    : 1;
    __I  uint32_t NFEN                      : 1;
    __I  uint32_t NMIICGENA                 : 1;
} stc_icg_icg1_field_t;

typedef struct
{
    __IO uint32_t NMITRG                    : 1;
    uint32_t RESERVED1                      : 3;
    __IO uint32_t NSMPCLK                   : 2;
    uint32_t RESERVED6                      : 1;
    __IO uint32_t NFEN                      : 1;
    uint32_t RESERVED8                      :24;
} stc_intc_nmicr_field_t;

typedef struct
{
    __IO uint32_t NMIENR                    : 1;
    __IO uint32_t SWDTENR                   : 1;
    __IO uint32_t PVD1ENR                   : 1;
    __IO uint32_t PVD2ENR                   : 1;
    uint32_t RESERVED4                      : 1;
    __IO uint32_t XTALSTPENR                : 1;
    uint32_t RESERVED6                      : 2;
    __IO uint32_t REPENR                    : 1;
    __IO uint32_t RECCENR                   : 1;
    __IO uint32_t BUSMENR                   : 1;
    __IO uint32_t WDTENR                    : 1;
    uint32_t RESERVED12                     :20;
} stc_intc_nmienr_field_t;

typedef struct
{
    __IO uint32_t NMIFR                     : 1;
    __IO uint32_t SWDTFR                    : 1;
    __IO uint32_t PVD1FR                    : 1;
    __IO uint32_t PVD2FR                    : 1;
    uint32_t RESERVED4                      : 1;
    __IO uint32_t XTALSTPFR                 : 1;
    uint32_t RESERVED6                      : 2;
    __IO uint32_t REPFR                     : 1;
    __IO uint32_t RECCFR                    : 1;
    __IO uint32_t BUSMFR                    : 1;
    __IO uint32_t WDTFR                     : 1;
    uint32_t RESERVED12                     :20;
} stc_intc_nmifr_field_t;

typedef struct
{
    __IO uint32_t NMICFR                    : 1;
    __IO uint32_t SWDTCFR                   : 1;
    __IO uint32_t PVD1CFR                   : 1;
    __IO uint32_t PVD2CFR                   : 1;
    uint32_t RESERVED4                      : 1;
    __IO uint32_t XTALSTPCFR                : 1;
    uint32_t RESERVED6                      : 2;
    __IO uint32_t REPCFR                    : 1;
    __IO uint32_t RECCCFR                   : 1;
    __IO uint32_t BUSMCFR                   : 1;
    __IO uint32_t WDTCFR                    : 1;
    uint32_t RESERVED12                     :20;
} stc_intc_nmicfr_field_t;

typedef struct
{
    __IO uint32_t EIRQTRG                   : 2;
    uint32_t RESERVED2                      : 2;
    __IO uint32_t EISMPCLK                  : 2;
    uint32_t RESERVED6                      : 1;
    __IO uint32_t EFEN                      : 1;
    uint32_t RESERVED8                      :24;
} stc_intc_eirqcr_field_t;

typedef struct
{
    __IO uint32_t EIRQWUEN                  :16;
    __IO uint32_t SWDTWUEN                  : 1;
    __IO uint32_t PVD1WUEN                  : 1;
    __IO uint32_t PVD2WUEN                  : 1;
    __IO uint32_t CMPI0WUEN                 : 1;
    __IO uint32_t WKTMWUEN                  : 1;
    __IO uint32_t RTCALMWUEN                : 1;
    __IO uint32_t RTCPRDWUEN                : 1;
    __IO uint32_t TMR0WUEN                  : 1;
    uint32_t RESERVED24                     : 1;
    __IO uint32_t RXWUEN                    : 1;
    uint32_t RESERVED26                     : 6;
} stc_intc_wupen_field_t;

typedef struct
{
    __IO uint32_t EIFR0                     : 1;
    __IO uint32_t EIFR1                     : 1;
    __IO uint32_t EIFR2                     : 1;
    __IO uint32_t EIFR3                     : 1;
    __IO uint32_t EIFR4                     : 1;
    __IO uint32_t EIFR5                     : 1;
    __IO uint32_t EIFR6                     : 1;
    __IO uint32_t EIFR7                     : 1;
    __IO uint32_t EIFR8                     : 1;
    __IO uint32_t EIFR9                     : 1;
    __IO uint32_t EIFR10                    : 1;
    __IO uint32_t EIFR11                    : 1;
    __IO uint32_t EIFR12                    : 1;
    __IO uint32_t EIFR13                    : 1;
    __IO uint32_t EIFR14                    : 1;
    __IO uint32_t EIFR15                    : 1;
    uint32_t RESERVED16                     :16;
} stc_intc_eifr_field_t;

typedef struct
{
    __IO uint32_t EICFR0                    : 1;
    __IO uint32_t EICFR1                    : 1;
    __IO uint32_t EICFR2                    : 1;
    __IO uint32_t EICFR3                    : 1;
    __IO uint32_t EICFR4                    : 1;
    __IO uint32_t EICFR5                    : 1;
    __IO uint32_t EICFR6                    : 1;
    __IO uint32_t EICFR7                    : 1;
    __IO uint32_t EICFR8                    : 1;
    __IO uint32_t EICFR9                    : 1;
    __IO uint32_t EICFR10                   : 1;
    __IO uint32_t EICFR11                   : 1;
    __IO uint32_t EICFR12                   : 1;
    __IO uint32_t EICFR13                   : 1;
    __IO uint32_t EICFR14                   : 1;
    __IO uint32_t EICFR15                   : 1;
    uint32_t RESERVED16                     :16;
} stc_intc_eicfr_field_t;

typedef struct
{
    __IO uint32_t INTSEL                    : 9;
    uint32_t RESERVED9                      :23;
} stc_intc_sel_field_t;

typedef struct
{
    __IO uint32_t VSEL0                     : 1;
    __IO uint32_t VSEL1                     : 1;
    __IO uint32_t VSEL2                     : 1;
    __IO uint32_t VSEL3                     : 1;
    __IO uint32_t VSEL4                     : 1;
    __IO uint32_t VSEL5                     : 1;
    __IO uint32_t VSEL6                     : 1;
    __IO uint32_t VSEL7                     : 1;
    __IO uint32_t VSEL8                     : 1;
    __IO uint32_t VSEL9                     : 1;
    __IO uint32_t VSEL10                    : 1;
    __IO uint32_t VSEL11                    : 1;
    __IO uint32_t VSEL12                    : 1;
    __IO uint32_t VSEL13                    : 1;
    __IO uint32_t VSEL14                    : 1;
    __IO uint32_t VSEL15                    : 1;
    __IO uint32_t VSEL16                    : 1;
    __IO uint32_t VSEL17                    : 1;
    __IO uint32_t VSEL18                    : 1;
    __IO uint32_t VSEL19                    : 1;
    __IO uint32_t VSEL20                    : 1;
    __IO uint32_t VSEL21                    : 1;
    __IO uint32_t VSEL22                    : 1;
    __IO uint32_t VSEL23                    : 1;
    __IO uint32_t VSEL24                    : 1;
    __IO uint32_t VSEL25                    : 1;
    __IO uint32_t VSEL26                    : 1;
    __IO uint32_t VSEL27                    : 1;
    __IO uint32_t VSEL28                    : 1;
    __IO uint32_t VSEL29                    : 1;
    __IO uint32_t VSEL30                    : 1;
    __IO uint32_t VSEL31                    : 1;
} stc_intc_vssel_field_t;

typedef struct
{
    __IO uint32_t SWIE0                     : 1;
    __IO uint32_t SWIE1                     : 1;
    __IO uint32_t SWIE2                     : 1;
    __IO uint32_t SWIE3                     : 1;
    __IO uint32_t SWIE4                     : 1;
    __IO uint32_t SWIE5                     : 1;
    __IO uint32_t SWIE6                     : 1;
    __IO uint32_t SWIE7                     : 1;
    __IO uint32_t SWIE8                     : 1;
    __IO uint32_t SWIE9                     : 1;
    __IO uint32_t SWIE10                    : 1;
    __IO uint32_t SWIE11                    : 1;
    __IO uint32_t SWIE12                    : 1;
    __IO uint32_t SWIE13                    : 1;
    __IO uint32_t SWIE14                    : 1;
    __IO uint32_t SWIE15                    : 1;
    __IO uint32_t SWIE16                    : 1;
    __IO uint32_t SWIE17                    : 1;
    __IO uint32_t SWIE18                    : 1;
    __IO uint32_t SWIE19                    : 1;
    __IO uint32_t SWIE20                    : 1;
    __IO uint32_t SWIE21                    : 1;
    __IO uint32_t SWIE22                    : 1;
    __IO uint32_t SWIE23                    : 1;
    __IO uint32_t SWIE24                    : 1;
    __IO uint32_t SWIE25                    : 1;
    __IO uint32_t SWIE26                    : 1;
    __IO uint32_t SWIE27                    : 1;
    __IO uint32_t SWIE28                    : 1;
    __IO uint32_t SWIE29                    : 1;
    __IO uint32_t SWIE30                    : 1;
    __IO uint32_t SWIE31                    : 1;
} stc_intc_swier_field_t;

typedef struct
{
    __IO uint32_t EVTE0                     : 1;
    __IO uint32_t EVTE1                     : 1;
    __IO uint32_t EVTE2                     : 1;
    __IO uint32_t EVTE3                     : 1;
    __IO uint32_t EVTE4                     : 1;
    __IO uint32_t EVTE5                     : 1;
    __IO uint32_t EVTE6                     : 1;
    __IO uint32_t EVTE7                     : 1;
    __IO uint32_t EVTE8                     : 1;
    __IO uint32_t EVTE9                     : 1;
    __IO uint32_t EVTE10                    : 1;
    __IO uint32_t EVTE11                    : 1;
    __IO uint32_t EVTE12                    : 1;
    __IO uint32_t EVTE13                    : 1;
    __IO uint32_t EVTE14                    : 1;
    __IO uint32_t EVTE15                    : 1;
    __IO uint32_t EVTE16                    : 1;
    __IO uint32_t EVTE17                    : 1;
    __IO uint32_t EVTE18                    : 1;
    __IO uint32_t EVTE19                    : 1;
    __IO uint32_t EVTE20                    : 1;
    __IO uint32_t EVTE21                    : 1;
    __IO uint32_t EVTE22                    : 1;
    __IO uint32_t EVTE23                    : 1;
    __IO uint32_t EVTE24                    : 1;
    __IO uint32_t EVTE25                    : 1;
    __IO uint32_t EVTE26                    : 1;
    __IO uint32_t EVTE27                    : 1;
    __IO uint32_t EVTE28                    : 1;
    __IO uint32_t EVTE29                    : 1;
    __IO uint32_t EVTE30                    : 1;
    __IO uint32_t EVTE31                    : 1;
} stc_intc_evter_field_t;

typedef struct
{
    __IO uint32_t IER0                      : 1;
    __IO uint32_t IER1                      : 1;
    __IO uint32_t IER2                      : 1;
    __IO uint32_t IER3                      : 1;
    __IO uint32_t IER4                      : 1;
    __IO uint32_t IER5                      : 1;
    __IO uint32_t IER6                      : 1;
    __IO uint32_t IER7                      : 1;
    __IO uint32_t IER8                      : 1;
    __IO uint32_t IER9                      : 1;
    __IO uint32_t IER10                     : 1;
    __IO uint32_t IER11                     : 1;
    __IO uint32_t IER12                     : 1;
    __IO uint32_t IER13                     : 1;
    __IO uint32_t IER14                     : 1;
    __IO uint32_t IER15                     : 1;
    __IO uint32_t IER16                     : 1;
    __IO uint32_t IER17                     : 1;
    __IO uint32_t IER18                     : 1;
    __IO uint32_t IER19                     : 1;
    __IO uint32_t IER20                     : 1;
    __IO uint32_t IER21                     : 1;
    __IO uint32_t IER22                     : 1;
    __IO uint32_t IER23                     : 1;
    __IO uint32_t IER24                     : 1;
    __IO uint32_t IER25                     : 1;
    __IO uint32_t IER26                     : 1;
    __IO uint32_t IER27                     : 1;
    __IO uint32_t IER28                     : 1;
    __IO uint32_t IER29                     : 1;
    __IO uint32_t IER30                     : 1;
    __IO uint32_t IER31                     : 1;
} stc_intc_ier_field_t;

typedef struct
{
    __IO uint32_t KEYINSEL                  :16;
    __IO uint32_t KEYOUTSEL                 : 3;
    uint32_t RESERVED19                     : 1;
    __IO uint32_t CKSEL                     : 2;
    uint32_t RESERVED22                     : 2;
    __IO uint32_t T_LLEVEL                  : 5;
    __IO uint32_t T_HIZ                     : 3;
} stc_keyscan_scr_field_t;

typedef struct
{
    __IO uint32_t SEN                       : 1;
    uint32_t RESERVED1                      :31;
} stc_keyscan_ser_field_t;

typedef struct
{
    __IO uint32_t INDEX                     : 3;
    uint32_t RESERVED3                      :29;
} stc_keyscan_ssr_field_t;

typedef struct
{
    __IO uint32_t MPURGSIZE                 : 5;
    __IO uint32_t MPURGADDR                 :27;
} stc_mpu_rgd_field_t;

typedef struct
{
    __IO uint32_t S2RG0RP                   : 1;
    __IO uint32_t S2RG0WP                   : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG0E                    : 1;
    __IO uint32_t S1RG0RP                   : 1;
    __IO uint32_t S1RG0WP                   : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG0E                    : 1;
    __IO uint32_t FRG0RP                    : 1;
    __IO uint32_t FRG0WP                    : 1;
    uint32_t RESERVED18                     : 5;
    __IO uint32_t FRG0E                     : 1;
    uint32_t RESERVED24                     : 8;
} stc_mpu_rgcr0_field_t;

typedef struct
{
    __IO uint32_t S2RG1RP                   : 1;
    __IO uint32_t S2RG1WP                   : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG1E                    : 1;
    __IO uint32_t S1RG1RP                   : 1;
    __IO uint32_t S1RG1WP                   : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG1E                    : 1;
    __IO uint32_t FRG1RP                    : 1;
    __IO uint32_t FRG1WP                    : 1;
    uint32_t RESERVED18                     : 5;
    __IO uint32_t FRG1E                     : 1;
    uint32_t RESERVED24                     : 8;
} stc_mpu_rgcr1_field_t;

typedef struct
{
    __IO uint32_t S2RG2RP                   : 1;
    __IO uint32_t S2RG2WP                   : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG2E                    : 1;
    __IO uint32_t S1RG2RP                   : 1;
    __IO uint32_t S1RG2WP                   : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG2E                    : 1;
    __IO uint32_t FRG2RP                    : 1;
    __IO uint32_t FRG2WP                    : 1;
    uint32_t RESERVED18                     : 5;
    __IO uint32_t FRG2E                     : 1;
    uint32_t RESERVED24                     : 8;
} stc_mpu_rgcr2_field_t;

typedef struct
{
    __IO uint32_t S2RG3RP                   : 1;
    __IO uint32_t S2RG3WP                   : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG3E                    : 1;
    __IO uint32_t S1RG3RP                   : 1;
    __IO uint32_t S1RG3WP                   : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG3E                    : 1;
    __IO uint32_t FRG3RP                    : 1;
    __IO uint32_t FRG3WP                    : 1;
    uint32_t RESERVED18                     : 5;
    __IO uint32_t FRG3E                     : 1;
    uint32_t RESERVED24                     : 8;
} stc_mpu_rgcr3_field_t;

typedef struct
{
    __IO uint32_t S2RG4RP                   : 1;
    __IO uint32_t S2RG4WP                   : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG4E                    : 1;
    __IO uint32_t S1RG4RP                   : 1;
    __IO uint32_t S1RG4WP                   : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG4E                    : 1;
    __IO uint32_t FRG4RP                    : 1;
    __IO uint32_t FRG4WP                    : 1;
    uint32_t RESERVED18                     : 5;
    __IO uint32_t FRG4E                     : 1;
    uint32_t RESERVED24                     : 8;
} stc_mpu_rgcr4_field_t;

typedef struct
{
    __IO uint32_t S2RG5RP                   : 1;
    __IO uint32_t S2RG5WP                   : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG5E                    : 1;
    __IO uint32_t S1RG5RP                   : 1;
    __IO uint32_t S1RG5WP                   : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG5E                    : 1;
    __IO uint32_t FRG5RP                    : 1;
    __IO uint32_t FRG5WP                    : 1;
    uint32_t RESERVED18                     : 5;
    __IO uint32_t FRG5E                     : 1;
    uint32_t RESERVED24                     : 8;
} stc_mpu_rgcr5_field_t;

typedef struct
{
    __IO uint32_t S2RG6RP                   : 1;
    __IO uint32_t S2RG6WP                   : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG6E                    : 1;
    __IO uint32_t S1RG6RP                   : 1;
    __IO uint32_t S1RG6WP                   : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG6E                    : 1;
    __IO uint32_t FRG6RP                    : 1;
    __IO uint32_t FRG6WP                    : 1;
    uint32_t RESERVED18                     : 5;
    __IO uint32_t FRG6E                     : 1;
    uint32_t RESERVED24                     : 8;
} stc_mpu_rgcr6_field_t;

typedef struct
{
    __IO uint32_t S2RG7RP                   : 1;
    __IO uint32_t S2RG7WP                   : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG7E                    : 1;
    __IO uint32_t S1RG7RP                   : 1;
    __IO uint32_t S1RG7WP                   : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG7E                    : 1;
    __IO uint32_t FRG7RP                    : 1;
    __IO uint32_t FRG7WP                    : 1;
    uint32_t RESERVED18                     : 5;
    __IO uint32_t FRG7E                     : 1;
    uint32_t RESERVED24                     : 8;
} stc_mpu_rgcr7_field_t;

typedef struct
{
    __IO uint32_t S2RG8RP                   : 1;
    __IO uint32_t S2RG8WP                   : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG8E                    : 1;
    __IO uint32_t S1RG8RP                   : 1;
    __IO uint32_t S1RG8WP                   : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG8E                    : 1;
    uint32_t RESERVED16                     :16;
} stc_mpu_rgcr8_field_t;

typedef struct
{
    __IO uint32_t S2RG9RP                   : 1;
    __IO uint32_t S2RG9WP                   : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG9E                    : 1;
    __IO uint32_t S1RG9RP                   : 1;
    __IO uint32_t S1RG9WP                   : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG9E                    : 1;
    uint32_t RESERVED16                     :16;
} stc_mpu_rgcr9_field_t;

typedef struct
{
    __IO uint32_t S2RG10RP                  : 1;
    __IO uint32_t S2RG10WP                  : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG10E                   : 1;
    __IO uint32_t S1RG10RP                  : 1;
    __IO uint32_t S1RG10WP                  : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG10E                   : 1;
    uint32_t RESERVED16                     :16;
} stc_mpu_rgcr10_field_t;

typedef struct
{
    __IO uint32_t S2RG11RP                  : 1;
    __IO uint32_t S2RG11WP                  : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG11E                   : 1;
    __IO uint32_t S1RG11RP                  : 1;
    __IO uint32_t S1RG11WP                  : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG11E                   : 1;
    uint32_t RESERVED16                     :16;
} stc_mpu_rgcr11_field_t;

typedef struct
{
    __IO uint32_t S2RG12RP                  : 1;
    __IO uint32_t S2RG12WP                  : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG12E                   : 1;
    __IO uint32_t S1RG12RP                  : 1;
    __IO uint32_t S1RG12WP                  : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG12E                   : 1;
    uint32_t RESERVED16                     :16;
} stc_mpu_rgcr12_field_t;

typedef struct
{
    __IO uint32_t S2RG13RP                  : 1;
    __IO uint32_t S2RG13WP                  : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG13E                   : 1;
    __IO uint32_t S1RG13RP                  : 1;
    __IO uint32_t S1RG13WP                  : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG13E                   : 1;
    uint32_t RESERVED16                     :16;
} stc_mpu_rgcr13_field_t;

typedef struct
{
    __IO uint32_t S2RG14RP                  : 1;
    __IO uint32_t S2RG14WP                  : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG14E                   : 1;
    __IO uint32_t S1RG14RP                  : 1;
    __IO uint32_t S1RG14WP                  : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG14E                   : 1;
    uint32_t RESERVED16                     :16;
} stc_mpu_rgcr14_field_t;

typedef struct
{
    __IO uint32_t S2RG15RP                  : 1;
    __IO uint32_t S2RG15WP                  : 1;
    uint32_t RESERVED2                      : 5;
    __IO uint32_t S2RG15E                   : 1;
    __IO uint32_t S1RG15RP                  : 1;
    __IO uint32_t S1RG15WP                  : 1;
    uint32_t RESERVED10                     : 5;
    __IO uint32_t S1RG15E                   : 1;
    uint32_t RESERVED16                     :16;
} stc_mpu_rgcr15_field_t;

typedef struct
{
    __IO uint32_t SMPU2BRP                  : 1;
    __IO uint32_t SMPU2BWP                  : 1;
    __IO uint32_t SMPU2ACT                  : 2;
    uint32_t RESERVED4                      : 3;
    __IO uint32_t SMPU2E                    : 1;
    __IO uint32_t SMPU1BRP                  : 1;
    __IO uint32_t SMPU1BWP                  : 1;
    __IO uint32_t SMPU1ACT                  : 2;
    uint32_t RESERVED12                     : 3;
    __IO uint32_t SMPU1E                    : 1;
    __IO uint32_t FMPUBRP                   : 1;
    __IO uint32_t FMPUBWP                   : 1;
    __IO uint32_t FMPUACT                   : 2;
    uint32_t RESERVED20                     : 3;
    __IO uint32_t FMPUE                     : 1;
    uint32_t RESERVED24                     : 8;
} stc_mpu_cr_field_t;

typedef struct
{
    __I  uint32_t SMPU2EAF                  : 1;
    uint32_t RESERVED1                      : 7;
    __I  uint32_t SMPU1EAF                  : 1;
    uint32_t RESERVED9                      : 7;
    __I  uint32_t FMPUEAF                   : 1;
    uint32_t RESERVED17                     :15;
} stc_mpu_sr_field_t;

typedef struct
{
    __O  uint32_t SMPU2ECLR                 : 1;
    uint32_t RESERVED1                      : 7;
    __O  uint32_t SMPU1ECLR                 : 1;
    uint32_t RESERVED9                      : 7;
    __O  uint32_t FMPUECLR                  : 1;
    uint32_t RESERVED17                     :15;
} stc_mpu_eclr_field_t;

typedef struct
{
    __IO uint32_t MPUWE                     : 1;
    __O  uint32_t WKEY                      :15;
    uint32_t RESERVED16                     :16;
} stc_mpu_wp_field_t;

typedef struct
{
    __IO uint32_t SRAMH                     : 1;
    uint32_t RESERVED1                      : 3;
    __IO uint32_t SRAM12                    : 1;
    uint32_t RESERVED5                      : 3;
    __IO uint32_t SRAM3                     : 1;
    uint32_t RESERVED9                      : 1;
    __IO uint32_t SRAMRET                   : 1;
    uint32_t RESERVED11                     : 3;
    __IO uint32_t DMA1                      : 1;
    __IO uint32_t DMA2                      : 1;
    __IO uint32_t FCM                       : 1;
    __IO uint32_t AOS                       : 1;
    uint32_t RESERVED18                     : 2;
    __IO uint32_t AES                       : 1;
    __IO uint32_t HASH                      : 1;
    __IO uint32_t TRNG                      : 1;
    __IO uint32_t CRC                       : 1;
    __IO uint32_t DCU1                      : 1;
    __IO uint32_t DCU2                      : 1;
    __IO uint32_t DCU3                      : 1;
    __IO uint32_t DCU4                      : 1;
    uint32_t RESERVED28                     : 3;
    __IO uint32_t KEY                       : 1;
} stc_mstp_fcg0_field_t;

typedef struct
{
    __IO uint32_t CAN                       : 1;
    uint32_t RESERVED1                      : 2;
    __IO uint32_t QSPI                      : 1;
    __IO uint32_t IIC1                      : 1;
    __IO uint32_t IIC2                      : 1;
    __IO uint32_t IIC3                      : 1;
    uint32_t RESERVED7                      : 1;
    __IO uint32_t USBFS                     : 1;
    uint32_t RESERVED9                      : 1;
    __IO uint32_t SDIOC1                    : 1;
    __IO uint32_t SDIOC2                    : 1;
    __IO uint32_t I2S1                      : 1;
    __IO uint32_t I2S2                      : 1;
    __IO uint32_t I2S3                      : 1;
    __IO uint32_t I2S4                      : 1;
    __IO uint32_t SPI1                      : 1;
    __IO uint32_t SPI2                      : 1;
    __IO uint32_t SPI3                      : 1;
    __IO uint32_t SPI4                      : 1;
    uint32_t RESERVED20                     : 4;
    __IO uint32_t USART1                    : 1;
    __IO uint32_t USART2                    : 1;
    __IO uint32_t USART3                    : 1;
    __IO uint32_t USART4                    : 1;
    uint32_t RESERVED28                     : 4;
} stc_mstp_fcg1_field_t;

typedef struct
{
    __IO uint32_t TIMER0_1                  : 1;
    __IO uint32_t TIMER0_2                  : 1;
    __IO uint32_t TIMERA_1                  : 1;
    __IO uint32_t TIMERA_2                  : 1;
    __IO uint32_t TIMERA_3                  : 1;
    __IO uint32_t TIMERA_4                  : 1;
    __IO uint32_t TIMERA_5                  : 1;
    __IO uint32_t TIMERA_6                  : 1;
    __IO uint32_t TIMER4_1                  : 1;
    __IO uint32_t TIMER4_2                  : 1;
    __IO uint32_t TIMER4_3                  : 1;
    uint32_t RESERVED11                     : 4;
    __IO uint32_t EMB                       : 1;
    __IO uint32_t TIMER6_1                  : 1;
    __IO uint32_t TIMER6_2                  : 1;
    __IO uint32_t TIMER6_3                  : 1;
    uint32_t RESERVED19                     :13;
} stc_mstp_fcg2_field_t;

typedef struct
{
    __IO uint32_t ADC1                      : 1;
    __IO uint32_t ADC2                      : 1;
    uint32_t RESERVED2                      : 6;
    __IO uint32_t CMP                       : 1;
    uint32_t RESERVED9                      : 3;
    __IO uint32_t OTS                       : 1;
    uint32_t RESERVED13                     :19;
} stc_mstp_fcg3_field_t;

typedef struct
{
    __IO uint32_t PRT0                      : 1;
    uint32_t RESERVED1                      :15;
    __O  uint32_t FCG0PCWE                  :16;
} stc_mstp_fcg0pc_field_t;

typedef struct
{
    __IO uint16_t OTSST                     : 1;
    __IO uint16_t OTSCK                     : 1;
    __IO uint16_t OTSIE                     : 1;
    __IO uint16_t TSSTP                     : 1;
    uint16_t RESERVED4                      :12;
} stc_ots_ctl_field_t;

typedef struct
{
    __I  uint32_t TSOFS                     : 8;
    __I  uint32_t TSSLP                     :24;
} stc_ots_lpr_field_t;

typedef struct
{
    __IO uint32_t DFB                       : 1;
    __IO uint32_t SOFEN                     : 1;
    uint32_t RESERVED2                      :30;
} stc_peric_usbfs_syctlreg_field_t;

typedef struct
{
    uint32_t RESERVED0                      : 1;
    __IO uint32_t SELMMC1                   : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t SELMMC2                   : 1;
    uint32_t RESERVED4                      :28;
} stc_peric_sdioc_syctlreg_field_t;

typedef struct
{
    __I  uint16_t PIN00                     : 1;
    __I  uint16_t PIN01                     : 1;
    __I  uint16_t PIN02                     : 1;
    __I  uint16_t PIN03                     : 1;
    __I  uint16_t PIN04                     : 1;
    __I  uint16_t PIN05                     : 1;
    __I  uint16_t PIN06                     : 1;
    __I  uint16_t PIN07                     : 1;
    __I  uint16_t PIN08                     : 1;
    __I  uint16_t PIN09                     : 1;
    __I  uint16_t PIN10                     : 1;
    __I  uint16_t PIN11                     : 1;
    __I  uint16_t PIN12                     : 1;
    __I  uint16_t PIN13                     : 1;
    __I  uint16_t PIN14                     : 1;
    __I  uint16_t PIN15                     : 1;
} stc_port_pidr_field_t;

typedef struct
{
    __IO uint16_t POUT00                    : 1;
    __IO uint16_t POUT01                    : 1;
    __IO uint16_t POUT02                    : 1;
    __IO uint16_t POUT03                    : 1;
    __IO uint16_t POUT04                    : 1;
    __IO uint16_t POUT05                    : 1;
    __IO uint16_t POUT06                    : 1;
    __IO uint16_t POUT07                    : 1;
    __IO uint16_t POUT08                    : 1;
    __IO uint16_t POUT09                    : 1;
    __IO uint16_t POUT10                    : 1;
    __IO uint16_t POUT11                    : 1;
    __IO uint16_t POUT12                    : 1;
    __IO uint16_t POUT13                    : 1;
    __IO uint16_t POUT14                    : 1;
    __IO uint16_t POUT15                    : 1;
} stc_port_podr_field_t;

typedef struct
{
    __IO uint16_t POUTE00                   : 1;
    __IO uint16_t POUTE01                   : 1;
    __IO uint16_t POUTE02                   : 1;
    __IO uint16_t POUTE03                   : 1;
    __IO uint16_t POUTE04                   : 1;
    __IO uint16_t POUTE05                   : 1;
    __IO uint16_t POUTE06                   : 1;
    __IO uint16_t POUTE07                   : 1;
    __IO uint16_t POUTE08                   : 1;
    __IO uint16_t POUTE09                   : 1;
    __IO uint16_t POUTE10                   : 1;
    __IO uint16_t POUTE11                   : 1;
    __IO uint16_t POUTE12                   : 1;
    __IO uint16_t POUTE13                   : 1;
    __IO uint16_t POUTE14                   : 1;
    __IO uint16_t POUTE15                   : 1;
} stc_port_poer_field_t;

typedef struct
{
    __IO uint16_t POS00                     : 1;
    __IO uint16_t POS01                     : 1;
    __IO uint16_t POS02                     : 1;
    __IO uint16_t POS03                     : 1;
    __IO uint16_t POS04                     : 1;
    __IO uint16_t POS05                     : 1;
    __IO uint16_t POS06                     : 1;
    __IO uint16_t POS07                     : 1;
    __IO uint16_t POS08                     : 1;
    __IO uint16_t POS09                     : 1;
    __IO uint16_t POS10                     : 1;
    __IO uint16_t POS11                     : 1;
    __IO uint16_t POS12                     : 1;
    __IO uint16_t POS13                     : 1;
    __IO uint16_t POS14                     : 1;
    __IO uint16_t POS15                     : 1;
} stc_port_posr_field_t;

typedef struct
{
    __IO uint16_t POR00                     : 1;
    __IO uint16_t POR01                     : 1;
    __IO uint16_t POR02                     : 1;
    __IO uint16_t POR03                     : 1;
    __IO uint16_t POR04                     : 1;
    __IO uint16_t POR05                     : 1;
    __IO uint16_t POR06                     : 1;
    __IO uint16_t POR07                     : 1;
    __IO uint16_t POR08                     : 1;
    __IO uint16_t POR09                     : 1;
    __IO uint16_t POR10                     : 1;
    __IO uint16_t POR11                     : 1;
    __IO uint16_t POR12                     : 1;
    __IO uint16_t POR13                     : 1;
    __IO uint16_t POR14                     : 1;
    __IO uint16_t POR15                     : 1;
} stc_port_porr_field_t;

typedef struct
{
    __IO uint16_t POT00                     : 1;
    __IO uint16_t POT01                     : 1;
    __IO uint16_t POT02                     : 1;
    __IO uint16_t POT03                     : 1;
    __IO uint16_t POT04                     : 1;
    __IO uint16_t POT05                     : 1;
    __IO uint16_t POT06                     : 1;
    __IO uint16_t POT07                     : 1;
    __IO uint16_t POT08                     : 1;
    __IO uint16_t POT09                     : 1;
    __IO uint16_t POT10                     : 1;
    __IO uint16_t POT11                     : 1;
    __IO uint16_t POT12                     : 1;
    __IO uint16_t POT13                     : 1;
    __IO uint16_t POT14                     : 1;
    __IO uint16_t POT15                     : 1;
} stc_port_potr_field_t;

typedef struct
{
    __I  uint16_t PIN00                     : 1;
    __I  uint16_t PIN01                     : 1;
    __I  uint16_t PIN02                     : 1;
    uint16_t RESERVED3                      :13;
} stc_port_pidrh_field_t;

typedef struct
{
    __IO uint16_t POUT00                    : 1;
    __IO uint16_t POUT01                    : 1;
    __IO uint16_t POUT02                    : 1;
    uint16_t RESERVED3                      :13;
} stc_port_podrh_field_t;

typedef struct
{
    __IO uint16_t POUTE00                   : 1;
    __IO uint16_t POUTE01                   : 1;
    __IO uint16_t POUTE02                   : 1;
    uint16_t RESERVED3                      :13;
} stc_port_poerh_field_t;

typedef struct
{
    __IO uint16_t POS00                     : 1;
    __IO uint16_t POS01                     : 1;
    __IO uint16_t POS02                     : 1;
    uint16_t RESERVED3                      :13;
} stc_port_posrh_field_t;

typedef struct
{
    __IO uint16_t POR00                     : 1;
    __IO uint16_t POR01                     : 1;
    __IO uint16_t POR02                     : 1;
    uint16_t RESERVED3                      :13;
} stc_port_porrh_field_t;

typedef struct
{
    __IO uint16_t POT00                     : 1;
    __IO uint16_t POT01                     : 1;
    __IO uint16_t POT02                     : 1;
    uint16_t RESERVED3                      :13;
} stc_port_potrh_field_t;

typedef struct
{
    __IO uint16_t SPFE                      : 5;
    uint16_t RESERVED5                      :11;
} stc_port_pspcr_field_t;

typedef struct
{
    __IO uint16_t BFSEL                     : 4;
    uint16_t RESERVED4                      :10;
    __IO uint16_t RDWT                      : 2;
} stc_port_pccr_field_t;

typedef struct
{
    __IO uint16_t PINAE                     : 6;
    uint16_t RESERVED6                      :10;
} stc_port_pinaer_field_t;

typedef struct
{
    __IO uint16_t WE                        : 1;
    uint16_t RESERVED1                      : 7;
    __O  uint16_t WP                        : 8;
} stc_port_pwpr_field_t;

typedef struct
{
    __IO uint16_t POUT                      : 1;
    __IO uint16_t POUTE                     : 1;
    __IO uint16_t NOD                       : 1;
    uint16_t RESERVED3                      : 1;
    __IO uint16_t DRV                       : 2;
    __IO uint16_t PUU                       : 1;
    uint16_t RESERVED7                      : 1;
    __I  uint16_t PIN                       : 1;
    __IO uint16_t INVE                      : 1;
    uint16_t RESERVED10                     : 2;
    __IO uint16_t INTE                      : 1;
    uint16_t RESERVED13                     : 1;
    __IO uint16_t LTE                       : 1;
    __IO uint16_t DDIS                      : 1;
} stc_port_pcr_field_t;

typedef struct
{
    __IO uint16_t FSEL                      : 6;
    uint16_t RESERVED6                      : 2;
    __IO uint16_t BFE                       : 1;
    uint16_t RESERVED9                      : 7;
} stc_port_pfsr_field_t;

typedef struct
{
    __IO uint32_t MDSEL                     : 3;
    __IO uint32_t PFE                       : 1;
    __IO uint32_t PFSAE                     : 1;
    __IO uint32_t DCOME                     : 1;
    __IO uint32_t XIPE                      : 1;
    __IO uint32_t SPIMD3                    : 1;
    __IO uint32_t IPRSL                     : 2;
    __IO uint32_t APRSL                     : 2;
    __IO uint32_t DPRSL                     : 2;
    uint32_t RESERVED14                     : 2;
    __IO uint32_t DIV                       : 6;
    uint32_t RESERVED22                     :10;
} stc_qspi_cr_field_t;

typedef struct
{
    __IO uint32_t SSHW                      : 4;
    __IO uint32_t SSNW                      : 2;
    uint32_t RESERVED6                      :26;
} stc_qspi_cscr_field_t;

typedef struct
{
    __IO uint32_t AWSL                      : 2;
    __IO uint32_t FOUR_BIC                  : 1;
    uint32_t RESERVED3                      : 1;
    __IO uint32_t SSNHD                     : 1;
    __IO uint32_t SSNLD                     : 1;
    __IO uint32_t WPOL                      : 1;
    uint32_t RESERVED7                      : 1;
    __IO uint32_t DMCYCN                    : 4;
    uint32_t RESERVED12                     : 3;
    __IO uint32_t DUTY                      : 1;
    uint32_t RESERVED16                     :16;
} stc_qspi_fcr_field_t;

typedef struct
{
    __IO uint32_t BUSY                      : 1;
    uint32_t RESERVED1                      : 5;
    __IO uint32_t XIPF                      : 1;
    __IO uint32_t RAER                      : 1;
    __IO uint32_t PFNUM                     : 5;
    uint32_t RESERVED13                     : 1;
    __IO uint32_t PFFUL                     : 1;
    __IO uint32_t PFAN                      : 1;
    uint32_t RESERVED16                     :16;
} stc_qspi_sr_field_t;

typedef struct
{
    __IO uint32_t DCOM                      : 8;
    uint32_t RESERVED8                      :24;
} stc_qspi_dcom_field_t;

typedef struct
{
    __IO uint32_t RIC                       : 8;
    uint32_t RESERVED8                      :24;
} stc_qspi_ccmd_field_t;

typedef struct
{
    __IO uint32_t XIPMC                     : 8;
    uint32_t RESERVED8                      :24;
} stc_qspi_xcmd_field_t;

typedef struct
{
    uint32_t RESERVED0                      : 7;
    __O  uint32_t RAERCLR                   : 1;
    uint32_t RESERVED8                      :24;
} stc_qspi_sr2_field_t;

typedef struct
{
    uint32_t RESERVED0                      :26;
    __IO uint32_t EXADR                     : 6;
} stc_qspi_exar_field_t;

typedef struct
{
    __IO uint8_t RESET                      : 1;
    uint8_t RESERVED1                       : 7;
} stc_rtc_cr0_field_t;

typedef struct
{
    __IO uint8_t PRDS                       : 3;
    __IO uint8_t AMPM                       : 1;
    __IO uint8_t ALMFCLR                    : 1;
    __IO uint8_t ONEHZOE                    : 1;
    __IO uint8_t ONEHZSEL                   : 1;
    __IO uint8_t START                      : 1;
} stc_rtc_cr1_field_t;

typedef struct
{
    __IO uint8_t RWREQ                      : 1;
    __IO uint8_t RWEN                       : 1;
    uint8_t RESERVED2                       : 1;
    __IO uint8_t ALMF                       : 1;
    uint8_t RESERVED4                       : 1;
    __IO uint8_t PRDIE                      : 1;
    __IO uint8_t ALMIE                      : 1;
    __IO uint8_t ALME                       : 1;
} stc_rtc_cr2_field_t;

typedef struct
{
    uint8_t RESERVED0                       : 4;
    __IO uint8_t LRCEN                      : 1;
    uint8_t RESERVED5                       : 2;
    __IO uint8_t RCKSEL                     : 1;
} stc_rtc_cr3_field_t;

typedef struct
{
    __IO uint8_t SECU                       : 4;
    __IO uint8_t SECD                       : 3;
    uint8_t RESERVED7                       : 1;
} stc_rtc_sec_field_t;

typedef struct
{
    __IO uint8_t MINU                       : 4;
    __IO uint8_t MIND                       : 3;
    uint8_t RESERVED7                       : 1;
} stc_rtc_min_field_t;

typedef struct
{
    __IO uint8_t HOURU                      : 4;
    __IO uint8_t HOURD                      : 2;
    uint8_t RESERVED6                       : 2;
} stc_rtc_hour_field_t;

typedef struct
{
    __IO uint8_t WEEK                       : 3;
    uint8_t RESERVED3                       : 5;
} stc_rtc_week_field_t;

typedef struct
{
    __IO uint8_t DAYU                       : 4;
    __IO uint8_t DAYD                       : 2;
    uint8_t RESERVED6                       : 2;
} stc_rtc_day_field_t;

typedef struct
{
    __IO uint8_t MON                        : 5;
    uint8_t RESERVED5                       : 3;
} stc_rtc_mon_field_t;

typedef struct
{
    __IO uint8_t YEARU                      : 4;
    __IO uint8_t YEARD                      : 4;
} stc_rtc_year_field_t;

typedef struct
{
    __IO uint8_t ALMMINU                    : 4;
    __IO uint8_t ALMMIND                    : 3;
    uint8_t RESERVED7                       : 1;
} stc_rtc_almmin_field_t;

typedef struct
{
    __IO uint8_t ALMHOURU                   : 4;
    __IO uint8_t ALMHOURD                   : 2;
    uint8_t RESERVED6                       : 2;
} stc_rtc_almhour_field_t;

typedef struct
{
    __IO uint8_t ALMWEEK                    : 7;
    uint8_t RESERVED7                       : 1;
} stc_rtc_almweek_field_t;

typedef struct
{
    __IO uint8_t COMP8                      : 1;
    uint8_t RESERVED1                       : 6;
    __IO uint8_t COMPEN                     : 1;
} stc_rtc_errcrh_field_t;

typedef struct
{
    __IO uint8_t COMP                       : 8;
} stc_rtc_errcrl_field_t;

typedef struct
{
    __IO uint16_t TBS                       :12;
    uint16_t RESERVED12                     : 4;
} stc_sdioc_blksize_field_t;

typedef struct
{
    uint16_t RESERVED0                      : 1;
    __IO uint16_t BCE                       : 1;
    __IO uint16_t ATCEN                     : 2;
    __IO uint16_t DDIR                      : 1;
    __IO uint16_t MULB                      : 1;
    uint16_t RESERVED6                      :10;
} stc_sdioc_transmode_field_t;

typedef struct
{
    __IO uint16_t RESTYP                    : 2;
    uint16_t RESERVED2                      : 1;
    __IO uint16_t CCE                       : 1;
    __IO uint16_t ICE                       : 1;
    __IO uint16_t DAT                       : 1;
    __IO uint16_t TYP                       : 2;
    __IO uint16_t IDX                       : 6;
    uint16_t RESERVED14                     : 2;
} stc_sdioc_cmd_field_t;

typedef struct
{
    __I  uint32_t CIC                       : 1;
    __I  uint32_t CID                       : 1;
    __I  uint32_t DA                        : 1;
    uint32_t RESERVED3                      : 5;
    __I  uint32_t WTA                       : 1;
    __I  uint32_t RTA                       : 1;
    __I  uint32_t BWE                       : 1;
    __I  uint32_t BRE                       : 1;
    uint32_t RESERVED12                     : 4;
    __I  uint32_t CIN                       : 1;
    __I  uint32_t CSS                       : 1;
    __I  uint32_t CDL                       : 1;
    __I  uint32_t WPL                       : 1;
    __I  uint32_t DATL                      : 4;
    __I  uint32_t CMDL                      : 1;
    uint32_t RESERVED25                     : 7;
} stc_sdioc_pstat_field_t;

typedef struct
{
    uint8_t RESERVED0                       : 1;
    __IO uint8_t DW                         : 1;
    __IO uint8_t HSEN                       : 1;
    uint8_t RESERVED3                       : 2;
    __IO uint8_t EXDW                       : 1;
    __IO uint8_t CDTL                       : 1;
    __IO uint8_t CDSS                       : 1;
} stc_sdioc_hostcon_field_t;

typedef struct
{
    __IO uint8_t PWON                       : 1;
    uint8_t RESERVED1                       : 7;
} stc_sdioc_pwrcon_field_t;

typedef struct
{
    __IO uint8_t SABGR                      : 1;
    __IO uint8_t CR                         : 1;
    __IO uint8_t RWC                        : 1;
    __IO uint8_t IABG                       : 1;
    uint8_t RESERVED4                       : 4;
} stc_sdioc_blkgpcon_field_t;

typedef struct
{
    __IO uint16_t ICE                       : 1;
    uint16_t RESERVED1                      : 1;
    __IO uint16_t CE                        : 1;
    uint16_t RESERVED3                      : 5;
    __IO uint16_t FS                        : 8;
} stc_sdioc_clkcon_field_t;

typedef struct
{
    __IO uint8_t DTO                        : 4;
    uint8_t RESERVED4                       : 4;
} stc_sdioc_toutcon_field_t;

typedef struct
{
    __IO uint8_t RSTA                       : 1;
    __IO uint8_t RSTC                       : 1;
    __IO uint8_t RSTD                       : 1;
    uint8_t RESERVED3                       : 5;
} stc_sdioc_sftrst_field_t;

typedef struct
{
    __IO uint16_t CC                        : 1;
    __IO uint16_t TC                        : 1;
    __IO uint16_t BGE                       : 1;
    uint16_t RESERVED3                      : 1;
    __IO uint16_t BWR                       : 1;
    __IO uint16_t BRR                       : 1;
    __IO uint16_t CIST                      : 1;
    __IO uint16_t CRM                       : 1;
    __I  uint16_t CINT                      : 1;
    uint16_t RESERVED9                      : 6;
    __I  uint16_t EI                        : 1;
} stc_sdioc_norintst_field_t;

typedef struct
{
    __IO uint16_t CTOE                      : 1;
    __IO uint16_t CCE                       : 1;
    __IO uint16_t CEBE                      : 1;
    __IO uint16_t CIE                       : 1;
    __IO uint16_t DTOE                      : 1;
    __IO uint16_t DCE                       : 1;
    __IO uint16_t DEBE                      : 1;
    uint16_t RESERVED7                      : 1;
    __IO uint16_t ACE                       : 1;
    uint16_t RESERVED9                      : 7;
} stc_sdioc_errintst_field_t;

typedef struct
{
    __IO uint16_t CCEN                      : 1;
    __IO uint16_t TCEN                      : 1;
    __IO uint16_t BGEEN                     : 1;
    uint16_t RESERVED3                      : 1;
    __IO uint16_t BWREN                     : 1;
    __IO uint16_t BRREN                     : 1;
    __IO uint16_t CISTEN                    : 1;
    __IO uint16_t CRMEN                     : 1;
    __IO uint16_t CINTEN                    : 1;
    uint16_t RESERVED9                      : 7;
} stc_sdioc_norintsten_field_t;

typedef struct
{
    __IO uint16_t CTOEEN                    : 1;
    __IO uint16_t CCEEN                     : 1;
    __IO uint16_t CEBEEN                    : 1;
    __IO uint16_t CIEEN                     : 1;
    __IO uint16_t DTOEEN                    : 1;
    __IO uint16_t DCEEN                     : 1;
    __IO uint16_t DEBEEN                    : 1;
    uint16_t RESERVED7                      : 1;
    __IO uint16_t ACEEN                     : 1;
    uint16_t RESERVED9                      : 7;
} stc_sdioc_errintsten_field_t;

typedef struct
{
    __IO uint16_t CCSEN                     : 1;
    __IO uint16_t TCSEN                     : 1;
    __IO uint16_t BGESEN                    : 1;
    uint16_t RESERVED3                      : 1;
    __IO uint16_t BWRSEN                    : 1;
    __IO uint16_t BRRSEN                    : 1;
    __IO uint16_t CISTSEN                   : 1;
    __IO uint16_t CRMSEN                    : 1;
    __IO uint16_t CINTSEN                   : 1;
    uint16_t RESERVED9                      : 7;
} stc_sdioc_norintsgen_field_t;

typedef struct
{
    __IO uint16_t CTOESEN                   : 1;
    __IO uint16_t CCESEN                    : 1;
    __IO uint16_t CEBESEN                   : 1;
    __IO uint16_t CIESEN                    : 1;
    __IO uint16_t DTOESEN                   : 1;
    __IO uint16_t DCESEN                    : 1;
    __IO uint16_t DEBESEN                   : 1;
    uint16_t RESERVED7                      : 1;
    __IO uint16_t ACESEN                    : 1;
    uint16_t RESERVED9                      : 7;
} stc_sdioc_errintsgen_field_t;

typedef struct
{
    __I  uint16_t NE                        : 1;
    __I  uint16_t TOE                       : 1;
    __I  uint16_t CE                        : 1;
    __I  uint16_t EBE                       : 1;
    __I  uint16_t IE                        : 1;
    uint16_t RESERVED5                      : 2;
    __I  uint16_t CMDE                      : 1;
    uint16_t RESERVED8                      : 8;
} stc_sdioc_atcerrst_field_t;

typedef struct
{
    __O  uint16_t FNE                       : 1;
    __O  uint16_t FTOE                      : 1;
    __O  uint16_t FCE                       : 1;
    __O  uint16_t FEBE                      : 1;
    __O  uint16_t FIE                       : 1;
    uint16_t RESERVED5                      : 2;
    __O  uint16_t FCMDE                     : 1;
    uint16_t RESERVED8                      : 8;
} stc_sdioc_fea_field_t;

typedef struct
{
    __O  uint16_t FCTOE                     : 1;
    __O  uint16_t FCCE                      : 1;
    __O  uint16_t FCEBE                     : 1;
    __O  uint16_t FCIE                      : 1;
    __O  uint16_t FDTOE                     : 1;
    __O  uint16_t FDCE                      : 1;
    __O  uint16_t FDEBE                     : 1;
    uint16_t RESERVED7                      : 1;
    __O  uint16_t FACE                      : 1;
    uint16_t RESERVED9                      : 7;
} stc_sdioc_fee_field_t;

typedef struct
{
    __IO uint32_t SPIMDS                    : 1;
    __IO uint32_t TXMDS                     : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t MSTR                      : 1;
    __IO uint32_t SPLPBK                    : 1;
    __IO uint32_t SPLPBK2                   : 1;
    __IO uint32_t SPE                       : 1;
    __IO uint32_t CSUSPE                    : 1;
    __IO uint32_t EIE                       : 1;
    __IO uint32_t TXIE                      : 1;
    __IO uint32_t RXIE                      : 1;
    __IO uint32_t IDIE                      : 1;
    __IO uint32_t MODFE                     : 1;
    __IO uint32_t PATE                      : 1;
    __IO uint32_t PAOE                      : 1;
    __IO uint32_t PAE                       : 1;
    uint32_t RESERVED16                     :16;
} stc_spi_cr1_field_t;

typedef struct
{
    __IO uint32_t FTHLV                     : 2;
    uint32_t RESERVED2                      : 4;
    __IO uint32_t SPRDTD                    : 1;
    uint32_t RESERVED7                      : 1;
    __IO uint32_t SS0PV                     : 1;
    __IO uint32_t SS1PV                     : 1;
    __IO uint32_t SS2PV                     : 1;
    __IO uint32_t SS3PV                     : 1;
    uint32_t RESERVED12                     : 8;
    __IO uint32_t MSSI                      : 3;
    uint32_t RESERVED23                     : 1;
    __IO uint32_t MSSDL                     : 3;
    uint32_t RESERVED27                     : 1;
    __IO uint32_t MIDI                      : 3;
    uint32_t RESERVED31                     : 1;
} stc_spi_cfg1_field_t;

typedef struct
{
    __IO uint32_t OVRERF                    : 1;
    __I  uint32_t IDLNF                     : 1;
    __IO uint32_t MODFERF                   : 1;
    __IO uint32_t PERF                      : 1;
    __IO uint32_t UDRERF                    : 1;
    __IO uint32_t TDEF                      : 1;
    uint32_t RESERVED6                      : 1;
    __IO uint32_t RDFF                      : 1;
    uint32_t RESERVED8                      :24;
} stc_spi_sr_field_t;

typedef struct
{
    __IO uint32_t CPHA                      : 1;
    __IO uint32_t CPOL                      : 1;
    __IO uint32_t MBR                       : 3;
    __IO uint32_t SSA                       : 3;
    __IO uint32_t DSIZE                     : 4;
    __IO uint32_t LSBF                      : 1;
    __IO uint32_t MIDIE                     : 1;
    __IO uint32_t MSSDLE                    : 1;
    __IO uint32_t MSSIE                     : 1;
    uint32_t RESERVED16                     :16;
} stc_spi_cfg2_field_t;

typedef struct
{
    __IO uint32_t SRAM12_RWT                : 3;
    uint32_t RESERVED3                      : 1;
    __IO uint32_t SRAM12_WWT                : 3;
    uint32_t RESERVED7                      : 1;
    __IO uint32_t SRAM3_RWT                 : 3;
    uint32_t RESERVED11                     : 1;
    __IO uint32_t SRAM3_WWT                 : 3;
    uint32_t RESERVED15                     : 1;
    __IO uint32_t SRAMH_RWT                 : 3;
    uint32_t RESERVED19                     : 1;
    __IO uint32_t SRAMH_WWT                 : 3;
    uint32_t RESERVED23                     : 1;
    __IO uint32_t SRAMR_RWT                 : 3;
    uint32_t RESERVED27                     : 1;
    __IO uint32_t SRAMR_WWT                 : 3;
    uint32_t RESERVED31                     : 1;
} stc_sramc_wtcr_field_t;

typedef struct
{
    __IO uint32_t WTPRC                     : 1;
    __IO uint32_t WTPRKW                    : 7;
    uint32_t RESERVED8                      :24;
} stc_sramc_wtpr_field_t;

typedef struct
{
    __IO uint32_t PYOAD                     : 1;
    uint32_t RESERVED1                      :15;
    __IO uint32_t ECCOAD                    : 1;
    uint32_t RESERVED17                     : 7;
    __IO uint32_t ECCMOD                    : 2;
    uint32_t RESERVED26                     : 6;
} stc_sramc_ckcr_field_t;

typedef struct
{
    __IO uint32_t CKPRC                     : 1;
    __IO uint32_t CKPRKW                    : 7;
    uint32_t RESERVED8                      :24;
} stc_sramc_ckpr_field_t;

typedef struct
{
    __IO uint32_t SRAM3_1ERR                : 1;
    __IO uint32_t SRAM3_2ERR                : 1;
    __IO uint32_t SRAM12_PYERR              : 1;
    __IO uint32_t SRAMH_PYERR               : 1;
    __IO uint32_t SRAMR_PYERR               : 1;
    uint32_t RESERVED5                      :27;
} stc_sramc_cksr_field_t;

typedef struct
{
    __I  uint32_t CNT                       :16;
    __IO uint32_t UDF                       : 1;
    __IO uint32_t REF                       : 1;
    uint32_t RESERVED18                     :14;
} stc_swdt_sr_field_t;

typedef struct
{
    __IO uint32_t RF                        :16;
    uint32_t RESERVED16                     :16;
} stc_swdt_rr_field_t;

typedef struct
{
    __IO uint16_t FLNWT                     : 1;
    __IO uint16_t CKSMRC                    : 1;
    uint16_t RESERVED2                      :13;
    __IO uint16_t STOP                      : 1;
} stc_sysreg_pwr_stpmcr_field_t;

typedef struct
{
    __IO uint16_t PERICKSEL                 : 4;
    uint16_t RESERVED4                      :12;
} stc_sysreg_cmu_pericksel_field_t;

typedef struct
{
    __IO uint16_t I2S1CKSEL                 : 4;
    __IO uint16_t I2S2CKSEL                 : 4;
    __IO uint16_t I2S3CKSEL                 : 4;
    __IO uint16_t I2S4CKSEL                 : 4;
} stc_sysreg_cmu_i2scksel_field_t;

typedef struct
{
    __IO uint32_t RAMPDC0                   : 1;
    __IO uint32_t RAMPDC1                   : 1;
    __IO uint32_t RAMPDC2                   : 1;
    __IO uint32_t RAMPDC3                   : 1;
    __IO uint32_t RAMPDC4                   : 1;
    __IO uint32_t RAMPDC5                   : 1;
    __IO uint32_t RAMPDC6                   : 1;
    __IO uint32_t RAMPDC7                   : 1;
    __IO uint32_t RAMPDC8                   : 1;
    uint32_t RESERVED9                      :23;
} stc_sysreg_pwr_rampc0_field_t;

typedef struct
{
    __IO uint32_t AESRDP                    : 1;
    __IO uint32_t AESWRP                    : 1;
    __IO uint32_t HASHRDP                   : 1;
    __IO uint32_t HASHWRP                   : 1;
    __IO uint32_t TRNGRDP                   : 1;
    __IO uint32_t TRNGWRP                   : 1;
    __IO uint32_t CRCRDP                    : 1;
    __IO uint32_t CRCWRP                    : 1;
    __IO uint32_t FMCRDP                    : 1;
    __IO uint32_t FMCWRP                    : 1;
    uint32_t RESERVED10                     : 2;
    __IO uint32_t WDTRDP                    : 1;
    __IO uint32_t WDTWRP                    : 1;
    __IO uint32_t SWDTRDP                   : 1;
    __IO uint32_t SWDTWRP                   : 1;
    __IO uint32_t BKSRAMRDP                 : 1;
    __IO uint32_t BKSRAMWRP                 : 1;
    __IO uint32_t RTCRDP                    : 1;
    __IO uint32_t RTCWRP                    : 1;
    __IO uint32_t DMPURDP                   : 1;
    __IO uint32_t DMPUWRP                   : 1;
    __IO uint32_t SRAMCRDP                  : 1;
    __IO uint32_t SRAMCWRP                  : 1;
    __IO uint32_t INTCRDP                   : 1;
    __IO uint32_t INTCWRP                   : 1;
    __IO uint32_t SYSCRDP                   : 1;
    __IO uint32_t SYSCWRP                   : 1;
    __IO uint32_t MSTPRDP                   : 1;
    __IO uint32_t MSTPWRP                   : 1;
    uint32_t RESERVED30                     : 1;
    __IO uint32_t BUSERRE                   : 1;
} stc_sysreg_mpu_ippr_field_t;

typedef struct
{
    __IO uint32_t PCLK0S                    : 3;
    uint32_t RESERVED3                      : 1;
    __IO uint32_t PCLK1S                    : 3;
    uint32_t RESERVED7                      : 1;
    __IO uint32_t PCLK2S                    : 3;
    uint32_t RESERVED11                     : 1;
    __IO uint32_t PCLK3S                    : 3;
    uint32_t RESERVED15                     : 1;
    __IO uint32_t PCLK4S                    : 3;
    uint32_t RESERVED19                     : 1;
    __IO uint32_t EXCKS                     : 3;
    uint32_t RESERVED23                     : 1;
    __IO uint32_t HCLKS                     : 3;
    uint32_t RESERVED27                     : 5;
} stc_sysreg_cmu_scfgr_field_t;

typedef struct
{
    uint8_t RESERVED0                       : 4;
    __IO uint8_t USBCKS                     : 4;
} stc_sysreg_cmu_ufsckcfgr_field_t;

typedef struct
{
    __IO uint8_t CKSW                       : 3;
    uint8_t RESERVED3                       : 5;
} stc_sysreg_cmu_ckswr_field_t;

typedef struct
{
    __IO uint8_t MPLLOFF                    : 1;
    uint8_t RESERVED1                       : 7;
} stc_sysreg_cmu_pllcr_field_t;

typedef struct
{
    __IO uint8_t UPLLOFF                    : 1;
    uint8_t RESERVED1                       : 7;
} stc_sysreg_cmu_upllcr_field_t;

typedef struct
{
    __IO uint8_t XTALSTP                    : 1;
    uint8_t RESERVED1                       : 7;
} stc_sysreg_cmu_xtalcr_field_t;

typedef struct
{
    __IO uint8_t HRCSTP                     : 1;
    uint8_t RESERVED1                       : 7;
} stc_sysreg_cmu_hrccr_field_t;

typedef struct
{
    __IO uint8_t MRCSTP                     : 1;
    uint8_t RESERVED1                       : 7;
} stc_sysreg_cmu_mrccr_field_t;

typedef struct
{
    __IO uint8_t HRCSTBF                    : 1;
    uint8_t RESERVED1                       : 2;
    __IO uint8_t XTALSTBF                   : 1;
    uint8_t RESERVED4                       : 1;
    __IO uint8_t MPLLSTBF                   : 1;
    __IO uint8_t UPLLSTBF                   : 1;
    uint8_t RESERVED7                       : 1;
} stc_sysreg_cmu_oscstbsr_field_t;

typedef struct
{
    __IO uint8_t MCO1SEL                    : 4;
    __IO uint8_t MCO1DIV                    : 3;
    __IO uint8_t MCO1EN                     : 1;
} stc_sysreg_cmu_mco1cfgr_field_t;

typedef struct
{
    __IO uint8_t MCO2SEL                    : 4;
    __IO uint8_t MCO2DIV                    : 3;
    __IO uint8_t MCO2EN                     : 1;
} stc_sysreg_cmu_mco2cfgr_field_t;

typedef struct
{
    __IO uint8_t TPIUCKS                    : 2;
    uint8_t RESERVED2                       : 5;
    __IO uint8_t TPIUCKOE                   : 1;
} stc_sysreg_cmu_tpiuckcfgr_field_t;

typedef struct
{
    __IO uint8_t XTALSTDIE                  : 1;
    __IO uint8_t XTALSTDRE                  : 1;
    __IO uint8_t XTALSTDRIS                 : 1;
    uint8_t RESERVED3                       : 4;
    __IO uint8_t XTALSTDE                   : 1;
} stc_sysreg_cmu_xtalstdcr_field_t;

typedef struct
{
    __IO uint8_t XTALSTDF                   : 1;
    uint8_t RESERVED1                       : 7;
} stc_sysreg_cmu_xtalstdsr_field_t;

typedef struct
{
    __IO uint8_t XTALSTB                    : 4;
    uint8_t RESERVED4                       : 4;
} stc_sysreg_cmu_xtalstbcr_field_t;

typedef struct
{
    __IO uint16_t PORF                      : 1;
    __IO uint16_t PINRF                     : 1;
    __IO uint16_t BORF                      : 1;
    __IO uint16_t PVD1RF                    : 1;
    __IO uint16_t PVD2RF                    : 1;
    __IO uint16_t WDRF                      : 1;
    __IO uint16_t SWDRF                     : 1;
    __IO uint16_t PDRF                      : 1;
    __IO uint16_t SWRF                      : 1;
    __IO uint16_t MPUERF                    : 1;
    __IO uint16_t RAPERF                    : 1;
    __IO uint16_t RAECRF                    : 1;
    __IO uint16_t CKFERF                    : 1;
    __IO uint16_t XTALERF                   : 1;
    __IO uint16_t MULTIRF                   : 1;
    __IO uint16_t CLRF                      : 1;
} stc_sysreg_rmu_rstf0_field_t;

typedef struct
{
    __IO uint8_t PVD1NMIS                   : 1;
    uint8_t RESERVED1                       : 3;
    __IO uint8_t PVD2NMIS                   : 1;
    uint8_t RESERVED5                       : 3;
} stc_sysreg_pwr_pvdicr_field_t;

typedef struct
{
    __IO uint8_t PVD1MON                    : 1;
    __IO uint8_t PVD1DETFLG                 : 1;
    uint8_t RESERVED2                       : 2;
    __IO uint8_t PVD2MON                    : 1;
    __IO uint8_t PVD2DETFLG                 : 1;
    uint8_t RESERVED6                       : 2;
} stc_sysreg_pwr_pvddsr_field_t;

typedef struct
{
    __IO uint32_t MPLLM                     : 5;
    uint32_t RESERVED5                      : 2;
    __IO uint32_t PLLSRC                    : 1;
    __IO uint32_t MPLLN                     : 9;
    uint32_t RESERVED17                     : 3;
    __IO uint32_t MPLLR                     : 4;
    __IO uint32_t MPLLQ                     : 4;
    __IO uint32_t MPLLP                     : 4;
} stc_sysreg_cmu_pllcfgr_field_t;

typedef struct
{
    __IO uint32_t UPLLM                     : 5;
    uint32_t RESERVED5                      : 3;
    __IO uint32_t UPLLN                     : 9;
    uint32_t RESERVED17                     : 3;
    __IO uint32_t UPLLR                     : 4;
    __IO uint32_t UPLLQ                     : 4;
    __IO uint32_t UPLLP                     : 4;
} stc_sysreg_cmu_upllcfgr_field_t;

typedef struct
{
    __IO uint16_t FPRCB0                    : 1;
    __IO uint16_t FPRCB1                    : 1;
    __IO uint16_t FPRCB2                    : 1;
    __IO uint16_t FPRCB3                    : 1;
    uint16_t RESERVED4                      : 4;
    __IO uint16_t FPRCWE                    : 8;
} stc_sysreg_pwr_fprc_field_t;

typedef struct
{
    __IO uint8_t PDMDS                      : 2;
    __IO uint8_t VVDRSD                     : 1;
    __IO uint8_t RETRAMSD                   : 1;
    __IO uint8_t IORTN                      : 2;
    uint8_t RESERVED6                       : 1;
    __IO uint8_t PWDN                       : 1;
} stc_sysreg_pwr_pwrc0_field_t;

typedef struct
{
    __IO uint8_t VPLLSD                     : 1;
    __IO uint8_t VHRCSD                     : 1;
    uint8_t RESERVED2                       : 4;
    __IO uint8_t STPDAS                     : 2;
} stc_sysreg_pwr_pwrc1_field_t;

typedef struct
{
    __IO uint8_t DDAS                       : 4;
    __IO uint8_t DVS                        : 2;
    uint8_t RESERVED6                       : 2;
} stc_sysreg_pwr_pwrc2_field_t;

typedef struct
{
    uint8_t RESERVED0                       : 2;
    __IO uint8_t PDTS                       : 1;
    uint8_t RESERVED3                       : 5;
} stc_sysreg_pwr_pwrc3_field_t;

typedef struct
{
    __IO uint8_t WKE00                      : 1;
    __IO uint8_t WKE01                      : 1;
    __IO uint8_t WKE02                      : 1;
    __IO uint8_t WKE03                      : 1;
    __IO uint8_t WKE10                      : 1;
    __IO uint8_t WKE11                      : 1;
    __IO uint8_t WKE12                      : 1;
    __IO uint8_t WKE13                      : 1;
} stc_sysreg_pwr_pdwke0_field_t;

typedef struct
{
    __IO uint8_t WKE20                      : 1;
    __IO uint8_t WKE21                      : 1;
    __IO uint8_t WKE22                      : 1;
    __IO uint8_t WKE23                      : 1;
    __IO uint8_t WKE30                      : 1;
    __IO uint8_t WKE31                      : 1;
    __IO uint8_t WKE32                      : 1;
    __IO uint8_t WKE33                      : 1;
} stc_sysreg_pwr_pdwke1_field_t;

typedef struct
{
    __IO uint8_t VD1WKE                     : 1;
    __IO uint8_t VD2WKE                     : 1;
    __IO uint8_t NMIWKE                     : 1;
    uint8_t RESERVED3                       : 1;
    __IO uint8_t RTCPRDWKE                  : 1;
    __IO uint8_t RTCALMWKE                  : 1;
    uint8_t RESERVED6                       : 1;
    __IO uint8_t WKTMWKE                    : 1;
} stc_sysreg_pwr_pdwke2_field_t;

typedef struct
{
    __IO uint8_t WK0EGS                     : 1;
    __IO uint8_t WK1EGS                     : 1;
    __IO uint8_t WK2EGS                     : 1;
    __IO uint8_t WK3EGS                     : 1;
    __IO uint8_t VD1EGS                     : 1;
    __IO uint8_t VD2EGS                     : 1;
    __IO uint8_t NMIEGS                     : 1;
    uint8_t RESERVED7                       : 1;
} stc_sysreg_pwr_pdwkes_field_t;

typedef struct
{
    __IO uint8_t PTWK0F                     : 1;
    __IO uint8_t PTWK1F                     : 1;
    __IO uint8_t PTWK2F                     : 1;
    __IO uint8_t PTWK3F                     : 1;
    __IO uint8_t VD1WKF                     : 1;
    __IO uint8_t VD2WKF                     : 1;
    __IO uint8_t NMIWKF                     : 1;
    uint8_t RESERVED7                       : 1;
} stc_sysreg_pwr_pdwkf0_field_t;

typedef struct
{
    uint8_t RESERVED0                       : 4;
    __IO uint8_t RTCPRDWKF                  : 1;
    __IO uint8_t RTCALMWKF                  : 1;
    uint8_t RESERVED6                       : 1;
    __IO uint8_t WKTMWKF                    : 1;
} stc_sysreg_pwr_pdwkf1_field_t;

typedef struct
{
    uint8_t RESERVED0                       : 7;
    __IO uint8_t ADBUFE                     : 1;
} stc_sysreg_pwr_pwcmr_field_t;

typedef struct
{
    uint8_t RESERVED0                       : 4;
    __IO uint8_t XTALDRV                    : 2;
    __IO uint8_t XTALMS                     : 1;
    __IO uint8_t SUPDRV                     : 1;
} stc_sysreg_cmu_xtalcfgr_field_t;

typedef struct
{
    __IO uint8_t EXVCCINEN                  : 1;
    uint8_t RESERVED1                       : 4;
    __IO uint8_t PVD1EN                     : 1;
    __IO uint8_t PVD2EN                     : 1;
    uint8_t RESERVED7                       : 1;
} stc_sysreg_pwr_pvdcr0_field_t;

typedef struct
{
    __IO uint8_t PVD1IRE                    : 1;
    __IO uint8_t PVD1IRS                    : 1;
    __IO uint8_t PVD1CMPOE                  : 1;
    uint8_t RESERVED3                       : 1;
    __IO uint8_t PVD2IRE                    : 1;
    __IO uint8_t PVD2IRS                    : 1;
    __IO uint8_t PVD2CMPOE                  : 1;
    uint8_t RESERVED7                       : 1;
} stc_sysreg_pwr_pvdcr1_field_t;

typedef struct
{
    __IO uint8_t PVD1NFDIS                  : 1;
    __IO uint8_t PVD1NFCKS                  : 2;
    uint8_t RESERVED3                       : 1;
    __IO uint8_t PVD2NFDIS                  : 1;
    __IO uint8_t PVD2NFCKS                  : 2;
    uint8_t RESERVED7                       : 1;
} stc_sysreg_pwr_pvdfcr_field_t;

typedef struct
{
    __IO uint8_t PVD1LVL                    : 3;
    uint8_t RESERVED3                       : 1;
    __IO uint8_t PVD2LVL                    : 3;
    uint8_t RESERVED7                       : 1;
} stc_sysreg_pwr_pvdlcr_field_t;

typedef struct
{
    __IO uint8_t XTAL32STP                  : 1;
    uint8_t RESERVED1                       : 7;
} stc_sysreg_cmu_xtal32cr_field_t;

typedef struct
{
    __IO uint8_t XTAL32DRV                  : 3;
    uint8_t RESERVED3                       : 5;
} stc_sysreg_cmu_xtal32cfgr_field_t;

typedef struct
{
    __IO uint8_t XTAL32NF                   : 2;
    uint8_t RESERVED2                       : 6;
} stc_sysreg_cmu_xtal32nfr_field_t;

typedef struct
{
    __IO uint8_t LRCSTP                     : 1;
    uint8_t RESERVED1                       : 7;
} stc_sysreg_cmu_lrccr_field_t;

typedef struct
{
    uint8_t RESERVED0                       : 7;
    __IO uint8_t CSDIS                      : 1;
} stc_sysreg_pwr_xtal32cs_field_t;

typedef struct
{
    __IO uint32_t CNTA                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr0_cntar_field_t;

typedef struct
{
    __IO uint32_t CNTB                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr0_cntbr_field_t;

typedef struct
{
    __IO uint32_t CMPA                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr0_cmpar_field_t;

typedef struct
{
    __IO uint32_t CMPB                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr0_cmpbr_field_t;

typedef struct
{
    __IO uint32_t CSTA                      : 1;
    __IO uint32_t CAPMDA                    : 1;
    __IO uint32_t INTENA                    : 1;
    uint32_t RESERVED3                      : 1;
    __IO uint32_t CKDIVA                    : 4;
    __IO uint32_t SYNSA                     : 1;
    __IO uint32_t SYNCLKA                   : 1;
    __IO uint32_t ASYNCLKA                  : 1;
    uint32_t RESERVED11                     : 1;
    __IO uint32_t HSTAA                     : 1;
    __IO uint32_t HSTPA                     : 1;
    __IO uint32_t HCLEA                     : 1;
    __IO uint32_t HICPA                     : 1;
    __IO uint32_t CSTB                      : 1;
    __IO uint32_t CAPMDB                    : 1;
    __IO uint32_t INTENB                    : 1;
    uint32_t RESERVED19                     : 1;
    __IO uint32_t CKDIVB                    : 4;
    __IO uint32_t SYNSB                     : 1;
    __IO uint32_t SYNCLKB                   : 1;
    __IO uint32_t ASYNCLKB                  : 1;
    uint32_t RESERVED27                     : 1;
    __IO uint32_t HSTAB                     : 1;
    __IO uint32_t HSTPB                     : 1;
    __IO uint32_t HCLEB                     : 1;
    __IO uint32_t HICPB                     : 1;
} stc_tmr0_bconr_field_t;

typedef struct
{
    __IO uint32_t CMAF                      : 1;
    uint32_t RESERVED1                      :15;
    __IO uint32_t CMBF                      : 1;
    uint32_t RESERVED17                     :15;
} stc_tmr0_stflr_field_t;

typedef struct
{
    __IO uint16_t OCEH                      : 1;
    __IO uint16_t OCEL                      : 1;
    __IO uint16_t OCPH                      : 1;
    __IO uint16_t OCPL                      : 1;
    __IO uint16_t OCIEH                     : 1;
    __IO uint16_t OCIEL                     : 1;
    __IO uint16_t OCFH                      : 1;
    __IO uint16_t OCFL                      : 1;
    uint16_t RESERVED8                      : 8;
} stc_tmr4_ocsr_field_t;

typedef struct
{
    __IO uint16_t CHBUFEN                   : 2;
    __IO uint16_t CLBUFEN                   : 2;
    __IO uint16_t MHBUFEN                   : 2;
    __IO uint16_t MLBUFEN                   : 2;
    __IO uint16_t LMCH                      : 1;
    __IO uint16_t LMCL                      : 1;
    __IO uint16_t LMMH                      : 1;
    __IO uint16_t LMML                      : 1;
    __IO uint16_t MCECH                     : 1;
    __IO uint16_t MCECL                     : 1;
    uint16_t RESERVED14                     : 2;
} stc_tmr4_ocer_field_t;

typedef struct
{
    __IO uint16_t OCFDCH                    : 1;
    __IO uint16_t OCFPKH                    : 1;
    __IO uint16_t OCFUCH                    : 1;
    __IO uint16_t OCFZRH                    : 1;
    __IO uint16_t OPDCH                     : 2;
    __IO uint16_t OPPKH                     : 2;
    __IO uint16_t OPUCH                     : 2;
    __IO uint16_t OPZRH                     : 2;
    __IO uint16_t OPNPKH                    : 2;
    __IO uint16_t OPNZRH                    : 2;
} stc_tmr4_ocmrh_field_t;

typedef struct
{
    __IO uint32_t OCFDCL                    : 1;
    __IO uint32_t OCFPKL                    : 1;
    __IO uint32_t OCFUCL                    : 1;
    __IO uint32_t OCFZRL                    : 1;
    __IO uint32_t OPDCL                     : 2;
    __IO uint32_t OPPKL                     : 2;
    __IO uint32_t OPUCL                     : 2;
    __IO uint32_t OPZRL                     : 2;
    __IO uint32_t OPNPKL                    : 2;
    __IO uint32_t OPNZRL                    : 2;
    __IO uint32_t EOPNDCL                   : 2;
    __IO uint32_t EOPNUCL                   : 2;
    __IO uint32_t EOPDCL                    : 2;
    __IO uint32_t EOPPKL                    : 2;
    __IO uint32_t EOPUCL                    : 2;
    __IO uint32_t EOPZRL                    : 2;
    __IO uint32_t EOPNPKL                   : 2;
    __IO uint32_t EOPNZRL                   : 2;
} stc_tmr4_ocmrl_field_t;

typedef struct
{
    __IO uint16_t CKDIV                     : 4;
    __IO uint16_t CLEAR                     : 1;
    __IO uint16_t MODE                      : 1;
    __IO uint16_t STOP                      : 1;
    __IO uint16_t BUFEN                     : 1;
    __IO uint16_t IRQPEN                    : 1;
    __IO uint16_t IRQPF                     : 1;
    uint16_t RESERVED10                     : 3;
    __IO uint16_t IRQZEN                    : 1;
    __IO uint16_t IRQZF                     : 1;
    __IO uint16_t ECKEN                     : 1;
} stc_tmr4_ccsr_field_t;

typedef struct
{
    __IO uint16_t ZIM                       : 4;
    __IO uint16_t PIM                       : 4;
    __I  uint16_t ZIC                       : 4;
    __I  uint16_t PIC                       : 4;
} stc_tmr4_cvpr_field_t;

typedef struct
{
    __IO uint16_t DIVCK                     : 4;
    __IO uint16_t PWMMD                     : 2;
    __IO uint16_t LVLS                      : 2;
    uint16_t RESERVED8                      : 8;
} stc_tmr4_pocr_field_t;

typedef struct
{
    __IO uint16_t RTIDU                     : 1;
    __IO uint16_t RTIDV                     : 1;
    __IO uint16_t RTIDW                     : 1;
    uint16_t RESERVED3                      : 1;
    __I  uint16_t RTIFU                     : 1;
    __IO uint16_t RTICU                     : 1;
    __IO uint16_t RTEU                      : 1;
    __IO uint16_t RTSU                      : 1;
    __I  uint16_t RTIFV                     : 1;
    __IO uint16_t RTICV                     : 1;
    __IO uint16_t RTEV                      : 1;
    __IO uint16_t RTSV                      : 1;
    __I  uint16_t RTIFW                     : 1;
    __IO uint16_t RTICW                     : 1;
    __IO uint16_t RTEW                      : 1;
    __IO uint16_t RTSW                      : 1;
} stc_tmr4_rcsr_field_t;

typedef struct
{
    __IO uint16_t BUFEN                     : 2;
    __IO uint16_t EVTOS                     : 3;
    __IO uint16_t LMC                       : 1;
    uint16_t RESERVED6                      : 2;
    __IO uint16_t EVTMS                     : 1;
    __IO uint16_t EVTDS                     : 1;
    uint16_t RESERVED10                     : 2;
    __IO uint16_t DEN                       : 1;
    __IO uint16_t PEN                       : 1;
    __IO uint16_t UEN                       : 1;
    __IO uint16_t ZEN                       : 1;
} stc_tmr4_scsr_field_t;

typedef struct
{
    __IO uint16_t AMC                       : 4;
    uint16_t RESERVED4                      : 2;
    __IO uint16_t MZCE                      : 1;
    __IO uint16_t MPCE                      : 1;
    uint16_t RESERVED8                      : 8;
} stc_tmr4_scmr_field_t;

typedef struct
{
    uint16_t RESERVED0                      : 7;
    __IO uint16_t HOLD                      : 1;
    uint16_t RESERVED8                      : 8;
} stc_tmr4_ecsr_field_t;

typedef struct
{
    __IO uint16_t EMBVAL                    : 2;
    uint16_t RESERVED2                      :14;
} stc_tmr4_cr_ecer1_field_t;

typedef struct
{
    __IO uint16_t EMBVAL                    : 2;
    uint16_t RESERVED2                      :14;
} stc_tmr4_cr_ecer2_field_t;

typedef struct
{
    __IO uint16_t EMBVAL                    : 2;
    uint16_t RESERVED2                      :14;
} stc_tmr4_cr_ecer3_field_t;

typedef struct
{
    __IO uint32_t CNT                       :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_cnter_field_t;

typedef struct
{
    __IO uint32_t PERA                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_perar_field_t;

typedef struct
{
    __IO uint32_t PERB                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_perbr_field_t;

typedef struct
{
    __IO uint32_t PERC                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_percr_field_t;

typedef struct
{
    __IO uint32_t GCMA                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_gcmar_field_t;

typedef struct
{
    __IO uint32_t GCMB                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_gcmbr_field_t;

typedef struct
{
    __IO uint32_t GCMC                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_gcmcr_field_t;

typedef struct
{
    __IO uint32_t GCMD                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_gcmdr_field_t;

typedef struct
{
    __IO uint32_t GCME                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_gcmer_field_t;

typedef struct
{
    __IO uint32_t GCMF                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_gcmfr_field_t;

typedef struct
{
    __IO uint32_t SCMA                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_scmar_field_t;

typedef struct
{
    __IO uint32_t SCMB                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_scmbr_field_t;

typedef struct
{
    __IO uint32_t SCMC                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_scmcr_field_t;

typedef struct
{
    __IO uint32_t SCMD                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_scmdr_field_t;

typedef struct
{
    __IO uint32_t SCME                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_scmer_field_t;

typedef struct
{
    __IO uint32_t SCMF                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_scmfr_field_t;

typedef struct
{
    __IO uint32_t DTUA                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_dtuar_field_t;

typedef struct
{
    __IO uint32_t DTDA                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_dtdar_field_t;

typedef struct
{
    __IO uint32_t DTUB                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_dtubr_field_t;

typedef struct
{
    __IO uint32_t DTDB                      :16;
    uint32_t RESERVED16                     :16;
} stc_tmr6_dtdbr_field_t;

typedef struct
{
    __IO uint32_t START                     : 1;
    __IO uint32_t MODE                      : 3;
    __IO uint32_t CKDIV                     : 3;
    uint32_t RESERVED7                      : 1;
    __IO uint32_t DIR                       : 1;
    uint32_t RESERVED9                      : 7;
    __IO uint32_t ZMSKREV                   : 1;
    __IO uint32_t ZMSKPOS                   : 1;
    __IO uint32_t ZMSKVAL                   : 2;
    uint32_t RESERVED20                     :12;
} stc_tmr6_gconr_field_t;

typedef struct
{
    __IO uint32_t INTENA                    : 1;
    __IO uint32_t INTENB                    : 1;
    __IO uint32_t INTENC                    : 1;
    __IO uint32_t INTEND                    : 1;
    __IO uint32_t INTENE                    : 1;
    __IO uint32_t INTENF                    : 1;
    __IO uint32_t INTENOVF                  : 1;
    __IO uint32_t INTENUDF                  : 1;
    __IO uint32_t INTENDTE                  : 1;
    uint32_t RESERVED9                      : 7;
    __IO uint32_t INTENSAU                  : 1;
    __IO uint32_t INTENSAD                  : 1;
    __IO uint32_t INTENSBU                  : 1;
    __IO uint32_t INTENSBD                  : 1;
    uint32_t RESERVED20                     :12;
} stc_tmr6_iconr_field_t;

typedef struct
{
    __IO uint32_t CAPMDA                    : 1;
    __IO uint32_t STACA                     : 1;
    __IO uint32_t STPCA                     : 1;
    __IO uint32_t STASTPSA                  : 1;
    __IO uint32_t CMPCA                     : 2;
    __IO uint32_t PERCA                     : 2;
    __IO uint32_t OUTENA                    : 1;
    uint32_t RESERVED9                      : 2;
    __IO uint32_t EMBVALA                   : 2;
    uint32_t RESERVED13                     : 3;
    __IO uint32_t CAPMDB                    : 1;
    __IO uint32_t STACB                     : 1;
    __IO uint32_t STPCB                     : 1;
    __IO uint32_t STASTPSB                  : 1;
    __IO uint32_t CMPCB                     : 2;
    __IO uint32_t PERCB                     : 2;
    __IO uint32_t OUTENB                    : 1;
    uint32_t RESERVED25                     : 2;
    __IO uint32_t EMBVALB                   : 2;
    uint32_t RESERVED29                     : 3;
} stc_tmr6_pconr_field_t;

typedef struct
{
    __IO uint32_t BENA                      : 1;
    __IO uint32_t BSEA                      : 1;
    __IO uint32_t BENB                      : 1;
    __IO uint32_t BSEB                      : 1;
    uint32_t RESERVED4                      : 4;
    __IO uint32_t BENP                      : 1;
    __IO uint32_t BSEP                      : 1;
    uint32_t RESERVED10                     : 6;
    __IO uint32_t BENSPA                    : 1;
    __IO uint32_t BSESPA                    : 1;
    uint32_t RESERVED18                     : 2;
    __IO uint32_t BTRSPA                    : 2;
    uint32_t RESERVED22                     : 2;
    __IO uint32_t BENSPB                    : 1;
    __IO uint32_t BSESPB                    : 1;
    uint32_t RESERVED26                     : 2;
    __IO uint32_t BTRSPB                    : 2;
    uint32_t RESERVED30                     : 2;
} stc_tmr6_bconr_field_t;

typedef struct
{
    __IO uint32_t DTCEN                     : 1;
    uint32_t RESERVED1                      : 3;
    __IO uint32_t DTBENU                    : 1;
    __IO uint32_t DTBEND                    : 1;
    uint32_t RESERVED6                      : 2;
    __IO uint32_t SEPA                      : 1;
    uint32_t RESERVED9                      :23;
} stc_tmr6_dconr_field_t;

typedef struct
{
    __IO uint32_t NOFIENGA                  : 1;
    __IO uint32_t NOFICKGA                  : 2;
    uint32_t RESERVED3                      : 1;
    __IO uint32_t NOFIENGB                  : 1;
    __IO uint32_t NOFICKGB                  : 2;
    uint32_t RESERVED7                      : 9;
    __IO uint32_t NOFIENTA                  : 1;
    __IO uint32_t NOFICKTA                  : 2;
    uint32_t RESERVED19                     : 1;
    __IO uint32_t NOFIENTB                  : 1;
    __IO uint32_t NOFICKTB                  : 2;
    uint32_t RESERVED23                     : 9;
} stc_tmr6_fconr_field_t;

typedef struct
{
    uint32_t RESERVED0                      : 8;
    __IO uint32_t SPPERIA                   : 1;
    __IO uint32_t SPPERIB                   : 1;
    uint32_t RESERVED10                     : 6;
    __IO uint32_t PCNTE                     : 2;
    __IO uint32_t PCNTS                     : 3;
    uint32_t RESERVED21                     :11;
} stc_tmr6_vperr_field_t;

typedef struct
{
    __IO uint32_t CMAF                      : 1;
    __IO uint32_t CMBF                      : 1;
    __IO uint32_t CMCF                      : 1;
    __IO uint32_t CMDF                      : 1;
    __IO uint32_t CMEF                      : 1;
    __IO uint32_t CMFF                      : 1;
    __IO uint32_t OVFF                      : 1;
    __IO uint32_t UDFF                      : 1;
    __I  uint32_t DTEF                      : 1;
    __IO uint32_t CMSAUF                    : 1;
    __IO uint32_t CMSADF                    : 1;
    __IO uint32_t CMSBUF                    : 1;
    __IO uint32_t CMSBDF                    : 1;
    uint32_t RESERVED13                     : 8;
    __I  uint32_t VPERNUM                   : 3;
    uint32_t RESERVED24                     : 7;
    __I  uint32_t DIRF                      : 1;
} stc_tmr6_stflr_field_t;

typedef struct
{
    __IO uint32_t HSTA0                     : 1;
    __IO uint32_t HSTA1                     : 1;
    uint32_t RESERVED2                      : 2;
    __IO uint32_t HSTA4                     : 1;
    __IO uint32_t HSTA5                     : 1;
    __IO uint32_t HSTA6                     : 1;
    __IO uint32_t HSTA7                     : 1;
    __IO uint32_t HSTA8                     : 1;
    __IO uint32_t HSTA9                     : 1;
    __IO uint32_t HSTA10                    : 1;
    __IO uint32_t HSTA11                    : 1;
    uint32_t RESERVED12                     :19;
    __IO uint32_t STARTS                    : 1;
} stc_tmr6_hstar_field_t;

typedef struct
{
    __IO uint32_t HSTP0                     : 1;
    __IO uint32_t HSTP1                     : 1;
    uint32_t RESERVED2                      : 2;
    __IO uint32_t HSTP4                     : 1;
    __IO uint32_t HSTP5                     : 1;
    __IO uint32_t HSTP6                     : 1;
    __IO uint32_t HSTP7                     : 1;
    __IO uint32_t HSTP8                     : 1;
    __IO uint32_t HSTP9                     : 1;
    __IO uint32_t HSTP10                    : 1;
    __IO uint32_t HSTP11                    : 1;
    uint32_t RESERVED12                     :19;
    __IO uint32_t STOPS                     : 1;
} stc_tmr6_hstpr_field_t;

typedef struct
{
    __IO uint32_t HCLE0                     : 1;
    __IO uint32_t HCLE1                     : 1;
    uint32_t RESERVED2                      : 2;
    __IO uint32_t HCLE4                     : 1;
    __IO uint32_t HCLE5                     : 1;
    __IO uint32_t HCLE6                     : 1;
    __IO uint32_t HCLE7                     : 1;
    __IO uint32_t HCLE8                     : 1;
    __IO uint32_t HCLE9                     : 1;
    __IO uint32_t HCLE10                    : 1;
    __IO uint32_t HCLE11                    : 1;
    uint32_t RESERVED12                     :19;
    __IO uint32_t CLEARS                    : 1;
} stc_tmr6_hclrr_field_t;

typedef struct
{
    __IO uint32_t HCPA0                     : 1;
    __IO uint32_t HCPA1                     : 1;
    uint32_t RESERVED2                      : 2;
    __IO uint32_t HCPA4                     : 1;
    __IO uint32_t HCPA5                     : 1;
    __IO uint32_t HCPA6                     : 1;
    __IO uint32_t HCPA7                     : 1;
    __IO uint32_t HCPA8                     : 1;
    __IO uint32_t HCPA9                     : 1;
    __IO uint32_t HCPA10                    : 1;
    __IO uint32_t HCPA11                    : 1;
    uint32_t RESERVED12                     :20;
} stc_tmr6_hcpar_field_t;

typedef struct
{
    __IO uint32_t HCPB0                     : 1;
    __IO uint32_t HCPB1                     : 1;
    uint32_t RESERVED2                      : 2;
    __IO uint32_t HCPB4                     : 1;
    __IO uint32_t HCPB5                     : 1;
    __IO uint32_t HCPB6                     : 1;
    __IO uint32_t HCPB7                     : 1;
    __IO uint32_t HCPB8                     : 1;
    __IO uint32_t HCPB9                     : 1;
    __IO uint32_t HCPB10                    : 1;
    __IO uint32_t HCPB11                    : 1;
    uint32_t RESERVED12                     :20;
} stc_tmr6_hcpbr_field_t;

typedef struct
{
    __IO uint32_t HCUP0                     : 1;
    __IO uint32_t HCUP1                     : 1;
    __IO uint32_t HCUP2                     : 1;
    __IO uint32_t HCUP3                     : 1;
    __IO uint32_t HCUP4                     : 1;
    __IO uint32_t HCUP5                     : 1;
    __IO uint32_t HCUP6                     : 1;
    __IO uint32_t HCUP7                     : 1;
    __IO uint32_t HCUP8                     : 1;
    __IO uint32_t HCUP9                     : 1;
    __IO uint32_t HCUP10                    : 1;
    __IO uint32_t HCUP11                    : 1;
    uint32_t RESERVED12                     : 4;
    __IO uint32_t HCUP16                    : 1;
    __IO uint32_t HCUP17                    : 1;
    uint32_t RESERVED18                     :14;
} stc_tmr6_hcupr_field_t;

typedef struct
{
    __IO uint32_t HCDO0                     : 1;
    __IO uint32_t HCDO1                     : 1;
    __IO uint32_t HCDO2                     : 1;
    __IO uint32_t HCDO3                     : 1;
    __IO uint32_t HCDO4                     : 1;
    __IO uint32_t HCDO5                     : 1;
    __IO uint32_t HCDO6                     : 1;
    __IO uint32_t HCDO7                     : 1;
    __IO uint32_t HCDO8                     : 1;
    __IO uint32_t HCDO9                     : 1;
    __IO uint32_t HCDO10                    : 1;
    __IO uint32_t HCDO11                    : 1;
    uint32_t RESERVED12                     : 4;
    __IO uint32_t HCDO16                    : 1;
    __IO uint32_t HCDO17                    : 1;
    uint32_t RESERVED18                     :14;
} stc_tmr6_hcdor_field_t;

typedef struct
{
    __IO uint32_t SSTA1                     : 1;
    __IO uint32_t SSTA2                     : 1;
    __IO uint32_t SSTA3                     : 1;
    uint32_t RESERVED3                      :13;
    __IO uint32_t RESV0                     : 1;
    uint32_t RESERVED17                     : 7;
    __IO uint32_t RESV                      : 1;
    uint32_t RESERVED25                     : 7;
} stc_tmr6_cr_sstar_field_t;

typedef struct
{
    __IO uint32_t SSTP1                     : 1;
    __IO uint32_t SSTP2                     : 1;
    __IO uint32_t SSTP3                     : 1;
    uint32_t RESERVED3                      :29;
} stc_tmr6_cr_sstpr_field_t;

typedef struct
{
    __IO uint32_t SCLE1                     : 1;
    __IO uint32_t SCLE2                     : 1;
    __IO uint32_t SCLE3                     : 1;
    uint32_t RESERVED3                      :29;
} stc_tmr6_cr_sclrr_field_t;

typedef struct
{
    __IO uint16_t CNT                       :16;
} stc_tmra_cnter_field_t;

typedef struct
{
    __IO uint16_t PER                       :16;
} stc_tmra_perar_field_t;

typedef struct
{
    __IO uint16_t CMP                       :16;
} stc_tmra_cmpar_field_t;

typedef struct
{
    __IO uint16_t START                     : 1;
    __IO uint16_t DIR                       : 1;
    __IO uint16_t MODE                      : 1;
    __IO uint16_t SYNST                     : 1;
    __IO uint16_t CKDIV                     : 4;
    uint16_t RESERVED8                      : 4;
    __IO uint16_t ITENOVF                   : 1;
    __IO uint16_t ITENUDF                   : 1;
    __IO uint16_t OVFF                      : 1;
    __IO uint16_t UDFF                      : 1;
} stc_tmra_bcstr_field_t;

typedef struct
{
    __IO uint16_t HSTA0                     : 1;
    __IO uint16_t HSTA1                     : 1;
    __IO uint16_t HSTA2                     : 1;
    uint16_t RESERVED3                      : 1;
    __IO uint16_t HSTP0                     : 1;
    __IO uint16_t HSTP1                     : 1;
    __IO uint16_t HSTP2                     : 1;
    uint16_t RESERVED7                      : 1;
    __IO uint16_t HCLE0                     : 1;
    __IO uint16_t HCLE1                     : 1;
    __IO uint16_t HCLE2                     : 1;
    uint16_t RESERVED11                     : 1;
    __IO uint16_t HCLE3                     : 1;
    __IO uint16_t HCLE4                     : 1;
    __IO uint16_t HCLE5                     : 1;
    __IO uint16_t HCLE6                     : 1;
} stc_tmra_hconr_field_t;

typedef struct
{
    __IO uint16_t HCUP0                     : 1;
    __IO uint16_t HCUP1                     : 1;
    __IO uint16_t HCUP2                     : 1;
    __IO uint16_t HCUP3                     : 1;
    __IO uint16_t HCUP4                     : 1;
    __IO uint16_t HCUP5                     : 1;
    __IO uint16_t HCUP6                     : 1;
    __IO uint16_t HCUP7                     : 1;
    __IO uint16_t HCUP8                     : 1;
    __IO uint16_t HCUP9                     : 1;
    __IO uint16_t HCUP10                    : 1;
    __IO uint16_t HCUP11                    : 1;
    __IO uint16_t HCUP12                    : 1;
    uint16_t RESERVED13                     : 3;
} stc_tmra_hcupr_field_t;

typedef struct
{
    __IO uint16_t HCDO0                     : 1;
    __IO uint16_t HCDO1                     : 1;
    __IO uint16_t HCDO2                     : 1;
    __IO uint16_t HCDO3                     : 1;
    __IO uint16_t HCDO4                     : 1;
    __IO uint16_t HCDO5                     : 1;
    __IO uint16_t HCDO6                     : 1;
    __IO uint16_t HCDO7                     : 1;
    __IO uint16_t HCDO8                     : 1;
    __IO uint16_t HCDO9                     : 1;
    __IO uint16_t HCDO10                    : 1;
    __IO uint16_t HCDO11                    : 1;
    __IO uint16_t HCDO12                    : 1;
    uint16_t RESERVED13                     : 3;
} stc_tmra_hcdor_field_t;

typedef struct
{
    __IO uint16_t ITEN1                     : 1;
    __IO uint16_t ITEN2                     : 1;
    __IO uint16_t ITEN3                     : 1;
    __IO uint16_t ITEN4                     : 1;
    __IO uint16_t ITEN5                     : 1;
    __IO uint16_t ITEN6                     : 1;
    __IO uint16_t ITEN7                     : 1;
    __IO uint16_t ITEN8                     : 1;
    uint16_t RESERVED8                      : 8;
} stc_tmra_iconr_field_t;

typedef struct
{
    __IO uint16_t ETEN1                     : 1;
    __IO uint16_t ETEN2                     : 1;
    __IO uint16_t ETEN3                     : 1;
    __IO uint16_t ETEN4                     : 1;
    __IO uint16_t ETEN5                     : 1;
    __IO uint16_t ETEN6                     : 1;
    __IO uint16_t ETEN7                     : 1;
    __IO uint16_t ETEN8                     : 1;
    uint16_t RESERVED8                      : 8;
} stc_tmra_econr_field_t;

typedef struct
{
    __IO uint16_t NOFIENTG                  : 1;
    __IO uint16_t NOFICKTG                  : 2;
    uint16_t RESERVED3                      : 5;
    __IO uint16_t NOFIENCA                  : 1;
    __IO uint16_t NOFICKCA                  : 2;
    uint16_t RESERVED11                     : 1;
    __IO uint16_t NOFIENCB                  : 1;
    __IO uint16_t NOFICKCB                  : 2;
    uint16_t RESERVED15                     : 1;
} stc_tmra_fconr_field_t;

typedef struct
{
    __IO uint16_t CMPF1                     : 1;
    __IO uint16_t CMPF2                     : 1;
    __IO uint16_t CMPF3                     : 1;
    __IO uint16_t CMPF4                     : 1;
    __IO uint16_t CMPF5                     : 1;
    __IO uint16_t CMPF6                     : 1;
    __IO uint16_t CMPF7                     : 1;
    __IO uint16_t CMPF8                     : 1;
    uint16_t RESERVED8                      : 8;
} stc_tmra_stflr_field_t;

typedef struct
{
    __IO uint16_t BEN                       : 1;
    __IO uint16_t BSE0                      : 1;
    __IO uint16_t BSE1                      : 1;
    uint16_t RESERVED3                      :13;
} stc_tmra_bconr_field_t;

typedef struct
{
    __IO uint16_t CAPMD                     : 1;
    uint16_t RESERVED1                      : 3;
    __IO uint16_t HICP0                     : 1;
    __IO uint16_t HICP1                     : 1;
    __IO uint16_t HICP2                     : 1;
    uint16_t RESERVED7                      : 1;
    __IO uint16_t HICP3                     : 1;
    __IO uint16_t HICP4                     : 1;
    uint16_t RESERVED10                     : 2;
    __IO uint16_t NOFIENCP                  : 1;
    __IO uint16_t NOFICKCP                  : 2;
    uint16_t RESERVED15                     : 1;
} stc_tmra_cconr_field_t;

typedef struct
{
    __IO uint16_t STAC                      : 2;
    __IO uint16_t STPC                      : 2;
    __IO uint16_t CMPC                      : 2;
    __IO uint16_t PERC                      : 2;
    __IO uint16_t FORC                      : 2;
    uint16_t RESERVED10                     : 2;
    __IO uint16_t OUTEN                     : 1;
    uint16_t RESERVED13                     : 3;
} stc_tmra_pconr_field_t;

typedef struct
{
    __IO uint32_t EN                        : 1;
    __IO uint32_t RUN                       : 1;
    uint32_t RESERVED2                      :30;
} stc_trng_cr_field_t;

typedef struct
{
    __IO uint32_t LOAD                      : 1;
    uint32_t RESERVED1                      : 1;
    __IO uint32_t CNT                       : 3;
    uint32_t RESERVED5                      :27;
} stc_trng_mr_field_t;

typedef struct
{
    __I  uint32_t PE                        : 1;
    __I  uint32_t FE                        : 1;
    uint32_t RESERVED2                      : 1;
    __I  uint32_t ORE                       : 1;
    uint32_t RESERVED4                      : 1;
    __I  uint32_t RXNE                      : 1;
    __I  uint32_t TC                        : 1;
    __I  uint32_t TXE                       : 1;
    __I  uint32_t RTOF                      : 1;
    uint32_t RESERVED9                      : 7;
    __I  uint32_t MPB                       : 1;
    uint32_t RESERVED17                     :15;
} stc_usart_sr_field_t;

typedef struct
{
    __IO uint32_t TDR                       : 9;
    __IO uint32_t MPID                      : 1;
    uint32_t RESERVED10                     : 6;
    __IO uint32_t RDR                       : 9;
    uint32_t RESERVED25                     : 7;
} stc_usart_dr_field_t;

typedef struct
{
    __IO uint32_t DIV_FRACTION              : 7;
    uint32_t RESERVED7                      : 1;
    __IO uint32_t DIV_INTEGER               : 8;
    uint32_t RESERVED16                     :16;
} stc_usart_brr_field_t;

typedef struct
{
    __IO uint32_t RTOE                      : 1;
    __IO uint32_t RTOIE                     : 1;
    __IO uint32_t RE                        : 1;
    __IO uint32_t TE                        : 1;
    __IO uint32_t SLME                      : 1;
    __IO uint32_t RIE                       : 1;
    __IO uint32_t TCIE                      : 1;
    __IO uint32_t TXEIE                     : 1;
    uint32_t RESERVED8                      : 1;
    __IO uint32_t PS                        : 1;
    __IO uint32_t PCE                       : 1;
    uint32_t RESERVED11                     : 1;
    __IO uint32_t M                         : 1;
    uint32_t RESERVED13                     : 2;
    __IO uint32_t OVER8                     : 1;
    __O  uint32_t CPE                       : 1;
    __O  uint32_t CFE                       : 1;
    uint32_t RESERVED18                     : 1;
    __O  uint32_t CORE                      : 1;
    __O  uint32_t CRTOF                     : 1;
    uint32_t RESERVED21                     : 3;
    __IO uint32_t MS                        : 1;
    uint32_t RESERVED25                     : 3;
    __IO uint32_t ML                        : 1;
    __IO uint32_t FBME                      : 1;
    __IO uint32_t NFE                       : 1;
    __IO uint32_t SBS                       : 1;
} stc_usart_cr1_field_t;

typedef struct
{
    __IO uint32_t MPE                       : 1;
    uint32_t RESERVED1                      :10;
    __IO uint32_t CLKC                      : 2;
    __IO uint32_t STOP                      : 1;
    uint32_t RESERVED14                     :18;
} stc_usart_cr2_field_t;

typedef struct
{
    uint32_t RESERVED0                      : 5;
    __IO uint32_t SCEN                      : 1;
    uint32_t RESERVED6                      : 3;
    __IO uint32_t CTSE                      : 1;
    uint32_t RESERVED10                     :11;
    __IO uint32_t BCN                       : 3;
    uint32_t RESERVED24                     : 8;
} stc_usart_cr3_field_t;

typedef struct
{
    __IO uint32_t PSC                       : 2;
    uint32_t RESERVED2                      :30;
} stc_usart_pr_field_t;

typedef struct
{
    uint32_t RESERVED0                      : 6;
    __IO uint32_t VBUSOVEN                  : 1;
    __IO uint32_t VBUSVAL                   : 1;
    uint32_t RESERVED8                      :24;
} stc_usbfs_gvbuscfg_field_t;

typedef struct
{
    __IO uint32_t GINTMSK                   : 1;
    __IO uint32_t HBSTLEN                   : 4;
    __IO uint32_t DMAEN                     : 1;
    uint32_t RESERVED6                      : 1;
    __IO uint32_t TXFELVL                   : 1;
    __IO uint32_t PTXFELVL                  : 1;
    uint32_t RESERVED9                      :23;
} stc_usbfs_gahbcfg_field_t;

typedef struct
{
    __IO uint32_t TOCAL                     : 3;
    uint32_t RESERVED3                      : 3;
    __IO uint32_t PHYSEL                    : 1;
    uint32_t RESERVED7                      : 3;
    __IO uint32_t TRDT                      : 4;
    uint32_t RESERVED14                     :15;
    __IO uint32_t FHMOD                     : 1;
    __IO uint32_t FDMOD                     : 1;
    uint32_t RESERVED31                     : 1;
} stc_usbfs_gusbcfg_field_t;

typedef struct
{
    __IO uint32_t CSRST                     : 1;
    __IO uint32_t HSRST                     : 1;
    __IO uint32_t FCRST                     : 1;
    uint32_t RESERVED3                      : 1;
    __IO uint32_t RXFFLSH                   : 1;
    __IO uint32_t TXFFLSH                   : 1;
    __IO uint32_t TXFNUM                    : 5;
    uint32_t RESERVED11                     :19;
    __I  uint32_t DMAREQ                    : 1;
    __I  uint32_t AHBIDL                    : 1;
} stc_usbfs_grstctl_field_t;

typedef struct
{
    __I  uint32_t CMOD                      : 1;
    __IO uint32_t MMIS                      : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t SOF                       : 1;
    __I  uint32_t RXFNE                     : 1;
    __I  uint32_t NPTXFE                    : 1;
    __I  uint32_t GINAKEFF                  : 1;
    __I  uint32_t GONAKEFF                  : 1;
    uint32_t RESERVED8                      : 2;
    __IO uint32_t ESUSP                     : 1;
    __IO uint32_t USBSUSP                   : 1;
    __IO uint32_t USBRST                    : 1;
    __IO uint32_t ENUMDNE                   : 1;
    __IO uint32_t ISOODRP                   : 1;
    __IO uint32_t EOPF                      : 1;
    uint32_t RESERVED16                     : 2;
    __I  uint32_t IEPINT                    : 1;
    __I  uint32_t OEPINT                    : 1;
    __IO uint32_t IISOIXFR                  : 1;
    __IO uint32_t IPXFR_INCOMPISOOUT        : 1;
    __IO uint32_t DATAFSUSP                 : 1;
    uint32_t RESERVED23                     : 1;
    __I  uint32_t HPRTINT                   : 1;
    __I  uint32_t HCINT                     : 1;
    __I  uint32_t PTXFE                     : 1;
    uint32_t RESERVED27                     : 1;
    __IO uint32_t CIDSCHG                   : 1;
    __IO uint32_t DISCINT                   : 1;
    __IO uint32_t VBUSVINT                  : 1;
    __IO uint32_t WKUINT                    : 1;
} stc_usbfs_gintsts_field_t;

typedef struct
{
    uint32_t RESERVED0                      : 1;
    __IO uint32_t MMISM                     : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t SOFM                      : 1;
    __IO uint32_t RXFNEM                    : 1;
    __IO uint32_t NPTXFEM                   : 1;
    __IO uint32_t GINAKEFFM                 : 1;
    __IO uint32_t GONAKEFFM                 : 1;
    uint32_t RESERVED8                      : 2;
    __IO uint32_t ESUSPM                    : 1;
    __IO uint32_t USBSUSPM                  : 1;
    __IO uint32_t USBRSTM                   : 1;
    __IO uint32_t ENUMDNEM                  : 1;
    __IO uint32_t ISOODRPM                  : 1;
    __IO uint32_t EOPFM                     : 1;
    uint32_t RESERVED16                     : 2;
    __IO uint32_t IEPIM                     : 1;
    __IO uint32_t OEPIM                     : 1;
    __IO uint32_t IISOIXFRM                 : 1;
    __IO uint32_t IPXFRM_INCOMPISOOUTM      : 1;
    __IO uint32_t DATAFSUSPM                : 1;
    uint32_t RESERVED23                     : 1;
    __IO uint32_t HPRTIM                    : 1;
    __IO uint32_t HCIM                      : 1;
    __IO uint32_t PTXFEM                    : 1;
    uint32_t RESERVED27                     : 1;
    __IO uint32_t CIDSCHGM                  : 1;
    __IO uint32_t DISCIM                    : 1;
    __IO uint32_t VBUSVIM                   : 1;
    __IO uint32_t WKUIM                     : 1;
} stc_usbfs_gintmsk_field_t;

typedef struct
{
    __I  uint32_t CHNUM_EPNUM               : 4;
    __I  uint32_t BCNT                      :11;
    __I  uint32_t DPID                      : 2;
    __I  uint32_t PKTSTS                    : 4;
    uint32_t RESERVED21                     :11;
} stc_usbfs_grxstsr_field_t;

typedef struct
{
    __I  uint32_t CHNUM_EPNUM               : 4;
    __I  uint32_t BCNT                      :11;
    __I  uint32_t DPID                      : 2;
    __I  uint32_t PKTSTS                    : 4;
    uint32_t RESERVED21                     :11;
} stc_usbfs_grxstsp_field_t;

typedef struct
{
    __IO uint32_t RXFD                      :11;
    uint32_t RESERVED11                     :21;
} stc_usbfs_grxfsiz_field_t;

typedef struct
{
    __IO uint32_t NPTXFSA                   :16;
    __IO uint32_t NPTXFD                    :16;
} stc_usbfs_hnptxfsiz_field_t;

typedef struct
{
    __I  uint32_t NPTXFSAV                  :16;
    __I  uint32_t NPTQXSAV                  : 8;
    __I  uint32_t NPTXQTOP                  : 7;
    uint32_t RESERVED31                     : 1;
} stc_usbfs_hnptxsts_field_t;

typedef struct
{
    __IO uint32_t PTXSA                     :12;
    uint32_t RESERVED12                     : 4;
    __IO uint32_t PTXFD                     :11;
    uint32_t RESERVED27                     : 5;
} stc_usbfs_hptxfsiz_field_t;

typedef struct
{
    __IO uint32_t INEPTXSA                  :12;
    uint32_t RESERVED12                     : 4;
    __IO uint32_t INEPTXFD                  :10;
    uint32_t RESERVED26                     : 6;
} stc_usbfs_dieptxf_field_t;

typedef struct
{
    __IO uint32_t FSLSPCS                   : 2;
    __IO uint32_t FSLSS                     : 1;
    uint32_t RESERVED3                      :29;
} stc_usbfs_hcfg_field_t;

typedef struct
{
    __IO uint32_t FRIVL                     :16;
    uint32_t RESERVED16                     :16;
} stc_usbfs_hfir_field_t;

typedef struct
{
    __I  uint32_t FRNUM                     :16;
    __I  uint32_t FTREM                     :16;
} stc_usbfs_hfnum_field_t;

typedef struct
{
    __I  uint32_t PTXFSAVL                  :16;
    __I  uint32_t PTXQSAV                   : 8;
    __I  uint32_t PTXQTOP                   : 8;
} stc_usbfs_hptxsts_field_t;

typedef struct
{
    __I  uint32_t HAINT                     :12;
    uint32_t RESERVED12                     :20;
} stc_usbfs_haint_field_t;

typedef struct
{
    __IO uint32_t HAINTM                    :12;
    uint32_t RESERVED12                     :20;
} stc_usbfs_haintmsk_field_t;

typedef struct
{
    __I  uint32_t PCSTS                     : 1;
    __IO uint32_t PCDET                     : 1;
    __IO uint32_t PENA                      : 1;
    __IO uint32_t PENCHNG                   : 1;
    uint32_t RESERVED4                      : 2;
    __IO uint32_t PRES                      : 1;
    __IO uint32_t PSUSP                     : 1;
    __IO uint32_t PRST                      : 1;
    uint32_t RESERVED9                      : 1;
    __I  uint32_t PLSTS                     : 2;
    __IO uint32_t PWPR                      : 1;
    uint32_t RESERVED13                     : 4;
    __I  uint32_t PSPD                      : 2;
    uint32_t RESERVED19                     :13;
} stc_usbfs_hprt_field_t;

typedef struct
{
    __IO uint32_t MPSIZ                     :11;
    __IO uint32_t EPNUM                     : 4;
    __IO uint32_t EPDIR                     : 1;
    uint32_t RESERVED16                     : 1;
    __IO uint32_t LSDEV                     : 1;
    __I  uint32_t EPTYP                     : 2;
    uint32_t RESERVED20                     : 2;
    __IO uint32_t DAD                       : 7;
    __IO uint32_t ODDFRM                    : 1;
    __IO uint32_t CHDIS                     : 1;
    __IO uint32_t CHENA                     : 1;
} stc_usbfs_hcchar_field_t;

typedef struct
{
    __IO uint32_t XFRC                      : 1;
    __IO uint32_t CHH                       : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t STALL                     : 1;
    __IO uint32_t NAK                       : 1;
    __IO uint32_t ACK                       : 1;
    uint32_t RESERVED6                      : 1;
    __IO uint32_t TXERR                     : 1;
    __IO uint32_t BBERR                     : 1;
    __IO uint32_t FRMOR                     : 1;
    __IO uint32_t DTERR                     : 1;
    uint32_t RESERVED11                     :21;
} stc_usbfs_hcint_field_t;

typedef struct
{
    __IO uint32_t XFRCM                     : 1;
    __IO uint32_t CHHM                      : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t STALLM                    : 1;
    __IO uint32_t NAKM                      : 1;
    __IO uint32_t ACKM                      : 1;
    uint32_t RESERVED6                      : 1;
    __IO uint32_t TXERRM                    : 1;
    __IO uint32_t BBERRM                    : 1;
    __IO uint32_t FRMORM                    : 1;
    __IO uint32_t DTERRM                    : 1;
    uint32_t RESERVED11                     :21;
} stc_usbfs_hcintmsk_field_t;

typedef struct
{
    __IO uint32_t XFRSIZ                    :19;
    __IO uint32_t PKTCNT                    :10;
    __IO uint32_t DPID                      : 2;
    uint32_t RESERVED31                     : 1;
} stc_usbfs_hctsiz_field_t;

typedef struct
{
    __IO uint32_t DSPD                      : 2;
    __IO uint32_t NZLSOHSK                  : 1;
    uint32_t RESERVED3                      : 1;
    __IO uint32_t DAD                       : 7;
    __IO uint32_t PFIVL                     : 2;
    uint32_t RESERVED13                     :19;
} stc_usbfs_dcfg_field_t;

typedef struct
{
    __IO uint32_t RWUSIG                    : 1;
    __IO uint32_t SDIS                      : 1;
    __I  uint32_t GINSTS                    : 1;
    __I  uint32_t GONSTS                    : 1;
    uint32_t RESERVED4                      : 3;
    __O  uint32_t SGINAK                    : 1;
    __O  uint32_t CGINAK                    : 1;
    __O  uint32_t SGONAK                    : 1;
    __O  uint32_t CGONAK                    : 1;
    __IO uint32_t POPRGDNE                  : 1;
    uint32_t RESERVED12                     :20;
} stc_usbfs_dctl_field_t;

typedef struct
{
    __I  uint32_t SUSPSTS                   : 1;
    __I  uint32_t ENUMSPD                   : 2;
    __I  uint32_t EERR                      : 1;
    uint32_t RESERVED4                      : 4;
    __I  uint32_t FNSOF                     :14;
    uint32_t RESERVED22                     :10;
} stc_usbfs_dsts_field_t;

typedef struct
{
    __IO uint32_t XFRCM                     : 1;
    __IO uint32_t EPDM                      : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t TOM                       : 1;
    __IO uint32_t ITTXFEMSK                 : 1;
    __IO uint32_t INEPNMM                   : 1;
    __IO uint32_t INEPNEM                   : 1;
    uint32_t RESERVED7                      :25;
} stc_usbfs_diepmsk_field_t;

typedef struct
{
    __IO uint32_t XFRCM                     : 1;
    __IO uint32_t EPDM                      : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t STUPM                     : 1;
    __IO uint32_t OTEPDM                    : 1;
    uint32_t RESERVED5                      :27;
} stc_usbfs_doepmsk_field_t;

typedef struct
{
    __I  uint32_t IEPINT                    : 6;
    uint32_t RESERVED6                      :10;
    __I  uint32_t OEPINT                    : 6;
    uint32_t RESERVED22                     :10;
} stc_usbfs_daint_field_t;

typedef struct
{
    __I  uint32_t IEPINTM                   : 6;
    uint32_t RESERVED6                      :10;
    __I  uint32_t OEPINTM                   : 6;
    uint32_t RESERVED22                     :10;
} stc_usbfs_daintmsk_field_t;

typedef struct
{
    __IO uint32_t INEPTXFEM                 : 6;
    uint32_t RESERVED6                      :26;
} stc_usbfs_diepempmsk_field_t;

typedef struct
{
    __I  uint32_t MPSIZ                     : 2;
    uint32_t RESERVED2                      :13;
    __I  uint32_t USBAEP                    : 1;
    uint32_t RESERVED16                     : 1;
    __I  uint32_t NAKSTS                    : 1;
    __I  uint32_t EPTYP                     : 2;
    uint32_t RESERVED20                     : 1;
    __IO uint32_t STALL                     : 1;
    __IO uint32_t TXFNUM                    : 4;
    __O  uint32_t CNAK                      : 1;
    __O  uint32_t SNAK                      : 1;
    uint32_t RESERVED28                     : 2;
    __I  uint32_t EPDIS                     : 1;
    __IO uint32_t EPENA                     : 1;
} stc_usbfs_diepctl0_field_t;

typedef struct
{
    __IO uint32_t XFRC                      : 1;
    __IO uint32_t EPDISD                    : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t TOC                       : 1;
    __IO uint32_t TTXFE                     : 1;
    uint32_t RESERVED5                      : 1;
    __IO uint32_t INEPNE                    : 1;
    __I  uint32_t TXFE                      : 1;
    uint32_t RESERVED8                      :24;
} stc_usbfs_diepint0_field_t;

typedef struct
{
    __IO uint32_t XFRSIZ                    : 7;
    uint32_t RESERVED7                      :12;
    __IO uint32_t PKTCNT                    : 2;
    uint32_t RESERVED21                     :11;
} stc_usbfs_dieptsiz0_field_t;

typedef struct
{
    __I  uint32_t INEPTFSAV                 :16;
    uint32_t RESERVED16                     :16;
} stc_usbfs_dtxfsts0_field_t;

typedef struct
{
    __IO uint32_t MPSIZ                     :11;
    uint32_t RESERVED11                     : 4;
    __I  uint32_t USBAEP                    : 1;
    __I  uint32_t EONUM_DPID                : 1;
    __I  uint32_t NAKSTS                    : 1;
    __I  uint32_t EPTYP                     : 2;
    uint32_t RESERVED20                     : 1;
    __IO uint32_t STALL                     : 1;
    __IO uint32_t TXFNUM                    : 4;
    __O  uint32_t CNAK                      : 1;
    __O  uint32_t SNAK                      : 1;
    __O  uint32_t SD0PID_SEVNFRM            : 1;
    __O  uint32_t SODDFRM                   : 1;
    __I  uint32_t EPDIS                     : 1;
    __IO uint32_t EPENA                     : 1;
} stc_usbfs_diepctl_field_t;

typedef struct
{
    __IO uint32_t XFRC                      : 1;
    __IO uint32_t EPDISD                    : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t TOC                       : 1;
    __IO uint32_t TTXFE                     : 1;
    uint32_t RESERVED5                      : 1;
    __IO uint32_t INEPNE                    : 1;
    __I  uint32_t TXFE                      : 1;
    uint32_t RESERVED8                      :24;
} stc_usbfs_diepint_field_t;

typedef struct
{
    __IO uint32_t XFRSIZ                    :19;
    __IO uint32_t PKTCNT                    :10;
    uint32_t RESERVED29                     : 3;
} stc_usbfs_dieptsiz_field_t;

typedef struct
{
    __I  uint32_t INEPTFSAV                 :16;
    uint32_t RESERVED16                     :16;
} stc_usbfs_dtxfsts_field_t;

typedef struct
{
    __I  uint32_t MPSIZ                     : 2;
    uint32_t RESERVED2                      :13;
    __I  uint32_t USBAEP                    : 1;
    uint32_t RESERVED16                     : 1;
    __I  uint32_t NAKSTS                    : 1;
    __I  uint32_t EPTYP                     : 2;
    __IO uint32_t SNPM                      : 1;
    __IO uint32_t STALL                     : 1;
    uint32_t RESERVED22                     : 4;
    __O  uint32_t CNAK                      : 1;
    __O  uint32_t SNAK                      : 1;
    uint32_t RESERVED28                     : 2;
    __I  uint32_t EPDIS                     : 1;
    __IO uint32_t EPENA                     : 1;
} stc_usbfs_doepctl0_field_t;

typedef struct
{
    __IO uint32_t XFRC                      : 1;
    __IO uint32_t EPDISD                    : 1;
    uint32_t RESERVED2                      : 1;
    __IO uint32_t STUP                      : 1;
    __IO uint32_t OTEPDIS                   : 1;
    uint32_t RESERVED5                      : 1;
    __IO uint32_t B2BSTUP                   : 1;
    uint32_t RESERVED7                      :25;
} stc_usbfs_doepint_field_t;

typedef struct
{
    __IO uint32_t XFRSIZ                    : 7;
    uint32_t RESERVED7                      :12;
    __IO uint32_t PKTCNT                    : 1;
    uint32_t RESERVED20                     : 9;
    __IO uint32_t STUPCNT                   : 2;
    uint32_t RESERVED31                     : 1;
} stc_usbfs_doeptsiz0_field_t;

typedef struct
{
    __IO uint32_t MPSIZ                     :11;
    uint32_t RESERVED11                     : 4;
    __I  uint32_t USBAEP                    : 1;
    __I  uint32_t DPID                      : 1;
    __I  uint32_t NAKSTS                    : 1;
    __I  uint32_t EPTYP                     : 2;
    __IO uint32_t SNPM                      : 1;
    __IO uint32_t STALL                     : 1;
    uint32_t RESERVED22                     : 4;
    __O  uint32_t CNAK                      : 1;
    __O  uint32_t SNAK                      : 1;
    __IO uint32_t SD0PID                    : 1;
    __IO uint32_t SD1PID                    : 1;
    __I  uint32_t EPDIS                     : 1;
    __IO uint32_t EPENA                     : 1;
} stc_usbfs_doepctl_field_t;

typedef struct
{
    __IO uint32_t XFRSIZ                    :19;
    __IO uint32_t PKTCNT                    :10;
    uint32_t RESERVED29                     : 3;
} stc_usbfs_doeptsiz_field_t;

typedef struct
{
    __IO uint32_t STPPCLK                   : 1;
    __IO uint32_t GATEHCLK                  : 1;
    uint32_t RESERVED2                      :30;
} stc_usbfs_pcgcctl_field_t;

typedef struct
{
    __IO uint32_t PERI                      : 2;
    uint32_t RESERVED2                      : 2;
    __IO uint32_t CKS                       : 4;
    __IO uint32_t WDPT                      : 4;
    uint32_t RESERVED12                     : 4;
    __IO uint32_t SLPOFF                    : 1;
    uint32_t RESERVED17                     :14;
    __IO uint32_t ITS                       : 1;
} stc_wdt_cr_field_t;

typedef struct
{
    __I  uint32_t CNT                       :16;
    __IO uint32_t UDF                       : 1;
    __IO uint32_t REF                       : 1;
    uint32_t RESERVED18                     :14;
} stc_wdt_sr_field_t;

typedef struct
{
    __IO uint32_t RF                        :16;
    uint32_t RESERVED16                     :16;
} stc_wdt_rr_field_t;

typedef struct
{
    __IO uint16_t WKTMCMP                   :12;
    __IO uint16_t WKOVF                     : 1;
    __IO uint16_t WKCKS                     : 2;
    __IO uint16_t WKTCE                     : 1;
} stc_wktm_cr_field_t;


/**
 * @brief ADC
 */
typedef struct
{
    union
    {
        __IO uint8_t STR;
        stc_adc_str_field_t STR_f;
    };
    uint8_t RESERVED0[1];
    union
    {
        __IO uint16_t CR0;
        stc_adc_cr0_field_t CR0_f;
    };
    union
    {
        __IO uint16_t CR1;
        stc_adc_cr1_field_t CR1_f;
    };
    uint8_t RESERVED1[4];
    union
    {
        __IO uint16_t TRGSR;
        stc_adc_trgsr_field_t TRGSR_f;
    };
    __IO uint16_t CHSELRA0;
    union
    {
        __IO uint16_t CHSELRA1;
        stc_adc_chselra1_field_t CHSELRA1_f;
    };
    __IO uint16_t CHSELRB0;
    union
    {
        __IO uint16_t CHSELRB1;
        stc_adc_chselrb1_field_t CHSELRB1_f;
    };
    __IO uint16_t AVCHSELR0;
    union
    {
        __IO uint16_t AVCHSELR1;
        stc_adc_avchselr1_field_t AVCHSELR1_f;
    };
    uint8_t RESERVED2[8];
    __IO uint8_t SSTR0;
    __IO uint8_t SSTR1;
    __IO uint8_t SSTR2;
    __IO uint8_t SSTR3;
    __IO uint8_t SSTR4;
    __IO uint8_t SSTR5;
    __IO uint8_t SSTR6;
    __IO uint8_t SSTR7;
    __IO uint8_t SSTR8;
    __IO uint8_t SSTR9;
    __IO uint8_t SSTR10;
    __IO uint8_t SSTR11;
    __IO uint8_t SSTR12;
    __IO uint8_t SSTR13;
    __IO uint8_t SSTR14;
    __IO uint8_t SSTR15;
    __IO uint8_t SSTRL;
    uint8_t RESERVED3[7];
    union
    {
        __IO uint16_t CHMUXR0;
        stc_adc_chmuxr0_field_t CHMUXR0_f;
    };
    union
    {
        __IO uint16_t CHMUXR1;
        stc_adc_chmuxr1_field_t CHMUXR1_f;
    };
    union
    {
        __IO uint16_t CHMUXR2;
        stc_adc_chmuxr2_field_t CHMUXR2_f;
    };
    union
    {
        __IO uint16_t CHMUXR3;
        stc_adc_chmuxr3_field_t CHMUXR3_f;
    };
    uint8_t RESERVED4[6];
    union
    {
        __IO uint8_t ISR;
        stc_adc_isr_field_t ISR_f;
    };
    union
    {
        __IO uint8_t ICR;
        stc_adc_icr_field_t ICR_f;
    };
    uint8_t RESERVED5[4];
    union
    {
        __IO uint16_t SYNCCR;
        stc_adc_synccr_field_t SYNCCR_f;
    };
    uint8_t RESERVED6[2];
    __IO uint16_t DR0;
    __IO uint16_t DR1;
    __IO uint16_t DR2;
    __IO uint16_t DR3;
    __IO uint16_t DR4;
    __IO uint16_t DR5;
    __IO uint16_t DR6;
    __IO uint16_t DR7;
    __IO uint16_t DR8;
    __IO uint16_t DR9;
    __IO uint16_t DR10;
    __IO uint16_t DR11;
    __IO uint16_t DR12;
    __IO uint16_t DR13;
    __IO uint16_t DR14;
    __IO uint16_t DR15;
    __IO uint16_t DR16;
    uint8_t RESERVED7[46];
    union
    {
        __IO uint16_t AWDCR;
        stc_adc_awdcr_field_t AWDCR_f;
    };
    uint8_t RESERVED8[2];
    __IO uint16_t AWDDR0;
    __IO uint16_t AWDDR1;
    uint8_t RESERVED9[4];
    __IO uint16_t AWDCHSR0;
    union
    {
        __IO uint16_t AWDCHSR1;
        stc_adc_awdchsr1_field_t AWDCHSR1_f;
    };
    __IO uint16_t AWDSR0;
    union
    {
        __IO uint16_t AWDSR1;
        stc_adc_awdsr1_field_t AWDSR1_f;
    };
    uint8_t RESERVED10[12];
    union
    {
        __IO uint16_t PGACR;
        stc_adc_pgacr_field_t PGACR_f;
    };
    union
    {
        __IO uint16_t PGAGSR;
        stc_adc_pgagsr_field_t PGAGSR_f;
    };
    uint8_t RESERVED11[8];
    union
    {
        __IO uint16_t PGAINSR0;
        stc_adc_pgainsr0_field_t PGAINSR0_f;
    };
    union
    {
        __IO uint16_t PGAINSR1;
        stc_adc_pgainsr1_field_t PGAINSR1_f;
    };
} M4_ADC_TypeDef;

/**
 * @brief AES
 */
typedef struct
{
    union
    {
        __IO uint32_t CR;
        stc_aes_cr_field_t CR_f;
    };
    uint8_t RESERVED0[12];
    __IO uint32_t DR0;
    __IO uint32_t DR1;
    __IO uint32_t DR2;
    __IO uint32_t DR3;
    __IO uint32_t KR0;
    __IO uint32_t KR1;
    __IO uint32_t KR2;
    __IO uint32_t KR3;
} M4_AES_TypeDef;

/**
 * @brief AOS
 */
typedef struct
{
    union
    {
        __IO uint32_t INT_SFTTRG;
        stc_aos_int_sfttrg_field_t INT_SFTTRG_f;
    };
    union
    {
        __IO uint32_t DCU1_TRGSEL;
        stc_aos_dcu1_trgsel_field_t DCU1_TRGSEL_f;
    };
    union
    {
        __IO uint32_t DCU2_TRGSEL;
        stc_aos_dcu2_trgsel_field_t DCU2_TRGSEL_f;
    };
    union
    {
        __IO uint32_t DCU3_TRGSEL;
        stc_aos_dcu3_trgsel_field_t DCU3_TRGSEL_f;
    };
    union
    {
        __IO uint32_t DCU4_TRGSEL;
        stc_aos_dcu4_trgsel_field_t DCU4_TRGSEL_f;
    };
    union
    {
        __IO uint32_t DMA1_TRGSEL0;
        stc_aos_dma1_trgsel_field_t DMA1_TRGSEL0_f;
    };
    union
    {
        __IO uint32_t DMA1_TRGSEL1;
        stc_aos_dma1_trgsel_field_t DMA1_TRGSEL1_f;
    };
    union
    {
        __IO uint32_t DMA1_TRGSEL2;
        stc_aos_dma1_trgsel_field_t DMA1_TRGSEL2_f;
    };
    union
    {
        __IO uint32_t DMA1_TRGSEL3;
        stc_aos_dma1_trgsel3_field_t DMA1_TRGSEL3_f;
    };
    union
    {
        __IO uint32_t DMA2_TRGSEL0;
        stc_aos_dma2_trgsel_field_t DMA2_TRGSEL0_f;
    };
    union
    {
        __IO uint32_t DMA2_TRGSEL1;
        stc_aos_dma2_trgsel_field_t DMA2_TRGSEL1_f;
    };
    union
    {
        __IO uint32_t DMA2_TRGSEL2;
        stc_aos_dma2_trgsel_field_t DMA2_TRGSEL2_f;
    };
    union
    {
        __IO uint32_t DMA2_TRGSEL3;
        stc_aos_dma2_trgsel_field_t DMA2_TRGSEL3_f;
    };
    union
    {
        __IO uint32_t DMA_TRGSELRC;
        stc_aos_dma_trgselrc_field_t DMA_TRGSELRC_f;
    };
    union
    {
        __IO uint32_t TMR6_HTSSR0;
        stc_aos_tmr6_htssr_field_t TMR6_HTSSR0_f;
    };
    union
    {
        __IO uint32_t TMR6_HTSSR1;
        stc_aos_tmr6_htssr_field_t TMR6_HTSSR1_f;
    };
    union
    {
        __IO uint32_t TMR0_HTSSR;
        stc_aos_tmr0_htssr_field_t TMR0_HTSSR_f;
    };
    union
    {
        __IO uint32_t PEVNTTRGSR12;
        stc_aos_pevnttrgsr12_field_t PEVNTTRGSR12_f;
    };
    union
    {
        __IO uint32_t PEVNTTRGSR34;
        stc_aos_pevnttrgsr34_field_t PEVNTTRGSR34_f;
    };
    union
    {
        __IO uint32_t TMRA_HTSSR0;
        stc_aos_tmra_htssr_field_t TMRA_HTSSR0_f;
    };
    union
    {
        __IO uint32_t TMRA_HTSSR1;
        stc_aos_tmra_htssr_field_t TMRA_HTSSR1_f;
    };
    union
    {
        __IO uint32_t OTS_TRG;
        stc_aos_ots_trg_field_t OTS_TRG_f;
    };
    union
    {
        __IO uint32_t ADC1_ITRGSELR0;
        stc_aos_adc1_itrgselr_field_t ADC1_ITRGSELR0_f;
    };
    union
    {
        __IO uint32_t ADC1_ITRGSELR1;
        stc_aos_adc1_itrgselr_field_t ADC1_ITRGSELR1_f;
    };
    union
    {
        __IO uint32_t ADC2_ITRGSELR0;
        stc_aos_adc2_itrgselr_field_t ADC2_ITRGSELR0_f;
    };
    union
    {
        __IO uint32_t ADC2_ITRGSELR1;
        stc_aos_adc2_itrgselr_field_t ADC2_ITRGSELR1_f;
    };
    union
    {
        __IO uint32_t COMTRG1;
        stc_aos_comtrg1_field_t COMTRG1_f;
    };
    union
    {
        __IO uint32_t COMTRG2;
        stc_aos_comtrg2_field_t COMTRG2_f;
    };
    uint8_t RESERVED0[144];
    union
    {
        __IO uint32_t PEVNTDIRR1;
        stc_aos_pevntdirr_field_t PEVNTDIRR1_f;
    };
    union
    {
        __IO uint32_t PEVNTIDR1;
        stc_aos_pevntidr_field_t PEVNTIDR1_f;
    };
    union
    {
        __IO uint32_t PEVNTODR1;
        stc_aos_pevntodr_field_t PEVNTODR1_f;
    };
    union
    {
        __IO uint32_t PEVNTORR1;
        stc_aos_pevntorr_field_t PEVNTORR1_f;
    };
    union
    {
        __IO uint32_t PEVNTOSR1;
        stc_aos_pevntosr_field_t PEVNTOSR1_f;
    };
    union
    {
        __IO uint32_t PEVNTRISR1;
        stc_aos_pevntrisr_field_t PEVNTRISR1_f;
    };
    union
    {
        __IO uint32_t PEVNTFAL1;
        stc_aos_pevntfal_field_t PEVNTFAL1_f;
    };
    union
    {
        __IO uint32_t PEVNTDIRR2;
        stc_aos_pevntdirr_field_t PEVNTDIRR2_f;
    };
    union
    {
        __IO uint32_t PEVNTIDR2;
        stc_aos_pevntidr_field_t PEVNTIDR2_f;
    };
    union
    {
        __IO uint32_t PEVNTODR2;
        stc_aos_pevntodr_field_t PEVNTODR2_f;
    };
    union
    {
        __IO uint32_t PEVNTORR2;
        stc_aos_pevntorr_field_t PEVNTORR2_f;
    };
    union
    {
        __IO uint32_t PEVNTOSR2;
        stc_aos_pevntosr_field_t PEVNTOSR2_f;
    };
    union
    {
        __IO uint32_t PEVNTRISR2;
        stc_aos_pevntrisr_field_t PEVNTRISR2_f;
    };
    union
    {
        __IO uint32_t PEVNTFAL2;
        stc_aos_pevntfal_field_t PEVNTFAL2_f;
    };
    union
    {
        __IO uint32_t PEVNTDIRR3;
        stc_aos_pevntdirr_field_t PEVNTDIRR3_f;
    };
    union
    {
        __IO uint32_t PEVNTIDR3;
        stc_aos_pevntidr_field_t PEVNTIDR3_f;
    };
    union
    {
        __IO uint32_t PEVNTODR3;
        stc_aos_pevntodr_field_t PEVNTODR3_f;
    };
    union
    {
        __IO uint32_t PEVNTORR3;
        stc_aos_pevntorr_field_t PEVNTORR3_f;
    };
    union
    {
        __IO uint32_t PEVNTOSR3;
        stc_aos_pevntosr_field_t PEVNTOSR3_f;
    };
    union
    {
        __IO uint32_t PEVNTRISR3;
        stc_aos_pevntrisr_field_t PEVNTRISR3_f;
    };
    union
    {
        __IO uint32_t PEVNTFAL3;
        stc_aos_pevntfal_field_t PEVNTFAL3_f;
    };
    union
    {
        __IO uint32_t PEVNTDIRR4;
        stc_aos_pevntdirr_field_t PEVNTDIRR4_f;
    };
    union
    {
        __IO uint32_t PEVNTIDR4;
        stc_aos_pevntidr_field_t PEVNTIDR4_f;
    };
    union
    {
        __IO uint32_t PEVNTODR4;
        stc_aos_pevntodr_field_t PEVNTODR4_f;
    };
    union
    {
        __IO uint32_t PEVNTORR4;
        stc_aos_pevntorr_field_t PEVNTORR4_f;
    };
    union
    {
        __IO uint32_t PEVNTOSR4;
        stc_aos_pevntosr_field_t PEVNTOSR4_f;
    };
    union
    {
        __IO uint32_t PEVNTRISR4;
        stc_aos_pevntrisr_field_t PEVNTRISR4_f;
    };
    union
    {
        __IO uint32_t PEVNTFAL4;
        stc_aos_pevntfal_field_t PEVNTFAL4_f;
    };
    union
    {
        __IO uint32_t PEVNTNFCR;
        stc_aos_pevntnfcr_field_t PEVNTNFCR_f;
    };
} M4_AOS_TypeDef;

/**
 * @brief CAN
 */
typedef struct
{
    __IO uint32_t RBUF;
    uint8_t RESERVED0[76];
    __IO uint32_t TBUF;
    uint8_t RESERVED1[76];
    union
    {
        __IO uint8_t CFG_STAT;
        stc_can_cfg_stat_field_t CFG_STAT_f;
    };
    union
    {
        __IO uint8_t TCMD;
        stc_can_tcmd_field_t TCMD_f;
    };
    union
    {
        __IO uint8_t TCTRL;
        stc_can_tctrl_field_t TCTRL_f;
    };
    union
    {
        __IO uint8_t RCTRL;
        stc_can_rctrl_field_t RCTRL_f;
    };
    union
    {
        __IO uint8_t RTIE;
        stc_can_rtie_field_t RTIE_f;
    };
    union
    {
        __IO uint8_t RTIF;
        stc_can_rtif_field_t RTIF_f;
    };
    union
    {
        __IO uint8_t ERRINT;
        stc_can_errint_field_t ERRINT_f;
    };
    union
    {
        __IO uint8_t LIMIT;
        stc_can_limit_field_t LIMIT_f;
    };
    union
    {
        __IO uint32_t BT;
        stc_can_bt_field_t BT_f;
    };
    uint8_t RESERVED2[4];
    union
    {
        __IO uint8_t EALCAP;
        stc_can_ealcap_field_t EALCAP_f;
    };
    uint8_t RESERVED3[1];
    __IO uint8_t RECNT;
    __IO uint8_t TECNT;
    union
    {
        __IO uint8_t ACFCTRL;
        stc_can_acfctrl_field_t ACFCTRL_f;
    };
    uint8_t RESERVED4[1];
    union
    {
        __IO uint8_t ACFEN;
        stc_can_acfen_field_t ACFEN_f;
    };
    uint8_t RESERVED5[1];
    union
    {
        __IO uint32_t ACF;
        stc_can_acf_field_t ACF_f;
    };
    uint8_t RESERVED6[2];
    union
    {
        __IO uint8_t TBSLOT;
        stc_can_tbslot_field_t TBSLOT_f;
    };
    union
    {
        __IO uint8_t TTCFG;
        stc_can_ttcfg_field_t TTCFG_f;
    };
    union
    {
        __IO uint32_t REF_MSG;
        stc_can_ref_msg_field_t REF_MSG_f;
    };
    union
    {
        __IO uint16_t TRG_CFG;
        stc_can_trg_cfg_field_t TRG_CFG_f;
    };
    __IO uint16_t TT_TRIG;
    __IO uint16_t TT_WTRIG;
} M4_CAN_TypeDef;

/**
 * @brief CMP
 */
typedef struct
{
    union
    {
        __IO uint16_t CTRL;
        stc_cmp_ctrl_field_t CTRL_f;
    };
    union
    {
        __IO uint16_t VLTSEL;
        stc_cmp_vltsel_field_t VLTSEL_f;
    };
    union
    {
        __IO uint16_t OUTMON;
        stc_cmp_outmon_field_t OUTMON_f;
    };
    union
    {
        __IO uint16_t CVSSTB;
        stc_cmp_cvsstb_field_t CVSSTB_f;
    };
    union
    {
        __IO uint16_t CVSPRD;
        stc_cmp_cvsprd_field_t CVSPRD_f;
    };
} M4_CMP_TypeDef;

/**
 * @brief CMP_CR
 */
typedef struct
{
    uint8_t RESERVED0[256];
    union
    {
        __IO uint16_t DADR1;
        stc_cmp_cr_dadr1_field_t DADR1_f;
    };
    union
    {
        __IO uint16_t DADR2;
        stc_cmp_cr_dadr2_field_t DADR2_f;
    };
    uint8_t RESERVED1[4];
    union
    {
        __IO uint16_t DACR;
        stc_cmp_cr_dacr_field_t DACR_f;
    };
    uint8_t RESERVED2[2];
    union
    {
        __IO uint16_t RVADC;
        stc_cmp_cr_rvadc_field_t RVADC_f;
    };
} M4_CMP_CR_TypeDef;

/**
 * @brief CRC
 */
typedef struct
{
    union
    {
        __IO uint32_t CR;
        stc_crc_cr_field_t CR_f;
    };
    union
    {
        __IO uint32_t RESLT;
        stc_crc_reslt_field_t RESLT_f;
    };
    uint8_t RESERVED0[4];
    union
    {
        __IO uint32_t FLG;
        stc_crc_flg_field_t FLG_f;
    };
    uint8_t RESERVED1[112];
    __IO uint32_t DAT0;
    __IO uint32_t DAT1;
    __IO uint32_t DAT2;
    __IO uint32_t DAT3;
    __IO uint32_t DAT4;
    __IO uint32_t DAT5;
    __IO uint32_t DAT6;
    __IO uint32_t DAT7;
    __IO uint32_t DAT8;
    __IO uint32_t DAT9;
    __IO uint32_t DAT10;
    __IO uint32_t DAT11;
    __IO uint32_t DAT12;
    __IO uint32_t DAT13;
    __IO uint32_t DAT14;
    __IO uint32_t DAT15;
    __IO uint32_t DAT16;
    __IO uint32_t DAT17;
    __IO uint32_t DAT18;
    __IO uint32_t DAT19;
    __IO uint32_t DAT20;
    __IO uint32_t DAT21;
    __IO uint32_t DAT22;
    __IO uint32_t DAT23;
    __IO uint32_t DAT24;
    __IO uint32_t DAT25;
    __IO uint32_t DAT26;
    __IO uint32_t DAT27;
    __IO uint32_t DAT28;
    __IO uint32_t DAT29;
    __IO uint32_t DAT30;
    __IO uint32_t DAT31;
} M4_CRC_TypeDef;

/**
 * @brief DBGC
 */
typedef struct
{
    __IO uint32_t AUTHID0;
    __IO uint32_t AUTHID1;
    __IO uint32_t AUTHID2;
    __IO uint32_t RESV0;
    union
    {
        __IO uint32_t MCUSTAT;
        stc_dbgc_mcustat_field_t MCUSTAT_f;
    };
    union
    {
        __IO uint32_t MCUCTL;
        stc_dbgc_mcuctl_field_t MCUCTL_f;
    };
    union
    {
        __IO uint32_t FMCCTL;
        stc_dbgc_fmcctl_field_t FMCCTL_f;
    };
    union
    {
        __IO uint32_t MCUDBGSTAT;
        stc_dbgc_mcudbgstat_field_t MCUDBGSTAT_f;
    };
    union
    {
        __IO uint32_t MCUSTPCTL;
        stc_dbgc_mcustpctl_field_t MCUSTPCTL_f;
    };
    union
    {
        __IO uint32_t MCUTRACECTL;
        stc_dbgc_mcutracectl_field_t MCUTRACECTL_f;
    };
} M4_DBGC_TypeDef;

/**
 * @brief DCU
 */
typedef struct
{
    union
    {
        __IO uint32_t CTL;
        stc_dcu_ctl_field_t CTL_f;
    };
    union
    {
        __IO uint32_t FLAG;
        stc_dcu_flag_field_t FLAG_f;
    };
    __IO uint32_t DATA0;
    __IO uint32_t DATA1;
    __IO uint32_t DATA2;
    union
    {
        __IO uint32_t FLAGCLR;
        stc_dcu_flagclr_field_t FLAGCLR_f;
    };
    union
    {
        __IO uint32_t INTSEL;
        stc_dcu_intsel_field_t INTSEL_f;
    };
} M4_DCU_TypeDef;

/**
 * @brief DMA
 */
typedef struct
{
    union
    {
        __IO uint32_t EN;
        stc_dma_en_field_t EN_f;
    };
    union
    {
        __IO uint32_t INTSTAT0;
        stc_dma_intstat0_field_t INTSTAT0_f;
    };
    union
    {
        __IO uint32_t INTSTAT1;
        stc_dma_intstat1_field_t INTSTAT1_f;
    };
    union
    {
        __IO uint32_t INTMASK0;
        stc_dma_intmask0_field_t INTMASK0_f;
    };
    union
    {
        __IO uint32_t INTMASK1;
        stc_dma_intmask1_field_t INTMASK1_f;
    };
    union
    {
        __IO uint32_t INTCLR0;
        stc_dma_intclr0_field_t INTCLR0_f;
    };
    union
    {
        __IO uint32_t INTCLR1;
        stc_dma_intclr1_field_t INTCLR1_f;
    };
    union
    {
        __IO uint32_t CHEN;
        stc_dma_chen_field_t CHEN_f;
    };
    union
    {
        __IO uint32_t REQSTAT;
        stc_dma_reqstat_field_t REQSTAT_f;
    };
    union
    {
        __IO uint32_t CHSTAT;
        stc_dma_chstat_field_t CHSTAT_f;
    };
    uint8_t RESERVED0[4];
    union
    {
        __IO uint32_t RCFGCTL;
        stc_dma_rcfgctl_field_t RCFGCTL_f;
    };
    uint8_t RESERVED1[16];
    __IO uint32_t SAR0;
    __IO uint32_t DAR0;
    union
    {
        __IO uint32_t DTCTL0;
        stc_dma_dtctl_field_t DTCTL0_f;
    };
    union
    {
        __IO uint32_t RPT0;
        stc_dma_rpt_field_t RPT0_f;
        __IO uint32_t RPTB0;
        stc_dma_rptb_field_t RPTB0_f;
    };
    union
    {
        __IO uint32_t SNSEQCTL0;
        stc_dma_snseqctl_field_t SNSEQCTL0_f;
        __IO uint32_t SNSEQCTLB0;
        stc_dma_snseqctlb_field_t SNSEQCTLB0_f;
    };
    union
    {
        __IO uint32_t DNSEQCTL0;
        stc_dma_dnseqctl_field_t DNSEQCTL0_f;
        __IO uint32_t DNSEQCTLB0;
        stc_dma_dnseqctlb_field_t DNSEQCTLB0_f;
    };
    union
    {
        __IO uint32_t LLP0;
        stc_dma_llp_field_t LLP0_f;
    };
    union
    {
        __IO uint32_t CHCTL0;
        stc_dma_chctl_field_t CHCTL0_f;
    };
    __IO uint32_t MONSAR0;
    __IO uint32_t MONDAR0;
    union
    {
        __IO uint32_t MONDTCTL0;
        stc_dma_mondtctl_field_t MONDTCTL0_f;
    };
    union
    {
        __IO uint32_t MONRPT0;
        stc_dma_monrpt_field_t MONRPT0_f;
    };
    union
    {
        __IO uint32_t MONSNSEQCTL0;
        stc_dma_monsnseqctl_field_t MONSNSEQCTL0_f;
    };
    union
    {
        __IO uint32_t MONDNSEQCTL0;
        stc_dma_mondnseqctl_field_t MONDNSEQCTL0_f;
    };
    uint8_t RESERVED2[8];
    __IO uint32_t SAR1;
    __IO uint32_t DAR1;
    union
    {
        __IO uint32_t DTCTL1;
        stc_dma_dtctl_field_t DTCTL1_f;
    };
    union
    {
        __IO uint32_t RPT1;
        stc_dma_rpt_field_t RPT1_f;
        __IO uint32_t RPTB1;
        stc_dma_rptb_field_t RPTB1_f;
    };
    union
    {
        __IO uint32_t SNSEQCTL1;
        stc_dma_snseqctl_field_t SNSEQCTL1_f;
        __IO uint32_t SNSEQCTLB1;
        stc_dma_snseqctlb_field_t SNSEQCTLB1_f;
    };
    union
    {
        __IO uint32_t DNSEQCTL1;
        stc_dma_dnseqctl_field_t DNSEQCTL1_f;
        __IO uint32_t DNSEQCTLB1;
        stc_dma_dnseqctlb_field_t DNSEQCTLB1_f;
    };
    union
    {
        __IO uint32_t LLP1;
        stc_dma_llp_field_t LLP1_f;
    };
    union
    {
        __IO uint32_t CHCTL1;
        stc_dma_chctl_field_t CHCTL1_f;
    };
    __IO uint32_t MONSAR1;
    __IO uint32_t MONDAR1;
    union
    {
        __IO uint32_t MONDTCTL1;
        stc_dma_mondtctl_field_t MONDTCTL1_f;
    };
    union
    {
        __IO uint32_t MONRPT1;
        stc_dma_monrpt_field_t MONRPT1_f;
    };
    union
    {
        __IO uint32_t MONSNSEQCTL1;
        stc_dma_monsnseqctl_field_t MONSNSEQCTL1_f;
    };
    union
    {
        __IO uint32_t MONDNSEQCTL1;
        stc_dma_mondnseqctl_field_t MONDNSEQCTL1_f;
    };
    uint8_t RESERVED3[8];
    __IO uint32_t SAR2;
    __IO uint32_t DAR2;
    union
    {
        __IO uint32_t DTCTL2;
        stc_dma_dtctl_field_t DTCTL2_f;
    };
    union
    {
        __IO uint32_t RPT2;
        stc_dma_rpt_field_t RPT2_f;
        __IO uint32_t RPTB2;
        stc_dma_rptb_field_t RPTB2_f;
    };
    union
    {
        __IO uint32_t SNSEQCTL2;
        stc_dma_snseqctl_field_t SNSEQCTL2_f;
        __IO uint32_t SNSEQCTLB2;
        stc_dma_snseqctlb_field_t SNSEQCTLB2_f;
    };
    union
    {
        __IO uint32_t DNSEQCTL2;
        stc_dma_dnseqctl_field_t DNSEQCTL2_f;
        __IO uint32_t DNSEQCTLB2;
        stc_dma_dnseqctlb_field_t DNSEQCTLB2_f;
    };
    union
    {
        __IO uint32_t LLP2;
        stc_dma_llp_field_t LLP2_f;
    };
    union
    {
        __IO uint32_t CHCTL2;
        stc_dma_chctl_field_t CHCTL2_f;
    };
    __IO uint32_t MONSAR2;
    __IO uint32_t MONDAR2;
    union
    {
        __IO uint32_t MONDTCTL2;
        stc_dma_mondtctl_field_t MONDTCTL2_f;
    };
    union
    {
        __IO uint32_t MONRPT2;
        stc_dma_monrpt_field_t MONRPT2_f;
    };
    union
    {
        __IO uint32_t MONSNSEQCTL2;
        stc_dma_monsnseqctl_field_t MONSNSEQCTL2_f;
    };
    union
    {
        __IO uint32_t MONDNSEQCTL2;
        stc_dma_mondnseqctl_field_t MONDNSEQCTL2_f;
    };
    uint8_t RESERVED4[8];
    __IO uint32_t SAR3;
    __IO uint32_t DAR3;
    union
    {
        __IO uint32_t DTCTL3;
        stc_dma_dtctl_field_t DTCTL3_f;
    };
    union
    {
        __IO uint32_t RPT3;
        stc_dma_rpt_field_t RPT3_f;
        __IO uint32_t RPTB3;
        stc_dma_rptb_field_t RPTB3_f;
    };
    union
    {
        __IO uint32_t SNSEQCTL3;
        stc_dma_snseqctl_field_t SNSEQCTL3_f;
        __IO uint32_t SNSEQCTLB3;
        stc_dma_snseqctlb_field_t SNSEQCTLB3_f;
    };
    union
    {
        __IO uint32_t DNSEQCTL3;
        stc_dma_dnseqctl_field_t DNSEQCTL3_f;
        __IO uint32_t DNSEQCTLB3;
        stc_dma_dnseqctlb_field_t DNSEQCTLB3_f;
    };
    union
    {
        __IO uint32_t LLP3;
        stc_dma_llp_field_t LLP3_f;
    };
    union
    {
        __IO uint32_t CHCTL3;
        stc_dma_chctl_field_t CHCTL3_f;
    };
    __IO uint32_t MONSAR3;
    __IO uint32_t MONDAR3;
    union
    {
        __IO uint32_t MONDTCTL3;
        stc_dma_mondtctl_field_t MONDTCTL3_f;
    };
    union
    {
        __IO uint32_t MONRPT3;
        stc_dma_monrpt_field_t MONRPT3_f;
    };
    union
    {
        __IO uint32_t MONSNSEQCTL3;
        stc_dma_monsnseqctl_field_t MONSNSEQCTL3_f;
    };
    union
    {
        __IO uint32_t MONDNSEQCTL3;
        stc_dma_mondnseqctl_field_t MONDNSEQCTL3_f;
    };
} M4_DMA_TypeDef;

/**
 * @brief EFM
 */
typedef struct
{
    union
    {
        __IO uint32_t FAPRT;
        stc_efm_faprt_field_t FAPRT_f;
    };
    union
    {
        __IO uint32_t FSTP;
        stc_efm_fstp_field_t FSTP_f;
    };
    union
    {
        __IO uint32_t FRMC;
        stc_efm_frmc_field_t FRMC_f;
    };
    union
    {
        __IO uint32_t FWMC;
        stc_efm_fwmc_field_t FWMC_f;
    };
    union
    {
        __IO uint32_t FSR;
        stc_efm_fsr_field_t FSR_f;
    };
    union
    {
        __IO uint32_t FSCLR;
        stc_efm_fsclr_field_t FSCLR_f;
    };
    union
    {
        __IO uint32_t FITE;
        stc_efm_fite_field_t FITE_f;
    };
    union
    {
        __IO uint32_t FSWP;
        stc_efm_fswp_field_t FSWP_f;
    };
    union
    {
        __IO uint32_t FPMTSW;
        stc_efm_fpmtsw_field_t FPMTSW_f;
    };
    union
    {
        __IO uint32_t FPMTEW;
        stc_efm_fpmtew_field_t FPMTEW_f;
    };
    uint8_t RESERVED0[40];
    __IO uint32_t UQID1;
    __IO uint32_t UQID2;
    __IO uint32_t UQID3;
    uint8_t RESERVED1[164];
    union
    {
        __IO uint32_t MMF_REMPRT;
        stc_efm_mmf_remprt_field_t MMF_REMPRT_f;
    };
    union
    {
        __IO uint32_t MMF_REMCR0;
        stc_efm_mmf_remcr0_field_t MMF_REMCR0_f;
    };
    union
    {
        __IO uint32_t MMF_REMCR1;
        stc_efm_mmf_remcr1_field_t MMF_REMCR1_f;
    };
    uint8_t RESERVED2[248];
    union
    {
        __IO uint32_t FRANDS;
        stc_efm_frands_field_t FRANDS_f;
    };
} M4_EFM_TypeDef;

/**
 * @brief EMB
 */
typedef struct
{
    union
    {
        __IO uint32_t CTL;
        stc_emb_ctl_field_t CTL_f;
    };
    union
    {
        __IO uint32_t PWMLV;
        stc_emb_pwmlv_field_t PWMLV_f;
    };
    union
    {
        __IO uint32_t SOE;
        stc_emb_soe_field_t SOE_f;
    };
    union
    {
        __IO uint32_t STAT;
        stc_emb_stat_field_t STAT_f;
    };
    union
    {
        __IO uint32_t STATCLR;
        stc_emb_statclr_field_t STATCLR_f;
    };
    union
    {
        __IO uint32_t INTEN;
        stc_emb_inten_field_t INTEN_f;
    };
} M4_EMB_TypeDef;

/**
 * @brief FCM
 */
typedef struct
{
    union
    {
        __IO uint32_t LVR;
        stc_fcm_lvr_field_t LVR_f;
    };
    union
    {
        __IO uint32_t UVR;
        stc_fcm_uvr_field_t UVR_f;
    };
    union
    {
        __IO uint32_t CNTR;
        stc_fcm_cntr_field_t CNTR_f;
    };
    union
    {
        __IO uint32_t STR;
        stc_fcm_str_field_t STR_f;
    };
    union
    {
        __IO uint32_t MCCR;
        stc_fcm_mccr_field_t MCCR_f;
    };
    union
    {
        __IO uint32_t RCCR;
        stc_fcm_rccr_field_t RCCR_f;
    };
    union
    {
        __IO uint32_t RIER;
        stc_fcm_rier_field_t RIER_f;
    };
    union
    {
        __IO uint32_t SR;
        stc_fcm_sr_field_t SR_f;
    };
    union
    {
        __IO uint32_t CLR;
        stc_fcm_clr_field_t CLR_f;
    };
} M4_FCM_TypeDef;

/**
 * @brief HASH
 */
typedef struct
{
    union
    {
        __IO uint32_t CR;
        stc_hash_cr_field_t CR_f;
    };
    uint8_t RESERVED0[12];
    __IO uint32_t HR7;
    __IO uint32_t HR6;
    __IO uint32_t HR5;
    __IO uint32_t HR4;
    __IO uint32_t HR3;
    __IO uint32_t HR2;
    __IO uint32_t HR1;
    __IO uint32_t HR0;
    uint8_t RESERVED1[16];
    __IO uint32_t DR15;
    __IO uint32_t DR14;
    __IO uint32_t DR13;
    __IO uint32_t DR12;
    __IO uint32_t DR11;
    __IO uint32_t DR10;
    __IO uint32_t DR9;
    __IO uint32_t DR8;
    __IO uint32_t DR7;
    __IO uint32_t DR6;
    __IO uint32_t DR5;
    __IO uint32_t DR4;
    __IO uint32_t DR3;
    __IO uint32_t DR2;
    __IO uint32_t DR1;
    __IO uint32_t DR0;
} M4_HASH_TypeDef;

/**
 * @brief I2C
 */
typedef struct
{
    union
    {
        __IO uint32_t CR1;
        stc_i2c_cr1_field_t CR1_f;
    };
    union
    {
        __IO uint32_t CR2;
        stc_i2c_cr2_field_t CR2_f;
    };
    union
    {
        __IO uint32_t CR3;
        stc_i2c_cr3_field_t CR3_f;
    };
    union
    {
        __IO uint32_t CR4;
        stc_i2c_cr4_field_t CR4_f;
    };
    union
    {
        __IO uint32_t SLR0;
        stc_i2c_slr0_field_t SLR0_f;
    };
    union
    {
        __IO uint32_t SLR1;
        stc_i2c_slr1_field_t SLR1_f;
    };
    union
    {
        __IO uint32_t SLTR;
        stc_i2c_sltr_field_t SLTR_f;
    };
    union
    {
        __IO uint32_t SR;
        stc_i2c_sr_field_t SR_f;
    };
    union
    {
        __IO uint32_t CLR;
        stc_i2c_clr_field_t CLR_f;
    };
    union
    {
        __IO uint8_t DTR;
        stc_i2c_dtr_field_t DTR_f;
    };
    uint8_t RESERVED0[3];
    union
    {
        __IO uint8_t DRR;
        stc_i2c_drr_field_t DRR_f;
    };
    uint8_t RESERVED1[3];
    union
    {
        __IO uint32_t CCR;
        stc_i2c_ccr_field_t CCR_f;
    };
    union
    {
        __IO uint32_t FLTR;
        stc_i2c_fltr_field_t FLTR_f;
    };
} M4_I2C_TypeDef;

/**
 * @brief I2S
 */
typedef struct
{
    union
    {
        __IO uint32_t CTRL;
        stc_i2s_ctrl_field_t CTRL_f;
    };
    union
    {
        __IO uint32_t SR;
        stc_i2s_sr_field_t SR_f;
    };
    union
    {
        __IO uint32_t ER;
        stc_i2s_er_field_t ER_f;
    };
    union
    {
        __IO uint32_t CFGR;
        stc_i2s_cfgr_field_t CFGR_f;
    };
    __IO uint32_t TXBUF;
    __IO uint32_t RXBUF;
    union
    {
        __IO uint32_t PR;
        stc_i2s_pr_field_t PR_f;
    };
} M4_I2S_TypeDef;

/**
 * @brief ICG
 */
typedef struct
{
    union
    {
        __IO uint32_t ICG0;
        stc_icg_icg0_field_t ICG0_f;
    };
    union
    {
        __IO uint32_t ICG1;
        stc_icg_icg1_field_t ICG1_f;
    };
    __IO uint32_t ICG2;
    __IO uint32_t ICG3;
    __IO uint32_t ICG4;
    __IO uint32_t ICG5;
    __IO uint32_t ICG6;
    __IO uint32_t ICG7;
} M4_ICG_TypeDef;

/**
 * @brief INTC
 */
typedef struct
{
    union
    {
        __IO uint32_t NMICR;
        stc_intc_nmicr_field_t NMICR_f;
    };
    union
    {
        __IO uint32_t NMIENR;
        stc_intc_nmienr_field_t NMIENR_f;
    };
    union
    {
        __IO uint32_t NMIFR;
        stc_intc_nmifr_field_t NMIFR_f;
    };
    union
    {
        __IO uint32_t NMICFR;
        stc_intc_nmicfr_field_t NMICFR_f;
    };
    union
    {
        __IO uint32_t EIRQCR0;
        stc_intc_eirqcr_field_t EIRQCR0_f;
    };
    union
    {
        __IO uint32_t EIRQCR1;
        stc_intc_eirqcr_field_t EIRQCR1_f;
    };
    union
    {
        __IO uint32_t EIRQCR2;
        stc_intc_eirqcr_field_t EIRQCR2_f;
    };
    union
    {
        __IO uint32_t EIRQCR3;
        stc_intc_eirqcr_field_t EIRQCR3_f;
    };
    union
    {
        __IO uint32_t EIRQCR4;
        stc_intc_eirqcr_field_t EIRQCR4_f;
    };
    union
    {
        __IO uint32_t EIRQCR5;
        stc_intc_eirqcr_field_t EIRQCR5_f;
    };
    union
    {
        __IO uint32_t EIRQCR6;
        stc_intc_eirqcr_field_t EIRQCR6_f;
    };
    union
    {
        __IO uint32_t EIRQCR7;
        stc_intc_eirqcr_field_t EIRQCR7_f;
    };
    union
    {
        __IO uint32_t EIRQCR8;
        stc_intc_eirqcr_field_t EIRQCR8_f;
    };
    union
    {
        __IO uint32_t EIRQCR9;
        stc_intc_eirqcr_field_t EIRQCR9_f;
    };
    union
    {
        __IO uint32_t EIRQCR10;
        stc_intc_eirqcr_field_t EIRQCR10_f;
    };
    union
    {
        __IO uint32_t EIRQCR11;
        stc_intc_eirqcr_field_t EIRQCR11_f;
    };
    union
    {
        __IO uint32_t EIRQCR12;
        stc_intc_eirqcr_field_t EIRQCR12_f;
    };
    union
    {
        __IO uint32_t EIRQCR13;
        stc_intc_eirqcr_field_t EIRQCR13_f;
    };
    union
    {
        __IO uint32_t EIRQCR14;
        stc_intc_eirqcr_field_t EIRQCR14_f;
    };
    union
    {
        __IO uint32_t EIRQCR15;
        stc_intc_eirqcr_field_t EIRQCR15_f;
    };
    union
    {
        __IO uint32_t WUPEN;
        stc_intc_wupen_field_t WUPEN_f;
    };
    union
    {
        __IO uint32_t EIFR;
        stc_intc_eifr_field_t EIFR_f;
    };
    union
    {
        __IO uint32_t EICFR;
        stc_intc_eicfr_field_t EICFR_f;
    };
    union
    {
        __IO uint32_t SEL0;
        stc_intc_sel_field_t SEL0_f;
    };
    union
    {
        __IO uint32_t SEL1;
        stc_intc_sel_field_t SEL1_f;
    };
    union
    {
        __IO uint32_t SEL2;
        stc_intc_sel_field_t SEL2_f;
    };
    union
    {
        __IO uint32_t SEL3;
        stc_intc_sel_field_t SEL3_f;
    };
    union
    {
        __IO uint32_t SEL4;
        stc_intc_sel_field_t SEL4_f;
    };
    union
    {
        __IO uint32_t SEL5;
        stc_intc_sel_field_t SEL5_f;
    };
    union
    {
        __IO uint32_t SEL6;
        stc_intc_sel_field_t SEL6_f;
    };
    union
    {
        __IO uint32_t SEL7;
        stc_intc_sel_field_t SEL7_f;
    };
    union
    {
        __IO uint32_t SEL8;
        stc_intc_sel_field_t SEL8_f;
    };
    union
    {
        __IO uint32_t SEL9;
        stc_intc_sel_field_t SEL9_f;
    };
    union
    {
        __IO uint32_t SEL10;
        stc_intc_sel_field_t SEL10_f;
    };
    union
    {
        __IO uint32_t SEL11;
        stc_intc_sel_field_t SEL11_f;
    };
    union
    {
        __IO uint32_t SEL12;
        stc_intc_sel_field_t SEL12_f;
    };
    union
    {
        __IO uint32_t SEL13;
        stc_intc_sel_field_t SEL13_f;
    };
    union
    {
        __IO uint32_t SEL14;
        stc_intc_sel_field_t SEL14_f;
    };
    union
    {
        __IO uint32_t SEL15;
        stc_intc_sel_field_t SEL15_f;
    };
    union
    {
        __IO uint32_t SEL16;
        stc_intc_sel_field_t SEL16_f;
    };
    union
    {
        __IO uint32_t SEL17;
        stc_intc_sel_field_t SEL17_f;
    };
    union
    {
        __IO uint32_t SEL18;
        stc_intc_sel_field_t SEL18_f;
    };
    union
    {
        __IO uint32_t SEL19;
        stc_intc_sel_field_t SEL19_f;
    };
    union
    {
        __IO uint32_t SEL20;
        stc_intc_sel_field_t SEL20_f;
    };
    union
    {
        __IO uint32_t SEL21;
        stc_intc_sel_field_t SEL21_f;
    };
    union
    {
        __IO uint32_t SEL22;
        stc_intc_sel_field_t SEL22_f;
    };
    union
    {
        __IO uint32_t SEL23;
        stc_intc_sel_field_t SEL23_f;
    };
    union
    {
        __IO uint32_t SEL24;
        stc_intc_sel_field_t SEL24_f;
    };
    union
    {
        __IO uint32_t SEL25;
        stc_intc_sel_field_t SEL25_f;
    };
    union
    {
        __IO uint32_t SEL26;
        stc_intc_sel_field_t SEL26_f;
    };
    union
    {
        __IO uint32_t SEL27;
        stc_intc_sel_field_t SEL27_f;
    };
    union
    {
        __IO uint32_t SEL28;
        stc_intc_sel_field_t SEL28_f;
    };
    union
    {
        __IO uint32_t SEL29;
        stc_intc_sel_field_t SEL29_f;
    };
    union
    {
        __IO uint32_t SEL30;
        stc_intc_sel_field_t SEL30_f;
    };
    union
    {
        __IO uint32_t SEL31;
        stc_intc_sel_field_t SEL31_f;
    };
    union
    {
        __IO uint32_t SEL32;
        stc_intc_sel_field_t SEL32_f;
    };
    union
    {
        __IO uint32_t SEL33;
        stc_intc_sel_field_t SEL33_f;
    };
    union
    {
        __IO uint32_t SEL34;
        stc_intc_sel_field_t SEL34_f;
    };
    union
    {
        __IO uint32_t SEL35;
        stc_intc_sel_field_t SEL35_f;
    };
    union
    {
        __IO uint32_t SEL36;
        stc_intc_sel_field_t SEL36_f;
    };
    union
    {
        __IO uint32_t SEL37;
        stc_intc_sel_field_t SEL37_f;
    };
    union
    {
        __IO uint32_t SEL38;
        stc_intc_sel_field_t SEL38_f;
    };
    union
    {
        __IO uint32_t SEL39;
        stc_intc_sel_field_t SEL39_f;
    };
    union
    {
        __IO uint32_t SEL40;
        stc_intc_sel_field_t SEL40_f;
    };
    union
    {
        __IO uint32_t SEL41;
        stc_intc_sel_field_t SEL41_f;
    };
    union
    {
        __IO uint32_t SEL42;
        stc_intc_sel_field_t SEL42_f;
    };
    union
    {
        __IO uint32_t SEL43;
        stc_intc_sel_field_t SEL43_f;
    };
    union
    {
        __IO uint32_t SEL44;
        stc_intc_sel_field_t SEL44_f;
    };
    union
    {
        __IO uint32_t SEL45;
        stc_intc_sel_field_t SEL45_f;
    };
    union
    {
        __IO uint32_t SEL46;
        stc_intc_sel_field_t SEL46_f;
    };
    union
    {
        __IO uint32_t SEL47;
        stc_intc_sel_field_t SEL47_f;
    };
    union
    {
        __IO uint32_t SEL48;
        stc_intc_sel_field_t SEL48_f;
    };
    union
    {
        __IO uint32_t SEL49;
        stc_intc_sel_field_t SEL49_f;
    };
    union
    {
        __IO uint32_t SEL50;
        stc_intc_sel_field_t SEL50_f;
    };
    union
    {
        __IO uint32_t SEL51;
        stc_intc_sel_field_t SEL51_f;
    };
    union
    {
        __IO uint32_t SEL52;
        stc_intc_sel_field_t SEL52_f;
    };
    union
    {
        __IO uint32_t SEL53;
        stc_intc_sel_field_t SEL53_f;
    };
    union
    {
        __IO uint32_t SEL54;
        stc_intc_sel_field_t SEL54_f;
    };
    union
    {
        __IO uint32_t SEL55;
        stc_intc_sel_field_t SEL55_f;
    };
    union
    {
        __IO uint32_t SEL56;
        stc_intc_sel_field_t SEL56_f;
    };
    union
    {
        __IO uint32_t SEL57;
        stc_intc_sel_field_t SEL57_f;
    };
    union
    {
        __IO uint32_t SEL58;
        stc_intc_sel_field_t SEL58_f;
    };
    union
    {
        __IO uint32_t SEL59;
        stc_intc_sel_field_t SEL59_f;
    };
    union
    {
        __IO uint32_t SEL60;
        stc_intc_sel_field_t SEL60_f;
    };
    union
    {
        __IO uint32_t SEL61;
        stc_intc_sel_field_t SEL61_f;
    };
    union
    {
        __IO uint32_t SEL62;
        stc_intc_sel_field_t SEL62_f;
    };
    union
    {
        __IO uint32_t SEL63;
        stc_intc_sel_field_t SEL63_f;
    };
    union
    {
        __IO uint32_t SEL64;
        stc_intc_sel_field_t SEL64_f;
    };
    union
    {
        __IO uint32_t SEL65;
        stc_intc_sel_field_t SEL65_f;
    };
    union
    {
        __IO uint32_t SEL66;
        stc_intc_sel_field_t SEL66_f;
    };
    union
    {
        __IO uint32_t SEL67;
        stc_intc_sel_field_t SEL67_f;
    };
    union
    {
        __IO uint32_t SEL68;
        stc_intc_sel_field_t SEL68_f;
    };
    union
    {
        __IO uint32_t SEL69;
        stc_intc_sel_field_t SEL69_f;
    };
    union
    {
        __IO uint32_t SEL70;
        stc_intc_sel_field_t SEL70_f;
    };
    union
    {
        __IO uint32_t SEL71;
        stc_intc_sel_field_t SEL71_f;
    };
    union
    {
        __IO uint32_t SEL72;
        stc_intc_sel_field_t SEL72_f;
    };
    union
    {
        __IO uint32_t SEL73;
        stc_intc_sel_field_t SEL73_f;
    };
    union
    {
        __IO uint32_t SEL74;
        stc_intc_sel_field_t SEL74_f;
    };
    union
    {
        __IO uint32_t SEL75;
        stc_intc_sel_field_t SEL75_f;
    };
    union
    {
        __IO uint32_t SEL76;
        stc_intc_sel_field_t SEL76_f;
    };
    union
    {
        __IO uint32_t SEL77;
        stc_intc_sel_field_t SEL77_f;
    };
    union
    {
        __IO uint32_t SEL78;
        stc_intc_sel_field_t SEL78_f;
    };
    union
    {
        __IO uint32_t SEL79;
        stc_intc_sel_field_t SEL79_f;
    };
    union
    {
        __IO uint32_t SEL80;
        stc_intc_sel_field_t SEL80_f;
    };
    union
    {
        __IO uint32_t SEL81;
        stc_intc_sel_field_t SEL81_f;
    };
    union
    {
        __IO uint32_t SEL82;
        stc_intc_sel_field_t SEL82_f;
    };
    union
    {
        __IO uint32_t SEL83;
        stc_intc_sel_field_t SEL83_f;
    };
    union
    {
        __IO uint32_t SEL84;
        stc_intc_sel_field_t SEL84_f;
    };
    union
    {
        __IO uint32_t SEL85;
        stc_intc_sel_field_t SEL85_f;
    };
    union
    {
        __IO uint32_t SEL86;
        stc_intc_sel_field_t SEL86_f;
    };
    union
    {
        __IO uint32_t SEL87;
        stc_intc_sel_field_t SEL87_f;
    };
    union
    {
        __IO uint32_t SEL88;
        stc_intc_sel_field_t SEL88_f;
    };
    union
    {
        __IO uint32_t SEL89;
        stc_intc_sel_field_t SEL89_f;
    };
    union
    {
        __IO uint32_t SEL90;
        stc_intc_sel_field_t SEL90_f;
    };
    union
    {
        __IO uint32_t SEL91;
        stc_intc_sel_field_t SEL91_f;
    };
    union
    {
        __IO uint32_t SEL92;
        stc_intc_sel_field_t SEL92_f;
    };
    union
    {
        __IO uint32_t SEL93;
        stc_intc_sel_field_t SEL93_f;
    };
    union
    {
        __IO uint32_t SEL94;
        stc_intc_sel_field_t SEL94_f;
    };
    union
    {
        __IO uint32_t SEL95;
        stc_intc_sel_field_t SEL95_f;
    };
    union
    {
        __IO uint32_t SEL96;
        stc_intc_sel_field_t SEL96_f;
    };
    union
    {
        __IO uint32_t SEL97;
        stc_intc_sel_field_t SEL97_f;
    };
    union
    {
        __IO uint32_t SEL98;
        stc_intc_sel_field_t SEL98_f;
    };
    union
    {
        __IO uint32_t SEL99;
        stc_intc_sel_field_t SEL99_f;
    };
    union
    {
        __IO uint32_t SEL100;
        stc_intc_sel_field_t SEL100_f;
    };
    union
    {
        __IO uint32_t SEL101;
        stc_intc_sel_field_t SEL101_f;
    };
    union
    {
        __IO uint32_t SEL102;
        stc_intc_sel_field_t SEL102_f;
    };
    union
    {
        __IO uint32_t SEL103;
        stc_intc_sel_field_t SEL103_f;
    };
    union
    {
        __IO uint32_t SEL104;
        stc_intc_sel_field_t SEL104_f;
    };
    union
    {
        __IO uint32_t SEL105;
        stc_intc_sel_field_t SEL105_f;
    };
    union
    {
        __IO uint32_t SEL106;
        stc_intc_sel_field_t SEL106_f;
    };
    union
    {
        __IO uint32_t SEL107;
        stc_intc_sel_field_t SEL107_f;
    };
    union
    {
        __IO uint32_t SEL108;
        stc_intc_sel_field_t SEL108_f;
    };
    union
    {
        __IO uint32_t SEL109;
        stc_intc_sel_field_t SEL109_f;
    };
    union
    {
        __IO uint32_t SEL110;
        stc_intc_sel_field_t SEL110_f;
    };
    union
    {
        __IO uint32_t SEL111;
        stc_intc_sel_field_t SEL111_f;
    };
    union
    {
        __IO uint32_t SEL112;
        stc_intc_sel_field_t SEL112_f;
    };
    union
    {
        __IO uint32_t SEL113;
        stc_intc_sel_field_t SEL113_f;
    };
    union
    {
        __IO uint32_t SEL114;
        stc_intc_sel_field_t SEL114_f;
    };
    union
    {
        __IO uint32_t SEL115;
        stc_intc_sel_field_t SEL115_f;
    };
    union
    {
        __IO uint32_t SEL116;
        stc_intc_sel_field_t SEL116_f;
    };
    union
    {
        __IO uint32_t SEL117;
        stc_intc_sel_field_t SEL117_f;
    };
    union
    {
        __IO uint32_t SEL118;
        stc_intc_sel_field_t SEL118_f;
    };
    union
    {
        __IO uint32_t SEL119;
        stc_intc_sel_field_t SEL119_f;
    };
    union
    {
        __IO uint32_t SEL120;
        stc_intc_sel_field_t SEL120_f;
    };
    union
    {
        __IO uint32_t SEL121;
        stc_intc_sel_field_t SEL121_f;
    };
    union
    {
        __IO uint32_t SEL122;
        stc_intc_sel_field_t SEL122_f;
    };
    union
    {
        __IO uint32_t SEL123;
        stc_intc_sel_field_t SEL123_f;
    };
    union
    {
        __IO uint32_t SEL124;
        stc_intc_sel_field_t SEL124_f;
    };
    union
    {
        __IO uint32_t SEL125;
        stc_intc_sel_field_t SEL125_f;
    };
    union
    {
        __IO uint32_t SEL126;
        stc_intc_sel_field_t SEL126_f;
    };
    union
    {
        __IO uint32_t SEL127;
        stc_intc_sel_field_t SEL127_f;
    };
    union
    {
        __IO uint32_t VSSEL128;
        stc_intc_vssel_field_t VSSEL128_f;
    };
    union
    {
        __IO uint32_t VSSEL129;
        stc_intc_vssel_field_t VSSEL129_f;
    };
    union
    {
        __IO uint32_t VSSEL130;
        stc_intc_vssel_field_t VSSEL130_f;
    };
    union
    {
        __IO uint32_t VSSEL131;
        stc_intc_vssel_field_t VSSEL131_f;
    };
    union
    {
        __IO uint32_t VSSEL132;
        stc_intc_vssel_field_t VSSEL132_f;
    };
    union
    {
        __IO uint32_t VSSEL133;
        stc_intc_vssel_field_t VSSEL133_f;
    };
    union
    {
        __IO uint32_t VSSEL134;
        stc_intc_vssel_field_t VSSEL134_f;
    };
    union
    {
        __IO uint32_t VSSEL135;
        stc_intc_vssel_field_t VSSEL135_f;
    };
    union
    {
        __IO uint32_t VSSEL136;
        stc_intc_vssel_field_t VSSEL136_f;
    };
    union
    {
        __IO uint32_t VSSEL137;
        stc_intc_vssel_field_t VSSEL137_f;
    };
    union
    {
        __IO uint32_t VSSEL138;
        stc_intc_vssel_field_t VSSEL138_f;
    };
    union
    {
        __IO uint32_t VSSEL139;
        stc_intc_vssel_field_t VSSEL139_f;
    };
    union
    {
        __IO uint32_t VSSEL140;
        stc_intc_vssel_field_t VSSEL140_f;
    };
    union
    {
        __IO uint32_t VSSEL141;
        stc_intc_vssel_field_t VSSEL141_f;
    };
    union
    {
        __IO uint32_t VSSEL142;
        stc_intc_vssel_field_t VSSEL142_f;
    };
    union
    {
        __IO uint32_t VSSEL143;
        stc_intc_vssel_field_t VSSEL143_f;
    };
    union
    {
        __IO uint32_t SWIER;
        stc_intc_swier_field_t SWIER_f;
    };
    union
    {
        __IO uint32_t EVTER;
        stc_intc_evter_field_t EVTER_f;
    };
    union
    {
        __IO uint32_t IER;
        stc_intc_ier_field_t IER_f;
    };
} M4_INTC_TypeDef;

/**
 * @brief KEYSCAN
 */
typedef struct
{
    union
    {
        __IO uint32_t SCR;
        stc_keyscan_scr_field_t SCR_f;
    };
    union
    {
        __IO uint32_t SER;
        stc_keyscan_ser_field_t SER_f;
    };
    union
    {
        __IO uint32_t SSR;
        stc_keyscan_ssr_field_t SSR_f;
    };
} M4_KEYSCAN_TypeDef;

/**
 * @brief MPU
 */
typedef struct
{
    union
    {
        __IO uint32_t RGD0;
        stc_mpu_rgd_field_t RGD0_f;
    };
    union
    {
        __IO uint32_t RGD1;
        stc_mpu_rgd_field_t RGD1_f;
    };
    union
    {
        __IO uint32_t RGD2;
        stc_mpu_rgd_field_t RGD2_f;
    };
    union
    {
        __IO uint32_t RGD3;
        stc_mpu_rgd_field_t RGD3_f;
    };
    union
    {
        __IO uint32_t RGD4;
        stc_mpu_rgd_field_t RGD4_f;
    };
    union
    {
        __IO uint32_t RGD5;
        stc_mpu_rgd_field_t RGD5_f;
    };
    union
    {
        __IO uint32_t RGD6;
        stc_mpu_rgd_field_t RGD6_f;
    };
    union
    {
        __IO uint32_t RGD7;
        stc_mpu_rgd_field_t RGD7_f;
    };
    union
    {
        __IO uint32_t RGD8;
        stc_mpu_rgd_field_t RGD8_f;
    };
    union
    {
        __IO uint32_t RGD9;
        stc_mpu_rgd_field_t RGD9_f;
    };
    union
    {
        __IO uint32_t RGD10;
        stc_mpu_rgd_field_t RGD10_f;
    };
    union
    {
        __IO uint32_t RGD11;
        stc_mpu_rgd_field_t RGD11_f;
    };
    union
    {
        __IO uint32_t RGD12;
        stc_mpu_rgd_field_t RGD12_f;
    };
    union
    {
        __IO uint32_t RGD13;
        stc_mpu_rgd_field_t RGD13_f;
    };
    union
    {
        __IO uint32_t RGD14;
        stc_mpu_rgd_field_t RGD14_f;
    };
    union
    {
        __IO uint32_t RGD15;
        stc_mpu_rgd_field_t RGD15_f;
    };
    union
    {
        __IO uint32_t RGCR0;
        stc_mpu_rgcr0_field_t RGCR0_f;
    };
    union
    {
        __IO uint32_t RGCR1;
        stc_mpu_rgcr1_field_t RGCR1_f;
    };
    union
    {
        __IO uint32_t RGCR2;
        stc_mpu_rgcr2_field_t RGCR2_f;
    };
    union
    {
        __IO uint32_t RGCR3;
        stc_mpu_rgcr3_field_t RGCR3_f;
    };
    union
    {
        __IO uint32_t RGCR4;
        stc_mpu_rgcr4_field_t RGCR4_f;
    };
    union
    {
        __IO uint32_t RGCR5;
        stc_mpu_rgcr5_field_t RGCR5_f;
    };
    union
    {
        __IO uint32_t RGCR6;
        stc_mpu_rgcr6_field_t RGCR6_f;
    };
    union
    {
        __IO uint32_t RGCR7;
        stc_mpu_rgcr7_field_t RGCR7_f;
    };
    union
    {
        __IO uint32_t RGCR8;
        stc_mpu_rgcr8_field_t RGCR8_f;
    };
    union
    {
        __IO uint32_t RGCR9;
        stc_mpu_rgcr9_field_t RGCR9_f;
    };
    union
    {
        __IO uint32_t RGCR10;
        stc_mpu_rgcr10_field_t RGCR10_f;
    };
    union
    {
        __IO uint32_t RGCR11;
        stc_mpu_rgcr11_field_t RGCR11_f;
    };
    union
    {
        __IO uint32_t RGCR12;
        stc_mpu_rgcr12_field_t RGCR12_f;
    };
    union
    {
        __IO uint32_t RGCR13;
        stc_mpu_rgcr13_field_t RGCR13_f;
    };
    union
    {
        __IO uint32_t RGCR14;
        stc_mpu_rgcr14_field_t RGCR14_f;
    };
    union
    {
        __IO uint32_t RGCR15;
        stc_mpu_rgcr15_field_t RGCR15_f;
    };
    union
    {
        __IO uint32_t CR;
        stc_mpu_cr_field_t CR_f;
    };
    union
    {
        __IO uint32_t SR;
        stc_mpu_sr_field_t SR_f;
    };
    union
    {
        __IO uint32_t ECLR;
        stc_mpu_eclr_field_t ECLR_f;
    };
    union
    {
        __IO uint32_t WP;
        stc_mpu_wp_field_t WP_f;
    };
} M4_MPU_TypeDef;

/**
 * @brief MSTP
 */
typedef struct
{
    union
    {
        __IO uint32_t FCG0;
        stc_mstp_fcg0_field_t FCG0_f;
    };
    union
    {
        __IO uint32_t FCG1;
        stc_mstp_fcg1_field_t FCG1_f;
    };
    union
    {
        __IO uint32_t FCG2;
        stc_mstp_fcg2_field_t FCG2_f;
    };
    union
    {
        __IO uint32_t FCG3;
        stc_mstp_fcg3_field_t FCG3_f;
    };
    union
    {
        __IO uint32_t FCG0PC;
        stc_mstp_fcg0pc_field_t FCG0PC_f;
    };
} M4_MSTP_TypeDef;

/**
 * @brief OTS
 */
typedef struct
{
    union
    {
        __IO uint16_t CTL;
        stc_ots_ctl_field_t CTL_f;
    };
    __IO uint16_t DR1;
    __IO uint16_t DR2;
    __IO uint16_t ECR;
    union
    {
        __IO uint32_t LPR;
        stc_ots_lpr_field_t LPR_f;
    };
} M4_OTS_TypeDef;

/**
 * @brief PERIC
 */
typedef struct
{
    union
    {
        __IO uint32_t USBFS_SYCTLREG;
        stc_peric_usbfs_syctlreg_field_t USBFS_SYCTLREG_f;
    };
    union
    {
        __IO uint32_t SDIOC_SYCTLREG;
        stc_peric_sdioc_syctlreg_field_t SDIOC_SYCTLREG_f;
    };
} M4_PERIC_TypeDef;

/**
 * @brief PORT
 */
typedef struct
{
    union
    {
        __IO uint16_t PIDRA;
        stc_port_pidr_field_t PIDRA_f;
    };
    uint8_t RESERVED0[2];
    union
    {
        __IO uint16_t PODRA;
        stc_port_podr_field_t PODRA_f;
    };
    union
    {
        __IO uint16_t POERA;
        stc_port_poer_field_t POERA_f;
    };
    union
    {
        __IO uint16_t POSRA;
        stc_port_posr_field_t POSRA_f;
    };
    union
    {
        __IO uint16_t PORRA;
        stc_port_porr_field_t PORRA_f;
    };
    union
    {
        __IO uint16_t POTRA;
        stc_port_potr_field_t POTRA_f;
    };
    uint8_t RESERVED1[2];
    union
    {
        __IO uint16_t PIDRB;
        stc_port_pidr_field_t PIDRB_f;
    };
    uint8_t RESERVED2[2];
    union
    {
        __IO uint16_t PODRB;
        stc_port_podr_field_t PODRB_f;
    };
    union
    {
        __IO uint16_t POERB;
        stc_port_poer_field_t POERB_f;
    };
    union
    {
        __IO uint16_t POSRB;
        stc_port_posr_field_t POSRB_f;
    };
    union
    {
        __IO uint16_t PORRB;
        stc_port_porr_field_t PORRB_f;
    };
    union
    {
        __IO uint16_t POTRB;
        stc_port_potr_field_t POTRB_f;
    };
    uint8_t RESERVED3[2];
    union
    {
        __IO uint16_t PIDRC;
        stc_port_pidr_field_t PIDRC_f;
    };
    uint8_t RESERVED4[2];
    union
    {
        __IO uint16_t PODRC;
        stc_port_podr_field_t PODRC_f;
    };
    union
    {
        __IO uint16_t POERC;
        stc_port_poer_field_t POERC_f;
    };
    union
    {
        __IO uint16_t POSRC;
        stc_port_posr_field_t POSRC_f;
    };
    union
    {
        __IO uint16_t PORRC;
        stc_port_porr_field_t PORRC_f;
    };
    union
    {
        __IO uint16_t POTRC;
        stc_port_potr_field_t POTRC_f;
    };
    uint8_t RESERVED5[2];
    union
    {
        __IO uint16_t PIDRD;
        stc_port_pidr_field_t PIDRD_f;
    };
    uint8_t RESERVED6[2];
    union
    {
        __IO uint16_t PODRD;
        stc_port_podr_field_t PODRD_f;
    };
    union
    {
        __IO uint16_t POERD;
        stc_port_poer_field_t POERD_f;
    };
    union
    {
        __IO uint16_t POSRD;
        stc_port_posr_field_t POSRD_f;
    };
    union
    {
        __IO uint16_t PORRD;
        stc_port_porr_field_t PORRD_f;
    };
    union
    {
        __IO uint16_t POTRD;
        stc_port_potr_field_t POTRD_f;
    };
    uint8_t RESERVED7[2];
    union
    {
        __IO uint16_t PIDRE;
        stc_port_pidr_field_t PIDRE_f;
    };
    uint8_t RESERVED8[2];
    union
    {
        __IO uint16_t PODRE;
        stc_port_podr_field_t PODRE_f;
    };
    union
    {
        __IO uint16_t POERE;
        stc_port_poer_field_t POERE_f;
    };
    union
    {
        __IO uint16_t POSRE;
        stc_port_posr_field_t POSRE_f;
    };
    union
    {
        __IO uint16_t PORRE;
        stc_port_porr_field_t PORRE_f;
    };
    union
    {
        __IO uint16_t POTRE;
        stc_port_potr_field_t POTRE_f;
    };
    uint8_t RESERVED9[2];
    union
    {
        __IO uint16_t PIDRH;
        stc_port_pidrh_field_t PIDRH_f;
    };
    uint8_t RESERVED10[2];
    union
    {
        __IO uint16_t PODRH;
        stc_port_podrh_field_t PODRH_f;
    };
    union
    {
        __IO uint16_t POERH;
        stc_port_poerh_field_t POERH_f;
    };
    union
    {
        __IO uint16_t POSRH;
        stc_port_posrh_field_t POSRH_f;
    };
    union
    {
        __IO uint16_t PORRH;
        stc_port_porrh_field_t PORRH_f;
    };
    union
    {
        __IO uint16_t POTRH;
        stc_port_potrh_field_t POTRH_f;
    };
    uint8_t RESERVED11[918];
    union
    {
        __IO uint16_t PSPCR;
        stc_port_pspcr_field_t PSPCR_f;
    };
    uint8_t RESERVED12[2];
    union
    {
        __IO uint16_t PCCR;
        stc_port_pccr_field_t PCCR_f;
    };
    union
    {
        __IO uint16_t PINAER;
        stc_port_pinaer_field_t PINAER_f;
    };
    union
    {
        __IO uint16_t PWPR;
        stc_port_pwpr_field_t PWPR_f;
    };
    uint8_t RESERVED13[2];
    union
    {
        __IO uint16_t PCRA0;
        stc_port_pcr_field_t PCRA0_f;
    };
    union
    {
        __IO uint16_t PFSRA0;
        stc_port_pfsr_field_t PFSRA0_f;
    };
    union
    {
        __IO uint16_t PCRA1;
        stc_port_pcr_field_t PCRA1_f;
    };
    union
    {
        __IO uint16_t PFSRA1;
        stc_port_pfsr_field_t PFSRA1_f;
    };
    union
    {
        __IO uint16_t PCRA2;
        stc_port_pcr_field_t PCRA2_f;
    };
    union
    {
        __IO uint16_t PFSRA2;
        stc_port_pfsr_field_t PFSRA2_f;
    };
    union
    {
        __IO uint16_t PCRA3;
        stc_port_pcr_field_t PCRA3_f;
    };
    union
    {
        __IO uint16_t PFSRA3;
        stc_port_pfsr_field_t PFSRA3_f;
    };
    union
    {
        __IO uint16_t PCRA4;
        stc_port_pcr_field_t PCRA4_f;
    };
    union
    {
        __IO uint16_t PFSRA4;
        stc_port_pfsr_field_t PFSRA4_f;
    };
    union
    {
        __IO uint16_t PCRA5;
        stc_port_pcr_field_t PCRA5_f;
    };
    union
    {
        __IO uint16_t PFSRA5;
        stc_port_pfsr_field_t PFSRA5_f;
    };
    union
    {
        __IO uint16_t PCRA6;
        stc_port_pcr_field_t PCRA6_f;
    };
    union
    {
        __IO uint16_t PFSRA6;
        stc_port_pfsr_field_t PFSRA6_f;
    };
    union
    {
        __IO uint16_t PCRA7;
        stc_port_pcr_field_t PCRA7_f;
    };
    union
    {
        __IO uint16_t PFSRA7;
        stc_port_pfsr_field_t PFSRA7_f;
    };
    union
    {
        __IO uint16_t PCRA8;
        stc_port_pcr_field_t PCRA8_f;
    };
    union
    {
        __IO uint16_t PFSRA8;
        stc_port_pfsr_field_t PFSRA8_f;
    };
    union
    {
        __IO uint16_t PCRA9;
        stc_port_pcr_field_t PCRA9_f;
    };
    union
    {
        __IO uint16_t PFSRA9;
        stc_port_pfsr_field_t PFSRA9_f;
    };
    union
    {
        __IO uint16_t PCRA10;
        stc_port_pcr_field_t PCRA10_f;
    };
    union
    {
        __IO uint16_t PFSRA10;
        stc_port_pfsr_field_t PFSRA10_f;
    };
    union
    {
        __IO uint16_t PCRA11;
        stc_port_pcr_field_t PCRA11_f;
    };
    union
    {
        __IO uint16_t PFSRA11;
        stc_port_pfsr_field_t PFSRA11_f;
    };
    union
    {
        __IO uint16_t PCRA12;
        stc_port_pcr_field_t PCRA12_f;
    };
    union
    {
        __IO uint16_t PFSRA12;
        stc_port_pfsr_field_t PFSRA12_f;
    };
    union
    {
        __IO uint16_t PCRA13;
        stc_port_pcr_field_t PCRA13_f;
    };
    union
    {
        __IO uint16_t PFSRA13;
        stc_port_pfsr_field_t PFSRA13_f;
    };
    union
    {
        __IO uint16_t PCRA14;
        stc_port_pcr_field_t PCRA14_f;
    };
    union
    {
        __IO uint16_t PFSRA14;
        stc_port_pfsr_field_t PFSRA14_f;
    };
    union
    {
        __IO uint16_t PCRA15;
        stc_port_pcr_field_t PCRA15_f;
    };
    union
    {
        __IO uint16_t PFSRA15;
        stc_port_pfsr_field_t PFSRA15_f;
    };
    union
    {
        __IO uint16_t PCRB0;
        stc_port_pcr_field_t PCRB0_f;
    };
    union
    {
        __IO uint16_t PFSRB0;
        stc_port_pfsr_field_t PFSRB0_f;
    };
    union
    {
        __IO uint16_t PCRB1;
        stc_port_pcr_field_t PCRB1_f;
    };
    union
    {
        __IO uint16_t PFSRB1;
        stc_port_pfsr_field_t PFSRB1_f;
    };
    union
    {
        __IO uint16_t PCRB2;
        stc_port_pcr_field_t PCRB2_f;
    };
    union
    {
        __IO uint16_t PFSRB2;
        stc_port_pfsr_field_t PFSRB2_f;
    };
    union
    {
        __IO uint16_t PCRB3;
        stc_port_pcr_field_t PCRB3_f;
    };
    union
    {
        __IO uint16_t PFSRB3;
        stc_port_pfsr_field_t PFSRB3_f;
    };
    union
    {
        __IO uint16_t PCRB4;
        stc_port_pcr_field_t PCRB4_f;
    };
    union
    {
        __IO uint16_t PFSRB4;
        stc_port_pfsr_field_t PFSRB4_f;
    };
    union
    {
        __IO uint16_t PCRB5;
        stc_port_pcr_field_t PCRB5_f;
    };
    union
    {
        __IO uint16_t PFSRB5;
        stc_port_pfsr_field_t PFSRB5_f;
    };
    union
    {
        __IO uint16_t PCRB6;
        stc_port_pcr_field_t PCRB6_f;
    };
    union
    {
        __IO uint16_t PFSRB6;
        stc_port_pfsr_field_t PFSRB6_f;
    };
    union
    {
        __IO uint16_t PCRB7;
        stc_port_pcr_field_t PCRB7_f;
    };
    union
    {
        __IO uint16_t PFSRB7;
        stc_port_pfsr_field_t PFSRB7_f;
    };
    union
    {
        __IO uint16_t PCRB8;
        stc_port_pcr_field_t PCRB8_f;
    };
    union
    {
        __IO uint16_t PFSRB8;
        stc_port_pfsr_field_t PFSRB8_f;
    };
    union
    {
        __IO uint16_t PCRB9;
        stc_port_pcr_field_t PCRB9_f;
    };
    union
    {
        __IO uint16_t PFSRB9;
        stc_port_pfsr_field_t PFSRB9_f;
    };
    union
    {
        __IO uint16_t PCRB10;
        stc_port_pcr_field_t PCRB10_f;
    };
    union
    {
        __IO uint16_t PFSRB10;
        stc_port_pfsr_field_t PFSRB10_f;
    };
    union
    {
        __IO uint16_t PCRB11;
        stc_port_pcr_field_t PCRB11_f;
    };
    union
    {
        __IO uint16_t PFSRB11;
        stc_port_pfsr_field_t PFSRB11_f;
    };
    union
    {
        __IO uint16_t PCRB12;
        stc_port_pcr_field_t PCRB12_f;
    };
    union
    {
        __IO uint16_t PFSRB12;
        stc_port_pfsr_field_t PFSRB12_f;
    };
    union
    {
        __IO uint16_t PCRB13;
        stc_port_pcr_field_t PCRB13_f;
    };
    union
    {
        __IO uint16_t PFSRB13;
        stc_port_pfsr_field_t PFSRB13_f;
    };
    union
    {
        __IO uint16_t PCRB14;
        stc_port_pcr_field_t PCRB14_f;
    };
    union
    {
        __IO uint16_t PFSRB14;
        stc_port_pfsr_field_t PFSRB14_f;
    };
    union
    {
        __IO uint16_t PCRB15;
        stc_port_pcr_field_t PCRB15_f;
    };
    union
    {
        __IO uint16_t PFSRB15;
        stc_port_pfsr_field_t PFSRB15_f;
    };
    union
    {
        __IO uint16_t PCRC0;
        stc_port_pcr_field_t PCRC0_f;
    };
    union
    {
        __IO uint16_t PFSRC0;
        stc_port_pfsr_field_t PFSRC0_f;
    };
    union
    {
        __IO uint16_t PCRC1;
        stc_port_pcr_field_t PCRC1_f;
    };
    union
    {
        __IO uint16_t PFSRC1;
        stc_port_pfsr_field_t PFSRC1_f;
    };
    union
    {
        __IO uint16_t PCRC2;
        stc_port_pcr_field_t PCRC2_f;
    };
    union
    {
        __IO uint16_t PFSRC2;
        stc_port_pfsr_field_t PFSRC2_f;
    };
    union
    {
        __IO uint16_t PCRC3;
        stc_port_pcr_field_t PCRC3_f;
    };
    union
    {
        __IO uint16_t PFSRC3;
        stc_port_pfsr_field_t PFSRC3_f;
    };
    union
    {
        __IO uint16_t PCRC4;
        stc_port_pcr_field_t PCRC4_f;
    };
    union
    {
        __IO uint16_t PFSRC4;
        stc_port_pfsr_field_t PFSRC4_f;
    };
    union
    {
        __IO uint16_t PCRC5;
        stc_port_pcr_field_t PCRC5_f;
    };
    union
    {
        __IO uint16_t PFSRC5;
        stc_port_pfsr_field_t PFSRC5_f;
    };
    union
    {
        __IO uint16_t PCRC6;
        stc_port_pcr_field_t PCRC6_f;
    };
    union
    {
        __IO uint16_t PFSRC6;
        stc_port_pfsr_field_t PFSRC6_f;
    };
    union
    {
        __IO uint16_t PCRC7;
        stc_port_pcr_field_t PCRC7_f;
    };
    union
    {
        __IO uint16_t PFSRC7;
        stc_port_pfsr_field_t PFSRC7_f;
    };
    union
    {
        __IO uint16_t PCRC8;
        stc_port_pcr_field_t PCRC8_f;
    };
    union
    {
        __IO uint16_t PFSRC8;
        stc_port_pfsr_field_t PFSRC8_f;
    };
    union
    {
        __IO uint16_t PCRC9;
        stc_port_pcr_field_t PCRC9_f;
    };
    union
    {
        __IO uint16_t PFSRC9;
        stc_port_pfsr_field_t PFSRC9_f;
    };
    union
    {
        __IO uint16_t PCRC10;
        stc_port_pcr_field_t PCRC10_f;
    };
    union
    {
        __IO uint16_t PFSRC10;
        stc_port_pfsr_field_t PFSRC10_f;
    };
    union
    {
        __IO uint16_t PCRC11;
        stc_port_pcr_field_t PCRC11_f;
    };
    union
    {
        __IO uint16_t PFSRC11;
        stc_port_pfsr_field_t PFSRC11_f;
    };
    union
    {
        __IO uint16_t PCRC12;
        stc_port_pcr_field_t PCRC12_f;
    };
    union
    {
        __IO uint16_t PFSRC12;
        stc_port_pfsr_field_t PFSRC12_f;
    };
    union
    {
        __IO uint16_t PCRC13;
        stc_port_pcr_field_t PCRC13_f;
    };
    union
    {
        __IO uint16_t PFSRC13;
        stc_port_pfsr_field_t PFSRC13_f;
    };
    union
    {
        __IO uint16_t PCRC14;
        stc_port_pcr_field_t PCRC14_f;
    };
    union
    {
        __IO uint16_t PFSRC14;
        stc_port_pfsr_field_t PFSRC14_f;
    };
    union
    {
        __IO uint16_t PCRC15;
        stc_port_pcr_field_t PCRC15_f;
    };
    union
    {
        __IO uint16_t PFSRC15;
        stc_port_pfsr_field_t PFSRC15_f;
    };
    union
    {
        __IO uint16_t PCRD0;
        stc_port_pcr_field_t PCRD0_f;
    };
    union
    {
        __IO uint16_t PFSRD0;
        stc_port_pfsr_field_t PFSRD0_f;
    };
    union
    {
        __IO uint16_t PCRD1;
        stc_port_pcr_field_t PCRD1_f;
    };
    union
    {
        __IO uint16_t PFSRD1;
        stc_port_pfsr_field_t PFSRD1_f;
    };
    union
    {
        __IO uint16_t PCRD2;
        stc_port_pcr_field_t PCRD2_f;
    };
    union
    {
        __IO uint16_t PFSRD2;
        stc_port_pfsr_field_t PFSRD2_f;
    };
    union
    {
        __IO uint16_t PCRD3;
        stc_port_pcr_field_t PCRD3_f;
    };
    union
    {
        __IO uint16_t PFSRD3;
        stc_port_pfsr_field_t PFSRD3_f;
    };
    union
    {
        __IO uint16_t PCRD4;
        stc_port_pcr_field_t PCRD4_f;
    };
    union
    {
        __IO uint16_t PFSRD4;
        stc_port_pfsr_field_t PFSRD4_f;
    };
    union
    {
        __IO uint16_t PCRD5;
        stc_port_pcr_field_t PCRD5_f;
    };
    union
    {
        __IO uint16_t PFSRD5;
        stc_port_pfsr_field_t PFSRD5_f;
    };
    union
    {
        __IO uint16_t PCRD6;
        stc_port_pcr_field_t PCRD6_f;
    };
    union
    {
        __IO uint16_t PFSRD6;
        stc_port_pfsr_field_t PFSRD6_f;
    };
    union
    {
        __IO uint16_t PCRD7;
        stc_port_pcr_field_t PCRD7_f;
    };
    union
    {
        __IO uint16_t PFSRD7;
        stc_port_pfsr_field_t PFSRD7_f;
    };
    union
    {
        __IO uint16_t PCRD8;
        stc_port_pcr_field_t PCRD8_f;
    };
    union
    {
        __IO uint16_t PFSRD8;
        stc_port_pfsr_field_t PFSRD8_f;
    };
    union
    {
        __IO uint16_t PCRD9;
        stc_port_pcr_field_t PCRD9_f;
    };
    union
    {
        __IO uint16_t PFSRD9;
        stc_port_pfsr_field_t PFSRD9_f;
    };
    union
    {
        __IO uint16_t PCRD10;
        stc_port_pcr_field_t PCRD10_f;
    };
    union
    {
        __IO uint16_t PFSRD10;
        stc_port_pfsr_field_t PFSRD10_f;
    };
    union
    {
        __IO uint16_t PCRD11;
        stc_port_pcr_field_t PCRD11_f;
    };
    union
    {
        __IO uint16_t PFSRD11;
        stc_port_pfsr_field_t PFSRD11_f;
    };
    union
    {
        __IO uint16_t PCRD12;
        stc_port_pcr_field_t PCRD12_f;
    };
    union
    {
        __IO uint16_t PFSRD12;
        stc_port_pfsr_field_t PFSRD12_f;
    };
    union
    {
        __IO uint16_t PCRD13;
        stc_port_pcr_field_t PCRD13_f;
    };
    union
    {
        __IO uint16_t PFSRD13;
        stc_port_pfsr_field_t PFSRD13_f;
    };
    union
    {
        __IO uint16_t PCRD14;
        stc_port_pcr_field_t PCRD14_f;
    };
    union
    {
        __IO uint16_t PFSRD14;
        stc_port_pfsr_field_t PFSRD14_f;
    };
    union
    {
        __IO uint16_t PCRD15;
        stc_port_pcr_field_t PCRD15_f;
    };
    union
    {
        __IO uint16_t PFSRD15;
        stc_port_pfsr_field_t PFSRD15_f;
    };
    union
    {
        __IO uint16_t PCRE0;
        stc_port_pcr_field_t PCRE0_f;
    };
    union
    {
        __IO uint16_t PFSRE0;
        stc_port_pfsr_field_t PFSRE0_f;
    };
    union
    {
        __IO uint16_t PCRE1;
        stc_port_pcr_field_t PCRE1_f;
    };
    union
    {
        __IO uint16_t PFSRE1;
        stc_port_pfsr_field_t PFSRE1_f;
    };
    union
    {
        __IO uint16_t PCRE2;
        stc_port_pcr_field_t PCRE2_f;
    };
    union
    {
        __IO uint16_t PFSRE2;
        stc_port_pfsr_field_t PFSRE2_f;
    };
    union
    {
        __IO uint16_t PCRE3;
        stc_port_pcr_field_t PCRE3_f;
    };
    union
    {
        __IO uint16_t PFSRE3;
        stc_port_pfsr_field_t PFSRE3_f;
    };
    union
    {
        __IO uint16_t PCRE4;
        stc_port_pcr_field_t PCRE4_f;
    };
    union
    {
        __IO uint16_t PFSRE4;
        stc_port_pfsr_field_t PFSRE4_f;
    };
    union
    {
        __IO uint16_t PCRE5;
        stc_port_pcr_field_t PCRE5_f;
    };
    union
    {
        __IO uint16_t PFSRE5;
        stc_port_pfsr_field_t PFSRE5_f;
    };
    union
    {
        __IO uint16_t PCRE6;
        stc_port_pcr_field_t PCRE6_f;
    };
    union
    {
        __IO uint16_t PFSRE6;
        stc_port_pfsr_field_t PFSRE6_f;
    };
    union
    {
        __IO uint16_t PCRE7;
        stc_port_pcr_field_t PCRE7_f;
    };
    union
    {
        __IO uint16_t PFSRE7;
        stc_port_pfsr_field_t PFSRE7_f;
    };
    union
    {
        __IO uint16_t PCRE8;
        stc_port_pcr_field_t PCRE8_f;
    };
    union
    {
        __IO uint16_t PFSRE8;
        stc_port_pfsr_field_t PFSRE8_f;
    };
    union
    {
        __IO uint16_t PCRE9;
        stc_port_pcr_field_t PCRE9_f;
    };
    union
    {
        __IO uint16_t PFSRE9;
        stc_port_pfsr_field_t PFSRE9_f;
    };
    union
    {
        __IO uint16_t PCRE10;
        stc_port_pcr_field_t PCRE10_f;
    };
    union
    {
        __IO uint16_t PFSRE10;
        stc_port_pfsr_field_t PFSRE10_f;
    };
    union
    {
        __IO uint16_t PCRE11;
        stc_port_pcr_field_t PCRE11_f;
    };
    union
    {
        __IO uint16_t PFSRE11;
        stc_port_pfsr_field_t PFSRE11_f;
    };
    union
    {
        __IO uint16_t PCRE12;
        stc_port_pcr_field_t PCRE12_f;
    };
    union
    {
        __IO uint16_t PFSRE12;
        stc_port_pfsr_field_t PFSRE12_f;
    };
    union
    {
        __IO uint16_t PCRE13;
        stc_port_pcr_field_t PCRE13_f;
    };
    union
    {
        __IO uint16_t PFSRE13;
        stc_port_pfsr_field_t PFSRE13_f;
    };
    union
    {
        __IO uint16_t PCRE14;
        stc_port_pcr_field_t PCRE14_f;
    };
    union
    {
        __IO uint16_t PFSRE14;
        stc_port_pfsr_field_t PFSRE14_f;
    };
    union
    {
        __IO uint16_t PCRE15;
        stc_port_pcr_field_t PCRE15_f;
    };
    union
    {
        __IO uint16_t PFSRE15;
        stc_port_pfsr_field_t PFSRE15_f;
    };
    union
    {
        __IO uint16_t PCRH0;
        stc_port_pcr_field_t PCRH0_f;
    };
    union
    {
        __IO uint16_t PFSRH0;
        stc_port_pfsr_field_t PFSRH0_f;
    };
    union
    {
        __IO uint16_t PCRH1;
        stc_port_pcr_field_t PCRH1_f;
    };
    union
    {
        __IO uint16_t PFSRH1;
        stc_port_pfsr_field_t PFSRH1_f;
    };
    union
    {
        __IO uint16_t PCRH2;
        stc_port_pcr_field_t PCRH2_f;
    };
    union
    {
        __IO uint16_t PFSRH2;
        stc_port_pfsr_field_t PFSRH2_f;
    };
} M4_PORT_TypeDef;

/**
 * @brief QSPI
 */
typedef struct
{
    union
    {
        __IO uint32_t CR;
        stc_qspi_cr_field_t CR_f;
    };
    union
    {
        __IO uint32_t CSCR;
        stc_qspi_cscr_field_t CSCR_f;
    };
    union
    {
        __IO uint32_t FCR;
        stc_qspi_fcr_field_t FCR_f;
    };
    union
    {
        __IO uint32_t SR;
        stc_qspi_sr_field_t SR_f;
    };
    union
    {
        __IO uint32_t DCOM;
        stc_qspi_dcom_field_t DCOM_f;
    };
    union
    {
        __IO uint32_t CCMD;
        stc_qspi_ccmd_field_t CCMD_f;
    };
    union
    {
        __IO uint32_t XCMD;
        stc_qspi_xcmd_field_t XCMD_f;
    };
    uint8_t RESERVED0[8];
    union
    {
        __IO uint32_t SR2;
        stc_qspi_sr2_field_t SR2_f;
    };
    uint8_t RESERVED1[2012];
    union
    {
        __IO uint32_t EXAR;
        stc_qspi_exar_field_t EXAR_f;
    };
} M4_QSPI_TypeDef;

/**
 * @brief RTC
 */
typedef struct
{
    union
    {
        __IO uint8_t CR0;
        stc_rtc_cr0_field_t CR0_f;
    };
    uint8_t RESERVED0[3];
    union
    {
        __IO uint8_t CR1;
        stc_rtc_cr1_field_t CR1_f;
    };
    uint8_t RESERVED1[3];
    union
    {
        __IO uint8_t CR2;
        stc_rtc_cr2_field_t CR2_f;
    };
    uint8_t RESERVED2[3];
    union
    {
        __IO uint8_t CR3;
        stc_rtc_cr3_field_t CR3_f;
    };
    uint8_t RESERVED3[3];
    union
    {
        __IO uint8_t SEC;
        stc_rtc_sec_field_t SEC_f;
    };
    uint8_t RESERVED4[3];
    union
    {
        __IO uint8_t MIN;
        stc_rtc_min_field_t MIN_f;
    };
    uint8_t RESERVED5[3];
    union
    {
        __IO uint8_t HOUR;
        stc_rtc_hour_field_t HOUR_f;
    };
    uint8_t RESERVED6[3];
    union
    {
        __IO uint8_t WEEK;
        stc_rtc_week_field_t WEEK_f;
    };
    uint8_t RESERVED7[3];
    union
    {
        __IO uint8_t DAY;
        stc_rtc_day_field_t DAY_f;
    };
    uint8_t RESERVED8[3];
    union
    {
        __IO uint8_t MON;
        stc_rtc_mon_field_t MON_f;
    };
    uint8_t RESERVED9[3];
    union
    {
        __IO uint8_t YEAR;
        stc_rtc_year_field_t YEAR_f;
    };
    uint8_t RESERVED10[3];
    union
    {
        __IO uint8_t ALMMIN;
        stc_rtc_almmin_field_t ALMMIN_f;
    };
    uint8_t RESERVED11[3];
    union
    {
        __IO uint8_t ALMHOUR;
        stc_rtc_almhour_field_t ALMHOUR_f;
    };
    uint8_t RESERVED12[3];
    union
    {
        __IO uint8_t ALMWEEK;
        stc_rtc_almweek_field_t ALMWEEK_f;
    };
    uint8_t RESERVED13[3];
    union
    {
        __IO uint8_t ERRCRH;
        stc_rtc_errcrh_field_t ERRCRH_f;
    };
    uint8_t RESERVED14[3];
    union
    {
        __IO uint8_t ERRCRL;
        stc_rtc_errcrl_field_t ERRCRL_f;
    };
} M4_RTC_TypeDef;

/**
 * @brief SDIOC
 */
typedef struct
{
    uint8_t RESERVED0[4];
    union
    {
        __IO uint16_t BLKSIZE;
        stc_sdioc_blksize_field_t BLKSIZE_f;
    };
    __IO uint16_t BLKCNT;
    __IO uint16_t ARG0;
    __IO uint16_t ARG1;
    union
    {
        __IO uint16_t TRANSMODE;
        stc_sdioc_transmode_field_t TRANSMODE_f;
    };
    union
    {
        __IO uint16_t CMD;
        stc_sdioc_cmd_field_t CMD_f;
    };
    __IO uint16_t RESP0;
    __IO uint16_t RESP1;
    __IO uint16_t RESP2;
    __IO uint16_t RESP3;
    __IO uint16_t RESP4;
    __IO uint16_t RESP5;
    __IO uint16_t RESP6;
    __IO uint16_t RESP7;
    __IO uint16_t BUF0;
    __IO uint16_t BUF1;
    union
    {
        __IO uint32_t PSTAT;
        stc_sdioc_pstat_field_t PSTAT_f;
    };
    union
    {
        __IO uint8_t HOSTCON;
        stc_sdioc_hostcon_field_t HOSTCON_f;
    };
    union
    {
        __IO uint8_t PWRCON;
        stc_sdioc_pwrcon_field_t PWRCON_f;
    };
    union
    {
        __IO uint8_t BLKGPCON;
        stc_sdioc_blkgpcon_field_t BLKGPCON_f;
    };
    uint8_t RESERVED1[1];
    union
    {
        __IO uint16_t CLKCON;
        stc_sdioc_clkcon_field_t CLKCON_f;
    };
    union
    {
        __IO uint8_t TOUTCON;
        stc_sdioc_toutcon_field_t TOUTCON_f;
    };
    union
    {
        __IO uint8_t SFTRST;
        stc_sdioc_sftrst_field_t SFTRST_f;
    };
    union
    {
        __IO uint16_t NORINTST;
        stc_sdioc_norintst_field_t NORINTST_f;
    };
    union
    {
        __IO uint16_t ERRINTST;
        stc_sdioc_errintst_field_t ERRINTST_f;
    };
    union
    {
        __IO uint16_t NORINTSTEN;
        stc_sdioc_norintsten_field_t NORINTSTEN_f;
    };
    union
    {
        __IO uint16_t ERRINTSTEN;
        stc_sdioc_errintsten_field_t ERRINTSTEN_f;
    };
    union
    {
        __IO uint16_t NORINTSGEN;
        stc_sdioc_norintsgen_field_t NORINTSGEN_f;
    };
    union
    {
        __IO uint16_t ERRINTSGEN;
        stc_sdioc_errintsgen_field_t ERRINTSGEN_f;
    };
    union
    {
        __IO uint16_t ATCERRST;
        stc_sdioc_atcerrst_field_t ATCERRST_f;
    };
    uint8_t RESERVED2[18];
    union
    {
        __IO uint16_t FEA;
        stc_sdioc_fea_field_t FEA_f;
    };
    union
    {
        __IO uint16_t FEE;
        stc_sdioc_fee_field_t FEE_f;
    };
} M4_SDIOC_TypeDef;

/**
 * @brief SPI
 */
typedef struct
{
    __IO uint32_t DR;
    union
    {
        __IO uint32_t CR1;
        stc_spi_cr1_field_t CR1_f;
    };
    uint8_t RESERVED0[4];
    union
    {
        __IO uint32_t CFG1;
        stc_spi_cfg1_field_t CFG1_f;
    };
    uint8_t RESERVED1[4];
    union
    {
        __IO uint32_t SR;
        stc_spi_sr_field_t SR_f;
    };
    union
    {
        __IO uint32_t CFG2;
        stc_spi_cfg2_field_t CFG2_f;
    };
} M4_SPI_TypeDef;

/**
 * @brief SRAMC
 */
typedef struct
{
    union
    {
        __IO uint32_t WTCR;
        stc_sramc_wtcr_field_t WTCR_f;
    };
    union
    {
        __IO uint32_t WTPR;
        stc_sramc_wtpr_field_t WTPR_f;
    };
    union
    {
        __IO uint32_t CKCR;
        stc_sramc_ckcr_field_t CKCR_f;
    };
    union
    {
        __IO uint32_t CKPR;
        stc_sramc_ckpr_field_t CKPR_f;
    };
    union
    {
        __IO uint32_t CKSR;
        stc_sramc_cksr_field_t CKSR_f;
    };
} M4_SRAMC_TypeDef;

/**
 * @brief SWDT
 */
typedef struct
{
    uint8_t RESERVED0[4];
    union
    {
        __IO uint32_t SR;
        stc_swdt_sr_field_t SR_f;
    };
    union
    {
        __IO uint32_t RR;
        stc_swdt_rr_field_t RR_f;
    };
} M4_SWDT_TypeDef;

/**
 * @brief SYSREG
 */
typedef struct
{
    uint8_t RESERVED0[12];
    union
    {
        __IO uint16_t PWR_STPMCR;
        stc_sysreg_pwr_stpmcr_field_t PWR_STPMCR_f;
    };
    uint8_t RESERVED1[2];
    union
    {
        __IO uint16_t CMU_PERICKSEL;
        stc_sysreg_cmu_pericksel_field_t CMU_PERICKSEL_f;
    };
    union
    {
        __IO uint16_t CMU_I2SCKSEL;
        stc_sysreg_cmu_i2scksel_field_t CMU_I2SCKSEL_f;
    };
    union
    {
        __IO uint32_t PWR_RAMPC0;
        stc_sysreg_pwr_rampc0_field_t PWR_RAMPC0_f;
    };
    __IO uint16_t PWR_RAMOPM;
    uint8_t RESERVED2[2];
    union
    {
        __IO uint32_t MPU_IPPR;
        stc_sysreg_mpu_ippr_field_t MPU_IPPR_f;
    };
    union
    {
        __IO uint32_t CMU_SCFGR;
        stc_sysreg_cmu_scfgr_field_t CMU_SCFGR_f;
    };
    union
    {
        __IO uint8_t CMU_UFSCKCFGR;
        stc_sysreg_cmu_ufsckcfgr_field_t CMU_UFSCKCFGR_f;
    };
    uint8_t RESERVED3[1];
    union
    {
        __IO uint8_t CMU_CKSWR;
        stc_sysreg_cmu_ckswr_field_t CMU_CKSWR_f;
    };
    uint8_t RESERVED4[3];
    union
    {
        __IO uint8_t CMU_PLLCR;
        stc_sysreg_cmu_pllcr_field_t CMU_PLLCR_f;
    };
    uint8_t RESERVED5[3];
    union
    {
        __IO uint8_t CMU_UPLLCR;
        stc_sysreg_cmu_upllcr_field_t CMU_UPLLCR_f;
    };
    uint8_t RESERVED6[3];
    union
    {
        __IO uint8_t CMU_XTALCR;
        stc_sysreg_cmu_xtalcr_field_t CMU_XTALCR_f;
    };
    uint8_t RESERVED7[3];
    union
    {
        __IO uint8_t CMU_HRCCR;
        stc_sysreg_cmu_hrccr_field_t CMU_HRCCR_f;
    };
    uint8_t RESERVED8[1];
    union
    {
        __IO uint8_t CMU_MRCCR;
        stc_sysreg_cmu_mrccr_field_t CMU_MRCCR_f;
    };
    uint8_t RESERVED9[3];
    union
    {
        __IO uint8_t CMU_OSCSTBSR;
        stc_sysreg_cmu_oscstbsr_field_t CMU_OSCSTBSR_f;
    };
    union
    {
        __IO uint8_t CMU_MCO1CFGR;
        stc_sysreg_cmu_mco1cfgr_field_t CMU_MCO1CFGR_f;
    };
    union
    {
        __IO uint8_t CMU_MCO2CFGR;
        stc_sysreg_cmu_mco2cfgr_field_t CMU_MCO2CFGR_f;
    };
    union
    {
        __IO uint8_t CMU_TPIUCKCFGR;
        stc_sysreg_cmu_tpiuckcfgr_field_t CMU_TPIUCKCFGR_f;
    };
    union
    {
        __IO uint8_t CMU_XTALSTDCR;
        stc_sysreg_cmu_xtalstdcr_field_t CMU_XTALSTDCR_f;
    };
    union
    {
        __IO uint8_t CMU_XTALSTDSR;
        stc_sysreg_cmu_xtalstdsr_field_t CMU_XTALSTDSR_f;
    };
    uint8_t RESERVED10[31];
    __IO uint8_t CMU_MRCTRM;
    __IO uint8_t CMU_HRCTRM;
    uint8_t RESERVED11[63];
    union
    {
        __IO uint8_t CMU_XTALSTBCR;
        stc_sysreg_cmu_xtalstbcr_field_t CMU_XTALSTBCR_f;
    };
    uint8_t RESERVED12[29];
    union
    {
        __IO uint16_t RMU_RSTF0;
        stc_sysreg_rmu_rstf0_field_t RMU_RSTF0_f;
    };
    uint8_t RESERVED13[30];
    union
    {
        __IO uint8_t PWR_PVDICR;
        stc_sysreg_pwr_pvdicr_field_t PWR_PVDICR_f;
    };
    union
    {
        __IO uint8_t PWR_PVDDSR;
        stc_sysreg_pwr_pvddsr_field_t PWR_PVDDSR_f;
    };
    uint8_t RESERVED14[30];
    union
    {
        __IO uint32_t CMU_PLLCFGR;
        stc_sysreg_cmu_pllcfgr_field_t CMU_PLLCFGR_f;
    };
    union
    {
        __IO uint32_t CMU_UPLLCFGR;
        stc_sysreg_cmu_upllcfgr_field_t CMU_UPLLCFGR_f;
    };
    uint8_t RESERVED15[758];
    union
    {
        __IO uint16_t PWR_FPRC;
        stc_sysreg_pwr_fprc_field_t PWR_FPRC_f;
    };
    union
    {
        __IO uint8_t PWR_PWRC0;
        stc_sysreg_pwr_pwrc0_field_t PWR_PWRC0_f;
    };
    union
    {
        __IO uint8_t PWR_PWRC1;
        stc_sysreg_pwr_pwrc1_field_t PWR_PWRC1_f;
    };
    union
    {
        __IO uint8_t PWR_PWRC2;
        stc_sysreg_pwr_pwrc2_field_t PWR_PWRC2_f;
    };
    union
    {
        __IO uint8_t PWR_PWRC3;
        stc_sysreg_pwr_pwrc3_field_t PWR_PWRC3_f;
    };
    union
    {
        __IO uint8_t PWR_PDWKE0;
        stc_sysreg_pwr_pdwke0_field_t PWR_PDWKE0_f;
    };
    union
    {
        __IO uint8_t PWR_PDWKE1;
        stc_sysreg_pwr_pdwke1_field_t PWR_PDWKE1_f;
    };
    union
    {
        __IO uint8_t PWR_PDWKE2;
        stc_sysreg_pwr_pdwke2_field_t PWR_PDWKE2_f;
    };
    union
    {
        __IO uint8_t PWR_PDWKES;
        stc_sysreg_pwr_pdwkes_field_t PWR_PDWKES_f;
    };
    union
    {
        __IO uint8_t PWR_PDWKF0;
        stc_sysreg_pwr_pdwkf0_field_t PWR_PDWKF0_f;
    };
    union
    {
        __IO uint8_t PWR_PDWKF1;
        stc_sysreg_pwr_pdwkf1_field_t PWR_PDWKF1_f;
    };
    union
    {
        __IO uint8_t PWR_PWCMR;
        stc_sysreg_pwr_pwcmr_field_t PWR_PWCMR_f;
    };
    uint8_t RESERVED16[4];
    __IO uint8_t PWR_MDSWCR;
    union
    {
        __IO uint8_t CMU_XTALCFGR;
        stc_sysreg_cmu_xtalcfgr_field_t CMU_XTALCFGR_f;
    };
    uint8_t RESERVED17[1];
    union
    {
        __IO uint8_t PWR_PVDCR0;
        stc_sysreg_pwr_pvdcr0_field_t PWR_PVDCR0_f;
    };
    union
    {
        __IO uint8_t PWR_PVDCR1;
        stc_sysreg_pwr_pvdcr1_field_t PWR_PVDCR1_f;
    };
    union
    {
        __IO uint8_t PWR_PVDFCR;
        stc_sysreg_pwr_pvdfcr_field_t PWR_PVDFCR_f;
    };
    union
    {
        __IO uint8_t PWR_PVDLCR;
        stc_sysreg_pwr_pvdlcr_field_t PWR_PVDLCR_f;
    };
    uint8_t RESERVED18[10];
    union
    {
        __IO uint8_t CMU_XTAL32CR;
        stc_sysreg_cmu_xtal32cr_field_t CMU_XTAL32CR_f;
    };
    union
    {
        __IO uint8_t CMU_XTAL32CFGR;
        stc_sysreg_cmu_xtal32cfgr_field_t CMU_XTAL32CFGR_f;
    };
    uint8_t RESERVED19[3];
    union
    {
        __IO uint8_t CMU_XTAL32NFR;
        stc_sysreg_cmu_xtal32nfr_field_t CMU_XTAL32NFR_f;
    };
    uint8_t RESERVED20[1];
    union
    {
        __IO uint8_t CMU_LRCCR;
        stc_sysreg_cmu_lrccr_field_t CMU_LRCCR_f;
    };
    uint8_t RESERVED21[1];
    __IO uint8_t CMU_LRCTRM;
    uint8_t RESERVED22[1];
    union
    {
        __IO uint8_t PWR_XTAL32CS;
        stc_sysreg_pwr_xtal32cs_field_t PWR_XTAL32CS_f;
    };
} M4_SYSREG_TypeDef;

/**
 * @brief TMR0
 */
typedef struct
{
    union
    {
        __IO uint32_t CNTAR;
        stc_tmr0_cntar_field_t CNTAR_f;
    };
    union
    {
        __IO uint32_t CNTBR;
        stc_tmr0_cntbr_field_t CNTBR_f;
    };
    union
    {
        __IO uint32_t CMPAR;
        stc_tmr0_cmpar_field_t CMPAR_f;
    };
    union
    {
        __IO uint32_t CMPBR;
        stc_tmr0_cmpbr_field_t CMPBR_f;
    };
    union
    {
        __IO uint32_t BCONR;
        stc_tmr0_bconr_field_t BCONR_f;
    };
    union
    {
        __IO uint32_t STFLR;
        stc_tmr0_stflr_field_t STFLR_f;
    };
} M4_TMR0_TypeDef;

/**
 * @brief TMR4
 */
typedef struct
{
    uint8_t RESERVED0[2];
    __IO uint16_t OCCRUH;
    uint8_t RESERVED1[2];
    __IO uint16_t OCCRUL;
    uint8_t RESERVED2[2];
    __IO uint16_t OCCRVH;
    uint8_t RESERVED3[2];
    __IO uint16_t OCCRVL;
    uint8_t RESERVED4[2];
    __IO uint16_t OCCRWH;
    uint8_t RESERVED5[2];
    __IO uint16_t OCCRWL;
    union
    {
        __IO uint16_t OCSRU;
        stc_tmr4_ocsr_field_t OCSRU_f;
    };
    union
    {
        __IO uint16_t OCERU;
        stc_tmr4_ocer_field_t OCERU_f;
    };
    union
    {
        __IO uint16_t OCSRV;
        stc_tmr4_ocsr_field_t OCSRV_f;
    };
    union
    {
        __IO uint16_t OCERV;
        stc_tmr4_ocer_field_t OCERV_f;
    };
    union
    {
        __IO uint16_t OCSRW;
        stc_tmr4_ocsr_field_t OCSRW_f;
    };
    union
    {
        __IO uint16_t OCERW;
        stc_tmr4_ocer_field_t OCERW_f;
    };
    union
    {
        __IO uint16_t OCMRHUH;
        stc_tmr4_ocmrh_field_t OCMRHUH_f;
    };
    uint8_t RESERVED6[2];
    union
    {
        __IO uint32_t OCMRLUL;
        stc_tmr4_ocmrl_field_t OCMRLUL_f;
    };
    union
    {
        __IO uint16_t OCMRHVH;
        stc_tmr4_ocmrh_field_t OCMRHVH_f;
    };
    uint8_t RESERVED7[2];
    union
    {
        __IO uint32_t OCMRLVL;
        stc_tmr4_ocmrl_field_t OCMRLVL_f;
    };
    union
    {
        __IO uint16_t OCMRHWH;
        stc_tmr4_ocmrh_field_t OCMRHWH_f;
    };
    uint8_t RESERVED8[2];
    union
    {
        __IO uint32_t OCMRLWL;
        stc_tmr4_ocmrl_field_t OCMRLWL_f;
    };
    uint8_t RESERVED9[6];
    __IO uint16_t CPSR;
    uint8_t RESERVED10[2];
    __IO uint16_t CNTR;
    union
    {
        __IO uint16_t CCSR;
        stc_tmr4_ccsr_field_t CCSR_f;
    };
    union
    {
        __IO uint16_t CVPR;
        stc_tmr4_cvpr_field_t CVPR_f;
    };
    uint8_t RESERVED11[54];
    __IO uint16_t PFSRU;
    __IO uint16_t PDARU;
    __IO uint16_t PDBRU;
    uint8_t RESERVED12[2];
    __IO uint16_t PFSRV;
    __IO uint16_t PDARV;
    __IO uint16_t PDBRV;
    uint8_t RESERVED13[2];
    __IO uint16_t PFSRW;
    __IO uint16_t PDARW;
    __IO uint16_t PDBRW;
    union
    {
        __IO uint16_t POCRU;
        stc_tmr4_pocr_field_t POCRU_f;
    };
    uint8_t RESERVED14[2];
    union
    {
        __IO uint16_t POCRV;
        stc_tmr4_pocr_field_t POCRV_f;
    };
    uint8_t RESERVED15[2];
    union
    {
        __IO uint16_t POCRW;
        stc_tmr4_pocr_field_t POCRW_f;
    };
    uint8_t RESERVED16[2];
    union
    {
        __IO uint16_t RCSR;
        stc_tmr4_rcsr_field_t RCSR_f;
    };
    uint8_t RESERVED17[12];
    __IO uint16_t SCCRUH;
    uint8_t RESERVED18[2];
    __IO uint16_t SCCRUL;
    uint8_t RESERVED19[2];
    __IO uint16_t SCCRVH;
    uint8_t RESERVED20[2];
    __IO uint16_t SCCRVL;
    uint8_t RESERVED21[2];
    __IO uint16_t SCCRWH;
    uint8_t RESERVED22[2];
    __IO uint16_t SCCRWL;
    union
    {
        __IO uint16_t SCSRUH;
        stc_tmr4_scsr_field_t SCSRUH_f;
    };
    union
    {
        __IO uint16_t SCMRUH;
        stc_tmr4_scmr_field_t SCMRUH_f;
    };
    union
    {
        __IO uint16_t SCSRUL;
        stc_tmr4_scsr_field_t SCSRUL_f;
    };
    union
    {
        __IO uint16_t SCMRUL;
        stc_tmr4_scmr_field_t SCMRUL_f;
    };
    union
    {
        __IO uint16_t SCSRVH;
        stc_tmr4_scsr_field_t SCSRVH_f;
    };
    union
    {
        __IO uint16_t SCMRVH;
        stc_tmr4_scmr_field_t SCMRVH_f;
    };
    union
    {
        __IO uint16_t SCSRVL;
        stc_tmr4_scsr_field_t SCSRVL_f;
    };
    union
    {
        __IO uint16_t SCMRVL;
        stc_tmr4_scmr_field_t SCMRVL_f;
    };
    union
    {
        __IO uint16_t SCSRWH;
        stc_tmr4_scsr_field_t SCSRWH_f;
    };
    union
    {
        __IO uint16_t SCMRWH;
        stc_tmr4_scmr_field_t SCMRWH_f;
    };
    union
    {
        __IO uint16_t SCSRWL;
        stc_tmr4_scsr_field_t SCSRWL_f;
    };
    union
    {
        __IO uint16_t SCMRWL;
        stc_tmr4_scmr_field_t SCMRWL_f;
    };
    uint8_t RESERVED23[16];
    union
    {
        __IO uint16_t ECSR;
        stc_tmr4_ecsr_field_t ECSR_f;
    };
} M4_TMR4_TypeDef;

/**
 * @brief TMR4_CR
 */
typedef struct
{
    union
    {
        __IO uint16_t ECER1;
        stc_tmr4_cr_ecer1_field_t ECER1_f;
    };
    uint8_t RESERVED0[2];
    union
    {
        __IO uint16_t ECER2;
        stc_tmr4_cr_ecer2_field_t ECER2_f;
    };
    uint8_t RESERVED1[2];
    union
    {
        __IO uint16_t ECER3;
        stc_tmr4_cr_ecer3_field_t ECER3_f;
    };
} M4_TMR4_CR_TypeDef;

/**
 * @brief TMR6
 */
typedef struct
{
    union
    {
        __IO uint32_t CNTER;
        stc_tmr6_cnter_field_t CNTER_f;
    };
    union
    {
        __IO uint32_t PERAR;
        stc_tmr6_perar_field_t PERAR_f;
    };
    union
    {
        __IO uint32_t PERBR;
        stc_tmr6_perbr_field_t PERBR_f;
    };
    union
    {
        __IO uint32_t PERCR;
        stc_tmr6_percr_field_t PERCR_f;
    };
    union
    {
        __IO uint32_t GCMAR;
        stc_tmr6_gcmar_field_t GCMAR_f;
    };
    union
    {
        __IO uint32_t GCMBR;
        stc_tmr6_gcmbr_field_t GCMBR_f;
    };
    union
    {
        __IO uint32_t GCMCR;
        stc_tmr6_gcmcr_field_t GCMCR_f;
    };
    union
    {
        __IO uint32_t GCMDR;
        stc_tmr6_gcmdr_field_t GCMDR_f;
    };
    union
    {
        __IO uint32_t GCMER;
        stc_tmr6_gcmer_field_t GCMER_f;
    };
    union
    {
        __IO uint32_t GCMFR;
        stc_tmr6_gcmfr_field_t GCMFR_f;
    };
    union
    {
        __IO uint32_t SCMAR;
        stc_tmr6_scmar_field_t SCMAR_f;
    };
    union
    {
        __IO uint32_t SCMBR;
        stc_tmr6_scmbr_field_t SCMBR_f;
    };
    union
    {
        __IO uint32_t SCMCR;
        stc_tmr6_scmcr_field_t SCMCR_f;
    };
    union
    {
        __IO uint32_t SCMDR;
        stc_tmr6_scmdr_field_t SCMDR_f;
    };
    union
    {
        __IO uint32_t SCMER;
        stc_tmr6_scmer_field_t SCMER_f;
    };
    union
    {
        __IO uint32_t SCMFR;
        stc_tmr6_scmfr_field_t SCMFR_f;
    };
    union
    {
        __IO uint32_t DTUAR;
        stc_tmr6_dtuar_field_t DTUAR_f;
    };
    union
    {
        __IO uint32_t DTDAR;
        stc_tmr6_dtdar_field_t DTDAR_f;
    };
    union
    {
        __IO uint32_t DTUBR;
        stc_tmr6_dtubr_field_t DTUBR_f;
    };
    union
    {
        __IO uint32_t DTDBR;
        stc_tmr6_dtdbr_field_t DTDBR_f;
    };
    union
    {
        __IO uint32_t GCONR;
        stc_tmr6_gconr_field_t GCONR_f;
    };
    union
    {
        __IO uint32_t ICONR;
        stc_tmr6_iconr_field_t ICONR_f;
    };
    union
    {
        __IO uint32_t PCONR;
        stc_tmr6_pconr_field_t PCONR_f;
    };
    union
    {
        __IO uint32_t BCONR;
        stc_tmr6_bconr_field_t BCONR_f;
    };
    union
    {
        __IO uint32_t DCONR;
        stc_tmr6_dconr_field_t DCONR_f;
    };
    uint8_t RESERVED0[4];
    union
    {
        __IO uint32_t FCONR;
        stc_tmr6_fconr_field_t FCONR_f;
    };
    union
    {
        __IO uint32_t VPERR;
        stc_tmr6_vperr_field_t VPERR_f;
    };
    union
    {
        __IO uint32_t STFLR;
        stc_tmr6_stflr_field_t STFLR_f;
    };
    union
    {
        __IO uint32_t HSTAR;
        stc_tmr6_hstar_field_t HSTAR_f;
    };
    union
    {
        __IO uint32_t HSTPR;
        stc_tmr6_hstpr_field_t HSTPR_f;
    };
    union
    {
        __IO uint32_t HCLRR;
        stc_tmr6_hclrr_field_t HCLRR_f;
    };
    union
    {
        __IO uint32_t HCPAR;
        stc_tmr6_hcpar_field_t HCPAR_f;
    };
    union
    {
        __IO uint32_t HCPBR;
        stc_tmr6_hcpbr_field_t HCPBR_f;
    };
    union
    {
        __IO uint32_t HCUPR;
        stc_tmr6_hcupr_field_t HCUPR_f;
    };
    union
    {
        __IO uint32_t HCDOR;
        stc_tmr6_hcdor_field_t HCDOR_f;
    };
} M4_TMR6_TypeDef;

/**
 * @brief TMR6_CR
 */
typedef struct
{
    uint8_t RESERVED0[1012];
    union
    {
        __IO uint32_t SSTAR;
        stc_tmr6_cr_sstar_field_t SSTAR_f;
    };
    union
    {
        __IO uint32_t SSTPR;
        stc_tmr6_cr_sstpr_field_t SSTPR_f;
    };
    union
    {
        __IO uint32_t SCLRR;
        stc_tmr6_cr_sclrr_field_t SCLRR_f;
    };
} M4_TMR6_CR_TypeDef;

/**
 * @brief TMRA
 */
typedef struct
{
    union
    {
        __IO uint16_t CNTER;
        stc_tmra_cnter_field_t CNTER_f;
    };
    uint8_t RESERVED0[2];
    union
    {
        __IO uint16_t PERAR;
        stc_tmra_perar_field_t PERAR_f;
    };
    uint8_t RESERVED1[58];
    union
    {
        __IO uint16_t CMPAR1;
        stc_tmra_cmpar_field_t CMPAR1_f;
    };
    uint8_t RESERVED2[2];
    union
    {
        __IO uint16_t CMPAR2;
        stc_tmra_cmpar_field_t CMPAR2_f;
    };
    uint8_t RESERVED3[2];
    union
    {
        __IO uint16_t CMPAR3;
        stc_tmra_cmpar_field_t CMPAR3_f;
    };
    uint8_t RESERVED4[2];
    union
    {
        __IO uint16_t CMPAR4;
        stc_tmra_cmpar_field_t CMPAR4_f;
    };
    uint8_t RESERVED5[2];
    union
    {
        __IO uint16_t CMPAR5;
        stc_tmra_cmpar_field_t CMPAR5_f;
    };
    uint8_t RESERVED6[2];
    union
    {
        __IO uint16_t CMPAR6;
        stc_tmra_cmpar_field_t CMPAR6_f;
    };
    uint8_t RESERVED7[2];
    union
    {
        __IO uint16_t CMPAR7;
        stc_tmra_cmpar_field_t CMPAR7_f;
    };
    uint8_t RESERVED8[2];
    union
    {
        __IO uint16_t CMPAR8;
        stc_tmra_cmpar_field_t CMPAR8_f;
    };
    uint8_t RESERVED9[34];
    union
    {
        __IO uint16_t BCSTR;
        stc_tmra_bcstr_field_t BCSTR_f;
    };
    uint8_t RESERVED10[2];
    union
    {
        __IO uint16_t HCONR;
        stc_tmra_hconr_field_t HCONR_f;
    };
    uint8_t RESERVED11[2];
    union
    {
        __IO uint16_t HCUPR;
        stc_tmra_hcupr_field_t HCUPR_f;
    };
    uint8_t RESERVED12[2];
    union
    {
        __IO uint16_t HCDOR;
        stc_tmra_hcdor_field_t HCDOR_f;
    };
    uint8_t RESERVED13[2];
    union
    {
        __IO uint16_t ICONR;
        stc_tmra_iconr_field_t ICONR_f;
    };
    uint8_t RESERVED14[2];
    union
    {
        __IO uint16_t ECONR;
        stc_tmra_econr_field_t ECONR_f;
    };
    uint8_t RESERVED15[2];
    union
    {
        __IO uint16_t FCONR;
        stc_tmra_fconr_field_t FCONR_f;
    };
    uint8_t RESERVED16[2];
    union
    {
        __IO uint16_t STFLR;
        stc_tmra_stflr_field_t STFLR_f;
    };
    uint8_t RESERVED17[34];
    union
    {
        __IO uint16_t BCONR1;
        stc_tmra_bconr_field_t BCONR1_f;
    };
    uint8_t RESERVED18[6];
    union
    {
        __IO uint16_t BCONR2;
        stc_tmra_bconr_field_t BCONR2_f;
    };
    uint8_t RESERVED19[6];
    union
    {
        __IO uint16_t BCONR3;
        stc_tmra_bconr_field_t BCONR3_f;
    };
    uint8_t RESERVED20[6];
    union
    {
        __IO uint16_t BCONR4;
        stc_tmra_bconr_field_t BCONR4_f;
    };
    uint8_t RESERVED21[38];
    union
    {
        __IO uint16_t CCONR1;
        stc_tmra_cconr_field_t CCONR1_f;
    };
    uint8_t RESERVED22[2];
    union
    {
        __IO uint16_t CCONR2;
        stc_tmra_cconr_field_t CCONR2_f;
    };
    uint8_t RESERVED23[2];
    union
    {
        __IO uint16_t CCONR3;
        stc_tmra_cconr_field_t CCONR3_f;
    };
    uint8_t RESERVED24[2];
    union
    {
        __IO uint16_t CCONR4;
        stc_tmra_cconr_field_t CCONR4_f;
    };
    uint8_t RESERVED25[2];
    union
    {
        __IO uint16_t CCONR5;
        stc_tmra_cconr_field_t CCONR5_f;
    };
    uint8_t RESERVED26[2];
    union
    {
        __IO uint16_t CCONR6;
        stc_tmra_cconr_field_t CCONR6_f;
    };
    uint8_t RESERVED27[2];
    union
    {
        __IO uint16_t CCONR7;
        stc_tmra_cconr_field_t CCONR7_f;
    };
    uint8_t RESERVED28[2];
    union
    {
        __IO uint16_t CCONR8;
        stc_tmra_cconr_field_t CCONR8_f;
    };
    uint8_t RESERVED29[34];
    union
    {
        __IO uint16_t PCONR1;
        stc_tmra_pconr_field_t PCONR1_f;
    };
    uint8_t RESERVED30[2];
    union
    {
        __IO uint16_t PCONR2;
        stc_tmra_pconr_field_t PCONR2_f;
    };
    uint8_t RESERVED31[2];
    union
    {
        __IO uint16_t PCONR3;
        stc_tmra_pconr_field_t PCONR3_f;
    };
    uint8_t RESERVED32[2];
    union
    {
        __IO uint16_t PCONR4;
        stc_tmra_pconr_field_t PCONR4_f;
    };
    uint8_t RESERVED33[2];
    union
    {
        __IO uint16_t PCONR5;
        stc_tmra_pconr_field_t PCONR5_f;
    };
    uint8_t RESERVED34[2];
    union
    {
        __IO uint16_t PCONR6;
        stc_tmra_pconr_field_t PCONR6_f;
    };
    uint8_t RESERVED35[2];
    union
    {
        __IO uint16_t PCONR7;
        stc_tmra_pconr_field_t PCONR7_f;
    };
    uint8_t RESERVED36[2];
    union
    {
        __IO uint16_t PCONR8;
        stc_tmra_pconr_field_t PCONR8_f;
    };
} M4_TMRA_TypeDef;

/**
 * @brief TRNG
 */
typedef struct
{
    union
    {
        __IO uint32_t CR;
        stc_trng_cr_field_t CR_f;
    };
    union
    {
        __IO uint32_t MR;
        stc_trng_mr_field_t MR_f;
    };
    uint8_t RESERVED0[4];
    __IO uint32_t DR0;
    __IO uint32_t DR1;
} M4_TRNG_TypeDef;

/**
 * @brief USART
 */
typedef struct
{
    union
    {
        __IO uint32_t SR;
        stc_usart_sr_field_t SR_f;
    };
    union
    {
        __IO uint32_t DR;
        stc_usart_dr_field_t DR_f;
    };
    union
    {
        __IO uint32_t BRR;
        stc_usart_brr_field_t BRR_f;
    };
    union
    {
        __IO uint32_t CR1;
        stc_usart_cr1_field_t CR1_f;
    };
    union
    {
        __IO uint32_t CR2;
        stc_usart_cr2_field_t CR2_f;
    };
    union
    {
        __IO uint32_t CR3;
        stc_usart_cr3_field_t CR3_f;
    };
    union
    {
        __IO uint32_t PR;
        stc_usart_pr_field_t PR_f;
    };
} M4_USART_TypeDef;

/**
 * @brief USBFS
 */
typedef struct
{
    union
    {
        __IO uint32_t GVBUSCFG;
        stc_usbfs_gvbuscfg_field_t GVBUSCFG_f;
    };
    uint8_t RESERVED0[4];
    union
    {
        __IO uint32_t GAHBCFG;
        stc_usbfs_gahbcfg_field_t GAHBCFG_f;
    };
    union
    {
        __IO uint32_t GUSBCFG;
        stc_usbfs_gusbcfg_field_t GUSBCFG_f;
    };
    union
    {
        __IO uint32_t GRSTCTL;
        stc_usbfs_grstctl_field_t GRSTCTL_f;
    };
    union
    {
        __IO uint32_t GINTSTS;
        stc_usbfs_gintsts_field_t GINTSTS_f;
    };
    union
    {
        __IO uint32_t GINTMSK;
        stc_usbfs_gintmsk_field_t GINTMSK_f;
    };
    union
    {
        __IO uint32_t GRXSTSR;
        stc_usbfs_grxstsr_field_t GRXSTSR_f;
    };
    union
    {
        __IO uint32_t GRXSTSP;
        stc_usbfs_grxstsp_field_t GRXSTSP_f;
    };
    union
    {
        __IO uint32_t GRXFSIZ;
        stc_usbfs_grxfsiz_field_t GRXFSIZ_f;
    };
    union
    {
        __IO uint32_t HNPTXFSIZ;
        stc_usbfs_hnptxfsiz_field_t HNPTXFSIZ_f;
    };
    union
    {
        __IO uint32_t HNPTXSTS;
        stc_usbfs_hnptxsts_field_t HNPTXSTS_f;
    };
    uint8_t RESERVED1[12];
    __IO uint32_t CID;
    uint8_t RESERVED2[192];
    union
    {
        __IO uint32_t HPTXFSIZ;
        stc_usbfs_hptxfsiz_field_t HPTXFSIZ_f;
    };
    union
    {
        __IO uint32_t DIEPTXF1;
        stc_usbfs_dieptxf_field_t DIEPTXF1_f;
    };
    union
    {
        __IO uint32_t DIEPTXF2;
        stc_usbfs_dieptxf_field_t DIEPTXF2_f;
    };
    union
    {
        __IO uint32_t DIEPTXF3;
        stc_usbfs_dieptxf_field_t DIEPTXF3_f;
    };
    union
    {
        __IO uint32_t DIEPTXF4;
        stc_usbfs_dieptxf_field_t DIEPTXF4_f;
    };
    union
    {
        __IO uint32_t DIEPTXF5;
        stc_usbfs_dieptxf_field_t DIEPTXF5_f;
    };
    uint8_t RESERVED3[744];
    union
    {
        __IO uint32_t HCFG;
        stc_usbfs_hcfg_field_t HCFG_f;
    };
    union
    {
        __IO uint32_t HFIR;
        stc_usbfs_hfir_field_t HFIR_f;
    };
    union
    {
        __IO uint32_t HFNUM;
        stc_usbfs_hfnum_field_t HFNUM_f;
    };
    uint8_t RESERVED4[4];
    union
    {
        __IO uint32_t HPTXSTS;
        stc_usbfs_hptxsts_field_t HPTXSTS_f;
    };
    union
    {
        __IO uint32_t HAINT;
        stc_usbfs_haint_field_t HAINT_f;
    };
    union
    {
        __IO uint32_t HAINTMSK;
        stc_usbfs_haintmsk_field_t HAINTMSK_f;
    };
    uint8_t RESERVED5[36];
    union
    {
        __IO uint32_t HPRT;
        stc_usbfs_hprt_field_t HPRT_f;
    };
    uint8_t RESERVED6[188];
    union
    {
        __IO uint32_t HCCHAR0;
        stc_usbfs_hcchar_field_t HCCHAR0_f;
    };
    uint8_t RESERVED7[4];
    union
    {
        __IO uint32_t HCINT0;
        stc_usbfs_hcint_field_t HCINT0_f;
    };
    union
    {
        __IO uint32_t HCINTMSK0;
        stc_usbfs_hcintmsk_field_t HCINTMSK0_f;
    };
    union
    {
        __IO uint32_t HCTSIZ0;
        stc_usbfs_hctsiz_field_t HCTSIZ0_f;
    };
    __IO uint32_t HCDMA0;
    uint8_t RESERVED8[8];
    union
    {
        __IO uint32_t HCCHAR1;
        stc_usbfs_hcchar_field_t HCCHAR1_f;
    };
    uint8_t RESERVED9[4];
    union
    {
        __IO uint32_t HCINT1;
        stc_usbfs_hcint_field_t HCINT1_f;
    };
    union
    {
        __IO uint32_t HCINTMSK1;
        stc_usbfs_hcintmsk_field_t HCINTMSK1_f;
    };
    union
    {
        __IO uint32_t HCTSIZ1;
        stc_usbfs_hctsiz_field_t HCTSIZ1_f;
    };
    __IO uint32_t HCDMA1;
    uint8_t RESERVED10[8];
    union
    {
        __IO uint32_t HCCHAR2;
        stc_usbfs_hcchar_field_t HCCHAR2_f;
    };
    uint8_t RESERVED11[4];
    union
    {
        __IO uint32_t HCINT2;
        stc_usbfs_hcint_field_t HCINT2_f;
    };
    union
    {
        __IO uint32_t HCINTMSK2;
        stc_usbfs_hcintmsk_field_t HCINTMSK2_f;
    };
    union
    {
        __IO uint32_t HCTSIZ2;
        stc_usbfs_hctsiz_field_t HCTSIZ2_f;
    };
    __IO uint32_t HCDMA2;
    uint8_t RESERVED12[8];
    union
    {
        __IO uint32_t HCCHAR3;
        stc_usbfs_hcchar_field_t HCCHAR3_f;
    };
    uint8_t RESERVED13[4];
    union
    {
        __IO uint32_t HCINT3;
        stc_usbfs_hcint_field_t HCINT3_f;
    };
    union
    {
        __IO uint32_t HCINTMSK3;
        stc_usbfs_hcintmsk_field_t HCINTMSK3_f;
    };
    union
    {
        __IO uint32_t HCTSIZ3;
        stc_usbfs_hctsiz_field_t HCTSIZ3_f;
    };
    __IO uint32_t HCDMA3;
    uint8_t RESERVED14[8];
    union
    {
        __IO uint32_t HCCHAR4;
        stc_usbfs_hcchar_field_t HCCHAR4_f;
    };
    uint8_t RESERVED15[4];
    union
    {
        __IO uint32_t HCINT4;
        stc_usbfs_hcint_field_t HCINT4_f;
    };
    union
    {
        __IO uint32_t HCINTMSK4;
        stc_usbfs_hcintmsk_field_t HCINTMSK4_f;
    };
    union
    {
        __IO uint32_t HCTSIZ4;
        stc_usbfs_hctsiz_field_t HCTSIZ4_f;
    };
    __IO uint32_t HCDMA4;
    uint8_t RESERVED16[8];
    union
    {
        __IO uint32_t HCCHAR5;
        stc_usbfs_hcchar_field_t HCCHAR5_f;
    };
    uint8_t RESERVED17[4];
    union
    {
        __IO uint32_t HCINT5;
        stc_usbfs_hcint_field_t HCINT5_f;
    };
    union
    {
        __IO uint32_t HCINTMSK5;
        stc_usbfs_hcintmsk_field_t HCINTMSK5_f;
    };
    union
    {
        __IO uint32_t HCTSIZ5;
        stc_usbfs_hctsiz_field_t HCTSIZ5_f;
    };
    __IO uint32_t HCDMA5;
    uint8_t RESERVED18[8];
    union
    {
        __IO uint32_t HCCHAR6;
        stc_usbfs_hcchar_field_t HCCHAR6_f;
    };
    uint8_t RESERVED19[4];
    union
    {
        __IO uint32_t HCINT6;
        stc_usbfs_hcint_field_t HCINT6_f;
    };
    union
    {
        __IO uint32_t HCINTMSK6;
        stc_usbfs_hcintmsk_field_t HCINTMSK6_f;
    };
    union
    {
        __IO uint32_t HCTSIZ6;
        stc_usbfs_hctsiz_field_t HCTSIZ6_f;
    };
    __IO uint32_t HCDMA6;
    uint8_t RESERVED20[8];
    union
    {
        __IO uint32_t HCCHAR7;
        stc_usbfs_hcchar_field_t HCCHAR7_f;
    };
    uint8_t RESERVED21[4];
    union
    {
        __IO uint32_t HCINT7;
        stc_usbfs_hcint_field_t HCINT7_f;
    };
    union
    {
        __IO uint32_t HCINTMSK7;
        stc_usbfs_hcintmsk_field_t HCINTMSK7_f;
    };
    union
    {
        __IO uint32_t HCTSIZ7;
        stc_usbfs_hctsiz_field_t HCTSIZ7_f;
    };
    __IO uint32_t HCDMA7;
    uint8_t RESERVED22[8];
    union
    {
        __IO uint32_t HCCHAR8;
        stc_usbfs_hcchar_field_t HCCHAR8_f;
    };
    uint8_t RESERVED23[4];
    union
    {
        __IO uint32_t HCINT8;
        stc_usbfs_hcint_field_t HCINT8_f;
    };
    union
    {
        __IO uint32_t HCINTMSK8;
        stc_usbfs_hcintmsk_field_t HCINTMSK8_f;
    };
    union
    {
        __IO uint32_t HCTSIZ8;
        stc_usbfs_hctsiz_field_t HCTSIZ8_f;
    };
    __IO uint32_t HCDMA8;
    uint8_t RESERVED24[8];
    union
    {
        __IO uint32_t HCCHAR9;
        stc_usbfs_hcchar_field_t HCCHAR9_f;
    };
    uint8_t RESERVED25[4];
    union
    {
        __IO uint32_t HCINT9;
        stc_usbfs_hcint_field_t HCINT9_f;
    };
    union
    {
        __IO uint32_t HCINTMSK9;
        stc_usbfs_hcintmsk_field_t HCINTMSK9_f;
    };
    union
    {
        __IO uint32_t HCTSIZ9;
        stc_usbfs_hctsiz_field_t HCTSIZ9_f;
    };
    __IO uint32_t HCDMA9;
    uint8_t RESERVED26[8];
    union
    {
        __IO uint32_t HCCHAR10;
        stc_usbfs_hcchar_field_t HCCHAR10_f;
    };
    uint8_t RESERVED27[4];
    union
    {
        __IO uint32_t HCINT10;
        stc_usbfs_hcint_field_t HCINT10_f;
    };
    union
    {
        __IO uint32_t HCINTMSK10;
        stc_usbfs_hcintmsk_field_t HCINTMSK10_f;
    };
    union
    {
        __IO uint32_t HCTSIZ10;
        stc_usbfs_hctsiz_field_t HCTSIZ10_f;
    };
    __IO uint32_t HCDMA10;
    uint8_t RESERVED28[8];
    union
    {
        __IO uint32_t HCCHAR11;
        stc_usbfs_hcchar_field_t HCCHAR11_f;
    };
    uint8_t RESERVED29[4];
    union
    {
        __IO uint32_t HCINT11;
        stc_usbfs_hcint_field_t HCINT11_f;
    };
    union
    {
        __IO uint32_t HCINTMSK11;
        stc_usbfs_hcintmsk_field_t HCINTMSK11_f;
    };
    union
    {
        __IO uint32_t HCTSIZ11;
        stc_usbfs_hctsiz_field_t HCTSIZ11_f;
    };
    __IO uint32_t HCDMA11;
    uint8_t RESERVED30[392];
    union
    {
        __IO uint32_t DCFG;
        stc_usbfs_dcfg_field_t DCFG_f;
    };
    union
    {
        __IO uint32_t DCTL;
        stc_usbfs_dctl_field_t DCTL_f;
    };
    union
    {
        __IO uint32_t DSTS;
        stc_usbfs_dsts_field_t DSTS_f;
    };
    uint8_t RESERVED31[4];
    union
    {
        __IO uint32_t DIEPMSK;
        stc_usbfs_diepmsk_field_t DIEPMSK_f;
    };
    union
    {
        __IO uint32_t DOEPMSK;
        stc_usbfs_doepmsk_field_t DOEPMSK_f;
    };
    union
    {
        __IO uint32_t DAINT;
        stc_usbfs_daint_field_t DAINT_f;
    };
    union
    {
        __IO uint32_t DAINTMSK;
        stc_usbfs_daintmsk_field_t DAINTMSK_f;
    };
    uint8_t RESERVED32[20];
    union
    {
        __IO uint32_t DIEPEMPMSK;
        stc_usbfs_diepempmsk_field_t DIEPEMPMSK_f;
    };
    uint8_t RESERVED33[200];
    union
    {
        __IO uint32_t DIEPCTL0;
        stc_usbfs_diepctl0_field_t DIEPCTL0_f;
    };
    uint8_t RESERVED34[4];
    union
    {
        __IO uint32_t DIEPINT0;
        stc_usbfs_diepint0_field_t DIEPINT0_f;
    };
    uint8_t RESERVED35[4];
    union
    {
        __IO uint32_t DIEPTSIZ0;
        stc_usbfs_dieptsiz0_field_t DIEPTSIZ0_f;
    };
    __IO uint32_t DIEPDMA0;
    union
    {
        __IO uint32_t DTXFSTS0;
        stc_usbfs_dtxfsts0_field_t DTXFSTS0_f;
    };
    uint8_t RESERVED36[4];
    union
    {
        __IO uint32_t DIEPCTL1;
        stc_usbfs_diepctl_field_t DIEPCTL1_f;
    };
    uint8_t RESERVED37[4];
    union
    {
        __IO uint32_t DIEPINT1;
        stc_usbfs_diepint_field_t DIEPINT1_f;
    };
    uint8_t RESERVED38[4];
    union
    {
        __IO uint32_t DIEPTSIZ1;
        stc_usbfs_dieptsiz_field_t DIEPTSIZ1_f;
    };
    __IO uint32_t DIEPDMA1;
    union
    {
        __IO uint32_t DTXFSTS1;
        stc_usbfs_dtxfsts_field_t DTXFSTS1_f;
    };
    uint8_t RESERVED39[4];
    union
    {
        __IO uint32_t DIEPCTL2;
        stc_usbfs_diepctl_field_t DIEPCTL2_f;
    };
    uint8_t RESERVED40[4];
    union
    {
        __IO uint32_t DIEPINT2;
        stc_usbfs_diepint_field_t DIEPINT2_f;
    };
    uint8_t RESERVED41[4];
    union
    {
        __IO uint32_t DIEPTSIZ2;
        stc_usbfs_dieptsiz_field_t DIEPTSIZ2_f;
    };
    __IO uint32_t DIEPDMA2;
    union
    {
        __IO uint32_t DTXFSTS2;
        stc_usbfs_dtxfsts_field_t DTXFSTS2_f;
    };
    uint8_t RESERVED42[4];
    union
    {
        __IO uint32_t DIEPCTL3;
        stc_usbfs_diepctl_field_t DIEPCTL3_f;
    };
    uint8_t RESERVED43[4];
    union
    {
        __IO uint32_t DIEPINT3;
        stc_usbfs_diepint_field_t DIEPINT3_f;
    };
    uint8_t RESERVED44[4];
    union
    {
        __IO uint32_t DIEPTSIZ3;
        stc_usbfs_dieptsiz_field_t DIEPTSIZ3_f;
    };
    __IO uint32_t DIEPDMA3;
    union
    {
        __IO uint32_t DTXFSTS3;
        stc_usbfs_dtxfsts_field_t DTXFSTS3_f;
    };
    uint8_t RESERVED45[4];
    union
    {
        __IO uint32_t DIEPCTL4;
        stc_usbfs_diepctl_field_t DIEPCTL4_f;
    };
    uint8_t RESERVED46[4];
    union
    {
        __IO uint32_t DIEPINT4;
        stc_usbfs_diepint_field_t DIEPINT4_f;
    };
    uint8_t RESERVED47[4];
    union
    {
        __IO uint32_t DIEPTSIZ4;
        stc_usbfs_dieptsiz_field_t DIEPTSIZ4_f;
    };
    __IO uint32_t DIEPDMA4;
    union
    {
        __IO uint32_t DTXFSTS4;
        stc_usbfs_dtxfsts_field_t DTXFSTS4_f;
    };
    uint8_t RESERVED48[4];
    union
    {
        __IO uint32_t DIEPCTL5;
        stc_usbfs_diepctl_field_t DIEPCTL5_f;
    };
    uint8_t RESERVED49[4];
    union
    {
        __IO uint32_t DIEPINT5;
        stc_usbfs_diepint_field_t DIEPINT5_f;
    };
    uint8_t RESERVED50[4];
    union
    {
        __IO uint32_t DIEPTSIZ5;
        stc_usbfs_dieptsiz_field_t DIEPTSIZ5_f;
    };
    __IO uint32_t DIEPDMA5;
    union
    {
        __IO uint32_t DTXFSTS5;
        stc_usbfs_dtxfsts_field_t DTXFSTS5_f;
    };
    uint8_t RESERVED51[324];
    union
    {
        __IO uint32_t DOEPCTL0;
        stc_usbfs_doepctl0_field_t DOEPCTL0_f;
    };
    uint8_t RESERVED52[4];
    union
    {
        __IO uint32_t DOEPINT0;
        stc_usbfs_doepint_field_t DOEPINT0_f;
    };
    uint8_t RESERVED53[4];
    union
    {
        __IO uint32_t DOEPTSIZ0;
        stc_usbfs_doeptsiz0_field_t DOEPTSIZ0_f;
    };
    __IO uint32_t DOEPDMA0;
    uint8_t RESERVED54[8];
    union
    {
        __IO uint32_t DOEPCTL1;
        stc_usbfs_doepctl_field_t DOEPCTL1_f;
    };
    uint8_t RESERVED55[4];
    union
    {
        __IO uint32_t DOEPINT1;
        stc_usbfs_doepint_field_t DOEPINT1_f;
    };
    uint8_t RESERVED56[4];
    union
    {
        __IO uint32_t DOEPTSIZ1;
        stc_usbfs_doeptsiz_field_t DOEPTSIZ1_f;
    };
    __IO uint32_t DOEPDMA1;
    uint8_t RESERVED57[8];
    union
    {
        __IO uint32_t DOEPCTL2;
        stc_usbfs_doepctl_field_t DOEPCTL2_f;
    };
    uint8_t RESERVED58[4];
    union
    {
        __IO uint32_t DOEPINT2;
        stc_usbfs_doepint_field_t DOEPINT2_f;
    };
    uint8_t RESERVED59[4];
    union
    {
        __IO uint32_t DOEPTSIZ2;
        stc_usbfs_doeptsiz_field_t DOEPTSIZ2_f;
    };
    __IO uint32_t DOEPDMA2;
    uint8_t RESERVED60[8];
    union
    {
        __IO uint32_t DOEPCTL3;
        stc_usbfs_doepctl_field_t DOEPCTL3_f;
    };
    uint8_t RESERVED61[4];
    union
    {
        __IO uint32_t DOEPINT3;
        stc_usbfs_doepint_field_t DOEPINT3_f;
    };
    uint8_t RESERVED62[4];
    union
    {
        __IO uint32_t DOEPTSIZ3;
        stc_usbfs_doeptsiz_field_t DOEPTSIZ3_f;
    };
    __IO uint32_t DOEPDMA3;
    uint8_t RESERVED63[8];
    union
    {
        __IO uint32_t DOEPCTL4;
        stc_usbfs_doepctl_field_t DOEPCTL4_f;
    };
    uint8_t RESERVED64[4];
    union
    {
        __IO uint32_t DOEPINT4;
        stc_usbfs_doepint_field_t DOEPINT4_f;
    };
    uint8_t RESERVED65[4];
    union
    {
        __IO uint32_t DOEPTSIZ4;
        stc_usbfs_doeptsiz_field_t DOEPTSIZ4_f;
    };
    __IO uint32_t DOEPDMA4;
    uint8_t RESERVED66[8];
    union
    {
        __IO uint32_t DOEPCTL5;
        stc_usbfs_doepctl_field_t DOEPCTL5_f;
    };
    uint8_t RESERVED67[4];
    union
    {
        __IO uint32_t DOEPINT5;
        stc_usbfs_doepint_field_t DOEPINT5_f;
    };
    uint8_t RESERVED68[4];
    union
    {
        __IO uint32_t DOEPTSIZ5;
        stc_usbfs_doeptsiz_field_t DOEPTSIZ5_f;
    };
    __IO uint32_t DOEPDMA5;
    uint8_t RESERVED69[584];
    union
    {
        __IO uint32_t PCGCCTL;
        stc_usbfs_pcgcctl_field_t PCGCCTL_f;
    };
} M4_USBFS_TypeDef;

/**
 * @brief WDT
 */
typedef struct
{
    union
    {
        __IO uint32_t CR;
        stc_wdt_cr_field_t CR_f;
    };
    union
    {
        __IO uint32_t SR;
        stc_wdt_sr_field_t SR_f;
    };
    union
    {
        __IO uint32_t RR;
        stc_wdt_rr_field_t RR_f;
    };
} M4_WDT_TypeDef;

/**
 * @brief WKTM
 */
typedef struct
{
    union
    {
        __IO uint16_t CR;
        stc_wktm_cr_field_t CR_f;
    };
} M4_WKTM_TypeDef;



/******************************************************************************/
/*           Device Specific Peripheral declaration & memory map              */
/******************************************************************************/

#define M4_ADC1                              ((M4_ADC_TypeDef *)0x40040000UL)
#define M4_ADC2                              ((M4_ADC_TypeDef *)0x40040400UL)
#define M4_AES                               ((M4_AES_TypeDef *)0x40008000UL)
#define M4_AOS                               ((M4_AOS_TypeDef *)0x40010800UL)
#define M4_CAN                               ((M4_CAN_TypeDef *)0x40070400UL)
#define M4_CMP1                              ((M4_CMP_TypeDef *)0x4004A000UL)
#define M4_CMP2                              ((M4_CMP_TypeDef *)0x4004A010UL)
#define M4_CMP3                              ((M4_CMP_TypeDef *)0x4004A020UL)
#define M4_CMP_CR                            ((M4_CMP_CR_TypeDef *)0x4004A000UL)
#define M4_CRC                               ((M4_CRC_TypeDef *)0x40008C00UL)
#define M4_DBGC                              ((M4_DBGC_TypeDef *)0xE0042000UL)
#define M4_DCU1                              ((M4_DCU_TypeDef *)0x40052000UL)
#define M4_DCU2                              ((M4_DCU_TypeDef *)0x40052400UL)
#define M4_DCU3                              ((M4_DCU_TypeDef *)0x40052800UL)
#define M4_DCU4                              ((M4_DCU_TypeDef *)0x40052C00UL)
#define M4_DMA1                              ((M4_DMA_TypeDef *)0x40053000UL)
#define M4_DMA2                              ((M4_DMA_TypeDef *)0x40053400UL)
#define M4_EFM                               ((M4_EFM_TypeDef *)0x40010400UL)
#define M4_EMB1                              ((M4_EMB_TypeDef *)0x40017C00UL)
#define M4_EMB2                              ((M4_EMB_TypeDef *)0x40017C20UL)
#define M4_EMB3                              ((M4_EMB_TypeDef *)0x40017C40UL)
#define M4_EMB4                              ((M4_EMB_TypeDef *)0x40017C60UL)
#define M4_FCM                               ((M4_FCM_TypeDef *)0x40048400UL)
#define M4_HASH                              ((M4_HASH_TypeDef *)0x40008400UL)
#define M4_I2C1                              ((M4_I2C_TypeDef *)0x4004E000UL)
#define M4_I2C2                              ((M4_I2C_TypeDef *)0x4004E400UL)
#define M4_I2C3                              ((M4_I2C_TypeDef *)0x4004E800UL)
#define M4_I2S1                              ((M4_I2S_TypeDef *)0x4001E000UL)
#define M4_I2S2                              ((M4_I2S_TypeDef *)0x4001E400UL)
#define M4_I2S3                              ((M4_I2S_TypeDef *)0x40022000UL)
#define M4_I2S4                              ((M4_I2S_TypeDef *)0x40022400UL)
#define M4_ICG                               ((M4_ICG_TypeDef *)0x00000400UL)
#define M4_INTC                              ((M4_INTC_TypeDef *)0x40051000UL)
#define M4_KEYSCAN                           ((M4_KEYSCAN_TypeDef *)0x40050C00UL)
#define M4_MPU                               ((M4_MPU_TypeDef *)0x40050000UL)
#define M4_MSTP                              ((M4_MSTP_TypeDef *)0x40048000UL)
#define M4_OTS                               ((M4_OTS_TypeDef *)0x4004A400UL)
#define M4_PERIC                             ((M4_PERIC_TypeDef *)0x40055400UL)
#define M4_PORT                              ((M4_PORT_TypeDef *)0x40053800UL)
#define M4_QSPI                              ((M4_QSPI_TypeDef *)0x9C000000UL)
#define M4_RTC                               ((M4_RTC_TypeDef *)0x4004C000UL)
#define M4_SDIOC1                            ((M4_SDIOC_TypeDef *)0x4006FC00UL)
#define M4_SDIOC2                            ((M4_SDIOC_TypeDef *)0x40070000UL)
#define M4_SPI1                              ((M4_SPI_TypeDef *)0x4001C000UL)
#define M4_SPI2                              ((M4_SPI_TypeDef *)0x4001C400UL)
#define M4_SPI3                              ((M4_SPI_TypeDef *)0x40020000UL)
#define M4_SPI4                              ((M4_SPI_TypeDef *)0x40020400UL)
#define M4_SRAMC                             ((M4_SRAMC_TypeDef *)0x40050800UL)
#define M4_SWDT                              ((M4_SWDT_TypeDef *)0x40049400UL)
#define M4_SYSREG                            ((M4_SYSREG_TypeDef *)0x40054000UL)
#define M4_TMR01                             ((M4_TMR0_TypeDef *)0x40024000UL)
#define M4_TMR02                             ((M4_TMR0_TypeDef *)0x40024400UL)
#define M4_TMR41                             ((M4_TMR4_TypeDef *)0x40017000UL)
#define M4_TMR42                             ((M4_TMR4_TypeDef *)0x40024800UL)
#define M4_TMR43                             ((M4_TMR4_TypeDef *)0x40024C00UL)
#define M4_TMR4_CR                           ((M4_TMR4_CR_TypeDef *)0x40055408UL)
#define M4_TMR61                             ((M4_TMR6_TypeDef *)0x40018000UL)
#define M4_TMR62                             ((M4_TMR6_TypeDef *)0x40018400UL)
#define M4_TMR63                             ((M4_TMR6_TypeDef *)0x40018800UL)
#define M4_TMR6_CR                           ((M4_TMR6_CR_TypeDef *)0x40018000UL)
#define M4_TMRA1                             ((M4_TMRA_TypeDef *)0x40015000UL)
#define M4_TMRA2                             ((M4_TMRA_TypeDef *)0x40015400UL)
#define M4_TMRA3                             ((M4_TMRA_TypeDef *)0x40015800UL)
#define M4_TMRA4                             ((M4_TMRA_TypeDef *)0x40015C00UL)
#define M4_TMRA5                             ((M4_TMRA_TypeDef *)0x40016000UL)
#define M4_TMRA6                             ((M4_TMRA_TypeDef *)0x40016400UL)
#define M4_TRNG                              ((M4_TRNG_TypeDef *)0x40041000UL)
#define M4_USART1                            ((M4_USART_TypeDef *)0x4001D000UL)
#define M4_USART2                            ((M4_USART_TypeDef *)0x4001D400UL)
#define M4_USART3                            ((M4_USART_TypeDef *)0x40021000UL)
#define M4_USART4                            ((M4_USART_TypeDef *)0x40021400UL)
#define M4_USBFS                             ((M4_USBFS_TypeDef *)0x400C0000UL)
#define M4_WDT                               ((M4_WDT_TypeDef *)0x40049000UL)
#define M4_WKTM                              ((M4_WKTM_TypeDef *)0x4004C400UL)


/******************************************************************************/
/*      Device Specific Peripheral bit_band declaration & memory map          */
/******************************************************************************/

#define bM4_ADC1_STR_STRT                         (*((volatile unsigned int*)(0x42800000UL)))
#define bM4_ADC1_CR0_MS0                          (*((volatile unsigned int*)(0x42800040UL)))
#define bM4_ADC1_CR0_MS1                          (*((volatile unsigned int*)(0x42800044UL)))
#define bM4_ADC1_CR0_ACCSEL0                      (*((volatile unsigned int*)(0x42800050UL)))
#define bM4_ADC1_CR0_ACCSEL1                      (*((volatile unsigned int*)(0x42800054UL)))
#define bM4_ADC1_CR0_CLREN                        (*((volatile unsigned int*)(0x42800058UL)))
#define bM4_ADC1_CR0_DFMT                         (*((volatile unsigned int*)(0x4280005CUL)))
#define bM4_ADC1_CR0_AVCNT0                       (*((volatile unsigned int*)(0x42800060UL)))
#define bM4_ADC1_CR0_AVCNT1                       (*((volatile unsigned int*)(0x42800064UL)))
#define bM4_ADC1_CR0_AVCNT2                       (*((volatile unsigned int*)(0x42800068UL)))
#define bM4_ADC1_CR1_RSCHSEL                      (*((volatile unsigned int*)(0x42800088UL)))
#define bM4_ADC1_TRGSR_TRGSELA0                   (*((volatile unsigned int*)(0x42800140UL)))
#define bM4_ADC1_TRGSR_TRGSELA1                   (*((volatile unsigned int*)(0x42800144UL)))
#define bM4_ADC1_TRGSR_TRGSELA2                   (*((volatile unsigned int*)(0x42800148UL)))
#define bM4_ADC1_TRGSR_TRGENA                     (*((volatile unsigned int*)(0x4280015CUL)))
#define bM4_ADC1_TRGSR_TRGSELB0                   (*((volatile unsigned int*)(0x42800160UL)))
#define bM4_ADC1_TRGSR_TRGSELB1                   (*((volatile unsigned int*)(0x42800164UL)))
#define bM4_ADC1_TRGSR_TRGSELB2                   (*((volatile unsigned int*)(0x42800168UL)))
#define bM4_ADC1_TRGSR_TRGENB                     (*((volatile unsigned int*)(0x4280017CUL)))
#define bM4_ADC1_CHSELRA1_CHSELA16                (*((volatile unsigned int*)(0x428001C0UL)))
#define bM4_ADC1_CHSELRB1_CHSELB16                (*((volatile unsigned int*)(0x42800240UL)))
#define bM4_ADC1_AVCHSELR1_AVCHSEL16              (*((volatile unsigned int*)(0x428002C0UL)))
#define bM4_ADC1_CHMUXR0_CH00MUX0                 (*((volatile unsigned int*)(0x42800700UL)))
#define bM4_ADC1_CHMUXR0_CH00MUX1                 (*((volatile unsigned int*)(0x42800704UL)))
#define bM4_ADC1_CHMUXR0_CH00MUX2                 (*((volatile unsigned int*)(0x42800708UL)))
#define bM4_ADC1_CHMUXR0_CH00MUX3                 (*((volatile unsigned int*)(0x4280070CUL)))
#define bM4_ADC1_CHMUXR0_CH01MUX0                 (*((volatile unsigned int*)(0x42800710UL)))
#define bM4_ADC1_CHMUXR0_CH01MUX1                 (*((volatile unsigned int*)(0x42800714UL)))
#define bM4_ADC1_CHMUXR0_CH01MUX2                 (*((volatile unsigned int*)(0x42800718UL)))
#define bM4_ADC1_CHMUXR0_CH01MUX3                 (*((volatile unsigned int*)(0x4280071CUL)))
#define bM4_ADC1_CHMUXR0_CH02MUX0                 (*((volatile unsigned int*)(0x42800720UL)))
#define bM4_ADC1_CHMUXR0_CH02MUX1                 (*((volatile unsigned int*)(0x42800724UL)))
#define bM4_ADC1_CHMUXR0_CH02MUX2                 (*((volatile unsigned int*)(0x42800728UL)))
#define bM4_ADC1_CHMUXR0_CH02MUX3                 (*((volatile unsigned int*)(0x4280072CUL)))
#define bM4_ADC1_CHMUXR0_CH03MUX0                 (*((volatile unsigned int*)(0x42800730UL)))
#define bM4_ADC1_CHMUXR0_CH03MUX1                 (*((volatile unsigned int*)(0x42800734UL)))
#define bM4_ADC1_CHMUXR0_CH03MUX2                 (*((volatile unsigned int*)(0x42800738UL)))
#define bM4_ADC1_CHMUXR0_CH03MUX3                 (*((volatile unsigned int*)(0x4280073CUL)))
#define bM4_ADC1_CHMUXR1_CH04MUX0                 (*((volatile unsigned int*)(0x42800740UL)))
#define bM4_ADC1_CHMUXR1_CH04MUX1                 (*((volatile unsigned int*)(0x42800744UL)))
#define bM4_ADC1_CHMUXR1_CH04MUX2                 (*((volatile unsigned int*)(0x42800748UL)))
#define bM4_ADC1_CHMUXR1_CH04MUX3                 (*((volatile unsigned int*)(0x4280074CUL)))
#define bM4_ADC1_CHMUXR1_CH05MUX0                 (*((volatile unsigned int*)(0x42800750UL)))
#define bM4_ADC1_CHMUXR1_CH05MUX1                 (*((volatile unsigned int*)(0x42800754UL)))
#define bM4_ADC1_CHMUXR1_CH05MUX2                 (*((volatile unsigned int*)(0x42800758UL)))
#define bM4_ADC1_CHMUXR1_CH05MUX3                 (*((volatile unsigned int*)(0x4280075CUL)))
#define bM4_ADC1_CHMUXR1_CH06MUX0                 (*((volatile unsigned int*)(0x42800760UL)))
#define bM4_ADC1_CHMUXR1_CH06MUX1                 (*((volatile unsigned int*)(0x42800764UL)))
#define bM4_ADC1_CHMUXR1_CH06MUX2                 (*((volatile unsigned int*)(0x42800768UL)))
#define bM4_ADC1_CHMUXR1_CH06MUX3                 (*((volatile unsigned int*)(0x4280076CUL)))
#define bM4_ADC1_CHMUXR1_CH07MUX0                 (*((volatile unsigned int*)(0x42800770UL)))
#define bM4_ADC1_CHMUXR1_CH07MUX1                 (*((volatile unsigned int*)(0x42800774UL)))
#define bM4_ADC1_CHMUXR1_CH07MUX2                 (*((volatile unsigned int*)(0x42800778UL)))
#define bM4_ADC1_CHMUXR1_CH07MUX3                 (*((volatile unsigned int*)(0x4280077CUL)))
#define bM4_ADC1_CHMUXR2_CH08MUX0                 (*((volatile unsigned int*)(0x42800780UL)))
#define bM4_ADC1_CHMUXR2_CH08MUX1                 (*((volatile unsigned int*)(0x42800784UL)))
#define bM4_ADC1_CHMUXR2_CH08MUX2                 (*((volatile unsigned int*)(0x42800788UL)))
#define bM4_ADC1_CHMUXR2_CH08MUX3                 (*((volatile unsigned int*)(0x4280078CUL)))
#define bM4_ADC1_CHMUXR2_CH09MUX0                 (*((volatile unsigned int*)(0x42800790UL)))
#define bM4_ADC1_CHMUXR2_CH09MUX1                 (*((volatile unsigned int*)(0x42800794UL)))
#define bM4_ADC1_CHMUXR2_CH09MUX2                 (*((volatile unsigned int*)(0x42800798UL)))
#define bM4_ADC1_CHMUXR2_CH09MUX3                 (*((volatile unsigned int*)(0x4280079CUL)))
#define bM4_ADC1_CHMUXR2_CH10MUX0                 (*((volatile unsigned int*)(0x428007A0UL)))
#define bM4_ADC1_CHMUXR2_CH10MUX1                 (*((volatile unsigned int*)(0x428007A4UL)))
#define bM4_ADC1_CHMUXR2_CH10MUX2                 (*((volatile unsigned int*)(0x428007A8UL)))
#define bM4_ADC1_CHMUXR2_CH10MUX3                 (*((volatile unsigned int*)(0x428007ACUL)))
#define bM4_ADC1_CHMUXR2_CH11MUX0                 (*((volatile unsigned int*)(0x428007B0UL)))
#define bM4_ADC1_CHMUXR2_CH11MUX1                 (*((volatile unsigned int*)(0x428007B4UL)))
#define bM4_ADC1_CHMUXR2_CH11MUX2                 (*((volatile unsigned int*)(0x428007B8UL)))
#define bM4_ADC1_CHMUXR2_CH11MUX3                 (*((volatile unsigned int*)(0x428007BCUL)))
#define bM4_ADC1_CHMUXR3_CH12MUX0                 (*((volatile unsigned int*)(0x428007C0UL)))
#define bM4_ADC1_CHMUXR3_CH12MUX1                 (*((volatile unsigned int*)(0x428007C4UL)))
#define bM4_ADC1_CHMUXR3_CH12MUX2                 (*((volatile unsigned int*)(0x428007C8UL)))
#define bM4_ADC1_CHMUXR3_CH12MUX3                 (*((volatile unsigned int*)(0x428007CCUL)))
#define bM4_ADC1_CHMUXR3_CH13MUX0                 (*((volatile unsigned int*)(0x428007D0UL)))
#define bM4_ADC1_CHMUXR3_CH13MUX1                 (*((volatile unsigned int*)(0x428007D4UL)))
#define bM4_ADC1_CHMUXR3_CH13MUX2                 (*((volatile unsigned int*)(0x428007D8UL)))
#define bM4_ADC1_CHMUXR3_CH13MUX3                 (*((volatile unsigned int*)(0x428007DCUL)))
#define bM4_ADC1_CHMUXR3_CH14MUX0                 (*((volatile unsigned int*)(0x428007E0UL)))
#define bM4_ADC1_CHMUXR3_CH14MUX1                 (*((volatile unsigned int*)(0x428007E4UL)))
#define bM4_ADC1_CHMUXR3_CH14MUX2                 (*((volatile unsigned int*)(0x428007E8UL)))
#define bM4_ADC1_CHMUXR3_CH14MUX3                 (*((volatile unsigned int*)(0x428007ECUL)))
#define bM4_ADC1_CHMUXR3_CH15MUX0                 (*((volatile unsigned int*)(0x428007F0UL)))
#define bM4_ADC1_CHMUXR3_CH15MUX1                 (*((volatile unsigned int*)(0x428007F4UL)))
#define bM4_ADC1_CHMUXR3_CH15MUX2                 (*((volatile unsigned int*)(0x428007F8UL)))
#define bM4_ADC1_CHMUXR3_CH15MUX3                 (*((volatile unsigned int*)(0x428007FCUL)))
#define bM4_ADC1_ISR_EOCAF                        (*((volatile unsigned int*)(0x428008C0UL)))
#define bM4_ADC1_ISR_EOCBF                        (*((volatile unsigned int*)(0x428008C4UL)))
#define bM4_ADC1_ICR_EOCAIEN                      (*((volatile unsigned int*)(0x428008E0UL)))
#define bM4_ADC1_ICR_EOCBIEN                      (*((volatile unsigned int*)(0x428008E4UL)))
#define bM4_ADC1_SYNCCR_SYNCEN                    (*((volatile unsigned int*)(0x42800980UL)))
#define bM4_ADC1_SYNCCR_SYNCMD0                   (*((volatile unsigned int*)(0x42800990UL)))
#define bM4_ADC1_SYNCCR_SYNCMD1                   (*((volatile unsigned int*)(0x42800994UL)))
#define bM4_ADC1_SYNCCR_SYNCMD2                   (*((volatile unsigned int*)(0x42800998UL)))
#define bM4_ADC1_SYNCCR_SYNCDLY0                  (*((volatile unsigned int*)(0x428009A0UL)))
#define bM4_ADC1_SYNCCR_SYNCDLY1                  (*((volatile unsigned int*)(0x428009A4UL)))
#define bM4_ADC1_SYNCCR_SYNCDLY2                  (*((volatile unsigned int*)(0x428009A8UL)))
#define bM4_ADC1_SYNCCR_SYNCDLY3                  (*((volatile unsigned int*)(0x428009ACUL)))
#define bM4_ADC1_SYNCCR_SYNCDLY4                  (*((volatile unsigned int*)(0x428009B0UL)))
#define bM4_ADC1_SYNCCR_SYNCDLY5                  (*((volatile unsigned int*)(0x428009B4UL)))
#define bM4_ADC1_SYNCCR_SYNCDLY6                  (*((volatile unsigned int*)(0x428009B8UL)))
#define bM4_ADC1_SYNCCR_SYNCDLY7                  (*((volatile unsigned int*)(0x428009BCUL)))
#define bM4_ADC1_AWDCR_AWDEN                      (*((volatile unsigned int*)(0x42801400UL)))
#define bM4_ADC1_AWDCR_AWDMD                      (*((volatile unsigned int*)(0x42801410UL)))
#define bM4_ADC1_AWDCR_AWDSS0                     (*((volatile unsigned int*)(0x42801418UL)))
#define bM4_ADC1_AWDCR_AWDSS1                     (*((volatile unsigned int*)(0x4280141CUL)))
#define bM4_ADC1_AWDCR_AWDIEN                     (*((volatile unsigned int*)(0x42801420UL)))
#define bM4_ADC1_AWDCHSR1_AWDCH16                 (*((volatile unsigned int*)(0x428015C0UL)))
#define bM4_ADC1_AWDSR1_AWDF16                    (*((volatile unsigned int*)(0x42801640UL)))
#define bM4_ADC1_PGACR_PGACTL0                    (*((volatile unsigned int*)(0x42801800UL)))
#define bM4_ADC1_PGACR_PGACTL1                    (*((volatile unsigned int*)(0x42801804UL)))
#define bM4_ADC1_PGACR_PGACTL2                    (*((volatile unsigned int*)(0x42801808UL)))
#define bM4_ADC1_PGACR_PGACTL3                    (*((volatile unsigned int*)(0x4280180CUL)))
#define bM4_ADC1_PGAGSR_GAIN0                     (*((volatile unsigned int*)(0x42801840UL)))
#define bM4_ADC1_PGAGSR_GAIN1                     (*((volatile unsigned int*)(0x42801844UL)))
#define bM4_ADC1_PGAGSR_GAIN2                     (*((volatile unsigned int*)(0x42801848UL)))
#define bM4_ADC1_PGAGSR_GAIN3                     (*((volatile unsigned int*)(0x4280184CUL)))
#define bM4_ADC1_PGAINSR0_PGAINSEL0               (*((volatile unsigned int*)(0x42801980UL)))
#define bM4_ADC1_PGAINSR0_PGAINSEL1               (*((volatile unsigned int*)(0x42801984UL)))
#define bM4_ADC1_PGAINSR0_PGAINSEL2               (*((volatile unsigned int*)(0x42801988UL)))
#define bM4_ADC1_PGAINSR0_PGAINSEL3               (*((volatile unsigned int*)(0x4280198CUL)))
#define bM4_ADC1_PGAINSR0_PGAINSEL4               (*((volatile unsigned int*)(0x42801990UL)))
#define bM4_ADC1_PGAINSR0_PGAINSEL5               (*((volatile unsigned int*)(0x42801994UL)))
#define bM4_ADC1_PGAINSR0_PGAINSEL6               (*((volatile unsigned int*)(0x42801998UL)))
#define bM4_ADC1_PGAINSR0_PGAINSEL7               (*((volatile unsigned int*)(0x4280199CUL)))
#define bM4_ADC1_PGAINSR0_PGAINSEL8               (*((volatile unsigned int*)(0x428019A0UL)))
#define bM4_ADC1_PGAINSR1_PGAVSSEN                (*((volatile unsigned int*)(0x428019C0UL)))
#define bM4_ADC2_STR_STRT                         (*((volatile unsigned int*)(0x42808000UL)))
#define bM4_ADC2_CR0_MS0                          (*((volatile unsigned int*)(0x42808040UL)))
#define bM4_ADC2_CR0_MS1                          (*((volatile unsigned int*)(0x42808044UL)))
#define bM4_ADC2_CR0_ACCSEL0                      (*((volatile unsigned int*)(0x42808050UL)))
#define bM4_ADC2_CR0_ACCSEL1                      (*((volatile unsigned int*)(0x42808054UL)))
#define bM4_ADC2_CR0_CLREN                        (*((volatile unsigned int*)(0x42808058UL)))
#define bM4_ADC2_CR0_DFMT                         (*((volatile unsigned int*)(0x4280805CUL)))
#define bM4_ADC2_CR0_AVCNT0                       (*((volatile unsigned int*)(0x42808060UL)))
#define bM4_ADC2_CR0_AVCNT1                       (*((volatile unsigned int*)(0x42808064UL)))
#define bM4_ADC2_CR0_AVCNT2                       (*((volatile unsigned int*)(0x42808068UL)))
#define bM4_ADC2_CR1_RSCHSEL                      (*((volatile unsigned int*)(0x42808088UL)))
#define bM4_ADC2_TRGSR_TRGSELA0                   (*((volatile unsigned int*)(0x42808140UL)))
#define bM4_ADC2_TRGSR_TRGSELA1                   (*((volatile unsigned int*)(0x42808144UL)))
#define bM4_ADC2_TRGSR_TRGSELA2                   (*((volatile unsigned int*)(0x42808148UL)))
#define bM4_ADC2_TRGSR_TRGENA                     (*((volatile unsigned int*)(0x4280815CUL)))
#define bM4_ADC2_TRGSR_TRGSELB0                   (*((volatile unsigned int*)(0x42808160UL)))
#define bM4_ADC2_TRGSR_TRGSELB1                   (*((volatile unsigned int*)(0x42808164UL)))
#define bM4_ADC2_TRGSR_TRGSELB2                   (*((volatile unsigned int*)(0x42808168UL)))
#define bM4_ADC2_TRGSR_TRGENB                     (*((volatile unsigned int*)(0x4280817CUL)))
#define bM4_ADC2_CHSELRA1_CHSELA16                (*((volatile unsigned int*)(0x428081C0UL)))
#define bM4_ADC2_CHSELRB1_CHSELB16                (*((volatile unsigned int*)(0x42808240UL)))
#define bM4_ADC2_AVCHSELR1_AVCHSEL16              (*((volatile unsigned int*)(0x428082C0UL)))
#define bM4_ADC2_CHMUXR0_CH00MUX0                 (*((volatile unsigned int*)(0x42808700UL)))
#define bM4_ADC2_CHMUXR0_CH00MUX1                 (*((volatile unsigned int*)(0x42808704UL)))
#define bM4_ADC2_CHMUXR0_CH00MUX2                 (*((volatile unsigned int*)(0x42808708UL)))
#define bM4_ADC2_CHMUXR0_CH00MUX3                 (*((volatile unsigned int*)(0x4280870CUL)))
#define bM4_ADC2_CHMUXR0_CH01MUX0                 (*((volatile unsigned int*)(0x42808710UL)))
#define bM4_ADC2_CHMUXR0_CH01MUX1                 (*((volatile unsigned int*)(0x42808714UL)))
#define bM4_ADC2_CHMUXR0_CH01MUX2                 (*((volatile unsigned int*)(0x42808718UL)))
#define bM4_ADC2_CHMUXR0_CH01MUX3                 (*((volatile unsigned int*)(0x4280871CUL)))
#define bM4_ADC2_CHMUXR0_CH02MUX0                 (*((volatile unsigned int*)(0x42808720UL)))
#define bM4_ADC2_CHMUXR0_CH02MUX1                 (*((volatile unsigned int*)(0x42808724UL)))
#define bM4_ADC2_CHMUXR0_CH02MUX2                 (*((volatile unsigned int*)(0x42808728UL)))
#define bM4_ADC2_CHMUXR0_CH02MUX3                 (*((volatile unsigned int*)(0x4280872CUL)))
#define bM4_ADC2_CHMUXR0_CH03MUX0                 (*((volatile unsigned int*)(0x42808730UL)))
#define bM4_ADC2_CHMUXR0_CH03MUX1                 (*((volatile unsigned int*)(0x42808734UL)))
#define bM4_ADC2_CHMUXR0_CH03MUX2                 (*((volatile unsigned int*)(0x42808738UL)))
#define bM4_ADC2_CHMUXR0_CH03MUX3                 (*((volatile unsigned int*)(0x4280873CUL)))
#define bM4_ADC2_CHMUXR1_CH04MUX0                 (*((volatile unsigned int*)(0x42808740UL)))
#define bM4_ADC2_CHMUXR1_CH04MUX1                 (*((volatile unsigned int*)(0x42808744UL)))
#define bM4_ADC2_CHMUXR1_CH04MUX2                 (*((volatile unsigned int*)(0x42808748UL)))
#define bM4_ADC2_CHMUXR1_CH04MUX3                 (*((volatile unsigned int*)(0x4280874CUL)))
#define bM4_ADC2_CHMUXR1_CH05MUX0                 (*((volatile unsigned int*)(0x42808750UL)))
#define bM4_ADC2_CHMUXR1_CH05MUX1                 (*((volatile unsigned int*)(0x42808754UL)))
#define bM4_ADC2_CHMUXR1_CH05MUX2                 (*((volatile unsigned int*)(0x42808758UL)))
#define bM4_ADC2_CHMUXR1_CH05MUX3                 (*((volatile unsigned int*)(0x4280875CUL)))
#define bM4_ADC2_CHMUXR1_CH06MUX0                 (*((volatile unsigned int*)(0x42808760UL)))
#define bM4_ADC2_CHMUXR1_CH06MUX1                 (*((volatile unsigned int*)(0x42808764UL)))
#define bM4_ADC2_CHMUXR1_CH06MUX2                 (*((volatile unsigned int*)(0x42808768UL)))
#define bM4_ADC2_CHMUXR1_CH06MUX3                 (*((volatile unsigned int*)(0x4280876CUL)))
#define bM4_ADC2_CHMUXR1_CH07MUX0                 (*((volatile unsigned int*)(0x42808770UL)))
#define bM4_ADC2_CHMUXR1_CH07MUX1                 (*((volatile unsigned int*)(0x42808774UL)))
#define bM4_ADC2_CHMUXR1_CH07MUX2                 (*((volatile unsigned int*)(0x42808778UL)))
#define bM4_ADC2_CHMUXR1_CH07MUX3                 (*((volatile unsigned int*)(0x4280877CUL)))
#define bM4_ADC2_CHMUXR2_CH08MUX0                 (*((volatile unsigned int*)(0x42808780UL)))
#define bM4_ADC2_CHMUXR2_CH08MUX1                 (*((volatile unsigned int*)(0x42808784UL)))
#define bM4_ADC2_CHMUXR2_CH08MUX2                 (*((volatile unsigned int*)(0x42808788UL)))
#define bM4_ADC2_CHMUXR2_CH08MUX3                 (*((volatile unsigned int*)(0x4280878CUL)))
#define bM4_ADC2_CHMUXR2_CH09MUX0                 (*((volatile unsigned int*)(0x42808790UL)))
#define bM4_ADC2_CHMUXR2_CH09MUX1                 (*((volatile unsigned int*)(0x42808794UL)))
#define bM4_ADC2_CHMUXR2_CH09MUX2                 (*((volatile unsigned int*)(0x42808798UL)))
#define bM4_ADC2_CHMUXR2_CH09MUX3                 (*((volatile unsigned int*)(0x4280879CUL)))
#define bM4_ADC2_CHMUXR2_CH10MUX0                 (*((volatile unsigned int*)(0x428087A0UL)))
#define bM4_ADC2_CHMUXR2_CH10MUX1                 (*((volatile unsigned int*)(0x428087A4UL)))
#define bM4_ADC2_CHMUXR2_CH10MUX2                 (*((volatile unsigned int*)(0x428087A8UL)))
#define bM4_ADC2_CHMUXR2_CH10MUX3                 (*((volatile unsigned int*)(0x428087ACUL)))
#define bM4_ADC2_CHMUXR2_CH11MUX0                 (*((volatile unsigned int*)(0x428087B0UL)))
#define bM4_ADC2_CHMUXR2_CH11MUX1                 (*((volatile unsigned int*)(0x428087B4UL)))
#define bM4_ADC2_CHMUXR2_CH11MUX2                 (*((volatile unsigned int*)(0x428087B8UL)))
#define bM4_ADC2_CHMUXR2_CH11MUX3                 (*((volatile unsigned int*)(0x428087BCUL)))
#define bM4_ADC2_CHMUXR3_CH12MUX0                 (*((volatile unsigned int*)(0x428087C0UL)))
#define bM4_ADC2_CHMUXR3_CH12MUX1                 (*((volatile unsigned int*)(0x428087C4UL)))
#define bM4_ADC2_CHMUXR3_CH12MUX2                 (*((volatile unsigned int*)(0x428087C8UL)))
#define bM4_ADC2_CHMUXR3_CH12MUX3                 (*((volatile unsigned int*)(0x428087CCUL)))
#define bM4_ADC2_CHMUXR3_CH13MUX0                 (*((volatile unsigned int*)(0x428087D0UL)))
#define bM4_ADC2_CHMUXR3_CH13MUX1                 (*((volatile unsigned int*)(0x428087D4UL)))
#define bM4_ADC2_CHMUXR3_CH13MUX2                 (*((volatile unsigned int*)(0x428087D8UL)))
#define bM4_ADC2_CHMUXR3_CH13MUX3                 (*((volatile unsigned int*)(0x428087DCUL)))
#define bM4_ADC2_CHMUXR3_CH14MUX0                 (*((volatile unsigned int*)(0x428087E0UL)))
#define bM4_ADC2_CHMUXR3_CH14MUX1                 (*((volatile unsigned int*)(0x428087E4UL)))
#define bM4_ADC2_CHMUXR3_CH14MUX2                 (*((volatile unsigned int*)(0x428087E8UL)))
#define bM4_ADC2_CHMUXR3_CH14MUX3                 (*((volatile unsigned int*)(0x428087ECUL)))
#define bM4_ADC2_CHMUXR3_CH15MUX0                 (*((volatile unsigned int*)(0x428087F0UL)))
#define bM4_ADC2_CHMUXR3_CH15MUX1                 (*((volatile unsigned int*)(0x428087F4UL)))
#define bM4_ADC2_CHMUXR3_CH15MUX2                 (*((volatile unsigned int*)(0x428087F8UL)))
#define bM4_ADC2_CHMUXR3_CH15MUX3                 (*((volatile unsigned int*)(0x428087FCUL)))
#define bM4_ADC2_ISR_EOCAF                        (*((volatile unsigned int*)(0x428088C0UL)))
#define bM4_ADC2_ISR_EOCBF                        (*((volatile unsigned int*)(0x428088C4UL)))
#define bM4_ADC2_ICR_EOCAIEN                      (*((volatile unsigned int*)(0x428088E0UL)))
#define bM4_ADC2_ICR_EOCBIEN                      (*((volatile unsigned int*)(0x428088E4UL)))
#define bM4_ADC2_SYNCCR_SYNCEN                    (*((volatile unsigned int*)(0x42808980UL)))
#define bM4_ADC2_SYNCCR_SYNCMD0                   (*((volatile unsigned int*)(0x42808990UL)))
#define bM4_ADC2_SYNCCR_SYNCMD1                   (*((volatile unsigned int*)(0x42808994UL)))
#define bM4_ADC2_SYNCCR_SYNCMD2                   (*((volatile unsigned int*)(0x42808998UL)))
#define bM4_ADC2_SYNCCR_SYNCDLY0                  (*((volatile unsigned int*)(0x428089A0UL)))
#define bM4_ADC2_SYNCCR_SYNCDLY1                  (*((volatile unsigned int*)(0x428089A4UL)))
#define bM4_ADC2_SYNCCR_SYNCDLY2                  (*((volatile unsigned int*)(0x428089A8UL)))
#define bM4_ADC2_SYNCCR_SYNCDLY3                  (*((volatile unsigned int*)(0x428089ACUL)))
#define bM4_ADC2_SYNCCR_SYNCDLY4                  (*((volatile unsigned int*)(0x428089B0UL)))
#define bM4_ADC2_SYNCCR_SYNCDLY5                  (*((volatile unsigned int*)(0x428089B4UL)))
#define bM4_ADC2_SYNCCR_SYNCDLY6                  (*((volatile unsigned int*)(0x428089B8UL)))
#define bM4_ADC2_SYNCCR_SYNCDLY7                  (*((volatile unsigned int*)(0x428089BCUL)))
#define bM4_ADC2_AWDCR_AWDEN                      (*((volatile unsigned int*)(0x42809400UL)))
#define bM4_ADC2_AWDCR_AWDMD                      (*((volatile unsigned int*)(0x42809410UL)))
#define bM4_ADC2_AWDCR_AWDSS0                     (*((volatile unsigned int*)(0x42809418UL)))
#define bM4_ADC2_AWDCR_AWDSS1                     (*((volatile unsigned int*)(0x4280941CUL)))
#define bM4_ADC2_AWDCR_AWDIEN                     (*((volatile unsigned int*)(0x42809420UL)))
#define bM4_ADC2_AWDCHSR1_AWDCH16                 (*((volatile unsigned int*)(0x428095C0UL)))
#define bM4_ADC2_AWDSR1_AWDF16                    (*((volatile unsigned int*)(0x42809640UL)))
#define bM4_ADC2_PGACR_PGACTL0                    (*((volatile unsigned int*)(0x42809800UL)))
#define bM4_ADC2_PGACR_PGACTL1                    (*((volatile unsigned int*)(0x42809804UL)))
#define bM4_ADC2_PGACR_PGACTL2                    (*((volatile unsigned int*)(0x42809808UL)))
#define bM4_ADC2_PGACR_PGACTL3                    (*((volatile unsigned int*)(0x4280980CUL)))
#define bM4_ADC2_PGAGSR_GAIN0                     (*((volatile unsigned int*)(0x42809840UL)))
#define bM4_ADC2_PGAGSR_GAIN1                     (*((volatile unsigned int*)(0x42809844UL)))
#define bM4_ADC2_PGAGSR_GAIN2                     (*((volatile unsigned int*)(0x42809848UL)))
#define bM4_ADC2_PGAGSR_GAIN3                     (*((volatile unsigned int*)(0x4280984CUL)))
#define bM4_ADC2_PGAINSR0_PGAINSEL0               (*((volatile unsigned int*)(0x42809980UL)))
#define bM4_ADC2_PGAINSR0_PGAINSEL1               (*((volatile unsigned int*)(0x42809984UL)))
#define bM4_ADC2_PGAINSR0_PGAINSEL2               (*((volatile unsigned int*)(0x42809988UL)))
#define bM4_ADC2_PGAINSR0_PGAINSEL3               (*((volatile unsigned int*)(0x4280998CUL)))
#define bM4_ADC2_PGAINSR0_PGAINSEL4               (*((volatile unsigned int*)(0x42809990UL)))
#define bM4_ADC2_PGAINSR0_PGAINSEL5               (*((volatile unsigned int*)(0x42809994UL)))
#define bM4_ADC2_PGAINSR0_PGAINSEL6               (*((volatile unsigned int*)(0x42809998UL)))
#define bM4_ADC2_PGAINSR0_PGAINSEL7               (*((volatile unsigned int*)(0x4280999CUL)))
#define bM4_ADC2_PGAINSR0_PGAINSEL8               (*((volatile unsigned int*)(0x428099A0UL)))
#define bM4_ADC2_PGAINSR1_PGAVSSEN                (*((volatile unsigned int*)(0x428099C0UL)))
#define bM4_AES_CR_START                          (*((volatile unsigned int*)(0x42100000UL)))
#define bM4_AES_CR_MODE                           (*((volatile unsigned int*)(0x42100004UL)))
#define bM4_AOS_INT_SFTTRG_STRG                   (*((volatile unsigned int*)(0x42210000UL)))
#define bM4_AOS_DCU1_TRGSEL_TRGSEL0               (*((volatile unsigned int*)(0x42210080UL)))
#define bM4_AOS_DCU1_TRGSEL_TRGSEL1               (*((volatile unsigned int*)(0x42210084UL)))
#define bM4_AOS_DCU1_TRGSEL_TRGSEL2               (*((volatile unsigned int*)(0x42210088UL)))
#define bM4_AOS_DCU1_TRGSEL_TRGSEL3               (*((volatile unsigned int*)(0x4221008CUL)))
#define bM4_AOS_DCU1_TRGSEL_TRGSEL4               (*((volatile unsigned int*)(0x42210090UL)))
#define bM4_AOS_DCU1_TRGSEL_TRGSEL5               (*((volatile unsigned int*)(0x42210094UL)))
#define bM4_AOS_DCU1_TRGSEL_TRGSEL6               (*((volatile unsigned int*)(0x42210098UL)))
#define bM4_AOS_DCU1_TRGSEL_TRGSEL7               (*((volatile unsigned int*)(0x4221009CUL)))
#define bM4_AOS_DCU1_TRGSEL_TRGSEL8               (*((volatile unsigned int*)(0x422100A0UL)))
#define bM4_AOS_DCU1_TRGSEL_COMTRG_EN0            (*((volatile unsigned int*)(0x422100F8UL)))
#define bM4_AOS_DCU1_TRGSEL_COMTRG_EN1            (*((volatile unsigned int*)(0x422100FCUL)))
#define bM4_AOS_DCU2_TRGSEL_TRGSEL0               (*((volatile unsigned int*)(0x42210100UL)))
#define bM4_AOS_DCU2_TRGSEL_TRGSEL1               (*((volatile unsigned int*)(0x42210104UL)))
#define bM4_AOS_DCU2_TRGSEL_TRGSEL2               (*((volatile unsigned int*)(0x42210108UL)))
#define bM4_AOS_DCU2_TRGSEL_TRGSEL3               (*((volatile unsigned int*)(0x4221010CUL)))
#define bM4_AOS_DCU2_TRGSEL_TRGSEL4               (*((volatile unsigned int*)(0x42210110UL)))
#define bM4_AOS_DCU2_TRGSEL_TRGSEL5               (*((volatile unsigned int*)(0x42210114UL)))
#define bM4_AOS_DCU2_TRGSEL_TRGSEL6               (*((volatile unsigned int*)(0x42210118UL)))
#define bM4_AOS_DCU2_TRGSEL_TRGSEL7               (*((volatile unsigned int*)(0x4221011CUL)))
#define bM4_AOS_DCU2_TRGSEL_TRGSEL8               (*((volatile unsigned int*)(0x42210120UL)))
#define bM4_AOS_DCU2_TRGSEL_COMTRG_EN0            (*((volatile unsigned int*)(0x42210178UL)))
#define bM4_AOS_DCU2_TRGSEL_COMTRG_EN1            (*((volatile unsigned int*)(0x4221017CUL)))
#define bM4_AOS_DCU3_TRGSEL_TRGSEL0               (*((volatile unsigned int*)(0x42210180UL)))
#define bM4_AOS_DCU3_TRGSEL_TRGSEL1               (*((volatile unsigned int*)(0x42210184UL)))
#define bM4_AOS_DCU3_TRGSEL_TRGSEL2               (*((volatile unsigned int*)(0x42210188UL)))
#define bM4_AOS_DCU3_TRGSEL_TRGSEL3               (*((volatile unsigned int*)(0x4221018CUL)))
#define bM4_AOS_DCU3_TRGSEL_TRGSEL4               (*((volatile unsigned int*)(0x42210190UL)))
#define bM4_AOS_DCU3_TRGSEL_TRGSEL5               (*((volatile unsigned int*)(0x42210194UL)))
#define bM4_AOS_DCU3_TRGSEL_TRGSEL6               (*((volatile unsigned int*)(0x42210198UL)))
#define bM4_AOS_DCU3_TRGSEL_TRGSEL7               (*((volatile unsigned int*)(0x4221019CUL)))
#define bM4_AOS_DCU3_TRGSEL_TRGSEL8               (*((volatile unsigned int*)(0x422101A0UL)))
#define bM4_AOS_DCU3_TRGSEL_COMTRG_EN0            (*((volatile unsigned int*)(0x422101F8UL)))
#define bM4_AOS_DCU3_TRGSEL_COMTRG_EN1            (*((volatile unsigned int*)(0x422101FCUL)))
#define bM4_AOS_DCU4_TRGSEL_TRGSEL0               (*((volatile unsigned int*)(0x42210200UL)))
#define bM4_AOS_DCU4_TRGSEL_TRGSEL1               (*((volatile unsigned int*)(0x42210204UL)))
#define bM4_AOS_DCU4_TRGSEL_TRGSEL2               (*((volatile unsigned int*)(0x42210208UL)))
#define bM4_AOS_DCU4_TRGSEL_TRGSEL3               (*((volatile unsigned int*)(0x4221020CUL)))
#define bM4_AOS_DCU4_TRGSEL_TRGSEL4               (*((volatile unsigned int*)(0x42210210UL)))
#define bM4_AOS_DCU4_TRGSEL_TRGSEL5               (*((volatile unsigned int*)(0x42210214UL)))
#define bM4_AOS_DCU4_TRGSEL_TRGSEL6               (*((volatile unsigned int*)(0x42210218UL)))
#define bM4_AOS_DCU4_TRGSEL_TRGSEL7               (*((volatile unsigned int*)(0x4221021CUL)))
#define bM4_AOS_DCU4_TRGSEL_TRGSEL8               (*((volatile unsigned int*)(0x42210220UL)))
#define bM4_AOS_DCU4_TRGSEL_COMTRG_EN0            (*((volatile unsigned int*)(0x42210278UL)))
#define bM4_AOS_DCU4_TRGSEL_COMTRG_EN1            (*((volatile unsigned int*)(0x4221027CUL)))
#define bM4_AOS_DMA1_TRGSEL0_TRGSEL0              (*((volatile unsigned int*)(0x42210280UL)))
#define bM4_AOS_DMA1_TRGSEL0_TRGSEL1              (*((volatile unsigned int*)(0x42210284UL)))
#define bM4_AOS_DMA1_TRGSEL0_TRGSEL2              (*((volatile unsigned int*)(0x42210288UL)))
#define bM4_AOS_DMA1_TRGSEL0_TRGSEL3              (*((volatile unsigned int*)(0x4221028CUL)))
#define bM4_AOS_DMA1_TRGSEL0_TRGSEL4              (*((volatile unsigned int*)(0x42210290UL)))
#define bM4_AOS_DMA1_TRGSEL0_TRGSEL5              (*((volatile unsigned int*)(0x42210294UL)))
#define bM4_AOS_DMA1_TRGSEL0_TRGSEL6              (*((volatile unsigned int*)(0x42210298UL)))
#define bM4_AOS_DMA1_TRGSEL0_TRGSEL7              (*((volatile unsigned int*)(0x4221029CUL)))
#define bM4_AOS_DMA1_TRGSEL0_TRGSEL8              (*((volatile unsigned int*)(0x422102A0UL)))
#define bM4_AOS_DMA1_TRGSEL0_COMTRG_EN0           (*((volatile unsigned int*)(0x422102F8UL)))
#define bM4_AOS_DMA1_TRGSEL0_COMTRG_EN1           (*((volatile unsigned int*)(0x422102FCUL)))
#define bM4_AOS_DMA1_TRGSEL1_TRGSEL0              (*((volatile unsigned int*)(0x42210300UL)))
#define bM4_AOS_DMA1_TRGSEL1_TRGSEL1              (*((volatile unsigned int*)(0x42210304UL)))
#define bM4_AOS_DMA1_TRGSEL1_TRGSEL2              (*((volatile unsigned int*)(0x42210308UL)))
#define bM4_AOS_DMA1_TRGSEL1_TRGSEL3              (*((volatile unsigned int*)(0x4221030CUL)))
#define bM4_AOS_DMA1_TRGSEL1_TRGSEL4              (*((volatile unsigned int*)(0x42210310UL)))
#define bM4_AOS_DMA1_TRGSEL1_TRGSEL5              (*((volatile unsigned int*)(0x42210314UL)))
#define bM4_AOS_DMA1_TRGSEL1_TRGSEL6              (*((volatile unsigned int*)(0x42210318UL)))
#define bM4_AOS_DMA1_TRGSEL1_TRGSEL7              (*((volatile unsigned int*)(0x4221031CUL)))
#define bM4_AOS_DMA1_TRGSEL1_TRGSEL8              (*((volatile unsigned int*)(0x42210320UL)))
#define bM4_AOS_DMA1_TRGSEL1_COMTRG_EN0           (*((volatile unsigned int*)(0x42210378UL)))
#define bM4_AOS_DMA1_TRGSEL1_COMTRG_EN1           (*((volatile unsigned int*)(0x4221037CUL)))
#define bM4_AOS_DMA1_TRGSEL2_TRGSEL0              (*((volatile unsigned int*)(0x42210380UL)))
#define bM4_AOS_DMA1_TRGSEL2_TRGSEL1              (*((volatile unsigned int*)(0x42210384UL)))
#define bM4_AOS_DMA1_TRGSEL2_TRGSEL2              (*((volatile unsigned int*)(0x42210388UL)))
#define bM4_AOS_DMA1_TRGSEL2_TRGSEL3              (*((volatile unsigned int*)(0x4221038CUL)))
#define bM4_AOS_DMA1_TRGSEL2_TRGSEL4              (*((volatile unsigned int*)(0x42210390UL)))
#define bM4_AOS_DMA1_TRGSEL2_TRGSEL5              (*((volatile unsigned int*)(0x42210394UL)))
#define bM4_AOS_DMA1_TRGSEL2_TRGSEL6              (*((volatile unsigned int*)(0x42210398UL)))
#define bM4_AOS_DMA1_TRGSEL2_TRGSEL7              (*((volatile unsigned int*)(0x4221039CUL)))
#define bM4_AOS_DMA1_TRGSEL2_TRGSEL8              (*((volatile unsigned int*)(0x422103A0UL)))
#define bM4_AOS_DMA1_TRGSEL2_COMTRG_EN0           (*((volatile unsigned int*)(0x422103F8UL)))
#define bM4_AOS_DMA1_TRGSEL2_COMTRG_EN1           (*((volatile unsigned int*)(0x422103FCUL)))
#define bM4_AOS_DMA1_TRGSEL3_TRGSEL0              (*((volatile unsigned int*)(0x42210400UL)))
#define bM4_AOS_DMA1_TRGSEL3_TRGSEL1              (*((volatile unsigned int*)(0x42210404UL)))
#define bM4_AOS_DMA1_TRGSEL3_TRGSEL2              (*((volatile unsigned int*)(0x42210408UL)))
#define bM4_AOS_DMA1_TRGSEL3_TRGSEL3              (*((volatile unsigned int*)(0x4221040CUL)))
#define bM4_AOS_DMA1_TRGSEL3_TRGSEL4              (*((volatile unsigned int*)(0x42210410UL)))
#define bM4_AOS_DMA1_TRGSEL3_TRGSEL5              (*((volatile unsigned int*)(0x42210414UL)))
#define bM4_AOS_DMA1_TRGSEL3_TRGSEL6              (*((volatile unsigned int*)(0x42210418UL)))
#define bM4_AOS_DMA1_TRGSEL3_TRGSEL7              (*((volatile unsigned int*)(0x4221041CUL)))
#define bM4_AOS_DMA1_TRGSEL3_TRGSEL8              (*((volatile unsigned int*)(0x42210420UL)))
#define bM4_AOS_DMA1_TRGSEL3_COMTRG_EN0           (*((volatile unsigned int*)(0x42210478UL)))
#define bM4_AOS_DMA1_TRGSEL3_COMTRG_EN1           (*((volatile unsigned int*)(0x4221047CUL)))
#define bM4_AOS_DMA2_TRGSEL0_TRGSEL0              (*((volatile unsigned int*)(0x42210480UL)))
#define bM4_AOS_DMA2_TRGSEL0_TRGSEL1              (*((volatile unsigned int*)(0x42210484UL)))
#define bM4_AOS_DMA2_TRGSEL0_TRGSEL2              (*((volatile unsigned int*)(0x42210488UL)))
#define bM4_AOS_DMA2_TRGSEL0_TRGSEL3              (*((volatile unsigned int*)(0x4221048CUL)))
#define bM4_AOS_DMA2_TRGSEL0_TRGSEL4              (*((volatile unsigned int*)(0x42210490UL)))
#define bM4_AOS_DMA2_TRGSEL0_TRGSEL5              (*((volatile unsigned int*)(0x42210494UL)))
#define bM4_AOS_DMA2_TRGSEL0_TRGSEL6              (*((volatile unsigned int*)(0x42210498UL)))
#define bM4_AOS_DMA2_TRGSEL0_TRGSEL7              (*((volatile unsigned int*)(0x4221049CUL)))
#define bM4_AOS_DMA2_TRGSEL0_TRGSEL8              (*((volatile unsigned int*)(0x422104A0UL)))
#define bM4_AOS_DMA2_TRGSEL0_COMTRG_EN0           (*((volatile unsigned int*)(0x422104F8UL)))
#define bM4_AOS_DMA2_TRGSEL0_COMTRG_EN1           (*((volatile unsigned int*)(0x422104FCUL)))
#define bM4_AOS_DMA2_TRGSEL1_TRGSEL0              (*((volatile unsigned int*)(0x42210500UL)))
#define bM4_AOS_DMA2_TRGSEL1_TRGSEL1              (*((volatile unsigned int*)(0x42210504UL)))
#define bM4_AOS_DMA2_TRGSEL1_TRGSEL2              (*((volatile unsigned int*)(0x42210508UL)))
#define bM4_AOS_DMA2_TRGSEL1_TRGSEL3              (*((volatile unsigned int*)(0x4221050CUL)))
#define bM4_AOS_DMA2_TRGSEL1_TRGSEL4              (*((volatile unsigned int*)(0x42210510UL)))
#define bM4_AOS_DMA2_TRGSEL1_TRGSEL5              (*((volatile unsigned int*)(0x42210514UL)))
#define bM4_AOS_DMA2_TRGSEL1_TRGSEL6              (*((volatile unsigned int*)(0x42210518UL)))
#define bM4_AOS_DMA2_TRGSEL1_TRGSEL7              (*((volatile unsigned int*)(0x4221051CUL)))
#define bM4_AOS_DMA2_TRGSEL1_TRGSEL8              (*((volatile unsigned int*)(0x42210520UL)))
#define bM4_AOS_DMA2_TRGSEL1_COMTRG_EN0           (*((volatile unsigned int*)(0x42210578UL)))
#define bM4_AOS_DMA2_TRGSEL1_COMTRG_EN1           (*((volatile unsigned int*)(0x4221057CUL)))
#define bM4_AOS_DMA2_TRGSEL2_TRGSEL0              (*((volatile unsigned int*)(0x42210580UL)))
#define bM4_AOS_DMA2_TRGSEL2_TRGSEL1              (*((volatile unsigned int*)(0x42210584UL)))
#define bM4_AOS_DMA2_TRGSEL2_TRGSEL2              (*((volatile unsigned int*)(0x42210588UL)))
#define bM4_AOS_DMA2_TRGSEL2_TRGSEL3              (*((volatile unsigned int*)(0x4221058CUL)))
#define bM4_AOS_DMA2_TRGSEL2_TRGSEL4              (*((volatile unsigned int*)(0x42210590UL)))
#define bM4_AOS_DMA2_TRGSEL2_TRGSEL5              (*((volatile unsigned int*)(0x42210594UL)))
#define bM4_AOS_DMA2_TRGSEL2_TRGSEL6              (*((volatile unsigned int*)(0x42210598UL)))
#define bM4_AOS_DMA2_TRGSEL2_TRGSEL7              (*((volatile unsigned int*)(0x4221059CUL)))
#define bM4_AOS_DMA2_TRGSEL2_TRGSEL8              (*((volatile unsigned int*)(0x422105A0UL)))
#define bM4_AOS_DMA2_TRGSEL2_COMTRG_EN0           (*((volatile unsigned int*)(0x422105F8UL)))
#define bM4_AOS_DMA2_TRGSEL2_COMTRG_EN1           (*((volatile unsigned int*)(0x422105FCUL)))
#define bM4_AOS_DMA2_TRGSEL3_TRGSEL0              (*((volatile unsigned int*)(0x42210600UL)))
#define bM4_AOS_DMA2_TRGSEL3_TRGSEL1              (*((volatile unsigned int*)(0x42210604UL)))
#define bM4_AOS_DMA2_TRGSEL3_TRGSEL2              (*((volatile unsigned int*)(0x42210608UL)))
#define bM4_AOS_DMA2_TRGSEL3_TRGSEL3              (*((volatile unsigned int*)(0x4221060CUL)))
#define bM4_AOS_DMA2_TRGSEL3_TRGSEL4              (*((volatile unsigned int*)(0x42210610UL)))
#define bM4_AOS_DMA2_TRGSEL3_TRGSEL5              (*((volatile unsigned int*)(0x42210614UL)))
#define bM4_AOS_DMA2_TRGSEL3_TRGSEL6              (*((volatile unsigned int*)(0x42210618UL)))
#define bM4_AOS_DMA2_TRGSEL3_TRGSEL7              (*((volatile unsigned int*)(0x4221061CUL)))
#define bM4_AOS_DMA2_TRGSEL3_TRGSEL8              (*((volatile unsigned int*)(0x42210620UL)))
#define bM4_AOS_DMA2_TRGSEL3_COMTRG_EN0           (*((volatile unsigned int*)(0x42210678UL)))
#define bM4_AOS_DMA2_TRGSEL3_COMTRG_EN1           (*((volatile unsigned int*)(0x4221067CUL)))
#define bM4_AOS_DMA_TRGSELRC_TRGSEL0              (*((volatile unsigned int*)(0x42210680UL)))
#define bM4_AOS_DMA_TRGSELRC_TRGSEL1              (*((volatile unsigned int*)(0x42210684UL)))
#define bM4_AOS_DMA_TRGSELRC_TRGSEL2              (*((volatile unsigned int*)(0x42210688UL)))
#define bM4_AOS_DMA_TRGSELRC_TRGSEL3              (*((volatile unsigned int*)(0x4221068CUL)))
#define bM4_AOS_DMA_TRGSELRC_TRGSEL4              (*((volatile unsigned int*)(0x42210690UL)))
#define bM4_AOS_DMA_TRGSELRC_TRGSEL5              (*((volatile unsigned int*)(0x42210694UL)))
#define bM4_AOS_DMA_TRGSELRC_TRGSEL6              (*((volatile unsigned int*)(0x42210698UL)))
#define bM4_AOS_DMA_TRGSELRC_TRGSEL7              (*((volatile unsigned int*)(0x4221069CUL)))
#define bM4_AOS_DMA_TRGSELRC_TRGSEL8              (*((volatile unsigned int*)(0x422106A0UL)))
#define bM4_AOS_DMA_TRGSELRC_COMTRG_EN0           (*((volatile unsigned int*)(0x422106F8UL)))
#define bM4_AOS_DMA_TRGSELRC_COMTRG_EN1           (*((volatile unsigned int*)(0x422106FCUL)))
#define bM4_AOS_TMR6_HTSSR0_TRGSEL0               (*((volatile unsigned int*)(0x42210700UL)))
#define bM4_AOS_TMR6_HTSSR0_TRGSEL1               (*((volatile unsigned int*)(0x42210704UL)))
#define bM4_AOS_TMR6_HTSSR0_TRGSEL2               (*((volatile unsigned int*)(0x42210708UL)))
#define bM4_AOS_TMR6_HTSSR0_TRGSEL3               (*((volatile unsigned int*)(0x4221070CUL)))
#define bM4_AOS_TMR6_HTSSR0_TRGSEL4               (*((volatile unsigned int*)(0x42210710UL)))
#define bM4_AOS_TMR6_HTSSR0_TRGSEL5               (*((volatile unsigned int*)(0x42210714UL)))
#define bM4_AOS_TMR6_HTSSR0_TRGSEL6               (*((volatile unsigned int*)(0x42210718UL)))
#define bM4_AOS_TMR6_HTSSR0_TRGSEL7               (*((volatile unsigned int*)(0x4221071CUL)))
#define bM4_AOS_TMR6_HTSSR0_TRGSEL8               (*((volatile unsigned int*)(0x42210720UL)))
#define bM4_AOS_TMR6_HTSSR0_COMTRG_EN0            (*((volatile unsigned int*)(0x42210778UL)))
#define bM4_AOS_TMR6_HTSSR0_COMTRG_EN1            (*((volatile unsigned int*)(0x4221077CUL)))
#define bM4_AOS_TMR6_HTSSR1_TRGSEL0               (*((volatile unsigned int*)(0x42210780UL)))
#define bM4_AOS_TMR6_HTSSR1_TRGSEL1               (*((volatile unsigned int*)(0x42210784UL)))
#define bM4_AOS_TMR6_HTSSR1_TRGSEL2               (*((volatile unsigned int*)(0x42210788UL)))
#define bM4_AOS_TMR6_HTSSR1_TRGSEL3               (*((volatile unsigned int*)(0x4221078CUL)))
#define bM4_AOS_TMR6_HTSSR1_TRGSEL4               (*((volatile unsigned int*)(0x42210790UL)))
#define bM4_AOS_TMR6_HTSSR1_TRGSEL5               (*((volatile unsigned int*)(0x42210794UL)))
#define bM4_AOS_TMR6_HTSSR1_TRGSEL6               (*((volatile unsigned int*)(0x42210798UL)))
#define bM4_AOS_TMR6_HTSSR1_TRGSEL7               (*((volatile unsigned int*)(0x4221079CUL)))
#define bM4_AOS_TMR6_HTSSR1_TRGSEL8               (*((volatile unsigned int*)(0x422107A0UL)))
#define bM4_AOS_TMR6_HTSSR1_COMTRG_EN0            (*((volatile unsigned int*)(0x422107F8UL)))
#define bM4_AOS_TMR6_HTSSR1_COMTRG_EN1            (*((volatile unsigned int*)(0x422107FCUL)))
#define bM4_AOS_TMR0_HTSSR_TRGSEL0                (*((volatile unsigned int*)(0x42210800UL)))
#define bM4_AOS_TMR0_HTSSR_TRGSEL1                (*((volatile unsigned int*)(0x42210804UL)))
#define bM4_AOS_TMR0_HTSSR_TRGSEL2                (*((volatile unsigned int*)(0x42210808UL)))
#define bM4_AOS_TMR0_HTSSR_TRGSEL3                (*((volatile unsigned int*)(0x4221080CUL)))
#define bM4_AOS_TMR0_HTSSR_TRGSEL4                (*((volatile unsigned int*)(0x42210810UL)))
#define bM4_AOS_TMR0_HTSSR_TRGSEL5                (*((volatile unsigned int*)(0x42210814UL)))
#define bM4_AOS_TMR0_HTSSR_TRGSEL6                (*((volatile unsigned int*)(0x42210818UL)))
#define bM4_AOS_TMR0_HTSSR_TRGSEL7                (*((volatile unsigned int*)(0x4221081CUL)))
#define bM4_AOS_TMR0_HTSSR_TRGSEL8                (*((volatile unsigned int*)(0x42210820UL)))
#define bM4_AOS_TMR0_HTSSR_COMTRG_EN0             (*((volatile unsigned int*)(0x42210878UL)))
#define bM4_AOS_TMR0_HTSSR_COMTRG_EN1             (*((volatile unsigned int*)(0x4221087CUL)))
#define bM4_AOS_PEVNTTRGSR12_TRGSEL0              (*((volatile unsigned int*)(0x42210880UL)))
#define bM4_AOS_PEVNTTRGSR12_TRGSEL1              (*((volatile unsigned int*)(0x42210884UL)))
#define bM4_AOS_PEVNTTRGSR12_TRGSEL2              (*((volatile unsigned int*)(0x42210888UL)))
#define bM4_AOS_PEVNTTRGSR12_TRGSEL3              (*((volatile unsigned int*)(0x4221088CUL)))
#define bM4_AOS_PEVNTTRGSR12_TRGSEL4              (*((volatile unsigned int*)(0x42210890UL)))
#define bM4_AOS_PEVNTTRGSR12_TRGSEL5              (*((volatile unsigned int*)(0x42210894UL)))
#define bM4_AOS_PEVNTTRGSR12_TRGSEL6              (*((volatile unsigned int*)(0x42210898UL)))
#define bM4_AOS_PEVNTTRGSR12_TRGSEL7              (*((volatile unsigned int*)(0x4221089CUL)))
#define bM4_AOS_PEVNTTRGSR12_TRGSEL8              (*((volatile unsigned int*)(0x422108A0UL)))
#define bM4_AOS_PEVNTTRGSR12_COMTRG_EN0           (*((volatile unsigned int*)(0x422108F8UL)))
#define bM4_AOS_PEVNTTRGSR12_COMTRG_EN1           (*((volatile unsigned int*)(0x422108FCUL)))
#define bM4_AOS_PEVNTTRGSR34_TRGSEL0              (*((volatile unsigned int*)(0x42210900UL)))
#define bM4_AOS_PEVNTTRGSR34_TRGSEL1              (*((volatile unsigned int*)(0x42210904UL)))
#define bM4_AOS_PEVNTTRGSR34_TRGSEL2              (*((volatile unsigned int*)(0x42210908UL)))
#define bM4_AOS_PEVNTTRGSR34_TRGSEL3              (*((volatile unsigned int*)(0x4221090CUL)))
#define bM4_AOS_PEVNTTRGSR34_TRGSEL4              (*((volatile unsigned int*)(0x42210910UL)))
#define bM4_AOS_PEVNTTRGSR34_TRGSEL5              (*((volatile unsigned int*)(0x42210914UL)))
#define bM4_AOS_PEVNTTRGSR34_TRGSEL6              (*((volatile unsigned int*)(0x42210918UL)))
#define bM4_AOS_PEVNTTRGSR34_TRGSEL7              (*((volatile unsigned int*)(0x4221091CUL)))
#define bM4_AOS_PEVNTTRGSR34_TRGSEL8              (*((volatile unsigned int*)(0x42210920UL)))
#define bM4_AOS_PEVNTTRGSR34_COMTRG_EN0           (*((volatile unsigned int*)(0x42210978UL)))
#define bM4_AOS_PEVNTTRGSR34_COMTRG_EN1           (*((volatile unsigned int*)(0x4221097CUL)))
#define bM4_AOS_TMRA_HTSSR0_TRGSEL0               (*((volatile unsigned int*)(0x42210980UL)))
#define bM4_AOS_TMRA_HTSSR0_TRGSEL1               (*((volatile unsigned int*)(0x42210984UL)))
#define bM4_AOS_TMRA_HTSSR0_TRGSEL2               (*((volatile unsigned int*)(0x42210988UL)))
#define bM4_AOS_TMRA_HTSSR0_TRGSEL3               (*((volatile unsigned int*)(0x4221098CUL)))
#define bM4_AOS_TMRA_HTSSR0_TRGSEL4               (*((volatile unsigned int*)(0x42210990UL)))
#define bM4_AOS_TMRA_HTSSR0_TRGSEL5               (*((volatile unsigned int*)(0x42210994UL)))
#define bM4_AOS_TMRA_HTSSR0_TRGSEL6               (*((volatile unsigned int*)(0x42210998UL)))
#define bM4_AOS_TMRA_HTSSR0_TRGSEL7               (*((volatile unsigned int*)(0x4221099CUL)))
#define bM4_AOS_TMRA_HTSSR0_TRGSEL8               (*((volatile unsigned int*)(0x422109A0UL)))
#define bM4_AOS_TMRA_HTSSR0_COMTRG_EN0            (*((volatile unsigned int*)(0x422109F8UL)))
#define bM4_AOS_TMRA_HTSSR0_COMTRG_EN1            (*((volatile unsigned int*)(0x422109FCUL)))
#define bM4_AOS_TMRA_HTSSR1_TRGSEL0               (*((volatile unsigned int*)(0x42210A00UL)))
#define bM4_AOS_TMRA_HTSSR1_TRGSEL1               (*((volatile unsigned int*)(0x42210A04UL)))
#define bM4_AOS_TMRA_HTSSR1_TRGSEL2               (*((volatile unsigned int*)(0x42210A08UL)))
#define bM4_AOS_TMRA_HTSSR1_TRGSEL3               (*((volatile unsigned int*)(0x42210A0CUL)))
#define bM4_AOS_TMRA_HTSSR1_TRGSEL4               (*((volatile unsigned int*)(0x42210A10UL)))
#define bM4_AOS_TMRA_HTSSR1_TRGSEL5               (*((volatile unsigned int*)(0x42210A14UL)))
#define bM4_AOS_TMRA_HTSSR1_TRGSEL6               (*((volatile unsigned int*)(0x42210A18UL)))
#define bM4_AOS_TMRA_HTSSR1_TRGSEL7               (*((volatile unsigned int*)(0x42210A1CUL)))
#define bM4_AOS_TMRA_HTSSR1_TRGSEL8               (*((volatile unsigned int*)(0x42210A20UL)))
#define bM4_AOS_TMRA_HTSSR1_COMTRG_EN0            (*((volatile unsigned int*)(0x42210A78UL)))
#define bM4_AOS_TMRA_HTSSR1_COMTRG_EN1            (*((volatile unsigned int*)(0x42210A7CUL)))
#define bM4_AOS_OTS_TRG_TRGSEL0                   (*((volatile unsigned int*)(0x42210A80UL)))
#define bM4_AOS_OTS_TRG_TRGSEL1                   (*((volatile unsigned int*)(0x42210A84UL)))
#define bM4_AOS_OTS_TRG_TRGSEL2                   (*((volatile unsigned int*)(0x42210A88UL)))
#define bM4_AOS_OTS_TRG_TRGSEL3                   (*((volatile unsigned int*)(0x42210A8CUL)))
#define bM4_AOS_OTS_TRG_TRGSEL4                   (*((volatile unsigned int*)(0x42210A90UL)))
#define bM4_AOS_OTS_TRG_TRGSEL5                   (*((volatile unsigned int*)(0x42210A94UL)))
#define bM4_AOS_OTS_TRG_TRGSEL6                   (*((volatile unsigned int*)(0x42210A98UL)))
#define bM4_AOS_OTS_TRG_TRGSEL7                   (*((volatile unsigned int*)(0x42210A9CUL)))
#define bM4_AOS_OTS_TRG_TRGSEL8                   (*((volatile unsigned int*)(0x42210AA0UL)))
#define bM4_AOS_OTS_TRG_COMTRG_EN0                (*((volatile unsigned int*)(0x42210AF8UL)))
#define bM4_AOS_OTS_TRG_COMTRG_EN1                (*((volatile unsigned int*)(0x42210AFCUL)))
#define bM4_AOS_ADC1_ITRGSELR0_TRGSEL0            (*((volatile unsigned int*)(0x42210B00UL)))
#define bM4_AOS_ADC1_ITRGSELR0_TRGSEL1            (*((volatile unsigned int*)(0x42210B04UL)))
#define bM4_AOS_ADC1_ITRGSELR0_TRGSEL2            (*((volatile unsigned int*)(0x42210B08UL)))
#define bM4_AOS_ADC1_ITRGSELR0_TRGSEL3            (*((volatile unsigned int*)(0x42210B0CUL)))
#define bM4_AOS_ADC1_ITRGSELR0_TRGSEL4            (*((volatile unsigned int*)(0x42210B10UL)))
#define bM4_AOS_ADC1_ITRGSELR0_TRGSEL5            (*((volatile unsigned int*)(0x42210B14UL)))
#define bM4_AOS_ADC1_ITRGSELR0_TRGSEL6            (*((volatile unsigned int*)(0x42210B18UL)))
#define bM4_AOS_ADC1_ITRGSELR0_TRGSEL7            (*((volatile unsigned int*)(0x42210B1CUL)))
#define bM4_AOS_ADC1_ITRGSELR0_TRGSEL8            (*((volatile unsigned int*)(0x42210B20UL)))
#define bM4_AOS_ADC1_ITRGSELR0_COMTRG_EN0         (*((volatile unsigned int*)(0x42210B78UL)))
#define bM4_AOS_ADC1_ITRGSELR0_COMTRG_EN1         (*((volatile unsigned int*)(0x42210B7CUL)))
#define bM4_AOS_ADC1_ITRGSELR1_TRGSEL0            (*((volatile unsigned int*)(0x42210B80UL)))
#define bM4_AOS_ADC1_ITRGSELR1_TRGSEL1            (*((volatile unsigned int*)(0x42210B84UL)))
#define bM4_AOS_ADC1_ITRGSELR1_TRGSEL2            (*((volatile unsigned int*)(0x42210B88UL)))
#define bM4_AOS_ADC1_ITRGSELR1_TRGSEL3            (*((volatile unsigned int*)(0x42210B8CUL)))
#define bM4_AOS_ADC1_ITRGSELR1_TRGSEL4            (*((volatile unsigned int*)(0x42210B90UL)))
#define bM4_AOS_ADC1_ITRGSELR1_TRGSEL5            (*((volatile unsigned int*)(0x42210B94UL)))
#define bM4_AOS_ADC1_ITRGSELR1_TRGSEL6            (*((volatile unsigned int*)(0x42210B98UL)))
#define bM4_AOS_ADC1_ITRGSELR1_TRGSEL7            (*((volatile unsigned int*)(0x42210B9CUL)))
#define bM4_AOS_ADC1_ITRGSELR1_TRGSEL8            (*((volatile unsigned int*)(0x42210BA0UL)))
#define bM4_AOS_ADC1_ITRGSELR1_COMTRG_EN0         (*((volatile unsigned int*)(0x42210BF8UL)))
#define bM4_AOS_ADC1_ITRGSELR1_COMTRG_EN1         (*((volatile unsigned int*)(0x42210BFCUL)))
#define bM4_AOS_ADC2_ITRGSELR0_TRGSEL0            (*((volatile unsigned int*)(0x42210C00UL)))
#define bM4_AOS_ADC2_ITRGSELR0_TRGSEL1            (*((volatile unsigned int*)(0x42210C04UL)))
#define bM4_AOS_ADC2_ITRGSELR0_TRGSEL2            (*((volatile unsigned int*)(0x42210C08UL)))
#define bM4_AOS_ADC2_ITRGSELR0_TRGSEL3            (*((volatile unsigned int*)(0x42210C0CUL)))
#define bM4_AOS_ADC2_ITRGSELR0_TRGSEL4            (*((volatile unsigned int*)(0x42210C10UL)))
#define bM4_AOS_ADC2_ITRGSELR0_TRGSEL5            (*((volatile unsigned int*)(0x42210C14UL)))
#define bM4_AOS_ADC2_ITRGSELR0_TRGSEL6            (*((volatile unsigned int*)(0x42210C18UL)))
#define bM4_AOS_ADC2_ITRGSELR0_TRGSEL7            (*((volatile unsigned int*)(0x42210C1CUL)))
#define bM4_AOS_ADC2_ITRGSELR0_TRGSEL8            (*((volatile unsigned int*)(0x42210C20UL)))
#define bM4_AOS_ADC2_ITRGSELR0_COMTRG_EN0         (*((volatile unsigned int*)(0x42210C78UL)))
#define bM4_AOS_ADC2_ITRGSELR0_COMTRG_EN1         (*((volatile unsigned int*)(0x42210C7CUL)))
#define bM4_AOS_ADC2_ITRGSELR1_TRGSEL0            (*((volatile unsigned int*)(0x42210C80UL)))
#define bM4_AOS_ADC2_ITRGSELR1_TRGSEL1            (*((volatile unsigned int*)(0x42210C84UL)))
#define bM4_AOS_ADC2_ITRGSELR1_TRGSEL2            (*((volatile unsigned int*)(0x42210C88UL)))
#define bM4_AOS_ADC2_ITRGSELR1_TRGSEL3            (*((volatile unsigned int*)(0x42210C8CUL)))
#define bM4_AOS_ADC2_ITRGSELR1_TRGSEL4            (*((volatile unsigned int*)(0x42210C90UL)))
#define bM4_AOS_ADC2_ITRGSELR1_TRGSEL5            (*((volatile unsigned int*)(0x42210C94UL)))
#define bM4_AOS_ADC2_ITRGSELR1_TRGSEL6            (*((volatile unsigned int*)(0x42210C98UL)))
#define bM4_AOS_ADC2_ITRGSELR1_TRGSEL7            (*((volatile unsigned int*)(0x42210C9CUL)))
#define bM4_AOS_ADC2_ITRGSELR1_TRGSEL8            (*((volatile unsigned int*)(0x42210CA0UL)))
#define bM4_AOS_ADC2_ITRGSELR1_COMTRG_EN0         (*((volatile unsigned int*)(0x42210CF8UL)))
#define bM4_AOS_ADC2_ITRGSELR1_COMTRG_EN1         (*((volatile unsigned int*)(0x42210CFCUL)))
#define bM4_AOS_COMTRG1_TRGSEL0                   (*((volatile unsigned int*)(0x42210D00UL)))
#define bM4_AOS_COMTRG1_TRGSEL1                   (*((volatile unsigned int*)(0x42210D04UL)))
#define bM4_AOS_COMTRG1_TRGSEL2                   (*((volatile unsigned int*)(0x42210D08UL)))
#define bM4_AOS_COMTRG1_TRGSEL3                   (*((volatile unsigned int*)(0x42210D0CUL)))
#define bM4_AOS_COMTRG1_TRGSEL4                   (*((volatile unsigned int*)(0x42210D10UL)))
#define bM4_AOS_COMTRG1_TRGSEL5                   (*((volatile unsigned int*)(0x42210D14UL)))
#define bM4_AOS_COMTRG1_TRGSEL6                   (*((volatile unsigned int*)(0x42210D18UL)))
#define bM4_AOS_COMTRG1_TRGSEL7                   (*((volatile unsigned int*)(0x42210D1CUL)))
#define bM4_AOS_COMTRG1_TRGSEL8                   (*((volatile unsigned int*)(0x42210D20UL)))
#define bM4_AOS_COMTRG2_TRGSEL0                   (*((volatile unsigned int*)(0x42210D80UL)))
#define bM4_AOS_COMTRG2_TRGSEL1                   (*((volatile unsigned int*)(0x42210D84UL)))
#define bM4_AOS_COMTRG2_TRGSEL2                   (*((volatile unsigned int*)(0x42210D88UL)))
#define bM4_AOS_COMTRG2_TRGSEL3                   (*((volatile unsigned int*)(0x42210D8CUL)))
#define bM4_AOS_COMTRG2_TRGSEL4                   (*((volatile unsigned int*)(0x42210D90UL)))
#define bM4_AOS_COMTRG2_TRGSEL5                   (*((volatile unsigned int*)(0x42210D94UL)))
#define bM4_AOS_COMTRG2_TRGSEL6                   (*((volatile unsigned int*)(0x42210D98UL)))
#define bM4_AOS_COMTRG2_TRGSEL7                   (*((volatile unsigned int*)(0x42210D9CUL)))
#define bM4_AOS_COMTRG2_TRGSEL8                   (*((volatile unsigned int*)(0x42210DA0UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR00                 (*((volatile unsigned int*)(0x42212000UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR01                 (*((volatile unsigned int*)(0x42212004UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR02                 (*((volatile unsigned int*)(0x42212008UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR03                 (*((volatile unsigned int*)(0x4221200CUL)))
#define bM4_AOS_PEVNTDIRR1_PDIR04                 (*((volatile unsigned int*)(0x42212010UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR05                 (*((volatile unsigned int*)(0x42212014UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR06                 (*((volatile unsigned int*)(0x42212018UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR07                 (*((volatile unsigned int*)(0x4221201CUL)))
#define bM4_AOS_PEVNTDIRR1_PDIR08                 (*((volatile unsigned int*)(0x42212020UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR09                 (*((volatile unsigned int*)(0x42212024UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR10                 (*((volatile unsigned int*)(0x42212028UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR11                 (*((volatile unsigned int*)(0x4221202CUL)))
#define bM4_AOS_PEVNTDIRR1_PDIR12                 (*((volatile unsigned int*)(0x42212030UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR13                 (*((volatile unsigned int*)(0x42212034UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR14                 (*((volatile unsigned int*)(0x42212038UL)))
#define bM4_AOS_PEVNTDIRR1_PDIR15                 (*((volatile unsigned int*)(0x4221203CUL)))
#define bM4_AOS_PEVNTIDR1_PIN00                   (*((volatile unsigned int*)(0x42212080UL)))
#define bM4_AOS_PEVNTIDR1_PIN01                   (*((volatile unsigned int*)(0x42212084UL)))
#define bM4_AOS_PEVNTIDR1_PIN02                   (*((volatile unsigned int*)(0x42212088UL)))
#define bM4_AOS_PEVNTIDR1_PIN03                   (*((volatile unsigned int*)(0x4221208CUL)))
#define bM4_AOS_PEVNTIDR1_PIN04                   (*((volatile unsigned int*)(0x42212090UL)))
#define bM4_AOS_PEVNTIDR1_PIN05                   (*((volatile unsigned int*)(0x42212094UL)))
#define bM4_AOS_PEVNTIDR1_PIN06                   (*((volatile unsigned int*)(0x42212098UL)))
#define bM4_AOS_PEVNTIDR1_PIN07                   (*((volatile unsigned int*)(0x4221209CUL)))
#define bM4_AOS_PEVNTIDR1_PIN08                   (*((volatile unsigned int*)(0x422120A0UL)))
#define bM4_AOS_PEVNTIDR1_PIN09                   (*((volatile unsigned int*)(0x422120A4UL)))
#define bM4_AOS_PEVNTIDR1_PIN10                   (*((volatile unsigned int*)(0x422120A8UL)))
#define bM4_AOS_PEVNTIDR1_PIN11                   (*((volatile unsigned int*)(0x422120ACUL)))
#define bM4_AOS_PEVNTIDR1_PIN12                   (*((volatile unsigned int*)(0x422120B0UL)))
#define bM4_AOS_PEVNTIDR1_PIN13                   (*((volatile unsigned int*)(0x422120B4UL)))
#define bM4_AOS_PEVNTIDR1_PIN14                   (*((volatile unsigned int*)(0x422120B8UL)))
#define bM4_AOS_PEVNTIDR1_PIN15                   (*((volatile unsigned int*)(0x422120BCUL)))
#define bM4_AOS_PEVNTODR1_POUT00                  (*((volatile unsigned int*)(0x42212100UL)))
#define bM4_AOS_PEVNTODR1_POUT01                  (*((volatile unsigned int*)(0x42212104UL)))
#define bM4_AOS_PEVNTODR1_POUT02                  (*((volatile unsigned int*)(0x42212108UL)))
#define bM4_AOS_PEVNTODR1_POUT03                  (*((volatile unsigned int*)(0x4221210CUL)))
#define bM4_AOS_PEVNTODR1_POUT04                  (*((volatile unsigned int*)(0x42212110UL)))
#define bM4_AOS_PEVNTODR1_POUT05                  (*((volatile unsigned int*)(0x42212114UL)))
#define bM4_AOS_PEVNTODR1_POUT06                  (*((volatile unsigned int*)(0x42212118UL)))
#define bM4_AOS_PEVNTODR1_POUT07                  (*((volatile unsigned int*)(0x4221211CUL)))
#define bM4_AOS_PEVNTODR1_POUT08                  (*((volatile unsigned int*)(0x42212120UL)))
#define bM4_AOS_PEVNTODR1_POUT09                  (*((volatile unsigned int*)(0x42212124UL)))
#define bM4_AOS_PEVNTODR1_POUT10                  (*((volatile unsigned int*)(0x42212128UL)))
#define bM4_AOS_PEVNTODR1_POUT11                  (*((volatile unsigned int*)(0x4221212CUL)))
#define bM4_AOS_PEVNTODR1_POUT12                  (*((volatile unsigned int*)(0x42212130UL)))
#define bM4_AOS_PEVNTODR1_POUT13                  (*((volatile unsigned int*)(0x42212134UL)))
#define bM4_AOS_PEVNTODR1_POUT14                  (*((volatile unsigned int*)(0x42212138UL)))
#define bM4_AOS_PEVNTODR1_POUT15                  (*((volatile unsigned int*)(0x4221213CUL)))
#define bM4_AOS_PEVNTORR1_POR00                   (*((volatile unsigned int*)(0x42212180UL)))
#define bM4_AOS_PEVNTORR1_POR01                   (*((volatile unsigned int*)(0x42212184UL)))
#define bM4_AOS_PEVNTORR1_POR02                   (*((volatile unsigned int*)(0x42212188UL)))
#define bM4_AOS_PEVNTORR1_POR03                   (*((volatile unsigned int*)(0x4221218CUL)))
#define bM4_AOS_PEVNTORR1_POR04                   (*((volatile unsigned int*)(0x42212190UL)))
#define bM4_AOS_PEVNTORR1_POR05                   (*((volatile unsigned int*)(0x42212194UL)))
#define bM4_AOS_PEVNTORR1_POR06                   (*((volatile unsigned int*)(0x42212198UL)))
#define bM4_AOS_PEVNTORR1_POR07                   (*((volatile unsigned int*)(0x4221219CUL)))
#define bM4_AOS_PEVNTORR1_POR08                   (*((volatile unsigned int*)(0x422121A0UL)))
#define bM4_AOS_PEVNTORR1_POR09                   (*((volatile unsigned int*)(0x422121A4UL)))
#define bM4_AOS_PEVNTORR1_POR10                   (*((volatile unsigned int*)(0x422121A8UL)))
#define bM4_AOS_PEVNTORR1_POR11                   (*((volatile unsigned int*)(0x422121ACUL)))
#define bM4_AOS_PEVNTORR1_POR12                   (*((volatile unsigned int*)(0x422121B0UL)))
#define bM4_AOS_PEVNTORR1_POR13                   (*((volatile unsigned int*)(0x422121B4UL)))
#define bM4_AOS_PEVNTORR1_POR14                   (*((volatile unsigned int*)(0x422121B8UL)))
#define bM4_AOS_PEVNTORR1_POR15                   (*((volatile unsigned int*)(0x422121BCUL)))
#define bM4_AOS_PEVNTOSR1_POS00                   (*((volatile unsigned int*)(0x42212200UL)))
#define bM4_AOS_PEVNTOSR1_POS01                   (*((volatile unsigned int*)(0x42212204UL)))
#define bM4_AOS_PEVNTOSR1_POS02                   (*((volatile unsigned int*)(0x42212208UL)))
#define bM4_AOS_PEVNTOSR1_POS03                   (*((volatile unsigned int*)(0x4221220CUL)))
#define bM4_AOS_PEVNTOSR1_POS04                   (*((volatile unsigned int*)(0x42212210UL)))
#define bM4_AOS_PEVNTOSR1_POS05                   (*((volatile unsigned int*)(0x42212214UL)))
#define bM4_AOS_PEVNTOSR1_POS06                   (*((volatile unsigned int*)(0x42212218UL)))
#define bM4_AOS_PEVNTOSR1_POS07                   (*((volatile unsigned int*)(0x4221221CUL)))
#define bM4_AOS_PEVNTOSR1_POS08                   (*((volatile unsigned int*)(0x42212220UL)))
#define bM4_AOS_PEVNTOSR1_POS09                   (*((volatile unsigned int*)(0x42212224UL)))
#define bM4_AOS_PEVNTOSR1_POS10                   (*((volatile unsigned int*)(0x42212228UL)))
#define bM4_AOS_PEVNTOSR1_POS11                   (*((volatile unsigned int*)(0x4221222CUL)))
#define bM4_AOS_PEVNTOSR1_POS12                   (*((volatile unsigned int*)(0x42212230UL)))
#define bM4_AOS_PEVNTOSR1_POS13                   (*((volatile unsigned int*)(0x42212234UL)))
#define bM4_AOS_PEVNTOSR1_POS14                   (*((volatile unsigned int*)(0x42212238UL)))
#define bM4_AOS_PEVNTOSR1_POS15                   (*((volatile unsigned int*)(0x4221223CUL)))
#define bM4_AOS_PEVNTRISR1_RIS00                  (*((volatile unsigned int*)(0x42212280UL)))
#define bM4_AOS_PEVNTRISR1_RIS01                  (*((volatile unsigned int*)(0x42212284UL)))
#define bM4_AOS_PEVNTRISR1_RIS02                  (*((volatile unsigned int*)(0x42212288UL)))
#define bM4_AOS_PEVNTRISR1_RIS03                  (*((volatile unsigned int*)(0x4221228CUL)))
#define bM4_AOS_PEVNTRISR1_RIS04                  (*((volatile unsigned int*)(0x42212290UL)))
#define bM4_AOS_PEVNTRISR1_RIS05                  (*((volatile unsigned int*)(0x42212294UL)))
#define bM4_AOS_PEVNTRISR1_RIS06                  (*((volatile unsigned int*)(0x42212298UL)))
#define bM4_AOS_PEVNTRISR1_RIS07                  (*((volatile unsigned int*)(0x4221229CUL)))
#define bM4_AOS_PEVNTRISR1_RIS08                  (*((volatile unsigned int*)(0x422122A0UL)))
#define bM4_AOS_PEVNTRISR1_RIS09                  (*((volatile unsigned int*)(0x422122A4UL)))
#define bM4_AOS_PEVNTRISR1_RIS10                  (*((volatile unsigned int*)(0x422122A8UL)))
#define bM4_AOS_PEVNTRISR1_RIS11                  (*((volatile unsigned int*)(0x422122ACUL)))
#define bM4_AOS_PEVNTRISR1_RIS12                  (*((volatile unsigned int*)(0x422122B0UL)))
#define bM4_AOS_PEVNTRISR1_RIS13                  (*((volatile unsigned int*)(0x422122B4UL)))
#define bM4_AOS_PEVNTRISR1_RIS14                  (*((volatile unsigned int*)(0x422122B8UL)))
#define bM4_AOS_PEVNTRISR1_RIS15                  (*((volatile unsigned int*)(0x422122BCUL)))
#define bM4_AOS_PEVNTFAL1_FAL00                   (*((volatile unsigned int*)(0x42212300UL)))
#define bM4_AOS_PEVNTFAL1_FAL01                   (*((volatile unsigned int*)(0x42212304UL)))
#define bM4_AOS_PEVNTFAL1_FAL02                   (*((volatile unsigned int*)(0x42212308UL)))
#define bM4_AOS_PEVNTFAL1_FAL03                   (*((volatile unsigned int*)(0x4221230CUL)))
#define bM4_AOS_PEVNTFAL1_FAL04                   (*((volatile unsigned int*)(0x42212310UL)))
#define bM4_AOS_PEVNTFAL1_FAL05                   (*((volatile unsigned int*)(0x42212314UL)))
#define bM4_AOS_PEVNTFAL1_FAL06                   (*((volatile unsigned int*)(0x42212318UL)))
#define bM4_AOS_PEVNTFAL1_FAL07                   (*((volatile unsigned int*)(0x4221231CUL)))
#define bM4_AOS_PEVNTFAL1_FAL08                   (*((volatile unsigned int*)(0x42212320UL)))
#define bM4_AOS_PEVNTFAL1_FAL09                   (*((volatile unsigned int*)(0x42212324UL)))
#define bM4_AOS_PEVNTFAL1_FAL10                   (*((volatile unsigned int*)(0x42212328UL)))
#define bM4_AOS_PEVNTFAL1_FAL11                   (*((volatile unsigned int*)(0x4221232CUL)))
#define bM4_AOS_PEVNTFAL1_FAL12                   (*((volatile unsigned int*)(0x42212330UL)))
#define bM4_AOS_PEVNTFAL1_FAL13                   (*((volatile unsigned int*)(0x42212334UL)))
#define bM4_AOS_PEVNTFAL1_FAL14                   (*((volatile unsigned int*)(0x42212338UL)))
#define bM4_AOS_PEVNTFAL1_FAL15                   (*((volatile unsigned int*)(0x4221233CUL)))
#define bM4_AOS_PEVNTDIRR2_PDIR00                 (*((volatile unsigned int*)(0x42212380UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR01                 (*((volatile unsigned int*)(0x42212384UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR02                 (*((volatile unsigned int*)(0x42212388UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR03                 (*((volatile unsigned int*)(0x4221238CUL)))
#define bM4_AOS_PEVNTDIRR2_PDIR04                 (*((volatile unsigned int*)(0x42212390UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR05                 (*((volatile unsigned int*)(0x42212394UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR06                 (*((volatile unsigned int*)(0x42212398UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR07                 (*((volatile unsigned int*)(0x4221239CUL)))
#define bM4_AOS_PEVNTDIRR2_PDIR08                 (*((volatile unsigned int*)(0x422123A0UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR09                 (*((volatile unsigned int*)(0x422123A4UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR10                 (*((volatile unsigned int*)(0x422123A8UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR11                 (*((volatile unsigned int*)(0x422123ACUL)))
#define bM4_AOS_PEVNTDIRR2_PDIR12                 (*((volatile unsigned int*)(0x422123B0UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR13                 (*((volatile unsigned int*)(0x422123B4UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR14                 (*((volatile unsigned int*)(0x422123B8UL)))
#define bM4_AOS_PEVNTDIRR2_PDIR15                 (*((volatile unsigned int*)(0x422123BCUL)))
#define bM4_AOS_PEVNTIDR2_PIN00                   (*((volatile unsigned int*)(0x42212400UL)))
#define bM4_AOS_PEVNTIDR2_PIN01                   (*((volatile unsigned int*)(0x42212404UL)))
#define bM4_AOS_PEVNTIDR2_PIN02                   (*((volatile unsigned int*)(0x42212408UL)))
#define bM4_AOS_PEVNTIDR2_PIN03                   (*((volatile unsigned int*)(0x4221240CUL)))
#define bM4_AOS_PEVNTIDR2_PIN04                   (*((volatile unsigned int*)(0x42212410UL)))
#define bM4_AOS_PEVNTIDR2_PIN05                   (*((volatile unsigned int*)(0x42212414UL)))
#define bM4_AOS_PEVNTIDR2_PIN06                   (*((volatile unsigned int*)(0x42212418UL)))
#define bM4_AOS_PEVNTIDR2_PIN07                   (*((volatile unsigned int*)(0x4221241CUL)))
#define bM4_AOS_PEVNTIDR2_PIN08                   (*((volatile unsigned int*)(0x42212420UL)))
#define bM4_AOS_PEVNTIDR2_PIN09                   (*((volatile unsigned int*)(0x42212424UL)))
#define bM4_AOS_PEVNTIDR2_PIN10                   (*((volatile unsigned int*)(0x42212428UL)))
#define bM4_AOS_PEVNTIDR2_PIN11                   (*((volatile unsigned int*)(0x4221242CUL)))
#define bM4_AOS_PEVNTIDR2_PIN12                   (*((volatile unsigned int*)(0x42212430UL)))
#define bM4_AOS_PEVNTIDR2_PIN13                   (*((volatile unsigned int*)(0x42212434UL)))
#define bM4_AOS_PEVNTIDR2_PIN14                   (*((volatile unsigned int*)(0x42212438UL)))
#define bM4_AOS_PEVNTIDR2_PIN15                   (*((volatile unsigned int*)(0x4221243CUL)))
#define bM4_AOS_PEVNTODR2_POUT00                  (*((volatile unsigned int*)(0x42212480UL)))
#define bM4_AOS_PEVNTODR2_POUT01                  (*((volatile unsigned int*)(0x42212484UL)))
#define bM4_AOS_PEVNTODR2_POUT02                  (*((volatile unsigned int*)(0x42212488UL)))
#define bM4_AOS_PEVNTODR2_POUT03                  (*((volatile unsigned int*)(0x4221248CUL)))
#define bM4_AOS_PEVNTODR2_POUT04                  (*((volatile unsigned int*)(0x42212490UL)))
#define bM4_AOS_PEVNTODR2_POUT05                  (*((volatile unsigned int*)(0x42212494UL)))
#define bM4_AOS_PEVNTODR2_POUT06                  (*((volatile unsigned int*)(0x42212498UL)))
#define bM4_AOS_PEVNTODR2_POUT07                  (*((volatile unsigned int*)(0x4221249CUL)))
#define bM4_AOS_PEVNTODR2_POUT08                  (*((volatile unsigned int*)(0x422124A0UL)))
#define bM4_AOS_PEVNTODR2_POUT09                  (*((volatile unsigned int*)(0x422124A4UL)))
#define bM4_AOS_PEVNTODR2_POUT10                  (*((volatile unsigned int*)(0x422124A8UL)))
#define bM4_AOS_PEVNTODR2_POUT11                  (*((volatile unsigned int*)(0x422124ACUL)))
#define bM4_AOS_PEVNTODR2_POUT12                  (*((volatile unsigned int*)(0x422124B0UL)))
#define bM4_AOS_PEVNTODR2_POUT13                  (*((volatile unsigned int*)(0x422124B4UL)))
#define bM4_AOS_PEVNTODR2_POUT14                  (*((volatile unsigned int*)(0x422124B8UL)))
#define bM4_AOS_PEVNTODR2_POUT15                  (*((volatile unsigned int*)(0x422124BCUL)))
#define bM4_AOS_PEVNTORR2_POR00                   (*((volatile unsigned int*)(0x42212500UL)))
#define bM4_AOS_PEVNTORR2_POR01                   (*((volatile unsigned int*)(0x42212504UL)))
#define bM4_AOS_PEVNTORR2_POR02                   (*((volatile unsigned int*)(0x42212508UL)))
#define bM4_AOS_PEVNTORR2_POR03                   (*((volatile unsigned int*)(0x4221250CUL)))
#define bM4_AOS_PEVNTORR2_POR04                   (*((volatile unsigned int*)(0x42212510UL)))
#define bM4_AOS_PEVNTORR2_POR05                   (*((volatile unsigned int*)(0x42212514UL)))
#define bM4_AOS_PEVNTORR2_POR06                   (*((volatile unsigned int*)(0x42212518UL)))
#define bM4_AOS_PEVNTORR2_POR07                   (*((volatile unsigned int*)(0x4221251CUL)))
#define bM4_AOS_PEVNTORR2_POR08                   (*((volatile unsigned int*)(0x42212520UL)))
#define bM4_AOS_PEVNTORR2_POR09                   (*((volatile unsigned int*)(0x42212524UL)))
#define bM4_AOS_PEVNTORR2_POR10                   (*((volatile unsigned int*)(0x42212528UL)))
#define bM4_AOS_PEVNTORR2_POR11                   (*((volatile unsigned int*)(0x4221252CUL)))
#define bM4_AOS_PEVNTORR2_POR12                   (*((volatile unsigned int*)(0x42212530UL)))
#define bM4_AOS_PEVNTORR2_POR13                   (*((volatile unsigned int*)(0x42212534UL)))
#define bM4_AOS_PEVNTORR2_POR14                   (*((volatile unsigned int*)(0x42212538UL)))
#define bM4_AOS_PEVNTORR2_POR15                   (*((volatile unsigned int*)(0x4221253CUL)))
#define bM4_AOS_PEVNTOSR2_POS00                   (*((volatile unsigned int*)(0x42212580UL)))
#define bM4_AOS_PEVNTOSR2_POS01                   (*((volatile unsigned int*)(0x42212584UL)))
#define bM4_AOS_PEVNTOSR2_POS02                   (*((volatile unsigned int*)(0x42212588UL)))
#define bM4_AOS_PEVNTOSR2_POS03                   (*((volatile unsigned int*)(0x4221258CUL)))
#define bM4_AOS_PEVNTOSR2_POS04                   (*((volatile unsigned int*)(0x42212590UL)))
#define bM4_AOS_PEVNTOSR2_POS05                   (*((volatile unsigned int*)(0x42212594UL)))
#define bM4_AOS_PEVNTOSR2_POS06                   (*((volatile unsigned int*)(0x42212598UL)))
#define bM4_AOS_PEVNTOSR2_POS07                   (*((volatile unsigned int*)(0x4221259CUL)))
#define bM4_AOS_PEVNTOSR2_POS08                   (*((volatile unsigned int*)(0x422125A0UL)))
#define bM4_AOS_PEVNTOSR2_POS09                   (*((volatile unsigned int*)(0x422125A4UL)))
#define bM4_AOS_PEVNTOSR2_POS10                   (*((volatile unsigned int*)(0x422125A8UL)))
#define bM4_AOS_PEVNTOSR2_POS11                   (*((volatile unsigned int*)(0x422125ACUL)))
#define bM4_AOS_PEVNTOSR2_POS12                   (*((volatile unsigned int*)(0x422125B0UL)))
#define bM4_AOS_PEVNTOSR2_POS13                   (*((volatile unsigned int*)(0x422125B4UL)))
#define bM4_AOS_PEVNTOSR2_POS14                   (*((volatile unsigned int*)(0x422125B8UL)))
#define bM4_AOS_PEVNTOSR2_POS15                   (*((volatile unsigned int*)(0x422125BCUL)))
#define bM4_AOS_PEVNTRISR2_RIS00                  (*((volatile unsigned int*)(0x42212600UL)))
#define bM4_AOS_PEVNTRISR2_RIS01                  (*((volatile unsigned int*)(0x42212604UL)))
#define bM4_AOS_PEVNTRISR2_RIS02                  (*((volatile unsigned int*)(0x42212608UL)))
#define bM4_AOS_PEVNTRISR2_RIS03                  (*((volatile unsigned int*)(0x4221260CUL)))
#define bM4_AOS_PEVNTRISR2_RIS04                  (*((volatile unsigned int*)(0x42212610UL)))
#define bM4_AOS_PEVNTRISR2_RIS05                  (*((volatile unsigned int*)(0x42212614UL)))
#define bM4_AOS_PEVNTRISR2_RIS06                  (*((volatile unsigned int*)(0x42212618UL)))
#define bM4_AOS_PEVNTRISR2_RIS07                  (*((volatile unsigned int*)(0x4221261CUL)))
#define bM4_AOS_PEVNTRISR2_RIS08                  (*((volatile unsigned int*)(0x42212620UL)))
#define bM4_AOS_PEVNTRISR2_RIS09                  (*((volatile unsigned int*)(0x42212624UL)))
#define bM4_AOS_PEVNTRISR2_RIS10                  (*((volatile unsigned int*)(0x42212628UL)))
#define bM4_AOS_PEVNTRISR2_RIS11                  (*((volatile unsigned int*)(0x4221262CUL)))
#define bM4_AOS_PEVNTRISR2_RIS12                  (*((volatile unsigned int*)(0x42212630UL)))
#define bM4_AOS_PEVNTRISR2_RIS13                  (*((volatile unsigned int*)(0x42212634UL)))
#define bM4_AOS_PEVNTRISR2_RIS14                  (*((volatile unsigned int*)(0x42212638UL)))
#define bM4_AOS_PEVNTRISR2_RIS15                  (*((volatile unsigned int*)(0x4221263CUL)))
#define bM4_AOS_PEVNTFAL2_FAL00                   (*((volatile unsigned int*)(0x42212680UL)))
#define bM4_AOS_PEVNTFAL2_FAL01                   (*((volatile unsigned int*)(0x42212684UL)))
#define bM4_AOS_PEVNTFAL2_FAL02                   (*((volatile unsigned int*)(0x42212688UL)))
#define bM4_AOS_PEVNTFAL2_FAL03                   (*((volatile unsigned int*)(0x4221268CUL)))
#define bM4_AOS_PEVNTFAL2_FAL04                   (*((volatile unsigned int*)(0x42212690UL)))
#define bM4_AOS_PEVNTFAL2_FAL05                   (*((volatile unsigned int*)(0x42212694UL)))
#define bM4_AOS_PEVNTFAL2_FAL06                   (*((volatile unsigned int*)(0x42212698UL)))
#define bM4_AOS_PEVNTFAL2_FAL07                   (*((volatile unsigned int*)(0x4221269CUL)))
#define bM4_AOS_PEVNTFAL2_FAL08                   (*((volatile unsigned int*)(0x422126A0UL)))
#define bM4_AOS_PEVNTFAL2_FAL09                   (*((volatile unsigned int*)(0x422126A4UL)))
#define bM4_AOS_PEVNTFAL2_FAL10                   (*((volatile unsigned int*)(0x422126A8UL)))
#define bM4_AOS_PEVNTFAL2_FAL11                   (*((volatile unsigned int*)(0x422126ACUL)))
#define bM4_AOS_PEVNTFAL2_FAL12                   (*((volatile unsigned int*)(0x422126B0UL)))
#define bM4_AOS_PEVNTFAL2_FAL13                   (*((volatile unsigned int*)(0x422126B4UL)))
#define bM4_AOS_PEVNTFAL2_FAL14                   (*((volatile unsigned int*)(0x422126B8UL)))
#define bM4_AOS_PEVNTFAL2_FAL15                   (*((volatile unsigned int*)(0x422126BCUL)))
#define bM4_AOS_PEVNTDIRR3_PDIR00                 (*((volatile unsigned int*)(0x42212700UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR01                 (*((volatile unsigned int*)(0x42212704UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR02                 (*((volatile unsigned int*)(0x42212708UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR03                 (*((volatile unsigned int*)(0x4221270CUL)))
#define bM4_AOS_PEVNTDIRR3_PDIR04                 (*((volatile unsigned int*)(0x42212710UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR05                 (*((volatile unsigned int*)(0x42212714UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR06                 (*((volatile unsigned int*)(0x42212718UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR07                 (*((volatile unsigned int*)(0x4221271CUL)))
#define bM4_AOS_PEVNTDIRR3_PDIR08                 (*((volatile unsigned int*)(0x42212720UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR09                 (*((volatile unsigned int*)(0x42212724UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR10                 (*((volatile unsigned int*)(0x42212728UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR11                 (*((volatile unsigned int*)(0x4221272CUL)))
#define bM4_AOS_PEVNTDIRR3_PDIR12                 (*((volatile unsigned int*)(0x42212730UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR13                 (*((volatile unsigned int*)(0x42212734UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR14                 (*((volatile unsigned int*)(0x42212738UL)))
#define bM4_AOS_PEVNTDIRR3_PDIR15                 (*((volatile unsigned int*)(0x4221273CUL)))
#define bM4_AOS_PEVNTIDR3_PIN00                   (*((volatile unsigned int*)(0x42212780UL)))
#define bM4_AOS_PEVNTIDR3_PIN01                   (*((volatile unsigned int*)(0x42212784UL)))
#define bM4_AOS_PEVNTIDR3_PIN02                   (*((volatile unsigned int*)(0x42212788UL)))
#define bM4_AOS_PEVNTIDR3_PIN03                   (*((volatile unsigned int*)(0x4221278CUL)))
#define bM4_AOS_PEVNTIDR3_PIN04                   (*((volatile unsigned int*)(0x42212790UL)))
#define bM4_AOS_PEVNTIDR3_PIN05                   (*((volatile unsigned int*)(0x42212794UL)))
#define bM4_AOS_PEVNTIDR3_PIN06                   (*((volatile unsigned int*)(0x42212798UL)))
#define bM4_AOS_PEVNTIDR3_PIN07                   (*((volatile unsigned int*)(0x4221279CUL)))
#define bM4_AOS_PEVNTIDR3_PIN08                   (*((volatile unsigned int*)(0x422127A0UL)))
#define bM4_AOS_PEVNTIDR3_PIN09                   (*((volatile unsigned int*)(0x422127A4UL)))
#define bM4_AOS_PEVNTIDR3_PIN10                   (*((volatile unsigned int*)(0x422127A8UL)))
#define bM4_AOS_PEVNTIDR3_PIN11                   (*((volatile unsigned int*)(0x422127ACUL)))
#define bM4_AOS_PEVNTIDR3_PIN12                   (*((volatile unsigned int*)(0x422127B0UL)))
#define bM4_AOS_PEVNTIDR3_PIN13                   (*((volatile unsigned int*)(0x422127B4UL)))
#define bM4_AOS_PEVNTIDR3_PIN14                   (*((volatile unsigned int*)(0x422127B8UL)))
#define bM4_AOS_PEVNTIDR3_PIN15                   (*((volatile unsigned int*)(0x422127BCUL)))
#define bM4_AOS_PEVNTODR3_POUT00                  (*((volatile unsigned int*)(0x42212800UL)))
#define bM4_AOS_PEVNTODR3_POUT01                  (*((volatile unsigned int*)(0x42212804UL)))
#define bM4_AOS_PEVNTODR3_POUT02                  (*((volatile unsigned int*)(0x42212808UL)))
#define bM4_AOS_PEVNTODR3_POUT03                  (*((volatile unsigned int*)(0x4221280CUL)))
#define bM4_AOS_PEVNTODR3_POUT04                  (*((volatile unsigned int*)(0x42212810UL)))
#define bM4_AOS_PEVNTODR3_POUT05                  (*((volatile unsigned int*)(0x42212814UL)))
#define bM4_AOS_PEVNTODR3_POUT06                  (*((volatile unsigned int*)(0x42212818UL)))
#define bM4_AOS_PEVNTODR3_POUT07                  (*((volatile unsigned int*)(0x4221281CUL)))
#define bM4_AOS_PEVNTODR3_POUT08                  (*((volatile unsigned int*)(0x42212820UL)))
#define bM4_AOS_PEVNTODR3_POUT09                  (*((volatile unsigned int*)(0x42212824UL)))
#define bM4_AOS_PEVNTODR3_POUT10                  (*((volatile unsigned int*)(0x42212828UL)))
#define bM4_AOS_PEVNTODR3_POUT11                  (*((volatile unsigned int*)(0x4221282CUL)))
#define bM4_AOS_PEVNTODR3_POUT12                  (*((volatile unsigned int*)(0x42212830UL)))
#define bM4_AOS_PEVNTODR3_POUT13                  (*((volatile unsigned int*)(0x42212834UL)))
#define bM4_AOS_PEVNTODR3_POUT14                  (*((volatile unsigned int*)(0x42212838UL)))
#define bM4_AOS_PEVNTODR3_POUT15                  (*((volatile unsigned int*)(0x4221283CUL)))
#define bM4_AOS_PEVNTORR3_POR00                   (*((volatile unsigned int*)(0x42212880UL)))
#define bM4_AOS_PEVNTORR3_POR01                   (*((volatile unsigned int*)(0x42212884UL)))
#define bM4_AOS_PEVNTORR3_POR02                   (*((volatile unsigned int*)(0x42212888UL)))
#define bM4_AOS_PEVNTORR3_POR03                   (*((volatile unsigned int*)(0x4221288CUL)))
#define bM4_AOS_PEVNTORR3_POR04                   (*((volatile unsigned int*)(0x42212890UL)))
#define bM4_AOS_PEVNTORR3_POR05                   (*((volatile unsigned int*)(0x42212894UL)))
#define bM4_AOS_PEVNTORR3_POR06                   (*((volatile unsigned int*)(0x42212898UL)))
#define bM4_AOS_PEVNTORR3_POR07                   (*((volatile unsigned int*)(0x4221289CUL)))
#define bM4_AOS_PEVNTORR3_POR08                   (*((volatile unsigned int*)(0x422128A0UL)))
#define bM4_AOS_PEVNTORR3_POR09                   (*((volatile unsigned int*)(0x422128A4UL)))
#define bM4_AOS_PEVNTORR3_POR10                   (*((volatile unsigned int*)(0x422128A8UL)))
#define bM4_AOS_PEVNTORR3_POR11                   (*((volatile unsigned int*)(0x422128ACUL)))
#define bM4_AOS_PEVNTORR3_POR12                   (*((volatile unsigned int*)(0x422128B0UL)))
#define bM4_AOS_PEVNTORR3_POR13                   (*((volatile unsigned int*)(0x422128B4UL)))
#define bM4_AOS_PEVNTORR3_POR14                   (*((volatile unsigned int*)(0x422128B8UL)))
#define bM4_AOS_PEVNTORR3_POR15                   (*((volatile unsigned int*)(0x422128BCUL)))
#define bM4_AOS_PEVNTOSR3_POS00                   (*((volatile unsigned int*)(0x42212900UL)))
#define bM4_AOS_PEVNTOSR3_POS01                   (*((volatile unsigned int*)(0x42212904UL)))
#define bM4_AOS_PEVNTOSR3_POS02                   (*((volatile unsigned int*)(0x42212908UL)))
#define bM4_AOS_PEVNTOSR3_POS03                   (*((volatile unsigned int*)(0x4221290CUL)))
#define bM4_AOS_PEVNTOSR3_POS04                   (*((volatile unsigned int*)(0x42212910UL)))
#define bM4_AOS_PEVNTOSR3_POS05                   (*((volatile unsigned int*)(0x42212914UL)))
#define bM4_AOS_PEVNTOSR3_POS06                   (*((volatile unsigned int*)(0x42212918UL)))
#define bM4_AOS_PEVNTOSR3_POS07                   (*((volatile unsigned int*)(0x4221291CUL)))
#define bM4_AOS_PEVNTOSR3_POS08                   (*((volatile unsigned int*)(0x42212920UL)))
#define bM4_AOS_PEVNTOSR3_POS09                   (*((volatile unsigned int*)(0x42212924UL)))
#define bM4_AOS_PEVNTOSR3_POS10                   (*((volatile unsigned int*)(0x42212928UL)))
#define bM4_AOS_PEVNTOSR3_POS11                   (*((volatile unsigned int*)(0x4221292CUL)))
#define bM4_AOS_PEVNTOSR3_POS12                   (*((volatile unsigned int*)(0x42212930UL)))
#define bM4_AOS_PEVNTOSR3_POS13                   (*((volatile unsigned int*)(0x42212934UL)))
#define bM4_AOS_PEVNTOSR3_POS14                   (*((volatile unsigned int*)(0x42212938UL)))
#define bM4_AOS_PEVNTOSR3_POS15                   (*((volatile unsigned int*)(0x4221293CUL)))
#define bM4_AOS_PEVNTRISR3_RIS00                  (*((volatile unsigned int*)(0x42212980UL)))
#define bM4_AOS_PEVNTRISR3_RIS01                  (*((volatile unsigned int*)(0x42212984UL)))
#define bM4_AOS_PEVNTRISR3_RIS02                  (*((volatile unsigned int*)(0x42212988UL)))
#define bM4_AOS_PEVNTRISR3_RIS03                  (*((volatile unsigned int*)(0x4221298CUL)))
#define bM4_AOS_PEVNTRISR3_RIS04                  (*((volatile unsigned int*)(0x42212990UL)))
#define bM4_AOS_PEVNTRISR3_RIS05                  (*((volatile unsigned int*)(0x42212994UL)))
#define bM4_AOS_PEVNTRISR3_RIS06                  (*((volatile unsigned int*)(0x42212998UL)))
#define bM4_AOS_PEVNTRISR3_RIS07                  (*((volatile unsigned int*)(0x4221299CUL)))
#define bM4_AOS_PEVNTRISR3_RIS08                  (*((volatile unsigned int*)(0x422129A0UL)))
#define bM4_AOS_PEVNTRISR3_RIS09                  (*((volatile unsigned int*)(0x422129A4UL)))
#define bM4_AOS_PEVNTRISR3_RIS10                  (*((volatile unsigned int*)(0x422129A8UL)))
#define bM4_AOS_PEVNTRISR3_RIS11                  (*((volatile unsigned int*)(0x422129ACUL)))
#define bM4_AOS_PEVNTRISR3_RIS12                  (*((volatile unsigned int*)(0x422129B0UL)))
#define bM4_AOS_PEVNTRISR3_RIS13                  (*((volatile unsigned int*)(0x422129B4UL)))
#define bM4_AOS_PEVNTRISR3_RIS14                  (*((volatile unsigned int*)(0x422129B8UL)))
#define bM4_AOS_PEVNTRISR3_RIS15                  (*((volatile unsigned int*)(0x422129BCUL)))
#define bM4_AOS_PEVNTFAL3_FAL00                   (*((volatile unsigned int*)(0x42212A00UL)))
#define bM4_AOS_PEVNTFAL3_FAL01                   (*((volatile unsigned int*)(0x42212A04UL)))
#define bM4_AOS_PEVNTFAL3_FAL02                   (*((volatile unsigned int*)(0x42212A08UL)))
#define bM4_AOS_PEVNTFAL3_FAL03                   (*((volatile unsigned int*)(0x42212A0CUL)))
#define bM4_AOS_PEVNTFAL3_FAL04                   (*((volatile unsigned int*)(0x42212A10UL)))
#define bM4_AOS_PEVNTFAL3_FAL05                   (*((volatile unsigned int*)(0x42212A14UL)))
#define bM4_AOS_PEVNTFAL3_FAL06                   (*((volatile unsigned int*)(0x42212A18UL)))
#define bM4_AOS_PEVNTFAL3_FAL07                   (*((volatile unsigned int*)(0x42212A1CUL)))
#define bM4_AOS_PEVNTFAL3_FAL08                   (*((volatile unsigned int*)(0x42212A20UL)))
#define bM4_AOS_PEVNTFAL3_FAL09                   (*((volatile unsigned int*)(0x42212A24UL)))
#define bM4_AOS_PEVNTFAL3_FAL10                   (*((volatile unsigned int*)(0x42212A28UL)))
#define bM4_AOS_PEVNTFAL3_FAL11                   (*((volatile unsigned int*)(0x42212A2CUL)))
#define bM4_AOS_PEVNTFAL3_FAL12                   (*((volatile unsigned int*)(0x42212A30UL)))
#define bM4_AOS_PEVNTFAL3_FAL13                   (*((volatile unsigned int*)(0x42212A34UL)))
#define bM4_AOS_PEVNTFAL3_FAL14                   (*((volatile unsigned int*)(0x42212A38UL)))
#define bM4_AOS_PEVNTFAL3_FAL15                   (*((volatile unsigned int*)(0x42212A3CUL)))
#define bM4_AOS_PEVNTDIRR4_PDIR00                 (*((volatile unsigned int*)(0x42212A80UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR01                 (*((volatile unsigned int*)(0x42212A84UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR02                 (*((volatile unsigned int*)(0x42212A88UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR03                 (*((volatile unsigned int*)(0x42212A8CUL)))
#define bM4_AOS_PEVNTDIRR4_PDIR04                 (*((volatile unsigned int*)(0x42212A90UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR05                 (*((volatile unsigned int*)(0x42212A94UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR06                 (*((volatile unsigned int*)(0x42212A98UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR07                 (*((volatile unsigned int*)(0x42212A9CUL)))
#define bM4_AOS_PEVNTDIRR4_PDIR08                 (*((volatile unsigned int*)(0x42212AA0UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR09                 (*((volatile unsigned int*)(0x42212AA4UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR10                 (*((volatile unsigned int*)(0x42212AA8UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR11                 (*((volatile unsigned int*)(0x42212AACUL)))
#define bM4_AOS_PEVNTDIRR4_PDIR12                 (*((volatile unsigned int*)(0x42212AB0UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR13                 (*((volatile unsigned int*)(0x42212AB4UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR14                 (*((volatile unsigned int*)(0x42212AB8UL)))
#define bM4_AOS_PEVNTDIRR4_PDIR15                 (*((volatile unsigned int*)(0x42212ABCUL)))
#define bM4_AOS_PEVNTIDR4_PIN00                   (*((volatile unsigned int*)(0x42212B00UL)))
#define bM4_AOS_PEVNTIDR4_PIN01                   (*((volatile unsigned int*)(0x42212B04UL)))
#define bM4_AOS_PEVNTIDR4_PIN02                   (*((volatile unsigned int*)(0x42212B08UL)))
#define bM4_AOS_PEVNTIDR4_PIN03                   (*((volatile unsigned int*)(0x42212B0CUL)))
#define bM4_AOS_PEVNTIDR4_PIN04                   (*((volatile unsigned int*)(0x42212B10UL)))
#define bM4_AOS_PEVNTIDR4_PIN05                   (*((volatile unsigned int*)(0x42212B14UL)))
#define bM4_AOS_PEVNTIDR4_PIN06                   (*((volatile unsigned int*)(0x42212B18UL)))
#define bM4_AOS_PEVNTIDR4_PIN07                   (*((volatile unsigned int*)(0x42212B1CUL)))
#define bM4_AOS_PEVNTIDR4_PIN08                   (*((volatile unsigned int*)(0x42212B20UL)))
#define bM4_AOS_PEVNTIDR4_PIN09                   (*((volatile unsigned int*)(0x42212B24UL)))
#define bM4_AOS_PEVNTIDR4_PIN10                   (*((volatile unsigned int*)(0x42212B28UL)))
#define bM4_AOS_PEVNTIDR4_PIN11                   (*((volatile unsigned int*)(0x42212B2CUL)))
#define bM4_AOS_PEVNTIDR4_PIN12                   (*((volatile unsigned int*)(0x42212B30UL)))
#define bM4_AOS_PEVNTIDR4_PIN13                   (*((volatile unsigned int*)(0x42212B34UL)))
#define bM4_AOS_PEVNTIDR4_PIN14                   (*((volatile unsigned int*)(0x42212B38UL)))
#define bM4_AOS_PEVNTIDR4_PIN15                   (*((volatile unsigned int*)(0x42212B3CUL)))
#define bM4_AOS_PEVNTODR4_POUT00                  (*((volatile unsigned int*)(0x42212B80UL)))
#define bM4_AOS_PEVNTODR4_POUT01                  (*((volatile unsigned int*)(0x42212B84UL)))
#define bM4_AOS_PEVNTODR4_POUT02                  (*((volatile unsigned int*)(0x42212B88UL)))
#define bM4_AOS_PEVNTODR4_POUT03                  (*((volatile unsigned int*)(0x42212B8CUL)))
#define bM4_AOS_PEVNTODR4_POUT04                  (*((volatile unsigned int*)(0x42212B90UL)))
#define bM4_AOS_PEVNTODR4_POUT05                  (*((volatile unsigned int*)(0x42212B94UL)))
#define bM4_AOS_PEVNTODR4_POUT06                  (*((volatile unsigned int*)(0x42212B98UL)))
#define bM4_AOS_PEVNTODR4_POUT07                  (*((volatile unsigned int*)(0x42212B9CUL)))
#define bM4_AOS_PEVNTODR4_POUT08                  (*((volatile unsigned int*)(0x42212BA0UL)))
#define bM4_AOS_PEVNTODR4_POUT09                  (*((volatile unsigned int*)(0x42212BA4UL)))
#define bM4_AOS_PEVNTODR4_POUT10                  (*((volatile unsigned int*)(0x42212BA8UL)))
#define bM4_AOS_PEVNTODR4_POUT11                  (*((volatile unsigned int*)(0x42212BACUL)))
#define bM4_AOS_PEVNTODR4_POUT12                  (*((volatile unsigned int*)(0x42212BB0UL)))
#define bM4_AOS_PEVNTODR4_POUT13                  (*((volatile unsigned int*)(0x42212BB4UL)))
#define bM4_AOS_PEVNTODR4_POUT14                  (*((volatile unsigned int*)(0x42212BB8UL)))
#define bM4_AOS_PEVNTODR4_POUT15                  (*((volatile unsigned int*)(0x42212BBCUL)))
#define bM4_AOS_PEVNTORR4_POR00                   (*((volatile unsigned int*)(0x42212C00UL)))
#define bM4_AOS_PEVNTORR4_POR01                   (*((volatile unsigned int*)(0x42212C04UL)))
#define bM4_AOS_PEVNTORR4_POR02                   (*((volatile unsigned int*)(0x42212C08UL)))
#define bM4_AOS_PEVNTORR4_POR03                   (*((volatile unsigned int*)(0x42212C0CUL)))
#define bM4_AOS_PEVNTORR4_POR04                   (*((volatile unsigned int*)(0x42212C10UL)))
#define bM4_AOS_PEVNTORR4_POR05                   (*((volatile unsigned int*)(0x42212C14UL)))
#define bM4_AOS_PEVNTORR4_POR06                   (*((volatile unsigned int*)(0x42212C18UL)))
#define bM4_AOS_PEVNTORR4_POR07                   (*((volatile unsigned int*)(0x42212C1CUL)))
#define bM4_AOS_PEVNTORR4_POR08                   (*((volatile unsigned int*)(0x42212C20UL)))
#define bM4_AOS_PEVNTORR4_POR09                   (*((volatile unsigned int*)(0x42212C24UL)))
#define bM4_AOS_PEVNTORR4_POR10                   (*((volatile unsigned int*)(0x42212C28UL)))
#define bM4_AOS_PEVNTORR4_POR11                   (*((volatile unsigned int*)(0x42212C2CUL)))
#define bM4_AOS_PEVNTORR4_POR12                   (*((volatile unsigned int*)(0x42212C30UL)))
#define bM4_AOS_PEVNTORR4_POR13                   (*((volatile unsigned int*)(0x42212C34UL)))
#define bM4_AOS_PEVNTORR4_POR14                   (*((volatile unsigned int*)(0x42212C38UL)))
#define bM4_AOS_PEVNTORR4_POR15                   (*((volatile unsigned int*)(0x42212C3CUL)))
#define bM4_AOS_PEVNTOSR4_POS00                   (*((volatile unsigned int*)(0x42212C80UL)))
#define bM4_AOS_PEVNTOSR4_POS01                   (*((volatile unsigned int*)(0x42212C84UL)))
#define bM4_AOS_PEVNTOSR4_POS02                   (*((volatile unsigned int*)(0x42212C88UL)))
#define bM4_AOS_PEVNTOSR4_POS03                   (*((volatile unsigned int*)(0x42212C8CUL)))
#define bM4_AOS_PEVNTOSR4_POS04                   (*((volatile unsigned int*)(0x42212C90UL)))
#define bM4_AOS_PEVNTOSR4_POS05                   (*((volatile unsigned int*)(0x42212C94UL)))
#define bM4_AOS_PEVNTOSR4_POS06                   (*((volatile unsigned int*)(0x42212C98UL)))
#define bM4_AOS_PEVNTOSR4_POS07                   (*((volatile unsigned int*)(0x42212C9CUL)))
#define bM4_AOS_PEVNTOSR4_POS08                   (*((volatile unsigned int*)(0x42212CA0UL)))
#define bM4_AOS_PEVNTOSR4_POS09                   (*((volatile unsigned int*)(0x42212CA4UL)))
#define bM4_AOS_PEVNTOSR4_POS10                   (*((volatile unsigned int*)(0x42212CA8UL)))
#define bM4_AOS_PEVNTOSR4_POS11                   (*((volatile unsigned int*)(0x42212CACUL)))
#define bM4_AOS_PEVNTOSR4_POS12                   (*((volatile unsigned int*)(0x42212CB0UL)))
#define bM4_AOS_PEVNTOSR4_POS13                   (*((volatile unsigned int*)(0x42212CB4UL)))
#define bM4_AOS_PEVNTOSR4_POS14                   (*((volatile unsigned int*)(0x42212CB8UL)))
#define bM4_AOS_PEVNTOSR4_POS15                   (*((volatile unsigned int*)(0x42212CBCUL)))
#define bM4_AOS_PEVNTRISR4_RIS00                  (*((volatile unsigned int*)(0x42212D00UL)))
#define bM4_AOS_PEVNTRISR4_RIS01                  (*((volatile unsigned int*)(0x42212D04UL)))
#define bM4_AOS_PEVNTRISR4_RIS02                  (*((volatile unsigned int*)(0x42212D08UL)))
#define bM4_AOS_PEVNTRISR4_RIS03                  (*((volatile unsigned int*)(0x42212D0CUL)))
#define bM4_AOS_PEVNTRISR4_RIS04                  (*((volatile unsigned int*)(0x42212D10UL)))
#define bM4_AOS_PEVNTRISR4_RIS05                  (*((volatile unsigned int*)(0x42212D14UL)))
#define bM4_AOS_PEVNTRISR4_RIS06                  (*((volatile unsigned int*)(0x42212D18UL)))
#define bM4_AOS_PEVNTRISR4_RIS07                  (*((volatile unsigned int*)(0x42212D1CUL)))
#define bM4_AOS_PEVNTRISR4_RIS08                  (*((volatile unsigned int*)(0x42212D20UL)))
#define bM4_AOS_PEVNTRISR4_RIS09                  (*((volatile unsigned int*)(0x42212D24UL)))
#define bM4_AOS_PEVNTRISR4_RIS10                  (*((volatile unsigned int*)(0x42212D28UL)))
#define bM4_AOS_PEVNTRISR4_RIS11                  (*((volatile unsigned int*)(0x42212D2CUL)))
#define bM4_AOS_PEVNTRISR4_RIS12                  (*((volatile unsigned int*)(0x42212D30UL)))
#define bM4_AOS_PEVNTRISR4_RIS13                  (*((volatile unsigned int*)(0x42212D34UL)))
#define bM4_AOS_PEVNTRISR4_RIS14                  (*((volatile unsigned int*)(0x42212D38UL)))
#define bM4_AOS_PEVNTRISR4_RIS15                  (*((volatile unsigned int*)(0x42212D3CUL)))
#define bM4_AOS_PEVNTFAL4_FAL00                   (*((volatile unsigned int*)(0x42212D80UL)))
#define bM4_AOS_PEVNTFAL4_FAL01                   (*((volatile unsigned int*)(0x42212D84UL)))
#define bM4_AOS_PEVNTFAL4_FAL02                   (*((volatile unsigned int*)(0x42212D88UL)))
#define bM4_AOS_PEVNTFAL4_FAL03                   (*((volatile unsigned int*)(0x42212D8CUL)))
#define bM4_AOS_PEVNTFAL4_FAL04                   (*((volatile unsigned int*)(0x42212D90UL)))
#define bM4_AOS_PEVNTFAL4_FAL05                   (*((volatile unsigned int*)(0x42212D94UL)))
#define bM4_AOS_PEVNTFAL4_FAL06                   (*((volatile unsigned int*)(0x42212D98UL)))
#define bM4_AOS_PEVNTFAL4_FAL07                   (*((volatile unsigned int*)(0x42212D9CUL)))
#define bM4_AOS_PEVNTFAL4_FAL08                   (*((volatile unsigned int*)(0x42212DA0UL)))
#define bM4_AOS_PEVNTFAL4_FAL09                   (*((volatile unsigned int*)(0x42212DA4UL)))
#define bM4_AOS_PEVNTFAL4_FAL10                   (*((volatile unsigned int*)(0x42212DA8UL)))
#define bM4_AOS_PEVNTFAL4_FAL11                   (*((volatile unsigned int*)(0x42212DACUL)))
#define bM4_AOS_PEVNTFAL4_FAL12                   (*((volatile unsigned int*)(0x42212DB0UL)))
#define bM4_AOS_PEVNTFAL4_FAL13                   (*((volatile unsigned int*)(0x42212DB4UL)))
#define bM4_AOS_PEVNTFAL4_FAL14                   (*((volatile unsigned int*)(0x42212DB8UL)))
#define bM4_AOS_PEVNTFAL4_FAL15                   (*((volatile unsigned int*)(0x42212DBCUL)))
#define bM4_AOS_PEVNTNFCR_NFEN1                   (*((volatile unsigned int*)(0x42212E00UL)))
#define bM4_AOS_PEVNTNFCR_DIVS10                  (*((volatile unsigned int*)(0x42212E04UL)))
#define bM4_AOS_PEVNTNFCR_DIVS11                  (*((volatile unsigned int*)(0x42212E08UL)))
#define bM4_AOS_PEVNTNFCR_NFEN2                   (*((volatile unsigned int*)(0x42212E20UL)))
#define bM4_AOS_PEVNTNFCR_DIVS20                  (*((volatile unsigned int*)(0x42212E24UL)))
#define bM4_AOS_PEVNTNFCR_DIVS21                  (*((volatile unsigned int*)(0x42212E28UL)))
#define bM4_AOS_PEVNTNFCR_NFEN3                   (*((volatile unsigned int*)(0x42212E40UL)))
#define bM4_AOS_PEVNTNFCR_DIVS30                  (*((volatile unsigned int*)(0x42212E44UL)))
#define bM4_AOS_PEVNTNFCR_DIVS31                  (*((volatile unsigned int*)(0x42212E48UL)))
#define bM4_AOS_PEVNTNFCR_NFEN4                   (*((volatile unsigned int*)(0x42212E60UL)))
#define bM4_AOS_PEVNTNFCR_DIVS40                  (*((volatile unsigned int*)(0x42212E64UL)))
#define bM4_AOS_PEVNTNFCR_DIVS41                  (*((volatile unsigned int*)(0x42212E68UL)))
#define bM4_CAN_CFG_STAT_BUSOFF                   (*((volatile unsigned int*)(0x42E09400UL)))
#define bM4_CAN_CFG_STAT_TACTIVE                  (*((volatile unsigned int*)(0x42E09404UL)))
#define bM4_CAN_CFG_STAT_RACTIVE                  (*((volatile unsigned int*)(0x42E09408UL)))
#define bM4_CAN_CFG_STAT_TSSS                     (*((volatile unsigned int*)(0x42E0940CUL)))
#define bM4_CAN_CFG_STAT_TPSS                     (*((volatile unsigned int*)(0x42E09410UL)))
#define bM4_CAN_CFG_STAT_LBMI                     (*((volatile unsigned int*)(0x42E09414UL)))
#define bM4_CAN_CFG_STAT_LBME                     (*((volatile unsigned int*)(0x42E09418UL)))
#define bM4_CAN_CFG_STAT_RESET                    (*((volatile unsigned int*)(0x42E0941CUL)))
#define bM4_CAN_TCMD_TSA                          (*((volatile unsigned int*)(0x42E09420UL)))
#define bM4_CAN_TCMD_TSALL                        (*((volatile unsigned int*)(0x42E09424UL)))
#define bM4_CAN_TCMD_TSONE                        (*((volatile unsigned int*)(0x42E09428UL)))
#define bM4_CAN_TCMD_TPA                          (*((volatile unsigned int*)(0x42E0942CUL)))
#define bM4_CAN_TCMD_TPE                          (*((volatile unsigned int*)(0x42E09430UL)))
#define bM4_CAN_TCMD_LOM                          (*((volatile unsigned int*)(0x42E09438UL)))
#define bM4_CAN_TCMD_TBSEL                        (*((volatile unsigned int*)(0x42E0943CUL)))
#define bM4_CAN_TCTRL_TSSTAT0                     (*((volatile unsigned int*)(0x42E09440UL)))
#define bM4_CAN_TCTRL_TSSTAT1                     (*((volatile unsigned int*)(0x42E09444UL)))
#define bM4_CAN_TCTRL_TTTBM                       (*((volatile unsigned int*)(0x42E09450UL)))
#define bM4_CAN_TCTRL_TSMODE                      (*((volatile unsigned int*)(0x42E09454UL)))
#define bM4_CAN_TCTRL_TSNEXT                      (*((volatile unsigned int*)(0x42E09458UL)))
#define bM4_CAN_RCTRL_RSTAT0                      (*((volatile unsigned int*)(0x42E09460UL)))
#define bM4_CAN_RCTRL_RSTAT1                      (*((volatile unsigned int*)(0x42E09464UL)))
#define bM4_CAN_RCTRL_RBALL                       (*((volatile unsigned int*)(0x42E0946CUL)))
#define bM4_CAN_RCTRL_RREL                        (*((volatile unsigned int*)(0x42E09470UL)))
#define bM4_CAN_RCTRL_ROV                         (*((volatile unsigned int*)(0x42E09474UL)))
#define bM4_CAN_RCTRL_ROM                         (*((volatile unsigned int*)(0x42E09478UL)))
#define bM4_CAN_RCTRL_SACK                        (*((volatile unsigned int*)(0x42E0947CUL)))
#define bM4_CAN_RTIE_TSFF                         (*((volatile unsigned int*)(0x42E09480UL)))
#define bM4_CAN_RTIE_EIE                          (*((volatile unsigned int*)(0x42E09484UL)))
#define bM4_CAN_RTIE_TSIE                         (*((volatile unsigned int*)(0x42E09488UL)))
#define bM4_CAN_RTIE_TPIE                         (*((volatile unsigned int*)(0x42E0948CUL)))
#define bM4_CAN_RTIE_RAFIE                        (*((volatile unsigned int*)(0x42E09490UL)))
#define bM4_CAN_RTIE_RFIE                         (*((volatile unsigned int*)(0x42E09494UL)))
#define bM4_CAN_RTIE_ROIE                         (*((volatile unsigned int*)(0x42E09498UL)))
#define bM4_CAN_RTIE_RIE                          (*((volatile unsigned int*)(0x42E0949CUL)))
#define bM4_CAN_RTIF_AIF                          (*((volatile unsigned int*)(0x42E094A0UL)))
#define bM4_CAN_RTIF_EIF                          (*((volatile unsigned int*)(0x42E094A4UL)))
#define bM4_CAN_RTIF_TSIF                         (*((volatile unsigned int*)(0x42E094A8UL)))
#define bM4_CAN_RTIF_TPIF                         (*((volatile unsigned int*)(0x42E094ACUL)))
#define bM4_CAN_RTIF_RAFIF                        (*((volatile unsigned int*)(0x42E094B0UL)))
#define bM4_CAN_RTIF_RFIF                         (*((volatile unsigned int*)(0x42E094B4UL)))
#define bM4_CAN_RTIF_ROIF                         (*((volatile unsigned int*)(0x42E094B8UL)))
#define bM4_CAN_RTIF_RIF                          (*((volatile unsigned int*)(0x42E094BCUL)))
#define bM4_CAN_ERRINT_BEIF                       (*((volatile unsigned int*)(0x42E094C0UL)))
#define bM4_CAN_ERRINT_BEIE                       (*((volatile unsigned int*)(0x42E094C4UL)))
#define bM4_CAN_ERRINT_ALIF                       (*((volatile unsigned int*)(0x42E094C8UL)))
#define bM4_CAN_ERRINT_ALIE                       (*((volatile unsigned int*)(0x42E094CCUL)))
#define bM4_CAN_ERRINT_EPIF                       (*((volatile unsigned int*)(0x42E094D0UL)))
#define bM4_CAN_ERRINT_EPIE                       (*((volatile unsigned int*)(0x42E094D4UL)))
#define bM4_CAN_ERRINT_EPASS                      (*((volatile unsigned int*)(0x42E094D8UL)))
#define bM4_CAN_ERRINT_EWARN                      (*((volatile unsigned int*)(0x42E094DCUL)))
#define bM4_CAN_LIMIT_EWL0                        (*((volatile unsigned int*)(0x42E094E0UL)))
#define bM4_CAN_LIMIT_EWL1                        (*((volatile unsigned int*)(0x42E094E4UL)))
#define bM4_CAN_LIMIT_EWL2                        (*((volatile unsigned int*)(0x42E094E8UL)))
#define bM4_CAN_LIMIT_EWL3                        (*((volatile unsigned int*)(0x42E094ECUL)))
#define bM4_CAN_LIMIT_AFWL0                       (*((volatile unsigned int*)(0x42E094F0UL)))
#define bM4_CAN_LIMIT_AFWL1                       (*((volatile unsigned int*)(0x42E094F4UL)))
#define bM4_CAN_LIMIT_AFWL2                       (*((volatile unsigned int*)(0x42E094F8UL)))
#define bM4_CAN_LIMIT_AFWL3                       (*((volatile unsigned int*)(0x42E094FCUL)))
#define bM4_CAN_BT_SEG_10                         (*((volatile unsigned int*)(0x42E09500UL)))
#define bM4_CAN_BT_SEG_11                         (*((volatile unsigned int*)(0x42E09504UL)))
#define bM4_CAN_BT_SEG_12                         (*((volatile unsigned int*)(0x42E09508UL)))
#define bM4_CAN_BT_SEG_13                         (*((volatile unsigned int*)(0x42E0950CUL)))
#define bM4_CAN_BT_SEG_14                         (*((volatile unsigned int*)(0x42E09510UL)))
#define bM4_CAN_BT_SEG_15                         (*((volatile unsigned int*)(0x42E09514UL)))
#define bM4_CAN_BT_SEG_16                         (*((volatile unsigned int*)(0x42E09518UL)))
#define bM4_CAN_BT_SEG_17                         (*((volatile unsigned int*)(0x42E0951CUL)))
#define bM4_CAN_BT_SEG_20                         (*((volatile unsigned int*)(0x42E09520UL)))
#define bM4_CAN_BT_SEG_21                         (*((volatile unsigned int*)(0x42E09524UL)))
#define bM4_CAN_BT_SEG_22                         (*((volatile unsigned int*)(0x42E09528UL)))
#define bM4_CAN_BT_SEG_23                         (*((volatile unsigned int*)(0x42E0952CUL)))
#define bM4_CAN_BT_SEG_24                         (*((volatile unsigned int*)(0x42E09530UL)))
#define bM4_CAN_BT_SEG_25                         (*((volatile unsigned int*)(0x42E09534UL)))
#define bM4_CAN_BT_SEG_26                         (*((volatile unsigned int*)(0x42E09538UL)))
#define bM4_CAN_BT_SJW0                           (*((volatile unsigned int*)(0x42E09540UL)))
#define bM4_CAN_BT_SJW1                           (*((volatile unsigned int*)(0x42E09544UL)))
#define bM4_CAN_BT_SJW2                           (*((volatile unsigned int*)(0x42E09548UL)))
#define bM4_CAN_BT_SJW3                           (*((volatile unsigned int*)(0x42E0954CUL)))
#define bM4_CAN_BT_SJW4                           (*((volatile unsigned int*)(0x42E09550UL)))
#define bM4_CAN_BT_SJW5                           (*((volatile unsigned int*)(0x42E09554UL)))
#define bM4_CAN_BT_SJW6                           (*((volatile unsigned int*)(0x42E09558UL)))
#define bM4_CAN_BT_PRESC0                         (*((volatile unsigned int*)(0x42E09560UL)))
#define bM4_CAN_BT_PRESC1                         (*((volatile unsigned int*)(0x42E09564UL)))
#define bM4_CAN_BT_PRESC2                         (*((volatile unsigned int*)(0x42E09568UL)))
#define bM4_CAN_BT_PRESC3                         (*((volatile unsigned int*)(0x42E0956CUL)))
#define bM4_CAN_BT_PRESC4                         (*((volatile unsigned int*)(0x42E09570UL)))
#define bM4_CAN_BT_PRESC5                         (*((volatile unsigned int*)(0x42E09574UL)))
#define bM4_CAN_BT_PRESC6                         (*((volatile unsigned int*)(0x42E09578UL)))
#define bM4_CAN_BT_PRESC7                         (*((volatile unsigned int*)(0x42E0957CUL)))
#define bM4_CAN_EALCAP_ALC0                       (*((volatile unsigned int*)(0x42E09600UL)))
#define bM4_CAN_EALCAP_ALC1                       (*((volatile unsigned int*)(0x42E09604UL)))
#define bM4_CAN_EALCAP_ALC2                       (*((volatile unsigned int*)(0x42E09608UL)))
#define bM4_CAN_EALCAP_ALC3                       (*((volatile unsigned int*)(0x42E0960CUL)))
#define bM4_CAN_EALCAP_ALC4                       (*((volatile unsigned int*)(0x42E09610UL)))
#define bM4_CAN_EALCAP_KOER0                      (*((volatile unsigned int*)(0x42E09614UL)))
#define bM4_CAN_EALCAP_KOER1                      (*((volatile unsigned int*)(0x42E09618UL)))
#define bM4_CAN_EALCAP_KOER2                      (*((volatile unsigned int*)(0x42E0961CUL)))
#define bM4_CAN_ACFCTRL_ACFADR0                   (*((volatile unsigned int*)(0x42E09680UL)))
#define bM4_CAN_ACFCTRL_ACFADR1                   (*((volatile unsigned int*)(0x42E09684UL)))
#define bM4_CAN_ACFCTRL_ACFADR2                   (*((volatile unsigned int*)(0x42E09688UL)))
#define bM4_CAN_ACFCTRL_ACFADR3                   (*((volatile unsigned int*)(0x42E0968CUL)))
#define bM4_CAN_ACFCTRL_SELMASK                   (*((volatile unsigned int*)(0x42E09694UL)))
#define bM4_CAN_ACFEN_AE_1                        (*((volatile unsigned int*)(0x42E096C0UL)))
#define bM4_CAN_ACFEN_AE_2                        (*((volatile unsigned int*)(0x42E096C4UL)))
#define bM4_CAN_ACFEN_AE_3                        (*((volatile unsigned int*)(0x42E096C8UL)))
#define bM4_CAN_ACFEN_AE_4                        (*((volatile unsigned int*)(0x42E096CCUL)))
#define bM4_CAN_ACFEN_AE_5                        (*((volatile unsigned int*)(0x42E096D0UL)))
#define bM4_CAN_ACFEN_AE_6                        (*((volatile unsigned int*)(0x42E096D4UL)))
#define bM4_CAN_ACFEN_AE_7                        (*((volatile unsigned int*)(0x42E096D8UL)))
#define bM4_CAN_ACFEN_AE_8                        (*((volatile unsigned int*)(0x42E096DCUL)))
#define bM4_CAN_ACF_ACODEORAMASK0                 (*((volatile unsigned int*)(0x42E09700UL)))
#define bM4_CAN_ACF_ACODEORAMASK1                 (*((volatile unsigned int*)(0x42E09704UL)))
#define bM4_CAN_ACF_ACODEORAMASK2                 (*((volatile unsigned int*)(0x42E09708UL)))
#define bM4_CAN_ACF_ACODEORAMASK3                 (*((volatile unsigned int*)(0x42E0970CUL)))
#define bM4_CAN_ACF_ACODEORAMASK4                 (*((volatile unsigned int*)(0x42E09710UL)))
#define bM4_CAN_ACF_ACODEORAMASK5                 (*((volatile unsigned int*)(0x42E09714UL)))
#define bM4_CAN_ACF_ACODEORAMASK6                 (*((volatile unsigned int*)(0x42E09718UL)))
#define bM4_CAN_ACF_ACODEORAMASK7                 (*((volatile unsigned int*)(0x42E0971CUL)))
#define bM4_CAN_ACF_ACODEORAMASK8                 (*((volatile unsigned int*)(0x42E09720UL)))
#define bM4_CAN_ACF_ACODEORAMASK9                 (*((volatile unsigned int*)(0x42E09724UL)))
#define bM4_CAN_ACF_ACODEORAMASK10                (*((volatile unsigned int*)(0x42E09728UL)))
#define bM4_CAN_ACF_ACODEORAMASK11                (*((volatile unsigned int*)(0x42E0972CUL)))
#define bM4_CAN_ACF_ACODEORAMASK12                (*((volatile unsigned int*)(0x42E09730UL)))
#define bM4_CAN_ACF_ACODEORAMASK13                (*((volatile unsigned int*)(0x42E09734UL)))
#define bM4_CAN_ACF_ACODEORAMASK14                (*((volatile unsigned int*)(0x42E09738UL)))
#define bM4_CAN_ACF_ACODEORAMASK15                (*((volatile unsigned int*)(0x42E0973CUL)))
#define bM4_CAN_ACF_ACODEORAMASK16                (*((volatile unsigned int*)(0x42E09740UL)))
#define bM4_CAN_ACF_ACODEORAMASK17                (*((volatile unsigned int*)(0x42E09744UL)))
#define bM4_CAN_ACF_ACODEORAMASK18                (*((volatile unsigned int*)(0x42E09748UL)))
#define bM4_CAN_ACF_ACODEORAMASK19                (*((volatile unsigned int*)(0x42E0974CUL)))
#define bM4_CAN_ACF_ACODEORAMASK20                (*((volatile unsigned int*)(0x42E09750UL)))
#define bM4_CAN_ACF_ACODEORAMASK21                (*((volatile unsigned int*)(0x42E09754UL)))
#define bM4_CAN_ACF_ACODEORAMASK22                (*((volatile unsigned int*)(0x42E09758UL)))
#define bM4_CAN_ACF_ACODEORAMASK23                (*((volatile unsigned int*)(0x42E0975CUL)))
#define bM4_CAN_ACF_ACODEORAMASK24                (*((volatile unsigned int*)(0x42E09760UL)))
#define bM4_CAN_ACF_ACODEORAMASK25                (*((volatile unsigned int*)(0x42E09764UL)))
#define bM4_CAN_ACF_ACODEORAMASK26                (*((volatile unsigned int*)(0x42E09768UL)))
#define bM4_CAN_ACF_ACODEORAMASK27                (*((volatile unsigned int*)(0x42E0976CUL)))
#define bM4_CAN_ACF_ACODEORAMASK28                (*((volatile unsigned int*)(0x42E09770UL)))
#define bM4_CAN_ACF_AIDE                          (*((volatile unsigned int*)(0x42E09774UL)))
#define bM4_CAN_ACF_AIDEE                         (*((volatile unsigned int*)(0x42E09778UL)))
#define bM4_CAN_TBSLOT_TBPTR0                     (*((volatile unsigned int*)(0x42E097C0UL)))
#define bM4_CAN_TBSLOT_TBPTR1                     (*((volatile unsigned int*)(0x42E097C4UL)))
#define bM4_CAN_TBSLOT_TBPTR2                     (*((volatile unsigned int*)(0x42E097C8UL)))
#define bM4_CAN_TBSLOT_TBPTR3                     (*((volatile unsigned int*)(0x42E097CCUL)))
#define bM4_CAN_TBSLOT_TBPTR4                     (*((volatile unsigned int*)(0x42E097D0UL)))
#define bM4_CAN_TBSLOT_TBPTR5                     (*((volatile unsigned int*)(0x42E097D4UL)))
#define bM4_CAN_TBSLOT_TBF                        (*((volatile unsigned int*)(0x42E097D8UL)))
#define bM4_CAN_TBSLOT_TBE                        (*((volatile unsigned int*)(0x42E097DCUL)))
#define bM4_CAN_TTCFG_TTEN                        (*((volatile unsigned int*)(0x42E097E0UL)))
#define bM4_CAN_TTCFG_T_PRESC0                    (*((volatile unsigned int*)(0x42E097E4UL)))
#define bM4_CAN_TTCFG_T_PRESC1                    (*((volatile unsigned int*)(0x42E097E8UL)))
#define bM4_CAN_TTCFG_TTIF                        (*((volatile unsigned int*)(0x42E097ECUL)))
#define bM4_CAN_TTCFG_TTIE                        (*((volatile unsigned int*)(0x42E097F0UL)))
#define bM4_CAN_TTCFG_TEIF                        (*((volatile unsigned int*)(0x42E097F4UL)))
#define bM4_CAN_TTCFG_WTIF                        (*((volatile unsigned int*)(0x42E097F8UL)))
#define bM4_CAN_TTCFG_WTIE                        (*((volatile unsigned int*)(0x42E097FCUL)))
#define bM4_CAN_REF_MSG_REF_ID0                   (*((volatile unsigned int*)(0x42E09800UL)))
#define bM4_CAN_REF_MSG_REF_ID1                   (*((volatile unsigned int*)(0x42E09804UL)))
#define bM4_CAN_REF_MSG_REF_ID2                   (*((volatile unsigned int*)(0x42E09808UL)))
#define bM4_CAN_REF_MSG_REF_ID3                   (*((volatile unsigned int*)(0x42E0980CUL)))
#define bM4_CAN_REF_MSG_REF_ID4                   (*((volatile unsigned int*)(0x42E09810UL)))
#define bM4_CAN_REF_MSG_REF_ID5                   (*((volatile unsigned int*)(0x42E09814UL)))
#define bM4_CAN_REF_MSG_REF_ID6                   (*((volatile unsigned int*)(0x42E09818UL)))
#define bM4_CAN_REF_MSG_REF_ID7                   (*((volatile unsigned int*)(0x42E0981CUL)))
#define bM4_CAN_REF_MSG_REF_ID8                   (*((volatile unsigned int*)(0x42E09820UL)))
#define bM4_CAN_REF_MSG_REF_ID9                   (*((volatile unsigned int*)(0x42E09824UL)))
#define bM4_CAN_REF_MSG_REF_ID10                  (*((volatile unsigned int*)(0x42E09828UL)))
#define bM4_CAN_REF_MSG_REF_ID11                  (*((volatile unsigned int*)(0x42E0982CUL)))
#define bM4_CAN_REF_MSG_REF_ID12                  (*((volatile unsigned int*)(0x42E09830UL)))
#define bM4_CAN_REF_MSG_REF_ID13                  (*((volatile unsigned int*)(0x42E09834UL)))
#define bM4_CAN_REF_MSG_REF_ID14                  (*((volatile unsigned int*)(0x42E09838UL)))
#define bM4_CAN_REF_MSG_REF_ID15                  (*((volatile unsigned int*)(0x42E0983CUL)))
#define bM4_CAN_REF_MSG_REF_ID16                  (*((volatile unsigned int*)(0x42E09840UL)))
#define bM4_CAN_REF_MSG_REF_ID17                  (*((volatile unsigned int*)(0x42E09844UL)))
#define bM4_CAN_REF_MSG_REF_ID18                  (*((volatile unsigned int*)(0x42E09848UL)))
#define bM4_CAN_REF_MSG_REF_ID19                  (*((volatile unsigned int*)(0x42E0984CUL)))
#define bM4_CAN_REF_MSG_REF_ID20                  (*((volatile unsigned int*)(0x42E09850UL)))
#define bM4_CAN_REF_MSG_REF_ID21                  (*((volatile unsigned int*)(0x42E09854UL)))
#define bM4_CAN_REF_MSG_REF_ID22                  (*((volatile unsigned int*)(0x42E09858UL)))
#define bM4_CAN_REF_MSG_REF_ID23                  (*((volatile unsigned int*)(0x42E0985CUL)))
#define bM4_CAN_REF_MSG_REF_ID24                  (*((volatile unsigned int*)(0x42E09860UL)))
#define bM4_CAN_REF_MSG_REF_ID25                  (*((volatile unsigned int*)(0x42E09864UL)))
#define bM4_CAN_REF_MSG_REF_ID26                  (*((volatile unsigned int*)(0x42E09868UL)))
#define bM4_CAN_REF_MSG_REF_ID27                  (*((volatile unsigned int*)(0x42E0986CUL)))
#define bM4_CAN_REF_MSG_REF_ID28                  (*((volatile unsigned int*)(0x42E09870UL)))
#define bM4_CAN_REF_MSG_REF_IDE                   (*((volatile unsigned int*)(0x42E0987CUL)))
#define bM4_CAN_TRG_CFG_TTPTR0                    (*((volatile unsigned int*)(0x42E09880UL)))
#define bM4_CAN_TRG_CFG_TTPTR1                    (*((volatile unsigned int*)(0x42E09884UL)))
#define bM4_CAN_TRG_CFG_TTPTR2                    (*((volatile unsigned int*)(0x42E09888UL)))
#define bM4_CAN_TRG_CFG_TTPTR3                    (*((volatile unsigned int*)(0x42E0988CUL)))
#define bM4_CAN_TRG_CFG_TTPTR4                    (*((volatile unsigned int*)(0x42E09890UL)))
#define bM4_CAN_TRG_CFG_TTPTR5                    (*((volatile unsigned int*)(0x42E09894UL)))
#define bM4_CAN_TRG_CFG_TTYPE0                    (*((volatile unsigned int*)(0x42E098A0UL)))
#define bM4_CAN_TRG_CFG_TTYPE1                    (*((volatile unsigned int*)(0x42E098A4UL)))
#define bM4_CAN_TRG_CFG_TTYPE2                    (*((volatile unsigned int*)(0x42E098A8UL)))
#define bM4_CAN_TRG_CFG_TEW0                      (*((volatile unsigned int*)(0x42E098B0UL)))
#define bM4_CAN_TRG_CFG_TEW1                      (*((volatile unsigned int*)(0x42E098B4UL)))
#define bM4_CAN_TRG_CFG_TEW2                      (*((volatile unsigned int*)(0x42E098B8UL)))
#define bM4_CAN_TRG_CFG_TEW3                      (*((volatile unsigned int*)(0x42E098BCUL)))
#define bM4_CMP1_CTRL_FLTSL0                      (*((volatile unsigned int*)(0x42940000UL)))
#define bM4_CMP1_CTRL_FLTSL1                      (*((volatile unsigned int*)(0x42940004UL)))
#define bM4_CMP1_CTRL_FLTSL2                      (*((volatile unsigned int*)(0x42940008UL)))
#define bM4_CMP1_CTRL_EDGSL0                      (*((volatile unsigned int*)(0x42940014UL)))
#define bM4_CMP1_CTRL_EDGSL1                      (*((volatile unsigned int*)(0x42940018UL)))
#define bM4_CMP1_CTRL_IEN                         (*((volatile unsigned int*)(0x4294001CUL)))
#define bM4_CMP1_CTRL_CVSEN                       (*((volatile unsigned int*)(0x42940020UL)))
#define bM4_CMP1_CTRL_OUTEN                       (*((volatile unsigned int*)(0x42940030UL)))
#define bM4_CMP1_CTRL_INV                         (*((volatile unsigned int*)(0x42940034UL)))
#define bM4_CMP1_CTRL_CMPOE                       (*((volatile unsigned int*)(0x42940038UL)))
#define bM4_CMP1_CTRL_CMPON                       (*((volatile unsigned int*)(0x4294003CUL)))
#define bM4_CMP1_VLTSEL_RVSL0                     (*((volatile unsigned int*)(0x42940040UL)))
#define bM4_CMP1_VLTSEL_RVSL1                     (*((volatile unsigned int*)(0x42940044UL)))
#define bM4_CMP1_VLTSEL_RVSL2                     (*((volatile unsigned int*)(0x42940048UL)))
#define bM4_CMP1_VLTSEL_RVSL3                     (*((volatile unsigned int*)(0x4294004CUL)))
#define bM4_CMP1_VLTSEL_CVSL0                     (*((volatile unsigned int*)(0x42940060UL)))
#define bM4_CMP1_VLTSEL_CVSL1                     (*((volatile unsigned int*)(0x42940064UL)))
#define bM4_CMP1_VLTSEL_CVSL2                     (*((volatile unsigned int*)(0x42940068UL)))
#define bM4_CMP1_VLTSEL_CVSL3                     (*((volatile unsigned int*)(0x4294006CUL)))
#define bM4_CMP1_VLTSEL_C4SL0                     (*((volatile unsigned int*)(0x42940070UL)))
#define bM4_CMP1_VLTSEL_C4SL1                     (*((volatile unsigned int*)(0x42940074UL)))
#define bM4_CMP1_VLTSEL_C4SL2                     (*((volatile unsigned int*)(0x42940078UL)))
#define bM4_CMP1_OUTMON_OMON                      (*((volatile unsigned int*)(0x42940080UL)))
#define bM4_CMP1_OUTMON_CVST0                     (*((volatile unsigned int*)(0x429400A0UL)))
#define bM4_CMP1_OUTMON_CVST1                     (*((volatile unsigned int*)(0x429400A4UL)))
#define bM4_CMP1_OUTMON_CVST2                     (*((volatile unsigned int*)(0x429400A8UL)))
#define bM4_CMP1_OUTMON_CVST3                     (*((volatile unsigned int*)(0x429400ACUL)))
#define bM4_CMP1_CVSSTB_STB0                      (*((volatile unsigned int*)(0x429400C0UL)))
#define bM4_CMP1_CVSSTB_STB1                      (*((volatile unsigned int*)(0x429400C4UL)))
#define bM4_CMP1_CVSSTB_STB2                      (*((volatile unsigned int*)(0x429400C8UL)))
#define bM4_CMP1_CVSSTB_STB3                      (*((volatile unsigned int*)(0x429400CCUL)))
#define bM4_CMP1_CVSPRD_PRD0                      (*((volatile unsigned int*)(0x42940100UL)))
#define bM4_CMP1_CVSPRD_PRD1                      (*((volatile unsigned int*)(0x42940104UL)))
#define bM4_CMP1_CVSPRD_PRD2                      (*((volatile unsigned int*)(0x42940108UL)))
#define bM4_CMP1_CVSPRD_PRD3                      (*((volatile unsigned int*)(0x4294010CUL)))
#define bM4_CMP1_CVSPRD_PRD4                      (*((volatile unsigned int*)(0x42940110UL)))
#define bM4_CMP1_CVSPRD_PRD5                      (*((volatile unsigned int*)(0x42940114UL)))
#define bM4_CMP1_CVSPRD_PRD6                      (*((volatile unsigned int*)(0x42940118UL)))
#define bM4_CMP1_CVSPRD_PRD7                      (*((volatile unsigned int*)(0x4294011CUL)))
#define bM4_CMP2_CTRL_FLTSL0                      (*((volatile unsigned int*)(0x42940200UL)))
#define bM4_CMP2_CTRL_FLTSL1                      (*((volatile unsigned int*)(0x42940204UL)))
#define bM4_CMP2_CTRL_FLTSL2                      (*((volatile unsigned int*)(0x42940208UL)))
#define bM4_CMP2_CTRL_EDGSL0                      (*((volatile unsigned int*)(0x42940214UL)))
#define bM4_CMP2_CTRL_EDGSL1                      (*((volatile unsigned int*)(0x42940218UL)))
#define bM4_CMP2_CTRL_IEN                         (*((volatile unsigned int*)(0x4294021CUL)))
#define bM4_CMP2_CTRL_CVSEN                       (*((volatile unsigned int*)(0x42940220UL)))
#define bM4_CMP2_CTRL_OUTEN                       (*((volatile unsigned int*)(0x42940230UL)))
#define bM4_CMP2_CTRL_INV                         (*((volatile unsigned int*)(0x42940234UL)))
#define bM4_CMP2_CTRL_CMPOE                       (*((volatile unsigned int*)(0x42940238UL)))
#define bM4_CMP2_CTRL_CMPON                       (*((volatile unsigned int*)(0x4294023CUL)))
#define bM4_CMP2_VLTSEL_RVSL0                     (*((volatile unsigned int*)(0x42940240UL)))
#define bM4_CMP2_VLTSEL_RVSL1                     (*((volatile unsigned int*)(0x42940244UL)))
#define bM4_CMP2_VLTSEL_RVSL2                     (*((volatile unsigned int*)(0x42940248UL)))
#define bM4_CMP2_VLTSEL_RVSL3                     (*((volatile unsigned int*)(0x4294024CUL)))
#define bM4_CMP2_VLTSEL_CVSL0                     (*((volatile unsigned int*)(0x42940260UL)))
#define bM4_CMP2_VLTSEL_CVSL1                     (*((volatile unsigned int*)(0x42940264UL)))
#define bM4_CMP2_VLTSEL_CVSL2                     (*((volatile unsigned int*)(0x42940268UL)))
#define bM4_CMP2_VLTSEL_CVSL3                     (*((volatile unsigned int*)(0x4294026CUL)))
#define bM4_CMP2_VLTSEL_C4SL0                     (*((volatile unsigned int*)(0x42940270UL)))
#define bM4_CMP2_VLTSEL_C4SL1                     (*((volatile unsigned int*)(0x42940274UL)))
#define bM4_CMP2_VLTSEL_C4SL2                     (*((volatile unsigned int*)(0x42940278UL)))
#define bM4_CMP2_OUTMON_OMON                      (*((volatile unsigned int*)(0x42940280UL)))
#define bM4_CMP2_OUTMON_CVST0                     (*((volatile unsigned int*)(0x429402A0UL)))
#define bM4_CMP2_OUTMON_CVST1                     (*((volatile unsigned int*)(0x429402A4UL)))
#define bM4_CMP2_OUTMON_CVST2                     (*((volatile unsigned int*)(0x429402A8UL)))
#define bM4_CMP2_OUTMON_CVST3                     (*((volatile unsigned int*)(0x429402ACUL)))
#define bM4_CMP2_CVSSTB_STB0                      (*((volatile unsigned int*)(0x429402C0UL)))
#define bM4_CMP2_CVSSTB_STB1                      (*((volatile unsigned int*)(0x429402C4UL)))
#define bM4_CMP2_CVSSTB_STB2                      (*((volatile unsigned int*)(0x429402C8UL)))
#define bM4_CMP2_CVSSTB_STB3                      (*((volatile unsigned int*)(0x429402CCUL)))
#define bM4_CMP2_CVSPRD_PRD0                      (*((volatile unsigned int*)(0x42940300UL)))
#define bM4_CMP2_CVSPRD_PRD1                      (*((volatile unsigned int*)(0x42940304UL)))
#define bM4_CMP2_CVSPRD_PRD2                      (*((volatile unsigned int*)(0x42940308UL)))
#define bM4_CMP2_CVSPRD_PRD3                      (*((volatile unsigned int*)(0x4294030CUL)))
#define bM4_CMP2_CVSPRD_PRD4                      (*((volatile unsigned int*)(0x42940310UL)))
#define bM4_CMP2_CVSPRD_PRD5                      (*((volatile unsigned int*)(0x42940314UL)))
#define bM4_CMP2_CVSPRD_PRD6                      (*((volatile unsigned int*)(0x42940318UL)))
#define bM4_CMP2_CVSPRD_PRD7                      (*((volatile unsigned int*)(0x4294031CUL)))
#define bM4_CMP3_CTRL_FLTSL0                      (*((volatile unsigned int*)(0x42940400UL)))
#define bM4_CMP3_CTRL_FLTSL1                      (*((volatile unsigned int*)(0x42940404UL)))
#define bM4_CMP3_CTRL_FLTSL2                      (*((volatile unsigned int*)(0x42940408UL)))
#define bM4_CMP3_CTRL_EDGSL0                      (*((volatile unsigned int*)(0x42940414UL)))
#define bM4_CMP3_CTRL_EDGSL1                      (*((volatile unsigned int*)(0x42940418UL)))
#define bM4_CMP3_CTRL_IEN                         (*((volatile unsigned int*)(0x4294041CUL)))
#define bM4_CMP3_CTRL_CVSEN                       (*((volatile unsigned int*)(0x42940420UL)))
#define bM4_CMP3_CTRL_OUTEN                       (*((volatile unsigned int*)(0x42940430UL)))
#define bM4_CMP3_CTRL_INV                         (*((volatile unsigned int*)(0x42940434UL)))
#define bM4_CMP3_CTRL_CMPOE                       (*((volatile unsigned int*)(0x42940438UL)))
#define bM4_CMP3_CTRL_CMPON                       (*((volatile unsigned int*)(0x4294043CUL)))
#define bM4_CMP3_VLTSEL_RVSL0                     (*((volatile unsigned int*)(0x42940440UL)))
#define bM4_CMP3_VLTSEL_RVSL1                     (*((volatile unsigned int*)(0x42940444UL)))
#define bM4_CMP3_VLTSEL_RVSL2                     (*((volatile unsigned int*)(0x42940448UL)))
#define bM4_CMP3_VLTSEL_RVSL3                     (*((volatile unsigned int*)(0x4294044CUL)))
#define bM4_CMP3_VLTSEL_CVSL0                     (*((volatile unsigned int*)(0x42940460UL)))
#define bM4_CMP3_VLTSEL_CVSL1                     (*((volatile unsigned int*)(0x42940464UL)))
#define bM4_CMP3_VLTSEL_CVSL2                     (*((volatile unsigned int*)(0x42940468UL)))
#define bM4_CMP3_VLTSEL_CVSL3                     (*((volatile unsigned int*)(0x4294046CUL)))
#define bM4_CMP3_VLTSEL_C4SL0                     (*((volatile unsigned int*)(0x42940470UL)))
#define bM4_CMP3_VLTSEL_C4SL1                     (*((volatile unsigned int*)(0x42940474UL)))
#define bM4_CMP3_VLTSEL_C4SL2                     (*((volatile unsigned int*)(0x42940478UL)))
#define bM4_CMP3_OUTMON_OMON                      (*((volatile unsigned int*)(0x42940480UL)))
#define bM4_CMP3_OUTMON_CVST0                     (*((volatile unsigned int*)(0x429404A0UL)))
#define bM4_CMP3_OUTMON_CVST1                     (*((volatile unsigned int*)(0x429404A4UL)))
#define bM4_CMP3_OUTMON_CVST2                     (*((volatile unsigned int*)(0x429404A8UL)))
#define bM4_CMP3_OUTMON_CVST3                     (*((volatile unsigned int*)(0x429404ACUL)))
#define bM4_CMP3_CVSSTB_STB0                      (*((volatile unsigned int*)(0x429404C0UL)))
#define bM4_CMP3_CVSSTB_STB1                      (*((volatile unsigned int*)(0x429404C4UL)))
#define bM4_CMP3_CVSSTB_STB2                      (*((volatile unsigned int*)(0x429404C8UL)))
#define bM4_CMP3_CVSSTB_STB3                      (*((volatile unsigned int*)(0x429404CCUL)))
#define bM4_CMP3_CVSPRD_PRD0                      (*((volatile unsigned int*)(0x42940500UL)))
#define bM4_CMP3_CVSPRD_PRD1                      (*((volatile unsigned int*)(0x42940504UL)))
#define bM4_CMP3_CVSPRD_PRD2                      (*((volatile unsigned int*)(0x42940508UL)))
#define bM4_CMP3_CVSPRD_PRD3                      (*((volatile unsigned int*)(0x4294050CUL)))
#define bM4_CMP3_CVSPRD_PRD4                      (*((volatile unsigned int*)(0x42940510UL)))
#define bM4_CMP3_CVSPRD_PRD5                      (*((volatile unsigned int*)(0x42940514UL)))
#define bM4_CMP3_CVSPRD_PRD6                      (*((volatile unsigned int*)(0x42940518UL)))
#define bM4_CMP3_CVSPRD_PRD7                      (*((volatile unsigned int*)(0x4294051CUL)))
#define bM4_CMP_CR_DADR1_DATA0                    (*((volatile unsigned int*)(0x42942000UL)))
#define bM4_CMP_CR_DADR1_DATA1                    (*((volatile unsigned int*)(0x42942004UL)))
#define bM4_CMP_CR_DADR1_DATA2                    (*((volatile unsigned int*)(0x42942008UL)))
#define bM4_CMP_CR_DADR1_DATA3                    (*((volatile unsigned int*)(0x4294200CUL)))
#define bM4_CMP_CR_DADR1_DATA4                    (*((volatile unsigned int*)(0x42942010UL)))
#define bM4_CMP_CR_DADR1_DATA5                    (*((volatile unsigned int*)(0x42942014UL)))
#define bM4_CMP_CR_DADR1_DATA6                    (*((volatile unsigned int*)(0x42942018UL)))
#define bM4_CMP_CR_DADR1_DATA7                    (*((volatile unsigned int*)(0x4294201CUL)))
#define bM4_CMP_CR_DADR2_DATA0                    (*((volatile unsigned int*)(0x42942040UL)))
#define bM4_CMP_CR_DADR2_DATA1                    (*((volatile unsigned int*)(0x42942044UL)))
#define bM4_CMP_CR_DADR2_DATA2                    (*((volatile unsigned int*)(0x42942048UL)))
#define bM4_CMP_CR_DADR2_DATA3                    (*((volatile unsigned int*)(0x4294204CUL)))
#define bM4_CMP_CR_DADR2_DATA4                    (*((volatile unsigned int*)(0x42942050UL)))
#define bM4_CMP_CR_DADR2_DATA5                    (*((volatile unsigned int*)(0x42942054UL)))
#define bM4_CMP_CR_DADR2_DATA6                    (*((volatile unsigned int*)(0x42942058UL)))
#define bM4_CMP_CR_DADR2_DATA7                    (*((volatile unsigned int*)(0x4294205CUL)))
#define bM4_CMP_CR_DACR_DA1EN                     (*((volatile unsigned int*)(0x42942100UL)))
#define bM4_CMP_CR_DACR_DA2EN                     (*((volatile unsigned int*)(0x42942104UL)))
#define bM4_CMP_CR_RVADC_DA1SW                    (*((volatile unsigned int*)(0x42942180UL)))
#define bM4_CMP_CR_RVADC_DA2SW                    (*((volatile unsigned int*)(0x42942184UL)))
#define bM4_CMP_CR_RVADC_VREFSW                   (*((volatile unsigned int*)(0x42942190UL)))
#define bM4_CMP_CR_RVADC_WPRT0                    (*((volatile unsigned int*)(0x429421A0UL)))
#define bM4_CMP_CR_RVADC_WPRT1                    (*((volatile unsigned int*)(0x429421A4UL)))
#define bM4_CMP_CR_RVADC_WPRT2                    (*((volatile unsigned int*)(0x429421A8UL)))
#define bM4_CMP_CR_RVADC_WPRT3                    (*((volatile unsigned int*)(0x429421ACUL)))
#define bM4_CMP_CR_RVADC_WPRT4                    (*((volatile unsigned int*)(0x429421B0UL)))
#define bM4_CMP_CR_RVADC_WPRT5                    (*((volatile unsigned int*)(0x429421B4UL)))
#define bM4_CMP_CR_RVADC_WPRT6                    (*((volatile unsigned int*)(0x429421B8UL)))
#define bM4_CMP_CR_RVADC_WPRT7                    (*((volatile unsigned int*)(0x429421BCUL)))
#define bM4_CRC_CR_CRC_SEL                        (*((volatile unsigned int*)(0x42118004UL)))
#define bM4_CRC_CR_REFIN                          (*((volatile unsigned int*)(0x42118008UL)))
#define bM4_CRC_CR_REFOUT                         (*((volatile unsigned int*)(0x4211800CUL)))
#define bM4_CRC_CR_XOROUT                         (*((volatile unsigned int*)(0x42118010UL)))
#define bM4_CRC_RESLT_CRC_REG0                    (*((volatile unsigned int*)(0x42118080UL)))
#define bM4_CRC_RESLT_CRC_REG1                    (*((volatile unsigned int*)(0x42118084UL)))
#define bM4_CRC_RESLT_CRC_REG2                    (*((volatile unsigned int*)(0x42118088UL)))
#define bM4_CRC_RESLT_CRC_REG3                    (*((volatile unsigned int*)(0x4211808CUL)))
#define bM4_CRC_RESLT_CRC_REG4                    (*((volatile unsigned int*)(0x42118090UL)))
#define bM4_CRC_RESLT_CRC_REG5                    (*((volatile unsigned int*)(0x42118094UL)))
#define bM4_CRC_RESLT_CRC_REG6                    (*((volatile unsigned int*)(0x42118098UL)))
#define bM4_CRC_RESLT_CRC_REG7                    (*((volatile unsigned int*)(0x4211809CUL)))
#define bM4_CRC_RESLT_CRC_REG8                    (*((volatile unsigned int*)(0x421180A0UL)))
#define bM4_CRC_RESLT_CRC_REG9                    (*((volatile unsigned int*)(0x421180A4UL)))
#define bM4_CRC_RESLT_CRC_REG10                   (*((volatile unsigned int*)(0x421180A8UL)))
#define bM4_CRC_RESLT_CRC_REG11                   (*((volatile unsigned int*)(0x421180ACUL)))
#define bM4_CRC_RESLT_CRC_REG12                   (*((volatile unsigned int*)(0x421180B0UL)))
#define bM4_CRC_RESLT_CRC_REG13                   (*((volatile unsigned int*)(0x421180B4UL)))
#define bM4_CRC_RESLT_CRC_REG14                   (*((volatile unsigned int*)(0x421180B8UL)))
#define bM4_CRC_RESLT_CRC_REG15                   (*((volatile unsigned int*)(0x421180BCUL)))
#define bM4_CRC_RESLT_CRCFLAG_16                  (*((volatile unsigned int*)(0x421180C0UL)))
#define bM4_CRC_FLG_FLAG                          (*((volatile unsigned int*)(0x42118180UL)))
#define bM4_DCU1_CTL_MODE0                        (*((volatile unsigned int*)(0x42A40000UL)))
#define bM4_DCU1_CTL_MODE1                        (*((volatile unsigned int*)(0x42A40004UL)))
#define bM4_DCU1_CTL_MODE2                        (*((volatile unsigned int*)(0x42A40008UL)))
#define bM4_DCU1_CTL_DATASIZE0                    (*((volatile unsigned int*)(0x42A4000CUL)))
#define bM4_DCU1_CTL_DATASIZE1                    (*((volatile unsigned int*)(0x42A40010UL)))
#define bM4_DCU1_CTL_COMP_TRG                     (*((volatile unsigned int*)(0x42A40020UL)))
#define bM4_DCU1_CTL_INTEN                        (*((volatile unsigned int*)(0x42A4007CUL)))
#define bM4_DCU1_FLAG_FLAG_OP                     (*((volatile unsigned int*)(0x42A40080UL)))
#define bM4_DCU1_FLAG_FLAG_LS2                    (*((volatile unsigned int*)(0x42A40084UL)))
#define bM4_DCU1_FLAG_FLAG_EQ2                    (*((volatile unsigned int*)(0x42A40088UL)))
#define bM4_DCU1_FLAG_FLAG_GT2                    (*((volatile unsigned int*)(0x42A4008CUL)))
#define bM4_DCU1_FLAG_FLAG_LS1                    (*((volatile unsigned int*)(0x42A40090UL)))
#define bM4_DCU1_FLAG_FLAG_EQ1                    (*((volatile unsigned int*)(0x42A40094UL)))
#define bM4_DCU1_FLAG_FLAG_GT1                    (*((volatile unsigned int*)(0x42A40098UL)))
#define bM4_DCU1_FLAGCLR_CLR_OP                   (*((volatile unsigned int*)(0x42A40280UL)))
#define bM4_DCU1_FLAGCLR_CLR_LS2                  (*((volatile unsigned int*)(0x42A40284UL)))
#define bM4_DCU1_FLAGCLR_CLR_EQ2                  (*((volatile unsigned int*)(0x42A40288UL)))
#define bM4_DCU1_FLAGCLR_CLR_GT2                  (*((volatile unsigned int*)(0x42A4028CUL)))
#define bM4_DCU1_FLAGCLR_CLR_LS1                  (*((volatile unsigned int*)(0x42A40290UL)))
#define bM4_DCU1_FLAGCLR_CLR_EQ1                  (*((volatile unsigned int*)(0x42A40294UL)))
#define bM4_DCU1_FLAGCLR_CLR_GT1                  (*((volatile unsigned int*)(0x42A40298UL)))
#define bM4_DCU1_INTSEL_INT_OP                    (*((volatile unsigned int*)(0x42A40300UL)))
#define bM4_DCU1_INTSEL_INT_LS2                   (*((volatile unsigned int*)(0x42A40304UL)))
#define bM4_DCU1_INTSEL_INT_EQ2                   (*((volatile unsigned int*)(0x42A40308UL)))
#define bM4_DCU1_INTSEL_INT_GT2                   (*((volatile unsigned int*)(0x42A4030CUL)))
#define bM4_DCU1_INTSEL_INT_LS1                   (*((volatile unsigned int*)(0x42A40310UL)))
#define bM4_DCU1_INTSEL_INT_EQ1                   (*((volatile unsigned int*)(0x42A40314UL)))
#define bM4_DCU1_INTSEL_INT_GT1                   (*((volatile unsigned int*)(0x42A40318UL)))
#define bM4_DCU1_INTSEL_INT_WIN0                  (*((volatile unsigned int*)(0x42A4031CUL)))
#define bM4_DCU1_INTSEL_INT_WIN1                  (*((volatile unsigned int*)(0x42A40320UL)))
#define bM4_DCU2_CTL_MODE0                        (*((volatile unsigned int*)(0x42A48000UL)))
#define bM4_DCU2_CTL_MODE1                        (*((volatile unsigned int*)(0x42A48004UL)))
#define bM4_DCU2_CTL_MODE2                        (*((volatile unsigned int*)(0x42A48008UL)))
#define bM4_DCU2_CTL_DATASIZE0                    (*((volatile unsigned int*)(0x42A4800CUL)))
#define bM4_DCU2_CTL_DATASIZE1                    (*((volatile unsigned int*)(0x42A48010UL)))
#define bM4_DCU2_CTL_COMP_TRG                     (*((volatile unsigned int*)(0x42A48020UL)))
#define bM4_DCU2_CTL_INTEN                        (*((volatile unsigned int*)(0x42A4807CUL)))
#define bM4_DCU2_FLAG_FLAG_OP                     (*((volatile unsigned int*)(0x42A48080UL)))
#define bM4_DCU2_FLAG_FLAG_LS2                    (*((volatile unsigned int*)(0x42A48084UL)))
#define bM4_DCU2_FLAG_FLAG_EQ2                    (*((volatile unsigned int*)(0x42A48088UL)))
#define bM4_DCU2_FLAG_FLAG_GT2                    (*((volatile unsigned int*)(0x42A4808CUL)))
#define bM4_DCU2_FLAG_FLAG_LS1                    (*((volatile unsigned int*)(0x42A48090UL)))
#define bM4_DCU2_FLAG_FLAG_EQ1                    (*((volatile unsigned int*)(0x42A48094UL)))
#define bM4_DCU2_FLAG_FLAG_GT1                    (*((volatile unsigned int*)(0x42A48098UL)))
#define bM4_DCU2_FLAGCLR_CLR_OP                   (*((volatile unsigned int*)(0x42A48280UL)))
#define bM4_DCU2_FLAGCLR_CLR_LS2                  (*((volatile unsigned int*)(0x42A48284UL)))
#define bM4_DCU2_FLAGCLR_CLR_EQ2                  (*((volatile unsigned int*)(0x42A48288UL)))
#define bM4_DCU2_FLAGCLR_CLR_GT2                  (*((volatile unsigned int*)(0x42A4828CUL)))
#define bM4_DCU2_FLAGCLR_CLR_LS1                  (*((volatile unsigned int*)(0x42A48290UL)))
#define bM4_DCU2_FLAGCLR_CLR_EQ1                  (*((volatile unsigned int*)(0x42A48294UL)))
#define bM4_DCU2_FLAGCLR_CLR_GT1                  (*((volatile unsigned int*)(0x42A48298UL)))
#define bM4_DCU2_INTSEL_INT_OP                    (*((volatile unsigned int*)(0x42A48300UL)))
#define bM4_DCU2_INTSEL_INT_LS2                   (*((volatile unsigned int*)(0x42A48304UL)))
#define bM4_DCU2_INTSEL_INT_EQ2                   (*((volatile unsigned int*)(0x42A48308UL)))
#define bM4_DCU2_INTSEL_INT_GT2                   (*((volatile unsigned int*)(0x42A4830CUL)))
#define bM4_DCU2_INTSEL_INT_LS1                   (*((volatile unsigned int*)(0x42A48310UL)))
#define bM4_DCU2_INTSEL_INT_EQ1                   (*((volatile unsigned int*)(0x42A48314UL)))
#define bM4_DCU2_INTSEL_INT_GT1                   (*((volatile unsigned int*)(0x42A48318UL)))
#define bM4_DCU2_INTSEL_INT_WIN0                  (*((volatile unsigned int*)(0x42A4831CUL)))
#define bM4_DCU2_INTSEL_INT_WIN1                  (*((volatile unsigned int*)(0x42A48320UL)))
#define bM4_DCU3_CTL_MODE0                        (*((volatile unsigned int*)(0x42A50000UL)))
#define bM4_DCU3_CTL_MODE1                        (*((volatile unsigned int*)(0x42A50004UL)))
#define bM4_DCU3_CTL_MODE2                        (*((volatile unsigned int*)(0x42A50008UL)))
#define bM4_DCU3_CTL_DATASIZE0                    (*((volatile unsigned int*)(0x42A5000CUL)))
#define bM4_DCU3_CTL_DATASIZE1                    (*((volatile unsigned int*)(0x42A50010UL)))
#define bM4_DCU3_CTL_COMP_TRG                     (*((volatile unsigned int*)(0x42A50020UL)))
#define bM4_DCU3_CTL_INTEN                        (*((volatile unsigned int*)(0x42A5007CUL)))
#define bM4_DCU3_FLAG_FLAG_OP                     (*((volatile unsigned int*)(0x42A50080UL)))
#define bM4_DCU3_FLAG_FLAG_LS2                    (*((volatile unsigned int*)(0x42A50084UL)))
#define bM4_DCU3_FLAG_FLAG_EQ2                    (*((volatile unsigned int*)(0x42A50088UL)))
#define bM4_DCU3_FLAG_FLAG_GT2                    (*((volatile unsigned int*)(0x42A5008CUL)))
#define bM4_DCU3_FLAG_FLAG_LS1                    (*((volatile unsigned int*)(0x42A50090UL)))
#define bM4_DCU3_FLAG_FLAG_EQ1                    (*((volatile unsigned int*)(0x42A50094UL)))
#define bM4_DCU3_FLAG_FLAG_GT1                    (*((volatile unsigned int*)(0x42A50098UL)))
#define bM4_DCU3_FLAGCLR_CLR_OP                   (*((volatile unsigned int*)(0x42A50280UL)))
#define bM4_DCU3_FLAGCLR_CLR_LS2                  (*((volatile unsigned int*)(0x42A50284UL)))
#define bM4_DCU3_FLAGCLR_CLR_EQ2                  (*((volatile unsigned int*)(0x42A50288UL)))
#define bM4_DCU3_FLAGCLR_CLR_GT2                  (*((volatile unsigned int*)(0x42A5028CUL)))
#define bM4_DCU3_FLAGCLR_CLR_LS1                  (*((volatile unsigned int*)(0x42A50290UL)))
#define bM4_DCU3_FLAGCLR_CLR_EQ1                  (*((volatile unsigned int*)(0x42A50294UL)))
#define bM4_DCU3_FLAGCLR_CLR_GT1                  (*((volatile unsigned int*)(0x42A50298UL)))
#define bM4_DCU3_INTSEL_INT_OP                    (*((volatile unsigned int*)(0x42A50300UL)))
#define bM4_DCU3_INTSEL_INT_LS2                   (*((volatile unsigned int*)(0x42A50304UL)))
#define bM4_DCU3_INTSEL_INT_EQ2                   (*((volatile unsigned int*)(0x42A50308UL)))
#define bM4_DCU3_INTSEL_INT_GT2                   (*((volatile unsigned int*)(0x42A5030CUL)))
#define bM4_DCU3_INTSEL_INT_LS1                   (*((volatile unsigned int*)(0x42A50310UL)))
#define bM4_DCU3_INTSEL_INT_EQ1                   (*((volatile unsigned int*)(0x42A50314UL)))
#define bM4_DCU3_INTSEL_INT_GT1                   (*((volatile unsigned int*)(0x42A50318UL)))
#define bM4_DCU3_INTSEL_INT_WIN0                  (*((volatile unsigned int*)(0x42A5031CUL)))
#define bM4_DCU3_INTSEL_INT_WIN1                  (*((volatile unsigned int*)(0x42A50320UL)))
#define bM4_DCU4_CTL_MODE0                        (*((volatile unsigned int*)(0x42A58000UL)))
#define bM4_DCU4_CTL_MODE1                        (*((volatile unsigned int*)(0x42A58004UL)))
#define bM4_DCU4_CTL_MODE2                        (*((volatile unsigned int*)(0x42A58008UL)))
#define bM4_DCU4_CTL_DATASIZE0                    (*((volatile unsigned int*)(0x42A5800CUL)))
#define bM4_DCU4_CTL_DATASIZE1                    (*((volatile unsigned int*)(0x42A58010UL)))
#define bM4_DCU4_CTL_COMP_TRG                     (*((volatile unsigned int*)(0x42A58020UL)))
#define bM4_DCU4_CTL_INTEN                        (*((volatile unsigned int*)(0x42A5807CUL)))
#define bM4_DCU4_FLAG_FLAG_OP                     (*((volatile unsigned int*)(0x42A58080UL)))
#define bM4_DCU4_FLAG_FLAG_LS2                    (*((volatile unsigned int*)(0x42A58084UL)))
#define bM4_DCU4_FLAG_FLAG_EQ2                    (*((volatile unsigned int*)(0x42A58088UL)))
#define bM4_DCU4_FLAG_FLAG_GT2                    (*((volatile unsigned int*)(0x42A5808CUL)))
#define bM4_DCU4_FLAG_FLAG_LS1                    (*((volatile unsigned int*)(0x42A58090UL)))
#define bM4_DCU4_FLAG_FLAG_EQ1                    (*((volatile unsigned int*)(0x42A58094UL)))
#define bM4_DCU4_FLAG_FLAG_GT1                    (*((volatile unsigned int*)(0x42A58098UL)))
#define bM4_DCU4_FLAGCLR_CLR_OP                   (*((volatile unsigned int*)(0x42A58280UL)))
#define bM4_DCU4_FLAGCLR_CLR_LS2                  (*((volatile unsigned int*)(0x42A58284UL)))
#define bM4_DCU4_FLAGCLR_CLR_EQ2                  (*((volatile unsigned int*)(0x42A58288UL)))
#define bM4_DCU4_FLAGCLR_CLR_GT2                  (*((volatile unsigned int*)(0x42A5828CUL)))
#define bM4_DCU4_FLAGCLR_CLR_LS1                  (*((volatile unsigned int*)(0x42A58290UL)))
#define bM4_DCU4_FLAGCLR_CLR_EQ1                  (*((volatile unsigned int*)(0x42A58294UL)))
#define bM4_DCU4_FLAGCLR_CLR_GT1                  (*((volatile unsigned int*)(0x42A58298UL)))
#define bM4_DCU4_INTSEL_INT_OP                    (*((volatile unsigned int*)(0x42A58300UL)))
#define bM4_DCU4_INTSEL_INT_LS2                   (*((volatile unsigned int*)(0x42A58304UL)))
#define bM4_DCU4_INTSEL_INT_EQ2                   (*((volatile unsigned int*)(0x42A58308UL)))
#define bM4_DCU4_INTSEL_INT_GT2                   (*((volatile unsigned int*)(0x42A5830CUL)))
#define bM4_DCU4_INTSEL_INT_LS1                   (*((volatile unsigned int*)(0x42A58310UL)))
#define bM4_DCU4_INTSEL_INT_EQ1                   (*((volatile unsigned int*)(0x42A58314UL)))
#define bM4_DCU4_INTSEL_INT_GT1                   (*((volatile unsigned int*)(0x42A58318UL)))
#define bM4_DCU4_INTSEL_INT_WIN0                  (*((volatile unsigned int*)(0x42A5831CUL)))
#define bM4_DCU4_INTSEL_INT_WIN1                  (*((volatile unsigned int*)(0x42A58320UL)))
#define bM4_DMA1_EN_EN                            (*((volatile unsigned int*)(0x42A60000UL)))
#define bM4_DMA1_INTSTAT0_TRNERR0                 (*((volatile unsigned int*)(0x42A60080UL)))
#define bM4_DMA1_INTSTAT0_TRNERR1                 (*((volatile unsigned int*)(0x42A60084UL)))
#define bM4_DMA1_INTSTAT0_TRNERR2                 (*((volatile unsigned int*)(0x42A60088UL)))
#define bM4_DMA1_INTSTAT0_TRNERR3                 (*((volatile unsigned int*)(0x42A6008CUL)))
#define bM4_DMA1_INTSTAT0_REQERR0                 (*((volatile unsigned int*)(0x42A600C0UL)))
#define bM4_DMA1_INTSTAT0_REQERR1                 (*((volatile unsigned int*)(0x42A600C4UL)))
#define bM4_DMA1_INTSTAT0_REQERR2                 (*((volatile unsigned int*)(0x42A600C8UL)))
#define bM4_DMA1_INTSTAT0_REQERR3                 (*((volatile unsigned int*)(0x42A600CCUL)))
#define bM4_DMA1_INTSTAT1_TC0                     (*((volatile unsigned int*)(0x42A60100UL)))
#define bM4_DMA1_INTSTAT1_TC1                     (*((volatile unsigned int*)(0x42A60104UL)))
#define bM4_DMA1_INTSTAT1_TC2                     (*((volatile unsigned int*)(0x42A60108UL)))
#define bM4_DMA1_INTSTAT1_TC3                     (*((volatile unsigned int*)(0x42A6010CUL)))
#define bM4_DMA1_INTSTAT1_BTC0                    (*((volatile unsigned int*)(0x42A60140UL)))
#define bM4_DMA1_INTSTAT1_BTC1                    (*((volatile unsigned int*)(0x42A60144UL)))
#define bM4_DMA1_INTSTAT1_BTC2                    (*((volatile unsigned int*)(0x42A60148UL)))
#define bM4_DMA1_INTSTAT1_BTC3                    (*((volatile unsigned int*)(0x42A6014CUL)))
#define bM4_DMA1_INTMASK0_MSKTRNERR0              (*((volatile unsigned int*)(0x42A60180UL)))
#define bM4_DMA1_INTMASK0_MSKTRNERR1              (*((volatile unsigned int*)(0x42A60184UL)))
#define bM4_DMA1_INTMASK0_MSKTRNERR2              (*((volatile unsigned int*)(0x42A60188UL)))
#define bM4_DMA1_INTMASK0_MSKTRNERR3              (*((volatile unsigned int*)(0x42A6018CUL)))
#define bM4_DMA1_INTMASK0_MSKREQERR0              (*((volatile unsigned int*)(0x42A601C0UL)))
#define bM4_DMA1_INTMASK0_MSKREQERR1              (*((volatile unsigned int*)(0x42A601C4UL)))
#define bM4_DMA1_INTMASK0_MSKREQERR2              (*((volatile unsigned int*)(0x42A601C8UL)))
#define bM4_DMA1_INTMASK0_MSKREQERR3              (*((volatile unsigned int*)(0x42A601CCUL)))
#define bM4_DMA1_INTMASK1_MSKTC0                  (*((volatile unsigned int*)(0x42A60200UL)))
#define bM4_DMA1_INTMASK1_MSKTC1                  (*((volatile unsigned int*)(0x42A60204UL)))
#define bM4_DMA1_INTMASK1_MSKTC2                  (*((volatile unsigned int*)(0x42A60208UL)))
#define bM4_DMA1_INTMASK1_MSKTC3                  (*((volatile unsigned int*)(0x42A6020CUL)))
#define bM4_DMA1_INTMASK1_MSKBTC0                 (*((volatile unsigned int*)(0x42A60240UL)))
#define bM4_DMA1_INTMASK1_MSKBTC1                 (*((volatile unsigned int*)(0x42A60244UL)))
#define bM4_DMA1_INTMASK1_MSKBTC2                 (*((volatile unsigned int*)(0x42A60248UL)))
#define bM4_DMA1_INTMASK1_MSKBTC3                 (*((volatile unsigned int*)(0x42A6024CUL)))
#define bM4_DMA1_INTCLR0_CLRTRNERR0               (*((volatile unsigned int*)(0x42A60280UL)))
#define bM4_DMA1_INTCLR0_CLRTRNERR1               (*((volatile unsigned int*)(0x42A60284UL)))
#define bM4_DMA1_INTCLR0_CLRTRNERR2               (*((volatile unsigned int*)(0x42A60288UL)))
#define bM4_DMA1_INTCLR0_CLRTRNERR3               (*((volatile unsigned int*)(0x42A6028CUL)))
#define bM4_DMA1_INTCLR0_CLRREQERR0               (*((volatile unsigned int*)(0x42A602C0UL)))
#define bM4_DMA1_INTCLR0_CLRREQERR1               (*((volatile unsigned int*)(0x42A602C4UL)))
#define bM4_DMA1_INTCLR0_CLRREQERR2               (*((volatile unsigned int*)(0x42A602C8UL)))
#define bM4_DMA1_INTCLR0_CLRREQERR3               (*((volatile unsigned int*)(0x42A602CCUL)))
#define bM4_DMA1_INTCLR1_CLRTC0                   (*((volatile unsigned int*)(0x42A60300UL)))
#define bM4_DMA1_INTCLR1_CLRTC1                   (*((volatile unsigned int*)(0x42A60304UL)))
#define bM4_DMA1_INTCLR1_CLRTC2                   (*((volatile unsigned int*)(0x42A60308UL)))
#define bM4_DMA1_INTCLR1_CLRTC3                   (*((volatile unsigned int*)(0x42A6030CUL)))
#define bM4_DMA1_INTCLR1_CLRBTC0                  (*((volatile unsigned int*)(0x42A60340UL)))
#define bM4_DMA1_INTCLR1_CLRBTC1                  (*((volatile unsigned int*)(0x42A60344UL)))
#define bM4_DMA1_INTCLR1_CLRBTC2                  (*((volatile unsigned int*)(0x42A60348UL)))
#define bM4_DMA1_INTCLR1_CLRBTC3                  (*((volatile unsigned int*)(0x42A6034CUL)))
#define bM4_DMA1_CHEN_CHEN0                       (*((volatile unsigned int*)(0x42A60380UL)))
#define bM4_DMA1_CHEN_CHEN1                       (*((volatile unsigned int*)(0x42A60384UL)))
#define bM4_DMA1_CHEN_CHEN2                       (*((volatile unsigned int*)(0x42A60388UL)))
#define bM4_DMA1_CHEN_CHEN3                       (*((volatile unsigned int*)(0x42A6038CUL)))
#define bM4_DMA1_REQSTAT_CHREQ0                   (*((volatile unsigned int*)(0x42A60400UL)))
#define bM4_DMA1_REQSTAT_CHREQ1                   (*((volatile unsigned int*)(0x42A60404UL)))
#define bM4_DMA1_REQSTAT_CHREQ2                   (*((volatile unsigned int*)(0x42A60408UL)))
#define bM4_DMA1_REQSTAT_CHREQ3                   (*((volatile unsigned int*)(0x42A6040CUL)))
#define bM4_DMA1_REQSTAT_RCFGREQ                  (*((volatile unsigned int*)(0x42A6043CUL)))
#define bM4_DMA1_CHSTAT_DMAACT                    (*((volatile unsigned int*)(0x42A60480UL)))
#define bM4_DMA1_CHSTAT_RCFGACT                   (*((volatile unsigned int*)(0x42A60484UL)))
#define bM4_DMA1_CHSTAT_CHACT0                    (*((volatile unsigned int*)(0x42A604C0UL)))
#define bM4_DMA1_CHSTAT_CHACT1                    (*((volatile unsigned int*)(0x42A604C4UL)))
#define bM4_DMA1_CHSTAT_CHACT2                    (*((volatile unsigned int*)(0x42A604C8UL)))
#define bM4_DMA1_CHSTAT_CHACT3                    (*((volatile unsigned int*)(0x42A604CCUL)))
#define bM4_DMA1_RCFGCTL_RCFGEN                   (*((volatile unsigned int*)(0x42A60580UL)))
#define bM4_DMA1_RCFGCTL_RCFGLLP                  (*((volatile unsigned int*)(0x42A60584UL)))
#define bM4_DMA1_RCFGCTL_RCFGCHS0                 (*((volatile unsigned int*)(0x42A605A0UL)))
#define bM4_DMA1_RCFGCTL_RCFGCHS1                 (*((volatile unsigned int*)(0x42A605A4UL)))
#define bM4_DMA1_RCFGCTL_RCFGCHS2                 (*((volatile unsigned int*)(0x42A605A8UL)))
#define bM4_DMA1_RCFGCTL_RCFGCHS3                 (*((volatile unsigned int*)(0x42A605ACUL)))
#define bM4_DMA1_RCFGCTL_SARMD0                   (*((volatile unsigned int*)(0x42A605C0UL)))
#define bM4_DMA1_RCFGCTL_SARMD1                   (*((volatile unsigned int*)(0x42A605C4UL)))
#define bM4_DMA1_RCFGCTL_DARMD0                   (*((volatile unsigned int*)(0x42A605C8UL)))
#define bM4_DMA1_RCFGCTL_DARMD1                   (*((volatile unsigned int*)(0x42A605CCUL)))
#define bM4_DMA1_RCFGCTL_CNTMD0                   (*((volatile unsigned int*)(0x42A605D0UL)))
#define bM4_DMA1_RCFGCTL_CNTMD1                   (*((volatile unsigned int*)(0x42A605D4UL)))
#define bM4_DMA1_DTCTL0_BLKSIZE0                  (*((volatile unsigned int*)(0x42A60900UL)))
#define bM4_DMA1_DTCTL0_BLKSIZE1                  (*((volatile unsigned int*)(0x42A60904UL)))
#define bM4_DMA1_DTCTL0_BLKSIZE2                  (*((volatile unsigned int*)(0x42A60908UL)))
#define bM4_DMA1_DTCTL0_BLKSIZE3                  (*((volatile unsigned int*)(0x42A6090CUL)))
#define bM4_DMA1_DTCTL0_BLKSIZE4                  (*((volatile unsigned int*)(0x42A60910UL)))
#define bM4_DMA1_DTCTL0_BLKSIZE5                  (*((volatile unsigned int*)(0x42A60914UL)))
#define bM4_DMA1_DTCTL0_BLKSIZE6                  (*((volatile unsigned int*)(0x42A60918UL)))
#define bM4_DMA1_DTCTL0_BLKSIZE7                  (*((volatile unsigned int*)(0x42A6091CUL)))
#define bM4_DMA1_DTCTL0_BLKSIZE8                  (*((volatile unsigned int*)(0x42A60920UL)))
#define bM4_DMA1_DTCTL0_BLKSIZE9                  (*((volatile unsigned int*)(0x42A60924UL)))
#define bM4_DMA1_DTCTL0_CNT0                      (*((volatile unsigned int*)(0x42A60940UL)))
#define bM4_DMA1_DTCTL0_CNT1                      (*((volatile unsigned int*)(0x42A60944UL)))
#define bM4_DMA1_DTCTL0_CNT2                      (*((volatile unsigned int*)(0x42A60948UL)))
#define bM4_DMA1_DTCTL0_CNT3                      (*((volatile unsigned int*)(0x42A6094CUL)))
#define bM4_DMA1_DTCTL0_CNT4                      (*((volatile unsigned int*)(0x42A60950UL)))
#define bM4_DMA1_DTCTL0_CNT5                      (*((volatile unsigned int*)(0x42A60954UL)))
#define bM4_DMA1_DTCTL0_CNT6                      (*((volatile unsigned int*)(0x42A60958UL)))
#define bM4_DMA1_DTCTL0_CNT7                      (*((volatile unsigned int*)(0x42A6095CUL)))
#define bM4_DMA1_DTCTL0_CNT8                      (*((volatile unsigned int*)(0x42A60960UL)))
#define bM4_DMA1_DTCTL0_CNT9                      (*((volatile unsigned int*)(0x42A60964UL)))
#define bM4_DMA1_DTCTL0_CNT10                     (*((volatile unsigned int*)(0x42A60968UL)))
#define bM4_DMA1_DTCTL0_CNT11                     (*((volatile unsigned int*)(0x42A6096CUL)))
#define bM4_DMA1_DTCTL0_CNT12                     (*((volatile unsigned int*)(0x42A60970UL)))
#define bM4_DMA1_DTCTL0_CNT13                     (*((volatile unsigned int*)(0x42A60974UL)))
#define bM4_DMA1_DTCTL0_CNT14                     (*((volatile unsigned int*)(0x42A60978UL)))
#define bM4_DMA1_DTCTL0_CNT15                     (*((volatile unsigned int*)(0x42A6097CUL)))
#define bM4_DMA1_RPT0_SRPT0                       (*((volatile unsigned int*)(0x42A60980UL)))
#define bM4_DMA1_RPT0_SRPT1                       (*((volatile unsigned int*)(0x42A60984UL)))
#define bM4_DMA1_RPT0_SRPT2                       (*((volatile unsigned int*)(0x42A60988UL)))
#define bM4_DMA1_RPT0_SRPT3                       (*((volatile unsigned int*)(0x42A6098CUL)))
#define bM4_DMA1_RPT0_SRPT4                       (*((volatile unsigned int*)(0x42A60990UL)))
#define bM4_DMA1_RPT0_SRPT5                       (*((volatile unsigned int*)(0x42A60994UL)))
#define bM4_DMA1_RPT0_SRPT6                       (*((volatile unsigned int*)(0x42A60998UL)))
#define bM4_DMA1_RPT0_SRPT7                       (*((volatile unsigned int*)(0x42A6099CUL)))
#define bM4_DMA1_RPT0_SRPT8                       (*((volatile unsigned int*)(0x42A609A0UL)))
#define bM4_DMA1_RPT0_SRPT9                       (*((volatile unsigned int*)(0x42A609A4UL)))
#define bM4_DMA1_RPT0_DRPT0                       (*((volatile unsigned int*)(0x42A609C0UL)))
#define bM4_DMA1_RPT0_DRPT1                       (*((volatile unsigned int*)(0x42A609C4UL)))
#define bM4_DMA1_RPT0_DRPT2                       (*((volatile unsigned int*)(0x42A609C8UL)))
#define bM4_DMA1_RPT0_DRPT3                       (*((volatile unsigned int*)(0x42A609CCUL)))
#define bM4_DMA1_RPT0_DRPT4                       (*((volatile unsigned int*)(0x42A609D0UL)))
#define bM4_DMA1_RPT0_DRPT5                       (*((volatile unsigned int*)(0x42A609D4UL)))
#define bM4_DMA1_RPT0_DRPT6                       (*((volatile unsigned int*)(0x42A609D8UL)))
#define bM4_DMA1_RPT0_DRPT7                       (*((volatile unsigned int*)(0x42A609DCUL)))
#define bM4_DMA1_RPT0_DRPT8                       (*((volatile unsigned int*)(0x42A609E0UL)))
#define bM4_DMA1_RPT0_DRPT9                       (*((volatile unsigned int*)(0x42A609E4UL)))
#define bM4_DMA1_RPTB0_SRPTB0                     (*((volatile unsigned int*)(0x42A60980UL)))
#define bM4_DMA1_RPTB0_SRPTB1                     (*((volatile unsigned int*)(0x42A60984UL)))
#define bM4_DMA1_RPTB0_SRPTB2                     (*((volatile unsigned int*)(0x42A60988UL)))
#define bM4_DMA1_RPTB0_SRPTB3                     (*((volatile unsigned int*)(0x42A6098CUL)))
#define bM4_DMA1_RPTB0_SRPTB4                     (*((volatile unsigned int*)(0x42A60990UL)))
#define bM4_DMA1_RPTB0_SRPTB5                     (*((volatile unsigned int*)(0x42A60994UL)))
#define bM4_DMA1_RPTB0_SRPTB6                     (*((volatile unsigned int*)(0x42A60998UL)))
#define bM4_DMA1_RPTB0_SRPTB7                     (*((volatile unsigned int*)(0x42A6099CUL)))
#define bM4_DMA1_RPTB0_SRPTB8                     (*((volatile unsigned int*)(0x42A609A0UL)))
#define bM4_DMA1_RPTB0_SRPTB9                     (*((volatile unsigned int*)(0x42A609A4UL)))
#define bM4_DMA1_RPTB0_DRPTB0                     (*((volatile unsigned int*)(0x42A609C0UL)))
#define bM4_DMA1_RPTB0_DRPTB1                     (*((volatile unsigned int*)(0x42A609C4UL)))
#define bM4_DMA1_RPTB0_DRPTB2                     (*((volatile unsigned int*)(0x42A609C8UL)))
#define bM4_DMA1_RPTB0_DRPTB3                     (*((volatile unsigned int*)(0x42A609CCUL)))
#define bM4_DMA1_RPTB0_DRPTB4                     (*((volatile unsigned int*)(0x42A609D0UL)))
#define bM4_DMA1_RPTB0_DRPTB5                     (*((volatile unsigned int*)(0x42A609D4UL)))
#define bM4_DMA1_RPTB0_DRPTB6                     (*((volatile unsigned int*)(0x42A609D8UL)))
#define bM4_DMA1_RPTB0_DRPTB7                     (*((volatile unsigned int*)(0x42A609DCUL)))
#define bM4_DMA1_RPTB0_DRPTB8                     (*((volatile unsigned int*)(0x42A609E0UL)))
#define bM4_DMA1_RPTB0_DRPTB9                     (*((volatile unsigned int*)(0x42A609E4UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET0               (*((volatile unsigned int*)(0x42A60A00UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET1               (*((volatile unsigned int*)(0x42A60A04UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET2               (*((volatile unsigned int*)(0x42A60A08UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET3               (*((volatile unsigned int*)(0x42A60A0CUL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET4               (*((volatile unsigned int*)(0x42A60A10UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET5               (*((volatile unsigned int*)(0x42A60A14UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET6               (*((volatile unsigned int*)(0x42A60A18UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET7               (*((volatile unsigned int*)(0x42A60A1CUL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET8               (*((volatile unsigned int*)(0x42A60A20UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET9               (*((volatile unsigned int*)(0x42A60A24UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET10              (*((volatile unsigned int*)(0x42A60A28UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET11              (*((volatile unsigned int*)(0x42A60A2CUL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET12              (*((volatile unsigned int*)(0x42A60A30UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET13              (*((volatile unsigned int*)(0x42A60A34UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET14              (*((volatile unsigned int*)(0x42A60A38UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET15              (*((volatile unsigned int*)(0x42A60A3CUL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET16              (*((volatile unsigned int*)(0x42A60A40UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET17              (*((volatile unsigned int*)(0x42A60A44UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET18              (*((volatile unsigned int*)(0x42A60A48UL)))
#define bM4_DMA1_SNSEQCTL0_SOFFSET19              (*((volatile unsigned int*)(0x42A60A4CUL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT0                (*((volatile unsigned int*)(0x42A60A50UL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT1                (*((volatile unsigned int*)(0x42A60A54UL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT2                (*((volatile unsigned int*)(0x42A60A58UL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT3                (*((volatile unsigned int*)(0x42A60A5CUL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT4                (*((volatile unsigned int*)(0x42A60A60UL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT5                (*((volatile unsigned int*)(0x42A60A64UL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT6                (*((volatile unsigned int*)(0x42A60A68UL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT7                (*((volatile unsigned int*)(0x42A60A6CUL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT8                (*((volatile unsigned int*)(0x42A60A70UL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT9                (*((volatile unsigned int*)(0x42A60A74UL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT10               (*((volatile unsigned int*)(0x42A60A78UL)))
#define bM4_DMA1_SNSEQCTL0_SNSCNT11               (*((volatile unsigned int*)(0x42A60A7CUL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST0              (*((volatile unsigned int*)(0x42A60A00UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST1              (*((volatile unsigned int*)(0x42A60A04UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST2              (*((volatile unsigned int*)(0x42A60A08UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST3              (*((volatile unsigned int*)(0x42A60A0CUL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST4              (*((volatile unsigned int*)(0x42A60A10UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST5              (*((volatile unsigned int*)(0x42A60A14UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST6              (*((volatile unsigned int*)(0x42A60A18UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST7              (*((volatile unsigned int*)(0x42A60A1CUL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST8              (*((volatile unsigned int*)(0x42A60A20UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST9              (*((volatile unsigned int*)(0x42A60A24UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST10             (*((volatile unsigned int*)(0x42A60A28UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST11             (*((volatile unsigned int*)(0x42A60A2CUL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST12             (*((volatile unsigned int*)(0x42A60A30UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST13             (*((volatile unsigned int*)(0x42A60A34UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST14             (*((volatile unsigned int*)(0x42A60A38UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST15             (*((volatile unsigned int*)(0x42A60A3CUL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST16             (*((volatile unsigned int*)(0x42A60A40UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST17             (*((volatile unsigned int*)(0x42A60A44UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST18             (*((volatile unsigned int*)(0x42A60A48UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSDIST19             (*((volatile unsigned int*)(0x42A60A4CUL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB0              (*((volatile unsigned int*)(0x42A60A50UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB1              (*((volatile unsigned int*)(0x42A60A54UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB2              (*((volatile unsigned int*)(0x42A60A58UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB3              (*((volatile unsigned int*)(0x42A60A5CUL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB4              (*((volatile unsigned int*)(0x42A60A60UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB5              (*((volatile unsigned int*)(0x42A60A64UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB6              (*((volatile unsigned int*)(0x42A60A68UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB7              (*((volatile unsigned int*)(0x42A60A6CUL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB8              (*((volatile unsigned int*)(0x42A60A70UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB9              (*((volatile unsigned int*)(0x42A60A74UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB10             (*((volatile unsigned int*)(0x42A60A78UL)))
#define bM4_DMA1_SNSEQCTLB0_SNSCNTB11             (*((volatile unsigned int*)(0x42A60A7CUL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET0               (*((volatile unsigned int*)(0x42A60A80UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET1               (*((volatile unsigned int*)(0x42A60A84UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET2               (*((volatile unsigned int*)(0x42A60A88UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET3               (*((volatile unsigned int*)(0x42A60A8CUL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET4               (*((volatile unsigned int*)(0x42A60A90UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET5               (*((volatile unsigned int*)(0x42A60A94UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET6               (*((volatile unsigned int*)(0x42A60A98UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET7               (*((volatile unsigned int*)(0x42A60A9CUL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET8               (*((volatile unsigned int*)(0x42A60AA0UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET9               (*((volatile unsigned int*)(0x42A60AA4UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET10              (*((volatile unsigned int*)(0x42A60AA8UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET11              (*((volatile unsigned int*)(0x42A60AACUL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET12              (*((volatile unsigned int*)(0x42A60AB0UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET13              (*((volatile unsigned int*)(0x42A60AB4UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET14              (*((volatile unsigned int*)(0x42A60AB8UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET15              (*((volatile unsigned int*)(0x42A60ABCUL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET16              (*((volatile unsigned int*)(0x42A60AC0UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET17              (*((volatile unsigned int*)(0x42A60AC4UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET18              (*((volatile unsigned int*)(0x42A60AC8UL)))
#define bM4_DMA1_DNSEQCTL0_DOFFSET19              (*((volatile unsigned int*)(0x42A60ACCUL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT0                (*((volatile unsigned int*)(0x42A60AD0UL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT1                (*((volatile unsigned int*)(0x42A60AD4UL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT2                (*((volatile unsigned int*)(0x42A60AD8UL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT3                (*((volatile unsigned int*)(0x42A60ADCUL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT4                (*((volatile unsigned int*)(0x42A60AE0UL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT5                (*((volatile unsigned int*)(0x42A60AE4UL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT6                (*((volatile unsigned int*)(0x42A60AE8UL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT7                (*((volatile unsigned int*)(0x42A60AECUL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT8                (*((volatile unsigned int*)(0x42A60AF0UL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT9                (*((volatile unsigned int*)(0x42A60AF4UL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT10               (*((volatile unsigned int*)(0x42A60AF8UL)))
#define bM4_DMA1_DNSEQCTL0_DNSCNT11               (*((volatile unsigned int*)(0x42A60AFCUL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST0              (*((volatile unsigned int*)(0x42A60A80UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST1              (*((volatile unsigned int*)(0x42A60A84UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST2              (*((volatile unsigned int*)(0x42A60A88UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST3              (*((volatile unsigned int*)(0x42A60A8CUL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST4              (*((volatile unsigned int*)(0x42A60A90UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST5              (*((volatile unsigned int*)(0x42A60A94UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST6              (*((volatile unsigned int*)(0x42A60A98UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST7              (*((volatile unsigned int*)(0x42A60A9CUL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST8              (*((volatile unsigned int*)(0x42A60AA0UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST9              (*((volatile unsigned int*)(0x42A60AA4UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST10             (*((volatile unsigned int*)(0x42A60AA8UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST11             (*((volatile unsigned int*)(0x42A60AACUL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST12             (*((volatile unsigned int*)(0x42A60AB0UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST13             (*((volatile unsigned int*)(0x42A60AB4UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST14             (*((volatile unsigned int*)(0x42A60AB8UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST15             (*((volatile unsigned int*)(0x42A60ABCUL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST16             (*((volatile unsigned int*)(0x42A60AC0UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST17             (*((volatile unsigned int*)(0x42A60AC4UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST18             (*((volatile unsigned int*)(0x42A60AC8UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSDIST19             (*((volatile unsigned int*)(0x42A60ACCUL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB0              (*((volatile unsigned int*)(0x42A60AD0UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB1              (*((volatile unsigned int*)(0x42A60AD4UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB2              (*((volatile unsigned int*)(0x42A60AD8UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB3              (*((volatile unsigned int*)(0x42A60ADCUL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB4              (*((volatile unsigned int*)(0x42A60AE0UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB5              (*((volatile unsigned int*)(0x42A60AE4UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB6              (*((volatile unsigned int*)(0x42A60AE8UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB7              (*((volatile unsigned int*)(0x42A60AECUL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB8              (*((volatile unsigned int*)(0x42A60AF0UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB9              (*((volatile unsigned int*)(0x42A60AF4UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB10             (*((volatile unsigned int*)(0x42A60AF8UL)))
#define bM4_DMA1_DNSEQCTLB0_DNSCNTB11             (*((volatile unsigned int*)(0x42A60AFCUL)))
#define bM4_DMA1_LLP0_LLP0                        (*((volatile unsigned int*)(0x42A60B08UL)))
#define bM4_DMA1_LLP0_LLP1                        (*((volatile unsigned int*)(0x42A60B0CUL)))
#define bM4_DMA1_LLP0_LLP2                        (*((volatile unsigned int*)(0x42A60B10UL)))
#define bM4_DMA1_LLP0_LLP3                        (*((volatile unsigned int*)(0x42A60B14UL)))
#define bM4_DMA1_LLP0_LLP4                        (*((volatile unsigned int*)(0x42A60B18UL)))
#define bM4_DMA1_LLP0_LLP5                        (*((volatile unsigned int*)(0x42A60B1CUL)))
#define bM4_DMA1_LLP0_LLP6                        (*((volatile unsigned int*)(0x42A60B20UL)))
#define bM4_DMA1_LLP0_LLP7                        (*((volatile unsigned int*)(0x42A60B24UL)))
#define bM4_DMA1_LLP0_LLP8                        (*((volatile unsigned int*)(0x42A60B28UL)))
#define bM4_DMA1_LLP0_LLP9                        (*((volatile unsigned int*)(0x42A60B2CUL)))
#define bM4_DMA1_LLP0_LLP10                       (*((volatile unsigned int*)(0x42A60B30UL)))
#define bM4_DMA1_LLP0_LLP11                       (*((volatile unsigned int*)(0x42A60B34UL)))
#define bM4_DMA1_LLP0_LLP12                       (*((volatile unsigned int*)(0x42A60B38UL)))
#define bM4_DMA1_LLP0_LLP13                       (*((volatile unsigned int*)(0x42A60B3CUL)))
#define bM4_DMA1_LLP0_LLP14                       (*((volatile unsigned int*)(0x42A60B40UL)))
#define bM4_DMA1_LLP0_LLP15                       (*((volatile unsigned int*)(0x42A60B44UL)))
#define bM4_DMA1_LLP0_LLP16                       (*((volatile unsigned int*)(0x42A60B48UL)))
#define bM4_DMA1_LLP0_LLP17                       (*((volatile unsigned int*)(0x42A60B4CUL)))
#define bM4_DMA1_LLP0_LLP18                       (*((volatile unsigned int*)(0x42A60B50UL)))
#define bM4_DMA1_LLP0_LLP19                       (*((volatile unsigned int*)(0x42A60B54UL)))
#define bM4_DMA1_LLP0_LLP20                       (*((volatile unsigned int*)(0x42A60B58UL)))
#define bM4_DMA1_LLP0_LLP21                       (*((volatile unsigned int*)(0x42A60B5CUL)))
#define bM4_DMA1_LLP0_LLP22                       (*((volatile unsigned int*)(0x42A60B60UL)))
#define bM4_DMA1_LLP0_LLP23                       (*((volatile unsigned int*)(0x42A60B64UL)))
#define bM4_DMA1_LLP0_LLP24                       (*((volatile unsigned int*)(0x42A60B68UL)))
#define bM4_DMA1_LLP0_LLP25                       (*((volatile unsigned int*)(0x42A60B6CUL)))
#define bM4_DMA1_LLP0_LLP26                       (*((volatile unsigned int*)(0x42A60B70UL)))
#define bM4_DMA1_LLP0_LLP27                       (*((volatile unsigned int*)(0x42A60B74UL)))
#define bM4_DMA1_LLP0_LLP28                       (*((volatile unsigned int*)(0x42A60B78UL)))
#define bM4_DMA1_LLP0_LLP29                       (*((volatile unsigned int*)(0x42A60B7CUL)))
#define bM4_DMA1_CHCTL0_SINC0                     (*((volatile unsigned int*)(0x42A60B80UL)))
#define bM4_DMA1_CHCTL0_SINC1                     (*((volatile unsigned int*)(0x42A60B84UL)))
#define bM4_DMA1_CHCTL0_DINC0                     (*((volatile unsigned int*)(0x42A60B88UL)))
#define bM4_DMA1_CHCTL0_DINC1                     (*((volatile unsigned int*)(0x42A60B8CUL)))
#define bM4_DMA1_CHCTL0_SRPTEN                    (*((volatile unsigned int*)(0x42A60B90UL)))
#define bM4_DMA1_CHCTL0_DRPTEN                    (*((volatile unsigned int*)(0x42A60B94UL)))
#define bM4_DMA1_CHCTL0_SNSEQEN                   (*((volatile unsigned int*)(0x42A60B98UL)))
#define bM4_DMA1_CHCTL0_DNSEQEN                   (*((volatile unsigned int*)(0x42A60B9CUL)))
#define bM4_DMA1_CHCTL0_HSIZE0                    (*((volatile unsigned int*)(0x42A60BA0UL)))
#define bM4_DMA1_CHCTL0_HSIZE1                    (*((volatile unsigned int*)(0x42A60BA4UL)))
#define bM4_DMA1_CHCTL0_LLPEN                     (*((volatile unsigned int*)(0x42A60BA8UL)))
#define bM4_DMA1_CHCTL0_LLPRUN                    (*((volatile unsigned int*)(0x42A60BACUL)))
#define bM4_DMA1_CHCTL0_IE                        (*((volatile unsigned int*)(0x42A60BB0UL)))
#define bM4_DMA1_MONDTCTL0_BLKSIZE0               (*((volatile unsigned int*)(0x42A60D00UL)))
#define bM4_DMA1_MONDTCTL0_BLKSIZE1               (*((volatile unsigned int*)(0x42A60D04UL)))
#define bM4_DMA1_MONDTCTL0_BLKSIZE2               (*((volatile unsigned int*)(0x42A60D08UL)))
#define bM4_DMA1_MONDTCTL0_BLKSIZE3               (*((volatile unsigned int*)(0x42A60D0CUL)))
#define bM4_DMA1_MONDTCTL0_BLKSIZE4               (*((volatile unsigned int*)(0x42A60D10UL)))
#define bM4_DMA1_MONDTCTL0_BLKSIZE5               (*((volatile unsigned int*)(0x42A60D14UL)))
#define bM4_DMA1_MONDTCTL0_BLKSIZE6               (*((volatile unsigned int*)(0x42A60D18UL)))
#define bM4_DMA1_MONDTCTL0_BLKSIZE7               (*((volatile unsigned int*)(0x42A60D1CUL)))
#define bM4_DMA1_MONDTCTL0_BLKSIZE8               (*((volatile unsigned int*)(0x42A60D20UL)))
#define bM4_DMA1_MONDTCTL0_BLKSIZE9               (*((volatile unsigned int*)(0x42A60D24UL)))
#define bM4_DMA1_MONDTCTL0_CNT0                   (*((volatile unsigned int*)(0x42A60D40UL)))
#define bM4_DMA1_MONDTCTL0_CNT1                   (*((volatile unsigned int*)(0x42A60D44UL)))
#define bM4_DMA1_MONDTCTL0_CNT2                   (*((volatile unsigned int*)(0x42A60D48UL)))
#define bM4_DMA1_MONDTCTL0_CNT3                   (*((volatile unsigned int*)(0x42A60D4CUL)))
#define bM4_DMA1_MONDTCTL0_CNT4                   (*((volatile unsigned int*)(0x42A60D50UL)))
#define bM4_DMA1_MONDTCTL0_CNT5                   (*((volatile unsigned int*)(0x42A60D54UL)))
#define bM4_DMA1_MONDTCTL0_CNT6                   (*((volatile unsigned int*)(0x42A60D58UL)))
#define bM4_DMA1_MONDTCTL0_CNT7                   (*((volatile unsigned int*)(0x42A60D5CUL)))
#define bM4_DMA1_MONDTCTL0_CNT8                   (*((volatile unsigned int*)(0x42A60D60UL)))
#define bM4_DMA1_MONDTCTL0_CNT9                   (*((volatile unsigned int*)(0x42A60D64UL)))
#define bM4_DMA1_MONDTCTL0_CNT10                  (*((volatile unsigned int*)(0x42A60D68UL)))
#define bM4_DMA1_MONDTCTL0_CNT11                  (*((volatile unsigned int*)(0x42A60D6CUL)))
#define bM4_DMA1_MONDTCTL0_CNT12                  (*((volatile unsigned int*)(0x42A60D70UL)))
#define bM4_DMA1_MONDTCTL0_CNT13                  (*((volatile unsigned int*)(0x42A60D74UL)))
#define bM4_DMA1_MONDTCTL0_CNT14                  (*((volatile unsigned int*)(0x42A60D78UL)))
#define bM4_DMA1_MONDTCTL0_CNT15                  (*((volatile unsigned int*)(0x42A60D7CUL)))
#define bM4_DMA1_MONRPT0_SRPT0                    (*((volatile unsigned int*)(0x42A60D80UL)))
#define bM4_DMA1_MONRPT0_SRPT1                    (*((volatile unsigned int*)(0x42A60D84UL)))
#define bM4_DMA1_MONRPT0_SRPT2                    (*((volatile unsigned int*)(0x42A60D88UL)))
#define bM4_DMA1_MONRPT0_SRPT3                    (*((volatile unsigned int*)(0x42A60D8CUL)))
#define bM4_DMA1_MONRPT0_SRPT4                    (*((volatile unsigned int*)(0x42A60D90UL)))
#define bM4_DMA1_MONRPT0_SRPT5                    (*((volatile unsigned int*)(0x42A60D94UL)))
#define bM4_DMA1_MONRPT0_SRPT6                    (*((volatile unsigned int*)(0x42A60D98UL)))
#define bM4_DMA1_MONRPT0_SRPT7                    (*((volatile unsigned int*)(0x42A60D9CUL)))
#define bM4_DMA1_MONRPT0_SRPT8                    (*((volatile unsigned int*)(0x42A60DA0UL)))
#define bM4_DMA1_MONRPT0_SRPT9                    (*((volatile unsigned int*)(0x42A60DA4UL)))
#define bM4_DMA1_MONRPT0_DRPT0                    (*((volatile unsigned int*)(0x42A60DC0UL)))
#define bM4_DMA1_MONRPT0_DRPT1                    (*((volatile unsigned int*)(0x42A60DC4UL)))
#define bM4_DMA1_MONRPT0_DRPT2                    (*((volatile unsigned int*)(0x42A60DC8UL)))
#define bM4_DMA1_MONRPT0_DRPT3                    (*((volatile unsigned int*)(0x42A60DCCUL)))
#define bM4_DMA1_MONRPT0_DRPT4                    (*((volatile unsigned int*)(0x42A60DD0UL)))
#define bM4_DMA1_MONRPT0_DRPT5                    (*((volatile unsigned int*)(0x42A60DD4UL)))
#define bM4_DMA1_MONRPT0_DRPT6                    (*((volatile unsigned int*)(0x42A60DD8UL)))
#define bM4_DMA1_MONRPT0_DRPT7                    (*((volatile unsigned int*)(0x42A60DDCUL)))
#define bM4_DMA1_MONRPT0_DRPT8                    (*((volatile unsigned int*)(0x42A60DE0UL)))
#define bM4_DMA1_MONRPT0_DRPT9                    (*((volatile unsigned int*)(0x42A60DE4UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET0            (*((volatile unsigned int*)(0x42A60E00UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET1            (*((volatile unsigned int*)(0x42A60E04UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET2            (*((volatile unsigned int*)(0x42A60E08UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET3            (*((volatile unsigned int*)(0x42A60E0CUL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET4            (*((volatile unsigned int*)(0x42A60E10UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET5            (*((volatile unsigned int*)(0x42A60E14UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET6            (*((volatile unsigned int*)(0x42A60E18UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET7            (*((volatile unsigned int*)(0x42A60E1CUL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET8            (*((volatile unsigned int*)(0x42A60E20UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET9            (*((volatile unsigned int*)(0x42A60E24UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET10           (*((volatile unsigned int*)(0x42A60E28UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET11           (*((volatile unsigned int*)(0x42A60E2CUL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET12           (*((volatile unsigned int*)(0x42A60E30UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET13           (*((volatile unsigned int*)(0x42A60E34UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET14           (*((volatile unsigned int*)(0x42A60E38UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET15           (*((volatile unsigned int*)(0x42A60E3CUL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET16           (*((volatile unsigned int*)(0x42A60E40UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET17           (*((volatile unsigned int*)(0x42A60E44UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET18           (*((volatile unsigned int*)(0x42A60E48UL)))
#define bM4_DMA1_MONSNSEQCTL0_SOFFSET19           (*((volatile unsigned int*)(0x42A60E4CUL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT0             (*((volatile unsigned int*)(0x42A60E50UL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT1             (*((volatile unsigned int*)(0x42A60E54UL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT2             (*((volatile unsigned int*)(0x42A60E58UL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT3             (*((volatile unsigned int*)(0x42A60E5CUL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT4             (*((volatile unsigned int*)(0x42A60E60UL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT5             (*((volatile unsigned int*)(0x42A60E64UL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT6             (*((volatile unsigned int*)(0x42A60E68UL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT7             (*((volatile unsigned int*)(0x42A60E6CUL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT8             (*((volatile unsigned int*)(0x42A60E70UL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT9             (*((volatile unsigned int*)(0x42A60E74UL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT10            (*((volatile unsigned int*)(0x42A60E78UL)))
#define bM4_DMA1_MONSNSEQCTL0_SNSCNT11            (*((volatile unsigned int*)(0x42A60E7CUL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET0            (*((volatile unsigned int*)(0x42A60E80UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET1            (*((volatile unsigned int*)(0x42A60E84UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET2            (*((volatile unsigned int*)(0x42A60E88UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET3            (*((volatile unsigned int*)(0x42A60E8CUL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET4            (*((volatile unsigned int*)(0x42A60E90UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET5            (*((volatile unsigned int*)(0x42A60E94UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET6            (*((volatile unsigned int*)(0x42A60E98UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET7            (*((volatile unsigned int*)(0x42A60E9CUL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET8            (*((volatile unsigned int*)(0x42A60EA0UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET9            (*((volatile unsigned int*)(0x42A60EA4UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET10           (*((volatile unsigned int*)(0x42A60EA8UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET11           (*((volatile unsigned int*)(0x42A60EACUL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET12           (*((volatile unsigned int*)(0x42A60EB0UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET13           (*((volatile unsigned int*)(0x42A60EB4UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET14           (*((volatile unsigned int*)(0x42A60EB8UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET15           (*((volatile unsigned int*)(0x42A60EBCUL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET16           (*((volatile unsigned int*)(0x42A60EC0UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET17           (*((volatile unsigned int*)(0x42A60EC4UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET18           (*((volatile unsigned int*)(0x42A60EC8UL)))
#define bM4_DMA1_MONDNSEQCTL0_DOFFSET19           (*((volatile unsigned int*)(0x42A60ECCUL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT0             (*((volatile unsigned int*)(0x42A60ED0UL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT1             (*((volatile unsigned int*)(0x42A60ED4UL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT2             (*((volatile unsigned int*)(0x42A60ED8UL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT3             (*((volatile unsigned int*)(0x42A60EDCUL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT4             (*((volatile unsigned int*)(0x42A60EE0UL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT5             (*((volatile unsigned int*)(0x42A60EE4UL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT6             (*((volatile unsigned int*)(0x42A60EE8UL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT7             (*((volatile unsigned int*)(0x42A60EECUL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT8             (*((volatile unsigned int*)(0x42A60EF0UL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT9             (*((volatile unsigned int*)(0x42A60EF4UL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT10            (*((volatile unsigned int*)(0x42A60EF8UL)))
#define bM4_DMA1_MONDNSEQCTL0_DNSCNT11            (*((volatile unsigned int*)(0x42A60EFCUL)))
#define bM4_DMA1_DTCTL1_BLKSIZE0                  (*((volatile unsigned int*)(0x42A61100UL)))
#define bM4_DMA1_DTCTL1_BLKSIZE1                  (*((volatile unsigned int*)(0x42A61104UL)))
#define bM4_DMA1_DTCTL1_BLKSIZE2                  (*((volatile unsigned int*)(0x42A61108UL)))
#define bM4_DMA1_DTCTL1_BLKSIZE3                  (*((volatile unsigned int*)(0x42A6110CUL)))
#define bM4_DMA1_DTCTL1_BLKSIZE4                  (*((volatile unsigned int*)(0x42A61110UL)))
#define bM4_DMA1_DTCTL1_BLKSIZE5                  (*((volatile unsigned int*)(0x42A61114UL)))
#define bM4_DMA1_DTCTL1_BLKSIZE6                  (*((volatile unsigned int*)(0x42A61118UL)))
#define bM4_DMA1_DTCTL1_BLKSIZE7                  (*((volatile unsigned int*)(0x42A6111CUL)))
#define bM4_DMA1_DTCTL1_BLKSIZE8                  (*((volatile unsigned int*)(0x42A61120UL)))
#define bM4_DMA1_DTCTL1_BLKSIZE9                  (*((volatile unsigned int*)(0x42A61124UL)))
#define bM4_DMA1_DTCTL1_CNT0                      (*((volatile unsigned int*)(0x42A61140UL)))
#define bM4_DMA1_DTCTL1_CNT1                      (*((volatile unsigned int*)(0x42A61144UL)))
#define bM4_DMA1_DTCTL1_CNT2                      (*((volatile unsigned int*)(0x42A61148UL)))
#define bM4_DMA1_DTCTL1_CNT3                      (*((volatile unsigned int*)(0x42A6114CUL)))
#define bM4_DMA1_DTCTL1_CNT4                      (*((volatile unsigned int*)(0x42A61150UL)))
#define bM4_DMA1_DTCTL1_CNT5                      (*((volatile unsigned int*)(0x42A61154UL)))
#define bM4_DMA1_DTCTL1_CNT6                      (*((volatile unsigned int*)(0x42A61158UL)))
#define bM4_DMA1_DTCTL1_CNT7                      (*((volatile unsigned int*)(0x42A6115CUL)))
#define bM4_DMA1_DTCTL1_CNT8                      (*((volatile unsigned int*)(0x42A61160UL)))
#define bM4_DMA1_DTCTL1_CNT9                      (*((volatile unsigned int*)(0x42A61164UL)))
#define bM4_DMA1_DTCTL1_CNT10                     (*((volatile unsigned int*)(0x42A61168UL)))
#define bM4_DMA1_DTCTL1_CNT11                     (*((volatile unsigned int*)(0x42A6116CUL)))
#define bM4_DMA1_DTCTL1_CNT12                     (*((volatile unsigned int*)(0x42A61170UL)))
#define bM4_DMA1_DTCTL1_CNT13                     (*((volatile unsigned int*)(0x42A61174UL)))
#define bM4_DMA1_DTCTL1_CNT14                     (*((volatile unsigned int*)(0x42A61178UL)))
#define bM4_DMA1_DTCTL1_CNT15                     (*((volatile unsigned int*)(0x42A6117CUL)))
#define bM4_DMA1_RPT1_SRPT0                       (*((volatile unsigned int*)(0x42A61180UL)))
#define bM4_DMA1_RPT1_SRPT1                       (*((volatile unsigned int*)(0x42A61184UL)))
#define bM4_DMA1_RPT1_SRPT2                       (*((volatile unsigned int*)(0x42A61188UL)))
#define bM4_DMA1_RPT1_SRPT3                       (*((volatile unsigned int*)(0x42A6118CUL)))
#define bM4_DMA1_RPT1_SRPT4                       (*((volatile unsigned int*)(0x42A61190UL)))
#define bM4_DMA1_RPT1_SRPT5                       (*((volatile unsigned int*)(0x42A61194UL)))
#define bM4_DMA1_RPT1_SRPT6                       (*((volatile unsigned int*)(0x42A61198UL)))
#define bM4_DMA1_RPT1_SRPT7                       (*((volatile unsigned int*)(0x42A6119CUL)))
#define bM4_DMA1_RPT1_SRPT8                       (*((volatile unsigned int*)(0x42A611A0UL)))
#define bM4_DMA1_RPT1_SRPT9                       (*((volatile unsigned int*)(0x42A611A4UL)))
#define bM4_DMA1_RPT1_DRPT0                       (*((volatile unsigned int*)(0x42A611C0UL)))
#define bM4_DMA1_RPT1_DRPT1                       (*((volatile unsigned int*)(0x42A611C4UL)))
#define bM4_DMA1_RPT1_DRPT2                       (*((volatile unsigned int*)(0x42A611C8UL)))
#define bM4_DMA1_RPT1_DRPT3                       (*((volatile unsigned int*)(0x42A611CCUL)))
#define bM4_DMA1_RPT1_DRPT4                       (*((volatile unsigned int*)(0x42A611D0UL)))
#define bM4_DMA1_RPT1_DRPT5                       (*((volatile unsigned int*)(0x42A611D4UL)))
#define bM4_DMA1_RPT1_DRPT6                       (*((volatile unsigned int*)(0x42A611D8UL)))
#define bM4_DMA1_RPT1_DRPT7                       (*((volatile unsigned int*)(0x42A611DCUL)))
#define bM4_DMA1_RPT1_DRPT8                       (*((volatile unsigned int*)(0x42A611E0UL)))
#define bM4_DMA1_RPT1_DRPT9                       (*((volatile unsigned int*)(0x42A611E4UL)))
#define bM4_DMA1_RPTB1_SRPTB0                     (*((volatile unsigned int*)(0x42A61180UL)))
#define bM4_DMA1_RPTB1_SRPTB1                     (*((volatile unsigned int*)(0x42A61184UL)))
#define bM4_DMA1_RPTB1_SRPTB2                     (*((volatile unsigned int*)(0x42A61188UL)))
#define bM4_DMA1_RPTB1_SRPTB3                     (*((volatile unsigned int*)(0x42A6118CUL)))
#define bM4_DMA1_RPTB1_SRPTB4                     (*((volatile unsigned int*)(0x42A61190UL)))
#define bM4_DMA1_RPTB1_SRPTB5                     (*((volatile unsigned int*)(0x42A61194UL)))
#define bM4_DMA1_RPTB1_SRPTB6                     (*((volatile unsigned int*)(0x42A61198UL)))
#define bM4_DMA1_RPTB1_SRPTB7                     (*((volatile unsigned int*)(0x42A6119CUL)))
#define bM4_DMA1_RPTB1_SRPTB8                     (*((volatile unsigned int*)(0x42A611A0UL)))
#define bM4_DMA1_RPTB1_SRPTB9                     (*((volatile unsigned int*)(0x42A611A4UL)))
#define bM4_DMA1_RPTB1_DRPTB0                     (*((volatile unsigned int*)(0x42A611C0UL)))
#define bM4_DMA1_RPTB1_DRPTB1                     (*((volatile unsigned int*)(0x42A611C4UL)))
#define bM4_DMA1_RPTB1_DRPTB2                     (*((volatile unsigned int*)(0x42A611C8UL)))
#define bM4_DMA1_RPTB1_DRPTB3                     (*((volatile unsigned int*)(0x42A611CCUL)))
#define bM4_DMA1_RPTB1_DRPTB4                     (*((volatile unsigned int*)(0x42A611D0UL)))
#define bM4_DMA1_RPTB1_DRPTB5                     (*((volatile unsigned int*)(0x42A611D4UL)))
#define bM4_DMA1_RPTB1_DRPTB6                     (*((volatile unsigned int*)(0x42A611D8UL)))
#define bM4_DMA1_RPTB1_DRPTB7                     (*((volatile unsigned int*)(0x42A611DCUL)))
#define bM4_DMA1_RPTB1_DRPTB8                     (*((volatile unsigned int*)(0x42A611E0UL)))
#define bM4_DMA1_RPTB1_DRPTB9                     (*((volatile unsigned int*)(0x42A611E4UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET0               (*((volatile unsigned int*)(0x42A61200UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET1               (*((volatile unsigned int*)(0x42A61204UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET2               (*((volatile unsigned int*)(0x42A61208UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET3               (*((volatile unsigned int*)(0x42A6120CUL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET4               (*((volatile unsigned int*)(0x42A61210UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET5               (*((volatile unsigned int*)(0x42A61214UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET6               (*((volatile unsigned int*)(0x42A61218UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET7               (*((volatile unsigned int*)(0x42A6121CUL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET8               (*((volatile unsigned int*)(0x42A61220UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET9               (*((volatile unsigned int*)(0x42A61224UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET10              (*((volatile unsigned int*)(0x42A61228UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET11              (*((volatile unsigned int*)(0x42A6122CUL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET12              (*((volatile unsigned int*)(0x42A61230UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET13              (*((volatile unsigned int*)(0x42A61234UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET14              (*((volatile unsigned int*)(0x42A61238UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET15              (*((volatile unsigned int*)(0x42A6123CUL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET16              (*((volatile unsigned int*)(0x42A61240UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET17              (*((volatile unsigned int*)(0x42A61244UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET18              (*((volatile unsigned int*)(0x42A61248UL)))
#define bM4_DMA1_SNSEQCTL1_SOFFSET19              (*((volatile unsigned int*)(0x42A6124CUL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT0                (*((volatile unsigned int*)(0x42A61250UL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT1                (*((volatile unsigned int*)(0x42A61254UL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT2                (*((volatile unsigned int*)(0x42A61258UL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT3                (*((volatile unsigned int*)(0x42A6125CUL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT4                (*((volatile unsigned int*)(0x42A61260UL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT5                (*((volatile unsigned int*)(0x42A61264UL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT6                (*((volatile unsigned int*)(0x42A61268UL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT7                (*((volatile unsigned int*)(0x42A6126CUL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT8                (*((volatile unsigned int*)(0x42A61270UL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT9                (*((volatile unsigned int*)(0x42A61274UL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT10               (*((volatile unsigned int*)(0x42A61278UL)))
#define bM4_DMA1_SNSEQCTL1_SNSCNT11               (*((volatile unsigned int*)(0x42A6127CUL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST0              (*((volatile unsigned int*)(0x42A61200UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST1              (*((volatile unsigned int*)(0x42A61204UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST2              (*((volatile unsigned int*)(0x42A61208UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST3              (*((volatile unsigned int*)(0x42A6120CUL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST4              (*((volatile unsigned int*)(0x42A61210UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST5              (*((volatile unsigned int*)(0x42A61214UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST6              (*((volatile unsigned int*)(0x42A61218UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST7              (*((volatile unsigned int*)(0x42A6121CUL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST8              (*((volatile unsigned int*)(0x42A61220UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST9              (*((volatile unsigned int*)(0x42A61224UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST10             (*((volatile unsigned int*)(0x42A61228UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST11             (*((volatile unsigned int*)(0x42A6122CUL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST12             (*((volatile unsigned int*)(0x42A61230UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST13             (*((volatile unsigned int*)(0x42A61234UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST14             (*((volatile unsigned int*)(0x42A61238UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST15             (*((volatile unsigned int*)(0x42A6123CUL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST16             (*((volatile unsigned int*)(0x42A61240UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST17             (*((volatile unsigned int*)(0x42A61244UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST18             (*((volatile unsigned int*)(0x42A61248UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSDIST19             (*((volatile unsigned int*)(0x42A6124CUL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB0              (*((volatile unsigned int*)(0x42A61250UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB1              (*((volatile unsigned int*)(0x42A61254UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB2              (*((volatile unsigned int*)(0x42A61258UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB3              (*((volatile unsigned int*)(0x42A6125CUL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB4              (*((volatile unsigned int*)(0x42A61260UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB5              (*((volatile unsigned int*)(0x42A61264UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB6              (*((volatile unsigned int*)(0x42A61268UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB7              (*((volatile unsigned int*)(0x42A6126CUL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB8              (*((volatile unsigned int*)(0x42A61270UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB9              (*((volatile unsigned int*)(0x42A61274UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB10             (*((volatile unsigned int*)(0x42A61278UL)))
#define bM4_DMA1_SNSEQCTLB1_SNSCNTB11             (*((volatile unsigned int*)(0x42A6127CUL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET0               (*((volatile unsigned int*)(0x42A61280UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET1               (*((volatile unsigned int*)(0x42A61284UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET2               (*((volatile unsigned int*)(0x42A61288UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET3               (*((volatile unsigned int*)(0x42A6128CUL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET4               (*((volatile unsigned int*)(0x42A61290UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET5               (*((volatile unsigned int*)(0x42A61294UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET6               (*((volatile unsigned int*)(0x42A61298UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET7               (*((volatile unsigned int*)(0x42A6129CUL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET8               (*((volatile unsigned int*)(0x42A612A0UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET9               (*((volatile unsigned int*)(0x42A612A4UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET10              (*((volatile unsigned int*)(0x42A612A8UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET11              (*((volatile unsigned int*)(0x42A612ACUL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET12              (*((volatile unsigned int*)(0x42A612B0UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET13              (*((volatile unsigned int*)(0x42A612B4UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET14              (*((volatile unsigned int*)(0x42A612B8UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET15              (*((volatile unsigned int*)(0x42A612BCUL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET16              (*((volatile unsigned int*)(0x42A612C0UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET17              (*((volatile unsigned int*)(0x42A612C4UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET18              (*((volatile unsigned int*)(0x42A612C8UL)))
#define bM4_DMA1_DNSEQCTL1_DOFFSET19              (*((volatile unsigned int*)(0x42A612CCUL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT0                (*((volatile unsigned int*)(0x42A612D0UL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT1                (*((volatile unsigned int*)(0x42A612D4UL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT2                (*((volatile unsigned int*)(0x42A612D8UL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT3                (*((volatile unsigned int*)(0x42A612DCUL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT4                (*((volatile unsigned int*)(0x42A612E0UL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT5                (*((volatile unsigned int*)(0x42A612E4UL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT6                (*((volatile unsigned int*)(0x42A612E8UL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT7                (*((volatile unsigned int*)(0x42A612ECUL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT8                (*((volatile unsigned int*)(0x42A612F0UL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT9                (*((volatile unsigned int*)(0x42A612F4UL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT10               (*((volatile unsigned int*)(0x42A612F8UL)))
#define bM4_DMA1_DNSEQCTL1_DNSCNT11               (*((volatile unsigned int*)(0x42A612FCUL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST0              (*((volatile unsigned int*)(0x42A61280UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST1              (*((volatile unsigned int*)(0x42A61284UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST2              (*((volatile unsigned int*)(0x42A61288UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST3              (*((volatile unsigned int*)(0x42A6128CUL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST4              (*((volatile unsigned int*)(0x42A61290UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST5              (*((volatile unsigned int*)(0x42A61294UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST6              (*((volatile unsigned int*)(0x42A61298UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST7              (*((volatile unsigned int*)(0x42A6129CUL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST8              (*((volatile unsigned int*)(0x42A612A0UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST9              (*((volatile unsigned int*)(0x42A612A4UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST10             (*((volatile unsigned int*)(0x42A612A8UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST11             (*((volatile unsigned int*)(0x42A612ACUL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST12             (*((volatile unsigned int*)(0x42A612B0UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST13             (*((volatile unsigned int*)(0x42A612B4UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST14             (*((volatile unsigned int*)(0x42A612B8UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST15             (*((volatile unsigned int*)(0x42A612BCUL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST16             (*((volatile unsigned int*)(0x42A612C0UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST17             (*((volatile unsigned int*)(0x42A612C4UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST18             (*((volatile unsigned int*)(0x42A612C8UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSDIST19             (*((volatile unsigned int*)(0x42A612CCUL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB0              (*((volatile unsigned int*)(0x42A612D0UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB1              (*((volatile unsigned int*)(0x42A612D4UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB2              (*((volatile unsigned int*)(0x42A612D8UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB3              (*((volatile unsigned int*)(0x42A612DCUL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB4              (*((volatile unsigned int*)(0x42A612E0UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB5              (*((volatile unsigned int*)(0x42A612E4UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB6              (*((volatile unsigned int*)(0x42A612E8UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB7              (*((volatile unsigned int*)(0x42A612ECUL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB8              (*((volatile unsigned int*)(0x42A612F0UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB9              (*((volatile unsigned int*)(0x42A612F4UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB10             (*((volatile unsigned int*)(0x42A612F8UL)))
#define bM4_DMA1_DNSEQCTLB1_DNSCNTB11             (*((volatile unsigned int*)(0x42A612FCUL)))
#define bM4_DMA1_LLP1_LLP0                        (*((volatile unsigned int*)(0x42A61308UL)))
#define bM4_DMA1_LLP1_LLP1                        (*((volatile unsigned int*)(0x42A6130CUL)))
#define bM4_DMA1_LLP1_LLP2                        (*((volatile unsigned int*)(0x42A61310UL)))
#define bM4_DMA1_LLP1_LLP3                        (*((volatile unsigned int*)(0x42A61314UL)))
#define bM4_DMA1_LLP1_LLP4                        (*((volatile unsigned int*)(0x42A61318UL)))
#define bM4_DMA1_LLP1_LLP5                        (*((volatile unsigned int*)(0x42A6131CUL)))
#define bM4_DMA1_LLP1_LLP6                        (*((volatile unsigned int*)(0x42A61320UL)))
#define bM4_DMA1_LLP1_LLP7                        (*((volatile unsigned int*)(0x42A61324UL)))
#define bM4_DMA1_LLP1_LLP8                        (*((volatile unsigned int*)(0x42A61328UL)))
#define bM4_DMA1_LLP1_LLP9                        (*((volatile unsigned int*)(0x42A6132CUL)))
#define bM4_DMA1_LLP1_LLP10                       (*((volatile unsigned int*)(0x42A61330UL)))
#define bM4_DMA1_LLP1_LLP11                       (*((volatile unsigned int*)(0x42A61334UL)))
#define bM4_DMA1_LLP1_LLP12                       (*((volatile unsigned int*)(0x42A61338UL)))
#define bM4_DMA1_LLP1_LLP13                       (*((volatile unsigned int*)(0x42A6133CUL)))
#define bM4_DMA1_LLP1_LLP14                       (*((volatile unsigned int*)(0x42A61340UL)))
#define bM4_DMA1_LLP1_LLP15                       (*((volatile unsigned int*)(0x42A61344UL)))
#define bM4_DMA1_LLP1_LLP16                       (*((volatile unsigned int*)(0x42A61348UL)))
#define bM4_DMA1_LLP1_LLP17                       (*((volatile unsigned int*)(0x42A6134CUL)))
#define bM4_DMA1_LLP1_LLP18                       (*((volatile unsigned int*)(0x42A61350UL)))
#define bM4_DMA1_LLP1_LLP19                       (*((volatile unsigned int*)(0x42A61354UL)))
#define bM4_DMA1_LLP1_LLP20                       (*((volatile unsigned int*)(0x42A61358UL)))
#define bM4_DMA1_LLP1_LLP21                       (*((volatile unsigned int*)(0x42A6135CUL)))
#define bM4_DMA1_LLP1_LLP22                       (*((volatile unsigned int*)(0x42A61360UL)))
#define bM4_DMA1_LLP1_LLP23                       (*((volatile unsigned int*)(0x42A61364UL)))
#define bM4_DMA1_LLP1_LLP24                       (*((volatile unsigned int*)(0x42A61368UL)))
#define bM4_DMA1_LLP1_LLP25                       (*((volatile unsigned int*)(0x42A6136CUL)))
#define bM4_DMA1_LLP1_LLP26                       (*((volatile unsigned int*)(0x42A61370UL)))
#define bM4_DMA1_LLP1_LLP27                       (*((volatile unsigned int*)(0x42A61374UL)))
#define bM4_DMA1_LLP1_LLP28                       (*((volatile unsigned int*)(0x42A61378UL)))
#define bM4_DMA1_LLP1_LLP29                       (*((volatile unsigned int*)(0x42A6137CUL)))
#define bM4_DMA1_CHCTL1_SINC0                     (*((volatile unsigned int*)(0x42A61380UL)))
#define bM4_DMA1_CHCTL1_SINC1                     (*((volatile unsigned int*)(0x42A61384UL)))
#define bM4_DMA1_CHCTL1_DINC0                     (*((volatile unsigned int*)(0x42A61388UL)))
#define bM4_DMA1_CHCTL1_DINC1                     (*((volatile unsigned int*)(0x42A6138CUL)))
#define bM4_DMA1_CHCTL1_SRPTEN                    (*((volatile unsigned int*)(0x42A61390UL)))
#define bM4_DMA1_CHCTL1_DRPTEN                    (*((volatile unsigned int*)(0x42A61394UL)))
#define bM4_DMA1_CHCTL1_SNSEQEN                   (*((volatile unsigned int*)(0x42A61398UL)))
#define bM4_DMA1_CHCTL1_DNSEQEN                   (*((volatile unsigned int*)(0x42A6139CUL)))
#define bM4_DMA1_CHCTL1_HSIZE0                    (*((volatile unsigned int*)(0x42A613A0UL)))
#define bM4_DMA1_CHCTL1_HSIZE1                    (*((volatile unsigned int*)(0x42A613A4UL)))
#define bM4_DMA1_CHCTL1_LLPEN                     (*((volatile unsigned int*)(0x42A613A8UL)))
#define bM4_DMA1_CHCTL1_LLPRUN                    (*((volatile unsigned int*)(0x42A613ACUL)))
#define bM4_DMA1_CHCTL1_IE                        (*((volatile unsigned int*)(0x42A613B0UL)))
#define bM4_DMA1_MONDTCTL1_BLKSIZE0               (*((volatile unsigned int*)(0x42A61500UL)))
#define bM4_DMA1_MONDTCTL1_BLKSIZE1               (*((volatile unsigned int*)(0x42A61504UL)))
#define bM4_DMA1_MONDTCTL1_BLKSIZE2               (*((volatile unsigned int*)(0x42A61508UL)))
#define bM4_DMA1_MONDTCTL1_BLKSIZE3               (*((volatile unsigned int*)(0x42A6150CUL)))
#define bM4_DMA1_MONDTCTL1_BLKSIZE4               (*((volatile unsigned int*)(0x42A61510UL)))
#define bM4_DMA1_MONDTCTL1_BLKSIZE5               (*((volatile unsigned int*)(0x42A61514UL)))
#define bM4_DMA1_MONDTCTL1_BLKSIZE6               (*((volatile unsigned int*)(0x42A61518UL)))
#define bM4_DMA1_MONDTCTL1_BLKSIZE7               (*((volatile unsigned int*)(0x42A6151CUL)))
#define bM4_DMA1_MONDTCTL1_BLKSIZE8               (*((volatile unsigned int*)(0x42A61520UL)))
#define bM4_DMA1_MONDTCTL1_BLKSIZE9               (*((volatile unsigned int*)(0x42A61524UL)))
#define bM4_DMA1_MONDTCTL1_CNT0                   (*((volatile unsigned int*)(0x42A61540UL)))
#define bM4_DMA1_MONDTCTL1_CNT1                   (*((volatile unsigned int*)(0x42A61544UL)))
#define bM4_DMA1_MONDTCTL1_CNT2                   (*((volatile unsigned int*)(0x42A61548UL)))
#define bM4_DMA1_MONDTCTL1_CNT3                   (*((volatile unsigned int*)(0x42A6154CUL)))
#define bM4_DMA1_MONDTCTL1_CNT4                   (*((volatile unsigned int*)(0x42A61550UL)))
#define bM4_DMA1_MONDTCTL1_CNT5                   (*((volatile unsigned int*)(0x42A61554UL)))
#define bM4_DMA1_MONDTCTL1_CNT6                   (*((volatile unsigned int*)(0x42A61558UL)))
#define bM4_DMA1_MONDTCTL1_CNT7                   (*((volatile unsigned int*)(0x42A6155CUL)))
#define bM4_DMA1_MONDTCTL1_CNT8                   (*((volatile unsigned int*)(0x42A61560UL)))
#define bM4_DMA1_MONDTCTL1_CNT9                   (*((volatile unsigned int*)(0x42A61564UL)))
#define bM4_DMA1_MONDTCTL1_CNT10                  (*((volatile unsigned int*)(0x42A61568UL)))
#define bM4_DMA1_MONDTCTL1_CNT11                  (*((volatile unsigned int*)(0x42A6156CUL)))
#define bM4_DMA1_MONDTCTL1_CNT12                  (*((volatile unsigned int*)(0x42A61570UL)))
#define bM4_DMA1_MONDTCTL1_CNT13                  (*((volatile unsigned int*)(0x42A61574UL)))
#define bM4_DMA1_MONDTCTL1_CNT14                  (*((volatile unsigned int*)(0x42A61578UL)))
#define bM4_DMA1_MONDTCTL1_CNT15                  (*((volatile unsigned int*)(0x42A6157CUL)))
#define bM4_DMA1_MONRPT1_SRPT0                    (*((volatile unsigned int*)(0x42A61580UL)))
#define bM4_DMA1_MONRPT1_SRPT1                    (*((volatile unsigned int*)(0x42A61584UL)))
#define bM4_DMA1_MONRPT1_SRPT2                    (*((volatile unsigned int*)(0x42A61588UL)))
#define bM4_DMA1_MONRPT1_SRPT3                    (*((volatile unsigned int*)(0x42A6158CUL)))
#define bM4_DMA1_MONRPT1_SRPT4                    (*((volatile unsigned int*)(0x42A61590UL)))
#define bM4_DMA1_MONRPT1_SRPT5                    (*((volatile unsigned int*)(0x42A61594UL)))
#define bM4_DMA1_MONRPT1_SRPT6                    (*((volatile unsigned int*)(0x42A61598UL)))
#define bM4_DMA1_MONRPT1_SRPT7                    (*((volatile unsigned int*)(0x42A6159CUL)))
#define bM4_DMA1_MONRPT1_SRPT8                    (*((volatile unsigned int*)(0x42A615A0UL)))
#define bM4_DMA1_MONRPT1_SRPT9                    (*((volatile unsigned int*)(0x42A615A4UL)))
#define bM4_DMA1_MONRPT1_DRPT0                    (*((volatile unsigned int*)(0x42A615C0UL)))
#define bM4_DMA1_MONRPT1_DRPT1                    (*((volatile unsigned int*)(0x42A615C4UL)))
#define bM4_DMA1_MONRPT1_DRPT2                    (*((volatile unsigned int*)(0x42A615C8UL)))
#define bM4_DMA1_MONRPT1_DRPT3                    (*((volatile unsigned int*)(0x42A615CCUL)))
#define bM4_DMA1_MONRPT1_DRPT4                    (*((volatile unsigned int*)(0x42A615D0UL)))
#define bM4_DMA1_MONRPT1_DRPT5                    (*((volatile unsigned int*)(0x42A615D4UL)))
#define bM4_DMA1_MONRPT1_DRPT6                    (*((volatile unsigned int*)(0x42A615D8UL)))
#define bM4_DMA1_MONRPT1_DRPT7                    (*((volatile unsigned int*)(0x42A615DCUL)))
#define bM4_DMA1_MONRPT1_DRPT8                    (*((volatile unsigned int*)(0x42A615E0UL)))
#define bM4_DMA1_MONRPT1_DRPT9                    (*((volatile unsigned int*)(0x42A615E4UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET0            (*((volatile unsigned int*)(0x42A61600UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET1            (*((volatile unsigned int*)(0x42A61604UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET2            (*((volatile unsigned int*)(0x42A61608UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET3            (*((volatile unsigned int*)(0x42A6160CUL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET4            (*((volatile unsigned int*)(0x42A61610UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET5            (*((volatile unsigned int*)(0x42A61614UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET6            (*((volatile unsigned int*)(0x42A61618UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET7            (*((volatile unsigned int*)(0x42A6161CUL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET8            (*((volatile unsigned int*)(0x42A61620UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET9            (*((volatile unsigned int*)(0x42A61624UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET10           (*((volatile unsigned int*)(0x42A61628UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET11           (*((volatile unsigned int*)(0x42A6162CUL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET12           (*((volatile unsigned int*)(0x42A61630UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET13           (*((volatile unsigned int*)(0x42A61634UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET14           (*((volatile unsigned int*)(0x42A61638UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET15           (*((volatile unsigned int*)(0x42A6163CUL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET16           (*((volatile unsigned int*)(0x42A61640UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET17           (*((volatile unsigned int*)(0x42A61644UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET18           (*((volatile unsigned int*)(0x42A61648UL)))
#define bM4_DMA1_MONSNSEQCTL1_SOFFSET19           (*((volatile unsigned int*)(0x42A6164CUL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT0             (*((volatile unsigned int*)(0x42A61650UL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT1             (*((volatile unsigned int*)(0x42A61654UL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT2             (*((volatile unsigned int*)(0x42A61658UL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT3             (*((volatile unsigned int*)(0x42A6165CUL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT4             (*((volatile unsigned int*)(0x42A61660UL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT5             (*((volatile unsigned int*)(0x42A61664UL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT6             (*((volatile unsigned int*)(0x42A61668UL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT7             (*((volatile unsigned int*)(0x42A6166CUL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT8             (*((volatile unsigned int*)(0x42A61670UL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT9             (*((volatile unsigned int*)(0x42A61674UL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT10            (*((volatile unsigned int*)(0x42A61678UL)))
#define bM4_DMA1_MONSNSEQCTL1_SNSCNT11            (*((volatile unsigned int*)(0x42A6167CUL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET0            (*((volatile unsigned int*)(0x42A61680UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET1            (*((volatile unsigned int*)(0x42A61684UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET2            (*((volatile unsigned int*)(0x42A61688UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET3            (*((volatile unsigned int*)(0x42A6168CUL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET4            (*((volatile unsigned int*)(0x42A61690UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET5            (*((volatile unsigned int*)(0x42A61694UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET6            (*((volatile unsigned int*)(0x42A61698UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET7            (*((volatile unsigned int*)(0x42A6169CUL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET8            (*((volatile unsigned int*)(0x42A616A0UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET9            (*((volatile unsigned int*)(0x42A616A4UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET10           (*((volatile unsigned int*)(0x42A616A8UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET11           (*((volatile unsigned int*)(0x42A616ACUL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET12           (*((volatile unsigned int*)(0x42A616B0UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET13           (*((volatile unsigned int*)(0x42A616B4UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET14           (*((volatile unsigned int*)(0x42A616B8UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET15           (*((volatile unsigned int*)(0x42A616BCUL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET16           (*((volatile unsigned int*)(0x42A616C0UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET17           (*((volatile unsigned int*)(0x42A616C4UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET18           (*((volatile unsigned int*)(0x42A616C8UL)))
#define bM4_DMA1_MONDNSEQCTL1_DOFFSET19           (*((volatile unsigned int*)(0x42A616CCUL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT0             (*((volatile unsigned int*)(0x42A616D0UL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT1             (*((volatile unsigned int*)(0x42A616D4UL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT2             (*((volatile unsigned int*)(0x42A616D8UL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT3             (*((volatile unsigned int*)(0x42A616DCUL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT4             (*((volatile unsigned int*)(0x42A616E0UL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT5             (*((volatile unsigned int*)(0x42A616E4UL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT6             (*((volatile unsigned int*)(0x42A616E8UL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT7             (*((volatile unsigned int*)(0x42A616ECUL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT8             (*((volatile unsigned int*)(0x42A616F0UL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT9             (*((volatile unsigned int*)(0x42A616F4UL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT10            (*((volatile unsigned int*)(0x42A616F8UL)))
#define bM4_DMA1_MONDNSEQCTL1_DNSCNT11            (*((volatile unsigned int*)(0x42A616FCUL)))
#define bM4_DMA1_DTCTL2_BLKSIZE0                  (*((volatile unsigned int*)(0x42A61900UL)))
#define bM4_DMA1_DTCTL2_BLKSIZE1                  (*((volatile unsigned int*)(0x42A61904UL)))
#define bM4_DMA1_DTCTL2_BLKSIZE2                  (*((volatile unsigned int*)(0x42A61908UL)))
#define bM4_DMA1_DTCTL2_BLKSIZE3                  (*((volatile unsigned int*)(0x42A6190CUL)))
#define bM4_DMA1_DTCTL2_BLKSIZE4                  (*((volatile unsigned int*)(0x42A61910UL)))
#define bM4_DMA1_DTCTL2_BLKSIZE5                  (*((volatile unsigned int*)(0x42A61914UL)))
#define bM4_DMA1_DTCTL2_BLKSIZE6                  (*((volatile unsigned int*)(0x42A61918UL)))
#define bM4_DMA1_DTCTL2_BLKSIZE7                  (*((volatile unsigned int*)(0x42A6191CUL)))
#define bM4_DMA1_DTCTL2_BLKSIZE8                  (*((volatile unsigned int*)(0x42A61920UL)))
#define bM4_DMA1_DTCTL2_BLKSIZE9                  (*((volatile unsigned int*)(0x42A61924UL)))
#define bM4_DMA1_DTCTL2_CNT0                      (*((volatile unsigned int*)(0x42A61940UL)))
#define bM4_DMA1_DTCTL2_CNT1                      (*((volatile unsigned int*)(0x42A61944UL)))
#define bM4_DMA1_DTCTL2_CNT2                      (*((volatile unsigned int*)(0x42A61948UL)))
#define bM4_DMA1_DTCTL2_CNT3                      (*((volatile unsigned int*)(0x42A6194CUL)))
#define bM4_DMA1_DTCTL2_CNT4                      (*((volatile unsigned int*)(0x42A61950UL)))
#define bM4_DMA1_DTCTL2_CNT5                      (*((volatile unsigned int*)(0x42A61954UL)))
#define bM4_DMA1_DTCTL2_CNT6                      (*((volatile unsigned int*)(0x42A61958UL)))
#define bM4_DMA1_DTCTL2_CNT7                      (*((volatile unsigned int*)(0x42A6195CUL)))
#define bM4_DMA1_DTCTL2_CNT8                      (*((volatile unsigned int*)(0x42A61960UL)))
#define bM4_DMA1_DTCTL2_CNT9                      (*((volatile unsigned int*)(0x42A61964UL)))
#define bM4_DMA1_DTCTL2_CNT10                     (*((volatile unsigned int*)(0x42A61968UL)))
#define bM4_DMA1_DTCTL2_CNT11                     (*((volatile unsigned int*)(0x42A6196CUL)))
#define bM4_DMA1_DTCTL2_CNT12                     (*((volatile unsigned int*)(0x42A61970UL)))
#define bM4_DMA1_DTCTL2_CNT13                     (*((volatile unsigned int*)(0x42A61974UL)))
#define bM4_DMA1_DTCTL2_CNT14                     (*((volatile unsigned int*)(0x42A61978UL)))
#define bM4_DMA1_DTCTL2_CNT15                     (*((volatile unsigned int*)(0x42A6197CUL)))
#define bM4_DMA1_RPT2_SRPT0                       (*((volatile unsigned int*)(0x42A61980UL)))
#define bM4_DMA1_RPT2_SRPT1                       (*((volatile unsigned int*)(0x42A61984UL)))
#define bM4_DMA1_RPT2_SRPT2                       (*((volatile unsigned int*)(0x42A61988UL)))
#define bM4_DMA1_RPT2_SRPT3                       (*((volatile unsigned int*)(0x42A6198CUL)))
#define bM4_DMA1_RPT2_SRPT4                       (*((volatile unsigned int*)(0x42A61990UL)))
#define bM4_DMA1_RPT2_SRPT5                       (*((volatile unsigned int*)(0x42A61994UL)))
#define bM4_DMA1_RPT2_SRPT6                       (*((volatile unsigned int*)(0x42A61998UL)))
#define bM4_DMA1_RPT2_SRPT7                       (*((volatile unsigned int*)(0x42A6199CUL)))
#define bM4_DMA1_RPT2_SRPT8                       (*((volatile unsigned int*)(0x42A619A0UL)))
#define bM4_DMA1_RPT2_SRPT9                       (*((volatile unsigned int*)(0x42A619A4UL)))
#define bM4_DMA1_RPT2_DRPT0                       (*((volatile unsigned int*)(0x42A619C0UL)))
#define bM4_DMA1_RPT2_DRPT1                       (*((volatile unsigned int*)(0x42A619C4UL)))
#define bM4_DMA1_RPT2_DRPT2                       (*((volatile unsigned int*)(0x42A619C8UL)))
#define bM4_DMA1_RPT2_DRPT3                       (*((volatile unsigned int*)(0x42A619CCUL)))
#define bM4_DMA1_RPT2_DRPT4                       (*((volatile unsigned int*)(0x42A619D0UL)))
#define bM4_DMA1_RPT2_DRPT5                       (*((volatile unsigned int*)(0x42A619D4UL)))
#define bM4_DMA1_RPT2_DRPT6                       (*((volatile unsigned int*)(0x42A619D8UL)))
#define bM4_DMA1_RPT2_DRPT7                       (*((volatile unsigned int*)(0x42A619DCUL)))
#define bM4_DMA1_RPT2_DRPT8                       (*((volatile unsigned int*)(0x42A619E0UL)))
#define bM4_DMA1_RPT2_DRPT9                       (*((volatile unsigned int*)(0x42A619E4UL)))
#define bM4_DMA1_RPTB2_SRPTB0                     (*((volatile unsigned int*)(0x42A61980UL)))
#define bM4_DMA1_RPTB2_SRPTB1                     (*((volatile unsigned int*)(0x42A61984UL)))
#define bM4_DMA1_RPTB2_SRPTB2                     (*((volatile unsigned int*)(0x42A61988UL)))
#define bM4_DMA1_RPTB2_SRPTB3                     (*((volatile unsigned int*)(0x42A6198CUL)))
#define bM4_DMA1_RPTB2_SRPTB4                     (*((volatile unsigned int*)(0x42A61990UL)))
#define bM4_DMA1_RPTB2_SRPTB5                     (*((volatile unsigned int*)(0x42A61994UL)))
#define bM4_DMA1_RPTB2_SRPTB6                     (*((volatile unsigned int*)(0x42A61998UL)))
#define bM4_DMA1_RPTB2_SRPTB7                     (*((volatile unsigned int*)(0x42A6199CUL)))
#define bM4_DMA1_RPTB2_SRPTB8                     (*((volatile unsigned int*)(0x42A619A0UL)))
#define bM4_DMA1_RPTB2_SRPTB9                     (*((volatile unsigned int*)(0x42A619A4UL)))
#define bM4_DMA1_RPTB2_DRPTB0                     (*((volatile unsigned int*)(0x42A619C0UL)))
#define bM4_DMA1_RPTB2_DRPTB1                     (*((volatile unsigned int*)(0x42A619C4UL)))
#define bM4_DMA1_RPTB2_DRPTB2                     (*((volatile unsigned int*)(0x42A619C8UL)))
#define bM4_DMA1_RPTB2_DRPTB3                     (*((volatile unsigned int*)(0x42A619CCUL)))
#define bM4_DMA1_RPTB2_DRPTB4                     (*((volatile unsigned int*)(0x42A619D0UL)))
#define bM4_DMA1_RPTB2_DRPTB5                     (*((volatile unsigned int*)(0x42A619D4UL)))
#define bM4_DMA1_RPTB2_DRPTB6                     (*((volatile unsigned int*)(0x42A619D8UL)))
#define bM4_DMA1_RPTB2_DRPTB7                     (*((volatile unsigned int*)(0x42A619DCUL)))
#define bM4_DMA1_RPTB2_DRPTB8                     (*((volatile unsigned int*)(0x42A619E0UL)))
#define bM4_DMA1_RPTB2_DRPTB9                     (*((volatile unsigned int*)(0x42A619E4UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET0               (*((volatile unsigned int*)(0x42A61A00UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET1               (*((volatile unsigned int*)(0x42A61A04UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET2               (*((volatile unsigned int*)(0x42A61A08UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET3               (*((volatile unsigned int*)(0x42A61A0CUL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET4               (*((volatile unsigned int*)(0x42A61A10UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET5               (*((volatile unsigned int*)(0x42A61A14UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET6               (*((volatile unsigned int*)(0x42A61A18UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET7               (*((volatile unsigned int*)(0x42A61A1CUL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET8               (*((volatile unsigned int*)(0x42A61A20UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET9               (*((volatile unsigned int*)(0x42A61A24UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET10              (*((volatile unsigned int*)(0x42A61A28UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET11              (*((volatile unsigned int*)(0x42A61A2CUL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET12              (*((volatile unsigned int*)(0x42A61A30UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET13              (*((volatile unsigned int*)(0x42A61A34UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET14              (*((volatile unsigned int*)(0x42A61A38UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET15              (*((volatile unsigned int*)(0x42A61A3CUL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET16              (*((volatile unsigned int*)(0x42A61A40UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET17              (*((volatile unsigned int*)(0x42A61A44UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET18              (*((volatile unsigned int*)(0x42A61A48UL)))
#define bM4_DMA1_SNSEQCTL2_SOFFSET19              (*((volatile unsigned int*)(0x42A61A4CUL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT0                (*((volatile unsigned int*)(0x42A61A50UL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT1                (*((volatile unsigned int*)(0x42A61A54UL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT2                (*((volatile unsigned int*)(0x42A61A58UL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT3                (*((volatile unsigned int*)(0x42A61A5CUL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT4                (*((volatile unsigned int*)(0x42A61A60UL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT5                (*((volatile unsigned int*)(0x42A61A64UL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT6                (*((volatile unsigned int*)(0x42A61A68UL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT7                (*((volatile unsigned int*)(0x42A61A6CUL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT8                (*((volatile unsigned int*)(0x42A61A70UL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT9                (*((volatile unsigned int*)(0x42A61A74UL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT10               (*((volatile unsigned int*)(0x42A61A78UL)))
#define bM4_DMA1_SNSEQCTL2_SNSCNT11               (*((volatile unsigned int*)(0x42A61A7CUL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST0              (*((volatile unsigned int*)(0x42A61A00UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST1              (*((volatile unsigned int*)(0x42A61A04UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST2              (*((volatile unsigned int*)(0x42A61A08UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST3              (*((volatile unsigned int*)(0x42A61A0CUL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST4              (*((volatile unsigned int*)(0x42A61A10UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST5              (*((volatile unsigned int*)(0x42A61A14UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST6              (*((volatile unsigned int*)(0x42A61A18UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST7              (*((volatile unsigned int*)(0x42A61A1CUL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST8              (*((volatile unsigned int*)(0x42A61A20UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST9              (*((volatile unsigned int*)(0x42A61A24UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST10             (*((volatile unsigned int*)(0x42A61A28UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST11             (*((volatile unsigned int*)(0x42A61A2CUL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST12             (*((volatile unsigned int*)(0x42A61A30UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST13             (*((volatile unsigned int*)(0x42A61A34UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST14             (*((volatile unsigned int*)(0x42A61A38UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST15             (*((volatile unsigned int*)(0x42A61A3CUL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST16             (*((volatile unsigned int*)(0x42A61A40UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST17             (*((volatile unsigned int*)(0x42A61A44UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST18             (*((volatile unsigned int*)(0x42A61A48UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSDIST19             (*((volatile unsigned int*)(0x42A61A4CUL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB0              (*((volatile unsigned int*)(0x42A61A50UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB1              (*((volatile unsigned int*)(0x42A61A54UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB2              (*((volatile unsigned int*)(0x42A61A58UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB3              (*((volatile unsigned int*)(0x42A61A5CUL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB4              (*((volatile unsigned int*)(0x42A61A60UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB5              (*((volatile unsigned int*)(0x42A61A64UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB6              (*((volatile unsigned int*)(0x42A61A68UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB7              (*((volatile unsigned int*)(0x42A61A6CUL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB8              (*((volatile unsigned int*)(0x42A61A70UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB9              (*((volatile unsigned int*)(0x42A61A74UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB10             (*((volatile unsigned int*)(0x42A61A78UL)))
#define bM4_DMA1_SNSEQCTLB2_SNSCNTB11             (*((volatile unsigned int*)(0x42A61A7CUL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET0               (*((volatile unsigned int*)(0x42A61A80UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET1               (*((volatile unsigned int*)(0x42A61A84UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET2               (*((volatile unsigned int*)(0x42A61A88UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET3               (*((volatile unsigned int*)(0x42A61A8CUL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET4               (*((volatile unsigned int*)(0x42A61A90UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET5               (*((volatile unsigned int*)(0x42A61A94UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET6               (*((volatile unsigned int*)(0x42A61A98UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET7               (*((volatile unsigned int*)(0x42A61A9CUL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET8               (*((volatile unsigned int*)(0x42A61AA0UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET9               (*((volatile unsigned int*)(0x42A61AA4UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET10              (*((volatile unsigned int*)(0x42A61AA8UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET11              (*((volatile unsigned int*)(0x42A61AACUL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET12              (*((volatile unsigned int*)(0x42A61AB0UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET13              (*((volatile unsigned int*)(0x42A61AB4UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET14              (*((volatile unsigned int*)(0x42A61AB8UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET15              (*((volatile unsigned int*)(0x42A61ABCUL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET16              (*((volatile unsigned int*)(0x42A61AC0UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET17              (*((volatile unsigned int*)(0x42A61AC4UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET18              (*((volatile unsigned int*)(0x42A61AC8UL)))
#define bM4_DMA1_DNSEQCTL2_DOFFSET19              (*((volatile unsigned int*)(0x42A61ACCUL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT0                (*((volatile unsigned int*)(0x42A61AD0UL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT1                (*((volatile unsigned int*)(0x42A61AD4UL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT2                (*((volatile unsigned int*)(0x42A61AD8UL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT3                (*((volatile unsigned int*)(0x42A61ADCUL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT4                (*((volatile unsigned int*)(0x42A61AE0UL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT5                (*((volatile unsigned int*)(0x42A61AE4UL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT6                (*((volatile unsigned int*)(0x42A61AE8UL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT7                (*((volatile unsigned int*)(0x42A61AECUL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT8                (*((volatile unsigned int*)(0x42A61AF0UL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT9                (*((volatile unsigned int*)(0x42A61AF4UL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT10               (*((volatile unsigned int*)(0x42A61AF8UL)))
#define bM4_DMA1_DNSEQCTL2_DNSCNT11               (*((volatile unsigned int*)(0x42A61AFCUL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST0              (*((volatile unsigned int*)(0x42A61A80UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST1              (*((volatile unsigned int*)(0x42A61A84UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST2              (*((volatile unsigned int*)(0x42A61A88UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST3              (*((volatile unsigned int*)(0x42A61A8CUL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST4              (*((volatile unsigned int*)(0x42A61A90UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST5              (*((volatile unsigned int*)(0x42A61A94UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST6              (*((volatile unsigned int*)(0x42A61A98UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST7              (*((volatile unsigned int*)(0x42A61A9CUL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST8              (*((volatile unsigned int*)(0x42A61AA0UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST9              (*((volatile unsigned int*)(0x42A61AA4UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST10             (*((volatile unsigned int*)(0x42A61AA8UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST11             (*((volatile unsigned int*)(0x42A61AACUL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST12             (*((volatile unsigned int*)(0x42A61AB0UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST13             (*((volatile unsigned int*)(0x42A61AB4UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST14             (*((volatile unsigned int*)(0x42A61AB8UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST15             (*((volatile unsigned int*)(0x42A61ABCUL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST16             (*((volatile unsigned int*)(0x42A61AC0UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST17             (*((volatile unsigned int*)(0x42A61AC4UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST18             (*((volatile unsigned int*)(0x42A61AC8UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSDIST19             (*((volatile unsigned int*)(0x42A61ACCUL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB0              (*((volatile unsigned int*)(0x42A61AD0UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB1              (*((volatile unsigned int*)(0x42A61AD4UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB2              (*((volatile unsigned int*)(0x42A61AD8UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB3              (*((volatile unsigned int*)(0x42A61ADCUL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB4              (*((volatile unsigned int*)(0x42A61AE0UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB5              (*((volatile unsigned int*)(0x42A61AE4UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB6              (*((volatile unsigned int*)(0x42A61AE8UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB7              (*((volatile unsigned int*)(0x42A61AECUL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB8              (*((volatile unsigned int*)(0x42A61AF0UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB9              (*((volatile unsigned int*)(0x42A61AF4UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB10             (*((volatile unsigned int*)(0x42A61AF8UL)))
#define bM4_DMA1_DNSEQCTLB2_DNSCNTB11             (*((volatile unsigned int*)(0x42A61AFCUL)))
#define bM4_DMA1_LLP2_LLP0                        (*((volatile unsigned int*)(0x42A61B08UL)))
#define bM4_DMA1_LLP2_LLP1                        (*((volatile unsigned int*)(0x42A61B0CUL)))
#define bM4_DMA1_LLP2_LLP2                        (*((volatile unsigned int*)(0x42A61B10UL)))
#define bM4_DMA1_LLP2_LLP3                        (*((volatile unsigned int*)(0x42A61B14UL)))
#define bM4_DMA1_LLP2_LLP4                        (*((volatile unsigned int*)(0x42A61B18UL)))
#define bM4_DMA1_LLP2_LLP5                        (*((volatile unsigned int*)(0x42A61B1CUL)))
#define bM4_DMA1_LLP2_LLP6                        (*((volatile unsigned int*)(0x42A61B20UL)))
#define bM4_DMA1_LLP2_LLP7                        (*((volatile unsigned int*)(0x42A61B24UL)))
#define bM4_DMA1_LLP2_LLP8                        (*((volatile unsigned int*)(0x42A61B28UL)))
#define bM4_DMA1_LLP2_LLP9                        (*((volatile unsigned int*)(0x42A61B2CUL)))
#define bM4_DMA1_LLP2_LLP10                       (*((volatile unsigned int*)(0x42A61B30UL)))
#define bM4_DMA1_LLP2_LLP11                       (*((volatile unsigned int*)(0x42A61B34UL)))
#define bM4_DMA1_LLP2_LLP12                       (*((volatile unsigned int*)(0x42A61B38UL)))
#define bM4_DMA1_LLP2_LLP13                       (*((volatile unsigned int*)(0x42A61B3CUL)))
#define bM4_DMA1_LLP2_LLP14                       (*((volatile unsigned int*)(0x42A61B40UL)))
#define bM4_DMA1_LLP2_LLP15                       (*((volatile unsigned int*)(0x42A61B44UL)))
#define bM4_DMA1_LLP2_LLP16                       (*((volatile unsigned int*)(0x42A61B48UL)))
#define bM4_DMA1_LLP2_LLP17                       (*((volatile unsigned int*)(0x42A61B4CUL)))
#define bM4_DMA1_LLP2_LLP18                       (*((volatile unsigned int*)(0x42A61B50UL)))
#define bM4_DMA1_LLP2_LLP19                       (*((volatile unsigned int*)(0x42A61B54UL)))
#define bM4_DMA1_LLP2_LLP20                       (*((volatile unsigned int*)(0x42A61B58UL)))
#define bM4_DMA1_LLP2_LLP21                       (*((volatile unsigned int*)(0x42A61B5CUL)))
#define bM4_DMA1_LLP2_LLP22                       (*((volatile unsigned int*)(0x42A61B60UL)))
#define bM4_DMA1_LLP2_LLP23                       (*((volatile unsigned int*)(0x42A61B64UL)))
#define bM4_DMA1_LLP2_LLP24                       (*((volatile unsigned int*)(0x42A61B68UL)))
#define bM4_DMA1_LLP2_LLP25                       (*((volatile unsigned int*)(0x42A61B6CUL)))
#define bM4_DMA1_LLP2_LLP26                       (*((volatile unsigned int*)(0x42A61B70UL)))
#define bM4_DMA1_LLP2_LLP27                       (*((volatile unsigned int*)(0x42A61B74UL)))
#define bM4_DMA1_LLP2_LLP28                       (*((volatile unsigned int*)(0x42A61B78UL)))
#define bM4_DMA1_LLP2_LLP29                       (*((volatile unsigned int*)(0x42A61B7CUL)))
#define bM4_DMA1_CHCTL2_SINC0                     (*((volatile unsigned int*)(0x42A61B80UL)))
#define bM4_DMA1_CHCTL2_SINC1                     (*((volatile unsigned int*)(0x42A61B84UL)))
#define bM4_DMA1_CHCTL2_DINC0                     (*((volatile unsigned int*)(0x42A61B88UL)))
#define bM4_DMA1_CHCTL2_DINC1                     (*((volatile unsigned int*)(0x42A61B8CUL)))
#define bM4_DMA1_CHCTL2_SRPTEN                    (*((volatile unsigned int*)(0x42A61B90UL)))
#define bM4_DMA1_CHCTL2_DRPTEN                    (*((volatile unsigned int*)(0x42A61B94UL)))
#define bM4_DMA1_CHCTL2_SNSEQEN                   (*((volatile unsigned int*)(0x42A61B98UL)))
#define bM4_DMA1_CHCTL2_DNSEQEN                   (*((volatile unsigned int*)(0x42A61B9CUL)))
#define bM4_DMA1_CHCTL2_HSIZE0                    (*((volatile unsigned int*)(0x42A61BA0UL)))
#define bM4_DMA1_CHCTL2_HSIZE1                    (*((volatile unsigned int*)(0x42A61BA4UL)))
#define bM4_DMA1_CHCTL2_LLPEN                     (*((volatile unsigned int*)(0x42A61BA8UL)))
#define bM4_DMA1_CHCTL2_LLPRUN                    (*((volatile unsigned int*)(0x42A61BACUL)))
#define bM4_DMA1_CHCTL2_IE                        (*((volatile unsigned int*)(0x42A61BB0UL)))
#define bM4_DMA1_MONDTCTL2_BLKSIZE0               (*((volatile unsigned int*)(0x42A61D00UL)))
#define bM4_DMA1_MONDTCTL2_BLKSIZE1               (*((volatile unsigned int*)(0x42A61D04UL)))
#define bM4_DMA1_MONDTCTL2_BLKSIZE2               (*((volatile unsigned int*)(0x42A61D08UL)))
#define bM4_DMA1_MONDTCTL2_BLKSIZE3               (*((volatile unsigned int*)(0x42A61D0CUL)))
#define bM4_DMA1_MONDTCTL2_BLKSIZE4               (*((volatile unsigned int*)(0x42A61D10UL)))
#define bM4_DMA1_MONDTCTL2_BLKSIZE5               (*((volatile unsigned int*)(0x42A61D14UL)))
#define bM4_DMA1_MONDTCTL2_BLKSIZE6               (*((volatile unsigned int*)(0x42A61D18UL)))
#define bM4_DMA1_MONDTCTL2_BLKSIZE7               (*((volatile unsigned int*)(0x42A61D1CUL)))
#define bM4_DMA1_MONDTCTL2_BLKSIZE8               (*((volatile unsigned int*)(0x42A61D20UL)))
#define bM4_DMA1_MONDTCTL2_BLKSIZE9               (*((volatile unsigned int*)(0x42A61D24UL)))
#define bM4_DMA1_MONDTCTL2_CNT0                   (*((volatile unsigned int*)(0x42A61D40UL)))
#define bM4_DMA1_MONDTCTL2_CNT1                   (*((volatile unsigned int*)(0x42A61D44UL)))
#define bM4_DMA1_MONDTCTL2_CNT2                   (*((volatile unsigned int*)(0x42A61D48UL)))
#define bM4_DMA1_MONDTCTL2_CNT3                   (*((volatile unsigned int*)(0x42A61D4CUL)))
#define bM4_DMA1_MONDTCTL2_CNT4                   (*((volatile unsigned int*)(0x42A61D50UL)))
#define bM4_DMA1_MONDTCTL2_CNT5                   (*((volatile unsigned int*)(0x42A61D54UL)))
#define bM4_DMA1_MONDTCTL2_CNT6                   (*((volatile unsigned int*)(0x42A61D58UL)))
#define bM4_DMA1_MONDTCTL2_CNT7                   (*((volatile unsigned int*)(0x42A61D5CUL)))
#define bM4_DMA1_MONDTCTL2_CNT8                   (*((volatile unsigned int*)(0x42A61D60UL)))
#define bM4_DMA1_MONDTCTL2_CNT9                   (*((volatile unsigned int*)(0x42A61D64UL)))
#define bM4_DMA1_MONDTCTL2_CNT10                  (*((volatile unsigned int*)(0x42A61D68UL)))
#define bM4_DMA1_MONDTCTL2_CNT11                  (*((volatile unsigned int*)(0x42A61D6CUL)))
#define bM4_DMA1_MONDTCTL2_CNT12                  (*((volatile unsigned int*)(0x42A61D70UL)))
#define bM4_DMA1_MONDTCTL2_CNT13                  (*((volatile unsigned int*)(0x42A61D74UL)))
#define bM4_DMA1_MONDTCTL2_CNT14                  (*((volatile unsigned int*)(0x42A61D78UL)))
#define bM4_DMA1_MONDTCTL2_CNT15                  (*((volatile unsigned int*)(0x42A61D7CUL)))
#define bM4_DMA1_MONRPT2_SRPT0                    (*((volatile unsigned int*)(0x42A61D80UL)))
#define bM4_DMA1_MONRPT2_SRPT1                    (*((volatile unsigned int*)(0x42A61D84UL)))
#define bM4_DMA1_MONRPT2_SRPT2                    (*((volatile unsigned int*)(0x42A61D88UL)))
#define bM4_DMA1_MONRPT2_SRPT3                    (*((volatile unsigned int*)(0x42A61D8CUL)))
#define bM4_DMA1_MONRPT2_SRPT4                    (*((volatile unsigned int*)(0x42A61D90UL)))
#define bM4_DMA1_MONRPT2_SRPT5                    (*((volatile unsigned int*)(0x42A61D94UL)))
#define bM4_DMA1_MONRPT2_SRPT6                    (*((volatile unsigned int*)(0x42A61D98UL)))
#define bM4_DMA1_MONRPT2_SRPT7                    (*((volatile unsigned int*)(0x42A61D9CUL)))
#define bM4_DMA1_MONRPT2_SRPT8                    (*((volatile unsigned int*)(0x42A61DA0UL)))
#define bM4_DMA1_MONRPT2_SRPT9                    (*((volatile unsigned int*)(0x42A61DA4UL)))
#define bM4_DMA1_MONRPT2_DRPT0                    (*((volatile unsigned int*)(0x42A61DC0UL)))
#define bM4_DMA1_MONRPT2_DRPT1                    (*((volatile unsigned int*)(0x42A61DC4UL)))
#define bM4_DMA1_MONRPT2_DRPT2                    (*((volatile unsigned int*)(0x42A61DC8UL)))
#define bM4_DMA1_MONRPT2_DRPT3                    (*((volatile unsigned int*)(0x42A61DCCUL)))
#define bM4_DMA1_MONRPT2_DRPT4                    (*((volatile unsigned int*)(0x42A61DD0UL)))
#define bM4_DMA1_MONRPT2_DRPT5                    (*((volatile unsigned int*)(0x42A61DD4UL)))
#define bM4_DMA1_MONRPT2_DRPT6                    (*((volatile unsigned int*)(0x42A61DD8UL)))
#define bM4_DMA1_MONRPT2_DRPT7                    (*((volatile unsigned int*)(0x42A61DDCUL)))
#define bM4_DMA1_MONRPT2_DRPT8                    (*((volatile unsigned int*)(0x42A61DE0UL)))
#define bM4_DMA1_MONRPT2_DRPT9                    (*((volatile unsigned int*)(0x42A61DE4UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET0            (*((volatile unsigned int*)(0x42A61E00UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET1            (*((volatile unsigned int*)(0x42A61E04UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET2            (*((volatile unsigned int*)(0x42A61E08UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET3            (*((volatile unsigned int*)(0x42A61E0CUL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET4            (*((volatile unsigned int*)(0x42A61E10UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET5            (*((volatile unsigned int*)(0x42A61E14UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET6            (*((volatile unsigned int*)(0x42A61E18UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET7            (*((volatile unsigned int*)(0x42A61E1CUL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET8            (*((volatile unsigned int*)(0x42A61E20UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET9            (*((volatile unsigned int*)(0x42A61E24UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET10           (*((volatile unsigned int*)(0x42A61E28UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET11           (*((volatile unsigned int*)(0x42A61E2CUL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET12           (*((volatile unsigned int*)(0x42A61E30UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET13           (*((volatile unsigned int*)(0x42A61E34UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET14           (*((volatile unsigned int*)(0x42A61E38UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET15           (*((volatile unsigned int*)(0x42A61E3CUL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET16           (*((volatile unsigned int*)(0x42A61E40UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET17           (*((volatile unsigned int*)(0x42A61E44UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET18           (*((volatile unsigned int*)(0x42A61E48UL)))
#define bM4_DMA1_MONSNSEQCTL2_SOFFSET19           (*((volatile unsigned int*)(0x42A61E4CUL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT0             (*((volatile unsigned int*)(0x42A61E50UL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT1             (*((volatile unsigned int*)(0x42A61E54UL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT2             (*((volatile unsigned int*)(0x42A61E58UL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT3             (*((volatile unsigned int*)(0x42A61E5CUL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT4             (*((volatile unsigned int*)(0x42A61E60UL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT5             (*((volatile unsigned int*)(0x42A61E64UL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT6             (*((volatile unsigned int*)(0x42A61E68UL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT7             (*((volatile unsigned int*)(0x42A61E6CUL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT8             (*((volatile unsigned int*)(0x42A61E70UL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT9             (*((volatile unsigned int*)(0x42A61E74UL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT10            (*((volatile unsigned int*)(0x42A61E78UL)))
#define bM4_DMA1_MONSNSEQCTL2_SNSCNT11            (*((volatile unsigned int*)(0x42A61E7CUL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET0            (*((volatile unsigned int*)(0x42A61E80UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET1            (*((volatile unsigned int*)(0x42A61E84UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET2            (*((volatile unsigned int*)(0x42A61E88UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET3            (*((volatile unsigned int*)(0x42A61E8CUL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET4            (*((volatile unsigned int*)(0x42A61E90UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET5            (*((volatile unsigned int*)(0x42A61E94UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET6            (*((volatile unsigned int*)(0x42A61E98UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET7            (*((volatile unsigned int*)(0x42A61E9CUL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET8            (*((volatile unsigned int*)(0x42A61EA0UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET9            (*((volatile unsigned int*)(0x42A61EA4UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET10           (*((volatile unsigned int*)(0x42A61EA8UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET11           (*((volatile unsigned int*)(0x42A61EACUL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET12           (*((volatile unsigned int*)(0x42A61EB0UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET13           (*((volatile unsigned int*)(0x42A61EB4UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET14           (*((volatile unsigned int*)(0x42A61EB8UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET15           (*((volatile unsigned int*)(0x42A61EBCUL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET16           (*((volatile unsigned int*)(0x42A61EC0UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET17           (*((volatile unsigned int*)(0x42A61EC4UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET18           (*((volatile unsigned int*)(0x42A61EC8UL)))
#define bM4_DMA1_MONDNSEQCTL2_DOFFSET19           (*((volatile unsigned int*)(0x42A61ECCUL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT0             (*((volatile unsigned int*)(0x42A61ED0UL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT1             (*((volatile unsigned int*)(0x42A61ED4UL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT2             (*((volatile unsigned int*)(0x42A61ED8UL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT3             (*((volatile unsigned int*)(0x42A61EDCUL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT4             (*((volatile unsigned int*)(0x42A61EE0UL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT5             (*((volatile unsigned int*)(0x42A61EE4UL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT6             (*((volatile unsigned int*)(0x42A61EE8UL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT7             (*((volatile unsigned int*)(0x42A61EECUL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT8             (*((volatile unsigned int*)(0x42A61EF0UL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT9             (*((volatile unsigned int*)(0x42A61EF4UL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT10            (*((volatile unsigned int*)(0x42A61EF8UL)))
#define bM4_DMA1_MONDNSEQCTL2_DNSCNT11            (*((volatile unsigned int*)(0x42A61EFCUL)))
#define bM4_DMA1_DTCTL3_BLKSIZE0                  (*((volatile unsigned int*)(0x42A62100UL)))
#define bM4_DMA1_DTCTL3_BLKSIZE1                  (*((volatile unsigned int*)(0x42A62104UL)))
#define bM4_DMA1_DTCTL3_BLKSIZE2                  (*((volatile unsigned int*)(0x42A62108UL)))
#define bM4_DMA1_DTCTL3_BLKSIZE3                  (*((volatile unsigned int*)(0x42A6210CUL)))
#define bM4_DMA1_DTCTL3_BLKSIZE4                  (*((volatile unsigned int*)(0x42A62110UL)))
#define bM4_DMA1_DTCTL3_BLKSIZE5                  (*((volatile unsigned int*)(0x42A62114UL)))
#define bM4_DMA1_DTCTL3_BLKSIZE6                  (*((volatile unsigned int*)(0x42A62118UL)))
#define bM4_DMA1_DTCTL3_BLKSIZE7                  (*((volatile unsigned int*)(0x42A6211CUL)))
#define bM4_DMA1_DTCTL3_BLKSIZE8                  (*((volatile unsigned int*)(0x42A62120UL)))
#define bM4_DMA1_DTCTL3_BLKSIZE9                  (*((volatile unsigned int*)(0x42A62124UL)))
#define bM4_DMA1_DTCTL3_CNT0                      (*((volatile unsigned int*)(0x42A62140UL)))
#define bM4_DMA1_DTCTL3_CNT1                      (*((volatile unsigned int*)(0x42A62144UL)))
#define bM4_DMA1_DTCTL3_CNT2                      (*((volatile unsigned int*)(0x42A62148UL)))
#define bM4_DMA1_DTCTL3_CNT3                      (*((volatile unsigned int*)(0x42A6214CUL)))
#define bM4_DMA1_DTCTL3_CNT4                      (*((volatile unsigned int*)(0x42A62150UL)))
#define bM4_DMA1_DTCTL3_CNT5                      (*((volatile unsigned int*)(0x42A62154UL)))
#define bM4_DMA1_DTCTL3_CNT6                      (*((volatile unsigned int*)(0x42A62158UL)))
#define bM4_DMA1_DTCTL3_CNT7                      (*((volatile unsigned int*)(0x42A6215CUL)))
#define bM4_DMA1_DTCTL3_CNT8                      (*((volatile unsigned int*)(0x42A62160UL)))
#define bM4_DMA1_DTCTL3_CNT9                      (*((volatile unsigned int*)(0x42A62164UL)))
#define bM4_DMA1_DTCTL3_CNT10                     (*((volatile unsigned int*)(0x42A62168UL)))
#define bM4_DMA1_DTCTL3_CNT11                     (*((volatile unsigned int*)(0x42A6216CUL)))
#define bM4_DMA1_DTCTL3_CNT12                     (*((volatile unsigned int*)(0x42A62170UL)))
#define bM4_DMA1_DTCTL3_CNT13                     (*((volatile unsigned int*)(0x42A62174UL)))
#define bM4_DMA1_DTCTL3_CNT14                     (*((volatile unsigned int*)(0x42A62178UL)))
#define bM4_DMA1_DTCTL3_CNT15                     (*((volatile unsigned int*)(0x42A6217CUL)))
#define bM4_DMA1_RPT3_SRPT0                       (*((volatile unsigned int*)(0x42A62180UL)))
#define bM4_DMA1_RPT3_SRPT1                       (*((volatile unsigned int*)(0x42A62184UL)))
#define bM4_DMA1_RPT3_SRPT2                       (*((volatile unsigned int*)(0x42A62188UL)))
#define bM4_DMA1_RPT3_SRPT3                       (*((volatile unsigned int*)(0x42A6218CUL)))
#define bM4_DMA1_RPT3_SRPT4                       (*((volatile unsigned int*)(0x42A62190UL)))
#define bM4_DMA1_RPT3_SRPT5                       (*((volatile unsigned int*)(0x42A62194UL)))
#define bM4_DMA1_RPT3_SRPT6                       (*((volatile unsigned int*)(0x42A62198UL)))
#define bM4_DMA1_RPT3_SRPT7                       (*((volatile unsigned int*)(0x42A6219CUL)))
#define bM4_DMA1_RPT3_SRPT8                       (*((volatile unsigned int*)(0x42A621A0UL)))
#define bM4_DMA1_RPT3_SRPT9                       (*((volatile unsigned int*)(0x42A621A4UL)))
#define bM4_DMA1_RPT3_DRPT0                       (*((volatile unsigned int*)(0x42A621C0UL)))
#define bM4_DMA1_RPT3_DRPT1                       (*((volatile unsigned int*)(0x42A621C4UL)))
#define bM4_DMA1_RPT3_DRPT2                       (*((volatile unsigned int*)(0x42A621C8UL)))
#define bM4_DMA1_RPT3_DRPT3                       (*((volatile unsigned int*)(0x42A621CCUL)))
#define bM4_DMA1_RPT3_DRPT4                       (*((volatile unsigned int*)(0x42A621D0UL)))
#define bM4_DMA1_RPT3_DRPT5                       (*((volatile unsigned int*)(0x42A621D4UL)))
#define bM4_DMA1_RPT3_DRPT6                       (*((volatile unsigned int*)(0x42A621D8UL)))
#define bM4_DMA1_RPT3_DRPT7                       (*((volatile unsigned int*)(0x42A621DCUL)))
#define bM4_DMA1_RPT3_DRPT8                       (*((volatile unsigned int*)(0x42A621E0UL)))
#define bM4_DMA1_RPT3_DRPT9                       (*((volatile unsigned int*)(0x42A621E4UL)))
#define bM4_DMA1_RPTB3_SRPTB0                     (*((volatile unsigned int*)(0x42A62180UL)))
#define bM4_DMA1_RPTB3_SRPTB1                     (*((volatile unsigned int*)(0x42A62184UL)))
#define bM4_DMA1_RPTB3_SRPTB2                     (*((volatile unsigned int*)(0x42A62188UL)))
#define bM4_DMA1_RPTB3_SRPTB3                     (*((volatile unsigned int*)(0x42A6218CUL)))
#define bM4_DMA1_RPTB3_SRPTB4                     (*((volatile unsigned int*)(0x42A62190UL)))
#define bM4_DMA1_RPTB3_SRPTB5                     (*((volatile unsigned int*)(0x42A62194UL)))
#define bM4_DMA1_RPTB3_SRPTB6                     (*((volatile unsigned int*)(0x42A62198UL)))
#define bM4_DMA1_RPTB3_SRPTB7                     (*((volatile unsigned int*)(0x42A6219CUL)))
#define bM4_DMA1_RPTB3_SRPTB8                     (*((volatile unsigned int*)(0x42A621A0UL)))
#define bM4_DMA1_RPTB3_SRPTB9                     (*((volatile unsigned int*)(0x42A621A4UL)))
#define bM4_DMA1_RPTB3_DRPTB0                     (*((volatile unsigned int*)(0x42A621C0UL)))
#define bM4_DMA1_RPTB3_DRPTB1                     (*((volatile unsigned int*)(0x42A621C4UL)))
#define bM4_DMA1_RPTB3_DRPTB2                     (*((volatile unsigned int*)(0x42A621C8UL)))
#define bM4_DMA1_RPTB3_DRPTB3                     (*((volatile unsigned int*)(0x42A621CCUL)))
#define bM4_DMA1_RPTB3_DRPTB4                     (*((volatile unsigned int*)(0x42A621D0UL)))
#define bM4_DMA1_RPTB3_DRPTB5                     (*((volatile unsigned int*)(0x42A621D4UL)))
#define bM4_DMA1_RPTB3_DRPTB6                     (*((volatile unsigned int*)(0x42A621D8UL)))
#define bM4_DMA1_RPTB3_DRPTB7                     (*((volatile unsigned int*)(0x42A621DCUL)))
#define bM4_DMA1_RPTB3_DRPTB8                     (*((volatile unsigned int*)(0x42A621E0UL)))
#define bM4_DMA1_RPTB3_DRPTB9                     (*((volatile unsigned int*)(0x42A621E4UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET0               (*((volatile unsigned int*)(0x42A62200UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET1               (*((volatile unsigned int*)(0x42A62204UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET2               (*((volatile unsigned int*)(0x42A62208UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET3               (*((volatile unsigned int*)(0x42A6220CUL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET4               (*((volatile unsigned int*)(0x42A62210UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET5               (*((volatile unsigned int*)(0x42A62214UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET6               (*((volatile unsigned int*)(0x42A62218UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET7               (*((volatile unsigned int*)(0x42A6221CUL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET8               (*((volatile unsigned int*)(0x42A62220UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET9               (*((volatile unsigned int*)(0x42A62224UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET10              (*((volatile unsigned int*)(0x42A62228UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET11              (*((volatile unsigned int*)(0x42A6222CUL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET12              (*((volatile unsigned int*)(0x42A62230UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET13              (*((volatile unsigned int*)(0x42A62234UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET14              (*((volatile unsigned int*)(0x42A62238UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET15              (*((volatile unsigned int*)(0x42A6223CUL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET16              (*((volatile unsigned int*)(0x42A62240UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET17              (*((volatile unsigned int*)(0x42A62244UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET18              (*((volatile unsigned int*)(0x42A62248UL)))
#define bM4_DMA1_SNSEQCTL3_SOFFSET19              (*((volatile unsigned int*)(0x42A6224CUL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT0                (*((volatile unsigned int*)(0x42A62250UL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT1                (*((volatile unsigned int*)(0x42A62254UL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT2                (*((volatile unsigned int*)(0x42A62258UL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT3                (*((volatile unsigned int*)(0x42A6225CUL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT4                (*((volatile unsigned int*)(0x42A62260UL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT5                (*((volatile unsigned int*)(0x42A62264UL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT6                (*((volatile unsigned int*)(0x42A62268UL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT7                (*((volatile unsigned int*)(0x42A6226CUL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT8                (*((volatile unsigned int*)(0x42A62270UL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT9                (*((volatile unsigned int*)(0x42A62274UL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT10               (*((volatile unsigned int*)(0x42A62278UL)))
#define bM4_DMA1_SNSEQCTL3_SNSCNT11               (*((volatile unsigned int*)(0x42A6227CUL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST0              (*((volatile unsigned int*)(0x42A62200UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST1              (*((volatile unsigned int*)(0x42A62204UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST2              (*((volatile unsigned int*)(0x42A62208UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST3              (*((volatile unsigned int*)(0x42A6220CUL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST4              (*((volatile unsigned int*)(0x42A62210UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST5              (*((volatile unsigned int*)(0x42A62214UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST6              (*((volatile unsigned int*)(0x42A62218UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST7              (*((volatile unsigned int*)(0x42A6221CUL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST8              (*((volatile unsigned int*)(0x42A62220UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST9              (*((volatile unsigned int*)(0x42A62224UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST10             (*((volatile unsigned int*)(0x42A62228UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST11             (*((volatile unsigned int*)(0x42A6222CUL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST12             (*((volatile unsigned int*)(0x42A62230UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST13             (*((volatile unsigned int*)(0x42A62234UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST14             (*((volatile unsigned int*)(0x42A62238UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST15             (*((volatile unsigned int*)(0x42A6223CUL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST16             (*((volatile unsigned int*)(0x42A62240UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST17             (*((volatile unsigned int*)(0x42A62244UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST18             (*((volatile unsigned int*)(0x42A62248UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSDIST19             (*((volatile unsigned int*)(0x42A6224CUL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB0              (*((volatile unsigned int*)(0x42A62250UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB1              (*((volatile unsigned int*)(0x42A62254UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB2              (*((volatile unsigned int*)(0x42A62258UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB3              (*((volatile unsigned int*)(0x42A6225CUL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB4              (*((volatile unsigned int*)(0x42A62260UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB5              (*((volatile unsigned int*)(0x42A62264UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB6              (*((volatile unsigned int*)(0x42A62268UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB7              (*((volatile unsigned int*)(0x42A6226CUL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB8              (*((volatile unsigned int*)(0x42A62270UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB9              (*((volatile unsigned int*)(0x42A62274UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB10             (*((volatile unsigned int*)(0x42A62278UL)))
#define bM4_DMA1_SNSEQCTLB3_SNSCNTB11             (*((volatile unsigned int*)(0x42A6227CUL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET0               (*((volatile unsigned int*)(0x42A62280UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET1               (*((volatile unsigned int*)(0x42A62284UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET2               (*((volatile unsigned int*)(0x42A62288UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET3               (*((volatile unsigned int*)(0x42A6228CUL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET4               (*((volatile unsigned int*)(0x42A62290UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET5               (*((volatile unsigned int*)(0x42A62294UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET6               (*((volatile unsigned int*)(0x42A62298UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET7               (*((volatile unsigned int*)(0x42A6229CUL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET8               (*((volatile unsigned int*)(0x42A622A0UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET9               (*((volatile unsigned int*)(0x42A622A4UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET10              (*((volatile unsigned int*)(0x42A622A8UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET11              (*((volatile unsigned int*)(0x42A622ACUL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET12              (*((volatile unsigned int*)(0x42A622B0UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET13              (*((volatile unsigned int*)(0x42A622B4UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET14              (*((volatile unsigned int*)(0x42A622B8UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET15              (*((volatile unsigned int*)(0x42A622BCUL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET16              (*((volatile unsigned int*)(0x42A622C0UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET17              (*((volatile unsigned int*)(0x42A622C4UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET18              (*((volatile unsigned int*)(0x42A622C8UL)))
#define bM4_DMA1_DNSEQCTL3_DOFFSET19              (*((volatile unsigned int*)(0x42A622CCUL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT0                (*((volatile unsigned int*)(0x42A622D0UL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT1                (*((volatile unsigned int*)(0x42A622D4UL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT2                (*((volatile unsigned int*)(0x42A622D8UL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT3                (*((volatile unsigned int*)(0x42A622DCUL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT4                (*((volatile unsigned int*)(0x42A622E0UL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT5                (*((volatile unsigned int*)(0x42A622E4UL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT6                (*((volatile unsigned int*)(0x42A622E8UL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT7                (*((volatile unsigned int*)(0x42A622ECUL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT8                (*((volatile unsigned int*)(0x42A622F0UL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT9                (*((volatile unsigned int*)(0x42A622F4UL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT10               (*((volatile unsigned int*)(0x42A622F8UL)))
#define bM4_DMA1_DNSEQCTL3_DNSCNT11               (*((volatile unsigned int*)(0x42A622FCUL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST0              (*((volatile unsigned int*)(0x42A62280UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST1              (*((volatile unsigned int*)(0x42A62284UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST2              (*((volatile unsigned int*)(0x42A62288UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST3              (*((volatile unsigned int*)(0x42A6228CUL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST4              (*((volatile unsigned int*)(0x42A62290UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST5              (*((volatile unsigned int*)(0x42A62294UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST6              (*((volatile unsigned int*)(0x42A62298UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST7              (*((volatile unsigned int*)(0x42A6229CUL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST8              (*((volatile unsigned int*)(0x42A622A0UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST9              (*((volatile unsigned int*)(0x42A622A4UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST10             (*((volatile unsigned int*)(0x42A622A8UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST11             (*((volatile unsigned int*)(0x42A622ACUL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST12             (*((volatile unsigned int*)(0x42A622B0UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST13             (*((volatile unsigned int*)(0x42A622B4UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST14             (*((volatile unsigned int*)(0x42A622B8UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST15             (*((volatile unsigned int*)(0x42A622BCUL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST16             (*((volatile unsigned int*)(0x42A622C0UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST17             (*((volatile unsigned int*)(0x42A622C4UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST18             (*((volatile unsigned int*)(0x42A622C8UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSDIST19             (*((volatile unsigned int*)(0x42A622CCUL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB0              (*((volatile unsigned int*)(0x42A622D0UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB1              (*((volatile unsigned int*)(0x42A622D4UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB2              (*((volatile unsigned int*)(0x42A622D8UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB3              (*((volatile unsigned int*)(0x42A622DCUL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB4              (*((volatile unsigned int*)(0x42A622E0UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB5              (*((volatile unsigned int*)(0x42A622E4UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB6              (*((volatile unsigned int*)(0x42A622E8UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB7              (*((volatile unsigned int*)(0x42A622ECUL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB8              (*((volatile unsigned int*)(0x42A622F0UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB9              (*((volatile unsigned int*)(0x42A622F4UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB10             (*((volatile unsigned int*)(0x42A622F8UL)))
#define bM4_DMA1_DNSEQCTLB3_DNSCNTB11             (*((volatile unsigned int*)(0x42A622FCUL)))
#define bM4_DMA1_LLP3_LLP0                        (*((volatile unsigned int*)(0x42A62308UL)))
#define bM4_DMA1_LLP3_LLP1                        (*((volatile unsigned int*)(0x42A6230CUL)))
#define bM4_DMA1_LLP3_LLP2                        (*((volatile unsigned int*)(0x42A62310UL)))
#define bM4_DMA1_LLP3_LLP3                        (*((volatile unsigned int*)(0x42A62314UL)))
#define bM4_DMA1_LLP3_LLP4                        (*((volatile unsigned int*)(0x42A62318UL)))
#define bM4_DMA1_LLP3_LLP5                        (*((volatile unsigned int*)(0x42A6231CUL)))
#define bM4_DMA1_LLP3_LLP6                        (*((volatile unsigned int*)(0x42A62320UL)))
#define bM4_DMA1_LLP3_LLP7                        (*((volatile unsigned int*)(0x42A62324UL)))
#define bM4_DMA1_LLP3_LLP8                        (*((volatile unsigned int*)(0x42A62328UL)))
#define bM4_DMA1_LLP3_LLP9                        (*((volatile unsigned int*)(0x42A6232CUL)))
#define bM4_DMA1_LLP3_LLP10                       (*((volatile unsigned int*)(0x42A62330UL)))
#define bM4_DMA1_LLP3_LLP11                       (*((volatile unsigned int*)(0x42A62334UL)))
#define bM4_DMA1_LLP3_LLP12                       (*((volatile unsigned int*)(0x42A62338UL)))
#define bM4_DMA1_LLP3_LLP13                       (*((volatile unsigned int*)(0x42A6233CUL)))
#define bM4_DMA1_LLP3_LLP14                       (*((volatile unsigned int*)(0x42A62340UL)))
#define bM4_DMA1_LLP3_LLP15                       (*((volatile unsigned int*)(0x42A62344UL)))
#define bM4_DMA1_LLP3_LLP16                       (*((volatile unsigned int*)(0x42A62348UL)))
#define bM4_DMA1_LLP3_LLP17                       (*((volatile unsigned int*)(0x42A6234CUL)))
#define bM4_DMA1_LLP3_LLP18                       (*((volatile unsigned int*)(0x42A62350UL)))
#define bM4_DMA1_LLP3_LLP19                       (*((volatile unsigned int*)(0x42A62354UL)))
#define bM4_DMA1_LLP3_LLP20                       (*((volatile unsigned int*)(0x42A62358UL)))
#define bM4_DMA1_LLP3_LLP21                       (*((volatile unsigned int*)(0x42A6235CUL)))
#define bM4_DMA1_LLP3_LLP22                       (*((volatile unsigned int*)(0x42A62360UL)))
#define bM4_DMA1_LLP3_LLP23                       (*((volatile unsigned int*)(0x42A62364UL)))
#define bM4_DMA1_LLP3_LLP24                       (*((volatile unsigned int*)(0x42A62368UL)))
#define bM4_DMA1_LLP3_LLP25                       (*((volatile unsigned int*)(0x42A6236CUL)))
#define bM4_DMA1_LLP3_LLP26                       (*((volatile unsigned int*)(0x42A62370UL)))
#define bM4_DMA1_LLP3_LLP27                       (*((volatile unsigned int*)(0x42A62374UL)))
#define bM4_DMA1_LLP3_LLP28                       (*((volatile unsigned int*)(0x42A62378UL)))
#define bM4_DMA1_LLP3_LLP29                       (*((volatile unsigned int*)(0x42A6237CUL)))
#define bM4_DMA1_CHCTL3_SINC0                     (*((volatile unsigned int*)(0x42A62380UL)))
#define bM4_DMA1_CHCTL3_SINC1                     (*((volatile unsigned int*)(0x42A62384UL)))
#define bM4_DMA1_CHCTL3_DINC0                     (*((volatile unsigned int*)(0x42A62388UL)))
#define bM4_DMA1_CHCTL3_DINC1                     (*((volatile unsigned int*)(0x42A6238CUL)))
#define bM4_DMA1_CHCTL3_SRPTEN                    (*((volatile unsigned int*)(0x42A62390UL)))
#define bM4_DMA1_CHCTL3_DRPTEN                    (*((volatile unsigned int*)(0x42A62394UL)))
#define bM4_DMA1_CHCTL3_SNSEQEN                   (*((volatile unsigned int*)(0x42A62398UL)))
#define bM4_DMA1_CHCTL3_DNSEQEN                   (*((volatile unsigned int*)(0x42A6239CUL)))
#define bM4_DMA1_CHCTL3_HSIZE0                    (*((volatile unsigned int*)(0x42A623A0UL)))
#define bM4_DMA1_CHCTL3_HSIZE1                    (*((volatile unsigned int*)(0x42A623A4UL)))
#define bM4_DMA1_CHCTL3_LLPEN                     (*((volatile unsigned int*)(0x42A623A8UL)))
#define bM4_DMA1_CHCTL3_LLPRUN                    (*((volatile unsigned int*)(0x42A623ACUL)))
#define bM4_DMA1_CHCTL3_IE                        (*((volatile unsigned int*)(0x42A623B0UL)))
#define bM4_DMA1_MONDTCTL3_BLKSIZE0               (*((volatile unsigned int*)(0x42A62500UL)))
#define bM4_DMA1_MONDTCTL3_BLKSIZE1               (*((volatile unsigned int*)(0x42A62504UL)))
#define bM4_DMA1_MONDTCTL3_BLKSIZE2               (*((volatile unsigned int*)(0x42A62508UL)))
#define bM4_DMA1_MONDTCTL3_BLKSIZE3               (*((volatile unsigned int*)(0x42A6250CUL)))
#define bM4_DMA1_MONDTCTL3_BLKSIZE4               (*((volatile unsigned int*)(0x42A62510UL)))
#define bM4_DMA1_MONDTCTL3_BLKSIZE5               (*((volatile unsigned int*)(0x42A62514UL)))
#define bM4_DMA1_MONDTCTL3_BLKSIZE6               (*((volatile unsigned int*)(0x42A62518UL)))
#define bM4_DMA1_MONDTCTL3_BLKSIZE7               (*((volatile unsigned int*)(0x42A6251CUL)))
#define bM4_DMA1_MONDTCTL3_BLKSIZE8               (*((volatile unsigned int*)(0x42A62520UL)))
#define bM4_DMA1_MONDTCTL3_BLKSIZE9               (*((volatile unsigned int*)(0x42A62524UL)))
#define bM4_DMA1_MONDTCTL3_CNT0                   (*((volatile unsigned int*)(0x42A62540UL)))
#define bM4_DMA1_MONDTCTL3_CNT1                   (*((volatile unsigned int*)(0x42A62544UL)))
#define bM4_DMA1_MONDTCTL3_CNT2                   (*((volatile unsigned int*)(0x42A62548UL)))
#define bM4_DMA1_MONDTCTL3_CNT3                   (*((volatile unsigned int*)(0x42A6254CUL)))
#define bM4_DMA1_MONDTCTL3_CNT4                   (*((volatile unsigned int*)(0x42A62550UL)))
#define bM4_DMA1_MONDTCTL3_CNT5                   (*((volatile unsigned int*)(0x42A62554UL)))
#define bM4_DMA1_MONDTCTL3_CNT6                   (*((volatile unsigned int*)(0x42A62558UL)))
#define bM4_DMA1_MONDTCTL3_CNT7                   (*((volatile unsigned int*)(0x42A6255CUL)))
#define bM4_DMA1_MONDTCTL3_CNT8                   (*((volatile unsigned int*)(0x42A62560UL)))
#define bM4_DMA1_MONDTCTL3_CNT9                   (*((volatile unsigned int*)(0x42A62564UL)))
#define bM4_DMA1_MONDTCTL3_CNT10                  (*((volatile unsigned int*)(0x42A62568UL)))
#define bM4_DMA1_MONDTCTL3_CNT11                  (*((volatile unsigned int*)(0x42A6256CUL)))
#define bM4_DMA1_MONDTCTL3_CNT12                  (*((volatile unsigned int*)(0x42A62570UL)))
#define bM4_DMA1_MONDTCTL3_CNT13                  (*((volatile unsigned int*)(0x42A62574UL)))
#define bM4_DMA1_MONDTCTL3_CNT14                  (*((volatile unsigned int*)(0x42A62578UL)))
#define bM4_DMA1_MONDTCTL3_CNT15                  (*((volatile unsigned int*)(0x42A6257CUL)))
#define bM4_DMA1_MONRPT3_SRPT0                    (*((volatile unsigned int*)(0x42A62580UL)))
#define bM4_DMA1_MONRPT3_SRPT1                    (*((volatile unsigned int*)(0x42A62584UL)))
#define bM4_DMA1_MONRPT3_SRPT2                    (*((volatile unsigned int*)(0x42A62588UL)))
#define bM4_DMA1_MONRPT3_SRPT3                    (*((volatile unsigned int*)(0x42A6258CUL)))
#define bM4_DMA1_MONRPT3_SRPT4                    (*((volatile unsigned int*)(0x42A62590UL)))
#define bM4_DMA1_MONRPT3_SRPT5                    (*((volatile unsigned int*)(0x42A62594UL)))
#define bM4_DMA1_MONRPT3_SRPT6                    (*((volatile unsigned int*)(0x42A62598UL)))
#define bM4_DMA1_MONRPT3_SRPT7                    (*((volatile unsigned int*)(0x42A6259CUL)))
#define bM4_DMA1_MONRPT3_SRPT8                    (*((volatile unsigned int*)(0x42A625A0UL)))
#define bM4_DMA1_MONRPT3_SRPT9                    (*((volatile unsigned int*)(0x42A625A4UL)))
#define bM4_DMA1_MONRPT3_DRPT0                    (*((volatile unsigned int*)(0x42A625C0UL)))
#define bM4_DMA1_MONRPT3_DRPT1                    (*((volatile unsigned int*)(0x42A625C4UL)))
#define bM4_DMA1_MONRPT3_DRPT2                    (*((volatile unsigned int*)(0x42A625C8UL)))
#define bM4_DMA1_MONRPT3_DRPT3                    (*((volatile unsigned int*)(0x42A625CCUL)))
#define bM4_DMA1_MONRPT3_DRPT4                    (*((volatile unsigned int*)(0x42A625D0UL)))
#define bM4_DMA1_MONRPT3_DRPT5                    (*((volatile unsigned int*)(0x42A625D4UL)))
#define bM4_DMA1_MONRPT3_DRPT6                    (*((volatile unsigned int*)(0x42A625D8UL)))
#define bM4_DMA1_MONRPT3_DRPT7                    (*((volatile unsigned int*)(0x42A625DCUL)))
#define bM4_DMA1_MONRPT3_DRPT8                    (*((volatile unsigned int*)(0x42A625E0UL)))
#define bM4_DMA1_MONRPT3_DRPT9                    (*((volatile unsigned int*)(0x42A625E4UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET0            (*((volatile unsigned int*)(0x42A62600UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET1            (*((volatile unsigned int*)(0x42A62604UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET2            (*((volatile unsigned int*)(0x42A62608UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET3            (*((volatile unsigned int*)(0x42A6260CUL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET4            (*((volatile unsigned int*)(0x42A62610UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET5            (*((volatile unsigned int*)(0x42A62614UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET6            (*((volatile unsigned int*)(0x42A62618UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET7            (*((volatile unsigned int*)(0x42A6261CUL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET8            (*((volatile unsigned int*)(0x42A62620UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET9            (*((volatile unsigned int*)(0x42A62624UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET10           (*((volatile unsigned int*)(0x42A62628UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET11           (*((volatile unsigned int*)(0x42A6262CUL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET12           (*((volatile unsigned int*)(0x42A62630UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET13           (*((volatile unsigned int*)(0x42A62634UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET14           (*((volatile unsigned int*)(0x42A62638UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET15           (*((volatile unsigned int*)(0x42A6263CUL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET16           (*((volatile unsigned int*)(0x42A62640UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET17           (*((volatile unsigned int*)(0x42A62644UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET18           (*((volatile unsigned int*)(0x42A62648UL)))
#define bM4_DMA1_MONSNSEQCTL3_SOFFSET19           (*((volatile unsigned int*)(0x42A6264CUL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT0             (*((volatile unsigned int*)(0x42A62650UL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT1             (*((volatile unsigned int*)(0x42A62654UL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT2             (*((volatile unsigned int*)(0x42A62658UL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT3             (*((volatile unsigned int*)(0x42A6265CUL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT4             (*((volatile unsigned int*)(0x42A62660UL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT5             (*((volatile unsigned int*)(0x42A62664UL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT6             (*((volatile unsigned int*)(0x42A62668UL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT7             (*((volatile unsigned int*)(0x42A6266CUL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT8             (*((volatile unsigned int*)(0x42A62670UL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT9             (*((volatile unsigned int*)(0x42A62674UL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT10            (*((volatile unsigned int*)(0x42A62678UL)))
#define bM4_DMA1_MONSNSEQCTL3_SNSCNT11            (*((volatile unsigned int*)(0x42A6267CUL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET0            (*((volatile unsigned int*)(0x42A62680UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET1            (*((volatile unsigned int*)(0x42A62684UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET2            (*((volatile unsigned int*)(0x42A62688UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET3            (*((volatile unsigned int*)(0x42A6268CUL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET4            (*((volatile unsigned int*)(0x42A62690UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET5            (*((volatile unsigned int*)(0x42A62694UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET6            (*((volatile unsigned int*)(0x42A62698UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET7            (*((volatile unsigned int*)(0x42A6269CUL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET8            (*((volatile unsigned int*)(0x42A626A0UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET9            (*((volatile unsigned int*)(0x42A626A4UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET10           (*((volatile unsigned int*)(0x42A626A8UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET11           (*((volatile unsigned int*)(0x42A626ACUL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET12           (*((volatile unsigned int*)(0x42A626B0UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET13           (*((volatile unsigned int*)(0x42A626B4UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET14           (*((volatile unsigned int*)(0x42A626B8UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET15           (*((volatile unsigned int*)(0x42A626BCUL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET16           (*((volatile unsigned int*)(0x42A626C0UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET17           (*((volatile unsigned int*)(0x42A626C4UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET18           (*((volatile unsigned int*)(0x42A626C8UL)))
#define bM4_DMA1_MONDNSEQCTL3_DOFFSET19           (*((volatile unsigned int*)(0x42A626CCUL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT0             (*((volatile unsigned int*)(0x42A626D0UL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT1             (*((volatile unsigned int*)(0x42A626D4UL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT2             (*((volatile unsigned int*)(0x42A626D8UL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT3             (*((volatile unsigned int*)(0x42A626DCUL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT4             (*((volatile unsigned int*)(0x42A626E0UL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT5             (*((volatile unsigned int*)(0x42A626E4UL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT6             (*((volatile unsigned int*)(0x42A626E8UL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT7             (*((volatile unsigned int*)(0x42A626ECUL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT8             (*((volatile unsigned int*)(0x42A626F0UL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT9             (*((volatile unsigned int*)(0x42A626F4UL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT10            (*((volatile unsigned int*)(0x42A626F8UL)))
#define bM4_DMA1_MONDNSEQCTL3_DNSCNT11            (*((volatile unsigned int*)(0x42A626FCUL)))
#define bM4_DMA2_EN_EN                            (*((volatile unsigned int*)(0x42A68000UL)))
#define bM4_DMA2_INTSTAT0_TRNERR0                 (*((volatile unsigned int*)(0x42A68080UL)))
#define bM4_DMA2_INTSTAT0_TRNERR1                 (*((volatile unsigned int*)(0x42A68084UL)))
#define bM4_DMA2_INTSTAT0_TRNERR2                 (*((volatile unsigned int*)(0x42A68088UL)))
#define bM4_DMA2_INTSTAT0_TRNERR3                 (*((volatile unsigned int*)(0x42A6808CUL)))
#define bM4_DMA2_INTSTAT0_REQERR0                 (*((volatile unsigned int*)(0x42A680C0UL)))
#define bM4_DMA2_INTSTAT0_REQERR1                 (*((volatile unsigned int*)(0x42A680C4UL)))
#define bM4_DMA2_INTSTAT0_REQERR2                 (*((volatile unsigned int*)(0x42A680C8UL)))
#define bM4_DMA2_INTSTAT0_REQERR3                 (*((volatile unsigned int*)(0x42A680CCUL)))
#define bM4_DMA2_INTSTAT1_TC0                     (*((volatile unsigned int*)(0x42A68100UL)))
#define bM4_DMA2_INTSTAT1_TC1                     (*((volatile unsigned int*)(0x42A68104UL)))
#define bM4_DMA2_INTSTAT1_TC2                     (*((volatile unsigned int*)(0x42A68108UL)))
#define bM4_DMA2_INTSTAT1_TC3                     (*((volatile unsigned int*)(0x42A6810CUL)))
#define bM4_DMA2_INTSTAT1_BTC0                    (*((volatile unsigned int*)(0x42A68140UL)))
#define bM4_DMA2_INTSTAT1_BTC1                    (*((volatile unsigned int*)(0x42A68144UL)))
#define bM4_DMA2_INTSTAT1_BTC2                    (*((volatile unsigned int*)(0x42A68148UL)))
#define bM4_DMA2_INTSTAT1_BTC3                    (*((volatile unsigned int*)(0x42A6814CUL)))
#define bM4_DMA2_INTMASK0_MSKTRNERR0              (*((volatile unsigned int*)(0x42A68180UL)))
#define bM4_DMA2_INTMASK0_MSKTRNERR1              (*((volatile unsigned int*)(0x42A68184UL)))
#define bM4_DMA2_INTMASK0_MSKTRNERR2              (*((volatile unsigned int*)(0x42A68188UL)))
#define bM4_DMA2_INTMASK0_MSKTRNERR3              (*((volatile unsigned int*)(0x42A6818CUL)))
#define bM4_DMA2_INTMASK0_MSKREQERR0              (*((volatile unsigned int*)(0x42A681C0UL)))
#define bM4_DMA2_INTMASK0_MSKREQERR1              (*((volatile unsigned int*)(0x42A681C4UL)))
#define bM4_DMA2_INTMASK0_MSKREQERR2              (*((volatile unsigned int*)(0x42A681C8UL)))
#define bM4_DMA2_INTMASK0_MSKREQERR3              (*((volatile unsigned int*)(0x42A681CCUL)))
#define bM4_DMA2_INTMASK1_MSKTC0                  (*((volatile unsigned int*)(0x42A68200UL)))
#define bM4_DMA2_INTMASK1_MSKTC1                  (*((volatile unsigned int*)(0x42A68204UL)))
#define bM4_DMA2_INTMASK1_MSKTC2                  (*((volatile unsigned int*)(0x42A68208UL)))
#define bM4_DMA2_INTMASK1_MSKTC3                  (*((volatile unsigned int*)(0x42A6820CUL)))
#define bM4_DMA2_INTMASK1_MSKBTC0                 (*((volatile unsigned int*)(0x42A68240UL)))
#define bM4_DMA2_INTMASK1_MSKBTC1                 (*((volatile unsigned int*)(0x42A68244UL)))
#define bM4_DMA2_INTMASK1_MSKBTC2                 (*((volatile unsigned int*)(0x42A68248UL)))
#define bM4_DMA2_INTMASK1_MSKBTC3                 (*((volatile unsigned int*)(0x42A6824CUL)))
#define bM4_DMA2_INTCLR0_CLRTRNERR0               (*((volatile unsigned int*)(0x42A68280UL)))
#define bM4_DMA2_INTCLR0_CLRTRNERR1               (*((volatile unsigned int*)(0x42A68284UL)))
#define bM4_DMA2_INTCLR0_CLRTRNERR2               (*((volatile unsigned int*)(0x42A68288UL)))
#define bM4_DMA2_INTCLR0_CLRTRNERR3               (*((volatile unsigned int*)(0x42A6828CUL)))
#define bM4_DMA2_INTCLR0_CLRREQERR0               (*((volatile unsigned int*)(0x42A682C0UL)))
#define bM4_DMA2_INTCLR0_CLRREQERR1               (*((volatile unsigned int*)(0x42A682C4UL)))
#define bM4_DMA2_INTCLR0_CLRREQERR2               (*((volatile unsigned int*)(0x42A682C8UL)))
#define bM4_DMA2_INTCLR0_CLRREQERR3               (*((volatile unsigned int*)(0x42A682CCUL)))
#define bM4_DMA2_INTCLR1_CLRTC0                   (*((volatile unsigned int*)(0x42A68300UL)))
#define bM4_DMA2_INTCLR1_CLRTC1                   (*((volatile unsigned int*)(0x42A68304UL)))
#define bM4_DMA2_INTCLR1_CLRTC2                   (*((volatile unsigned int*)(0x42A68308UL)))
#define bM4_DMA2_INTCLR1_CLRTC3                   (*((volatile unsigned int*)(0x42A6830CUL)))
#define bM4_DMA2_INTCLR1_CLRBTC0                  (*((volatile unsigned int*)(0x42A68340UL)))
#define bM4_DMA2_INTCLR1_CLRBTC1                  (*((volatile unsigned int*)(0x42A68344UL)))
#define bM4_DMA2_INTCLR1_CLRBTC2                  (*((volatile unsigned int*)(0x42A68348UL)))
#define bM4_DMA2_INTCLR1_CLRBTC3                  (*((volatile unsigned int*)(0x42A6834CUL)))
#define bM4_DMA2_CHEN_CHEN0                       (*((volatile unsigned int*)(0x42A68380UL)))
#define bM4_DMA2_CHEN_CHEN1                       (*((volatile unsigned int*)(0x42A68384UL)))
#define bM4_DMA2_CHEN_CHEN2                       (*((volatile unsigned int*)(0x42A68388UL)))
#define bM4_DMA2_CHEN_CHEN3                       (*((volatile unsigned int*)(0x42A6838CUL)))
#define bM4_DMA2_REQSTAT_CHREQ0                   (*((volatile unsigned int*)(0x42A68400UL)))
#define bM4_DMA2_REQSTAT_CHREQ1                   (*((volatile unsigned int*)(0x42A68404UL)))
#define bM4_DMA2_REQSTAT_CHREQ2                   (*((volatile unsigned int*)(0x42A68408UL)))
#define bM4_DMA2_REQSTAT_CHREQ3                   (*((volatile unsigned int*)(0x42A6840CUL)))
#define bM4_DMA2_REQSTAT_RCFGREQ                  (*((volatile unsigned int*)(0x42A6843CUL)))
#define bM4_DMA2_CHSTAT_DMAACT                    (*((volatile unsigned int*)(0x42A68480UL)))
#define bM4_DMA2_CHSTAT_RCFGACT                   (*((volatile unsigned int*)(0x42A68484UL)))
#define bM4_DMA2_CHSTAT_CHACT0                    (*((volatile unsigned int*)(0x42A684C0UL)))
#define bM4_DMA2_CHSTAT_CHACT1                    (*((volatile unsigned int*)(0x42A684C4UL)))
#define bM4_DMA2_CHSTAT_CHACT2                    (*((volatile unsigned int*)(0x42A684C8UL)))
#define bM4_DMA2_CHSTAT_CHACT3                    (*((volatile unsigned int*)(0x42A684CCUL)))
#define bM4_DMA2_RCFGCTL_RCFGEN                   (*((volatile unsigned int*)(0x42A68580UL)))
#define bM4_DMA2_RCFGCTL_RCFGLLP                  (*((volatile unsigned int*)(0x42A68584UL)))
#define bM4_DMA2_RCFGCTL_RCFGCHS0                 (*((volatile unsigned int*)(0x42A685A0UL)))
#define bM4_DMA2_RCFGCTL_RCFGCHS1                 (*((volatile unsigned int*)(0x42A685A4UL)))
#define bM4_DMA2_RCFGCTL_RCFGCHS2                 (*((volatile unsigned int*)(0x42A685A8UL)))
#define bM4_DMA2_RCFGCTL_RCFGCHS3                 (*((volatile unsigned int*)(0x42A685ACUL)))
#define bM4_DMA2_RCFGCTL_SARMD0                   (*((volatile unsigned int*)(0x42A685C0UL)))
#define bM4_DMA2_RCFGCTL_SARMD1                   (*((volatile unsigned int*)(0x42A685C4UL)))
#define bM4_DMA2_RCFGCTL_DARMD0                   (*((volatile unsigned int*)(0x42A685C8UL)))
#define bM4_DMA2_RCFGCTL_DARMD1                   (*((volatile unsigned int*)(0x42A685CCUL)))
#define bM4_DMA2_RCFGCTL_CNTMD0                   (*((volatile unsigned int*)(0x42A685D0UL)))
#define bM4_DMA2_RCFGCTL_CNTMD1                   (*((volatile unsigned int*)(0x42A685D4UL)))
#define bM4_DMA2_DTCTL0_BLKSIZE0                  (*((volatile unsigned int*)(0x42A68900UL)))
#define bM4_DMA2_DTCTL0_BLKSIZE1                  (*((volatile unsigned int*)(0x42A68904UL)))
#define bM4_DMA2_DTCTL0_BLKSIZE2                  (*((volatile unsigned int*)(0x42A68908UL)))
#define bM4_DMA2_DTCTL0_BLKSIZE3                  (*((volatile unsigned int*)(0x42A6890CUL)))
#define bM4_DMA2_DTCTL0_BLKSIZE4                  (*((volatile unsigned int*)(0x42A68910UL)))
#define bM4_DMA2_DTCTL0_BLKSIZE5                  (*((volatile unsigned int*)(0x42A68914UL)))
#define bM4_DMA2_DTCTL0_BLKSIZE6                  (*((volatile unsigned int*)(0x42A68918UL)))
#define bM4_DMA2_DTCTL0_BLKSIZE7                  (*((volatile unsigned int*)(0x42A6891CUL)))
#define bM4_DMA2_DTCTL0_BLKSIZE8                  (*((volatile unsigned int*)(0x42A68920UL)))
#define bM4_DMA2_DTCTL0_BLKSIZE9                  (*((volatile unsigned int*)(0x42A68924UL)))
#define bM4_DMA2_DTCTL0_CNT0                      (*((volatile unsigned int*)(0x42A68940UL)))
#define bM4_DMA2_DTCTL0_CNT1                      (*((volatile unsigned int*)(0x42A68944UL)))
#define bM4_DMA2_DTCTL0_CNT2                      (*((volatile unsigned int*)(0x42A68948UL)))
#define bM4_DMA2_DTCTL0_CNT3                      (*((volatile unsigned int*)(0x42A6894CUL)))
#define bM4_DMA2_DTCTL0_CNT4                      (*((volatile unsigned int*)(0x42A68950UL)))
#define bM4_DMA2_DTCTL0_CNT5                      (*((volatile unsigned int*)(0x42A68954UL)))
#define bM4_DMA2_DTCTL0_CNT6                      (*((volatile unsigned int*)(0x42A68958UL)))
#define bM4_DMA2_DTCTL0_CNT7                      (*((volatile unsigned int*)(0x42A6895CUL)))
#define bM4_DMA2_DTCTL0_CNT8                      (*((volatile unsigned int*)(0x42A68960UL)))
#define bM4_DMA2_DTCTL0_CNT9                      (*((volatile unsigned int*)(0x42A68964UL)))
#define bM4_DMA2_DTCTL0_CNT10                     (*((volatile unsigned int*)(0x42A68968UL)))
#define bM4_DMA2_DTCTL0_CNT11                     (*((volatile unsigned int*)(0x42A6896CUL)))
#define bM4_DMA2_DTCTL0_CNT12                     (*((volatile unsigned int*)(0x42A68970UL)))
#define bM4_DMA2_DTCTL0_CNT13                     (*((volatile unsigned int*)(0x42A68974UL)))
#define bM4_DMA2_DTCTL0_CNT14                     (*((volatile unsigned int*)(0x42A68978UL)))
#define bM4_DMA2_DTCTL0_CNT15                     (*((volatile unsigned int*)(0x42A6897CUL)))
#define bM4_DMA2_RPT0_SRPT0                       (*((volatile unsigned int*)(0x42A68980UL)))
#define bM4_DMA2_RPT0_SRPT1                       (*((volatile unsigned int*)(0x42A68984UL)))
#define bM4_DMA2_RPT0_SRPT2                       (*((volatile unsigned int*)(0x42A68988UL)))
#define bM4_DMA2_RPT0_SRPT3                       (*((volatile unsigned int*)(0x42A6898CUL)))
#define bM4_DMA2_RPT0_SRPT4                       (*((volatile unsigned int*)(0x42A68990UL)))
#define bM4_DMA2_RPT0_SRPT5                       (*((volatile unsigned int*)(0x42A68994UL)))
#define bM4_DMA2_RPT0_SRPT6                       (*((volatile unsigned int*)(0x42A68998UL)))
#define bM4_DMA2_RPT0_SRPT7                       (*((volatile unsigned int*)(0x42A6899CUL)))
#define bM4_DMA2_RPT0_SRPT8                       (*((volatile unsigned int*)(0x42A689A0UL)))
#define bM4_DMA2_RPT0_SRPT9                       (*((volatile unsigned int*)(0x42A689A4UL)))
#define bM4_DMA2_RPT0_DRPT0                       (*((volatile unsigned int*)(0x42A689C0UL)))
#define bM4_DMA2_RPT0_DRPT1                       (*((volatile unsigned int*)(0x42A689C4UL)))
#define bM4_DMA2_RPT0_DRPT2                       (*((volatile unsigned int*)(0x42A689C8UL)))
#define bM4_DMA2_RPT0_DRPT3                       (*((volatile unsigned int*)(0x42A689CCUL)))
#define bM4_DMA2_RPT0_DRPT4                       (*((volatile unsigned int*)(0x42A689D0UL)))
#define bM4_DMA2_RPT0_DRPT5                       (*((volatile unsigned int*)(0x42A689D4UL)))
#define bM4_DMA2_RPT0_DRPT6                       (*((volatile unsigned int*)(0x42A689D8UL)))
#define bM4_DMA2_RPT0_DRPT7                       (*((volatile unsigned int*)(0x42A689DCUL)))
#define bM4_DMA2_RPT0_DRPT8                       (*((volatile unsigned int*)(0x42A689E0UL)))
#define bM4_DMA2_RPT0_DRPT9                       (*((volatile unsigned int*)(0x42A689E4UL)))
#define bM4_DMA2_RPTB0_SRPTB0                     (*((volatile unsigned int*)(0x42A68980UL)))
#define bM4_DMA2_RPTB0_SRPTB1                     (*((volatile unsigned int*)(0x42A68984UL)))
#define bM4_DMA2_RPTB0_SRPTB2                     (*((volatile unsigned int*)(0x42A68988UL)))
#define bM4_DMA2_RPTB0_SRPTB3                     (*((volatile unsigned int*)(0x42A6898CUL)))
#define bM4_DMA2_RPTB0_SRPTB4                     (*((volatile unsigned int*)(0x42A68990UL)))
#define bM4_DMA2_RPTB0_SRPTB5                     (*((volatile unsigned int*)(0x42A68994UL)))
#define bM4_DMA2_RPTB0_SRPTB6                     (*((volatile unsigned int*)(0x42A68998UL)))
#define bM4_DMA2_RPTB0_SRPTB7                     (*((volatile unsigned int*)(0x42A6899CUL)))
#define bM4_DMA2_RPTB0_SRPTB8                     (*((volatile unsigned int*)(0x42A689A0UL)))
#define bM4_DMA2_RPTB0_SRPTB9                     (*((volatile unsigned int*)(0x42A689A4UL)))
#define bM4_DMA2_RPTB0_DRPTB0                     (*((volatile unsigned int*)(0x42A689C0UL)))
#define bM4_DMA2_RPTB0_DRPTB1                     (*((volatile unsigned int*)(0x42A689C4UL)))
#define bM4_DMA2_RPTB0_DRPTB2                     (*((volatile unsigned int*)(0x42A689C8UL)))
#define bM4_DMA2_RPTB0_DRPTB3                     (*((volatile unsigned int*)(0x42A689CCUL)))
#define bM4_DMA2_RPTB0_DRPTB4                     (*((volatile unsigned int*)(0x42A689D0UL)))
#define bM4_DMA2_RPTB0_DRPTB5                     (*((volatile unsigned int*)(0x42A689D4UL)))
#define bM4_DMA2_RPTB0_DRPTB6                     (*((volatile unsigned int*)(0x42A689D8UL)))
#define bM4_DMA2_RPTB0_DRPTB7                     (*((volatile unsigned int*)(0x42A689DCUL)))
#define bM4_DMA2_RPTB0_DRPTB8                     (*((volatile unsigned int*)(0x42A689E0UL)))
#define bM4_DMA2_RPTB0_DRPTB9                     (*((volatile unsigned int*)(0x42A689E4UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET0               (*((volatile unsigned int*)(0x42A68A00UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET1               (*((volatile unsigned int*)(0x42A68A04UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET2               (*((volatile unsigned int*)(0x42A68A08UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET3               (*((volatile unsigned int*)(0x42A68A0CUL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET4               (*((volatile unsigned int*)(0x42A68A10UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET5               (*((volatile unsigned int*)(0x42A68A14UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET6               (*((volatile unsigned int*)(0x42A68A18UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET7               (*((volatile unsigned int*)(0x42A68A1CUL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET8               (*((volatile unsigned int*)(0x42A68A20UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET9               (*((volatile unsigned int*)(0x42A68A24UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET10              (*((volatile unsigned int*)(0x42A68A28UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET11              (*((volatile unsigned int*)(0x42A68A2CUL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET12              (*((volatile unsigned int*)(0x42A68A30UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET13              (*((volatile unsigned int*)(0x42A68A34UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET14              (*((volatile unsigned int*)(0x42A68A38UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET15              (*((volatile unsigned int*)(0x42A68A3CUL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET16              (*((volatile unsigned int*)(0x42A68A40UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET17              (*((volatile unsigned int*)(0x42A68A44UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET18              (*((volatile unsigned int*)(0x42A68A48UL)))
#define bM4_DMA2_SNSEQCTL0_SOFFSET19              (*((volatile unsigned int*)(0x42A68A4CUL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT0                (*((volatile unsigned int*)(0x42A68A50UL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT1                (*((volatile unsigned int*)(0x42A68A54UL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT2                (*((volatile unsigned int*)(0x42A68A58UL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT3                (*((volatile unsigned int*)(0x42A68A5CUL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT4                (*((volatile unsigned int*)(0x42A68A60UL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT5                (*((volatile unsigned int*)(0x42A68A64UL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT6                (*((volatile unsigned int*)(0x42A68A68UL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT7                (*((volatile unsigned int*)(0x42A68A6CUL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT8                (*((volatile unsigned int*)(0x42A68A70UL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT9                (*((volatile unsigned int*)(0x42A68A74UL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT10               (*((volatile unsigned int*)(0x42A68A78UL)))
#define bM4_DMA2_SNSEQCTL0_SNSCNT11               (*((volatile unsigned int*)(0x42A68A7CUL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST0              (*((volatile unsigned int*)(0x42A68A00UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST1              (*((volatile unsigned int*)(0x42A68A04UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST2              (*((volatile unsigned int*)(0x42A68A08UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST3              (*((volatile unsigned int*)(0x42A68A0CUL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST4              (*((volatile unsigned int*)(0x42A68A10UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST5              (*((volatile unsigned int*)(0x42A68A14UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST6              (*((volatile unsigned int*)(0x42A68A18UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST7              (*((volatile unsigned int*)(0x42A68A1CUL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST8              (*((volatile unsigned int*)(0x42A68A20UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST9              (*((volatile unsigned int*)(0x42A68A24UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST10             (*((volatile unsigned int*)(0x42A68A28UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST11             (*((volatile unsigned int*)(0x42A68A2CUL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST12             (*((volatile unsigned int*)(0x42A68A30UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST13             (*((volatile unsigned int*)(0x42A68A34UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST14             (*((volatile unsigned int*)(0x42A68A38UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST15             (*((volatile unsigned int*)(0x42A68A3CUL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST16             (*((volatile unsigned int*)(0x42A68A40UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST17             (*((volatile unsigned int*)(0x42A68A44UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST18             (*((volatile unsigned int*)(0x42A68A48UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSDIST19             (*((volatile unsigned int*)(0x42A68A4CUL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB0              (*((volatile unsigned int*)(0x42A68A50UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB1              (*((volatile unsigned int*)(0x42A68A54UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB2              (*((volatile unsigned int*)(0x42A68A58UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB3              (*((volatile unsigned int*)(0x42A68A5CUL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB4              (*((volatile unsigned int*)(0x42A68A60UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB5              (*((volatile unsigned int*)(0x42A68A64UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB6              (*((volatile unsigned int*)(0x42A68A68UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB7              (*((volatile unsigned int*)(0x42A68A6CUL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB8              (*((volatile unsigned int*)(0x42A68A70UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB9              (*((volatile unsigned int*)(0x42A68A74UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB10             (*((volatile unsigned int*)(0x42A68A78UL)))
#define bM4_DMA2_SNSEQCTLB0_SNSCNTB11             (*((volatile unsigned int*)(0x42A68A7CUL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET0               (*((volatile unsigned int*)(0x42A68A80UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET1               (*((volatile unsigned int*)(0x42A68A84UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET2               (*((volatile unsigned int*)(0x42A68A88UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET3               (*((volatile unsigned int*)(0x42A68A8CUL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET4               (*((volatile unsigned int*)(0x42A68A90UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET5               (*((volatile unsigned int*)(0x42A68A94UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET6               (*((volatile unsigned int*)(0x42A68A98UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET7               (*((volatile unsigned int*)(0x42A68A9CUL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET8               (*((volatile unsigned int*)(0x42A68AA0UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET9               (*((volatile unsigned int*)(0x42A68AA4UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET10              (*((volatile unsigned int*)(0x42A68AA8UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET11              (*((volatile unsigned int*)(0x42A68AACUL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET12              (*((volatile unsigned int*)(0x42A68AB0UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET13              (*((volatile unsigned int*)(0x42A68AB4UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET14              (*((volatile unsigned int*)(0x42A68AB8UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET15              (*((volatile unsigned int*)(0x42A68ABCUL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET16              (*((volatile unsigned int*)(0x42A68AC0UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET17              (*((volatile unsigned int*)(0x42A68AC4UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET18              (*((volatile unsigned int*)(0x42A68AC8UL)))
#define bM4_DMA2_DNSEQCTL0_DOFFSET19              (*((volatile unsigned int*)(0x42A68ACCUL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT0                (*((volatile unsigned int*)(0x42A68AD0UL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT1                (*((volatile unsigned int*)(0x42A68AD4UL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT2                (*((volatile unsigned int*)(0x42A68AD8UL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT3                (*((volatile unsigned int*)(0x42A68ADCUL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT4                (*((volatile unsigned int*)(0x42A68AE0UL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT5                (*((volatile unsigned int*)(0x42A68AE4UL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT6                (*((volatile unsigned int*)(0x42A68AE8UL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT7                (*((volatile unsigned int*)(0x42A68AECUL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT8                (*((volatile unsigned int*)(0x42A68AF0UL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT9                (*((volatile unsigned int*)(0x42A68AF4UL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT10               (*((volatile unsigned int*)(0x42A68AF8UL)))
#define bM4_DMA2_DNSEQCTL0_DNSCNT11               (*((volatile unsigned int*)(0x42A68AFCUL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST0              (*((volatile unsigned int*)(0x42A68A80UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST1              (*((volatile unsigned int*)(0x42A68A84UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST2              (*((volatile unsigned int*)(0x42A68A88UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST3              (*((volatile unsigned int*)(0x42A68A8CUL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST4              (*((volatile unsigned int*)(0x42A68A90UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST5              (*((volatile unsigned int*)(0x42A68A94UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST6              (*((volatile unsigned int*)(0x42A68A98UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST7              (*((volatile unsigned int*)(0x42A68A9CUL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST8              (*((volatile unsigned int*)(0x42A68AA0UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST9              (*((volatile unsigned int*)(0x42A68AA4UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST10             (*((volatile unsigned int*)(0x42A68AA8UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST11             (*((volatile unsigned int*)(0x42A68AACUL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST12             (*((volatile unsigned int*)(0x42A68AB0UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST13             (*((volatile unsigned int*)(0x42A68AB4UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST14             (*((volatile unsigned int*)(0x42A68AB8UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST15             (*((volatile unsigned int*)(0x42A68ABCUL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST16             (*((volatile unsigned int*)(0x42A68AC0UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST17             (*((volatile unsigned int*)(0x42A68AC4UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST18             (*((volatile unsigned int*)(0x42A68AC8UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSDIST19             (*((volatile unsigned int*)(0x42A68ACCUL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB0              (*((volatile unsigned int*)(0x42A68AD0UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB1              (*((volatile unsigned int*)(0x42A68AD4UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB2              (*((volatile unsigned int*)(0x42A68AD8UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB3              (*((volatile unsigned int*)(0x42A68ADCUL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB4              (*((volatile unsigned int*)(0x42A68AE0UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB5              (*((volatile unsigned int*)(0x42A68AE4UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB6              (*((volatile unsigned int*)(0x42A68AE8UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB7              (*((volatile unsigned int*)(0x42A68AECUL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB8              (*((volatile unsigned int*)(0x42A68AF0UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB9              (*((volatile unsigned int*)(0x42A68AF4UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB10             (*((volatile unsigned int*)(0x42A68AF8UL)))
#define bM4_DMA2_DNSEQCTLB0_DNSCNTB11             (*((volatile unsigned int*)(0x42A68AFCUL)))
#define bM4_DMA2_LLP0_LLP0                        (*((volatile unsigned int*)(0x42A68B08UL)))
#define bM4_DMA2_LLP0_LLP1                        (*((volatile unsigned int*)(0x42A68B0CUL)))
#define bM4_DMA2_LLP0_LLP2                        (*((volatile unsigned int*)(0x42A68B10UL)))
#define bM4_DMA2_LLP0_LLP3                        (*((volatile unsigned int*)(0x42A68B14UL)))
#define bM4_DMA2_LLP0_LLP4                        (*((volatile unsigned int*)(0x42A68B18UL)))
#define bM4_DMA2_LLP0_LLP5                        (*((volatile unsigned int*)(0x42A68B1CUL)))
#define bM4_DMA2_LLP0_LLP6                        (*((volatile unsigned int*)(0x42A68B20UL)))
#define bM4_DMA2_LLP0_LLP7                        (*((volatile unsigned int*)(0x42A68B24UL)))
#define bM4_DMA2_LLP0_LLP8                        (*((volatile unsigned int*)(0x42A68B28UL)))
#define bM4_DMA2_LLP0_LLP9                        (*((volatile unsigned int*)(0x42A68B2CUL)))
#define bM4_DMA2_LLP0_LLP10                       (*((volatile unsigned int*)(0x42A68B30UL)))
#define bM4_DMA2_LLP0_LLP11                       (*((volatile unsigned int*)(0x42A68B34UL)))
#define bM4_DMA2_LLP0_LLP12                       (*((volatile unsigned int*)(0x42A68B38UL)))
#define bM4_DMA2_LLP0_LLP13                       (*((volatile unsigned int*)(0x42A68B3CUL)))
#define bM4_DMA2_LLP0_LLP14                       (*((volatile unsigned int*)(0x42A68B40UL)))
#define bM4_DMA2_LLP0_LLP15                       (*((volatile unsigned int*)(0x42A68B44UL)))
#define bM4_DMA2_LLP0_LLP16                       (*((volatile unsigned int*)(0x42A68B48UL)))
#define bM4_DMA2_LLP0_LLP17                       (*((volatile unsigned int*)(0x42A68B4CUL)))
#define bM4_DMA2_LLP0_LLP18                       (*((volatile unsigned int*)(0x42A68B50UL)))
#define bM4_DMA2_LLP0_LLP19                       (*((volatile unsigned int*)(0x42A68B54UL)))
#define bM4_DMA2_LLP0_LLP20                       (*((volatile unsigned int*)(0x42A68B58UL)))
#define bM4_DMA2_LLP0_LLP21                       (*((volatile unsigned int*)(0x42A68B5CUL)))
#define bM4_DMA2_LLP0_LLP22                       (*((volatile unsigned int*)(0x42A68B60UL)))
#define bM4_DMA2_LLP0_LLP23                       (*((volatile unsigned int*)(0x42A68B64UL)))
#define bM4_DMA2_LLP0_LLP24                       (*((volatile unsigned int*)(0x42A68B68UL)))
#define bM4_DMA2_LLP0_LLP25                       (*((volatile unsigned int*)(0x42A68B6CUL)))
#define bM4_DMA2_LLP0_LLP26                       (*((volatile unsigned int*)(0x42A68B70UL)))
#define bM4_DMA2_LLP0_LLP27                       (*((volatile unsigned int*)(0x42A68B74UL)))
#define bM4_DMA2_LLP0_LLP28                       (*((volatile unsigned int*)(0x42A68B78UL)))
#define bM4_DMA2_LLP0_LLP29                       (*((volatile unsigned int*)(0x42A68B7CUL)))
#define bM4_DMA2_CHCTL0_SINC0                     (*((volatile unsigned int*)(0x42A68B80UL)))
#define bM4_DMA2_CHCTL0_SINC1                     (*((volatile unsigned int*)(0x42A68B84UL)))
#define bM4_DMA2_CHCTL0_DINC0                     (*((volatile unsigned int*)(0x42A68B88UL)))
#define bM4_DMA2_CHCTL0_DINC1                     (*((volatile unsigned int*)(0x42A68B8CUL)))
#define bM4_DMA2_CHCTL0_SRPTEN                    (*((volatile unsigned int*)(0x42A68B90UL)))
#define bM4_DMA2_CHCTL0_DRPTEN                    (*((volatile unsigned int*)(0x42A68B94UL)))
#define bM4_DMA2_CHCTL0_SNSEQEN                   (*((volatile unsigned int*)(0x42A68B98UL)))
#define bM4_DMA2_CHCTL0_DNSEQEN                   (*((volatile unsigned int*)(0x42A68B9CUL)))
#define bM4_DMA2_CHCTL0_HSIZE0                    (*((volatile unsigned int*)(0x42A68BA0UL)))
#define bM4_DMA2_CHCTL0_HSIZE1                    (*((volatile unsigned int*)(0x42A68BA4UL)))
#define bM4_DMA2_CHCTL0_LLPEN                     (*((volatile unsigned int*)(0x42A68BA8UL)))
#define bM4_DMA2_CHCTL0_LLPRUN                    (*((volatile unsigned int*)(0x42A68BACUL)))
#define bM4_DMA2_CHCTL0_IE                        (*((volatile unsigned int*)(0x42A68BB0UL)))
#define bM4_DMA2_MONDTCTL0_BLKSIZE0               (*((volatile unsigned int*)(0x42A68D00UL)))
#define bM4_DMA2_MONDTCTL0_BLKSIZE1               (*((volatile unsigned int*)(0x42A68D04UL)))
#define bM4_DMA2_MONDTCTL0_BLKSIZE2               (*((volatile unsigned int*)(0x42A68D08UL)))
#define bM4_DMA2_MONDTCTL0_BLKSIZE3               (*((volatile unsigned int*)(0x42A68D0CUL)))
#define bM4_DMA2_MONDTCTL0_BLKSIZE4               (*((volatile unsigned int*)(0x42A68D10UL)))
#define bM4_DMA2_MONDTCTL0_BLKSIZE5               (*((volatile unsigned int*)(0x42A68D14UL)))
#define bM4_DMA2_MONDTCTL0_BLKSIZE6               (*((volatile unsigned int*)(0x42A68D18UL)))
#define bM4_DMA2_MONDTCTL0_BLKSIZE7               (*((volatile unsigned int*)(0x42A68D1CUL)))
#define bM4_DMA2_MONDTCTL0_BLKSIZE8               (*((volatile unsigned int*)(0x42A68D20UL)))
#define bM4_DMA2_MONDTCTL0_BLKSIZE9               (*((volatile unsigned int*)(0x42A68D24UL)))
#define bM4_DMA2_MONDTCTL0_CNT0                   (*((volatile unsigned int*)(0x42A68D40UL)))
#define bM4_DMA2_MONDTCTL0_CNT1                   (*((volatile unsigned int*)(0x42A68D44UL)))
#define bM4_DMA2_MONDTCTL0_CNT2                   (*((volatile unsigned int*)(0x42A68D48UL)))
#define bM4_DMA2_MONDTCTL0_CNT3                   (*((volatile unsigned int*)(0x42A68D4CUL)))
#define bM4_DMA2_MONDTCTL0_CNT4                   (*((volatile unsigned int*)(0x42A68D50UL)))
#define bM4_DMA2_MONDTCTL0_CNT5                   (*((volatile unsigned int*)(0x42A68D54UL)))
#define bM4_DMA2_MONDTCTL0_CNT6                   (*((volatile unsigned int*)(0x42A68D58UL)))
#define bM4_DMA2_MONDTCTL0_CNT7                   (*((volatile unsigned int*)(0x42A68D5CUL)))
#define bM4_DMA2_MONDTCTL0_CNT8                   (*((volatile unsigned int*)(0x42A68D60UL)))
#define bM4_DMA2_MONDTCTL0_CNT9                   (*((volatile unsigned int*)(0x42A68D64UL)))
#define bM4_DMA2_MONDTCTL0_CNT10                  (*((volatile unsigned int*)(0x42A68D68UL)))
#define bM4_DMA2_MONDTCTL0_CNT11                  (*((volatile unsigned int*)(0x42A68D6CUL)))
#define bM4_DMA2_MONDTCTL0_CNT12                  (*((volatile unsigned int*)(0x42A68D70UL)))
#define bM4_DMA2_MONDTCTL0_CNT13                  (*((volatile unsigned int*)(0x42A68D74UL)))
#define bM4_DMA2_MONDTCTL0_CNT14                  (*((volatile unsigned int*)(0x42A68D78UL)))
#define bM4_DMA2_MONDTCTL0_CNT15                  (*((volatile unsigned int*)(0x42A68D7CUL)))
#define bM4_DMA2_MONRPT0_SRPT0                    (*((volatile unsigned int*)(0x42A68D80UL)))
#define bM4_DMA2_MONRPT0_SRPT1                    (*((volatile unsigned int*)(0x42A68D84UL)))
#define bM4_DMA2_MONRPT0_SRPT2                    (*((volatile unsigned int*)(0x42A68D88UL)))
#define bM4_DMA2_MONRPT0_SRPT3                    (*((volatile unsigned int*)(0x42A68D8CUL)))
#define bM4_DMA2_MONRPT0_SRPT4                    (*((volatile unsigned int*)(0x42A68D90UL)))
#define bM4_DMA2_MONRPT0_SRPT5                    (*((volatile unsigned int*)(0x42A68D94UL)))
#define bM4_DMA2_MONRPT0_SRPT6                    (*((volatile unsigned int*)(0x42A68D98UL)))
#define bM4_DMA2_MONRPT0_SRPT7                    (*((volatile unsigned int*)(0x42A68D9CUL)))
#define bM4_DMA2_MONRPT0_SRPT8                    (*((volatile unsigned int*)(0x42A68DA0UL)))
#define bM4_DMA2_MONRPT0_SRPT9                    (*((volatile unsigned int*)(0x42A68DA4UL)))
#define bM4_DMA2_MONRPT0_DRPT0                    (*((volatile unsigned int*)(0x42A68DC0UL)))
#define bM4_DMA2_MONRPT0_DRPT1                    (*((volatile unsigned int*)(0x42A68DC4UL)))
#define bM4_DMA2_MONRPT0_DRPT2                    (*((volatile unsigned int*)(0x42A68DC8UL)))
#define bM4_DMA2_MONRPT0_DRPT3                    (*((volatile unsigned int*)(0x42A68DCCUL)))
#define bM4_DMA2_MONRPT0_DRPT4                    (*((volatile unsigned int*)(0x42A68DD0UL)))
#define bM4_DMA2_MONRPT0_DRPT5                    (*((volatile unsigned int*)(0x42A68DD4UL)))
#define bM4_DMA2_MONRPT0_DRPT6                    (*((volatile unsigned int*)(0x42A68DD8UL)))
#define bM4_DMA2_MONRPT0_DRPT7                    (*((volatile unsigned int*)(0x42A68DDCUL)))
#define bM4_DMA2_MONRPT0_DRPT8                    (*((volatile unsigned int*)(0x42A68DE0UL)))
#define bM4_DMA2_MONRPT0_DRPT9                    (*((volatile unsigned int*)(0x42A68DE4UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET0            (*((volatile unsigned int*)(0x42A68E00UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET1            (*((volatile unsigned int*)(0x42A68E04UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET2            (*((volatile unsigned int*)(0x42A68E08UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET3            (*((volatile unsigned int*)(0x42A68E0CUL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET4            (*((volatile unsigned int*)(0x42A68E10UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET5            (*((volatile unsigned int*)(0x42A68E14UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET6            (*((volatile unsigned int*)(0x42A68E18UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET7            (*((volatile unsigned int*)(0x42A68E1CUL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET8            (*((volatile unsigned int*)(0x42A68E20UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET9            (*((volatile unsigned int*)(0x42A68E24UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET10           (*((volatile unsigned int*)(0x42A68E28UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET11           (*((volatile unsigned int*)(0x42A68E2CUL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET12           (*((volatile unsigned int*)(0x42A68E30UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET13           (*((volatile unsigned int*)(0x42A68E34UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET14           (*((volatile unsigned int*)(0x42A68E38UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET15           (*((volatile unsigned int*)(0x42A68E3CUL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET16           (*((volatile unsigned int*)(0x42A68E40UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET17           (*((volatile unsigned int*)(0x42A68E44UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET18           (*((volatile unsigned int*)(0x42A68E48UL)))
#define bM4_DMA2_MONSNSEQCTL0_SOFFSET19           (*((volatile unsigned int*)(0x42A68E4CUL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT0             (*((volatile unsigned int*)(0x42A68E50UL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT1             (*((volatile unsigned int*)(0x42A68E54UL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT2             (*((volatile unsigned int*)(0x42A68E58UL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT3             (*((volatile unsigned int*)(0x42A68E5CUL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT4             (*((volatile unsigned int*)(0x42A68E60UL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT5             (*((volatile unsigned int*)(0x42A68E64UL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT6             (*((volatile unsigned int*)(0x42A68E68UL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT7             (*((volatile unsigned int*)(0x42A68E6CUL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT8             (*((volatile unsigned int*)(0x42A68E70UL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT9             (*((volatile unsigned int*)(0x42A68E74UL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT10            (*((volatile unsigned int*)(0x42A68E78UL)))
#define bM4_DMA2_MONSNSEQCTL0_SNSCNT11            (*((volatile unsigned int*)(0x42A68E7CUL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET0            (*((volatile unsigned int*)(0x42A68E80UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET1            (*((volatile unsigned int*)(0x42A68E84UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET2            (*((volatile unsigned int*)(0x42A68E88UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET3            (*((volatile unsigned int*)(0x42A68E8CUL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET4            (*((volatile unsigned int*)(0x42A68E90UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET5            (*((volatile unsigned int*)(0x42A68E94UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET6            (*((volatile unsigned int*)(0x42A68E98UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET7            (*((volatile unsigned int*)(0x42A68E9CUL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET8            (*((volatile unsigned int*)(0x42A68EA0UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET9            (*((volatile unsigned int*)(0x42A68EA4UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET10           (*((volatile unsigned int*)(0x42A68EA8UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET11           (*((volatile unsigned int*)(0x42A68EACUL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET12           (*((volatile unsigned int*)(0x42A68EB0UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET13           (*((volatile unsigned int*)(0x42A68EB4UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET14           (*((volatile unsigned int*)(0x42A68EB8UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET15           (*((volatile unsigned int*)(0x42A68EBCUL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET16           (*((volatile unsigned int*)(0x42A68EC0UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET17           (*((volatile unsigned int*)(0x42A68EC4UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET18           (*((volatile unsigned int*)(0x42A68EC8UL)))
#define bM4_DMA2_MONDNSEQCTL0_DOFFSET19           (*((volatile unsigned int*)(0x42A68ECCUL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT0             (*((volatile unsigned int*)(0x42A68ED0UL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT1             (*((volatile unsigned int*)(0x42A68ED4UL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT2             (*((volatile unsigned int*)(0x42A68ED8UL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT3             (*((volatile unsigned int*)(0x42A68EDCUL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT4             (*((volatile unsigned int*)(0x42A68EE0UL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT5             (*((volatile unsigned int*)(0x42A68EE4UL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT6             (*((volatile unsigned int*)(0x42A68EE8UL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT7             (*((volatile unsigned int*)(0x42A68EECUL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT8             (*((volatile unsigned int*)(0x42A68EF0UL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT9             (*((volatile unsigned int*)(0x42A68EF4UL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT10            (*((volatile unsigned int*)(0x42A68EF8UL)))
#define bM4_DMA2_MONDNSEQCTL0_DNSCNT11            (*((volatile unsigned int*)(0x42A68EFCUL)))
#define bM4_DMA2_DTCTL1_BLKSIZE0                  (*((volatile unsigned int*)(0x42A69100UL)))
#define bM4_DMA2_DTCTL1_BLKSIZE1                  (*((volatile unsigned int*)(0x42A69104UL)))
#define bM4_DMA2_DTCTL1_BLKSIZE2                  (*((volatile unsigned int*)(0x42A69108UL)))
#define bM4_DMA2_DTCTL1_BLKSIZE3                  (*((volatile unsigned int*)(0x42A6910CUL)))
#define bM4_DMA2_DTCTL1_BLKSIZE4                  (*((volatile unsigned int*)(0x42A69110UL)))
#define bM4_DMA2_DTCTL1_BLKSIZE5                  (*((volatile unsigned int*)(0x42A69114UL)))
#define bM4_DMA2_DTCTL1_BLKSIZE6                  (*((volatile unsigned int*)(0x42A69118UL)))
#define bM4_DMA2_DTCTL1_BLKSIZE7                  (*((volatile unsigned int*)(0x42A6911CUL)))
#define bM4_DMA2_DTCTL1_BLKSIZE8                  (*((volatile unsigned int*)(0x42A69120UL)))
#define bM4_DMA2_DTCTL1_BLKSIZE9                  (*((volatile unsigned int*)(0x42A69124UL)))
#define bM4_DMA2_DTCTL1_CNT0                      (*((volatile unsigned int*)(0x42A69140UL)))
#define bM4_DMA2_DTCTL1_CNT1                      (*((volatile unsigned int*)(0x42A69144UL)))
#define bM4_DMA2_DTCTL1_CNT2                      (*((volatile unsigned int*)(0x42A69148UL)))
#define bM4_DMA2_DTCTL1_CNT3                      (*((volatile unsigned int*)(0x42A6914CUL)))
#define bM4_DMA2_DTCTL1_CNT4                      (*((volatile unsigned int*)(0x42A69150UL)))
#define bM4_DMA2_DTCTL1_CNT5                      (*((volatile unsigned int*)(0x42A69154UL)))
#define bM4_DMA2_DTCTL1_CNT6                      (*((volatile unsigned int*)(0x42A69158UL)))
#define bM4_DMA2_DTCTL1_CNT7                      (*((volatile unsigned int*)(0x42A6915CUL)))
#define bM4_DMA2_DTCTL1_CNT8                      (*((volatile unsigned int*)(0x42A69160UL)))
#define bM4_DMA2_DTCTL1_CNT9                      (*((volatile unsigned int*)(0x42A69164UL)))
#define bM4_DMA2_DTCTL1_CNT10                     (*((volatile unsigned int*)(0x42A69168UL)))
#define bM4_DMA2_DTCTL1_CNT11                     (*((volatile unsigned int*)(0x42A6916CUL)))
#define bM4_DMA2_DTCTL1_CNT12                     (*((volatile unsigned int*)(0x42A69170UL)))
#define bM4_DMA2_DTCTL1_CNT13                     (*((volatile unsigned int*)(0x42A69174UL)))
#define bM4_DMA2_DTCTL1_CNT14                     (*((volatile unsigned int*)(0x42A69178UL)))
#define bM4_DMA2_DTCTL1_CNT15                     (*((volatile unsigned int*)(0x42A6917CUL)))
#define bM4_DMA2_RPT1_SRPT0                       (*((volatile unsigned int*)(0x42A69180UL)))
#define bM4_DMA2_RPT1_SRPT1                       (*((volatile unsigned int*)(0x42A69184UL)))
#define bM4_DMA2_RPT1_SRPT2                       (*((volatile unsigned int*)(0x42A69188UL)))
#define bM4_DMA2_RPT1_SRPT3                       (*((volatile unsigned int*)(0x42A6918CUL)))
#define bM4_DMA2_RPT1_SRPT4                       (*((volatile unsigned int*)(0x42A69190UL)))
#define bM4_DMA2_RPT1_SRPT5                       (*((volatile unsigned int*)(0x42A69194UL)))
#define bM4_DMA2_RPT1_SRPT6                       (*((volatile unsigned int*)(0x42A69198UL)))
#define bM4_DMA2_RPT1_SRPT7                       (*((volatile unsigned int*)(0x42A6919CUL)))
#define bM4_DMA2_RPT1_SRPT8                       (*((volatile unsigned int*)(0x42A691A0UL)))
#define bM4_DMA2_RPT1_SRPT9                       (*((volatile unsigned int*)(0x42A691A4UL)))
#define bM4_DMA2_RPT1_DRPT0                       (*((volatile unsigned int*)(0x42A691C0UL)))
#define bM4_DMA2_RPT1_DRPT1                       (*((volatile unsigned int*)(0x42A691C4UL)))
#define bM4_DMA2_RPT1_DRPT2                       (*((volatile unsigned int*)(0x42A691C8UL)))
#define bM4_DMA2_RPT1_DRPT3                       (*((volatile unsigned int*)(0x42A691CCUL)))
#define bM4_DMA2_RPT1_DRPT4                       (*((volatile unsigned int*)(0x42A691D0UL)))
#define bM4_DMA2_RPT1_DRPT5                       (*((volatile unsigned int*)(0x42A691D4UL)))
#define bM4_DMA2_RPT1_DRPT6                       (*((volatile unsigned int*)(0x42A691D8UL)))
#define bM4_DMA2_RPT1_DRPT7                       (*((volatile unsigned int*)(0x42A691DCUL)))
#define bM4_DMA2_RPT1_DRPT8                       (*((volatile unsigned int*)(0x42A691E0UL)))
#define bM4_DMA2_RPT1_DRPT9                       (*((volatile unsigned int*)(0x42A691E4UL)))
#define bM4_DMA2_RPTB1_SRPTB0                     (*((volatile unsigned int*)(0x42A69180UL)))
#define bM4_DMA2_RPTB1_SRPTB1                     (*((volatile unsigned int*)(0x42A69184UL)))
#define bM4_DMA2_RPTB1_SRPTB2                     (*((volatile unsigned int*)(0x42A69188UL)))
#define bM4_DMA2_RPTB1_SRPTB3                     (*((volatile unsigned int*)(0x42A6918CUL)))
#define bM4_DMA2_RPTB1_SRPTB4                     (*((volatile unsigned int*)(0x42A69190UL)))
#define bM4_DMA2_RPTB1_SRPTB5                     (*((volatile unsigned int*)(0x42A69194UL)))
#define bM4_DMA2_RPTB1_SRPTB6                     (*((volatile unsigned int*)(0x42A69198UL)))
#define bM4_DMA2_RPTB1_SRPTB7                     (*((volatile unsigned int*)(0x42A6919CUL)))
#define bM4_DMA2_RPTB1_SRPTB8                     (*((volatile unsigned int*)(0x42A691A0UL)))
#define bM4_DMA2_RPTB1_SRPTB9                     (*((volatile unsigned int*)(0x42A691A4UL)))
#define bM4_DMA2_RPTB1_DRPTB0                     (*((volatile unsigned int*)(0x42A691C0UL)))
#define bM4_DMA2_RPTB1_DRPTB1                     (*((volatile unsigned int*)(0x42A691C4UL)))
#define bM4_DMA2_RPTB1_DRPTB2                     (*((volatile unsigned int*)(0x42A691C8UL)))
#define bM4_DMA2_RPTB1_DRPTB3                     (*((volatile unsigned int*)(0x42A691CCUL)))
#define bM4_DMA2_RPTB1_DRPTB4                     (*((volatile unsigned int*)(0x42A691D0UL)))
#define bM4_DMA2_RPTB1_DRPTB5                     (*((volatile unsigned int*)(0x42A691D4UL)))
#define bM4_DMA2_RPTB1_DRPTB6                     (*((volatile unsigned int*)(0x42A691D8UL)))
#define bM4_DMA2_RPTB1_DRPTB7                     (*((volatile unsigned int*)(0x42A691DCUL)))
#define bM4_DMA2_RPTB1_DRPTB8                     (*((volatile unsigned int*)(0x42A691E0UL)))
#define bM4_DMA2_RPTB1_DRPTB9                     (*((volatile unsigned int*)(0x42A691E4UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET0               (*((volatile unsigned int*)(0x42A69200UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET1               (*((volatile unsigned int*)(0x42A69204UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET2               (*((volatile unsigned int*)(0x42A69208UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET3               (*((volatile unsigned int*)(0x42A6920CUL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET4               (*((volatile unsigned int*)(0x42A69210UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET5               (*((volatile unsigned int*)(0x42A69214UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET6               (*((volatile unsigned int*)(0x42A69218UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET7               (*((volatile unsigned int*)(0x42A6921CUL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET8               (*((volatile unsigned int*)(0x42A69220UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET9               (*((volatile unsigned int*)(0x42A69224UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET10              (*((volatile unsigned int*)(0x42A69228UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET11              (*((volatile unsigned int*)(0x42A6922CUL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET12              (*((volatile unsigned int*)(0x42A69230UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET13              (*((volatile unsigned int*)(0x42A69234UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET14              (*((volatile unsigned int*)(0x42A69238UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET15              (*((volatile unsigned int*)(0x42A6923CUL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET16              (*((volatile unsigned int*)(0x42A69240UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET17              (*((volatile unsigned int*)(0x42A69244UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET18              (*((volatile unsigned int*)(0x42A69248UL)))
#define bM4_DMA2_SNSEQCTL1_SOFFSET19              (*((volatile unsigned int*)(0x42A6924CUL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT0                (*((volatile unsigned int*)(0x42A69250UL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT1                (*((volatile unsigned int*)(0x42A69254UL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT2                (*((volatile unsigned int*)(0x42A69258UL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT3                (*((volatile unsigned int*)(0x42A6925CUL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT4                (*((volatile unsigned int*)(0x42A69260UL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT5                (*((volatile unsigned int*)(0x42A69264UL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT6                (*((volatile unsigned int*)(0x42A69268UL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT7                (*((volatile unsigned int*)(0x42A6926CUL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT8                (*((volatile unsigned int*)(0x42A69270UL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT9                (*((volatile unsigned int*)(0x42A69274UL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT10               (*((volatile unsigned int*)(0x42A69278UL)))
#define bM4_DMA2_SNSEQCTL1_SNSCNT11               (*((volatile unsigned int*)(0x42A6927CUL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST0              (*((volatile unsigned int*)(0x42A69200UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST1              (*((volatile unsigned int*)(0x42A69204UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST2              (*((volatile unsigned int*)(0x42A69208UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST3              (*((volatile unsigned int*)(0x42A6920CUL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST4              (*((volatile unsigned int*)(0x42A69210UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST5              (*((volatile unsigned int*)(0x42A69214UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST6              (*((volatile unsigned int*)(0x42A69218UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST7              (*((volatile unsigned int*)(0x42A6921CUL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST8              (*((volatile unsigned int*)(0x42A69220UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST9              (*((volatile unsigned int*)(0x42A69224UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST10             (*((volatile unsigned int*)(0x42A69228UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST11             (*((volatile unsigned int*)(0x42A6922CUL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST12             (*((volatile unsigned int*)(0x42A69230UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST13             (*((volatile unsigned int*)(0x42A69234UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST14             (*((volatile unsigned int*)(0x42A69238UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST15             (*((volatile unsigned int*)(0x42A6923CUL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST16             (*((volatile unsigned int*)(0x42A69240UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST17             (*((volatile unsigned int*)(0x42A69244UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST18             (*((volatile unsigned int*)(0x42A69248UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSDIST19             (*((volatile unsigned int*)(0x42A6924CUL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB0              (*((volatile unsigned int*)(0x42A69250UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB1              (*((volatile unsigned int*)(0x42A69254UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB2              (*((volatile unsigned int*)(0x42A69258UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB3              (*((volatile unsigned int*)(0x42A6925CUL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB4              (*((volatile unsigned int*)(0x42A69260UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB5              (*((volatile unsigned int*)(0x42A69264UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB6              (*((volatile unsigned int*)(0x42A69268UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB7              (*((volatile unsigned int*)(0x42A6926CUL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB8              (*((volatile unsigned int*)(0x42A69270UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB9              (*((volatile unsigned int*)(0x42A69274UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB10             (*((volatile unsigned int*)(0x42A69278UL)))
#define bM4_DMA2_SNSEQCTLB1_SNSCNTB11             (*((volatile unsigned int*)(0x42A6927CUL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET0               (*((volatile unsigned int*)(0x42A69280UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET1               (*((volatile unsigned int*)(0x42A69284UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET2               (*((volatile unsigned int*)(0x42A69288UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET3               (*((volatile unsigned int*)(0x42A6928CUL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET4               (*((volatile unsigned int*)(0x42A69290UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET5               (*((volatile unsigned int*)(0x42A69294UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET6               (*((volatile unsigned int*)(0x42A69298UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET7               (*((volatile unsigned int*)(0x42A6929CUL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET8               (*((volatile unsigned int*)(0x42A692A0UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET9               (*((volatile unsigned int*)(0x42A692A4UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET10              (*((volatile unsigned int*)(0x42A692A8UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET11              (*((volatile unsigned int*)(0x42A692ACUL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET12              (*((volatile unsigned int*)(0x42A692B0UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET13              (*((volatile unsigned int*)(0x42A692B4UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET14              (*((volatile unsigned int*)(0x42A692B8UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET15              (*((volatile unsigned int*)(0x42A692BCUL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET16              (*((volatile unsigned int*)(0x42A692C0UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET17              (*((volatile unsigned int*)(0x42A692C4UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET18              (*((volatile unsigned int*)(0x42A692C8UL)))
#define bM4_DMA2_DNSEQCTL1_DOFFSET19              (*((volatile unsigned int*)(0x42A692CCUL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT0                (*((volatile unsigned int*)(0x42A692D0UL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT1                (*((volatile unsigned int*)(0x42A692D4UL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT2                (*((volatile unsigned int*)(0x42A692D8UL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT3                (*((volatile unsigned int*)(0x42A692DCUL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT4                (*((volatile unsigned int*)(0x42A692E0UL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT5                (*((volatile unsigned int*)(0x42A692E4UL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT6                (*((volatile unsigned int*)(0x42A692E8UL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT7                (*((volatile unsigned int*)(0x42A692ECUL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT8                (*((volatile unsigned int*)(0x42A692F0UL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT9                (*((volatile unsigned int*)(0x42A692F4UL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT10               (*((volatile unsigned int*)(0x42A692F8UL)))
#define bM4_DMA2_DNSEQCTL1_DNSCNT11               (*((volatile unsigned int*)(0x42A692FCUL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST0              (*((volatile unsigned int*)(0x42A69280UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST1              (*((volatile unsigned int*)(0x42A69284UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST2              (*((volatile unsigned int*)(0x42A69288UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST3              (*((volatile unsigned int*)(0x42A6928CUL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST4              (*((volatile unsigned int*)(0x42A69290UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST5              (*((volatile unsigned int*)(0x42A69294UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST6              (*((volatile unsigned int*)(0x42A69298UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST7              (*((volatile unsigned int*)(0x42A6929CUL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST8              (*((volatile unsigned int*)(0x42A692A0UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST9              (*((volatile unsigned int*)(0x42A692A4UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST10             (*((volatile unsigned int*)(0x42A692A8UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST11             (*((volatile unsigned int*)(0x42A692ACUL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST12             (*((volatile unsigned int*)(0x42A692B0UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST13             (*((volatile unsigned int*)(0x42A692B4UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST14             (*((volatile unsigned int*)(0x42A692B8UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST15             (*((volatile unsigned int*)(0x42A692BCUL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST16             (*((volatile unsigned int*)(0x42A692C0UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST17             (*((volatile unsigned int*)(0x42A692C4UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST18             (*((volatile unsigned int*)(0x42A692C8UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSDIST19             (*((volatile unsigned int*)(0x42A692CCUL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB0              (*((volatile unsigned int*)(0x42A692D0UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB1              (*((volatile unsigned int*)(0x42A692D4UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB2              (*((volatile unsigned int*)(0x42A692D8UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB3              (*((volatile unsigned int*)(0x42A692DCUL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB4              (*((volatile unsigned int*)(0x42A692E0UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB5              (*((volatile unsigned int*)(0x42A692E4UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB6              (*((volatile unsigned int*)(0x42A692E8UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB7              (*((volatile unsigned int*)(0x42A692ECUL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB8              (*((volatile unsigned int*)(0x42A692F0UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB9              (*((volatile unsigned int*)(0x42A692F4UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB10             (*((volatile unsigned int*)(0x42A692F8UL)))
#define bM4_DMA2_DNSEQCTLB1_DNSCNTB11             (*((volatile unsigned int*)(0x42A692FCUL)))
#define bM4_DMA2_LLP1_LLP0                        (*((volatile unsigned int*)(0x42A69308UL)))
#define bM4_DMA2_LLP1_LLP1                        (*((volatile unsigned int*)(0x42A6930CUL)))
#define bM4_DMA2_LLP1_LLP2                        (*((volatile unsigned int*)(0x42A69310UL)))
#define bM4_DMA2_LLP1_LLP3                        (*((volatile unsigned int*)(0x42A69314UL)))
#define bM4_DMA2_LLP1_LLP4                        (*((volatile unsigned int*)(0x42A69318UL)))
#define bM4_DMA2_LLP1_LLP5                        (*((volatile unsigned int*)(0x42A6931CUL)))
#define bM4_DMA2_LLP1_LLP6                        (*((volatile unsigned int*)(0x42A69320UL)))
#define bM4_DMA2_LLP1_LLP7                        (*((volatile unsigned int*)(0x42A69324UL)))
#define bM4_DMA2_LLP1_LLP8                        (*((volatile unsigned int*)(0x42A69328UL)))
#define bM4_DMA2_LLP1_LLP9                        (*((volatile unsigned int*)(0x42A6932CUL)))
#define bM4_DMA2_LLP1_LLP10                       (*((volatile unsigned int*)(0x42A69330UL)))
#define bM4_DMA2_LLP1_LLP11                       (*((volatile unsigned int*)(0x42A69334UL)))
#define bM4_DMA2_LLP1_LLP12                       (*((volatile unsigned int*)(0x42A69338UL)))
#define bM4_DMA2_LLP1_LLP13                       (*((volatile unsigned int*)(0x42A6933CUL)))
#define bM4_DMA2_LLP1_LLP14                       (*((volatile unsigned int*)(0x42A69340UL)))
#define bM4_DMA2_LLP1_LLP15                       (*((volatile unsigned int*)(0x42A69344UL)))
#define bM4_DMA2_LLP1_LLP16                       (*((volatile unsigned int*)(0x42A69348UL)))
#define bM4_DMA2_LLP1_LLP17                       (*((volatile unsigned int*)(0x42A6934CUL)))
#define bM4_DMA2_LLP1_LLP18                       (*((volatile unsigned int*)(0x42A69350UL)))
#define bM4_DMA2_LLP1_LLP19                       (*((volatile unsigned int*)(0x42A69354UL)))
#define bM4_DMA2_LLP1_LLP20                       (*((volatile unsigned int*)(0x42A69358UL)))
#define bM4_DMA2_LLP1_LLP21                       (*((volatile unsigned int*)(0x42A6935CUL)))
#define bM4_DMA2_LLP1_LLP22                       (*((volatile unsigned int*)(0x42A69360UL)))
#define bM4_DMA2_LLP1_LLP23                       (*((volatile unsigned int*)(0x42A69364UL)))
#define bM4_DMA2_LLP1_LLP24                       (*((volatile unsigned int*)(0x42A69368UL)))
#define bM4_DMA2_LLP1_LLP25                       (*((volatile unsigned int*)(0x42A6936CUL)))
#define bM4_DMA2_LLP1_LLP26                       (*((volatile unsigned int*)(0x42A69370UL)))
#define bM4_DMA2_LLP1_LLP27                       (*((volatile unsigned int*)(0x42A69374UL)))
#define bM4_DMA2_LLP1_LLP28                       (*((volatile unsigned int*)(0x42A69378UL)))
#define bM4_DMA2_LLP1_LLP29                       (*((volatile unsigned int*)(0x42A6937CUL)))
#define bM4_DMA2_CHCTL1_SINC0                     (*((volatile unsigned int*)(0x42A69380UL)))
#define bM4_DMA2_CHCTL1_SINC1                     (*((volatile unsigned int*)(0x42A69384UL)))
#define bM4_DMA2_CHCTL1_DINC0                     (*((volatile unsigned int*)(0x42A69388UL)))
#define bM4_DMA2_CHCTL1_DINC1                     (*((volatile unsigned int*)(0x42A6938CUL)))
#define bM4_DMA2_CHCTL1_SRPTEN                    (*((volatile unsigned int*)(0x42A69390UL)))
#define bM4_DMA2_CHCTL1_DRPTEN                    (*((volatile unsigned int*)(0x42A69394UL)))
#define bM4_DMA2_CHCTL1_SNSEQEN                   (*((volatile unsigned int*)(0x42A69398UL)))
#define bM4_DMA2_CHCTL1_DNSEQEN                   (*((volatile unsigned int*)(0x42A6939CUL)))
#define bM4_DMA2_CHCTL1_HSIZE0                    (*((volatile unsigned int*)(0x42A693A0UL)))
#define bM4_DMA2_CHCTL1_HSIZE1                    (*((volatile unsigned int*)(0x42A693A4UL)))
#define bM4_DMA2_CHCTL1_LLPEN                     (*((volatile unsigned int*)(0x42A693A8UL)))
#define bM4_DMA2_CHCTL1_LLPRUN                    (*((volatile unsigned int*)(0x42A693ACUL)))
#define bM4_DMA2_CHCTL1_IE                        (*((volatile unsigned int*)(0x42A693B0UL)))
#define bM4_DMA2_MONDTCTL1_BLKSIZE0               (*((volatile unsigned int*)(0x42A69500UL)))
#define bM4_DMA2_MONDTCTL1_BLKSIZE1               (*((volatile unsigned int*)(0x42A69504UL)))
#define bM4_DMA2_MONDTCTL1_BLKSIZE2               (*((volatile unsigned int*)(0x42A69508UL)))
#define bM4_DMA2_MONDTCTL1_BLKSIZE3               (*((volatile unsigned int*)(0x42A6950CUL)))
#define bM4_DMA2_MONDTCTL1_BLKSIZE4               (*((volatile unsigned int*)(0x42A69510UL)))
#define bM4_DMA2_MONDTCTL1_BLKSIZE5               (*((volatile unsigned int*)(0x42A69514UL)))
#define bM4_DMA2_MONDTCTL1_BLKSIZE6               (*((volatile unsigned int*)(0x42A69518UL)))
#define bM4_DMA2_MONDTCTL1_BLKSIZE7               (*((volatile unsigned int*)(0x42A6951CUL)))
#define bM4_DMA2_MONDTCTL1_BLKSIZE8               (*((volatile unsigned int*)(0x42A69520UL)))
#define bM4_DMA2_MONDTCTL1_BLKSIZE9               (*((volatile unsigned int*)(0x42A69524UL)))
#define bM4_DMA2_MONDTCTL1_CNT0                   (*((volatile unsigned int*)(0x42A69540UL)))
#define bM4_DMA2_MONDTCTL1_CNT1                   (*((volatile unsigned int*)(0x42A69544UL)))
#define bM4_DMA2_MONDTCTL1_CNT2                   (*((volatile unsigned int*)(0x42A69548UL)))
#define bM4_DMA2_MONDTCTL1_CNT3                   (*((volatile unsigned int*)(0x42A6954CUL)))
#define bM4_DMA2_MONDTCTL1_CNT4                   (*((volatile unsigned int*)(0x42A69550UL)))
#define bM4_DMA2_MONDTCTL1_CNT5                   (*((volatile unsigned int*)(0x42A69554UL)))
#define bM4_DMA2_MONDTCTL1_CNT6                   (*((volatile unsigned int*)(0x42A69558UL)))
#define bM4_DMA2_MONDTCTL1_CNT7                   (*((volatile unsigned int*)(0x42A6955CUL)))
#define bM4_DMA2_MONDTCTL1_CNT8                   (*((volatile unsigned int*)(0x42A69560UL)))
#define bM4_DMA2_MONDTCTL1_CNT9                   (*((volatile unsigned int*)(0x42A69564UL)))
#define bM4_DMA2_MONDTCTL1_CNT10                  (*((volatile unsigned int*)(0x42A69568UL)))
#define bM4_DMA2_MONDTCTL1_CNT11                  (*((volatile unsigned int*)(0x42A6956CUL)))
#define bM4_DMA2_MONDTCTL1_CNT12                  (*((volatile unsigned int*)(0x42A69570UL)))
#define bM4_DMA2_MONDTCTL1_CNT13                  (*((volatile unsigned int*)(0x42A69574UL)))
#define bM4_DMA2_MONDTCTL1_CNT14                  (*((volatile unsigned int*)(0x42A69578UL)))
#define bM4_DMA2_MONDTCTL1_CNT15                  (*((volatile unsigned int*)(0x42A6957CUL)))
#define bM4_DMA2_MONRPT1_SRPT0                    (*((volatile unsigned int*)(0x42A69580UL)))
#define bM4_DMA2_MONRPT1_SRPT1                    (*((volatile unsigned int*)(0x42A69584UL)))
#define bM4_DMA2_MONRPT1_SRPT2                    (*((volatile unsigned int*)(0x42A69588UL)))
#define bM4_DMA2_MONRPT1_SRPT3                    (*((volatile unsigned int*)(0x42A6958CUL)))
#define bM4_DMA2_MONRPT1_SRPT4                    (*((volatile unsigned int*)(0x42A69590UL)))
#define bM4_DMA2_MONRPT1_SRPT5                    (*((volatile unsigned int*)(0x42A69594UL)))
#define bM4_DMA2_MONRPT1_SRPT6                    (*((volatile unsigned int*)(0x42A69598UL)))
#define bM4_DMA2_MONRPT1_SRPT7                    (*((volatile unsigned int*)(0x42A6959CUL)))
#define bM4_DMA2_MONRPT1_SRPT8                    (*((volatile unsigned int*)(0x42A695A0UL)))
#define bM4_DMA2_MONRPT1_SRPT9                    (*((volatile unsigned int*)(0x42A695A4UL)))
#define bM4_DMA2_MONRPT1_DRPT0                    (*((volatile unsigned int*)(0x42A695C0UL)))
#define bM4_DMA2_MONRPT1_DRPT1                    (*((volatile unsigned int*)(0x42A695C4UL)))
#define bM4_DMA2_MONRPT1_DRPT2                    (*((volatile unsigned int*)(0x42A695C8UL)))
#define bM4_DMA2_MONRPT1_DRPT3                    (*((volatile unsigned int*)(0x42A695CCUL)))
#define bM4_DMA2_MONRPT1_DRPT4                    (*((volatile unsigned int*)(0x42A695D0UL)))
#define bM4_DMA2_MONRPT1_DRPT5                    (*((volatile unsigned int*)(0x42A695D4UL)))
#define bM4_DMA2_MONRPT1_DRPT6                    (*((volatile unsigned int*)(0x42A695D8UL)))
#define bM4_DMA2_MONRPT1_DRPT7                    (*((volatile unsigned int*)(0x42A695DCUL)))
#define bM4_DMA2_MONRPT1_DRPT8                    (*((volatile unsigned int*)(0x42A695E0UL)))
#define bM4_DMA2_MONRPT1_DRPT9                    (*((volatile unsigned int*)(0x42A695E4UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET0            (*((volatile unsigned int*)(0x42A69600UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET1            (*((volatile unsigned int*)(0x42A69604UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET2            (*((volatile unsigned int*)(0x42A69608UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET3            (*((volatile unsigned int*)(0x42A6960CUL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET4            (*((volatile unsigned int*)(0x42A69610UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET5            (*((volatile unsigned int*)(0x42A69614UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET6            (*((volatile unsigned int*)(0x42A69618UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET7            (*((volatile unsigned int*)(0x42A6961CUL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET8            (*((volatile unsigned int*)(0x42A69620UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET9            (*((volatile unsigned int*)(0x42A69624UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET10           (*((volatile unsigned int*)(0x42A69628UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET11           (*((volatile unsigned int*)(0x42A6962CUL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET12           (*((volatile unsigned int*)(0x42A69630UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET13           (*((volatile unsigned int*)(0x42A69634UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET14           (*((volatile unsigned int*)(0x42A69638UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET15           (*((volatile unsigned int*)(0x42A6963CUL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET16           (*((volatile unsigned int*)(0x42A69640UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET17           (*((volatile unsigned int*)(0x42A69644UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET18           (*((volatile unsigned int*)(0x42A69648UL)))
#define bM4_DMA2_MONSNSEQCTL1_SOFFSET19           (*((volatile unsigned int*)(0x42A6964CUL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT0             (*((volatile unsigned int*)(0x42A69650UL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT1             (*((volatile unsigned int*)(0x42A69654UL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT2             (*((volatile unsigned int*)(0x42A69658UL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT3             (*((volatile unsigned int*)(0x42A6965CUL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT4             (*((volatile unsigned int*)(0x42A69660UL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT5             (*((volatile unsigned int*)(0x42A69664UL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT6             (*((volatile unsigned int*)(0x42A69668UL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT7             (*((volatile unsigned int*)(0x42A6966CUL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT8             (*((volatile unsigned int*)(0x42A69670UL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT9             (*((volatile unsigned int*)(0x42A69674UL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT10            (*((volatile unsigned int*)(0x42A69678UL)))
#define bM4_DMA2_MONSNSEQCTL1_SNSCNT11            (*((volatile unsigned int*)(0x42A6967CUL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET0            (*((volatile unsigned int*)(0x42A69680UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET1            (*((volatile unsigned int*)(0x42A69684UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET2            (*((volatile unsigned int*)(0x42A69688UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET3            (*((volatile unsigned int*)(0x42A6968CUL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET4            (*((volatile unsigned int*)(0x42A69690UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET5            (*((volatile unsigned int*)(0x42A69694UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET6            (*((volatile unsigned int*)(0x42A69698UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET7            (*((volatile unsigned int*)(0x42A6969CUL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET8            (*((volatile unsigned int*)(0x42A696A0UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET9            (*((volatile unsigned int*)(0x42A696A4UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET10           (*((volatile unsigned int*)(0x42A696A8UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET11           (*((volatile unsigned int*)(0x42A696ACUL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET12           (*((volatile unsigned int*)(0x42A696B0UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET13           (*((volatile unsigned int*)(0x42A696B4UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET14           (*((volatile unsigned int*)(0x42A696B8UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET15           (*((volatile unsigned int*)(0x42A696BCUL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET16           (*((volatile unsigned int*)(0x42A696C0UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET17           (*((volatile unsigned int*)(0x42A696C4UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET18           (*((volatile unsigned int*)(0x42A696C8UL)))
#define bM4_DMA2_MONDNSEQCTL1_DOFFSET19           (*((volatile unsigned int*)(0x42A696CCUL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT0             (*((volatile unsigned int*)(0x42A696D0UL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT1             (*((volatile unsigned int*)(0x42A696D4UL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT2             (*((volatile unsigned int*)(0x42A696D8UL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT3             (*((volatile unsigned int*)(0x42A696DCUL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT4             (*((volatile unsigned int*)(0x42A696E0UL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT5             (*((volatile unsigned int*)(0x42A696E4UL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT6             (*((volatile unsigned int*)(0x42A696E8UL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT7             (*((volatile unsigned int*)(0x42A696ECUL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT8             (*((volatile unsigned int*)(0x42A696F0UL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT9             (*((volatile unsigned int*)(0x42A696F4UL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT10            (*((volatile unsigned int*)(0x42A696F8UL)))
#define bM4_DMA2_MONDNSEQCTL1_DNSCNT11            (*((volatile unsigned int*)(0x42A696FCUL)))
#define bM4_DMA2_DTCTL2_BLKSIZE0                  (*((volatile unsigned int*)(0x42A69900UL)))
#define bM4_DMA2_DTCTL2_BLKSIZE1                  (*((volatile unsigned int*)(0x42A69904UL)))
#define bM4_DMA2_DTCTL2_BLKSIZE2                  (*((volatile unsigned int*)(0x42A69908UL)))
#define bM4_DMA2_DTCTL2_BLKSIZE3                  (*((volatile unsigned int*)(0x42A6990CUL)))
#define bM4_DMA2_DTCTL2_BLKSIZE4                  (*((volatile unsigned int*)(0x42A69910UL)))
#define bM4_DMA2_DTCTL2_BLKSIZE5                  (*((volatile unsigned int*)(0x42A69914UL)))
#define bM4_DMA2_DTCTL2_BLKSIZE6                  (*((volatile unsigned int*)(0x42A69918UL)))
#define bM4_DMA2_DTCTL2_BLKSIZE7                  (*((volatile unsigned int*)(0x42A6991CUL)))
#define bM4_DMA2_DTCTL2_BLKSIZE8                  (*((volatile unsigned int*)(0x42A69920UL)))
#define bM4_DMA2_DTCTL2_BLKSIZE9                  (*((volatile unsigned int*)(0x42A69924UL)))
#define bM4_DMA2_DTCTL2_CNT0                      (*((volatile unsigned int*)(0x42A69940UL)))
#define bM4_DMA2_DTCTL2_CNT1                      (*((volatile unsigned int*)(0x42A69944UL)))
#define bM4_DMA2_DTCTL2_CNT2                      (*((volatile unsigned int*)(0x42A69948UL)))
#define bM4_DMA2_DTCTL2_CNT3                      (*((volatile unsigned int*)(0x42A6994CUL)))
#define bM4_DMA2_DTCTL2_CNT4                      (*((volatile unsigned int*)(0x42A69950UL)))
#define bM4_DMA2_DTCTL2_CNT5                      (*((volatile unsigned int*)(0x42A69954UL)))
#define bM4_DMA2_DTCTL2_CNT6                      (*((volatile unsigned int*)(0x42A69958UL)))
#define bM4_DMA2_DTCTL2_CNT7                      (*((volatile unsigned int*)(0x42A6995CUL)))
#define bM4_DMA2_DTCTL2_CNT8                      (*((volatile unsigned int*)(0x42A69960UL)))
#define bM4_DMA2_DTCTL2_CNT9                      (*((volatile unsigned int*)(0x42A69964UL)))
#define bM4_DMA2_DTCTL2_CNT10                     (*((volatile unsigned int*)(0x42A69968UL)))
#define bM4_DMA2_DTCTL2_CNT11                     (*((volatile unsigned int*)(0x42A6996CUL)))
#define bM4_DMA2_DTCTL2_CNT12                     (*((volatile unsigned int*)(0x42A69970UL)))
#define bM4_DMA2_DTCTL2_CNT13                     (*((volatile unsigned int*)(0x42A69974UL)))
#define bM4_DMA2_DTCTL2_CNT14                     (*((volatile unsigned int*)(0x42A69978UL)))
#define bM4_DMA2_DTCTL2_CNT15                     (*((volatile unsigned int*)(0x42A6997CUL)))
#define bM4_DMA2_RPT2_SRPT0                       (*((volatile unsigned int*)(0x42A69980UL)))
#define bM4_DMA2_RPT2_SRPT1                       (*((volatile unsigned int*)(0x42A69984UL)))
#define bM4_DMA2_RPT2_SRPT2                       (*((volatile unsigned int*)(0x42A69988UL)))
#define bM4_DMA2_RPT2_SRPT3                       (*((volatile unsigned int*)(0x42A6998CUL)))
#define bM4_DMA2_RPT2_SRPT4                       (*((volatile unsigned int*)(0x42A69990UL)))
#define bM4_DMA2_RPT2_SRPT5                       (*((volatile unsigned int*)(0x42A69994UL)))
#define bM4_DMA2_RPT2_SRPT6                       (*((volatile unsigned int*)(0x42A69998UL)))
#define bM4_DMA2_RPT2_SRPT7                       (*((volatile unsigned int*)(0x42A6999CUL)))
#define bM4_DMA2_RPT2_SRPT8                       (*((volatile unsigned int*)(0x42A699A0UL)))
#define bM4_DMA2_RPT2_SRPT9                       (*((volatile unsigned int*)(0x42A699A4UL)))
#define bM4_DMA2_RPT2_DRPT0                       (*((volatile unsigned int*)(0x42A699C0UL)))
#define bM4_DMA2_RPT2_DRPT1                       (*((volatile unsigned int*)(0x42A699C4UL)))
#define bM4_DMA2_RPT2_DRPT2                       (*((volatile unsigned int*)(0x42A699C8UL)))
#define bM4_DMA2_RPT2_DRPT3                       (*((volatile unsigned int*)(0x42A699CCUL)))
#define bM4_DMA2_RPT2_DRPT4                       (*((volatile unsigned int*)(0x42A699D0UL)))
#define bM4_DMA2_RPT2_DRPT5                       (*((volatile unsigned int*)(0x42A699D4UL)))
#define bM4_DMA2_RPT2_DRPT6                       (*((volatile unsigned int*)(0x42A699D8UL)))
#define bM4_DMA2_RPT2_DRPT7                       (*((volatile unsigned int*)(0x42A699DCUL)))
#define bM4_DMA2_RPT2_DRPT8                       (*((volatile unsigned int*)(0x42A699E0UL)))
#define bM4_DMA2_RPT2_DRPT9                       (*((volatile unsigned int*)(0x42A699E4UL)))
#define bM4_DMA2_RPTB2_SRPTB0                     (*((volatile unsigned int*)(0x42A69980UL)))
#define bM4_DMA2_RPTB2_SRPTB1                     (*((volatile unsigned int*)(0x42A69984UL)))
#define bM4_DMA2_RPTB2_SRPTB2                     (*((volatile unsigned int*)(0x42A69988UL)))
#define bM4_DMA2_RPTB2_SRPTB3                     (*((volatile unsigned int*)(0x42A6998CUL)))
#define bM4_DMA2_RPTB2_SRPTB4                     (*((volatile unsigned int*)(0x42A69990UL)))
#define bM4_DMA2_RPTB2_SRPTB5                     (*((volatile unsigned int*)(0x42A69994UL)))
#define bM4_DMA2_RPTB2_SRPTB6                     (*((volatile unsigned int*)(0x42A69998UL)))
#define bM4_DMA2_RPTB2_SRPTB7                     (*((volatile unsigned int*)(0x42A6999CUL)))
#define bM4_DMA2_RPTB2_SRPTB8                     (*((volatile unsigned int*)(0x42A699A0UL)))
#define bM4_DMA2_RPTB2_SRPTB9                     (*((volatile unsigned int*)(0x42A699A4UL)))
#define bM4_DMA2_RPTB2_DRPTB0                     (*((volatile unsigned int*)(0x42A699C0UL)))
#define bM4_DMA2_RPTB2_DRPTB1                     (*((volatile unsigned int*)(0x42A699C4UL)))
#define bM4_DMA2_RPTB2_DRPTB2                     (*((volatile unsigned int*)(0x42A699C8UL)))
#define bM4_DMA2_RPTB2_DRPTB3                     (*((volatile unsigned int*)(0x42A699CCUL)))
#define bM4_DMA2_RPTB2_DRPTB4                     (*((volatile unsigned int*)(0x42A699D0UL)))
#define bM4_DMA2_RPTB2_DRPTB5                     (*((volatile unsigned int*)(0x42A699D4UL)))
#define bM4_DMA2_RPTB2_DRPTB6                     (*((volatile unsigned int*)(0x42A699D8UL)))
#define bM4_DMA2_RPTB2_DRPTB7                     (*((volatile unsigned int*)(0x42A699DCUL)))
#define bM4_DMA2_RPTB2_DRPTB8                     (*((volatile unsigned int*)(0x42A699E0UL)))
#define bM4_DMA2_RPTB2_DRPTB9                     (*((volatile unsigned int*)(0x42A699E4UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET0               (*((volatile unsigned int*)(0x42A69A00UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET1               (*((volatile unsigned int*)(0x42A69A04UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET2               (*((volatile unsigned int*)(0x42A69A08UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET3               (*((volatile unsigned int*)(0x42A69A0CUL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET4               (*((volatile unsigned int*)(0x42A69A10UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET5               (*((volatile unsigned int*)(0x42A69A14UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET6               (*((volatile unsigned int*)(0x42A69A18UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET7               (*((volatile unsigned int*)(0x42A69A1CUL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET8               (*((volatile unsigned int*)(0x42A69A20UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET9               (*((volatile unsigned int*)(0x42A69A24UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET10              (*((volatile unsigned int*)(0x42A69A28UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET11              (*((volatile unsigned int*)(0x42A69A2CUL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET12              (*((volatile unsigned int*)(0x42A69A30UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET13              (*((volatile unsigned int*)(0x42A69A34UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET14              (*((volatile unsigned int*)(0x42A69A38UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET15              (*((volatile unsigned int*)(0x42A69A3CUL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET16              (*((volatile unsigned int*)(0x42A69A40UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET17              (*((volatile unsigned int*)(0x42A69A44UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET18              (*((volatile unsigned int*)(0x42A69A48UL)))
#define bM4_DMA2_SNSEQCTL2_SOFFSET19              (*((volatile unsigned int*)(0x42A69A4CUL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT0                (*((volatile unsigned int*)(0x42A69A50UL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT1                (*((volatile unsigned int*)(0x42A69A54UL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT2                (*((volatile unsigned int*)(0x42A69A58UL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT3                (*((volatile unsigned int*)(0x42A69A5CUL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT4                (*((volatile unsigned int*)(0x42A69A60UL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT5                (*((volatile unsigned int*)(0x42A69A64UL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT6                (*((volatile unsigned int*)(0x42A69A68UL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT7                (*((volatile unsigned int*)(0x42A69A6CUL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT8                (*((volatile unsigned int*)(0x42A69A70UL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT9                (*((volatile unsigned int*)(0x42A69A74UL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT10               (*((volatile unsigned int*)(0x42A69A78UL)))
#define bM4_DMA2_SNSEQCTL2_SNSCNT11               (*((volatile unsigned int*)(0x42A69A7CUL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST0              (*((volatile unsigned int*)(0x42A69A00UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST1              (*((volatile unsigned int*)(0x42A69A04UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST2              (*((volatile unsigned int*)(0x42A69A08UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST3              (*((volatile unsigned int*)(0x42A69A0CUL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST4              (*((volatile unsigned int*)(0x42A69A10UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST5              (*((volatile unsigned int*)(0x42A69A14UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST6              (*((volatile unsigned int*)(0x42A69A18UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST7              (*((volatile unsigned int*)(0x42A69A1CUL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST8              (*((volatile unsigned int*)(0x42A69A20UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST9              (*((volatile unsigned int*)(0x42A69A24UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST10             (*((volatile unsigned int*)(0x42A69A28UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST11             (*((volatile unsigned int*)(0x42A69A2CUL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST12             (*((volatile unsigned int*)(0x42A69A30UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST13             (*((volatile unsigned int*)(0x42A69A34UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST14             (*((volatile unsigned int*)(0x42A69A38UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST15             (*((volatile unsigned int*)(0x42A69A3CUL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST16             (*((volatile unsigned int*)(0x42A69A40UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST17             (*((volatile unsigned int*)(0x42A69A44UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST18             (*((volatile unsigned int*)(0x42A69A48UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSDIST19             (*((volatile unsigned int*)(0x42A69A4CUL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB0              (*((volatile unsigned int*)(0x42A69A50UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB1              (*((volatile unsigned int*)(0x42A69A54UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB2              (*((volatile unsigned int*)(0x42A69A58UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB3              (*((volatile unsigned int*)(0x42A69A5CUL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB4              (*((volatile unsigned int*)(0x42A69A60UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB5              (*((volatile unsigned int*)(0x42A69A64UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB6              (*((volatile unsigned int*)(0x42A69A68UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB7              (*((volatile unsigned int*)(0x42A69A6CUL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB8              (*((volatile unsigned int*)(0x42A69A70UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB9              (*((volatile unsigned int*)(0x42A69A74UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB10             (*((volatile unsigned int*)(0x42A69A78UL)))
#define bM4_DMA2_SNSEQCTLB2_SNSCNTB11             (*((volatile unsigned int*)(0x42A69A7CUL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET0               (*((volatile unsigned int*)(0x42A69A80UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET1               (*((volatile unsigned int*)(0x42A69A84UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET2               (*((volatile unsigned int*)(0x42A69A88UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET3               (*((volatile unsigned int*)(0x42A69A8CUL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET4               (*((volatile unsigned int*)(0x42A69A90UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET5               (*((volatile unsigned int*)(0x42A69A94UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET6               (*((volatile unsigned int*)(0x42A69A98UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET7               (*((volatile unsigned int*)(0x42A69A9CUL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET8               (*((volatile unsigned int*)(0x42A69AA0UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET9               (*((volatile unsigned int*)(0x42A69AA4UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET10              (*((volatile unsigned int*)(0x42A69AA8UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET11              (*((volatile unsigned int*)(0x42A69AACUL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET12              (*((volatile unsigned int*)(0x42A69AB0UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET13              (*((volatile unsigned int*)(0x42A69AB4UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET14              (*((volatile unsigned int*)(0x42A69AB8UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET15              (*((volatile unsigned int*)(0x42A69ABCUL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET16              (*((volatile unsigned int*)(0x42A69AC0UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET17              (*((volatile unsigned int*)(0x42A69AC4UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET18              (*((volatile unsigned int*)(0x42A69AC8UL)))
#define bM4_DMA2_DNSEQCTL2_DOFFSET19              (*((volatile unsigned int*)(0x42A69ACCUL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT0                (*((volatile unsigned int*)(0x42A69AD0UL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT1                (*((volatile unsigned int*)(0x42A69AD4UL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT2                (*((volatile unsigned int*)(0x42A69AD8UL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT3                (*((volatile unsigned int*)(0x42A69ADCUL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT4                (*((volatile unsigned int*)(0x42A69AE0UL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT5                (*((volatile unsigned int*)(0x42A69AE4UL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT6                (*((volatile unsigned int*)(0x42A69AE8UL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT7                (*((volatile unsigned int*)(0x42A69AECUL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT8                (*((volatile unsigned int*)(0x42A69AF0UL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT9                (*((volatile unsigned int*)(0x42A69AF4UL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT10               (*((volatile unsigned int*)(0x42A69AF8UL)))
#define bM4_DMA2_DNSEQCTL2_DNSCNT11               (*((volatile unsigned int*)(0x42A69AFCUL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST0              (*((volatile unsigned int*)(0x42A69A80UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST1              (*((volatile unsigned int*)(0x42A69A84UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST2              (*((volatile unsigned int*)(0x42A69A88UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST3              (*((volatile unsigned int*)(0x42A69A8CUL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST4              (*((volatile unsigned int*)(0x42A69A90UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST5              (*((volatile unsigned int*)(0x42A69A94UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST6              (*((volatile unsigned int*)(0x42A69A98UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST7              (*((volatile unsigned int*)(0x42A69A9CUL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST8              (*((volatile unsigned int*)(0x42A69AA0UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST9              (*((volatile unsigned int*)(0x42A69AA4UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST10             (*((volatile unsigned int*)(0x42A69AA8UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST11             (*((volatile unsigned int*)(0x42A69AACUL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST12             (*((volatile unsigned int*)(0x42A69AB0UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST13             (*((volatile unsigned int*)(0x42A69AB4UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST14             (*((volatile unsigned int*)(0x42A69AB8UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST15             (*((volatile unsigned int*)(0x42A69ABCUL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST16             (*((volatile unsigned int*)(0x42A69AC0UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST17             (*((volatile unsigned int*)(0x42A69AC4UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST18             (*((volatile unsigned int*)(0x42A69AC8UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSDIST19             (*((volatile unsigned int*)(0x42A69ACCUL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB0              (*((volatile unsigned int*)(0x42A69AD0UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB1              (*((volatile unsigned int*)(0x42A69AD4UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB2              (*((volatile unsigned int*)(0x42A69AD8UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB3              (*((volatile unsigned int*)(0x42A69ADCUL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB4              (*((volatile unsigned int*)(0x42A69AE0UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB5              (*((volatile unsigned int*)(0x42A69AE4UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB6              (*((volatile unsigned int*)(0x42A69AE8UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB7              (*((volatile unsigned int*)(0x42A69AECUL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB8              (*((volatile unsigned int*)(0x42A69AF0UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB9              (*((volatile unsigned int*)(0x42A69AF4UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB10             (*((volatile unsigned int*)(0x42A69AF8UL)))
#define bM4_DMA2_DNSEQCTLB2_DNSCNTB11             (*((volatile unsigned int*)(0x42A69AFCUL)))
#define bM4_DMA2_LLP2_LLP0                        (*((volatile unsigned int*)(0x42A69B08UL)))
#define bM4_DMA2_LLP2_LLP1                        (*((volatile unsigned int*)(0x42A69B0CUL)))
#define bM4_DMA2_LLP2_LLP2                        (*((volatile unsigned int*)(0x42A69B10UL)))
#define bM4_DMA2_LLP2_LLP3                        (*((volatile unsigned int*)(0x42A69B14UL)))
#define bM4_DMA2_LLP2_LLP4                        (*((volatile unsigned int*)(0x42A69B18UL)))
#define bM4_DMA2_LLP2_LLP5                        (*((volatile unsigned int*)(0x42A69B1CUL)))
#define bM4_DMA2_LLP2_LLP6                        (*((volatile unsigned int*)(0x42A69B20UL)))
#define bM4_DMA2_LLP2_LLP7                        (*((volatile unsigned int*)(0x42A69B24UL)))
#define bM4_DMA2_LLP2_LLP8                        (*((volatile unsigned int*)(0x42A69B28UL)))
#define bM4_DMA2_LLP2_LLP9                        (*((volatile unsigned int*)(0x42A69B2CUL)))
#define bM4_DMA2_LLP2_LLP10                       (*((volatile unsigned int*)(0x42A69B30UL)))
#define bM4_DMA2_LLP2_LLP11                       (*((volatile unsigned int*)(0x42A69B34UL)))
#define bM4_DMA2_LLP2_LLP12                       (*((volatile unsigned int*)(0x42A69B38UL)))
#define bM4_DMA2_LLP2_LLP13                       (*((volatile unsigned int*)(0x42A69B3CUL)))
#define bM4_DMA2_LLP2_LLP14                       (*((volatile unsigned int*)(0x42A69B40UL)))
#define bM4_DMA2_LLP2_LLP15                       (*((volatile unsigned int*)(0x42A69B44UL)))
#define bM4_DMA2_LLP2_LLP16                       (*((volatile unsigned int*)(0x42A69B48UL)))
#define bM4_DMA2_LLP2_LLP17                       (*((volatile unsigned int*)(0x42A69B4CUL)))
#define bM4_DMA2_LLP2_LLP18                       (*((volatile unsigned int*)(0x42A69B50UL)))
#define bM4_DMA2_LLP2_LLP19                       (*((volatile unsigned int*)(0x42A69B54UL)))
#define bM4_DMA2_LLP2_LLP20                       (*((volatile unsigned int*)(0x42A69B58UL)))
#define bM4_DMA2_LLP2_LLP21                       (*((volatile unsigned int*)(0x42A69B5CUL)))
#define bM4_DMA2_LLP2_LLP22                       (*((volatile unsigned int*)(0x42A69B60UL)))
#define bM4_DMA2_LLP2_LLP23                       (*((volatile unsigned int*)(0x42A69B64UL)))
#define bM4_DMA2_LLP2_LLP24                       (*((volatile unsigned int*)(0x42A69B68UL)))
#define bM4_DMA2_LLP2_LLP25                       (*((volatile unsigned int*)(0x42A69B6CUL)))
#define bM4_DMA2_LLP2_LLP26                       (*((volatile unsigned int*)(0x42A69B70UL)))
#define bM4_DMA2_LLP2_LLP27                       (*((volatile unsigned int*)(0x42A69B74UL)))
#define bM4_DMA2_LLP2_LLP28                       (*((volatile unsigned int*)(0x42A69B78UL)))
#define bM4_DMA2_LLP2_LLP29                       (*((volatile unsigned int*)(0x42A69B7CUL)))
#define bM4_DMA2_CHCTL2_SINC0                     (*((volatile unsigned int*)(0x42A69B80UL)))
#define bM4_DMA2_CHCTL2_SINC1                     (*((volatile unsigned int*)(0x42A69B84UL)))
#define bM4_DMA2_CHCTL2_DINC0                     (*((volatile unsigned int*)(0x42A69B88UL)))
#define bM4_DMA2_CHCTL2_DINC1                     (*((volatile unsigned int*)(0x42A69B8CUL)))
#define bM4_DMA2_CHCTL2_SRPTEN                    (*((volatile unsigned int*)(0x42A69B90UL)))
#define bM4_DMA2_CHCTL2_DRPTEN                    (*((volatile unsigned int*)(0x42A69B94UL)))
#define bM4_DMA2_CHCTL2_SNSEQEN                   (*((volatile unsigned int*)(0x42A69B98UL)))
#define bM4_DMA2_CHCTL2_DNSEQEN                   (*((volatile unsigned int*)(0x42A69B9CUL)))
#define bM4_DMA2_CHCTL2_HSIZE0                    (*((volatile unsigned int*)(0x42A69BA0UL)))
#define bM4_DMA2_CHCTL2_HSIZE1                    (*((volatile unsigned int*)(0x42A69BA4UL)))
#define bM4_DMA2_CHCTL2_LLPEN                     (*((volatile unsigned int*)(0x42A69BA8UL)))
#define bM4_DMA2_CHCTL2_LLPRUN                    (*((volatile unsigned int*)(0x42A69BACUL)))
#define bM4_DMA2_CHCTL2_IE                        (*((volatile unsigned int*)(0x42A69BB0UL)))
#define bM4_DMA2_MONDTCTL2_BLKSIZE0               (*((volatile unsigned int*)(0x42A69D00UL)))
#define bM4_DMA2_MONDTCTL2_BLKSIZE1               (*((volatile unsigned int*)(0x42A69D04UL)))
#define bM4_DMA2_MONDTCTL2_BLKSIZE2               (*((volatile unsigned int*)(0x42A69D08UL)))
#define bM4_DMA2_MONDTCTL2_BLKSIZE3               (*((volatile unsigned int*)(0x42A69D0CUL)))
#define bM4_DMA2_MONDTCTL2_BLKSIZE4               (*((volatile unsigned int*)(0x42A69D10UL)))
#define bM4_DMA2_MONDTCTL2_BLKSIZE5               (*((volatile unsigned int*)(0x42A69D14UL)))
#define bM4_DMA2_MONDTCTL2_BLKSIZE6               (*((volatile unsigned int*)(0x42A69D18UL)))
#define bM4_DMA2_MONDTCTL2_BLKSIZE7               (*((volatile unsigned int*)(0x42A69D1CUL)))
#define bM4_DMA2_MONDTCTL2_BLKSIZE8               (*((volatile unsigned int*)(0x42A69D20UL)))
#define bM4_DMA2_MONDTCTL2_BLKSIZE9               (*((volatile unsigned int*)(0x42A69D24UL)))
#define bM4_DMA2_MONDTCTL2_CNT0                   (*((volatile unsigned int*)(0x42A69D40UL)))
#define bM4_DMA2_MONDTCTL2_CNT1                   (*((volatile unsigned int*)(0x42A69D44UL)))
#define bM4_DMA2_MONDTCTL2_CNT2                   (*((volatile unsigned int*)(0x42A69D48UL)))
#define bM4_DMA2_MONDTCTL2_CNT3                   (*((volatile unsigned int*)(0x42A69D4CUL)))
#define bM4_DMA2_MONDTCTL2_CNT4                   (*((volatile unsigned int*)(0x42A69D50UL)))
#define bM4_DMA2_MONDTCTL2_CNT5                   (*((volatile unsigned int*)(0x42A69D54UL)))
#define bM4_DMA2_MONDTCTL2_CNT6                   (*((volatile unsigned int*)(0x42A69D58UL)))
#define bM4_DMA2_MONDTCTL2_CNT7                   (*((volatile unsigned int*)(0x42A69D5CUL)))
#define bM4_DMA2_MONDTCTL2_CNT8                   (*((volatile unsigned int*)(0x42A69D60UL)))
#define bM4_DMA2_MONDTCTL2_CNT9                   (*((volatile unsigned int*)(0x42A69D64UL)))
#define bM4_DMA2_MONDTCTL2_CNT10                  (*((volatile unsigned int*)(0x42A69D68UL)))
#define bM4_DMA2_MONDTCTL2_CNT11                  (*((volatile unsigned int*)(0x42A69D6CUL)))
#define bM4_DMA2_MONDTCTL2_CNT12                  (*((volatile unsigned int*)(0x42A69D70UL)))
#define bM4_DMA2_MONDTCTL2_CNT13                  (*((volatile unsigned int*)(0x42A69D74UL)))
#define bM4_DMA2_MONDTCTL2_CNT14                  (*((volatile unsigned int*)(0x42A69D78UL)))
#define bM4_DMA2_MONDTCTL2_CNT15                  (*((volatile unsigned int*)(0x42A69D7CUL)))
#define bM4_DMA2_MONRPT2_SRPT0                    (*((volatile unsigned int*)(0x42A69D80UL)))
#define bM4_DMA2_MONRPT2_SRPT1                    (*((volatile unsigned int*)(0x42A69D84UL)))
#define bM4_DMA2_MONRPT2_SRPT2                    (*((volatile unsigned int*)(0x42A69D88UL)))
#define bM4_DMA2_MONRPT2_SRPT3                    (*((volatile unsigned int*)(0x42A69D8CUL)))
#define bM4_DMA2_MONRPT2_SRPT4                    (*((volatile unsigned int*)(0x42A69D90UL)))
#define bM4_DMA2_MONRPT2_SRPT5                    (*((volatile unsigned int*)(0x42A69D94UL)))
#define bM4_DMA2_MONRPT2_SRPT6                    (*((volatile unsigned int*)(0x42A69D98UL)))
#define bM4_DMA2_MONRPT2_SRPT7                    (*((volatile unsigned int*)(0x42A69D9CUL)))
#define bM4_DMA2_MONRPT2_SRPT8                    (*((volatile unsigned int*)(0x42A69DA0UL)))
#define bM4_DMA2_MONRPT2_SRPT9                    (*((volatile unsigned int*)(0x42A69DA4UL)))
#define bM4_DMA2_MONRPT2_DRPT0                    (*((volatile unsigned int*)(0x42A69DC0UL)))
#define bM4_DMA2_MONRPT2_DRPT1                    (*((volatile unsigned int*)(0x42A69DC4UL)))
#define bM4_DMA2_MONRPT2_DRPT2                    (*((volatile unsigned int*)(0x42A69DC8UL)))
#define bM4_DMA2_MONRPT2_DRPT3                    (*((volatile unsigned int*)(0x42A69DCCUL)))
#define bM4_DMA2_MONRPT2_DRPT4                    (*((volatile unsigned int*)(0x42A69DD0UL)))
#define bM4_DMA2_MONRPT2_DRPT5                    (*((volatile unsigned int*)(0x42A69DD4UL)))
#define bM4_DMA2_MONRPT2_DRPT6                    (*((volatile unsigned int*)(0x42A69DD8UL)))
#define bM4_DMA2_MONRPT2_DRPT7                    (*((volatile unsigned int*)(0x42A69DDCUL)))
#define bM4_DMA2_MONRPT2_DRPT8                    (*((volatile unsigned int*)(0x42A69DE0UL)))
#define bM4_DMA2_MONRPT2_DRPT9                    (*((volatile unsigned int*)(0x42A69DE4UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET0            (*((volatile unsigned int*)(0x42A69E00UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET1            (*((volatile unsigned int*)(0x42A69E04UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET2            (*((volatile unsigned int*)(0x42A69E08UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET3            (*((volatile unsigned int*)(0x42A69E0CUL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET4            (*((volatile unsigned int*)(0x42A69E10UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET5            (*((volatile unsigned int*)(0x42A69E14UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET6            (*((volatile unsigned int*)(0x42A69E18UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET7            (*((volatile unsigned int*)(0x42A69E1CUL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET8            (*((volatile unsigned int*)(0x42A69E20UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET9            (*((volatile unsigned int*)(0x42A69E24UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET10           (*((volatile unsigned int*)(0x42A69E28UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET11           (*((volatile unsigned int*)(0x42A69E2CUL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET12           (*((volatile unsigned int*)(0x42A69E30UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET13           (*((volatile unsigned int*)(0x42A69E34UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET14           (*((volatile unsigned int*)(0x42A69E38UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET15           (*((volatile unsigned int*)(0x42A69E3CUL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET16           (*((volatile unsigned int*)(0x42A69E40UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET17           (*((volatile unsigned int*)(0x42A69E44UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET18           (*((volatile unsigned int*)(0x42A69E48UL)))
#define bM4_DMA2_MONSNSEQCTL2_SOFFSET19           (*((volatile unsigned int*)(0x42A69E4CUL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT0             (*((volatile unsigned int*)(0x42A69E50UL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT1             (*((volatile unsigned int*)(0x42A69E54UL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT2             (*((volatile unsigned int*)(0x42A69E58UL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT3             (*((volatile unsigned int*)(0x42A69E5CUL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT4             (*((volatile unsigned int*)(0x42A69E60UL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT5             (*((volatile unsigned int*)(0x42A69E64UL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT6             (*((volatile unsigned int*)(0x42A69E68UL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT7             (*((volatile unsigned int*)(0x42A69E6CUL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT8             (*((volatile unsigned int*)(0x42A69E70UL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT9             (*((volatile unsigned int*)(0x42A69E74UL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT10            (*((volatile unsigned int*)(0x42A69E78UL)))
#define bM4_DMA2_MONSNSEQCTL2_SNSCNT11            (*((volatile unsigned int*)(0x42A69E7CUL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET0            (*((volatile unsigned int*)(0x42A69E80UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET1            (*((volatile unsigned int*)(0x42A69E84UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET2            (*((volatile unsigned int*)(0x42A69E88UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET3            (*((volatile unsigned int*)(0x42A69E8CUL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET4            (*((volatile unsigned int*)(0x42A69E90UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET5            (*((volatile unsigned int*)(0x42A69E94UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET6            (*((volatile unsigned int*)(0x42A69E98UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET7            (*((volatile unsigned int*)(0x42A69E9CUL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET8            (*((volatile unsigned int*)(0x42A69EA0UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET9            (*((volatile unsigned int*)(0x42A69EA4UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET10           (*((volatile unsigned int*)(0x42A69EA8UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET11           (*((volatile unsigned int*)(0x42A69EACUL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET12           (*((volatile unsigned int*)(0x42A69EB0UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET13           (*((volatile unsigned int*)(0x42A69EB4UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET14           (*((volatile unsigned int*)(0x42A69EB8UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET15           (*((volatile unsigned int*)(0x42A69EBCUL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET16           (*((volatile unsigned int*)(0x42A69EC0UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET17           (*((volatile unsigned int*)(0x42A69EC4UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET18           (*((volatile unsigned int*)(0x42A69EC8UL)))
#define bM4_DMA2_MONDNSEQCTL2_DOFFSET19           (*((volatile unsigned int*)(0x42A69ECCUL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT0             (*((volatile unsigned int*)(0x42A69ED0UL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT1             (*((volatile unsigned int*)(0x42A69ED4UL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT2             (*((volatile unsigned int*)(0x42A69ED8UL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT3             (*((volatile unsigned int*)(0x42A69EDCUL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT4             (*((volatile unsigned int*)(0x42A69EE0UL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT5             (*((volatile unsigned int*)(0x42A69EE4UL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT6             (*((volatile unsigned int*)(0x42A69EE8UL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT7             (*((volatile unsigned int*)(0x42A69EECUL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT8             (*((volatile unsigned int*)(0x42A69EF0UL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT9             (*((volatile unsigned int*)(0x42A69EF4UL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT10            (*((volatile unsigned int*)(0x42A69EF8UL)))
#define bM4_DMA2_MONDNSEQCTL2_DNSCNT11            (*((volatile unsigned int*)(0x42A69EFCUL)))
#define bM4_DMA2_DTCTL3_BLKSIZE0                  (*((volatile unsigned int*)(0x42A6A100UL)))
#define bM4_DMA2_DTCTL3_BLKSIZE1                  (*((volatile unsigned int*)(0x42A6A104UL)))
#define bM4_DMA2_DTCTL3_BLKSIZE2                  (*((volatile unsigned int*)(0x42A6A108UL)))
#define bM4_DMA2_DTCTL3_BLKSIZE3                  (*((volatile unsigned int*)(0x42A6A10CUL)))
#define bM4_DMA2_DTCTL3_BLKSIZE4                  (*((volatile unsigned int*)(0x42A6A110UL)))
#define bM4_DMA2_DTCTL3_BLKSIZE5                  (*((volatile unsigned int*)(0x42A6A114UL)))
#define bM4_DMA2_DTCTL3_BLKSIZE6                  (*((volatile unsigned int*)(0x42A6A118UL)))
#define bM4_DMA2_DTCTL3_BLKSIZE7                  (*((volatile unsigned int*)(0x42A6A11CUL)))
#define bM4_DMA2_DTCTL3_BLKSIZE8                  (*((volatile unsigned int*)(0x42A6A120UL)))
#define bM4_DMA2_DTCTL3_BLKSIZE9                  (*((volatile unsigned int*)(0x42A6A124UL)))
#define bM4_DMA2_DTCTL3_CNT0                      (*((volatile unsigned int*)(0x42A6A140UL)))
#define bM4_DMA2_DTCTL3_CNT1                      (*((volatile unsigned int*)(0x42A6A144UL)))
#define bM4_DMA2_DTCTL3_CNT2                      (*((volatile unsigned int*)(0x42A6A148UL)))
#define bM4_DMA2_DTCTL3_CNT3                      (*((volatile unsigned int*)(0x42A6A14CUL)))
#define bM4_DMA2_DTCTL3_CNT4                      (*((volatile unsigned int*)(0x42A6A150UL)))
#define bM4_DMA2_DTCTL3_CNT5                      (*((volatile unsigned int*)(0x42A6A154UL)))
#define bM4_DMA2_DTCTL3_CNT6                      (*((volatile unsigned int*)(0x42A6A158UL)))
#define bM4_DMA2_DTCTL3_CNT7                      (*((volatile unsigned int*)(0x42A6A15CUL)))
#define bM4_DMA2_DTCTL3_CNT8                      (*((volatile unsigned int*)(0x42A6A160UL)))
#define bM4_DMA2_DTCTL3_CNT9                      (*((volatile unsigned int*)(0x42A6A164UL)))
#define bM4_DMA2_DTCTL3_CNT10                     (*((volatile unsigned int*)(0x42A6A168UL)))
#define bM4_DMA2_DTCTL3_CNT11                     (*((volatile unsigned int*)(0x42A6A16CUL)))
#define bM4_DMA2_DTCTL3_CNT12                     (*((volatile unsigned int*)(0x42A6A170UL)))
#define bM4_DMA2_DTCTL3_CNT13                     (*((volatile unsigned int*)(0x42A6A174UL)))
#define bM4_DMA2_DTCTL3_CNT14                     (*((volatile unsigned int*)(0x42A6A178UL)))
#define bM4_DMA2_DTCTL3_CNT15                     (*((volatile unsigned int*)(0x42A6A17CUL)))
#define bM4_DMA2_RPT3_SRPT0                       (*((volatile unsigned int*)(0x42A6A180UL)))
#define bM4_DMA2_RPT3_SRPT1                       (*((volatile unsigned int*)(0x42A6A184UL)))
#define bM4_DMA2_RPT3_SRPT2                       (*((volatile unsigned int*)(0x42A6A188UL)))
#define bM4_DMA2_RPT3_SRPT3                       (*((volatile unsigned int*)(0x42A6A18CUL)))
#define bM4_DMA2_RPT3_SRPT4                       (*((volatile unsigned int*)(0x42A6A190UL)))
#define bM4_DMA2_RPT3_SRPT5                       (*((volatile unsigned int*)(0x42A6A194UL)))
#define bM4_DMA2_RPT3_SRPT6                       (*((volatile unsigned int*)(0x42A6A198UL)))
#define bM4_DMA2_RPT3_SRPT7                       (*((volatile unsigned int*)(0x42A6A19CUL)))
#define bM4_DMA2_RPT3_SRPT8                       (*((volatile unsigned int*)(0x42A6A1A0UL)))
#define bM4_DMA2_RPT3_SRPT9                       (*((volatile unsigned int*)(0x42A6A1A4UL)))
#define bM4_DMA2_RPT3_DRPT0                       (*((volatile unsigned int*)(0x42A6A1C0UL)))
#define bM4_DMA2_RPT3_DRPT1                       (*((volatile unsigned int*)(0x42A6A1C4UL)))
#define bM4_DMA2_RPT3_DRPT2                       (*((volatile unsigned int*)(0x42A6A1C8UL)))
#define bM4_DMA2_RPT3_DRPT3                       (*((volatile unsigned int*)(0x42A6A1CCUL)))
#define bM4_DMA2_RPT3_DRPT4                       (*((volatile unsigned int*)(0x42A6A1D0UL)))
#define bM4_DMA2_RPT3_DRPT5                       (*((volatile unsigned int*)(0x42A6A1D4UL)))
#define bM4_DMA2_RPT3_DRPT6                       (*((volatile unsigned int*)(0x42A6A1D8UL)))
#define bM4_DMA2_RPT3_DRPT7                       (*((volatile unsigned int*)(0x42A6A1DCUL)))
#define bM4_DMA2_RPT3_DRPT8                       (*((volatile unsigned int*)(0x42A6A1E0UL)))
#define bM4_DMA2_RPT3_DRPT9                       (*((volatile unsigned int*)(0x42A6A1E4UL)))
#define bM4_DMA2_RPTB3_SRPTB0                     (*((volatile unsigned int*)(0x42A6A180UL)))
#define bM4_DMA2_RPTB3_SRPTB1                     (*((volatile unsigned int*)(0x42A6A184UL)))
#define bM4_DMA2_RPTB3_SRPTB2                     (*((volatile unsigned int*)(0x42A6A188UL)))
#define bM4_DMA2_RPTB3_SRPTB3                     (*((volatile unsigned int*)(0x42A6A18CUL)))
#define bM4_DMA2_RPTB3_SRPTB4                     (*((volatile unsigned int*)(0x42A6A190UL)))
#define bM4_DMA2_RPTB3_SRPTB5                     (*((volatile unsigned int*)(0x42A6A194UL)))
#define bM4_DMA2_RPTB3_SRPTB6                     (*((volatile unsigned int*)(0x42A6A198UL)))
#define bM4_DMA2_RPTB3_SRPTB7                     (*((volatile unsigned int*)(0x42A6A19CUL)))
#define bM4_DMA2_RPTB3_SRPTB8                     (*((volatile unsigned int*)(0x42A6A1A0UL)))
#define bM4_DMA2_RPTB3_SRPTB9                     (*((volatile unsigned int*)(0x42A6A1A4UL)))
#define bM4_DMA2_RPTB3_DRPTB0                     (*((volatile unsigned int*)(0x42A6A1C0UL)))
#define bM4_DMA2_RPTB3_DRPTB1                     (*((volatile unsigned int*)(0x42A6A1C4UL)))
#define bM4_DMA2_RPTB3_DRPTB2                     (*((volatile unsigned int*)(0x42A6A1C8UL)))
#define bM4_DMA2_RPTB3_DRPTB3                     (*((volatile unsigned int*)(0x42A6A1CCUL)))
#define bM4_DMA2_RPTB3_DRPTB4                     (*((volatile unsigned int*)(0x42A6A1D0UL)))
#define bM4_DMA2_RPTB3_DRPTB5                     (*((volatile unsigned int*)(0x42A6A1D4UL)))
#define bM4_DMA2_RPTB3_DRPTB6                     (*((volatile unsigned int*)(0x42A6A1D8UL)))
#define bM4_DMA2_RPTB3_DRPTB7                     (*((volatile unsigned int*)(0x42A6A1DCUL)))
#define bM4_DMA2_RPTB3_DRPTB8                     (*((volatile unsigned int*)(0x42A6A1E0UL)))
#define bM4_DMA2_RPTB3_DRPTB9                     (*((volatile unsigned int*)(0x42A6A1E4UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET0               (*((volatile unsigned int*)(0x42A6A200UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET1               (*((volatile unsigned int*)(0x42A6A204UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET2               (*((volatile unsigned int*)(0x42A6A208UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET3               (*((volatile unsigned int*)(0x42A6A20CUL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET4               (*((volatile unsigned int*)(0x42A6A210UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET5               (*((volatile unsigned int*)(0x42A6A214UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET6               (*((volatile unsigned int*)(0x42A6A218UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET7               (*((volatile unsigned int*)(0x42A6A21CUL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET8               (*((volatile unsigned int*)(0x42A6A220UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET9               (*((volatile unsigned int*)(0x42A6A224UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET10              (*((volatile unsigned int*)(0x42A6A228UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET11              (*((volatile unsigned int*)(0x42A6A22CUL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET12              (*((volatile unsigned int*)(0x42A6A230UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET13              (*((volatile unsigned int*)(0x42A6A234UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET14              (*((volatile unsigned int*)(0x42A6A238UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET15              (*((volatile unsigned int*)(0x42A6A23CUL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET16              (*((volatile unsigned int*)(0x42A6A240UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET17              (*((volatile unsigned int*)(0x42A6A244UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET18              (*((volatile unsigned int*)(0x42A6A248UL)))
#define bM4_DMA2_SNSEQCTL3_SOFFSET19              (*((volatile unsigned int*)(0x42A6A24CUL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT0                (*((volatile unsigned int*)(0x42A6A250UL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT1                (*((volatile unsigned int*)(0x42A6A254UL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT2                (*((volatile unsigned int*)(0x42A6A258UL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT3                (*((volatile unsigned int*)(0x42A6A25CUL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT4                (*((volatile unsigned int*)(0x42A6A260UL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT5                (*((volatile unsigned int*)(0x42A6A264UL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT6                (*((volatile unsigned int*)(0x42A6A268UL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT7                (*((volatile unsigned int*)(0x42A6A26CUL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT8                (*((volatile unsigned int*)(0x42A6A270UL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT9                (*((volatile unsigned int*)(0x42A6A274UL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT10               (*((volatile unsigned int*)(0x42A6A278UL)))
#define bM4_DMA2_SNSEQCTL3_SNSCNT11               (*((volatile unsigned int*)(0x42A6A27CUL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST0              (*((volatile unsigned int*)(0x42A6A200UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST1              (*((volatile unsigned int*)(0x42A6A204UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST2              (*((volatile unsigned int*)(0x42A6A208UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST3              (*((volatile unsigned int*)(0x42A6A20CUL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST4              (*((volatile unsigned int*)(0x42A6A210UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST5              (*((volatile unsigned int*)(0x42A6A214UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST6              (*((volatile unsigned int*)(0x42A6A218UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST7              (*((volatile unsigned int*)(0x42A6A21CUL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST8              (*((volatile unsigned int*)(0x42A6A220UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST9              (*((volatile unsigned int*)(0x42A6A224UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST10             (*((volatile unsigned int*)(0x42A6A228UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST11             (*((volatile unsigned int*)(0x42A6A22CUL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST12             (*((volatile unsigned int*)(0x42A6A230UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST13             (*((volatile unsigned int*)(0x42A6A234UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST14             (*((volatile unsigned int*)(0x42A6A238UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST15             (*((volatile unsigned int*)(0x42A6A23CUL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST16             (*((volatile unsigned int*)(0x42A6A240UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST17             (*((volatile unsigned int*)(0x42A6A244UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST18             (*((volatile unsigned int*)(0x42A6A248UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSDIST19             (*((volatile unsigned int*)(0x42A6A24CUL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB0              (*((volatile unsigned int*)(0x42A6A250UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB1              (*((volatile unsigned int*)(0x42A6A254UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB2              (*((volatile unsigned int*)(0x42A6A258UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB3              (*((volatile unsigned int*)(0x42A6A25CUL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB4              (*((volatile unsigned int*)(0x42A6A260UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB5              (*((volatile unsigned int*)(0x42A6A264UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB6              (*((volatile unsigned int*)(0x42A6A268UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB7              (*((volatile unsigned int*)(0x42A6A26CUL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB8              (*((volatile unsigned int*)(0x42A6A270UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB9              (*((volatile unsigned int*)(0x42A6A274UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB10             (*((volatile unsigned int*)(0x42A6A278UL)))
#define bM4_DMA2_SNSEQCTLB3_SNSCNTB11             (*((volatile unsigned int*)(0x42A6A27CUL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET0               (*((volatile unsigned int*)(0x42A6A280UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET1               (*((volatile unsigned int*)(0x42A6A284UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET2               (*((volatile unsigned int*)(0x42A6A288UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET3               (*((volatile unsigned int*)(0x42A6A28CUL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET4               (*((volatile unsigned int*)(0x42A6A290UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET5               (*((volatile unsigned int*)(0x42A6A294UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET6               (*((volatile unsigned int*)(0x42A6A298UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET7               (*((volatile unsigned int*)(0x42A6A29CUL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET8               (*((volatile unsigned int*)(0x42A6A2A0UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET9               (*((volatile unsigned int*)(0x42A6A2A4UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET10              (*((volatile unsigned int*)(0x42A6A2A8UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET11              (*((volatile unsigned int*)(0x42A6A2ACUL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET12              (*((volatile unsigned int*)(0x42A6A2B0UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET13              (*((volatile unsigned int*)(0x42A6A2B4UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET14              (*((volatile unsigned int*)(0x42A6A2B8UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET15              (*((volatile unsigned int*)(0x42A6A2BCUL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET16              (*((volatile unsigned int*)(0x42A6A2C0UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET17              (*((volatile unsigned int*)(0x42A6A2C4UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET18              (*((volatile unsigned int*)(0x42A6A2C8UL)))
#define bM4_DMA2_DNSEQCTL3_DOFFSET19              (*((volatile unsigned int*)(0x42A6A2CCUL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT0                (*((volatile unsigned int*)(0x42A6A2D0UL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT1                (*((volatile unsigned int*)(0x42A6A2D4UL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT2                (*((volatile unsigned int*)(0x42A6A2D8UL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT3                (*((volatile unsigned int*)(0x42A6A2DCUL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT4                (*((volatile unsigned int*)(0x42A6A2E0UL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT5                (*((volatile unsigned int*)(0x42A6A2E4UL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT6                (*((volatile unsigned int*)(0x42A6A2E8UL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT7                (*((volatile unsigned int*)(0x42A6A2ECUL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT8                (*((volatile unsigned int*)(0x42A6A2F0UL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT9                (*((volatile unsigned int*)(0x42A6A2F4UL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT10               (*((volatile unsigned int*)(0x42A6A2F8UL)))
#define bM4_DMA2_DNSEQCTL3_DNSCNT11               (*((volatile unsigned int*)(0x42A6A2FCUL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST0              (*((volatile unsigned int*)(0x42A6A280UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST1              (*((volatile unsigned int*)(0x42A6A284UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST2              (*((volatile unsigned int*)(0x42A6A288UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST3              (*((volatile unsigned int*)(0x42A6A28CUL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST4              (*((volatile unsigned int*)(0x42A6A290UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST5              (*((volatile unsigned int*)(0x42A6A294UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST6              (*((volatile unsigned int*)(0x42A6A298UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST7              (*((volatile unsigned int*)(0x42A6A29CUL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST8              (*((volatile unsigned int*)(0x42A6A2A0UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST9              (*((volatile unsigned int*)(0x42A6A2A4UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST10             (*((volatile unsigned int*)(0x42A6A2A8UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST11             (*((volatile unsigned int*)(0x42A6A2ACUL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST12             (*((volatile unsigned int*)(0x42A6A2B0UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST13             (*((volatile unsigned int*)(0x42A6A2B4UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST14             (*((volatile unsigned int*)(0x42A6A2B8UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST15             (*((volatile unsigned int*)(0x42A6A2BCUL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST16             (*((volatile unsigned int*)(0x42A6A2C0UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST17             (*((volatile unsigned int*)(0x42A6A2C4UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST18             (*((volatile unsigned int*)(0x42A6A2C8UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSDIST19             (*((volatile unsigned int*)(0x42A6A2CCUL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB0              (*((volatile unsigned int*)(0x42A6A2D0UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB1              (*((volatile unsigned int*)(0x42A6A2D4UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB2              (*((volatile unsigned int*)(0x42A6A2D8UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB3              (*((volatile unsigned int*)(0x42A6A2DCUL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB4              (*((volatile unsigned int*)(0x42A6A2E0UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB5              (*((volatile unsigned int*)(0x42A6A2E4UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB6              (*((volatile unsigned int*)(0x42A6A2E8UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB7              (*((volatile unsigned int*)(0x42A6A2ECUL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB8              (*((volatile unsigned int*)(0x42A6A2F0UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB9              (*((volatile unsigned int*)(0x42A6A2F4UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB10             (*((volatile unsigned int*)(0x42A6A2F8UL)))
#define bM4_DMA2_DNSEQCTLB3_DNSCNTB11             (*((volatile unsigned int*)(0x42A6A2FCUL)))
#define bM4_DMA2_LLP3_LLP0                        (*((volatile unsigned int*)(0x42A6A308UL)))
#define bM4_DMA2_LLP3_LLP1                        (*((volatile unsigned int*)(0x42A6A30CUL)))
#define bM4_DMA2_LLP3_LLP2                        (*((volatile unsigned int*)(0x42A6A310UL)))
#define bM4_DMA2_LLP3_LLP3                        (*((volatile unsigned int*)(0x42A6A314UL)))
#define bM4_DMA2_LLP3_LLP4                        (*((volatile unsigned int*)(0x42A6A318UL)))
#define bM4_DMA2_LLP3_LLP5                        (*((volatile unsigned int*)(0x42A6A31CUL)))
#define bM4_DMA2_LLP3_LLP6                        (*((volatile unsigned int*)(0x42A6A320UL)))
#define bM4_DMA2_LLP3_LLP7                        (*((volatile unsigned int*)(0x42A6A324UL)))
#define bM4_DMA2_LLP3_LLP8                        (*((volatile unsigned int*)(0x42A6A328UL)))
#define bM4_DMA2_LLP3_LLP9                        (*((volatile unsigned int*)(0x42A6A32CUL)))
#define bM4_DMA2_LLP3_LLP10                       (*((volatile unsigned int*)(0x42A6A330UL)))
#define bM4_DMA2_LLP3_LLP11                       (*((volatile unsigned int*)(0x42A6A334UL)))
#define bM4_DMA2_LLP3_LLP12                       (*((volatile unsigned int*)(0x42A6A338UL)))
#define bM4_DMA2_LLP3_LLP13                       (*((volatile unsigned int*)(0x42A6A33CUL)))
#define bM4_DMA2_LLP3_LLP14                       (*((volatile unsigned int*)(0x42A6A340UL)))
#define bM4_DMA2_LLP3_LLP15                       (*((volatile unsigned int*)(0x42A6A344UL)))
#define bM4_DMA2_LLP3_LLP16                       (*((volatile unsigned int*)(0x42A6A348UL)))
#define bM4_DMA2_LLP3_LLP17                       (*((volatile unsigned int*)(0x42A6A34CUL)))
#define bM4_DMA2_LLP3_LLP18                       (*((volatile unsigned int*)(0x42A6A350UL)))
#define bM4_DMA2_LLP3_LLP19                       (*((volatile unsigned int*)(0x42A6A354UL)))
#define bM4_DMA2_LLP3_LLP20                       (*((volatile unsigned int*)(0x42A6A358UL)))
#define bM4_DMA2_LLP3_LLP21                       (*((volatile unsigned int*)(0x42A6A35CUL)))
#define bM4_DMA2_LLP3_LLP22                       (*((volatile unsigned int*)(0x42A6A360UL)))
#define bM4_DMA2_LLP3_LLP23                       (*((volatile unsigned int*)(0x42A6A364UL)))
#define bM4_DMA2_LLP3_LLP24                       (*((volatile unsigned int*)(0x42A6A368UL)))
#define bM4_DMA2_LLP3_LLP25                       (*((volatile unsigned int*)(0x42A6A36CUL)))
#define bM4_DMA2_LLP3_LLP26                       (*((volatile unsigned int*)(0x42A6A370UL)))
#define bM4_DMA2_LLP3_LLP27                       (*((volatile unsigned int*)(0x42A6A374UL)))
#define bM4_DMA2_LLP3_LLP28                       (*((volatile unsigned int*)(0x42A6A378UL)))
#define bM4_DMA2_LLP3_LLP29                       (*((volatile unsigned int*)(0x42A6A37CUL)))
#define bM4_DMA2_CHCTL3_SINC0                     (*((volatile unsigned int*)(0x42A6A380UL)))
#define bM4_DMA2_CHCTL3_SINC1                     (*((volatile unsigned int*)(0x42A6A384UL)))
#define bM4_DMA2_CHCTL3_DINC0                     (*((volatile unsigned int*)(0x42A6A388UL)))
#define bM4_DMA2_CHCTL3_DINC1                     (*((volatile unsigned int*)(0x42A6A38CUL)))
#define bM4_DMA2_CHCTL3_SRPTEN                    (*((volatile unsigned int*)(0x42A6A390UL)))
#define bM4_DMA2_CHCTL3_DRPTEN                    (*((volatile unsigned int*)(0x42A6A394UL)))
#define bM4_DMA2_CHCTL3_SNSEQEN                   (*((volatile unsigned int*)(0x42A6A398UL)))
#define bM4_DMA2_CHCTL3_DNSEQEN                   (*((volatile unsigned int*)(0x42A6A39CUL)))
#define bM4_DMA2_CHCTL3_HSIZE0                    (*((volatile unsigned int*)(0x42A6A3A0UL)))
#define bM4_DMA2_CHCTL3_HSIZE1                    (*((volatile unsigned int*)(0x42A6A3A4UL)))
#define bM4_DMA2_CHCTL3_LLPEN                     (*((volatile unsigned int*)(0x42A6A3A8UL)))
#define bM4_DMA2_CHCTL3_LLPRUN                    (*((volatile unsigned int*)(0x42A6A3ACUL)))
#define bM4_DMA2_CHCTL3_IE                        (*((volatile unsigned int*)(0x42A6A3B0UL)))
#define bM4_DMA2_MONDTCTL3_BLKSIZE0               (*((volatile unsigned int*)(0x42A6A500UL)))
#define bM4_DMA2_MONDTCTL3_BLKSIZE1               (*((volatile unsigned int*)(0x42A6A504UL)))
#define bM4_DMA2_MONDTCTL3_BLKSIZE2               (*((volatile unsigned int*)(0x42A6A508UL)))
#define bM4_DMA2_MONDTCTL3_BLKSIZE3               (*((volatile unsigned int*)(0x42A6A50CUL)))
#define bM4_DMA2_MONDTCTL3_BLKSIZE4               (*((volatile unsigned int*)(0x42A6A510UL)))
#define bM4_DMA2_MONDTCTL3_BLKSIZE5               (*((volatile unsigned int*)(0x42A6A514UL)))
#define bM4_DMA2_MONDTCTL3_BLKSIZE6               (*((volatile unsigned int*)(0x42A6A518UL)))
#define bM4_DMA2_MONDTCTL3_BLKSIZE7               (*((volatile unsigned int*)(0x42A6A51CUL)))
#define bM4_DMA2_MONDTCTL3_BLKSIZE8               (*((volatile unsigned int*)(0x42A6A520UL)))
#define bM4_DMA2_MONDTCTL3_BLKSIZE9               (*((volatile unsigned int*)(0x42A6A524UL)))
#define bM4_DMA2_MONDTCTL3_CNT0                   (*((volatile unsigned int*)(0x42A6A540UL)))
#define bM4_DMA2_MONDTCTL3_CNT1                   (*((volatile unsigned int*)(0x42A6A544UL)))
#define bM4_DMA2_MONDTCTL3_CNT2                   (*((volatile unsigned int*)(0x42A6A548UL)))
#define bM4_DMA2_MONDTCTL3_CNT3                   (*((volatile unsigned int*)(0x42A6A54CUL)))
#define bM4_DMA2_MONDTCTL3_CNT4                   (*((volatile unsigned int*)(0x42A6A550UL)))
#define bM4_DMA2_MONDTCTL3_CNT5                   (*((volatile unsigned int*)(0x42A6A554UL)))
#define bM4_DMA2_MONDTCTL3_CNT6                   (*((volatile unsigned int*)(0x42A6A558UL)))
#define bM4_DMA2_MONDTCTL3_CNT7                   (*((volatile unsigned int*)(0x42A6A55CUL)))
#define bM4_DMA2_MONDTCTL3_CNT8                   (*((volatile unsigned int*)(0x42A6A560UL)))
#define bM4_DMA2_MONDTCTL3_CNT9                   (*((volatile unsigned int*)(0x42A6A564UL)))
#define bM4_DMA2_MONDTCTL3_CNT10                  (*((volatile unsigned int*)(0x42A6A568UL)))
#define bM4_DMA2_MONDTCTL3_CNT11                  (*((volatile unsigned int*)(0x42A6A56CUL)))
#define bM4_DMA2_MONDTCTL3_CNT12                  (*((volatile unsigned int*)(0x42A6A570UL)))
#define bM4_DMA2_MONDTCTL3_CNT13                  (*((volatile unsigned int*)(0x42A6A574UL)))
#define bM4_DMA2_MONDTCTL3_CNT14                  (*((volatile unsigned int*)(0x42A6A578UL)))
#define bM4_DMA2_MONDTCTL3_CNT15                  (*((volatile unsigned int*)(0x42A6A57CUL)))
#define bM4_DMA2_MONRPT3_SRPT0                    (*((volatile unsigned int*)(0x42A6A580UL)))
#define bM4_DMA2_MONRPT3_SRPT1                    (*((volatile unsigned int*)(0x42A6A584UL)))
#define bM4_DMA2_MONRPT3_SRPT2                    (*((volatile unsigned int*)(0x42A6A588UL)))
#define bM4_DMA2_MONRPT3_SRPT3                    (*((volatile unsigned int*)(0x42A6A58CUL)))
#define bM4_DMA2_MONRPT3_SRPT4                    (*((volatile unsigned int*)(0x42A6A590UL)))
#define bM4_DMA2_MONRPT3_SRPT5                    (*((volatile unsigned int*)(0x42A6A594UL)))
#define bM4_DMA2_MONRPT3_SRPT6                    (*((volatile unsigned int*)(0x42A6A598UL)))
#define bM4_DMA2_MONRPT3_SRPT7                    (*((volatile unsigned int*)(0x42A6A59CUL)))
#define bM4_DMA2_MONRPT3_SRPT8                    (*((volatile unsigned int*)(0x42A6A5A0UL)))
#define bM4_DMA2_MONRPT3_SRPT9                    (*((volatile unsigned int*)(0x42A6A5A4UL)))
#define bM4_DMA2_MONRPT3_DRPT0                    (*((volatile unsigned int*)(0x42A6A5C0UL)))
#define bM4_DMA2_MONRPT3_DRPT1                    (*((volatile unsigned int*)(0x42A6A5C4UL)))
#define bM4_DMA2_MONRPT3_DRPT2                    (*((volatile unsigned int*)(0x42A6A5C8UL)))
#define bM4_DMA2_MONRPT3_DRPT3                    (*((volatile unsigned int*)(0x42A6A5CCUL)))
#define bM4_DMA2_MONRPT3_DRPT4                    (*((volatile unsigned int*)(0x42A6A5D0UL)))
#define bM4_DMA2_MONRPT3_DRPT5                    (*((volatile unsigned int*)(0x42A6A5D4UL)))
#define bM4_DMA2_MONRPT3_DRPT6                    (*((volatile unsigned int*)(0x42A6A5D8UL)))
#define bM4_DMA2_MONRPT3_DRPT7                    (*((volatile unsigned int*)(0x42A6A5DCUL)))
#define bM4_DMA2_MONRPT3_DRPT8                    (*((volatile unsigned int*)(0x42A6A5E0UL)))
#define bM4_DMA2_MONRPT3_DRPT9                    (*((volatile unsigned int*)(0x42A6A5E4UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET0            (*((volatile unsigned int*)(0x42A6A600UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET1            (*((volatile unsigned int*)(0x42A6A604UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET2            (*((volatile unsigned int*)(0x42A6A608UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET3            (*((volatile unsigned int*)(0x42A6A60CUL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET4            (*((volatile unsigned int*)(0x42A6A610UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET5            (*((volatile unsigned int*)(0x42A6A614UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET6            (*((volatile unsigned int*)(0x42A6A618UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET7            (*((volatile unsigned int*)(0x42A6A61CUL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET8            (*((volatile unsigned int*)(0x42A6A620UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET9            (*((volatile unsigned int*)(0x42A6A624UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET10           (*((volatile unsigned int*)(0x42A6A628UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET11           (*((volatile unsigned int*)(0x42A6A62CUL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET12           (*((volatile unsigned int*)(0x42A6A630UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET13           (*((volatile unsigned int*)(0x42A6A634UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET14           (*((volatile unsigned int*)(0x42A6A638UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET15           (*((volatile unsigned int*)(0x42A6A63CUL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET16           (*((volatile unsigned int*)(0x42A6A640UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET17           (*((volatile unsigned int*)(0x42A6A644UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET18           (*((volatile unsigned int*)(0x42A6A648UL)))
#define bM4_DMA2_MONSNSEQCTL3_SOFFSET19           (*((volatile unsigned int*)(0x42A6A64CUL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT0             (*((volatile unsigned int*)(0x42A6A650UL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT1             (*((volatile unsigned int*)(0x42A6A654UL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT2             (*((volatile unsigned int*)(0x42A6A658UL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT3             (*((volatile unsigned int*)(0x42A6A65CUL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT4             (*((volatile unsigned int*)(0x42A6A660UL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT5             (*((volatile unsigned int*)(0x42A6A664UL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT6             (*((volatile unsigned int*)(0x42A6A668UL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT7             (*((volatile unsigned int*)(0x42A6A66CUL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT8             (*((volatile unsigned int*)(0x42A6A670UL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT9             (*((volatile unsigned int*)(0x42A6A674UL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT10            (*((volatile unsigned int*)(0x42A6A678UL)))
#define bM4_DMA2_MONSNSEQCTL3_SNSCNT11            (*((volatile unsigned int*)(0x42A6A67CUL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET0            (*((volatile unsigned int*)(0x42A6A680UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET1            (*((volatile unsigned int*)(0x42A6A684UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET2            (*((volatile unsigned int*)(0x42A6A688UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET3            (*((volatile unsigned int*)(0x42A6A68CUL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET4            (*((volatile unsigned int*)(0x42A6A690UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET5            (*((volatile unsigned int*)(0x42A6A694UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET6            (*((volatile unsigned int*)(0x42A6A698UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET7            (*((volatile unsigned int*)(0x42A6A69CUL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET8            (*((volatile unsigned int*)(0x42A6A6A0UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET9            (*((volatile unsigned int*)(0x42A6A6A4UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET10           (*((volatile unsigned int*)(0x42A6A6A8UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET11           (*((volatile unsigned int*)(0x42A6A6ACUL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET12           (*((volatile unsigned int*)(0x42A6A6B0UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET13           (*((volatile unsigned int*)(0x42A6A6B4UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET14           (*((volatile unsigned int*)(0x42A6A6B8UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET15           (*((volatile unsigned int*)(0x42A6A6BCUL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET16           (*((volatile unsigned int*)(0x42A6A6C0UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET17           (*((volatile unsigned int*)(0x42A6A6C4UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET18           (*((volatile unsigned int*)(0x42A6A6C8UL)))
#define bM4_DMA2_MONDNSEQCTL3_DOFFSET19           (*((volatile unsigned int*)(0x42A6A6CCUL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT0             (*((volatile unsigned int*)(0x42A6A6D0UL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT1             (*((volatile unsigned int*)(0x42A6A6D4UL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT2             (*((volatile unsigned int*)(0x42A6A6D8UL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT3             (*((volatile unsigned int*)(0x42A6A6DCUL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT4             (*((volatile unsigned int*)(0x42A6A6E0UL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT5             (*((volatile unsigned int*)(0x42A6A6E4UL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT6             (*((volatile unsigned int*)(0x42A6A6E8UL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT7             (*((volatile unsigned int*)(0x42A6A6ECUL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT8             (*((volatile unsigned int*)(0x42A6A6F0UL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT9             (*((volatile unsigned int*)(0x42A6A6F4UL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT10            (*((volatile unsigned int*)(0x42A6A6F8UL)))
#define bM4_DMA2_MONDNSEQCTL3_DNSCNT11            (*((volatile unsigned int*)(0x42A6A6FCUL)))
#define bM4_EFM_FAPRT_FAPRT0                      (*((volatile unsigned int*)(0x42208000UL)))
#define bM4_EFM_FAPRT_FAPRT1                      (*((volatile unsigned int*)(0x42208004UL)))
#define bM4_EFM_FAPRT_FAPRT2                      (*((volatile unsigned int*)(0x42208008UL)))
#define bM4_EFM_FAPRT_FAPRT3                      (*((volatile unsigned int*)(0x4220800CUL)))
#define bM4_EFM_FAPRT_FAPRT4                      (*((volatile unsigned int*)(0x42208010UL)))
#define bM4_EFM_FAPRT_FAPRT5                      (*((volatile unsigned int*)(0x42208014UL)))
#define bM4_EFM_FAPRT_FAPRT6                      (*((volatile unsigned int*)(0x42208018UL)))
#define bM4_EFM_FAPRT_FAPRT7                      (*((volatile unsigned int*)(0x4220801CUL)))
#define bM4_EFM_FAPRT_FAPRT8                      (*((volatile unsigned int*)(0x42208020UL)))
#define bM4_EFM_FAPRT_FAPRT9                      (*((volatile unsigned int*)(0x42208024UL)))
#define bM4_EFM_FAPRT_FAPRT10                     (*((volatile unsigned int*)(0x42208028UL)))
#define bM4_EFM_FAPRT_FAPRT11                     (*((volatile unsigned int*)(0x4220802CUL)))
#define bM4_EFM_FAPRT_FAPRT12                     (*((volatile unsigned int*)(0x42208030UL)))
#define bM4_EFM_FAPRT_FAPRT13                     (*((volatile unsigned int*)(0x42208034UL)))
#define bM4_EFM_FAPRT_FAPRT14                     (*((volatile unsigned int*)(0x42208038UL)))
#define bM4_EFM_FAPRT_FAPRT15                     (*((volatile unsigned int*)(0x4220803CUL)))
#define bM4_EFM_FSTP_FSTP                         (*((volatile unsigned int*)(0x42208080UL)))
#define bM4_EFM_FRMC_SLPMD                        (*((volatile unsigned int*)(0x42208100UL)))
#define bM4_EFM_FRMC_FLWT0                        (*((volatile unsigned int*)(0x42208110UL)))
#define bM4_EFM_FRMC_FLWT1                        (*((volatile unsigned int*)(0x42208114UL)))
#define bM4_EFM_FRMC_FLWT2                        (*((volatile unsigned int*)(0x42208118UL)))
#define bM4_EFM_FRMC_FLWT3                        (*((volatile unsigned int*)(0x4220811CUL)))
#define bM4_EFM_FRMC_LVM                          (*((volatile unsigned int*)(0x42208120UL)))
#define bM4_EFM_FRMC_CACHE                        (*((volatile unsigned int*)(0x42208140UL)))
#define bM4_EFM_FRMC_CRST                         (*((volatile unsigned int*)(0x42208160UL)))
#define bM4_EFM_FWMC_PEMODE                       (*((volatile unsigned int*)(0x42208180UL)))
#define bM4_EFM_FWMC_PEMOD0                       (*((volatile unsigned int*)(0x42208190UL)))
#define bM4_EFM_FWMC_PEMOD1                       (*((volatile unsigned int*)(0x42208194UL)))
#define bM4_EFM_FWMC_PEMOD2                       (*((volatile unsigned int*)(0x42208198UL)))
#define bM4_EFM_FWMC_BUSHLDCTL                    (*((volatile unsigned int*)(0x422081A0UL)))
#define bM4_EFM_FSR_PEWERR                        (*((volatile unsigned int*)(0x42208200UL)))
#define bM4_EFM_FSR_PEPRTERR                      (*((volatile unsigned int*)(0x42208204UL)))
#define bM4_EFM_FSR_PGSZERR                       (*((volatile unsigned int*)(0x42208208UL)))
#define bM4_EFM_FSR_PGMISMTCH                     (*((volatile unsigned int*)(0x4220820CUL)))
#define bM4_EFM_FSR_OPTEND                        (*((volatile unsigned int*)(0x42208210UL)))
#define bM4_EFM_FSR_COLERR                        (*((volatile unsigned int*)(0x42208214UL)))
#define bM4_EFM_FSR_RDY                           (*((volatile unsigned int*)(0x42208220UL)))
#define bM4_EFM_FSCLR_PEWERRCLR                   (*((volatile unsigned int*)(0x42208280UL)))
#define bM4_EFM_FSCLR_PEPRTERRCLR                 (*((volatile unsigned int*)(0x42208284UL)))
#define bM4_EFM_FSCLR_PGSZERRCLR                  (*((volatile unsigned int*)(0x42208288UL)))
#define bM4_EFM_FSCLR_PGMISMTCHCLR                (*((volatile unsigned int*)(0x4220828CUL)))
#define bM4_EFM_FSCLR_OPTENDCLR                   (*((volatile unsigned int*)(0x42208290UL)))
#define bM4_EFM_FSCLR_COLERRCLR                   (*((volatile unsigned int*)(0x42208294UL)))
#define bM4_EFM_FITE_PEERRITE                     (*((volatile unsigned int*)(0x42208300UL)))
#define bM4_EFM_FITE_OPTENDITE                    (*((volatile unsigned int*)(0x42208304UL)))
#define bM4_EFM_FITE_COLERRITE                    (*((volatile unsigned int*)(0x42208308UL)))
#define bM4_EFM_FSWP_FSWP                         (*((volatile unsigned int*)(0x42208380UL)))
#define bM4_EFM_FPMTSW_FPMTSW0                    (*((volatile unsigned int*)(0x42208400UL)))
#define bM4_EFM_FPMTSW_FPMTSW1                    (*((volatile unsigned int*)(0x42208404UL)))
#define bM4_EFM_FPMTSW_FPMTSW2                    (*((volatile unsigned int*)(0x42208408UL)))
#define bM4_EFM_FPMTSW_FPMTSW3                    (*((volatile unsigned int*)(0x4220840CUL)))
#define bM4_EFM_FPMTSW_FPMTSW4                    (*((volatile unsigned int*)(0x42208410UL)))
#define bM4_EFM_FPMTSW_FPMTSW5                    (*((volatile unsigned int*)(0x42208414UL)))
#define bM4_EFM_FPMTSW_FPMTSW6                    (*((volatile unsigned int*)(0x42208418UL)))
#define bM4_EFM_FPMTSW_FPMTSW7                    (*((volatile unsigned int*)(0x4220841CUL)))
#define bM4_EFM_FPMTSW_FPMTSW8                    (*((volatile unsigned int*)(0x42208420UL)))
#define bM4_EFM_FPMTSW_FPMTSW9                    (*((volatile unsigned int*)(0x42208424UL)))
#define bM4_EFM_FPMTSW_FPMTSW10                   (*((volatile unsigned int*)(0x42208428UL)))
#define bM4_EFM_FPMTSW_FPMTSW11                   (*((volatile unsigned int*)(0x4220842CUL)))
#define bM4_EFM_FPMTSW_FPMTSW12                   (*((volatile unsigned int*)(0x42208430UL)))
#define bM4_EFM_FPMTSW_FPMTSW13                   (*((volatile unsigned int*)(0x42208434UL)))
#define bM4_EFM_FPMTSW_FPMTSW14                   (*((volatile unsigned int*)(0x42208438UL)))
#define bM4_EFM_FPMTSW_FPMTSW15                   (*((volatile unsigned int*)(0x4220843CUL)))
#define bM4_EFM_FPMTSW_FPMTSW16                   (*((volatile unsigned int*)(0x42208440UL)))
#define bM4_EFM_FPMTSW_FPMTSW17                   (*((volatile unsigned int*)(0x42208444UL)))
#define bM4_EFM_FPMTSW_FPMTSW18                   (*((volatile unsigned int*)(0x42208448UL)))
#define bM4_EFM_FPMTEW_FPMTEW0                    (*((volatile unsigned int*)(0x42208480UL)))
#define bM4_EFM_FPMTEW_FPMTEW1                    (*((volatile unsigned int*)(0x42208484UL)))
#define bM4_EFM_FPMTEW_FPMTEW2                    (*((volatile unsigned int*)(0x42208488UL)))
#define bM4_EFM_FPMTEW_FPMTEW3                    (*((volatile unsigned int*)(0x4220848CUL)))
#define bM4_EFM_FPMTEW_FPMTEW4                    (*((volatile unsigned int*)(0x42208490UL)))
#define bM4_EFM_FPMTEW_FPMTEW5                    (*((volatile unsigned int*)(0x42208494UL)))
#define bM4_EFM_FPMTEW_FPMTEW6                    (*((volatile unsigned int*)(0x42208498UL)))
#define bM4_EFM_FPMTEW_FPMTEW7                    (*((volatile unsigned int*)(0x4220849CUL)))
#define bM4_EFM_FPMTEW_FPMTEW8                    (*((volatile unsigned int*)(0x422084A0UL)))
#define bM4_EFM_FPMTEW_FPMTEW9                    (*((volatile unsigned int*)(0x422084A4UL)))
#define bM4_EFM_FPMTEW_FPMTEW10                   (*((volatile unsigned int*)(0x422084A8UL)))
#define bM4_EFM_FPMTEW_FPMTEW11                   (*((volatile unsigned int*)(0x422084ACUL)))
#define bM4_EFM_FPMTEW_FPMTEW12                   (*((volatile unsigned int*)(0x422084B0UL)))
#define bM4_EFM_FPMTEW_FPMTEW13                   (*((volatile unsigned int*)(0x422084B4UL)))
#define bM4_EFM_FPMTEW_FPMTEW14                   (*((volatile unsigned int*)(0x422084B8UL)))
#define bM4_EFM_FPMTEW_FPMTEW15                   (*((volatile unsigned int*)(0x422084BCUL)))
#define bM4_EFM_FPMTEW_FPMTEW16                   (*((volatile unsigned int*)(0x422084C0UL)))
#define bM4_EFM_FPMTEW_FPMTEW17                   (*((volatile unsigned int*)(0x422084C4UL)))
#define bM4_EFM_FPMTEW_FPMTEW18                   (*((volatile unsigned int*)(0x422084C8UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT0                (*((volatile unsigned int*)(0x4220A000UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT1                (*((volatile unsigned int*)(0x4220A004UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT2                (*((volatile unsigned int*)(0x4220A008UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT3                (*((volatile unsigned int*)(0x4220A00CUL)))
#define bM4_EFM_MMF_REMPRT_REMPRT4                (*((volatile unsigned int*)(0x4220A010UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT5                (*((volatile unsigned int*)(0x4220A014UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT6                (*((volatile unsigned int*)(0x4220A018UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT7                (*((volatile unsigned int*)(0x4220A01CUL)))
#define bM4_EFM_MMF_REMPRT_REMPRT8                (*((volatile unsigned int*)(0x4220A020UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT9                (*((volatile unsigned int*)(0x4220A024UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT10               (*((volatile unsigned int*)(0x4220A028UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT11               (*((volatile unsigned int*)(0x4220A02CUL)))
#define bM4_EFM_MMF_REMPRT_REMPRT12               (*((volatile unsigned int*)(0x4220A030UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT13               (*((volatile unsigned int*)(0x4220A034UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT14               (*((volatile unsigned int*)(0x4220A038UL)))
#define bM4_EFM_MMF_REMPRT_REMPRT15               (*((volatile unsigned int*)(0x4220A03CUL)))
#define bM4_EFM_MMF_REMCR0_RM0SIZE0               (*((volatile unsigned int*)(0x4220A080UL)))
#define bM4_EFM_MMF_REMCR0_RM0SIZE1               (*((volatile unsigned int*)(0x4220A084UL)))
#define bM4_EFM_MMF_REMCR0_RM0SIZE2               (*((volatile unsigned int*)(0x4220A088UL)))
#define bM4_EFM_MMF_REMCR0_RM0SIZE3               (*((volatile unsigned int*)(0x4220A08CUL)))
#define bM4_EFM_MMF_REMCR0_RM0SIZE4               (*((volatile unsigned int*)(0x4220A090UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR0              (*((volatile unsigned int*)(0x4220A0B0UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR1              (*((volatile unsigned int*)(0x4220A0B4UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR2              (*((volatile unsigned int*)(0x4220A0B8UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR3              (*((volatile unsigned int*)(0x4220A0BCUL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR4              (*((volatile unsigned int*)(0x4220A0C0UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR5              (*((volatile unsigned int*)(0x4220A0C4UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR6              (*((volatile unsigned int*)(0x4220A0C8UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR7              (*((volatile unsigned int*)(0x4220A0CCUL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR8              (*((volatile unsigned int*)(0x4220A0D0UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR9              (*((volatile unsigned int*)(0x4220A0D4UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR10             (*((volatile unsigned int*)(0x4220A0D8UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR11             (*((volatile unsigned int*)(0x4220A0DCUL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR12             (*((volatile unsigned int*)(0x4220A0E0UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR13             (*((volatile unsigned int*)(0x4220A0E4UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR14             (*((volatile unsigned int*)(0x4220A0E8UL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR15             (*((volatile unsigned int*)(0x4220A0ECUL)))
#define bM4_EFM_MMF_REMCR0_RM0TADDR16             (*((volatile unsigned int*)(0x4220A0F0UL)))
#define bM4_EFM_MMF_REMCR0_EN0                    (*((volatile unsigned int*)(0x4220A0FCUL)))
#define bM4_EFM_MMF_REMCR1_RM1SIZE0               (*((volatile unsigned int*)(0x4220A100UL)))
#define bM4_EFM_MMF_REMCR1_RM1SIZE1               (*((volatile unsigned int*)(0x4220A104UL)))
#define bM4_EFM_MMF_REMCR1_RM1SIZE2               (*((volatile unsigned int*)(0x4220A108UL)))
#define bM4_EFM_MMF_REMCR1_RM1SIZE3               (*((volatile unsigned int*)(0x4220A10CUL)))
#define bM4_EFM_MMF_REMCR1_RM1SIZE4               (*((volatile unsigned int*)(0x4220A110UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR0              (*((volatile unsigned int*)(0x4220A130UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR1              (*((volatile unsigned int*)(0x4220A134UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR2              (*((volatile unsigned int*)(0x4220A138UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR3              (*((volatile unsigned int*)(0x4220A13CUL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR4              (*((volatile unsigned int*)(0x4220A140UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR5              (*((volatile unsigned int*)(0x4220A144UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR6              (*((volatile unsigned int*)(0x4220A148UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR7              (*((volatile unsigned int*)(0x4220A14CUL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR8              (*((volatile unsigned int*)(0x4220A150UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR9              (*((volatile unsigned int*)(0x4220A154UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR10             (*((volatile unsigned int*)(0x4220A158UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR11             (*((volatile unsigned int*)(0x4220A15CUL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR12             (*((volatile unsigned int*)(0x4220A160UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR13             (*((volatile unsigned int*)(0x4220A164UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR14             (*((volatile unsigned int*)(0x4220A168UL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR15             (*((volatile unsigned int*)(0x4220A16CUL)))
#define bM4_EFM_MMF_REMCR1_RM1TADDR16             (*((volatile unsigned int*)(0x4220A170UL)))
#define bM4_EFM_MMF_REMCR1_EN1                    (*((volatile unsigned int*)(0x4220A17CUL)))
#define bM4_EFM_FRANDS_FRANDS0                    (*((volatile unsigned int*)(0x4220C084UL)))
#define bM4_EFM_FRANDS_FRANDS1                    (*((volatile unsigned int*)(0x4220C088UL)))
#define bM4_EFM_FRANDS_FRANDS2                    (*((volatile unsigned int*)(0x4220C08CUL)))
#define bM4_EFM_FRANDS_FRANDS3                    (*((volatile unsigned int*)(0x4220C090UL)))
#define bM4_EFM_FRANDS_FRANDS4                    (*((volatile unsigned int*)(0x4220C094UL)))
#define bM4_EFM_FRANDS_FRANDS5                    (*((volatile unsigned int*)(0x4220C098UL)))
#define bM4_EFM_FRANDS_FRANDS6                    (*((volatile unsigned int*)(0x4220C09CUL)))
#define bM4_EFM_FRANDS_FRANDS7                    (*((volatile unsigned int*)(0x4220C0A0UL)))
#define bM4_EFM_FRANDS_FRANDS8                    (*((volatile unsigned int*)(0x4220C0A4UL)))
#define bM4_EFM_FRANDS_FRANDS9                    (*((volatile unsigned int*)(0x4220C0A8UL)))
#define bM4_EFM_FRANDS_FRANDS10                   (*((volatile unsigned int*)(0x4220C0ACUL)))
#define bM4_EFM_FRANDS_FRANDS11                   (*((volatile unsigned int*)(0x4220C0B0UL)))
#define bM4_EFM_FRANDS_FRANDS12                   (*((volatile unsigned int*)(0x4220C0B4UL)))
#define bM4_EFM_FRANDS_FRANDS13                   (*((volatile unsigned int*)(0x4220C0B8UL)))
#define bM4_EFM_FRANDS_FRANDFG                    (*((volatile unsigned int*)(0x4220C0C0UL)))
#define bM4_EMB1_CTL_PORTINEN                     (*((volatile unsigned int*)(0x422F8000UL)))
#define bM4_EMB1_CTL_CMPEN0                       (*((volatile unsigned int*)(0x422F8004UL)))
#define bM4_EMB1_CTL_CMPEN1                       (*((volatile unsigned int*)(0x422F8008UL)))
#define bM4_EMB1_CTL_CMPEN2                       (*((volatile unsigned int*)(0x422F800CUL)))
#define bM4_EMB1_CTL_OSCSTPEN                     (*((volatile unsigned int*)(0x422F8014UL)))
#define bM4_EMB1_CTL_PWMSEN0                      (*((volatile unsigned int*)(0x422F8018UL)))
#define bM4_EMB1_CTL_PWMSEN1                      (*((volatile unsigned int*)(0x422F801CUL)))
#define bM4_EMB1_CTL_PWMSEN2                      (*((volatile unsigned int*)(0x422F8020UL)))
#define bM4_EMB1_CTL_NFSEL0                       (*((volatile unsigned int*)(0x422F8070UL)))
#define bM4_EMB1_CTL_NFSEL1                       (*((volatile unsigned int*)(0x422F8074UL)))
#define bM4_EMB1_CTL_NFEN                         (*((volatile unsigned int*)(0x422F8078UL)))
#define bM4_EMB1_CTL_INVSEL                       (*((volatile unsigned int*)(0x422F807CUL)))
#define bM4_EMB1_PWMLV_PWMLV0                     (*((volatile unsigned int*)(0x422F8080UL)))
#define bM4_EMB1_PWMLV_PWMLV1                     (*((volatile unsigned int*)(0x422F8084UL)))
#define bM4_EMB1_PWMLV_PWMLV2                     (*((volatile unsigned int*)(0x422F8088UL)))
#define bM4_EMB1_SOE_SOE                          (*((volatile unsigned int*)(0x422F8100UL)))
#define bM4_EMB1_STAT_PORTINF                     (*((volatile unsigned int*)(0x422F8180UL)))
#define bM4_EMB1_STAT_PWMSF                       (*((volatile unsigned int*)(0x422F8184UL)))
#define bM4_EMB1_STAT_CMPF                        (*((volatile unsigned int*)(0x422F8188UL)))
#define bM4_EMB1_STAT_OSF                         (*((volatile unsigned int*)(0x422F818CUL)))
#define bM4_EMB1_STAT_PORTINST                    (*((volatile unsigned int*)(0x422F8190UL)))
#define bM4_EMB1_STAT_PWMST                       (*((volatile unsigned int*)(0x422F8194UL)))
#define bM4_EMB1_STATCLR_PORTINFCLR               (*((volatile unsigned int*)(0x422F8200UL)))
#define bM4_EMB1_STATCLR_PWMSFCLR                 (*((volatile unsigned int*)(0x422F8204UL)))
#define bM4_EMB1_STATCLR_CMPFCLR                  (*((volatile unsigned int*)(0x422F8208UL)))
#define bM4_EMB1_STATCLR_OSFCLR                   (*((volatile unsigned int*)(0x422F820CUL)))
#define bM4_EMB1_INTEN_PORTINTEN                  (*((volatile unsigned int*)(0x422F8280UL)))
#define bM4_EMB1_INTEN_PWMINTEN                   (*((volatile unsigned int*)(0x422F8284UL)))
#define bM4_EMB1_INTEN_CMPINTEN                   (*((volatile unsigned int*)(0x422F8288UL)))
#define bM4_EMB1_INTEN_OSINTEN                    (*((volatile unsigned int*)(0x422F828CUL)))
#define bM4_EMB2_CTL_PORTINEN                     (*((volatile unsigned int*)(0x422F8400UL)))
#define bM4_EMB2_CTL_CMPEN0                       (*((volatile unsigned int*)(0x422F8404UL)))
#define bM4_EMB2_CTL_CMPEN1                       (*((volatile unsigned int*)(0x422F8408UL)))
#define bM4_EMB2_CTL_CMPEN2                       (*((volatile unsigned int*)(0x422F840CUL)))
#define bM4_EMB2_CTL_OSCSTPEN                     (*((volatile unsigned int*)(0x422F8414UL)))
#define bM4_EMB2_CTL_PWMSEN0                      (*((volatile unsigned int*)(0x422F8418UL)))
#define bM4_EMB2_CTL_PWMSEN1                      (*((volatile unsigned int*)(0x422F841CUL)))
#define bM4_EMB2_CTL_PWMSEN2                      (*((volatile unsigned int*)(0x422F8420UL)))
#define bM4_EMB2_CTL_NFSEL0                       (*((volatile unsigned int*)(0x422F8470UL)))
#define bM4_EMB2_CTL_NFSEL1                       (*((volatile unsigned int*)(0x422F8474UL)))
#define bM4_EMB2_CTL_NFEN                         (*((volatile unsigned int*)(0x422F8478UL)))
#define bM4_EMB2_CTL_INVSEL                       (*((volatile unsigned int*)(0x422F847CUL)))
#define bM4_EMB2_PWMLV_PWMLV0                     (*((volatile unsigned int*)(0x422F8480UL)))
#define bM4_EMB2_PWMLV_PWMLV1                     (*((volatile unsigned int*)(0x422F8484UL)))
#define bM4_EMB2_PWMLV_PWMLV2                     (*((volatile unsigned int*)(0x422F8488UL)))
#define bM4_EMB2_SOE_SOE                          (*((volatile unsigned int*)(0x422F8500UL)))
#define bM4_EMB2_STAT_PORTINF                     (*((volatile unsigned int*)(0x422F8580UL)))
#define bM4_EMB2_STAT_PWMSF                       (*((volatile unsigned int*)(0x422F8584UL)))
#define bM4_EMB2_STAT_CMPF                        (*((volatile unsigned int*)(0x422F8588UL)))
#define bM4_EMB2_STAT_OSF                         (*((volatile unsigned int*)(0x422F858CUL)))
#define bM4_EMB2_STAT_PORTINST                    (*((volatile unsigned int*)(0x422F8590UL)))
#define bM4_EMB2_STAT_PWMST                       (*((volatile unsigned int*)(0x422F8594UL)))
#define bM4_EMB2_STATCLR_PORTINFCLR               (*((volatile unsigned int*)(0x422F8600UL)))
#define bM4_EMB2_STATCLR_PWMSFCLR                 (*((volatile unsigned int*)(0x422F8604UL)))
#define bM4_EMB2_STATCLR_CMPFCLR                  (*((volatile unsigned int*)(0x422F8608UL)))
#define bM4_EMB2_STATCLR_OSFCLR                   (*((volatile unsigned int*)(0x422F860CUL)))
#define bM4_EMB2_INTEN_PORTINTEN                  (*((volatile unsigned int*)(0x422F8680UL)))
#define bM4_EMB2_INTEN_PWMINTEN                   (*((volatile unsigned int*)(0x422F8684UL)))
#define bM4_EMB2_INTEN_CMPINTEN                   (*((volatile unsigned int*)(0x422F8688UL)))
#define bM4_EMB2_INTEN_OSINTEN                    (*((volatile unsigned int*)(0x422F868CUL)))
#define bM4_EMB3_CTL_PORTINEN                     (*((volatile unsigned int*)(0x422F8800UL)))
#define bM4_EMB3_CTL_CMPEN0                       (*((volatile unsigned int*)(0x422F8804UL)))
#define bM4_EMB3_CTL_CMPEN1                       (*((volatile unsigned int*)(0x422F8808UL)))
#define bM4_EMB3_CTL_CMPEN2                       (*((volatile unsigned int*)(0x422F880CUL)))
#define bM4_EMB3_CTL_OSCSTPEN                     (*((volatile unsigned int*)(0x422F8814UL)))
#define bM4_EMB3_CTL_PWMSEN0                      (*((volatile unsigned int*)(0x422F8818UL)))
#define bM4_EMB3_CTL_PWMSEN1                      (*((volatile unsigned int*)(0x422F881CUL)))
#define bM4_EMB3_CTL_PWMSEN2                      (*((volatile unsigned int*)(0x422F8820UL)))
#define bM4_EMB3_CTL_NFSEL0                       (*((volatile unsigned int*)(0x422F8870UL)))
#define bM4_EMB3_CTL_NFSEL1                       (*((volatile unsigned int*)(0x422F8874UL)))
#define bM4_EMB3_CTL_NFEN                         (*((volatile unsigned int*)(0x422F8878UL)))
#define bM4_EMB3_CTL_INVSEL                       (*((volatile unsigned int*)(0x422F887CUL)))
#define bM4_EMB3_PWMLV_PWMLV0                     (*((volatile unsigned int*)(0x422F8880UL)))
#define bM4_EMB3_PWMLV_PWMLV1                     (*((volatile unsigned int*)(0x422F8884UL)))
#define bM4_EMB3_PWMLV_PWMLV2                     (*((volatile unsigned int*)(0x422F8888UL)))
#define bM4_EMB3_SOE_SOE                          (*((volatile unsigned int*)(0x422F8900UL)))
#define bM4_EMB3_STAT_PORTINF                     (*((volatile unsigned int*)(0x422F8980UL)))
#define bM4_EMB3_STAT_PWMSF                       (*((volatile unsigned int*)(0x422F8984UL)))
#define bM4_EMB3_STAT_CMPF                        (*((volatile unsigned int*)(0x422F8988UL)))
#define bM4_EMB3_STAT_OSF                         (*((volatile unsigned int*)(0x422F898CUL)))
#define bM4_EMB3_STAT_PORTINST                    (*((volatile unsigned int*)(0x422F8990UL)))
#define bM4_EMB3_STAT_PWMST                       (*((volatile unsigned int*)(0x422F8994UL)))
#define bM4_EMB3_STATCLR_PORTINFCLR               (*((volatile unsigned int*)(0x422F8A00UL)))
#define bM4_EMB3_STATCLR_PWMSFCLR                 (*((volatile unsigned int*)(0x422F8A04UL)))
#define bM4_EMB3_STATCLR_CMPFCLR                  (*((volatile unsigned int*)(0x422F8A08UL)))
#define bM4_EMB3_STATCLR_OSFCLR                   (*((volatile unsigned int*)(0x422F8A0CUL)))
#define bM4_EMB3_INTEN_PORTINTEN                  (*((volatile unsigned int*)(0x422F8A80UL)))
#define bM4_EMB3_INTEN_PWMINTEN                   (*((volatile unsigned int*)(0x422F8A84UL)))
#define bM4_EMB3_INTEN_CMPINTEN                   (*((volatile unsigned int*)(0x422F8A88UL)))
#define bM4_EMB3_INTEN_OSINTEN                    (*((volatile unsigned int*)(0x422F8A8CUL)))
#define bM4_EMB4_CTL_PORTINEN                     (*((volatile unsigned int*)(0x422F8C00UL)))
#define bM4_EMB4_CTL_CMPEN0                       (*((volatile unsigned int*)(0x422F8C04UL)))
#define bM4_EMB4_CTL_CMPEN1                       (*((volatile unsigned int*)(0x422F8C08UL)))
#define bM4_EMB4_CTL_CMPEN2                       (*((volatile unsigned int*)(0x422F8C0CUL)))
#define bM4_EMB4_CTL_OSCSTPEN                     (*((volatile unsigned int*)(0x422F8C14UL)))
#define bM4_EMB4_CTL_PWMSEN0                      (*((volatile unsigned int*)(0x422F8C18UL)))
#define bM4_EMB4_CTL_PWMSEN1                      (*((volatile unsigned int*)(0x422F8C1CUL)))
#define bM4_EMB4_CTL_PWMSEN2                      (*((volatile unsigned int*)(0x422F8C20UL)))
#define bM4_EMB4_CTL_NFSEL0                       (*((volatile unsigned int*)(0x422F8C70UL)))
#define bM4_EMB4_CTL_NFSEL1                       (*((volatile unsigned int*)(0x422F8C74UL)))
#define bM4_EMB4_CTL_NFEN                         (*((volatile unsigned int*)(0x422F8C78UL)))
#define bM4_EMB4_CTL_INVSEL                       (*((volatile unsigned int*)(0x422F8C7CUL)))
#define bM4_EMB4_PWMLV_PWMLV0                     (*((volatile unsigned int*)(0x422F8C80UL)))
#define bM4_EMB4_PWMLV_PWMLV1                     (*((volatile unsigned int*)(0x422F8C84UL)))
#define bM4_EMB4_PWMLV_PWMLV2                     (*((volatile unsigned int*)(0x422F8C88UL)))
#define bM4_EMB4_SOE_SOE                          (*((volatile unsigned int*)(0x422F8D00UL)))
#define bM4_EMB4_STAT_PORTINF                     (*((volatile unsigned int*)(0x422F8D80UL)))
#define bM4_EMB4_STAT_PWMSF                       (*((volatile unsigned int*)(0x422F8D84UL)))
#define bM4_EMB4_STAT_CMPF                        (*((volatile unsigned int*)(0x422F8D88UL)))
#define bM4_EMB4_STAT_OSF                         (*((volatile unsigned int*)(0x422F8D8CUL)))
#define bM4_EMB4_STAT_PORTINST                    (*((volatile unsigned int*)(0x422F8D90UL)))
#define bM4_EMB4_STAT_PWMST                       (*((volatile unsigned int*)(0x422F8D94UL)))
#define bM4_EMB4_STATCLR_PORTINFCLR               (*((volatile unsigned int*)(0x422F8E00UL)))
#define bM4_EMB4_STATCLR_PWMSFCLR                 (*((volatile unsigned int*)(0x422F8E04UL)))
#define bM4_EMB4_STATCLR_CMPFCLR                  (*((volatile unsigned int*)(0x422F8E08UL)))
#define bM4_EMB4_STATCLR_OSFCLR                   (*((volatile unsigned int*)(0x422F8E0CUL)))
#define bM4_EMB4_INTEN_PORTINTEN                  (*((volatile unsigned int*)(0x422F8E80UL)))
#define bM4_EMB4_INTEN_PWMINTEN                   (*((volatile unsigned int*)(0x422F8E84UL)))
#define bM4_EMB4_INTEN_CMPINTEN                   (*((volatile unsigned int*)(0x422F8E88UL)))
#define bM4_EMB4_INTEN_OSINTEN                    (*((volatile unsigned int*)(0x422F8E8CUL)))
#define bM4_FCM_LVR_LVR0                          (*((volatile unsigned int*)(0x42908000UL)))
#define bM4_FCM_LVR_LVR1                          (*((volatile unsigned int*)(0x42908004UL)))
#define bM4_FCM_LVR_LVR2                          (*((volatile unsigned int*)(0x42908008UL)))
#define bM4_FCM_LVR_LVR3                          (*((volatile unsigned int*)(0x4290800CUL)))
#define bM4_FCM_LVR_LVR4                          (*((volatile unsigned int*)(0x42908010UL)))
#define bM4_FCM_LVR_LVR5                          (*((volatile unsigned int*)(0x42908014UL)))
#define bM4_FCM_LVR_LVR6                          (*((volatile unsigned int*)(0x42908018UL)))
#define bM4_FCM_LVR_LVR7                          (*((volatile unsigned int*)(0x4290801CUL)))
#define bM4_FCM_LVR_LVR8                          (*((volatile unsigned int*)(0x42908020UL)))
#define bM4_FCM_LVR_LVR9                          (*((volatile unsigned int*)(0x42908024UL)))
#define bM4_FCM_LVR_LVR10                         (*((volatile unsigned int*)(0x42908028UL)))
#define bM4_FCM_LVR_LVR11                         (*((volatile unsigned int*)(0x4290802CUL)))
#define bM4_FCM_LVR_LVR12                         (*((volatile unsigned int*)(0x42908030UL)))
#define bM4_FCM_LVR_LVR13                         (*((volatile unsigned int*)(0x42908034UL)))
#define bM4_FCM_LVR_LVR14                         (*((volatile unsigned int*)(0x42908038UL)))
#define bM4_FCM_LVR_LVR15                         (*((volatile unsigned int*)(0x4290803CUL)))
#define bM4_FCM_UVR_UVR0                          (*((volatile unsigned int*)(0x42908080UL)))
#define bM4_FCM_UVR_UVR1                          (*((volatile unsigned int*)(0x42908084UL)))
#define bM4_FCM_UVR_UVR2                          (*((volatile unsigned int*)(0x42908088UL)))
#define bM4_FCM_UVR_UVR3                          (*((volatile unsigned int*)(0x4290808CUL)))
#define bM4_FCM_UVR_UVR4                          (*((volatile unsigned int*)(0x42908090UL)))
#define bM4_FCM_UVR_UVR5                          (*((volatile unsigned int*)(0x42908094UL)))
#define bM4_FCM_UVR_UVR6                          (*((volatile unsigned int*)(0x42908098UL)))
#define bM4_FCM_UVR_UVR7                          (*((volatile unsigned int*)(0x4290809CUL)))
#define bM4_FCM_UVR_UVR8                          (*((volatile unsigned int*)(0x429080A0UL)))
#define bM4_FCM_UVR_UVR9                          (*((volatile unsigned int*)(0x429080A4UL)))
#define bM4_FCM_UVR_UVR10                         (*((volatile unsigned int*)(0x429080A8UL)))
#define bM4_FCM_UVR_UVR11                         (*((volatile unsigned int*)(0x429080ACUL)))
#define bM4_FCM_UVR_UVR12                         (*((volatile unsigned int*)(0x429080B0UL)))
#define bM4_FCM_UVR_UVR13                         (*((volatile unsigned int*)(0x429080B4UL)))
#define bM4_FCM_UVR_UVR14                         (*((volatile unsigned int*)(0x429080B8UL)))
#define bM4_FCM_UVR_UVR15                         (*((volatile unsigned int*)(0x429080BCUL)))
#define bM4_FCM_CNTR_CNTR0                        (*((volatile unsigned int*)(0x42908100UL)))
#define bM4_FCM_CNTR_CNTR1                        (*((volatile unsigned int*)(0x42908104UL)))
#define bM4_FCM_CNTR_CNTR2                        (*((volatile unsigned int*)(0x42908108UL)))
#define bM4_FCM_CNTR_CNTR3                        (*((volatile unsigned int*)(0x4290810CUL)))
#define bM4_FCM_CNTR_CNTR4                        (*((volatile unsigned int*)(0x42908110UL)))
#define bM4_FCM_CNTR_CNTR5                        (*((volatile unsigned int*)(0x42908114UL)))
#define bM4_FCM_CNTR_CNTR6                        (*((volatile unsigned int*)(0x42908118UL)))
#define bM4_FCM_CNTR_CNTR7                        (*((volatile unsigned int*)(0x4290811CUL)))
#define bM4_FCM_CNTR_CNTR8                        (*((volatile unsigned int*)(0x42908120UL)))
#define bM4_FCM_CNTR_CNTR9                        (*((volatile unsigned int*)(0x42908124UL)))
#define bM4_FCM_CNTR_CNTR10                       (*((volatile unsigned int*)(0x42908128UL)))
#define bM4_FCM_CNTR_CNTR11                       (*((volatile unsigned int*)(0x4290812CUL)))
#define bM4_FCM_CNTR_CNTR12                       (*((volatile unsigned int*)(0x42908130UL)))
#define bM4_FCM_CNTR_CNTR13                       (*((volatile unsigned int*)(0x42908134UL)))
#define bM4_FCM_CNTR_CNTR14                       (*((volatile unsigned int*)(0x42908138UL)))
#define bM4_FCM_CNTR_CNTR15                       (*((volatile unsigned int*)(0x4290813CUL)))
#define bM4_FCM_STR_START                         (*((volatile unsigned int*)(0x42908180UL)))
#define bM4_FCM_MCCR_MDIVS0                       (*((volatile unsigned int*)(0x42908200UL)))
#define bM4_FCM_MCCR_MDIVS1                       (*((volatile unsigned int*)(0x42908204UL)))
#define bM4_FCM_MCCR_MCKS0                        (*((volatile unsigned int*)(0x42908210UL)))
#define bM4_FCM_MCCR_MCKS1                        (*((volatile unsigned int*)(0x42908214UL)))
#define bM4_FCM_MCCR_MCKS2                        (*((volatile unsigned int*)(0x42908218UL)))
#define bM4_FCM_MCCR_MCKS3                        (*((volatile unsigned int*)(0x4290821CUL)))
#define bM4_FCM_RCCR_RDIVS0                       (*((volatile unsigned int*)(0x42908280UL)))
#define bM4_FCM_RCCR_RDIVS1                       (*((volatile unsigned int*)(0x42908284UL)))
#define bM4_FCM_RCCR_RCKS0                        (*((volatile unsigned int*)(0x4290828CUL)))
#define bM4_FCM_RCCR_RCKS1                        (*((volatile unsigned int*)(0x42908290UL)))
#define bM4_FCM_RCCR_RCKS2                        (*((volatile unsigned int*)(0x42908294UL)))
#define bM4_FCM_RCCR_RCKS3                        (*((volatile unsigned int*)(0x42908298UL)))
#define bM4_FCM_RCCR_INEXS                        (*((volatile unsigned int*)(0x4290829CUL)))
#define bM4_FCM_RCCR_DNFS0                        (*((volatile unsigned int*)(0x429082A0UL)))
#define bM4_FCM_RCCR_DNFS1                        (*((volatile unsigned int*)(0x429082A4UL)))
#define bM4_FCM_RCCR_EDGES0                       (*((volatile unsigned int*)(0x429082B0UL)))
#define bM4_FCM_RCCR_EDGES1                       (*((volatile unsigned int*)(0x429082B4UL)))
#define bM4_FCM_RCCR_EXREFE                       (*((volatile unsigned int*)(0x429082BCUL)))
#define bM4_FCM_RIER_ERRIE                        (*((volatile unsigned int*)(0x42908300UL)))
#define bM4_FCM_RIER_MENDIE                       (*((volatile unsigned int*)(0x42908304UL)))
#define bM4_FCM_RIER_OVFIE                        (*((volatile unsigned int*)(0x42908308UL)))
#define bM4_FCM_RIER_ERRINTRS                     (*((volatile unsigned int*)(0x42908310UL)))
#define bM4_FCM_RIER_ERRE                         (*((volatile unsigned int*)(0x4290831CUL)))
#define bM4_FCM_SR_ERRF                           (*((volatile unsigned int*)(0x42908380UL)))
#define bM4_FCM_SR_MENDF                          (*((volatile unsigned int*)(0x42908384UL)))
#define bM4_FCM_SR_OVF                            (*((volatile unsigned int*)(0x42908388UL)))
#define bM4_FCM_CLR_ERRFCLR                       (*((volatile unsigned int*)(0x42908400UL)))
#define bM4_FCM_CLR_MENDFCLR                      (*((volatile unsigned int*)(0x42908404UL)))
#define bM4_FCM_CLR_OVFCLR                        (*((volatile unsigned int*)(0x42908408UL)))
#define bM4_HASH_CR_START                         (*((volatile unsigned int*)(0x42108000UL)))
#define bM4_HASH_CR_FST_GRP                       (*((volatile unsigned int*)(0x42108004UL)))
#define bM4_I2C1_CR1_PE                           (*((volatile unsigned int*)(0x429C0000UL)))
#define bM4_I2C1_CR1_SMBUS                        (*((volatile unsigned int*)(0x429C0004UL)))
#define bM4_I2C1_CR1_SMBALRTEN                    (*((volatile unsigned int*)(0x429C0008UL)))
#define bM4_I2C1_CR1_SMBDEFAULTEN                 (*((volatile unsigned int*)(0x429C000CUL)))
#define bM4_I2C1_CR1_SMBHOSTEN                    (*((volatile unsigned int*)(0x429C0010UL)))
#define bM4_I2C1_CR1_ENGC                         (*((volatile unsigned int*)(0x429C0018UL)))
#define bM4_I2C1_CR1_RESTART                      (*((volatile unsigned int*)(0x429C001CUL)))
#define bM4_I2C1_CR1_START                        (*((volatile unsigned int*)(0x429C0020UL)))
#define bM4_I2C1_CR1_STOP                         (*((volatile unsigned int*)(0x429C0024UL)))
#define bM4_I2C1_CR1_ACK                          (*((volatile unsigned int*)(0x429C0028UL)))
#define bM4_I2C1_CR1_SWRST                        (*((volatile unsigned int*)(0x429C003CUL)))
#define bM4_I2C1_CR2_STARTIE                      (*((volatile unsigned int*)(0x429C0080UL)))
#define bM4_I2C1_CR2_SLADDR0IE                    (*((volatile unsigned int*)(0x429C0084UL)))
#define bM4_I2C1_CR2_SLADDR1IE                    (*((volatile unsigned int*)(0x429C0088UL)))
#define bM4_I2C1_CR2_TENDIE                       (*((volatile unsigned int*)(0x429C008CUL)))
#define bM4_I2C1_CR2_STOPIE                       (*((volatile unsigned int*)(0x429C0090UL)))
#define bM4_I2C1_CR2_RFULLIE                      (*((volatile unsigned int*)(0x429C0098UL)))
#define bM4_I2C1_CR2_TEMPTYIE                     (*((volatile unsigned int*)(0x429C009CUL)))
#define bM4_I2C1_CR2_ARLOIE                       (*((volatile unsigned int*)(0x429C00A4UL)))
#define bM4_I2C1_CR2_NACKIE                       (*((volatile unsigned int*)(0x429C00B0UL)))
#define bM4_I2C1_CR2_TMOUTIE                      (*((volatile unsigned int*)(0x429C00B8UL)))
#define bM4_I2C1_CR2_GENCALLIE                    (*((volatile unsigned int*)(0x429C00D0UL)))
#define bM4_I2C1_CR2_SMBDEFAULTIE                 (*((volatile unsigned int*)(0x429C00D4UL)))
#define bM4_I2C1_CR2_SMBHOSTIE                    (*((volatile unsigned int*)(0x429C00D8UL)))
#define bM4_I2C1_CR2_SMBALRTIE                    (*((volatile unsigned int*)(0x429C00DCUL)))
#define bM4_I2C1_CR3_TMOUTEN                      (*((volatile unsigned int*)(0x429C0100UL)))
#define bM4_I2C1_CR3_LTMOUT                       (*((volatile unsigned int*)(0x429C0104UL)))
#define bM4_I2C1_CR3_HTMOUT                       (*((volatile unsigned int*)(0x429C0108UL)))
#define bM4_I2C1_CR3_FACKEN                       (*((volatile unsigned int*)(0x429C011CUL)))
#define bM4_I2C1_CR4_BUSWAIT                      (*((volatile unsigned int*)(0x429C01A8UL)))
#define bM4_I2C1_SLR0_SLADDR00                    (*((volatile unsigned int*)(0x429C0200UL)))
#define bM4_I2C1_SLR0_SLADDR01                    (*((volatile unsigned int*)(0x429C0204UL)))
#define bM4_I2C1_SLR0_SLADDR02                    (*((volatile unsigned int*)(0x429C0208UL)))
#define bM4_I2C1_SLR0_SLADDR03                    (*((volatile unsigned int*)(0x429C020CUL)))
#define bM4_I2C1_SLR0_SLADDR04                    (*((volatile unsigned int*)(0x429C0210UL)))
#define bM4_I2C1_SLR0_SLADDR05                    (*((volatile unsigned int*)(0x429C0214UL)))
#define bM4_I2C1_SLR0_SLADDR06                    (*((volatile unsigned int*)(0x429C0218UL)))
#define bM4_I2C1_SLR0_SLADDR07                    (*((volatile unsigned int*)(0x429C021CUL)))
#define bM4_I2C1_SLR0_SLADDR08                    (*((volatile unsigned int*)(0x429C0220UL)))
#define bM4_I2C1_SLR0_SLADDR09                    (*((volatile unsigned int*)(0x429C0224UL)))
#define bM4_I2C1_SLR0_SLADDR0EN                   (*((volatile unsigned int*)(0x429C0230UL)))
#define bM4_I2C1_SLR0_ADDRMOD0                    (*((volatile unsigned int*)(0x429C023CUL)))
#define bM4_I2C1_SLR1_SLADDR10                    (*((volatile unsigned int*)(0x429C0280UL)))
#define bM4_I2C1_SLR1_SLADDR11                    (*((volatile unsigned int*)(0x429C0284UL)))
#define bM4_I2C1_SLR1_SLADDR12                    (*((volatile unsigned int*)(0x429C0288UL)))
#define bM4_I2C1_SLR1_SLADDR13                    (*((volatile unsigned int*)(0x429C028CUL)))
#define bM4_I2C1_SLR1_SLADDR14                    (*((volatile unsigned int*)(0x429C0290UL)))
#define bM4_I2C1_SLR1_SLADDR15                    (*((volatile unsigned int*)(0x429C0294UL)))
#define bM4_I2C1_SLR1_SLADDR16                    (*((volatile unsigned int*)(0x429C0298UL)))
#define bM4_I2C1_SLR1_SLADDR17                    (*((volatile unsigned int*)(0x429C029CUL)))
#define bM4_I2C1_SLR1_SLADDR18                    (*((volatile unsigned int*)(0x429C02A0UL)))
#define bM4_I2C1_SLR1_SLADDR19                    (*((volatile unsigned int*)(0x429C02A4UL)))
#define bM4_I2C1_SLR1_SLADDR1EN                   (*((volatile unsigned int*)(0x429C02B0UL)))
#define bM4_I2C1_SLR1_ADDRMOD1                    (*((volatile unsigned int*)(0x429C02BCUL)))
#define bM4_I2C1_SLTR_TOUTLOW0                    (*((volatile unsigned int*)(0x429C0300UL)))
#define bM4_I2C1_SLTR_TOUTLOW1                    (*((volatile unsigned int*)(0x429C0304UL)))
#define bM4_I2C1_SLTR_TOUTLOW2                    (*((volatile unsigned int*)(0x429C0308UL)))
#define bM4_I2C1_SLTR_TOUTLOW3                    (*((volatile unsigned int*)(0x429C030CUL)))
#define bM4_I2C1_SLTR_TOUTLOW4                    (*((volatile unsigned int*)(0x429C0310UL)))
#define bM4_I2C1_SLTR_TOUTLOW5                    (*((volatile unsigned int*)(0x429C0314UL)))
#define bM4_I2C1_SLTR_TOUTLOW6                    (*((volatile unsigned int*)(0x429C0318UL)))
#define bM4_I2C1_SLTR_TOUTLOW7                    (*((volatile unsigned int*)(0x429C031CUL)))
#define bM4_I2C1_SLTR_TOUTLOW8                    (*((volatile unsigned int*)(0x429C0320UL)))
#define bM4_I2C1_SLTR_TOUTLOW9                    (*((volatile unsigned int*)(0x429C0324UL)))
#define bM4_I2C1_SLTR_TOUTLOW10                   (*((volatile unsigned int*)(0x429C0328UL)))
#define bM4_I2C1_SLTR_TOUTLOW11                   (*((volatile unsigned int*)(0x429C032CUL)))
#define bM4_I2C1_SLTR_TOUTLOW12                   (*((volatile unsigned int*)(0x429C0330UL)))
#define bM4_I2C1_SLTR_TOUTLOW13                   (*((volatile unsigned int*)(0x429C0334UL)))
#define bM4_I2C1_SLTR_TOUTLOW14                   (*((volatile unsigned int*)(0x429C0338UL)))
#define bM4_I2C1_SLTR_TOUTLOW15                   (*((volatile unsigned int*)(0x429C033CUL)))
#define bM4_I2C1_SLTR_TOUTHIGH0                   (*((volatile unsigned int*)(0x429C0340UL)))
#define bM4_I2C1_SLTR_TOUTHIGH1                   (*((volatile unsigned int*)(0x429C0344UL)))
#define bM4_I2C1_SLTR_TOUTHIGH2                   (*((volatile unsigned int*)(0x429C0348UL)))
#define bM4_I2C1_SLTR_TOUTHIGH3                   (*((volatile unsigned int*)(0x429C034CUL)))
#define bM4_I2C1_SLTR_TOUTHIGH4                   (*((volatile unsigned int*)(0x429C0350UL)))
#define bM4_I2C1_SLTR_TOUTHIGH5                   (*((volatile unsigned int*)(0x429C0354UL)))
#define bM4_I2C1_SLTR_TOUTHIGH6                   (*((volatile unsigned int*)(0x429C0358UL)))
#define bM4_I2C1_SLTR_TOUTHIGH7                   (*((volatile unsigned int*)(0x429C035CUL)))
#define bM4_I2C1_SLTR_TOUTHIGH8                   (*((volatile unsigned int*)(0x429C0360UL)))
#define bM4_I2C1_SLTR_TOUTHIGH9                   (*((volatile unsigned int*)(0x429C0364UL)))
#define bM4_I2C1_SLTR_TOUTHIGH10                  (*((volatile unsigned int*)(0x429C0368UL)))
#define bM4_I2C1_SLTR_TOUTHIGH11                  (*((volatile unsigned int*)(0x429C036CUL)))
#define bM4_I2C1_SLTR_TOUTHIGH12                  (*((volatile unsigned int*)(0x429C0370UL)))
#define bM4_I2C1_SLTR_TOUTHIGH13                  (*((volatile unsigned int*)(0x429C0374UL)))
#define bM4_I2C1_SLTR_TOUTHIGH14                  (*((volatile unsigned int*)(0x429C0378UL)))
#define bM4_I2C1_SLTR_TOUTHIGH15                  (*((volatile unsigned int*)(0x429C037CUL)))
#define bM4_I2C1_SR_STARTF                        (*((volatile unsigned int*)(0x429C0380UL)))
#define bM4_I2C1_SR_SLADDR0F                      (*((volatile unsigned int*)(0x429C0384UL)))
#define bM4_I2C1_SR_SLADDR1F                      (*((volatile unsigned int*)(0x429C0388UL)))
#define bM4_I2C1_SR_TENDF                         (*((volatile unsigned int*)(0x429C038CUL)))
#define bM4_I2C1_SR_STOPF                         (*((volatile unsigned int*)(0x429C0390UL)))
#define bM4_I2C1_SR_RFULLF                        (*((volatile unsigned int*)(0x429C0398UL)))
#define bM4_I2C1_SR_TEMPTYF                       (*((volatile unsigned int*)(0x429C039CUL)))
#define bM4_I2C1_SR_ARLOF                         (*((volatile unsigned int*)(0x429C03A4UL)))
#define bM4_I2C1_SR_ACKRF                         (*((volatile unsigned int*)(0x429C03A8UL)))
#define bM4_I2C1_SR_NACKF                         (*((volatile unsigned int*)(0x429C03B0UL)))
#define bM4_I2C1_SR_TMOUTF                        (*((volatile unsigned int*)(0x429C03B8UL)))
#define bM4_I2C1_SR_MSL                           (*((volatile unsigned int*)(0x429C03C0UL)))
#define bM4_I2C1_SR_BUSY                          (*((volatile unsigned int*)(0x429C03C4UL)))
#define bM4_I2C1_SR_TRA                           (*((volatile unsigned int*)(0x429C03C8UL)))
#define bM4_I2C1_SR_GENCALLF                      (*((volatile unsigned int*)(0x429C03D0UL)))
#define bM4_I2C1_SR_SMBDEFAULTF                   (*((volatile unsigned int*)(0x429C03D4UL)))
#define bM4_I2C1_SR_SMBHOSTF                      (*((volatile unsigned int*)(0x429C03D8UL)))
#define bM4_I2C1_SR_SMBALRTF                      (*((volatile unsigned int*)(0x429C03DCUL)))
#define bM4_I2C1_CLR_STARTFCLR                    (*((volatile unsigned int*)(0x429C0400UL)))
#define bM4_I2C1_CLR_SLADDR0FCLR                  (*((volatile unsigned int*)(0x429C0404UL)))
#define bM4_I2C1_CLR_SLADDR1FCLR                  (*((volatile unsigned int*)(0x429C0408UL)))
#define bM4_I2C1_CLR_TENDFCLR                     (*((volatile unsigned int*)(0x429C040CUL)))
#define bM4_I2C1_CLR_STOPFCLR                     (*((volatile unsigned int*)(0x429C0410UL)))
#define bM4_I2C1_CLR_RFULLFCLR                    (*((volatile unsigned int*)(0x429C0418UL)))
#define bM4_I2C1_CLR_TEMPTYFCLR                   (*((volatile unsigned int*)(0x429C041CUL)))
#define bM4_I2C1_CLR_ARLOFCLR                     (*((volatile unsigned int*)(0x429C0424UL)))
#define bM4_I2C1_CLR_NACKFCLR                     (*((volatile unsigned int*)(0x429C0430UL)))
#define bM4_I2C1_CLR_TMOUTFCLR                    (*((volatile unsigned int*)(0x429C0438UL)))
#define bM4_I2C1_CLR_GENCALLFCLR                  (*((volatile unsigned int*)(0x429C0450UL)))
#define bM4_I2C1_CLR_SMBDEFAULTFCLR               (*((volatile unsigned int*)(0x429C0454UL)))
#define bM4_I2C1_CLR_SMBHOSTFCLR                  (*((volatile unsigned int*)(0x429C0458UL)))
#define bM4_I2C1_CLR_SMBALRTFCLR                  (*((volatile unsigned int*)(0x429C045CUL)))
#define bM4_I2C1_DTR_DT0                          (*((volatile unsigned int*)(0x429C0480UL)))
#define bM4_I2C1_DTR_DT1                          (*((volatile unsigned int*)(0x429C0484UL)))
#define bM4_I2C1_DTR_DT2                          (*((volatile unsigned int*)(0x429C0488UL)))
#define bM4_I2C1_DTR_DT3                          (*((volatile unsigned int*)(0x429C048CUL)))
#define bM4_I2C1_DTR_DT4                          (*((volatile unsigned int*)(0x429C0490UL)))
#define bM4_I2C1_DTR_DT5                          (*((volatile unsigned int*)(0x429C0494UL)))
#define bM4_I2C1_DTR_DT6                          (*((volatile unsigned int*)(0x429C0498UL)))
#define bM4_I2C1_DTR_DT7                          (*((volatile unsigned int*)(0x429C049CUL)))
#define bM4_I2C1_DRR_DR0                          (*((volatile unsigned int*)(0x429C0500UL)))
#define bM4_I2C1_DRR_DR1                          (*((volatile unsigned int*)(0x429C0504UL)))
#define bM4_I2C1_DRR_DR2                          (*((volatile unsigned int*)(0x429C0508UL)))
#define bM4_I2C1_DRR_DR3                          (*((volatile unsigned int*)(0x429C050CUL)))
#define bM4_I2C1_DRR_DR4                          (*((volatile unsigned int*)(0x429C0510UL)))
#define bM4_I2C1_DRR_DR5                          (*((volatile unsigned int*)(0x429C0514UL)))
#define bM4_I2C1_DRR_DR6                          (*((volatile unsigned int*)(0x429C0518UL)))
#define bM4_I2C1_DRR_DR7                          (*((volatile unsigned int*)(0x429C051CUL)))
#define bM4_I2C1_CCR_SLOWW0                       (*((volatile unsigned int*)(0x429C0580UL)))
#define bM4_I2C1_CCR_SLOWW1                       (*((volatile unsigned int*)(0x429C0584UL)))
#define bM4_I2C1_CCR_SLOWW2                       (*((volatile unsigned int*)(0x429C0588UL)))
#define bM4_I2C1_CCR_SLOWW3                       (*((volatile unsigned int*)(0x429C058CUL)))
#define bM4_I2C1_CCR_SLOWW4                       (*((volatile unsigned int*)(0x429C0590UL)))
#define bM4_I2C1_CCR_SHIGHW0                      (*((volatile unsigned int*)(0x429C05A0UL)))
#define bM4_I2C1_CCR_SHIGHW1                      (*((volatile unsigned int*)(0x429C05A4UL)))
#define bM4_I2C1_CCR_SHIGHW2                      (*((volatile unsigned int*)(0x429C05A8UL)))
#define bM4_I2C1_CCR_SHIGHW3                      (*((volatile unsigned int*)(0x429C05ACUL)))
#define bM4_I2C1_CCR_SHIGHW4                      (*((volatile unsigned int*)(0x429C05B0UL)))
#define bM4_I2C1_CCR_FREQ0                        (*((volatile unsigned int*)(0x429C05C0UL)))
#define bM4_I2C1_CCR_FREQ1                        (*((volatile unsigned int*)(0x429C05C4UL)))
#define bM4_I2C1_CCR_FREQ2                        (*((volatile unsigned int*)(0x429C05C8UL)))
#define bM4_I2C1_FLTR_DNF0                        (*((volatile unsigned int*)(0x429C0600UL)))
#define bM4_I2C1_FLTR_DNF1                        (*((volatile unsigned int*)(0x429C0604UL)))
#define bM4_I2C1_FLTR_DNFEN                       (*((volatile unsigned int*)(0x429C0610UL)))
#define bM4_I2C1_FLTR_ANFEN                       (*((volatile unsigned int*)(0x429C0614UL)))
#define bM4_I2C2_CR1_PE                           (*((volatile unsigned int*)(0x429C8000UL)))
#define bM4_I2C2_CR1_SMBUS                        (*((volatile unsigned int*)(0x429C8004UL)))
#define bM4_I2C2_CR1_SMBALRTEN                    (*((volatile unsigned int*)(0x429C8008UL)))
#define bM4_I2C2_CR1_SMBDEFAULTEN                 (*((volatile unsigned int*)(0x429C800CUL)))
#define bM4_I2C2_CR1_SMBHOSTEN                    (*((volatile unsigned int*)(0x429C8010UL)))
#define bM4_I2C2_CR1_ENGC                         (*((volatile unsigned int*)(0x429C8018UL)))
#define bM4_I2C2_CR1_RESTART                      (*((volatile unsigned int*)(0x429C801CUL)))
#define bM4_I2C2_CR1_START                        (*((volatile unsigned int*)(0x429C8020UL)))
#define bM4_I2C2_CR1_STOP                         (*((volatile unsigned int*)(0x429C8024UL)))
#define bM4_I2C2_CR1_ACK                          (*((volatile unsigned int*)(0x429C8028UL)))
#define bM4_I2C2_CR1_SWRST                        (*((volatile unsigned int*)(0x429C803CUL)))
#define bM4_I2C2_CR2_STARTIE                      (*((volatile unsigned int*)(0x429C8080UL)))
#define bM4_I2C2_CR2_SLADDR0IE                    (*((volatile unsigned int*)(0x429C8084UL)))
#define bM4_I2C2_CR2_SLADDR1IE                    (*((volatile unsigned int*)(0x429C8088UL)))
#define bM4_I2C2_CR2_TENDIE                       (*((volatile unsigned int*)(0x429C808CUL)))
#define bM4_I2C2_CR2_STOPIE                       (*((volatile unsigned int*)(0x429C8090UL)))
#define bM4_I2C2_CR2_RFULLIE                      (*((volatile unsigned int*)(0x429C8098UL)))
#define bM4_I2C2_CR2_TEMPTYIE                     (*((volatile unsigned int*)(0x429C809CUL)))
#define bM4_I2C2_CR2_ARLOIE                       (*((volatile unsigned int*)(0x429C80A4UL)))
#define bM4_I2C2_CR2_NACKIE                       (*((volatile unsigned int*)(0x429C80B0UL)))
#define bM4_I2C2_CR2_TMOUTIE                      (*((volatile unsigned int*)(0x429C80B8UL)))
#define bM4_I2C2_CR2_GENCALLIE                    (*((volatile unsigned int*)(0x429C80D0UL)))
#define bM4_I2C2_CR2_SMBDEFAULTIE                 (*((volatile unsigned int*)(0x429C80D4UL)))
#define bM4_I2C2_CR2_SMBHOSTIE                    (*((volatile unsigned int*)(0x429C80D8UL)))
#define bM4_I2C2_CR2_SMBALRTIE                    (*((volatile unsigned int*)(0x429C80DCUL)))
#define bM4_I2C2_CR3_TMOUTEN                      (*((volatile unsigned int*)(0x429C8100UL)))
#define bM4_I2C2_CR3_LTMOUT                       (*((volatile unsigned int*)(0x429C8104UL)))
#define bM4_I2C2_CR3_HTMOUT                       (*((volatile unsigned int*)(0x429C8108UL)))
#define bM4_I2C2_CR3_FACKEN                       (*((volatile unsigned int*)(0x429C811CUL)))
#define bM4_I2C2_CR4_BUSWAIT                      (*((volatile unsigned int*)(0x429C81A8UL)))
#define bM4_I2C2_SLR0_SLADDR00                    (*((volatile unsigned int*)(0x429C8200UL)))
#define bM4_I2C2_SLR0_SLADDR01                    (*((volatile unsigned int*)(0x429C8204UL)))
#define bM4_I2C2_SLR0_SLADDR02                    (*((volatile unsigned int*)(0x429C8208UL)))
#define bM4_I2C2_SLR0_SLADDR03                    (*((volatile unsigned int*)(0x429C820CUL)))
#define bM4_I2C2_SLR0_SLADDR04                    (*((volatile unsigned int*)(0x429C8210UL)))
#define bM4_I2C2_SLR0_SLADDR05                    (*((volatile unsigned int*)(0x429C8214UL)))
#define bM4_I2C2_SLR0_SLADDR06                    (*((volatile unsigned int*)(0x429C8218UL)))
#define bM4_I2C2_SLR0_SLADDR07                    (*((volatile unsigned int*)(0x429C821CUL)))
#define bM4_I2C2_SLR0_SLADDR08                    (*((volatile unsigned int*)(0x429C8220UL)))
#define bM4_I2C2_SLR0_SLADDR09                    (*((volatile unsigned int*)(0x429C8224UL)))
#define bM4_I2C2_SLR0_SLADDR0EN                   (*((volatile unsigned int*)(0x429C8230UL)))
#define bM4_I2C2_SLR0_ADDRMOD0                    (*((volatile unsigned int*)(0x429C823CUL)))
#define bM4_I2C2_SLR1_SLADDR10                    (*((volatile unsigned int*)(0x429C8280UL)))
#define bM4_I2C2_SLR1_SLADDR11                    (*((volatile unsigned int*)(0x429C8284UL)))
#define bM4_I2C2_SLR1_SLADDR12                    (*((volatile unsigned int*)(0x429C8288UL)))
#define bM4_I2C2_SLR1_SLADDR13                    (*((volatile unsigned int*)(0x429C828CUL)))
#define bM4_I2C2_SLR1_SLADDR14                    (*((volatile unsigned int*)(0x429C8290UL)))
#define bM4_I2C2_SLR1_SLADDR15                    (*((volatile unsigned int*)(0x429C8294UL)))
#define bM4_I2C2_SLR1_SLADDR16                    (*((volatile unsigned int*)(0x429C8298UL)))
#define bM4_I2C2_SLR1_SLADDR17                    (*((volatile unsigned int*)(0x429C829CUL)))
#define bM4_I2C2_SLR1_SLADDR18                    (*((volatile unsigned int*)(0x429C82A0UL)))
#define bM4_I2C2_SLR1_SLADDR19                    (*((volatile unsigned int*)(0x429C82A4UL)))
#define bM4_I2C2_SLR1_SLADDR1EN                   (*((volatile unsigned int*)(0x429C82B0UL)))
#define bM4_I2C2_SLR1_ADDRMOD1                    (*((volatile unsigned int*)(0x429C82BCUL)))
#define bM4_I2C2_SLTR_TOUTLOW0                    (*((volatile unsigned int*)(0x429C8300UL)))
#define bM4_I2C2_SLTR_TOUTLOW1                    (*((volatile unsigned int*)(0x429C8304UL)))
#define bM4_I2C2_SLTR_TOUTLOW2                    (*((volatile unsigned int*)(0x429C8308UL)))
#define bM4_I2C2_SLTR_TOUTLOW3                    (*((volatile unsigned int*)(0x429C830CUL)))
#define bM4_I2C2_SLTR_TOUTLOW4                    (*((volatile unsigned int*)(0x429C8310UL)))
#define bM4_I2C2_SLTR_TOUTLOW5                    (*((volatile unsigned int*)(0x429C8314UL)))
#define bM4_I2C2_SLTR_TOUTLOW6                    (*((volatile unsigned int*)(0x429C8318UL)))
#define bM4_I2C2_SLTR_TOUTLOW7                    (*((volatile unsigned int*)(0x429C831CUL)))
#define bM4_I2C2_SLTR_TOUTLOW8                    (*((volatile unsigned int*)(0x429C8320UL)))
#define bM4_I2C2_SLTR_TOUTLOW9                    (*((volatile unsigned int*)(0x429C8324UL)))
#define bM4_I2C2_SLTR_TOUTLOW10                   (*((volatile unsigned int*)(0x429C8328UL)))
#define bM4_I2C2_SLTR_TOUTLOW11                   (*((volatile unsigned int*)(0x429C832CUL)))
#define bM4_I2C2_SLTR_TOUTLOW12                   (*((volatile unsigned int*)(0x429C8330UL)))
#define bM4_I2C2_SLTR_TOUTLOW13                   (*((volatile unsigned int*)(0x429C8334UL)))
#define bM4_I2C2_SLTR_TOUTLOW14                   (*((volatile unsigned int*)(0x429C8338UL)))
#define bM4_I2C2_SLTR_TOUTLOW15                   (*((volatile unsigned int*)(0x429C833CUL)))
#define bM4_I2C2_SLTR_TOUTHIGH0                   (*((volatile unsigned int*)(0x429C8340UL)))
#define bM4_I2C2_SLTR_TOUTHIGH1                   (*((volatile unsigned int*)(0x429C8344UL)))
#define bM4_I2C2_SLTR_TOUTHIGH2                   (*((volatile unsigned int*)(0x429C8348UL)))
#define bM4_I2C2_SLTR_TOUTHIGH3                   (*((volatile unsigned int*)(0x429C834CUL)))
#define bM4_I2C2_SLTR_TOUTHIGH4                   (*((volatile unsigned int*)(0x429C8350UL)))
#define bM4_I2C2_SLTR_TOUTHIGH5                   (*((volatile unsigned int*)(0x429C8354UL)))
#define bM4_I2C2_SLTR_TOUTHIGH6                   (*((volatile unsigned int*)(0x429C8358UL)))
#define bM4_I2C2_SLTR_TOUTHIGH7                   (*((volatile unsigned int*)(0x429C835CUL)))
#define bM4_I2C2_SLTR_TOUTHIGH8                   (*((volatile unsigned int*)(0x429C8360UL)))
#define bM4_I2C2_SLTR_TOUTHIGH9                   (*((volatile unsigned int*)(0x429C8364UL)))
#define bM4_I2C2_SLTR_TOUTHIGH10                  (*((volatile unsigned int*)(0x429C8368UL)))
#define bM4_I2C2_SLTR_TOUTHIGH11                  (*((volatile unsigned int*)(0x429C836CUL)))
#define bM4_I2C2_SLTR_TOUTHIGH12                  (*((volatile unsigned int*)(0x429C8370UL)))
#define bM4_I2C2_SLTR_TOUTHIGH13                  (*((volatile unsigned int*)(0x429C8374UL)))
#define bM4_I2C2_SLTR_TOUTHIGH14                  (*((volatile unsigned int*)(0x429C8378UL)))
#define bM4_I2C2_SLTR_TOUTHIGH15                  (*((volatile unsigned int*)(0x429C837CUL)))
#define bM4_I2C2_SR_STARTF                        (*((volatile unsigned int*)(0x429C8380UL)))
#define bM4_I2C2_SR_SLADDR0F                      (*((volatile unsigned int*)(0x429C8384UL)))
#define bM4_I2C2_SR_SLADDR1F                      (*((volatile unsigned int*)(0x429C8388UL)))
#define bM4_I2C2_SR_TENDF                         (*((volatile unsigned int*)(0x429C838CUL)))
#define bM4_I2C2_SR_STOPF                         (*((volatile unsigned int*)(0x429C8390UL)))
#define bM4_I2C2_SR_RFULLF                        (*((volatile unsigned int*)(0x429C8398UL)))
#define bM4_I2C2_SR_TEMPTYF                       (*((volatile unsigned int*)(0x429C839CUL)))
#define bM4_I2C2_SR_ARLOF                         (*((volatile unsigned int*)(0x429C83A4UL)))
#define bM4_I2C2_SR_ACKRF                         (*((volatile unsigned int*)(0x429C83A8UL)))
#define bM4_I2C2_SR_NACKF                         (*((volatile unsigned int*)(0x429C83B0UL)))
#define bM4_I2C2_SR_TMOUTF                        (*((volatile unsigned int*)(0x429C83B8UL)))
#define bM4_I2C2_SR_MSL                           (*((volatile unsigned int*)(0x429C83C0UL)))
#define bM4_I2C2_SR_BUSY                          (*((volatile unsigned int*)(0x429C83C4UL)))
#define bM4_I2C2_SR_TRA                           (*((volatile unsigned int*)(0x429C83C8UL)))
#define bM4_I2C2_SR_GENCALLF                      (*((volatile unsigned int*)(0x429C83D0UL)))
#define bM4_I2C2_SR_SMBDEFAULTF                   (*((volatile unsigned int*)(0x429C83D4UL)))
#define bM4_I2C2_SR_SMBHOSTF                      (*((volatile unsigned int*)(0x429C83D8UL)))
#define bM4_I2C2_SR_SMBALRTF                      (*((volatile unsigned int*)(0x429C83DCUL)))
#define bM4_I2C2_CLR_STARTFCLR                    (*((volatile unsigned int*)(0x429C8400UL)))
#define bM4_I2C2_CLR_SLADDR0FCLR                  (*((volatile unsigned int*)(0x429C8404UL)))
#define bM4_I2C2_CLR_SLADDR1FCLR                  (*((volatile unsigned int*)(0x429C8408UL)))
#define bM4_I2C2_CLR_TENDFCLR                     (*((volatile unsigned int*)(0x429C840CUL)))
#define bM4_I2C2_CLR_STOPFCLR                     (*((volatile unsigned int*)(0x429C8410UL)))
#define bM4_I2C2_CLR_RFULLFCLR                    (*((volatile unsigned int*)(0x429C8418UL)))
#define bM4_I2C2_CLR_TEMPTYFCLR                   (*((volatile unsigned int*)(0x429C841CUL)))
#define bM4_I2C2_CLR_ARLOFCLR                     (*((volatile unsigned int*)(0x429C8424UL)))
#define bM4_I2C2_CLR_NACKFCLR                     (*((volatile unsigned int*)(0x429C8430UL)))
#define bM4_I2C2_CLR_TMOUTFCLR                    (*((volatile unsigned int*)(0x429C8438UL)))
#define bM4_I2C2_CLR_GENCALLFCLR                  (*((volatile unsigned int*)(0x429C8450UL)))
#define bM4_I2C2_CLR_SMBDEFAULTFCLR               (*((volatile unsigned int*)(0x429C8454UL)))
#define bM4_I2C2_CLR_SMBHOSTFCLR                  (*((volatile unsigned int*)(0x429C8458UL)))
#define bM4_I2C2_CLR_SMBALRTFCLR                  (*((volatile unsigned int*)(0x429C845CUL)))
#define bM4_I2C2_DTR_DT0                          (*((volatile unsigned int*)(0x429C8480UL)))
#define bM4_I2C2_DTR_DT1                          (*((volatile unsigned int*)(0x429C8484UL)))
#define bM4_I2C2_DTR_DT2                          (*((volatile unsigned int*)(0x429C8488UL)))
#define bM4_I2C2_DTR_DT3                          (*((volatile unsigned int*)(0x429C848CUL)))
#define bM4_I2C2_DTR_DT4                          (*((volatile unsigned int*)(0x429C8490UL)))
#define bM4_I2C2_DTR_DT5                          (*((volatile unsigned int*)(0x429C8494UL)))
#define bM4_I2C2_DTR_DT6                          (*((volatile unsigned int*)(0x429C8498UL)))
#define bM4_I2C2_DTR_DT7                          (*((volatile unsigned int*)(0x429C849CUL)))
#define bM4_I2C2_DRR_DR0                          (*((volatile unsigned int*)(0x429C8500UL)))
#define bM4_I2C2_DRR_DR1                          (*((volatile unsigned int*)(0x429C8504UL)))
#define bM4_I2C2_DRR_DR2                          (*((volatile unsigned int*)(0x429C8508UL)))
#define bM4_I2C2_DRR_DR3                          (*((volatile unsigned int*)(0x429C850CUL)))
#define bM4_I2C2_DRR_DR4                          (*((volatile unsigned int*)(0x429C8510UL)))
#define bM4_I2C2_DRR_DR5                          (*((volatile unsigned int*)(0x429C8514UL)))
#define bM4_I2C2_DRR_DR6                          (*((volatile unsigned int*)(0x429C8518UL)))
#define bM4_I2C2_DRR_DR7                          (*((volatile unsigned int*)(0x429C851CUL)))
#define bM4_I2C2_CCR_SLOWW0                       (*((volatile unsigned int*)(0x429C8580UL)))
#define bM4_I2C2_CCR_SLOWW1                       (*((volatile unsigned int*)(0x429C8584UL)))
#define bM4_I2C2_CCR_SLOWW2                       (*((volatile unsigned int*)(0x429C8588UL)))
#define bM4_I2C2_CCR_SLOWW3                       (*((volatile unsigned int*)(0x429C858CUL)))
#define bM4_I2C2_CCR_SLOWW4                       (*((volatile unsigned int*)(0x429C8590UL)))
#define bM4_I2C2_CCR_SHIGHW0                      (*((volatile unsigned int*)(0x429C85A0UL)))
#define bM4_I2C2_CCR_SHIGHW1                      (*((volatile unsigned int*)(0x429C85A4UL)))
#define bM4_I2C2_CCR_SHIGHW2                      (*((volatile unsigned int*)(0x429C85A8UL)))
#define bM4_I2C2_CCR_SHIGHW3                      (*((volatile unsigned int*)(0x429C85ACUL)))
#define bM4_I2C2_CCR_SHIGHW4                      (*((volatile unsigned int*)(0x429C85B0UL)))
#define bM4_I2C2_CCR_FREQ0                        (*((volatile unsigned int*)(0x429C85C0UL)))
#define bM4_I2C2_CCR_FREQ1                        (*((volatile unsigned int*)(0x429C85C4UL)))
#define bM4_I2C2_CCR_FREQ2                        (*((volatile unsigned int*)(0x429C85C8UL)))
#define bM4_I2C2_FLTR_DNF0                        (*((volatile unsigned int*)(0x429C8600UL)))
#define bM4_I2C2_FLTR_DNF1                        (*((volatile unsigned int*)(0x429C8604UL)))
#define bM4_I2C2_FLTR_DNFEN                       (*((volatile unsigned int*)(0x429C8610UL)))
#define bM4_I2C2_FLTR_ANFEN                       (*((volatile unsigned int*)(0x429C8614UL)))
#define bM4_I2C3_CR1_PE                           (*((volatile unsigned int*)(0x429D0000UL)))
#define bM4_I2C3_CR1_SMBUS                        (*((volatile unsigned int*)(0x429D0004UL)))
#define bM4_I2C3_CR1_SMBALRTEN                    (*((volatile unsigned int*)(0x429D0008UL)))
#define bM4_I2C3_CR1_SMBDEFAULTEN                 (*((volatile unsigned int*)(0x429D000CUL)))
#define bM4_I2C3_CR1_SMBHOSTEN                    (*((volatile unsigned int*)(0x429D0010UL)))
#define bM4_I2C3_CR1_ENGC                         (*((volatile unsigned int*)(0x429D0018UL)))
#define bM4_I2C3_CR1_RESTART                      (*((volatile unsigned int*)(0x429D001CUL)))
#define bM4_I2C3_CR1_START                        (*((volatile unsigned int*)(0x429D0020UL)))
#define bM4_I2C3_CR1_STOP                         (*((volatile unsigned int*)(0x429D0024UL)))
#define bM4_I2C3_CR1_ACK                          (*((volatile unsigned int*)(0x429D0028UL)))
#define bM4_I2C3_CR1_SWRST                        (*((volatile unsigned int*)(0x429D003CUL)))
#define bM4_I2C3_CR2_STARTIE                      (*((volatile unsigned int*)(0x429D0080UL)))
#define bM4_I2C3_CR2_SLADDR0IE                    (*((volatile unsigned int*)(0x429D0084UL)))
#define bM4_I2C3_CR2_SLADDR1IE                    (*((volatile unsigned int*)(0x429D0088UL)))
#define bM4_I2C3_CR2_TENDIE                       (*((volatile unsigned int*)(0x429D008CUL)))
#define bM4_I2C3_CR2_STOPIE                       (*((volatile unsigned int*)(0x429D0090UL)))
#define bM4_I2C3_CR2_RFULLIE                      (*((volatile unsigned int*)(0x429D0098UL)))
#define bM4_I2C3_CR2_TEMPTYIE                     (*((volatile unsigned int*)(0x429D009CUL)))
#define bM4_I2C3_CR2_ARLOIE                       (*((volatile unsigned int*)(0x429D00A4UL)))
#define bM4_I2C3_CR2_NACKIE                       (*((volatile unsigned int*)(0x429D00B0UL)))
#define bM4_I2C3_CR2_TMOUTIE                      (*((volatile unsigned int*)(0x429D00B8UL)))
#define bM4_I2C3_CR2_GENCALLIE                    (*((volatile unsigned int*)(0x429D00D0UL)))
#define bM4_I2C3_CR2_SMBDEFAULTIE                 (*((volatile unsigned int*)(0x429D00D4UL)))
#define bM4_I2C3_CR2_SMBHOSTIE                    (*((volatile unsigned int*)(0x429D00D8UL)))
#define bM4_I2C3_CR2_SMBALRTIE                    (*((volatile unsigned int*)(0x429D00DCUL)))
#define bM4_I2C3_CR3_TMOUTEN                      (*((volatile unsigned int*)(0x429D0100UL)))
#define bM4_I2C3_CR3_LTMOUT                       (*((volatile unsigned int*)(0x429D0104UL)))
#define bM4_I2C3_CR3_HTMOUT                       (*((volatile unsigned int*)(0x429D0108UL)))
#define bM4_I2C3_CR3_FACKEN                       (*((volatile unsigned int*)(0x429D011CUL)))
#define bM4_I2C3_CR4_BUSWAIT                      (*((volatile unsigned int*)(0x429D01A8UL)))
#define bM4_I2C3_SLR0_SLADDR00                    (*((volatile unsigned int*)(0x429D0200UL)))
#define bM4_I2C3_SLR0_SLADDR01                    (*((volatile unsigned int*)(0x429D0204UL)))
#define bM4_I2C3_SLR0_SLADDR02                    (*((volatile unsigned int*)(0x429D0208UL)))
#define bM4_I2C3_SLR0_SLADDR03                    (*((volatile unsigned int*)(0x429D020CUL)))
#define bM4_I2C3_SLR0_SLADDR04                    (*((volatile unsigned int*)(0x429D0210UL)))
#define bM4_I2C3_SLR0_SLADDR05                    (*((volatile unsigned int*)(0x429D0214UL)))
#define bM4_I2C3_SLR0_SLADDR06                    (*((volatile unsigned int*)(0x429D0218UL)))
#define bM4_I2C3_SLR0_SLADDR07                    (*((volatile unsigned int*)(0x429D021CUL)))
#define bM4_I2C3_SLR0_SLADDR08                    (*((volatile unsigned int*)(0x429D0220UL)))
#define bM4_I2C3_SLR0_SLADDR09                    (*((volatile unsigned int*)(0x429D0224UL)))
#define bM4_I2C3_SLR0_SLADDR0EN                   (*((volatile unsigned int*)(0x429D0230UL)))
#define bM4_I2C3_SLR0_ADDRMOD0                    (*((volatile unsigned int*)(0x429D023CUL)))
#define bM4_I2C3_SLR1_SLADDR10                    (*((volatile unsigned int*)(0x429D0280UL)))
#define bM4_I2C3_SLR1_SLADDR11                    (*((volatile unsigned int*)(0x429D0284UL)))
#define bM4_I2C3_SLR1_SLADDR12                    (*((volatile unsigned int*)(0x429D0288UL)))
#define bM4_I2C3_SLR1_SLADDR13                    (*((volatile unsigned int*)(0x429D028CUL)))
#define bM4_I2C3_SLR1_SLADDR14                    (*((volatile unsigned int*)(0x429D0290UL)))
#define bM4_I2C3_SLR1_SLADDR15                    (*((volatile unsigned int*)(0x429D0294UL)))
#define bM4_I2C3_SLR1_SLADDR16                    (*((volatile unsigned int*)(0x429D0298UL)))
#define bM4_I2C3_SLR1_SLADDR17                    (*((volatile unsigned int*)(0x429D029CUL)))
#define bM4_I2C3_SLR1_SLADDR18                    (*((volatile unsigned int*)(0x429D02A0UL)))
#define bM4_I2C3_SLR1_SLADDR19                    (*((volatile unsigned int*)(0x429D02A4UL)))
#define bM4_I2C3_SLR1_SLADDR1EN                   (*((volatile unsigned int*)(0x429D02B0UL)))
#define bM4_I2C3_SLR1_ADDRMOD1                    (*((volatile unsigned int*)(0x429D02BCUL)))
#define bM4_I2C3_SLTR_TOUTLOW0                    (*((volatile unsigned int*)(0x429D0300UL)))
#define bM4_I2C3_SLTR_TOUTLOW1                    (*((volatile unsigned int*)(0x429D0304UL)))
#define bM4_I2C3_SLTR_TOUTLOW2                    (*((volatile unsigned int*)(0x429D0308UL)))
#define bM4_I2C3_SLTR_TOUTLOW3                    (*((volatile unsigned int*)(0x429D030CUL)))
#define bM4_I2C3_SLTR_TOUTLOW4                    (*((volatile unsigned int*)(0x429D0310UL)))
#define bM4_I2C3_SLTR_TOUTLOW5                    (*((volatile unsigned int*)(0x429D0314UL)))
#define bM4_I2C3_SLTR_TOUTLOW6                    (*((volatile unsigned int*)(0x429D0318UL)))
#define bM4_I2C3_SLTR_TOUTLOW7                    (*((volatile unsigned int*)(0x429D031CUL)))
#define bM4_I2C3_SLTR_TOUTLOW8                    (*((volatile unsigned int*)(0x429D0320UL)))
#define bM4_I2C3_SLTR_TOUTLOW9                    (*((volatile unsigned int*)(0x429D0324UL)))
#define bM4_I2C3_SLTR_TOUTLOW10                   (*((volatile unsigned int*)(0x429D0328UL)))
#define bM4_I2C3_SLTR_TOUTLOW11                   (*((volatile unsigned int*)(0x429D032CUL)))
#define bM4_I2C3_SLTR_TOUTLOW12                   (*((volatile unsigned int*)(0x429D0330UL)))
#define bM4_I2C3_SLTR_TOUTLOW13                   (*((volatile unsigned int*)(0x429D0334UL)))
#define bM4_I2C3_SLTR_TOUTLOW14                   (*((volatile unsigned int*)(0x429D0338UL)))
#define bM4_I2C3_SLTR_TOUTLOW15                   (*((volatile unsigned int*)(0x429D033CUL)))
#define bM4_I2C3_SLTR_TOUTHIGH0                   (*((volatile unsigned int*)(0x429D0340UL)))
#define bM4_I2C3_SLTR_TOUTHIGH1                   (*((volatile unsigned int*)(0x429D0344UL)))
#define bM4_I2C3_SLTR_TOUTHIGH2                   (*((volatile unsigned int*)(0x429D0348UL)))
#define bM4_I2C3_SLTR_TOUTHIGH3                   (*((volatile unsigned int*)(0x429D034CUL)))
#define bM4_I2C3_SLTR_TOUTHIGH4                   (*((volatile unsigned int*)(0x429D0350UL)))
#define bM4_I2C3_SLTR_TOUTHIGH5                   (*((volatile unsigned int*)(0x429D0354UL)))
#define bM4_I2C3_SLTR_TOUTHIGH6                   (*((volatile unsigned int*)(0x429D0358UL)))
#define bM4_I2C3_SLTR_TOUTHIGH7                   (*((volatile unsigned int*)(0x429D035CUL)))
#define bM4_I2C3_SLTR_TOUTHIGH8                   (*((volatile unsigned int*)(0x429D0360UL)))
#define bM4_I2C3_SLTR_TOUTHIGH9                   (*((volatile unsigned int*)(0x429D0364UL)))
#define bM4_I2C3_SLTR_TOUTHIGH10                  (*((volatile unsigned int*)(0x429D0368UL)))
#define bM4_I2C3_SLTR_TOUTHIGH11                  (*((volatile unsigned int*)(0x429D036CUL)))
#define bM4_I2C3_SLTR_TOUTHIGH12                  (*((volatile unsigned int*)(0x429D0370UL)))
#define bM4_I2C3_SLTR_TOUTHIGH13                  (*((volatile unsigned int*)(0x429D0374UL)))
#define bM4_I2C3_SLTR_TOUTHIGH14                  (*((volatile unsigned int*)(0x429D0378UL)))
#define bM4_I2C3_SLTR_TOUTHIGH15                  (*((volatile unsigned int*)(0x429D037CUL)))
#define bM4_I2C3_SR_STARTF                        (*((volatile unsigned int*)(0x429D0380UL)))
#define bM4_I2C3_SR_SLADDR0F                      (*((volatile unsigned int*)(0x429D0384UL)))
#define bM4_I2C3_SR_SLADDR1F                      (*((volatile unsigned int*)(0x429D0388UL)))
#define bM4_I2C3_SR_TENDF                         (*((volatile unsigned int*)(0x429D038CUL)))
#define bM4_I2C3_SR_STOPF                         (*((volatile unsigned int*)(0x429D0390UL)))
#define bM4_I2C3_SR_RFULLF                        (*((volatile unsigned int*)(0x429D0398UL)))
#define bM4_I2C3_SR_TEMPTYF                       (*((volatile unsigned int*)(0x429D039CUL)))
#define bM4_I2C3_SR_ARLOF                         (*((volatile unsigned int*)(0x429D03A4UL)))
#define bM4_I2C3_SR_ACKRF                         (*((volatile unsigned int*)(0x429D03A8UL)))
#define bM4_I2C3_SR_NACKF                         (*((volatile unsigned int*)(0x429D03B0UL)))
#define bM4_I2C3_SR_TMOUTF                        (*((volatile unsigned int*)(0x429D03B8UL)))
#define bM4_I2C3_SR_MSL                           (*((volatile unsigned int*)(0x429D03C0UL)))
#define bM4_I2C3_SR_BUSY                          (*((volatile unsigned int*)(0x429D03C4UL)))
#define bM4_I2C3_SR_TRA                           (*((volatile unsigned int*)(0x429D03C8UL)))
#define bM4_I2C3_SR_GENCALLF                      (*((volatile unsigned int*)(0x429D03D0UL)))
#define bM4_I2C3_SR_SMBDEFAULTF                   (*((volatile unsigned int*)(0x429D03D4UL)))
#define bM4_I2C3_SR_SMBHOSTF                      (*((volatile unsigned int*)(0x429D03D8UL)))
#define bM4_I2C3_SR_SMBALRTF                      (*((volatile unsigned int*)(0x429D03DCUL)))
#define bM4_I2C3_CLR_STARTFCLR                    (*((volatile unsigned int*)(0x429D0400UL)))
#define bM4_I2C3_CLR_SLADDR0FCLR                  (*((volatile unsigned int*)(0x429D0404UL)))
#define bM4_I2C3_CLR_SLADDR1FCLR                  (*((volatile unsigned int*)(0x429D0408UL)))
#define bM4_I2C3_CLR_TENDFCLR                     (*((volatile unsigned int*)(0x429D040CUL)))
#define bM4_I2C3_CLR_STOPFCLR                     (*((volatile unsigned int*)(0x429D0410UL)))
#define bM4_I2C3_CLR_RFULLFCLR                    (*((volatile unsigned int*)(0x429D0418UL)))
#define bM4_I2C3_CLR_TEMPTYFCLR                   (*((volatile unsigned int*)(0x429D041CUL)))
#define bM4_I2C3_CLR_ARLOFCLR                     (*((volatile unsigned int*)(0x429D0424UL)))
#define bM4_I2C3_CLR_NACKFCLR                     (*((volatile unsigned int*)(0x429D0430UL)))
#define bM4_I2C3_CLR_TMOUTFCLR                    (*((volatile unsigned int*)(0x429D0438UL)))
#define bM4_I2C3_CLR_GENCALLFCLR                  (*((volatile unsigned int*)(0x429D0450UL)))
#define bM4_I2C3_CLR_SMBDEFAULTFCLR               (*((volatile unsigned int*)(0x429D0454UL)))
#define bM4_I2C3_CLR_SMBHOSTFCLR                  (*((volatile unsigned int*)(0x429D0458UL)))
#define bM4_I2C3_CLR_SMBALRTFCLR                  (*((volatile unsigned int*)(0x429D045CUL)))
#define bM4_I2C3_DTR_DT0                          (*((volatile unsigned int*)(0x429D0480UL)))
#define bM4_I2C3_DTR_DT1                          (*((volatile unsigned int*)(0x429D0484UL)))
#define bM4_I2C3_DTR_DT2                          (*((volatile unsigned int*)(0x429D0488UL)))
#define bM4_I2C3_DTR_DT3                          (*((volatile unsigned int*)(0x429D048CUL)))
#define bM4_I2C3_DTR_DT4                          (*((volatile unsigned int*)(0x429D0490UL)))
#define bM4_I2C3_DTR_DT5                          (*((volatile unsigned int*)(0x429D0494UL)))
#define bM4_I2C3_DTR_DT6                          (*((volatile unsigned int*)(0x429D0498UL)))
#define bM4_I2C3_DTR_DT7                          (*((volatile unsigned int*)(0x429D049CUL)))
#define bM4_I2C3_DRR_DR0                          (*((volatile unsigned int*)(0x429D0500UL)))
#define bM4_I2C3_DRR_DR1                          (*((volatile unsigned int*)(0x429D0504UL)))
#define bM4_I2C3_DRR_DR2                          (*((volatile unsigned int*)(0x429D0508UL)))
#define bM4_I2C3_DRR_DR3                          (*((volatile unsigned int*)(0x429D050CUL)))
#define bM4_I2C3_DRR_DR4                          (*((volatile unsigned int*)(0x429D0510UL)))
#define bM4_I2C3_DRR_DR5                          (*((volatile unsigned int*)(0x429D0514UL)))
#define bM4_I2C3_DRR_DR6                          (*((volatile unsigned int*)(0x429D0518UL)))
#define bM4_I2C3_DRR_DR7                          (*((volatile unsigned int*)(0x429D051CUL)))
#define bM4_I2C3_CCR_SLOWW0                       (*((volatile unsigned int*)(0x429D0580UL)))
#define bM4_I2C3_CCR_SLOWW1                       (*((volatile unsigned int*)(0x429D0584UL)))
#define bM4_I2C3_CCR_SLOWW2                       (*((volatile unsigned int*)(0x429D0588UL)))
#define bM4_I2C3_CCR_SLOWW3                       (*((volatile unsigned int*)(0x429D058CUL)))
#define bM4_I2C3_CCR_SLOWW4                       (*((volatile unsigned int*)(0x429D0590UL)))
#define bM4_I2C3_CCR_SHIGHW0                      (*((volatile unsigned int*)(0x429D05A0UL)))
#define bM4_I2C3_CCR_SHIGHW1                      (*((volatile unsigned int*)(0x429D05A4UL)))
#define bM4_I2C3_CCR_SHIGHW2                      (*((volatile unsigned int*)(0x429D05A8UL)))
#define bM4_I2C3_CCR_SHIGHW3                      (*((volatile unsigned int*)(0x429D05ACUL)))
#define bM4_I2C3_CCR_SHIGHW4                      (*((volatile unsigned int*)(0x429D05B0UL)))
#define bM4_I2C3_CCR_FREQ0                        (*((volatile unsigned int*)(0x429D05C0UL)))
#define bM4_I2C3_CCR_FREQ1                        (*((volatile unsigned int*)(0x429D05C4UL)))
#define bM4_I2C3_CCR_FREQ2                        (*((volatile unsigned int*)(0x429D05C8UL)))
#define bM4_I2C3_FLTR_DNF0                        (*((volatile unsigned int*)(0x429D0600UL)))
#define bM4_I2C3_FLTR_DNF1                        (*((volatile unsigned int*)(0x429D0604UL)))
#define bM4_I2C3_FLTR_DNFEN                       (*((volatile unsigned int*)(0x429D0610UL)))
#define bM4_I2C3_FLTR_ANFEN                       (*((volatile unsigned int*)(0x429D0614UL)))
#define bM4_I2S1_CTRL_TXE                         (*((volatile unsigned int*)(0x423C0000UL)))
#define bM4_I2S1_CTRL_TXIE                        (*((volatile unsigned int*)(0x423C0004UL)))
#define bM4_I2S1_CTRL_RXE                         (*((volatile unsigned int*)(0x423C0008UL)))
#define bM4_I2S1_CTRL_RXIE                        (*((volatile unsigned int*)(0x423C000CUL)))
#define bM4_I2S1_CTRL_EIE                         (*((volatile unsigned int*)(0x423C0010UL)))
#define bM4_I2S1_CTRL_WMS                         (*((volatile unsigned int*)(0x423C0014UL)))
#define bM4_I2S1_CTRL_ODD                         (*((volatile unsigned int*)(0x423C0018UL)))
#define bM4_I2S1_CTRL_MCKOE                       (*((volatile unsigned int*)(0x423C001CUL)))
#define bM4_I2S1_CTRL_TXBIRQWL0                   (*((volatile unsigned int*)(0x423C0020UL)))
#define bM4_I2S1_CTRL_TXBIRQWL1                   (*((volatile unsigned int*)(0x423C0024UL)))
#define bM4_I2S1_CTRL_TXBIRQWL2                   (*((volatile unsigned int*)(0x423C0028UL)))
#define bM4_I2S1_CTRL_RXBIRQWL0                   (*((volatile unsigned int*)(0x423C0030UL)))
#define bM4_I2S1_CTRL_RXBIRQWL1                   (*((volatile unsigned int*)(0x423C0034UL)))
#define bM4_I2S1_CTRL_RXBIRQWL2                   (*((volatile unsigned int*)(0x423C0038UL)))
#define bM4_I2S1_CTRL_FIFOR                       (*((volatile unsigned int*)(0x423C0040UL)))
#define bM4_I2S1_CTRL_CODECRC                     (*((volatile unsigned int*)(0x423C0044UL)))
#define bM4_I2S1_CTRL_I2SPLLSEL                   (*((volatile unsigned int*)(0x423C0048UL)))
#define bM4_I2S1_CTRL_SDOE                        (*((volatile unsigned int*)(0x423C004CUL)))
#define bM4_I2S1_CTRL_LRCKOE                      (*((volatile unsigned int*)(0x423C0050UL)))
#define bM4_I2S1_CTRL_CKOE                        (*((volatile unsigned int*)(0x423C0054UL)))
#define bM4_I2S1_CTRL_DUPLEX                      (*((volatile unsigned int*)(0x423C0058UL)))
#define bM4_I2S1_CTRL_CLKSEL                      (*((volatile unsigned int*)(0x423C005CUL)))
#define bM4_I2S1_SR_TXBA                          (*((volatile unsigned int*)(0x423C0080UL)))
#define bM4_I2S1_SR_RXBA                          (*((volatile unsigned int*)(0x423C0084UL)))
#define bM4_I2S1_SR_TXBE                          (*((volatile unsigned int*)(0x423C0088UL)))
#define bM4_I2S1_SR_TXBF                          (*((volatile unsigned int*)(0x423C008CUL)))
#define bM4_I2S1_SR_RXBE                          (*((volatile unsigned int*)(0x423C0090UL)))
#define bM4_I2S1_SR_RXBF                          (*((volatile unsigned int*)(0x423C0094UL)))
#define bM4_I2S1_ER_TXERR                         (*((volatile unsigned int*)(0x423C0100UL)))
#define bM4_I2S1_ER_RXERR                         (*((volatile unsigned int*)(0x423C0104UL)))
#define bM4_I2S1_CFGR_I2SSTD0                     (*((volatile unsigned int*)(0x423C0180UL)))
#define bM4_I2S1_CFGR_I2SSTD1                     (*((volatile unsigned int*)(0x423C0184UL)))
#define bM4_I2S1_CFGR_DATLEN0                     (*((volatile unsigned int*)(0x423C0188UL)))
#define bM4_I2S1_CFGR_DATLEN1                     (*((volatile unsigned int*)(0x423C018CUL)))
#define bM4_I2S1_CFGR_CHLEN                       (*((volatile unsigned int*)(0x423C0190UL)))
#define bM4_I2S1_CFGR_PCMSYNC                     (*((volatile unsigned int*)(0x423C0194UL)))
#define bM4_I2S1_PR_I2SDIV0                       (*((volatile unsigned int*)(0x423C0300UL)))
#define bM4_I2S1_PR_I2SDIV1                       (*((volatile unsigned int*)(0x423C0304UL)))
#define bM4_I2S1_PR_I2SDIV2                       (*((volatile unsigned int*)(0x423C0308UL)))
#define bM4_I2S1_PR_I2SDIV3                       (*((volatile unsigned int*)(0x423C030CUL)))
#define bM4_I2S1_PR_I2SDIV4                       (*((volatile unsigned int*)(0x423C0310UL)))
#define bM4_I2S1_PR_I2SDIV5                       (*((volatile unsigned int*)(0x423C0314UL)))
#define bM4_I2S1_PR_I2SDIV6                       (*((volatile unsigned int*)(0x423C0318UL)))
#define bM4_I2S1_PR_I2SDIV7                       (*((volatile unsigned int*)(0x423C031CUL)))
#define bM4_I2S2_CTRL_TXE                         (*((volatile unsigned int*)(0x423C8000UL)))
#define bM4_I2S2_CTRL_TXIE                        (*((volatile unsigned int*)(0x423C8004UL)))
#define bM4_I2S2_CTRL_RXE                         (*((volatile unsigned int*)(0x423C8008UL)))
#define bM4_I2S2_CTRL_RXIE                        (*((volatile unsigned int*)(0x423C800CUL)))
#define bM4_I2S2_CTRL_EIE                         (*((volatile unsigned int*)(0x423C8010UL)))
#define bM4_I2S2_CTRL_WMS                         (*((volatile unsigned int*)(0x423C8014UL)))
#define bM4_I2S2_CTRL_ODD                         (*((volatile unsigned int*)(0x423C8018UL)))
#define bM4_I2S2_CTRL_MCKOE                       (*((volatile unsigned int*)(0x423C801CUL)))
#define bM4_I2S2_CTRL_TXBIRQWL0                   (*((volatile unsigned int*)(0x423C8020UL)))
#define bM4_I2S2_CTRL_TXBIRQWL1                   (*((volatile unsigned int*)(0x423C8024UL)))
#define bM4_I2S2_CTRL_TXBIRQWL2                   (*((volatile unsigned int*)(0x423C8028UL)))
#define bM4_I2S2_CTRL_RXBIRQWL0                   (*((volatile unsigned int*)(0x423C8030UL)))
#define bM4_I2S2_CTRL_RXBIRQWL1                   (*((volatile unsigned int*)(0x423C8034UL)))
#define bM4_I2S2_CTRL_RXBIRQWL2                   (*((volatile unsigned int*)(0x423C8038UL)))
#define bM4_I2S2_CTRL_FIFOR                       (*((volatile unsigned int*)(0x423C8040UL)))
#define bM4_I2S2_CTRL_CODECRC                     (*((volatile unsigned int*)(0x423C8044UL)))
#define bM4_I2S2_CTRL_I2SPLLSEL                   (*((volatile unsigned int*)(0x423C8048UL)))
#define bM4_I2S2_CTRL_SDOE                        (*((volatile unsigned int*)(0x423C804CUL)))
#define bM4_I2S2_CTRL_LRCKOE                      (*((volatile unsigned int*)(0x423C8050UL)))
#define bM4_I2S2_CTRL_CKOE                        (*((volatile unsigned int*)(0x423C8054UL)))
#define bM4_I2S2_CTRL_DUPLEX                      (*((volatile unsigned int*)(0x423C8058UL)))
#define bM4_I2S2_CTRL_CLKSEL                      (*((volatile unsigned int*)(0x423C805CUL)))
#define bM4_I2S2_SR_TXBA                          (*((volatile unsigned int*)(0x423C8080UL)))
#define bM4_I2S2_SR_RXBA                          (*((volatile unsigned int*)(0x423C8084UL)))
#define bM4_I2S2_SR_TXBE                          (*((volatile unsigned int*)(0x423C8088UL)))
#define bM4_I2S2_SR_TXBF                          (*((volatile unsigned int*)(0x423C808CUL)))
#define bM4_I2S2_SR_RXBE                          (*((volatile unsigned int*)(0x423C8090UL)))
#define bM4_I2S2_SR_RXBF                          (*((volatile unsigned int*)(0x423C8094UL)))
#define bM4_I2S2_ER_TXERR                         (*((volatile unsigned int*)(0x423C8100UL)))
#define bM4_I2S2_ER_RXERR                         (*((volatile unsigned int*)(0x423C8104UL)))
#define bM4_I2S2_CFGR_I2SSTD0                     (*((volatile unsigned int*)(0x423C8180UL)))
#define bM4_I2S2_CFGR_I2SSTD1                     (*((volatile unsigned int*)(0x423C8184UL)))
#define bM4_I2S2_CFGR_DATLEN0                     (*((volatile unsigned int*)(0x423C8188UL)))
#define bM4_I2S2_CFGR_DATLEN1                     (*((volatile unsigned int*)(0x423C818CUL)))
#define bM4_I2S2_CFGR_CHLEN                       (*((volatile unsigned int*)(0x423C8190UL)))
#define bM4_I2S2_CFGR_PCMSYNC                     (*((volatile unsigned int*)(0x423C8194UL)))
#define bM4_I2S2_PR_I2SDIV0                       (*((volatile unsigned int*)(0x423C8300UL)))
#define bM4_I2S2_PR_I2SDIV1                       (*((volatile unsigned int*)(0x423C8304UL)))
#define bM4_I2S2_PR_I2SDIV2                       (*((volatile unsigned int*)(0x423C8308UL)))
#define bM4_I2S2_PR_I2SDIV3                       (*((volatile unsigned int*)(0x423C830CUL)))
#define bM4_I2S2_PR_I2SDIV4                       (*((volatile unsigned int*)(0x423C8310UL)))
#define bM4_I2S2_PR_I2SDIV5                       (*((volatile unsigned int*)(0x423C8314UL)))
#define bM4_I2S2_PR_I2SDIV6                       (*((volatile unsigned int*)(0x423C8318UL)))
#define bM4_I2S2_PR_I2SDIV7                       (*((volatile unsigned int*)(0x423C831CUL)))
#define bM4_I2S3_CTRL_TXE                         (*((volatile unsigned int*)(0x42440000UL)))
#define bM4_I2S3_CTRL_TXIE                        (*((volatile unsigned int*)(0x42440004UL)))
#define bM4_I2S3_CTRL_RXE                         (*((volatile unsigned int*)(0x42440008UL)))
#define bM4_I2S3_CTRL_RXIE                        (*((volatile unsigned int*)(0x4244000CUL)))
#define bM4_I2S3_CTRL_EIE                         (*((volatile unsigned int*)(0x42440010UL)))
#define bM4_I2S3_CTRL_WMS                         (*((volatile unsigned int*)(0x42440014UL)))
#define bM4_I2S3_CTRL_ODD                         (*((volatile unsigned int*)(0x42440018UL)))
#define bM4_I2S3_CTRL_MCKOE                       (*((volatile unsigned int*)(0x4244001CUL)))
#define bM4_I2S3_CTRL_TXBIRQWL0                   (*((volatile unsigned int*)(0x42440020UL)))
#define bM4_I2S3_CTRL_TXBIRQWL1                   (*((volatile unsigned int*)(0x42440024UL)))
#define bM4_I2S3_CTRL_TXBIRQWL2                   (*((volatile unsigned int*)(0x42440028UL)))
#define bM4_I2S3_CTRL_RXBIRQWL0                   (*((volatile unsigned int*)(0x42440030UL)))
#define bM4_I2S3_CTRL_RXBIRQWL1                   (*((volatile unsigned int*)(0x42440034UL)))
#define bM4_I2S3_CTRL_RXBIRQWL2                   (*((volatile unsigned int*)(0x42440038UL)))
#define bM4_I2S3_CTRL_FIFOR                       (*((volatile unsigned int*)(0x42440040UL)))
#define bM4_I2S3_CTRL_CODECRC                     (*((volatile unsigned int*)(0x42440044UL)))
#define bM4_I2S3_CTRL_I2SPLLSEL                   (*((volatile unsigned int*)(0x42440048UL)))
#define bM4_I2S3_CTRL_SDOE                        (*((volatile unsigned int*)(0x4244004CUL)))
#define bM4_I2S3_CTRL_LRCKOE                      (*((volatile unsigned int*)(0x42440050UL)))
#define bM4_I2S3_CTRL_CKOE                        (*((volatile unsigned int*)(0x42440054UL)))
#define bM4_I2S3_CTRL_DUPLEX                      (*((volatile unsigned int*)(0x42440058UL)))
#define bM4_I2S3_CTRL_CLKSEL                      (*((volatile unsigned int*)(0x4244005CUL)))
#define bM4_I2S3_SR_TXBA                          (*((volatile unsigned int*)(0x42440080UL)))
#define bM4_I2S3_SR_RXBA                          (*((volatile unsigned int*)(0x42440084UL)))
#define bM4_I2S3_SR_TXBE                          (*((volatile unsigned int*)(0x42440088UL)))
#define bM4_I2S3_SR_TXBF                          (*((volatile unsigned int*)(0x4244008CUL)))
#define bM4_I2S3_SR_RXBE                          (*((volatile unsigned int*)(0x42440090UL)))
#define bM4_I2S3_SR_RXBF                          (*((volatile unsigned int*)(0x42440094UL)))
#define bM4_I2S3_ER_TXERR                         (*((volatile unsigned int*)(0x42440100UL)))
#define bM4_I2S3_ER_RXERR                         (*((volatile unsigned int*)(0x42440104UL)))
#define bM4_I2S3_CFGR_I2SSTD0                     (*((volatile unsigned int*)(0x42440180UL)))
#define bM4_I2S3_CFGR_I2SSTD1                     (*((volatile unsigned int*)(0x42440184UL)))
#define bM4_I2S3_CFGR_DATLEN0                     (*((volatile unsigned int*)(0x42440188UL)))
#define bM4_I2S3_CFGR_DATLEN1                     (*((volatile unsigned int*)(0x4244018CUL)))
#define bM4_I2S3_CFGR_CHLEN                       (*((volatile unsigned int*)(0x42440190UL)))
#define bM4_I2S3_CFGR_PCMSYNC                     (*((volatile unsigned int*)(0x42440194UL)))
#define bM4_I2S3_PR_I2SDIV0                       (*((volatile unsigned int*)(0x42440300UL)))
#define bM4_I2S3_PR_I2SDIV1                       (*((volatile unsigned int*)(0x42440304UL)))
#define bM4_I2S3_PR_I2SDIV2                       (*((volatile unsigned int*)(0x42440308UL)))
#define bM4_I2S3_PR_I2SDIV3                       (*((volatile unsigned int*)(0x4244030CUL)))
#define bM4_I2S3_PR_I2SDIV4                       (*((volatile unsigned int*)(0x42440310UL)))
#define bM4_I2S3_PR_I2SDIV5                       (*((volatile unsigned int*)(0x42440314UL)))
#define bM4_I2S3_PR_I2SDIV6                       (*((volatile unsigned int*)(0x42440318UL)))
#define bM4_I2S3_PR_I2SDIV7                       (*((volatile unsigned int*)(0x4244031CUL)))
#define bM4_I2S4_CTRL_TXE                         (*((volatile unsigned int*)(0x42448000UL)))
#define bM4_I2S4_CTRL_TXIE                        (*((volatile unsigned int*)(0x42448004UL)))
#define bM4_I2S4_CTRL_RXE                         (*((volatile unsigned int*)(0x42448008UL)))
#define bM4_I2S4_CTRL_RXIE                        (*((volatile unsigned int*)(0x4244800CUL)))
#define bM4_I2S4_CTRL_EIE                         (*((volatile unsigned int*)(0x42448010UL)))
#define bM4_I2S4_CTRL_WMS                         (*((volatile unsigned int*)(0x42448014UL)))
#define bM4_I2S4_CTRL_ODD                         (*((volatile unsigned int*)(0x42448018UL)))
#define bM4_I2S4_CTRL_MCKOE                       (*((volatile unsigned int*)(0x4244801CUL)))
#define bM4_I2S4_CTRL_TXBIRQWL0                   (*((volatile unsigned int*)(0x42448020UL)))
#define bM4_I2S4_CTRL_TXBIRQWL1                   (*((volatile unsigned int*)(0x42448024UL)))
#define bM4_I2S4_CTRL_TXBIRQWL2                   (*((volatile unsigned int*)(0x42448028UL)))
#define bM4_I2S4_CTRL_RXBIRQWL0                   (*((volatile unsigned int*)(0x42448030UL)))
#define bM4_I2S4_CTRL_RXBIRQWL1                   (*((volatile unsigned int*)(0x42448034UL)))
#define bM4_I2S4_CTRL_RXBIRQWL2                   (*((volatile unsigned int*)(0x42448038UL)))
#define bM4_I2S4_CTRL_FIFOR                       (*((volatile unsigned int*)(0x42448040UL)))
#define bM4_I2S4_CTRL_CODECRC                     (*((volatile unsigned int*)(0x42448044UL)))
#define bM4_I2S4_CTRL_I2SPLLSEL                   (*((volatile unsigned int*)(0x42448048UL)))
#define bM4_I2S4_CTRL_SDOE                        (*((volatile unsigned int*)(0x4244804CUL)))
#define bM4_I2S4_CTRL_LRCKOE                      (*((volatile unsigned int*)(0x42448050UL)))
#define bM4_I2S4_CTRL_CKOE                        (*((volatile unsigned int*)(0x42448054UL)))
#define bM4_I2S4_CTRL_DUPLEX                      (*((volatile unsigned int*)(0x42448058UL)))
#define bM4_I2S4_CTRL_CLKSEL                      (*((volatile unsigned int*)(0x4244805CUL)))
#define bM4_I2S4_SR_TXBA                          (*((volatile unsigned int*)(0x42448080UL)))
#define bM4_I2S4_SR_RXBA                          (*((volatile unsigned int*)(0x42448084UL)))
#define bM4_I2S4_SR_TXBE                          (*((volatile unsigned int*)(0x42448088UL)))
#define bM4_I2S4_SR_TXBF                          (*((volatile unsigned int*)(0x4244808CUL)))
#define bM4_I2S4_SR_RXBE                          (*((volatile unsigned int*)(0x42448090UL)))
#define bM4_I2S4_SR_RXBF                          (*((volatile unsigned int*)(0x42448094UL)))
#define bM4_I2S4_ER_TXERR                         (*((volatile unsigned int*)(0x42448100UL)))
#define bM4_I2S4_ER_RXERR                         (*((volatile unsigned int*)(0x42448104UL)))
#define bM4_I2S4_CFGR_I2SSTD0                     (*((volatile unsigned int*)(0x42448180UL)))
#define bM4_I2S4_CFGR_I2SSTD1                     (*((volatile unsigned int*)(0x42448184UL)))
#define bM4_I2S4_CFGR_DATLEN0                     (*((volatile unsigned int*)(0x42448188UL)))
#define bM4_I2S4_CFGR_DATLEN1                     (*((volatile unsigned int*)(0x4244818CUL)))
#define bM4_I2S4_CFGR_CHLEN                       (*((volatile unsigned int*)(0x42448190UL)))
#define bM4_I2S4_CFGR_PCMSYNC                     (*((volatile unsigned int*)(0x42448194UL)))
#define bM4_I2S4_PR_I2SDIV0                       (*((volatile unsigned int*)(0x42448300UL)))
#define bM4_I2S4_PR_I2SDIV1                       (*((volatile unsigned int*)(0x42448304UL)))
#define bM4_I2S4_PR_I2SDIV2                       (*((volatile unsigned int*)(0x42448308UL)))
#define bM4_I2S4_PR_I2SDIV3                       (*((volatile unsigned int*)(0x4244830CUL)))
#define bM4_I2S4_PR_I2SDIV4                       (*((volatile unsigned int*)(0x42448310UL)))
#define bM4_I2S4_PR_I2SDIV5                       (*((volatile unsigned int*)(0x42448314UL)))
#define bM4_I2S4_PR_I2SDIV6                       (*((volatile unsigned int*)(0x42448318UL)))
#define bM4_I2S4_PR_I2SDIV7                       (*((volatile unsigned int*)(0x4244831CUL)))
#define bM4_INTC_NMICR_NMITRG                     (*((volatile unsigned int*)(0x42A20000UL)))
#define bM4_INTC_NMICR_NSMPCLK0                   (*((volatile unsigned int*)(0x42A20010UL)))
#define bM4_INTC_NMICR_NSMPCLK1                   (*((volatile unsigned int*)(0x42A20014UL)))
#define bM4_INTC_NMICR_NFEN                       (*((volatile unsigned int*)(0x42A2001CUL)))
#define bM4_INTC_NMIENR_NMIENR                    (*((volatile unsigned int*)(0x42A20080UL)))
#define bM4_INTC_NMIENR_SWDTENR                   (*((volatile unsigned int*)(0x42A20084UL)))
#define bM4_INTC_NMIENR_PVD1ENR                   (*((volatile unsigned int*)(0x42A20088UL)))
#define bM4_INTC_NMIENR_PVD2ENR                   (*((volatile unsigned int*)(0x42A2008CUL)))
#define bM4_INTC_NMIENR_XTALSTPENR                (*((volatile unsigned int*)(0x42A20094UL)))
#define bM4_INTC_NMIENR_REPENR                    (*((volatile unsigned int*)(0x42A200A0UL)))
#define bM4_INTC_NMIENR_RECCENR                   (*((volatile unsigned int*)(0x42A200A4UL)))
#define bM4_INTC_NMIENR_BUSMENR                   (*((volatile unsigned int*)(0x42A200A8UL)))
#define bM4_INTC_NMIENR_WDTENR                    (*((volatile unsigned int*)(0x42A200ACUL)))
#define bM4_INTC_NMIFR_NMIFR                      (*((volatile unsigned int*)(0x42A20100UL)))
#define bM4_INTC_NMIFR_SWDTFR                     (*((volatile unsigned int*)(0x42A20104UL)))
#define bM4_INTC_NMIFR_PVD1FR                     (*((volatile unsigned int*)(0x42A20108UL)))
#define bM4_INTC_NMIFR_PVD2FR                     (*((volatile unsigned int*)(0x42A2010CUL)))
#define bM4_INTC_NMIFR_XTALSTPFR                  (*((volatile unsigned int*)(0x42A20114UL)))
#define bM4_INTC_NMIFR_REPFR                      (*((volatile unsigned int*)(0x42A20120UL)))
#define bM4_INTC_NMIFR_RECCFR                     (*((volatile unsigned int*)(0x42A20124UL)))
#define bM4_INTC_NMIFR_BUSMFR                     (*((volatile unsigned int*)(0x42A20128UL)))
#define bM4_INTC_NMIFR_WDTFR                      (*((volatile unsigned int*)(0x42A2012CUL)))
#define bM4_INTC_NMICFR_NMICFR                    (*((volatile unsigned int*)(0x42A20180UL)))
#define bM4_INTC_NMICFR_SWDTCFR                   (*((volatile unsigned int*)(0x42A20184UL)))
#define bM4_INTC_NMICFR_PVD1CFR                   (*((volatile unsigned int*)(0x42A20188UL)))
#define bM4_INTC_NMICFR_PVD2CFR                   (*((volatile unsigned int*)(0x42A2018CUL)))
#define bM4_INTC_NMICFR_XTALSTPCFR                (*((volatile unsigned int*)(0x42A20194UL)))
#define bM4_INTC_NMICFR_REPCFR                    (*((volatile unsigned int*)(0x42A201A0UL)))
#define bM4_INTC_NMICFR_RECCCFR                   (*((volatile unsigned int*)(0x42A201A4UL)))
#define bM4_INTC_NMICFR_BUSMCFR                   (*((volatile unsigned int*)(0x42A201A8UL)))
#define bM4_INTC_NMICFR_WDTCFR                    (*((volatile unsigned int*)(0x42A201ACUL)))
#define bM4_INTC_EIRQCR0_EIRQTRG0                 (*((volatile unsigned int*)(0x42A20200UL)))
#define bM4_INTC_EIRQCR0_EIRQTRG1                 (*((volatile unsigned int*)(0x42A20204UL)))
#define bM4_INTC_EIRQCR0_EISMPCLK0                (*((volatile unsigned int*)(0x42A20210UL)))
#define bM4_INTC_EIRQCR0_EISMPCLK1                (*((volatile unsigned int*)(0x42A20214UL)))
#define bM4_INTC_EIRQCR0_EFEN                     (*((volatile unsigned int*)(0x42A2021CUL)))
#define bM4_INTC_EIRQCR1_EIRQTRG0                 (*((volatile unsigned int*)(0x42A20280UL)))
#define bM4_INTC_EIRQCR1_EIRQTRG1                 (*((volatile unsigned int*)(0x42A20284UL)))
#define bM4_INTC_EIRQCR1_EISMPCLK0                (*((volatile unsigned int*)(0x42A20290UL)))
#define bM4_INTC_EIRQCR1_EISMPCLK1                (*((volatile unsigned int*)(0x42A20294UL)))
#define bM4_INTC_EIRQCR1_EFEN                     (*((volatile unsigned int*)(0x42A2029CUL)))
#define bM4_INTC_EIRQCR2_EIRQTRG0                 (*((volatile unsigned int*)(0x42A20300UL)))
#define bM4_INTC_EIRQCR2_EIRQTRG1                 (*((volatile unsigned int*)(0x42A20304UL)))
#define bM4_INTC_EIRQCR2_EISMPCLK0                (*((volatile unsigned int*)(0x42A20310UL)))
#define bM4_INTC_EIRQCR2_EISMPCLK1                (*((volatile unsigned int*)(0x42A20314UL)))
#define bM4_INTC_EIRQCR2_EFEN                     (*((volatile unsigned int*)(0x42A2031CUL)))
#define bM4_INTC_EIRQCR3_EIRQTRG0                 (*((volatile unsigned int*)(0x42A20380UL)))
#define bM4_INTC_EIRQCR3_EIRQTRG1                 (*((volatile unsigned int*)(0x42A20384UL)))
#define bM4_INTC_EIRQCR3_EISMPCLK0                (*((volatile unsigned int*)(0x42A20390UL)))
#define bM4_INTC_EIRQCR3_EISMPCLK1                (*((volatile unsigned int*)(0x42A20394UL)))
#define bM4_INTC_EIRQCR3_EFEN                     (*((volatile unsigned int*)(0x42A2039CUL)))
#define bM4_INTC_EIRQCR4_EIRQTRG0                 (*((volatile unsigned int*)(0x42A20400UL)))
#define bM4_INTC_EIRQCR4_EIRQTRG1                 (*((volatile unsigned int*)(0x42A20404UL)))
#define bM4_INTC_EIRQCR4_EISMPCLK0                (*((volatile unsigned int*)(0x42A20410UL)))
#define bM4_INTC_EIRQCR4_EISMPCLK1                (*((volatile unsigned int*)(0x42A20414UL)))
#define bM4_INTC_EIRQCR4_EFEN                     (*((volatile unsigned int*)(0x42A2041CUL)))
#define bM4_INTC_EIRQCR5_EIRQTRG0                 (*((volatile unsigned int*)(0x42A20480UL)))
#define bM4_INTC_EIRQCR5_EIRQTRG1                 (*((volatile unsigned int*)(0x42A20484UL)))
#define bM4_INTC_EIRQCR5_EISMPCLK0                (*((volatile unsigned int*)(0x42A20490UL)))
#define bM4_INTC_EIRQCR5_EISMPCLK1                (*((volatile unsigned int*)(0x42A20494UL)))
#define bM4_INTC_EIRQCR5_EFEN                     (*((volatile unsigned int*)(0x42A2049CUL)))
#define bM4_INTC_EIRQCR6_EIRQTRG0                 (*((volatile unsigned int*)(0x42A20500UL)))
#define bM4_INTC_EIRQCR6_EIRQTRG1                 (*((volatile unsigned int*)(0x42A20504UL)))
#define bM4_INTC_EIRQCR6_EISMPCLK0                (*((volatile unsigned int*)(0x42A20510UL)))
#define bM4_INTC_EIRQCR6_EISMPCLK1                (*((volatile unsigned int*)(0x42A20514UL)))
#define bM4_INTC_EIRQCR6_EFEN                     (*((volatile unsigned int*)(0x42A2051CUL)))
#define bM4_INTC_EIRQCR7_EIRQTRG0                 (*((volatile unsigned int*)(0x42A20580UL)))
#define bM4_INTC_EIRQCR7_EIRQTRG1                 (*((volatile unsigned int*)(0x42A20584UL)))
#define bM4_INTC_EIRQCR7_EISMPCLK0                (*((volatile unsigned int*)(0x42A20590UL)))
#define bM4_INTC_EIRQCR7_EISMPCLK1                (*((volatile unsigned int*)(0x42A20594UL)))
#define bM4_INTC_EIRQCR7_EFEN                     (*((volatile unsigned int*)(0x42A2059CUL)))
#define bM4_INTC_EIRQCR8_EIRQTRG0                 (*((volatile unsigned int*)(0x42A20600UL)))
#define bM4_INTC_EIRQCR8_EIRQTRG1                 (*((volatile unsigned int*)(0x42A20604UL)))
#define bM4_INTC_EIRQCR8_EISMPCLK0                (*((volatile unsigned int*)(0x42A20610UL)))
#define bM4_INTC_EIRQCR8_EISMPCLK1                (*((volatile unsigned int*)(0x42A20614UL)))
#define bM4_INTC_EIRQCR8_EFEN                     (*((volatile unsigned int*)(0x42A2061CUL)))
#define bM4_INTC_EIRQCR9_EIRQTRG0                 (*((volatile unsigned int*)(0x42A20680UL)))
#define bM4_INTC_EIRQCR9_EIRQTRG1                 (*((volatile unsigned int*)(0x42A20684UL)))
#define bM4_INTC_EIRQCR9_EISMPCLK0                (*((volatile unsigned int*)(0x42A20690UL)))
#define bM4_INTC_EIRQCR9_EISMPCLK1                (*((volatile unsigned int*)(0x42A20694UL)))
#define bM4_INTC_EIRQCR9_EFEN                     (*((volatile unsigned int*)(0x42A2069CUL)))
#define bM4_INTC_EIRQCR10_EIRQTRG0                (*((volatile unsigned int*)(0x42A20700UL)))
#define bM4_INTC_EIRQCR10_EIRQTRG1                (*((volatile unsigned int*)(0x42A20704UL)))
#define bM4_INTC_EIRQCR10_EISMPCLK0               (*((volatile unsigned int*)(0x42A20710UL)))
#define bM4_INTC_EIRQCR10_EISMPCLK1               (*((volatile unsigned int*)(0x42A20714UL)))
#define bM4_INTC_EIRQCR10_EFEN                    (*((volatile unsigned int*)(0x42A2071CUL)))
#define bM4_INTC_EIRQCR11_EIRQTRG0                (*((volatile unsigned int*)(0x42A20780UL)))
#define bM4_INTC_EIRQCR11_EIRQTRG1                (*((volatile unsigned int*)(0x42A20784UL)))
#define bM4_INTC_EIRQCR11_EISMPCLK0               (*((volatile unsigned int*)(0x42A20790UL)))
#define bM4_INTC_EIRQCR11_EISMPCLK1               (*((volatile unsigned int*)(0x42A20794UL)))
#define bM4_INTC_EIRQCR11_EFEN                    (*((volatile unsigned int*)(0x42A2079CUL)))
#define bM4_INTC_EIRQCR12_EIRQTRG0                (*((volatile unsigned int*)(0x42A20800UL)))
#define bM4_INTC_EIRQCR12_EIRQTRG1                (*((volatile unsigned int*)(0x42A20804UL)))
#define bM4_INTC_EIRQCR12_EISMPCLK0               (*((volatile unsigned int*)(0x42A20810UL)))
#define bM4_INTC_EIRQCR12_EISMPCLK1               (*((volatile unsigned int*)(0x42A20814UL)))
#define bM4_INTC_EIRQCR12_EFEN                    (*((volatile unsigned int*)(0x42A2081CUL)))
#define bM4_INTC_EIRQCR13_EIRQTRG0                (*((volatile unsigned int*)(0x42A20880UL)))
#define bM4_INTC_EIRQCR13_EIRQTRG1                (*((volatile unsigned int*)(0x42A20884UL)))
#define bM4_INTC_EIRQCR13_EISMPCLK0               (*((volatile unsigned int*)(0x42A20890UL)))
#define bM4_INTC_EIRQCR13_EISMPCLK1               (*((volatile unsigned int*)(0x42A20894UL)))
#define bM4_INTC_EIRQCR13_EFEN                    (*((volatile unsigned int*)(0x42A2089CUL)))
#define bM4_INTC_EIRQCR14_EIRQTRG0                (*((volatile unsigned int*)(0x42A20900UL)))
#define bM4_INTC_EIRQCR14_EIRQTRG1                (*((volatile unsigned int*)(0x42A20904UL)))
#define bM4_INTC_EIRQCR14_EISMPCLK0               (*((volatile unsigned int*)(0x42A20910UL)))
#define bM4_INTC_EIRQCR14_EISMPCLK1               (*((volatile unsigned int*)(0x42A20914UL)))
#define bM4_INTC_EIRQCR14_EFEN                    (*((volatile unsigned int*)(0x42A2091CUL)))
#define bM4_INTC_EIRQCR15_EIRQTRG0                (*((volatile unsigned int*)(0x42A20980UL)))
#define bM4_INTC_EIRQCR15_EIRQTRG1                (*((volatile unsigned int*)(0x42A20984UL)))
#define bM4_INTC_EIRQCR15_EISMPCLK0               (*((volatile unsigned int*)(0x42A20990UL)))
#define bM4_INTC_EIRQCR15_EISMPCLK1               (*((volatile unsigned int*)(0x42A20994UL)))
#define bM4_INTC_EIRQCR15_EFEN                    (*((volatile unsigned int*)(0x42A2099CUL)))
#define bM4_INTC_WUPEN_EIRQWUEN0                  (*((volatile unsigned int*)(0x42A20A00UL)))
#define bM4_INTC_WUPEN_EIRQWUEN1                  (*((volatile unsigned int*)(0x42A20A04UL)))
#define bM4_INTC_WUPEN_EIRQWUEN2                  (*((volatile unsigned int*)(0x42A20A08UL)))
#define bM4_INTC_WUPEN_EIRQWUEN3                  (*((volatile unsigned int*)(0x42A20A0CUL)))
#define bM4_INTC_WUPEN_EIRQWUEN4                  (*((volatile unsigned int*)(0x42A20A10UL)))
#define bM4_INTC_WUPEN_EIRQWUEN5                  (*((volatile unsigned int*)(0x42A20A14UL)))
#define bM4_INTC_WUPEN_EIRQWUEN6                  (*((volatile unsigned int*)(0x42A20A18UL)))
#define bM4_INTC_WUPEN_EIRQWUEN7                  (*((volatile unsigned int*)(0x42A20A1CUL)))
#define bM4_INTC_WUPEN_EIRQWUEN8                  (*((volatile unsigned int*)(0x42A20A20UL)))
#define bM4_INTC_WUPEN_EIRQWUEN9                  (*((volatile unsigned int*)(0x42A20A24UL)))
#define bM4_INTC_WUPEN_EIRQWUEN10                 (*((volatile unsigned int*)(0x42A20A28UL)))
#define bM4_INTC_WUPEN_EIRQWUEN11                 (*((volatile unsigned int*)(0x42A20A2CUL)))
#define bM4_INTC_WUPEN_EIRQWUEN12                 (*((volatile unsigned int*)(0x42A20A30UL)))
#define bM4_INTC_WUPEN_EIRQWUEN13                 (*((volatile unsigned int*)(0x42A20A34UL)))
#define bM4_INTC_WUPEN_EIRQWUEN14                 (*((volatile unsigned int*)(0x42A20A38UL)))
#define bM4_INTC_WUPEN_EIRQWUEN15                 (*((volatile unsigned int*)(0x42A20A3CUL)))
#define bM4_INTC_WUPEN_SWDTWUEN                   (*((volatile unsigned int*)(0x42A20A40UL)))
#define bM4_INTC_WUPEN_PVD1WUEN                   (*((volatile unsigned int*)(0x42A20A44UL)))
#define bM4_INTC_WUPEN_PVD2WUEN                   (*((volatile unsigned int*)(0x42A20A48UL)))
#define bM4_INTC_WUPEN_CMPI0WUEN                  (*((volatile unsigned int*)(0x42A20A4CUL)))
#define bM4_INTC_WUPEN_WKTMWUEN                   (*((volatile unsigned int*)(0x42A20A50UL)))
#define bM4_INTC_WUPEN_RTCALMWUEN                 (*((volatile unsigned int*)(0x42A20A54UL)))
#define bM4_INTC_WUPEN_RTCPRDWUEN                 (*((volatile unsigned int*)(0x42A20A58UL)))
#define bM4_INTC_WUPEN_TMR0WUEN                   (*((volatile unsigned int*)(0x42A20A5CUL)))
#define bM4_INTC_WUPEN_RXWUEN                     (*((volatile unsigned int*)(0x42A20A64UL)))
#define bM4_INTC_EIFR_EIFR0                       (*((volatile unsigned int*)(0x42A20A80UL)))
#define bM4_INTC_EIFR_EIFR1                       (*((volatile unsigned int*)(0x42A20A84UL)))
#define bM4_INTC_EIFR_EIFR2                       (*((volatile unsigned int*)(0x42A20A88UL)))
#define bM4_INTC_EIFR_EIFR3                       (*((volatile unsigned int*)(0x42A20A8CUL)))
#define bM4_INTC_EIFR_EIFR4                       (*((volatile unsigned int*)(0x42A20A90UL)))
#define bM4_INTC_EIFR_EIFR5                       (*((volatile unsigned int*)(0x42A20A94UL)))
#define bM4_INTC_EIFR_EIFR6                       (*((volatile unsigned int*)(0x42A20A98UL)))
#define bM4_INTC_EIFR_EIFR7                       (*((volatile unsigned int*)(0x42A20A9CUL)))
#define bM4_INTC_EIFR_EIFR8                       (*((volatile unsigned int*)(0x42A20AA0UL)))
#define bM4_INTC_EIFR_EIFR9                       (*((volatile unsigned int*)(0x42A20AA4UL)))
#define bM4_INTC_EIFR_EIFR10                      (*((volatile unsigned int*)(0x42A20AA8UL)))
#define bM4_INTC_EIFR_EIFR11                      (*((volatile unsigned int*)(0x42A20AACUL)))
#define bM4_INTC_EIFR_EIFR12                      (*((volatile unsigned int*)(0x42A20AB0UL)))
#define bM4_INTC_EIFR_EIFR13                      (*((volatile unsigned int*)(0x42A20AB4UL)))
#define bM4_INTC_EIFR_EIFR14                      (*((volatile unsigned int*)(0x42A20AB8UL)))
#define bM4_INTC_EIFR_EIFR15                      (*((volatile unsigned int*)(0x42A20ABCUL)))
#define bM4_INTC_EICFR_EICFR0                     (*((volatile unsigned int*)(0x42A20B00UL)))
#define bM4_INTC_EICFR_EICFR1                     (*((volatile unsigned int*)(0x42A20B04UL)))
#define bM4_INTC_EICFR_EICFR2                     (*((volatile unsigned int*)(0x42A20B08UL)))
#define bM4_INTC_EICFR_EICFR3                     (*((volatile unsigned int*)(0x42A20B0CUL)))
#define bM4_INTC_EICFR_EICFR4                     (*((volatile unsigned int*)(0x42A20B10UL)))
#define bM4_INTC_EICFR_EICFR5                     (*((volatile unsigned int*)(0x42A20B14UL)))
#define bM4_INTC_EICFR_EICFR6                     (*((volatile unsigned int*)(0x42A20B18UL)))
#define bM4_INTC_EICFR_EICFR7                     (*((volatile unsigned int*)(0x42A20B1CUL)))
#define bM4_INTC_EICFR_EICFR8                     (*((volatile unsigned int*)(0x42A20B20UL)))
#define bM4_INTC_EICFR_EICFR9                     (*((volatile unsigned int*)(0x42A20B24UL)))
#define bM4_INTC_EICFR_EICFR10                    (*((volatile unsigned int*)(0x42A20B28UL)))
#define bM4_INTC_EICFR_EICFR11                    (*((volatile unsigned int*)(0x42A20B2CUL)))
#define bM4_INTC_EICFR_EICFR12                    (*((volatile unsigned int*)(0x42A20B30UL)))
#define bM4_INTC_EICFR_EICFR13                    (*((volatile unsigned int*)(0x42A20B34UL)))
#define bM4_INTC_EICFR_EICFR14                    (*((volatile unsigned int*)(0x42A20B38UL)))
#define bM4_INTC_EICFR_EICFR15                    (*((volatile unsigned int*)(0x42A20B3CUL)))
#define bM4_INTC_SEL0_INTSEL0                     (*((volatile unsigned int*)(0x42A20B80UL)))
#define bM4_INTC_SEL0_INTSEL1                     (*((volatile unsigned int*)(0x42A20B84UL)))
#define bM4_INTC_SEL0_INTSEL2                     (*((volatile unsigned int*)(0x42A20B88UL)))
#define bM4_INTC_SEL0_INTSEL3                     (*((volatile unsigned int*)(0x42A20B8CUL)))
#define bM4_INTC_SEL0_INTSEL4                     (*((volatile unsigned int*)(0x42A20B90UL)))
#define bM4_INTC_SEL0_INTSEL5                     (*((volatile unsigned int*)(0x42A20B94UL)))
#define bM4_INTC_SEL0_INTSEL6                     (*((volatile unsigned int*)(0x42A20B98UL)))
#define bM4_INTC_SEL0_INTSEL7                     (*((volatile unsigned int*)(0x42A20B9CUL)))
#define bM4_INTC_SEL0_INTSEL8                     (*((volatile unsigned int*)(0x42A20BA0UL)))
#define bM4_INTC_SEL1_INTSEL0                     (*((volatile unsigned int*)(0x42A20C00UL)))
#define bM4_INTC_SEL1_INTSEL1                     (*((volatile unsigned int*)(0x42A20C04UL)))
#define bM4_INTC_SEL1_INTSEL2                     (*((volatile unsigned int*)(0x42A20C08UL)))
#define bM4_INTC_SEL1_INTSEL3                     (*((volatile unsigned int*)(0x42A20C0CUL)))
#define bM4_INTC_SEL1_INTSEL4                     (*((volatile unsigned int*)(0x42A20C10UL)))
#define bM4_INTC_SEL1_INTSEL5                     (*((volatile unsigned int*)(0x42A20C14UL)))
#define bM4_INTC_SEL1_INTSEL6                     (*((volatile unsigned int*)(0x42A20C18UL)))
#define bM4_INTC_SEL1_INTSEL7                     (*((volatile unsigned int*)(0x42A20C1CUL)))
#define bM4_INTC_SEL1_INTSEL8                     (*((volatile unsigned int*)(0x42A20C20UL)))
#define bM4_INTC_SEL2_INTSEL0                     (*((volatile unsigned int*)(0x42A20C80UL)))
#define bM4_INTC_SEL2_INTSEL1                     (*((volatile unsigned int*)(0x42A20C84UL)))
#define bM4_INTC_SEL2_INTSEL2                     (*((volatile unsigned int*)(0x42A20C88UL)))
#define bM4_INTC_SEL2_INTSEL3                     (*((volatile unsigned int*)(0x42A20C8CUL)))
#define bM4_INTC_SEL2_INTSEL4                     (*((volatile unsigned int*)(0x42A20C90UL)))
#define bM4_INTC_SEL2_INTSEL5                     (*((volatile unsigned int*)(0x42A20C94UL)))
#define bM4_INTC_SEL2_INTSEL6                     (*((volatile unsigned int*)(0x42A20C98UL)))
#define bM4_INTC_SEL2_INTSEL7                     (*((volatile unsigned int*)(0x42A20C9CUL)))
#define bM4_INTC_SEL2_INTSEL8                     (*((volatile unsigned int*)(0x42A20CA0UL)))
#define bM4_INTC_SEL3_INTSEL0                     (*((volatile unsigned int*)(0x42A20D00UL)))
#define bM4_INTC_SEL3_INTSEL1                     (*((volatile unsigned int*)(0x42A20D04UL)))
#define bM4_INTC_SEL3_INTSEL2                     (*((volatile unsigned int*)(0x42A20D08UL)))
#define bM4_INTC_SEL3_INTSEL3                     (*((volatile unsigned int*)(0x42A20D0CUL)))
#define bM4_INTC_SEL3_INTSEL4                     (*((volatile unsigned int*)(0x42A20D10UL)))
#define bM4_INTC_SEL3_INTSEL5                     (*((volatile unsigned int*)(0x42A20D14UL)))
#define bM4_INTC_SEL3_INTSEL6                     (*((volatile unsigned int*)(0x42A20D18UL)))
#define bM4_INTC_SEL3_INTSEL7                     (*((volatile unsigned int*)(0x42A20D1CUL)))
#define bM4_INTC_SEL3_INTSEL8                     (*((volatile unsigned int*)(0x42A20D20UL)))
#define bM4_INTC_SEL4_INTSEL0                     (*((volatile unsigned int*)(0x42A20D80UL)))
#define bM4_INTC_SEL4_INTSEL1                     (*((volatile unsigned int*)(0x42A20D84UL)))
#define bM4_INTC_SEL4_INTSEL2                     (*((volatile unsigned int*)(0x42A20D88UL)))
#define bM4_INTC_SEL4_INTSEL3                     (*((volatile unsigned int*)(0x42A20D8CUL)))
#define bM4_INTC_SEL4_INTSEL4                     (*((volatile unsigned int*)(0x42A20D90UL)))
#define bM4_INTC_SEL4_INTSEL5                     (*((volatile unsigned int*)(0x42A20D94UL)))
#define bM4_INTC_SEL4_INTSEL6                     (*((volatile unsigned int*)(0x42A20D98UL)))
#define bM4_INTC_SEL4_INTSEL7                     (*((volatile unsigned int*)(0x42A20D9CUL)))
#define bM4_INTC_SEL4_INTSEL8                     (*((volatile unsigned int*)(0x42A20DA0UL)))
#define bM4_INTC_SEL5_INTSEL0                     (*((volatile unsigned int*)(0x42A20E00UL)))
#define bM4_INTC_SEL5_INTSEL1                     (*((volatile unsigned int*)(0x42A20E04UL)))
#define bM4_INTC_SEL5_INTSEL2                     (*((volatile unsigned int*)(0x42A20E08UL)))
#define bM4_INTC_SEL5_INTSEL3                     (*((volatile unsigned int*)(0x42A20E0CUL)))
#define bM4_INTC_SEL5_INTSEL4                     (*((volatile unsigned int*)(0x42A20E10UL)))
#define bM4_INTC_SEL5_INTSEL5                     (*((volatile unsigned int*)(0x42A20E14UL)))
#define bM4_INTC_SEL5_INTSEL6                     (*((volatile unsigned int*)(0x42A20E18UL)))
#define bM4_INTC_SEL5_INTSEL7                     (*((volatile unsigned int*)(0x42A20E1CUL)))
#define bM4_INTC_SEL5_INTSEL8                     (*((volatile unsigned int*)(0x42A20E20UL)))
#define bM4_INTC_SEL6_INTSEL0                     (*((volatile unsigned int*)(0x42A20E80UL)))
#define bM4_INTC_SEL6_INTSEL1                     (*((volatile unsigned int*)(0x42A20E84UL)))
#define bM4_INTC_SEL6_INTSEL2                     (*((volatile unsigned int*)(0x42A20E88UL)))
#define bM4_INTC_SEL6_INTSEL3                     (*((volatile unsigned int*)(0x42A20E8CUL)))
#define bM4_INTC_SEL6_INTSEL4                     (*((volatile unsigned int*)(0x42A20E90UL)))
#define bM4_INTC_SEL6_INTSEL5                     (*((volatile unsigned int*)(0x42A20E94UL)))
#define bM4_INTC_SEL6_INTSEL6                     (*((volatile unsigned int*)(0x42A20E98UL)))
#define bM4_INTC_SEL6_INTSEL7                     (*((volatile unsigned int*)(0x42A20E9CUL)))
#define bM4_INTC_SEL6_INTSEL8                     (*((volatile unsigned int*)(0x42A20EA0UL)))
#define bM4_INTC_SEL7_INTSEL0                     (*((volatile unsigned int*)(0x42A20F00UL)))
#define bM4_INTC_SEL7_INTSEL1                     (*((volatile unsigned int*)(0x42A20F04UL)))
#define bM4_INTC_SEL7_INTSEL2                     (*((volatile unsigned int*)(0x42A20F08UL)))
#define bM4_INTC_SEL7_INTSEL3                     (*((volatile unsigned int*)(0x42A20F0CUL)))
#define bM4_INTC_SEL7_INTSEL4                     (*((volatile unsigned int*)(0x42A20F10UL)))
#define bM4_INTC_SEL7_INTSEL5                     (*((volatile unsigned int*)(0x42A20F14UL)))
#define bM4_INTC_SEL7_INTSEL6                     (*((volatile unsigned int*)(0x42A20F18UL)))
#define bM4_INTC_SEL7_INTSEL7                     (*((volatile unsigned int*)(0x42A20F1CUL)))
#define bM4_INTC_SEL7_INTSEL8                     (*((volatile unsigned int*)(0x42A20F20UL)))
#define bM4_INTC_SEL8_INTSEL0                     (*((volatile unsigned int*)(0x42A20F80UL)))
#define bM4_INTC_SEL8_INTSEL1                     (*((volatile unsigned int*)(0x42A20F84UL)))
#define bM4_INTC_SEL8_INTSEL2                     (*((volatile unsigned int*)(0x42A20F88UL)))
#define bM4_INTC_SEL8_INTSEL3                     (*((volatile unsigned int*)(0x42A20F8CUL)))
#define bM4_INTC_SEL8_INTSEL4                     (*((volatile unsigned int*)(0x42A20F90UL)))
#define bM4_INTC_SEL8_INTSEL5                     (*((volatile unsigned int*)(0x42A20F94UL)))
#define bM4_INTC_SEL8_INTSEL6                     (*((volatile unsigned int*)(0x42A20F98UL)))
#define bM4_INTC_SEL8_INTSEL7                     (*((volatile unsigned int*)(0x42A20F9CUL)))
#define bM4_INTC_SEL8_INTSEL8                     (*((volatile unsigned int*)(0x42A20FA0UL)))
#define bM4_INTC_SEL9_INTSEL0                     (*((volatile unsigned int*)(0x42A21000UL)))
#define bM4_INTC_SEL9_INTSEL1                     (*((volatile unsigned int*)(0x42A21004UL)))
#define bM4_INTC_SEL9_INTSEL2                     (*((volatile unsigned int*)(0x42A21008UL)))
#define bM4_INTC_SEL9_INTSEL3                     (*((volatile unsigned int*)(0x42A2100CUL)))
#define bM4_INTC_SEL9_INTSEL4                     (*((volatile unsigned int*)(0x42A21010UL)))
#define bM4_INTC_SEL9_INTSEL5                     (*((volatile unsigned int*)(0x42A21014UL)))
#define bM4_INTC_SEL9_INTSEL6                     (*((volatile unsigned int*)(0x42A21018UL)))
#define bM4_INTC_SEL9_INTSEL7                     (*((volatile unsigned int*)(0x42A2101CUL)))
#define bM4_INTC_SEL9_INTSEL8                     (*((volatile unsigned int*)(0x42A21020UL)))
#define bM4_INTC_SEL10_INTSEL0                    (*((volatile unsigned int*)(0x42A21080UL)))
#define bM4_INTC_SEL10_INTSEL1                    (*((volatile unsigned int*)(0x42A21084UL)))
#define bM4_INTC_SEL10_INTSEL2                    (*((volatile unsigned int*)(0x42A21088UL)))
#define bM4_INTC_SEL10_INTSEL3                    (*((volatile unsigned int*)(0x42A2108CUL)))
#define bM4_INTC_SEL10_INTSEL4                    (*((volatile unsigned int*)(0x42A21090UL)))
#define bM4_INTC_SEL10_INTSEL5                    (*((volatile unsigned int*)(0x42A21094UL)))
#define bM4_INTC_SEL10_INTSEL6                    (*((volatile unsigned int*)(0x42A21098UL)))
#define bM4_INTC_SEL10_INTSEL7                    (*((volatile unsigned int*)(0x42A2109CUL)))
#define bM4_INTC_SEL10_INTSEL8                    (*((volatile unsigned int*)(0x42A210A0UL)))
#define bM4_INTC_SEL11_INTSEL0                    (*((volatile unsigned int*)(0x42A21100UL)))
#define bM4_INTC_SEL11_INTSEL1                    (*((volatile unsigned int*)(0x42A21104UL)))
#define bM4_INTC_SEL11_INTSEL2                    (*((volatile unsigned int*)(0x42A21108UL)))
#define bM4_INTC_SEL11_INTSEL3                    (*((volatile unsigned int*)(0x42A2110CUL)))
#define bM4_INTC_SEL11_INTSEL4                    (*((volatile unsigned int*)(0x42A21110UL)))
#define bM4_INTC_SEL11_INTSEL5                    (*((volatile unsigned int*)(0x42A21114UL)))
#define bM4_INTC_SEL11_INTSEL6                    (*((volatile unsigned int*)(0x42A21118UL)))
#define bM4_INTC_SEL11_INTSEL7                    (*((volatile unsigned int*)(0x42A2111CUL)))
#define bM4_INTC_SEL11_INTSEL8                    (*((volatile unsigned int*)(0x42A21120UL)))
#define bM4_INTC_SEL12_INTSEL0                    (*((volatile unsigned int*)(0x42A21180UL)))
#define bM4_INTC_SEL12_INTSEL1                    (*((volatile unsigned int*)(0x42A21184UL)))
#define bM4_INTC_SEL12_INTSEL2                    (*((volatile unsigned int*)(0x42A21188UL)))
#define bM4_INTC_SEL12_INTSEL3                    (*((volatile unsigned int*)(0x42A2118CUL)))
#define bM4_INTC_SEL12_INTSEL4                    (*((volatile unsigned int*)(0x42A21190UL)))
#define bM4_INTC_SEL12_INTSEL5                    (*((volatile unsigned int*)(0x42A21194UL)))
#define bM4_INTC_SEL12_INTSEL6                    (*((volatile unsigned int*)(0x42A21198UL)))
#define bM4_INTC_SEL12_INTSEL7                    (*((volatile unsigned int*)(0x42A2119CUL)))
#define bM4_INTC_SEL12_INTSEL8                    (*((volatile unsigned int*)(0x42A211A0UL)))
#define bM4_INTC_SEL13_INTSEL0                    (*((volatile unsigned int*)(0x42A21200UL)))
#define bM4_INTC_SEL13_INTSEL1                    (*((volatile unsigned int*)(0x42A21204UL)))
#define bM4_INTC_SEL13_INTSEL2                    (*((volatile unsigned int*)(0x42A21208UL)))
#define bM4_INTC_SEL13_INTSEL3                    (*((volatile unsigned int*)(0x42A2120CUL)))
#define bM4_INTC_SEL13_INTSEL4                    (*((volatile unsigned int*)(0x42A21210UL)))
#define bM4_INTC_SEL13_INTSEL5                    (*((volatile unsigned int*)(0x42A21214UL)))
#define bM4_INTC_SEL13_INTSEL6                    (*((volatile unsigned int*)(0x42A21218UL)))
#define bM4_INTC_SEL13_INTSEL7                    (*((volatile unsigned int*)(0x42A2121CUL)))
#define bM4_INTC_SEL13_INTSEL8                    (*((volatile unsigned int*)(0x42A21220UL)))
#define bM4_INTC_SEL14_INTSEL0                    (*((volatile unsigned int*)(0x42A21280UL)))
#define bM4_INTC_SEL14_INTSEL1                    (*((volatile unsigned int*)(0x42A21284UL)))
#define bM4_INTC_SEL14_INTSEL2                    (*((volatile unsigned int*)(0x42A21288UL)))
#define bM4_INTC_SEL14_INTSEL3                    (*((volatile unsigned int*)(0x42A2128CUL)))
#define bM4_INTC_SEL14_INTSEL4                    (*((volatile unsigned int*)(0x42A21290UL)))
#define bM4_INTC_SEL14_INTSEL5                    (*((volatile unsigned int*)(0x42A21294UL)))
#define bM4_INTC_SEL14_INTSEL6                    (*((volatile unsigned int*)(0x42A21298UL)))
#define bM4_INTC_SEL14_INTSEL7                    (*((volatile unsigned int*)(0x42A2129CUL)))
#define bM4_INTC_SEL14_INTSEL8                    (*((volatile unsigned int*)(0x42A212A0UL)))
#define bM4_INTC_SEL15_INTSEL0                    (*((volatile unsigned int*)(0x42A21300UL)))
#define bM4_INTC_SEL15_INTSEL1                    (*((volatile unsigned int*)(0x42A21304UL)))
#define bM4_INTC_SEL15_INTSEL2                    (*((volatile unsigned int*)(0x42A21308UL)))
#define bM4_INTC_SEL15_INTSEL3                    (*((volatile unsigned int*)(0x42A2130CUL)))
#define bM4_INTC_SEL15_INTSEL4                    (*((volatile unsigned int*)(0x42A21310UL)))
#define bM4_INTC_SEL15_INTSEL5                    (*((volatile unsigned int*)(0x42A21314UL)))
#define bM4_INTC_SEL15_INTSEL6                    (*((volatile unsigned int*)(0x42A21318UL)))
#define bM4_INTC_SEL15_INTSEL7                    (*((volatile unsigned int*)(0x42A2131CUL)))
#define bM4_INTC_SEL15_INTSEL8                    (*((volatile unsigned int*)(0x42A21320UL)))
#define bM4_INTC_SEL16_INTSEL0                    (*((volatile unsigned int*)(0x42A21380UL)))
#define bM4_INTC_SEL16_INTSEL1                    (*((volatile unsigned int*)(0x42A21384UL)))
#define bM4_INTC_SEL16_INTSEL2                    (*((volatile unsigned int*)(0x42A21388UL)))
#define bM4_INTC_SEL16_INTSEL3                    (*((volatile unsigned int*)(0x42A2138CUL)))
#define bM4_INTC_SEL16_INTSEL4                    (*((volatile unsigned int*)(0x42A21390UL)))
#define bM4_INTC_SEL16_INTSEL5                    (*((volatile unsigned int*)(0x42A21394UL)))
#define bM4_INTC_SEL16_INTSEL6                    (*((volatile unsigned int*)(0x42A21398UL)))
#define bM4_INTC_SEL16_INTSEL7                    (*((volatile unsigned int*)(0x42A2139CUL)))
#define bM4_INTC_SEL16_INTSEL8                    (*((volatile unsigned int*)(0x42A213A0UL)))
#define bM4_INTC_SEL17_INTSEL0                    (*((volatile unsigned int*)(0x42A21400UL)))
#define bM4_INTC_SEL17_INTSEL1                    (*((volatile unsigned int*)(0x42A21404UL)))
#define bM4_INTC_SEL17_INTSEL2                    (*((volatile unsigned int*)(0x42A21408UL)))
#define bM4_INTC_SEL17_INTSEL3                    (*((volatile unsigned int*)(0x42A2140CUL)))
#define bM4_INTC_SEL17_INTSEL4                    (*((volatile unsigned int*)(0x42A21410UL)))
#define bM4_INTC_SEL17_INTSEL5                    (*((volatile unsigned int*)(0x42A21414UL)))
#define bM4_INTC_SEL17_INTSEL6                    (*((volatile unsigned int*)(0x42A21418UL)))
#define bM4_INTC_SEL17_INTSEL7                    (*((volatile unsigned int*)(0x42A2141CUL)))
#define bM4_INTC_SEL17_INTSEL8                    (*((volatile unsigned int*)(0x42A21420UL)))
#define bM4_INTC_SEL18_INTSEL0                    (*((volatile unsigned int*)(0x42A21480UL)))
#define bM4_INTC_SEL18_INTSEL1                    (*((volatile unsigned int*)(0x42A21484UL)))
#define bM4_INTC_SEL18_INTSEL2                    (*((volatile unsigned int*)(0x42A21488UL)))
#define bM4_INTC_SEL18_INTSEL3                    (*((volatile unsigned int*)(0x42A2148CUL)))
#define bM4_INTC_SEL18_INTSEL4                    (*((volatile unsigned int*)(0x42A21490UL)))
#define bM4_INTC_SEL18_INTSEL5                    (*((volatile unsigned int*)(0x42A21494UL)))
#define bM4_INTC_SEL18_INTSEL6                    (*((volatile unsigned int*)(0x42A21498UL)))
#define bM4_INTC_SEL18_INTSEL7                    (*((volatile unsigned int*)(0x42A2149CUL)))
#define bM4_INTC_SEL18_INTSEL8                    (*((volatile unsigned int*)(0x42A214A0UL)))
#define bM4_INTC_SEL19_INTSEL0                    (*((volatile unsigned int*)(0x42A21500UL)))
#define bM4_INTC_SEL19_INTSEL1                    (*((volatile unsigned int*)(0x42A21504UL)))
#define bM4_INTC_SEL19_INTSEL2                    (*((volatile unsigned int*)(0x42A21508UL)))
#define bM4_INTC_SEL19_INTSEL3                    (*((volatile unsigned int*)(0x42A2150CUL)))
#define bM4_INTC_SEL19_INTSEL4                    (*((volatile unsigned int*)(0x42A21510UL)))
#define bM4_INTC_SEL19_INTSEL5                    (*((volatile unsigned int*)(0x42A21514UL)))
#define bM4_INTC_SEL19_INTSEL6                    (*((volatile unsigned int*)(0x42A21518UL)))
#define bM4_INTC_SEL19_INTSEL7                    (*((volatile unsigned int*)(0x42A2151CUL)))
#define bM4_INTC_SEL19_INTSEL8                    (*((volatile unsigned int*)(0x42A21520UL)))
#define bM4_INTC_SEL20_INTSEL0                    (*((volatile unsigned int*)(0x42A21580UL)))
#define bM4_INTC_SEL20_INTSEL1                    (*((volatile unsigned int*)(0x42A21584UL)))
#define bM4_INTC_SEL20_INTSEL2                    (*((volatile unsigned int*)(0x42A21588UL)))
#define bM4_INTC_SEL20_INTSEL3                    (*((volatile unsigned int*)(0x42A2158CUL)))
#define bM4_INTC_SEL20_INTSEL4                    (*((volatile unsigned int*)(0x42A21590UL)))
#define bM4_INTC_SEL20_INTSEL5                    (*((volatile unsigned int*)(0x42A21594UL)))
#define bM4_INTC_SEL20_INTSEL6                    (*((volatile unsigned int*)(0x42A21598UL)))
#define bM4_INTC_SEL20_INTSEL7                    (*((volatile unsigned int*)(0x42A2159CUL)))
#define bM4_INTC_SEL20_INTSEL8                    (*((volatile unsigned int*)(0x42A215A0UL)))
#define bM4_INTC_SEL21_INTSEL0                    (*((volatile unsigned int*)(0x42A21600UL)))
#define bM4_INTC_SEL21_INTSEL1                    (*((volatile unsigned int*)(0x42A21604UL)))
#define bM4_INTC_SEL21_INTSEL2                    (*((volatile unsigned int*)(0x42A21608UL)))
#define bM4_INTC_SEL21_INTSEL3                    (*((volatile unsigned int*)(0x42A2160CUL)))
#define bM4_INTC_SEL21_INTSEL4                    (*((volatile unsigned int*)(0x42A21610UL)))
#define bM4_INTC_SEL21_INTSEL5                    (*((volatile unsigned int*)(0x42A21614UL)))
#define bM4_INTC_SEL21_INTSEL6                    (*((volatile unsigned int*)(0x42A21618UL)))
#define bM4_INTC_SEL21_INTSEL7                    (*((volatile unsigned int*)(0x42A2161CUL)))
#define bM4_INTC_SEL21_INTSEL8                    (*((volatile unsigned int*)(0x42A21620UL)))
#define bM4_INTC_SEL22_INTSEL0                    (*((volatile unsigned int*)(0x42A21680UL)))
#define bM4_INTC_SEL22_INTSEL1                    (*((volatile unsigned int*)(0x42A21684UL)))
#define bM4_INTC_SEL22_INTSEL2                    (*((volatile unsigned int*)(0x42A21688UL)))
#define bM4_INTC_SEL22_INTSEL3                    (*((volatile unsigned int*)(0x42A2168CUL)))
#define bM4_INTC_SEL22_INTSEL4                    (*((volatile unsigned int*)(0x42A21690UL)))
#define bM4_INTC_SEL22_INTSEL5                    (*((volatile unsigned int*)(0x42A21694UL)))
#define bM4_INTC_SEL22_INTSEL6                    (*((volatile unsigned int*)(0x42A21698UL)))
#define bM4_INTC_SEL22_INTSEL7                    (*((volatile unsigned int*)(0x42A2169CUL)))
#define bM4_INTC_SEL22_INTSEL8                    (*((volatile unsigned int*)(0x42A216A0UL)))
#define bM4_INTC_SEL23_INTSEL0                    (*((volatile unsigned int*)(0x42A21700UL)))
#define bM4_INTC_SEL23_INTSEL1                    (*((volatile unsigned int*)(0x42A21704UL)))
#define bM4_INTC_SEL23_INTSEL2                    (*((volatile unsigned int*)(0x42A21708UL)))
#define bM4_INTC_SEL23_INTSEL3                    (*((volatile unsigned int*)(0x42A2170CUL)))
#define bM4_INTC_SEL23_INTSEL4                    (*((volatile unsigned int*)(0x42A21710UL)))
#define bM4_INTC_SEL23_INTSEL5                    (*((volatile unsigned int*)(0x42A21714UL)))
#define bM4_INTC_SEL23_INTSEL6                    (*((volatile unsigned int*)(0x42A21718UL)))
#define bM4_INTC_SEL23_INTSEL7                    (*((volatile unsigned int*)(0x42A2171CUL)))
#define bM4_INTC_SEL23_INTSEL8                    (*((volatile unsigned int*)(0x42A21720UL)))
#define bM4_INTC_SEL24_INTSEL0                    (*((volatile unsigned int*)(0x42A21780UL)))
#define bM4_INTC_SEL24_INTSEL1                    (*((volatile unsigned int*)(0x42A21784UL)))
#define bM4_INTC_SEL24_INTSEL2                    (*((volatile unsigned int*)(0x42A21788UL)))
#define bM4_INTC_SEL24_INTSEL3                    (*((volatile unsigned int*)(0x42A2178CUL)))
#define bM4_INTC_SEL24_INTSEL4                    (*((volatile unsigned int*)(0x42A21790UL)))
#define bM4_INTC_SEL24_INTSEL5                    (*((volatile unsigned int*)(0x42A21794UL)))
#define bM4_INTC_SEL24_INTSEL6                    (*((volatile unsigned int*)(0x42A21798UL)))
#define bM4_INTC_SEL24_INTSEL7                    (*((volatile unsigned int*)(0x42A2179CUL)))
#define bM4_INTC_SEL24_INTSEL8                    (*((volatile unsigned int*)(0x42A217A0UL)))
#define bM4_INTC_SEL25_INTSEL0                    (*((volatile unsigned int*)(0x42A21800UL)))
#define bM4_INTC_SEL25_INTSEL1                    (*((volatile unsigned int*)(0x42A21804UL)))
#define bM4_INTC_SEL25_INTSEL2                    (*((volatile unsigned int*)(0x42A21808UL)))
#define bM4_INTC_SEL25_INTSEL3                    (*((volatile unsigned int*)(0x42A2180CUL)))
#define bM4_INTC_SEL25_INTSEL4                    (*((volatile unsigned int*)(0x42A21810UL)))
#define bM4_INTC_SEL25_INTSEL5                    (*((volatile unsigned int*)(0x42A21814UL)))
#define bM4_INTC_SEL25_INTSEL6                    (*((volatile unsigned int*)(0x42A21818UL)))
#define bM4_INTC_SEL25_INTSEL7                    (*((volatile unsigned int*)(0x42A2181CUL)))
#define bM4_INTC_SEL25_INTSEL8                    (*((volatile unsigned int*)(0x42A21820UL)))
#define bM4_INTC_SEL26_INTSEL0                    (*((volatile unsigned int*)(0x42A21880UL)))
#define bM4_INTC_SEL26_INTSEL1                    (*((volatile unsigned int*)(0x42A21884UL)))
#define bM4_INTC_SEL26_INTSEL2                    (*((volatile unsigned int*)(0x42A21888UL)))
#define bM4_INTC_SEL26_INTSEL3                    (*((volatile unsigned int*)(0x42A2188CUL)))
#define bM4_INTC_SEL26_INTSEL4                    (*((volatile unsigned int*)(0x42A21890UL)))
#define bM4_INTC_SEL26_INTSEL5                    (*((volatile unsigned int*)(0x42A21894UL)))
#define bM4_INTC_SEL26_INTSEL6                    (*((volatile unsigned int*)(0x42A21898UL)))
#define bM4_INTC_SEL26_INTSEL7                    (*((volatile unsigned int*)(0x42A2189CUL)))
#define bM4_INTC_SEL26_INTSEL8                    (*((volatile unsigned int*)(0x42A218A0UL)))
#define bM4_INTC_SEL27_INTSEL0                    (*((volatile unsigned int*)(0x42A21900UL)))
#define bM4_INTC_SEL27_INTSEL1                    (*((volatile unsigned int*)(0x42A21904UL)))
#define bM4_INTC_SEL27_INTSEL2                    (*((volatile unsigned int*)(0x42A21908UL)))
#define bM4_INTC_SEL27_INTSEL3                    (*((volatile unsigned int*)(0x42A2190CUL)))
#define bM4_INTC_SEL27_INTSEL4                    (*((volatile unsigned int*)(0x42A21910UL)))
#define bM4_INTC_SEL27_INTSEL5                    (*((volatile unsigned int*)(0x42A21914UL)))
#define bM4_INTC_SEL27_INTSEL6                    (*((volatile unsigned int*)(0x42A21918UL)))
#define bM4_INTC_SEL27_INTSEL7                    (*((volatile unsigned int*)(0x42A2191CUL)))
#define bM4_INTC_SEL27_INTSEL8                    (*((volatile unsigned int*)(0x42A21920UL)))
#define bM4_INTC_SEL28_INTSEL0                    (*((volatile unsigned int*)(0x42A21980UL)))
#define bM4_INTC_SEL28_INTSEL1                    (*((volatile unsigned int*)(0x42A21984UL)))
#define bM4_INTC_SEL28_INTSEL2                    (*((volatile unsigned int*)(0x42A21988UL)))
#define bM4_INTC_SEL28_INTSEL3                    (*((volatile unsigned int*)(0x42A2198CUL)))
#define bM4_INTC_SEL28_INTSEL4                    (*((volatile unsigned int*)(0x42A21990UL)))
#define bM4_INTC_SEL28_INTSEL5                    (*((volatile unsigned int*)(0x42A21994UL)))
#define bM4_INTC_SEL28_INTSEL6                    (*((volatile unsigned int*)(0x42A21998UL)))
#define bM4_INTC_SEL28_INTSEL7                    (*((volatile unsigned int*)(0x42A2199CUL)))
#define bM4_INTC_SEL28_INTSEL8                    (*((volatile unsigned int*)(0x42A219A0UL)))
#define bM4_INTC_SEL29_INTSEL0                    (*((volatile unsigned int*)(0x42A21A00UL)))
#define bM4_INTC_SEL29_INTSEL1                    (*((volatile unsigned int*)(0x42A21A04UL)))
#define bM4_INTC_SEL29_INTSEL2                    (*((volatile unsigned int*)(0x42A21A08UL)))
#define bM4_INTC_SEL29_INTSEL3                    (*((volatile unsigned int*)(0x42A21A0CUL)))
#define bM4_INTC_SEL29_INTSEL4                    (*((volatile unsigned int*)(0x42A21A10UL)))
#define bM4_INTC_SEL29_INTSEL5                    (*((volatile unsigned int*)(0x42A21A14UL)))
#define bM4_INTC_SEL29_INTSEL6                    (*((volatile unsigned int*)(0x42A21A18UL)))
#define bM4_INTC_SEL29_INTSEL7                    (*((volatile unsigned int*)(0x42A21A1CUL)))
#define bM4_INTC_SEL29_INTSEL8                    (*((volatile unsigned int*)(0x42A21A20UL)))
#define bM4_INTC_SEL30_INTSEL0                    (*((volatile unsigned int*)(0x42A21A80UL)))
#define bM4_INTC_SEL30_INTSEL1                    (*((volatile unsigned int*)(0x42A21A84UL)))
#define bM4_INTC_SEL30_INTSEL2                    (*((volatile unsigned int*)(0x42A21A88UL)))
#define bM4_INTC_SEL30_INTSEL3                    (*((volatile unsigned int*)(0x42A21A8CUL)))
#define bM4_INTC_SEL30_INTSEL4                    (*((volatile unsigned int*)(0x42A21A90UL)))
#define bM4_INTC_SEL30_INTSEL5                    (*((volatile unsigned int*)(0x42A21A94UL)))
#define bM4_INTC_SEL30_INTSEL6                    (*((volatile unsigned int*)(0x42A21A98UL)))
#define bM4_INTC_SEL30_INTSEL7                    (*((volatile unsigned int*)(0x42A21A9CUL)))
#define bM4_INTC_SEL30_INTSEL8                    (*((volatile unsigned int*)(0x42A21AA0UL)))
#define bM4_INTC_SEL31_INTSEL0                    (*((volatile unsigned int*)(0x42A21B00UL)))
#define bM4_INTC_SEL31_INTSEL1                    (*((volatile unsigned int*)(0x42A21B04UL)))
#define bM4_INTC_SEL31_INTSEL2                    (*((volatile unsigned int*)(0x42A21B08UL)))
#define bM4_INTC_SEL31_INTSEL3                    (*((volatile unsigned int*)(0x42A21B0CUL)))
#define bM4_INTC_SEL31_INTSEL4                    (*((volatile unsigned int*)(0x42A21B10UL)))
#define bM4_INTC_SEL31_INTSEL5                    (*((volatile unsigned int*)(0x42A21B14UL)))
#define bM4_INTC_SEL31_INTSEL6                    (*((volatile unsigned int*)(0x42A21B18UL)))
#define bM4_INTC_SEL31_INTSEL7                    (*((volatile unsigned int*)(0x42A21B1CUL)))
#define bM4_INTC_SEL31_INTSEL8                    (*((volatile unsigned int*)(0x42A21B20UL)))
#define bM4_INTC_SEL32_INTSEL0                    (*((volatile unsigned int*)(0x42A21B80UL)))
#define bM4_INTC_SEL32_INTSEL1                    (*((volatile unsigned int*)(0x42A21B84UL)))
#define bM4_INTC_SEL32_INTSEL2                    (*((volatile unsigned int*)(0x42A21B88UL)))
#define bM4_INTC_SEL32_INTSEL3                    (*((volatile unsigned int*)(0x42A21B8CUL)))
#define bM4_INTC_SEL32_INTSEL4                    (*((volatile unsigned int*)(0x42A21B90UL)))
#define bM4_INTC_SEL32_INTSEL5                    (*((volatile unsigned int*)(0x42A21B94UL)))
#define bM4_INTC_SEL32_INTSEL6                    (*((volatile unsigned int*)(0x42A21B98UL)))
#define bM4_INTC_SEL32_INTSEL7                    (*((volatile unsigned int*)(0x42A21B9CUL)))
#define bM4_INTC_SEL32_INTSEL8                    (*((volatile unsigned int*)(0x42A21BA0UL)))
#define bM4_INTC_SEL33_INTSEL0                    (*((volatile unsigned int*)(0x42A21C00UL)))
#define bM4_INTC_SEL33_INTSEL1                    (*((volatile unsigned int*)(0x42A21C04UL)))
#define bM4_INTC_SEL33_INTSEL2                    (*((volatile unsigned int*)(0x42A21C08UL)))
#define bM4_INTC_SEL33_INTSEL3                    (*((volatile unsigned int*)(0x42A21C0CUL)))
#define bM4_INTC_SEL33_INTSEL4                    (*((volatile unsigned int*)(0x42A21C10UL)))
#define bM4_INTC_SEL33_INTSEL5                    (*((volatile unsigned int*)(0x42A21C14UL)))
#define bM4_INTC_SEL33_INTSEL6                    (*((volatile unsigned int*)(0x42A21C18UL)))
#define bM4_INTC_SEL33_INTSEL7                    (*((volatile unsigned int*)(0x42A21C1CUL)))
#define bM4_INTC_SEL33_INTSEL8                    (*((volatile unsigned int*)(0x42A21C20UL)))
#define bM4_INTC_SEL34_INTSEL0                    (*((volatile unsigned int*)(0x42A21C80UL)))
#define bM4_INTC_SEL34_INTSEL1                    (*((volatile unsigned int*)(0x42A21C84UL)))
#define bM4_INTC_SEL34_INTSEL2                    (*((volatile unsigned int*)(0x42A21C88UL)))
#define bM4_INTC_SEL34_INTSEL3                    (*((volatile unsigned int*)(0x42A21C8CUL)))
#define bM4_INTC_SEL34_INTSEL4                    (*((volatile unsigned int*)(0x42A21C90UL)))
#define bM4_INTC_SEL34_INTSEL5                    (*((volatile unsigned int*)(0x42A21C94UL)))
#define bM4_INTC_SEL34_INTSEL6                    (*((volatile unsigned int*)(0x42A21C98UL)))
#define bM4_INTC_SEL34_INTSEL7                    (*((volatile unsigned int*)(0x42A21C9CUL)))
#define bM4_INTC_SEL34_INTSEL8                    (*((volatile unsigned int*)(0x42A21CA0UL)))
#define bM4_INTC_SEL35_INTSEL0                    (*((volatile unsigned int*)(0x42A21D00UL)))
#define bM4_INTC_SEL35_INTSEL1                    (*((volatile unsigned int*)(0x42A21D04UL)))
#define bM4_INTC_SEL35_INTSEL2                    (*((volatile unsigned int*)(0x42A21D08UL)))
#define bM4_INTC_SEL35_INTSEL3                    (*((volatile unsigned int*)(0x42A21D0CUL)))
#define bM4_INTC_SEL35_INTSEL4                    (*((volatile unsigned int*)(0x42A21D10UL)))
#define bM4_INTC_SEL35_INTSEL5                    (*((volatile unsigned int*)(0x42A21D14UL)))
#define bM4_INTC_SEL35_INTSEL6                    (*((volatile unsigned int*)(0x42A21D18UL)))
#define bM4_INTC_SEL35_INTSEL7                    (*((volatile unsigned int*)(0x42A21D1CUL)))
#define bM4_INTC_SEL35_INTSEL8                    (*((volatile unsigned int*)(0x42A21D20UL)))
#define bM4_INTC_SEL36_INTSEL0                    (*((volatile unsigned int*)(0x42A21D80UL)))
#define bM4_INTC_SEL36_INTSEL1                    (*((volatile unsigned int*)(0x42A21D84UL)))
#define bM4_INTC_SEL36_INTSEL2                    (*((volatile unsigned int*)(0x42A21D88UL)))
#define bM4_INTC_SEL36_INTSEL3                    (*((volatile unsigned int*)(0x42A21D8CUL)))
#define bM4_INTC_SEL36_INTSEL4                    (*((volatile unsigned int*)(0x42A21D90UL)))
#define bM4_INTC_SEL36_INTSEL5                    (*((volatile unsigned int*)(0x42A21D94UL)))
#define bM4_INTC_SEL36_INTSEL6                    (*((volatile unsigned int*)(0x42A21D98UL)))
#define bM4_INTC_SEL36_INTSEL7                    (*((volatile unsigned int*)(0x42A21D9CUL)))
#define bM4_INTC_SEL36_INTSEL8                    (*((volatile unsigned int*)(0x42A21DA0UL)))
#define bM4_INTC_SEL37_INTSEL0                    (*((volatile unsigned int*)(0x42A21E00UL)))
#define bM4_INTC_SEL37_INTSEL1                    (*((volatile unsigned int*)(0x42A21E04UL)))
#define bM4_INTC_SEL37_INTSEL2                    (*((volatile unsigned int*)(0x42A21E08UL)))
#define bM4_INTC_SEL37_INTSEL3                    (*((volatile unsigned int*)(0x42A21E0CUL)))
#define bM4_INTC_SEL37_INTSEL4                    (*((volatile unsigned int*)(0x42A21E10UL)))
#define bM4_INTC_SEL37_INTSEL5                    (*((volatile unsigned int*)(0x42A21E14UL)))
#define bM4_INTC_SEL37_INTSEL6                    (*((volatile unsigned int*)(0x42A21E18UL)))
#define bM4_INTC_SEL37_INTSEL7                    (*((volatile unsigned int*)(0x42A21E1CUL)))
#define bM4_INTC_SEL37_INTSEL8                    (*((volatile unsigned int*)(0x42A21E20UL)))
#define bM4_INTC_SEL38_INTSEL0                    (*((volatile unsigned int*)(0x42A21E80UL)))
#define bM4_INTC_SEL38_INTSEL1                    (*((volatile unsigned int*)(0x42A21E84UL)))
#define bM4_INTC_SEL38_INTSEL2                    (*((volatile unsigned int*)(0x42A21E88UL)))
#define bM4_INTC_SEL38_INTSEL3                    (*((volatile unsigned int*)(0x42A21E8CUL)))
#define bM4_INTC_SEL38_INTSEL4                    (*((volatile unsigned int*)(0x42A21E90UL)))
#define bM4_INTC_SEL38_INTSEL5                    (*((volatile unsigned int*)(0x42A21E94UL)))
#define bM4_INTC_SEL38_INTSEL6                    (*((volatile unsigned int*)(0x42A21E98UL)))
#define bM4_INTC_SEL38_INTSEL7                    (*((volatile unsigned int*)(0x42A21E9CUL)))
#define bM4_INTC_SEL38_INTSEL8                    (*((volatile unsigned int*)(0x42A21EA0UL)))
#define bM4_INTC_SEL39_INTSEL0                    (*((volatile unsigned int*)(0x42A21F00UL)))
#define bM4_INTC_SEL39_INTSEL1                    (*((volatile unsigned int*)(0x42A21F04UL)))
#define bM4_INTC_SEL39_INTSEL2                    (*((volatile unsigned int*)(0x42A21F08UL)))
#define bM4_INTC_SEL39_INTSEL3                    (*((volatile unsigned int*)(0x42A21F0CUL)))
#define bM4_INTC_SEL39_INTSEL4                    (*((volatile unsigned int*)(0x42A21F10UL)))
#define bM4_INTC_SEL39_INTSEL5                    (*((volatile unsigned int*)(0x42A21F14UL)))
#define bM4_INTC_SEL39_INTSEL6                    (*((volatile unsigned int*)(0x42A21F18UL)))
#define bM4_INTC_SEL39_INTSEL7                    (*((volatile unsigned int*)(0x42A21F1CUL)))
#define bM4_INTC_SEL39_INTSEL8                    (*((volatile unsigned int*)(0x42A21F20UL)))
#define bM4_INTC_SEL40_INTSEL0                    (*((volatile unsigned int*)(0x42A21F80UL)))
#define bM4_INTC_SEL40_INTSEL1                    (*((volatile unsigned int*)(0x42A21F84UL)))
#define bM4_INTC_SEL40_INTSEL2                    (*((volatile unsigned int*)(0x42A21F88UL)))
#define bM4_INTC_SEL40_INTSEL3                    (*((volatile unsigned int*)(0x42A21F8CUL)))
#define bM4_INTC_SEL40_INTSEL4                    (*((volatile unsigned int*)(0x42A21F90UL)))
#define bM4_INTC_SEL40_INTSEL5                    (*((volatile unsigned int*)(0x42A21F94UL)))
#define bM4_INTC_SEL40_INTSEL6                    (*((volatile unsigned int*)(0x42A21F98UL)))
#define bM4_INTC_SEL40_INTSEL7                    (*((volatile unsigned int*)(0x42A21F9CUL)))
#define bM4_INTC_SEL40_INTSEL8                    (*((volatile unsigned int*)(0x42A21FA0UL)))
#define bM4_INTC_SEL41_INTSEL0                    (*((volatile unsigned int*)(0x42A22000UL)))
#define bM4_INTC_SEL41_INTSEL1                    (*((volatile unsigned int*)(0x42A22004UL)))
#define bM4_INTC_SEL41_INTSEL2                    (*((volatile unsigned int*)(0x42A22008UL)))
#define bM4_INTC_SEL41_INTSEL3                    (*((volatile unsigned int*)(0x42A2200CUL)))
#define bM4_INTC_SEL41_INTSEL4                    (*((volatile unsigned int*)(0x42A22010UL)))
#define bM4_INTC_SEL41_INTSEL5                    (*((volatile unsigned int*)(0x42A22014UL)))
#define bM4_INTC_SEL41_INTSEL6                    (*((volatile unsigned int*)(0x42A22018UL)))
#define bM4_INTC_SEL41_INTSEL7                    (*((volatile unsigned int*)(0x42A2201CUL)))
#define bM4_INTC_SEL41_INTSEL8                    (*((volatile unsigned int*)(0x42A22020UL)))
#define bM4_INTC_SEL42_INTSEL0                    (*((volatile unsigned int*)(0x42A22080UL)))
#define bM4_INTC_SEL42_INTSEL1                    (*((volatile unsigned int*)(0x42A22084UL)))
#define bM4_INTC_SEL42_INTSEL2                    (*((volatile unsigned int*)(0x42A22088UL)))
#define bM4_INTC_SEL42_INTSEL3                    (*((volatile unsigned int*)(0x42A2208CUL)))
#define bM4_INTC_SEL42_INTSEL4                    (*((volatile unsigned int*)(0x42A22090UL)))
#define bM4_INTC_SEL42_INTSEL5                    (*((volatile unsigned int*)(0x42A22094UL)))
#define bM4_INTC_SEL42_INTSEL6                    (*((volatile unsigned int*)(0x42A22098UL)))
#define bM4_INTC_SEL42_INTSEL7                    (*((volatile unsigned int*)(0x42A2209CUL)))
#define bM4_INTC_SEL42_INTSEL8                    (*((volatile unsigned int*)(0x42A220A0UL)))
#define bM4_INTC_SEL43_INTSEL0                    (*((volatile unsigned int*)(0x42A22100UL)))
#define bM4_INTC_SEL43_INTSEL1                    (*((volatile unsigned int*)(0x42A22104UL)))
#define bM4_INTC_SEL43_INTSEL2                    (*((volatile unsigned int*)(0x42A22108UL)))
#define bM4_INTC_SEL43_INTSEL3                    (*((volatile unsigned int*)(0x42A2210CUL)))
#define bM4_INTC_SEL43_INTSEL4                    (*((volatile unsigned int*)(0x42A22110UL)))
#define bM4_INTC_SEL43_INTSEL5                    (*((volatile unsigned int*)(0x42A22114UL)))
#define bM4_INTC_SEL43_INTSEL6                    (*((volatile unsigned int*)(0x42A22118UL)))
#define bM4_INTC_SEL43_INTSEL7                    (*((volatile unsigned int*)(0x42A2211CUL)))
#define bM4_INTC_SEL43_INTSEL8                    (*((volatile unsigned int*)(0x42A22120UL)))
#define bM4_INTC_SEL44_INTSEL0                    (*((volatile unsigned int*)(0x42A22180UL)))
#define bM4_INTC_SEL44_INTSEL1                    (*((volatile unsigned int*)(0x42A22184UL)))
#define bM4_INTC_SEL44_INTSEL2                    (*((volatile unsigned int*)(0x42A22188UL)))
#define bM4_INTC_SEL44_INTSEL3                    (*((volatile unsigned int*)(0x42A2218CUL)))
#define bM4_INTC_SEL44_INTSEL4                    (*((volatile unsigned int*)(0x42A22190UL)))
#define bM4_INTC_SEL44_INTSEL5                    (*((volatile unsigned int*)(0x42A22194UL)))
#define bM4_INTC_SEL44_INTSEL6                    (*((volatile unsigned int*)(0x42A22198UL)))
#define bM4_INTC_SEL44_INTSEL7                    (*((volatile unsigned int*)(0x42A2219CUL)))
#define bM4_INTC_SEL44_INTSEL8                    (*((volatile unsigned int*)(0x42A221A0UL)))
#define bM4_INTC_SEL45_INTSEL0                    (*((volatile unsigned int*)(0x42A22200UL)))
#define bM4_INTC_SEL45_INTSEL1                    (*((volatile unsigned int*)(0x42A22204UL)))
#define bM4_INTC_SEL45_INTSEL2                    (*((volatile unsigned int*)(0x42A22208UL)))
#define bM4_INTC_SEL45_INTSEL3                    (*((volatile unsigned int*)(0x42A2220CUL)))
#define bM4_INTC_SEL45_INTSEL4                    (*((volatile unsigned int*)(0x42A22210UL)))
#define bM4_INTC_SEL45_INTSEL5                    (*((volatile unsigned int*)(0x42A22214UL)))
#define bM4_INTC_SEL45_INTSEL6                    (*((volatile unsigned int*)(0x42A22218UL)))
#define bM4_INTC_SEL45_INTSEL7                    (*((volatile unsigned int*)(0x42A2221CUL)))
#define bM4_INTC_SEL45_INTSEL8                    (*((volatile unsigned int*)(0x42A22220UL)))
#define bM4_INTC_SEL46_INTSEL0                    (*((volatile unsigned int*)(0x42A22280UL)))
#define bM4_INTC_SEL46_INTSEL1                    (*((volatile unsigned int*)(0x42A22284UL)))
#define bM4_INTC_SEL46_INTSEL2                    (*((volatile unsigned int*)(0x42A22288UL)))
#define bM4_INTC_SEL46_INTSEL3                    (*((volatile unsigned int*)(0x42A2228CUL)))
#define bM4_INTC_SEL46_INTSEL4                    (*((volatile unsigned int*)(0x42A22290UL)))
#define bM4_INTC_SEL46_INTSEL5                    (*((volatile unsigned int*)(0x42A22294UL)))
#define bM4_INTC_SEL46_INTSEL6                    (*((volatile unsigned int*)(0x42A22298UL)))
#define bM4_INTC_SEL46_INTSEL7                    (*((volatile unsigned int*)(0x42A2229CUL)))
#define bM4_INTC_SEL46_INTSEL8                    (*((volatile unsigned int*)(0x42A222A0UL)))
#define bM4_INTC_SEL47_INTSEL0                    (*((volatile unsigned int*)(0x42A22300UL)))
#define bM4_INTC_SEL47_INTSEL1                    (*((volatile unsigned int*)(0x42A22304UL)))
#define bM4_INTC_SEL47_INTSEL2                    (*((volatile unsigned int*)(0x42A22308UL)))
#define bM4_INTC_SEL47_INTSEL3                    (*((volatile unsigned int*)(0x42A2230CUL)))
#define bM4_INTC_SEL47_INTSEL4                    (*((volatile unsigned int*)(0x42A22310UL)))
#define bM4_INTC_SEL47_INTSEL5                    (*((volatile unsigned int*)(0x42A22314UL)))
#define bM4_INTC_SEL47_INTSEL6                    (*((volatile unsigned int*)(0x42A22318UL)))
#define bM4_INTC_SEL47_INTSEL7                    (*((volatile unsigned int*)(0x42A2231CUL)))
#define bM4_INTC_SEL47_INTSEL8                    (*((volatile unsigned int*)(0x42A22320UL)))
#define bM4_INTC_SEL48_INTSEL0                    (*((volatile unsigned int*)(0x42A22380UL)))
#define bM4_INTC_SEL48_INTSEL1                    (*((volatile unsigned int*)(0x42A22384UL)))
#define bM4_INTC_SEL48_INTSEL2                    (*((volatile unsigned int*)(0x42A22388UL)))
#define bM4_INTC_SEL48_INTSEL3                    (*((volatile unsigned int*)(0x42A2238CUL)))
#define bM4_INTC_SEL48_INTSEL4                    (*((volatile unsigned int*)(0x42A22390UL)))
#define bM4_INTC_SEL48_INTSEL5                    (*((volatile unsigned int*)(0x42A22394UL)))
#define bM4_INTC_SEL48_INTSEL6                    (*((volatile unsigned int*)(0x42A22398UL)))
#define bM4_INTC_SEL48_INTSEL7                    (*((volatile unsigned int*)(0x42A2239CUL)))
#define bM4_INTC_SEL48_INTSEL8                    (*((volatile unsigned int*)(0x42A223A0UL)))
#define bM4_INTC_SEL49_INTSEL0                    (*((volatile unsigned int*)(0x42A22400UL)))
#define bM4_INTC_SEL49_INTSEL1                    (*((volatile unsigned int*)(0x42A22404UL)))
#define bM4_INTC_SEL49_INTSEL2                    (*((volatile unsigned int*)(0x42A22408UL)))
#define bM4_INTC_SEL49_INTSEL3                    (*((volatile unsigned int*)(0x42A2240CUL)))
#define bM4_INTC_SEL49_INTSEL4                    (*((volatile unsigned int*)(0x42A22410UL)))
#define bM4_INTC_SEL49_INTSEL5                    (*((volatile unsigned int*)(0x42A22414UL)))
#define bM4_INTC_SEL49_INTSEL6                    (*((volatile unsigned int*)(0x42A22418UL)))
#define bM4_INTC_SEL49_INTSEL7                    (*((volatile unsigned int*)(0x42A2241CUL)))
#define bM4_INTC_SEL49_INTSEL8                    (*((volatile unsigned int*)(0x42A22420UL)))
#define bM4_INTC_SEL50_INTSEL0                    (*((volatile unsigned int*)(0x42A22480UL)))
#define bM4_INTC_SEL50_INTSEL1                    (*((volatile unsigned int*)(0x42A22484UL)))
#define bM4_INTC_SEL50_INTSEL2                    (*((volatile unsigned int*)(0x42A22488UL)))
#define bM4_INTC_SEL50_INTSEL3                    (*((volatile unsigned int*)(0x42A2248CUL)))
#define bM4_INTC_SEL50_INTSEL4                    (*((volatile unsigned int*)(0x42A22490UL)))
#define bM4_INTC_SEL50_INTSEL5                    (*((volatile unsigned int*)(0x42A22494UL)))
#define bM4_INTC_SEL50_INTSEL6                    (*((volatile unsigned int*)(0x42A22498UL)))
#define bM4_INTC_SEL50_INTSEL7                    (*((volatile unsigned int*)(0x42A2249CUL)))
#define bM4_INTC_SEL50_INTSEL8                    (*((volatile unsigned int*)(0x42A224A0UL)))
#define bM4_INTC_SEL51_INTSEL0                    (*((volatile unsigned int*)(0x42A22500UL)))
#define bM4_INTC_SEL51_INTSEL1                    (*((volatile unsigned int*)(0x42A22504UL)))
#define bM4_INTC_SEL51_INTSEL2                    (*((volatile unsigned int*)(0x42A22508UL)))
#define bM4_INTC_SEL51_INTSEL3                    (*((volatile unsigned int*)(0x42A2250CUL)))
#define bM4_INTC_SEL51_INTSEL4                    (*((volatile unsigned int*)(0x42A22510UL)))
#define bM4_INTC_SEL51_INTSEL5                    (*((volatile unsigned int*)(0x42A22514UL)))
#define bM4_INTC_SEL51_INTSEL6                    (*((volatile unsigned int*)(0x42A22518UL)))
#define bM4_INTC_SEL51_INTSEL7                    (*((volatile unsigned int*)(0x42A2251CUL)))
#define bM4_INTC_SEL51_INTSEL8                    (*((volatile unsigned int*)(0x42A22520UL)))
#define bM4_INTC_SEL52_INTSEL0                    (*((volatile unsigned int*)(0x42A22580UL)))
#define bM4_INTC_SEL52_INTSEL1                    (*((volatile unsigned int*)(0x42A22584UL)))
#define bM4_INTC_SEL52_INTSEL2                    (*((volatile unsigned int*)(0x42A22588UL)))
#define bM4_INTC_SEL52_INTSEL3                    (*((volatile unsigned int*)(0x42A2258CUL)))
#define bM4_INTC_SEL52_INTSEL4                    (*((volatile unsigned int*)(0x42A22590UL)))
#define bM4_INTC_SEL52_INTSEL5                    (*((volatile unsigned int*)(0x42A22594UL)))
#define bM4_INTC_SEL52_INTSEL6                    (*((volatile unsigned int*)(0x42A22598UL)))
#define bM4_INTC_SEL52_INTSEL7                    (*((volatile unsigned int*)(0x42A2259CUL)))
#define bM4_INTC_SEL52_INTSEL8                    (*((volatile unsigned int*)(0x42A225A0UL)))
#define bM4_INTC_SEL53_INTSEL0                    (*((volatile unsigned int*)(0x42A22600UL)))
#define bM4_INTC_SEL53_INTSEL1                    (*((volatile unsigned int*)(0x42A22604UL)))
#define bM4_INTC_SEL53_INTSEL2                    (*((volatile unsigned int*)(0x42A22608UL)))
#define bM4_INTC_SEL53_INTSEL3                    (*((volatile unsigned int*)(0x42A2260CUL)))
#define bM4_INTC_SEL53_INTSEL4                    (*((volatile unsigned int*)(0x42A22610UL)))
#define bM4_INTC_SEL53_INTSEL5                    (*((volatile unsigned int*)(0x42A22614UL)))
#define bM4_INTC_SEL53_INTSEL6                    (*((volatile unsigned int*)(0x42A22618UL)))
#define bM4_INTC_SEL53_INTSEL7                    (*((volatile unsigned int*)(0x42A2261CUL)))
#define bM4_INTC_SEL53_INTSEL8                    (*((volatile unsigned int*)(0x42A22620UL)))
#define bM4_INTC_SEL54_INTSEL0                    (*((volatile unsigned int*)(0x42A22680UL)))
#define bM4_INTC_SEL54_INTSEL1                    (*((volatile unsigned int*)(0x42A22684UL)))
#define bM4_INTC_SEL54_INTSEL2                    (*((volatile unsigned int*)(0x42A22688UL)))
#define bM4_INTC_SEL54_INTSEL3                    (*((volatile unsigned int*)(0x42A2268CUL)))
#define bM4_INTC_SEL54_INTSEL4                    (*((volatile unsigned int*)(0x42A22690UL)))
#define bM4_INTC_SEL54_INTSEL5                    (*((volatile unsigned int*)(0x42A22694UL)))
#define bM4_INTC_SEL54_INTSEL6                    (*((volatile unsigned int*)(0x42A22698UL)))
#define bM4_INTC_SEL54_INTSEL7                    (*((volatile unsigned int*)(0x42A2269CUL)))
#define bM4_INTC_SEL54_INTSEL8                    (*((volatile unsigned int*)(0x42A226A0UL)))
#define bM4_INTC_SEL55_INTSEL0                    (*((volatile unsigned int*)(0x42A22700UL)))
#define bM4_INTC_SEL55_INTSEL1                    (*((volatile unsigned int*)(0x42A22704UL)))
#define bM4_INTC_SEL55_INTSEL2                    (*((volatile unsigned int*)(0x42A22708UL)))
#define bM4_INTC_SEL55_INTSEL3                    (*((volatile unsigned int*)(0x42A2270CUL)))
#define bM4_INTC_SEL55_INTSEL4                    (*((volatile unsigned int*)(0x42A22710UL)))
#define bM4_INTC_SEL55_INTSEL5                    (*((volatile unsigned int*)(0x42A22714UL)))
#define bM4_INTC_SEL55_INTSEL6                    (*((volatile unsigned int*)(0x42A22718UL)))
#define bM4_INTC_SEL55_INTSEL7                    (*((volatile unsigned int*)(0x42A2271CUL)))
#define bM4_INTC_SEL55_INTSEL8                    (*((volatile unsigned int*)(0x42A22720UL)))
#define bM4_INTC_SEL56_INTSEL0                    (*((volatile unsigned int*)(0x42A22780UL)))
#define bM4_INTC_SEL56_INTSEL1                    (*((volatile unsigned int*)(0x42A22784UL)))
#define bM4_INTC_SEL56_INTSEL2                    (*((volatile unsigned int*)(0x42A22788UL)))
#define bM4_INTC_SEL56_INTSEL3                    (*((volatile unsigned int*)(0x42A2278CUL)))
#define bM4_INTC_SEL56_INTSEL4                    (*((volatile unsigned int*)(0x42A22790UL)))
#define bM4_INTC_SEL56_INTSEL5                    (*((volatile unsigned int*)(0x42A22794UL)))
#define bM4_INTC_SEL56_INTSEL6                    (*((volatile unsigned int*)(0x42A22798UL)))
#define bM4_INTC_SEL56_INTSEL7                    (*((volatile unsigned int*)(0x42A2279CUL)))
#define bM4_INTC_SEL56_INTSEL8                    (*((volatile unsigned int*)(0x42A227A0UL)))
#define bM4_INTC_SEL57_INTSEL0                    (*((volatile unsigned int*)(0x42A22800UL)))
#define bM4_INTC_SEL57_INTSEL1                    (*((volatile unsigned int*)(0x42A22804UL)))
#define bM4_INTC_SEL57_INTSEL2                    (*((volatile unsigned int*)(0x42A22808UL)))
#define bM4_INTC_SEL57_INTSEL3                    (*((volatile unsigned int*)(0x42A2280CUL)))
#define bM4_INTC_SEL57_INTSEL4                    (*((volatile unsigned int*)(0x42A22810UL)))
#define bM4_INTC_SEL57_INTSEL5                    (*((volatile unsigned int*)(0x42A22814UL)))
#define bM4_INTC_SEL57_INTSEL6                    (*((volatile unsigned int*)(0x42A22818UL)))
#define bM4_INTC_SEL57_INTSEL7                    (*((volatile unsigned int*)(0x42A2281CUL)))
#define bM4_INTC_SEL57_INTSEL8                    (*((volatile unsigned int*)(0x42A22820UL)))
#define bM4_INTC_SEL58_INTSEL0                    (*((volatile unsigned int*)(0x42A22880UL)))
#define bM4_INTC_SEL58_INTSEL1                    (*((volatile unsigned int*)(0x42A22884UL)))
#define bM4_INTC_SEL58_INTSEL2                    (*((volatile unsigned int*)(0x42A22888UL)))
#define bM4_INTC_SEL58_INTSEL3                    (*((volatile unsigned int*)(0x42A2288CUL)))
#define bM4_INTC_SEL58_INTSEL4                    (*((volatile unsigned int*)(0x42A22890UL)))
#define bM4_INTC_SEL58_INTSEL5                    (*((volatile unsigned int*)(0x42A22894UL)))
#define bM4_INTC_SEL58_INTSEL6                    (*((volatile unsigned int*)(0x42A22898UL)))
#define bM4_INTC_SEL58_INTSEL7                    (*((volatile unsigned int*)(0x42A2289CUL)))
#define bM4_INTC_SEL58_INTSEL8                    (*((volatile unsigned int*)(0x42A228A0UL)))
#define bM4_INTC_SEL59_INTSEL0                    (*((volatile unsigned int*)(0x42A22900UL)))
#define bM4_INTC_SEL59_INTSEL1                    (*((volatile unsigned int*)(0x42A22904UL)))
#define bM4_INTC_SEL59_INTSEL2                    (*((volatile unsigned int*)(0x42A22908UL)))
#define bM4_INTC_SEL59_INTSEL3                    (*((volatile unsigned int*)(0x42A2290CUL)))
#define bM4_INTC_SEL59_INTSEL4                    (*((volatile unsigned int*)(0x42A22910UL)))
#define bM4_INTC_SEL59_INTSEL5                    (*((volatile unsigned int*)(0x42A22914UL)))
#define bM4_INTC_SEL59_INTSEL6                    (*((volatile unsigned int*)(0x42A22918UL)))
#define bM4_INTC_SEL59_INTSEL7                    (*((volatile unsigned int*)(0x42A2291CUL)))
#define bM4_INTC_SEL59_INTSEL8                    (*((volatile unsigned int*)(0x42A22920UL)))
#define bM4_INTC_SEL60_INTSEL0                    (*((volatile unsigned int*)(0x42A22980UL)))
#define bM4_INTC_SEL60_INTSEL1                    (*((volatile unsigned int*)(0x42A22984UL)))
#define bM4_INTC_SEL60_INTSEL2                    (*((volatile unsigned int*)(0x42A22988UL)))
#define bM4_INTC_SEL60_INTSEL3                    (*((volatile unsigned int*)(0x42A2298CUL)))
#define bM4_INTC_SEL60_INTSEL4                    (*((volatile unsigned int*)(0x42A22990UL)))
#define bM4_INTC_SEL60_INTSEL5                    (*((volatile unsigned int*)(0x42A22994UL)))
#define bM4_INTC_SEL60_INTSEL6                    (*((volatile unsigned int*)(0x42A22998UL)))
#define bM4_INTC_SEL60_INTSEL7                    (*((volatile unsigned int*)(0x42A2299CUL)))
#define bM4_INTC_SEL60_INTSEL8                    (*((volatile unsigned int*)(0x42A229A0UL)))
#define bM4_INTC_SEL61_INTSEL0                    (*((volatile unsigned int*)(0x42A22A00UL)))
#define bM4_INTC_SEL61_INTSEL1                    (*((volatile unsigned int*)(0x42A22A04UL)))
#define bM4_INTC_SEL61_INTSEL2                    (*((volatile unsigned int*)(0x42A22A08UL)))
#define bM4_INTC_SEL61_INTSEL3                    (*((volatile unsigned int*)(0x42A22A0CUL)))
#define bM4_INTC_SEL61_INTSEL4                    (*((volatile unsigned int*)(0x42A22A10UL)))
#define bM4_INTC_SEL61_INTSEL5                    (*((volatile unsigned int*)(0x42A22A14UL)))
#define bM4_INTC_SEL61_INTSEL6                    (*((volatile unsigned int*)(0x42A22A18UL)))
#define bM4_INTC_SEL61_INTSEL7                    (*((volatile unsigned int*)(0x42A22A1CUL)))
#define bM4_INTC_SEL61_INTSEL8                    (*((volatile unsigned int*)(0x42A22A20UL)))
#define bM4_INTC_SEL62_INTSEL0                    (*((volatile unsigned int*)(0x42A22A80UL)))
#define bM4_INTC_SEL62_INTSEL1                    (*((volatile unsigned int*)(0x42A22A84UL)))
#define bM4_INTC_SEL62_INTSEL2                    (*((volatile unsigned int*)(0x42A22A88UL)))
#define bM4_INTC_SEL62_INTSEL3                    (*((volatile unsigned int*)(0x42A22A8CUL)))
#define bM4_INTC_SEL62_INTSEL4                    (*((volatile unsigned int*)(0x42A22A90UL)))
#define bM4_INTC_SEL62_INTSEL5                    (*((volatile unsigned int*)(0x42A22A94UL)))
#define bM4_INTC_SEL62_INTSEL6                    (*((volatile unsigned int*)(0x42A22A98UL)))
#define bM4_INTC_SEL62_INTSEL7                    (*((volatile unsigned int*)(0x42A22A9CUL)))
#define bM4_INTC_SEL62_INTSEL8                    (*((volatile unsigned int*)(0x42A22AA0UL)))
#define bM4_INTC_SEL63_INTSEL0                    (*((volatile unsigned int*)(0x42A22B00UL)))
#define bM4_INTC_SEL63_INTSEL1                    (*((volatile unsigned int*)(0x42A22B04UL)))
#define bM4_INTC_SEL63_INTSEL2                    (*((volatile unsigned int*)(0x42A22B08UL)))
#define bM4_INTC_SEL63_INTSEL3                    (*((volatile unsigned int*)(0x42A22B0CUL)))
#define bM4_INTC_SEL63_INTSEL4                    (*((volatile unsigned int*)(0x42A22B10UL)))
#define bM4_INTC_SEL63_INTSEL5                    (*((volatile unsigned int*)(0x42A22B14UL)))
#define bM4_INTC_SEL63_INTSEL6                    (*((volatile unsigned int*)(0x42A22B18UL)))
#define bM4_INTC_SEL63_INTSEL7                    (*((volatile unsigned int*)(0x42A22B1CUL)))
#define bM4_INTC_SEL63_INTSEL8                    (*((volatile unsigned int*)(0x42A22B20UL)))
#define bM4_INTC_SEL64_INTSEL0                    (*((volatile unsigned int*)(0x42A22B80UL)))
#define bM4_INTC_SEL64_INTSEL1                    (*((volatile unsigned int*)(0x42A22B84UL)))
#define bM4_INTC_SEL64_INTSEL2                    (*((volatile unsigned int*)(0x42A22B88UL)))
#define bM4_INTC_SEL64_INTSEL3                    (*((volatile unsigned int*)(0x42A22B8CUL)))
#define bM4_INTC_SEL64_INTSEL4                    (*((volatile unsigned int*)(0x42A22B90UL)))
#define bM4_INTC_SEL64_INTSEL5                    (*((volatile unsigned int*)(0x42A22B94UL)))
#define bM4_INTC_SEL64_INTSEL6                    (*((volatile unsigned int*)(0x42A22B98UL)))
#define bM4_INTC_SEL64_INTSEL7                    (*((volatile unsigned int*)(0x42A22B9CUL)))
#define bM4_INTC_SEL64_INTSEL8                    (*((volatile unsigned int*)(0x42A22BA0UL)))
#define bM4_INTC_SEL65_INTSEL0                    (*((volatile unsigned int*)(0x42A22C00UL)))
#define bM4_INTC_SEL65_INTSEL1                    (*((volatile unsigned int*)(0x42A22C04UL)))
#define bM4_INTC_SEL65_INTSEL2                    (*((volatile unsigned int*)(0x42A22C08UL)))
#define bM4_INTC_SEL65_INTSEL3                    (*((volatile unsigned int*)(0x42A22C0CUL)))
#define bM4_INTC_SEL65_INTSEL4                    (*((volatile unsigned int*)(0x42A22C10UL)))
#define bM4_INTC_SEL65_INTSEL5                    (*((volatile unsigned int*)(0x42A22C14UL)))
#define bM4_INTC_SEL65_INTSEL6                    (*((volatile unsigned int*)(0x42A22C18UL)))
#define bM4_INTC_SEL65_INTSEL7                    (*((volatile unsigned int*)(0x42A22C1CUL)))
#define bM4_INTC_SEL65_INTSEL8                    (*((volatile unsigned int*)(0x42A22C20UL)))
#define bM4_INTC_SEL66_INTSEL0                    (*((volatile unsigned int*)(0x42A22C80UL)))
#define bM4_INTC_SEL66_INTSEL1                    (*((volatile unsigned int*)(0x42A22C84UL)))
#define bM4_INTC_SEL66_INTSEL2                    (*((volatile unsigned int*)(0x42A22C88UL)))
#define bM4_INTC_SEL66_INTSEL3                    (*((volatile unsigned int*)(0x42A22C8CUL)))
#define bM4_INTC_SEL66_INTSEL4                    (*((volatile unsigned int*)(0x42A22C90UL)))
#define bM4_INTC_SEL66_INTSEL5                    (*((volatile unsigned int*)(0x42A22C94UL)))
#define bM4_INTC_SEL66_INTSEL6                    (*((volatile unsigned int*)(0x42A22C98UL)))
#define bM4_INTC_SEL66_INTSEL7                    (*((volatile unsigned int*)(0x42A22C9CUL)))
#define bM4_INTC_SEL66_INTSEL8                    (*((volatile unsigned int*)(0x42A22CA0UL)))
#define bM4_INTC_SEL67_INTSEL0                    (*((volatile unsigned int*)(0x42A22D00UL)))
#define bM4_INTC_SEL67_INTSEL1                    (*((volatile unsigned int*)(0x42A22D04UL)))
#define bM4_INTC_SEL67_INTSEL2                    (*((volatile unsigned int*)(0x42A22D08UL)))
#define bM4_INTC_SEL67_INTSEL3                    (*((volatile unsigned int*)(0x42A22D0CUL)))
#define bM4_INTC_SEL67_INTSEL4                    (*((volatile unsigned int*)(0x42A22D10UL)))
#define bM4_INTC_SEL67_INTSEL5                    (*((volatile unsigned int*)(0x42A22D14UL)))
#define bM4_INTC_SEL67_INTSEL6                    (*((volatile unsigned int*)(0x42A22D18UL)))
#define bM4_INTC_SEL67_INTSEL7                    (*((volatile unsigned int*)(0x42A22D1CUL)))
#define bM4_INTC_SEL67_INTSEL8                    (*((volatile unsigned int*)(0x42A22D20UL)))
#define bM4_INTC_SEL68_INTSEL0                    (*((volatile unsigned int*)(0x42A22D80UL)))
#define bM4_INTC_SEL68_INTSEL1                    (*((volatile unsigned int*)(0x42A22D84UL)))
#define bM4_INTC_SEL68_INTSEL2                    (*((volatile unsigned int*)(0x42A22D88UL)))
#define bM4_INTC_SEL68_INTSEL3                    (*((volatile unsigned int*)(0x42A22D8CUL)))
#define bM4_INTC_SEL68_INTSEL4                    (*((volatile unsigned int*)(0x42A22D90UL)))
#define bM4_INTC_SEL68_INTSEL5                    (*((volatile unsigned int*)(0x42A22D94UL)))
#define bM4_INTC_SEL68_INTSEL6                    (*((volatile unsigned int*)(0x42A22D98UL)))
#define bM4_INTC_SEL68_INTSEL7                    (*((volatile unsigned int*)(0x42A22D9CUL)))
#define bM4_INTC_SEL68_INTSEL8                    (*((volatile unsigned int*)(0x42A22DA0UL)))
#define bM4_INTC_SEL69_INTSEL0                    (*((volatile unsigned int*)(0x42A22E00UL)))
#define bM4_INTC_SEL69_INTSEL1                    (*((volatile unsigned int*)(0x42A22E04UL)))
#define bM4_INTC_SEL69_INTSEL2                    (*((volatile unsigned int*)(0x42A22E08UL)))
#define bM4_INTC_SEL69_INTSEL3                    (*((volatile unsigned int*)(0x42A22E0CUL)))
#define bM4_INTC_SEL69_INTSEL4                    (*((volatile unsigned int*)(0x42A22E10UL)))
#define bM4_INTC_SEL69_INTSEL5                    (*((volatile unsigned int*)(0x42A22E14UL)))
#define bM4_INTC_SEL69_INTSEL6                    (*((volatile unsigned int*)(0x42A22E18UL)))
#define bM4_INTC_SEL69_INTSEL7                    (*((volatile unsigned int*)(0x42A22E1CUL)))
#define bM4_INTC_SEL69_INTSEL8                    (*((volatile unsigned int*)(0x42A22E20UL)))
#define bM4_INTC_SEL70_INTSEL0                    (*((volatile unsigned int*)(0x42A22E80UL)))
#define bM4_INTC_SEL70_INTSEL1                    (*((volatile unsigned int*)(0x42A22E84UL)))
#define bM4_INTC_SEL70_INTSEL2                    (*((volatile unsigned int*)(0x42A22E88UL)))
#define bM4_INTC_SEL70_INTSEL3                    (*((volatile unsigned int*)(0x42A22E8CUL)))
#define bM4_INTC_SEL70_INTSEL4                    (*((volatile unsigned int*)(0x42A22E90UL)))
#define bM4_INTC_SEL70_INTSEL5                    (*((volatile unsigned int*)(0x42A22E94UL)))
#define bM4_INTC_SEL70_INTSEL6                    (*((volatile unsigned int*)(0x42A22E98UL)))
#define bM4_INTC_SEL70_INTSEL7                    (*((volatile unsigned int*)(0x42A22E9CUL)))
#define bM4_INTC_SEL70_INTSEL8                    (*((volatile unsigned int*)(0x42A22EA0UL)))
#define bM4_INTC_SEL71_INTSEL0                    (*((volatile unsigned int*)(0x42A22F00UL)))
#define bM4_INTC_SEL71_INTSEL1                    (*((volatile unsigned int*)(0x42A22F04UL)))
#define bM4_INTC_SEL71_INTSEL2                    (*((volatile unsigned int*)(0x42A22F08UL)))
#define bM4_INTC_SEL71_INTSEL3                    (*((volatile unsigned int*)(0x42A22F0CUL)))
#define bM4_INTC_SEL71_INTSEL4                    (*((volatile unsigned int*)(0x42A22F10UL)))
#define bM4_INTC_SEL71_INTSEL5                    (*((volatile unsigned int*)(0x42A22F14UL)))
#define bM4_INTC_SEL71_INTSEL6                    (*((volatile unsigned int*)(0x42A22F18UL)))
#define bM4_INTC_SEL71_INTSEL7                    (*((volatile unsigned int*)(0x42A22F1CUL)))
#define bM4_INTC_SEL71_INTSEL8                    (*((volatile unsigned int*)(0x42A22F20UL)))
#define bM4_INTC_SEL72_INTSEL0                    (*((volatile unsigned int*)(0x42A22F80UL)))
#define bM4_INTC_SEL72_INTSEL1                    (*((volatile unsigned int*)(0x42A22F84UL)))
#define bM4_INTC_SEL72_INTSEL2                    (*((volatile unsigned int*)(0x42A22F88UL)))
#define bM4_INTC_SEL72_INTSEL3                    (*((volatile unsigned int*)(0x42A22F8CUL)))
#define bM4_INTC_SEL72_INTSEL4                    (*((volatile unsigned int*)(0x42A22F90UL)))
#define bM4_INTC_SEL72_INTSEL5                    (*((volatile unsigned int*)(0x42A22F94UL)))
#define bM4_INTC_SEL72_INTSEL6                    (*((volatile unsigned int*)(0x42A22F98UL)))
#define bM4_INTC_SEL72_INTSEL7                    (*((volatile unsigned int*)(0x42A22F9CUL)))
#define bM4_INTC_SEL72_INTSEL8                    (*((volatile unsigned int*)(0x42A22FA0UL)))
#define bM4_INTC_SEL73_INTSEL0                    (*((volatile unsigned int*)(0x42A23000UL)))
#define bM4_INTC_SEL73_INTSEL1                    (*((volatile unsigned int*)(0x42A23004UL)))
#define bM4_INTC_SEL73_INTSEL2                    (*((volatile unsigned int*)(0x42A23008UL)))
#define bM4_INTC_SEL73_INTSEL3                    (*((volatile unsigned int*)(0x42A2300CUL)))
#define bM4_INTC_SEL73_INTSEL4                    (*((volatile unsigned int*)(0x42A23010UL)))
#define bM4_INTC_SEL73_INTSEL5                    (*((volatile unsigned int*)(0x42A23014UL)))
#define bM4_INTC_SEL73_INTSEL6                    (*((volatile unsigned int*)(0x42A23018UL)))
#define bM4_INTC_SEL73_INTSEL7                    (*((volatile unsigned int*)(0x42A2301CUL)))
#define bM4_INTC_SEL73_INTSEL8                    (*((volatile unsigned int*)(0x42A23020UL)))
#define bM4_INTC_SEL74_INTSEL0                    (*((volatile unsigned int*)(0x42A23080UL)))
#define bM4_INTC_SEL74_INTSEL1                    (*((volatile unsigned int*)(0x42A23084UL)))
#define bM4_INTC_SEL74_INTSEL2                    (*((volatile unsigned int*)(0x42A23088UL)))
#define bM4_INTC_SEL74_INTSEL3                    (*((volatile unsigned int*)(0x42A2308CUL)))
#define bM4_INTC_SEL74_INTSEL4                    (*((volatile unsigned int*)(0x42A23090UL)))
#define bM4_INTC_SEL74_INTSEL5                    (*((volatile unsigned int*)(0x42A23094UL)))
#define bM4_INTC_SEL74_INTSEL6                    (*((volatile unsigned int*)(0x42A23098UL)))
#define bM4_INTC_SEL74_INTSEL7                    (*((volatile unsigned int*)(0x42A2309CUL)))
#define bM4_INTC_SEL74_INTSEL8                    (*((volatile unsigned int*)(0x42A230A0UL)))
#define bM4_INTC_SEL75_INTSEL0                    (*((volatile unsigned int*)(0x42A23100UL)))
#define bM4_INTC_SEL75_INTSEL1                    (*((volatile unsigned int*)(0x42A23104UL)))
#define bM4_INTC_SEL75_INTSEL2                    (*((volatile unsigned int*)(0x42A23108UL)))
#define bM4_INTC_SEL75_INTSEL3                    (*((volatile unsigned int*)(0x42A2310CUL)))
#define bM4_INTC_SEL75_INTSEL4                    (*((volatile unsigned int*)(0x42A23110UL)))
#define bM4_INTC_SEL75_INTSEL5                    (*((volatile unsigned int*)(0x42A23114UL)))
#define bM4_INTC_SEL75_INTSEL6                    (*((volatile unsigned int*)(0x42A23118UL)))
#define bM4_INTC_SEL75_INTSEL7                    (*((volatile unsigned int*)(0x42A2311CUL)))
#define bM4_INTC_SEL75_INTSEL8                    (*((volatile unsigned int*)(0x42A23120UL)))
#define bM4_INTC_SEL76_INTSEL0                    (*((volatile unsigned int*)(0x42A23180UL)))
#define bM4_INTC_SEL76_INTSEL1                    (*((volatile unsigned int*)(0x42A23184UL)))
#define bM4_INTC_SEL76_INTSEL2                    (*((volatile unsigned int*)(0x42A23188UL)))
#define bM4_INTC_SEL76_INTSEL3                    (*((volatile unsigned int*)(0x42A2318CUL)))
#define bM4_INTC_SEL76_INTSEL4                    (*((volatile unsigned int*)(0x42A23190UL)))
#define bM4_INTC_SEL76_INTSEL5                    (*((volatile unsigned int*)(0x42A23194UL)))
#define bM4_INTC_SEL76_INTSEL6                    (*((volatile unsigned int*)(0x42A23198UL)))
#define bM4_INTC_SEL76_INTSEL7                    (*((volatile unsigned int*)(0x42A2319CUL)))
#define bM4_INTC_SEL76_INTSEL8                    (*((volatile unsigned int*)(0x42A231A0UL)))
#define bM4_INTC_SEL77_INTSEL0                    (*((volatile unsigned int*)(0x42A23200UL)))
#define bM4_INTC_SEL77_INTSEL1                    (*((volatile unsigned int*)(0x42A23204UL)))
#define bM4_INTC_SEL77_INTSEL2                    (*((volatile unsigned int*)(0x42A23208UL)))
#define bM4_INTC_SEL77_INTSEL3                    (*((volatile unsigned int*)(0x42A2320CUL)))
#define bM4_INTC_SEL77_INTSEL4                    (*((volatile unsigned int*)(0x42A23210UL)))
#define bM4_INTC_SEL77_INTSEL5                    (*((volatile unsigned int*)(0x42A23214UL)))
#define bM4_INTC_SEL77_INTSEL6                    (*((volatile unsigned int*)(0x42A23218UL)))
#define bM4_INTC_SEL77_INTSEL7                    (*((volatile unsigned int*)(0x42A2321CUL)))
#define bM4_INTC_SEL77_INTSEL8                    (*((volatile unsigned int*)(0x42A23220UL)))
#define bM4_INTC_SEL78_INTSEL0                    (*((volatile unsigned int*)(0x42A23280UL)))
#define bM4_INTC_SEL78_INTSEL1                    (*((volatile unsigned int*)(0x42A23284UL)))
#define bM4_INTC_SEL78_INTSEL2                    (*((volatile unsigned int*)(0x42A23288UL)))
#define bM4_INTC_SEL78_INTSEL3                    (*((volatile unsigned int*)(0x42A2328CUL)))
#define bM4_INTC_SEL78_INTSEL4                    (*((volatile unsigned int*)(0x42A23290UL)))
#define bM4_INTC_SEL78_INTSEL5                    (*((volatile unsigned int*)(0x42A23294UL)))
#define bM4_INTC_SEL78_INTSEL6                    (*((volatile unsigned int*)(0x42A23298UL)))
#define bM4_INTC_SEL78_INTSEL7                    (*((volatile unsigned int*)(0x42A2329CUL)))
#define bM4_INTC_SEL78_INTSEL8                    (*((volatile unsigned int*)(0x42A232A0UL)))
#define bM4_INTC_SEL79_INTSEL0                    (*((volatile unsigned int*)(0x42A23300UL)))
#define bM4_INTC_SEL79_INTSEL1                    (*((volatile unsigned int*)(0x42A23304UL)))
#define bM4_INTC_SEL79_INTSEL2                    (*((volatile unsigned int*)(0x42A23308UL)))
#define bM4_INTC_SEL79_INTSEL3                    (*((volatile unsigned int*)(0x42A2330CUL)))
#define bM4_INTC_SEL79_INTSEL4                    (*((volatile unsigned int*)(0x42A23310UL)))
#define bM4_INTC_SEL79_INTSEL5                    (*((volatile unsigned int*)(0x42A23314UL)))
#define bM4_INTC_SEL79_INTSEL6                    (*((volatile unsigned int*)(0x42A23318UL)))
#define bM4_INTC_SEL79_INTSEL7                    (*((volatile unsigned int*)(0x42A2331CUL)))
#define bM4_INTC_SEL79_INTSEL8                    (*((volatile unsigned int*)(0x42A23320UL)))
#define bM4_INTC_SEL80_INTSEL0                    (*((volatile unsigned int*)(0x42A23380UL)))
#define bM4_INTC_SEL80_INTSEL1                    (*((volatile unsigned int*)(0x42A23384UL)))
#define bM4_INTC_SEL80_INTSEL2                    (*((volatile unsigned int*)(0x42A23388UL)))
#define bM4_INTC_SEL80_INTSEL3                    (*((volatile unsigned int*)(0x42A2338CUL)))
#define bM4_INTC_SEL80_INTSEL4                    (*((volatile unsigned int*)(0x42A23390UL)))
#define bM4_INTC_SEL80_INTSEL5                    (*((volatile unsigned int*)(0x42A23394UL)))
#define bM4_INTC_SEL80_INTSEL6                    (*((volatile unsigned int*)(0x42A23398UL)))
#define bM4_INTC_SEL80_INTSEL7                    (*((volatile unsigned int*)(0x42A2339CUL)))
#define bM4_INTC_SEL80_INTSEL8                    (*((volatile unsigned int*)(0x42A233A0UL)))
#define bM4_INTC_SEL81_INTSEL0                    (*((volatile unsigned int*)(0x42A23400UL)))
#define bM4_INTC_SEL81_INTSEL1                    (*((volatile unsigned int*)(0x42A23404UL)))
#define bM4_INTC_SEL81_INTSEL2                    (*((volatile unsigned int*)(0x42A23408UL)))
#define bM4_INTC_SEL81_INTSEL3                    (*((volatile unsigned int*)(0x42A2340CUL)))
#define bM4_INTC_SEL81_INTSEL4                    (*((volatile unsigned int*)(0x42A23410UL)))
#define bM4_INTC_SEL81_INTSEL5                    (*((volatile unsigned int*)(0x42A23414UL)))
#define bM4_INTC_SEL81_INTSEL6                    (*((volatile unsigned int*)(0x42A23418UL)))
#define bM4_INTC_SEL81_INTSEL7                    (*((volatile unsigned int*)(0x42A2341CUL)))
#define bM4_INTC_SEL81_INTSEL8                    (*((volatile unsigned int*)(0x42A23420UL)))
#define bM4_INTC_SEL82_INTSEL0                    (*((volatile unsigned int*)(0x42A23480UL)))
#define bM4_INTC_SEL82_INTSEL1                    (*((volatile unsigned int*)(0x42A23484UL)))
#define bM4_INTC_SEL82_INTSEL2                    (*((volatile unsigned int*)(0x42A23488UL)))
#define bM4_INTC_SEL82_INTSEL3                    (*((volatile unsigned int*)(0x42A2348CUL)))
#define bM4_INTC_SEL82_INTSEL4                    (*((volatile unsigned int*)(0x42A23490UL)))
#define bM4_INTC_SEL82_INTSEL5                    (*((volatile unsigned int*)(0x42A23494UL)))
#define bM4_INTC_SEL82_INTSEL6                    (*((volatile unsigned int*)(0x42A23498UL)))
#define bM4_INTC_SEL82_INTSEL7                    (*((volatile unsigned int*)(0x42A2349CUL)))
#define bM4_INTC_SEL82_INTSEL8                    (*((volatile unsigned int*)(0x42A234A0UL)))
#define bM4_INTC_SEL83_INTSEL0                    (*((volatile unsigned int*)(0x42A23500UL)))
#define bM4_INTC_SEL83_INTSEL1                    (*((volatile unsigned int*)(0x42A23504UL)))
#define bM4_INTC_SEL83_INTSEL2                    (*((volatile unsigned int*)(0x42A23508UL)))
#define bM4_INTC_SEL83_INTSEL3                    (*((volatile unsigned int*)(0x42A2350CUL)))
#define bM4_INTC_SEL83_INTSEL4                    (*((volatile unsigned int*)(0x42A23510UL)))
#define bM4_INTC_SEL83_INTSEL5                    (*((volatile unsigned int*)(0x42A23514UL)))
#define bM4_INTC_SEL83_INTSEL6                    (*((volatile unsigned int*)(0x42A23518UL)))
#define bM4_INTC_SEL83_INTSEL7                    (*((volatile unsigned int*)(0x42A2351CUL)))
#define bM4_INTC_SEL83_INTSEL8                    (*((volatile unsigned int*)(0x42A23520UL)))
#define bM4_INTC_SEL84_INTSEL0                    (*((volatile unsigned int*)(0x42A23580UL)))
#define bM4_INTC_SEL84_INTSEL1                    (*((volatile unsigned int*)(0x42A23584UL)))
#define bM4_INTC_SEL84_INTSEL2                    (*((volatile unsigned int*)(0x42A23588UL)))
#define bM4_INTC_SEL84_INTSEL3                    (*((volatile unsigned int*)(0x42A2358CUL)))
#define bM4_INTC_SEL84_INTSEL4                    (*((volatile unsigned int*)(0x42A23590UL)))
#define bM4_INTC_SEL84_INTSEL5                    (*((volatile unsigned int*)(0x42A23594UL)))
#define bM4_INTC_SEL84_INTSEL6                    (*((volatile unsigned int*)(0x42A23598UL)))
#define bM4_INTC_SEL84_INTSEL7                    (*((volatile unsigned int*)(0x42A2359CUL)))
#define bM4_INTC_SEL84_INTSEL8                    (*((volatile unsigned int*)(0x42A235A0UL)))
#define bM4_INTC_SEL85_INTSEL0                    (*((volatile unsigned int*)(0x42A23600UL)))
#define bM4_INTC_SEL85_INTSEL1                    (*((volatile unsigned int*)(0x42A23604UL)))
#define bM4_INTC_SEL85_INTSEL2                    (*((volatile unsigned int*)(0x42A23608UL)))
#define bM4_INTC_SEL85_INTSEL3                    (*((volatile unsigned int*)(0x42A2360CUL)))
#define bM4_INTC_SEL85_INTSEL4                    (*((volatile unsigned int*)(0x42A23610UL)))
#define bM4_INTC_SEL85_INTSEL5                    (*((volatile unsigned int*)(0x42A23614UL)))
#define bM4_INTC_SEL85_INTSEL6                    (*((volatile unsigned int*)(0x42A23618UL)))
#define bM4_INTC_SEL85_INTSEL7                    (*((volatile unsigned int*)(0x42A2361CUL)))
#define bM4_INTC_SEL85_INTSEL8                    (*((volatile unsigned int*)(0x42A23620UL)))
#define bM4_INTC_SEL86_INTSEL0                    (*((volatile unsigned int*)(0x42A23680UL)))
#define bM4_INTC_SEL86_INTSEL1                    (*((volatile unsigned int*)(0x42A23684UL)))
#define bM4_INTC_SEL86_INTSEL2                    (*((volatile unsigned int*)(0x42A23688UL)))
#define bM4_INTC_SEL86_INTSEL3                    (*((volatile unsigned int*)(0x42A2368CUL)))
#define bM4_INTC_SEL86_INTSEL4                    (*((volatile unsigned int*)(0x42A23690UL)))
#define bM4_INTC_SEL86_INTSEL5                    (*((volatile unsigned int*)(0x42A23694UL)))
#define bM4_INTC_SEL86_INTSEL6                    (*((volatile unsigned int*)(0x42A23698UL)))
#define bM4_INTC_SEL86_INTSEL7                    (*((volatile unsigned int*)(0x42A2369CUL)))
#define bM4_INTC_SEL86_INTSEL8                    (*((volatile unsigned int*)(0x42A236A0UL)))
#define bM4_INTC_SEL87_INTSEL0                    (*((volatile unsigned int*)(0x42A23700UL)))
#define bM4_INTC_SEL87_INTSEL1                    (*((volatile unsigned int*)(0x42A23704UL)))
#define bM4_INTC_SEL87_INTSEL2                    (*((volatile unsigned int*)(0x42A23708UL)))
#define bM4_INTC_SEL87_INTSEL3                    (*((volatile unsigned int*)(0x42A2370CUL)))
#define bM4_INTC_SEL87_INTSEL4                    (*((volatile unsigned int*)(0x42A23710UL)))
#define bM4_INTC_SEL87_INTSEL5                    (*((volatile unsigned int*)(0x42A23714UL)))
#define bM4_INTC_SEL87_INTSEL6                    (*((volatile unsigned int*)(0x42A23718UL)))
#define bM4_INTC_SEL87_INTSEL7                    (*((volatile unsigned int*)(0x42A2371CUL)))
#define bM4_INTC_SEL87_INTSEL8                    (*((volatile unsigned int*)(0x42A23720UL)))
#define bM4_INTC_SEL88_INTSEL0                    (*((volatile unsigned int*)(0x42A23780UL)))
#define bM4_INTC_SEL88_INTSEL1                    (*((volatile unsigned int*)(0x42A23784UL)))
#define bM4_INTC_SEL88_INTSEL2                    (*((volatile unsigned int*)(0x42A23788UL)))
#define bM4_INTC_SEL88_INTSEL3                    (*((volatile unsigned int*)(0x42A2378CUL)))
#define bM4_INTC_SEL88_INTSEL4                    (*((volatile unsigned int*)(0x42A23790UL)))
#define bM4_INTC_SEL88_INTSEL5                    (*((volatile unsigned int*)(0x42A23794UL)))
#define bM4_INTC_SEL88_INTSEL6                    (*((volatile unsigned int*)(0x42A23798UL)))
#define bM4_INTC_SEL88_INTSEL7                    (*((volatile unsigned int*)(0x42A2379CUL)))
#define bM4_INTC_SEL88_INTSEL8                    (*((volatile unsigned int*)(0x42A237A0UL)))
#define bM4_INTC_SEL89_INTSEL0                    (*((volatile unsigned int*)(0x42A23800UL)))
#define bM4_INTC_SEL89_INTSEL1                    (*((volatile unsigned int*)(0x42A23804UL)))
#define bM4_INTC_SEL89_INTSEL2                    (*((volatile unsigned int*)(0x42A23808UL)))
#define bM4_INTC_SEL89_INTSEL3                    (*((volatile unsigned int*)(0x42A2380CUL)))
#define bM4_INTC_SEL89_INTSEL4                    (*((volatile unsigned int*)(0x42A23810UL)))
#define bM4_INTC_SEL89_INTSEL5                    (*((volatile unsigned int*)(0x42A23814UL)))
#define bM4_INTC_SEL89_INTSEL6                    (*((volatile unsigned int*)(0x42A23818UL)))
#define bM4_INTC_SEL89_INTSEL7                    (*((volatile unsigned int*)(0x42A2381CUL)))
#define bM4_INTC_SEL89_INTSEL8                    (*((volatile unsigned int*)(0x42A23820UL)))
#define bM4_INTC_SEL90_INTSEL0                    (*((volatile unsigned int*)(0x42A23880UL)))
#define bM4_INTC_SEL90_INTSEL1                    (*((volatile unsigned int*)(0x42A23884UL)))
#define bM4_INTC_SEL90_INTSEL2                    (*((volatile unsigned int*)(0x42A23888UL)))
#define bM4_INTC_SEL90_INTSEL3                    (*((volatile unsigned int*)(0x42A2388CUL)))
#define bM4_INTC_SEL90_INTSEL4                    (*((volatile unsigned int*)(0x42A23890UL)))
#define bM4_INTC_SEL90_INTSEL5                    (*((volatile unsigned int*)(0x42A23894UL)))
#define bM4_INTC_SEL90_INTSEL6                    (*((volatile unsigned int*)(0x42A23898UL)))
#define bM4_INTC_SEL90_INTSEL7                    (*((volatile unsigned int*)(0x42A2389CUL)))
#define bM4_INTC_SEL90_INTSEL8                    (*((volatile unsigned int*)(0x42A238A0UL)))
#define bM4_INTC_SEL91_INTSEL0                    (*((volatile unsigned int*)(0x42A23900UL)))
#define bM4_INTC_SEL91_INTSEL1                    (*((volatile unsigned int*)(0x42A23904UL)))
#define bM4_INTC_SEL91_INTSEL2                    (*((volatile unsigned int*)(0x42A23908UL)))
#define bM4_INTC_SEL91_INTSEL3                    (*((volatile unsigned int*)(0x42A2390CUL)))
#define bM4_INTC_SEL91_INTSEL4                    (*((volatile unsigned int*)(0x42A23910UL)))
#define bM4_INTC_SEL91_INTSEL5                    (*((volatile unsigned int*)(0x42A23914UL)))
#define bM4_INTC_SEL91_INTSEL6                    (*((volatile unsigned int*)(0x42A23918UL)))
#define bM4_INTC_SEL91_INTSEL7                    (*((volatile unsigned int*)(0x42A2391CUL)))
#define bM4_INTC_SEL91_INTSEL8                    (*((volatile unsigned int*)(0x42A23920UL)))
#define bM4_INTC_SEL92_INTSEL0                    (*((volatile unsigned int*)(0x42A23980UL)))
#define bM4_INTC_SEL92_INTSEL1                    (*((volatile unsigned int*)(0x42A23984UL)))
#define bM4_INTC_SEL92_INTSEL2                    (*((volatile unsigned int*)(0x42A23988UL)))
#define bM4_INTC_SEL92_INTSEL3                    (*((volatile unsigned int*)(0x42A2398CUL)))
#define bM4_INTC_SEL92_INTSEL4                    (*((volatile unsigned int*)(0x42A23990UL)))
#define bM4_INTC_SEL92_INTSEL5                    (*((volatile unsigned int*)(0x42A23994UL)))
#define bM4_INTC_SEL92_INTSEL6                    (*((volatile unsigned int*)(0x42A23998UL)))
#define bM4_INTC_SEL92_INTSEL7                    (*((volatile unsigned int*)(0x42A2399CUL)))
#define bM4_INTC_SEL92_INTSEL8                    (*((volatile unsigned int*)(0x42A239A0UL)))
#define bM4_INTC_SEL93_INTSEL0                    (*((volatile unsigned int*)(0x42A23A00UL)))
#define bM4_INTC_SEL93_INTSEL1                    (*((volatile unsigned int*)(0x42A23A04UL)))
#define bM4_INTC_SEL93_INTSEL2                    (*((volatile unsigned int*)(0x42A23A08UL)))
#define bM4_INTC_SEL93_INTSEL3                    (*((volatile unsigned int*)(0x42A23A0CUL)))
#define bM4_INTC_SEL93_INTSEL4                    (*((volatile unsigned int*)(0x42A23A10UL)))
#define bM4_INTC_SEL93_INTSEL5                    (*((volatile unsigned int*)(0x42A23A14UL)))
#define bM4_INTC_SEL93_INTSEL6                    (*((volatile unsigned int*)(0x42A23A18UL)))
#define bM4_INTC_SEL93_INTSEL7                    (*((volatile unsigned int*)(0x42A23A1CUL)))
#define bM4_INTC_SEL93_INTSEL8                    (*((volatile unsigned int*)(0x42A23A20UL)))
#define bM4_INTC_SEL94_INTSEL0                    (*((volatile unsigned int*)(0x42A23A80UL)))
#define bM4_INTC_SEL94_INTSEL1                    (*((volatile unsigned int*)(0x42A23A84UL)))
#define bM4_INTC_SEL94_INTSEL2                    (*((volatile unsigned int*)(0x42A23A88UL)))
#define bM4_INTC_SEL94_INTSEL3                    (*((volatile unsigned int*)(0x42A23A8CUL)))
#define bM4_INTC_SEL94_INTSEL4                    (*((volatile unsigned int*)(0x42A23A90UL)))
#define bM4_INTC_SEL94_INTSEL5                    (*((volatile unsigned int*)(0x42A23A94UL)))
#define bM4_INTC_SEL94_INTSEL6                    (*((volatile unsigned int*)(0x42A23A98UL)))
#define bM4_INTC_SEL94_INTSEL7                    (*((volatile unsigned int*)(0x42A23A9CUL)))
#define bM4_INTC_SEL94_INTSEL8                    (*((volatile unsigned int*)(0x42A23AA0UL)))
#define bM4_INTC_SEL95_INTSEL0                    (*((volatile unsigned int*)(0x42A23B00UL)))
#define bM4_INTC_SEL95_INTSEL1                    (*((volatile unsigned int*)(0x42A23B04UL)))
#define bM4_INTC_SEL95_INTSEL2                    (*((volatile unsigned int*)(0x42A23B08UL)))
#define bM4_INTC_SEL95_INTSEL3                    (*((volatile unsigned int*)(0x42A23B0CUL)))
#define bM4_INTC_SEL95_INTSEL4                    (*((volatile unsigned int*)(0x42A23B10UL)))
#define bM4_INTC_SEL95_INTSEL5                    (*((volatile unsigned int*)(0x42A23B14UL)))
#define bM4_INTC_SEL95_INTSEL6                    (*((volatile unsigned int*)(0x42A23B18UL)))
#define bM4_INTC_SEL95_INTSEL7                    (*((volatile unsigned int*)(0x42A23B1CUL)))
#define bM4_INTC_SEL95_INTSEL8                    (*((volatile unsigned int*)(0x42A23B20UL)))
#define bM4_INTC_SEL96_INTSEL0                    (*((volatile unsigned int*)(0x42A23B80UL)))
#define bM4_INTC_SEL96_INTSEL1                    (*((volatile unsigned int*)(0x42A23B84UL)))
#define bM4_INTC_SEL96_INTSEL2                    (*((volatile unsigned int*)(0x42A23B88UL)))
#define bM4_INTC_SEL96_INTSEL3                    (*((volatile unsigned int*)(0x42A23B8CUL)))
#define bM4_INTC_SEL96_INTSEL4                    (*((volatile unsigned int*)(0x42A23B90UL)))
#define bM4_INTC_SEL96_INTSEL5                    (*((volatile unsigned int*)(0x42A23B94UL)))
#define bM4_INTC_SEL96_INTSEL6                    (*((volatile unsigned int*)(0x42A23B98UL)))
#define bM4_INTC_SEL96_INTSEL7                    (*((volatile unsigned int*)(0x42A23B9CUL)))
#define bM4_INTC_SEL96_INTSEL8                    (*((volatile unsigned int*)(0x42A23BA0UL)))
#define bM4_INTC_SEL97_INTSEL0                    (*((volatile unsigned int*)(0x42A23C00UL)))
#define bM4_INTC_SEL97_INTSEL1                    (*((volatile unsigned int*)(0x42A23C04UL)))
#define bM4_INTC_SEL97_INTSEL2                    (*((volatile unsigned int*)(0x42A23C08UL)))
#define bM4_INTC_SEL97_INTSEL3                    (*((volatile unsigned int*)(0x42A23C0CUL)))
#define bM4_INTC_SEL97_INTSEL4                    (*((volatile unsigned int*)(0x42A23C10UL)))
#define bM4_INTC_SEL97_INTSEL5                    (*((volatile unsigned int*)(0x42A23C14UL)))
#define bM4_INTC_SEL97_INTSEL6                    (*((volatile unsigned int*)(0x42A23C18UL)))
#define bM4_INTC_SEL97_INTSEL7                    (*((volatile unsigned int*)(0x42A23C1CUL)))
#define bM4_INTC_SEL97_INTSEL8                    (*((volatile unsigned int*)(0x42A23C20UL)))
#define bM4_INTC_SEL98_INTSEL0                    (*((volatile unsigned int*)(0x42A23C80UL)))
#define bM4_INTC_SEL98_INTSEL1                    (*((volatile unsigned int*)(0x42A23C84UL)))
#define bM4_INTC_SEL98_INTSEL2                    (*((volatile unsigned int*)(0x42A23C88UL)))
#define bM4_INTC_SEL98_INTSEL3                    (*((volatile unsigned int*)(0x42A23C8CUL)))
#define bM4_INTC_SEL98_INTSEL4                    (*((volatile unsigned int*)(0x42A23C90UL)))
#define bM4_INTC_SEL98_INTSEL5                    (*((volatile unsigned int*)(0x42A23C94UL)))
#define bM4_INTC_SEL98_INTSEL6                    (*((volatile unsigned int*)(0x42A23C98UL)))
#define bM4_INTC_SEL98_INTSEL7                    (*((volatile unsigned int*)(0x42A23C9CUL)))
#define bM4_INTC_SEL98_INTSEL8                    (*((volatile unsigned int*)(0x42A23CA0UL)))
#define bM4_INTC_SEL99_INTSEL0                    (*((volatile unsigned int*)(0x42A23D00UL)))
#define bM4_INTC_SEL99_INTSEL1                    (*((volatile unsigned int*)(0x42A23D04UL)))
#define bM4_INTC_SEL99_INTSEL2                    (*((volatile unsigned int*)(0x42A23D08UL)))
#define bM4_INTC_SEL99_INTSEL3                    (*((volatile unsigned int*)(0x42A23D0CUL)))
#define bM4_INTC_SEL99_INTSEL4                    (*((volatile unsigned int*)(0x42A23D10UL)))
#define bM4_INTC_SEL99_INTSEL5                    (*((volatile unsigned int*)(0x42A23D14UL)))
#define bM4_INTC_SEL99_INTSEL6                    (*((volatile unsigned int*)(0x42A23D18UL)))
#define bM4_INTC_SEL99_INTSEL7                    (*((volatile unsigned int*)(0x42A23D1CUL)))
#define bM4_INTC_SEL99_INTSEL8                    (*((volatile unsigned int*)(0x42A23D20UL)))
#define bM4_INTC_SEL100_INTSEL0                   (*((volatile unsigned int*)(0x42A23D80UL)))
#define bM4_INTC_SEL100_INTSEL1                   (*((volatile unsigned int*)(0x42A23D84UL)))
#define bM4_INTC_SEL100_INTSEL2                   (*((volatile unsigned int*)(0x42A23D88UL)))
#define bM4_INTC_SEL100_INTSEL3                   (*((volatile unsigned int*)(0x42A23D8CUL)))
#define bM4_INTC_SEL100_INTSEL4                   (*((volatile unsigned int*)(0x42A23D90UL)))
#define bM4_INTC_SEL100_INTSEL5                   (*((volatile unsigned int*)(0x42A23D94UL)))
#define bM4_INTC_SEL100_INTSEL6                   (*((volatile unsigned int*)(0x42A23D98UL)))
#define bM4_INTC_SEL100_INTSEL7                   (*((volatile unsigned int*)(0x42A23D9CUL)))
#define bM4_INTC_SEL100_INTSEL8                   (*((volatile unsigned int*)(0x42A23DA0UL)))
#define bM4_INTC_SEL101_INTSEL0                   (*((volatile unsigned int*)(0x42A23E00UL)))
#define bM4_INTC_SEL101_INTSEL1                   (*((volatile unsigned int*)(0x42A23E04UL)))
#define bM4_INTC_SEL101_INTSEL2                   (*((volatile unsigned int*)(0x42A23E08UL)))
#define bM4_INTC_SEL101_INTSEL3                   (*((volatile unsigned int*)(0x42A23E0CUL)))
#define bM4_INTC_SEL101_INTSEL4                   (*((volatile unsigned int*)(0x42A23E10UL)))
#define bM4_INTC_SEL101_INTSEL5                   (*((volatile unsigned int*)(0x42A23E14UL)))
#define bM4_INTC_SEL101_INTSEL6                   (*((volatile unsigned int*)(0x42A23E18UL)))
#define bM4_INTC_SEL101_INTSEL7                   (*((volatile unsigned int*)(0x42A23E1CUL)))
#define bM4_INTC_SEL101_INTSEL8                   (*((volatile unsigned int*)(0x42A23E20UL)))
#define bM4_INTC_SEL102_INTSEL0                   (*((volatile unsigned int*)(0x42A23E80UL)))
#define bM4_INTC_SEL102_INTSEL1                   (*((volatile unsigned int*)(0x42A23E84UL)))
#define bM4_INTC_SEL102_INTSEL2                   (*((volatile unsigned int*)(0x42A23E88UL)))
#define bM4_INTC_SEL102_INTSEL3                   (*((volatile unsigned int*)(0x42A23E8CUL)))
#define bM4_INTC_SEL102_INTSEL4                   (*((volatile unsigned int*)(0x42A23E90UL)))
#define bM4_INTC_SEL102_INTSEL5                   (*((volatile unsigned int*)(0x42A23E94UL)))
#define bM4_INTC_SEL102_INTSEL6                   (*((volatile unsigned int*)(0x42A23E98UL)))
#define bM4_INTC_SEL102_INTSEL7                   (*((volatile unsigned int*)(0x42A23E9CUL)))
#define bM4_INTC_SEL102_INTSEL8                   (*((volatile unsigned int*)(0x42A23EA0UL)))
#define bM4_INTC_SEL103_INTSEL0                   (*((volatile unsigned int*)(0x42A23F00UL)))
#define bM4_INTC_SEL103_INTSEL1                   (*((volatile unsigned int*)(0x42A23F04UL)))
#define bM4_INTC_SEL103_INTSEL2                   (*((volatile unsigned int*)(0x42A23F08UL)))
#define bM4_INTC_SEL103_INTSEL3                   (*((volatile unsigned int*)(0x42A23F0CUL)))
#define bM4_INTC_SEL103_INTSEL4                   (*((volatile unsigned int*)(0x42A23F10UL)))
#define bM4_INTC_SEL103_INTSEL5                   (*((volatile unsigned int*)(0x42A23F14UL)))
#define bM4_INTC_SEL103_INTSEL6                   (*((volatile unsigned int*)(0x42A23F18UL)))
#define bM4_INTC_SEL103_INTSEL7                   (*((volatile unsigned int*)(0x42A23F1CUL)))
#define bM4_INTC_SEL103_INTSEL8                   (*((volatile unsigned int*)(0x42A23F20UL)))
#define bM4_INTC_SEL104_INTSEL0                   (*((volatile unsigned int*)(0x42A23F80UL)))
#define bM4_INTC_SEL104_INTSEL1                   (*((volatile unsigned int*)(0x42A23F84UL)))
#define bM4_INTC_SEL104_INTSEL2                   (*((volatile unsigned int*)(0x42A23F88UL)))
#define bM4_INTC_SEL104_INTSEL3                   (*((volatile unsigned int*)(0x42A23F8CUL)))
#define bM4_INTC_SEL104_INTSEL4                   (*((volatile unsigned int*)(0x42A23F90UL)))
#define bM4_INTC_SEL104_INTSEL5                   (*((volatile unsigned int*)(0x42A23F94UL)))
#define bM4_INTC_SEL104_INTSEL6                   (*((volatile unsigned int*)(0x42A23F98UL)))
#define bM4_INTC_SEL104_INTSEL7                   (*((volatile unsigned int*)(0x42A23F9CUL)))
#define bM4_INTC_SEL104_INTSEL8                   (*((volatile unsigned int*)(0x42A23FA0UL)))
#define bM4_INTC_SEL105_INTSEL0                   (*((volatile unsigned int*)(0x42A24000UL)))
#define bM4_INTC_SEL105_INTSEL1                   (*((volatile unsigned int*)(0x42A24004UL)))
#define bM4_INTC_SEL105_INTSEL2                   (*((volatile unsigned int*)(0x42A24008UL)))
#define bM4_INTC_SEL105_INTSEL3                   (*((volatile unsigned int*)(0x42A2400CUL)))
#define bM4_INTC_SEL105_INTSEL4                   (*((volatile unsigned int*)(0x42A24010UL)))
#define bM4_INTC_SEL105_INTSEL5                   (*((volatile unsigned int*)(0x42A24014UL)))
#define bM4_INTC_SEL105_INTSEL6                   (*((volatile unsigned int*)(0x42A24018UL)))
#define bM4_INTC_SEL105_INTSEL7                   (*((volatile unsigned int*)(0x42A2401CUL)))
#define bM4_INTC_SEL105_INTSEL8                   (*((volatile unsigned int*)(0x42A24020UL)))
#define bM4_INTC_SEL106_INTSEL0                   (*((volatile unsigned int*)(0x42A24080UL)))
#define bM4_INTC_SEL106_INTSEL1                   (*((volatile unsigned int*)(0x42A24084UL)))
#define bM4_INTC_SEL106_INTSEL2                   (*((volatile unsigned int*)(0x42A24088UL)))
#define bM4_INTC_SEL106_INTSEL3                   (*((volatile unsigned int*)(0x42A2408CUL)))
#define bM4_INTC_SEL106_INTSEL4                   (*((volatile unsigned int*)(0x42A24090UL)))
#define bM4_INTC_SEL106_INTSEL5                   (*((volatile unsigned int*)(0x42A24094UL)))
#define bM4_INTC_SEL106_INTSEL6                   (*((volatile unsigned int*)(0x42A24098UL)))
#define bM4_INTC_SEL106_INTSEL7                   (*((volatile unsigned int*)(0x42A2409CUL)))
#define bM4_INTC_SEL106_INTSEL8                   (*((volatile unsigned int*)(0x42A240A0UL)))
#define bM4_INTC_SEL107_INTSEL0                   (*((volatile unsigned int*)(0x42A24100UL)))
#define bM4_INTC_SEL107_INTSEL1                   (*((volatile unsigned int*)(0x42A24104UL)))
#define bM4_INTC_SEL107_INTSEL2                   (*((volatile unsigned int*)(0x42A24108UL)))
#define bM4_INTC_SEL107_INTSEL3                   (*((volatile unsigned int*)(0x42A2410CUL)))
#define bM4_INTC_SEL107_INTSEL4                   (*((volatile unsigned int*)(0x42A24110UL)))
#define bM4_INTC_SEL107_INTSEL5                   (*((volatile unsigned int*)(0x42A24114UL)))
#define bM4_INTC_SEL107_INTSEL6                   (*((volatile unsigned int*)(0x42A24118UL)))
#define bM4_INTC_SEL107_INTSEL7                   (*((volatile unsigned int*)(0x42A2411CUL)))
#define bM4_INTC_SEL107_INTSEL8                   (*((volatile unsigned int*)(0x42A24120UL)))
#define bM4_INTC_SEL108_INTSEL0                   (*((volatile unsigned int*)(0x42A24180UL)))
#define bM4_INTC_SEL108_INTSEL1                   (*((volatile unsigned int*)(0x42A24184UL)))
#define bM4_INTC_SEL108_INTSEL2                   (*((volatile unsigned int*)(0x42A24188UL)))
#define bM4_INTC_SEL108_INTSEL3                   (*((volatile unsigned int*)(0x42A2418CUL)))
#define bM4_INTC_SEL108_INTSEL4                   (*((volatile unsigned int*)(0x42A24190UL)))
#define bM4_INTC_SEL108_INTSEL5                   (*((volatile unsigned int*)(0x42A24194UL)))
#define bM4_INTC_SEL108_INTSEL6                   (*((volatile unsigned int*)(0x42A24198UL)))
#define bM4_INTC_SEL108_INTSEL7                   (*((volatile unsigned int*)(0x42A2419CUL)))
#define bM4_INTC_SEL108_INTSEL8                   (*((volatile unsigned int*)(0x42A241A0UL)))
#define bM4_INTC_SEL109_INTSEL0                   (*((volatile unsigned int*)(0x42A24200UL)))
#define bM4_INTC_SEL109_INTSEL1                   (*((volatile unsigned int*)(0x42A24204UL)))
#define bM4_INTC_SEL109_INTSEL2                   (*((volatile unsigned int*)(0x42A24208UL)))
#define bM4_INTC_SEL109_INTSEL3                   (*((volatile unsigned int*)(0x42A2420CUL)))
#define bM4_INTC_SEL109_INTSEL4                   (*((volatile unsigned int*)(0x42A24210UL)))
#define bM4_INTC_SEL109_INTSEL5                   (*((volatile unsigned int*)(0x42A24214UL)))
#define bM4_INTC_SEL109_INTSEL6                   (*((volatile unsigned int*)(0x42A24218UL)))
#define bM4_INTC_SEL109_INTSEL7                   (*((volatile unsigned int*)(0x42A2421CUL)))
#define bM4_INTC_SEL109_INTSEL8                   (*((volatile unsigned int*)(0x42A24220UL)))
#define bM4_INTC_SEL110_INTSEL0                   (*((volatile unsigned int*)(0x42A24280UL)))
#define bM4_INTC_SEL110_INTSEL1                   (*((volatile unsigned int*)(0x42A24284UL)))
#define bM4_INTC_SEL110_INTSEL2                   (*((volatile unsigned int*)(0x42A24288UL)))
#define bM4_INTC_SEL110_INTSEL3                   (*((volatile unsigned int*)(0x42A2428CUL)))
#define bM4_INTC_SEL110_INTSEL4                   (*((volatile unsigned int*)(0x42A24290UL)))
#define bM4_INTC_SEL110_INTSEL5                   (*((volatile unsigned int*)(0x42A24294UL)))
#define bM4_INTC_SEL110_INTSEL6                   (*((volatile unsigned int*)(0x42A24298UL)))
#define bM4_INTC_SEL110_INTSEL7                   (*((volatile unsigned int*)(0x42A2429CUL)))
#define bM4_INTC_SEL110_INTSEL8                   (*((volatile unsigned int*)(0x42A242A0UL)))
#define bM4_INTC_SEL111_INTSEL0                   (*((volatile unsigned int*)(0x42A24300UL)))
#define bM4_INTC_SEL111_INTSEL1                   (*((volatile unsigned int*)(0x42A24304UL)))
#define bM4_INTC_SEL111_INTSEL2                   (*((volatile unsigned int*)(0x42A24308UL)))
#define bM4_INTC_SEL111_INTSEL3                   (*((volatile unsigned int*)(0x42A2430CUL)))
#define bM4_INTC_SEL111_INTSEL4                   (*((volatile unsigned int*)(0x42A24310UL)))
#define bM4_INTC_SEL111_INTSEL5                   (*((volatile unsigned int*)(0x42A24314UL)))
#define bM4_INTC_SEL111_INTSEL6                   (*((volatile unsigned int*)(0x42A24318UL)))
#define bM4_INTC_SEL111_INTSEL7                   (*((volatile unsigned int*)(0x42A2431CUL)))
#define bM4_INTC_SEL111_INTSEL8                   (*((volatile unsigned int*)(0x42A24320UL)))
#define bM4_INTC_SEL112_INTSEL0                   (*((volatile unsigned int*)(0x42A24380UL)))
#define bM4_INTC_SEL112_INTSEL1                   (*((volatile unsigned int*)(0x42A24384UL)))
#define bM4_INTC_SEL112_INTSEL2                   (*((volatile unsigned int*)(0x42A24388UL)))
#define bM4_INTC_SEL112_INTSEL3                   (*((volatile unsigned int*)(0x42A2438CUL)))
#define bM4_INTC_SEL112_INTSEL4                   (*((volatile unsigned int*)(0x42A24390UL)))
#define bM4_INTC_SEL112_INTSEL5                   (*((volatile unsigned int*)(0x42A24394UL)))
#define bM4_INTC_SEL112_INTSEL6                   (*((volatile unsigned int*)(0x42A24398UL)))
#define bM4_INTC_SEL112_INTSEL7                   (*((volatile unsigned int*)(0x42A2439CUL)))
#define bM4_INTC_SEL112_INTSEL8                   (*((volatile unsigned int*)(0x42A243A0UL)))
#define bM4_INTC_SEL113_INTSEL0                   (*((volatile unsigned int*)(0x42A24400UL)))
#define bM4_INTC_SEL113_INTSEL1                   (*((volatile unsigned int*)(0x42A24404UL)))
#define bM4_INTC_SEL113_INTSEL2                   (*((volatile unsigned int*)(0x42A24408UL)))
#define bM4_INTC_SEL113_INTSEL3                   (*((volatile unsigned int*)(0x42A2440CUL)))
#define bM4_INTC_SEL113_INTSEL4                   (*((volatile unsigned int*)(0x42A24410UL)))
#define bM4_INTC_SEL113_INTSEL5                   (*((volatile unsigned int*)(0x42A24414UL)))
#define bM4_INTC_SEL113_INTSEL6                   (*((volatile unsigned int*)(0x42A24418UL)))
#define bM4_INTC_SEL113_INTSEL7                   (*((volatile unsigned int*)(0x42A2441CUL)))
#define bM4_INTC_SEL113_INTSEL8                   (*((volatile unsigned int*)(0x42A24420UL)))
#define bM4_INTC_SEL114_INTSEL0                   (*((volatile unsigned int*)(0x42A24480UL)))
#define bM4_INTC_SEL114_INTSEL1                   (*((volatile unsigned int*)(0x42A24484UL)))
#define bM4_INTC_SEL114_INTSEL2                   (*((volatile unsigned int*)(0x42A24488UL)))
#define bM4_INTC_SEL114_INTSEL3                   (*((volatile unsigned int*)(0x42A2448CUL)))
#define bM4_INTC_SEL114_INTSEL4                   (*((volatile unsigned int*)(0x42A24490UL)))
#define bM4_INTC_SEL114_INTSEL5                   (*((volatile unsigned int*)(0x42A24494UL)))
#define bM4_INTC_SEL114_INTSEL6                   (*((volatile unsigned int*)(0x42A24498UL)))
#define bM4_INTC_SEL114_INTSEL7                   (*((volatile unsigned int*)(0x42A2449CUL)))
#define bM4_INTC_SEL114_INTSEL8                   (*((volatile unsigned int*)(0x42A244A0UL)))
#define bM4_INTC_SEL115_INTSEL0                   (*((volatile unsigned int*)(0x42A24500UL)))
#define bM4_INTC_SEL115_INTSEL1                   (*((volatile unsigned int*)(0x42A24504UL)))
#define bM4_INTC_SEL115_INTSEL2                   (*((volatile unsigned int*)(0x42A24508UL)))
#define bM4_INTC_SEL115_INTSEL3                   (*((volatile unsigned int*)(0x42A2450CUL)))
#define bM4_INTC_SEL115_INTSEL4                   (*((volatile unsigned int*)(0x42A24510UL)))
#define bM4_INTC_SEL115_INTSEL5                   (*((volatile unsigned int*)(0x42A24514UL)))
#define bM4_INTC_SEL115_INTSEL6                   (*((volatile unsigned int*)(0x42A24518UL)))
#define bM4_INTC_SEL115_INTSEL7                   (*((volatile unsigned int*)(0x42A2451CUL)))
#define bM4_INTC_SEL115_INTSEL8                   (*((volatile unsigned int*)(0x42A24520UL)))
#define bM4_INTC_SEL116_INTSEL0                   (*((volatile unsigned int*)(0x42A24580UL)))
#define bM4_INTC_SEL116_INTSEL1                   (*((volatile unsigned int*)(0x42A24584UL)))
#define bM4_INTC_SEL116_INTSEL2                   (*((volatile unsigned int*)(0x42A24588UL)))
#define bM4_INTC_SEL116_INTSEL3                   (*((volatile unsigned int*)(0x42A2458CUL)))
#define bM4_INTC_SEL116_INTSEL4                   (*((volatile unsigned int*)(0x42A24590UL)))
#define bM4_INTC_SEL116_INTSEL5                   (*((volatile unsigned int*)(0x42A24594UL)))
#define bM4_INTC_SEL116_INTSEL6                   (*((volatile unsigned int*)(0x42A24598UL)))
#define bM4_INTC_SEL116_INTSEL7                   (*((volatile unsigned int*)(0x42A2459CUL)))
#define bM4_INTC_SEL116_INTSEL8                   (*((volatile unsigned int*)(0x42A245A0UL)))
#define bM4_INTC_SEL117_INTSEL0                   (*((volatile unsigned int*)(0x42A24600UL)))
#define bM4_INTC_SEL117_INTSEL1                   (*((volatile unsigned int*)(0x42A24604UL)))
#define bM4_INTC_SEL117_INTSEL2                   (*((volatile unsigned int*)(0x42A24608UL)))
#define bM4_INTC_SEL117_INTSEL3                   (*((volatile unsigned int*)(0x42A2460CUL)))
#define bM4_INTC_SEL117_INTSEL4                   (*((volatile unsigned int*)(0x42A24610UL)))
#define bM4_INTC_SEL117_INTSEL5                   (*((volatile unsigned int*)(0x42A24614UL)))
#define bM4_INTC_SEL117_INTSEL6                   (*((volatile unsigned int*)(0x42A24618UL)))
#define bM4_INTC_SEL117_INTSEL7                   (*((volatile unsigned int*)(0x42A2461CUL)))
#define bM4_INTC_SEL117_INTSEL8                   (*((volatile unsigned int*)(0x42A24620UL)))
#define bM4_INTC_SEL118_INTSEL0                   (*((volatile unsigned int*)(0x42A24680UL)))
#define bM4_INTC_SEL118_INTSEL1                   (*((volatile unsigned int*)(0x42A24684UL)))
#define bM4_INTC_SEL118_INTSEL2                   (*((volatile unsigned int*)(0x42A24688UL)))
#define bM4_INTC_SEL118_INTSEL3                   (*((volatile unsigned int*)(0x42A2468CUL)))
#define bM4_INTC_SEL118_INTSEL4                   (*((volatile unsigned int*)(0x42A24690UL)))
#define bM4_INTC_SEL118_INTSEL5                   (*((volatile unsigned int*)(0x42A24694UL)))
#define bM4_INTC_SEL118_INTSEL6                   (*((volatile unsigned int*)(0x42A24698UL)))
#define bM4_INTC_SEL118_INTSEL7                   (*((volatile unsigned int*)(0x42A2469CUL)))
#define bM4_INTC_SEL118_INTSEL8                   (*((volatile unsigned int*)(0x42A246A0UL)))
#define bM4_INTC_SEL119_INTSEL0                   (*((volatile unsigned int*)(0x42A24700UL)))
#define bM4_INTC_SEL119_INTSEL1                   (*((volatile unsigned int*)(0x42A24704UL)))
#define bM4_INTC_SEL119_INTSEL2                   (*((volatile unsigned int*)(0x42A24708UL)))
#define bM4_INTC_SEL119_INTSEL3                   (*((volatile unsigned int*)(0x42A2470CUL)))
#define bM4_INTC_SEL119_INTSEL4                   (*((volatile unsigned int*)(0x42A24710UL)))
#define bM4_INTC_SEL119_INTSEL5                   (*((volatile unsigned int*)(0x42A24714UL)))
#define bM4_INTC_SEL119_INTSEL6                   (*((volatile unsigned int*)(0x42A24718UL)))
#define bM4_INTC_SEL119_INTSEL7                   (*((volatile unsigned int*)(0x42A2471CUL)))
#define bM4_INTC_SEL119_INTSEL8                   (*((volatile unsigned int*)(0x42A24720UL)))
#define bM4_INTC_SEL120_INTSEL0                   (*((volatile unsigned int*)(0x42A24780UL)))
#define bM4_INTC_SEL120_INTSEL1                   (*((volatile unsigned int*)(0x42A24784UL)))
#define bM4_INTC_SEL120_INTSEL2                   (*((volatile unsigned int*)(0x42A24788UL)))
#define bM4_INTC_SEL120_INTSEL3                   (*((volatile unsigned int*)(0x42A2478CUL)))
#define bM4_INTC_SEL120_INTSEL4                   (*((volatile unsigned int*)(0x42A24790UL)))
#define bM4_INTC_SEL120_INTSEL5                   (*((volatile unsigned int*)(0x42A24794UL)))
#define bM4_INTC_SEL120_INTSEL6                   (*((volatile unsigned int*)(0x42A24798UL)))
#define bM4_INTC_SEL120_INTSEL7                   (*((volatile unsigned int*)(0x42A2479CUL)))
#define bM4_INTC_SEL120_INTSEL8                   (*((volatile unsigned int*)(0x42A247A0UL)))
#define bM4_INTC_SEL121_INTSEL0                   (*((volatile unsigned int*)(0x42A24800UL)))
#define bM4_INTC_SEL121_INTSEL1                   (*((volatile unsigned int*)(0x42A24804UL)))
#define bM4_INTC_SEL121_INTSEL2                   (*((volatile unsigned int*)(0x42A24808UL)))
#define bM4_INTC_SEL121_INTSEL3                   (*((volatile unsigned int*)(0x42A2480CUL)))
#define bM4_INTC_SEL121_INTSEL4                   (*((volatile unsigned int*)(0x42A24810UL)))
#define bM4_INTC_SEL121_INTSEL5                   (*((volatile unsigned int*)(0x42A24814UL)))
#define bM4_INTC_SEL121_INTSEL6                   (*((volatile unsigned int*)(0x42A24818UL)))
#define bM4_INTC_SEL121_INTSEL7                   (*((volatile unsigned int*)(0x42A2481CUL)))
#define bM4_INTC_SEL121_INTSEL8                   (*((volatile unsigned int*)(0x42A24820UL)))
#define bM4_INTC_SEL122_INTSEL0                   (*((volatile unsigned int*)(0x42A24880UL)))
#define bM4_INTC_SEL122_INTSEL1                   (*((volatile unsigned int*)(0x42A24884UL)))
#define bM4_INTC_SEL122_INTSEL2                   (*((volatile unsigned int*)(0x42A24888UL)))
#define bM4_INTC_SEL122_INTSEL3                   (*((volatile unsigned int*)(0x42A2488CUL)))
#define bM4_INTC_SEL122_INTSEL4                   (*((volatile unsigned int*)(0x42A24890UL)))
#define bM4_INTC_SEL122_INTSEL5                   (*((volatile unsigned int*)(0x42A24894UL)))
#define bM4_INTC_SEL122_INTSEL6                   (*((volatile unsigned int*)(0x42A24898UL)))
#define bM4_INTC_SEL122_INTSEL7                   (*((volatile unsigned int*)(0x42A2489CUL)))
#define bM4_INTC_SEL122_INTSEL8                   (*((volatile unsigned int*)(0x42A248A0UL)))
#define bM4_INTC_SEL123_INTSEL0                   (*((volatile unsigned int*)(0x42A24900UL)))
#define bM4_INTC_SEL123_INTSEL1                   (*((volatile unsigned int*)(0x42A24904UL)))
#define bM4_INTC_SEL123_INTSEL2                   (*((volatile unsigned int*)(0x42A24908UL)))
#define bM4_INTC_SEL123_INTSEL3                   (*((volatile unsigned int*)(0x42A2490CUL)))
#define bM4_INTC_SEL123_INTSEL4                   (*((volatile unsigned int*)(0x42A24910UL)))
#define bM4_INTC_SEL123_INTSEL5                   (*((volatile unsigned int*)(0x42A24914UL)))
#define bM4_INTC_SEL123_INTSEL6                   (*((volatile unsigned int*)(0x42A24918UL)))
#define bM4_INTC_SEL123_INTSEL7                   (*((volatile unsigned int*)(0x42A2491CUL)))
#define bM4_INTC_SEL123_INTSEL8                   (*((volatile unsigned int*)(0x42A24920UL)))
#define bM4_INTC_SEL124_INTSEL0                   (*((volatile unsigned int*)(0x42A24980UL)))
#define bM4_INTC_SEL124_INTSEL1                   (*((volatile unsigned int*)(0x42A24984UL)))
#define bM4_INTC_SEL124_INTSEL2                   (*((volatile unsigned int*)(0x42A24988UL)))
#define bM4_INTC_SEL124_INTSEL3                   (*((volatile unsigned int*)(0x42A2498CUL)))
#define bM4_INTC_SEL124_INTSEL4                   (*((volatile unsigned int*)(0x42A24990UL)))
#define bM4_INTC_SEL124_INTSEL5                   (*((volatile unsigned int*)(0x42A24994UL)))
#define bM4_INTC_SEL124_INTSEL6                   (*((volatile unsigned int*)(0x42A24998UL)))
#define bM4_INTC_SEL124_INTSEL7                   (*((volatile unsigned int*)(0x42A2499CUL)))
#define bM4_INTC_SEL124_INTSEL8                   (*((volatile unsigned int*)(0x42A249A0UL)))
#define bM4_INTC_SEL125_INTSEL0                   (*((volatile unsigned int*)(0x42A24A00UL)))
#define bM4_INTC_SEL125_INTSEL1                   (*((volatile unsigned int*)(0x42A24A04UL)))
#define bM4_INTC_SEL125_INTSEL2                   (*((volatile unsigned int*)(0x42A24A08UL)))
#define bM4_INTC_SEL125_INTSEL3                   (*((volatile unsigned int*)(0x42A24A0CUL)))
#define bM4_INTC_SEL125_INTSEL4                   (*((volatile unsigned int*)(0x42A24A10UL)))
#define bM4_INTC_SEL125_INTSEL5                   (*((volatile unsigned int*)(0x42A24A14UL)))
#define bM4_INTC_SEL125_INTSEL6                   (*((volatile unsigned int*)(0x42A24A18UL)))
#define bM4_INTC_SEL125_INTSEL7                   (*((volatile unsigned int*)(0x42A24A1CUL)))
#define bM4_INTC_SEL125_INTSEL8                   (*((volatile unsigned int*)(0x42A24A20UL)))
#define bM4_INTC_SEL126_INTSEL0                   (*((volatile unsigned int*)(0x42A24A80UL)))
#define bM4_INTC_SEL126_INTSEL1                   (*((volatile unsigned int*)(0x42A24A84UL)))
#define bM4_INTC_SEL126_INTSEL2                   (*((volatile unsigned int*)(0x42A24A88UL)))
#define bM4_INTC_SEL126_INTSEL3                   (*((volatile unsigned int*)(0x42A24A8CUL)))
#define bM4_INTC_SEL126_INTSEL4                   (*((volatile unsigned int*)(0x42A24A90UL)))
#define bM4_INTC_SEL126_INTSEL5                   (*((volatile unsigned int*)(0x42A24A94UL)))
#define bM4_INTC_SEL126_INTSEL6                   (*((volatile unsigned int*)(0x42A24A98UL)))
#define bM4_INTC_SEL126_INTSEL7                   (*((volatile unsigned int*)(0x42A24A9CUL)))
#define bM4_INTC_SEL126_INTSEL8                   (*((volatile unsigned int*)(0x42A24AA0UL)))
#define bM4_INTC_SEL127_INTSEL0                   (*((volatile unsigned int*)(0x42A24B00UL)))
#define bM4_INTC_SEL127_INTSEL1                   (*((volatile unsigned int*)(0x42A24B04UL)))
#define bM4_INTC_SEL127_INTSEL2                   (*((volatile unsigned int*)(0x42A24B08UL)))
#define bM4_INTC_SEL127_INTSEL3                   (*((volatile unsigned int*)(0x42A24B0CUL)))
#define bM4_INTC_SEL127_INTSEL4                   (*((volatile unsigned int*)(0x42A24B10UL)))
#define bM4_INTC_SEL127_INTSEL5                   (*((volatile unsigned int*)(0x42A24B14UL)))
#define bM4_INTC_SEL127_INTSEL6                   (*((volatile unsigned int*)(0x42A24B18UL)))
#define bM4_INTC_SEL127_INTSEL7                   (*((volatile unsigned int*)(0x42A24B1CUL)))
#define bM4_INTC_SEL127_INTSEL8                   (*((volatile unsigned int*)(0x42A24B20UL)))
#define bM4_INTC_VSSEL128_VSEL0                   (*((volatile unsigned int*)(0x42A24B80UL)))
#define bM4_INTC_VSSEL128_VSEL1                   (*((volatile unsigned int*)(0x42A24B84UL)))
#define bM4_INTC_VSSEL128_VSEL2                   (*((volatile unsigned int*)(0x42A24B88UL)))
#define bM4_INTC_VSSEL128_VSEL3                   (*((volatile unsigned int*)(0x42A24B8CUL)))
#define bM4_INTC_VSSEL128_VSEL4                   (*((volatile unsigned int*)(0x42A24B90UL)))
#define bM4_INTC_VSSEL128_VSEL5                   (*((volatile unsigned int*)(0x42A24B94UL)))
#define bM4_INTC_VSSEL128_VSEL6                   (*((volatile unsigned int*)(0x42A24B98UL)))
#define bM4_INTC_VSSEL128_VSEL7                   (*((volatile unsigned int*)(0x42A24B9CUL)))
#define bM4_INTC_VSSEL128_VSEL8                   (*((volatile unsigned int*)(0x42A24BA0UL)))
#define bM4_INTC_VSSEL128_VSEL9                   (*((volatile unsigned int*)(0x42A24BA4UL)))
#define bM4_INTC_VSSEL128_VSEL10                  (*((volatile unsigned int*)(0x42A24BA8UL)))
#define bM4_INTC_VSSEL128_VSEL11                  (*((volatile unsigned int*)(0x42A24BACUL)))
#define bM4_INTC_VSSEL128_VSEL12                  (*((volatile unsigned int*)(0x42A24BB0UL)))
#define bM4_INTC_VSSEL128_VSEL13                  (*((volatile unsigned int*)(0x42A24BB4UL)))
#define bM4_INTC_VSSEL128_VSEL14                  (*((volatile unsigned int*)(0x42A24BB8UL)))
#define bM4_INTC_VSSEL128_VSEL15                  (*((volatile unsigned int*)(0x42A24BBCUL)))
#define bM4_INTC_VSSEL128_VSEL16                  (*((volatile unsigned int*)(0x42A24BC0UL)))
#define bM4_INTC_VSSEL128_VSEL17                  (*((volatile unsigned int*)(0x42A24BC4UL)))
#define bM4_INTC_VSSEL128_VSEL18                  (*((volatile unsigned int*)(0x42A24BC8UL)))
#define bM4_INTC_VSSEL128_VSEL19                  (*((volatile unsigned int*)(0x42A24BCCUL)))
#define bM4_INTC_VSSEL128_VSEL20                  (*((volatile unsigned int*)(0x42A24BD0UL)))
#define bM4_INTC_VSSEL128_VSEL21                  (*((volatile unsigned int*)(0x42A24BD4UL)))
#define bM4_INTC_VSSEL128_VSEL22                  (*((volatile unsigned int*)(0x42A24BD8UL)))
#define bM4_INTC_VSSEL128_VSEL23                  (*((volatile unsigned int*)(0x42A24BDCUL)))
#define bM4_INTC_VSSEL128_VSEL24                  (*((volatile unsigned int*)(0x42A24BE0UL)))
#define bM4_INTC_VSSEL128_VSEL25                  (*((volatile unsigned int*)(0x42A24BE4UL)))
#define bM4_INTC_VSSEL128_VSEL26                  (*((volatile unsigned int*)(0x42A24BE8UL)))
#define bM4_INTC_VSSEL128_VSEL27                  (*((volatile unsigned int*)(0x42A24BECUL)))
#define bM4_INTC_VSSEL128_VSEL28                  (*((volatile unsigned int*)(0x42A24BF0UL)))
#define bM4_INTC_VSSEL128_VSEL29                  (*((volatile unsigned int*)(0x42A24BF4UL)))
#define bM4_INTC_VSSEL128_VSEL30                  (*((volatile unsigned int*)(0x42A24BF8UL)))
#define bM4_INTC_VSSEL128_VSEL31                  (*((volatile unsigned int*)(0x42A24BFCUL)))
#define bM4_INTC_VSSEL129_VSEL0                   (*((volatile unsigned int*)(0x42A24C00UL)))
#define bM4_INTC_VSSEL129_VSEL1                   (*((volatile unsigned int*)(0x42A24C04UL)))
#define bM4_INTC_VSSEL129_VSEL2                   (*((volatile unsigned int*)(0x42A24C08UL)))
#define bM4_INTC_VSSEL129_VSEL3                   (*((volatile unsigned int*)(0x42A24C0CUL)))
#define bM4_INTC_VSSEL129_VSEL4                   (*((volatile unsigned int*)(0x42A24C10UL)))
#define bM4_INTC_VSSEL129_VSEL5                   (*((volatile unsigned int*)(0x42A24C14UL)))
#define bM4_INTC_VSSEL129_VSEL6                   (*((volatile unsigned int*)(0x42A24C18UL)))
#define bM4_INTC_VSSEL129_VSEL7                   (*((volatile unsigned int*)(0x42A24C1CUL)))
#define bM4_INTC_VSSEL129_VSEL8                   (*((volatile unsigned int*)(0x42A24C20UL)))
#define bM4_INTC_VSSEL129_VSEL9                   (*((volatile unsigned int*)(0x42A24C24UL)))
#define bM4_INTC_VSSEL129_VSEL10                  (*((volatile unsigned int*)(0x42A24C28UL)))
#define bM4_INTC_VSSEL129_VSEL11                  (*((volatile unsigned int*)(0x42A24C2CUL)))
#define bM4_INTC_VSSEL129_VSEL12                  (*((volatile unsigned int*)(0x42A24C30UL)))
#define bM4_INTC_VSSEL129_VSEL13                  (*((volatile unsigned int*)(0x42A24C34UL)))
#define bM4_INTC_VSSEL129_VSEL14                  (*((volatile unsigned int*)(0x42A24C38UL)))
#define bM4_INTC_VSSEL129_VSEL15                  (*((volatile unsigned int*)(0x42A24C3CUL)))
#define bM4_INTC_VSSEL129_VSEL16                  (*((volatile unsigned int*)(0x42A24C40UL)))
#define bM4_INTC_VSSEL129_VSEL17                  (*((volatile unsigned int*)(0x42A24C44UL)))
#define bM4_INTC_VSSEL129_VSEL18                  (*((volatile unsigned int*)(0x42A24C48UL)))
#define bM4_INTC_VSSEL129_VSEL19                  (*((volatile unsigned int*)(0x42A24C4CUL)))
#define bM4_INTC_VSSEL129_VSEL20                  (*((volatile unsigned int*)(0x42A24C50UL)))
#define bM4_INTC_VSSEL129_VSEL21                  (*((volatile unsigned int*)(0x42A24C54UL)))
#define bM4_INTC_VSSEL129_VSEL22                  (*((volatile unsigned int*)(0x42A24C58UL)))
#define bM4_INTC_VSSEL129_VSEL23                  (*((volatile unsigned int*)(0x42A24C5CUL)))
#define bM4_INTC_VSSEL129_VSEL24                  (*((volatile unsigned int*)(0x42A24C60UL)))
#define bM4_INTC_VSSEL129_VSEL25                  (*((volatile unsigned int*)(0x42A24C64UL)))
#define bM4_INTC_VSSEL129_VSEL26                  (*((volatile unsigned int*)(0x42A24C68UL)))
#define bM4_INTC_VSSEL129_VSEL27                  (*((volatile unsigned int*)(0x42A24C6CUL)))
#define bM4_INTC_VSSEL129_VSEL28                  (*((volatile unsigned int*)(0x42A24C70UL)))
#define bM4_INTC_VSSEL129_VSEL29                  (*((volatile unsigned int*)(0x42A24C74UL)))
#define bM4_INTC_VSSEL129_VSEL30                  (*((volatile unsigned int*)(0x42A24C78UL)))
#define bM4_INTC_VSSEL129_VSEL31                  (*((volatile unsigned int*)(0x42A24C7CUL)))
#define bM4_INTC_VSSEL130_VSEL0                   (*((volatile unsigned int*)(0x42A24C80UL)))
#define bM4_INTC_VSSEL130_VSEL1                   (*((volatile unsigned int*)(0x42A24C84UL)))
#define bM4_INTC_VSSEL130_VSEL2                   (*((volatile unsigned int*)(0x42A24C88UL)))
#define bM4_INTC_VSSEL130_VSEL3                   (*((volatile unsigned int*)(0x42A24C8CUL)))
#define bM4_INTC_VSSEL130_VSEL4                   (*((volatile unsigned int*)(0x42A24C90UL)))
#define bM4_INTC_VSSEL130_VSEL5                   (*((volatile unsigned int*)(0x42A24C94UL)))
#define bM4_INTC_VSSEL130_VSEL6                   (*((volatile unsigned int*)(0x42A24C98UL)))
#define bM4_INTC_VSSEL130_VSEL7                   (*((volatile unsigned int*)(0x42A24C9CUL)))
#define bM4_INTC_VSSEL130_VSEL8                   (*((volatile unsigned int*)(0x42A24CA0UL)))
#define bM4_INTC_VSSEL130_VSEL9                   (*((volatile unsigned int*)(0x42A24CA4UL)))
#define bM4_INTC_VSSEL130_VSEL10                  (*((volatile unsigned int*)(0x42A24CA8UL)))
#define bM4_INTC_VSSEL130_VSEL11                  (*((volatile unsigned int*)(0x42A24CACUL)))
#define bM4_INTC_VSSEL130_VSEL12                  (*((volatile unsigned int*)(0x42A24CB0UL)))
#define bM4_INTC_VSSEL130_VSEL13                  (*((volatile unsigned int*)(0x42A24CB4UL)))
#define bM4_INTC_VSSEL130_VSEL14                  (*((volatile unsigned int*)(0x42A24CB8UL)))
#define bM4_INTC_VSSEL130_VSEL15                  (*((volatile unsigned int*)(0x42A24CBCUL)))
#define bM4_INTC_VSSEL130_VSEL16                  (*((volatile unsigned int*)(0x42A24CC0UL)))
#define bM4_INTC_VSSEL130_VSEL17                  (*((volatile unsigned int*)(0x42A24CC4UL)))
#define bM4_INTC_VSSEL130_VSEL18                  (*((volatile unsigned int*)(0x42A24CC8UL)))
#define bM4_INTC_VSSEL130_VSEL19                  (*((volatile unsigned int*)(0x42A24CCCUL)))
#define bM4_INTC_VSSEL130_VSEL20                  (*((volatile unsigned int*)(0x42A24CD0UL)))
#define bM4_INTC_VSSEL130_VSEL21                  (*((volatile unsigned int*)(0x42A24CD4UL)))
#define bM4_INTC_VSSEL130_VSEL22                  (*((volatile unsigned int*)(0x42A24CD8UL)))
#define bM4_INTC_VSSEL130_VSEL23                  (*((volatile unsigned int*)(0x42A24CDCUL)))
#define bM4_INTC_VSSEL130_VSEL24                  (*((volatile unsigned int*)(0x42A24CE0UL)))
#define bM4_INTC_VSSEL130_VSEL25                  (*((volatile unsigned int*)(0x42A24CE4UL)))
#define bM4_INTC_VSSEL130_VSEL26                  (*((volatile unsigned int*)(0x42A24CE8UL)))
#define bM4_INTC_VSSEL130_VSEL27                  (*((volatile unsigned int*)(0x42A24CECUL)))
#define bM4_INTC_VSSEL130_VSEL28                  (*((volatile unsigned int*)(0x42A24CF0UL)))
#define bM4_INTC_VSSEL130_VSEL29                  (*((volatile unsigned int*)(0x42A24CF4UL)))
#define bM4_INTC_VSSEL130_VSEL30                  (*((volatile unsigned int*)(0x42A24CF8UL)))
#define bM4_INTC_VSSEL130_VSEL31                  (*((volatile unsigned int*)(0x42A24CFCUL)))
#define bM4_INTC_VSSEL131_VSEL0                   (*((volatile unsigned int*)(0x42A24D00UL)))
#define bM4_INTC_VSSEL131_VSEL1                   (*((volatile unsigned int*)(0x42A24D04UL)))
#define bM4_INTC_VSSEL131_VSEL2                   (*((volatile unsigned int*)(0x42A24D08UL)))
#define bM4_INTC_VSSEL131_VSEL3                   (*((volatile unsigned int*)(0x42A24D0CUL)))
#define bM4_INTC_VSSEL131_VSEL4                   (*((volatile unsigned int*)(0x42A24D10UL)))
#define bM4_INTC_VSSEL131_VSEL5                   (*((volatile unsigned int*)(0x42A24D14UL)))
#define bM4_INTC_VSSEL131_VSEL6                   (*((volatile unsigned int*)(0x42A24D18UL)))
#define bM4_INTC_VSSEL131_VSEL7                   (*((volatile unsigned int*)(0x42A24D1CUL)))
#define bM4_INTC_VSSEL131_VSEL8                   (*((volatile unsigned int*)(0x42A24D20UL)))
#define bM4_INTC_VSSEL131_VSEL9                   (*((volatile unsigned int*)(0x42A24D24UL)))
#define bM4_INTC_VSSEL131_VSEL10                  (*((volatile unsigned int*)(0x42A24D28UL)))
#define bM4_INTC_VSSEL131_VSEL11                  (*((volatile unsigned int*)(0x42A24D2CUL)))
#define bM4_INTC_VSSEL131_VSEL12                  (*((volatile unsigned int*)(0x42A24D30UL)))
#define bM4_INTC_VSSEL131_VSEL13                  (*((volatile unsigned int*)(0x42A24D34UL)))
#define bM4_INTC_VSSEL131_VSEL14                  (*((volatile unsigned int*)(0x42A24D38UL)))
#define bM4_INTC_VSSEL131_VSEL15                  (*((volatile unsigned int*)(0x42A24D3CUL)))
#define bM4_INTC_VSSEL131_VSEL16                  (*((volatile unsigned int*)(0x42A24D40UL)))
#define bM4_INTC_VSSEL131_VSEL17                  (*((volatile unsigned int*)(0x42A24D44UL)))
#define bM4_INTC_VSSEL131_VSEL18                  (*((volatile unsigned int*)(0x42A24D48UL)))
#define bM4_INTC_VSSEL131_VSEL19                  (*((volatile unsigned int*)(0x42A24D4CUL)))
#define bM4_INTC_VSSEL131_VSEL20                  (*((volatile unsigned int*)(0x42A24D50UL)))
#define bM4_INTC_VSSEL131_VSEL21                  (*((volatile unsigned int*)(0x42A24D54UL)))
#define bM4_INTC_VSSEL131_VSEL22                  (*((volatile unsigned int*)(0x42A24D58UL)))
#define bM4_INTC_VSSEL131_VSEL23                  (*((volatile unsigned int*)(0x42A24D5CUL)))
#define bM4_INTC_VSSEL131_VSEL24                  (*((volatile unsigned int*)(0x42A24D60UL)))
#define bM4_INTC_VSSEL131_VSEL25                  (*((volatile unsigned int*)(0x42A24D64UL)))
#define bM4_INTC_VSSEL131_VSEL26                  (*((volatile unsigned int*)(0x42A24D68UL)))
#define bM4_INTC_VSSEL131_VSEL27                  (*((volatile unsigned int*)(0x42A24D6CUL)))
#define bM4_INTC_VSSEL131_VSEL28                  (*((volatile unsigned int*)(0x42A24D70UL)))
#define bM4_INTC_VSSEL131_VSEL29                  (*((volatile unsigned int*)(0x42A24D74UL)))
#define bM4_INTC_VSSEL131_VSEL30                  (*((volatile unsigned int*)(0x42A24D78UL)))
#define bM4_INTC_VSSEL131_VSEL31                  (*((volatile unsigned int*)(0x42A24D7CUL)))
#define bM4_INTC_VSSEL132_VSEL0                   (*((volatile unsigned int*)(0x42A24D80UL)))
#define bM4_INTC_VSSEL132_VSEL1                   (*((volatile unsigned int*)(0x42A24D84UL)))
#define bM4_INTC_VSSEL132_VSEL2                   (*((volatile unsigned int*)(0x42A24D88UL)))
#define bM4_INTC_VSSEL132_VSEL3                   (*((volatile unsigned int*)(0x42A24D8CUL)))
#define bM4_INTC_VSSEL132_VSEL4                   (*((volatile unsigned int*)(0x42A24D90UL)))
#define bM4_INTC_VSSEL132_VSEL5                   (*((volatile unsigned int*)(0x42A24D94UL)))
#define bM4_INTC_VSSEL132_VSEL6                   (*((volatile unsigned int*)(0x42A24D98UL)))
#define bM4_INTC_VSSEL132_VSEL7                   (*((volatile unsigned int*)(0x42A24D9CUL)))
#define bM4_INTC_VSSEL132_VSEL8                   (*((volatile unsigned int*)(0x42A24DA0UL)))
#define bM4_INTC_VSSEL132_VSEL9                   (*((volatile unsigned int*)(0x42A24DA4UL)))
#define bM4_INTC_VSSEL132_VSEL10                  (*((volatile unsigned int*)(0x42A24DA8UL)))
#define bM4_INTC_VSSEL132_VSEL11                  (*((volatile unsigned int*)(0x42A24DACUL)))
#define bM4_INTC_VSSEL132_VSEL12                  (*((volatile unsigned int*)(0x42A24DB0UL)))
#define bM4_INTC_VSSEL132_VSEL13                  (*((volatile unsigned int*)(0x42A24DB4UL)))
#define bM4_INTC_VSSEL132_VSEL14                  (*((volatile unsigned int*)(0x42A24DB8UL)))
#define bM4_INTC_VSSEL132_VSEL15                  (*((volatile unsigned int*)(0x42A24DBCUL)))
#define bM4_INTC_VSSEL132_VSEL16                  (*((volatile unsigned int*)(0x42A24DC0UL)))
#define bM4_INTC_VSSEL132_VSEL17                  (*((volatile unsigned int*)(0x42A24DC4UL)))
#define bM4_INTC_VSSEL132_VSEL18                  (*((volatile unsigned int*)(0x42A24DC8UL)))
#define bM4_INTC_VSSEL132_VSEL19                  (*((volatile unsigned int*)(0x42A24DCCUL)))
#define bM4_INTC_VSSEL132_VSEL20                  (*((volatile unsigned int*)(0x42A24DD0UL)))
#define bM4_INTC_VSSEL132_VSEL21                  (*((volatile unsigned int*)(0x42A24DD4UL)))
#define bM4_INTC_VSSEL132_VSEL22                  (*((volatile unsigned int*)(0x42A24DD8UL)))
#define bM4_INTC_VSSEL132_VSEL23                  (*((volatile unsigned int*)(0x42A24DDCUL)))
#define bM4_INTC_VSSEL132_VSEL24                  (*((volatile unsigned int*)(0x42A24DE0UL)))
#define bM4_INTC_VSSEL132_VSEL25                  (*((volatile unsigned int*)(0x42A24DE4UL)))
#define bM4_INTC_VSSEL132_VSEL26                  (*((volatile unsigned int*)(0x42A24DE8UL)))
#define bM4_INTC_VSSEL132_VSEL27                  (*((volatile unsigned int*)(0x42A24DECUL)))
#define bM4_INTC_VSSEL132_VSEL28                  (*((volatile unsigned int*)(0x42A24DF0UL)))
#define bM4_INTC_VSSEL132_VSEL29                  (*((volatile unsigned int*)(0x42A24DF4UL)))
#define bM4_INTC_VSSEL132_VSEL30                  (*((volatile unsigned int*)(0x42A24DF8UL)))
#define bM4_INTC_VSSEL132_VSEL31                  (*((volatile unsigned int*)(0x42A24DFCUL)))
#define bM4_INTC_VSSEL133_VSEL0                   (*((volatile unsigned int*)(0x42A24E00UL)))
#define bM4_INTC_VSSEL133_VSEL1                   (*((volatile unsigned int*)(0x42A24E04UL)))
#define bM4_INTC_VSSEL133_VSEL2                   (*((volatile unsigned int*)(0x42A24E08UL)))
#define bM4_INTC_VSSEL133_VSEL3                   (*((volatile unsigned int*)(0x42A24E0CUL)))
#define bM4_INTC_VSSEL133_VSEL4                   (*((volatile unsigned int*)(0x42A24E10UL)))
#define bM4_INTC_VSSEL133_VSEL5                   (*((volatile unsigned int*)(0x42A24E14UL)))
#define bM4_INTC_VSSEL133_VSEL6                   (*((volatile unsigned int*)(0x42A24E18UL)))
#define bM4_INTC_VSSEL133_VSEL7                   (*((volatile unsigned int*)(0x42A24E1CUL)))
#define bM4_INTC_VSSEL133_VSEL8                   (*((volatile unsigned int*)(0x42A24E20UL)))
#define bM4_INTC_VSSEL133_VSEL9                   (*((volatile unsigned int*)(0x42A24E24UL)))
#define bM4_INTC_VSSEL133_VSEL10                  (*((volatile unsigned int*)(0x42A24E28UL)))
#define bM4_INTC_VSSEL133_VSEL11                  (*((volatile unsigned int*)(0x42A24E2CUL)))
#define bM4_INTC_VSSEL133_VSEL12                  (*((volatile unsigned int*)(0x42A24E30UL)))
#define bM4_INTC_VSSEL133_VSEL13                  (*((volatile unsigned int*)(0x42A24E34UL)))
#define bM4_INTC_VSSEL133_VSEL14                  (*((volatile unsigned int*)(0x42A24E38UL)))
#define bM4_INTC_VSSEL133_VSEL15                  (*((volatile unsigned int*)(0x42A24E3CUL)))
#define bM4_INTC_VSSEL133_VSEL16                  (*((volatile unsigned int*)(0x42A24E40UL)))
#define bM4_INTC_VSSEL133_VSEL17                  (*((volatile unsigned int*)(0x42A24E44UL)))
#define bM4_INTC_VSSEL133_VSEL18                  (*((volatile unsigned int*)(0x42A24E48UL)))
#define bM4_INTC_VSSEL133_VSEL19                  (*((volatile unsigned int*)(0x42A24E4CUL)))
#define bM4_INTC_VSSEL133_VSEL20                  (*((volatile unsigned int*)(0x42A24E50UL)))
#define bM4_INTC_VSSEL133_VSEL21                  (*((volatile unsigned int*)(0x42A24E54UL)))
#define bM4_INTC_VSSEL133_VSEL22                  (*((volatile unsigned int*)(0x42A24E58UL)))
#define bM4_INTC_VSSEL133_VSEL23                  (*((volatile unsigned int*)(0x42A24E5CUL)))
#define bM4_INTC_VSSEL133_VSEL24                  (*((volatile unsigned int*)(0x42A24E60UL)))
#define bM4_INTC_VSSEL133_VSEL25                  (*((volatile unsigned int*)(0x42A24E64UL)))
#define bM4_INTC_VSSEL133_VSEL26                  (*((volatile unsigned int*)(0x42A24E68UL)))
#define bM4_INTC_VSSEL133_VSEL27                  (*((volatile unsigned int*)(0x42A24E6CUL)))
#define bM4_INTC_VSSEL133_VSEL28                  (*((volatile unsigned int*)(0x42A24E70UL)))
#define bM4_INTC_VSSEL133_VSEL29                  (*((volatile unsigned int*)(0x42A24E74UL)))
#define bM4_INTC_VSSEL133_VSEL30                  (*((volatile unsigned int*)(0x42A24E78UL)))
#define bM4_INTC_VSSEL133_VSEL31                  (*((volatile unsigned int*)(0x42A24E7CUL)))
#define bM4_INTC_VSSEL134_VSEL0                   (*((volatile unsigned int*)(0x42A24E80UL)))
#define bM4_INTC_VSSEL134_VSEL1                   (*((volatile unsigned int*)(0x42A24E84UL)))
#define bM4_INTC_VSSEL134_VSEL2                   (*((volatile unsigned int*)(0x42A24E88UL)))
#define bM4_INTC_VSSEL134_VSEL3                   (*((volatile unsigned int*)(0x42A24E8CUL)))
#define bM4_INTC_VSSEL134_VSEL4                   (*((volatile unsigned int*)(0x42A24E90UL)))
#define bM4_INTC_VSSEL134_VSEL5                   (*((volatile unsigned int*)(0x42A24E94UL)))
#define bM4_INTC_VSSEL134_VSEL6                   (*((volatile unsigned int*)(0x42A24E98UL)))
#define bM4_INTC_VSSEL134_VSEL7                   (*((volatile unsigned int*)(0x42A24E9CUL)))
#define bM4_INTC_VSSEL134_VSEL8                   (*((volatile unsigned int*)(0x42A24EA0UL)))
#define bM4_INTC_VSSEL134_VSEL9                   (*((volatile unsigned int*)(0x42A24EA4UL)))
#define bM4_INTC_VSSEL134_VSEL10                  (*((volatile unsigned int*)(0x42A24EA8UL)))
#define bM4_INTC_VSSEL134_VSEL11                  (*((volatile unsigned int*)(0x42A24EACUL)))
#define bM4_INTC_VSSEL134_VSEL12                  (*((volatile unsigned int*)(0x42A24EB0UL)))
#define bM4_INTC_VSSEL134_VSEL13                  (*((volatile unsigned int*)(0x42A24EB4UL)))
#define bM4_INTC_VSSEL134_VSEL14                  (*((volatile unsigned int*)(0x42A24EB8UL)))
#define bM4_INTC_VSSEL134_VSEL15                  (*((volatile unsigned int*)(0x42A24EBCUL)))
#define bM4_INTC_VSSEL134_VSEL16                  (*((volatile unsigned int*)(0x42A24EC0UL)))
#define bM4_INTC_VSSEL134_VSEL17                  (*((volatile unsigned int*)(0x42A24EC4UL)))
#define bM4_INTC_VSSEL134_VSEL18                  (*((volatile unsigned int*)(0x42A24EC8UL)))
#define bM4_INTC_VSSEL134_VSEL19                  (*((volatile unsigned int*)(0x42A24ECCUL)))
#define bM4_INTC_VSSEL134_VSEL20                  (*((volatile unsigned int*)(0x42A24ED0UL)))
#define bM4_INTC_VSSEL134_VSEL21                  (*((volatile unsigned int*)(0x42A24ED4UL)))
#define bM4_INTC_VSSEL134_VSEL22                  (*((volatile unsigned int*)(0x42A24ED8UL)))
#define bM4_INTC_VSSEL134_VSEL23                  (*((volatile unsigned int*)(0x42A24EDCUL)))
#define bM4_INTC_VSSEL134_VSEL24                  (*((volatile unsigned int*)(0x42A24EE0UL)))
#define bM4_INTC_VSSEL134_VSEL25                  (*((volatile unsigned int*)(0x42A24EE4UL)))
#define bM4_INTC_VSSEL134_VSEL26                  (*((volatile unsigned int*)(0x42A24EE8UL)))
#define bM4_INTC_VSSEL134_VSEL27                  (*((volatile unsigned int*)(0x42A24EECUL)))
#define bM4_INTC_VSSEL134_VSEL28                  (*((volatile unsigned int*)(0x42A24EF0UL)))
#define bM4_INTC_VSSEL134_VSEL29                  (*((volatile unsigned int*)(0x42A24EF4UL)))
#define bM4_INTC_VSSEL134_VSEL30                  (*((volatile unsigned int*)(0x42A24EF8UL)))
#define bM4_INTC_VSSEL134_VSEL31                  (*((volatile unsigned int*)(0x42A24EFCUL)))
#define bM4_INTC_VSSEL135_VSEL0                   (*((volatile unsigned int*)(0x42A24F00UL)))
#define bM4_INTC_VSSEL135_VSEL1                   (*((volatile unsigned int*)(0x42A24F04UL)))
#define bM4_INTC_VSSEL135_VSEL2                   (*((volatile unsigned int*)(0x42A24F08UL)))
#define bM4_INTC_VSSEL135_VSEL3                   (*((volatile unsigned int*)(0x42A24F0CUL)))
#define bM4_INTC_VSSEL135_VSEL4                   (*((volatile unsigned int*)(0x42A24F10UL)))
#define bM4_INTC_VSSEL135_VSEL5                   (*((volatile unsigned int*)(0x42A24F14UL)))
#define bM4_INTC_VSSEL135_VSEL6                   (*((volatile unsigned int*)(0x42A24F18UL)))
#define bM4_INTC_VSSEL135_VSEL7                   (*((volatile unsigned int*)(0x42A24F1CUL)))
#define bM4_INTC_VSSEL135_VSEL8                   (*((volatile unsigned int*)(0x42A24F20UL)))
#define bM4_INTC_VSSEL135_VSEL9                   (*((volatile unsigned int*)(0x42A24F24UL)))
#define bM4_INTC_VSSEL135_VSEL10                  (*((volatile unsigned int*)(0x42A24F28UL)))
#define bM4_INTC_VSSEL135_VSEL11                  (*((volatile unsigned int*)(0x42A24F2CUL)))
#define bM4_INTC_VSSEL135_VSEL12                  (*((volatile unsigned int*)(0x42A24F30UL)))
#define bM4_INTC_VSSEL135_VSEL13                  (*((volatile unsigned int*)(0x42A24F34UL)))
#define bM4_INTC_VSSEL135_VSEL14                  (*((volatile unsigned int*)(0x42A24F38UL)))
#define bM4_INTC_VSSEL135_VSEL15                  (*((volatile unsigned int*)(0x42A24F3CUL)))
#define bM4_INTC_VSSEL135_VSEL16                  (*((volatile unsigned int*)(0x42A24F40UL)))
#define bM4_INTC_VSSEL135_VSEL17                  (*((volatile unsigned int*)(0x42A24F44UL)))
#define bM4_INTC_VSSEL135_VSEL18                  (*((volatile unsigned int*)(0x42A24F48UL)))
#define bM4_INTC_VSSEL135_VSEL19                  (*((volatile unsigned int*)(0x42A24F4CUL)))
#define bM4_INTC_VSSEL135_VSEL20                  (*((volatile unsigned int*)(0x42A24F50UL)))
#define bM4_INTC_VSSEL135_VSEL21                  (*((volatile unsigned int*)(0x42A24F54UL)))
#define bM4_INTC_VSSEL135_VSEL22                  (*((volatile unsigned int*)(0x42A24F58UL)))
#define bM4_INTC_VSSEL135_VSEL23                  (*((volatile unsigned int*)(0x42A24F5CUL)))
#define bM4_INTC_VSSEL135_VSEL24                  (*((volatile unsigned int*)(0x42A24F60UL)))
#define bM4_INTC_VSSEL135_VSEL25                  (*((volatile unsigned int*)(0x42A24F64UL)))
#define bM4_INTC_VSSEL135_VSEL26                  (*((volatile unsigned int*)(0x42A24F68UL)))
#define bM4_INTC_VSSEL135_VSEL27                  (*((volatile unsigned int*)(0x42A24F6CUL)))
#define bM4_INTC_VSSEL135_VSEL28                  (*((volatile unsigned int*)(0x42A24F70UL)))
#define bM4_INTC_VSSEL135_VSEL29                  (*((volatile unsigned int*)(0x42A24F74UL)))
#define bM4_INTC_VSSEL135_VSEL30                  (*((volatile unsigned int*)(0x42A24F78UL)))
#define bM4_INTC_VSSEL135_VSEL31                  (*((volatile unsigned int*)(0x42A24F7CUL)))
#define bM4_INTC_VSSEL136_VSEL0                   (*((volatile unsigned int*)(0x42A24F80UL)))
#define bM4_INTC_VSSEL136_VSEL1                   (*((volatile unsigned int*)(0x42A24F84UL)))
#define bM4_INTC_VSSEL136_VSEL2                   (*((volatile unsigned int*)(0x42A24F88UL)))
#define bM4_INTC_VSSEL136_VSEL3                   (*((volatile unsigned int*)(0x42A24F8CUL)))
#define bM4_INTC_VSSEL136_VSEL4                   (*((volatile unsigned int*)(0x42A24F90UL)))
#define bM4_INTC_VSSEL136_VSEL5                   (*((volatile unsigned int*)(0x42A24F94UL)))
#define bM4_INTC_VSSEL136_VSEL6                   (*((volatile unsigned int*)(0x42A24F98UL)))
#define bM4_INTC_VSSEL136_VSEL7                   (*((volatile unsigned int*)(0x42A24F9CUL)))
#define bM4_INTC_VSSEL136_VSEL8                   (*((volatile unsigned int*)(0x42A24FA0UL)))
#define bM4_INTC_VSSEL136_VSEL9                   (*((volatile unsigned int*)(0x42A24FA4UL)))
#define bM4_INTC_VSSEL136_VSEL10                  (*((volatile unsigned int*)(0x42A24FA8UL)))
#define bM4_INTC_VSSEL136_VSEL11                  (*((volatile unsigned int*)(0x42A24FACUL)))
#define bM4_INTC_VSSEL136_VSEL12                  (*((volatile unsigned int*)(0x42A24FB0UL)))
#define bM4_INTC_VSSEL136_VSEL13                  (*((volatile unsigned int*)(0x42A24FB4UL)))
#define bM4_INTC_VSSEL136_VSEL14                  (*((volatile unsigned int*)(0x42A24FB8UL)))
#define bM4_INTC_VSSEL136_VSEL15                  (*((volatile unsigned int*)(0x42A24FBCUL)))
#define bM4_INTC_VSSEL136_VSEL16                  (*((volatile unsigned int*)(0x42A24FC0UL)))
#define bM4_INTC_VSSEL136_VSEL17                  (*((volatile unsigned int*)(0x42A24FC4UL)))
#define bM4_INTC_VSSEL136_VSEL18                  (*((volatile unsigned int*)(0x42A24FC8UL)))
#define bM4_INTC_VSSEL136_VSEL19                  (*((volatile unsigned int*)(0x42A24FCCUL)))
#define bM4_INTC_VSSEL136_VSEL20                  (*((volatile unsigned int*)(0x42A24FD0UL)))
#define bM4_INTC_VSSEL136_VSEL21                  (*((volatile unsigned int*)(0x42A24FD4UL)))
#define bM4_INTC_VSSEL136_VSEL22                  (*((volatile unsigned int*)(0x42A24FD8UL)))
#define bM4_INTC_VSSEL136_VSEL23                  (*((volatile unsigned int*)(0x42A24FDCUL)))
#define bM4_INTC_VSSEL136_VSEL24                  (*((volatile unsigned int*)(0x42A24FE0UL)))
#define bM4_INTC_VSSEL136_VSEL25                  (*((volatile unsigned int*)(0x42A24FE4UL)))
#define bM4_INTC_VSSEL136_VSEL26                  (*((volatile unsigned int*)(0x42A24FE8UL)))
#define bM4_INTC_VSSEL136_VSEL27                  (*((volatile unsigned int*)(0x42A24FECUL)))
#define bM4_INTC_VSSEL136_VSEL28                  (*((volatile unsigned int*)(0x42A24FF0UL)))
#define bM4_INTC_VSSEL136_VSEL29                  (*((volatile unsigned int*)(0x42A24FF4UL)))
#define bM4_INTC_VSSEL136_VSEL30                  (*((volatile unsigned int*)(0x42A24FF8UL)))
#define bM4_INTC_VSSEL136_VSEL31                  (*((volatile unsigned int*)(0x42A24FFCUL)))
#define bM4_INTC_VSSEL137_VSEL0                   (*((volatile unsigned int*)(0x42A25000UL)))
#define bM4_INTC_VSSEL137_VSEL1                   (*((volatile unsigned int*)(0x42A25004UL)))
#define bM4_INTC_VSSEL137_VSEL2                   (*((volatile unsigned int*)(0x42A25008UL)))
#define bM4_INTC_VSSEL137_VSEL3                   (*((volatile unsigned int*)(0x42A2500CUL)))
#define bM4_INTC_VSSEL137_VSEL4                   (*((volatile unsigned int*)(0x42A25010UL)))
#define bM4_INTC_VSSEL137_VSEL5                   (*((volatile unsigned int*)(0x42A25014UL)))
#define bM4_INTC_VSSEL137_VSEL6                   (*((volatile unsigned int*)(0x42A25018UL)))
#define bM4_INTC_VSSEL137_VSEL7                   (*((volatile unsigned int*)(0x42A2501CUL)))
#define bM4_INTC_VSSEL137_VSEL8                   (*((volatile unsigned int*)(0x42A25020UL)))
#define bM4_INTC_VSSEL137_VSEL9                   (*((volatile unsigned int*)(0x42A25024UL)))
#define bM4_INTC_VSSEL137_VSEL10                  (*((volatile unsigned int*)(0x42A25028UL)))
#define bM4_INTC_VSSEL137_VSEL11                  (*((volatile unsigned int*)(0x42A2502CUL)))
#define bM4_INTC_VSSEL137_VSEL12                  (*((volatile unsigned int*)(0x42A25030UL)))
#define bM4_INTC_VSSEL137_VSEL13                  (*((volatile unsigned int*)(0x42A25034UL)))
#define bM4_INTC_VSSEL137_VSEL14                  (*((volatile unsigned int*)(0x42A25038UL)))
#define bM4_INTC_VSSEL137_VSEL15                  (*((volatile unsigned int*)(0x42A2503CUL)))
#define bM4_INTC_VSSEL137_VSEL16                  (*((volatile unsigned int*)(0x42A25040UL)))
#define bM4_INTC_VSSEL137_VSEL17                  (*((volatile unsigned int*)(0x42A25044UL)))
#define bM4_INTC_VSSEL137_VSEL18                  (*((volatile unsigned int*)(0x42A25048UL)))
#define bM4_INTC_VSSEL137_VSEL19                  (*((volatile unsigned int*)(0x42A2504CUL)))
#define bM4_INTC_VSSEL137_VSEL20                  (*((volatile unsigned int*)(0x42A25050UL)))
#define bM4_INTC_VSSEL137_VSEL21                  (*((volatile unsigned int*)(0x42A25054UL)))
#define bM4_INTC_VSSEL137_VSEL22                  (*((volatile unsigned int*)(0x42A25058UL)))
#define bM4_INTC_VSSEL137_VSEL23                  (*((volatile unsigned int*)(0x42A2505CUL)))
#define bM4_INTC_VSSEL137_VSEL24                  (*((volatile unsigned int*)(0x42A25060UL)))
#define bM4_INTC_VSSEL137_VSEL25                  (*((volatile unsigned int*)(0x42A25064UL)))
#define bM4_INTC_VSSEL137_VSEL26                  (*((volatile unsigned int*)(0x42A25068UL)))
#define bM4_INTC_VSSEL137_VSEL27                  (*((volatile unsigned int*)(0x42A2506CUL)))
#define bM4_INTC_VSSEL137_VSEL28                  (*((volatile unsigned int*)(0x42A25070UL)))
#define bM4_INTC_VSSEL137_VSEL29                  (*((volatile unsigned int*)(0x42A25074UL)))
#define bM4_INTC_VSSEL137_VSEL30                  (*((volatile unsigned int*)(0x42A25078UL)))
#define bM4_INTC_VSSEL137_VSEL31                  (*((volatile unsigned int*)(0x42A2507CUL)))
#define bM4_INTC_VSSEL138_VSEL0                   (*((volatile unsigned int*)(0x42A25080UL)))
#define bM4_INTC_VSSEL138_VSEL1                   (*((volatile unsigned int*)(0x42A25084UL)))
#define bM4_INTC_VSSEL138_VSEL2                   (*((volatile unsigned int*)(0x42A25088UL)))
#define bM4_INTC_VSSEL138_VSEL3                   (*((volatile unsigned int*)(0x42A2508CUL)))
#define bM4_INTC_VSSEL138_VSEL4                   (*((volatile unsigned int*)(0x42A25090UL)))
#define bM4_INTC_VSSEL138_VSEL5                   (*((volatile unsigned int*)(0x42A25094UL)))
#define bM4_INTC_VSSEL138_VSEL6                   (*((volatile unsigned int*)(0x42A25098UL)))
#define bM4_INTC_VSSEL138_VSEL7                   (*((volatile unsigned int*)(0x42A2509CUL)))
#define bM4_INTC_VSSEL138_VSEL8                   (*((volatile unsigned int*)(0x42A250A0UL)))
#define bM4_INTC_VSSEL138_VSEL9                   (*((volatile unsigned int*)(0x42A250A4UL)))
#define bM4_INTC_VSSEL138_VSEL10                  (*((volatile unsigned int*)(0x42A250A8UL)))
#define bM4_INTC_VSSEL138_VSEL11                  (*((volatile unsigned int*)(0x42A250ACUL)))
#define bM4_INTC_VSSEL138_VSEL12                  (*((volatile unsigned int*)(0x42A250B0UL)))
#define bM4_INTC_VSSEL138_VSEL13                  (*((volatile unsigned int*)(0x42A250B4UL)))
#define bM4_INTC_VSSEL138_VSEL14                  (*((volatile unsigned int*)(0x42A250B8UL)))
#define bM4_INTC_VSSEL138_VSEL15                  (*((volatile unsigned int*)(0x42A250BCUL)))
#define bM4_INTC_VSSEL138_VSEL16                  (*((volatile unsigned int*)(0x42A250C0UL)))
#define bM4_INTC_VSSEL138_VSEL17                  (*((volatile unsigned int*)(0x42A250C4UL)))
#define bM4_INTC_VSSEL138_VSEL18                  (*((volatile unsigned int*)(0x42A250C8UL)))
#define bM4_INTC_VSSEL138_VSEL19                  (*((volatile unsigned int*)(0x42A250CCUL)))
#define bM4_INTC_VSSEL138_VSEL20                  (*((volatile unsigned int*)(0x42A250D0UL)))
#define bM4_INTC_VSSEL138_VSEL21                  (*((volatile unsigned int*)(0x42A250D4UL)))
#define bM4_INTC_VSSEL138_VSEL22                  (*((volatile unsigned int*)(0x42A250D8UL)))
#define bM4_INTC_VSSEL138_VSEL23                  (*((volatile unsigned int*)(0x42A250DCUL)))
#define bM4_INTC_VSSEL138_VSEL24                  (*((volatile unsigned int*)(0x42A250E0UL)))
#define bM4_INTC_VSSEL138_VSEL25                  (*((volatile unsigned int*)(0x42A250E4UL)))
#define bM4_INTC_VSSEL138_VSEL26                  (*((volatile unsigned int*)(0x42A250E8UL)))
#define bM4_INTC_VSSEL138_VSEL27                  (*((volatile unsigned int*)(0x42A250ECUL)))
#define bM4_INTC_VSSEL138_VSEL28                  (*((volatile unsigned int*)(0x42A250F0UL)))
#define bM4_INTC_VSSEL138_VSEL29                  (*((volatile unsigned int*)(0x42A250F4UL)))
#define bM4_INTC_VSSEL138_VSEL30                  (*((volatile unsigned int*)(0x42A250F8UL)))
#define bM4_INTC_VSSEL138_VSEL31                  (*((volatile unsigned int*)(0x42A250FCUL)))
#define bM4_INTC_VSSEL139_VSEL0                   (*((volatile unsigned int*)(0x42A25100UL)))
#define bM4_INTC_VSSEL139_VSEL1                   (*((volatile unsigned int*)(0x42A25104UL)))
#define bM4_INTC_VSSEL139_VSEL2                   (*((volatile unsigned int*)(0x42A25108UL)))
#define bM4_INTC_VSSEL139_VSEL3                   (*((volatile unsigned int*)(0x42A2510CUL)))
#define bM4_INTC_VSSEL139_VSEL4                   (*((volatile unsigned int*)(0x42A25110UL)))
#define bM4_INTC_VSSEL139_VSEL5                   (*((volatile unsigned int*)(0x42A25114UL)))
#define bM4_INTC_VSSEL139_VSEL6                   (*((volatile unsigned int*)(0x42A25118UL)))
#define bM4_INTC_VSSEL139_VSEL7                   (*((volatile unsigned int*)(0x42A2511CUL)))
#define bM4_INTC_VSSEL139_VSEL8                   (*((volatile unsigned int*)(0x42A25120UL)))
#define bM4_INTC_VSSEL139_VSEL9                   (*((volatile unsigned int*)(0x42A25124UL)))
#define bM4_INTC_VSSEL139_VSEL10                  (*((volatile unsigned int*)(0x42A25128UL)))
#define bM4_INTC_VSSEL139_VSEL11                  (*((volatile unsigned int*)(0x42A2512CUL)))
#define bM4_INTC_VSSEL139_VSEL12                  (*((volatile unsigned int*)(0x42A25130UL)))
#define bM4_INTC_VSSEL139_VSEL13                  (*((volatile unsigned int*)(0x42A25134UL)))
#define bM4_INTC_VSSEL139_VSEL14                  (*((volatile unsigned int*)(0x42A25138UL)))
#define bM4_INTC_VSSEL139_VSEL15                  (*((volatile unsigned int*)(0x42A2513CUL)))
#define bM4_INTC_VSSEL139_VSEL16                  (*((volatile unsigned int*)(0x42A25140UL)))
#define bM4_INTC_VSSEL139_VSEL17                  (*((volatile unsigned int*)(0x42A25144UL)))
#define bM4_INTC_VSSEL139_VSEL18                  (*((volatile unsigned int*)(0x42A25148UL)))
#define bM4_INTC_VSSEL139_VSEL19                  (*((volatile unsigned int*)(0x42A2514CUL)))
#define bM4_INTC_VSSEL139_VSEL20                  (*((volatile unsigned int*)(0x42A25150UL)))
#define bM4_INTC_VSSEL139_VSEL21                  (*((volatile unsigned int*)(0x42A25154UL)))
#define bM4_INTC_VSSEL139_VSEL22                  (*((volatile unsigned int*)(0x42A25158UL)))
#define bM4_INTC_VSSEL139_VSEL23                  (*((volatile unsigned int*)(0x42A2515CUL)))
#define bM4_INTC_VSSEL139_VSEL24                  (*((volatile unsigned int*)(0x42A25160UL)))
#define bM4_INTC_VSSEL139_VSEL25                  (*((volatile unsigned int*)(0x42A25164UL)))
#define bM4_INTC_VSSEL139_VSEL26                  (*((volatile unsigned int*)(0x42A25168UL)))
#define bM4_INTC_VSSEL139_VSEL27                  (*((volatile unsigned int*)(0x42A2516CUL)))
#define bM4_INTC_VSSEL139_VSEL28                  (*((volatile unsigned int*)(0x42A25170UL)))
#define bM4_INTC_VSSEL139_VSEL29                  (*((volatile unsigned int*)(0x42A25174UL)))
#define bM4_INTC_VSSEL139_VSEL30                  (*((volatile unsigned int*)(0x42A25178UL)))
#define bM4_INTC_VSSEL139_VSEL31                  (*((volatile unsigned int*)(0x42A2517CUL)))
#define bM4_INTC_VSSEL140_VSEL0                   (*((volatile unsigned int*)(0x42A25180UL)))
#define bM4_INTC_VSSEL140_VSEL1                   (*((volatile unsigned int*)(0x42A25184UL)))
#define bM4_INTC_VSSEL140_VSEL2                   (*((volatile unsigned int*)(0x42A25188UL)))
#define bM4_INTC_VSSEL140_VSEL3                   (*((volatile unsigned int*)(0x42A2518CUL)))
#define bM4_INTC_VSSEL140_VSEL4                   (*((volatile unsigned int*)(0x42A25190UL)))
#define bM4_INTC_VSSEL140_VSEL5                   (*((volatile unsigned int*)(0x42A25194UL)))
#define bM4_INTC_VSSEL140_VSEL6                   (*((volatile unsigned int*)(0x42A25198UL)))
#define bM4_INTC_VSSEL140_VSEL7                   (*((volatile unsigned int*)(0x42A2519CUL)))
#define bM4_INTC_VSSEL140_VSEL8                   (*((volatile unsigned int*)(0x42A251A0UL)))
#define bM4_INTC_VSSEL140_VSEL9                   (*((volatile unsigned int*)(0x42A251A4UL)))
#define bM4_INTC_VSSEL140_VSEL10                  (*((volatile unsigned int*)(0x42A251A8UL)))
#define bM4_INTC_VSSEL140_VSEL11                  (*((volatile unsigned int*)(0x42A251ACUL)))
#define bM4_INTC_VSSEL140_VSEL12                  (*((volatile unsigned int*)(0x42A251B0UL)))
#define bM4_INTC_VSSEL140_VSEL13                  (*((volatile unsigned int*)(0x42A251B4UL)))
#define bM4_INTC_VSSEL140_VSEL14                  (*((volatile unsigned int*)(0x42A251B8UL)))
#define bM4_INTC_VSSEL140_VSEL15                  (*((volatile unsigned int*)(0x42A251BCUL)))
#define bM4_INTC_VSSEL140_VSEL16                  (*((volatile unsigned int*)(0x42A251C0UL)))
#define bM4_INTC_VSSEL140_VSEL17                  (*((volatile unsigned int*)(0x42A251C4UL)))
#define bM4_INTC_VSSEL140_VSEL18                  (*((volatile unsigned int*)(0x42A251C8UL)))
#define bM4_INTC_VSSEL140_VSEL19                  (*((volatile unsigned int*)(0x42A251CCUL)))
#define bM4_INTC_VSSEL140_VSEL20                  (*((volatile unsigned int*)(0x42A251D0UL)))
#define bM4_INTC_VSSEL140_VSEL21                  (*((volatile unsigned int*)(0x42A251D4UL)))
#define bM4_INTC_VSSEL140_VSEL22                  (*((volatile unsigned int*)(0x42A251D8UL)))
#define bM4_INTC_VSSEL140_VSEL23                  (*((volatile unsigned int*)(0x42A251DCUL)))
#define bM4_INTC_VSSEL140_VSEL24                  (*((volatile unsigned int*)(0x42A251E0UL)))
#define bM4_INTC_VSSEL140_VSEL25                  (*((volatile unsigned int*)(0x42A251E4UL)))
#define bM4_INTC_VSSEL140_VSEL26                  (*((volatile unsigned int*)(0x42A251E8UL)))
#define bM4_INTC_VSSEL140_VSEL27                  (*((volatile unsigned int*)(0x42A251ECUL)))
#define bM4_INTC_VSSEL140_VSEL28                  (*((volatile unsigned int*)(0x42A251F0UL)))
#define bM4_INTC_VSSEL140_VSEL29                  (*((volatile unsigned int*)(0x42A251F4UL)))
#define bM4_INTC_VSSEL140_VSEL30                  (*((volatile unsigned int*)(0x42A251F8UL)))
#define bM4_INTC_VSSEL140_VSEL31                  (*((volatile unsigned int*)(0x42A251FCUL)))
#define bM4_INTC_VSSEL141_VSEL0                   (*((volatile unsigned int*)(0x42A25200UL)))
#define bM4_INTC_VSSEL141_VSEL1                   (*((volatile unsigned int*)(0x42A25204UL)))
#define bM4_INTC_VSSEL141_VSEL2                   (*((volatile unsigned int*)(0x42A25208UL)))
#define bM4_INTC_VSSEL141_VSEL3                   (*((volatile unsigned int*)(0x42A2520CUL)))
#define bM4_INTC_VSSEL141_VSEL4                   (*((volatile unsigned int*)(0x42A25210UL)))
#define bM4_INTC_VSSEL141_VSEL5                   (*((volatile unsigned int*)(0x42A25214UL)))
#define bM4_INTC_VSSEL141_VSEL6                   (*((volatile unsigned int*)(0x42A25218UL)))
#define bM4_INTC_VSSEL141_VSEL7                   (*((volatile unsigned int*)(0x42A2521CUL)))
#define bM4_INTC_VSSEL141_VSEL8                   (*((volatile unsigned int*)(0x42A25220UL)))
#define bM4_INTC_VSSEL141_VSEL9                   (*((volatile unsigned int*)(0x42A25224UL)))
#define bM4_INTC_VSSEL141_VSEL10                  (*((volatile unsigned int*)(0x42A25228UL)))
#define bM4_INTC_VSSEL141_VSEL11                  (*((volatile unsigned int*)(0x42A2522CUL)))
#define bM4_INTC_VSSEL141_VSEL12                  (*((volatile unsigned int*)(0x42A25230UL)))
#define bM4_INTC_VSSEL141_VSEL13                  (*((volatile unsigned int*)(0x42A25234UL)))
#define bM4_INTC_VSSEL141_VSEL14                  (*((volatile unsigned int*)(0x42A25238UL)))
#define bM4_INTC_VSSEL141_VSEL15                  (*((volatile unsigned int*)(0x42A2523CUL)))
#define bM4_INTC_VSSEL141_VSEL16                  (*((volatile unsigned int*)(0x42A25240UL)))
#define bM4_INTC_VSSEL141_VSEL17                  (*((volatile unsigned int*)(0x42A25244UL)))
#define bM4_INTC_VSSEL141_VSEL18                  (*((volatile unsigned int*)(0x42A25248UL)))
#define bM4_INTC_VSSEL141_VSEL19                  (*((volatile unsigned int*)(0x42A2524CUL)))
#define bM4_INTC_VSSEL141_VSEL20                  (*((volatile unsigned int*)(0x42A25250UL)))
#define bM4_INTC_VSSEL141_VSEL21                  (*((volatile unsigned int*)(0x42A25254UL)))
#define bM4_INTC_VSSEL141_VSEL22                  (*((volatile unsigned int*)(0x42A25258UL)))
#define bM4_INTC_VSSEL141_VSEL23                  (*((volatile unsigned int*)(0x42A2525CUL)))
#define bM4_INTC_VSSEL141_VSEL24                  (*((volatile unsigned int*)(0x42A25260UL)))
#define bM4_INTC_VSSEL141_VSEL25                  (*((volatile unsigned int*)(0x42A25264UL)))
#define bM4_INTC_VSSEL141_VSEL26                  (*((volatile unsigned int*)(0x42A25268UL)))
#define bM4_INTC_VSSEL141_VSEL27                  (*((volatile unsigned int*)(0x42A2526CUL)))
#define bM4_INTC_VSSEL141_VSEL28                  (*((volatile unsigned int*)(0x42A25270UL)))
#define bM4_INTC_VSSEL141_VSEL29                  (*((volatile unsigned int*)(0x42A25274UL)))
#define bM4_INTC_VSSEL141_VSEL30                  (*((volatile unsigned int*)(0x42A25278UL)))
#define bM4_INTC_VSSEL141_VSEL31                  (*((volatile unsigned int*)(0x42A2527CUL)))
#define bM4_INTC_VSSEL142_VSEL0                   (*((volatile unsigned int*)(0x42A25280UL)))
#define bM4_INTC_VSSEL142_VSEL1                   (*((volatile unsigned int*)(0x42A25284UL)))
#define bM4_INTC_VSSEL142_VSEL2                   (*((volatile unsigned int*)(0x42A25288UL)))
#define bM4_INTC_VSSEL142_VSEL3                   (*((volatile unsigned int*)(0x42A2528CUL)))
#define bM4_INTC_VSSEL142_VSEL4                   (*((volatile unsigned int*)(0x42A25290UL)))
#define bM4_INTC_VSSEL142_VSEL5                   (*((volatile unsigned int*)(0x42A25294UL)))
#define bM4_INTC_VSSEL142_VSEL6                   (*((volatile unsigned int*)(0x42A25298UL)))
#define bM4_INTC_VSSEL142_VSEL7                   (*((volatile unsigned int*)(0x42A2529CUL)))
#define bM4_INTC_VSSEL142_VSEL8                   (*((volatile unsigned int*)(0x42A252A0UL)))
#define bM4_INTC_VSSEL142_VSEL9                   (*((volatile unsigned int*)(0x42A252A4UL)))
#define bM4_INTC_VSSEL142_VSEL10                  (*((volatile unsigned int*)(0x42A252A8UL)))
#define bM4_INTC_VSSEL142_VSEL11                  (*((volatile unsigned int*)(0x42A252ACUL)))
#define bM4_INTC_VSSEL142_VSEL12                  (*((volatile unsigned int*)(0x42A252B0UL)))
#define bM4_INTC_VSSEL142_VSEL13                  (*((volatile unsigned int*)(0x42A252B4UL)))
#define bM4_INTC_VSSEL142_VSEL14                  (*((volatile unsigned int*)(0x42A252B8UL)))
#define bM4_INTC_VSSEL142_VSEL15                  (*((volatile unsigned int*)(0x42A252BCUL)))
#define bM4_INTC_VSSEL142_VSEL16                  (*((volatile unsigned int*)(0x42A252C0UL)))
#define bM4_INTC_VSSEL142_VSEL17                  (*((volatile unsigned int*)(0x42A252C4UL)))
#define bM4_INTC_VSSEL142_VSEL18                  (*((volatile unsigned int*)(0x42A252C8UL)))
#define bM4_INTC_VSSEL142_VSEL19                  (*((volatile unsigned int*)(0x42A252CCUL)))
#define bM4_INTC_VSSEL142_VSEL20                  (*((volatile unsigned int*)(0x42A252D0UL)))
#define bM4_INTC_VSSEL142_VSEL21                  (*((volatile unsigned int*)(0x42A252D4UL)))
#define bM4_INTC_VSSEL142_VSEL22                  (*((volatile unsigned int*)(0x42A252D8UL)))
#define bM4_INTC_VSSEL142_VSEL23                  (*((volatile unsigned int*)(0x42A252DCUL)))
#define bM4_INTC_VSSEL142_VSEL24                  (*((volatile unsigned int*)(0x42A252E0UL)))
#define bM4_INTC_VSSEL142_VSEL25                  (*((volatile unsigned int*)(0x42A252E4UL)))
#define bM4_INTC_VSSEL142_VSEL26                  (*((volatile unsigned int*)(0x42A252E8UL)))
#define bM4_INTC_VSSEL142_VSEL27                  (*((volatile unsigned int*)(0x42A252ECUL)))
#define bM4_INTC_VSSEL142_VSEL28                  (*((volatile unsigned int*)(0x42A252F0UL)))
#define bM4_INTC_VSSEL142_VSEL29                  (*((volatile unsigned int*)(0x42A252F4UL)))
#define bM4_INTC_VSSEL142_VSEL30                  (*((volatile unsigned int*)(0x42A252F8UL)))
#define bM4_INTC_VSSEL142_VSEL31                  (*((volatile unsigned int*)(0x42A252FCUL)))
#define bM4_INTC_VSSEL143_VSEL0                   (*((volatile unsigned int*)(0x42A25300UL)))
#define bM4_INTC_VSSEL143_VSEL1                   (*((volatile unsigned int*)(0x42A25304UL)))
#define bM4_INTC_VSSEL143_VSEL2                   (*((volatile unsigned int*)(0x42A25308UL)))
#define bM4_INTC_VSSEL143_VSEL3                   (*((volatile unsigned int*)(0x42A2530CUL)))
#define bM4_INTC_VSSEL143_VSEL4                   (*((volatile unsigned int*)(0x42A25310UL)))
#define bM4_INTC_VSSEL143_VSEL5                   (*((volatile unsigned int*)(0x42A25314UL)))
#define bM4_INTC_VSSEL143_VSEL6                   (*((volatile unsigned int*)(0x42A25318UL)))
#define bM4_INTC_VSSEL143_VSEL7                   (*((volatile unsigned int*)(0x42A2531CUL)))
#define bM4_INTC_VSSEL143_VSEL8                   (*((volatile unsigned int*)(0x42A25320UL)))
#define bM4_INTC_VSSEL143_VSEL9                   (*((volatile unsigned int*)(0x42A25324UL)))
#define bM4_INTC_VSSEL143_VSEL10                  (*((volatile unsigned int*)(0x42A25328UL)))
#define bM4_INTC_VSSEL143_VSEL11                  (*((volatile unsigned int*)(0x42A2532CUL)))
#define bM4_INTC_VSSEL143_VSEL12                  (*((volatile unsigned int*)(0x42A25330UL)))
#define bM4_INTC_VSSEL143_VSEL13                  (*((volatile unsigned int*)(0x42A25334UL)))
#define bM4_INTC_VSSEL143_VSEL14                  (*((volatile unsigned int*)(0x42A25338UL)))
#define bM4_INTC_VSSEL143_VSEL15                  (*((volatile unsigned int*)(0x42A2533CUL)))
#define bM4_INTC_VSSEL143_VSEL16                  (*((volatile unsigned int*)(0x42A25340UL)))
#define bM4_INTC_VSSEL143_VSEL17                  (*((volatile unsigned int*)(0x42A25344UL)))
#define bM4_INTC_VSSEL143_VSEL18                  (*((volatile unsigned int*)(0x42A25348UL)))
#define bM4_INTC_VSSEL143_VSEL19                  (*((volatile unsigned int*)(0x42A2534CUL)))
#define bM4_INTC_VSSEL143_VSEL20                  (*((volatile unsigned int*)(0x42A25350UL)))
#define bM4_INTC_VSSEL143_VSEL21                  (*((volatile unsigned int*)(0x42A25354UL)))
#define bM4_INTC_VSSEL143_VSEL22                  (*((volatile unsigned int*)(0x42A25358UL)))
#define bM4_INTC_VSSEL143_VSEL23                  (*((volatile unsigned int*)(0x42A2535CUL)))
#define bM4_INTC_VSSEL143_VSEL24                  (*((volatile unsigned int*)(0x42A25360UL)))
#define bM4_INTC_VSSEL143_VSEL25                  (*((volatile unsigned int*)(0x42A25364UL)))
#define bM4_INTC_VSSEL143_VSEL26                  (*((volatile unsigned int*)(0x42A25368UL)))
#define bM4_INTC_VSSEL143_VSEL27                  (*((volatile unsigned int*)(0x42A2536CUL)))
#define bM4_INTC_VSSEL143_VSEL28                  (*((volatile unsigned int*)(0x42A25370UL)))
#define bM4_INTC_VSSEL143_VSEL29                  (*((volatile unsigned int*)(0x42A25374UL)))
#define bM4_INTC_VSSEL143_VSEL30                  (*((volatile unsigned int*)(0x42A25378UL)))
#define bM4_INTC_VSSEL143_VSEL31                  (*((volatile unsigned int*)(0x42A2537CUL)))
#define bM4_INTC_SWIER_SWIE0                      (*((volatile unsigned int*)(0x42A25380UL)))
#define bM4_INTC_SWIER_SWIE1                      (*((volatile unsigned int*)(0x42A25384UL)))
#define bM4_INTC_SWIER_SWIE2                      (*((volatile unsigned int*)(0x42A25388UL)))
#define bM4_INTC_SWIER_SWIE3                      (*((volatile unsigned int*)(0x42A2538CUL)))
#define bM4_INTC_SWIER_SWIE4                      (*((volatile unsigned int*)(0x42A25390UL)))
#define bM4_INTC_SWIER_SWIE5                      (*((volatile unsigned int*)(0x42A25394UL)))
#define bM4_INTC_SWIER_SWIE6                      (*((volatile unsigned int*)(0x42A25398UL)))
#define bM4_INTC_SWIER_SWIE7                      (*((volatile unsigned int*)(0x42A2539CUL)))
#define bM4_INTC_SWIER_SWIE8                      (*((volatile unsigned int*)(0x42A253A0UL)))
#define bM4_INTC_SWIER_SWIE9                      (*((volatile unsigned int*)(0x42A253A4UL)))
#define bM4_INTC_SWIER_SWIE10                     (*((volatile unsigned int*)(0x42A253A8UL)))
#define bM4_INTC_SWIER_SWIE11                     (*((volatile unsigned int*)(0x42A253ACUL)))
#define bM4_INTC_SWIER_SWIE12                     (*((volatile unsigned int*)(0x42A253B0UL)))
#define bM4_INTC_SWIER_SWIE13                     (*((volatile unsigned int*)(0x42A253B4UL)))
#define bM4_INTC_SWIER_SWIE14                     (*((volatile unsigned int*)(0x42A253B8UL)))
#define bM4_INTC_SWIER_SWIE15                     (*((volatile unsigned int*)(0x42A253BCUL)))
#define bM4_INTC_SWIER_SWIE16                     (*((volatile unsigned int*)(0x42A253C0UL)))
#define bM4_INTC_SWIER_SWIE17                     (*((volatile unsigned int*)(0x42A253C4UL)))
#define bM4_INTC_SWIER_SWIE18                     (*((volatile unsigned int*)(0x42A253C8UL)))
#define bM4_INTC_SWIER_SWIE19                     (*((volatile unsigned int*)(0x42A253CCUL)))
#define bM4_INTC_SWIER_SWIE20                     (*((volatile unsigned int*)(0x42A253D0UL)))
#define bM4_INTC_SWIER_SWIE21                     (*((volatile unsigned int*)(0x42A253D4UL)))
#define bM4_INTC_SWIER_SWIE22                     (*((volatile unsigned int*)(0x42A253D8UL)))
#define bM4_INTC_SWIER_SWIE23                     (*((volatile unsigned int*)(0x42A253DCUL)))
#define bM4_INTC_SWIER_SWIE24                     (*((volatile unsigned int*)(0x42A253E0UL)))
#define bM4_INTC_SWIER_SWIE25                     (*((volatile unsigned int*)(0x42A253E4UL)))
#define bM4_INTC_SWIER_SWIE26                     (*((volatile unsigned int*)(0x42A253E8UL)))
#define bM4_INTC_SWIER_SWIE27                     (*((volatile unsigned int*)(0x42A253ECUL)))
#define bM4_INTC_SWIER_SWIE28                     (*((volatile unsigned int*)(0x42A253F0UL)))
#define bM4_INTC_SWIER_SWIE29                     (*((volatile unsigned int*)(0x42A253F4UL)))
#define bM4_INTC_SWIER_SWIE30                     (*((volatile unsigned int*)(0x42A253F8UL)))
#define bM4_INTC_SWIER_SWIE31                     (*((volatile unsigned int*)(0x42A253FCUL)))
#define bM4_INTC_EVTER_EVTE0                      (*((volatile unsigned int*)(0x42A25400UL)))
#define bM4_INTC_EVTER_EVTE1                      (*((volatile unsigned int*)(0x42A25404UL)))
#define bM4_INTC_EVTER_EVTE2                      (*((volatile unsigned int*)(0x42A25408UL)))
#define bM4_INTC_EVTER_EVTE3                      (*((volatile unsigned int*)(0x42A2540CUL)))
#define bM4_INTC_EVTER_EVTE4                      (*((volatile unsigned int*)(0x42A25410UL)))
#define bM4_INTC_EVTER_EVTE5                      (*((volatile unsigned int*)(0x42A25414UL)))
#defin