/* clapper-0.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Clapper", gir_namespace = "Clapper", gir_version = "0.0", lower_case_cprefix = "clapper_")]
namespace Clapper {
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_audio_stream_get_type ()")]
	public class AudioStream : Clapper.Stream {
		[CCode (has_construct_function = false)]
		protected AudioStream ();
		public uint get_bitrate ();
		public int get_channels ();
		public string? get_codec ();
		public string? get_lang_code ();
		public string? get_lang_name ();
		public string? get_sample_format ();
		public int get_sample_rate ();
		public uint bitrate { get; }
		public int channels { get; }
		public string codec { owned get; }
		public string lang_code { owned get; }
		public string lang_name { owned get; }
		public string sample_format { owned get; }
		public int sample_rate { get; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_discoverer_get_type ()")]
	[Version (deprecated = true, deprecated_since = "0.10")]
	public class Discoverer : Clapper.Feature {
		[CCode (has_construct_function = false)]
		public Discoverer ();
		public Clapper.DiscovererDiscoveryMode get_discovery_mode ();
		public void set_discovery_mode (Clapper.DiscovererDiscoveryMode mode);
		public Clapper.DiscovererDiscoveryMode discovery_mode { get; set; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_enhancer_proxy_get_type ()")]
	[Version (since = "0.10")]
	public class EnhancerProxy : Gst.Object {
		[CCode (has_construct_function = false)]
		protected EnhancerProxy ();
		public bool extra_data_lists_value (string key, string value);
		public unowned string? get_description ();
		public unowned string? get_extra_data (string key);
		public unowned string get_friendly_name ();
		public unowned string get_module_dir ();
		public unowned string get_module_name ();
		public GLib.Settings? get_settings ();
		public bool get_target_creation_allowed ();
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		public unowned GLib.Type[]? get_target_interfaces ();
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		public unowned GLib.ParamSpec[]? get_target_properties ();
		public unowned string? get_version ();
		public void set_locally_with_table (GLib.HashTable<string,GLib.Value?> table);
		public void set_target_creation_allowed (bool allowed);
		public bool target_has_interface (GLib.Type iface_type);
		public string description { get; }
		public string friendly_name { get; }
		public string module_dir { get; }
		public string module_name { get; }
		public bool target_creation_allowed { get; set; }
		public string version { get; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_enhancer_proxy_list_get_type ()")]
	[Version (since = "0.10")]
	public class EnhancerProxyList : Gst.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected EnhancerProxyList ();
		public uint get_n_proxies ();
		public Clapper.EnhancerProxy? get_proxy (uint index);
		public Clapper.EnhancerProxy? get_proxy_by_module (string module_name);
		public unowned Clapper.EnhancerProxy? peek_proxy (uint index);
		public uint n_proxies { get; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_feature_get_type ()")]
	[Version (deprecated = true, deprecated_since = "0.10")]
	public class Feature : Gst.Object {
		[CCode (has_construct_function = false)]
		protected Feature ();
		[NoWrapper]
		public virtual void item_updated (Clapper.MediaItem item);
		[NoWrapper]
		public virtual void mute_changed (bool mute);
		[NoWrapper]
		public virtual void played_item_changed (Clapper.MediaItem item);
		[NoWrapper]
		public virtual void position_changed (double position);
		[NoWrapper]
		public virtual bool prepare ();
		[NoWrapper]
		public virtual void property_changed (GLib.ParamSpec pspec);
		[NoWrapper]
		public virtual void queue_cleared ();
		[NoWrapper]
		public virtual void queue_item_added (Clapper.MediaItem item, uint index);
		[NoWrapper]
		public virtual void queue_item_removed (Clapper.MediaItem item, uint index);
		[NoWrapper]
		public virtual void queue_item_repositioned (uint before, uint after);
		[NoWrapper]
		public virtual void queue_progression_changed (Clapper.QueueProgressionMode mode);
		[NoWrapper]
		public virtual void speed_changed (double speed);
		[NoWrapper]
		public virtual void state_changed (Clapper.PlayerState state);
		[NoWrapper]
		public virtual bool unprepare ();
		[NoWrapper]
		public virtual void volume_changed (double volume);
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_harvest_get_type ()")]
	[Version (since = "0.8")]
	public class Harvest : Gst.Object {
		[CCode (has_construct_function = false)]
		protected Harvest ();
		public bool fill (string media_type, [CCode (array_length_cname = "size", array_length_pos = 2.1, array_length_type = "gsize")] owned uint8[] data);
		public bool fill_with_bytes (string media_type, owned GLib.Bytes bytes);
		public bool fill_with_text (string media_type, owned string text);
		public void headers_set_value (string key, GLib.Value value);
		[Version (since = "0.10")]
		public void set_expiration_date_utc (GLib.DateTime date_utc);
		[Version (since = "0.10")]
		public void set_expiration_seconds (double seconds);
		public void tags_add_value (string tag, GLib.Value value);
		public void toc_add (Gst.TocEntryType type, string title, double start, double end);
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_marker_get_type ()")]
	public class Marker : Gst.Object {
		[CCode (has_construct_function = false)]
		public Marker (Clapper.MarkerType marker_type, string? title, double start, double end);
		public double get_end ();
		public Clapper.MarkerType get_marker_type ();
		public double get_start ();
		public unowned string? get_title ();
		public double end { get; construct; }
		public Clapper.MarkerType marker_type { get; construct; }
		public double start { get; construct; }
		public string title { get; construct; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_media_item_get_type ()")]
	public class MediaItem : Gst.Object {
		[CCode (has_construct_function = false)]
		public MediaItem (string uri);
		[CCode (has_construct_function = false)]
		[Version (since = "0.8")]
		public MediaItem.cached (string uri, string? location);
		[CCode (has_construct_function = false)]
		public MediaItem.from_file (GLib.File file);
		[Version (since = "0.10")]
		public string? get_cache_location ();
		[Version (deprecated = true, deprecated_since = "0.10")]
		public string? get_container_format ();
		public double get_duration ();
		public uint get_id ();
		[Version (since = "0.10")]
		public string? get_redirect_uri ();
		public string? get_suburi ();
		[Version (since = "0.10")]
		public Gst.TagList get_tags ();
		public unowned Clapper.Timeline get_timeline ();
		public string? get_title ();
		public unowned string get_uri ();
		[Version (since = "0.10")]
		public bool populate_tags (Gst.TagList tags);
		public void set_suburi (string suburi);
		[Version (since = "0.8")]
		public string cache_location { owned get; construct; }
		[Version (deprecated = true, deprecated_since = "0.10")]
		public string container_format { owned get; }
		public double duration { get; }
		public uint id { get; }
		[Version (since = "0.10")]
		public string redirect_uri { owned get; }
		public string suburi { owned get; set; }
		[Version (since = "0.10")]
		public Gst.TagList tags { owned get; }
		public Clapper.Timeline timeline { get; }
		public string title { owned get; }
		public string uri { get; construct; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_mpris_get_type ()")]
	[Version (deprecated = true, deprecated_since = "0.10")]
	public class Mpris : Clapper.Feature {
		[CCode (has_construct_function = false)]
		public Mpris (string own_name, string identity, string? desktop_entry);
		public string? get_fallback_art_url ();
		public bool get_queue_controllable ();
		public void set_fallback_art_url (string? art_url);
		public void set_queue_controllable (bool controllable);
		[NoAccessorMethod]
		public string desktop_entry { owned get; construct; }
		public string fallback_art_url { owned get; set; }
		[NoAccessorMethod]
		public string identity { owned get; construct; }
		[NoAccessorMethod]
		public string own_name { owned get; construct; }
		public bool queue_controllable { get; set; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_player_get_type ()")]
	public class Player : Clapper.ThreadedObject {
		[CCode (has_construct_function = false)]
		public Player ();
		public void add_feature (Clapper.Feature feature);
		[Version (since = "0.10")]
		public void advance_frame ();
		[Version (since = "0.8")]
		public uint get_adaptive_bandwidth ();
		[Version (since = "0.8")]
		public uint get_adaptive_max_bitrate ();
		[Version (since = "0.8")]
		public uint get_adaptive_min_bitrate ();
		[Version (since = "0.8")]
		public uint get_adaptive_start_bitrate ();
		public bool get_audio_enabled ();
		public Gst.Element get_audio_filter ();
		public double get_audio_offset ();
		public Gst.Element get_audio_sink ();
		public unowned Clapper.StreamList get_audio_streams ();
		public bool get_autoplay ();
		public Gst.Element get_current_audio_decoder ();
		public Gst.Element get_current_video_decoder ();
		[Version (since = "0.8")]
		public string? get_download_dir ();
		[Version (since = "0.8")]
		public bool get_download_enabled ();
		[Version (since = "0.10")]
		public unowned Clapper.EnhancerProxyList get_enhancer_proxies ();
		public bool get_mute ();
		public double get_position ();
		public unowned Clapper.Queue get_queue ();
		public double get_speed ();
		public Clapper.PlayerState get_state ();
		public string get_subtitle_font_desc ();
		public double get_subtitle_offset ();
		public unowned Clapper.StreamList get_subtitle_streams ();
		public bool get_subtitles_enabled ();
		public bool get_video_enabled ();
		public Gst.Element get_video_filter ();
		public Gst.Element get_video_sink ();
		public unowned Clapper.StreamList get_video_streams ();
		public double get_volume ();
		[Version (since = "0.10")]
		public string make_pipeline_graph (Gst.DebugGraphDetails details);
		public void pause ();
		public void play ();
		[Version (since = "0.10")]
		public void post_message (owned Gst.Message msg, Clapper.PlayerMessageDestination destination);
		public void seek (double position);
		public void seek_custom (double position, Clapper.PlayerSeekMethod method);
		[Version (since = "0.8")]
		public void set_adaptive_max_bitrate (uint bitrate);
		[Version (since = "0.8")]
		public void set_adaptive_min_bitrate (uint bitrate);
		[Version (since = "0.8")]
		public void set_adaptive_start_bitrate (uint bitrate);
		public void set_audio_enabled (bool enabled);
		public void set_audio_filter (Gst.Element? element);
		public void set_audio_offset (double offset);
		public void set_audio_sink (Gst.Element? element);
		public void set_autoplay (bool enabled);
		[Version (since = "0.8")]
		public void set_download_dir (string path);
		[Version (since = "0.8")]
		public void set_download_enabled (bool enabled);
		public void set_mute (bool mute);
		public void set_speed (double speed);
		public void set_subtitle_font_desc (string font_desc);
		public void set_subtitle_offset (double offset);
		public void set_subtitles_enabled (bool enabled);
		public void set_video_enabled (bool enabled);
		public void set_video_filter (Gst.Element? element);
		public void set_video_sink (Gst.Element? element);
		public void set_volume (double volume);
		public void stop ();
		[Version (since = "0.8")]
		public uint adaptive_bandwidth { get; }
		[Version (since = "0.8")]
		public uint adaptive_max_bitrate { get; set; }
		[Version (since = "0.8")]
		public uint adaptive_min_bitrate { get; set; }
		[Version (since = "0.8")]
		public uint adaptive_start_bitrate { get; set; }
		public bool audio_enabled { get; set; }
		public Gst.Element audio_filter { owned get; set; }
		public double audio_offset { get; set; }
		public Gst.Element audio_sink { owned get; set; }
		public Clapper.StreamList audio_streams { get; }
		public bool autoplay { get; set; }
		public Gst.Element current_audio_decoder { owned get; }
		public Gst.Element current_video_decoder { owned get; }
		[Version (since = "0.8")]
		public string download_dir { owned get; set; }
		[Version (since = "0.8")]
		public bool download_enabled { get; set; }
		[Version (since = "0.10")]
		public Clapper.EnhancerProxyList enhancer_proxies { get; }
		public bool mute { get; set; }
		public double position { get; }
		public Clapper.Queue queue { get; }
		public double speed { get; set; }
		public Clapper.PlayerState state { get; }
		public string subtitle_font_desc { owned get; set; }
		public double subtitle_offset { get; set; }
		public Clapper.StreamList subtitle_streams { get; }
		public bool subtitles_enabled { get; set; }
		public bool video_enabled { get; set; }
		public Gst.Element video_filter { owned get; set; }
		public Gst.Element video_sink { owned get; set; }
		public Clapper.StreamList video_streams { get; }
		public double volume { get; set; }
		[Version (since = "0.8")]
		public signal void download_complete (Clapper.MediaItem item, string location);
		public signal void error (GLib.Error error, string? debug_info);
		[Version (since = "0.10")]
		public signal void message (Gst.Message msg);
		public signal void missing_plugin (string name, string? installer_detail);
		public signal void seek_done ();
		public signal void warning (GLib.Error error, string? debug_info);
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_queue_get_type ()")]
	public class Queue : Gst.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Queue ();
		public void add_item (Clapper.MediaItem item);
		public void clear ();
		public bool find_item (Clapper.MediaItem item, out uint index);
		public uint get_current_index ();
		public Clapper.MediaItem? get_current_item ();
		public bool get_gapless ();
		public bool get_instant ();
		public Clapper.QueueProgressionMode get_progression_mode ();
		public void insert_item (Clapper.MediaItem item, int index);
		[Version (since = "0.10")]
		public void insert_item_after (Clapper.MediaItem item, Clapper.MediaItem? after_item);
		public bool item_is_current (Clapper.MediaItem item);
		public void remove_index (uint index);
		public void remove_item (Clapper.MediaItem item);
		public void reposition_item (Clapper.MediaItem item, int index);
		public bool select_index (uint index);
		public bool select_item (Clapper.MediaItem? item);
		public bool select_next_item ();
		public bool select_previous_item ();
		public void set_gapless (bool gapless);
		public void set_instant (bool instant);
		public void set_progression_mode (Clapper.QueueProgressionMode mode);
		public Clapper.MediaItem? steal_index (uint index);
		[NoAccessorMethod]
		public uint current_index { get; set; }
		public Clapper.MediaItem current_item { owned get; }
		public bool gapless { get; set; }
		public bool instant { get; set; }
		[NoAccessorMethod]
		public uint n_items { get; }
		public Clapper.QueueProgressionMode progression_mode { get; set; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_server_get_type ()")]
	[Version (deprecated = true, deprecated_since = "0.10")]
	public class Server : Clapper.Feature {
		[CCode (has_construct_function = false)]
		public Server ();
		public uint get_current_port ();
		public bool get_enabled ();
		public uint get_port ();
		public bool get_queue_controllable ();
		public bool get_running ();
		public void set_enabled (bool enabled);
		public void set_port (uint port);
		public void set_queue_controllable (bool controllable);
		public uint current_port { get; }
		public bool enabled { get; set; }
		public uint port { get; set; }
		public bool queue_controllable { get; set; }
		public bool running { get; }
		public signal void error (GLib.Error error);
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_stream_get_type ()")]
	public class Stream : Gst.Object {
		[CCode (has_construct_function = false)]
		protected Stream ();
		public Clapper.StreamType get_stream_type ();
		public string? get_title ();
		[NoWrapper]
		public virtual void internal_stream_updated (Gst.Caps? caps, Gst.TagList? tags);
		public Clapper.StreamType stream_type { get; construct; }
		public string title { owned get; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_stream_list_get_type ()")]
	public class StreamList : Gst.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected StreamList ();
		public uint get_current_index ();
		public Clapper.Stream? get_current_stream ();
		public uint get_n_streams ();
		public Clapper.Stream? get_stream (uint index);
		public bool select_index (uint index);
		public bool select_stream (Clapper.Stream stream);
		[NoAccessorMethod]
		public uint current_index { get; set; }
		public Clapper.Stream current_stream { owned get; }
		public uint n_streams { get; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_subtitle_stream_get_type ()")]
	public class SubtitleStream : Clapper.Stream {
		[CCode (has_construct_function = false)]
		protected SubtitleStream ();
		public string? get_lang_code ();
		public string? get_lang_name ();
		public string lang_code { owned get; }
		public string lang_name { owned get; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_threaded_object_get_type ()")]
	public class ThreadedObject : Gst.Object {
		[CCode (has_construct_function = false)]
		protected ThreadedObject ();
		public unowned GLib.MainContext get_context ();
		[NoWrapper]
		public virtual void thread_start ();
		[NoWrapper]
		public virtual void thread_stop ();
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_timeline_get_type ()")]
	public class Timeline : Gst.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Timeline ();
		public Clapper.Marker? get_marker (uint index);
		public uint get_n_markers ();
		public void insert_marker (Clapper.Marker marker);
		public void remove_marker (Clapper.Marker marker);
		public uint n_markers { get; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_id = "clapper_video_stream_get_type ()")]
	public class VideoStream : Clapper.Stream {
		[CCode (has_construct_function = false)]
		protected VideoStream ();
		public uint get_bitrate ();
		public string? get_codec ();
		public double get_fps ();
		public int get_height ();
		public string? get_pixel_format ();
		public int get_width ();
		public uint bitrate { get; }
		public string codec { owned get; }
		public double fps { get; }
		public int height { get; }
		public string pixel_format { owned get; }
		public int width { get; }
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_cname = "ClapperExtractableInterface", type_id = "clapper_extractable_get_type ()")]
	[Version (since = "0.8")]
	public interface Extractable : GLib.Object {
		[NoWrapper]
		public abstract bool extract (GLib.Uri uri, Clapper.Harvest harvest, GLib.Cancellable cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_cname = "ClapperPlaylistableInterface", type_id = "clapper_playlistable_get_type ()")]
	[Version (since = "0.10")]
	public interface Playlistable : GLib.Object {
		[NoWrapper]
		public abstract bool parse (GLib.Uri uri, GLib.Bytes bytes, GLib.ListStore playlist, GLib.Cancellable cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "clapper/clapper.h", type_cname = "ClapperReactableInterface", type_id = "clapper_reactable_get_type ()")]
	[Version (since = "0.10")]
	public interface Reactable : Gst.Object {
		public Clapper.Player? get_player ();
		[NoWrapper]
		public abstract void item_updated (Clapper.MediaItem item, Clapper.ReactableItemUpdatedFlags flags);
		[NoWrapper]
		public abstract void message_received (Gst.Message msg);
		[NoWrapper]
		public abstract void mute_changed (bool mute);
		[NoWrapper]
		public abstract void played_item_changed (Clapper.MediaItem item);
		[NoWrapper]
		public abstract void position_changed (double position);
		public void queue_append_sync (Clapper.MediaItem item);
		public void queue_clear_sync ();
		[NoWrapper]
		public abstract void queue_cleared ();
		public void queue_insert_sync (Clapper.MediaItem item, Clapper.MediaItem after_item);
		[NoWrapper]
		public abstract void queue_item_added (Clapper.MediaItem item, uint index);
		[NoWrapper]
		public abstract void queue_item_removed (Clapper.MediaItem item, uint index);
		[NoWrapper]
		public abstract void queue_item_repositioned (uint before, uint after);
		[NoWrapper]
		public abstract void queue_progression_changed (Clapper.QueueProgressionMode mode);
		public void queue_remove_sync (Clapper.MediaItem item);
		[NoWrapper]
		public abstract void speed_changed (double speed);
		[NoWrapper]
		public abstract void state_changed (Clapper.PlayerState state);
		public void timeline_insert_sync (Clapper.Timeline timeline, Clapper.Marker marker);
		public void timeline_remove_sync (Clapper.Timeline timeline, Clapper.Marker marker);
		[NoWrapper]
		public abstract void volume_changed (double volume);
	}
	[CCode (cheader_filename = "clapper/clapper.h", cprefix = "CLAPPER_DISCOVERER_DISCOVERY_", type_id = "clapper_discoverer_discovery_mode_get_type ()")]
	[Version (deprecated = true, deprecated_since = "0.10")]
	public enum DiscovererDiscoveryMode {
		ALWAYS,
		NONCURRENT
	}
	[CCode (cheader_filename = "clapper/clapper.h", cprefix = "CLAPPER_ENHANCER_PARAM_", type_id = "clapper_enhancer_param_flags_get_type ()")]
	[Flags]
	[Version (since = "0.10")]
	public enum EnhancerParamFlags {
		GLOBAL,
		LOCAL,
		FILEPATH,
		DIRPATH
	}
	[CCode (cheader_filename = "clapper/clapper.h", cprefix = "CLAPPER_MARKER_TYPE_", type_id = "clapper_marker_type_get_type ()")]
	public enum MarkerType {
		UNKNOWN,
		TITLE,
		CHAPTER,
		TRACK,
		CUSTOM_1,
		CUSTOM_2,
		CUSTOM_3
	}
	[CCode (cheader_filename = "clapper/clapper.h", cprefix = "CLAPPER_PLAYER_MESSAGE_DESTINATION_", type_id = "clapper_player_message_destination_get_type ()")]
	[Version (since = "0.10")]
	public enum PlayerMessageDestination {
		PLAYER,
		REACTABLES,
		APPLICATION
	}
	[CCode (cheader_filename = "clapper/clapper.h", cprefix = "CLAPPER_PLAYER_SEEK_METHOD_", type_id = "clapper_player_seek_method_get_type ()")]
	public enum PlayerSeekMethod {
		ACCURATE,
		NORMAL,
		FAST
	}
	[CCode (cheader_filename = "clapper/clapper.h", cprefix = "CLAPPER_PLAYER_STATE_", type_id = "clapper_player_state_get_type ()")]
	public enum PlayerState {
		STOPPED,
		BUFFERING,
		PAUSED,
		PLAYING
	}
	[CCode (cheader_filename = "clapper/clapper.h", cprefix = "CLAPPER_QUEUE_PROGRESSION_", type_id = "clapper_queue_progression_mode_get_type ()")]
	public enum QueueProgressionMode {
		NONE,
		CONSECUTIVE,
		REPEAT_ITEM,
		CAROUSEL,
		SHUFFLE
	}
	[CCode (cheader_filename = "clapper/clapper.h", cprefix = "CLAPPER_REACTABLE_ITEM_UPDATED_", type_id = "clapper_reactable_item_updated_flags_get_type ()")]
	[Flags]
	[Version (since = "0.10")]
	public enum ReactableItemUpdatedFlags {
		TITLE,
		DURATION,
		TIMELINE,
		TAGS,
		REDIRECT_URI,
		CACHE_LOCATION
	}
	[CCode (cheader_filename = "clapper/clapper.h", cprefix = "CLAPPER_STREAM_TYPE_", type_id = "clapper_stream_type_get_type ()")]
	public enum StreamType {
		UNKNOWN,
		VIDEO,
		AUDIO,
		SUBTITLE
	}
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_HAVE_DISCOVERER")]
	public const bool HAVE_DISCOVERER;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_HAVE_MPRIS")]
	public const bool HAVE_MPRIS;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_HAVE_SERVER")]
	public const bool HAVE_SERVER;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_MARKER_NO_END")]
	public const double MARKER_NO_END;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_QUEUE_INVALID_POSITION")]
	public const uint QUEUE_INVALID_POSITION;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_STREAM_LIST_INVALID_POSITION")]
	public const uint STREAM_LIST_INVALID_POSITION;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_TIME_FORMAT")]
	public const string TIME_FORMAT;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_TIME_MS_FORMAT")]
	public const string TIME_MS_FORMAT;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_VERSION_S")]
	public const string VERSION_S;
	[CCode (cheader_filename = "clapper/clapper.h", cname = "CLAPPER_WITH_ENHANCERS_LOADER")]
	[Version (since = "0.8")]
	public const bool WITH_ENHANCERS_LOADER;
	[CCode (cheader_filename = "clapper/clapper.h")]
	[Version (deprecated = true, deprecated_since = "0.10", since = "0.8")]
	public static bool enhancer_check (GLib.Type iface_type, string scheme, string? host, out unowned string name);
	[CCode (cheader_filename = "clapper/clapper.h")]
	[Version (since = "0.10")]
	public static unowned Clapper.EnhancerProxyList get_global_enhancer_proxies ();
	[CCode (cheader_filename = "clapper/clapper.h")]
	[Version (since = "0.10")]
	public static uint get_major_version ();
	[CCode (cheader_filename = "clapper/clapper.h")]
	[Version (since = "0.10")]
	public static uint get_micro_version ();
	[CCode (cheader_filename = "clapper/clapper.h")]
	[Version (since = "0.10")]
	public static uint get_minor_version ();
	[CCode (cheader_filename = "clapper/clapper.h")]
	[Version (since = "0.10")]
	public static unowned string get_version_s ();
	[CCode (cheader_filename = "clapper/clapper.h")]
	public static void init ([CCode (array_length_cname = "argc", array_length_pos = 0.5)] ref unowned string[]? argv);
	[CCode (cheader_filename = "clapper/clapper.h")]
	public static bool init_check ([CCode (array_length_cname = "argc", array_length_pos = 0.5)] ref unowned string[]? argv);
}
