/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.daten.ListePset;
import mediathek.daten.ListePsetVorlagen;
import mediathek.gui.PanelVorlage;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.TextCopyPasteHandler;
import mediathek.tool.models.NonEditableTableModel;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PanelPsetImport
extends PanelVorlage {
    private final ListePsetVorlagen listePsetVorlagen = new ListePsetVorlagen();
    private static final Logger logger = LogManager.getLogger();
    private JButton jButtonAktualisieren;
    private JButton jButtonImportDatei;
    private JButton jButtonImportStandard;
    private JButton jButtonImportText;
    private JButton jButtonImportVorlage;
    private JButton jButtonPfad;
    private JComboBox<String> jComboBoxBs;
    private JTable jTableVorlagen;
    private JTextArea jTextAreaBeschreibung;
    private JTextArea jTextAreaImport;
    private JTextField jTextFieldBs;
    private JTextField jTextFieldDatei;
    private JTextField jTextFieldName;
    private JTextField jTextFieldUrl;

    public PanelPsetImport(Daten d, JFrame parentComponent) {
        super(d, parentComponent);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jButtonAktualisieren.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/arrows-rotate.svg"));
        this.jButtonPfad.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg"));
        this.jComboBoxBs.setModel(new DefaultComboBoxModel<String>(ListePsetVorlagen.BS));
        this.jComboBoxBs.addActionListener(e -> this.tabelleLaden());
        this.jButtonImportDatei.setEnabled(false);
        this.jButtonImportText.setEnabled(false);
        this.jButtonPfad.addActionListener(new BeobPfad());
        this.jTextFieldDatei.getDocument().addDocumentListener(new BeobPfadDoc());
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldDatei);
        this.jTextFieldDatei.setComponentPopupMenu(handler.getPopupMenu());
        this.jTextAreaImport.getDocument().addDocumentListener(new BeobTextArea());
        TextCopyPasteHandler<JTextArea> handler2 = new TextCopyPasteHandler<JTextArea>(this.jTextAreaImport);
        this.jTextAreaImport.setComponentPopupMenu(handler2.getPopupMenu());
        this.jButtonImportVorlage.addActionListener(e -> {
            if (!this.jTextFieldUrl.getText().isEmpty()) {
                this.importDatei(this.jTextFieldUrl.getText());
            }
        });
        this.jButtonImportDatei.addActionListener(e -> this.importDatei(this.jTextFieldDatei.getText()));
        this.jButtonImportText.addActionListener(e -> this.importText());
        this.jButtonAktualisieren.addActionListener(e -> {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.listePsetVorlagen.loadListOfSets();
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.tabelleLaden();
        });
        this.jTableVorlagen.getSelectionModel().addListSelectionListener(new BeobTableSelect());
        this.jTableVorlagen.setModel(new NonEditableTableModel(new Object[0][], ListePsetVorlagen.PGR_COLUMN_NAMES));
        if (!Config.isDebugModeEnabled()) {
            TableColumnModel colModel = this.jTableVorlagen.getColumnModel();
            colModel.getColumn(this.jTableVorlagen.convertColumnIndexToView(2)).setMinWidth(0);
            colModel.getColumn(this.jTableVorlagen.convertColumnIndexToView(2)).setPreferredWidth(0);
            colModel.getColumn(this.jTableVorlagen.convertColumnIndexToView(2)).setMaxWidth(0);
        }
        this.jButtonImportStandard.addActionListener(e -> GuiFunktionenProgramme.addSetVorlagen(this.parentComponent, this.daten, ListePsetVorlagen.getStandarset(this.parentComponent, true), true));
    }

    private void importDatei(String datei) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ListePset listePset = ListePsetVorlagen.importPsetFile(datei, true);
        if (listePset != null) {
            ListePset.progMusterErsetzen(this.parentComponent, listePset);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        GuiFunktionenProgramme.addSetVorlagen(this.parentComponent, this.daten, listePset, false);
    }

    private void importText() {
        ListePset listePset = ListePsetVorlagen.importPsetText(this.jTextAreaImport.getText(), true);
        if (listePset != null) {
            ListePset.progMusterErsetzen(this.parentComponent, listePset);
        }
        GuiFunktionenProgramme.addSetVorlagen(this.parentComponent, this.daten, listePset, false);
    }

    private void tabelleLaden() {
        this.jTableVorlagen.setModel(this.listePsetVorlagen.createModel(this.jComboBoxBs.getSelectedItem().toString()));
        if (!Config.isDebugModeEnabled()) {
            this.jTableVorlagen.getColumnModel().getColumn(this.jTableVorlagen.convertColumnIndexToView(2)).setMinWidth(0);
            this.jTableVorlagen.getColumnModel().getColumn(this.jTableVorlagen.convertColumnIndexToView(2)).setPreferredWidth(0);
            this.jTableVorlagen.getColumnModel().getColumn(this.jTableVorlagen.convertColumnIndexToView(2)).setMaxWidth(0);
        }
    }

    private void table1Select() {
        Object[] vorlage = new String[6];
        Arrays.fill(vorlage, "");
        int selectedTableRow = this.jTableVorlagen.getSelectedRow();
        if (selectedTableRow >= 0) {
            int selectedModelRow = this.jTableVorlagen.convertRowIndexToModel(selectedTableRow);
            TableModel model = this.jTableVorlagen.getModel();
            for (int i = 0; i < 6; ++i) {
                vorlage[i] = model.getValueAt(selectedModelRow, i).toString();
            }
        }
        this.jTextFieldName.setText((String)vorlage[0]);
        this.jTextFieldBs.setText((String)vorlage[3]);
        this.jTextFieldUrl.setText((String)vorlage[4]);
        this.jTextAreaBeschreibung.setText((String)vorlage[1]);
    }

    private void initComponents() {
        JTabbedPane jTabbedPane1 = new JTabbedPane();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.jTableVorlagen = new JTable();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldUrl = new JTextField();
        JLabel jLabel3 = new JLabel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.jTextAreaBeschreibung = new JTextArea();
        this.jButtonImportVorlage = new JButton();
        JLabel jLabel6 = new JLabel();
        this.jTextFieldBs = new JTextField();
        this.jButtonAktualisieren = new JButton();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.jComboBoxBs = new JComboBox();
        JPanel jPanel5 = new JPanel();
        this.jButtonImportStandard = new JButton();
        JScrollPane jScrollPane4 = new JScrollPane();
        JTextArea jTextArea1 = new JTextArea();
        JPanel jPanel1 = new JPanel();
        JPanel jPanel6 = new JPanel();
        this.jTextFieldDatei = new JTextField();
        this.jButtonPfad = new JButton();
        this.jButtonImportDatei = new JButton();
        JLabel jLabel7 = new JLabel();
        JPanel jPanel7 = new JPanel();
        this.jTextAreaImport = new JTextArea();
        this.jButtonImportText = new JButton();
        this.jTableVorlagen.setModel(new NonEditableTableModel());
        jScrollPane2.setViewportView(this.jTableVorlagen);
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jLabel1.setText("Name:");
        this.jTextFieldName.setEditable(false);
        jLabel2.setText("URL:");
        this.jTextFieldUrl.setEditable(false);
        jLabel3.setText("Beschreibung:");
        this.jTextAreaBeschreibung.setEditable(false);
        this.jTextAreaBeschreibung.setColumns(20);
        this.jTextAreaBeschreibung.setRows(5);
        jScrollPane3.setViewportView(this.jTextAreaBeschreibung);
        this.jButtonImportVorlage.setText("Set importieren");
        jLabel6.setText("Betriebssystem:");
        this.jTextFieldBs.setEditable(false);
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel1).addComponent(jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldBs).addComponent(this.jTextFieldName))).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonImportVorlage)).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel2).addComponent(jLabel3)).addGap(26, 26, 26).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldUrl).addComponent(jScrollPane3, -1, 461, Short.MAX_VALUE)))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(this.jTextFieldBs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.jTextFieldUrl, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel3).addComponent(jScrollPane3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonImportVorlage).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(1, this.jButtonImportVorlage, this.jTextFieldBs, this.jTextFieldName, this.jTextFieldUrl);
        this.jButtonAktualisieren.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-aktualisieren.png")));
        this.jButtonAktualisieren.setToolTipText("Neu laden");
        jLabel4.setText("Vorlagen von der Website laden:");
        jLabel5.setText("Betriebssystem:");
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jScrollPane2, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxBs, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAktualisieren))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(7, 7, 7).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel4).addComponent(this.jButtonAktualisieren).addComponent(jLabel5).addComponent(this.jComboBoxBs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane2, -1, 216, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel4, -2, -1, -2).addContainerGap()));
        jTabbedPane1.addTab("Setvorlagen", jPanel3);
        this.jButtonImportStandard.setText("Set anlegen");
        jTextArea1.setEditable(false);
        jTextArea1.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        jTextArea1.setColumns(20);
        jTextArea1.setRows(5);
        jTextArea1.setText("Die Standardsets, die beim ersten Programmstart\nangelegt wurden, nochmals anlegen.\n\nDie bestehenden Sets bleiben unver\u00e4ndert erhalten,\nsollten jedoch vorher unter \"Set bearbeiten\" umbenannt\nwerden, z.B. von \"Speichern\" zu \"Speichern alt\".\n\nSoll aber der Ursprungszustand wieder hergestellt werden,\nm\u00fcssen vorher alle bestehenden Sets gel\u00f6scht werden.");
        jTextArea1.setMargin(new Insets(5, 5, 5, 5));
        jScrollPane4.setViewportView(jTextArea1);
        GroupLayout jPanel5Layout = new GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane4, -1, 591, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonImportStandard))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane4, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonImportStandard).addContainerGap(302, Short.MAX_VALUE)));
        jTabbedPane1.addTab("Standardset", jPanel5);
        jPanel6.setBorder(BorderFactory.createTitledBorder("Set aus Datei importieren"));
        this.jButtonPfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonPfad.setToolTipText("URL/Datei ausw\u00e4hlen");
        this.jButtonImportDatei.setText("Set importieren");
        jLabel7.setText("Datei/URL:");
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap(12, -2).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addComponent(jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDatei).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPfad)).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonImportDatei))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonPfad).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDatei, -2, -1, -2).addComponent(jLabel7))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonImportDatei).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.linkSize(1, this.jButtonPfad, this.jTextFieldDatei);
        jPanel7.setBorder(BorderFactory.createTitledBorder("Set als Text importieren"));
        this.jTextAreaImport.setColumns(20);
        this.jTextAreaImport.setRows(5);
        this.jTextAreaImport.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jButtonImportText.setText("Set importieren");
        GroupLayout jPanel7Layout = new GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextAreaImport, -1, 557, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonImportText))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextAreaImport, -1, 309, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonImportText).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel7, -1, -1, Short.MAX_VALUE).addComponent(jPanel6, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel7, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jTabbedPane1.addTab("Set importieren", jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jTabbedPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jTabbedPane1).addContainerGap()));
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog((Frame)MediathekGui.ui(), "Programmset ausw\u00e4hlen");
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        PanelPsetImport.this.jTextFieldDatei.setText(new File(chooser.getDirectory() + chooser.getFile()).getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                if (PanelPsetImport.this.jTextFieldDatei.getText().isEmpty()) {
                    chooser.setCurrentDirectory(new File(SystemUtils.USER_HOME));
                } else {
                    chooser.setCurrentDirectory(new File(PanelPsetImport.this.jTextFieldDatei.getText()));
                }
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        PanelPsetImport.this.jTextFieldDatei.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
            }
        }
    }

    private class BeobPfadDoc
    implements DocumentListener {
        private BeobPfadDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            PanelPsetImport.this.jButtonImportDatei.setEnabled(!PanelPsetImport.this.jTextFieldDatei.getText().equals(""));
            if (PanelPsetImport.this.jTextFieldDatei.getText().equals("")) {
                PanelPsetImport.this.jTextFieldDatei.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            } else if (ListePsetVorlagen.importPsetFile(PanelPsetImport.this.jTextFieldDatei.getText(), false) != null) {
                PanelPsetImport.this.jTextFieldDatei.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            } else {
                PanelPsetImport.this.jTextFieldDatei.setBackground(new Color(255, 200, 200));
            }
        }
    }

    private class BeobTextArea
    implements DocumentListener {
        private BeobTextArea() {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            PanelPsetImport.this.jButtonImportText.setEnabled(!PanelPsetImport.this.jTextAreaImport.getText().equals(""));
            if (PanelPsetImport.this.jTextAreaImport.getText().equals("")) {
                PanelPsetImport.this.jTextAreaImport.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
            } else if (ListePsetVorlagen.importPsetText(PanelPsetImport.this.jTextAreaImport.getText(), false) != null) {
                PanelPsetImport.this.jTextAreaImport.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
                PanelPsetImport.this.jButtonImportText.setEnabled(true);
            } else {
                PanelPsetImport.this.jTextAreaImport.setBackground(new Color(255, 200, 200));
                PanelPsetImport.this.jButtonImportText.setEnabled(false);
            }
        }
    }

    private class BeobTableSelect
    implements ListSelectionListener {
        private BeobTableSelect() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                PanelPsetImport.this.table1Select();
            }
        }
    }
}

