/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import oracle.jdbc.OracleConnectionWrapper;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.Datum;
import oracle.sql.Kotad;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public class TypeDescriptor
implements OracleTypeMetaData,
Serializable,
ORAData,
OracleData,
Diagnosable {
    private static final String CLASS_NAME = TypeDescriptor.class.getName();
    public static boolean DEBUG_SERIALIZATION = false;
    static final long serialVersionUID = 2022598722047823723L;
    public static final int KOIDFLEN = 16;
    static final short KOTA_TRN = 1;
    static final short KOTA_PDF = 2;
    static final short KOTA_ITOID = 4;
    static final short KOTA_LOB = 8;
    static final short KOTA_AD = 16;
    static final short KOTA_NMHSH = 32;
    static final short KOTA_TEV = 64;
    static final short KOTA_INH = 128;
    static final short KOTA_10I = 256;
    static final short KOTA_RBF = 512;
    static final short KOTA_HBF = 1024;
    static final int ANYTYPE_IMAGE_SIZE_TOID = 23;
    static final int ANYTYPE_IMAGE_SIZE_NO_TOID = 5;
    static final byte KOTTDOID = 1;
    static final byte KOTTBOID = 2;
    static final byte KOTADOID = 3;
    static final byte KOTREFOID = 4;
    static final byte KOTMDOID = 5;
    static final byte KOTMIOID = 6;
    static final byte KOTEXOID = 7;
    static final byte KOTDATOID = 8;
    static final byte KOTBYTOID = 9;
    static final byte KOTSHOOID = 10;
    static final byte KOTLONOID = 11;
    static final byte KOTREAOID = 12;
    static final byte KOTDOUOID = 13;
    static final byte KOTFLOOID = 14;
    static final byte KOTNUMOID = 15;
    static final byte KOTDECOID = 16;
    static final byte KOTUBYOID = 17;
    static final byte KOTUSHOID = 18;
    static final byte KOTULOOID = 19;
    static final byte KOTOCTOID = 20;
    static final byte KOTSMLOID = 21;
    static final byte KOTINTOID = 22;
    static final byte KOTRAWOID = 23;
    static final byte KOTPTROID = 24;
    static final byte KOTVSIOID = 25;
    static final byte KOTFSIOID = 26;
    static final byte KOTVSOOID = 27;
    static final byte KOTMLSOID = 28;
    static final byte KOTVAROID = 29;
    static final byte KOTMSTOID = 30;
    static final byte KOTNATOID = 31;
    static final byte KOTDOMOID = 32;
    static final byte KOTUND1OID = 33;
    static final byte KOTCLBOID = 34;
    static final byte KOTBLBOID = 35;
    static final byte KOTCFLOID = 36;
    static final byte KOTBFLOID = 37;
    static final byte KOTOIDOID = 38;
    static final byte KOTCAROID = 39;
    static final byte KOTCANOID = 40;
    static final byte KOTLPTOID = 41;
    static final byte KOTBRIOID = 42;
    static final byte KOTUCOOID = 43;
    static final byte KOTRECOID = 44;
    static final byte KOTRCUOID = 45;
    static final byte KOTBOOOID = 46;
    static final byte KOTRIDOID = 47;
    static final byte KOTPLOOID = 48;
    static final byte KOTPLROID = 49;
    static final byte KOTPBIOID = 50;
    static final byte KOTPINOID = 51;
    static final byte KOTPNAOID = 52;
    static final byte KOTPNNOID = 53;
    static final byte KOTPPOOID = 54;
    static final byte KOTPPNOID = 55;
    static final byte KOTPSTOID = 56;
    static final byte KOTEX1OID = 57;
    static final byte KOTOPQOID = 58;
    static final byte KOTTMOID = 59;
    static final byte KOTTMTZOID = 60;
    static final byte KOTTSOID = 61;
    static final byte KOTTSTZOID = 62;
    static final byte KOTIYMOID = 63;
    static final byte KOTIDSOID = 64;
    static final byte KOTTSIMPTZOID = 65;
    static final byte KOTTBXOID = 66;
    static final byte KOTADXOID = 67;
    static final byte KOTOIDBFLT = 68;
    static final byte KOTOIDBDBL = 69;
    static final byte KOTURDOID = 70;
    static final byte KOTJSONOID = 71;
    static final byte KOTLASTOID = 72;
    static final byte[] KOTTDEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1};
    static final byte[] KOTTBEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2};
    static final byte[] KOTADEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3};
    static final byte[] KOTMDEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4};
    static final byte[] KOTTBXEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 66};
    static final byte[] KOTADXEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 67};
    static final byte[] KOTTDTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    static final byte[] KOTTBTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
    static final byte[] KOTADTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3};
    static final byte[] KOTMDTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5};
    static final byte[] KOTMITOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6};
    static final byte[] KOTEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7};
    static final byte[] KOTEX1TOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57};
    static final byte[] KOTTBXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66};
    static final byte[] KOTADXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67};
    public static final byte[] RAWTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23};
    public static final byte[] JSONTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71};
    public static final byte[] ANYTYPETOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 16};
    public static final byte[] ANYDATATOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 17};
    public static final byte[] ANYDATASETTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 18};
    public static final byte[] XMLTYPETOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 0};
    static final short SQLT_NONE = 0;
    static final short SQLT_CHR = 1;
    static final short SQLT_NUM = 2;
    static final short SQLT_INT = 3;
    static final short SQLT_FLT = 4;
    static final short SQLT_STR = 5;
    static final short SQLT_VNU = 6;
    static final short SQLT_PDN = 7;
    static final short SQLT_LNG = 8;
    static final short SQLT_VCS = 9;
    static final short SQLT_NON = 10;
    static final short SQLT_RID = 11;
    static final short SQLT_DAT = 12;
    static final short SQLT_VBI = 15;
    static final short SQLT_BFLOAT = 21;
    static final short SQLT_BDOUBLE = 22;
    static final short SQLT_BIN = 23;
    static final short SQLT_LBI = 24;
    static final short SQLT_UIN = 68;
    static final short SQLT_SLS = 91;
    static final short SQLT_LVC = 94;
    static final short SQLT_LVB = 95;
    static final short SQLT_AFC = 96;
    static final short SQLT_AVC = 97;
    static final short SQLT_IBFLOAT = 100;
    static final short SQLT_IBDOUBLE = 101;
    static final short SQLT_CUR = 102;
    static final short SQLT_RDD = 104;
    static final short SQLT_LAB = 105;
    static final short SQLT_OSL = 106;
    static final short SQLT_NTY = 108;
    static final short SQLT_REF = 110;
    static final short SQLT_CLOB = 112;
    static final short SQLT_BLOB = 113;
    static final short SQLT_BFILEE = 114;
    static final short SQLT_FILE = 114;
    static final short SQLT_CFILEE = 115;
    static final short SQLT_RSET = 116;
    static final short SQLT_SVT = 118;
    static final short SQLT_NCO = 122;
    static final short SQLT_DTR = 152;
    static final short SQLT_DUN = 153;
    static final short SQLT_DOP = 154;
    static final short SQLT_VST = 155;
    static final short SQLT_ODT = 156;
    static final short SQLT_DOL = 172;
    static final short SQLT_DATE = 184;
    static final short SQLT_TIME = 185;
    static final short SQLT_TIME_TZ = 186;
    static final short SQLT_TIMESTAMP = 187;
    static final short SQLT_TIMESTAMP_TZ = 188;
    static final short SQLT_INTERVAL_YM = 189;
    static final short SQLT_INTERVAL_DS = 190;
    static final short SQLT_TIMESTAMP_LTZ = 232;
    static final short SQLT_PNTY = 241;
    static final short SQLT_CFILE = 115;
    static final short SQLT_BFILE = 114;
    static final short SQLT_REC = 250;
    static final short SQLT_TAB = 251;
    static final short SQLT_BOL = 252;
    static final short SQLCS_IMPLICIT = 1;
    static final short SQLCS_NCHAR = 2;
    static final short SQLCS_EXPLICIT = 3;
    static final short SQLCS_FLEXIBLE = 4;
    static final short SQLCS_LIT_NULL = 5;
    static final short SQLT_XDP = 103;
    static final short SQLT_OKO = 107;
    static final short SQLT_INTY = 109;
    static final short SQLT_IREF = 111;
    static final short SQLT_DCLOB = 195;
    public static final short TYPECODE_REF = 110;
    public static final short TYPECODE_DATE = 12;
    public static final short TYPECODE_SIGNED8 = 27;
    public static final short TYPECODE_SIGNED16 = 28;
    public static final short TYPECODE_SIGNED32 = 29;
    public static final short TYPECODE_REAL = 21;
    public static final short TYPECODE_DOUBLE = 22;
    public static final short TYPECODE_BFLOAT = 100;
    public static final short TYPECODE_BDOUBLE = 101;
    public static final short TYPECODE_FLOAT = 4;
    public static final short TYPECODE_NUMBER = 2;
    public static final short TYPECODE_DECIMAL = 7;
    public static final short TYPECODE_UNSIGNED8 = 23;
    public static final short TYPECODE_UNSIGNED16 = 25;
    public static final short TYPECODE_UNSIGNED32 = 26;
    public static final short TYPECODE_OCTET = 245;
    public static final short TYPECODE_SMALLINT = 246;
    public static final short TYPECODE_INTEGER = 3;
    public static final short TYPECODE_RAW = 95;
    public static final short TYPECODE_PTR = 32;
    public static final short TYPECODE_VARCHAR2 = 9;
    public static final short TYPECODE_CHAR = 96;
    public static final short TYPECODE_VARCHAR = 1;
    public static final short TYPECODE_MLSLABEL = 105;
    public static final short TYPECODE_VARRAY = 247;
    public static final short TYPECODE_TABLE = 248;
    public static final short TYPECODE_OBJECT = 108;
    public static final short TYPECODE_OPAQUE = 58;
    public static final short TYPECODE_NAMEDCOLLECTION = 122;
    public static final short TYPECODE_BLOB = 113;
    public static final short TYPECODE_BFILE = 114;
    public static final short TYPECODE_CLOB = 112;
    public static final short TYPECODE_CFILE = 115;
    public static final short TYPECODE_TIME = 185;
    public static final short TYPECODE_TIME_TZ = 186;
    public static final short TYPECODE_TIMESTAMP = 187;
    public static final short TYPECODE_TIMESTAMP_TZ = 188;
    public static final short TYPECODE_TIMESTAMP_LTZ = 232;
    public static final short TYPECODE_INTERVAL_YM = 189;
    public static final short TYPECODE_INTERVAL_DS = 190;
    public static final short TYPECODE_UROWID = 104;
    public static final short TYPECODE_OTMFIRST = 228;
    public static final short TYPECODE_OTMLAST = 320;
    public static final short TYPECODE_SYSFIRST = 228;
    public static final short TYPECODE_SYSLAST = 235;
    public static final short TYPECODE_PLS_INTEGER = 266;
    public static final short TYPECODE_ITABLE = 251;
    public static final short TYPECODE_RECORD = 250;
    public static final short TYPECODE_BOOLEAN = 252;
    public static final short TYPECODE_NCHAR = 286;
    public static final short TYPECODE_NVARCHAR2 = 287;
    public static final short TYPECODE_NCLOB = 288;
    public static final short TYPECODE_NONE = 0;
    public static final short TYPECODE_ERRHP = 283;
    public static final short TYPECODE_JDBC_JOBJECT = 2000;
    public static final short TYPECODE_JDBC_STRUCT = 2002;
    public static final short TYPECODE_JDBC_ARRAY = 2003;
    public static final short TYPECODE_JDBC_JOPAQUE = 2000;
    public static final short TYPECODE_JDBC_REF = 2006;
    public static final short TYPECODE_JDBC_JSTRUCT = 2008;
    public static final short TYPECODE_SQLXML = 2009;
    private static final short TYPECODE_MAXVALUE = 2009;
    static final short[] OID_TO_TYPECODE = new short[72];
    SQLName sqlName;
    OracleNamedType pickler;
    transient oracle.jdbc.internal.OracleConnection connection;
    short internalTypeCode;
    boolean isTransient = false;
    byte[] toid = null;
    int toidVersion = 1;
    long precision;
    byte scale;
    byte[] transientImage = null;
    AttributeDescriptor[] attributesDescriptor = null;
    transient Boolean isInstanciable = null;
    transient String supertype = null;
    transient int numLocalAttrs = -1;
    transient String[] subtypes = null;
    transient String[] attrJavaNames = null;
    String typeNameByUser;
    private static String[] typeCodeTypeNameMap;
    Object acProxy;

    void copyDescriptor(TypeDescriptor src) {
        if (src.sqlName != null) {
            this.sqlName = src.sqlName;
        }
        this.pickler = src.pickler;
        this.connection = src.connection;
        this.internalTypeCode = src.internalTypeCode;
        this.isTransient = src.isTransient;
        this.toid = src.toid;
        this.toidVersion = src.toidVersion;
        this.precision = src.precision;
        this.scale = src.scale;
        this.transientImage = src.transientImage;
        this.attributesDescriptor = src.attributesDescriptor;
        this.isInstanciable = src.isInstanciable;
        this.supertype = src.supertype;
        this.numLocalAttrs = src.numLocalAttrs;
        this.subtypes = src.subtypes;
        this.attrJavaNames = src.attrJavaNames;
        if (src.typeNameByUser != null) {
            this.typeNameByUser = src.typeNameByUser;
        }
    }

    protected TypeDescriptor(short _typeCode) {
        this.internalTypeCode = _typeCode;
    }

    protected TypeDescriptor(short _typeCode, String name, Connection conn) throws SQLException {
        this.internalTypeCode = _typeCode;
        if (name == null || conn == null) {
            SQLException sqlException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments").fillInStackTrace();
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "TypeDescriptor.<init>", "Invalid arguments, 'name' should not be an empty string and conn should not be null. An exception is thrown.", null, sqlException);
            throw sqlException;
        }
        this.setPhysicalConnectionOf(conn);
        this.typeNameByUser = name;
    }

    protected TypeDescriptor(short _typeCode, SQLName name, Connection conn) throws SQLException {
        this.internalTypeCode = _typeCode;
        if (name == null || conn == null) {
            SQLException sqlException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments").fillInStackTrace();
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "TypeDescriptor.<init>", "Invalid arguments, 'name' and 'conn' should not be null. An exception is thrown.", null, sqlException);
            throw sqlException;
        }
        this.sqlName = name;
        this.typeNameByUser = this.sqlName.getName();
        this.setPhysicalConnectionOf(conn);
    }

    protected TypeDescriptor(short _typeCode, SQLName name, OracleTypeADT type, Connection conn) throws SQLException {
        this.internalTypeCode = _typeCode;
        if (name == null || type == null) {
            SQLException sqlException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments").fillInStackTrace();
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "TypeDescriptor.<init>", "Invalid arguments, 'type' and 'conn' should not be null. An exception is thrown.", null, sqlException);
            throw sqlException;
        }
        this.sqlName = name;
        this.typeNameByUser = this.sqlName.getName();
        if (conn != null) {
            this.setPhysicalConnectionOf(conn);
        }
        this.pickler = type;
        this.pickler.setDescriptor(this);
        this.toid = type.getTOID();
    }

    protected TypeDescriptor(short _typeCode, OracleTypeADT type, Connection conn) throws SQLException {
        this.internalTypeCode = _typeCode;
        if (type == null || conn == null) {
            SQLException sqlException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments").fillInStackTrace();
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "TypeDescriptor.<init>", "Invalid arguments, 'type' and 'conn' should not be null. An exception is thrown.", null, sqlException);
            throw sqlException;
        }
        this.setPhysicalConnectionOf(conn);
        this.sqlName = null;
        this.pickler = type;
        this.pickler.setDescriptor(this);
        this.toid = type.getTOID();
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        return OracleTypeMetaData.Kind.TYPE;
    }

    @Override
    public String getName() throws SQLException {
        if (this.sqlName == null) {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                this.initSQLName();
            }
        }
        String ret = null;
        if (this.sqlName != null) {
            ret = this.sqlName.getName();
        }
        return ret;
    }

    @Override
    public SQLName getSQLName() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.sqlName == null) {
                this.initSQLName();
            }
            SQLName sQLName = this.sqlName;
            return sQLName;
        }
    }

    void initSQLName() throws SQLException {
        if (!this.isTransient) {
            if (this.connection == null) {
                SQLException sqlException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "initSQLName", "Internal error, connection is null. An exception is thrown.", null, sqlException);
                throw sqlException;
            }
            if (this.pickler != null) {
                this.sqlName = new SQLName(this.pickler.getFullName(), this.connection);
            } else if (this.typeNameByUser != null) {
                this.sqlName = new SQLName(this.typeNameByUser, this.connection);
            } else if (this.toid != null) {
                String typeName;
                this.typeNameByUser = typeName = OracleTypeADT.toid2typename(this.connection, this.toid);
                this.sqlName = new SQLName(typeName, this.connection);
                TypeDescriptor descriptorFromCache = null;
                String qname = this.sqlName.getName();
                descriptorFromCache = (TypeDescriptor)this.connection.doGetDescriptor(qname);
                if (descriptorFromCache != null) {
                    this.copyDescriptor(descriptorFromCache);
                }
            } else if (this.internalTypeCode == 108 || this.internalTypeCode == 122) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
    }

    @Override
    public String getSchemaName() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            String ret = null;
            if (this.sqlName == null) {
                this.initSQLName();
            }
            if (this.sqlName != null) {
                ret = this.sqlName.getSchema();
            }
            String string = ret;
            return string;
        }
    }

    public String getTypeName() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            String ret = null;
            if (this.sqlName == null) {
                this.initSQLName();
            }
            if (this.sqlName != null) {
                ret = this.sqlName.getSimpleName();
            }
            String string = ret;
            return string;
        }
    }

    public OracleNamedType getPickler() {
        return this.pickler;
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() {
        return this.connection;
    }

    public void setPhysicalConnectionOf(Connection conn) {
        this.connection = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
    }

    @Override
    public int getTypeCode() throws SQLException {
        return this.internalTypeCode;
    }

    @Override
    public String getTypeCodeName() throws SQLException {
        return TypeDescriptor.getTypeCodeTypeNameMap()[this.getTypeCode()];
    }

    private static String[] getTypeCodeTypeNameMap() throws SQLException {
        if (typeCodeTypeNameMap == null) {
            String[] typeCodeTypeNameMap_local = new String[2010];
            Class<?> typeDescriptorClass = null;
            try {
                typeDescriptorClass = Class.forName("oracle.sql.TypeDescriptor");
            }
            catch (ClassNotFoundException ex) {
                throw (SQLException)DatabaseError.createSqlException(1, "TypeDescriptor.getTypeCodeName: got a ClassNotFoundException: " + ex.getMessage()).fillInStackTrace();
            }
            Field[] publicTypeCodeFields = typeDescriptorClass.getFields();
            for (int i = 0; i < publicTypeCodeFields.length; ++i) {
                if (!publicTypeCodeFields[i].getName().startsWith("TYPECODE_")) continue;
                try {
                    typeCodeTypeNameMap_local[publicTypeCodeFields[i].getInt(null)] = publicTypeCodeFields[i].getName();
                    continue;
                }
                catch (Exception ex) {
                    throw (SQLException)DatabaseError.createSqlException(1, "TypeDescriptor.getTypeCodeName: " + ex.getMessage()).fillInStackTrace();
                }
            }
            typeCodeTypeNameMap = typeCodeTypeNameMap_local;
        }
        return typeCodeTypeNameMap;
    }

    public short getInternalTypeCode() throws SQLException {
        return this.internalTypeCode;
    }

    public static boolean isV2available(byte[] toid) {
        int i = 0;
        while (toid[i] == 0) {
            ++i;
        }
        return i == 13 && toid[13] == 2 && toid[14] == 16 && toid[15] < 67 && toid[15] >= 0;
    }

    public static TypeDescriptor getTypeDescriptor(String name, oracle.jdbc.OracleConnection conn) throws SQLException {
        TypeDescriptor descriptor = null;
        conn = ConcreteProxyUtil.unwrapConnectionProxy(conn);
        oracle.jdbc.internal.OracleConnection physConn = conn.physicalConnectionWithin();
        try (Monitor.CloseableLock lock = physConn.acquireCloseableLock();){
            try {
                SQLName sqlName = new SQLName(name, conn);
                String qname = sqlName.getName();
                descriptor = (TypeDescriptor)physConn.doGetDescriptor(qname);
                if (descriptor == null) {
                    OracleTypeADT otype = new OracleTypeADT(name, conn);
                    oracle.jdbc.internal.OracleConnection iconn = (oracle.jdbc.internal.OracleConnection)conn;
                    otype.init(iconn);
                    descriptor = TypeDescriptor.newDescriptorFromADT(sqlName, conn, otype);
                    conn.putDescriptor(qname, descriptor);
                }
            }
            catch (SQLRecoverableException sqlrexc) {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getTypeDescriptor", "Exception caught and thrown : {0}", (String)null, sqlrexc, (Object)sqlrexc.getMessage());
                throw sqlrexc;
            }
            catch (SQLException sqlException) {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getTypeDescriptor", "Exception caught and thrown : {0}", (String)null, sqlException, (Object)sqlException.getMessage());
                throw (SQLException)DatabaseError.createSqlException(null, sqlException, 60, "Unable to resolve type \"" + name + "\"").fillInStackTrace();
            }
            catch (Exception e) {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getTypeDescriptor", "Exception caught and thrown : {0} ", (String)null, e, (Object)e.getMessage());
                throw (SQLException)DatabaseError.createSqlException(null, 60, "Unable to resolve type \"" + name + "\"").fillInStackTrace();
            }
            TypeDescriptor typeDescriptor = descriptor;
            return typeDescriptor;
        }
    }

    public static CompletionStage<TypeDescriptor> getTypeDescriptorAsync(String name, oracle.jdbc.OracleConnection conn) {
        String qname;
        SQLName sqlName;
        Monitor.CloseableLock lock;
        block10: {
            lock = ((oracle.jdbc.internal.OracleConnection)conn).acquireCloseableLock();
            sqlName = new SQLName(name, conn);
            qname = sqlName.getName();
            TypeDescriptor cachedDescriptor = (TypeDescriptor)((oracle.jdbc.internal.OracleConnection)conn).doGetDescriptor(qname);
            if (cachedDescriptor == null) break block10;
            CompletableFuture<TypeDescriptor> completableFuture = CompletableFuture.completedFuture(cachedDescriptor);
            if (lock != null) {
                lock.close();
            }
            return completableFuture;
        }
        try {
            CompletionStage<Object> descriptorStage;
            try {
                OracleTypeADT otype = new OracleTypeADT(name, conn);
                oracle.jdbc.internal.OracleConnection iconn = (oracle.jdbc.internal.OracleConnection)conn;
                descriptorStage = otype.initAsync(iconn).thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
                    TypeDescriptor descriptor = TypeDescriptor.newDescriptorFromADT(sqlName, conn, otype);
                    conn.putDescriptor(qname, descriptor);
                    return descriptor;
                }));
            }
            catch (Exception getDescriptorException) {
                descriptorStage = CompletableFuture.failedStage(getDescriptorException);
            }
            CompletionStage<TypeDescriptor> completionStage = descriptorStage.exceptionally(completionError -> {
                Throwable error = CompletionStageUtil.unwrapCompletionException(completionError);
                error.printStackTrace();
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getTypeDescriptorAsync", "Exception caught and thrown : {0}", (String)null, error, (Object)error.getMessage());
                SQLException thrownException = error instanceof SQLRecoverableException ? (SQLRecoverableException)error : (error instanceof SQLException ? (SQLException)DatabaseError.createSqlException(null, (SQLException)error, 60, "Unable to resolve type \"" + name + "\"").fillInStackTrace() : (SQLException)DatabaseError.createSqlException(null, 60, "Unable to resolve type \"" + name + "\"").fillInStackTrace());
                throw new CompletionException(thrownException);
            });
            return completionStage;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    private static TypeDescriptor newDescriptorFromADT(SQLName sqlName, oracle.jdbc.OracleConnection conn, OracleTypeADT otype) throws SQLException {
        TypeDescriptor descriptor;
        OracleNamedType realType = otype.cleanup();
        switch (realType.getTypeCode()) {
            case 2002: 
            case 2008: {
                descriptor = new StructDescriptor(sqlName, (OracleTypeADT)realType, (Connection)conn);
                break;
            }
            case 2003: {
                descriptor = new ArrayDescriptor(sqlName, (OracleTypeCOLLECTION)realType, (Connection)conn);
                break;
            }
            case 2007: {
                descriptor = new OpaqueDescriptor(sqlName, (OracleTypeOPAQUE)realType, (Connection)conn);
                break;
            }
            default: {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "newDescriptorFromADT", "The real type should be either STRUCT, JAVA_STRUCT, ARRAY or OPAQUE. An exception is thrown.", null, null);
                throw (SQLException)DatabaseError.createSqlException(1).fillInStackTrace();
            }
        }
        realType.setDescriptor(descriptor);
        return descriptor;
    }

    public static TypeDescriptor getTypeDescriptor(String qualifiedName, oracle.jdbc.OracleConnection conn, byte[] image, long offset) throws SQLException {
        conn = ConcreteProxyUtil.unwrapConnectionProxy(conn);
        oracle.jdbc.internal.OracleConnection physConn = conn.physicalConnectionWithin();
        try (Monitor.CloseableLock lock = physConn.acquireCloseableLock();){
            TypeDescriptor descriptor = null;
            String qname = TypeDescriptor.getSubtypeName(conn, image, offset);
            if (qname == null) {
                qname = qualifiedName;
            }
            if ((descriptor = (TypeDescriptor)physConn.doGetDescriptor(qname)) == null) {
                SQLName sqlName = new SQLName(qname, conn);
                OracleTypeADT otype = new OracleTypeADT(qname, conn);
                otype.init(physConn);
                OracleNamedType realType = otype.cleanup();
                switch (realType.getTypeCode()) {
                    case 2002: 
                    case 2008: {
                        descriptor = new StructDescriptor(sqlName, (OracleTypeADT)realType, (Connection)conn);
                        break;
                    }
                    case 2003: {
                        descriptor = new ArrayDescriptor(sqlName, (OracleTypeCOLLECTION)realType, (Connection)conn);
                        break;
                    }
                    case 2007: {
                        descriptor = new OpaqueDescriptor(sqlName, (OracleTypeOPAQUE)realType, (Connection)conn);
                        break;
                    }
                    default: {
                        CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getTypeDescriptor", "The real type should be either STRUCT, JAVA_STRUCT, ARRAY or OPAQUE. An exception is thrown.", null, null);
                        throw (SQLException)DatabaseError.createSqlException(1).fillInStackTrace();
                    }
                }
                conn.putDescriptor(qname, descriptor);
            }
            TypeDescriptor typeDescriptor = descriptor;
            return typeDescriptor;
        }
    }

    @Override
    public Datum toDatum(Connection c) throws SQLException {
        this.connection = c instanceof OracleConnectionWrapper && !(c instanceof OracleConnection) ? (oracle.jdbc.internal.OracleConnection)((OracleConnectionWrapper)c).unwrap() : (oracle.jdbc.internal.OracleConnection)c;
        OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.ANYTYPE", c);
        byte[] image = new byte[this.getOpaqueImageTypeSize()];
        this.pickleOpaqueTypeImage(image, 0, false);
        OPAQUE opq = new OPAQUE(desc, this.connection, image);
        opq.setShareBytes(opq.toBytes());
        return opq;
    }

    @Override
    public Object toJDBCObject(Connection c) throws SQLException {
        return this.toDatum(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static TypeDescriptor unpickleOpaqueTypeImage(PickleContext context, Connection connection, short[] rdbmsTypeCodeArr) throws SQLException {
        byte[] toid = null;
        TypeDescriptor ret = null;
        int offsetBegin = context.offset();
        byte[] image = context.image();
        context.skipBytes(1);
        short flag = (short)context.readUB2();
        rdbmsTypeCodeArr[0] = (short)context.readUB2();
        try (Monitor.CloseableLock lock = ((oracle.jdbc.internal.OracleConnection)connection).acquireCloseableLock();){
            if ((flag & 0x20) != 0) {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "unpickleOpaqueTypeImage", "Export/Import of persistent type isn't supported.", null, null);
                throw (SQLException)DatabaseError.createSqlException(178).fillInStackTrace();
            }
            if ((flag & 1) == 0) {
                if ((flag & 2) == 0 || rdbmsTypeCodeArr[0] == 110 || rdbmsTypeCodeArr[0] == 58) {
                    toid = context.readDataValue(16);
                    int toidVersion = context.readUB2();
                    String typeName = (String)((oracle.jdbc.internal.OracleConnection)connection).getDescriptor(toid);
                    ret = (TypeDescriptor)((oracle.jdbc.internal.OracleConnection)connection).doGetDescriptor(typeName);
                    if (ret == null) {
                        if (rdbmsTypeCodeArr[0] == 122) {
                            ret = new ArrayDescriptor(toid, toidVersion, connection);
                        } else if (rdbmsTypeCodeArr[0] == 108 || rdbmsTypeCodeArr[0] == 110) {
                            ret = new StructDescriptor(toid, toidVersion, connection);
                        } else {
                            if (rdbmsTypeCodeArr[0] != 58) throw (SQLException)DatabaseError.createSqlException(178).fillInStackTrace();
                            ret = new OpaqueDescriptor(toid, toidVersion, connection);
                        }
                    }
                } else {
                    ret = new TypeDescriptor(rdbmsTypeCodeArr[0]);
                }
                ret.setTransient(false);
            } else {
                int numattrs = (int)context.readUB4();
                if (rdbmsTypeCodeArr[0] == 108) {
                    AttributeDescriptor[] ados = null;
                    if (numattrs > 0) {
                        ados = new AttributeDescriptor[numattrs];
                        for (int i = 0; i < numattrs; ++i) {
                            byte adeFlag = context.readByte();
                            ados[i] = Kotad.unpickleAttributeImage(adeFlag == 2, context);
                            if (adeFlag == 2) continue;
                            short[] attrRdbmsTypeCode = new short[1];
                            ados[i].setTypeDescriptor(TypeDescriptor.unpickleOpaqueTypeImage(context, connection, attrRdbmsTypeCode));
                        }
                    }
                    ret = new StructDescriptor(ados, connection);
                } else {
                    if (numattrs != 1) throw (SQLException)DatabaseError.createSqlException(178).fillInStackTrace();
                    byte adeFlag = context.readByte();
                    ret = Kotad.unpickleTypeDescriptorImage(context);
                }
                ret.setTransient(true);
            }
            if (ret.isTransient()) {
                int offsetEnd = context.offset();
                byte[] transientTypeImage = new byte[offsetEnd - offsetBegin];
                System.arraycopy(image, offsetBegin, transientTypeImage, 0, transientTypeImage.length);
                ret.setTransientImage(transientTypeImage);
            }
            TypeDescriptor typeDescriptor = ret;
            return typeDescriptor;
        }
    }

    void setTransientImage(byte[] _transientImage) {
        this.transientImage = _transientImage;
    }

    void setTransient(boolean _isTransient) {
        this.isTransient = _isTransient;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    int getOpaqueImageTypeSize() {
        int ret = 0;
        if (this.isTransient) {
            ret = this.transientImage.length;
        } else {
            ret = 5;
            if (this.toid != null && this.toid.length == 16) {
                ret = 23;
            }
        }
        return ret;
    }

    int pickleOpaqueTypeImage(byte[] buffer, int offset, boolean isREF) {
        if (this.isTransient) {
            System.arraycopy(this.transientImage, 0, buffer, offset, this.transientImage.length);
            offset += this.transientImage.length;
        } else {
            boolean includeToid = false;
            if (this.toid != null && this.toid.length == 16) {
                includeToid = true;
            }
            buffer[offset++] = 1;
            int rdbmsTypeCode = this.internalTypeCode;
            if (isREF) {
                rdbmsTypeCode = 110;
            }
            int flag = 512;
            if (rdbmsTypeCode != 108 && rdbmsTypeCode != 122) {
                flag |= 2;
            }
            if (includeToid && rdbmsTypeCode != 110) {
                flag |= 4;
            }
            buffer[offset++] = (byte)((flag & 0xFF00) >> 8 & 0xFF);
            buffer[offset++] = (byte)(flag & 0xFF);
            buffer[offset++] = (byte)((rdbmsTypeCode & 0xFF00) >> 8 & 0xFF);
            buffer[offset++] = (byte)(rdbmsTypeCode & 0xFF);
            if (includeToid) {
                System.arraycopy(this.toid, 0, buffer, offset, this.toid.length);
                offset += this.toid.length;
                buffer[offset++] = (byte)((this.toidVersion & 0xFF00) >> 8 & 0xFF);
                buffer[offset++] = (byte)(this.toidVersion & 0xFF);
            }
        }
        return offset;
    }

    public void setPrecision(long _precision) {
        this.precision = _precision;
    }

    public long getPrecision() {
        return this.precision;
    }

    public void setScale(byte _scale) {
        this.scale = _scale;
    }

    public byte getScale() {
        return this.scale;
    }

    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (this.sqlName == null) {
                this.initSQLName();
            }
        }
        catch (SQLException e) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "writeObject", "Exception caught and thrown : {0} ", (String)null, e, (Object)e.getMessage());
            throw new IOException(e.getMessage());
        }
        out.writeObject(this.sqlName);
        out.writeObject(this.pickler);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.sqlName = (SQLName)in.readObject();
        this.pickler = (OracleNamedType)in.readObject();
    }

    public void setConnection(Connection connection) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.pickler.setConnection(this.getInternalConnection());
    }

    public static String getSubtypeName(oracle.jdbc.OracleConnection conn, byte[] image, long offset) throws SQLException {
        if (image == null || image.length == 0 || conn == null) {
            throw (SQLException)DatabaseError.createSqlException(68, " 'image' should not be empty and 'conn' should not be null. ").fillInStackTrace();
        }
        String ret = OracleTypeADT.getSubtypeName(conn, image, offset);
        return ret;
    }

    public void initMetadataRecursively() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            if (this.pickler != null) {
                this.pickler.initMetadataRecursively();
            }
        }
    }

    public void initNamesRecursively() throws SQLException {
        if (this.pickler != null) {
            this.pickler.initNamesRecursively();
        }
    }

    public void fixupConnection(oracle.jdbc.internal.OracleConnection fixupConn) throws SQLException {
        if (this.connection == null) {
            this.connection = fixupConn;
        }
        if (this.pickler != null) {
            this.pickler.fixupConnection(fixupConn);
        }
    }

    public String toXMLString() throws SQLException {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean fetchAllMetaDataAsNeeded) throws SQLException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printXMLHeader(pw);
        this.printXML(pw, 0, fetchAllMetaDataAsNeeded);
        return sw.getBuffer().substring(0);
    }

    public void printXML(PrintStream s) throws SQLException {
        this.printXML(s, false);
    }

    public void printXML(PrintStream stream, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        PrintWriter pw = new PrintWriter(stream, true);
        this.printXMLHeader(pw);
        this.printXML(pw, 0, fetchAllMetaDataAsNeeded);
    }

    void printXML(PrintWriter pw, int indent, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        String tagname = this.tagName();
        pw.println("<" + tagname + " sqlName=\"" + this.getName() + "\" >");
        if (this.pickler != null) {
            this.pickler.printXML(pw, indent + 1, fetchAllMetaDataAsNeeded);
        }
        pw.println("</" + tagname + ">");
    }

    String tagName() {
        return "TypeDescriptor";
    }

    void printXMLHeader(PrintWriter pw) throws SQLException {
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    public static String convToUpperCase(String str) {
        if (str != null && !str.startsWith("\"")) {
            char[] srcChars = str.toCharArray();
            for (int i = 0; i < srcChars.length; ++i) {
                srcChars[i] = Character.toUpperCase(srcChars[i]);
            }
            str = String.copyValueOf(srcChars);
        }
        return str;
    }

    public Class getClass(Map map) throws SQLException {
        String qualifiedName = this.getName();
        Class c = this.connection.getClassForType(qualifiedName, map);
        String schema = this.getSchemaName();
        String type = this.getTypeName();
        if (c == null) {
            c = (Class)map.get(type);
        }
        if (c == null) {
            if (this.connection.isProxySession()) {
                schema = TypeDescriptor.convToUpperCase(schema);
            }
            c = (Class)map.get(schema + "." + type);
        }
        if (SQLName.s_parseAllFormat) {
            if (c == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(schema)) {
                c = (Class)map.get("\"" + type + "\"");
            }
            if (c == null) {
                c = (Class)map.get("\"" + schema + "\".\"" + type + "\"");
            }
            if (c == null) {
                c = (Class)map.get("\"" + schema + "\"." + type);
            }
            if (c == null) {
                c = (Class)map.get(schema + ".\"" + type + "\"");
            }
        }
        return c;
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    static {
        TypeDescriptor.OID_TO_TYPECODE[8] = 12;
        TypeDescriptor.OID_TO_TYPECODE[9] = 27;
        TypeDescriptor.OID_TO_TYPECODE[10] = 28;
        TypeDescriptor.OID_TO_TYPECODE[11] = 29;
        TypeDescriptor.OID_TO_TYPECODE[12] = 21;
        TypeDescriptor.OID_TO_TYPECODE[13] = 22;
        TypeDescriptor.OID_TO_TYPECODE[14] = 4;
        TypeDescriptor.OID_TO_TYPECODE[15] = 2;
        TypeDescriptor.OID_TO_TYPECODE[16] = 7;
        TypeDescriptor.OID_TO_TYPECODE[17] = 23;
        TypeDescriptor.OID_TO_TYPECODE[18] = 25;
        TypeDescriptor.OID_TO_TYPECODE[19] = 26;
        TypeDescriptor.OID_TO_TYPECODE[20] = 245;
        TypeDescriptor.OID_TO_TYPECODE[21] = 246;
        TypeDescriptor.OID_TO_TYPECODE[22] = 3;
        TypeDescriptor.OID_TO_TYPECODE[23] = 95;
        TypeDescriptor.OID_TO_TYPECODE[24] = 32;
        TypeDescriptor.OID_TO_TYPECODE[25] = 9;
        TypeDescriptor.OID_TO_TYPECODE[26] = 96;
        TypeDescriptor.OID_TO_TYPECODE[27] = 1;
        TypeDescriptor.OID_TO_TYPECODE[28] = 105;
        TypeDescriptor.OID_TO_TYPECODE[29] = 247;
        TypeDescriptor.OID_TO_TYPECODE[30] = 248;
        TypeDescriptor.OID_TO_TYPECODE[31] = 108;
        TypeDescriptor.OID_TO_TYPECODE[32] = 0;
        TypeDescriptor.OID_TO_TYPECODE[33] = 0;
        TypeDescriptor.OID_TO_TYPECODE[34] = 112;
        TypeDescriptor.OID_TO_TYPECODE[35] = 113;
        TypeDescriptor.OID_TO_TYPECODE[36] = 115;
        TypeDescriptor.OID_TO_TYPECODE[37] = 114;
        TypeDescriptor.OID_TO_TYPECODE[38] = 0;
        TypeDescriptor.OID_TO_TYPECODE[39] = 0;
        TypeDescriptor.OID_TO_TYPECODE[40] = 0;
        TypeDescriptor.OID_TO_TYPECODE[41] = 0;
        TypeDescriptor.OID_TO_TYPECODE[42] = 0;
        TypeDescriptor.OID_TO_TYPECODE[43] = 0;
        TypeDescriptor.OID_TO_TYPECODE[44] = 0;
        TypeDescriptor.OID_TO_TYPECODE[45] = 0;
        TypeDescriptor.OID_TO_TYPECODE[46] = 252;
        TypeDescriptor.OID_TO_TYPECODE[47] = 0;
        TypeDescriptor.OID_TO_TYPECODE[48] = 0;
        TypeDescriptor.OID_TO_TYPECODE[49] = 0;
        TypeDescriptor.OID_TO_TYPECODE[50] = 0;
        TypeDescriptor.OID_TO_TYPECODE[51] = 0;
        TypeDescriptor.OID_TO_TYPECODE[52] = 0;
        TypeDescriptor.OID_TO_TYPECODE[53] = 0;
        TypeDescriptor.OID_TO_TYPECODE[54] = 0;
        TypeDescriptor.OID_TO_TYPECODE[55] = 0;
        TypeDescriptor.OID_TO_TYPECODE[56] = 0;
        TypeDescriptor.OID_TO_TYPECODE[57] = 0;
        TypeDescriptor.OID_TO_TYPECODE[58] = 58;
        TypeDescriptor.OID_TO_TYPECODE[59] = 185;
        TypeDescriptor.OID_TO_TYPECODE[60] = 186;
        TypeDescriptor.OID_TO_TYPECODE[61] = 187;
        TypeDescriptor.OID_TO_TYPECODE[62] = 188;
        TypeDescriptor.OID_TO_TYPECODE[63] = 189;
        TypeDescriptor.OID_TO_TYPECODE[64] = 190;
        TypeDescriptor.OID_TO_TYPECODE[65] = 232;
        TypeDescriptor.OID_TO_TYPECODE[66] = 0;
        TypeDescriptor.OID_TO_TYPECODE[67] = 0;
        TypeDescriptor.OID_TO_TYPECODE[68] = 100;
        TypeDescriptor.OID_TO_TYPECODE[69] = 101;
        TypeDescriptor.OID_TO_TYPECODE[70] = 104;
        typeCodeTypeNameMap = null;
        try {
            TypeDescriptor.getTypeCodeTypeNameMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

