/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.credentials;

import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;

public class CachedCredentialsProvider
extends CredentialsProvider {
    private CredentialsProvider cachedProvider;

    private CachedCredentialsProvider(CachedCredentialsProviderBuilder builder) {
        this.cachedProvider = builder.getCachedProvider();
        this.addReferenceTo(this.cachedProvider);
        long nativeHandle = CachedCredentialsProvider.cachedCredentialsProviderNew(this, builder.getCachingDurationInSeconds(), this.cachedProvider.getNativeHandle());
        this.acquireNativeHandle(nativeHandle);
    }

    private static native long cachedCredentialsProviderNew(CachedCredentialsProvider var0, int var1, long var2);

    public static class CachedCredentialsProviderBuilder {
        private int cachingDurationInSeconds;
        private CredentialsProvider cachedProvider;

        public CachedCredentialsProviderBuilder withCachingDurationInSeconds(int cachingDurationInSeconds) {
            this.cachingDurationInSeconds = cachingDurationInSeconds;
            return this;
        }

        int getCachingDurationInSeconds() {
            return this.cachingDurationInSeconds;
        }

        public CachedCredentialsProviderBuilder withCachedProvider(CredentialsProvider cachedProvider) {
            this.cachedProvider = cachedProvider;
            return this;
        }

        CredentialsProvider getCachedProvider() {
            return this.cachedProvider;
        }

        public CachedCredentialsProvider build() {
            return new CachedCredentialsProvider(this);
        }
    }
}

