/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItem;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItemSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVpcEndpointsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DeleteVpcEndpointsResponse> {
    private static final SdkField<List<UnsuccessfulItem>> UNSUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Unsuccessful").getter(DeleteVpcEndpointsResponse.getter(DeleteVpcEndpointsResponse::unsuccessful)).setter(DeleteVpcEndpointsResponse.setter(Builder::unsuccessful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unsuccessful").unmarshallLocationName("unsuccessful").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnsuccessfulItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNSUCCESSFUL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteVpcEndpointsResponse.memberNameToFieldInitializer();
    private final List<UnsuccessfulItem> unsuccessful;

    private DeleteVpcEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.unsuccessful = builder.unsuccessful;
    }

    public final boolean hasUnsuccessful() {
        return this.unsuccessful != null && !(this.unsuccessful instanceof SdkAutoConstructList);
    }

    public final List<UnsuccessfulItem> unsuccessful() {
        return this.unsuccessful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessful() ? this.unsuccessful() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointsResponse)) {
            return false;
        }
        DeleteVpcEndpointsResponse other = (DeleteVpcEndpointsResponse)((Object)obj);
        return this.hasUnsuccessful() == other.hasUnsuccessful() && Objects.equals(this.unsuccessful(), other.unsuccessful());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteVpcEndpointsResponse").add("Unsuccessful", this.hasUnsuccessful() ? this.unsuccessful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Unsuccessful": {
                return Optional.ofNullable(clazz.cast(this.unsuccessful()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<UnsuccessfulItem>>> map = new HashMap<String, SdkField<List<UnsuccessfulItem>>>();
        map.put("Unsuccessful", UNSUCCESSFUL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcEndpointsResponse, T> g) {
        return obj -> g.apply((DeleteVpcEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<UnsuccessfulItem> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointsResponse model) {
            super(model);
            this.unsuccessful(model.unsuccessful);
        }

        public final List<UnsuccessfulItem.Builder> getUnsuccessful() {
            List<UnsuccessfulItem.Builder> result = UnsuccessfulItemSetCopier.copyToBuilder(this.unsuccessful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem ... unsuccessful) {
            this.unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<UnsuccessfulItem.Builder> ... unsuccessful) {
            this.unsuccessful(Stream.of(unsuccessful).map(c -> (UnsuccessfulItem)((UnsuccessfulItem.Builder)UnsuccessfulItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteVpcEndpointsResponse build() {
            return new DeleteVpcEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteVpcEndpointsResponse> {
        public Builder unsuccessful(Collection<UnsuccessfulItem> var1);

        public Builder unsuccessful(UnsuccessfulItem ... var1);

        public Builder unsuccessful(Consumer<UnsuccessfulItem.Builder> ... var1);
    }
}

