/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessNativeApplicationOidcOptions;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderDeviceOptions;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVerifiedAccessTrustProviderRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVerifiedAccessTrustProviderRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessTrustProviderId").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::verifiedAccessTrustProviderId)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::verifiedAccessTrustProviderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderId").unmarshallLocationName("VerifiedAccessTrustProviderId").build()}).build();
    private static final SdkField<ModifyVerifiedAccessTrustProviderOidcOptions> OIDC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OidcOptions").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::oidcOptions)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::oidcOptions)).constructor(ModifyVerifiedAccessTrustProviderOidcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcOptions").unmarshallLocationName("OidcOptions").build()}).build();
    private static final SdkField<ModifyVerifiedAccessTrustProviderDeviceOptions> DEVICE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceOptions").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::deviceOptions)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::deviceOptions)).constructor(ModifyVerifiedAccessTrustProviderDeviceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOptions").unmarshallLocationName("DeviceOptions").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::description)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::dryRun)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::clientToken)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<VerifiedAccessSseSpecificationRequest> SSE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseSpecification").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::sseSpecification)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::sseSpecification)).constructor(VerifiedAccessSseSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification").unmarshallLocationName("SseSpecification").build()}).build();
    private static final SdkField<ModifyVerifiedAccessNativeApplicationOidcOptions> NATIVE_APPLICATION_OIDC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NativeApplicationOidcOptions").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::nativeApplicationOidcOptions)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::nativeApplicationOidcOptions)).constructor(ModifyVerifiedAccessNativeApplicationOidcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NativeApplicationOidcOptions").unmarshallLocationName("NativeApplicationOidcOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD, OIDC_OPTIONS_FIELD, DEVICE_OPTIONS_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD, CLIENT_TOKEN_FIELD, SSE_SPECIFICATION_FIELD, NATIVE_APPLICATION_OIDC_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyVerifiedAccessTrustProviderRequest.memberNameToFieldInitializer();
    private final String verifiedAccessTrustProviderId;
    private final ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions;
    private final ModifyVerifiedAccessTrustProviderDeviceOptions deviceOptions;
    private final String description;
    private final Boolean dryRun;
    private final String clientToken;
    private final VerifiedAccessSseSpecificationRequest sseSpecification;
    private final ModifyVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions;

    private ModifyVerifiedAccessTrustProviderRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessTrustProviderId = builder.verifiedAccessTrustProviderId;
        this.oidcOptions = builder.oidcOptions;
        this.deviceOptions = builder.deviceOptions;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.sseSpecification = builder.sseSpecification;
        this.nativeApplicationOidcOptions = builder.nativeApplicationOidcOptions;
    }

    public final String verifiedAccessTrustProviderId() {
        return this.verifiedAccessTrustProviderId;
    }

    public final ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions() {
        return this.oidcOptions;
    }

    public final ModifyVerifiedAccessTrustProviderDeviceOptions deviceOptions() {
        return this.deviceOptions;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final VerifiedAccessSseSpecificationRequest sseSpecification() {
        return this.sseSpecification;
    }

    public final ModifyVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions() {
        return this.nativeApplicationOidcOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessTrustProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.oidcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.nativeApplicationOidcOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessTrustProviderRequest)) {
            return false;
        }
        ModifyVerifiedAccessTrustProviderRequest other = (ModifyVerifiedAccessTrustProviderRequest)((Object)obj);
        return Objects.equals(this.verifiedAccessTrustProviderId(), other.verifiedAccessTrustProviderId()) && Objects.equals(this.oidcOptions(), other.oidcOptions()) && Objects.equals(this.deviceOptions(), other.deviceOptions()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.sseSpecification(), other.sseSpecification()) && Objects.equals(this.nativeApplicationOidcOptions(), other.nativeApplicationOidcOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVerifiedAccessTrustProviderRequest").add("VerifiedAccessTrustProviderId", (Object)this.verifiedAccessTrustProviderId()).add("OidcOptions", (Object)this.oidcOptions()).add("DeviceOptions", (Object)this.deviceOptions()).add("Description", (Object)this.description()).add("DryRun", (Object)this.dryRun()).add("ClientToken", (Object)this.clientToken()).add("SseSpecification", (Object)this.sseSpecification()).add("NativeApplicationOidcOptions", (Object)this.nativeApplicationOidcOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessTrustProviderId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessTrustProviderId()));
            }
            case "OidcOptions": {
                return Optional.ofNullable(clazz.cast(this.oidcOptions()));
            }
            case "DeviceOptions": {
                return Optional.ofNullable(clazz.cast(this.deviceOptions()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "SseSpecification": {
                return Optional.ofNullable(clazz.cast(this.sseSpecification()));
            }
            case "NativeApplicationOidcOptions": {
                return Optional.ofNullable(clazz.cast(this.nativeApplicationOidcOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VerifiedAccessTrustProviderId", VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD);
        map.put("OidcOptions", OIDC_OPTIONS_FIELD);
        map.put("DeviceOptions", DEVICE_OPTIONS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("SseSpecification", SSE_SPECIFICATION_FIELD);
        map.put("NativeApplicationOidcOptions", NATIVE_APPLICATION_OIDC_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessTrustProviderRequest, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessTrustProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String verifiedAccessTrustProviderId;
        private ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions;
        private ModifyVerifiedAccessTrustProviderDeviceOptions deviceOptions;
        private String description;
        private Boolean dryRun;
        private String clientToken;
        private VerifiedAccessSseSpecificationRequest sseSpecification;
        private ModifyVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessTrustProviderRequest model) {
            super(model);
            this.verifiedAccessTrustProviderId(model.verifiedAccessTrustProviderId);
            this.oidcOptions(model.oidcOptions);
            this.deviceOptions(model.deviceOptions);
            this.description(model.description);
            this.dryRun(model.dryRun);
            this.clientToken(model.clientToken);
            this.sseSpecification(model.sseSpecification);
            this.nativeApplicationOidcOptions(model.nativeApplicationOidcOptions);
        }

        public final String getVerifiedAccessTrustProviderId() {
            return this.verifiedAccessTrustProviderId;
        }

        public final void setVerifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
        }

        @Override
        public final Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
            return this;
        }

        public final ModifyVerifiedAccessTrustProviderOidcOptions.Builder getOidcOptions() {
            return this.oidcOptions != null ? this.oidcOptions.toBuilder() : null;
        }

        public final void setOidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions.BuilderImpl oidcOptions) {
            this.oidcOptions = oidcOptions != null ? oidcOptions.build() : null;
        }

        @Override
        public final Builder oidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions) {
            this.oidcOptions = oidcOptions;
            return this;
        }

        public final ModifyVerifiedAccessTrustProviderDeviceOptions.Builder getDeviceOptions() {
            return this.deviceOptions != null ? this.deviceOptions.toBuilder() : null;
        }

        public final void setDeviceOptions(ModifyVerifiedAccessTrustProviderDeviceOptions.BuilderImpl deviceOptions) {
            this.deviceOptions = deviceOptions != null ? deviceOptions.build() : null;
        }

        @Override
        public final Builder deviceOptions(ModifyVerifiedAccessTrustProviderDeviceOptions deviceOptions) {
            this.deviceOptions = deviceOptions;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final VerifiedAccessSseSpecificationRequest.Builder getSseSpecification() {
            return this.sseSpecification != null ? this.sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationRequest.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationRequest sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final ModifyVerifiedAccessNativeApplicationOidcOptions.Builder getNativeApplicationOidcOptions() {
            return this.nativeApplicationOidcOptions != null ? this.nativeApplicationOidcOptions.toBuilder() : null;
        }

        public final void setNativeApplicationOidcOptions(ModifyVerifiedAccessNativeApplicationOidcOptions.BuilderImpl nativeApplicationOidcOptions) {
            this.nativeApplicationOidcOptions = nativeApplicationOidcOptions != null ? nativeApplicationOidcOptions.build() : null;
        }

        @Override
        public final Builder nativeApplicationOidcOptions(ModifyVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions) {
            this.nativeApplicationOidcOptions = nativeApplicationOidcOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVerifiedAccessTrustProviderRequest build() {
            return new ModifyVerifiedAccessTrustProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVerifiedAccessTrustProviderRequest> {
        public Builder verifiedAccessTrustProviderId(String var1);

        public Builder oidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions var1);

        default public Builder oidcOptions(Consumer<ModifyVerifiedAccessTrustProviderOidcOptions.Builder> oidcOptions) {
            return this.oidcOptions((ModifyVerifiedAccessTrustProviderOidcOptions)((ModifyVerifiedAccessTrustProviderOidcOptions.Builder)ModifyVerifiedAccessTrustProviderOidcOptions.builder().applyMutation(oidcOptions)).build());
        }

        public Builder deviceOptions(ModifyVerifiedAccessTrustProviderDeviceOptions var1);

        default public Builder deviceOptions(Consumer<ModifyVerifiedAccessTrustProviderDeviceOptions.Builder> deviceOptions) {
            return this.deviceOptions((ModifyVerifiedAccessTrustProviderDeviceOptions)((ModifyVerifiedAccessTrustProviderDeviceOptions.Builder)ModifyVerifiedAccessTrustProviderDeviceOptions.builder().applyMutation(deviceOptions)).build());
        }

        public Builder description(String var1);

        public Builder dryRun(Boolean var1);

        public Builder clientToken(String var1);

        public Builder sseSpecification(VerifiedAccessSseSpecificationRequest var1);

        default public Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationRequest.Builder> sseSpecification) {
            return this.sseSpecification((VerifiedAccessSseSpecificationRequest)((VerifiedAccessSseSpecificationRequest.Builder)VerifiedAccessSseSpecificationRequest.builder().applyMutation(sseSpecification)).build());
        }

        public Builder nativeApplicationOidcOptions(ModifyVerifiedAccessNativeApplicationOidcOptions var1);

        default public Builder nativeApplicationOidcOptions(Consumer<ModifyVerifiedAccessNativeApplicationOidcOptions.Builder> nativeApplicationOidcOptions) {
            return this.nativeApplicationOidcOptions((ModifyVerifiedAccessNativeApplicationOidcOptions)((ModifyVerifiedAccessNativeApplicationOidcOptions.Builder)ModifyVerifiedAccessNativeApplicationOidcOptions.builder().applyMutation(nativeApplicationOidcOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

