/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRoute;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTransitGatewayRoutesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, SearchTransitGatewayRoutesResponse> {
    private static final SdkField<List<TransitGatewayRoute>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(SearchTransitGatewayRoutesResponse.getter(SearchTransitGatewayRoutesResponse::routes)).setter(SearchTransitGatewayRoutesResponse.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet").unmarshallLocationName("routeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ADDITIONAL_ROUTES_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AdditionalRoutesAvailable").getter(SearchTransitGatewayRoutesResponse.getter(SearchTransitGatewayRoutesResponse::additionalRoutesAvailable)).setter(SearchTransitGatewayRoutesResponse.setter(Builder::additionalRoutesAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRoutesAvailable").unmarshallLocationName("additionalRoutesAvailable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTES_FIELD, ADDITIONAL_ROUTES_AVAILABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchTransitGatewayRoutesResponse.memberNameToFieldInitializer();
    private final List<TransitGatewayRoute> routes;
    private final Boolean additionalRoutesAvailable;

    private SearchTransitGatewayRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.routes = builder.routes;
        this.additionalRoutesAvailable = builder.additionalRoutesAvailable;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayRoute> routes() {
        return this.routes;
    }

    public final Boolean additionalRoutesAvailable() {
        return this.additionalRoutesAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalRoutesAvailable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTransitGatewayRoutesResponse)) {
            return false;
        }
        SearchTransitGatewayRoutesResponse other = (SearchTransitGatewayRoutesResponse)((Object)obj);
        return this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes()) && Objects.equals(this.additionalRoutesAvailable(), other.additionalRoutesAvailable());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTransitGatewayRoutesResponse").add("Routes", this.hasRoutes() ? this.routes() : null).add("AdditionalRoutesAvailable", (Object)this.additionalRoutesAvailable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "AdditionalRoutesAvailable": {
                return Optional.ofNullable(clazz.cast(this.additionalRoutesAvailable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RouteSet", ROUTES_FIELD);
        map.put("AdditionalRoutesAvailable", ADDITIONAL_ROUTES_AVAILABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchTransitGatewayRoutesResponse, T> g) {
        return obj -> g.apply((SearchTransitGatewayRoutesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayRoute> routes = DefaultSdkAutoConstructList.getInstance();
        private Boolean additionalRoutesAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTransitGatewayRoutesResponse model) {
            super(model);
            this.routes(model.routes);
            this.additionalRoutesAvailable(model.additionalRoutesAvailable);
        }

        public final List<TransitGatewayRoute.Builder> getRoutes() {
            List<TransitGatewayRoute.Builder> result = TransitGatewayRouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<TransitGatewayRoute.BuilderImpl> routes) {
            this.routes = TransitGatewayRouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<TransitGatewayRoute> routes) {
            this.routes = TransitGatewayRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(TransitGatewayRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<TransitGatewayRoute.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (TransitGatewayRoute)((TransitGatewayRoute.Builder)TransitGatewayRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAdditionalRoutesAvailable() {
            return this.additionalRoutesAvailable;
        }

        public final void setAdditionalRoutesAvailable(Boolean additionalRoutesAvailable) {
            this.additionalRoutesAvailable = additionalRoutesAvailable;
        }

        @Override
        public final Builder additionalRoutesAvailable(Boolean additionalRoutesAvailable) {
            this.additionalRoutesAvailable = additionalRoutesAvailable;
            return this;
        }

        @Override
        public SearchTransitGatewayRoutesResponse build() {
            return new SearchTransitGatewayRoutesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTransitGatewayRoutesResponse> {
        public Builder routes(Collection<TransitGatewayRoute> var1);

        public Builder routes(TransitGatewayRoute ... var1);

        public Builder routes(Consumer<TransitGatewayRoute.Builder> ... var1);

        public Builder additionalRoutesAvailable(Boolean var1);
    }
}

