/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class ETileLookAheadOrBehind
extends ETile {
    private final ETile orig;
    private final HColorSet colorSet;
    private final double deltax1 = 4.0;
    private final double deltax2 = 8.0;
    private final double deltay = 6.0;
    private final Style style;
    private final UText supText;
    private final FontConfiguration fc;

    public ETileLookAheadOrBehind(ETile orig, FontConfiguration fc, Style style, HColorSet colorSet, String type) {
        this.style = style;
        this.orig = orig;
        this.fc = fc;
        this.colorSet = colorSet;
        this.supText = UText.build(type, fc);
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        return 6.0 + this.orig.getH1(stringBounder);
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        return this.orig.getH2(stringBounder) + 6.0;
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        return this.orig.getWidth(stringBounder) + 4.0 + 8.0 + this.supText.calculateDimension(stringBounder).getWidth();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim = this.calculateDimension(stringBounder);
        HColor lineColor = this.style.value(PName.LineColor).asColor(this.colorSet);
        URectangle rect = URectangle.build(dim).rounded(30.0);
        ug.apply(lineColor).apply(new UStroke(2.0, 3.0, 1.0)).draw(rect);
        double posText = this.getH1(stringBounder) + this.supText.getDescent(stringBounder);
        ug.apply(new UTranslate(4.0, 2.0 + posText)).draw(this.supText);
        this.orig.drawU(ug.apply(new UTranslate(4.0 + this.supText.calculateDimension(stringBounder).getWidth(), 6.0)));
    }

    @Override
    public void push(ETile tile) {
        throw new UnsupportedOperationException();
    }
}

