# This file has been autogenerated by the pywayland scanner

# Copyright © 2024 Xaver Hugl
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class WpAlphaModifierSurfaceV1(Interface):
    """Alpha modifier object for a surface

    This interface allows the client to set a factor for the alpha values on a
    surface, which can be used to offload such operations to the compositor.
    The default factor is UINT32_MAX.

    This object has to be destroyed before the associated
    :class:`~pywayland.protocol.wayland.WlSurface`. Once the
    :class:`~pywayland.protocol.wayland.WlSurface` is destroyed, all request on
    this object will raise the no_surface error.
    """

    name = "wp_alpha_modifier_surface_v1"
    version = 1

    class error(enum.IntEnum):
        no_surface = 0


class WpAlphaModifierSurfaceV1Proxy(Proxy[WpAlphaModifierSurfaceV1]):
    interface = WpAlphaModifierSurfaceV1

    @WpAlphaModifierSurfaceV1.request()
    def destroy(self) -> None:
        """Destroy the alpha modifier object

        This destroys the object, and is equivalent to set_multiplier with a
        value of UINT32_MAX, with the same double-buffered semantics as
        set_multiplier.
        """
        self._marshal(0)
        self._destroy()

    @WpAlphaModifierSurfaceV1.request(
        Argument(ArgumentType.Uint),
    )
    def set_multiplier(self, factor: int) -> None:
        """Specify the alpha multiplier

        Sets the alpha multiplier for the surface. The alpha multiplier is
        double-buffered state, see :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` for details.

        This factor is applied in the compositor's blending space, as an
        additional step after the processing of per-pixel alpha values for the
        :class:`~pywayland.protocol.wayland.WlSurface`. The exact meaning of
        the factor is thus undefined, unless the blending space is specified in
        a different extension.

        This multiplier is applied even if the buffer attached to the
        :class:`~pywayland.protocol.wayland.WlSurface` doesn't have an alpha
        channel; in that case an alpha value of one is used instead.

        Zero means completely transparent, UINT32_MAX means completely opaque.

        :param factor:
        :type factor:
            `ArgumentType.Uint`
        """
        self._marshal(1, factor)


class WpAlphaModifierSurfaceV1Resource(Resource):
    interface = WpAlphaModifierSurfaceV1


class WpAlphaModifierSurfaceV1Global(Global):
    interface = WpAlphaModifierSurfaceV1


WpAlphaModifierSurfaceV1._gen_c()
WpAlphaModifierSurfaceV1.proxy_class = WpAlphaModifierSurfaceV1Proxy
WpAlphaModifierSurfaceV1.resource_class = WpAlphaModifierSurfaceV1Resource
WpAlphaModifierSurfaceV1.global_class = WpAlphaModifierSurfaceV1Global
