/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;

@ApiStatus.Internal
public final class BasicXmlTagUtil {
    private static final ObjectIntMap<String> ourCharacterEntities = new ObjectIntHashMap(6);

    public static String getCDATAQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&\n";
        int textLength = text.length();
        if (textLength > 0 && (Character.isWhitespace(text.charAt(0)) || Character.isWhitespace(text.charAt(textLength - 1)))) {
            return "<![CDATA[" + text + "]]>";
        }
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static String getInlineQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&";
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static CharSequence composeTagText(@NonNls String tagName, @NonNls String tagValue) {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(tagName);
        if (StringUtil.isEmpty((String)tagValue)) {
            builder.append("/>");
        } else {
            builder.append('>').append(BasicXmlTagUtil.getCDATAQuote(tagValue)).append("</").append(tagName).append('>');
        }
        return builder;
    }

    public static String[] getCharacterEntityNames() {
        return ArrayUtilRt.toStringArray((Collection)ourCharacterEntities.keySet());
    }

    public static char getCharacterByEntityName(String entityName) {
        int c = ourCharacterEntities.get((Object)entityName);
        return c == -1 ? (char)'\u0000' : (char)c;
    }

    static {
        ourCharacterEntities.put((Object)"lt", 60);
        ourCharacterEntities.put((Object)"gt", 62);
        ourCharacterEntities.put((Object)"apos", 39);
        ourCharacterEntities.put((Object)"quot", 34);
        ourCharacterEntities.put((Object)"nbsp", 160);
        ourCharacterEntities.put((Object)"amp", 38);
    }
}

