/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.maven.MavenJpsBundle;
import org.jetbrains.jps.maven.compiler.MavenPatternFileFilter;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenFilteredJarConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTarget;

public final class MavenFilteredJarModuleBuilder
extends ModuleLevelBuilder {
    private static final Key<MavenProjectConfiguration> CACHE_JAR_CONFIG = Key.create((String)"MavenFilteredJarModuleBuilder.MavenProjectConfiguration.cache");
    private final ConcurrentMap<String, BuildListener> listenerMap = new ConcurrentHashMap<String, BuildListener>();

    MavenFilteredJarModuleBuilder() {
        super(BuilderCategory.CLASS_INSTRUMENTER);
    }

    public void chunkBuildStarted(final CompileContext context, final ModuleChunk chunk) {
        final List<MavenFilteredJarConfiguration> jarsConfig = MavenFilteredJarModuleBuilder.getJarsConfig(context, chunk);
        if (jarsConfig.isEmpty()) {
            return;
        }
        BuildListener listener = new BuildListener(){

            public void filesGenerated(@NotNull FileGeneratedEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Pair pair : event.getPaths()) {
                    List configs = ContainerUtil.filter((Collection)jarsConfig, c -> c.originalOutput.equals(FileUtilRt.toSystemDependentName((String)((String)pair.first))));
                    configs.forEach(config -> MavenFilteredJarModuleBuilder.copyCreatedFileIfNeeded((Pair<String, String>)pair, config, context));
                }
            }

            public void filesDeleted(@NotNull FileDeletedEvent event) {
                List<MavenFilteredJarConfiguration> jarsConfig2;
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((jarsConfig2 = MavenFilteredJarModuleBuilder.getJarsConfig(context, chunk)).isEmpty()) {
                    return;
                }
                for (String deletedFilePath : event.getFilePaths()) {
                    List configs = ContainerUtil.filter(jarsConfig2, c -> FileUtil.isAncestor((String)c.originalOutput, (String)deletedFilePath, (boolean)true));
                    for (MavenFilteredJarConfiguration config : configs) {
                        MavenFilteredJarModuleBuilder.deleteFile(config, deletedFilePath);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenFilteredJarModuleBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "filesGenerated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "filesDeleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.listenerMap.put(MavenFilteredJarModuleBuilder.nameFor(chunk), listener);
        context.addBuildListener(listener);
    }

    private static String nameFor(ModuleChunk chunk) {
        return chunk.getTargets().stream().map(t -> t.getPresentableName()).collect(Collectors.joining());
    }

    private static void deleteFile(MavenFilteredJarConfiguration config, String path) {
        String relative = FileUtilRt.getRelativePath((File)new File(config.originalOutput), (File)new File(path));
        if (relative == null) {
            return;
        }
        try {
            FileUtilRt.deleteRecursively((Path)new File(new File(config.jarOutput), relative).toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void copyCreatedFileIfNeeded(Pair<String, String> pair, MavenFilteredJarConfiguration config, CompileContext context) {
        File from = new File(new File((String)pair.first), (String)pair.second);
        File to = new File(new File(config.jarOutput), (String)pair.second);
        MavenPatternFileFilter filter = new MavenPatternFileFilter(config.includes, config.excludes);
        if (filter.accept((String)pair.second)) {
            try {
                FSOperations.copy((File)from, (File)to);
            }
            catch (IOException e) {
                context.processMessage((BuildMessage)new CompilerMessage(MavenJpsBundle.message("maven.filter.jar.compiler", new Object[0]), BuildMessage.Kind.ERROR, e.getMessage()));
            }
        }
    }

    @NotNull
    public static List<MavenFilteredJarConfiguration> getJarsConfig(CompileContext context, ModuleChunk chunk) {
        List<MavenFilteredJarConfiguration> list = chunk.getTargets().stream().flatMap(target -> MavenFilteredJarModuleBuilder.getJarConfigurations(context, target.getModule().getName(), target.isTests()).stream()).collect(Collectors.toList());
        if (list == null) {
            MavenFilteredJarModuleBuilder.$$$reportNull$$$0(0);
        }
        return list;
    }

    static List<MavenFilteredJarConfiguration> getJarsConfig(@NotNull CompileContext context, @NotNull MavenResourcesTarget target) {
        if (context == null) {
            MavenFilteredJarModuleBuilder.$$$reportNull$$$0(1);
        }
        if (target == null) {
            MavenFilteredJarModuleBuilder.$$$reportNull$$$0(2);
        }
        return MavenFilteredJarModuleBuilder.getJarConfigurations(context, target.getModule().getName(), target.isTests());
    }

    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        BuildListener buildListener = (BuildListener)this.listenerMap.remove(MavenFilteredJarModuleBuilder.nameFor(chunk));
        if (buildListener != null) {
            context.removeBuildListener(buildListener);
        }
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        return ModuleLevelBuilder.ExitCode.OK;
    }

    @NotNull
    private static List<MavenFilteredJarConfiguration> getJarConfigurations(CompileContext context, String moduleName, boolean isTests) {
        MavenProjectConfiguration projectConfig = MavenFilteredJarModuleBuilder.getOrLoadConfiguration(context);
        if (projectConfig == null) {
            List<MavenFilteredJarConfiguration> list = Collections.emptyList();
            if (list == null) {
                MavenFilteredJarModuleBuilder.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = ContainerUtil.filter(projectConfig.jarsConfiguration.values(), it -> it.moduleName.equals(moduleName) && it.isTest == isTests);
        if (list == null) {
            MavenFilteredJarModuleBuilder.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private static MavenProjectConfiguration getOrLoadConfiguration(CompileContext context) {
        MavenProjectConfiguration projectConfig = (MavenProjectConfiguration)context.getUserData(CACHE_JAR_CONFIG);
        if (projectConfig != null) {
            return projectConfig;
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        context.putUserData(CACHE_JAR_CONFIG, (Object)projectConfig);
        return projectConfig;
    }

    @NotNull
    public List<String> getCompilableFileExtensions() {
        List<String> list = List.of();
        if (list == null) {
            MavenFilteredJarModuleBuilder.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getPresentableName() {
        String string = MavenJpsBundle.message("maven.filter.jar.compiler", new Object[0]);
        if (string == null) {
            MavenFilteredJarModuleBuilder.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/maven/compiler/MavenFilteredJarModuleBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarsConfig";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenFilteredJarModuleBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarConfigurations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilableFileExtensions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJarsConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

