/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.connection.EventLogSettingsClient;
import com.jetbrains.fus.reporting.configuration.ConfigurationClient;
import com.jetbrains.fus.reporting.configuration.ConfigurationClientFactory;
import com.jetbrains.fus.reporting.configuration.RegionCode;
import com.jetbrains.fus.reporting.connection.JavaHttpClientBuilder;
import com.jetbrains.fus.reporting.connection.JavaHttpRequestBuilder;
import com.jetbrains.fus.reporting.connection.ProxyInfo;
import com.jetbrains.fus.reporting.model.http.HttpClientBuilder;
import com.jetbrains.fus.reporting.model.http.HttpRequestBuilder;
import com.jetbrains.fus.reporting.model.serialization.Serializer;
import com.jetbrains.fus.reporting.serialization.FusKotlinSerializer;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/eventLog/connection/EventLogUploadSettingsClient;", "Lcom/intellij/internal/statistic/eventLog/connection/EventLogSettingsClient;", "recorderId", "", "applicationInfo", "Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;", "cacheTimeoutMs", "", "<init>", "(Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;J)V", "getRecorderId", "()Ljava/lang/String;", "getApplicationInfo", "()Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;", "configurationClient", "Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;", "getConfigurationClient", "()Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;", "setConfigurationClient", "(Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;)V", "Companion", "intellij.platform.statistics.uploader"})
@ApiStatus.Internal
public class EventLogUploadSettingsClient
extends EventLogSettingsClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    @NotNull
    private final EventLogApplicationInfo applicationInfo;
    @NotNull
    private ConfigurationClient configurationClient;
    @VisibleForTesting
    @NotNull
    private static final String chinaRegion = "china";

    public EventLogUploadSettingsClient(@NotNull String recorderId, @NotNull EventLogApplicationInfo applicationInfo, long cacheTimeoutMs) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)applicationInfo, (String)"applicationInfo");
        this.recorderId = recorderId;
        this.applicationInfo = applicationInfo;
        ConfigurationClientFactory.Companion companion = ConfigurationClientFactory.Companion;
        String string = this.getRecorderId();
        String string2 = this.getApplicationInfo().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProductCode(...)");
        String string3 = string2;
        String string4 = this.getApplicationInfo().getProductVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProductVersion(...)");
        String string5 = string4;
        boolean bl = this.getApplicationInfo().isTestConfig();
        JavaHttpClientBuilder javaHttpClientBuilder = new JavaHttpClientBuilder().setSSLContext(this.getApplicationInfo().getConnectionSettings().provideSSLContext()).setProxyProvider(arg_0 -> EventLogUploadSettingsClient.configurationClient$lambda$0(this, arg_0));
        JavaHttpRequestBuilder javaHttpRequestBuilder = new JavaHttpRequestBuilder().setExtraHeaders(this.getApplicationInfo().getConnectionSettings().provideExtraHeaders()).setUserAgent(this.getApplicationInfo().getConnectionSettings().provideUserAgent());
        RegionCode regionCode = Intrinsics.areEqual((Object)this.getApplicationInfo().getRegionalCode(), (Object)chinaRegion) ? RegionCode.CN : RegionCode.ALL;
        FusKotlinSerializer fusKotlinSerializer = new FusKotlinSerializer();
        this.configurationClient = companion.create(string, string3, string5, bl, (HttpClientBuilder)javaHttpClientBuilder, (HttpRequestBuilder)javaHttpRequestBuilder, regionCode, cacheTimeoutMs, (Serializer)fusKotlinSerializer);
    }

    public /* synthetic */ EventLogUploadSettingsClient(String string, EventLogApplicationInfo eventLogApplicationInfo, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = TimeUnit.MINUTES.toMillis(10L);
        }
        this(string, eventLogApplicationInfo, l);
    }

    @Override
    @NotNull
    public String getRecorderId() {
        return this.recorderId;
    }

    @Override
    @NotNull
    public EventLogApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @Override
    @NotNull
    public ConfigurationClient getConfigurationClient() {
        return this.configurationClient;
    }

    public void setConfigurationClient(@NotNull ConfigurationClient configurationClient) {
        Intrinsics.checkNotNullParameter((Object)configurationClient, (String)"<set-?>");
        this.configurationClient = configurationClient;
    }

    private static final ProxyInfo configurationClient$lambda$0(EventLogUploadSettingsClient this$0, String configurationUrl) {
        Intrinsics.checkNotNullParameter((Object)configurationUrl, (String)"configurationUrl");
        return new ProxyInfo(this$0.getApplicationInfo().getConnectionSettings().provideProxy(configurationUrl).getProxy(), null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/eventLog/connection/EventLogUploadSettingsClient$Companion;", "", "<init>", "()V", "chinaRegion", "", "getChinaRegion", "()Ljava/lang/String;", "intellij.platform.statistics.uploader"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getChinaRegion() {
            return chinaRegion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

