/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.phonetics.metaphone;

import ai.grazie.nlp.phonetics.PhoneticEncoder;
import ai.grazie.utils.multiplatform.SafeJsExport;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@SafeJsExport
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\f\n\u0002\b\u0007\b\u0007\u0018\u0000 02\u00020\u0001:\u0002/0B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u001e\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00052\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J$\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J$\u0010\u0011\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J$\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J$\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J,\u0010\u0014\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J$\u0010\u0016\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J$\u0010\u0017\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J,\u0010\u0018\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J$\u0010\u0019\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J$\u0010\u001a\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J,\u0010\u001b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J,\u0010\u001c\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J$\u0010\u001d\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J$\u0010\u001e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J$\u0010\u001f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J$\u0010 \u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J,\u0010!\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0014\u0010,\u001a\u0004\u0018\u00010\u00072\b\u0010-\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010.\u001a\u00020*2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lai/grazie/nlp/phonetics/metaphone/DoubleMetaphone;", "Lai/grazie/nlp/phonetics/PhoneticEncoder;", "<init>", "()V", "maxCodeLen", "", "encode", "", "value", "doubleMetaphone", "alternate", "", "handleAEIOUY", "result", "Lai/grazie/nlp/phonetics/metaphone/DoubleMetaphone$DoubleMetaphoneResult;", "index", "handleC", "handleCC", "handleCH", "handleD", "handleG", "slavoGermanic", "handleGH", "handleH", "handleJ", "handleL", "handleP", "handleR", "handleS", "handleSC", "handleT", "handleW", "handleX", "handleZ", "conditionC0", "conditionCH0", "conditionCH1", "conditionL0", "conditionM0", "isSlavoGermanic", "isVowel", "ch", "", "isSilentStart", "cleanInput", "input", "charAt", "DoubleMetaphoneResult", "Companion", "nlp-phonetics"})
@SourceDebugExtension(value={"SMAP\nDoubleMetaphone.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleMetaphone.kt\nai/grazie/nlp/phonetics/metaphone/DoubleMetaphone\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,926:1\n108#2:927\n80#2,22:928\n*S KotlinDebug\n*F\n+ 1 DoubleMetaphone.kt\nai/grazie/nlp/phonetics/metaphone/DoubleMetaphone\n*L\n801#1:927\n801#1:928,22\n*E\n"})
public final class DoubleMetaphone
implements PhoneticEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxCodeLen;
    @NotNull
    private static final String VOWELS = "AEIOUY";
    @NotNull
    private static final String[] SILENT_START;
    @NotNull
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE;
    @NotNull
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER;
    @NotNull
    private static final String[] L_T_K_S_N_M_B_Z;

    public DoubleMetaphone() {
        this.maxCodeLen = 12;
    }

    @Override
    @NotNull
    public String encode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = DoubleMetaphone.doubleMetaphone$default(this, value, false, 2, null);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String doubleMetaphone(String value, boolean alternate) {
        String value2 = value;
        if ((value2 = this.cleanInput(value2)) == null) {
            return null;
        }
        boolean slavoGermanic = this.isSlavoGermanic(value2);
        int index = this.isSilentStart(value2) ? 1 : 0;
        DoubleMetaphoneResult result2 = new DoubleMetaphoneResult(this.maxCodeLen);
        block25: while (!result2.isComplete() && index <= value2.length() - 1) {
            switch (value2.charAt(index)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    index = this.handleAEIOUY(result2, index);
                    continue block25;
                }
                case 'B': {
                    result2.append$nlp_phonetics('P');
                    index = this.charAt(value2, index + 1) == 'B' ? index + 2 : index + 1;
                    continue block25;
                }
                case '\u00c7': {
                    result2.append$nlp_phonetics('S');
                    ++index;
                    continue block25;
                }
                case 'C': {
                    index = this.handleC(value2, result2, index);
                    continue block25;
                }
                case 'D': {
                    index = this.handleD(value2, result2, index);
                    continue block25;
                }
                case 'F': {
                    result2.append$nlp_phonetics('F');
                    index = this.charAt(value2, index + 1) == 'F' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'G': {
                    index = this.handleG(value2, result2, index, slavoGermanic);
                    continue block25;
                }
                case 'H': {
                    index = this.handleH(value2, result2, index);
                    continue block25;
                }
                case 'J': {
                    index = this.handleJ(value2, result2, index, slavoGermanic);
                    continue block25;
                }
                case 'K': {
                    result2.append$nlp_phonetics('K');
                    index = this.charAt(value2, index + 1) == 'K' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'L': {
                    index = this.handleL(value2, result2, index);
                    continue block25;
                }
                case 'M': {
                    result2.append$nlp_phonetics('M');
                    index = this.conditionM0(value2, index) ? index + 2 : index + 1;
                    continue block25;
                }
                case 'N': {
                    result2.append$nlp_phonetics('N');
                    index = this.charAt(value2, index + 1) == 'N' ? index + 2 : index + 1;
                    continue block25;
                }
                case '\u00d1': {
                    result2.append$nlp_phonetics('N');
                    ++index;
                    continue block25;
                }
                case 'P': {
                    index = this.handleP(value2, result2, index);
                    continue block25;
                }
                case 'Q': {
                    result2.append$nlp_phonetics('K');
                    index = this.charAt(value2, index + 1) == 'Q' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'R': {
                    index = this.handleR(value2, result2, index, slavoGermanic);
                    continue block25;
                }
                case 'S': {
                    index = this.handleS(value2, result2, index, slavoGermanic);
                    continue block25;
                }
                case 'T': {
                    index = this.handleT(value2, result2, index);
                    continue block25;
                }
                case 'V': {
                    result2.append$nlp_phonetics('F');
                    index = this.charAt(value2, index + 1) == 'V' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'W': {
                    index = this.handleW(value2, result2, index);
                    continue block25;
                }
                case 'X': {
                    index = this.handleX(value2, result2, index);
                    continue block25;
                }
                case 'Z': {
                    index = this.handleZ(value2, result2, index, slavoGermanic);
                    continue block25;
                }
            }
            ++index;
        }
        return alternate ? result2.getAlternate() : result2.getPrimary();
    }

    static /* synthetic */ String doubleMetaphone$default(DoubleMetaphone doubleMetaphone, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return doubleMetaphone.doubleMetaphone(string, bl);
    }

    private final int handleAEIOUY(DoubleMetaphoneResult result2, int index) {
        if (index == 0) {
            result2.append$nlp_phonetics('A');
        }
        return index + 1;
    }

    private final int handleC(String value, DoubleMetaphoneResult result2, int index) {
        String[] stringArray;
        int index2 = index;
        if (this.conditionC0(value, index2)) {
            result2.append$nlp_phonetics('K');
            index2 += 2;
        } else if (index2 == 0 && DoubleMetaphone.Companion.contains(value, index2, 6, stringArray = new String[]{"CAESAR"})) {
            result2.append$nlp_phonetics('S');
            index2 += 2;
        } else {
            stringArray = new String[]{"CH"};
            if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                index2 = this.handleCH(value, result2, index2);
            } else {
                stringArray = new String[]{"CZ"};
                if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray) && !DoubleMetaphone.Companion.contains(value, index2 - 2, 4, stringArray = new String[]{"WICZ"})) {
                    result2.append$nlp_phonetics('S', 'X');
                    index2 += 2;
                } else {
                    stringArray = new String[]{"CIA"};
                    if (DoubleMetaphone.Companion.contains(value, index2 + 1, 3, stringArray)) {
                        result2.append$nlp_phonetics('X');
                        index2 += 3;
                    } else {
                        stringArray = new String[]{"CC"};
                        if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray) && (index2 != 1 || this.charAt(value, 0) != 'M')) {
                            return this.handleCC(value, result2, index2);
                        }
                        stringArray = new String[]{"CK", "CG", "CQ"};
                        if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                            result2.append$nlp_phonetics('K');
                            index2 += 2;
                        } else {
                            stringArray = new String[]{"CI", "CE", "CY"};
                            if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                                stringArray = new String[]{"CIO", "CIE", "CIA"};
                                if (DoubleMetaphone.Companion.contains(value, index2, 3, stringArray)) {
                                    result2.append$nlp_phonetics('S', 'X');
                                } else {
                                    result2.append$nlp_phonetics('S');
                                }
                                index2 += 2;
                            } else {
                                result2.append$nlp_phonetics('K');
                                stringArray = new String[]{" C", " Q", " G"};
                                index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray) ? (index2 += 3) : (DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray = new String[]{"C", "K", "Q"}) && !DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray = new String[]{"CE", "CI"}) ? (index2 += 2) : ++index2);
                            }
                        }
                    }
                }
            }
        }
        return index2;
    }

    private final int handleCC(String value, DoubleMetaphoneResult result2, int index) {
        int index2 = index;
        String[] stringArray = new String[]{"I", "E", "H"};
        if (DoubleMetaphone.Companion.contains(value, index2 + 2, 1, stringArray) && !DoubleMetaphone.Companion.contains(value, index2 + 2, 2, stringArray = new String[]{"HU"})) {
            if (index2 == 1 && this.charAt(value, index2 - 1) == 'A' || DoubleMetaphone.Companion.contains(value, index2 - 1, 5, stringArray = new String[]{"UCCEE", "UCCES"})) {
                result2.append$nlp_phonetics("KS");
            } else {
                result2.append$nlp_phonetics('X');
            }
            index2 += 3;
        } else {
            result2.append$nlp_phonetics('K');
            index2 += 2;
        }
        return index2;
    }

    private final int handleCH(String value, DoubleMetaphoneResult result2, int index) {
        String[] stringArray;
        if (index > 0) {
            stringArray = new String[]{"CHAE"};
            if (DoubleMetaphone.Companion.contains(value, index, 4, stringArray)) {
                result2.append$nlp_phonetics('K', 'X');
                return index + 2;
            }
        }
        if (this.conditionCH0(value, index)) {
            result2.append$nlp_phonetics('K');
            return index + 2;
        }
        if (this.conditionCH1(value, index)) {
            result2.append$nlp_phonetics('K');
            return index + 2;
        }
        if (index > 0) {
            stringArray = new String[]{"MC"};
            if (DoubleMetaphone.Companion.contains(value, 0, 2, stringArray)) {
                result2.append$nlp_phonetics('K');
            } else {
                result2.append$nlp_phonetics('X', 'K');
            }
        } else {
            result2.append$nlp_phonetics('X');
        }
        return index + 2;
    }

    private final int handleD(String value, DoubleMetaphoneResult result2, int index) {
        int index2 = index;
        String[] stringArray = new String[]{"DG"};
        if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
            stringArray = new String[]{"I", "E", "Y"};
            if (DoubleMetaphone.Companion.contains(value, index2 + 2, 1, stringArray)) {
                result2.append$nlp_phonetics('J');
                index2 += 3;
            } else {
                result2.append$nlp_phonetics("TK");
                index2 += 2;
            }
        } else {
            stringArray = new String[]{"DT", "DD"};
            if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                result2.append$nlp_phonetics('T');
                index2 += 2;
            } else {
                result2.append$nlp_phonetics('T');
                ++index2;
            }
        }
        return index2;
    }

    private final int handleG(String value, DoubleMetaphoneResult result2, int index, boolean slavoGermanic) {
        int index2 = index;
        if (this.charAt(value, index2 + 1) == 'H') {
            index2 = this.handleGH(value, result2, index2);
        } else if (this.charAt(value, index2 + 1) == 'N') {
            if (index2 == 1 && this.isVowel(this.charAt(value, 0)) && !slavoGermanic) {
                result2.append$nlp_phonetics("KN", "N");
            } else {
                String[] stringArray = new String[]{"EY"};
                if (!DoubleMetaphone.Companion.contains(value, index2 + 2, 2, stringArray) && this.charAt(value, index2 + 1) != 'Y' && !slavoGermanic) {
                    result2.append$nlp_phonetics("N", "KN");
                } else {
                    result2.append$nlp_phonetics("KN");
                }
            }
            index2 += 2;
        } else {
            String[] stringArray = new String[]{"LI"};
            if (DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray) && !slavoGermanic) {
                result2.append$nlp_phonetics("KL", "L");
                index2 += 2;
            } else if (index2 == 0 && (this.charAt(value, index2 + 1) == 'Y' || DoubleMetaphone.Companion.contains(value, index2 + 1, 2, Arrays.copyOf(stringArray = DoubleMetaphone.ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER, stringArray.length)))) {
                result2.append$nlp_phonetics('K', 'J');
                index2 += 2;
            } else {
                stringArray = new String[]{"ER"};
                if (!(!DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray) && this.charAt(value, index2 + 1) != 'Y' || DoubleMetaphone.Companion.contains(value, 0, 6, stringArray = new String[]{"DANGER", "RANGER", "MANGER"}) || DoubleMetaphone.Companion.contains(value, index2 - 1, 1, stringArray = new String[]{"E", "I"}) || DoubleMetaphone.Companion.contains(value, index2 - 1, 3, stringArray = new String[]{"RGY", "OGY"}))) {
                    result2.append$nlp_phonetics('K', 'J');
                    index2 += 2;
                } else {
                    stringArray = new String[]{"E", "I", "Y"};
                    if (DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) || DoubleMetaphone.Companion.contains(value, index2 - 1, 4, stringArray = new String[]{"AGGI", "OGGI"})) {
                        stringArray = new String[]{"VAN ", "VON "};
                        if (DoubleMetaphone.Companion.contains(value, 0, 4, stringArray) || DoubleMetaphone.Companion.contains(value, 0, 3, stringArray = new String[]{"SCH"}) || DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray = new String[]{"ET"})) {
                            result2.append$nlp_phonetics('K');
                        } else {
                            stringArray = new String[]{"IER"};
                            if (DoubleMetaphone.Companion.contains(value, index2 + 1, 3, stringArray)) {
                                result2.append$nlp_phonetics('J');
                            } else {
                                result2.append$nlp_phonetics('J', 'K');
                            }
                        }
                        index2 += 2;
                    } else if (this.charAt(value, index2 + 1) == 'G') {
                        index2 += 2;
                        result2.append$nlp_phonetics('K');
                    } else {
                        ++index2;
                        result2.append$nlp_phonetics('K');
                    }
                }
            }
        }
        return index2;
    }

    private final int handleGH(String value, DoubleMetaphoneResult result2, int index) {
        String[] stringArray;
        int index2 = index;
        if (index2 > 0 && !this.isVowel(this.charAt(value, index2 - 1))) {
            result2.append$nlp_phonetics('K');
            index2 += 2;
        } else if (index2 == 0) {
            if (this.charAt(value, index2 + 2) == 'I') {
                result2.append$nlp_phonetics('J');
            } else {
                result2.append$nlp_phonetics('K');
            }
            index2 += 2;
        } else if (index2 > 1 && DoubleMetaphone.Companion.contains(value, index2 - 2, 1, stringArray = new String[]{"B", "H", "D"}) || index2 > 2 && DoubleMetaphone.Companion.contains(value, index2 - 3, 1, stringArray = new String[]{"B", "H", "D"}) || index2 > 3 && DoubleMetaphone.Companion.contains(value, index2 - 4, 1, stringArray = new String[]{"B", "H"})) {
            index2 += 2;
        } else {
            if (index2 > 2 && this.charAt(value, index2 - 1) == 'U' && DoubleMetaphone.Companion.contains(value, index2 - 3, 1, stringArray = new String[]{"C", "G", "L", "R", "T"})) {
                result2.append$nlp_phonetics('F');
            } else if (index2 > 0 && this.charAt(value, index2 - 1) != 'I') {
                result2.append$nlp_phonetics('K');
            }
            index2 += 2;
        }
        return index2;
    }

    private final int handleH(String value, DoubleMetaphoneResult result2, int index) {
        int index2 = index;
        if ((index2 == 0 || this.isVowel(this.charAt(value, index2 - 1))) && this.isVowel(this.charAt(value, index2 + 1))) {
            result2.append$nlp_phonetics('H');
            index2 += 2;
        } else {
            ++index2;
        }
        return index2;
    }

    private final int handleJ(String value, DoubleMetaphoneResult result2, int index, boolean slavoGermanic) {
        int index2 = index;
        String[] stringArray = new String[]{"JOSE"};
        if (DoubleMetaphone.Companion.contains(value, index2, 4, stringArray) || DoubleMetaphone.Companion.contains(value, 0, 4, stringArray = new String[]{"SAN "})) {
            if (index2 == 0 && this.charAt(value, index2 + 4) == ' ' || value.length() == 4 || DoubleMetaphone.Companion.contains(value, 0, 4, stringArray = new String[]{"SAN "})) {
                result2.append$nlp_phonetics('H');
            } else {
                result2.append$nlp_phonetics('J', 'H');
            }
            ++index2;
        } else {
            if (index2 == 0 && !DoubleMetaphone.Companion.contains(value, index2, 4, stringArray = new String[]{"JOSE"})) {
                result2.append$nlp_phonetics('J', 'A');
            } else if (this.isVowel(this.charAt(value, index2 - 1)) && !slavoGermanic && (this.charAt(value, index2 + 1) == 'A' || this.charAt(value, index2 + 1) == 'O')) {
                result2.append$nlp_phonetics('J', 'H');
            } else if (index2 == value.length() - 1) {
                result2.append$nlp_phonetics('J', ' ');
            } else {
                stringArray = L_T_K_S_N_M_B_Z;
                if (!DoubleMetaphone.Companion.contains(value, index2 + 1, 1, Arrays.copyOf(stringArray, stringArray.length)) && !DoubleMetaphone.Companion.contains(value, index2 - 1, 1, stringArray = new String[]{"S", "K", "L"})) {
                    result2.append$nlp_phonetics('J');
                }
            }
            index2 = this.charAt(value, index2 + 1) == 'J' ? (index2 += 2) : ++index2;
        }
        return index2;
    }

    private final int handleL(String value, DoubleMetaphoneResult result2, int index) {
        int index2 = index;
        if (this.charAt(value, index2 + 1) == 'L') {
            if (this.conditionL0(value, index2)) {
                result2.appendPrimary$nlp_phonetics('L');
            } else {
                result2.append$nlp_phonetics('L');
            }
            index2 += 2;
        } else {
            ++index2;
            result2.append$nlp_phonetics('L');
        }
        return index2;
    }

    private final int handleP(String value, DoubleMetaphoneResult result2, int index) {
        int index2 = index;
        if (this.charAt(value, index2 + 1) == 'H') {
            result2.append$nlp_phonetics('F');
            index2 += 2;
        } else {
            result2.append$nlp_phonetics('P');
            String[] stringArray = new String[]{"P", "B"};
            index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private final int handleR(String value, DoubleMetaphoneResult result2, int index, boolean slavoGermanic) {
        String[] stringArray;
        if (index == value.length() - 1 && !slavoGermanic && DoubleMetaphone.Companion.contains(value, index - 2, 2, stringArray = new String[]{"IE"}) && !DoubleMetaphone.Companion.contains(value, index - 4, 2, stringArray = new String[]{"ME", "MA"})) {
            result2.appendAlternate$nlp_phonetics('R');
        } else {
            result2.append$nlp_phonetics('R');
        }
        return this.charAt(value, index + 1) == 'R' ? index + 2 : index + 1;
    }

    private final int handleS(String value, DoubleMetaphoneResult result2, int index, boolean slavoGermanic) {
        int index2 = index;
        String[] stringArray = new String[]{"ISL", "YSL"};
        if (DoubleMetaphone.Companion.contains(value, index2 - 1, 3, stringArray)) {
            ++index2;
        } else if (index2 == 0 && DoubleMetaphone.Companion.contains(value, index2, 5, stringArray = new String[]{"SUGAR"})) {
            result2.append$nlp_phonetics('X', 'S');
            ++index2;
        } else {
            stringArray = new String[]{"SH"};
            if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                stringArray = new String[]{"HEIM", "HOEK", "HOLM", "HOLZ"};
                if (DoubleMetaphone.Companion.contains(value, index2 + 1, 4, stringArray)) {
                    result2.append$nlp_phonetics('S');
                } else {
                    result2.append$nlp_phonetics('X');
                }
                index2 += 2;
            } else {
                stringArray = new String[]{"SIO", "SIA"};
                if (DoubleMetaphone.Companion.contains(value, index2, 3, stringArray) || DoubleMetaphone.Companion.contains(value, index2, 4, stringArray = new String[]{"SIAN"})) {
                    if (slavoGermanic) {
                        result2.append$nlp_phonetics('S');
                    } else {
                        result2.append$nlp_phonetics('S', 'X');
                    }
                    index2 += 3;
                } else if (index2 == 0 && DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray = new String[]{"M", "N", "L", "W"}) || DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray = new String[]{"Z"})) {
                    result2.append$nlp_phonetics('S', 'X');
                    stringArray = new String[]{"Z"};
                    index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) ? index2 + 2 : index2 + 1;
                } else {
                    stringArray = new String[]{"SC"};
                    if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
                        index2 = this.handleSC(value, result2, index2);
                    } else {
                        if (index2 == value.length() - 1 && DoubleMetaphone.Companion.contains(value, index2 - 2, 2, stringArray = new String[]{"AI", "OI"})) {
                            result2.appendAlternate$nlp_phonetics('S');
                        } else {
                            result2.append$nlp_phonetics('S');
                        }
                        stringArray = new String[]{"S", "Z"};
                        index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) ? index2 + 2 : index2 + 1;
                    }
                }
            }
        }
        return index2;
    }

    private final int handleSC(String value, DoubleMetaphoneResult result2, int index) {
        if (this.charAt(value, index + 2) == 'H') {
            String[] stringArray = new String[]{"OO", "ER", "EN", "UY", "ED", "EM"};
            if (DoubleMetaphone.Companion.contains(value, index + 3, 2, stringArray)) {
                stringArray = new String[]{"ER", "EN"};
                if (DoubleMetaphone.Companion.contains(value, index + 3, 2, stringArray)) {
                    result2.append$nlp_phonetics("X", "SK");
                } else {
                    result2.append$nlp_phonetics("SK");
                }
            } else if (index == 0 && !this.isVowel(this.charAt(value, 3)) && this.charAt(value, 3) != 'W') {
                result2.append$nlp_phonetics('X', 'S');
            } else {
                result2.append$nlp_phonetics('X');
            }
        } else {
            String[] stringArray = new String[]{"I", "E", "Y"};
            if (DoubleMetaphone.Companion.contains(value, index + 2, 1, stringArray)) {
                result2.append$nlp_phonetics('S');
            } else {
                result2.append$nlp_phonetics("SK");
            }
        }
        return index + 3;
    }

    private final int handleT(String value, DoubleMetaphoneResult result2, int index) {
        int index2 = index;
        String[] stringArray = new String[]{"TION"};
        if (DoubleMetaphone.Companion.contains(value, index2, 4, stringArray)) {
            result2.append$nlp_phonetics('X');
            index2 += 3;
        } else {
            stringArray = new String[]{"TIA", "TCH"};
            if (DoubleMetaphone.Companion.contains(value, index2, 3, stringArray)) {
                result2.append$nlp_phonetics('X');
                index2 += 3;
            } else {
                stringArray = new String[]{"TH"};
                if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray) || DoubleMetaphone.Companion.contains(value, index2, 3, stringArray = new String[]{"TTH"})) {
                    stringArray = new String[]{"OM", "AM"};
                    if (DoubleMetaphone.Companion.contains(value, index2 + 2, 2, stringArray) || DoubleMetaphone.Companion.contains(value, 0, 4, stringArray = new String[]{"VAN ", "VON "}) || DoubleMetaphone.Companion.contains(value, 0, 3, stringArray = new String[]{"SCH"})) {
                        result2.append$nlp_phonetics('T');
                    } else {
                        result2.append$nlp_phonetics('0', 'T');
                    }
                    index2 += 2;
                } else {
                    result2.append$nlp_phonetics('T');
                    stringArray = new String[]{"T", "D"};
                    index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) ? index2 + 2 : index2 + 1;
                }
            }
        }
        return index2;
    }

    private final int handleW(String value, DoubleMetaphoneResult result2, int index) {
        int index2 = index;
        String[] stringArray = new String[]{"WR"};
        if (DoubleMetaphone.Companion.contains(value, index2, 2, stringArray)) {
            result2.append$nlp_phonetics('R');
            index2 += 2;
        } else if (index2 == 0 && (this.isVowel(this.charAt(value, index2 + 1)) || DoubleMetaphone.Companion.contains(value, index2, 2, stringArray = new String[]{"WH"}))) {
            if (this.isVowel(this.charAt(value, index2 + 1))) {
                result2.append$nlp_phonetics('A', 'F');
            } else {
                result2.append$nlp_phonetics('A');
            }
            ++index2;
        } else if (index2 == value.length() - 1 && this.isVowel(this.charAt(value, index2 - 1)) || DoubleMetaphone.Companion.contains(value, index2 - 1, 5, stringArray = new String[]{"EWSKI", "EWSKY", "OWSKI", "OWSKY"}) || DoubleMetaphone.Companion.contains(value, 0, 3, stringArray = new String[]{"SCH"})) {
            result2.appendAlternate$nlp_phonetics('F');
            ++index2;
        } else {
            stringArray = new String[]{"WICZ", "WITZ"};
            if (DoubleMetaphone.Companion.contains(value, index2, 4, stringArray)) {
                result2.append$nlp_phonetics("TS", "FX");
                index2 += 4;
            } else {
                ++index2;
            }
        }
        return index2;
    }

    private final int handleX(String value, DoubleMetaphoneResult result2, int index) {
        int index2 = index;
        if (index2 == 0) {
            result2.append$nlp_phonetics('S');
            ++index2;
        } else {
            String[] stringArray;
            if (index2 != value.length() - 1 || !DoubleMetaphone.Companion.contains(value, index2 - 3, 3, stringArray = new String[]{"IAU", "EAU"}) && !DoubleMetaphone.Companion.contains(value, index2 - 2, 2, stringArray = new String[]{"AU", "OU"})) {
                result2.append$nlp_phonetics("KS");
            }
            stringArray = new String[]{"C", "X"};
            index2 = DoubleMetaphone.Companion.contains(value, index2 + 1, 1, stringArray) ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private final int handleZ(String value, DoubleMetaphoneResult result2, int index, boolean slavoGermanic) {
        int index2 = index;
        if (this.charAt(value, index2 + 1) == 'H') {
            result2.append$nlp_phonetics('J');
            index2 += 2;
        } else {
            String[] stringArray = new String[]{"ZO", "ZI", "ZA"};
            if (DoubleMetaphone.Companion.contains(value, index2 + 1, 2, stringArray) || slavoGermanic && index2 > 0 && this.charAt(value, index2 - 1) != 'T') {
                result2.append$nlp_phonetics("S", "TS");
            } else {
                result2.append$nlp_phonetics('S');
            }
            index2 = this.charAt(value, index2 + 1) == 'Z' ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private final boolean conditionC0(String value, int index) {
        String[] stringArray;
        String[] stringArray2 = new String[]{"CHIA"};
        if (DoubleMetaphone.Companion.contains(value, index, 4, stringArray2)) {
            return true;
        }
        if (index <= 1) {
            return false;
        }
        if (this.isVowel(this.charAt(value, index - 2))) {
            return false;
        }
        stringArray2 = new String[]{"ACH"};
        if (!DoubleMetaphone.Companion.contains(value, index - 1, 3, stringArray2)) {
            return false;
        }
        char c = this.charAt(value, index + 2);
        return c != 'I' && c != 'E' || DoubleMetaphone.Companion.contains(value, index - 2, 6, stringArray = new String[]{"BACHER", "MACHER"});
    }

    private final boolean conditionCH0(String value, int index) {
        if (index != 0) {
            return false;
        }
        String[] stringArray = new String[]{"HARAC", "HARIS"};
        if (!DoubleMetaphone.Companion.contains(value, index + 1, 5, stringArray) && !DoubleMetaphone.Companion.contains(value, index + 1, 3, stringArray = new String[]{"HOR", "HYM", "HIA", "HEM"})) {
            return false;
        }
        stringArray = new String[]{"CHORE"};
        return !DoubleMetaphone.Companion.contains(value, 0, 5, stringArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean conditionCH1(String value, int index) {
        String[] stringArray = new String[]{"VAN ", "VON "};
        if (DoubleMetaphone.Companion.contains(value, 0, 4, stringArray)) return true;
        stringArray = new String[]{"SCH"};
        if (DoubleMetaphone.Companion.contains(value, 0, 3, stringArray)) return true;
        stringArray = new String[]{"ORCHES", "ARCHIT", "ORCHID"};
        if (DoubleMetaphone.Companion.contains(value, index - 2, 6, stringArray)) return true;
        stringArray = new String[]{"T", "S"};
        if (DoubleMetaphone.Companion.contains(value, index + 2, 1, stringArray)) return true;
        stringArray = new String[]{"A", "O", "U", "E"};
        if (!DoubleMetaphone.Companion.contains(value, index - 1, 1, stringArray)) {
            if (index != 0) return false;
        }
        if (DoubleMetaphone.Companion.contains(value, index + 2, 1, Arrays.copyOf(stringArray = DoubleMetaphone.L_R_N_M_B_H_F_V_W_SPACE, stringArray.length))) return true;
        if (index + 1 != value.length() - 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean conditionL0(String value, int index) {
        String[] stringArray;
        if (index == value.length() - 3) {
            stringArray = new String[]{"ILLO", "ILLA", "ALLE"};
            if (DoubleMetaphone.Companion.contains(value, index - 1, 4, stringArray)) {
                return true;
            }
        }
        stringArray = new String[]{"AS", "OS"};
        if (!DoubleMetaphone.Companion.contains(value, value.length() - 2, 2, stringArray)) {
            stringArray = new String[]{"A", "O"};
            if (!DoubleMetaphone.Companion.contains(value, value.length() - 1, 1, stringArray)) return false;
        }
        stringArray = new String[]{"ALLE"};
        if (!DoubleMetaphone.Companion.contains(value, index - 1, 4, stringArray)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean conditionM0(String value, int index) {
        if (this.charAt(value, index + 1) == 'M') {
            return true;
        }
        String[] stringArray = new String[]{"UMB"};
        if (!DoubleMetaphone.Companion.contains(value, index - 1, 3, stringArray)) return false;
        if (index + 1 == value.length() - 1) return true;
        stringArray = new String[]{"ER"};
        if (!DoubleMetaphone.Companion.contains(value, index + 2, 2, stringArray)) return false;
        return true;
    }

    private final boolean isSlavoGermanic(String value) {
        return StringsKt.indexOf$default((CharSequence)value, (char)'W', (int)0, (boolean)false, (int)6, null) > -1 || StringsKt.indexOf$default((CharSequence)value, (char)'K', (int)0, (boolean)false, (int)6, null) > -1 || StringsKt.indexOf$default((CharSequence)value, (String)"CZ", (int)0, (boolean)false, (int)6, null) > -1 || StringsKt.indexOf$default((CharSequence)value, (String)"WITZ", (int)0, (boolean)false, (int)6, null) > -1;
    }

    private final boolean isVowel(char ch) {
        return StringsKt.indexOf$default((CharSequence)VOWELS, (char)ch, (int)0, (boolean)false, (int)6, null) != -1;
    }

    private final boolean isSilentStart(String value) {
        boolean result2 = false;
        for (String element : SILENT_START) {
            if (!StringsKt.startsWith$default((String)value, (String)element, (boolean)false, (int)2, null)) continue;
            result2 = true;
            break;
        }
        return result2;
    }

    private final String cleanInput(String input) {
        String string;
        String input2;
        String string2 = input;
        if (string2 == null) {
            return null;
        }
        String $this$trim$iv = input2 = string2;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if ((input2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
            string = null;
        } else {
            String string3 = input2.toUpperCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        }
        return string;
    }

    private final char charAt(String value, int index) {
        return index < 0 || index >= value.length() ? (char)'\u0000' : value.charAt(index);
    }

    static {
        String[] stringArray = new String[]{"GN", "KN", "PN", "WR", "PS"};
        SILENT_START = stringArray;
        stringArray = new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " "};
        L_R_N_M_B_H_F_V_W_SPACE = stringArray;
        stringArray = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
        ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = stringArray;
        stringArray = new String[]{"L", "T", "K", "S", "N", "M", "B", "Z"};
        L_T_K_S_N_M_B_Z = stringArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0014"}, d2={"Lai/grazie/nlp/phonetics/metaphone/DoubleMetaphone$Companion;", "", "<init>", "()V", "VOWELS", "", "SILENT_START", "", "[Ljava/lang/String;", "L_R_N_M_B_H_F_V_W_SPACE", "ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER", "L_T_K_S_N_M_B_Z", "contains", "", "value", "start", "", "length", "criteria", "(Ljava/lang/String;II[Ljava/lang/String;)Z", "nlp-phonetics"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean contains(String value, int start, int length, String ... criteria) {
            boolean result2 = false;
            if (start >= 0 && start + length <= value.length()) {
                String string = value.substring(start, start + length);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String target = string;
                for (String element : criteria) {
                    if (!Intrinsics.areEqual((Object)target, (Object)element)) continue;
                    result2 = true;
                    break;
                }
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u000eJ\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0012J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lai/grazie/nlp/phonetics/metaphone/DoubleMetaphone$DoubleMetaphoneResult;", "", "maxLength", "", "<init>", "(Lai/grazie/nlp/phonetics/metaphone/DoubleMetaphone;I)V", "primary", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "alternate", "append", "", "value", "", "append$nlp_phonetics", "appendPrimary", "appendPrimary$nlp_phonetics", "appendAlternate", "appendAlternate$nlp_phonetics", "", "getPrimary", "getAlternate", "isComplete", "", "()Z", "nlp-phonetics"})
    private final class DoubleMetaphoneResult {
        private final int maxLength;
        @NotNull
        private final StringBuilder primary;
        @NotNull
        private final StringBuilder alternate;

        public DoubleMetaphoneResult(int maxLength) {
            this.maxLength = maxLength;
            this.primary = new StringBuilder(DoubleMetaphone.this.maxCodeLen);
            this.alternate = new StringBuilder(DoubleMetaphone.this.maxCodeLen);
        }

        public final void append$nlp_phonetics(char value) {
            this.appendPrimary$nlp_phonetics(value);
            this.appendAlternate$nlp_phonetics(value);
        }

        public final void append$nlp_phonetics(char primary, char alternate) {
            this.appendPrimary$nlp_phonetics(primary);
            this.appendAlternate$nlp_phonetics(alternate);
        }

        public final void appendPrimary$nlp_phonetics(char value) {
            if (this.primary.length() < this.maxLength) {
                this.primary.append(value);
            }
        }

        public final void appendAlternate$nlp_phonetics(char value) {
            if (this.alternate.length() < this.maxLength) {
                this.alternate.append(value);
            }
        }

        public final void append$nlp_phonetics(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.appendPrimary$nlp_phonetics(value);
            this.appendAlternate$nlp_phonetics(value);
        }

        public final void append$nlp_phonetics(@NotNull String primary, @NotNull String alternate) {
            Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
            Intrinsics.checkNotNullParameter((Object)alternate, (String)"alternate");
            this.appendPrimary$nlp_phonetics(primary);
            this.appendAlternate$nlp_phonetics(alternate);
        }

        public final void appendPrimary$nlp_phonetics(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int addChars = this.maxLength - this.primary.length();
            if (value.length() <= addChars) {
                v0 = this.primary.append(value);
            } else {
                String string = value.substring(0, addChars);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                v0 = this.primary.append(string);
            }
        }

        public final void appendAlternate$nlp_phonetics(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int addChars = this.maxLength - this.alternate.length();
            if (value.length() <= addChars) {
                v0 = this.alternate.append(value);
            } else {
                String string = value.substring(0, addChars);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                v0 = this.alternate.append(string);
            }
        }

        @NotNull
        public final String getPrimary() {
            String string = this.primary.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final String getAlternate() {
            String string = this.alternate.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public final boolean isComplete() {
            return this.primary.length() >= this.maxLength && this.alternate.length() >= this.maxLength;
        }
    }
}

