﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotfleetwise/IoTFleetWise_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTFleetWise {
namespace Model {

/**
 * <p>An HTTP error resulting from creating a vehicle.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateVehicleError">AWS
 * API Reference</a></p>
 */
class CreateVehicleError {
 public:
  AWS_IOTFLEETWISE_API CreateVehicleError() = default;
  AWS_IOTFLEETWISE_API CreateVehicleError(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTFLEETWISE_API CreateVehicleError& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTFLEETWISE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the vehicle with the error.</p>
   */
  inline const Aws::String& GetVehicleName() const { return m_vehicleName; }
  inline bool VehicleNameHasBeenSet() const { return m_vehicleNameHasBeenSet; }
  template <typename VehicleNameT = Aws::String>
  void SetVehicleName(VehicleNameT&& value) {
    m_vehicleNameHasBeenSet = true;
    m_vehicleName = std::forward<VehicleNameT>(value);
  }
  template <typename VehicleNameT = Aws::String>
  CreateVehicleError& WithVehicleName(VehicleNameT&& value) {
    SetVehicleName(std::forward<VehicleNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An HTTP error code.</p>
   */
  inline const Aws::String& GetCode() const { return m_code; }
  inline bool CodeHasBeenSet() const { return m_codeHasBeenSet; }
  template <typename CodeT = Aws::String>
  void SetCode(CodeT&& value) {
    m_codeHasBeenSet = true;
    m_code = std::forward<CodeT>(value);
  }
  template <typename CodeT = Aws::String>
  CreateVehicleError& WithCode(CodeT&& value) {
    SetCode(std::forward<CodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the HTTP error.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  CreateVehicleError& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_vehicleName;

  Aws::String m_code;

  Aws::String m_message;
  bool m_vehicleNameHasBeenSet = false;
  bool m_codeHasBeenSet = false;
  bool m_messageHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTFleetWise
}  // namespace Aws
