﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/medialive/MediaLive_EXPORTS.h>
#include <aws/medialive/model/MultiplexOutputDestination.h>
#include <aws/medialive/model/MultiplexSettings.h>
#include <aws/medialive/model/MultiplexState.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MediaLive {
namespace Model {
/**
 * Placeholder documentation for DeleteMultiplexResponse<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexResponse">AWS
 * API Reference</a></p>
 */
class DeleteMultiplexResult {
 public:
  AWS_MEDIALIVE_API DeleteMultiplexResult() = default;
  AWS_MEDIALIVE_API DeleteMultiplexResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MEDIALIVE_API DeleteMultiplexResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * The unique arn of the multiplex.
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  DeleteMultiplexResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * A list of availability zones for the multiplex.
   */
  inline const Aws::Vector<Aws::String>& GetAvailabilityZones() const { return m_availabilityZones; }
  template <typename AvailabilityZonesT = Aws::Vector<Aws::String>>
  void SetAvailabilityZones(AvailabilityZonesT&& value) {
    m_availabilityZonesHasBeenSet = true;
    m_availabilityZones = std::forward<AvailabilityZonesT>(value);
  }
  template <typename AvailabilityZonesT = Aws::Vector<Aws::String>>
  DeleteMultiplexResult& WithAvailabilityZones(AvailabilityZonesT&& value) {
    SetAvailabilityZones(std::forward<AvailabilityZonesT>(value));
    return *this;
  }
  template <typename AvailabilityZonesT = Aws::String>
  DeleteMultiplexResult& AddAvailabilityZones(AvailabilityZonesT&& value) {
    m_availabilityZonesHasBeenSet = true;
    m_availabilityZones.emplace_back(std::forward<AvailabilityZonesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * A list of the multiplex output destinations.
   */
  inline const Aws::Vector<MultiplexOutputDestination>& GetDestinations() const { return m_destinations; }
  template <typename DestinationsT = Aws::Vector<MultiplexOutputDestination>>
  void SetDestinations(DestinationsT&& value) {
    m_destinationsHasBeenSet = true;
    m_destinations = std::forward<DestinationsT>(value);
  }
  template <typename DestinationsT = Aws::Vector<MultiplexOutputDestination>>
  DeleteMultiplexResult& WithDestinations(DestinationsT&& value) {
    SetDestinations(std::forward<DestinationsT>(value));
    return *this;
  }
  template <typename DestinationsT = MultiplexOutputDestination>
  DeleteMultiplexResult& AddDestinations(DestinationsT&& value) {
    m_destinationsHasBeenSet = true;
    m_destinations.emplace_back(std::forward<DestinationsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The unique id of the multiplex.
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  DeleteMultiplexResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Configuration for a multiplex event.
   */
  inline const MultiplexSettings& GetMultiplexSettings() const { return m_multiplexSettings; }
  template <typename MultiplexSettingsT = MultiplexSettings>
  void SetMultiplexSettings(MultiplexSettingsT&& value) {
    m_multiplexSettingsHasBeenSet = true;
    m_multiplexSettings = std::forward<MultiplexSettingsT>(value);
  }
  template <typename MultiplexSettingsT = MultiplexSettings>
  DeleteMultiplexResult& WithMultiplexSettings(MultiplexSettingsT&& value) {
    SetMultiplexSettings(std::forward<MultiplexSettingsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The name of the multiplex.
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DeleteMultiplexResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The number of currently healthy pipelines.
   */
  inline int GetPipelinesRunningCount() const { return m_pipelinesRunningCount; }
  inline void SetPipelinesRunningCount(int value) {
    m_pipelinesRunningCountHasBeenSet = true;
    m_pipelinesRunningCount = value;
  }
  inline DeleteMultiplexResult& WithPipelinesRunningCount(int value) {
    SetPipelinesRunningCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * The number of programs in the multiplex.
   */
  inline int GetProgramCount() const { return m_programCount; }
  inline void SetProgramCount(int value) {
    m_programCountHasBeenSet = true;
    m_programCount = value;
  }
  inline DeleteMultiplexResult& WithProgramCount(int value) {
    SetProgramCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * The current state of the multiplex.
   */
  inline MultiplexState GetState() const { return m_state; }
  inline void SetState(MultiplexState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline DeleteMultiplexResult& WithState(MultiplexState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * A collection of key-value pairs.
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  DeleteMultiplexResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  DeleteMultiplexResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteMultiplexResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::Vector<Aws::String> m_availabilityZones;

  Aws::Vector<MultiplexOutputDestination> m_destinations;

  Aws::String m_id;

  MultiplexSettings m_multiplexSettings;

  Aws::String m_name;

  int m_pipelinesRunningCount{0};

  int m_programCount{0};

  MultiplexState m_state{MultiplexState::NOT_SET};

  Aws::Map<Aws::String, Aws::String> m_tags;

  Aws::String m_requestId;
  bool m_arnHasBeenSet = false;
  bool m_availabilityZonesHasBeenSet = false;
  bool m_destinationsHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_multiplexSettingsHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_pipelinesRunningCountHasBeenSet = false;
  bool m_programCountHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaLive
}  // namespace Aws
