# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class BackupManagementType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Backup management type to execute the current job."""

    INVALID = "Invalid"
    AZURE_IAAS_VM = "AzureIaasVM"
    MAB = "MAB"
    DPM = "DPM"
    AZURE_BACKUP_SERVER = "AzureBackupServer"
    AZURE_SQL = "AzureSql"
    AZURE_STORAGE = "AzureStorage"
    AZURE_WORKLOAD = "AzureWorkload"
    DEFAULT_BACKUP = "DefaultBackup"


class CopyOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Options to resolve copy conflicts."""

    INVALID = "Invalid"
    CREATE_COPY = "CreateCopy"
    SKIP = "Skip"
    OVERWRITE = "Overwrite"
    FAIL_ON_CONFLICT = "FailOnConflict"


class CreateMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Create mode to indicate recovery of existing soft deleted data source or creation of new data
    source.
    """

    INVALID = "Invalid"
    DEFAULT = "Default"
    RECOVER = "Recover"


class DataSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of workload this item represents."""

    INVALID = "Invalid"
    VM = "VM"
    FILE_FOLDER = "FileFolder"
    AZURE_SQL_DB = "AzureSqlDb"
    SQLDB = "SQLDB"
    EXCHANGE = "Exchange"
    SHAREPOINT = "Sharepoint"
    V_MWARE_VM = "VMwareVM"
    SYSTEM_STATE = "SystemState"
    CLIENT = "Client"
    GENERIC_DATA_SOURCE = "GenericDataSource"
    SQL_DATA_BASE = "SQLDataBase"
    AZURE_FILE_SHARE = "AzureFileShare"
    SAP_HANA_DATABASE = "SAPHanaDatabase"
    SAP_ASE_DATABASE = "SAPAseDatabase"


class HealthState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Health State for the backed up item."""

    PASSED = "Passed"
    ACTION_REQUIRED = "ActionRequired"
    ACTION_SUGGESTED = "ActionSuggested"
    INVALID = "Invalid"


class HealthStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """backups running status for this backup item."""

    PASSED = "Passed"
    ACTION_REQUIRED = "ActionRequired"
    ACTION_SUGGESTED = "ActionSuggested"
    INVALID = "Invalid"


class JobOperationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of operation."""

    INVALID = "Invalid"
    REGISTER = "Register"
    UN_REGISTER = "UnRegister"
    CONFIGURE_BACKUP = "ConfigureBackup"
    BACKUP = "Backup"
    RESTORE = "Restore"
    DISABLE_BACKUP = "DisableBackup"
    DELETE_BACKUP_DATA = "DeleteBackupData"
    CROSS_REGION_RESTORE = "CrossRegionRestore"
    UNDELETE = "Undelete"
    UPDATE_CUSTOMER_MANAGED_KEY = "UpdateCustomerManagedKey"


class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the job."""

    INVALID = "Invalid"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    FAILED = "Failed"
    COMPLETED_WITH_WARNINGS = "CompletedWithWarnings"
    CANCELLED = "Cancelled"
    CANCELLING = "Cancelling"


class JobSupportedAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """JobSupportedAction."""

    INVALID = "Invalid"
    CANCELLABLE = "Cancellable"
    RETRIABLE = "Retriable"


class LastBackupStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Last backup operation status. Possible values: Healthy, Unhealthy."""

    INVALID = "Invalid"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    IR_PENDING = "IRPending"


class MabServerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Server type of MAB container."""

    INVALID = "Invalid"
    UNKNOWN = "Unknown"
    IAAS_VM_CONTAINER = "IaasVMContainer"
    IAAS_VM_SERVICE_CONTAINER = "IaasVMServiceContainer"
    DPM_CONTAINER = "DPMContainer"
    AZURE_BACKUP_SERVER_CONTAINER = "AzureBackupServerContainer"
    MAB_CONTAINER = "MABContainer"
    CLUSTER = "Cluster"
    AZURE_SQL_CONTAINER = "AzureSqlContainer"
    WINDOWS = "Windows"
    V_CENTER = "VCenter"
    VM_APP_CONTAINER = "VMAppContainer"
    SQLAG_WORK_LOAD_CONTAINER = "SQLAGWorkLoadContainer"
    STORAGE_CONTAINER = "StorageContainer"
    GENERIC_CONTAINER = "GenericContainer"


class OperationStatusValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operation status."""

    INVALID = "Invalid"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"


class OverwriteOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Can Overwrite if Target DataBase already exists."""

    INVALID = "Invalid"
    FAIL_ON_CONFLICT = "FailOnConflict"
    OVERWRITE = "Overwrite"


class ProtectedItemHealthStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Health status of the backup item, evaluated based on last heartbeat received."""

    INVALID = "Invalid"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    NOT_REACHABLE = "NotReachable"
    IR_PENDING = "IRPending"


class ProtectedItemState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Backup state of the backed up item."""

    INVALID = "Invalid"
    IR_PENDING = "IRPending"
    PROTECTED = "Protected"
    PROTECTION_ERROR = "ProtectionError"
    PROTECTION_STOPPED = "ProtectionStopped"
    PROTECTION_PAUSED = "ProtectionPaused"


class ProtectionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Backup state of this backup item."""

    INVALID = "Invalid"
    IR_PENDING = "IRPending"
    PROTECTED = "Protected"
    PROTECTION_ERROR = "ProtectionError"
    PROTECTION_STOPPED = "ProtectionStopped"
    PROTECTION_PAUSED = "ProtectionPaused"


class RecoveryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines whether the current recovery mode is file restore or database restore."""

    INVALID = "Invalid"
    FILE_RECOVERY = "FileRecovery"
    WORKLOAD_RECOVERY = "WorkloadRecovery"


class RecoveryPointTierStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Recovery point tier status."""

    INVALID = "Invalid"
    VALID = "Valid"
    DISABLED = "Disabled"
    DELETED = "Deleted"
    REHYDRATED = "Rehydrated"


class RecoveryPointTierType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Recovery point tier type."""

    INVALID = "Invalid"
    INSTANT_RP = "InstantRP"
    HARDENED_RP = "HardenedRP"
    ARCHIVED_RP = "ArchivedRP"


class RecoveryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of this recovery."""

    INVALID = "Invalid"
    ORIGINAL_LOCATION = "OriginalLocation"
    ALTERNATE_LOCATION = "AlternateLocation"
    RESTORE_DISKS = "RestoreDisks"
    OFFLINE = "Offline"


class ResourceHealthStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource Health Status."""

    HEALTHY = "Healthy"
    TRANSIENT_DEGRADED = "TransientDegraded"
    PERSISTENT_DEGRADED = "PersistentDegraded"
    TRANSIENT_UNHEALTHY = "TransientUnhealthy"
    PERSISTENT_UNHEALTHY = "PersistentUnhealthy"
    INVALID = "Invalid"


class RestorePointQueryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RestorePoint type."""

    INVALID = "Invalid"
    FULL = "Full"
    LOG = "Log"
    DIFFERENTIAL = "Differential"
    FULL_AND_DIFFERENTIAL = "FullAndDifferential"
    ALL = "All"
    INCREMENTAL = "Incremental"


class RestorePointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of restore point."""

    INVALID = "Invalid"
    FULL = "Full"
    LOG = "Log"
    DIFFERENTIAL = "Differential"
    INCREMENTAL = "Incremental"


class RestoreRequestType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Restore Type (FullShareRestore or ItemLevelRestore)."""

    INVALID = "Invalid"
    FULL_SHARE_RESTORE = "FullShareRestore"
    ITEM_LEVEL_RESTORE = "ItemLevelRestore"


class SQLDataDirectoryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of data directory mapping."""

    INVALID = "Invalid"
    DATA = "Data"
    LOG = "Log"


class StorageType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage type."""

    INVALID = "Invalid"
    GEO_REDUNDANT = "GeoRedundant"
    LOCALLY_REDUNDANT = "LocallyRedundant"
    ZONE_REDUNDANT = "ZoneRedundant"
    READ_ACCESS_GEO_ZONE_REDUNDANT = "ReadAccessGeoZoneRedundant"


class StorageTypeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is
    always Locked.
    """

    INVALID = "Invalid"
    LOCKED = "Locked"
    UNLOCKED = "Unlocked"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Backup management type for this container."""

    INVALID = "Invalid"
    BACKUP_PROTECTED_ITEM_COUNT_SUMMARY = "BackupProtectedItemCountSummary"
    BACKUP_PROTECTION_CONTAINER_COUNT_SUMMARY = "BackupProtectionContainerCountSummary"


class UsagesUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Unit of the usage."""

    COUNT = "Count"
    BYTES = "Bytes"
    SECONDS = "Seconds"
    PERCENT = "Percent"
    COUNT_PER_SECOND = "CountPerSecond"
    BYTES_PER_SECOND = "BytesPerSecond"


class WorkloadType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Workload type of backup item."""

    INVALID = "Invalid"
    VM = "VM"
    FILE_FOLDER = "FileFolder"
    AZURE_SQL_DB = "AzureSqlDb"
    SQLDB = "SQLDB"
    EXCHANGE = "Exchange"
    SHAREPOINT = "Sharepoint"
    V_MWARE_VM = "VMwareVM"
    SYSTEM_STATE = "SystemState"
    CLIENT = "Client"
    GENERIC_DATA_SOURCE = "GenericDataSource"
    SQL_DATA_BASE = "SQLDataBase"
    AZURE_FILE_SHARE = "AzureFileShare"
    SAP_HANA_DATABASE = "SAPHanaDatabase"
    SAP_ASE_DATABASE = "SAPAseDatabase"
