/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.convert.ExternalUtils;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import gps.log.out.GPSFile;

public class GPSGPXFile
extends GPSFile {
    private final StringBuffer rec = new StringBuffer(1024);
    private boolean isWayType;
    private boolean isNewTrack = true;
    private int currentFilter;
    private String trackName = "";
    private boolean isTrkSegSplitOnlyWhenSmall = false;
    private boolean isGPX1_0 = true;
    private boolean addLinkData = true;
    private int posDigits;
    private int heightDigits;
    private boolean isHasComment;
    private boolean isHasSymbol;
    private final String TOPO_1_0_SCHEMA = "http://www.topografix.com/GPX/1/0";
    private final String TOPO_1_1_SCHEMA = "http://www.topografix.com/GPX/1/1";
    private boolean isDataHeaderWritten = false;
    private static final char[] zeros = "0000000".toCharArray();
    private boolean isNeedTrackSegment = false;

    public GPSGPXFile() {
        this.numberOfPasses = 2;
    }

    @Override
    public void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        if (this.getParamObject().hasParam("trk-split-small")) {
            this.isTrkSegSplitOnlyWhenSmall = this.getParamObject().getBoolParam("trk-split-small");
        }
        if (this.getParamObject().hasParam("gpx-link")) {
            this.addLinkData = this.getParamObject().getBoolParam("gpx-link");
        }
        if (this.getParamObject().hasParam("gpx-1_1")) {
            this.isGPX1_0 = !this.getParamObject().getBoolParam("gpx-1_1");
        }
        this.posDigits = this.getParamObject().hasParam("pos-digits") ? this.getParamObject().getIntParam("pos-digits") : 6;
        this.heightDigits = this.getParamObject().hasParam("height-digits") ? this.getParamObject().getIntParam("height-digits") : 3;
        this.isHasComment = this.getParamObject().hasParam("gpxnc") ? !this.getParamObject().getBoolParam("gpxnc") : true;
        this.isHasSymbol = this.getParamObject().hasParam("gpxns") ? !this.getParamObject().getBoolParam("gpxns") : true;
        this.currentFilter = 1;
        this.isWayType = true;
    }

    @Override
    public boolean nextPass() {
        super.nextPass();
        if (this.nbrOfPassesToGo > 0) {
            --this.nbrOfPassesToGo;
            this.previousDate = 0;
            this.isWayType = false;
            this.currentFilter = 0;
            return true;
        }
        return false;
    }

    @Override
    protected final void writeFileHeader(String string) {
        String string2;
        String string3;
        if (this.isGPX1_0) {
            string3 = "http://www.topografix.com/GPX/1/0";
            string2 = "1.0";
        } else {
            string3 = "http://www.topografix.com/GPX/1/1";
            string2 = "1.1";
        }
        String string4 = "";
        if (!this.isGPX1_0) {
            string4 = string4 + "<metadata>";
        }
        string4 = string4 + "<name>" + string + "</name>";
        if (!this.isGPX1_0) {
            string4 = string4 + "</metadata>";
        }
        string = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>\r\n<gpx xmlns=\"" + string3 + "\"\r\n creator=\"BT747 V2.2.1\"" + " version=\"" + string2 + "\"\r\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xsi:schemaLocation=\"" + string3 + " " + string3 + "/gpx.xsd\">\r\n" + string4;
        this.writeTxt(string);
    }

    private final void writeActualDataHeader() {
        if (!this.isWayType) {
            String string = "<trk>";
            if (this.isIncludeTrkName) {
                string = string + "<name>" + this.trackName + "</name>";
            }
            string = string + "<trkseg>\r\n";
            this.isDataHeaderWritten = true;
            this.writeTxt(string);
        }
    }

    @Override
    protected final void writeDataHeader() {
        if (!this.isWayType) {
            this.isNewTrack = true;
        }
    }

    @Override
    protected final void writeDataFooter() {
        if (!this.isWayType && this.isDataHeaderWritten) {
            String string = "</trkseg></trk>\r\n";
            this.writeTxt(string);
            this.isDataHeaderWritten = false;
        }
    }

    protected final void writeTrkSegSplit() {
        if (!this.isWayType && this.isDataHeaderWritten) {
            String string = "</trkseg><trkseg>";
            this.writeTxt(string);
        }
    }

    @Override
    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        boolean bl = this.ptFilters[this.currentFilter].doFilter(gPSRecord);
        boolean bl2 = this.needsToSplitTrack;
        if (!bl && !this.isWayType) {
            if (this.isTrkSegSplitOnlyWhenSmall) {
                this.isNeedTrackSegment = true;
            } else {
                bl2 |= !this.ignoreBadPoints;
            }
        }
        if (!this.isNewTrack && !this.firstRecord && bl2) {
            this.writeDataFooter();
            this.writeDataHeader();
        }
        if (bl) {
            CharSequence charSequence;
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (gPSRecord.hasValid() && this.selectedFileFields.hasValid()) {
                switch (gPSRecord.getValid()) {
                    case 1: {
                        string2 = string2 + "none";
                        break;
                    }
                    case 2: {
                        string2 = string2 + "3d";
                        break;
                    }
                    case 4: {
                        string2 = string2 + "dgps";
                        break;
                    }
                    case 8: {
                        string2 = string2 + "pps";
                    }
                }
            }
            if (gPSRecord.hasRcr() && this.selectedFileFields.hasRcr()) {
                this.rec.append("<type>");
                string3 = CommonOut.getRCRtype(gPSRecord);
                this.rec.append("</type>\r\n");
            }
            if (gPSRecord.hasHdop() && this.selectedFileFields.hasHdop()) {
                string4 = JavaLibBridge.toString((float)gPSRecord.getHdop() / 100.0f, 2);
            }
            if (gPSRecord.hasNsat() && this.selectedFileFields.hasNsat()) {
                string5 = string5 + gPSRecord.getNsat() / 256;
            }
            this.rec.setLength(0);
            if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                string = string + this.t.getYear() + "-" + (this.t.getMonth() < 10 ? "0" : "") + this.t.getMonth() + "-" + (this.t.getDay() < 10 ? "0" : "") + this.t.getDay() + "T" + (this.t.getHour() < 10 ? "0" : "") + this.t.getHour() + ":" + (this.t.getMinute() < 10 ? "0" : "") + this.t.getMinute() + ":" + (this.t.getSecond() < 10 ? "0" : "") + this.t.getSecond();
                if (gPSRecord.hasMillisecond() && this.selectedFileFields.hasMillisecond()) {
                    string = string + ".";
                    string = string + (gPSRecord.milisecond < 100 ? "0" : "");
                    string = string + (gPSRecord.milisecond < 10 ? "0" : "");
                    string = string + gPSRecord.milisecond;
                }
                string = string + "Z";
            }
            if (this.isNewTrack) {
                charSequence = new StringBuffer();
                if (gPSRecord.hasRecCount()) {
                    String string6 = "" + gPSRecord.getRecCount();
                    int n = 5 - string6.length();
                    if (n < 0) {
                        n = 0;
                    }
                    charSequence.append(zeros, 0, n);
                    this.trackName = "#" + charSequence.toString() + string6 + "#";
                }
                if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                    this.trackName = this.trackName + " " + string;
                }
                this.writeActualDataHeader();
            } else if (this.isNeedTrackSegment) {
                this.writeTrkSegSplit();
            }
            if (this.isWayType) {
                this.rec.append("<wpt ");
            } else {
                this.rec.append("<trkpt ");
            }
            if (gPSRecord.hasLatitude() && this.selectedFileFields.hasLatitude()) {
                this.rec.append("lat=\"");
                this.rec.append(JavaLibBridge.toString(gPSRecord.getLatitude(), this.posDigits));
                this.rec.append("\" ");
            }
            if (gPSRecord.hasLongitude() && this.selectedFileFields.hasLongitude()) {
                this.rec.append("lon=\"");
                this.rec.append(JavaLibBridge.toString(gPSRecord.getLongitude(), this.posDigits));
                this.rec.append("\"");
            }
            this.rec.append(" >\r\n");
            if (gPSRecord.hasHeight() && this.selectedFileFields.hasHeight()) {
                this.rec.append("<ele>");
                this.rec.append(JavaLibBridge.toString(gPSRecord.getHeight(), this.heightDigits));
                this.rec.append("</ele>\r\n");
            }
            if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                this.rec.append("<time>");
                this.rec.append(string);
                this.rec.append("</time>\r\n");
            }
            if (this.isGPX1_0 && !this.isWayType && gPSRecord.hasHeading() && this.selectedFileFields.hasHeading()) {
                this.rec.append("<course>");
                this.rec.append(JavaLibBridge.toString(gPSRecord.getHeading(), 5));
                this.rec.append("</course>\r\n");
            }
            if (this.isGPX1_0 && !this.isWayType && gPSRecord.hasSpeed() && this.selectedFileFields.hasSpeed()) {
                this.rec.append("<speed>");
                this.rec.append(JavaLibBridge.toString(gPSRecord.getSpeed() / 3.6f, 4));
                this.rec.append("</speed>\r\n");
            }
            if (this.selectedFileFields.hasGeoid() || this.selectedFileFields.hasHeight()) {
                this.rec.append("<geoidheight>");
                float f = gPSRecord.hasGeoid() ? gPSRecord.getGeoid() : (float)((long)(10.0 * ExternalUtils.wgs84Separation(gPSRecord.getLatitude(), gPSRecord.getLongitude()))) / 10.0f;
                this.rec.append(JavaLibBridge.toString(f, this.heightDigits));
                this.rec.append("</geoidheight>");
            }
            if (this.isWayType || this.isIncludeTrkName) {
                this.rec.append("<name>");
                if (this.isWayType) {
                    this.rec.append("wpt-");
                } else {
                    this.rec.append("trkpt-");
                }
                if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                    this.rec.append(string);
                    if (this.isNewTrack) {
                        this.trackName = this.trackName + " " + string;
                    }
                } else {
                    this.rec.append(gPSRecord.recCount);
                }
                this.rec.append("</name>\r\n");
            }
            if (this.isHasComment && (!this.isWayType && this.isTrkComment || this.isWayType && this.isWayComment) && (this.recordNbrInLogs || string2.length() != 0 || string3.length() != 0 || string4.length() != 0 || string5.length() != 0)) {
                this.rec.append("<cmt>");
                this.rec.append("<![CDATA[");
                CommonOut.getHtml(this.rec, gPSRecord, this.selectedFileFields, this.t, this.recordNbrInLogs, this.imperial);
                this.rec.append("]]>");
                this.rec.append("</cmt>\r\n");
            }
            if (this.addLinkData && gPSRecord.hasVoxStr()) {
                if (this.isGPX1_0) {
                    this.rec.append("<url>");
                    this.rec.append(CommonOut.getLink(gPSRecord, false));
                    this.rec.append("</url><urlname>");
                    this.rec.append(gPSRecord.getVoxStr());
                    this.rec.append("</urlname>\r\n");
                } else {
                    this.rec.append("<link href=\"");
                    this.rec.append(CommonOut.getLink(gPSRecord, false));
                    this.rec.append("\"><text>");
                    this.rec.append(gPSRecord.getVoxStr());
                    this.rec.append("</text></link>\r\n");
                }
            }
            if (gPSRecord.hasRcr() && this.selectedFileFields.hasRcr()) {
                if (this.isHasSymbol) {
                    this.rec.append("<sym>");
                    this.rec.append(CommonOut.getRcrSymbolText(gPSRecord));
                    this.rec.append("</sym>\r\n");
                }
                this.rec.append("<type>");
                this.rec.append(string3);
                this.rec.append("</type>\r\n");
            }
            if (string2.length() != 0) {
                this.rec.append("<fix>");
                this.rec.append(string2);
                this.rec.append("</fix>\r\n");
            }
            if (gPSRecord.hasNsat() && this.selectedFileFields.hasNsat()) {
                this.rec.append("<sat>");
                this.rec.append(string5);
                this.rec.append("</sat>\r\n");
            }
            if (gPSRecord.hasHdop() && this.selectedFileFields.hasHdop()) {
                this.rec.append("<hdop>");
                this.rec.append(string4);
                this.rec.append("</hdop>\r\n");
            }
            if (gPSRecord.hasVdop() && this.selectedFileFields.hasVdop()) {
                this.rec.append("<vdop>");
                this.rec.append(JavaLibBridge.toString((float)gPSRecord.getVdop() / 100.0f, 2));
                this.rec.append("</vdop>\r\n");
            }
            if (gPSRecord.hasPdop() && this.selectedFileFields.hasPdop()) {
                this.rec.append("<pdop>");
                this.rec.append(JavaLibBridge.toString((float)gPSRecord.getPdop() / 100.0f, 2));
                this.rec.append("</pdop>\r\n");
            }
            if (gPSRecord.hasDage() && this.selectedFileFields.hasDage()) {
                this.rec.append("<ageofdgpsdata>");
                this.rec.append(gPSRecord.getDage());
                this.rec.append("</ageofdgpsdata>\r\n");
            }
            if (gPSRecord.hasDsta() && this.selectedFileFields.hasDsta()) {
                this.rec.append("<dgpsid>");
                this.rec.append(gPSRecord.getDsta());
                this.rec.append("</dgpsid>\r\n");
            }
            if (this.isWayType) {
                this.rec.append("</wpt>\r\n");
            } else {
                this.rec.append("</trkpt>\r\n");
            }
            charSequence = this.rec.toString();
            if (((String)charSequence).length() > 21) {
                this.writeTxt((String)charSequence);
            }
            this.rec.setLength(0);
            this.isNewTrack = false;
            this.isNeedTrackSegment = false;
        }
    }

    @Override
    public void finaliseFile() {
        if (this.isOpen()) {
            this.writeDataFooter();
            String string = "</gpx>";
            this.writeTxt(string);
        }
        super.finaliseFile();
    }
}

