/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.browser;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.ui.ActionBars;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardViewCompositeControl;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.utils.CommonUtils;

public class DashboardBrowserComposite
extends Composite
implements DashboardViewCompositeControl {
    private final DashboardContainer viewContainer;
    private final DashboardItemContainer dashboardContainer;
    private Browser browser;

    public DashboardBrowserComposite(DashboardItemContainer dashboardContainer, DashboardContainer viewContainer, Composite parent, int style, Point preferredSize) {
        super(parent, style);
        DashboardBrowserComposite.initializeGlobalBrowser(viewContainer);
        this.dashboardContainer = dashboardContainer;
        this.viewContainer = viewContainer;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.browser = new Browser((Composite)this, 0);
        this.browser.setLayoutData((Object)new GridData(1808));
        DashboardItemConfiguration itemConfig = dashboardContainer.getItemDescriptor();
        String dashboardURL = itemConfig.getDashboardURL();
        if (!CommonUtils.isEmpty((String)dashboardURL)) {
            this.browser.setUrl(itemConfig.evaluateURL(dashboardURL, dashboardContainer.getProject(), dashboardContainer.getDataSourceContainer()));
        }
    }

    private void closeBrowser() {
    }

    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public Control getDashboardControl() {
        return this.browser;
    }

    private static void initializeGlobalBrowser(DashboardContainer viewContainer) {
        IStatusLineManager statusLineManager;
        IActionBars actionBars = ActionBars.extractActionBars((IWorkbenchSite)viewContainer.getWorkbenchSite());
        if (actionBars != null && (statusLineManager = actionBars.getStatusLineManager()) != null) {
            BrowserContributionItem item;
            if (statusLineManager instanceof SubStatusLineManager) {
                SubStatusLineManager sslm = (SubStatusLineManager)statusLineManager;
                statusLineManager = (IStatusLineManager)sslm.getParent();
            }
            IContributionItem[] iContributionItemArray = statusLineManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                item = iContributionItemArray[n2];
                if (item instanceof BrowserContributionItem) {
                    BrowserContributionItem bci = item;
                    return;
                }
                ++n2;
            }
            item = new BrowserContributionItem();
            statusLineManager.add((IContributionItem)item);
        }
    }

    private static class BrowserContributionItem
    extends ContributionItem {
        private Composite globalComposite;

        private BrowserContributionItem() {
        }

        public void fill(Composite parent) {
            this.globalComposite = new Browser(parent, 0);
            this.globalComposite.setLayout((Layout)new RowLayout());
            StatusLineLayoutData ld = new StatusLineLayoutData();
            ld.widthHint = 0;
            ld.heightHint = 0;
            this.globalComposite.setLayoutData((Object)ld);
        }
    }
}

