/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.util.test.FreeColTestCase;

public class GoodsContainerTest
extends FreeColTestCase {
    GoodsType sugar = GoodsContainerTest.spec().getGoodsType("model.goods.sugar");
    GoodsType food = GoodsContainerTest.spec().getPrimaryFoodType();
    GoodsType fish = GoodsContainerTest.spec().getGoodsType("model.goods.fish");
    GoodsType lumber = GoodsContainerTest.spec().getGoodsType("model.goods.lumber");

    public void testContainer() {
        int difference;
        Game game = GoodsContainerTest.getGame();
        game.changeMap(GoodsContainerTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        GoodsContainer container = new GoodsContainer(game, colony);
        GoodsContainerTest.assertEquals((int)0, (int)container.getGoodsCount(this.sugar));
        GoodsContainerTest.assertEquals((int)0, (int)container.getGoodsCount(this.food));
        GoodsContainerTest.assertEquals((int)0, (int)container.getGoodsCount(this.fish));
        GoodsContainerTest.assertEquals((int)0, (int)container.getGoodsCount(this.lumber));
        container.addGoods(this.sugar, 36);
        GoodsContainerTest.assertEquals((int)36, (int)container.getGoodsCount(this.sugar));
        container.addGoods(this.lumber, 37);
        GoodsContainerTest.assertEquals((int)37, (int)container.getGoodsCount(this.lumber));
        container.addGoods(this.food, 38);
        GoodsContainerTest.assertEquals((int)38, (int)container.getGoodsCount(this.food));
        container.addGoods(this.fish, 39);
        GoodsContainerTest.assertEquals((int)39, (int)container.getGoodsCount(this.fish));
        int totalDifference = difference = 20;
        container.addGoods(this.sugar, difference);
        GoodsContainerTest.assertEquals((int)(36 + totalDifference), (int)container.getGoodsCount(this.sugar));
        container.addGoods(this.lumber, difference);
        GoodsContainerTest.assertEquals((int)(37 + totalDifference), (int)container.getGoodsCount(this.lumber));
        container.addGoods(this.food, difference);
        GoodsContainerTest.assertEquals((int)(38 + totalDifference), (int)container.getGoodsCount(this.food));
        container.addGoods(this.fish, difference);
        GoodsContainerTest.assertEquals((int)(39 + totalDifference), (int)container.getGoodsCount(this.fish));
        difference = 10;
        container.removeGoods(this.sugar, difference);
        GoodsContainerTest.assertEquals((int)(36 + (totalDifference -= difference)), (int)container.getGoodsCount(this.sugar));
        container.removeGoods(this.lumber, difference);
        GoodsContainerTest.assertEquals((int)(37 + totalDifference), (int)container.getGoodsCount(this.lumber));
        container.removeGoods(this.food, difference);
        GoodsContainerTest.assertEquals((int)(38 + totalDifference), (int)container.getGoodsCount(this.food));
        container.removeGoods(this.fish, difference);
        GoodsContainerTest.assertEquals((int)(39 + totalDifference), (int)container.getGoodsCount(this.fish));
        difference = -20;
        container.addGoods(this.sugar, difference);
        GoodsContainerTest.assertEquals((int)(36 + (totalDifference += difference)), (int)container.getGoodsCount(this.sugar));
        container.addGoods(this.lumber, difference);
        GoodsContainerTest.assertEquals((int)(37 + totalDifference), (int)container.getGoodsCount(this.lumber));
        container.addGoods(this.food, difference);
        GoodsContainerTest.assertEquals((int)(38 + totalDifference), (int)container.getGoodsCount(this.food));
        container.addGoods(this.fish, difference);
        GoodsContainerTest.assertEquals((int)(39 + totalDifference), (int)container.getGoodsCount(this.fish));
        container.removeAbove(10);
        GoodsContainerTest.assertEquals((int)10, (int)container.getGoodsCount(this.sugar));
        GoodsContainerTest.assertEquals((int)10, (int)container.getGoodsCount(this.lumber));
        GoodsContainerTest.assertEquals((int)(38 + totalDifference), (int)container.getGoodsCount(this.food));
        GoodsContainerTest.assertEquals((int)(39 + totalDifference), (int)container.getGoodsCount(this.fish));
        difference = 20;
        totalDifference -= difference;
        container.removeGoods(this.sugar, difference);
        GoodsContainerTest.assertEquals((int)0, (int)container.getGoodsCount(this.sugar));
        container.removeGoods(this.lumber, difference);
        GoodsContainerTest.assertEquals((int)0, (int)container.getGoodsCount(this.lumber));
        container.removeGoods(this.food, difference);
        GoodsContainerTest.assertEquals((int)(38 + totalDifference), (int)container.getGoodsCount(this.food));
        container.removeGoods(this.fish, difference);
        GoodsContainerTest.assertEquals((int)(39 + totalDifference), (int)container.getGoodsCount(this.fish));
    }
}

