/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scripts;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.classpath.transforms.ClasspathElementTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactoryForLegacy;
import org.gradle.internal.classpath.transforms.InstrumentingClassTransform;
import org.gradle.internal.classpath.types.GradleCoreInstrumentationTypeRegistry;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.internal.execution.ImmutableUnitOfWork;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.gradle.internal.instrumentation.reporting.PropertyUpgradeReportConfig;
import org.gradle.internal.instrumentation.reporting.listener.BytecodeUpgradeReportMethodInterceptionListener;
import org.gradle.internal.instrumentation.reporting.listener.MethodInterceptionListener;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.jspecify.annotations.Nullable;

public abstract class BuildScriptCompilationAndInstrumentation
implements ImmutableUnitOfWork {
    private static final CachingDisabledReason CACHING_DISABLED_FOR_PROPERTY_REPORT = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching of buildscript compilation disabled due for property upgrade report");
    private final ScriptSource source;
    private final ImmutableWorkspaceProvider workspaceProvider;
    private final InputFingerprinter inputFingerprinter;
    private final ClasspathElementTransformFactoryForLegacy transformFactory;
    protected final FileCollectionFactory fileCollectionFactory;
    private final GradleCoreInstrumentationTypeRegistry gradleCoreTypeRegistry;
    private final PropertyUpgradeReportConfig propertyUpgradeReportConfig;

    public BuildScriptCompilationAndInstrumentation(ScriptSource source, ImmutableWorkspaceProvider workspaceProvider, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, ClasspathElementTransformFactoryForLegacy transformFactory, GradleCoreInstrumentationTypeRegistry gradleCoreTypeRegistry, PropertyUpgradeReportConfig propertyUpgradeReportConfig) {
        this.source = source;
        this.workspaceProvider = workspaceProvider;
        this.fileCollectionFactory = fileCollectionFactory;
        this.inputFingerprinter = inputFingerprinter;
        this.transformFactory = transformFactory;
        this.gradleCoreTypeRegistry = gradleCoreTypeRegistry;
        this.propertyUpgradeReportConfig = propertyUpgradeReportConfig;
    }

    public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
        return this.propertyUpgradeReportConfig.isEnabled() ? Optional.of(CACHING_DISABLED_FOR_PROPERTY_REPORT) : Optional.empty();
    }

    @OverridingMethodsMustInvokeSuper
    public void visitIdentityInputs(UnitOfWork.InputVisitor visitor) {
        visitor.visitInputProperty("isProviderUpgradeReportEnabled", () -> ((PropertyUpgradeReportConfig)this.propertyUpgradeReportConfig).isEnabled());
    }

    protected abstract File compile(File var1);

    protected abstract File instrumentedOutput(File var1);

    protected File propertyUpgradeReport(File workspace) {
        return new File(workspace, "reports/gradle-intercepted-methods.report");
    }

    public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
        Hasher hasher = Hashing.newHasher();
        identityInputs.values().forEach(value -> Objects.requireNonNull(value).appendToHasher(hasher));
        String identity = hasher.hash().toString();
        return () -> identity;
    }

    @OverridingMethodsMustInvokeSuper
    public void visitOutputs(File workspace, UnitOfWork.OutputVisitor visitor) {
        File instrumentedOutput = this.instrumentedOutput(workspace);
        UnitOfWork.OutputFileValueSupplier instrumentedOutputValue = UnitOfWork.OutputFileValueSupplier.fromStatic((File)instrumentedOutput, (FileCollection)this.fileCollectionFactory.fixed(new File[]{instrumentedOutput}));
        visitor.visitOutputProperty("instrumentedOutput", TreeType.DIRECTORY, instrumentedOutputValue);
        File propertyUpgradeReport = this.propertyUpgradeReport(workspace);
        UnitOfWork.OutputFileValueSupplier propertyUpgradeReportOutputValue = UnitOfWork.OutputFileValueSupplier.fromStatic((File)propertyUpgradeReport, (FileCollection)this.fileCollectionFactory.fixed(new File[]{propertyUpgradeReport}));
        visitor.visitOutputProperty("propertyUpgradeReportOutput", TreeType.FILE, propertyUpgradeReportOutputValue);
    }

    public UnitOfWork.WorkOutput execute(UnitOfWork.ExecutionRequest executionRequest) {
        File workspace = executionRequest.getWorkspace();
        File compileOutput = this.compile(workspace);
        this.instrument(compileOutput, this.instrumentedOutput(workspace), this.propertyUpgradeReport(workspace));
        return new UnitOfWork.WorkOutput(){

            public UnitOfWork.WorkResult getDidWork() {
                return UnitOfWork.WorkResult.DID_WORK;
            }

            public @Nullable Object getOutput(File workspace) {
                return BuildScriptCompilationAndInstrumentation.this.loadAlreadyProducedOutput(workspace);
            }
        };
    }

    private void instrument(File sourceDir, File destination, File propertyUpgradeReport) {
        if (this.propertyUpgradeReportConfig.isEnabled()) {
            File source = this.source.getResource().getFile();
            try (BytecodeUpgradeReportMethodInterceptionListener methodInterceptionListener = new BytecodeUpgradeReportMethodInterceptionListener(source, propertyUpgradeReport);){
                InstrumentingClassTransform classTransform = new InstrumentingClassTransform(BytecodeInterceptorFilter.INSTRUMENTATION_AND_BYTECODE_REPORT, this.gradleCoreTypeRegistry, (MethodInterceptionListener)methodInterceptionListener);
                ClasspathElementTransform transform = this.transformFactory.createTransformer(sourceDir, classTransform);
                transform.transform(destination);
            }
        } else {
            InstrumentingClassTransform classTransform = new InstrumentingClassTransform(BytecodeInterceptorFilter.INSTRUMENTATION_ONLY, InstrumentationTypeRegistry.EMPTY);
            ClasspathElementTransform transform = this.transformFactory.createTransformer(sourceDir, classTransform);
            transform.transform(destination);
        }
    }

    public @Nullable Object loadAlreadyProducedOutput(File workspace) {
        return new Output(this.instrumentedOutput(workspace), this.propertyUpgradeReport(workspace));
    }

    public InputFingerprinter getInputFingerprinter() {
        return this.inputFingerprinter;
    }

    public ImmutableWorkspaceProvider getWorkspaceProvider() {
        return this.workspaceProvider;
    }

    public abstract String getDisplayName();

    public static class Output {
        private final File instrumentedOutput;
        private final File propertyUpgradeReport;

        public Output(File instrumentedOutput, File propertyUpgradeReport) {
            this.instrumentedOutput = instrumentedOutput;
            this.propertyUpgradeReport = propertyUpgradeReport;
        }

        public File getInstrumentedOutput() {
            return this.instrumentedOutput;
        }

        public File getPropertyUpgradeReport() {
            return this.propertyUpgradeReport;
        }
    }
}

