/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.OkCancelDialog;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.OrchestraInstrument;
import org.jsampler.task.Global;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;
import org.linuxsampler.lscp.Instrument;
import org.linuxsampler.lscp.Parser;

public class JSAddOrEditInstrumentDlg
extends OkCancelDialog {
    private final JLabel lName = new JLabel(StdI18n.i18n.getLabel("JSAddOrEditInstrumentDlg.lName"));
    private final JLabel lDesc = new JLabel(StdI18n.i18n.getLabel("JSAddOrEditInstrumentDlg.lDesc"));
    private final JLabel lPath = new JLabel(StdI18n.i18n.getLabel("JSAddOrEditInstrumentDlg.lPath"));
    private final JLabel lIndex = new JLabel(StdI18n.i18n.getLabel("JSAddOrEditInstrumentDlg.lIndex"));
    private final JButton btnBrowse = new JButton(StdI18n.i18n.getButtonLabel("browse"));
    private final JTextField tfName = new JTextField();
    private final JTextField tfDesc = new JTextField();
    private final JComboBox cbPath = new JComboBox();
    private final JComboBox cbIndex = new JComboBox();
    private OrchestraInstrument instrument;
    private boolean init = true;
    private final Handler eventHandler = new Handler();

    public JSAddOrEditInstrumentDlg() {
        this(new OrchestraInstrument());
    }

    public JSAddOrEditInstrumentDlg(OrchestraInstrument orchestraInstrument) {
        super((Frame)CC.getMainFrame(), StdI18n.i18n.getLabel("JSAddOrEditInstrumentDlg.title"));
        int n;
        this.instrument = orchestraInstrument;
        this.cbPath.setEditable(true);
        String[] stringArray = this.preferences().getStringListProperty("recentInstrumentFiles");
        for (String string : stringArray) {
            this.cbPath.addItem(string);
        }
        this.cbPath.setSelectedItem(null);
        this.cbPath.setPreferredSize(new Dimension(200, this.cbPath.getPreferredSize().height));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lName, gridBagConstraints);
        jPanel.add(this.lName);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lDesc, gridBagConstraints);
        jPanel.add(this.lDesc);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lPath, gridBagConstraints);
        jPanel.add(this.lPath);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.btnBrowse, gridBagConstraints);
        jPanel.add(this.btnBrowse);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lIndex, gridBagConstraints);
        jPanel.add(this.lIndex);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tfName, gridBagConstraints);
        jPanel.add(this.tfName);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.tfDesc, gridBagConstraints);
        jPanel.add(this.tfDesc);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.cbPath, gridBagConstraints);
        jPanel.add(this.cbPath);
        for (n = 0; n < 101; ++n) {
            this.cbIndex.addItem(n);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.cbIndex, gridBagConstraints);
        jPanel.add(this.cbIndex);
        this.setMainPane(jPanel);
        n = this.getPreferredSize().width;
        Dimension dimension = new Dimension(n > 500 ? n : 500, this.getPreferredSize().height);
        this.setPreferredSize(dimension);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.tfName.getDocument().addDocumentListener(this.getHandler());
        this.btnBrowse.addActionListener(this.getHandler());
        this.cbPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSAddOrEditInstrumentDlg.this.updateState();
                JSAddOrEditInstrumentDlg.this.updateFileInstruments();
            }
        });
        this.cbIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = JSAddOrEditInstrumentDlg.this.cbIndex.getSelectedItem();
                if (object == null) {
                    return;
                }
                if (object.toString().length() > 5) {
                    JSAddOrEditInstrumentDlg.this.tfName.setText(object.toString());
                }
            }
        });
        this.updateInfo();
        this.updateState();
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    private void updateInfo() {
        this.tfName.setText(this.getInstrument().getName());
        this.tfDesc.setText(this.getInstrument().getDescription());
        this.cbPath.setSelectedItem(this.getInstrument().getFilePath());
        this.cbIndex.setSelectedIndex(this.getInstrument().getInstrumentIndex());
    }

    private void updateState() {
        Object object;
        boolean bl = true;
        if (this.tfName.getText().length() == 0) {
            bl = false;
        }
        if ((object = this.cbPath.getSelectedItem()) == null || object.toString().length() == 0) {
            bl = false;
        }
        if ((object = this.cbIndex.getSelectedItem()) == null || object.toString().length() == 0) {
            bl = false;
        }
        this.btnOk.setEnabled(bl);
    }

    private void updateFileInstruments() {
        Object object = this.cbPath.getSelectedItem();
        if (object == null) {
            return;
        }
        String string = object.toString();
        final Global.GetFileInstruments getFileInstruments = new Global.GetFileInstruments(string);
        getFileInstruments.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                int n;
                Instrument[] instrumentArray = (Instrument[])getFileInstruments.getResult();
                if (instrumentArray == null) {
                    JSAddOrEditInstrumentDlg.this.cbIndex.removeAllItems();
                    for (int i = 0; i < 101; ++i) {
                        JSAddOrEditInstrumentDlg.this.cbIndex.addItem(i);
                    }
                    return;
                }
                JSAddOrEditInstrumentDlg.this.cbIndex.removeAllItems();
                for (n = 0; n < instrumentArray.length; ++n) {
                    JSAddOrEditInstrumentDlg.this.cbIndex.addItem(n + " - " + instrumentArray[n].getName());
                }
                if (JSAddOrEditInstrumentDlg.this.init) {
                    n = JSAddOrEditInstrumentDlg.this.getInstrument().getInstrumentIndex();
                    JSAddOrEditInstrumentDlg.this.cbIndex.setSelectedIndex(n);
                    JSAddOrEditInstrumentDlg.this.init = false;
                }
            }
        });
        CC.getTaskQueue().add(getFileInstruments);
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        this.instrument.setName(this.tfName.getText());
        this.instrument.setDescription(this.tfDesc.getText());
        this.instrument.setFilePath(this.cbPath.getSelectedItem().toString());
        int n = this.cbIndex.getSelectedIndex();
        this.instrument.setInstrumentIndex(n);
        StdUtils.updateRecentElements("recentInstrumentFiles", this.instrument.getFilePath());
        this.setVisible(false);
        this.setCancelled(false);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    public OrchestraInstrument getInstrument() {
        return this.instrument;
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements DocumentListener,
    ActionListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSAddOrEditInstrumentDlg.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSAddOrEditInstrumentDlg.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSAddOrEditInstrumentDlg.this.updateState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = StdUtils.showOpenInstrumentFileChooser(JSAddOrEditInstrumentDlg.this);
            if (file == null) {
                return;
            }
            String string = file.getAbsolutePath();
            if (File.separatorChar == '\\') {
                string = string.replace('\\', '/');
            }
            string = Parser.toEscapedString(string);
            JSAddOrEditInstrumentDlg.this.cbPath.setSelectedItem(string);
        }
    }
}

