/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.CacheableSqmInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class SimpleNonSelectQueryPlan
implements NonSelectQueryPlan {
    private final SqmDmlStatement<?> statement;
    private final DomainParameterXref domainParameterXref;
    private volatile CacheableSqmInterpretation<MutationStatement, JdbcOperationQueryMutation> interpretation;

    public SimpleNonSelectQueryPlan(SqmDmlStatement<?> statement, DomainParameterXref domainParameterXref) {
        this.statement = statement;
        this.domainParameterXref = domainParameterXref;
    }

    protected SqmDmlStatement<?> getStatement() {
        return this.statement;
    }

    @Override
    public int executeUpdate(DomainQueryExecutionContext context) {
        BulkOperationCleanupAction.schedule(context.getSession(), this.statement);
        Interpretation interpretation = this.getInterpretation(context);
        SqmJdbcExecutionContextAdapter executionContext = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(context);
        return this.execute(interpretation.interpretation, interpretation.jdbcParameterBindings, executionContext);
    }

    protected int execute(CacheableSqmInterpretation<MutationStatement, JdbcOperationQueryMutation> sqmInterpretation, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        return session.getFactory().getJdbcServices().getJdbcMutationExecutor().execute(sqmInterpretation.jdbcOperation(), jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    private JdbcParameterBindings createJdbcParameterBindings(final CacheableSqmInterpretation<MutationStatement, JdbcOperationQueryMutation> sqmInterpretation, DomainQueryExecutionContext executionContext) {
        return SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, sqmInterpretation.jdbcParamsXref(), new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return sqmInterpretation.sqmParameterMappingModelTypes().get(parameter);
            }
        }, executionContext.getSession());
    }

    protected SqmTranslation<? extends MutationStatement> buildTranslation(SqmDmlStatement<?> sqm, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        return sessionFactory.getQueryEngine().getSqmTranslatorFactory().createMutationTranslator(sqm, executionContext.getQueryOptions(), domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), sessionFactory.getSqlTranslationEngine()).translate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Interpretation getInterpretation(DomainQueryExecutionContext context) {
        Interpretation builtInterpretation = null;
        CacheableSqmInterpretation<MutationStatement, JdbcOperationQueryMutation> localCopy = this.interpretation;
        if (localCopy == null) {
            SimpleNonSelectQueryPlan simpleNonSelectQueryPlan = this;
            synchronized (simpleNonSelectQueryPlan) {
                localCopy = this.interpretation;
                if (localCopy == null) {
                    builtInterpretation = this.buildInterpretation(this.statement, this.domainParameterXref, context);
                    localCopy = builtInterpretation.interpretation;
                    this.interpretation = builtInterpretation.interpretation;
                } else {
                    builtInterpretation = this.updateInterpretation(localCopy, context);
                }
            }
        } else {
            builtInterpretation = this.updateInterpretation(localCopy, context);
        }
        return builtInterpretation != null ? builtInterpretation : new Interpretation(localCopy, this.createJdbcParameterBindings(localCopy, context));
    }

    private @Nullable Interpretation updateInterpretation(CacheableSqmInterpretation<MutationStatement, JdbcOperationQueryMutation> localCopy, DomainQueryExecutionContext context) {
        Interpretation builtInterpretation = null;
        if (localCopy.jdbcOperation().dependsOnParameterBindings()) {
            JdbcParameterBindings jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, context);
            if (!localCopy.jdbcOperation().isCompatibleWith(jdbcParameterBindings, context.getQueryOptions())) {
                builtInterpretation = this.buildInterpretation(localCopy.statement(), localCopy.jdbcParamsXref(), localCopy.sqmParameterMappingModelTypes(), jdbcParameterBindings, context);
                this.interpretation = builtInterpretation.interpretation;
            } else {
                builtInterpretation = new Interpretation(localCopy, jdbcParameterBindings);
            }
        }
        return builtInterpretation;
    }

    protected Interpretation buildInterpretation(SqmDmlStatement<?> sqm, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        SqmTranslation<? extends MutationStatement> sqmInterpretation = this.buildTranslation(sqm, domainParameterXref, executionContext);
        Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
        final Map<SqmParameter<?>, MappingModelExpressible<?>> parameterModelTypeResolutions = sqmInterpretation.getSqmParameterMappingModelTypeResolutions();
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)parameterModelTypeResolutions.get(parameter);
            }
        }, session);
        return this.buildInterpretation(sqmInterpretation.getSqlAst(), jdbcParamsXref, parameterModelTypeResolutions, jdbcParameterBindings, executionContext);
    }

    protected Interpretation buildInterpretation(MutationStatement mutationStatement, Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref, Map<SqmParameter<?>, MappingModelExpressible<?>> parameterModelTypeResolutions, JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        SqlAstTranslator<? extends JdbcOperationQueryMutation> mutationTranslator = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(sessionFactory, mutationStatement);
        return new Interpretation(new CacheableSqmInterpretation<MutationStatement, JdbcOperationQueryMutation>(mutationStatement, mutationTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions()), jdbcParamsXref, parameterModelTypeResolutions), jdbcParameterBindings);
    }

    protected record Interpretation(CacheableSqmInterpretation<MutationStatement, JdbcOperationQueryMutation> interpretation, JdbcParameterBindings jdbcParameterBindings) {
    }
}

