/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.IndexMark;
import writer2latex.office.OfficeReader;
import writer2latex.util.Misc;
import writer2latex.util.StringComparator;
import writer2latex.xhtml.AlphabeticalEntry;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.IndexConverterHelper;
import writer2latex.xhtml.IndexData;
import writer2latex.xhtml.XhtmlConfig;

class AlphabeticalIndexConverter
extends IndexConverterHelper {
    private List<AlphabeticalEntry> index = new ArrayList<AlphabeticalEntry>();
    private int nIndexIndex = -1;
    private int nAlphabeticalIndex = -1;

    AlphabeticalIndexConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter, "text:alphabetical-index-source");
    }

    int getFileIndex() {
        return this.nAlphabeticalIndex;
    }

    void handleIndexMark(Node onode, Node hnode) {
        this.handleIndexMark(Misc.getAttribute(onode, "text:string-value"), onode, hnode);
    }

    void handleIndexMarkStart(Node onode, Node hnode) {
        this.handleIndexMark(IndexMark.getIndexValue(onode), onode, hnode);
    }

    void handleIndexMark(String sWord, Node onode, Node hnode) {
        if (sWord != null) {
            String sKey2;
            AlphabeticalEntry entry = new AlphabeticalEntry();
            int i = 0;
            String sKey1 = Misc.getAttribute(onode, "text:key1");
            if (sKey1 != null) {
                int n = i;
                i = (short)(i + 1);
                entry.sWord[n] = sKey1;
            }
            if ((sKey2 = Misc.getAttribute(onode, "text:key2")) != null) {
                int n = i;
                i = (short)(i + 1);
                entry.sWord[n] = sKey2;
            }
            entry.sWord[i] = sWord;
            entry.nIndex = ++this.nIndexIndex;
            this.index.add(entry);
            hnode.appendChild(this.converter.createTarget("idx" + this.nIndexIndex));
        }
    }

    @Override
    void handleIndex(Element onode, Element hnode, int nChapterNumber) {
        this.nAlphabeticalIndex = this.converter.getOutFileIndex();
        super.handleIndex(onode, hnode, nChapterNumber);
    }

    @Override
    void generate(IndexData data) {
        Element source = data.onode;
        Element container = data.hnode;
        this.sortEntries(source);
        String[] sEntryStyleName = this.getEntryStyleName(source);
        String[] sLastKey = new String[2];
        for (int i = 0; i <= this.nIndexIndex; ++i) {
            AlphabeticalEntry entry = this.index.get(i);
            for (int j = 0; j < 3; ++j) {
                if (entry.sWord[j] == null) continue;
                Element li = this.converter.createElement("li");
                container.appendChild(li);
                Element p = this.getTextCv().createParagraph(li, sEntryStyleName[j]);
                if (j < 2 && entry.sWord[j + 1] != null) {
                    if (entry.sWord[j].equals(sLastKey[j])) continue;
                    p.appendChild(this.converter.createTextNode(entry.sWord[j]));
                    continue;
                }
                Element a = this.converter.createLink("idx" + entry.nIndex);
                p.appendChild(a);
                a.appendChild(this.converter.createTextNode(entry.sWord[j]));
            }
            sLastKey[0] = entry.sWord[0];
            sLastKey[1] = entry.sWord[1];
        }
        if (this.config.indexLinks()) {
            Element title = Misc.getChildByTagName(source, "text:index-title-template");
            String sTitle = title != null ? Misc.getPCDATA(title) : "Alphabetical Index";
            this.converter.addContentEntry(sTitle, 1, this.converter.getTarget(Misc.getAttribute(source.getParentNode(), "text:name")));
        }
    }

    private void sortEntries(Element source) {
        StringComparator<AlphabeticalEntry> comparator = new StringComparator<AlphabeticalEntry>(Misc.getAttribute(source, "fo:language"), Misc.getAttribute(source, "fo:country")){

            @Override
            public int compare(AlphabeticalEntry a, AlphabeticalEntry b) {
                int nResult = 0;
                for (int i = 0; i < 3; ++i) {
                    nResult = this.getCollator().compare(a.sWord[i], b.sWord[i]);
                    if (nResult != 0) {
                        return nResult;
                    }
                    if (i >= 2) continue;
                    if (a.sWord[i + 1] == null && b.sWord[i + 1] != null) {
                        return -1;
                    }
                    if (a.sWord[i + 1] != null && b.sWord[i + 1] == null) {
                        return 1;
                    }
                    if (a.sWord[i + 1] != null || b.sWord[i + 1] != null) continue;
                    return nResult;
                }
                return nResult;
            }
        };
        Collections.sort(this.index, comparator);
    }

    private String[] getEntryStyleName(Element source) {
        String[] sStyleName = new String[3];
        for (Node child = source.getFirstChild(); child != null; child = child.getNextSibling()) {
            int nLevel;
            if (child.getNodeType() != 1 || !child.getNodeName().equals("text:alphabetical-index-entry-template") || 1 > (nLevel = Misc.getPosInteger(Misc.getAttribute(child, "text:outline-level"), 0)) || nLevel > 3) continue;
            sStyleName[nLevel - 1] = Misc.getAttribute(child, "text:style-name");
        }
        return sStyleName;
    }
}

