/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ButtonStyle;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideMenu;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JideSplitButton
extends JideMenu
implements ButtonStyle,
ComponentStateSupport {
    private static final String uiClassID = "JideSplitButtonUI";
    private int _buttonStyle = 0;
    private boolean _alwaysDropdown = false;
    public static final String PROPERTY_ALWAYS_DROPDOWN = "alwaysDropdown";
    public static final String ACTION_PROPERTY_SPLIT_BUTTON_ENABLED = "JideSplitButtonEnabled";
    private Color _defaultForeground;
    private Color _rolloverBackground;
    private Color _selectedBackground;
    private Color _pressedBackground;
    private Color _rolloverForeground;
    private Color _selectedForeground;
    private Color _pressedForeground;

    public JideSplitButton() {
        this.initComponent();
    }

    public JideSplitButton(String s2) {
        super(s2);
        this.initComponent();
    }

    public JideSplitButton(String s2, Icon icon) {
        super(s2);
        this.setIcon(icon);
        this.initComponent();
    }

    public JideSplitButton(Icon icon) {
        super("");
        this.setIcon(icon);
        this.initComponent();
    }

    public JideSplitButton(Action a) {
        super(a);
        this.initComponent();
    }

    protected void initComponent() {
        this.setModel(new DefaultSplitButtonModel());
        if (this.getAction() != null) {
            this.configurePropertiesFromAction(this.getAction());
        }
        this.setFocusable(true);
        this.setRequestFocusEnabled(false);
    }

    @Override
    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    @Override
    public void setUI(ButtonUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isButtonSelected() {
        return this.model instanceof SplitButtonModel && ((DefaultSplitButtonModel)this.model).isButtonSelected();
    }

    public void setButtonSelected(boolean b) {
        if (this.model instanceof SplitButtonModel) {
            ((DefaultSplitButtonModel)this.model).setButtonSelected(b);
        }
    }

    public boolean isButtonEnabled() {
        return this.model instanceof SplitButtonModel && ((DefaultSplitButtonModel)this.model).isButtonEnabled();
    }

    public void setButtonEnabled(boolean b) {
        if (this.model instanceof SplitButtonModel) {
            ((DefaultSplitButtonModel)this.model).setButtonEnabled(b);
        }
    }

    @Override
    public int getButtonStyle() {
        return this._buttonStyle;
    }

    @Override
    public void setButtonStyle(int buttonStyle) {
        if (buttonStyle < 0 || buttonStyle > 2) {
            throw new IllegalArgumentException("Only TOOLBAR_STYLE, TOOLBOX_STYLE, and FLAT_STYLE are supported");
        }
        if (buttonStyle == this._buttonStyle) {
            return;
        }
        int oldStyle = this._buttonStyle;
        this._buttonStyle = buttonStyle;
        this.firePropertyChange("buttonStyle", oldStyle, this._buttonStyle);
    }

    public boolean isAlwaysDropdown() {
        return this._alwaysDropdown;
    }

    public void setAlwaysDropdown(boolean alwaysDropdown) {
        if (this._alwaysDropdown != alwaysDropdown) {
            boolean old = this._alwaysDropdown;
            this._alwaysDropdown = alwaysDropdown;
            this.firePropertyChange(PROPERTY_ALWAYS_DROPDOWN, old, alwaysDropdown);
        }
    }

    @Override
    public void setText(String text) {
        Boolean hide = (Boolean)this.getClientProperty("hideActionText");
        if (hide == null || Boolean.FALSE.equals(hide)) {
            super.setText(text);
        }
    }

    public Color getDefaultForeground() {
        return this._defaultForeground;
    }

    public void setDefaultForeground(Color defaultForeground) {
        this._defaultForeground = defaultForeground;
    }

    private Color getRolloverBackground() {
        return this._rolloverBackground;
    }

    private void setRolloverBackground(Color rolloverBackground) {
        this._rolloverBackground = rolloverBackground;
    }

    private Color getSelectedBackground() {
        return this._selectedBackground;
    }

    private void setSelectedBackground(Color selectedBackground) {
        this._selectedBackground = selectedBackground;
    }

    private Color getPressedBackground() {
        return this._pressedBackground;
    }

    private void setPressedBackground(Color pressedBackground) {
        this._pressedBackground = pressedBackground;
    }

    private Color getRolloverForeground() {
        return this._rolloverForeground;
    }

    private void setRolloverForeground(Color rolloverForeground) {
        this._rolloverForeground = rolloverForeground;
    }

    private Color getSelectedForeground() {
        return this._selectedForeground;
    }

    private void setSelectedForeground(Color selectedForeground) {
        this._selectedForeground = selectedForeground;
    }

    private Color getPressedForeground() {
        return this._pressedForeground;
    }

    private void setPressedForeground(Color pressedForeground) {
        this._pressedForeground = pressedForeground;
    }

    @Override
    public Color getBackgroundOfState(int state) {
        switch (state) {
            case 0: {
                return this.getBackground();
            }
            case 2: {
                return this.getRolloverBackground();
            }
            case 3: {
                return this.getSelectedBackground();
            }
            case 1: {
                return this.getPressedBackground();
            }
        }
        return null;
    }

    @Override
    public void setBackgroundOfState(int state, Color color) {
        switch (state) {
            case 0: {
                this.setBackground(color);
                break;
            }
            case 2: {
                this.setRolloverBackground(color);
                break;
            }
            case 3: {
                this.setSelectedBackground(color);
                break;
            }
            case 1: {
                this.setPressedBackground(color);
            }
        }
    }

    @Override
    public Color getForegroundOfState(int state) {
        switch (state) {
            case 0: {
                return this.getDefaultForeground();
            }
            case 2: {
                return this.getRolloverForeground();
            }
            case 3: {
                return this.getSelectedForeground();
            }
            case 1: {
                return this.getPressedForeground();
            }
        }
        return null;
    }

    @Override
    public void setForegroundOfState(int state, Color color) {
        switch (state) {
            case 0: {
                this.setDefaultForeground(color);
                break;
            }
            case 2: {
                this.setRolloverForeground(color);
                break;
            }
            case 3: {
                this.setSelectedForeground(color);
                break;
            }
            case 1: {
                this.setPressedForeground(color);
            }
        }
    }

    @Override
    public void doClick() {
        Action action = this.getActionMap().get("pressed");
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void doClickOnMenu() {
        Action action = this.getActionMap().get("downPressed");
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    @Override
    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        this.setButtonEnabled(JideSplitButton.isSplitButtonEnabled(action));
        this.setIconFromAction(action);
    }

    protected void setIconFromAction(Action action) {
        Icon icon = null;
        if (action != null) {
            Icon icon2 = icon = SystemInfo.isJdk6Above() && !(this.getParent() instanceof JPopupMenu) ? (Icon)action.getValue("SwingLargeIconKey") : null;
            if (icon == null) {
                icon = (Icon)action.getValue("SmallIcon");
            }
        }
        this.setIcon(icon);
    }

    @Override
    protected void actionPropertyChanged(Action action, String propertyName) {
        super.actionPropertyChanged(action, propertyName);
        if (ACTION_PROPERTY_SPLIT_BUTTON_ENABLED.equals(propertyName) || "enabled".equals(propertyName)) {
            this.setButtonEnabled(JideSplitButton.isSplitButtonEnabled(action));
        } else if ("SmallIcon".equals(propertyName)) {
            this.setIconFromAction(action);
        } else if (SystemInfo.isJdk6Above() && "SwingLargeIconKey".equals(propertyName)) {
            this.setIconFromAction(action);
        }
    }

    public static boolean isSplitButtonEnabled(Action action) {
        if (action == null) {
            return true;
        }
        Object value = action.getValue(ACTION_PROPERTY_SPLIT_BUTTON_ENABLED);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return action.isEnabled();
    }

    void largeIconChanged(Action a) {
    }

    void smallIconChanged(Action a) {
    }
}

