/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@ExperimentalApi
public record IngestionStatus(boolean isPaused) implements Writeable,
ToXContent
{
    public static final String IS_PAUSED = "is_paused";

    public IngestionStatus(StreamInput in) throws IOException {
        this(in.readBoolean());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.isPaused);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(IS_PAUSED, this.isPaused);
        builder.endObject();
        return builder;
    }

    public static IngestionStatus fromXContent(XContentParser parser) throws IOException {
        boolean isPaused = false;
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                String fieldName;
                if (token != XContentParser.Token.FIELD_NAME || !IS_PAUSED.equals(fieldName = parser.currentName())) continue;
                parser.nextToken();
                isPaused = parser.booleanValue();
            }
        }
        return new IngestionStatus(isPaused);
    }

    public static IngestionStatus getDefaultValue() {
        return new IngestionStatus(false);
    }
}

