/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.hll.CurMode;
import com.yahoo.sketches.hll.PreambleUtil;

final class HllUtil {
    static final int KEY_BITS_26 = 26;
    static final int VAL_BITS_6 = 6;
    static final int KEY_MASK_26 = 0x3FFFFFF;
    static final int VAL_MASK_6 = 63;
    static final int EMPTY = 0;
    static final int MIN_LOG_K = 4;
    static final int MAX_LOG_K = 21;
    static final double HLL_HIP_RSE_FACTOR = Math.sqrt(Math.log(2.0));
    static final double HLL_NON_HIP_RSE_FACTOR = Math.sqrt(3.0 * Math.log(2.0) - 1.0);
    static final double COUPON_RSE_FACTOR = 0.409;
    static final double COUPON_RSE = 4.99267578125E-5;
    static final int LG_INIT_LIST_SIZE = 3;
    static final int LG_INIT_SET_SIZE = 5;
    static final int RESIZE_NUMER = 3;
    static final int RESIZE_DENOM = 4;
    static final int loNibbleMask = 15;
    static final int hiNibbleMask = 240;
    static final int AUX_TOKEN = 15;
    static final int[] LG_AUX_ARR_INTS = new int[]{0, 2, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};

    HllUtil() {
    }

    static final int checkLgK(int lgK) {
        if (lgK >= 4 && lgK <= 21) {
            return lgK;
        }
        throw new SketchesArgumentException("Log K must be between 4 and 21, inclusive: " + lgK);
    }

    static void checkMemSize(long minBytes, long capBytes) {
        if (capBytes < minBytes) {
            throw new SketchesArgumentException("Given WritableMemory is not large enough: " + capBytes);
        }
    }

    static final void checkNumStdDev(int numStdDev) {
        if (numStdDev < 1 || numStdDev > 3) {
            throw new SketchesArgumentException("NumStdDev may not be less than 1 or greater than 3.");
        }
    }

    static CurMode checkPreamble(Memory mem) {
        int preInts = PreambleUtil.extractPreInts(mem);
        int serVer = PreambleUtil.extractSerVer(mem);
        int famId = PreambleUtil.extractFamilyId(mem);
        CurMode curMode = PreambleUtil.extractCurMode(mem);
        if (famId != Family.HLL.getID() || serVer != 1 || preInts != 2 && preInts != 3 && preInts != 10 || curMode == CurMode.LIST && preInts != 2 || curMode == CurMode.SET && preInts != 3 || curMode == CurMode.HLL && preInts != 10) {
            HllUtil.badPreambleState(mem);
        }
        return curMode;
    }

    static final void noWriteAccess() {
        throw new SketchesArgumentException("This sketch does not have write access to the underlying resource.");
    }

    static final void badPreambleState(Memory mem) {
        throw new SketchesArgumentException("Possible Corruption, Invalid Preamble:" + PreambleUtil.toString(mem));
    }

    static String pairString(int pair) {
        return "SlotNo: " + HllUtil.getLow26(pair) + ", Value: " + HllUtil.getValue(pair);
    }

    static int pair(int slotNo, int value) {
        return value << 26 | slotNo & 0x3FFFFFF;
    }

    static final int getLow26(int coupon) {
        return coupon & 0x3FFFFFF;
    }

    static final int getValue(int coupon) {
        return coupon >>> 26;
    }
}

