/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.MacOSVersionStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MacHost
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MacHost> {
    private static final SdkField<String> HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostId").getter(MacHost.getter(MacHost::hostId)).setter(MacHost.setter(Builder::hostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").unmarshallLocationName("hostId").build()}).build();
    private static final SdkField<List<String>> MAC_OS_LATEST_SUPPORTED_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MacOSLatestSupportedVersions").getter(MacHost.getter(MacHost::macOSLatestSupportedVersions)).setter(MacHost.setter(Builder::macOSLatestSupportedVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacOSLatestSupportedVersionSet").unmarshallLocationName("macOSLatestSupportedVersionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_ID_FIELD, MAC_OS_LATEST_SUPPORTED_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MacHost.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostId;
    private final List<String> macOSLatestSupportedVersions;

    private MacHost(BuilderImpl builder) {
        this.hostId = builder.hostId;
        this.macOSLatestSupportedVersions = builder.macOSLatestSupportedVersions;
    }

    public final String hostId() {
        return this.hostId;
    }

    public final boolean hasMacOSLatestSupportedVersions() {
        return this.macOSLatestSupportedVersions != null && !(this.macOSLatestSupportedVersions instanceof SdkAutoConstructList);
    }

    public final List<String> macOSLatestSupportedVersions() {
        return this.macOSLatestSupportedVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMacOSLatestSupportedVersions() ? this.macOSLatestSupportedVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacHost)) {
            return false;
        }
        MacHost other = (MacHost)obj;
        return Objects.equals(this.hostId(), other.hostId()) && this.hasMacOSLatestSupportedVersions() == other.hasMacOSLatestSupportedVersions() && Objects.equals(this.macOSLatestSupportedVersions(), other.macOSLatestSupportedVersions());
    }

    public final String toString() {
        return ToString.builder((String)"MacHost").add("HostId", (Object)this.hostId()).add("MacOSLatestSupportedVersions", this.hasMacOSLatestSupportedVersions() ? this.macOSLatestSupportedVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostId": {
                return Optional.ofNullable(clazz.cast(this.hostId()));
            }
            case "MacOSLatestSupportedVersions": {
                return Optional.ofNullable(clazz.cast(this.macOSLatestSupportedVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HostId", HOST_ID_FIELD);
        map.put("MacOSLatestSupportedVersionSet", MAC_OS_LATEST_SUPPORTED_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MacHost, T> g) {
        return obj -> g.apply((MacHost)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostId;
        private List<String> macOSLatestSupportedVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MacHost model) {
            this.hostId(model.hostId);
            this.macOSLatestSupportedVersions(model.macOSLatestSupportedVersions);
        }

        public final String getHostId() {
            return this.hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final Collection<String> getMacOSLatestSupportedVersions() {
            if (this.macOSLatestSupportedVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.macOSLatestSupportedVersions;
        }

        public final void setMacOSLatestSupportedVersions(Collection<String> macOSLatestSupportedVersions) {
            this.macOSLatestSupportedVersions = MacOSVersionStringListCopier.copy(macOSLatestSupportedVersions);
        }

        @Override
        public final Builder macOSLatestSupportedVersions(Collection<String> macOSLatestSupportedVersions) {
            this.macOSLatestSupportedVersions = MacOSVersionStringListCopier.copy(macOSLatestSupportedVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macOSLatestSupportedVersions(String ... macOSLatestSupportedVersions) {
            this.macOSLatestSupportedVersions(Arrays.asList(macOSLatestSupportedVersions));
            return this;
        }

        public MacHost build() {
            return new MacHost(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MacHost> {
        public Builder hostId(String var1);

        public Builder macOSLatestSupportedVersions(Collection<String> var1);

        public Builder macOSLatestSupportedVersions(String ... var1);
    }
}

