/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.validation.PyAnnotationHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAssignTargetAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder myHolder;

    public PyAssignTargetAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        if (holder == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @NotNull
    private PyAnnotationHolder getHolder() {
        PyAnnotationHolder pyAnnotationHolder = this.myHolder;
        if (pyAnnotationHolder == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        return pyAnnotationHolder;
    }

    public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
        if (node == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        for (PyExpression expression : node.getRawTargets()) {
            expression.accept((PsiElementVisitor)new ExprVisitor(Operation.Assign));
        }
        PyExpression expression = node.getAssignedValue();
        if (expression instanceof PyAssignmentExpression) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.unparenthesized.assignment.expression.value", new Object[0])).range((PsiElement)expression).create();
        }
    }

    public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
        if (node == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        node.getTarget().accept((PsiElementVisitor)new ExprVisitor(Operation.AugAssign));
    }

    public void visitPyDelStatement(@NotNull PyDelStatement node) {
        if (node == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        ExprVisitor visitor = new ExprVisitor(Operation.Delete);
        for (PyExpression expr : node.getTargets()) {
            expr.accept((PsiElementVisitor)visitor);
        }
    }

    public void visitPyExceptBlock(@NotNull PyExceptPart node) {
        PyExpression target;
        if (node == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        if ((target = node.getTarget()) != null) {
            target.accept((PsiElementVisitor)new ExprVisitor(Operation.Except));
        }
    }

    public void visitPyForStatement(@NotNull PyForStatement node) {
        PyExpression target;
        if (node == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(6);
        }
        if ((target = node.getForPart().getTarget()) != null) {
            target.accept((PsiElementVisitor)new ExprVisitor(Operation.For));
            this.checkNotAssignmentExpression(target, PyPsiBundle.message("ANN.assignment.expression.as.a.target", new Object[0]));
        }
    }

    public void visitPyWithItem(@NotNull PyWithItem node) {
        PyExpression target;
        if (node == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(7);
        }
        if ((target = node.getTarget()) != null) {
            target.accept((PsiElementVisitor)new ExprVisitor(Operation.With));
        }
    }

    public void visitPyExpressionStatement(@NotNull PyExpressionStatement node) {
        PyExpression expression;
        if (node == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(8);
        }
        if ((expression = node.getExpression()) instanceof PyAssignmentExpression) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.unparenthesized.assignment.expression.statement", new Object[0])).range((PsiElement)expression).create();
        }
    }

    public void visitPyAssignmentExpression(@NotNull PyAssignmentExpression node) {
        PyComprehensionElement comprehensionElement;
        if (node == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(9);
        }
        if (ScopeUtil.getScopeOwner((PsiElement)(comprehensionElement = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)node, PyComprehensionElement.class, (boolean)true, (Class[])new Class[]{ScopeOwner.class}))) instanceof PyClass) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.assignment.expressions.within.a.comprehension.cannot.be.used.in.a.class.body", new Object[0])).create();
        }
    }

    public void visitPyComprehensionElement(@NotNull PyComprehensionElement node) {
        if (node == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(10);
        }
        String targetMessage = PyPsiBundle.message("ANN.assignment.expression.as.a.target", new Object[0]);
        String iterableMessage = PyPsiBundle.message("ANN.assignment.expression.in.an.iterable", new Object[0]);
        node.getForComponents().forEach(it -> {
            PyExpression iteratorVariable = (PyExpression)it.getIteratorVariable();
            iteratorVariable.accept((PsiElementVisitor)new ExprVisitor(Operation.For));
            this.checkNotAssignmentExpression(iteratorVariable, targetMessage);
            this.checkNoAssignmentExpressionAsChild((PyExpression)it.getIteratedList(), iterableMessage);
        });
    }

    private void checkNoAssignmentExpressionAsChild(@Nullable PyExpression expression, @NotNull @InspectionMessage String message) {
        if (message == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(11);
        }
        PsiTreeUtil.findChildrenOfType((PsiElement)expression, PyAssignmentExpression.class).forEach(it -> this.checkNotAssignmentExpression((PyExpression)it, message));
    }

    private void checkNotAssignmentExpression(@Nullable PyExpression expression, @NotNull @InspectionMessage String message) {
        if (message == null) {
            PyAssignTargetAnnotatorVisitor.$$$reportNull$$$0(12);
        }
        if (PyPsiUtils.flattenParens((PyExpression)expression) instanceof PyAssignmentExpression) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)expression).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/validation/PyAssignTargetAnnotatorVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/validation/PyAssignTargetAnnotatorVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssignmentStatement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAugAssignmentStatement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDelStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitPyExceptBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitPyForStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitPyWithItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitPyExpressionStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssignmentExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitPyComprehensionElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkNoAssignmentExpressionAsChild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkNotAssignmentExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class ExprVisitor
    extends PyElementVisitor {
        private final Operation myOp;

        ExprVisitor(Operation op) {
            this.myOp = op;
        }

        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            String referencedName;
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(0);
            }
            if ("None".equals(referencedName = node.getReferencedName())) {
                PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, this.myOp == Operation.Delete ? PyPsiBundle.message("ANN.deleting.none", new Object[0]) : PyPsiBundle.message("ANN.assign.to.none", new Object[0])).range((PsiElement)node).create();
            }
        }

        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            VirtualFile vfile;
            String targetName;
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(1);
            }
            if ("None".equals(targetName = node.getName()) && (vfile = node.getContainingFile().getVirtualFile()) != null && !vfile.getUrl().contains("/python_stubs/")) {
                PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, this.myOp == Operation.Delete ? PyPsiBundle.message("ANN.deleting.none", new Object[0]) : PyPsiBundle.message("ANN.assign.to.none", new Object[0])).range((PsiElement)node).create();
            }
            if ("__debug__".equals(targetName)) {
                if (LanguageLevel.forElement((PsiElement)node).isPy3K()) {
                    PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.assignment.to.keyword", new Object[0])).range((PsiElement)node).create();
                } else {
                    PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.cannot.assign.to.debug", new Object[0])).range((PsiElement)node).create();
                }
            }
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(2);
            }
            PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, this.myOp == Operation.Delete ? PyPsiBundle.message("ANN.cant.delete.call", new Object[0]) : PyPsiBundle.message("ANN.cant.assign.to.call", new Object[0])).range((PsiElement)node).create();
        }

        public void visitPyGeneratorExpression(@NotNull PyGeneratorExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(3);
            }
            PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message(this.myOp == Operation.AugAssign ? "ANN.cant.aug.assign.to.generator" : "ANN.cant.assign.to.generator", new Object[0])).range((PsiElement)node).create();
        }

        public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(4);
            }
            PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.cant.assign.to.operator", new Object[0])).range((PsiElement)node).create();
        }

        public void visitPyTupleExpression(@NotNull PyTupleExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(5);
            }
            if (node.isEmpty() && LanguageLevel.forElement((PsiElement)node).isPython2()) {
                PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.cant.assign.to.parens", new Object[0])).range((PsiElement)node).create();
            } else if (this.myOp == Operation.AugAssign) {
                PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.cant.aug.assign.to.tuple.or.generator", new Object[0])).range((PsiElement)node).create();
            } else {
                node.acceptChildren((PsiElementVisitor)this);
            }
        }

        public void visitPyParenthesizedExpression(@NotNull PyParenthesizedExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(6);
            }
            if (this.myOp == Operation.AugAssign) {
                PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.cant.aug.assign.to.tuple.or.generator", new Object[0])).range((PsiElement)node).create();
            } else {
                node.acceptChildren((PsiElementVisitor)this);
            }
        }

        public void visitPyListLiteralExpression(@NotNull PyListLiteralExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(7);
            }
            if (this.myOp == Operation.AugAssign) {
                PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.cant.aug.assign.to.list.or.comprh", new Object[0])).range((PsiElement)node).create();
            } else {
                node.acceptChildren((PsiElementVisitor)this);
            }
        }

        public void visitPyListCompExpression(@NotNull PyListCompExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(8);
            }
            PyAssignTargetAnnotatorVisitor.this.getHolder().markError((PsiElement)node, PyPsiBundle.message(this.myOp == Operation.AugAssign ? "ANN.cant.aug.assign.to.comprh" : "ANN.cant.assign.to.comprh", new Object[0]));
        }

        public void visitPyDictCompExpression(@NotNull PyDictCompExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(9);
            }
            PyAssignTargetAnnotatorVisitor.this.getHolder().markError((PsiElement)node, PyPsiBundle.message(this.myOp == Operation.AugAssign ? "ANN.cant.aug.assign.to.dict.comprh" : "ANN.cant.assign.to.dict.comprh", new Object[0]));
        }

        public void visitPySetCompExpression(@NotNull PySetCompExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(10);
            }
            PyAssignTargetAnnotatorVisitor.this.getHolder().markError((PsiElement)node, PyPsiBundle.message(this.myOp == Operation.AugAssign ? "ANN.cant.aug.assign.to.set.comprh" : "ANN.cant.assign.to.set.comprh", new Object[0]));
        }

        public void visitPyStarExpression(@NotNull PyStarExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(11);
            }
            super.visitPyStarExpression(node);
            if (!(node.getParent() instanceof PySequenceExpression)) {
                PyAssignTargetAnnotatorVisitor.this.getHolder().markError((PsiElement)node, PyPsiBundle.message("ANN.cant.aug.assign.starred.assignment.target.must.be.in.list.or.tuple", new Object[0]));
            }
        }

        public void visitPyDictLiteralExpression(@NotNull PyDictLiteralExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(12);
            }
            this.checkLiteral((PsiElement)node);
        }

        public void visitPySetLiteralExpression(@NotNull PySetLiteralExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(13);
            }
            this.checkLiteral((PsiElement)node);
        }

        public void visitPyNumericLiteralExpression(@NotNull PyNumericLiteralExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(14);
            }
            this.checkLiteral((PsiElement)node);
        }

        public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(15);
            }
            this.checkLiteral((PsiElement)node);
        }

        private void checkLiteral(@NotNull PsiElement node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(16);
            }
            PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message(this.myOp == Operation.Delete ? "ANN.cant.delete.literal" : "ANN.cant.assign.to.literal", new Object[0])).range(node).create();
        }

        public void visitPyLambdaExpression(@NotNull PyLambdaExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(17);
            }
            PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.cant.assign.to.lambda", new Object[0])).range((PsiElement)node).create();
        }

        public void visitPyNoneLiteralExpression(@NotNull PyNoneLiteralExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(18);
            }
            PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.assignment.to.keyword", new Object[0])).range((PsiElement)node).create();
        }

        public void visitPyBoolLiteralExpression(@NotNull PyBoolLiteralExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(19);
            }
            PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.assignment.to.keyword", new Object[0])).range((PsiElement)node).create();
        }

        public void visitPyPrefixExpression(@NotNull PyPrefixExpression node) {
            if (node == null) {
                ExprVisitor.$$$reportNull$$$0(20);
            }
            if (node.getOperator() == PyTokenTypes.AWAIT_KEYWORD) {
                PyAssignTargetAnnotatorVisitor.this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.cant.assign.to.await.expr", new Object[0])).range((PsiElement)node).create();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/jetbrains/python/validation/PyAssignTargetAnnotatorVisitor$ExprVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyGeneratorExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyBinaryExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTupleExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyParenthesizedExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyListLiteralExpression";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyListCompExpression";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyDictCompExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPySetCompExpression";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyStarExpression";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyDictLiteralExpression";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPySetLiteralExpression";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyNumericLiteralExpression";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyStringLiteralExpression";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkLiteral";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyLambdaExpression";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyNoneLiteralExpression";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyBoolLiteralExpression";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyPrefixExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Operation {
        Assign,
        AugAssign,
        Delete,
        Except,
        For,
        With;

    }
}

