/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;

public class Arrays {
    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static Object[] asObjectArray(Object array) {
        Preconditions.checkArgument(Arrays.isArray(array), "Given object %s is not an array", array);
        int length = Array.getLength(array);
        Object[] objectArray = new Object[length];
        for (int i2 = 0; i2 < length; ++i2) {
            objectArray[i2] = Array.get(array, i2);
        }
        return objectArray;
    }

    public static List<Object> asList(Object array) {
        return Lists.newArrayList(Arrays.asObjectArray(array));
    }

    public static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || Arrays.isEmpty(array);
    }

    @SafeVarargs
    public static <T> T[] array(T ... values) {
        return values;
    }

    public static int[] array(AtomicIntegerArray atomicIntegerArray) {
        if (atomicIntegerArray == null) {
            return null;
        }
        int[] array = new int[atomicIntegerArray.length()];
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = atomicIntegerArray.get(i2);
        }
        return array;
    }

    public static long[] array(AtomicLongArray atomicLongArray) {
        if (atomicLongArray == null) {
            return null;
        }
        long[] array = new long[atomicLongArray.length()];
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = atomicLongArray.get(i2);
        }
        return array;
    }

    public static <T> T[] array(AtomicReferenceArray<T> atomicReferenceArray) {
        if (atomicReferenceArray == null) {
            return null;
        }
        int length = atomicReferenceArray.length();
        if (length == 0) {
            return Arrays.array(new Object[0]);
        }
        ArrayList<Object> list = Lists.newArrayList();
        for (int i2 = 0; i2 < length; ++i2) {
            list.add(atomicReferenceArray.get(i2));
        }
        return list.toArray((Object[])Array.newInstance(Object.class, length));
    }

    public static <T> List<T> nonNullElementsIn(T[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return java.util.Arrays.stream(array).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> boolean hasOnlyNullElements(T[] array) {
        Objects.requireNonNull(array);
        if (Arrays.isEmpty(array)) {
            return false;
        }
        for (T o : array) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean isEmpty(T[] array) {
        return array.length == 0;
    }

    public static boolean isObjectArray(Object o) {
        return Arrays.isArray(o) && !Arrays.isArrayTypePrimitive(o);
    }

    public static boolean isArrayTypePrimitive(Object o) {
        return Arrays.isArray(o) && o.getClass().getComponentType().isPrimitive();
    }

    public static IllegalArgumentException notAnArrayOfPrimitives(Object o) {
        return new IllegalArgumentException("<%s> is not an array of primitives".formatted(o));
    }

    public static <T> T[] prepend(T first2, T ... rest) {
        Object[] result2 = new Object[1 + rest.length];
        result2[0] = first2;
        System.arraycopy(rest, 0, result2, 1, rest.length);
        return result2;
    }

    public static int sizeOf(Object array) {
        if (!Arrays.isArray(array)) {
            throw new IllegalArgumentException("expecting %s to be an array".formatted(array));
        }
        if (array instanceof Object[]) {
            Object[] objects = (Object[])array;
            return objects.length;
        }
        return Array.getLength(array);
    }

    public static boolean isArrayEmpty(Object array) {
        return Arrays.sizeOf(array) == 0;
    }

    private Arrays() {
    }
}

