/*
 * Decompiled with CFR 0.152.
 */
package hughai;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.EnemyTracker;
import hughai.EnergyController;
import hughai.GameAdapter;
import hughai.GiveOrderWrapper;
import hughai.MetalController;
import hughai.Ownership;
import hughai.PlayerObjects;
import hughai.ResourceManager;
import hughai.VoiceCommandHandler;
import hughai.basictypes.TerrainPos;
import hughai.building.Workflows;
import hughai.controllers.level1.Offense;
import hughai.controllers.level1.Reconnaissance;
import hughai.mapping.BuildPlanner;
import hughai.mapping.Maps;
import hughai.mapping.Metal;
import hughai.mapping.ReclaimHelper;
import hughai.unitdata.BuildTable;
import hughai.unitdata.BuildTree;
import hughai.unitdata.UnitController;
import hughai.unitdata.UnitDefHelp;
import hughai.unitdata.UnitLists;
import hughai.utils.Config;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class WorkflowController {
    PlayerObjects playerObjects;
    CSAI csai;
    OOAICallback aicallback;
    ResourceManager resourceManager;
    LogFile logfile;
    UnitController unitController;
    BuildPlanner buildPlanner;
    Ownership ownership;
    BuildTree buildTree;
    BuildTable buildTable;
    MetalController metalController;
    EnergyController energyController;
    GiveOrderWrapper giveOrderWrapper;
    UnitDefHelp unitDefHelp;
    Metal metal;
    DrawingUtils drawingUtils;
    ReclaimHelper reclaimHelper;
    UnitLists unitLists;
    Maps maps;
    EnemyTracker enemyTracker;
    Config config;
    Offense offense;
    Reconnaissance reconnaissance;
    Workflows workflows;
    Random random = new Random();
    public double energymetalratio = 10.0;
    HashMap<Workflows.Workflow.Order, ArrayList<Ownership.IOrder>> unitsUnderContructionByOrder = new HashMap();
    List<Unit> ActiveConstructors = new ArrayList<Unit>();
    Map<Unit, Unit> AssistingConstructors = new HashMap<Unit, Unit>();
    Workflows.Workflow currentWorkflow;
    Collection<Workflows.Workflow.Order> currentOrders;
    List<String> energyunits = new ArrayList<String>();
    List<String> metalunits = new ArrayList<String>();

    public WorkflowController(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.resourceManager = playerObjects.getResourceManager();
        this.logfile = playerObjects.getLogFile();
        this.unitController = playerObjects.getUnitController();
        this.buildPlanner = playerObjects.getBuildPlanner();
        this.ownership = playerObjects.getOwnership();
        this.buildTree = playerObjects.getBuildTree();
        this.buildTable = playerObjects.getBuildTable();
        this.metalController = playerObjects.getMetalController();
        this.energyController = playerObjects.getEnergyController();
        this.giveOrderWrapper = playerObjects.getGiveOrderWrapper();
        this.unitDefHelp = playerObjects.getUnitDefHelp();
        this.metal = playerObjects.getMetal();
        this.drawingUtils = playerObjects.getDrawingUtils();
        this.reclaimHelper = playerObjects.getReclaimHelper();
        this.unitLists = playerObjects.getUnitLists();
        this.config = playerObjects.getConfig();
        this.maps = playerObjects.getMaps();
        this.enemyTracker = playerObjects.getEnemyTracker();
        this.workflows = playerObjects.getWorkflows();
        if (this.csai.DebugOn) {
            this.csai.RegisterVoiceCommand("dumpworkflow", new DumpWorkFlowHandler());
        }
    }

    public void Activate() {
        this.metal.Init();
        this.currentWorkflow = this.workflows.getWorkflowsByName().get(this.config.getDefaultWorkflowName());
        if (this.currentWorkflow == null) {
            Iterator<Workflows.Workflow> iterator = this.workflows.getWorkflowsByName().values().iterator();
            while (iterator.hasNext()) {
                Workflows.Workflow workflow;
                this.currentWorkflow = workflow = iterator.next();
            }
        }
        this.currentOrders = this.currentWorkflow.orders;
        this.reconnaissance = new Reconnaissance(this.playerObjects);
        this.reconnaissance.Activate();
        this.offense = new Offense(this.playerObjects);
        this.offense.Activate();
        this.maps.getLosMap();
        this.playerObjects.getBuildTree();
        this.unitController.LoadExistingUnits();
        this.enemyTracker.LoadExistingUnits();
        this.CheckIdleUnits();
        this.csai.registerGameListener(new GameListener());
    }

    void CheckIdleUnits() {
        for (Unit unit : this.unitController.units) {
            UnitDef unitDef = unit.getDef();
            if (!unitDef.isBuilder()) continue;
            if (unit.getCurrentCommands().size() == 0) {
                this.logfile.WriteLine("Unit " + unitDef.getHumanName() + " not busy, calling idle");
                if (this.AssistingConstructors.containsKey(unit)) {
                    this.logfile.WriteLine("removing from assistingconstructors");
                    this.AssistingConstructors.remove(unit);
                }
                this.logfile.WriteLine("... calling unitidle ...");
                new GameListener().UnitIdle(unit);
            }
            if (this.ActiveConstructors.contains(unit)) continue;
            this.logfile.WriteLine("Unit " + unitDef.getHumanName() + " not in active commanders, calling idle");
            new GameListener().UnitIdle(unit);
        }
    }

    public void AddEnergyUnit(String string) {
        this.energyunits.add(string);
    }

    public void AddMetalUnit(String string) {
        this.metalunits.add(string);
    }

    void OfferAssistance(Unit unit) {
        Unit unit2 = null;
        double d = 1.0E9;
        TerrainPos terrainPos = this.unitController.getPos(unit);
        for (Unit unit3 : this.ActiveConstructors) {
            float f;
            TerrainPos terrainPos2 = this.unitController.getPos(unit3);
            if (terrainPos2 == null || !((double)(f = terrainPos.GetSquaredDistance(terrainPos2)) < d)) continue;
            unit2 = unit3;
            d = f;
        }
        if (unit2 != null) {
            this.logfile.WriteLine("unit to assist should be " + unit2);
            if (!this.AssistingConstructors.containsKey(unit)) {
                this.logfile.WriteLine("assisting " + unit2);
                this.giveOrderWrapper.Guard(unit, unit2);
                this.AssistingConstructors.put(unit, unit2);
            } else if (this.AssistingConstructors.get(unit) != unit2) {
                this.logfile.WriteLine("assisting " + unit2);
                this.giveOrderWrapper.Guard(unit, unit2);
                this.AssistingConstructors.put(unit, unit2);
            }
        }
    }

    boolean BuildConstructionVehicle(Unit unit, UnitDef unitDef) {
        UnitDef unitDef2 = null;
        String string = this.buildTree.listToOurTeamsUnitName(this.config.getBasicconstructionvehicleunitnames());
        if (string == null) {
            return false;
        }
        if (this.buildTree.CanBuild(unitDef.getName().toLowerCase(), string)) {
            unitDef2 = this.buildTable.getUnitDefByName(string);
        } else if (this.buildTree.CanBuild(unitDef.getName().toLowerCase(), string)) {
            unitDef2 = this.buildTable.getUnitDefByName(string);
        } else {
            return false;
        }
        TerrainPos terrainPos = this.BuildUnit(unit, unitDef2.getName().toLowerCase());
        Ownership.IOrder iOrder = this.ownership.RegisterBuildingOrder(new BuildListener(), unit, unitDef2, terrainPos);
        this.logfile.WriteLine("building: " + unitDef2.getName().toLowerCase());
        if (this.AssistingConstructors.containsKey(unit)) {
            this.AssistingConstructors.remove(unit);
        }
        return true;
    }

    TerrainPos BuildUnit(Unit unit, String string) {
        this.csai.DebugSay("workflow, building " + string);
        UnitDef unitDef = this.buildTable.getUnitDefByName(string);
        UnitDef unitDef2 = unit.getDef();
        if (this.unitDefHelp.IsMobile(unitDef2)) {
            this.logfile.WriteLine("constructor is mobile");
            TerrainPos terrainPos = this.unitController.getPos(unit);
            TerrainPos terrainPos2 = this.buildPlanner.ClosestBuildSite(unitDef, terrainPos, 3000, 2);
            terrainPos2 = TerrainPos.fromAIFloat3(this.aicallback.getMap().findClosestBuildSite(unitDef, terrainPos2.toAIFloat3(), 1400.0f, 0, 0));
            this.logfile.WriteLine("constructor location: " + terrainPos + " Buildsite: " + terrainPos2 + " target item: " + unitDef.getHumanName());
            if (!this.ActiveConstructors.contains(unit)) {
                this.ActiveConstructors.add(unit);
            }
            this.drawingUtils.DrawUnit(string.toUpperCase(), terrainPos2, 0.0f, 1, this.aicallback.getSkirmishAI().getTeamId(), true, true);
            this.giveOrderWrapper.BuildUnit(unit, string, terrainPos2);
            return terrainPos2;
        }
        TerrainPos terrainPos = this.unitController.getPos(unit);
        this.logfile.WriteLine("factory location: " + terrainPos + " target item: " + unitDef.getHumanName());
        if (!this.ActiveConstructors.contains(unit)) {
            this.ActiveConstructors.add(unit);
        }
        this.drawingUtils.DrawUnit(unitDef.getName().toUpperCase(), terrainPos, 0.0f, 200, this.aicallback.getSkirmishAI().getTeamId(), true, true);
        this.giveOrderWrapper.BuildUnit(unit, string);
        return terrainPos;
    }

    boolean BuildMex(Unit unit) {
        String string = this.buildTree.listToOurTeamsUnitName(this.config.getBasicmetalextractorunitnames());
        if (string == null) {
            return false;
        }
        if (!this.buildTree.CanBuild(unit.getDef().getName().toLowerCase(), string)) {
            return false;
        }
        UnitDef unitDef = this.buildTable.getUnitDefByName(string);
        TerrainPos terrainPos = this.metal.GetNearestMetalSpot(this.unitController.getPos(unit));
        TerrainPos terrainPos2 = TerrainPos.fromAIFloat3(this.aicallback.getMap().findClosestBuildSite(unitDef, terrainPos.toAIFloat3(), 100.0f, 0, 0));
        this.logfile.WriteLine("Workflow.buildmex, metal says build at " + terrainPos + " map changes this to: " + terrainPos2);
        if (!this.ActiveConstructors.contains(unit)) {
            this.ActiveConstructors.add(unit);
        }
        this.giveOrderWrapper.BuildUnit(unit, unitDef.getName(), terrainPos2);
        return true;
    }

    boolean BuildSolarCell(Unit unit) {
        String string = this.buildTree.listToOurTeamsUnitName(this.config.getBasicenergyextractorunitnames());
        if (string == null) {
            return false;
        }
        if (!this.buildTree.CanBuild(unit.getDef().getName().toLowerCase(), string)) {
            return false;
        }
        UnitDef unitDef = this.buildTable.getUnitDefByName(string);
        TerrainPos terrainPos = this.buildPlanner.ClosestBuildSite(unitDef, this.unitController.getPos(unit), 3000, 2);
        terrainPos = TerrainPos.fromAIFloat3(this.aicallback.getMap().findClosestBuildSite(unitDef, terrainPos.toAIFloat3(), 100.0f, 0, 0));
        if (!this.ActiveConstructors.contains(unit)) {
            this.ActiveConstructors.add(unit);
        }
        this.giveOrderWrapper.BuildUnit(unit, unitDef.getName(), terrainPos);
        return true;
    }

    class BuildListener
    implements Ownership.IBuilder {
        BuildListener() {
        }

        @Override
        public void UnitFinished(Ownership.IOrder iOrder, Unit unit) {
            for (Workflows.Workflow.Order order : WorkflowController.this.currentOrders) {
                if (WorkflowController.this.unitsUnderContructionByOrder.get(order) == null) {
                    WorkflowController.this.unitsUnderContructionByOrder.put(order, new ArrayList());
                }
                if (!WorkflowController.this.unitsUnderContructionByOrder.get(order).contains(iOrder)) continue;
                WorkflowController.this.unitsUnderContructionByOrder.get(order).remove(iOrder);
            }
            new GameListener().UnitIdle(unit);
        }

        @Override
        public void UnitCreated(Ownership.IOrder iOrder, Unit unit) {
        }

        @Override
        public void UnitDestroyed(Ownership.IOrder iOrder, Unit unit) {
            for (Workflows.Workflow.Order order : WorkflowController.this.currentOrders) {
                if (WorkflowController.this.unitsUnderContructionByOrder.get(order) == null) {
                    WorkflowController.this.unitsUnderContructionByOrder.put(order, new ArrayList());
                }
                if (!WorkflowController.this.unitsUnderContructionByOrder.get(order).contains(iOrder)) continue;
                WorkflowController.this.unitsUnderContructionByOrder.get(order).remove(iOrder);
            }
        }
    }

    class GameListener
    extends GameAdapter {
        GameListener() {
        }

        @Override
        public void Tick(int n) {
            WorkflowController.this.CheckIdleUnits();
        }

        @Override
        public void UnitIdle(Unit unit) {
            Object object;
            UnitDef unitDef = WorkflowController.this.unitController.getUnitDef(unit);
            if (!unitDef.isBuilder()) {
                return;
            }
            WorkflowController.this.logfile.WriteLine("unitidleevent " + unit.getUnitId() + " " + unitDef.getName() + " " + unitDef.getHumanName());
            if (WorkflowController.this.ActiveConstructors.contains(unit)) {
                WorkflowController.this.ActiveConstructors.remove(unit);
            }
            WorkflowController.this.ownership.SignalConstructorIsIdle(unit);
            double d = 0.0;
            ArrayList<Workflows.Workflow.Order> arrayList = new ArrayList<Workflows.Workflow.Order>();
            for (Workflows.Workflow.Order order : WorkflowController.this.currentOrders) {
                double d2 = order.priority;
                if (!(d2 >= d)) continue;
                if (WorkflowController.this.unitsUnderContructionByOrder.get(order) == null) {
                    WorkflowController.this.unitsUnderContructionByOrder.put(order, new ArrayList());
                }
                object = WorkflowController.this.unitsUnderContructionByOrder.get(order);
                int n = object.size();
                if (WorkflowController.this.unitController.UnitsByName.containsKey(order.unitname)) {
                    n += WorkflowController.this.unitController.UnitsByName.get(order.unitname).size();
                }
                if (n >= order.quantity || !WorkflowController.this.buildTree.CanBuild(unitDef.getName().toLowerCase(), order.unitname)) continue;
                if (d2 > d) {
                    d = d2;
                    arrayList = new ArrayList();
                    arrayList.add(order);
                    continue;
                }
                if (d2 != d) continue;
                arrayList.add(order);
            }
            ArrayList arrayList2 = new ArrayList();
            boolean bl = false;
            boolean bl2 = false;
            UnitDef unitDef2 = null;
            for (Workflows.Workflow.Order order : arrayList) {
                WorkflowController.this.csai.DebugSay("bestorder " + order.unitname);
                unitDef2 = WorkflowController.this.buildTable.getUnitDefByName(order.unitname);
                if (WorkflowController.this.metalController.CanBuild(unitDef, unitDef2)) {
                    if (WorkflowController.this.energyController.CanBuild(unitDef, unitDef2)) {
                        arrayList2.add(order);
                        WorkflowController.this.csai.DebugSay("possible: " + order.unitname);
                        continue;
                    }
                    WorkflowController.this.csai.DebugSay("needs energy");
                    bl2 = true;
                    continue;
                }
                WorkflowController.this.csai.DebugSay("needs metal");
                bl = true;
            }
            if (arrayList2.size() == 0) {
                object = WorkflowController.this.buildTree.listToOurTeamsUnitName(WorkflowController.this.config.getCommanderunitnames());
                if (WorkflowController.this.unitLists.getLevel1ConstructorList().getUnits().size() < 1 && !WorkflowController.this.unitController.UnitsByName.containsKey(object) && WorkflowController.this.BuildConstructionVehicle(unit, unitDef)) {
                    return;
                }
                if ((bl2 || WorkflowController.this.resourceManager.getCurrentEnergy() < WorkflowController.this.resourceManager.getEnergyStorage() / 5.0f) && WorkflowController.this.BuildSolarCell(unit)) {
                    WorkflowController.this.logfile.WriteLine("building solarcell");
                    if (WorkflowController.this.AssistingConstructors.containsKey(unit)) {
                        WorkflowController.this.AssistingConstructors.remove(unit);
                    }
                    return;
                }
                if (bl || WorkflowController.this.resourceManager.getCurrentMetal() < WorkflowController.this.resourceManager.getMetalStorage() / 5.0f) {
                    TerrainPos terrainPos = WorkflowController.this.reclaimHelper.GetNearestReclaim(unit);
                    if (terrainPos != null) {
                        WorkflowController.this.giveOrderWrapper.Reclaim(unit, terrainPos, 100.0);
                        return;
                    }
                    if (WorkflowController.this.BuildMex(unit)) {
                        WorkflowController.this.logfile.WriteLine("building mex");
                        if (WorkflowController.this.AssistingConstructors.containsKey(unit)) {
                            WorkflowController.this.AssistingConstructors.remove(unit);
                        }
                        return;
                    }
                }
                WorkflowController.this.logfile.WriteLine("offering assistance");
                WorkflowController.this.OfferAssistance(unit);
                return;
            }
            object = (Workflows.Workflow.Order)arrayList2.get(WorkflowController.this.random.nextInt(arrayList2.size()));
            String string = WorkflowController.this.buildTree.listToOurTeamsUnitName(WorkflowController.this.config.getBasicmetalextractorunitnames());
            if (((Workflows.Workflow.Order)object).unitname.equals(string)) {
                WorkflowController.this.BuildMex(unit);
                if (WorkflowController.this.AssistingConstructors.containsKey(unit)) {
                    WorkflowController.this.AssistingConstructors.remove(unit);
                }
            } else {
                unitDef2 = WorkflowController.this.buildTable.getUnitDefByName(((Workflows.Workflow.Order)object).unitname);
                TerrainPos terrainPos = WorkflowController.this.BuildUnit(unit, ((Workflows.Workflow.Order)object).unitname);
                Ownership.IOrder iOrder = WorkflowController.this.ownership.RegisterBuildingOrder(new BuildListener(), unit, unitDef2, terrainPos);
                WorkflowController.this.logfile.WriteLine("building: " + ((Workflows.Workflow.Order)object).unitname);
                if (WorkflowController.this.unitsUnderContructionByOrder.get(object) == null) {
                    WorkflowController.this.unitsUnderContructionByOrder.put((Workflows.Workflow.Order)object, new ArrayList());
                }
                WorkflowController.this.unitsUnderContructionByOrder.get(object).add(iOrder);
                if (WorkflowController.this.AssistingConstructors.containsKey(unit)) {
                    WorkflowController.this.AssistingConstructors.remove(unit);
                }
            }
        }
    }

    public class DumpWorkFlowHandler
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            WorkflowController.this.logfile.WriteLine("Workflow:");
            for (Workflows.Workflow.Order order : WorkflowController.this.currentOrders) {
                WorkflowController.this.logfile.WriteLine(order.toString());
            }
        }
    }
}

