/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.ExperimentalApi;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.lexer.Stack;
import org.intellij.markdown.parser.CancellationToken;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H$J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00122\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001bH$R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/intellij/markdown/parser/TreeBuilder;", "", "nodeBuilder", "Lorg/intellij/markdown/ast/ASTNodeBuilder;", "(Lorg/intellij/markdown/ast/ASTNodeBuilder;)V", "cancellationToken", "Lorg/intellij/markdown/parser/CancellationToken;", "(Lorg/intellij/markdown/ast/ASTNodeBuilder;Lorg/intellij/markdown/parser/CancellationToken;)V", "getCancellationToken", "()Lorg/intellij/markdown/parser/CancellationToken;", "getNodeBuilder", "()Lorg/intellij/markdown/ast/ASTNodeBuilder;", "buildTree", "Lorg/intellij/markdown/ast/ASTNode;", "production", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "constructEvents", "Lorg/intellij/markdown/parser/TreeBuilder$MyEvent;", "createASTNodeOnClosingEvent", "Lorg/intellij/markdown/parser/TreeBuilder$MyASTNodeWrapper;", "event", "currentNodeChildren", "isTopmostNode", "", "flushEverythingBeforeEvent", "", "", "MyASTNodeWrapper", "MyEvent", "markdown"})
@SourceDebugExtension(value={"SMAP\nTreeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeBuilder.kt\norg/intellij/markdown/parser/TreeBuilder\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,127:1\n107#2,4:128\n107#2,4:132\n107#2,4:136\n106#2,3:140\n110#2:144\n106#3:143\n*S KotlinDebug\n*F\n+ 1 TreeBuilder.kt\norg/intellij/markdown/parser/TreeBuilder\n*L\n22#1:128,4\n23#1:132,4\n41#1:136,4\n51#1:140,3\n51#1:144\n51#1:143\n*E\n"})
public abstract class TreeBuilder {
    @NotNull
    private final ASTNodeBuilder nodeBuilder;
    @NotNull
    private final CancellationToken cancellationToken;

    @ExperimentalApi
    public TreeBuilder(@NotNull ASTNodeBuilder nodeBuilder, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter(nodeBuilder, "nodeBuilder");
        Intrinsics.checkNotNullParameter(cancellationToken, "cancellationToken");
        this.nodeBuilder = nodeBuilder;
        this.cancellationToken = cancellationToken;
    }

    @NotNull
    protected final ASTNodeBuilder getNodeBuilder() {
        return this.nodeBuilder;
    }

    @NotNull
    protected final CancellationToken getCancellationToken() {
        return this.cancellationToken;
    }

    public TreeBuilder(@NotNull ASTNodeBuilder nodeBuilder) {
        Intrinsics.checkNotNullParameter(nodeBuilder, "nodeBuilder");
        this(nodeBuilder, CancellationToken.NonCancellable.INSTANCE);
    }

    @NotNull
    public final ASTNode buildTree(@NotNull List<SequentialParser.Node> production) {
        boolean condition$iv;
        Intrinsics.checkNotNullParameter(production, "production");
        List<MyEvent> events = this.constructEvents(production);
        Stack markersStack = new Stack();
        Compat compat = Compat.INSTANCE;
        int n = !((Collection)events).isEmpty() ? 1 : 0;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "nonsense";
            throw new MarkdownParsingException(string);
        }
        Compat this_$iv = Compat.INSTANCE;
        condition$iv = Intrinsics.areEqual(CollectionsKt.first(events).getInfo(), CollectionsKt.last(events).getInfo());
        $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "more than one root?\nfirst: " + CollectionsKt.first(events).getInfo() + "\nlast: " + CollectionsKt.last(events).getInfo();
            throw new MarkdownParsingException(string);
        }
        n = events.size();
        for (int i = 0; i < n; ++i) {
            List list;
            this.cancellationToken.checkCancelled();
            MyEvent event = events.get(i);
            this.flushEverythingBeforeEvent(event, markersStack.isEmpty() ? null : (List)((Pair)markersStack.peek()).getSecond());
            if (event.isStart()) {
                markersStack.push(new Pair(event, new ArrayList()));
                continue;
            }
            if (event.isEmpty()) {
                list = new ArrayList();
            } else {
                Pair eventAndChildren = (Pair)markersStack.pop();
                Compat compat2 = Compat.INSTANCE;
                boolean condition$iv2 = Intrinsics.areEqual(((MyEvent)eventAndChildren.getFirst()).getInfo(), event.getInfo());
                boolean $i$f$assert2 = false;
                if (!condition$iv2) {
                    boolean bl = false;
                    String string = "Intersecting parsed nodes detected: " + ((MyEvent)eventAndChildren.getFirst()).getInfo() + " vs " + event.getInfo();
                    throw new MarkdownParsingException(string);
                }
                list = (List)eventAndChildren.getSecond();
            }
            List currentNodeChildren = list;
            boolean isTopmostNode = markersStack.isEmpty();
            MyASTNodeWrapper newNode = this.createASTNodeOnClosingEvent(event, currentNodeChildren, isTopmostNode);
            if (isTopmostNode) {
                Compat condition$iv2 = Compat.INSTANCE;
                boolean condition$iv3 = i + 1 == events.size();
                boolean $i$f$assert3 = false;
                if (!condition$iv3) {
                    boolean bl = false;
                    String string = "";
                    throw new MarkdownParsingException(string);
                }
                return newNode.getAstNode();
            }
            ((List)((Pair)markersStack.peek()).getSecond()).add(newNode);
        }
        throw new AssertionError((Object)"markers stack should close some time thus would not be here!");
    }

    @NotNull
    protected abstract MyASTNodeWrapper createASTNodeOnClosingEvent(@NotNull MyEvent var1, @NotNull List<MyASTNodeWrapper> var2, boolean var3);

    protected abstract void flushEverythingBeforeEvent(@NotNull MyEvent var1, @Nullable List<MyASTNodeWrapper> var2);

    private final List<MyEvent> constructEvents(List<SequentialParser.Node> production) {
        ArrayList<MyEvent> events = new ArrayList<MyEvent>();
        int n = production.size();
        for (int index = 0; index < n; ++index) {
            this.cancellationToken.checkCancelled();
            SequentialParser.Node result2 = production.get(index);
            int startTokenId = result2.getRange().getFirst();
            int endTokenId = result2.getRange().getLast();
            events.add(new MyEvent(startTokenId, index, result2));
            if (endTokenId == startTokenId) continue;
            events.add(new MyEvent(endTokenId, index, result2));
        }
        CollectionsKt.sort((List)events);
        return events;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/intellij/markdown/parser/TreeBuilder$MyASTNodeWrapper;", "", "astNode", "Lorg/intellij/markdown/ast/ASTNode;", "startTokenIndex", "", "endTokenIndex", "(Lorg/intellij/markdown/ast/ASTNode;II)V", "getAstNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getEndTokenIndex", "()I", "getStartTokenIndex", "markdown"})
    protected static final class MyASTNodeWrapper {
        @NotNull
        private final ASTNode astNode;
        private final int startTokenIndex;
        private final int endTokenIndex;

        public MyASTNodeWrapper(@NotNull ASTNode astNode, int startTokenIndex, int endTokenIndex) {
            Intrinsics.checkNotNullParameter(astNode, "astNode");
            this.astNode = astNode;
            this.startTokenIndex = startTokenIndex;
            this.endTokenIndex = endTokenIndex;
        }

        @NotNull
        public final ASTNode getAstNode() {
            return this.astNode;
        }

        public final int getStartTokenIndex() {
            return this.startTokenIndex;
        }

        public final int getEndTokenIndex() {
            return this.endTokenIndex;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/intellij/markdown/parser/TreeBuilder$MyEvent;", "", "position", "", "timeClosed", "info", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "(IILorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;)V", "getInfo", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "getPosition", "()I", "getTimeClosed", "compareTo", "other", "isEmpty", "", "isStart", "toString", "", "markdown"})
    protected static final class MyEvent
    implements Comparable<MyEvent> {
        private final int position;
        private final int timeClosed;
        @NotNull
        private final SequentialParser.Node info;

        public MyEvent(int position, int timeClosed, @NotNull SequentialParser.Node info) {
            Intrinsics.checkNotNullParameter(info, "info");
            this.position = position;
            this.timeClosed = timeClosed;
            this.info = info;
        }

        public final int getPosition() {
            return this.position;
        }

        public final int getTimeClosed() {
            return this.timeClosed;
        }

        @NotNull
        public final SequentialParser.Node getInfo() {
            return this.info;
        }

        public final boolean isStart() {
            return this.info.getRange().getLast() != this.position;
        }

        public final boolean isEmpty() {
            return this.info.getRange().getFirst() == this.info.getRange().getLast();
        }

        @Override
        public int compareTo(@NotNull MyEvent other) {
            Intrinsics.checkNotNullParameter(other, "other");
            if (this.position != other.position) {
                return this.position - other.position;
            }
            if (this.isStart() == other.isStart()) {
                int positionDiff = this.info.getRange().getFirst() + this.info.getRange().getLast() - (other.info.getRange().getFirst() + other.info.getRange().getLast());
                if (positionDiff != 0) {
                    if (this.isEmpty() || other.isEmpty()) {
                        return positionDiff;
                    }
                    return -positionDiff;
                }
                int timeDiff = this.timeClosed - other.timeClosed;
                return this.isStart() ? -timeDiff : timeDiff;
            }
            return this.isStart() ? 1 : -1;
        }

        @NotNull
        public String toString() {
            return (this.isStart() ? "Open" : "Close") + ": " + this.position + " (" + this.info + ')';
        }
    }
}

