/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.CommunicatorI;
import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.IdentityParseException;
import com.zeroc.Ice.InitializationData;
import com.zeroc.Ice.InvocationFuture;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.LoggerI;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.PropertiesI;
import com.zeroc.Ice.ProtocolVersion;
import com.zeroc.Ice.ToStringMode;
import com.zeroc.Ice.VersionParseException;
import com.zeroc.IceInternal.Protocol;
import com.zeroc.IceUtilInternal.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class Util {
    public static final ProtocolVersion Protocol_1_0 = new ProtocolVersion(1, 0);
    public static final EncodingVersion Encoding_1_0 = new EncodingVersion(1, 0);
    public static final EncodingVersion Encoding_1_1 = new EncodingVersion(1, 1);
    private static Object _processLoggerMutex = new Object();
    private static Logger _processLogger = null;
    private static String[] _iceTypeIdPrefixes = new String[]{"::Glacier2::", "::Ice::", "::IceBox::", "::IceDiscovery::", "::IceGrid::", "::IceLocatorDiscovery::", "::IceMX::", "::IcePatch2::", "::IceStorm::"};

    public static Properties createProperties() {
        return new PropertiesI();
    }

    public static Properties createProperties(String[] args) {
        return Util.createProperties(args, null, null);
    }

    public static Properties createProperties(String[] args, List<String> remainingArgs) {
        return Util.createProperties(args, null, remainingArgs);
    }

    public static Properties createProperties(String[] args, Properties defaults) {
        return Util.createProperties(args, defaults, null);
    }

    public static Properties createProperties(String[] args, Properties defaults, List<String> remainingArgs) {
        PropertiesI properties = new PropertiesI();
        properties.init(args, defaults, remainingArgs);
        return properties;
    }

    public static Communicator initialize() {
        return Util.initialize(new InitializationData());
    }

    public static Communicator initialize(String[] args) {
        return Util.initialize(args, (InitializationData)null, null);
    }

    public static Communicator initialize(String[] args, List<String> remainingArgs) {
        return Util.initialize(args, (InitializationData)null, remainingArgs);
    }

    public static Communicator initialize(InitializationData initData) {
        return Util.initialize(null, initData, null);
    }

    public static Communicator initialize(String[] args, InitializationData initData) {
        return Util.initialize(args, initData, null);
    }

    public static Communicator initialize(String[] args, String configFile) {
        return Util.initialize(args, configFile, null);
    }

    public static Communicator initialize(String[] args, InitializationData initData, List<String> remainingArgs) {
        initData = initData == null ? new InitializationData() : initData.clone();
        if (args != null) {
            ArrayList<String> rArgs = new ArrayList<String>();
            initData.properties = Util.createProperties(args, initData.properties, rArgs);
            args = rArgs.toArray(new String[rArgs.size()]);
        }
        CommunicatorI communicator = new CommunicatorI(initData);
        communicator.finishSetup(args != null ? args : new String[]{}, remainingArgs);
        return communicator;
    }

    public static Communicator initialize(String[] args, String configFile, List<String> remainingArgs) {
        InitializationData initData = null;
        if (configFile != null) {
            initData = new InitializationData();
            initData.properties = Util.createProperties();
            initData.properties.load(configFile);
        }
        return Util.initialize(args, initData, remainingArgs);
    }

    public static Identity stringToIdentity(String s) {
        Identity ident = new Identity();
        int slash = -1;
        int pos = 0;
        while ((pos = s.indexOf(47, pos)) != -1) {
            int escapes = 0;
            while (pos - escapes > 0 && s.charAt(pos - escapes - 1) == '\\') {
                ++escapes;
            }
            if (escapes % 2 == 0) {
                if (slash == -1) {
                    slash = pos;
                } else {
                    IdentityParseException ex = new IdentityParseException();
                    ex.str = "unescaped backslash in identity `" + s + "'";
                    throw ex;
                }
            }
            ++pos;
        }
        if (slash == -1) {
            ident.category = "";
            try {
                ident.name = StringUtil.unescapeString(s, 0, s.length(), "/");
            }
            catch (IllegalArgumentException e) {
                IdentityParseException ex = new IdentityParseException();
                ex.str = "invalid identity name `" + s + "': " + e.getMessage();
                throw ex;
            }
        }
        try {
            ident.category = StringUtil.unescapeString(s, 0, slash, "/");
        }
        catch (IllegalArgumentException e) {
            IdentityParseException ex = new IdentityParseException();
            ex.str = "invalid category in identity `" + s + "': " + e.getMessage();
            throw ex;
        }
        if (slash + 1 < s.length()) {
            try {
                ident.name = StringUtil.unescapeString(s, slash + 1, s.length(), "/");
            }
            catch (IllegalArgumentException e) {
                IdentityParseException ex = new IdentityParseException();
                ex.str = "invalid name in identity `" + s + "': " + e.getMessage();
                throw ex;
            }
        } else {
            ident.name = "";
        }
        return ident;
    }

    public static String identityToString(Identity ident, ToStringMode toStringMode) {
        if (ident.category == null || ident.category.length() == 0) {
            return StringUtil.escapeString(ident.name, "/", toStringMode);
        }
        return StringUtil.escapeString(ident.category, "/", toStringMode) + '/' + StringUtil.escapeString(ident.name, "/", toStringMode);
    }

    public static String identityToString(Identity ident) {
        return Util.identityToString(ident, ToStringMode.Unicode);
    }

    public static int proxyIdentityCompare(ObjectPrx lhs, ObjectPrx rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null && rhs != null) {
            return -1;
        }
        if (lhs != null && rhs == null) {
            return 1;
        }
        Identity lhsIdentity = lhs.ice_getIdentity();
        Identity rhsIdentity = rhs.ice_getIdentity();
        int n = lhsIdentity.name.compareTo(rhsIdentity.name);
        if (n != 0) {
            return n;
        }
        return lhsIdentity.category.compareTo(rhsIdentity.category);
    }

    public static int proxyIdentityAndFacetCompare(ObjectPrx lhs, ObjectPrx rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null && rhs != null) {
            return -1;
        }
        if (lhs != null && rhs == null) {
            return 1;
        }
        Identity lhsIdentity = lhs.ice_getIdentity();
        Identity rhsIdentity = rhs.ice_getIdentity();
        int n = lhsIdentity.name.compareTo(rhsIdentity.name);
        if (n != 0) {
            return n;
        }
        n = lhsIdentity.category.compareTo(rhsIdentity.category);
        if (n != 0) {
            return n;
        }
        String lhsFacet = lhs.ice_getFacet();
        String rhsFacet = rhs.ice_getFacet();
        if (lhsFacet == null && rhsFacet == null) {
            return 0;
        }
        if (lhsFacet == null) {
            return -1;
        }
        if (rhsFacet == null) {
            return 1;
        }
        return lhsFacet.compareTo(rhsFacet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getProcessLogger() {
        Object object = _processLoggerMutex;
        synchronized (object) {
            if (_processLogger == null) {
                _processLogger = new LoggerI("", "");
            }
            return _processLogger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProcessLogger(Logger logger) {
        Object object = _processLoggerMutex;
        synchronized (object) {
            _processLogger = logger;
        }
    }

    public static String stringVersion() {
        return "3.7.10";
    }

    public static int intVersion() {
        return 30710;
    }

    public static ProtocolVersion stringToProtocolVersion(String version) {
        return new ProtocolVersion(Util.stringToMajor(version), Util.stringToMinor(version));
    }

    public static EncodingVersion stringToEncodingVersion(String version) {
        return new EncodingVersion(Util.stringToMajor(version), Util.stringToMinor(version));
    }

    public static String protocolVersionToString(ProtocolVersion v) {
        return Util.majorMinorToString(v.major, v.minor);
    }

    public static String encodingVersionToString(EncodingVersion v) {
        return Util.majorMinorToString(v.major, v.minor);
    }

    public static ProtocolVersion currentProtocol() {
        return Protocol.currentProtocol.clone();
    }

    public static EncodingVersion currentEncoding() {
        return Protocol.currentEncoding.clone();
    }

    public static <T> InvocationFuture<T> getInvocationFuture(CompletableFuture<T> f) {
        if (!(f instanceof InvocationFuture)) {
            throw new IllegalArgumentException("future did not originate from an asynchronous proxy invocation");
        }
        return (InvocationFuture)f;
    }

    public static String typeIdToClass(String id) {
        if (!id.startsWith("::")) {
            return null;
        }
        StringBuilder buf = new StringBuilder(id.length());
        for (int i = 0; i < _iceTypeIdPrefixes.length; ++i) {
            if (!id.startsWith(_iceTypeIdPrefixes[i])) continue;
            buf.append("com.zeroc");
            break;
        }
        int start = 2;
        boolean done = false;
        while (!done) {
            String s;
            int end = id.indexOf(58, start);
            if (end != -1) {
                s = id.substring(start, end);
                start = end + 2;
            } else {
                s = id.substring(start);
                done = true;
            }
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(Util.fixKwd(s));
        }
        return buf.toString();
    }

    private static String fixKwd(String name) {
        Object[] keywordList = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "checkedCast", "class", "clone", "const", "continue", "default", "do", "double", "else", "enum", "equals", "extends", "false", "final", "finalize", "finally", "float", "for", "getClass", "goto", "hashCode", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "notify", "notifyAll", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "toString", "transient", "true", "try", "uncheckedCast", "void", "volatile", "wait", "while"};
        boolean found = Arrays.binarySearch(keywordList, name) >= 0;
        return found ? "_" + name : name;
    }

    private static byte stringToMajor(String str) {
        int majVersion;
        int pos = str.indexOf(46);
        if (pos == -1) {
            throw new VersionParseException("malformed version value `" + str + "'");
        }
        String majStr = str.substring(0, pos);
        try {
            majVersion = Integer.parseInt(majStr);
        }
        catch (NumberFormatException ex) {
            throw new VersionParseException("invalid version value `" + str + "'");
        }
        if (majVersion < 1 || majVersion > 255) {
            throw new VersionParseException("range error in version `" + str + "'");
        }
        return (byte)majVersion;
    }

    private static byte stringToMinor(String str) {
        int minVersion;
        int pos = str.indexOf(46);
        if (pos == -1) {
            throw new VersionParseException("malformed version value `" + str + "'");
        }
        String minStr = str.substring(pos + 1, str.length());
        try {
            minVersion = Integer.parseInt(minStr);
        }
        catch (NumberFormatException ex) {
            throw new VersionParseException("invalid version value `" + str + "'");
        }
        if (minVersion < 0 || minVersion > 255) {
            throw new VersionParseException("range error in version `" + str + "'");
        }
        return (byte)minVersion;
    }

    private static String majorMinorToString(byte major, byte minor) {
        StringBuilder str = new StringBuilder();
        str.append(major < 0 ? major + 255 : major);
        str.append(".");
        str.append(minor < 0 ? minor + 255 : minor);
        return str.toString();
    }
}

