---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              accents mathématiques, grands accents, chapeau, 
              accolade horizontale, barre horizontale
---

# Comment obtenir les accents mathématiques standards ?

Il existe par défaut dix accents mathématiques pour des lettres isolées 
(qui s'obtiennent tous en [mode mathématique](../passer_en_mode_mathematique)).
Ils sont illustrés dans l'exemple suivant :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[
  \hat{a}      +  \check{a} 
  + \breve{a}  +  \acute{a}
  + \grave{a}  +  \tilde{a}
  + \bar{a}    +  \vec{a}
  + \dot{a}    +  \ddot{a} = 0
\]
\end{document}
```

Dans le cas particulier des lettres **i** et **j**, il faut utiliser, 
toujours en mode mathématique, les commandes `\imath` et `\jmath` 
qui permettent de supprimer le point par défaut :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Notez que $i$ n'est pas $\imath$ et encore moins $\tilde{\imath}$.

Et constatez que $j$ n'est pas $\jmath$ et toujours pas $\ddot{\jmath}$.
\end{document}
```

Des accents mathématiques associables à un ensemble de lettres 
(et donc redimensionnables) sont également disponibles, comme l'illustre 
l'exemple suivant :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[
  \widehat{abc}           +  \widetilde{def}
  + \overrightarrow{ghi}  +  \overline{jkl}
  + \underline{mno}       +  \overbrace{pqr}
  + \underbrace{stu} = 0
\]
\end{document}
```

La question 
"[](/4_domaines_specialises/mathematiques/structures/accolade_horizontale)" 
illustre une fonctionnalité proche de ce sujet. 