// This is an auto-generated file.
// Any changs to this file will be overwritten

namespace Akonadi {
namespace Protocol {

int version()
{
    return 58;
}

void serialize(QIODevice *device, const CommandPtr &cmd)
{
    DataStream stream(device);
    switch (static_cast<int>(cmd->type() | (cmd->isResponse() ? Command::_ResponseBit : 0))) {
    case Command::Invalid:
        stream << cmdCast<Command>(cmd);
        break;
    case Command::Invalid | Command::_ResponseBit:
        stream << cmdCast<Response>(cmd);
        break;
    case Command::Hello | Command::_ResponseBit:
        stream << cmdCast<HelloResponse>(cmd);
        break;
    case Command::Login:
        stream << cmdCast<LoginCommand>(cmd);
        break;
    case Command::Login | Command::_ResponseBit:
        stream << cmdCast<LoginResponse>(cmd);
        break;
    case Command::Logout:
        stream << cmdCast<LogoutCommand>(cmd);
        break;
    case Command::Logout | Command::_ResponseBit:
        stream << cmdCast<LogoutResponse>(cmd);
        break;
    case Command::Transaction:
        stream << cmdCast<TransactionCommand>(cmd);
        break;
    case Command::Transaction | Command::_ResponseBit:
        stream << cmdCast<TransactionResponse>(cmd);
        break;
    case Command::CreateItem:
        stream << cmdCast<CreateItemCommand>(cmd);
        break;
    case Command::CreateItem | Command::_ResponseBit:
        stream << cmdCast<CreateItemResponse>(cmd);
        break;
    case Command::CopyItems:
        stream << cmdCast<CopyItemsCommand>(cmd);
        break;
    case Command::CopyItems | Command::_ResponseBit:
        stream << cmdCast<CopyItemsResponse>(cmd);
        break;
    case Command::DeleteItems:
        stream << cmdCast<DeleteItemsCommand>(cmd);
        break;
    case Command::DeleteItems | Command::_ResponseBit:
        stream << cmdCast<DeleteItemsResponse>(cmd);
        break;
    case Command::FetchRelations:
        stream << cmdCast<FetchRelationsCommand>(cmd);
        break;
    case Command::FetchRelations | Command::_ResponseBit:
        stream << cmdCast<FetchRelationsResponse>(cmd);
        break;
    case Command::FetchTags:
        stream << cmdCast<FetchTagsCommand>(cmd);
        break;
    case Command::FetchTags | Command::_ResponseBit:
        stream << cmdCast<FetchTagsResponse>(cmd);
        break;
    case Command::FetchItems:
        stream << cmdCast<FetchItemsCommand>(cmd);
        break;
    case Command::FetchItems | Command::_ResponseBit:
        stream << cmdCast<FetchItemsResponse>(cmd);
        break;
    case Command::LinkItems:
        stream << cmdCast<LinkItemsCommand>(cmd);
        break;
    case Command::LinkItems | Command::_ResponseBit:
        stream << cmdCast<LinkItemsResponse>(cmd);
        break;
    case Command::ModifyItems:
        stream << cmdCast<ModifyItemsCommand>(cmd);
        break;
    case Command::ModifyItems | Command::_ResponseBit:
        stream << cmdCast<ModifyItemsResponse>(cmd);
        break;
    case Command::MoveItems:
        stream << cmdCast<MoveItemsCommand>(cmd);
        break;
    case Command::MoveItems | Command::_ResponseBit:
        stream << cmdCast<MoveItemsResponse>(cmd);
        break;
    case Command::CreateCollection:
        stream << cmdCast<CreateCollectionCommand>(cmd);
        break;
    case Command::CreateCollection | Command::_ResponseBit:
        stream << cmdCast<CreateCollectionResponse>(cmd);
        break;
    case Command::CopyCollection:
        stream << cmdCast<CopyCollectionCommand>(cmd);
        break;
    case Command::CopyCollection | Command::_ResponseBit:
        stream << cmdCast<CopyCollectionResponse>(cmd);
        break;
    case Command::DeleteCollection:
        stream << cmdCast<DeleteCollectionCommand>(cmd);
        break;
    case Command::DeleteCollection | Command::_ResponseBit:
        stream << cmdCast<DeleteCollectionResponse>(cmd);
        break;
    case Command::FetchCollectionStats:
        stream << cmdCast<FetchCollectionStatsCommand>(cmd);
        break;
    case Command::FetchCollectionStats | Command::_ResponseBit:
        stream << cmdCast<FetchCollectionStatsResponse>(cmd);
        break;
    case Command::FetchCollections:
        stream << cmdCast<FetchCollectionsCommand>(cmd);
        break;
    case Command::FetchCollections | Command::_ResponseBit:
        stream << cmdCast<FetchCollectionsResponse>(cmd);
        break;
    case Command::ModifyCollection:
        stream << cmdCast<ModifyCollectionCommand>(cmd);
        break;
    case Command::ModifyCollection | Command::_ResponseBit:
        stream << cmdCast<ModifyCollectionResponse>(cmd);
        break;
    case Command::MoveCollection:
        stream << cmdCast<MoveCollectionCommand>(cmd);
        break;
    case Command::MoveCollection | Command::_ResponseBit:
        stream << cmdCast<MoveCollectionResponse>(cmd);
        break;
    case Command::Search:
        stream << cmdCast<SearchCommand>(cmd);
        break;
    case Command::Search | Command::_ResponseBit:
        stream << cmdCast<SearchResponse>(cmd);
        break;
    case Command::SearchResult:
        stream << cmdCast<SearchResultCommand>(cmd);
        break;
    case Command::SearchResult | Command::_ResponseBit:
        stream << cmdCast<SearchResultResponse>(cmd);
        break;
    case Command::StoreSearch:
        stream << cmdCast<StoreSearchCommand>(cmd);
        break;
    case Command::StoreSearch | Command::_ResponseBit:
        stream << cmdCast<StoreSearchResponse>(cmd);
        break;
    case Command::CreateTag:
        stream << cmdCast<CreateTagCommand>(cmd);
        break;
    case Command::CreateTag | Command::_ResponseBit:
        stream << cmdCast<CreateTagResponse>(cmd);
        break;
    case Command::DeleteTag:
        stream << cmdCast<DeleteTagCommand>(cmd);
        break;
    case Command::DeleteTag | Command::_ResponseBit:
        stream << cmdCast<DeleteTagResponse>(cmd);
        break;
    case Command::ModifyTag:
        stream << cmdCast<ModifyTagCommand>(cmd);
        break;
    case Command::ModifyTag | Command::_ResponseBit:
        stream << cmdCast<ModifyTagResponse>(cmd);
        break;
    case Command::ModifyRelation:
        stream << cmdCast<ModifyRelationCommand>(cmd);
        break;
    case Command::ModifyRelation | Command::_ResponseBit:
        stream << cmdCast<ModifyRelationResponse>(cmd);
        break;
    case Command::RemoveRelations:
        stream << cmdCast<RemoveRelationsCommand>(cmd);
        break;
    case Command::RemoveRelations | Command::_ResponseBit:
        stream << cmdCast<RemoveRelationsResponse>(cmd);
        break;
    case Command::SelectResource:
        stream << cmdCast<SelectResourceCommand>(cmd);
        break;
    case Command::SelectResource | Command::_ResponseBit:
        stream << cmdCast<SelectResourceResponse>(cmd);
        break;
    case Command::StreamPayload:
        stream << cmdCast<StreamPayloadCommand>(cmd);
        break;
    case Command::StreamPayload | Command::_ResponseBit:
        stream << cmdCast<StreamPayloadResponse>(cmd);
        break;
    case Command::ItemChangeNotification:
        stream << cmdCast<ItemChangeNotification>(cmd);
        break;
    case Command::CollectionChangeNotification:
        stream << cmdCast<CollectionChangeNotification>(cmd);
        break;
    case Command::TagChangeNotification:
        stream << cmdCast<TagChangeNotification>(cmd);
        break;
    case Command::RelationChangeNotification:
        stream << cmdCast<RelationChangeNotification>(cmd);
        break;
    case Command::CreateSubscription:
        stream << cmdCast<CreateSubscriptionCommand>(cmd);
        break;
    case Command::CreateSubscription | Command::_ResponseBit:
        stream << cmdCast<CreateSubscriptionResponse>(cmd);
        break;
    case Command::ModifySubscription:
        stream << cmdCast<ModifySubscriptionCommand>(cmd);
        break;
    case Command::ModifySubscription | Command::_ResponseBit:
        stream << cmdCast<ModifySubscriptionResponse>(cmd);
        break;
    case Command::SubscriptionChangeNotification:
        stream << cmdCast<SubscriptionChangeNotification>(cmd);
        break;
    case Command::DebugChangeNotification:
        stream << cmdCast<DebugChangeNotification>(cmd);
        break;
    }
}

CommandPtr deserialize(QIODevice *device)
{
    DataStream stream(device);
    stream.waitForData(sizeof(Command::Type));
    Command::Type cmdType;
    if (Q_UNLIKELY(device->peek((char *) &cmdType, sizeof(Command::Type)) != sizeof(Command::Type))) {
        throw ProtocolException("Failed to peek command type");
    }
    CommandPtr cmd;
    if (cmdType & Command::_ResponseBit) {
        cmd = Factory::response(Command::Type(cmdType & ~Command::_ResponseBit));
    } else {
        cmd = Factory::command(cmdType);
    }

    switch (static_cast<int>(cmdType)) {
    case Command::Invalid:
        stream >> cmdCast<Command>(cmd);
        return cmd;
    case Command::Invalid | Command::_ResponseBit:
        stream >> cmdCast<Response>(cmd);
        return cmd;
    case Command::Hello | Command::_ResponseBit:
        stream >> cmdCast<HelloResponse>(cmd);
        return cmd;
    case Command::Login:
        stream >> cmdCast<LoginCommand>(cmd);
        return cmd;
    case Command::Login | Command::_ResponseBit:
        stream >> cmdCast<LoginResponse>(cmd);
        return cmd;
    case Command::Logout:
        stream >> cmdCast<LogoutCommand>(cmd);
        return cmd;
    case Command::Logout | Command::_ResponseBit:
        stream >> cmdCast<LogoutResponse>(cmd);
        return cmd;
    case Command::Transaction:
        stream >> cmdCast<TransactionCommand>(cmd);
        return cmd;
    case Command::Transaction | Command::_ResponseBit:
        stream >> cmdCast<TransactionResponse>(cmd);
        return cmd;
    case Command::CreateItem:
        stream >> cmdCast<CreateItemCommand>(cmd);
        return cmd;
    case Command::CreateItem | Command::_ResponseBit:
        stream >> cmdCast<CreateItemResponse>(cmd);
        return cmd;
    case Command::CopyItems:
        stream >> cmdCast<CopyItemsCommand>(cmd);
        return cmd;
    case Command::CopyItems | Command::_ResponseBit:
        stream >> cmdCast<CopyItemsResponse>(cmd);
        return cmd;
    case Command::DeleteItems:
        stream >> cmdCast<DeleteItemsCommand>(cmd);
        return cmd;
    case Command::DeleteItems | Command::_ResponseBit:
        stream >> cmdCast<DeleteItemsResponse>(cmd);
        return cmd;
    case Command::FetchRelations:
        stream >> cmdCast<FetchRelationsCommand>(cmd);
        return cmd;
    case Command::FetchRelations | Command::_ResponseBit:
        stream >> cmdCast<FetchRelationsResponse>(cmd);
        return cmd;
    case Command::FetchTags:
        stream >> cmdCast<FetchTagsCommand>(cmd);
        return cmd;
    case Command::FetchTags | Command::_ResponseBit:
        stream >> cmdCast<FetchTagsResponse>(cmd);
        return cmd;
    case Command::FetchItems:
        stream >> cmdCast<FetchItemsCommand>(cmd);
        return cmd;
    case Command::FetchItems | Command::_ResponseBit:
        stream >> cmdCast<FetchItemsResponse>(cmd);
        return cmd;
    case Command::LinkItems:
        stream >> cmdCast<LinkItemsCommand>(cmd);
        return cmd;
    case Command::LinkItems | Command::_ResponseBit:
        stream >> cmdCast<LinkItemsResponse>(cmd);
        return cmd;
    case Command::ModifyItems:
        stream >> cmdCast<ModifyItemsCommand>(cmd);
        return cmd;
    case Command::ModifyItems | Command::_ResponseBit:
        stream >> cmdCast<ModifyItemsResponse>(cmd);
        return cmd;
    case Command::MoveItems:
        stream >> cmdCast<MoveItemsCommand>(cmd);
        return cmd;
    case Command::MoveItems | Command::_ResponseBit:
        stream >> cmdCast<MoveItemsResponse>(cmd);
        return cmd;
    case Command::CreateCollection:
        stream >> cmdCast<CreateCollectionCommand>(cmd);
        return cmd;
    case Command::CreateCollection | Command::_ResponseBit:
        stream >> cmdCast<CreateCollectionResponse>(cmd);
        return cmd;
    case Command::CopyCollection:
        stream >> cmdCast<CopyCollectionCommand>(cmd);
        return cmd;
    case Command::CopyCollection | Command::_ResponseBit:
        stream >> cmdCast<CopyCollectionResponse>(cmd);
        return cmd;
    case Command::DeleteCollection:
        stream >> cmdCast<DeleteCollectionCommand>(cmd);
        return cmd;
    case Command::DeleteCollection | Command::_ResponseBit:
        stream >> cmdCast<DeleteCollectionResponse>(cmd);
        return cmd;
    case Command::FetchCollectionStats:
        stream >> cmdCast<FetchCollectionStatsCommand>(cmd);
        return cmd;
    case Command::FetchCollectionStats | Command::_ResponseBit:
        stream >> cmdCast<FetchCollectionStatsResponse>(cmd);
        return cmd;
    case Command::FetchCollections:
        stream >> cmdCast<FetchCollectionsCommand>(cmd);
        return cmd;
    case Command::FetchCollections | Command::_ResponseBit:
        stream >> cmdCast<FetchCollectionsResponse>(cmd);
        return cmd;
    case Command::ModifyCollection:
        stream >> cmdCast<ModifyCollectionCommand>(cmd);
        return cmd;
    case Command::ModifyCollection | Command::_ResponseBit:
        stream >> cmdCast<ModifyCollectionResponse>(cmd);
        return cmd;
    case Command::MoveCollection:
        stream >> cmdCast<MoveCollectionCommand>(cmd);
        return cmd;
    case Command::MoveCollection | Command::_ResponseBit:
        stream >> cmdCast<MoveCollectionResponse>(cmd);
        return cmd;
    case Command::Search:
        stream >> cmdCast<SearchCommand>(cmd);
        return cmd;
    case Command::Search | Command::_ResponseBit:
        stream >> cmdCast<SearchResponse>(cmd);
        return cmd;
    case Command::SearchResult:
        stream >> cmdCast<SearchResultCommand>(cmd);
        return cmd;
    case Command::SearchResult | Command::_ResponseBit:
        stream >> cmdCast<SearchResultResponse>(cmd);
        return cmd;
    case Command::StoreSearch:
        stream >> cmdCast<StoreSearchCommand>(cmd);
        return cmd;
    case Command::StoreSearch | Command::_ResponseBit:
        stream >> cmdCast<StoreSearchResponse>(cmd);
        return cmd;
    case Command::CreateTag:
        stream >> cmdCast<CreateTagCommand>(cmd);
        return cmd;
    case Command::CreateTag | Command::_ResponseBit:
        stream >> cmdCast<CreateTagResponse>(cmd);
        return cmd;
    case Command::DeleteTag:
        stream >> cmdCast<DeleteTagCommand>(cmd);
        return cmd;
    case Command::DeleteTag | Command::_ResponseBit:
        stream >> cmdCast<DeleteTagResponse>(cmd);
        return cmd;
    case Command::ModifyTag:
        stream >> cmdCast<ModifyTagCommand>(cmd);
        return cmd;
    case Command::ModifyTag | Command::_ResponseBit:
        stream >> cmdCast<ModifyTagResponse>(cmd);
        return cmd;
    case Command::ModifyRelation:
        stream >> cmdCast<ModifyRelationCommand>(cmd);
        return cmd;
    case Command::ModifyRelation | Command::_ResponseBit:
        stream >> cmdCast<ModifyRelationResponse>(cmd);
        return cmd;
    case Command::RemoveRelations:
        stream >> cmdCast<RemoveRelationsCommand>(cmd);
        return cmd;
    case Command::RemoveRelations | Command::_ResponseBit:
        stream >> cmdCast<RemoveRelationsResponse>(cmd);
        return cmd;
    case Command::SelectResource:
        stream >> cmdCast<SelectResourceCommand>(cmd);
        return cmd;
    case Command::SelectResource | Command::_ResponseBit:
        stream >> cmdCast<SelectResourceResponse>(cmd);
        return cmd;
    case Command::StreamPayload:
        stream >> cmdCast<StreamPayloadCommand>(cmd);
        return cmd;
    case Command::StreamPayload | Command::_ResponseBit:
        stream >> cmdCast<StreamPayloadResponse>(cmd);
        return cmd;
    case Command::ItemChangeNotification:
        stream >> cmdCast<ItemChangeNotification>(cmd);
        return cmd;
    case Command::CollectionChangeNotification:
        stream >> cmdCast<CollectionChangeNotification>(cmd);
        return cmd;
    case Command::TagChangeNotification:
        stream >> cmdCast<TagChangeNotification>(cmd);
        return cmd;
    case Command::RelationChangeNotification:
        stream >> cmdCast<RelationChangeNotification>(cmd);
        return cmd;
    case Command::CreateSubscription:
        stream >> cmdCast<CreateSubscriptionCommand>(cmd);
        return cmd;
    case Command::CreateSubscription | Command::_ResponseBit:
        stream >> cmdCast<CreateSubscriptionResponse>(cmd);
        return cmd;
    case Command::ModifySubscription:
        stream >> cmdCast<ModifySubscriptionCommand>(cmd);
        return cmd;
    case Command::ModifySubscription | Command::_ResponseBit:
        stream >> cmdCast<ModifySubscriptionResponse>(cmd);
        return cmd;
    case Command::SubscriptionChangeNotification:
        stream >> cmdCast<SubscriptionChangeNotification>(cmd);
        return cmd;
    case Command::DebugChangeNotification:
        stream >> cmdCast<DebugChangeNotification>(cmd);
        return cmd;
    }
    return CommandPtr::create();
}

QString debugString(const Command &cmd)
{
    QString out;
    switch (static_cast<int>(cmd.type() | (cmd.isResponse() ? Command::_ResponseBit : 0))) {
    case Command::Invalid:
        QDebug(&out).noquote() << static_cast<const Command &>(cmd);
        return out;
    case Command::Invalid | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const Response &>(cmd);
        return out;
    case Command::Hello | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const HelloResponse &>(cmd);
        return out;
    case Command::Login:
        QDebug(&out).noquote() << static_cast<const LoginCommand &>(cmd);
        return out;
    case Command::Login | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const LoginResponse &>(cmd);
        return out;
    case Command::Logout:
        QDebug(&out).noquote() << static_cast<const LogoutCommand &>(cmd);
        return out;
    case Command::Logout | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const LogoutResponse &>(cmd);
        return out;
    case Command::Transaction:
        QDebug(&out).noquote() << static_cast<const TransactionCommand &>(cmd);
        return out;
    case Command::Transaction | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const TransactionResponse &>(cmd);
        return out;
    case Command::CreateItem:
        QDebug(&out).noquote() << static_cast<const CreateItemCommand &>(cmd);
        return out;
    case Command::CreateItem | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CreateItemResponse &>(cmd);
        return out;
    case Command::CopyItems:
        QDebug(&out).noquote() << static_cast<const CopyItemsCommand &>(cmd);
        return out;
    case Command::CopyItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CopyItemsResponse &>(cmd);
        return out;
    case Command::DeleteItems:
        QDebug(&out).noquote() << static_cast<const DeleteItemsCommand &>(cmd);
        return out;
    case Command::DeleteItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const DeleteItemsResponse &>(cmd);
        return out;
    case Command::FetchRelations:
        QDebug(&out).noquote() << static_cast<const FetchRelationsCommand &>(cmd);
        return out;
    case Command::FetchRelations | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const FetchRelationsResponse &>(cmd);
        return out;
    case Command::FetchTags:
        QDebug(&out).noquote() << static_cast<const FetchTagsCommand &>(cmd);
        return out;
    case Command::FetchTags | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const FetchTagsResponse &>(cmd);
        return out;
    case Command::FetchItems:
        QDebug(&out).noquote() << static_cast<const FetchItemsCommand &>(cmd);
        return out;
    case Command::FetchItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const FetchItemsResponse &>(cmd);
        return out;
    case Command::LinkItems:
        QDebug(&out).noquote() << static_cast<const LinkItemsCommand &>(cmd);
        return out;
    case Command::LinkItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const LinkItemsResponse &>(cmd);
        return out;
    case Command::ModifyItems:
        QDebug(&out).noquote() << static_cast<const ModifyItemsCommand &>(cmd);
        return out;
    case Command::ModifyItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const ModifyItemsResponse &>(cmd);
        return out;
    case Command::MoveItems:
        QDebug(&out).noquote() << static_cast<const MoveItemsCommand &>(cmd);
        return out;
    case Command::MoveItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const MoveItemsResponse &>(cmd);
        return out;
    case Command::CreateCollection:
        QDebug(&out).noquote() << static_cast<const CreateCollectionCommand &>(cmd);
        return out;
    case Command::CreateCollection | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CreateCollectionResponse &>(cmd);
        return out;
    case Command::CopyCollection:
        QDebug(&out).noquote() << static_cast<const CopyCollectionCommand &>(cmd);
        return out;
    case Command::CopyCollection | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CopyCollectionResponse &>(cmd);
        return out;
    case Command::DeleteCollection:
        QDebug(&out).noquote() << static_cast<const DeleteCollectionCommand &>(cmd);
        return out;
    case Command::DeleteCollection | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const DeleteCollectionResponse &>(cmd);
        return out;
    case Command::FetchCollectionStats:
        QDebug(&out).noquote() << static_cast<const FetchCollectionStatsCommand &>(cmd);
        return out;
    case Command::FetchCollectionStats | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const FetchCollectionStatsResponse &>(cmd);
        return out;
    case Command::FetchCollections:
        QDebug(&out).noquote() << static_cast<const FetchCollectionsCommand &>(cmd);
        return out;
    case Command::FetchCollections | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const FetchCollectionsResponse &>(cmd);
        return out;
    case Command::ModifyCollection:
        QDebug(&out).noquote() << static_cast<const ModifyCollectionCommand &>(cmd);
        return out;
    case Command::ModifyCollection | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const ModifyCollectionResponse &>(cmd);
        return out;
    case Command::MoveCollection:
        QDebug(&out).noquote() << static_cast<const MoveCollectionCommand &>(cmd);
        return out;
    case Command::MoveCollection | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const MoveCollectionResponse &>(cmd);
        return out;
    case Command::Search:
        QDebug(&out).noquote() << static_cast<const SearchCommand &>(cmd);
        return out;
    case Command::Search | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const SearchResponse &>(cmd);
        return out;
    case Command::SearchResult:
        QDebug(&out).noquote() << static_cast<const SearchResultCommand &>(cmd);
        return out;
    case Command::SearchResult | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const SearchResultResponse &>(cmd);
        return out;
    case Command::StoreSearch:
        QDebug(&out).noquote() << static_cast<const StoreSearchCommand &>(cmd);
        return out;
    case Command::StoreSearch | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const StoreSearchResponse &>(cmd);
        return out;
    case Command::CreateTag:
        QDebug(&out).noquote() << static_cast<const CreateTagCommand &>(cmd);
        return out;
    case Command::CreateTag | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CreateTagResponse &>(cmd);
        return out;
    case Command::DeleteTag:
        QDebug(&out).noquote() << static_cast<const DeleteTagCommand &>(cmd);
        return out;
    case Command::DeleteTag | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const DeleteTagResponse &>(cmd);
        return out;
    case Command::ModifyTag:
        QDebug(&out).noquote() << static_cast<const ModifyTagCommand &>(cmd);
        return out;
    case Command::ModifyTag | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const ModifyTagResponse &>(cmd);
        return out;
    case Command::ModifyRelation:
        QDebug(&out).noquote() << static_cast<const ModifyRelationCommand &>(cmd);
        return out;
    case Command::ModifyRelation | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const ModifyRelationResponse &>(cmd);
        return out;
    case Command::RemoveRelations:
        QDebug(&out).noquote() << static_cast<const RemoveRelationsCommand &>(cmd);
        return out;
    case Command::RemoveRelations | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const RemoveRelationsResponse &>(cmd);
        return out;
    case Command::SelectResource:
        QDebug(&out).noquote() << static_cast<const SelectResourceCommand &>(cmd);
        return out;
    case Command::SelectResource | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const SelectResourceResponse &>(cmd);
        return out;
    case Command::StreamPayload:
        QDebug(&out).noquote() << static_cast<const StreamPayloadCommand &>(cmd);
        return out;
    case Command::StreamPayload | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const StreamPayloadResponse &>(cmd);
        return out;
    case Command::ItemChangeNotification:
        QDebug(&out).noquote() << static_cast<const ItemChangeNotification &>(cmd);
        return out;
    case Command::CollectionChangeNotification:
        QDebug(&out).noquote() << static_cast<const CollectionChangeNotification &>(cmd);
        return out;
    case Command::TagChangeNotification:
        QDebug(&out).noquote() << static_cast<const TagChangeNotification &>(cmd);
        return out;
    case Command::RelationChangeNotification:
        QDebug(&out).noquote() << static_cast<const RelationChangeNotification &>(cmd);
        return out;
    case Command::CreateSubscription:
        QDebug(&out).noquote() << static_cast<const CreateSubscriptionCommand &>(cmd);
        return out;
    case Command::CreateSubscription | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CreateSubscriptionResponse &>(cmd);
        return out;
    case Command::ModifySubscription:
        QDebug(&out).noquote() << static_cast<const ModifySubscriptionCommand &>(cmd);
        return out;
    case Command::ModifySubscription | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const ModifySubscriptionResponse &>(cmd);
        return out;
    case Command::SubscriptionChangeNotification:
        QDebug(&out).noquote() << static_cast<const SubscriptionChangeNotification &>(cmd);
        return out;
    case Command::DebugChangeNotification:
        QDebug(&out).noquote() << static_cast<const DebugChangeNotification &>(cmd);
        return out;
    }
    return QString();
}



/************************* Ancestor *************************/

Ancestor::Ancestor()
    : mId(-1)
{
}

Ancestor::Ancestor(qint64 id, const QString &remoteId)
    : mId(id)
    , mRemoteId(remoteId)
{
}

Ancestor::Ancestor(const Ancestor&other)
    : mId(other.mId)
    , mRemoteId(other.mRemoteId)
    , mName(other.mName)
    , mAttributes(other.mAttributes)
{
}

Ancestor::~Ancestor()
{
}

Ancestor &Ancestor::operator=(const Ancestor &other)
{
    mId = other.mId;
    mRemoteId = other.mRemoteId;
    mName = other.mName;
    mAttributes = other.mAttributes;
    return *this;
}

bool Ancestor::operator==(const Ancestor &other) const
{
    return true // simplifies generation
        && mId == other.mId
        && mRemoteId == other.mRemoteId
        && mName == other.mName
        && mAttributes == other.mAttributes
    ;
}

DataStream &operator<<(DataStream &stream, const Ancestor &obj)
{
    stream << obj.mId;
    stream << obj.mRemoteId;
    stream << obj.mName;
    stream << obj.mAttributes;
    return stream;
}

DataStream &operator>>(DataStream &stream, Ancestor &obj)
{
    stream >> obj.mId;
    stream >> obj.mRemoteId;
    stream >> obj.mName;
    stream >> obj.mAttributes;
    return stream;
}

QDebug operator<<(QDebug dbg, const Ancestor &obj)
{
    return dbg.noquote()
        << "id:" << obj.mId << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "name:" << obj.mName << "\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
}



/************************* PartMetaData *************************/

PartMetaData::PartMetaData()
    : mSize(0)
    , mVersion(0)
    , mStorageType(Internal)
{
}

PartMetaData::PartMetaData(const QByteArray &name, qint64 size, int version, const PartMetaData::StorageType &storageType)
    : mName(name)
    , mSize(size)
    , mVersion(version)
    , mStorageType(storageType)
{
}

PartMetaData::PartMetaData(const PartMetaData&other)
    : mName(other.mName)
    , mSize(other.mSize)
    , mVersion(other.mVersion)
    , mStorageType(other.mStorageType)
{
}

PartMetaData::~PartMetaData()
{
}

PartMetaData &PartMetaData::operator=(const PartMetaData &other)
{
    mName = other.mName;
    mSize = other.mSize;
    mVersion = other.mVersion;
    mStorageType = other.mStorageType;
    return *this;
}

bool PartMetaData::operator==(const PartMetaData &other) const
{
    return true // simplifies generation
        && mName == other.mName
        && mSize == other.mSize
        && mVersion == other.mVersion
        && mStorageType == other.mStorageType
    ;
}

DataStream &operator<<(DataStream &stream, const PartMetaData &obj)
{
    stream << obj.mName;
    stream << obj.mSize;
    stream << obj.mVersion;
    stream << obj.mStorageType;
    return stream;
}

DataStream &operator>>(DataStream &stream, PartMetaData &obj)
{
    stream >> obj.mName;
    stream >> obj.mSize;
    stream >> obj.mVersion;
    stream >> obj.mStorageType;
    return stream;
}

QDebug operator<<(QDebug dbg, const PartMetaData &obj)
{
    return dbg.noquote()
        << "name:" << obj.mName << "\n"
        << "size:" << obj.mSize << "\n"
        << "version:" << obj.mVersion << "\n"
        << "storageType:" << obj.mStorageType << "\n"
    ;
}



/************************* CachePolicy *************************/

CachePolicy::CachePolicy()
    : mCheckInterval(-1)
    , mCacheTimeout(-1)
    , mInherit(true)
    , mSyncOnDemand(false)
{
}

CachePolicy::CachePolicy(const CachePolicy&other)
    : mLocalParts(other.mLocalParts)
    , mCheckInterval(other.mCheckInterval)
    , mCacheTimeout(other.mCacheTimeout)
    , mInherit(other.mInherit)
    , mSyncOnDemand(other.mSyncOnDemand)
{
}

CachePolicy::~CachePolicy()
{
}

CachePolicy &CachePolicy::operator=(const CachePolicy &other)
{
    mLocalParts = other.mLocalParts;
    mCheckInterval = other.mCheckInterval;
    mCacheTimeout = other.mCacheTimeout;
    mInherit = other.mInherit;
    mSyncOnDemand = other.mSyncOnDemand;
    return *this;
}

bool CachePolicy::operator==(const CachePolicy &other) const
{
    return true // simplifies generation
        && mLocalParts == other.mLocalParts
        && mCheckInterval == other.mCheckInterval
        && mCacheTimeout == other.mCacheTimeout
        && mInherit == other.mInherit
        && mSyncOnDemand == other.mSyncOnDemand
    ;
}

DataStream &operator<<(DataStream &stream, const CachePolicy &obj)
{
    stream << obj.mLocalParts;
    stream << obj.mCheckInterval;
    stream << obj.mCacheTimeout;
    stream << obj.mInherit;
    stream << obj.mSyncOnDemand;
    return stream;
}

DataStream &operator>>(DataStream &stream, CachePolicy &obj)
{
    stream >> obj.mLocalParts;
    stream >> obj.mCheckInterval;
    stream >> obj.mCacheTimeout;
    stream >> obj.mInherit;
    stream >> obj.mSyncOnDemand;
    return stream;
}

QDebug operator<<(QDebug dbg, const CachePolicy &obj)
{
    return dbg.noquote()
        << "localParts:" << obj.mLocalParts << "\n"
        << "checkInterval:" << obj.mCheckInterval << "\n"
        << "cacheTimeout:" << obj.mCacheTimeout << "\n"
        << "inherit:" << obj.mInherit << "\n"
        << "syncOnDemand:" << obj.mSyncOnDemand << "\n"
    ;
}



/************************* HelloResponse *************************/

HelloResponse::HelloResponse()
    : Response(Command::Hello)
    , mProtocolVersion(0)
    , mGeneration(0)
{
}

HelloResponse::HelloResponse(const HelloResponse&other)
    : Response(other)
    , mServerName(other.mServerName)
    , mMessage(other.mMessage)
    , mProtocolVersion(other.mProtocolVersion)
    , mGeneration(other.mGeneration)
{
}

HelloResponse::~HelloResponse()
{
}

HelloResponse &HelloResponse::operator=(const HelloResponse &other)
{
    Response::operator=(other);
    mServerName = other.mServerName;
    mMessage = other.mMessage;
    mProtocolVersion = other.mProtocolVersion;
    mGeneration = other.mGeneration;
    return *this;
}

bool HelloResponse::operator==(const HelloResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mServerName == other.mServerName
        && mMessage == other.mMessage
        && mProtocolVersion == other.mProtocolVersion
        && mGeneration == other.mGeneration
    ;
}

DataStream &operator<<(DataStream &stream, const HelloResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mServerName;
    stream << obj.mMessage;
    stream << obj.mProtocolVersion;
    stream << obj.mGeneration;
    return stream;
}

DataStream &operator>>(DataStream &stream, HelloResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mServerName;
    stream >> obj.mMessage;
    stream >> obj.mProtocolVersion;
    stream >> obj.mGeneration;
    return stream;
}

QDebug operator<<(QDebug dbg, const HelloResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
        << "serverName:" << obj.mServerName << "\n"
        << "message:" << obj.mMessage << "\n"
        << "protocolVersion:" << obj.mProtocolVersion << "\n"
        << "generation:" << obj.mGeneration << "\n"
    ;
}



/************************* LoginCommand *************************/

LoginCommand::LoginCommand()
    : Command(Command::Login)
{
}

LoginCommand::LoginCommand(const QByteArray &sessionId)
    : Command(Command::Login)
    , mSessionId(sessionId)
{
}

LoginCommand::LoginCommand(const LoginCommand&other)
    : Command(other)
    , mSessionId(other.mSessionId)
{
}

LoginCommand::~LoginCommand()
{
}

LoginCommand &LoginCommand::operator=(const LoginCommand &other)
{
    Command::operator=(other);
    mSessionId = other.mSessionId;
    return *this;
}

bool LoginCommand::operator==(const LoginCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mSessionId == other.mSessionId
    ;
}

DataStream &operator<<(DataStream &stream, const LoginCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mSessionId;
    return stream;
}

DataStream &operator>>(DataStream &stream, LoginCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mSessionId;
    return stream;
}

QDebug operator<<(QDebug dbg, const LoginCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "sessionId:" << obj.mSessionId << "\n"
    ;
}



/************************* LoginResponse *************************/

LoginResponse::LoginResponse()
    : Response(Command::Login)
{
}

LoginResponse::LoginResponse(const LoginResponse&other)
    : Response(other)
{
}

LoginResponse::~LoginResponse()
{
}

LoginResponse &LoginResponse::operator=(const LoginResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool LoginResponse::operator==(const LoginResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const LoginResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, LoginResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const LoginResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* LogoutCommand *************************/

LogoutCommand::LogoutCommand()
    : Command(Command::Logout)
{
}

LogoutCommand::LogoutCommand(const LogoutCommand&other)
    : Command(other)
{
}

LogoutCommand::~LogoutCommand()
{
}

LogoutCommand &LogoutCommand::operator=(const LogoutCommand &other)
{
    Command::operator=(other);
    return *this;
}

bool LogoutCommand::operator==(const LogoutCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const LogoutCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, LogoutCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const LogoutCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
    ;
}



/************************* LogoutResponse *************************/

LogoutResponse::LogoutResponse()
    : Response(Command::Logout)
{
}

LogoutResponse::LogoutResponse(const LogoutResponse&other)
    : Response(other)
{
}

LogoutResponse::~LogoutResponse()
{
}

LogoutResponse &LogoutResponse::operator=(const LogoutResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool LogoutResponse::operator==(const LogoutResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const LogoutResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, LogoutResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const LogoutResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* TransactionCommand *************************/

TransactionCommand::TransactionCommand()
    : Command(Command::Transaction)
    , mMode(Invalid)
{
}

TransactionCommand::TransactionCommand(const TransactionCommand::Mode &mode)
    : Command(Command::Transaction)
    , mMode(mode)
{
}

TransactionCommand::TransactionCommand(const TransactionCommand&other)
    : Command(other)
    , mMode(other.mMode)
{
}

TransactionCommand::~TransactionCommand()
{
}

TransactionCommand &TransactionCommand::operator=(const TransactionCommand &other)
{
    Command::operator=(other);
    mMode = other.mMode;
    return *this;
}

bool TransactionCommand::operator==(const TransactionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mMode == other.mMode
    ;
}

DataStream &operator<<(DataStream &stream, const TransactionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mMode;
    return stream;
}

DataStream &operator>>(DataStream &stream, TransactionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mMode;
    return stream;
}

QDebug operator<<(QDebug dbg, const TransactionCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "mode:" << obj.mMode << "\n"
    ;
}



/************************* TransactionResponse *************************/

TransactionResponse::TransactionResponse()
    : Response(Command::Transaction)
{
}

TransactionResponse::TransactionResponse(const TransactionResponse&other)
    : Response(other)
{
}

TransactionResponse::~TransactionResponse()
{
}

TransactionResponse &TransactionResponse::operator=(const TransactionResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool TransactionResponse::operator==(const TransactionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const TransactionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, TransactionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const TransactionResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* CreateItemCommand *************************/

CreateItemCommand::CreateItemCommand()
    : Command(Command::CreateItem)
    , mItemSize(0)
    , mMergeModes(None)
    , mFlagsOverwritten(false)
{
}

CreateItemCommand::CreateItemCommand(const CreateItemCommand&other)
    : Command(other)
    , mCollection(other.mCollection)
    , mParts(other.mParts)
    , mAttributes(other.mAttributes)
    , mRemovedTags(other.mRemovedTags)
    , mAddedTags(other.mAddedTags)
    , mTags(other.mTags)
    , mRemovedFlags(other.mRemovedFlags)
    , mAddedFlags(other.mAddedFlags)
    , mFlags(other.mFlags)
    , mDateTime(other.mDateTime)
    , mRemoteRevision(other.mRemoteRevision)
    , mRemoteId(other.mRemoteId)
    , mGid(other.mGid)
    , mMimeType(other.mMimeType)
    , mItemSize(other.mItemSize)
    , mMergeModes(other.mMergeModes)
    , mFlagsOverwritten(other.mFlagsOverwritten)
{
}

CreateItemCommand::~CreateItemCommand()
{
}

CreateItemCommand &CreateItemCommand::operator=(const CreateItemCommand &other)
{
    Command::operator=(other);
    mCollection = other.mCollection;
    mParts = other.mParts;
    mAttributes = other.mAttributes;
    mRemovedTags = other.mRemovedTags;
    mAddedTags = other.mAddedTags;
    mTags = other.mTags;
    mRemovedFlags = other.mRemovedFlags;
    mAddedFlags = other.mAddedFlags;
    mFlags = other.mFlags;
    mDateTime = other.mDateTime;
    mRemoteRevision = other.mRemoteRevision;
    mRemoteId = other.mRemoteId;
    mGid = other.mGid;
    mMimeType = other.mMimeType;
    mItemSize = other.mItemSize;
    mMergeModes = other.mMergeModes;
    mFlagsOverwritten = other.mFlagsOverwritten;
    return *this;
}

bool CreateItemCommand::operator==(const CreateItemCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
        && mParts == other.mParts
        && mAttributes == other.mAttributes
        && mRemovedTags == other.mRemovedTags
        && mAddedTags == other.mAddedTags
        && mTags == other.mTags
        && mRemovedFlags == other.mRemovedFlags
        && mAddedFlags == other.mAddedFlags
        && mFlags == other.mFlags
        && mDateTime == other.mDateTime
        && mRemoteRevision == other.mRemoteRevision
        && mRemoteId == other.mRemoteId
        && mGid == other.mGid
        && mMimeType == other.mMimeType
        && mItemSize == other.mItemSize
        && mMergeModes == other.mMergeModes
        && mFlagsOverwritten == other.mFlagsOverwritten
    ;
}

DataStream &operator<<(DataStream &stream, const CreateItemCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mFlags;
    stream << obj.mFlagsOverwritten;
    stream << obj.mMergeModes;
    stream << obj.mItemSize;
    stream << obj.mMimeType;
    stream << obj.mGid;
    stream << obj.mRemoteId;
    stream << obj.mRemoteRevision;
    stream << obj.mDateTime;
    stream << obj.mCollection;
    stream << obj.mAddedFlags;
    stream << obj.mRemovedFlags;
    stream << obj.mTags;
    stream << obj.mAddedTags;
    stream << obj.mRemovedTags;
    stream << obj.mAttributes;
    stream << obj.mParts;
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateItemCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mFlags;
    stream >> obj.mFlagsOverwritten;
    stream >> obj.mMergeModes;
    stream >> obj.mItemSize;
    stream >> obj.mMimeType;
    stream >> obj.mGid;
    stream >> obj.mRemoteId;
    stream >> obj.mRemoteRevision;
    stream >> obj.mDateTime;
    stream >> obj.mCollection;
    stream >> obj.mAddedFlags;
    stream >> obj.mRemovedFlags;
    stream >> obj.mTags;
    stream >> obj.mAddedTags;
    stream >> obj.mRemovedTags;
    stream >> obj.mAttributes;
    stream >> obj.mParts;
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateItemCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "flags:" << obj.mFlags << "\n"
        << "flagsOverwritten:" << obj.mFlagsOverwritten << "\n"
        << "mergeModes:" << obj.mMergeModes << "\n"
        << "itemSize:" << obj.mItemSize << "\n"
        << "mimeType:" << obj.mMimeType << "\n"
        << "gid:" << obj.mGid << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "dateTime:" << obj.mDateTime << "\n"
        << "collection:" << obj.mCollection << "\n"
        << "addedFlags:" << obj.mAddedFlags << "\n"
        << "removedFlags:" << obj.mRemovedFlags << "\n"
        << "tags:" << obj.mTags << "\n"
        << "addedTags:" << obj.mAddedTags << "\n"
        << "removedTags:" << obj.mRemovedTags << "\n"
        << "attributes:" << obj.mAttributes << "\n"
        << "parts:" << obj.mParts << "\n"
    ;
}



/************************* CreateItemResponse *************************/

CreateItemResponse::CreateItemResponse()
    : Response(Command::CreateItem)
{
}

CreateItemResponse::CreateItemResponse(const CreateItemResponse&other)
    : Response(other)
{
}

CreateItemResponse::~CreateItemResponse()
{
}

CreateItemResponse &CreateItemResponse::operator=(const CreateItemResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool CreateItemResponse::operator==(const CreateItemResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CreateItemResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateItemResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateItemResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* CopyItemsCommand *************************/

CopyItemsCommand::CopyItemsCommand()
    : Command(Command::CopyItems)
{
}

CopyItemsCommand::CopyItemsCommand(const Scope &items, const Scope &destination)
    : Command(Command::CopyItems)
    , mItems(items)
    , mDestination(destination)
{
}

CopyItemsCommand::CopyItemsCommand(const CopyItemsCommand&other)
    : Command(other)
    , mItems(other.mItems)
    , mDestination(other.mDestination)
{
}

CopyItemsCommand::~CopyItemsCommand()
{
}

CopyItemsCommand &CopyItemsCommand::operator=(const CopyItemsCommand &other)
{
    Command::operator=(other);
    mItems = other.mItems;
    mDestination = other.mDestination;
    return *this;
}

bool CopyItemsCommand::operator==(const CopyItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mItems == other.mItems
        && mDestination == other.mDestination
    ;
}

DataStream &operator<<(DataStream &stream, const CopyItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mItems;
    stream << obj.mDestination;
    return stream;
}

DataStream &operator>>(DataStream &stream, CopyItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mItems;
    stream >> obj.mDestination;
    return stream;
}

QDebug operator<<(QDebug dbg, const CopyItemsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "items:" << obj.mItems << "\n"
        << "destination:" << obj.mDestination << "\n"
    ;
}



/************************* CopyItemsResponse *************************/

CopyItemsResponse::CopyItemsResponse()
    : Response(Command::CopyItems)
{
}

CopyItemsResponse::CopyItemsResponse(const CopyItemsResponse&other)
    : Response(other)
{
}

CopyItemsResponse::~CopyItemsResponse()
{
}

CopyItemsResponse &CopyItemsResponse::operator=(const CopyItemsResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool CopyItemsResponse::operator==(const CopyItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CopyItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CopyItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CopyItemsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* DeleteItemsCommand *************************/

DeleteItemsCommand::DeleteItemsCommand()
    : Command(Command::DeleteItems)
{
}

DeleteItemsCommand::DeleteItemsCommand(const Scope &items, const Akonadi::Protocol::ScopeContext &scopeContext)
    : Command(Command::DeleteItems)
    , mItems(items)
    , mScopeContext(scopeContext)
{
}

DeleteItemsCommand::DeleteItemsCommand(const DeleteItemsCommand&other)
    : Command(other)
    , mItems(other.mItems)
    , mScopeContext(other.mScopeContext)
{
}

DeleteItemsCommand::~DeleteItemsCommand()
{
}

DeleteItemsCommand &DeleteItemsCommand::operator=(const DeleteItemsCommand &other)
{
    Command::operator=(other);
    mItems = other.mItems;
    mScopeContext = other.mScopeContext;
    return *this;
}

bool DeleteItemsCommand::operator==(const DeleteItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mItems == other.mItems
        && mScopeContext == other.mScopeContext
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mItems;
    stream << obj.mScopeContext;
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mItems;
    stream >> obj.mScopeContext;
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteItemsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "items:" << obj.mItems << "\n"
        << "scopeContext:" << obj.mScopeContext << "\n"
    ;
}



/************************* DeleteItemsResponse *************************/

DeleteItemsResponse::DeleteItemsResponse()
    : Response(Command::DeleteItems)
{
}

DeleteItemsResponse::DeleteItemsResponse(const DeleteItemsResponse&other)
    : Response(other)
{
}

DeleteItemsResponse::~DeleteItemsResponse()
{
}

DeleteItemsResponse &DeleteItemsResponse::operator=(const DeleteItemsResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool DeleteItemsResponse::operator==(const DeleteItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteItemsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* FetchRelationsCommand *************************/

FetchRelationsCommand::FetchRelationsCommand()
    : Command(Command::FetchRelations)
    , mLeft(-1)
    , mRight(-1)
    , mSide(-1)
{
}

FetchRelationsCommand::FetchRelationsCommand(qint64 left, qint64 right, const QVector<QByteArray> &types, const QString &resource)
    : Command(Command::FetchRelations)
    , mLeft(left)
    , mRight(right)
    , mSide(-1)
    , mTypes(types)
    , mResource(resource)
{
}

FetchRelationsCommand::FetchRelationsCommand(qint64 side, const QVector<QByteArray> &types, const QString &resource)
    : Command(Command::FetchRelations)
    , mLeft(-1)
    , mRight(-1)
    , mSide(side)
    , mTypes(types)
    , mResource(resource)
{
}

FetchRelationsCommand::FetchRelationsCommand(const FetchRelationsCommand&other)
    : Command(other)
    , mLeft(other.mLeft)
    , mRight(other.mRight)
    , mSide(other.mSide)
    , mTypes(other.mTypes)
    , mResource(other.mResource)
{
}

FetchRelationsCommand::~FetchRelationsCommand()
{
}

FetchRelationsCommand &FetchRelationsCommand::operator=(const FetchRelationsCommand &other)
{
    Command::operator=(other);
    mLeft = other.mLeft;
    mRight = other.mRight;
    mSide = other.mSide;
    mTypes = other.mTypes;
    mResource = other.mResource;
    return *this;
}

bool FetchRelationsCommand::operator==(const FetchRelationsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mLeft == other.mLeft
        && mRight == other.mRight
        && mSide == other.mSide
        && mTypes == other.mTypes
        && mResource == other.mResource
    ;
}

DataStream &operator<<(DataStream &stream, const FetchRelationsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mLeft;
    stream << obj.mRight;
    stream << obj.mSide;
    stream << obj.mTypes;
    stream << obj.mResource;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchRelationsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mLeft;
    stream >> obj.mRight;
    stream >> obj.mSide;
    stream >> obj.mTypes;
    stream >> obj.mResource;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchRelationsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "left:" << obj.mLeft << "\n"
        << "right:" << obj.mRight << "\n"
        << "side:" << obj.mSide << "\n"
        << "types:" << obj.mTypes << "\n"
        << "resource:" << obj.mResource << "\n"
    ;
}



/************************* FetchRelationsResponse *************************/

FetchRelationsResponse::FetchRelationsResponse()
    : Response(Command::FetchRelations)
    , mLeft(-1)
    , mRight(-1)
{
}

FetchRelationsResponse::FetchRelationsResponse(qint64 left, const QByteArray &leftMimeType, qint64 right, const QByteArray &rightMimeType, const QByteArray &type, const QByteArray &remoteId)
    : Response(Command::FetchRelations)
    , mLeft(left)
    , mLeftMimeType(leftMimeType)
    , mRight(right)
    , mRightMimeType(rightMimeType)
    , mType(type)
    , mRemoteId(remoteId)
{
}

FetchRelationsResponse::FetchRelationsResponse(const FetchRelationsResponse&other)
    : Response(other)
    , mLeft(other.mLeft)
    , mLeftMimeType(other.mLeftMimeType)
    , mRight(other.mRight)
    , mRightMimeType(other.mRightMimeType)
    , mType(other.mType)
    , mRemoteId(other.mRemoteId)
{
}

FetchRelationsResponse::~FetchRelationsResponse()
{
}

FetchRelationsResponse &FetchRelationsResponse::operator=(const FetchRelationsResponse &other)
{
    Response::operator=(other);
    mLeft = other.mLeft;
    mLeftMimeType = other.mLeftMimeType;
    mRight = other.mRight;
    mRightMimeType = other.mRightMimeType;
    mType = other.mType;
    mRemoteId = other.mRemoteId;
    return *this;
}

bool FetchRelationsResponse::operator==(const FetchRelationsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mLeft == other.mLeft
        && mLeftMimeType == other.mLeftMimeType
        && mRight == other.mRight
        && mRightMimeType == other.mRightMimeType
        && mType == other.mType
        && mRemoteId == other.mRemoteId
    ;
}

DataStream &operator<<(DataStream &stream, const FetchRelationsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mLeft;
    stream << obj.mLeftMimeType;
    stream << obj.mRight;
    stream << obj.mRightMimeType;
    stream << obj.mType;
    stream << obj.mRemoteId;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchRelationsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mLeft;
    stream >> obj.mLeftMimeType;
    stream >> obj.mRight;
    stream >> obj.mRightMimeType;
    stream >> obj.mType;
    stream >> obj.mRemoteId;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchRelationsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
        << "left:" << obj.mLeft << "\n"
        << "leftMimeType:" << obj.mLeftMimeType << "\n"
        << "right:" << obj.mRight << "\n"
        << "rightMimeType:" << obj.mRightMimeType << "\n"
        << "type:" << obj.mType << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
    ;
}



/************************* FetchTagsCommand *************************/

FetchTagsCommand::FetchTagsCommand()
    : Command(Command::FetchTags)
    , mIdOnly(false)
{
}

FetchTagsCommand::FetchTagsCommand(const Scope &scope)
    : Command(Command::FetchTags)
    , mScope(scope)
    , mIdOnly(false)
{
}

FetchTagsCommand::FetchTagsCommand(const FetchTagsCommand&other)
    : Command(other)
    , mScope(other.mScope)
    , mAttributes(other.mAttributes)
    , mIdOnly(other.mIdOnly)
{
}

FetchTagsCommand::~FetchTagsCommand()
{
}

FetchTagsCommand &FetchTagsCommand::operator=(const FetchTagsCommand &other)
{
    Command::operator=(other);
    mScope = other.mScope;
    mAttributes = other.mAttributes;
    mIdOnly = other.mIdOnly;
    return *this;
}

bool FetchTagsCommand::operator==(const FetchTagsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mScope == other.mScope
        && mAttributes == other.mAttributes
        && mIdOnly == other.mIdOnly
    ;
}

DataStream &operator<<(DataStream &stream, const FetchTagsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mScope;
    stream << obj.mAttributes;
    stream << obj.mIdOnly;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchTagsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mScope;
    stream >> obj.mAttributes;
    stream >> obj.mIdOnly;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchTagsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "scope:" << obj.mScope << "\n"
        << "attributes:" << obj.mAttributes << "\n"
        << "idOnly:" << obj.mIdOnly << "\n"
    ;
}



/************************* FetchTagsResponse *************************/

FetchTagsResponse::FetchTagsResponse()
    : Response(Command::FetchTags)
    , mId(-1)
    , mParentId(-1)
{
}

FetchTagsResponse::FetchTagsResponse(qint64 id)
    : Response(Command::FetchTags)
    , mId(id)
    , mParentId(-1)
{
}

FetchTagsResponse::FetchTagsResponse(qint64 id, const QByteArray &gid, const QByteArray &type, const QByteArray &remoteId, qint64 parentId, const Akonadi::Protocol::Attributes &attributes)
    : Response(Command::FetchTags)
    , mId(id)
    , mParentId(parentId)
    , mGid(gid)
    , mType(type)
    , mRemoteId(remoteId)
    , mAttributes(attributes)
{
}

FetchTagsResponse::FetchTagsResponse(const FetchTagsResponse&other)
    : Response(other)
    , mId(other.mId)
    , mParentId(other.mParentId)
    , mGid(other.mGid)
    , mType(other.mType)
    , mRemoteId(other.mRemoteId)
    , mAttributes(other.mAttributes)
{
}

FetchTagsResponse::~FetchTagsResponse()
{
}

FetchTagsResponse &FetchTagsResponse::operator=(const FetchTagsResponse &other)
{
    Response::operator=(other);
    mId = other.mId;
    mParentId = other.mParentId;
    mGid = other.mGid;
    mType = other.mType;
    mRemoteId = other.mRemoteId;
    mAttributes = other.mAttributes;
    return *this;
}

bool FetchTagsResponse::operator==(const FetchTagsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mId == other.mId
        && mParentId == other.mParentId
        && mGid == other.mGid
        && mType == other.mType
        && mRemoteId == other.mRemoteId
        && mAttributes == other.mAttributes
    ;
}

DataStream &operator<<(DataStream &stream, const FetchTagsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mId;
    stream << obj.mParentId;
    stream << obj.mGid;
    stream << obj.mType;
    stream << obj.mRemoteId;
    stream << obj.mAttributes;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchTagsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mId;
    stream >> obj.mParentId;
    stream >> obj.mGid;
    stream >> obj.mType;
    stream >> obj.mRemoteId;
    stream >> obj.mAttributes;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchTagsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
        << "id:" << obj.mId << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "gid:" << obj.mGid << "\n"
        << "type:" << obj.mType << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
}



/************************* FetchItemsCommand *************************/

FetchItemsCommand::FetchItemsCommand()
    : Command(Command::FetchItems)
{
}

FetchItemsCommand::FetchItemsCommand(const Scope &scope, const Akonadi::Protocol::ScopeContext &scopeContext, const Akonadi::Protocol::FetchScope &fetchScope)
    : Command(Command::FetchItems)
    , mScope(scope)
    , mScopeContext(scopeContext)
    , mFetchScope(fetchScope)
{
}

FetchItemsCommand::FetchItemsCommand(const FetchItemsCommand&other)
    : Command(other)
    , mScope(other.mScope)
    , mScopeContext(other.mScopeContext)
    , mFetchScope(other.mFetchScope)
{
}

FetchItemsCommand::~FetchItemsCommand()
{
}

FetchItemsCommand &FetchItemsCommand::operator=(const FetchItemsCommand &other)
{
    Command::operator=(other);
    mScope = other.mScope;
    mScopeContext = other.mScopeContext;
    mFetchScope = other.mFetchScope;
    return *this;
}

bool FetchItemsCommand::operator==(const FetchItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mScope == other.mScope
        && mScopeContext == other.mScopeContext
        && mFetchScope == other.mFetchScope
    ;
}

DataStream &operator<<(DataStream &stream, const FetchItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mScope;
    stream << obj.mScopeContext;
    stream << obj.mFetchScope;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mScope;
    stream >> obj.mScopeContext;
    stream >> obj.mFetchScope;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchItemsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "scope:" << obj.mScope << "\n"
        << "scopeContext:" << obj.mScopeContext << "\n"
        << "fetchScope:" << obj.mFetchScope << "\n"
    ;
}



/************************* FetchItemsResponse *************************/

FetchItemsResponse::FetchItemsResponse()
    : Response(Command::FetchItems)
    , mId(-1)
    , mParentId(-1)
    , mSize(0)
    , mRevision(-1)
{
}

FetchItemsResponse::FetchItemsResponse(qint64 id)
    : Response(Command::FetchItems)
    , mId(id)
    , mParentId(-1)
    , mSize(0)
    , mRevision(-1)
{
}

FetchItemsResponse::FetchItemsResponse(const FetchItemsResponse&other)
    : Response(other)
    , mId(other.mId)
    , mParentId(other.mParentId)
    , mRemoteId(other.mRemoteId)
    , mRemoteRevision(other.mRemoteRevision)
    , mGid(other.mGid)
    , mSize(other.mSize)
    , mMimeType(other.mMimeType)
    , mMTime(other.mMTime)
    , mFlags(other.mFlags)
    , mTags(other.mTags)
    , mVirtualReferences(other.mVirtualReferences)
    , mRelations(other.mRelations)
    , mAncestors(other.mAncestors)
    , mParts(other.mParts)
    , mCachedParts(other.mCachedParts)
    , mRevision(other.mRevision)
{
}

FetchItemsResponse::~FetchItemsResponse()
{
}

FetchItemsResponse &FetchItemsResponse::operator=(const FetchItemsResponse &other)
{
    Response::operator=(other);
    mId = other.mId;
    mParentId = other.mParentId;
    mRemoteId = other.mRemoteId;
    mRemoteRevision = other.mRemoteRevision;
    mGid = other.mGid;
    mSize = other.mSize;
    mMimeType = other.mMimeType;
    mMTime = other.mMTime;
    mFlags = other.mFlags;
    mTags = other.mTags;
    mVirtualReferences = other.mVirtualReferences;
    mRelations = other.mRelations;
    mAncestors = other.mAncestors;
    mParts = other.mParts;
    mCachedParts = other.mCachedParts;
    mRevision = other.mRevision;
    return *this;
}

bool FetchItemsResponse::operator==(const FetchItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mId == other.mId
        && mParentId == other.mParentId
        && mRemoteId == other.mRemoteId
        && mRemoteRevision == other.mRemoteRevision
        && mGid == other.mGid
        && mSize == other.mSize
        && mMimeType == other.mMimeType
        && mMTime == other.mMTime
        && mFlags == other.mFlags
        && mTags == other.mTags
        && mVirtualReferences == other.mVirtualReferences
        && mRelations == other.mRelations
        && mAncestors == other.mAncestors
        && mParts == other.mParts
        && mCachedParts == other.mCachedParts
        && mRevision == other.mRevision
    ;
}

DataStream &operator<<(DataStream &stream, const FetchItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mId;
    stream << obj.mParentId;
    stream << obj.mRemoteId;
    stream << obj.mRemoteRevision;
    stream << obj.mGid;
    stream << obj.mSize;
    stream << obj.mMimeType;
    stream << obj.mMTime;
    stream << obj.mFlags;
    stream << obj.mTags;
    stream << obj.mVirtualReferences;
    stream << obj.mRelations;
    stream << obj.mAncestors;
    stream << obj.mParts;
    stream << obj.mCachedParts;
    stream << obj.mRevision;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mId;
    stream >> obj.mParentId;
    stream >> obj.mRemoteId;
    stream >> obj.mRemoteRevision;
    stream >> obj.mGid;
    stream >> obj.mSize;
    stream >> obj.mMimeType;
    stream >> obj.mMTime;
    stream >> obj.mFlags;
    stream >> obj.mTags;
    stream >> obj.mVirtualReferences;
    stream >> obj.mRelations;
    stream >> obj.mAncestors;
    stream >> obj.mParts;
    stream >> obj.mCachedParts;
    stream >> obj.mRevision;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchItemsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
        << "id:" << obj.mId << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "gid:" << obj.mGid << "\n"
        << "size:" << obj.mSize << "\n"
        << "mimeType:" << obj.mMimeType << "\n"
        << "mTime:" << obj.mMTime << "\n"
        << "flags:" << obj.mFlags << "\n"
        << "tags:" << obj.mTags << "\n"
        << "virtualReferences:" << obj.mVirtualReferences << "\n"
        << "relations:" << obj.mRelations << "\n"
        << "ancestors:" << obj.mAncestors << "\n"
        << "parts:" << obj.mParts << "\n"
        << "cachedParts:" << obj.mCachedParts << "\n"
        << "revision:" << obj.mRevision << "\n"
    ;
}



/************************* LinkItemsCommand *************************/

LinkItemsCommand::LinkItemsCommand()
    : Command(Command::LinkItems)
    , mAction(Link)
{
}

LinkItemsCommand::LinkItemsCommand(const LinkItemsCommand::Action &action, const Scope &items, const Scope &destination)
    : Command(Command::LinkItems)
    , mItems(items)
    , mDestination(destination)
    , mAction(action)
{
}

LinkItemsCommand::LinkItemsCommand(const LinkItemsCommand&other)
    : Command(other)
    , mItems(other.mItems)
    , mDestination(other.mDestination)
    , mAction(other.mAction)
{
}

LinkItemsCommand::~LinkItemsCommand()
{
}

LinkItemsCommand &LinkItemsCommand::operator=(const LinkItemsCommand &other)
{
    Command::operator=(other);
    mItems = other.mItems;
    mDestination = other.mDestination;
    mAction = other.mAction;
    return *this;
}

bool LinkItemsCommand::operator==(const LinkItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mItems == other.mItems
        && mDestination == other.mDestination
        && mAction == other.mAction
    ;
}

DataStream &operator<<(DataStream &stream, const LinkItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mItems;
    stream << obj.mDestination;
    stream << obj.mAction;
    return stream;
}

DataStream &operator>>(DataStream &stream, LinkItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mItems;
    stream >> obj.mDestination;
    stream >> obj.mAction;
    return stream;
}

QDebug operator<<(QDebug dbg, const LinkItemsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "items:" << obj.mItems << "\n"
        << "destination:" << obj.mDestination << "\n"
        << "action:" << obj.mAction << "\n"
    ;
}



/************************* LinkItemsResponse *************************/

LinkItemsResponse::LinkItemsResponse()
    : Response(Command::LinkItems)
{
}

LinkItemsResponse::LinkItemsResponse(const LinkItemsResponse&other)
    : Response(other)
{
}

LinkItemsResponse::~LinkItemsResponse()
{
}

LinkItemsResponse &LinkItemsResponse::operator=(const LinkItemsResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool LinkItemsResponse::operator==(const LinkItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const LinkItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, LinkItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const LinkItemsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* ModifyItemsCommand *************************/

ModifyItemsCommand::ModifyItemsCommand()
    : Command(Command::ModifyItems)
    , mItemSize(0)
    , mModifiedParts(None)
    , mOldRevision(-1)
    , mDirty(true)
    , mInvalidateCache(false)
    , mNoResponse(false)
    , mNotify(true)
{
}

ModifyItemsCommand::ModifyItemsCommand(const Scope &items)
    : Command(Command::ModifyItems)
    , mItemSize(0)
    , mItems(items)
    , mModifiedParts(None)
    , mOldRevision(-1)
    , mDirty(true)
    , mInvalidateCache(false)
    , mNoResponse(false)
    , mNotify(true)
{
}

ModifyItemsCommand::ModifyItemsCommand(const ModifyItemsCommand&other)
    : Command(other)
    , mGid(other.mGid)
    , mAttributes(other.mAttributes)
    , mParts(other.mParts)
    , mRemovedParts(other.mRemovedParts)
    , mItemSize(other.mItemSize)
    , mRemoteRevision(other.mRemoteRevision)
    , mRemoteId(other.mRemoteId)
    , mRemovedTags(other.mRemovedTags)
    , mAddedTags(other.mAddedTags)
    , mTags(other.mTags)
    , mRemovedFlags(other.mRemovedFlags)
    , mAddedFlags(other.mAddedFlags)
    , mFlags(other.mFlags)
    , mItems(other.mItems)
    , mModifiedParts(other.mModifiedParts)
    , mOldRevision(other.mOldRevision)
    , mDirty(other.mDirty)
    , mInvalidateCache(other.mInvalidateCache)
    , mNoResponse(other.mNoResponse)
    , mNotify(other.mNotify)
{
}

ModifyItemsCommand::~ModifyItemsCommand()
{
}

ModifyItemsCommand &ModifyItemsCommand::operator=(const ModifyItemsCommand &other)
{
    Command::operator=(other);
    mGid = other.mGid;
    mAttributes = other.mAttributes;
    mParts = other.mParts;
    mRemovedParts = other.mRemovedParts;
    mItemSize = other.mItemSize;
    mRemoteRevision = other.mRemoteRevision;
    mRemoteId = other.mRemoteId;
    mRemovedTags = other.mRemovedTags;
    mAddedTags = other.mAddedTags;
    mTags = other.mTags;
    mRemovedFlags = other.mRemovedFlags;
    mAddedFlags = other.mAddedFlags;
    mFlags = other.mFlags;
    mItems = other.mItems;
    mModifiedParts = other.mModifiedParts;
    mOldRevision = other.mOldRevision;
    mDirty = other.mDirty;
    mInvalidateCache = other.mInvalidateCache;
    mNoResponse = other.mNoResponse;
    mNotify = other.mNotify;
    return *this;
}

bool ModifyItemsCommand::operator==(const ModifyItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mGid == other.mGid
        && mAttributes == other.mAttributes
        && mParts == other.mParts
        && mRemovedParts == other.mRemovedParts
        && mItemSize == other.mItemSize
        && mRemoteRevision == other.mRemoteRevision
        && mRemoteId == other.mRemoteId
        && mRemovedTags == other.mRemovedTags
        && mAddedTags == other.mAddedTags
        && mTags == other.mTags
        && mRemovedFlags == other.mRemovedFlags
        && mAddedFlags == other.mAddedFlags
        && mFlags == other.mFlags
        && mItems == other.mItems
        && mModifiedParts == other.mModifiedParts
        && mOldRevision == other.mOldRevision
        && mDirty == other.mDirty
        && mInvalidateCache == other.mInvalidateCache
        && mNoResponse == other.mNoResponse
        && mNotify == other.mNotify
    ;
}

void ModifyItemsCommand::setGid(const QString &val)
{
    mGid = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::GID);
}

void ModifyItemsCommand::setAttributes(const Akonadi::Protocol::Attributes &val)
{
    mAttributes = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::Attributes);
}

void ModifyItemsCommand::setParts(const QSet<QByteArray> &val)
{
    mParts = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::Parts);
}

void ModifyItemsCommand::setRemovedParts(const QSet<QByteArray> &val)
{
    mRemovedParts = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::RemovedParts);
}

void ModifyItemsCommand::setItemSize(qint64 val)
{
    mItemSize = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::Size);
}

void ModifyItemsCommand::setRemoteRevision(const QString &val)
{
    mRemoteRevision = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::RemoteRevision);
}

void ModifyItemsCommand::setRemoteId(const QString &val)
{
    mRemoteId = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::RemoteID);
}

void ModifyItemsCommand::setRemovedTags(const Scope &val)
{
    mRemovedTags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::RemovedTags);
}

void ModifyItemsCommand::setAddedTags(const Scope &val)
{
    mAddedTags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::AddedTags);
}

void ModifyItemsCommand::setTags(const Scope &val)
{
    mTags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::Tags);
}

void ModifyItemsCommand::setRemovedFlags(const QSet<QByteArray> &val)
{
    mRemovedFlags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::RemovedFlags);
}

void ModifyItemsCommand::setAddedFlags(const QSet<QByteArray> &val)
{
    mAddedFlags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::AddedFlags);
}

void ModifyItemsCommand::setFlags(const QSet<QByteArray> &val)
{
    mFlags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::Flags);
}

DataStream &operator<<(DataStream &stream, const ModifyItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mNotify;
    stream << obj.mNoResponse;
    stream << obj.mInvalidateCache;
    stream << obj.mDirty;
    stream << obj.mOldRevision;
    stream << obj.mModifiedParts;
    stream << obj.mItems;
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedFlags)) {
        stream << obj.mRemovedFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Flags)) {
        stream << obj.mFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::AddedFlags)) {
        stream << obj.mAddedFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::GID)) {
        stream << obj.mGid;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Tags)) {
        stream << obj.mTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::AddedTags)) {
        stream << obj.mAddedTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedTags)) {
        stream << obj.mRemovedTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemoteID)) {
        stream << obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemoteRevision)) {
        stream << obj.mRemoteRevision;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Size)) {
        stream << obj.mItemSize;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedParts)) {
        stream << obj.mRemovedParts;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Parts)) {
        stream << obj.mParts;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Attributes)) {
        stream << obj.mAttributes;
    }
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mNotify;
    stream >> obj.mNoResponse;
    stream >> obj.mInvalidateCache;
    stream >> obj.mDirty;
    stream >> obj.mOldRevision;
    stream >> obj.mModifiedParts;
    stream >> obj.mItems;
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedFlags)) {
        stream >> obj.mRemovedFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Flags)) {
        stream >> obj.mFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::AddedFlags)) {
        stream >> obj.mAddedFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::GID)) {
        stream >> obj.mGid;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Tags)) {
        stream >> obj.mTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::AddedTags)) {
        stream >> obj.mAddedTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedTags)) {
        stream >> obj.mRemovedTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemoteID)) {
        stream >> obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemoteRevision)) {
        stream >> obj.mRemoteRevision;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Size)) {
        stream >> obj.mItemSize;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedParts)) {
        stream >> obj.mRemovedParts;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Parts)) {
        stream >> obj.mParts;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Attributes)) {
        stream >> obj.mAttributes;
    }
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyItemsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "notify:" << obj.mNotify << "\n"
        << "noResponse:" << obj.mNoResponse << "\n"
        << "invalidateCache:" << obj.mInvalidateCache << "\n"
        << "dirty:" << obj.mDirty << "\n"
        << "oldRevision:" << obj.mOldRevision << "\n"
        << "modifiedParts:" << obj.mModifiedParts << "\n"
        << "items:" << obj.mItems << "\n"
        << "removedFlags:" << obj.mRemovedFlags << "\n"
        << "flags:" << obj.mFlags << "\n"
        << "addedFlags:" << obj.mAddedFlags << "\n"
        << "gid:" << obj.mGid << "\n"
        << "tags:" << obj.mTags << "\n"
        << "addedTags:" << obj.mAddedTags << "\n"
        << "removedTags:" << obj.mRemovedTags << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "itemSize:" << obj.mItemSize << "\n"
        << "removedParts:" << obj.mRemovedParts << "\n"
        << "parts:" << obj.mParts << "\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
}



/************************* ModifyItemsResponse *************************/

ModifyItemsResponse::ModifyItemsResponse()
    : Response(Command::ModifyItems)
    , mId(-1)
    , mNewRevision(0)
{
}

ModifyItemsResponse::ModifyItemsResponse(qint64 id, int newRevision)
    : Response(Command::ModifyItems)
    , mId(id)
    , mNewRevision(newRevision)
{
}

ModifyItemsResponse::ModifyItemsResponse(const ModifyItemsResponse&other)
    : Response(other)
    , mId(other.mId)
    , mModificationDateTime(other.mModificationDateTime)
    , mNewRevision(other.mNewRevision)
{
}

ModifyItemsResponse::~ModifyItemsResponse()
{
}

ModifyItemsResponse &ModifyItemsResponse::operator=(const ModifyItemsResponse &other)
{
    Response::operator=(other);
    mId = other.mId;
    mModificationDateTime = other.mModificationDateTime;
    mNewRevision = other.mNewRevision;
    return *this;
}

bool ModifyItemsResponse::operator==(const ModifyItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mId == other.mId
        && mModificationDateTime == other.mModificationDateTime
        && mNewRevision == other.mNewRevision
    ;
}

DataStream &operator<<(DataStream &stream, const ModifyItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mId;
    stream << obj.mModificationDateTime;
    stream << obj.mNewRevision;
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mId;
    stream >> obj.mModificationDateTime;
    stream >> obj.mNewRevision;
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyItemsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
        << "id:" << obj.mId << "\n"
        << "modificationDateTime:" << obj.mModificationDateTime << "\n"
        << "newRevision:" << obj.mNewRevision << "\n"
    ;
}



/************************* MoveItemsCommand *************************/

MoveItemsCommand::MoveItemsCommand()
    : Command(Command::MoveItems)
{
}

MoveItemsCommand::MoveItemsCommand(const Scope &items, const Scope &destination)
    : Command(Command::MoveItems)
    , mItems(items)
    , mDestination(destination)
{
}

MoveItemsCommand::MoveItemsCommand(const Scope &items, const Akonadi::Protocol::ScopeContext &itemsContext, const Scope &destination)
    : Command(Command::MoveItems)
    , mItems(items)
    , mDestination(destination)
    , mItemsContext(itemsContext)
{
}

MoveItemsCommand::MoveItemsCommand(const MoveItemsCommand&other)
    : Command(other)
    , mItems(other.mItems)
    , mDestination(other.mDestination)
    , mItemsContext(other.mItemsContext)
{
}

MoveItemsCommand::~MoveItemsCommand()
{
}

MoveItemsCommand &MoveItemsCommand::operator=(const MoveItemsCommand &other)
{
    Command::operator=(other);
    mItems = other.mItems;
    mDestination = other.mDestination;
    mItemsContext = other.mItemsContext;
    return *this;
}

bool MoveItemsCommand::operator==(const MoveItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mItems == other.mItems
        && mDestination == other.mDestination
        && mItemsContext == other.mItemsContext
    ;
}

DataStream &operator<<(DataStream &stream, const MoveItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mItems;
    stream << obj.mDestination;
    stream << obj.mItemsContext;
    return stream;
}

DataStream &operator>>(DataStream &stream, MoveItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mItems;
    stream >> obj.mDestination;
    stream >> obj.mItemsContext;
    return stream;
}

QDebug operator<<(QDebug dbg, const MoveItemsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "items:" << obj.mItems << "\n"
        << "destination:" << obj.mDestination << "\n"
        << "itemsContext:" << obj.mItemsContext << "\n"
    ;
}



/************************* MoveItemsResponse *************************/

MoveItemsResponse::MoveItemsResponse()
    : Response(Command::MoveItems)
{
}

MoveItemsResponse::MoveItemsResponse(const MoveItemsResponse&other)
    : Response(other)
{
}

MoveItemsResponse::~MoveItemsResponse()
{
}

MoveItemsResponse &MoveItemsResponse::operator=(const MoveItemsResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool MoveItemsResponse::operator==(const MoveItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const MoveItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, MoveItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const MoveItemsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* CreateCollectionCommand *************************/

CreateCollectionCommand::CreateCollectionCommand()
    : Command(Command::CreateCollection)
    , mIsVirtual(false)
    , mEnabled(true)
    , mSyncPref(Tristate::Undefined)
    , mDisplayPref(Tristate::Undefined)
    , mIndexPref(Tristate::Undefined)
{
}

CreateCollectionCommand::CreateCollectionCommand(const CreateCollectionCommand&other)
    : Command(other)
    , mParent(other.mParent)
    , mName(other.mName)
    , mRemoteId(other.mRemoteId)
    , mRemoteRevision(other.mRemoteRevision)
    , mMimeTypes(other.mMimeTypes)
    , mAttributes(other.mAttributes)
    , mCachePolicy(other.mCachePolicy)
    , mIsVirtual(other.mIsVirtual)
    , mEnabled(other.mEnabled)
    , mSyncPref(other.mSyncPref)
    , mDisplayPref(other.mDisplayPref)
    , mIndexPref(other.mIndexPref)
{
}

CreateCollectionCommand::~CreateCollectionCommand()
{
}

CreateCollectionCommand &CreateCollectionCommand::operator=(const CreateCollectionCommand &other)
{
    Command::operator=(other);
    mParent = other.mParent;
    mName = other.mName;
    mRemoteId = other.mRemoteId;
    mRemoteRevision = other.mRemoteRevision;
    mMimeTypes = other.mMimeTypes;
    mAttributes = other.mAttributes;
    mCachePolicy = other.mCachePolicy;
    mIsVirtual = other.mIsVirtual;
    mEnabled = other.mEnabled;
    mSyncPref = other.mSyncPref;
    mDisplayPref = other.mDisplayPref;
    mIndexPref = other.mIndexPref;
    return *this;
}

bool CreateCollectionCommand::operator==(const CreateCollectionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mParent == other.mParent
        && mName == other.mName
        && mRemoteId == other.mRemoteId
        && mRemoteRevision == other.mRemoteRevision
        && mMimeTypes == other.mMimeTypes
        && mAttributes == other.mAttributes
        && mCachePolicy == other.mCachePolicy
        && mIsVirtual == other.mIsVirtual
        && mEnabled == other.mEnabled
        && mSyncPref == other.mSyncPref
        && mDisplayPref == other.mDisplayPref
        && mIndexPref == other.mIndexPref
    ;
}

DataStream &operator<<(DataStream &stream, const CreateCollectionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mParent;
    stream << obj.mName;
    stream << obj.mRemoteId;
    stream << obj.mRemoteRevision;
    stream << obj.mMimeTypes;
    stream << obj.mAttributes;
    stream << obj.mCachePolicy;
    stream << obj.mIsVirtual;
    stream << obj.mEnabled;
    stream << obj.mSyncPref;
    stream << obj.mDisplayPref;
    stream << obj.mIndexPref;
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateCollectionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mParent;
    stream >> obj.mName;
    stream >> obj.mRemoteId;
    stream >> obj.mRemoteRevision;
    stream >> obj.mMimeTypes;
    stream >> obj.mAttributes;
    stream >> obj.mCachePolicy;
    stream >> obj.mIsVirtual;
    stream >> obj.mEnabled;
    stream >> obj.mSyncPref;
    stream >> obj.mDisplayPref;
    stream >> obj.mIndexPref;
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateCollectionCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "parent:" << obj.mParent << "\n"
        << "name:" << obj.mName << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "attributes:" << obj.mAttributes << "\n"
        << "cachePolicy:" << obj.mCachePolicy << "\n"
        << "isVirtual:" << obj.mIsVirtual << "\n"
        << "enabled:" << obj.mEnabled << "\n"
        << "syncPref:" << obj.mSyncPref << "\n"
        << "displayPref:" << obj.mDisplayPref << "\n"
        << "indexPref:" << obj.mIndexPref << "\n"
    ;
}



/************************* CreateCollectionResponse *************************/

CreateCollectionResponse::CreateCollectionResponse()
    : Response(Command::CreateCollection)
{
}

CreateCollectionResponse::CreateCollectionResponse(const CreateCollectionResponse&other)
    : Response(other)
{
}

CreateCollectionResponse::~CreateCollectionResponse()
{
}

CreateCollectionResponse &CreateCollectionResponse::operator=(const CreateCollectionResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool CreateCollectionResponse::operator==(const CreateCollectionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CreateCollectionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateCollectionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateCollectionResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* CopyCollectionCommand *************************/

CopyCollectionCommand::CopyCollectionCommand()
    : Command(Command::CopyCollection)
{
}

CopyCollectionCommand::CopyCollectionCommand(const Scope &collection, const Scope &destination)
    : Command(Command::CopyCollection)
    , mCollection(collection)
    , mDestination(destination)
{
}

CopyCollectionCommand::CopyCollectionCommand(const CopyCollectionCommand&other)
    : Command(other)
    , mCollection(other.mCollection)
    , mDestination(other.mDestination)
{
}

CopyCollectionCommand::~CopyCollectionCommand()
{
}

CopyCollectionCommand &CopyCollectionCommand::operator=(const CopyCollectionCommand &other)
{
    Command::operator=(other);
    mCollection = other.mCollection;
    mDestination = other.mDestination;
    return *this;
}

bool CopyCollectionCommand::operator==(const CopyCollectionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
        && mDestination == other.mDestination
    ;
}

DataStream &operator<<(DataStream &stream, const CopyCollectionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mCollection;
    stream << obj.mDestination;
    return stream;
}

DataStream &operator>>(DataStream &stream, CopyCollectionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mCollection;
    stream >> obj.mDestination;
    return stream;
}

QDebug operator<<(QDebug dbg, const CopyCollectionCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "collection:" << obj.mCollection << "\n"
        << "destination:" << obj.mDestination << "\n"
    ;
}



/************************* CopyCollectionResponse *************************/

CopyCollectionResponse::CopyCollectionResponse()
    : Response(Command::CopyCollection)
{
}

CopyCollectionResponse::CopyCollectionResponse(const CopyCollectionResponse&other)
    : Response(other)
{
}

CopyCollectionResponse::~CopyCollectionResponse()
{
}

CopyCollectionResponse &CopyCollectionResponse::operator=(const CopyCollectionResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool CopyCollectionResponse::operator==(const CopyCollectionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CopyCollectionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CopyCollectionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CopyCollectionResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* DeleteCollectionCommand *************************/

DeleteCollectionCommand::DeleteCollectionCommand()
    : Command(Command::DeleteCollection)
{
}

DeleteCollectionCommand::DeleteCollectionCommand(const Scope &collection)
    : Command(Command::DeleteCollection)
    , mCollection(collection)
{
}

DeleteCollectionCommand::DeleteCollectionCommand(const DeleteCollectionCommand&other)
    : Command(other)
    , mCollection(other.mCollection)
{
}

DeleteCollectionCommand::~DeleteCollectionCommand()
{
}

DeleteCollectionCommand &DeleteCollectionCommand::operator=(const DeleteCollectionCommand &other)
{
    Command::operator=(other);
    mCollection = other.mCollection;
    return *this;
}

bool DeleteCollectionCommand::operator==(const DeleteCollectionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteCollectionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mCollection;
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteCollectionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mCollection;
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteCollectionCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "collection:" << obj.mCollection << "\n"
    ;
}



/************************* DeleteCollectionResponse *************************/

DeleteCollectionResponse::DeleteCollectionResponse()
    : Response(Command::DeleteCollection)
{
}

DeleteCollectionResponse::DeleteCollectionResponse(const DeleteCollectionResponse&other)
    : Response(other)
{
}

DeleteCollectionResponse::~DeleteCollectionResponse()
{
}

DeleteCollectionResponse &DeleteCollectionResponse::operator=(const DeleteCollectionResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool DeleteCollectionResponse::operator==(const DeleteCollectionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteCollectionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteCollectionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteCollectionResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* FetchCollectionStatsCommand *************************/

FetchCollectionStatsCommand::FetchCollectionStatsCommand()
    : Command(Command::FetchCollectionStats)
{
}

FetchCollectionStatsCommand::FetchCollectionStatsCommand(const Scope &collection)
    : Command(Command::FetchCollectionStats)
    , mCollection(collection)
{
}

FetchCollectionStatsCommand::FetchCollectionStatsCommand(const FetchCollectionStatsCommand&other)
    : Command(other)
    , mCollection(other.mCollection)
{
}

FetchCollectionStatsCommand::~FetchCollectionStatsCommand()
{
}

FetchCollectionStatsCommand &FetchCollectionStatsCommand::operator=(const FetchCollectionStatsCommand &other)
{
    Command::operator=(other);
    mCollection = other.mCollection;
    return *this;
}

bool FetchCollectionStatsCommand::operator==(const FetchCollectionStatsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
    ;
}

DataStream &operator<<(DataStream &stream, const FetchCollectionStatsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mCollection;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchCollectionStatsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mCollection;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchCollectionStatsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "collection:" << obj.mCollection << "\n"
    ;
}



/************************* FetchCollectionStatsResponse *************************/

FetchCollectionStatsResponse::FetchCollectionStatsResponse()
    : Response(Command::FetchCollectionStats)
    , mCount(0)
    , mUnseen(0)
    , mSize(0)
{
}

FetchCollectionStatsResponse::FetchCollectionStatsResponse(qint64 count, qint64 unseen, qint64 size)
    : Response(Command::FetchCollectionStats)
    , mCount(count)
    , mUnseen(unseen)
    , mSize(size)
{
}

FetchCollectionStatsResponse::FetchCollectionStatsResponse(const FetchCollectionStatsResponse&other)
    : Response(other)
    , mCount(other.mCount)
    , mUnseen(other.mUnseen)
    , mSize(other.mSize)
{
}

FetchCollectionStatsResponse::~FetchCollectionStatsResponse()
{
}

FetchCollectionStatsResponse &FetchCollectionStatsResponse::operator=(const FetchCollectionStatsResponse &other)
{
    Response::operator=(other);
    mCount = other.mCount;
    mUnseen = other.mUnseen;
    mSize = other.mSize;
    return *this;
}

bool FetchCollectionStatsResponse::operator==(const FetchCollectionStatsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mCount == other.mCount
        && mUnseen == other.mUnseen
        && mSize == other.mSize
    ;
}

DataStream &operator<<(DataStream &stream, const FetchCollectionStatsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mCount;
    stream << obj.mUnseen;
    stream << obj.mSize;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchCollectionStatsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mCount;
    stream >> obj.mUnseen;
    stream >> obj.mSize;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchCollectionStatsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
        << "count:" << obj.mCount << "\n"
        << "unseen:" << obj.mUnseen << "\n"
        << "size:" << obj.mSize << "\n"
    ;
}



/************************* FetchCollectionsCommand *************************/

FetchCollectionsCommand::FetchCollectionsCommand()
    : Command(Command::FetchCollections)
    , mDepth(BaseCollection)
    , mEnabled(false)
    , mSyncPref(false)
    , mDisplayPref(false)
    , mIndexPref(false)
    , mFetchStats(false)
{
}

FetchCollectionsCommand::FetchCollectionsCommand(const Scope &collections)
    : Command(Command::FetchCollections)
    , mCollections(collections)
    , mDepth(BaseCollection)
    , mEnabled(false)
    , mSyncPref(false)
    , mDisplayPref(false)
    , mIndexPref(false)
    , mFetchStats(false)
{
}

FetchCollectionsCommand::FetchCollectionsCommand(const FetchCollectionsCommand&other)
    : Command(other)
    , mCollections(other.mCollections)
    , mResource(other.mResource)
    , mMimeTypes(other.mMimeTypes)
    , mAncestorsAttributes(other.mAncestorsAttributes)
    , mDepth(other.mDepth)
    , mAncestorsDepth(other.mAncestorsDepth)
    , mEnabled(other.mEnabled)
    , mSyncPref(other.mSyncPref)
    , mDisplayPref(other.mDisplayPref)
    , mIndexPref(other.mIndexPref)
    , mFetchStats(other.mFetchStats)
{
}

FetchCollectionsCommand::~FetchCollectionsCommand()
{
}

FetchCollectionsCommand &FetchCollectionsCommand::operator=(const FetchCollectionsCommand &other)
{
    Command::operator=(other);
    mCollections = other.mCollections;
    mResource = other.mResource;
    mMimeTypes = other.mMimeTypes;
    mAncestorsAttributes = other.mAncestorsAttributes;
    mDepth = other.mDepth;
    mAncestorsDepth = other.mAncestorsDepth;
    mEnabled = other.mEnabled;
    mSyncPref = other.mSyncPref;
    mDisplayPref = other.mDisplayPref;
    mIndexPref = other.mIndexPref;
    mFetchStats = other.mFetchStats;
    return *this;
}

bool FetchCollectionsCommand::operator==(const FetchCollectionsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollections == other.mCollections
        && mResource == other.mResource
        && mMimeTypes == other.mMimeTypes
        && mAncestorsAttributes == other.mAncestorsAttributes
        && mDepth == other.mDepth
        && mAncestorsDepth == other.mAncestorsDepth
        && mEnabled == other.mEnabled
        && mSyncPref == other.mSyncPref
        && mDisplayPref == other.mDisplayPref
        && mIndexPref == other.mIndexPref
        && mFetchStats == other.mFetchStats
    ;
}

DataStream &operator<<(DataStream &stream, const FetchCollectionsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mCollections;
    stream << obj.mResource;
    stream << obj.mMimeTypes;
    stream << obj.mAncestorsAttributes;
    stream << obj.mDepth;
    stream << obj.mAncestorsDepth;
    stream << obj.mEnabled;
    stream << obj.mSyncPref;
    stream << obj.mDisplayPref;
    stream << obj.mIndexPref;
    stream << obj.mFetchStats;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchCollectionsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mCollections;
    stream >> obj.mResource;
    stream >> obj.mMimeTypes;
    stream >> obj.mAncestorsAttributes;
    stream >> obj.mDepth;
    stream >> obj.mAncestorsDepth;
    stream >> obj.mEnabled;
    stream >> obj.mSyncPref;
    stream >> obj.mDisplayPref;
    stream >> obj.mIndexPref;
    stream >> obj.mFetchStats;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchCollectionsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "collections:" << obj.mCollections << "\n"
        << "resource:" << obj.mResource << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "ancestorsAttributes:" << obj.mAncestorsAttributes << "\n"
        << "depth:" << obj.mDepth << "\n"
        << "ancestorsDepth:" << obj.mAncestorsDepth << "\n"
        << "enabled:" << obj.mEnabled << "\n"
        << "syncPref:" << obj.mSyncPref << "\n"
        << "displayPref:" << obj.mDisplayPref << "\n"
        << "indexPref:" << obj.mIndexPref << "\n"
        << "fetchStats:" << obj.mFetchStats << "\n"
    ;
}



/************************* FetchCollectionsResponse *************************/

FetchCollectionsResponse::FetchCollectionsResponse()
    : Response(Command::FetchCollections)
    , mParentId(-1)
    , mId(-1)
    , mEnabled(true)
    , mDisplayPref(Tristate::Undefined)
    , mSyncPref(Tristate::Undefined)
    , mIndexPref(Tristate::Undefined)
    , mReferenced(false)
    , mIsVirtual(false)
{
}

FetchCollectionsResponse::FetchCollectionsResponse(qint64 id)
    : Response(Command::FetchCollections)
    , mParentId(-1)
    , mId(id)
    , mEnabled(true)
    , mDisplayPref(Tristate::Undefined)
    , mSyncPref(Tristate::Undefined)
    , mIndexPref(Tristate::Undefined)
    , mReferenced(false)
    , mIsVirtual(false)
{
}

FetchCollectionsResponse::FetchCollectionsResponse(const FetchCollectionsResponse&other)
    : Response(other)
    , mParentId(other.mParentId)
    , mAttributes(other.mAttributes)
    , mAncestors(other.mAncestors)
    , mSearchCollections(other.mSearchCollections)
    , mSearchQuery(other.mSearchQuery)
    , mResource(other.mResource)
    , mRemoteRevision(other.mRemoteRevision)
    , mRemoteId(other.mRemoteId)
    , mMimeTypes(other.mMimeTypes)
    , mName(other.mName)
    , mId(other.mId)
    , mStatistics(other.mStatistics)
    , mCachePolicy(other.mCachePolicy)
    , mEnabled(other.mEnabled)
    , mDisplayPref(other.mDisplayPref)
    , mSyncPref(other.mSyncPref)
    , mIndexPref(other.mIndexPref)
    , mReferenced(other.mReferenced)
    , mIsVirtual(other.mIsVirtual)
{
}

FetchCollectionsResponse::~FetchCollectionsResponse()
{
}

FetchCollectionsResponse &FetchCollectionsResponse::operator=(const FetchCollectionsResponse &other)
{
    Response::operator=(other);
    mParentId = other.mParentId;
    mAttributes = other.mAttributes;
    mAncestors = other.mAncestors;
    mSearchCollections = other.mSearchCollections;
    mSearchQuery = other.mSearchQuery;
    mResource = other.mResource;
    mRemoteRevision = other.mRemoteRevision;
    mRemoteId = other.mRemoteId;
    mMimeTypes = other.mMimeTypes;
    mName = other.mName;
    mId = other.mId;
    mStatistics = other.mStatistics;
    mCachePolicy = other.mCachePolicy;
    mEnabled = other.mEnabled;
    mDisplayPref = other.mDisplayPref;
    mSyncPref = other.mSyncPref;
    mIndexPref = other.mIndexPref;
    mReferenced = other.mReferenced;
    mIsVirtual = other.mIsVirtual;
    return *this;
}

bool FetchCollectionsResponse::operator==(const FetchCollectionsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mParentId == other.mParentId
        && mAttributes == other.mAttributes
        && mAncestors == other.mAncestors
        && mSearchCollections == other.mSearchCollections
        && mSearchQuery == other.mSearchQuery
        && mResource == other.mResource
        && mRemoteRevision == other.mRemoteRevision
        && mRemoteId == other.mRemoteId
        && mMimeTypes == other.mMimeTypes
        && mName == other.mName
        && mId == other.mId
        && mStatistics == other.mStatistics
        && mCachePolicy == other.mCachePolicy
        && mEnabled == other.mEnabled
        && mDisplayPref == other.mDisplayPref
        && mSyncPref == other.mSyncPref
        && mIndexPref == other.mIndexPref
        && mReferenced == other.mReferenced
        && mIsVirtual == other.mIsVirtual
    ;
}

DataStream &operator<<(DataStream &stream, const FetchCollectionsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mName;
    stream << obj.mIsVirtual;
    stream << obj.mReferenced;
    stream << obj.mIndexPref;
    stream << obj.mSyncPref;
    stream << obj.mDisplayPref;
    stream << obj.mEnabled;
    stream << obj.mCachePolicy;
    stream << obj.mStatistics;
    stream << obj.mId;
    stream << obj.mParentId;
    stream << obj.mMimeTypes;
    stream << obj.mRemoteId;
    stream << obj.mRemoteRevision;
    stream << obj.mResource;
    stream << obj.mSearchQuery;
    stream << obj.mSearchCollections;
    stream << obj.mAncestors;
    stream << obj.mAttributes;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchCollectionsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mName;
    stream >> obj.mIsVirtual;
    stream >> obj.mReferenced;
    stream >> obj.mIndexPref;
    stream >> obj.mSyncPref;
    stream >> obj.mDisplayPref;
    stream >> obj.mEnabled;
    stream >> obj.mCachePolicy;
    stream >> obj.mStatistics;
    stream >> obj.mId;
    stream >> obj.mParentId;
    stream >> obj.mMimeTypes;
    stream >> obj.mRemoteId;
    stream >> obj.mRemoteRevision;
    stream >> obj.mResource;
    stream >> obj.mSearchQuery;
    stream >> obj.mSearchCollections;
    stream >> obj.mAncestors;
    stream >> obj.mAttributes;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchCollectionsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
        << "name:" << obj.mName << "\n"
        << "isVirtual:" << obj.mIsVirtual << "\n"
        << "referenced:" << obj.mReferenced << "\n"
        << "indexPref:" << obj.mIndexPref << "\n"
        << "syncPref:" << obj.mSyncPref << "\n"
        << "displayPref:" << obj.mDisplayPref << "\n"
        << "enabled:" << obj.mEnabled << "\n"
        << "cachePolicy:" << obj.mCachePolicy << "\n"
        << "statistics:" << obj.mStatistics << "\n"
        << "id:" << obj.mId << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "resource:" << obj.mResource << "\n"
        << "searchQuery:" << obj.mSearchQuery << "\n"
        << "searchCollections:" << obj.mSearchCollections << "\n"
        << "ancestors:" << obj.mAncestors << "\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
}



/************************* ModifyCollectionCommand *************************/

ModifyCollectionCommand::ModifyCollectionCommand()
    : Command(Command::ModifyCollection)
    , mParentId(-1)
    , mModifiedParts(None)
    , mPersistentSearchRecursive(false)
    , mPersistentSearchRemote(false)
    , mEnabled(true)
    , mSyncPref(Tristate::Undefined)
    , mDisplayPref(Tristate::Undefined)
    , mIndexPref(Tristate::Undefined)
    , mReferenced(false)
{
}

ModifyCollectionCommand::ModifyCollectionCommand(const Scope &collection)
    : Command(Command::ModifyCollection)
    , mCollection(collection)
    , mParentId(-1)
    , mModifiedParts(None)
    , mPersistentSearchRecursive(false)
    , mPersistentSearchRemote(false)
    , mEnabled(true)
    , mSyncPref(Tristate::Undefined)
    , mDisplayPref(Tristate::Undefined)
    , mIndexPref(Tristate::Undefined)
    , mReferenced(false)
{
}

ModifyCollectionCommand::ModifyCollectionCommand(const ModifyCollectionCommand&other)
    : Command(other)
    , mCollection(other.mCollection)
    , mAttributes(other.mAttributes)
    , mRemovedAttributes(other.mRemovedAttributes)
    , mPersistentSearchCollections(other.mPersistentSearchCollections)
    , mPersistentSearchQuery(other.mPersistentSearchQuery)
    , mRemoteRevision(other.mRemoteRevision)
    , mRemoteId(other.mRemoteId)
    , mName(other.mName)
    , mMimeTypes(other.mMimeTypes)
    , mParentId(other.mParentId)
    , mCachePolicy(other.mCachePolicy)
    , mModifiedParts(other.mModifiedParts)
    , mPersistentSearchRecursive(other.mPersistentSearchRecursive)
    , mPersistentSearchRemote(other.mPersistentSearchRemote)
    , mEnabled(other.mEnabled)
    , mSyncPref(other.mSyncPref)
    , mDisplayPref(other.mDisplayPref)
    , mIndexPref(other.mIndexPref)
    , mReferenced(other.mReferenced)
{
}

ModifyCollectionCommand::~ModifyCollectionCommand()
{
}

ModifyCollectionCommand &ModifyCollectionCommand::operator=(const ModifyCollectionCommand &other)
{
    Command::operator=(other);
    mCollection = other.mCollection;
    mAttributes = other.mAttributes;
    mRemovedAttributes = other.mRemovedAttributes;
    mPersistentSearchCollections = other.mPersistentSearchCollections;
    mPersistentSearchQuery = other.mPersistentSearchQuery;
    mRemoteRevision = other.mRemoteRevision;
    mRemoteId = other.mRemoteId;
    mName = other.mName;
    mMimeTypes = other.mMimeTypes;
    mParentId = other.mParentId;
    mCachePolicy = other.mCachePolicy;
    mModifiedParts = other.mModifiedParts;
    mPersistentSearchRecursive = other.mPersistentSearchRecursive;
    mPersistentSearchRemote = other.mPersistentSearchRemote;
    mEnabled = other.mEnabled;
    mSyncPref = other.mSyncPref;
    mDisplayPref = other.mDisplayPref;
    mIndexPref = other.mIndexPref;
    mReferenced = other.mReferenced;
    return *this;
}

bool ModifyCollectionCommand::operator==(const ModifyCollectionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
        && mAttributes == other.mAttributes
        && mRemovedAttributes == other.mRemovedAttributes
        && mPersistentSearchCollections == other.mPersistentSearchCollections
        && mPersistentSearchQuery == other.mPersistentSearchQuery
        && mRemoteRevision == other.mRemoteRevision
        && mRemoteId == other.mRemoteId
        && mName == other.mName
        && mMimeTypes == other.mMimeTypes
        && mParentId == other.mParentId
        && mCachePolicy == other.mCachePolicy
        && mModifiedParts == other.mModifiedParts
        && mPersistentSearchRecursive == other.mPersistentSearchRecursive
        && mPersistentSearchRemote == other.mPersistentSearchRemote
        && mEnabled == other.mEnabled
        && mSyncPref == other.mSyncPref
        && mDisplayPref == other.mDisplayPref
        && mIndexPref == other.mIndexPref
        && mReferenced == other.mReferenced
    ;
}

void ModifyCollectionCommand::setAttributes(const Akonadi::Protocol::Attributes &val)
{
    mAttributes = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::Attributes);
}

void ModifyCollectionCommand::setRemovedAttributes(const QSet<QByteArray> &val)
{
    mRemovedAttributes = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::RemovedAttributes);
}

void ModifyCollectionCommand::setPersistentSearchCollections(const QVector<qint64> &val)
{
    mPersistentSearchCollections = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::PersistentSearch);
}

void ModifyCollectionCommand::setPersistentSearchQuery(const QString &val)
{
    mPersistentSearchQuery = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::PersistentSearch);
}

void ModifyCollectionCommand::setRemoteRevision(const QString &val)
{
    mRemoteRevision = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::RemoteRevision);
}

void ModifyCollectionCommand::setRemoteId(const QString &val)
{
    mRemoteId = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::RemoteID);
}

void ModifyCollectionCommand::setName(const QString &val)
{
    mName = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::Name);
}

void ModifyCollectionCommand::setMimeTypes(const QStringList &val)
{
    mMimeTypes = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::MimeTypes);
}

void ModifyCollectionCommand::setParentId(qint64 val)
{
    mParentId = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::ParentID);
}

void ModifyCollectionCommand::setCachePolicy(const Akonadi::Protocol::CachePolicy &val)
{
    mCachePolicy = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::CachePolicy);
}

void ModifyCollectionCommand::setPersistentSearchRecursive(bool val)
{
    mPersistentSearchRecursive = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::PersistentSearch);
}

void ModifyCollectionCommand::setPersistentSearchRemote(bool val)
{
    mPersistentSearchRemote = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::PersistentSearch);
}

void ModifyCollectionCommand::setEnabled(bool val)
{
    mEnabled = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::ListPreferences);
}

void ModifyCollectionCommand::setSyncPref(const Tristate &val)
{
    mSyncPref = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::ListPreferences);
}

void ModifyCollectionCommand::setDisplayPref(const Tristate &val)
{
    mDisplayPref = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::ListPreferences);
}

void ModifyCollectionCommand::setIndexPref(const Tristate &val)
{
    mIndexPref = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::ListPreferences);
}

void ModifyCollectionCommand::setReferenced(bool val)
{
    mReferenced = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::Referenced);
}

DataStream &operator<<(DataStream &stream, const ModifyCollectionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mModifiedParts;
    stream << obj.mCollection;
    if ((obj.mModifiedParts & ModifyCollectionCommand::ParentID)) {
        stream << obj.mParentId;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::Referenced)) {
        stream << obj.mReferenced;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream << obj.mIndexPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream << obj.mDisplayPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream << obj.mSyncPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream << obj.mEnabled;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream << obj.mPersistentSearchRemote;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream << obj.mPersistentSearchRecursive;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::CachePolicy)) {
        stream << obj.mCachePolicy;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::MimeTypes)) {
        stream << obj.mMimeTypes;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::Name)) {
        stream << obj.mName;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemoteID)) {
        stream << obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemoteRevision)) {
        stream << obj.mRemoteRevision;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream << obj.mPersistentSearchQuery;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream << obj.mPersistentSearchCollections;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemovedAttributes)) {
        stream << obj.mRemovedAttributes;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::Attributes)) {
        stream << obj.mAttributes;
    }
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyCollectionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mModifiedParts;
    stream >> obj.mCollection;
    if ((obj.mModifiedParts & ModifyCollectionCommand::ParentID)) {
        stream >> obj.mParentId;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::Referenced)) {
        stream >> obj.mReferenced;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream >> obj.mIndexPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream >> obj.mDisplayPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream >> obj.mSyncPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream >> obj.mEnabled;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream >> obj.mPersistentSearchRemote;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream >> obj.mPersistentSearchRecursive;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::CachePolicy)) {
        stream >> obj.mCachePolicy;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::MimeTypes)) {
        stream >> obj.mMimeTypes;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::Name)) {
        stream >> obj.mName;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemoteID)) {
        stream >> obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemoteRevision)) {
        stream >> obj.mRemoteRevision;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream >> obj.mPersistentSearchQuery;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream >> obj.mPersistentSearchCollections;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemovedAttributes)) {
        stream >> obj.mRemovedAttributes;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::Attributes)) {
        stream >> obj.mAttributes;
    }
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyCollectionCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "modifiedParts:" << obj.mModifiedParts << "\n"
        << "collection:" << obj.mCollection << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "referenced:" << obj.mReferenced << "\n"
        << "indexPref:" << obj.mIndexPref << "\n"
        << "displayPref:" << obj.mDisplayPref << "\n"
        << "syncPref:" << obj.mSyncPref << "\n"
        << "enabled:" << obj.mEnabled << "\n"
        << "persistentSearchRemote:" << obj.mPersistentSearchRemote << "\n"
        << "persistentSearchRecursive:" << obj.mPersistentSearchRecursive << "\n"
        << "cachePolicy:" << obj.mCachePolicy << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "name:" << obj.mName << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "persistentSearchQuery:" << obj.mPersistentSearchQuery << "\n"
        << "persistentSearchCollections:" << obj.mPersistentSearchCollections << "\n"
        << "removedAttributes:" << obj.mRemovedAttributes << "\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
}



/************************* ModifyCollectionResponse *************************/

ModifyCollectionResponse::ModifyCollectionResponse()
    : Response(Command::ModifyCollection)
{
}

ModifyCollectionResponse::ModifyCollectionResponse(const ModifyCollectionResponse&other)
    : Response(other)
{
}

ModifyCollectionResponse::~ModifyCollectionResponse()
{
}

ModifyCollectionResponse &ModifyCollectionResponse::operator=(const ModifyCollectionResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool ModifyCollectionResponse::operator==(const ModifyCollectionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const ModifyCollectionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyCollectionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyCollectionResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* MoveCollectionCommand *************************/

MoveCollectionCommand::MoveCollectionCommand()
    : Command(Command::MoveCollection)
{
}

MoveCollectionCommand::MoveCollectionCommand(const Scope &collection, const Scope &destination)
    : Command(Command::MoveCollection)
    , mCollection(collection)
    , mDestination(destination)
{
}

MoveCollectionCommand::MoveCollectionCommand(const MoveCollectionCommand&other)
    : Command(other)
    , mCollection(other.mCollection)
    , mDestination(other.mDestination)
{
}

MoveCollectionCommand::~MoveCollectionCommand()
{
}

MoveCollectionCommand &MoveCollectionCommand::operator=(const MoveCollectionCommand &other)
{
    Command::operator=(other);
    mCollection = other.mCollection;
    mDestination = other.mDestination;
    return *this;
}

bool MoveCollectionCommand::operator==(const MoveCollectionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
        && mDestination == other.mDestination
    ;
}

DataStream &operator<<(DataStream &stream, const MoveCollectionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mCollection;
    stream << obj.mDestination;
    return stream;
}

DataStream &operator>>(DataStream &stream, MoveCollectionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mCollection;
    stream >> obj.mDestination;
    return stream;
}

QDebug operator<<(QDebug dbg, const MoveCollectionCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "collection:" << obj.mCollection << "\n"
        << "destination:" << obj.mDestination << "\n"
    ;
}



/************************* MoveCollectionResponse *************************/

MoveCollectionResponse::MoveCollectionResponse()
    : Response(Command::MoveCollection)
{
}

MoveCollectionResponse::MoveCollectionResponse(const MoveCollectionResponse&other)
    : Response(other)
{
}

MoveCollectionResponse::~MoveCollectionResponse()
{
}

MoveCollectionResponse &MoveCollectionResponse::operator=(const MoveCollectionResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool MoveCollectionResponse::operator==(const MoveCollectionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const MoveCollectionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, MoveCollectionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const MoveCollectionResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* SearchCommand *************************/

SearchCommand::SearchCommand()
    : Command(Command::Search)
    , mRecursive(false)
    , mRemote(false)
{
}

SearchCommand::SearchCommand(const QString &query)
    : Command(Command::Search)
    , mQuery(query)
    , mRecursive(false)
    , mRemote(false)
{
}

SearchCommand::SearchCommand(const SearchCommand&other)
    : Command(other)
    , mMimeTypes(other.mMimeTypes)
    , mCollections(other.mCollections)
    , mQuery(other.mQuery)
    , mFetchScope(other.mFetchScope)
    , mRecursive(other.mRecursive)
    , mRemote(other.mRemote)
{
}

SearchCommand::~SearchCommand()
{
}

SearchCommand &SearchCommand::operator=(const SearchCommand &other)
{
    Command::operator=(other);
    mMimeTypes = other.mMimeTypes;
    mCollections = other.mCollections;
    mQuery = other.mQuery;
    mFetchScope = other.mFetchScope;
    mRecursive = other.mRecursive;
    mRemote = other.mRemote;
    return *this;
}

bool SearchCommand::operator==(const SearchCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mMimeTypes == other.mMimeTypes
        && mCollections == other.mCollections
        && mQuery == other.mQuery
        && mFetchScope == other.mFetchScope
        && mRecursive == other.mRecursive
        && mRemote == other.mRemote
    ;
}

DataStream &operator<<(DataStream &stream, const SearchCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mMimeTypes;
    stream << obj.mCollections;
    stream << obj.mQuery;
    stream << obj.mFetchScope;
    stream << obj.mRecursive;
    stream << obj.mRemote;
    return stream;
}

DataStream &operator>>(DataStream &stream, SearchCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mMimeTypes;
    stream >> obj.mCollections;
    stream >> obj.mQuery;
    stream >> obj.mFetchScope;
    stream >> obj.mRecursive;
    stream >> obj.mRemote;
    return stream;
}

QDebug operator<<(QDebug dbg, const SearchCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "collections:" << obj.mCollections << "\n"
        << "query:" << obj.mQuery << "\n"
        << "fetchScope:" << obj.mFetchScope << "\n"
        << "recursive:" << obj.mRecursive << "\n"
        << "remote:" << obj.mRemote << "\n"
    ;
}



/************************* SearchResponse *************************/

SearchResponse::SearchResponse()
    : Response(Command::Search)
{
}

SearchResponse::SearchResponse(const SearchResponse&other)
    : Response(other)
{
}

SearchResponse::~SearchResponse()
{
}

SearchResponse &SearchResponse::operator=(const SearchResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool SearchResponse::operator==(const SearchResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const SearchResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, SearchResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const SearchResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* SearchResultCommand *************************/

SearchResultCommand::SearchResultCommand()
    : Command(Command::SearchResult)
    , mCollectionId(-1)
{
}

SearchResultCommand::SearchResultCommand(const QByteArray &searchId, qint64 collectionId, const Scope &result)
    : Command(Command::SearchResult)
    , mSearchId(searchId)
    , mCollectionId(collectionId)
    , mResult(result)
{
}

SearchResultCommand::SearchResultCommand(const SearchResultCommand&other)
    : Command(other)
    , mSearchId(other.mSearchId)
    , mCollectionId(other.mCollectionId)
    , mResult(other.mResult)
{
}

SearchResultCommand::~SearchResultCommand()
{
}

SearchResultCommand &SearchResultCommand::operator=(const SearchResultCommand &other)
{
    Command::operator=(other);
    mSearchId = other.mSearchId;
    mCollectionId = other.mCollectionId;
    mResult = other.mResult;
    return *this;
}

bool SearchResultCommand::operator==(const SearchResultCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mSearchId == other.mSearchId
        && mCollectionId == other.mCollectionId
        && mResult == other.mResult
    ;
}

DataStream &operator<<(DataStream &stream, const SearchResultCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mSearchId;
    stream << obj.mCollectionId;
    stream << obj.mResult;
    return stream;
}

DataStream &operator>>(DataStream &stream, SearchResultCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mSearchId;
    stream >> obj.mCollectionId;
    stream >> obj.mResult;
    return stream;
}

QDebug operator<<(QDebug dbg, const SearchResultCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "searchId:" << obj.mSearchId << "\n"
        << "collectionId:" << obj.mCollectionId << "\n"
        << "result:" << obj.mResult << "\n"
    ;
}



/************************* SearchResultResponse *************************/

SearchResultResponse::SearchResultResponse()
    : Response(Command::SearchResult)
{
}

SearchResultResponse::SearchResultResponse(const SearchResultResponse&other)
    : Response(other)
{
}

SearchResultResponse::~SearchResultResponse()
{
}

SearchResultResponse &SearchResultResponse::operator=(const SearchResultResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool SearchResultResponse::operator==(const SearchResultResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const SearchResultResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, SearchResultResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const SearchResultResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* StoreSearchCommand *************************/

StoreSearchCommand::StoreSearchCommand()
    : Command(Command::StoreSearch)
    , mRemote(false)
    , mRecursive(false)
{
}

StoreSearchCommand::StoreSearchCommand(const StoreSearchCommand&other)
    : Command(other)
    , mName(other.mName)
    , mQuery(other.mQuery)
    , mMimeTypes(other.mMimeTypes)
    , mQueryCollections(other.mQueryCollections)
    , mRemote(other.mRemote)
    , mRecursive(other.mRecursive)
{
}

StoreSearchCommand::~StoreSearchCommand()
{
}

StoreSearchCommand &StoreSearchCommand::operator=(const StoreSearchCommand &other)
{
    Command::operator=(other);
    mName = other.mName;
    mQuery = other.mQuery;
    mMimeTypes = other.mMimeTypes;
    mQueryCollections = other.mQueryCollections;
    mRemote = other.mRemote;
    mRecursive = other.mRecursive;
    return *this;
}

bool StoreSearchCommand::operator==(const StoreSearchCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mName == other.mName
        && mQuery == other.mQuery
        && mMimeTypes == other.mMimeTypes
        && mQueryCollections == other.mQueryCollections
        && mRemote == other.mRemote
        && mRecursive == other.mRecursive
    ;
}

DataStream &operator<<(DataStream &stream, const StoreSearchCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mName;
    stream << obj.mQuery;
    stream << obj.mMimeTypes;
    stream << obj.mQueryCollections;
    stream << obj.mRemote;
    stream << obj.mRecursive;
    return stream;
}

DataStream &operator>>(DataStream &stream, StoreSearchCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mName;
    stream >> obj.mQuery;
    stream >> obj.mMimeTypes;
    stream >> obj.mQueryCollections;
    stream >> obj.mRemote;
    stream >> obj.mRecursive;
    return stream;
}

QDebug operator<<(QDebug dbg, const StoreSearchCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "name:" << obj.mName << "\n"
        << "query:" << obj.mQuery << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "queryCollections:" << obj.mQueryCollections << "\n"
        << "remote:" << obj.mRemote << "\n"
        << "recursive:" << obj.mRecursive << "\n"
    ;
}



/************************* StoreSearchResponse *************************/

StoreSearchResponse::StoreSearchResponse()
    : Response(Command::StoreSearch)
{
}

StoreSearchResponse::StoreSearchResponse(const StoreSearchResponse&other)
    : Response(other)
{
}

StoreSearchResponse::~StoreSearchResponse()
{
}

StoreSearchResponse &StoreSearchResponse::operator=(const StoreSearchResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool StoreSearchResponse::operator==(const StoreSearchResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const StoreSearchResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, StoreSearchResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const StoreSearchResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* CreateTagCommand *************************/

CreateTagCommand::CreateTagCommand()
    : Command(Command::CreateTag)
    , mParentId(-1)
    , mMerge(false)
{
}

CreateTagCommand::CreateTagCommand(const CreateTagCommand&other)
    : Command(other)
    , mGid(other.mGid)
    , mRemoteId(other.mRemoteId)
    , mType(other.mType)
    , mAttributes(other.mAttributes)
    , mParentId(other.mParentId)
    , mMerge(other.mMerge)
{
}

CreateTagCommand::~CreateTagCommand()
{
}

CreateTagCommand &CreateTagCommand::operator=(const CreateTagCommand &other)
{
    Command::operator=(other);
    mGid = other.mGid;
    mRemoteId = other.mRemoteId;
    mType = other.mType;
    mAttributes = other.mAttributes;
    mParentId = other.mParentId;
    mMerge = other.mMerge;
    return *this;
}

bool CreateTagCommand::operator==(const CreateTagCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mGid == other.mGid
        && mRemoteId == other.mRemoteId
        && mType == other.mType
        && mAttributes == other.mAttributes
        && mParentId == other.mParentId
        && mMerge == other.mMerge
    ;
}

DataStream &operator<<(DataStream &stream, const CreateTagCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mGid;
    stream << obj.mRemoteId;
    stream << obj.mType;
    stream << obj.mAttributes;
    stream << obj.mParentId;
    stream << obj.mMerge;
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateTagCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mGid;
    stream >> obj.mRemoteId;
    stream >> obj.mType;
    stream >> obj.mAttributes;
    stream >> obj.mParentId;
    stream >> obj.mMerge;
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateTagCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "gid:" << obj.mGid << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "type:" << obj.mType << "\n"
        << "attributes:" << obj.mAttributes << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "merge:" << obj.mMerge << "\n"
    ;
}



/************************* CreateTagResponse *************************/

CreateTagResponse::CreateTagResponse()
    : Response(Command::CreateTag)
{
}

CreateTagResponse::CreateTagResponse(const CreateTagResponse&other)
    : Response(other)
{
}

CreateTagResponse::~CreateTagResponse()
{
}

CreateTagResponse &CreateTagResponse::operator=(const CreateTagResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool CreateTagResponse::operator==(const CreateTagResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CreateTagResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateTagResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateTagResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* DeleteTagCommand *************************/

DeleteTagCommand::DeleteTagCommand()
    : Command(Command::DeleteTag)
{
}

DeleteTagCommand::DeleteTagCommand(const Scope &tag)
    : Command(Command::DeleteTag)
    , mTag(tag)
{
}

DeleteTagCommand::DeleteTagCommand(const DeleteTagCommand&other)
    : Command(other)
    , mTag(other.mTag)
{
}

DeleteTagCommand::~DeleteTagCommand()
{
}

DeleteTagCommand &DeleteTagCommand::operator=(const DeleteTagCommand &other)
{
    Command::operator=(other);
    mTag = other.mTag;
    return *this;
}

bool DeleteTagCommand::operator==(const DeleteTagCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mTag == other.mTag
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteTagCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mTag;
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteTagCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mTag;
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteTagCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "tag:" << obj.mTag << "\n"
    ;
}



/************************* DeleteTagResponse *************************/

DeleteTagResponse::DeleteTagResponse()
    : Response(Command::DeleteTag)
{
}

DeleteTagResponse::DeleteTagResponse(const DeleteTagResponse&other)
    : Response(other)
{
}

DeleteTagResponse::~DeleteTagResponse()
{
}

DeleteTagResponse &DeleteTagResponse::operator=(const DeleteTagResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool DeleteTagResponse::operator==(const DeleteTagResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteTagResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteTagResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteTagResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* ModifyTagCommand *************************/

ModifyTagCommand::ModifyTagCommand()
    : Command(Command::ModifyTag)
    , mTagId(-1)
    , mParentId(-1)
    , mModifiedParts(None)
{
}

ModifyTagCommand::ModifyTagCommand(qint64 tagId)
    : Command(Command::ModifyTag)
    , mTagId(tagId)
    , mParentId(-1)
    , mModifiedParts(None)
{
}

ModifyTagCommand::ModifyTagCommand(const ModifyTagCommand&other)
    : Command(other)
    , mTagId(other.mTagId)
    , mParentId(other.mParentId)
    , mType(other.mType)
    , mRemoteId(other.mRemoteId)
    , mRemovedAttributes(other.mRemovedAttributes)
    , mAttributes(other.mAttributes)
    , mModifiedParts(other.mModifiedParts)
{
}

ModifyTagCommand::~ModifyTagCommand()
{
}

ModifyTagCommand &ModifyTagCommand::operator=(const ModifyTagCommand &other)
{
    Command::operator=(other);
    mTagId = other.mTagId;
    mParentId = other.mParentId;
    mType = other.mType;
    mRemoteId = other.mRemoteId;
    mRemovedAttributes = other.mRemovedAttributes;
    mAttributes = other.mAttributes;
    mModifiedParts = other.mModifiedParts;
    return *this;
}

bool ModifyTagCommand::operator==(const ModifyTagCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mTagId == other.mTagId
        && mParentId == other.mParentId
        && mType == other.mType
        && mRemoteId == other.mRemoteId
        && mRemovedAttributes == other.mRemovedAttributes
        && mAttributes == other.mAttributes
        && mModifiedParts == other.mModifiedParts
    ;
}

void ModifyTagCommand::setParentId(qint64 val)
{
    mParentId = val;
    mModifiedParts |= ModifyTagCommand::ModifiedParts(ModifyTagCommand::ParentId);
}

void ModifyTagCommand::setType(const QByteArray &val)
{
    mType = val;
    mModifiedParts |= ModifyTagCommand::ModifiedParts(ModifyTagCommand::Type);
}

void ModifyTagCommand::setRemoteId(const QByteArray &val)
{
    mRemoteId = val;
    mModifiedParts |= ModifyTagCommand::ModifiedParts(ModifyTagCommand::RemoteId);
}

void ModifyTagCommand::setRemovedAttributes(const QSet<QByteArray> &val)
{
    mRemovedAttributes = val;
    mModifiedParts |= ModifyTagCommand::ModifiedParts(ModifyTagCommand::RemovedAttributes);
}

void ModifyTagCommand::setAttributes(const Akonadi::Protocol::Attributes &val)
{
    mAttributes = val;
    mModifiedParts |= ModifyTagCommand::ModifiedParts(ModifyTagCommand::Attributes);
}

DataStream &operator<<(DataStream &stream, const ModifyTagCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mTagId;
    stream << obj.mModifiedParts;
    if ((obj.mModifiedParts & ModifyTagCommand::ParentId)) {
        stream << obj.mParentId;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::Type)) {
        stream << obj.mType;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::RemoteId)) {
        stream << obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::RemovedAttributes)) {
        stream << obj.mRemovedAttributes;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::Attributes)) {
        stream << obj.mAttributes;
    }
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyTagCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mTagId;
    stream >> obj.mModifiedParts;
    if ((obj.mModifiedParts & ModifyTagCommand::ParentId)) {
        stream >> obj.mParentId;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::Type)) {
        stream >> obj.mType;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::RemoteId)) {
        stream >> obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::RemovedAttributes)) {
        stream >> obj.mRemovedAttributes;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::Attributes)) {
        stream >> obj.mAttributes;
    }
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyTagCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "tagId:" << obj.mTagId << "\n"
        << "modifiedParts:" << obj.mModifiedParts << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "type:" << obj.mType << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "removedAttributes:" << obj.mRemovedAttributes << "\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
}



/************************* ModifyTagResponse *************************/

ModifyTagResponse::ModifyTagResponse()
    : Response(Command::ModifyTag)
{
}

ModifyTagResponse::ModifyTagResponse(const ModifyTagResponse&other)
    : Response(other)
{
}

ModifyTagResponse::~ModifyTagResponse()
{
}

ModifyTagResponse &ModifyTagResponse::operator=(const ModifyTagResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool ModifyTagResponse::operator==(const ModifyTagResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const ModifyTagResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyTagResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyTagResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* ModifyRelationCommand *************************/

ModifyRelationCommand::ModifyRelationCommand()
    : Command(Command::ModifyRelation)
    , mLeft(-1)
    , mRight(-1)
{
}

ModifyRelationCommand::ModifyRelationCommand(qint64 left, qint64 right, const QByteArray &type, const QByteArray &remoteId)
    : Command(Command::ModifyRelation)
    , mLeft(left)
    , mRight(right)
    , mType(type)
    , mRemoteId(remoteId)
{
}

ModifyRelationCommand::ModifyRelationCommand(const ModifyRelationCommand&other)
    : Command(other)
    , mLeft(other.mLeft)
    , mRight(other.mRight)
    , mType(other.mType)
    , mRemoteId(other.mRemoteId)
{
}

ModifyRelationCommand::~ModifyRelationCommand()
{
}

ModifyRelationCommand &ModifyRelationCommand::operator=(const ModifyRelationCommand &other)
{
    Command::operator=(other);
    mLeft = other.mLeft;
    mRight = other.mRight;
    mType = other.mType;
    mRemoteId = other.mRemoteId;
    return *this;
}

bool ModifyRelationCommand::operator==(const ModifyRelationCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mLeft == other.mLeft
        && mRight == other.mRight
        && mType == other.mType
        && mRemoteId == other.mRemoteId
    ;
}

DataStream &operator<<(DataStream &stream, const ModifyRelationCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mLeft;
    stream << obj.mRight;
    stream << obj.mType;
    stream << obj.mRemoteId;
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyRelationCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mLeft;
    stream >> obj.mRight;
    stream >> obj.mType;
    stream >> obj.mRemoteId;
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyRelationCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "left:" << obj.mLeft << "\n"
        << "right:" << obj.mRight << "\n"
        << "type:" << obj.mType << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
    ;
}



/************************* ModifyRelationResponse *************************/

ModifyRelationResponse::ModifyRelationResponse()
    : Response(Command::ModifyRelation)
{
}

ModifyRelationResponse::ModifyRelationResponse(const ModifyRelationResponse&other)
    : Response(other)
{
}

ModifyRelationResponse::~ModifyRelationResponse()
{
}

ModifyRelationResponse &ModifyRelationResponse::operator=(const ModifyRelationResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool ModifyRelationResponse::operator==(const ModifyRelationResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const ModifyRelationResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyRelationResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyRelationResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* RemoveRelationsCommand *************************/

RemoveRelationsCommand::RemoveRelationsCommand()
    : Command(Command::RemoveRelations)
    , mLeft(-1)
    , mRight(-1)
{
}

RemoveRelationsCommand::RemoveRelationsCommand(qint64 left, qint64 right, const QByteArray &type)
    : Command(Command::RemoveRelations)
    , mLeft(left)
    , mRight(right)
    , mType(type)
{
}

RemoveRelationsCommand::RemoveRelationsCommand(const RemoveRelationsCommand&other)
    : Command(other)
    , mLeft(other.mLeft)
    , mRight(other.mRight)
    , mType(other.mType)
{
}

RemoveRelationsCommand::~RemoveRelationsCommand()
{
}

RemoveRelationsCommand &RemoveRelationsCommand::operator=(const RemoveRelationsCommand &other)
{
    Command::operator=(other);
    mLeft = other.mLeft;
    mRight = other.mRight;
    mType = other.mType;
    return *this;
}

bool RemoveRelationsCommand::operator==(const RemoveRelationsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mLeft == other.mLeft
        && mRight == other.mRight
        && mType == other.mType
    ;
}

DataStream &operator<<(DataStream &stream, const RemoveRelationsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mLeft;
    stream << obj.mRight;
    stream << obj.mType;
    return stream;
}

DataStream &operator>>(DataStream &stream, RemoveRelationsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mLeft;
    stream >> obj.mRight;
    stream >> obj.mType;
    return stream;
}

QDebug operator<<(QDebug dbg, const RemoveRelationsCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "left:" << obj.mLeft << "\n"
        << "right:" << obj.mRight << "\n"
        << "type:" << obj.mType << "\n"
    ;
}



/************************* RemoveRelationsResponse *************************/

RemoveRelationsResponse::RemoveRelationsResponse()
    : Response(Command::RemoveRelations)
{
}

RemoveRelationsResponse::RemoveRelationsResponse(const RemoveRelationsResponse&other)
    : Response(other)
{
}

RemoveRelationsResponse::~RemoveRelationsResponse()
{
}

RemoveRelationsResponse &RemoveRelationsResponse::operator=(const RemoveRelationsResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool RemoveRelationsResponse::operator==(const RemoveRelationsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const RemoveRelationsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, RemoveRelationsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const RemoveRelationsResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* SelectResourceCommand *************************/

SelectResourceCommand::SelectResourceCommand()
    : Command(Command::SelectResource)
{
}

SelectResourceCommand::SelectResourceCommand(const QString &resourceId)
    : Command(Command::SelectResource)
    , mResourceId(resourceId)
{
}

SelectResourceCommand::SelectResourceCommand(const SelectResourceCommand&other)
    : Command(other)
    , mResourceId(other.mResourceId)
{
}

SelectResourceCommand::~SelectResourceCommand()
{
}

SelectResourceCommand &SelectResourceCommand::operator=(const SelectResourceCommand &other)
{
    Command::operator=(other);
    mResourceId = other.mResourceId;
    return *this;
}

bool SelectResourceCommand::operator==(const SelectResourceCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mResourceId == other.mResourceId
    ;
}

DataStream &operator<<(DataStream &stream, const SelectResourceCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mResourceId;
    return stream;
}

DataStream &operator>>(DataStream &stream, SelectResourceCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mResourceId;
    return stream;
}

QDebug operator<<(QDebug dbg, const SelectResourceCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "resourceId:" << obj.mResourceId << "\n"
    ;
}



/************************* SelectResourceResponse *************************/

SelectResourceResponse::SelectResourceResponse()
    : Response(Command::SelectResource)
{
}

SelectResourceResponse::SelectResourceResponse(const SelectResourceResponse&other)
    : Response(other)
{
}

SelectResourceResponse::~SelectResourceResponse()
{
}

SelectResourceResponse &SelectResourceResponse::operator=(const SelectResourceResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool SelectResourceResponse::operator==(const SelectResourceResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const SelectResourceResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, SelectResourceResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const SelectResourceResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* StreamPayloadCommand *************************/

StreamPayloadCommand::StreamPayloadCommand()
    : Command(Command::StreamPayload)
    , mRequest(MetaData)
{
}

StreamPayloadCommand::StreamPayloadCommand(const QByteArray &payloadName, const StreamPayloadCommand::Request &request, const QString &destination)
    : Command(Command::StreamPayload)
    , mPayloadName(payloadName)
    , mDestination(destination)
    , mRequest(request)
{
}

StreamPayloadCommand::StreamPayloadCommand(const StreamPayloadCommand&other)
    : Command(other)
    , mPayloadName(other.mPayloadName)
    , mDestination(other.mDestination)
    , mRequest(other.mRequest)
{
}

StreamPayloadCommand::~StreamPayloadCommand()
{
}

StreamPayloadCommand &StreamPayloadCommand::operator=(const StreamPayloadCommand &other)
{
    Command::operator=(other);
    mPayloadName = other.mPayloadName;
    mDestination = other.mDestination;
    mRequest = other.mRequest;
    return *this;
}

bool StreamPayloadCommand::operator==(const StreamPayloadCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mPayloadName == other.mPayloadName
        && mDestination == other.mDestination
        && mRequest == other.mRequest
    ;
}

DataStream &operator<<(DataStream &stream, const StreamPayloadCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mPayloadName;
    stream << obj.mDestination;
    stream << obj.mRequest;
    return stream;
}

DataStream &operator>>(DataStream &stream, StreamPayloadCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mPayloadName;
    stream >> obj.mDestination;
    stream >> obj.mRequest;
    return stream;
}

QDebug operator<<(QDebug dbg, const StreamPayloadCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "payloadName:" << obj.mPayloadName << "\n"
        << "destination:" << obj.mDestination << "\n"
        << "request:" << obj.mRequest << "\n"
    ;
}



/************************* StreamPayloadResponse *************************/

StreamPayloadResponse::StreamPayloadResponse()
    : Response(Command::StreamPayload)
{
}

StreamPayloadResponse::StreamPayloadResponse(const QByteArray &payloadName, const Akonadi::Protocol::PartMetaData &metaData)
    : Response(Command::StreamPayload)
    , mPayloadName(payloadName)
    , mMetaData(metaData)
{
}

StreamPayloadResponse::StreamPayloadResponse(const QByteArray &payloadName, const QByteArray &data)
    : Response(Command::StreamPayload)
    , mPayloadName(payloadName)
    , mData(data)
{
}

StreamPayloadResponse::StreamPayloadResponse(const QByteArray &payloadName, const Akonadi::Protocol::PartMetaData &metaData, const QByteArray &data)
    : Response(Command::StreamPayload)
    , mPayloadName(payloadName)
    , mData(data)
    , mMetaData(metaData)
{
}

StreamPayloadResponse::StreamPayloadResponse(const StreamPayloadResponse&other)
    : Response(other)
    , mPayloadName(other.mPayloadName)
    , mData(other.mData)
    , mMetaData(other.mMetaData)
{
}

StreamPayloadResponse::~StreamPayloadResponse()
{
}

StreamPayloadResponse &StreamPayloadResponse::operator=(const StreamPayloadResponse &other)
{
    Response::operator=(other);
    mPayloadName = other.mPayloadName;
    mData = other.mData;
    mMetaData = other.mMetaData;
    return *this;
}

bool StreamPayloadResponse::operator==(const StreamPayloadResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mPayloadName == other.mPayloadName
        && mData == other.mData
        && mMetaData == other.mMetaData
    ;
}

DataStream &operator<<(DataStream &stream, const StreamPayloadResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mPayloadName;
    stream << obj.mData;
    stream << obj.mMetaData;
    return stream;
}

DataStream &operator>>(DataStream &stream, StreamPayloadResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mPayloadName;
    stream >> obj.mData;
    stream >> obj.mMetaData;
    return stream;
}

QDebug operator<<(QDebug dbg, const StreamPayloadResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
        << "payloadName:" << obj.mPayloadName << "\n"
        << "data:" << obj.mData << "\n"
        << "metaData:" << obj.mMetaData << "\n"
    ;
}



/************************* ItemChangeNotification *************************/

ItemChangeNotification::ItemChangeNotification()
    : ChangeNotification(Command::ItemChangeNotification)
    , mParentCollection(-1)
    , mParentDestCollection(-1)
    , mOperation(InvalidOp)
{
}

ItemChangeNotification::ItemChangeNotification(const ItemChangeNotification&other)
    : ChangeNotification(other)
    , mItems(other.mItems)
    , mResource(other.mResource)
    , mParentCollection(other.mParentCollection)
    , mParentDestCollection(other.mParentDestCollection)
    , mDestinationResource(other.mDestinationResource)
    , mItemParts(other.mItemParts)
    , mAddedFlags(other.mAddedFlags)
    , mRemovedFlags(other.mRemovedFlags)
    , mAddedTags(other.mAddedTags)
    , mRemovedTags(other.mRemovedTags)
    , mAddedRelations(other.mAddedRelations)
    , mRemovedRelations(other.mRemovedRelations)
    , mOperation(other.mOperation)
{
}

ItemChangeNotification::~ItemChangeNotification()
{
}

ItemChangeNotification &ItemChangeNotification::operator=(const ItemChangeNotification &other)
{
    ChangeNotification::operator=(other);
    mItems = other.mItems;
    mResource = other.mResource;
    mParentCollection = other.mParentCollection;
    mParentDestCollection = other.mParentDestCollection;
    mDestinationResource = other.mDestinationResource;
    mItemParts = other.mItemParts;
    mAddedFlags = other.mAddedFlags;
    mRemovedFlags = other.mRemovedFlags;
    mAddedTags = other.mAddedTags;
    mRemovedTags = other.mRemovedTags;
    mAddedRelations = other.mAddedRelations;
    mRemovedRelations = other.mRemovedRelations;
    mOperation = other.mOperation;
    return *this;
}

bool ItemChangeNotification::operator==(const ItemChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mItems == other.mItems
        && mResource == other.mResource
        && mParentCollection == other.mParentCollection
        && mParentDestCollection == other.mParentDestCollection
        && mDestinationResource == other.mDestinationResource
        && mItemParts == other.mItemParts
        && mAddedFlags == other.mAddedFlags
        && mRemovedFlags == other.mRemovedFlags
        && mAddedTags == other.mAddedTags
        && mRemovedTags == other.mRemovedTags
        && mAddedRelations == other.mAddedRelations
        && mRemovedRelations == other.mRemovedRelations
        && mOperation == other.mOperation
    ;
}

DataStream &operator<<(DataStream &stream, const ItemChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mItems;
    stream << obj.mResource;
    stream << obj.mParentCollection;
    stream << obj.mParentDestCollection;
    stream << obj.mDestinationResource;
    stream << obj.mItemParts;
    stream << obj.mAddedFlags;
    stream << obj.mRemovedFlags;
    stream << obj.mAddedTags;
    stream << obj.mRemovedTags;
    stream << obj.mAddedRelations;
    stream << obj.mRemovedRelations;
    stream << obj.mOperation;
    return stream;
}

DataStream &operator>>(DataStream &stream, ItemChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mItems;
    stream >> obj.mResource;
    stream >> obj.mParentCollection;
    stream >> obj.mParentDestCollection;
    stream >> obj.mDestinationResource;
    stream >> obj.mItemParts;
    stream >> obj.mAddedFlags;
    stream >> obj.mRemovedFlags;
    stream >> obj.mAddedTags;
    stream >> obj.mRemovedTags;
    stream >> obj.mAddedRelations;
    stream >> obj.mRemovedRelations;
    stream >> obj.mOperation;
    return stream;
}

QDebug operator<<(QDebug dbg, const ItemChangeNotification &obj)
{
    return dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "items:" << obj.mItems << "\n"
        << "resource:" << obj.mResource << "\n"
        << "parentCollection:" << obj.mParentCollection << "\n"
        << "parentDestCollection:" << obj.mParentDestCollection << "\n"
        << "destinationResource:" << obj.mDestinationResource << "\n"
        << "itemParts:" << obj.mItemParts << "\n"
        << "addedFlags:" << obj.mAddedFlags << "\n"
        << "removedFlags:" << obj.mRemovedFlags << "\n"
        << "addedTags:" << obj.mAddedTags << "\n"
        << "removedTags:" << obj.mRemovedTags << "\n"
        << "addedRelations:" << obj.mAddedRelations << "\n"
        << "removedRelations:" << obj.mRemovedRelations << "\n"
        << "operation:" << obj.mOperation << "\n"
    ;
}



/************************* CollectionChangeNotification *************************/

CollectionChangeNotification::CollectionChangeNotification()
    : ChangeNotification(Command::CollectionChangeNotification)
    , mId(-1)
    , mParentCollection(-1)
    , mParentDestCollection(-1)
    , mOperation(InvalidOp)
{
}

CollectionChangeNotification::CollectionChangeNotification(const CollectionChangeNotification&other)
    : ChangeNotification(other)
    , mId(other.mId)
    , mRemoteId(other.mRemoteId)
    , mRemoteRevision(other.mRemoteRevision)
    , mResource(other.mResource)
    , mParentCollection(other.mParentCollection)
    , mParentDestCollection(other.mParentDestCollection)
    , mDestinationResource(other.mDestinationResource)
    , mChangedParts(other.mChangedParts)
    , mOperation(other.mOperation)
{
}

CollectionChangeNotification::~CollectionChangeNotification()
{
}

CollectionChangeNotification &CollectionChangeNotification::operator=(const CollectionChangeNotification &other)
{
    ChangeNotification::operator=(other);
    mId = other.mId;
    mRemoteId = other.mRemoteId;
    mRemoteRevision = other.mRemoteRevision;
    mResource = other.mResource;
    mParentCollection = other.mParentCollection;
    mParentDestCollection = other.mParentDestCollection;
    mDestinationResource = other.mDestinationResource;
    mChangedParts = other.mChangedParts;
    mOperation = other.mOperation;
    return *this;
}

bool CollectionChangeNotification::operator==(const CollectionChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mId == other.mId
        && mRemoteId == other.mRemoteId
        && mRemoteRevision == other.mRemoteRevision
        && mResource == other.mResource
        && mParentCollection == other.mParentCollection
        && mParentDestCollection == other.mParentDestCollection
        && mDestinationResource == other.mDestinationResource
        && mChangedParts == other.mChangedParts
        && mOperation == other.mOperation
    ;
}

DataStream &operator<<(DataStream &stream, const CollectionChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mId;
    stream << obj.mRemoteId;
    stream << obj.mRemoteRevision;
    stream << obj.mResource;
    stream << obj.mParentCollection;
    stream << obj.mParentDestCollection;
    stream << obj.mDestinationResource;
    stream << obj.mChangedParts;
    stream << obj.mOperation;
    return stream;
}

DataStream &operator>>(DataStream &stream, CollectionChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mId;
    stream >> obj.mRemoteId;
    stream >> obj.mRemoteRevision;
    stream >> obj.mResource;
    stream >> obj.mParentCollection;
    stream >> obj.mParentDestCollection;
    stream >> obj.mDestinationResource;
    stream >> obj.mChangedParts;
    stream >> obj.mOperation;
    return stream;
}

QDebug operator<<(QDebug dbg, const CollectionChangeNotification &obj)
{
    return dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "id:" << obj.mId << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "resource:" << obj.mResource << "\n"
        << "parentCollection:" << obj.mParentCollection << "\n"
        << "parentDestCollection:" << obj.mParentDestCollection << "\n"
        << "destinationResource:" << obj.mDestinationResource << "\n"
        << "changedParts:" << obj.mChangedParts << "\n"
        << "operation:" << obj.mOperation << "\n"
    ;
}



/************************* TagChangeNotification *************************/

TagChangeNotification::TagChangeNotification()
    : ChangeNotification(Command::TagChangeNotification)
    , mId(-1)
    , mOperation(InvalidOp)
{
}

TagChangeNotification::TagChangeNotification(const TagChangeNotification&other)
    : ChangeNotification(other)
    , mId(other.mId)
    , mRemoteId(other.mRemoteId)
    , mResource(other.mResource)
    , mOperation(other.mOperation)
{
}

TagChangeNotification::~TagChangeNotification()
{
}

TagChangeNotification &TagChangeNotification::operator=(const TagChangeNotification &other)
{
    ChangeNotification::operator=(other);
    mId = other.mId;
    mRemoteId = other.mRemoteId;
    mResource = other.mResource;
    mOperation = other.mOperation;
    return *this;
}

bool TagChangeNotification::operator==(const TagChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mId == other.mId
        && mRemoteId == other.mRemoteId
        && mResource == other.mResource
        && mOperation == other.mOperation
    ;
}

DataStream &operator<<(DataStream &stream, const TagChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mId;
    stream << obj.mRemoteId;
    stream << obj.mResource;
    stream << obj.mOperation;
    return stream;
}

DataStream &operator>>(DataStream &stream, TagChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mId;
    stream >> obj.mRemoteId;
    stream >> obj.mResource;
    stream >> obj.mOperation;
    return stream;
}

QDebug operator<<(QDebug dbg, const TagChangeNotification &obj)
{
    return dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "id:" << obj.mId << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "resource:" << obj.mResource << "\n"
        << "operation:" << obj.mOperation << "\n"
    ;
}



/************************* RelationChangeNotification *************************/

RelationChangeNotification::RelationChangeNotification()
    : ChangeNotification(Command::RelationChangeNotification)
    , mLeftItem(-1)
    , mRightItem(-1)
    , mOperation(InvalidOp)
{
}

RelationChangeNotification::RelationChangeNotification(const RelationChangeNotification&other)
    : ChangeNotification(other)
    , mLeftItem(other.mLeftItem)
    , mRightItem(other.mRightItem)
    , mRemoteId(other.mRemoteId)
    , mType(other.mType)
    , mOperation(other.mOperation)
{
}

RelationChangeNotification::~RelationChangeNotification()
{
}

RelationChangeNotification &RelationChangeNotification::operator=(const RelationChangeNotification &other)
{
    ChangeNotification::operator=(other);
    mLeftItem = other.mLeftItem;
    mRightItem = other.mRightItem;
    mRemoteId = other.mRemoteId;
    mType = other.mType;
    mOperation = other.mOperation;
    return *this;
}

bool RelationChangeNotification::operator==(const RelationChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mLeftItem == other.mLeftItem
        && mRightItem == other.mRightItem
        && mRemoteId == other.mRemoteId
        && mType == other.mType
        && mOperation == other.mOperation
    ;
}

DataStream &operator<<(DataStream &stream, const RelationChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mLeftItem;
    stream << obj.mRightItem;
    stream << obj.mRemoteId;
    stream << obj.mType;
    stream << obj.mOperation;
    return stream;
}

DataStream &operator>>(DataStream &stream, RelationChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mLeftItem;
    stream >> obj.mRightItem;
    stream >> obj.mRemoteId;
    stream >> obj.mType;
    stream >> obj.mOperation;
    return stream;
}

QDebug operator<<(QDebug dbg, const RelationChangeNotification &obj)
{
    return dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "leftItem:" << obj.mLeftItem << "\n"
        << "rightItem:" << obj.mRightItem << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "type:" << obj.mType << "\n"
        << "operation:" << obj.mOperation << "\n"
    ;
}



/************************* CreateSubscriptionCommand *************************/

CreateSubscriptionCommand::CreateSubscriptionCommand()
    : Command(Command::CreateSubscription)
{
}

CreateSubscriptionCommand::CreateSubscriptionCommand(const QByteArray &subscriberName, const QByteArray &session)
    : Command(Command::CreateSubscription)
    , mSubscriberName(subscriberName)
    , mSession(session)
{
}

CreateSubscriptionCommand::CreateSubscriptionCommand(const CreateSubscriptionCommand&other)
    : Command(other)
    , mSubscriberName(other.mSubscriberName)
    , mSession(other.mSession)
{
}

CreateSubscriptionCommand::~CreateSubscriptionCommand()
{
}

CreateSubscriptionCommand &CreateSubscriptionCommand::operator=(const CreateSubscriptionCommand &other)
{
    Command::operator=(other);
    mSubscriberName = other.mSubscriberName;
    mSession = other.mSession;
    return *this;
}

bool CreateSubscriptionCommand::operator==(const CreateSubscriptionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mSubscriberName == other.mSubscriberName
        && mSession == other.mSession
    ;
}

DataStream &operator<<(DataStream &stream, const CreateSubscriptionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mSubscriberName;
    stream << obj.mSession;
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateSubscriptionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mSubscriberName;
    stream >> obj.mSession;
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateSubscriptionCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "subscriberName:" << obj.mSubscriberName << "\n"
        << "session:" << obj.mSession << "\n"
    ;
}



/************************* CreateSubscriptionResponse *************************/

CreateSubscriptionResponse::CreateSubscriptionResponse()
    : Response(Command::CreateSubscription)
{
}

CreateSubscriptionResponse::CreateSubscriptionResponse(const CreateSubscriptionResponse&other)
    : Response(other)
{
}

CreateSubscriptionResponse::~CreateSubscriptionResponse()
{
}

CreateSubscriptionResponse &CreateSubscriptionResponse::operator=(const CreateSubscriptionResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool CreateSubscriptionResponse::operator==(const CreateSubscriptionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CreateSubscriptionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateSubscriptionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateSubscriptionResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* ModifySubscriptionCommand *************************/

ModifySubscriptionCommand::ModifySubscriptionCommand()
    : Command(Command::ModifySubscription)
    , mModifiedParts(None)
    , mAllMonitored(false)
    , mIsExclusive(false)
{
}

ModifySubscriptionCommand::ModifySubscriptionCommand(const ModifySubscriptionCommand&other)
    : Command(other)
    , mStopMonitoringTypes(other.mStopMonitoringTypes)
    , mStopIgnoringSessions(other.mStopIgnoringSessions)
    , mStartIgnoringSessions(other.mStartIgnoringSessions)
    , mStopMonitoringMimeTypes(other.mStopMonitoringMimeTypes)
    , mStartMonitoringMimeTypes(other.mStartMonitoringMimeTypes)
    , mStopMonitoringResources(other.mStopMonitoringResources)
    , mStartMonitoringResources(other.mStartMonitoringResources)
    , mStartMonitoringTypes(other.mStartMonitoringTypes)
    , mStopMonitoringTags(other.mStopMonitoringTags)
    , mStartMonitoringTags(other.mStartMonitoringTags)
    , mStopMonitoringItems(other.mStopMonitoringItems)
    , mStartMonitoringItems(other.mStartMonitoringItems)
    , mStopMonitoringCollections(other.mStopMonitoringCollections)
    , mStartMonitoringCollections(other.mStartMonitoringCollections)
    , mSubscriberName(other.mSubscriberName)
    , mModifiedParts(other.mModifiedParts)
    , mAllMonitored(other.mAllMonitored)
    , mIsExclusive(other.mIsExclusive)
{
}

ModifySubscriptionCommand::~ModifySubscriptionCommand()
{
}

ModifySubscriptionCommand &ModifySubscriptionCommand::operator=(const ModifySubscriptionCommand &other)
{
    Command::operator=(other);
    mStopMonitoringTypes = other.mStopMonitoringTypes;
    mStopIgnoringSessions = other.mStopIgnoringSessions;
    mStartIgnoringSessions = other.mStartIgnoringSessions;
    mStopMonitoringMimeTypes = other.mStopMonitoringMimeTypes;
    mStartMonitoringMimeTypes = other.mStartMonitoringMimeTypes;
    mStopMonitoringResources = other.mStopMonitoringResources;
    mStartMonitoringResources = other.mStartMonitoringResources;
    mStartMonitoringTypes = other.mStartMonitoringTypes;
    mStopMonitoringTags = other.mStopMonitoringTags;
    mStartMonitoringTags = other.mStartMonitoringTags;
    mStopMonitoringItems = other.mStopMonitoringItems;
    mStartMonitoringItems = other.mStartMonitoringItems;
    mStopMonitoringCollections = other.mStopMonitoringCollections;
    mStartMonitoringCollections = other.mStartMonitoringCollections;
    mSubscriberName = other.mSubscriberName;
    mModifiedParts = other.mModifiedParts;
    mAllMonitored = other.mAllMonitored;
    mIsExclusive = other.mIsExclusive;
    return *this;
}

bool ModifySubscriptionCommand::operator==(const ModifySubscriptionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mStopMonitoringTypes == other.mStopMonitoringTypes
        && mStopIgnoringSessions == other.mStopIgnoringSessions
        && mStartIgnoringSessions == other.mStartIgnoringSessions
        && mStopMonitoringMimeTypes == other.mStopMonitoringMimeTypes
        && mStartMonitoringMimeTypes == other.mStartMonitoringMimeTypes
        && mStopMonitoringResources == other.mStopMonitoringResources
        && mStartMonitoringResources == other.mStartMonitoringResources
        && mStartMonitoringTypes == other.mStartMonitoringTypes
        && mStopMonitoringTags == other.mStopMonitoringTags
        && mStartMonitoringTags == other.mStartMonitoringTags
        && mStopMonitoringItems == other.mStopMonitoringItems
        && mStartMonitoringItems == other.mStartMonitoringItems
        && mStopMonitoringCollections == other.mStopMonitoringCollections
        && mStartMonitoringCollections == other.mStartMonitoringCollections
        && mSubscriberName == other.mSubscriberName
        && mModifiedParts == other.mModifiedParts
        && mAllMonitored == other.mAllMonitored
        && mIsExclusive == other.mIsExclusive
    ;
}

void ModifySubscriptionCommand::stopMonitoringType(const ModifySubscriptionCommand::ChangeType &val)
{
    mStopMonitoringTypes << val;
    auto it = std::find(mStartMonitoringTypes.begin(), mStartMonitoringTypes.end(), val);
    if (it != mStartMonitoringTypes.end()) {
        mStartMonitoringTypes.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Types);
}

void ModifySubscriptionCommand::stopIgnoringSession(const QByteArray &val)
{
    mStopIgnoringSessions << val;
    auto it = std::find(mStartIgnoringSessions.begin(), mStartIgnoringSessions.end(), val);
    if (it != mStartIgnoringSessions.end()) {
        mStartIgnoringSessions.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Sessions);
}

void ModifySubscriptionCommand::startIgnoringSession(const QByteArray &val)
{
    mStartIgnoringSessions << val;
    auto it = std::find(mStopIgnoringSessions.begin(), mStopIgnoringSessions.end(), val);
    if (it != mStopIgnoringSessions.end()) {
        mStopIgnoringSessions.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Sessions);
}

void ModifySubscriptionCommand::stopMonitoringMimeType(const QString &val)
{
    mStopMonitoringMimeTypes << val;
    auto it = std::find(mStartMonitoringMimeTypes.begin(), mStartMonitoringMimeTypes.end(), val);
    if (it != mStartMonitoringMimeTypes.end()) {
        mStartMonitoringMimeTypes.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::MimeTypes);
}

void ModifySubscriptionCommand::startMonitoringMimeType(const QString &val)
{
    mStartMonitoringMimeTypes << val;
    auto it = std::find(mStopMonitoringMimeTypes.begin(), mStopMonitoringMimeTypes.end(), val);
    if (it != mStopMonitoringMimeTypes.end()) {
        mStopMonitoringMimeTypes.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::MimeTypes);
}

void ModifySubscriptionCommand::stopMonitoringResource(const QByteArray &val)
{
    mStopMonitoringResources << val;
    auto it = std::find(mStartMonitoringResources.begin(), mStartMonitoringResources.end(), val);
    if (it != mStartMonitoringResources.end()) {
        mStartMonitoringResources.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Resources);
}

void ModifySubscriptionCommand::startMonitoringResource(const QByteArray &val)
{
    mStartMonitoringResources << val;
    auto it = std::find(mStopMonitoringResources.begin(), mStopMonitoringResources.end(), val);
    if (it != mStopMonitoringResources.end()) {
        mStopMonitoringResources.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Resources);
}

void ModifySubscriptionCommand::startMonitoringType(const ModifySubscriptionCommand::ChangeType &val)
{
    mStartMonitoringTypes << val;
    auto it = std::find(mStopMonitoringTypes.begin(), mStopMonitoringTypes.end(), val);
    if (it != mStopMonitoringTypes.end()) {
        mStopMonitoringTypes.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Types);
}

void ModifySubscriptionCommand::stopMonitoringTag(const qint64 &val)
{
    mStopMonitoringTags << val;
    auto it = std::find(mStartMonitoringTags.begin(), mStartMonitoringTags.end(), val);
    if (it != mStartMonitoringTags.end()) {
        mStartMonitoringTags.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Tags);
}

void ModifySubscriptionCommand::startMonitoringTag(const qint64 &val)
{
    mStartMonitoringTags << val;
    auto it = std::find(mStopMonitoringTags.begin(), mStopMonitoringTags.end(), val);
    if (it != mStopMonitoringTags.end()) {
        mStopMonitoringTags.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Tags);
}

void ModifySubscriptionCommand::stopMonitoringItem(const qint64 &val)
{
    mStopMonitoringItems << val;
    auto it = std::find(mStartMonitoringItems.begin(), mStartMonitoringItems.end(), val);
    if (it != mStartMonitoringItems.end()) {
        mStartMonitoringItems.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Items);
}

void ModifySubscriptionCommand::startMonitoringItem(const qint64 &val)
{
    mStartMonitoringItems << val;
    auto it = std::find(mStopMonitoringItems.begin(), mStopMonitoringItems.end(), val);
    if (it != mStopMonitoringItems.end()) {
        mStopMonitoringItems.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Items);
}

void ModifySubscriptionCommand::stopMonitoringCollection(const qint64 &val)
{
    mStopMonitoringCollections << val;
    auto it = std::find(mStartMonitoringCollections.begin(), mStartMonitoringCollections.end(), val);
    if (it != mStartMonitoringCollections.end()) {
        mStartMonitoringCollections.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Collections);
}

void ModifySubscriptionCommand::startMonitoringCollection(const qint64 &val)
{
    mStartMonitoringCollections << val;
    auto it = std::find(mStopMonitoringCollections.begin(), mStopMonitoringCollections.end(), val);
    if (it != mStopMonitoringCollections.end()) {
        mStopMonitoringCollections.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Collections);
}

void ModifySubscriptionCommand::setAllMonitored(bool val)
{
    mAllMonitored = val;
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::AllFlag);
}

void ModifySubscriptionCommand::setIsExclusive(bool val)
{
    mIsExclusive = val;
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::ExclusiveFlag);
}

DataStream &operator<<(DataStream &stream, const ModifySubscriptionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mModifiedParts;
    stream << obj.mSubscriberName;
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Tags) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringTags;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::ExclusiveFlag)) {
        stream << obj.mIsExclusive;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::AllFlag)) {
        stream << obj.mAllMonitored;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Collections) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringCollections;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Collections) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringCollections;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Items) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringItems;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Items) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringItems;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Types) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Tags) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringTags;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Types) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Resources) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringResources;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Resources) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringResources;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::MimeTypes) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringMimeTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::MimeTypes) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringMimeTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Sessions) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartIgnoringSessions;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Sessions) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopIgnoringSessions;
    }
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifySubscriptionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mModifiedParts;
    stream >> obj.mSubscriberName;
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Tags) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringTags;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::ExclusiveFlag)) {
        stream >> obj.mIsExclusive;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::AllFlag)) {
        stream >> obj.mAllMonitored;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Collections) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringCollections;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Collections) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringCollections;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Items) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringItems;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Items) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringItems;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Types) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Tags) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringTags;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Types) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Resources) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringResources;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Resources) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringResources;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::MimeTypes) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringMimeTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::MimeTypes) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringMimeTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Sessions) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartIgnoringSessions;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Sessions) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopIgnoringSessions;
    }
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifySubscriptionCommand &obj)
{
    return dbg.noquote() << static_cast<const Command &>(obj)
        << "modifiedParts:" << obj.mModifiedParts << "\n"
        << "subscriberName:" << obj.mSubscriberName << "\n"
        << "startMonitoringTags:" << obj.mStartMonitoringTags << "\n"
        << "isExclusive:" << obj.mIsExclusive << "\n"
        << "allMonitored:" << obj.mAllMonitored << "\n"
        << "startMonitoringCollections:" << obj.mStartMonitoringCollections << "\n"
        << "stopMonitoringCollections:" << obj.mStopMonitoringCollections << "\n"
        << "startMonitoringItems:" << obj.mStartMonitoringItems << "\n"
        << "stopMonitoringItems:" << obj.mStopMonitoringItems << "\n"
        << "stopMonitoringTypes:" << obj.mStopMonitoringTypes << "\n"
        << "stopMonitoringTags:" << obj.mStopMonitoringTags << "\n"
        << "startMonitoringTypes:" << obj.mStartMonitoringTypes << "\n"
        << "startMonitoringResources:" << obj.mStartMonitoringResources << "\n"
        << "stopMonitoringResources:" << obj.mStopMonitoringResources << "\n"
        << "startMonitoringMimeTypes:" << obj.mStartMonitoringMimeTypes << "\n"
        << "stopMonitoringMimeTypes:" << obj.mStopMonitoringMimeTypes << "\n"
        << "startIgnoringSessions:" << obj.mStartIgnoringSessions << "\n"
        << "stopIgnoringSessions:" << obj.mStopIgnoringSessions << "\n"
    ;
}



/************************* ModifySubscriptionResponse *************************/

ModifySubscriptionResponse::ModifySubscriptionResponse()
    : Response(Command::ModifySubscription)
{
}

ModifySubscriptionResponse::ModifySubscriptionResponse(const ModifySubscriptionResponse&other)
    : Response(other)
{
}

ModifySubscriptionResponse::~ModifySubscriptionResponse()
{
}

ModifySubscriptionResponse &ModifySubscriptionResponse::operator=(const ModifySubscriptionResponse &other)
{
    Response::operator=(other);
    return *this;
}

bool ModifySubscriptionResponse::operator==(const ModifySubscriptionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const ModifySubscriptionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifySubscriptionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifySubscriptionResponse &obj)
{
    return dbg.noquote() << static_cast<const Response &>(obj)
    ;
}



/************************* SubscriptionChangeNotification *************************/

SubscriptionChangeNotification::SubscriptionChangeNotification()
    : ChangeNotification(Command::SubscriptionChangeNotification)
    , mOperation(InvalidOp)
    , mAllMonitored(false)
    , mExclusive(false)
{
}

SubscriptionChangeNotification::SubscriptionChangeNotification(const SubscriptionChangeNotification&other)
    : ChangeNotification(other)
    , mSubscriber(other.mSubscriber)
    , mCollections(other.mCollections)
    , mItems(other.mItems)
    , mTags(other.mTags)
    , mTypes(other.mTypes)
    , mMimeTypes(other.mMimeTypes)
    , mResources(other.mResources)
    , mIgnoredSessions(other.mIgnoredSessions)
    , mOperation(other.mOperation)
    , mAllMonitored(other.mAllMonitored)
    , mExclusive(other.mExclusive)
{
}

SubscriptionChangeNotification::~SubscriptionChangeNotification()
{
}

SubscriptionChangeNotification &SubscriptionChangeNotification::operator=(const SubscriptionChangeNotification &other)
{
    ChangeNotification::operator=(other);
    mSubscriber = other.mSubscriber;
    mCollections = other.mCollections;
    mItems = other.mItems;
    mTags = other.mTags;
    mTypes = other.mTypes;
    mMimeTypes = other.mMimeTypes;
    mResources = other.mResources;
    mIgnoredSessions = other.mIgnoredSessions;
    mOperation = other.mOperation;
    mAllMonitored = other.mAllMonitored;
    mExclusive = other.mExclusive;
    return *this;
}

bool SubscriptionChangeNotification::operator==(const SubscriptionChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mSubscriber == other.mSubscriber
        && mCollections == other.mCollections
        && mItems == other.mItems
        && mTags == other.mTags
        && mTypes == other.mTypes
        && mMimeTypes == other.mMimeTypes
        && mResources == other.mResources
        && mIgnoredSessions == other.mIgnoredSessions
        && mOperation == other.mOperation
        && mAllMonitored == other.mAllMonitored
        && mExclusive == other.mExclusive
    ;
}

DataStream &operator<<(DataStream &stream, const SubscriptionChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mSubscriber;
    stream << obj.mCollections;
    stream << obj.mItems;
    stream << obj.mTags;
    stream << obj.mTypes;
    stream << obj.mMimeTypes;
    stream << obj.mResources;
    stream << obj.mIgnoredSessions;
    stream << obj.mOperation;
    stream << obj.mAllMonitored;
    stream << obj.mExclusive;
    return stream;
}

DataStream &operator>>(DataStream &stream, SubscriptionChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mSubscriber;
    stream >> obj.mCollections;
    stream >> obj.mItems;
    stream >> obj.mTags;
    stream >> obj.mTypes;
    stream >> obj.mMimeTypes;
    stream >> obj.mResources;
    stream >> obj.mIgnoredSessions;
    stream >> obj.mOperation;
    stream >> obj.mAllMonitored;
    stream >> obj.mExclusive;
    return stream;
}

QDebug operator<<(QDebug dbg, const SubscriptionChangeNotification &obj)
{
    return dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "subscriber:" << obj.mSubscriber << "\n"
        << "collections:" << obj.mCollections << "\n"
        << "items:" << obj.mItems << "\n"
        << "tags:" << obj.mTags << "\n"
        << "types:" << obj.mTypes << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "resources:" << obj.mResources << "\n"
        << "ignoredSessions:" << obj.mIgnoredSessions << "\n"
        << "operation:" << obj.mOperation << "\n"
        << "allMonitored:" << obj.mAllMonitored << "\n"
        << "exclusive:" << obj.mExclusive << "\n"
    ;
}



/************************* DebugChangeNotification *************************/

DebugChangeNotification::DebugChangeNotification()
    : ChangeNotification(Command::DebugChangeNotification)
    , mTimestamp(0)
{
}

DebugChangeNotification::DebugChangeNotification(const DebugChangeNotification&other)
    : ChangeNotification(other)
    , mNotification(other.mNotification)
    , mListeners(other.mListeners)
    , mTimestamp(other.mTimestamp)
{
}

DebugChangeNotification::~DebugChangeNotification()
{
}

DebugChangeNotification &DebugChangeNotification::operator=(const DebugChangeNotification &other)
{
    ChangeNotification::operator=(other);
    mNotification = other.mNotification;
    mListeners = other.mListeners;
    mTimestamp = other.mTimestamp;
    return *this;
}

bool DebugChangeNotification::operator==(const DebugChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mNotification == other.mNotification
        && mListeners == other.mListeners
        && mTimestamp == other.mTimestamp
    ;
}

DataStream &operator<<(DataStream &stream, const DebugChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mNotification;
    stream << obj.mListeners;
    stream << obj.mTimestamp;
    return stream;
}

DataStream &operator>>(DataStream &stream, DebugChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mNotification;
    stream >> obj.mListeners;
    stream >> obj.mTimestamp;
    return stream;
}

QDebug operator<<(QDebug dbg, const DebugChangeNotification &obj)
{
    return dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "notification:" << obj.mNotification << "\n"
        << "listeners:" << obj.mListeners << "\n"
        << "timestamp:" << obj.mTimestamp << "\n"
    ;
}

} // namespace Protocol
} // namespace Akonadi
