

/* Copyright 1998 by the Massachusetts Institute of Technology.
 * Copyright (C) 2004 - 2011 by Daniel Stenberg et al
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 */

#include "ares_setup.h"

#include "ares.h"
#include "ares_platform.h"
#include "ares_nowarn.h"
#include "ares_private.h"

#if defined(WIN32) && !defined(MSDOS) || defined(__CYGWIN__)
#include <windows.h>

#define V_PLATFORM_WIN32s         0
#define V_PLATFORM_WIN32_WINDOWS  1
#define V_PLATFORM_WIN32_NT       2
#define V_PLATFORM_WIN32_CE       3

win_platform ares__getplatform(void)
{
  OSVERSIONINFOEX OsvEx;

  memset(&OsvEx, 0, sizeof(OsvEx));
  OsvEx.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable:4996) /* warning C4996: 'GetVersionExW': was declared deprecated */
#endif
  if (!GetVersionEx((void *)&OsvEx))
    {
      memset(&OsvEx, 0, sizeof(OsvEx));
      OsvEx.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
      if (!GetVersionEx((void *)&OsvEx))
        return WIN_UNKNOWN;
    }
#ifdef _MSC_VER
#pragma warning(pop)
#endif

  switch(OsvEx.dwPlatformId)
    {
      case V_PLATFORM_WIN32s:
        return WIN_3X;

      case V_PLATFORM_WIN32_WINDOWS:
        return WIN_9X;

      case V_PLATFORM_WIN32_NT:
        return WIN_NT;

      case V_PLATFORM_WIN32_CE:
        return WIN_CE;

      default:
        return WIN_UNKNOWN;
    }
}

#endif /* WIN32 && ! MSDOS */

#if defined(_WIN32_WCE)

/* IANA Well Known Ports are in range 0-1023 */
#define USE_IANA_WELL_KNOWN_PORTS 1

/* IANA Registered Ports are in range 1024-49151 */
#define USE_IANA_REGISTERED_PORTS 1

struct pvt_servent {
  char           *s_name;
  char          **s_aliases;
  unsigned short  s_port;
  char           *s_proto;
};

/*
 * Ref: http://www.iana.org/assignments/port-numbers
 */

static struct pvt_servent IANAports[] = {
#ifdef USE_IANA_WELL_KNOWN_PORTS
{"tcpmux",             {NULL}, 1, "tcp"},
{"tcpmux",             {NULL}, 1, "udp"},
{"compressnet",        {NULL}, 2, "tcp"},
{"compressnet",        {NULL}, 2, "udp"},
{"compressnet",        {NULL}, 3, "tcp"},
{"compressnet",        {NULL}, 3, "udp"},
{"rje",                {NULL}, 5, "tcp"},
{"rje",                {NULL}, 5, "udp"},
{"echo",               {NULL}, 7, "tcp"},
{"echo",               {NULL}, 7, "udp"},
{"discard",            {NULL}, 9, "tcp"},
{"discard",            {NULL}, 9, "udp"},
{"discard",            {NULL}, 9, "sctp"},
{"discard",            {NULL}, 9, "dccp"},
{"systat",             {NULL}, 11, "tcp"},
{"systat",             {NULL}, 11, "udp"},
{"daytime",            {NULL}, 13, "tcp"},
{"daytime",            {NULL}, 13, "udp"},
{"qotd",               {NULL}, 17, "tcp"},
{"qotd",               {NULL}, 17, "udp"},
{"msp",                {NULL}, 18, "tcp"},
{"msp",                {NULL}, 18, "udp"},
{"chargen",            {NULL}, 19, "tcp"},
{"chargen",            {NULL}, 19, "udp"},
{"ftp-data",           {NULL}, 20, "tcp"},
{"ftp-data",           {NULL}, 20, "udp"},
{"ftp-data",           {NULL}, 20, "sctp"},
{"ftp",                {NULL}, 21, "tcp"},
{"ftp",                {NULL}, 21, "udp"},
{"ftp",                {NULL}, 21, "sctp"},
{"ssh",                {NULL}, 22, "tcp"},
{"ssh",                {NULL}, 22, "udp"},
{"ssh",                {NULL}, 22, "sctp"},
{"telnet",             {NULL}, 23, "tcp"},
{"telnet",             {NULL}, 23, "udp"},
{"smtp",               {NULL}, 25, "tcp"},
{"smtp",               {NULL}, 25, "udp"},
{"nsw-fe",             {NULL}, 27, "tcp"},
{"nsw-fe",             {NULL}, 27, "udp"},
{"msg-icp",            {NULL}, 29, "tcp"},
{"msg-icp",            {NULL}, 29, "udp"},
{"msg-auth",           {NULL}, 31, "tcp"},
{"msg-auth",           {NULL}, 31, "udp"},
{"dsp",                {NULL}, 33, "tcp"},
{"dsp",                {NULL}, 33, "udp"},
{"time",               {NULL}, 37, "tcp"},
{"time",               {NULL}, 37, "udp"},
{"rap",                {NULL}, 38, "tcp"},
{"rap",                {NULL}, 38, "udp"},
{"rlp",                {NULL}, 39, "tcp"},
{"rlp",                {NULL}, 39, "udp"},
{"graphics",           {NULL}, 41, "tcp"},
{"graphics",           {NULL}, 41, "udp"},
{"name",               {NULL}, 42, "tcp"},
{"name",               {NULL}, 42, "udp"},
{"nameserver",         {NULL}, 42, "tcp"},
{"nameserver",         {NULL}, 42, "udp"},
{"nicname",            {NULL}, 43, "tcp"},
{"nicname",            {NULL}, 43, "udp"},
{"mpm-flags",          {NULL}, 44, "tcp"},
{"mpm-flags",          {NULL}, 44, "udp"},
{"mpm",                {NULL}, 45, "tcp"},
{"mpm",                {NULL}, 45, "udp"},
{"mpm-snd",            {NULL}, 46, "tcp"},
{"mpm-snd",            {NULL}, 46, "udp"},
{"ni-ftp",             {NULL}, 47, "tcp"},
{"ni-ftp",             {NULL}, 47, "udp"},
{"auditd",             {NULL}, 48, "tcp"},
{"auditd",             {NULL}, 48, "udp"},
{"tacacs",             {NULL}, 49, "tcp"},
{"tacacs",             {NULL}, 49, "udp"},
{"re-mail-ck",         {NULL}, 50, "tcp"},
{"re-mail-ck",         {NULL}, 50, "udp"},
{"la-maint",           {NULL}, 51, "tcp"},
{"la-maint",           {NULL}, 51, "udp"},
{"xns-time",           {NULL}, 52, "tcp"},
{"xns-time",           {NULL}, 52, "udp"},
{"domain",             {NULL}, 53, "tcp"},
{"domain",             {NULL}, 53, "udp"},
{"xns-ch",             {NULL}, 54, "tcp"},
{"xns-ch",             {NULL}, 54, "udp"},
{"isi-gl",             {NULL}, 55, "tcp"},
{"isi-gl",             {NULL}, 55, "udp"},
{"xns-auth",           {NULL}, 56, "tcp"},
{"xns-auth",           {NULL}, 56, "udp"},
{"xns-mail",           {NULL}, 58, "tcp"},
{"xns-mail",           {NULL}, 58, "udp"},
{"ni-mail",            {NULL}, 61, "tcp"},
{"ni-mail",            {NULL}, 61, "udp"},
{"acas",               {NULL}, 62, "tcp"},
{"acas",               {NULL}, 62, "udp"},
{"whois++",            {NULL}, 63, "tcp"},
{"whois++",            {NULL}, 63, "udp"},
{"covia",              {NULL}, 64, "tcp"},
{"covia",              {NULL}, 64, "udp"},
{"tacacs-ds",          {NULL}, 65, "tcp"},
{"tacacs-ds",          {NULL}, 65, "udp"},
{"sql*net",            {NULL}, 66, "tcp"},
{"sql*net",            {NULL}, 66, "udp"},
{"bootps",             {NULL}, 67, "tcp"},
{"bootps",             {NULL}, 67, "udp"},
{"bootpc",             {NULL}, 68, "tcp"},
{"bootpc",             {NULL}, 68, "udp"},
{"tftp",               {NULL}, 69, "tcp"},
{"tftp",               {NULL}, 69, "udp"},
{"gopher",             {NULL}, 70, "tcp"},
{"gopher",             {NULL}, 70, "udp"},
{"netrjs-1",           {NULL}, 71, "tcp"},
{"netrjs-1",           {NULL}, 71, "udp"},
{"netrjs-2",           {NULL}, 72, "tcp"},
{"netrjs-2",           {NULL}, 72, "udp"},
{"netrjs-3",           {NULL}, 73, "tcp"},
{"netrjs-3",           {NULL}, 73, "udp"},
{"netrjs-4",           {NULL}, 74, "tcp"},
{"netrjs-4",           {NULL}, 74, "udp"},
{"deos",               {NULL}, 76, "tcp"},
{"deos",               {NULL}, 76, "udp"},
{"vettcp",             {NULL}, 78, "tcp"},
{"vettcp",             {NULL}, 78, "udp"},
{"finger",             {NULL}, 79, "tcp"},
{"finger",             {NULL}, 79, "udp"},
{"http",               {NULL}, 80, "tcp"},
{"http",               {NULL}, 80, "udp"},
{"www",                {NULL}, 80, "tcp"},
{"www",                {NULL}, 80, "udp"},
{"www-http",           {NULL}, 80, "tcp"},
{"www-http",           {NULL}, 80, "udp"},
{"http",               {NULL}, 80, "sctp"},
{"xfer",               {NULL}, 82, "tcp"},
{"xfer",               {NULL}, 82, "udp"},
{"mit-ml-dev",         {NULL}, 83, "tcp"},
{"mit-ml-dev",         {NULL}, 83, "udp"},
{"ctf",                {NULL}, 84, "tcp"},
{"ctf",                {NULL}, 84, "udp"},
{"mit-ml-dev",         {NULL}, 85, "tcp"},
{"mit-ml-dev",         {NULL}, 85, "udp"},
{"mfcobol",            {NULL}, 86, "tcp"},
{"mfcobol",            {NULL}, 86, "udp"},
{"kerberos",           {NULL}, 88, "tcp"},
{"kerberos",           {NULL}, 88, "udp"},
{"su-mit-tg",          {NULL}, 89, "tcp"},
{"su-mit-tg",          {NULL}, 89, "udp"},
{"dnsix",              {NULL}, 90, "tcp"},
{"dnsix",              {NULL}, 90, "udp"},
{"mit-dov",            {NULL}, 91, "tcp"},
{"mit-dov",            {NULL}, 91, "udp"},
{"npp",                {NULL}, 92, "tcp"},
{"npp",                {NULL}, 92, "udp"},
{"dcp",                {NULL}, 93, "tcp"},
{"dcp",                {NULL}, 93, "udp"},
{"objcall",            {NULL}, 94, "tcp"},
{"objcall",            {NULL}, 94, "udp"},
{"supdup",             {NULL}, 95, "tcp"},
{"supdup",             {NULL}, 95, "udp"},
{"dixie",              {NULL}, 96, "tcp"},
{"dixie",              {NULL}, 96, "udp"},
{"swift-rvf",          {NULL}, 97, "tcp"},
{"swift-rvf",          {NULL}, 97, "udp"},
{"tacnews",            {NULL}, 98, "tcp"},
{"tacnews",            {NULL}, 98, "udp"},
{"metagram",           {NULL}, 99, "tcp"},
{"metagram",           {NULL}, 99, "udp"},
{"newacct",            {NULL}, 100, "tcp"},
{"hostname",           {NULL}, 101, "tcp"},
{"hostname",           {NULL}, 101, "udp"},
{"iso-tsap",           {NULL}, 102, "tcp"},
{"iso-tsap",           {NULL}, 102, "udp"},
{"gppitnp",            {NULL}, 103, "tcp"},
{"gppitnp",            {NULL}, 103, "udp"},
{"acr-nema",           {NULL}, 104, "tcp"},
{"acr-nema",           {NULL}, 104, "udp"},
{"cso",                {NULL}, 105, "tcp"},
{"cso",                {NULL}, 105, "udp"},
{"csnet-ns",           {NULL}, 105, "tcp"},
{"csnet-ns",           {NULL}, 105, "udp"},
{"3com-tsmux",         {NULL}, 106, "tcp"},
{"3com-tsmux",         {NULL}, 106, "udp"},
{"rtelnet",            {NULL}, 107, "tcp"},
{"rtelnet",            {NULL}, 107, "udp"},
{"snagas",             {NULL}, 108, "tcp"},
{"snagas",             {NULL}, 108, "udp"},
{"pop2",               {NULL}, 109, "tcp"},
{"pop2",               {NULL}, 109, "udp"},
{"pop3",               {NULL}, 110, "tcp"},
{"pop3",               {NULL}, 110, "udp"},
{"sunrpc",             {NULL}, 111, "tcp"},
{"sunrpc",             {NULL}, 111, "udp"},
{"mcidas",             {NULL}, 112, "tcp"},
{"mcidas",             {NULL}, 112, "udp"},
{"ident",              {NULL}, 113, "tcp"},
{"auth",               {NULL}, 113, "tcp"},
{"auth",               {NULL}, 113, "udp"},
{"sftp",               {NULL}, 115, "tcp"},
{"sftp",               {NULL}, 115, "udp"},
{"ansanotify",         {NULL}, 116, "tcp"},
{"ansanotify",         {NULL}, 116, "udp"},
{"uucp-path",          {NULL}, 117, "tcp"},
{"uucp-path",          {NULL}, 117, "udp"},
{"sqlserv",            {NULL}, 118, "tcp"},
{"sqlserv",            {NULL}, 118, "udp"},
{"nntp",               {NULL}, 119, "tcp"},
{"nntp",               {NULL}, 119, "udp"},
{"cfdptkt",            {NULL}, 120, "tcp"},
{"cfdptkt",            {NULL}, 120, "udp"},
{"erpc",               {NULL}, 121, "tcp"},
{"erpc",               {NULL}, 121, "udp"},
{"smakynet",           {NULL}, 122, "tcp"},
{"smakynet",           {NULL}, 122, "udp"},
{"ntp",                {NULL}, 123, "tcp"},
{"ntp",                {NULL}, 123, "udp"},
{"ansatrader",         {NULL}, 124, "tcp"},
{"ansatrader",         {NULL}, 124, "udp"},
{"locus-map",          {NULL}, 125, "tcp"},
{"locus-map",          {NULL}, 125, "udp"},
{"nxedit",             {NULL}, 126, "tcp"},
{"nxedit",             {NULL}, 126, "udp"},
{"locus-con",          {NULL}, 127, "tcp"},
{"locus-con",          {NULL}, 127, "udp"},
{"gss-xlicen",         {NULL}, 128, "tcp"},
{"gss-xlicen",         {NULL}, 128, "udp"},
{"pwdgen",             {NULL}, 129, "tcp"},
{"pwdgen",             {NULL}, 129, "udp"},
{"cisco-fna",          {NULL}, 130, "tcp"},
{"cisco-fna",          {NULL}, 130, "udp"},
{"cisco-tna",          {NULL}, 131, "tcp"},
{"cisco-tna",          {NULL}, 131, "udp"},
{"cisco-sys",          {NULL}, 132, "tcp"},
{"cisco-sys",          {NULL}, 132, "udp"},
{"statsrv",            {NULL}, 133, "tcp"},
{"statsrv",            {NULL}, 133, "udp"},
{"ingres-net",         {NULL}, 134, "tcp"},
{"ingres-net",         {NULL}, 134, "udp"},
{"epmap",              {NULL}, 135, "tcp"},
{"epmap",              {NULL}, 135, "udp"},
{"profile",            {NULL}, 136, "tcp"},
{"profile",            {NULL}, 136, "udp"},
{"netbios-ns",         {NULL}, 137, "tcp"},
{"netbios-ns",         {NULL}, 137, "udp"},
{"netbios-dgm",        {NULL}, 138, "tcp"},
{"netbios-dgm",        {NULL}, 138, "udp"},
{"netbios-ssn",        {NULL}, 139, "tcp"},
{"netbios-ssn",        {NULL}, 139, "udp"},
{"emfis-data",         {NULL}, 140, "tcp"},
{"emfis-data",         {NULL}, 140, "udp"},
{"emfis-cntl",         {NULL}, 141, "tcp"},
{"emfis-cntl",         {NULL}, 141, "udp"},
{"bl-idm",             {NULL}, 142, "tcp"},
{"bl-idm",             {NULL}, 142, "udp"},
{"imap",               {NULL}, 143, "tcp"},
{"imap",               {NULL}, 143, "udp"},
{"uma",                {NULL}, 144, "tcp"},
{"uma",                {NULL}, 144, "udp"},
{"uaac",               {NULL}, 145, "tcp"},
{"uaac",               {NULL}, 145, "udp"},
{"iso-tp0",            {NULL}, 146, "tcp"},
{"iso-tp0",            {NULL}, 146, "udp"},
{"iso-ip",             {NULL}, 147, "tcp"},
{"iso-ip",             {NULL}, 147, "udp"},
{"jargon",             {NULL}, 148, "tcp"},
{"jargon",             {NULL}, 148, "udp"},
{"aed-512",            {NULL}, 149, "tcp"},
{"aed-512",            {NULL}, 149, "udp"},
{"sql-net",            {NULL}, 150, "tcp"},
{"sql-net",            {NULL}, 150, "udp"},
{"hems",               {NULL}, 151, "tcp"},
{"hems",               {NULL}, 151, "udp"},
{"bftp",               {NULL}, 152, "tcp"},
{"bftp",               {NULL}, 152, "udp"},
{"sgmp",               {NULL}, 153, "tcp"},
{"sgmp",               {NULL}, 153, "udp"},
{"netsc-prod",         {NULL}, 154, "tcp"},
{"netsc-prod",         {NULL}, 154, "udp"},
{"netsc-dev",          {NULL}, 155, "tcp"},
{"netsc-dev",          {NULL}, 155, "udp"},
{"sqlsrv",             {NULL}, 156, "tcp"},
{"sqlsrv",             {NULL}, 156, "udp"},
{"knet-cmp",           {NULL}, 157, "tcp"},
{"knet-cmp",           {NULL}, 157, "udp"},
{"pcmail-srv",         {NULL}, 158, "tcp"},
{"pcmail-srv",         {NULL}, 158, "udp"},
{"nss-routing",        {NULL}, 159, "tcp"},
{"nss-routing",        {NULL}, 159, "udp"},
{"sgmp-traps",         {NULL}, 160, "tcp"},
{"sgmp-traps",         {NULL}, 160, "udp"},
{"snmp",               {NULL}, 161, "tcp"},
{"snmp",               {NULL}, 161, "udp"},
{"snmptrap",           {NULL}, 162, "tcp"},
{"snmptrap",           {NULL}, 162, "udp"},
{"cmip-man",           {NULL}, 163, "tcp"},
{"cmip-man",           {NULL}, 163, "udp"},
{"cmip-agent",         {NULL}, 164, "tcp"},
{"cmip-agent",         {NULL}, 164, "udp"},
{"xns-courier",        {NULL}, 165, "tcp"},
{"xns-courier",        {NULL}, 165, "udp"},
{"s-net",              {NULL}, 166, "tcp"},
{"s-net",              {NULL}, 166, "udp"},
{"namp",               {NULL}, 167, "tcp"},
{"namp",               {NULL}, 167, "udp"},
{"rsvd",               {NULL}, 168, "tcp"},
{"rsvd",               {NULL}, 168, "udp"},
{"send",               {NULL}, 169, "tcp"},
{"send",               {NULL}, 169, "udp"},
{"print-srv",          {NULL}, 170, "tcp"},
{"print-srv",          {NULL}, 170, "udp"},
{"multiplex",          {NULL}, 171, "tcp"},
{"multiplex",          {NULL}, 171, "udp"},
{"cl/1",               {NULL}, 172, "tcp"},
{"cl/1",               {NULL}, 172, "udp"},
{"xyplex-mux",         {NULL}, 173, "tcp"},
{"xyplex-mux",         {NULL}, 173, "udp"},
{"mailq",              {NULL}, 174, "tcp"},
{"mailq",              {NULL}, 174, "udp"},
{"vmnet",              {NULL}, 175, "tcp"},
{"vmnet",              {NULL}, 175, "udp"},
{"genrad-mux",         {NULL}, 176, "tcp"},
{"genrad-mux",         {NULL}, 176, "udp"},
{"xdmcp",              {NULL}, 177, "tcp"},
{"xdmcp",              {NULL}, 177, "udp"},
{"nextstep",           {NULL}, 178, "tcp"},
{"nextstep",           {NULL}, 178, "udp"},
{"bgp",                {NULL}, 179, "tcp"},
{"bgp",                {NULL}, 179, "udp"},
{"bgp",                {NULL}, 179, "sctp"},
{"ris",                {NULL}, 180, "tcp"},
{"ris",                {NULL}, 180, "udp"},
{"unify",              {NULL}, 181, "tcp"},
{"unify",              {NULL}, 181, "udp"},
{"audit",              {NULL}, 182, "tcp"},
{"audit",              {NULL}, 182, "udp"},
{"ocbinder",           {NULL}, 183, "tcp"},
{"ocbinder",           {NULL}, 183, "udp"},
{"ocserver",           {NULL}, 184, "tcp"},
{"ocserver",           {NULL}, 184, "udp"},
{"remote-kis",         {NULL}, 185, "tcp"},
{"remote-kis",         {NULL}, 185, "udp"},
{"kis",                {NULL}, 186, "tcp"},
{"kis",                {NULL}, 186, "udp"},
{"aci",                {NULL}, 187, "tcp"},
{"aci",                {NULL}, 187, "udp"},
{"mumps",              {NULL}, 188, "tcp"},
{"mumps",              {NULL}, 188, "udp"},
{"qft",                {NULL}, 189, "tcp"},
{"qft",                {NULL}, 189, "udp"},
{"gacp",               {NULL}, 190, "tcp"},
{"gacp",               {NULL}, 190, "udp"},
{"prospero",           {NULL}, 191, "tcp"},
{"prospero",           {NULL}, 191, "udp"},
{"osu-nms",            {NULL}, 192, "tcp"},
{"osu-nms",            {NULL}, 192, "udp"},
{"srmp",               {NULL}, 193, "tcp"},
{"srmp",               {NULL}, 193, "udp"},
{"irc",                {NULL}, 194, "tcp"},
{"irc",                {NULL}, 194, "udp"},
{"dn6-nlm-aud",        {NULL}, 195, "tcp"},
{"dn6-nlm-aud",        {NULL}, 195, "udp"},
{"dn6-smm-red",        {NULL}, 196, "tcp"},
{"dn6-smm-red",        {NULL}, 196, "udp"},
{"dls",                {NULL}, 197, "tcp"},
{"dls",                {NULL}, 197, "udp"},
{"dls-mon",            {NULL}, 198, "tcp"},
{"dls-mon",            {NULL}, 198, "udp"},
{"smux",               {NULL}, 199, "tcp"},
{"smux",               {NULL}, 199, "udp"},
{"src",                {NULL}, 200, "tcp"},
{"src",                {NULL}, 200, "udp"},
{"at-rtmp",            {NULL}, 201, "tcp"},
{"at-rtmp",            {NULL}, 201, "udp"},
{"at-nbp",             {NULL}, 202, "tcp"},
{"at-nbp",             {NULL}, 202, "udp"},
{"at-3",               {NULL}, 203, "tcp"},
{"at-3",               {NULL}, 203, "udp"},
{"at-echo",            {NULL}, 204, "tcp"},
{"at-echo",            {NULL}, 204, "udp"},
{"at-5",               {NULL}, 205, "tcp"},
{"at-5",               {NULL}, 205, "udp"},
{"at-zis",             {NULL}, 206, "tcp"},
{"at-zis",             {NULL}, 206, "udp"},
{"at-7",               {NULL}, 207, "tcp"},
{"at-7",               {NULL}, 207, "udp"},
{"at-8",               {NULL}, 208, "tcp"},
{"at-8",               {NULL}, 208, "udp"},
{"qmtp",               {NULL}, 209, "tcp"},
{"qmtp",               {NULL}, 209, "udp"},
{"z39.50",             {NULL}, 210, "tcp"},
{"z39.50",             {NULL}, 210, "udp"},
{"914c/g",             {NULL}, 211, "tcp"},
{"914c/g",             {NULL}, 211, "udp"},
{"anet",               {NULL}, 212, "tcp"},
{"anet",               {NULL}, 212, "udp"},
{"ipx",                {NULL}, 213, "tcp"},
{"ipx",                {NULL}, 213, "udp"},
{"vmpwscs",            {NULL}, 214, "tcp"},
{"vmpwscs",            {NULL}, 214, "udp"},
{"softpc",             {NULL}, 215, "tcp"},
{"softpc",             {NULL}, 215, "udp"},
{"CAIlic",             {NULL}, 216, "tcp"},
{"CAIlic",             {NULL}, 216, "udp"},
{"dbase",              {NULL}, 217, "tcp"},
{"dbase",              {NULL}, 217, "udp"},
{"mpp",                {NULL}, 218, "tcp"},
{"mpp",                {NULL}, 218, "udp"},
{"uarps",              {NULL}, 219, "tcp"},
{"uarps",              {NULL}, 219, "udp"},
{"imap3",              {NULL}, 220, "tcp"},
{"imap3",              {NULL}, 220, "udp"},
{"fln-spx",            {NULL}, 221, "tcp"},
{"fln-spx",            {NULL}, 221, "udp"},
{"rsh-spx",            {NULL}, 222, "tcp"},
{"rsh-spx",            {NULL}, 222, "udp"},
{"cdc",                {NULL}, 223, "tcp"},
{"cdc",                {NULL}, 223, "udp"},
{"masqdialer",         {NULL}, 224, "tcp"},
{"masqdialer",         {NULL}, 224, "udp"},
{"direct",             {NULL}, 242, "tcp"},
{"direct",             {NULL}, 242, "udp"},
{"sur-meas",           {NULL}, 243, "tcp"},
{"sur-meas",           {NULL}, 243, "udp"},
{"inbusiness",         {NULL}, 244, "tcp"},
{"inbusiness",         {NULL}, 244, "udp"},
{"link",               {NULL}, 245, "tcp"},
{"link",               {NULL}, 245, "udp"},
{"dsp3270",            {NULL}, 246, "tcp"},
{"dsp3270",            {NULL}, 246, "udp"},
{"subntbcst_tftp",     {NULL}, 247, "tcp"},
{"subntbcst_tftp",     {NULL}, 247, "udp"},
{"bhfhs",              {NULL}, 248, "tcp"},
{"bhfhs",              {NULL}, 248, "udp"},
{"rap",                {NULL}, 256, "tcp"},
{"rap",                {NULL}, 256, "udp"},
{"set",                {NULL}, 257, "tcp"},
{"set",                {NULL}, 257, "udp"},
{"esro-gen",           {NULL}, 259, "tcp"},
{"esro-gen",           {NULL}, 259, "udp"},
{"openport",           {NULL}, 260, "tcp"},
{"openport",           {NULL}, 260, "udp"},
{"nsiiops",            {NULL}, 261, "tcp"},
{"nsiiops",            {NULL}, 261, "udp"},
{"arcisdms",           {NULL}, 262, "tcp"},
{"arcisdms",           {NULL}, 262, "udp"},
{"hdap",               {NULL}, 263, "tcp"},
{"hdap",               {NULL}, 263, "udp"},
{"bgmp",               {NULL}, 264, "tcp"},
{"bgmp",               {NULL}, 264, "udp"},
{"x-bone-ctl",         {NULL}, 265, "tcp"},
{"x-bone-ctl",         {NULL}, 265, "udp"},
{"sst",                {NULL}, 266, "tcp"},
{"sst",                {NULL}, 266, "udp"},
{"td-service",         {NULL}, 267, "tcp"},
{"td-service",         {NULL}, 267, "udp"},
{"td-replica",         {NULL}, 268, "tcp"},
{"td-replica",         {NULL}, 268, "udp"},
{"manet",              {NULL}, 269, "tcp"},
{"manet",              {NULL}, 269, "udp"},
{"gist",               {NULL}, 270, "udp"},
{"http-mgmt",          {NULL}, 280, "tcp"},
{"http-mgmt",          {NULL}, 280, "udp"},
{"personal-link",      {NULL}, 281, "tcp"},
{"personal-link",      {NULL}, 281, "udp"},
{"cableport-ax",       {NULL}, 282, "tcp"},
{"cableport-ax",       {NULL}, 282, "udp"},
{"rescap",             {NULL}, 283, "tcp"},
{"rescap",             {NULL}, 283, "udp"},
{"corerjd",            {NULL}, 284, "tcp"},
{"corerjd",            {NULL}, 284, "udp"},
{"fxp",                {NULL}, 286, "tcp"},
{"fxp",                {NULL}, 286, "udp"},
{"k-block",            {NULL}, 287, "tcp"},
{"k-block",            {NULL}, 287, "udp"},
{"novastorbakcup",     {NULL}, 308, "tcp"},
{"novastorbakcup",     {NULL}, 308, "udp"},
{"entrusttime",        {NULL}, 309, "tcp"},
{"entrusttime",        {NULL}, 309, "udp"},
{"bhmds",              {NULL}, 310, "tcp"},
{"bhmds",              {NULL}, 310, "udp"},
{"asip-webadmin",      {NULL}, 311, "tcp"},
{"asip-webadmin",      {NULL}, 311, "udp"},
{"vslmp",              {NULL}, 312, "tcp"},
{"vslmp",              {NULL}, 312, "udp"},
{"magenta-logic",      {NULL}, 313, "tcp"},
{"magenta-logic",      {NULL}, 313, "udp"},
{"opalis-robot",       {NULL}, 314, "tcp"},
{"opalis-robot",       {NULL}, 314, "udp"},
{"dpsi",               {NULL}, 315, "tcp"},
{"dpsi",               {NULL}, 315, "udp"},
{"decauth",            {NULL}, 316, "tcp"},
{"decauth",            {NULL}, 316, "udp"},
{"zannet",             {NULL}, 317, "tcp"},
{"zannet",             {NULL}, 317, "udp"},
{"pkix-timestamp",     {NULL}, 318, "tcp"},
{"pkix-timestamp",     {NULL}, 318, "udp"},
{"ptp-event",          {NULL}, 319, "tcp"},
{"ptp-event",          {NULL}, 319, "udp"},
{"ptp-general",        {NULL}, 320, "tcp"},
{"ptp-general",        {NULL}, 320, "udp"},
{"pip",                {NULL}, 321, "tcp"},
{"pip",                {NULL}, 321, "udp"},
{"rtsps",              {NULL}, 322, "tcp"},
{"rtsps",              {NULL}, 322, "udp"},
{"texar",              {NULL}, 333, "tcp"},
{"texar",              {NULL}, 333, "udp"},
{"pdap",               {NULL}, 344, "tcp"},
{"pdap",               {NULL}, 344, "udp"},
{"pawserv",            {NULL}, 345, "tcp"},
{"pawserv",            {NULL}, 345, "udp"},
{"zserv",              {NULL}, 346, "tcp"},
{"zserv",              {NULL}, 346, "udp"},
{"fatserv",            {NULL}, 347, "tcp"},
{"fatserv",            {NULL}, 347, "udp"},
{"csi-sgwp",           {NULL}, 348, "tcp"},
{"csi-sgwp",           {NULL}, 348, "udp"},
{"mftp",               {NULL}, 349, "tcp"},
{"mftp",               {NULL}, 349, "udp"},
{"matip-type-a",       {NULL}, 350, "tcp"},
{"matip-type-a",       {NULL}, 350, "udp"},
{"matip-type-b",       {NULL}, 351, "tcp"},
{"matip-type-b",       {NULL}, 351, "udp"},
{"bhoetty",            {NULL}, 351, "tcp"},
{"bhoetty",            {NULL}, 351, "udp"},
{"dtag-ste-sb",        {NULL}, 352, "tcp"},
{"dtag-ste-sb",        {NULL}, 352, "udp"},
{"bhoedap4",           {NULL}, 352, "tcp"},
{"bhoedap4",           {NULL}, 352, "udp"},
{"ndsauth",            {NULL}, 353, "tcp"},
{"ndsauth",            {NULL}, 353, "udp"},
{"bh611",              {NULL}, 354, "tcp"},
{"bh611",              {NULL}, 354, "udp"},
{"datex-asn",          {NULL}, 355, "tcp"},
{"datex-asn",          {NULL}, 355, "udp"},
{"cloanto-net-1",      {NULL}, 356, "tcp"},
{"cloanto-net-1",      {NULL}, 356, "udp"},
{"bhevent",            {NULL}, 357, "tcp"},
{"bhevent",            {NULL}, 357, "udp"},
{"shrinkwrap",         {NULL}, 358, "tcp"},
{"shrinkwrap",         {NULL}, 358, "udp"},
{"nsrmp",              {NULL}, 359, "tcp"},
{"nsrmp",              {NULL}, 359, "udp"},
{"scoi2odialog",       {NULL}, 360, "tcp"},
{"scoi2odialog",       {NULL}, 360, "udp"},
{"semantix",           {NULL}, 361, "tcp"},
{"semantix",           {NULL}, 361, "udp"},
{"srssend",            {NULL}, 362, "tcp"},
{"srssend",            {NULL}, 362, "udp"},
{"rsvp_tunnel",        {NULL}, 363, "tcp"},
{"rsvp_tunnel",        {NULL}, 363, "udp"},
{"aurora-cmgr",        {NULL}, 364, "tcp"},
{"aurora-cmgr",        {NULL}, 364, "udp"},
{"dtk",                {NULL}, 365, "tcp"},
{"dtk",                {NULL}, 365, "udp"},
{"odmr",               {NULL}, 366, "tcp"},
{"odmr",               {NULL}, 366, "udp"},
{"mortgageware",       {NULL}, 367, "tcp"},
{"mortgageware",       {NULL}, 367, "udp"},
{"qbikgdp",            {NULL}, 368, "tcp"},
{"qbikgdp",            {NULL}, 368, "udp"},
{"rpc2portmap",        {NULL}, 369, "tcp"},
{"rpc2portmap",        {NULL}, 369, "udp"},
{"codaauth2",          {NULL}, 370, "tcp"},
{"codaauth2",          {NULL}, 370, "udp"},
{"clearcase",          {NULL}, 371, "tcp"},
{"clearcase",          {NULL}, 371, "udp"},
{"ulistproc",          {NULL}, 372, "tcp"},
{"ulistproc",          {NULL}, 372, "udp"},
{"legent-1",           {NULL}, 373, "tcp"},
{"legent-1",           {NULL}, 373, "udp"},
{"legent-2",           {NULL}, 374, "tcp"},
{"legent-2",           {NULL}, 374, "udp"},
{"hassle",             {NULL}, 375, "tcp"},
{"hassle",             {NULL}, 375, "udp"},
{"nip",                {NULL}, 376, "tcp"},
{"nip",                {NULL}, 376, "udp"},
{"tnETOS",             {NULL}, 377, "tcp"},
{"tnETOS",             {NULL}, 377, "udp"},
{"dsETOS",             {NULL}, 378, "tcp"},
{"dsETOS",             {NULL}, 378, "udp"},
{"is99c",              {NULL}, 379, "tcp"},
{"is99c",              {NULL}, 379, "udp"},
{"is99s",              {NULL}, 380, "tcp"},
{"is99s",              {NULL}, 380, "udp"},
{"hp-collector",       {NULL}, 381, "tcp"},
{"hp-collector",       {NULL}, 381, "udp"},
{"hp-managed-node",    {NULL}, 382, "tcp"},
{"hp-managed-node",    {NULL}, 382, "udp"},
{"hp-alarm-mgr",       {NULL}, 383, "tcp"},
{"hp-alarm-mgr",       {NULL}, 383, "udp"},
{"arns",               {NULL}, 384, "tcp"},
{"arns",               {NULL}, 384, "udp"},
{"ibm-app",            {NULL}, 385, "tcp"},
{"ibm-app",            {NULL}, 385, "udp"},
{"asa",                {NULL}, 386, "tcp"},
{"asa",                {NULL}, 386, "udp"},
{"aurp",               {NULL}, 387, "tcp"},
{"aurp",               {NULL}, 387, "udp"},
{"unidata-ldm",        {NULL}, 388, "tcp"},
{"unidata-ldm",        {NULL}, 388, "udp"},
{"ldap",               {NULL}, 389, "tcp"},
{"ldap",               {NULL}, 389, "udp"},
{"uis",                {NULL}, 390, "tcp"},
{"uis",                {NULL}, 390, "udp"},
{"synotics-relay",     {NULL}, 391, "tcp"},
{"synotics-relay",     {NULL}, 391, "udp"},
{"synotics-broker",    {NULL}, 392, "tcp"},
{"synotics-broker",    {NULL}, 392, "udp"},
{"meta5",              {NULL}, 393, "tcp"},
{"meta5",              {NULL}, 393, "udp"},
{"embl-ndt",           {NULL}, 394, "tcp"},
{"embl-ndt",           {NULL}, 394, "udp"},
{"netcp",              {NULL}, 395, "tcp"},
{"netcp",              {NULL}, 395, "udp"},
{"netware-ip",         {NULL}, 396, "tcp"},
{"netware-ip",         {NULL}, 396, "udp"},
{"mptn",               {NULL}, 397, "tcp"},
{"mptn",               {NULL}, 397, "udp"},
{"kryptolan",          {NULL}, 398, "tcp"},
{"kryptolan",          {NULL}, 398, "udp"},
{"iso-tsap-c2",        {NULL}, 399, "tcp"},
{"iso-tsap-c2",        {NULL}, 399, "udp"},
{"osb-sd",             {NULL}, 400, "tcp"},
{"osb-sd",             {NULL}, 400, "udp"},
{"ups",                {NULL}, 401, "tcp"},
{"ups",                {NULL}, 401, "udp"},
{"genie",              {NULL}, 402, "tcp"},
{"genie",              {NULL}, 402, "udp"},
{"decap",              {NULL}, 403, "tcp"},
{"decap",              {NULL}, 403, "udp"},
{"nced",               {NULL}, 404, "tcp"},
{"nced",               {NULL}, 404, "udp"},
{"ncld",               {NULL}, 405, "tcp"},
{"ncld",               {NULL}, 405, "udp"},
{"imsp",               {NULL}, 406, "tcp"},
{"imsp",               {NULL}, 406, "udp"},
{"timbuktu",           {NULL}, 407, "tcp"},
{"timbuktu",           {NULL}, 407, "udp"},
{"prm-sm",             {NULL}, 408, "tcp"},
{"prm-sm",             {NULL}, 408, "udp"},
{"prm-nm",             {NULL}, 409, "tcp"},
{"prm-nm",             {NULL}, 409, "udp"},
{"decladebug",         {NULL}, 410, "tcp"},
{"decladebug",         {NULL}, 410, "udp"},
{"rmt",                {NULL}, 411, "tcp"},
{"rmt",                {NULL}, 411, "udp"},
{"synoptics-trap",     {NULL}, 412, "tcp"},
{"synoptics-trap",     {NULL}, 412, "udp"},
{"smsp",               {NULL}, 413, "tcp"},
{"smsp",               {NULL}, 413, "udp"},
{"infoseek",           {NULL}, 414, "tcp"},
{"infoseek",           {NULL}, 414, "udp"},
{"bnet",               {NULL}, 415, "tcp"},
{"bnet",               {NULL}, 415, "udp"},
{"silverplatter",      {NULL}, 416, "tcp"},
{"silverplatter",      {NULL}, 416, "udp"},
{"onmux",              {NULL}, 417, "tcp"},
{"onmux",              {NULL}, 417, "udp"},
{"hyper-g",            {NULL}, 418, "tcp"},
{"hyper-g",            {NULL}, 418, "udp"},
{"ariel1",             {NULL}, 419, "tcp"},
{"ariel1",             {NULL}, 419, "udp"},
{"smpte",              {NULL}, 420, "tcp"},
{"smpte",              {NULL}, 420, "udp"},
{"ariel2",             {NULL}, 421, "tcp"},
{"ariel2",             {NULL}, 421, "udp"},
{"ariel3",             {NULL}, 422, "tcp"},
{"ariel3",             {NULL}, 422, "udp"},
{"opc-job-start",      {NULL}, 423, "tcp"},
{"opc-job-start",      {NULL}, 423, "udp"},
{"opc-job-track",      {NULL}, 424, "tcp"},
{"opc-job-track",      {NULL}, 424, "udp"},
{"icad-el",            {NULL}, 425, "tcp"},
{"icad-el",            {NULL}, 425, "udp"},
{"smartsdp",           {NULL}, 426, "tcp"},
{"smartsdp",           {NULL}, 426, "udp"},
{"svrloc",             {NULL}, 427, "tcp"},
{"svrloc",             {NULL}, 427, "udp"},
{"ocs_cmu",            {NULL}, 428, "tcp"},
{"ocs_cmu",            {NULL}, 428, "udp"},
{"ocs_amu",            {NULL}, 429, "tcp"},
{"ocs_amu",            {NULL}, 429, "udp"},
{"utmpsd",             {NULL}, 430, "tcp"},
{"utmpsd",             {NULL}, 430, "udp"},
{"utmpcd",             {NULL}, 431, "tcp"},
{"utmpcd",             {NULL}, 431, "udp"},
{"iasd",               {NULL}, 432, "tcp"},
{"iasd",               {NULL}, 432, "udp"},
{"nnsp",               {NULL}, 433, "tcp"},
{"nnsp",               {NULL}, 433, "udp"},
{"mobileip-agent",     {NULL}, 434, "tcp"},
{"mobileip-agent",     {NULL}, 434, "udp"},
{"mobilip-mn",         {NULL}, 435, "tcp"},
{"mobilip-mn",         {NULL}, 435, "udp"},
{"dna-cml",            {NULL}, 436, "tcp"},
{"dna-cml",            {NULL}, 436, "udp"},
{"comscm",             {NULL}, 437, "tcp"},
{"comscm",             {NULL}, 437, "udp"},
{"dsfgw",              {NULL}, 438, "tcp"},
{"dsfgw",              {NULL}, 438, "udp"},
{"dasp",               {NULL}, 439, "tcp"},
{"dasp",               {NULL}, 439, "udp"},
{"sgcp",               {NULL}, 440, "tcp"},
{"sgcp",               {NULL}, 440, "udp"},
{"decvms-sysmgt",      {NULL}, 441, "tcp"},
{"decvms-sysmgt",      {NULL}, 441, "udp"},
{"cvc_hostd",          {NULL}, 442, "tcp"},
{"cvc_hostd",          {NULL}, 442, "udp"},
{"https",              {NULL}, 443, "tcp"},
{"https",              {NULL}, 443, "udp"},
{"https",              {NULL}, 443, "sctp"},
{"snpp",               {NULL}, 444, "tcp"},
{"snpp",               {NULL}, 444, "udp"},
{"microsoft-ds",       {NULL}, 445, "tcp"},
{"microsoft-ds",       {NULL}, 445, "udp"},
{"ddm-rdb",            {NULL}, 446, "tcp"},
{"ddm-rdb",            {NULL}, 446, "udp"},
{"ddm-dfm",            {NULL}, 447, "tcp"},
{"ddm-dfm",            {NULL}, 447, "udp"},
{"ddm-ssl",            {NULL}, 448, "tcp"},
{"ddm-ssl",            {NULL}, 448, "udp"},
{"as-servermap",       {NULL}, 449, "tcp"},
{"as-servermap",       {NULL}, 449, "udp"},
{"tserver",            {NULL}, 450, "tcp"},
{"tserver",            {NULL}, 450, "udp"},
{"sfs-smp-net",        {NULL}, 451, "tcp"},
{"sfs-smp-net",        {NULL}, 451, "udp"},
{"sfs-config",         {NULL}, 452, "tcp"},
{"sfs-config",         {NULL}, 452, "udp"},
{"creativeserver",     {NULL}, 453, "tcp"},
{"creativeserver",     {NULL}, 453, "udp"},
{"contentserver",      {NULL}, 454, "tcp"},
{"contentserver",      {NULL}, 454, "udp"},
{"creativepartnr",     {NULL}, 455, "tcp"},
{"creativepartnr",     {NULL}, 455, "udp"},
{"macon-tcp",          {NULL}, 456, "tcp"},
{"macon-udp",          {NULL}, 456, "udp"},
{"scohelp",            {NULL}, 457, "tcp"},
{"scohelp",            {NULL}, 457, "udp"},
{"appleqtc",           {NULL}, 458, "tcp"},
{"appleqtc",           {NULL}, 458, "udp"},
{"ampr-rcmd",          {NULL}, 459, "tcp"},
{"ampr-rcmd",          {NULL}, 459, "udp"},
{"skronk",             {NULL}, 460, "tcp"},
{"skronk",             {NULL}, 460, "udp"},
{"datasurfsrv",        {NULL}, 461, "tcp"},
{"datasurfsrv",        {NULL}, 461, "udp"},
{"datasurfsrvsec",     {NULL}, 462, "tcp"},
{"datasurfsrvsec",     {NULL}, 462, "udp"},
{"alpes",              {NULL}, 463, "tcp"},
{"alpes",              {NULL}, 463, "udp"},
{"kpasswd",            {NULL}, 464, "tcp"},
{"kpasswd",            {NULL}, 464, "udp"},
{"urd",                {NULL}, 465, "tcp"},
{"igmpv3lite",         {NULL}, 465, "udp"},
{"digital-vrc",        {NULL}, 466, "tcp"},
{"digital-vrc",        {NULL}, 466, "udp"},
{"mylex-mapd",         {NULL}, 467, "tcp"},
{"mylex-mapd",         {NULL}, 467, "udp"},
{"photuris",           {NULL}, 468, "tcp"},
{"photuris",           {NULL}, 468, "udp"},
{"rcp",                {NULL}, 469, "tcp"},
{"rcp",                {NULL}, 469, "udp"},
{"scx-proxy",          {NULL}, 470, "tcp"},
{"scx-proxy",          {NULL}, 470, "udp"},
{"mondex",             {NULL}, 471, "tcp"},
{"mondex",             {NULL}, 471, "udp"},
{"ljk-login",          {NULL}, 472, "tcp"},
{"ljk-login",          {NULL}, 472, "udp"},
{"hybrid-pop",         {NULL}, 473, "tcp"},
{"hybrid-pop",         {NULL}, 473, "udp"},
{"tn-tl-w1",           {NULL}, 474, "tcp"},
{"tn-tl-w2",           {NULL}, 474, "udp"},
{"tcpnethaspsrv",      {NULL}, 475, "tcp"},
{"tcpnethaspsrv",      {NULL}, 475, "udp"},
{"tn-tl-fd1",          {NULL}, 476, "tcp"},
{"tn-tl-fd1",          {NULL}, 476, "udp"},
{"ss7ns",              {NULL}, 477, "tcp"},
{"ss7ns",              {NULL}, 477, "udp"},
{"spsc",               {NULL}, 478, "tcp"},
{"spsc",               {NULL}, 478, "udp"},
{"iafserver",          {NULL}, 479, "tcp"},
{"iafserver",          {NULL}, 479, "udp"},
{"iafdbase",           {NULL}, 480, "tcp"},
{"iafdbase",           {NULL}, 480, "udp"},
{"ph",                 {NULL}, 481, "tcp"},
{"ph",                 {NULL}, 481, "udp"},
{"bgs-nsi",            {NULL}, 482, "tcp"},
{"bgs-nsi",            {NULL}, 482, "udp"},
{"ulpnet",             {NULL}, 483, "tcp"},
{"ulpnet",             {NULL}, 483, "udp"},
{"integra-sme",        {NULL}, 484, "tcp"},
{"integra-sme",        {NULL}, 484, "udp"},
{"powerburst",         {NULL}, 485, "tcp"},
{"powerburst",         {NULL}, 485, "udp"},
{"avian",              {NULL}, 486, "tcp"},
{"avian",              {NULL}, 486, "udp"},
{"saft",               {NULL}, 487, "tcp"},
{"saft",               {NULL}, 487, "udp"},
{"gss-http",           {NULL}, 488, "tcp"},
{"gss-http",           {NULL}, 488, "udp"},
{"nest-protocol",      {NULL}, 489, "tcp"},
{"nest-protocol",      {NULL}, 489, "udp"},
{"micom-pfs",          {NULL}, 490, "tcp"},
{"micom-pfs",          {NULL}, 490, "udp"},
{"go-login",           {NULL}, 491, "tcp"},
{"go-login",           {NULL}, 491, "udp"},
{"ticf-1",             {NULL}, 492, "tcp"},
{"ticf-1",             {NULL}, 492, "udp"},
{"ticf-2",             {NULL}, 493, "tcp"},
{"ticf-2",             {NULL}, 493, "udp"},
{"pov-ray",            {NULL}, 494, "tcp"},
{"pov-ray",            {NULL}, 494, "udp"},
{"intecourier",        {NULL}, 495, "tcp"},
{"intecourier",        {NULL}, 495, "udp"},
{"pim-rp-disc",        {NULL}, 496, "tcp"},
{"pim-rp-disc",        {NULL}, 496, "udp"},
{"dantz",              {NULL}, 497, "tcp"},
{"dantz",              {NULL}, 497, "udp"},
{"siam",               {NULL}, 498, "tcp"},
{"siam",               {NULL}, 498, "udp"},
{"iso-ill",            {NULL}, 499, "tcp"},
{"iso-ill",            {NULL}, 499, "udp"},
{"isakmp",             {NULL}, 500, "tcp"},
{"isakmp",             {NULL}, 500, "udp"},
{"stmf",               {NULL}, 501, "tcp"},
{"stmf",               {NULL}, 501, "udp"},
{"asa-appl-proto",     {NULL}, 502, "tcp"},
{"asa-appl-proto",     {NULL}, 502, "udp"},
{"intrinsa",           {NULL}, 503, "tcp"},
{"intrinsa",           {NULL}, 503, "udp"},
{"citadel",            {NULL}, 504, "tcp"},
{"citadel",            {NULL}, 504, "udp"},
{"mailbox-lm",         {NULL}, 505, "tcp"},
{"mailbox-lm",         {NULL}, 505, "udp"},
{"ohimsrv",            {NULL}, 506, "tcp"},
{"ohimsrv",            {NULL}, 506, "udp"},
{"crs",                {NULL}, 507, "tcp"},
{"crs",                {NULL}, 507, "udp"},
{"xvttp",              {NULL}, 508, "tcp"},
{"xvttp",              {NULL}, 508, "udp"},
{"snare",              {NULL}, 509, "tcp"},
{"snare",              {NULL}, 509, "udp"},
{"fcp",                {NULL}, 510, "tcp"},
{"fcp",                {NULL}, 510, "udp"},
{"passgo",             {NULL}, 511, "tcp"},
{"passgo",             {NULL}, 511, "udp"},
{"exec",               {NULL}, 512, "tcp"},
{"comsat",             {NULL}, 512, "udp"},
{"biff",               {NULL}, 512, "udp"},
{"login",              {NULL}, 513, "tcp"},
{"who",                {NULL}, 513, "udp"},
{"shell",              {NULL}, 514, "tcp"},
{"syslog",             {NULL}, 514, "udp"},
{"printer",            {NULL}, 515, "tcp"},
{"printer",            {NULL}, 515, "udp"},
{"videotex",           {NULL}, 516, "tcp"},
{"videotex",           {NULL}, 516, "udp"},
{"talk",               {NULL}, 517, "tcp"},
{"talk",               {NULL}, 517, "udp"},
{"ntalk",              {NULL}, 518, "tcp"},
{"ntalk",              {NULL}, 518, "udp"},
{"utime",              {NULL}, 519, "tcp"},
{"utime",              {NULL}, 519, "udp"},
{"efs",                {NULL}, 520, "tcp"},
{"router",             {NULL}, 520, "udp"},
{"ripng",              {NULL}, 521, "tcp"},
{"ripng",              {NULL}, 521, "udp"},
{"ulp",                {NULL}, 522, "tcp"},
{"ulp",                {NULL}, 522, "udp"},
{"ibm-db2",            {NULL}, 523, "tcp"},
{"ibm-db2",            {NULL}, 523, "udp"},
{"ncp",                {NULL}, 524, "tcp"},
{"ncp",                {NULL}, 524, "udp"},
{"timed",              {NULL}, 525, "tcp"},
{"timed",              {NULL}, 525, "udp"},
{"tempo",              {NULL}, 526, "tcp"},
{"tempo",              {NULL}, 526, "udp"},
{"stx",                {NULL}, 527, "tcp"},
{"stx",                {NULL}, 527, "udp"},
{"custix",             {NULL}, 528, "tcp"},
{"custix",             {NULL}, 528, "udp"},
{"irc-serv",           {NULL}, 529, "tcp"},
{"irc-serv",           {NULL}, 529, "udp"},
{"courier",            {NULL}, 530, "tcp"},
{"courier",            {NULL}, 530, "udp"},
{"conference",         {NULL}, 531, "tcp"},
{"conference",         {NULL}, 531, "udp"},
{"netnews",            {NULL}, 532, "tcp"},
{"netnews",            {NULL}, 532, "udp"},
{"netwall",            {NULL}, 533, "tcp"},
{"netwall",            {NULL}, 533, "udp"},
{"windream",           {NULL}, 534, "tcp"},
{"windream",           {NULL}, 534, "udp"},
{"iiop",               {NULL}, 535, "tcp"},
{"iiop",               {NULL}, 535, "udp"},
{"opalis-rdv",         {NULL}, 536, "tcp"},
{"opalis-rdv",         {NULL}, 536, "udp"},
{"nmsp",               {NULL}, 537, "tcp"},
{"nmsp",               {NULL}, 537, "udp"},
{"gdomap",             {NULL}, 538, "tcp"},
{"gdomap",             {NULL}, 538, "udp"},
{"apertus-ldp",        {NULL}, 539, "tcp"},
{"apertus-ldp",        {NULL}, 539, "udp"},
{"uucp",               {NULL}, 540, "tcp"},
{"uucp",               {NULL}, 540, "udp"},
{"uucp-rlogin",        {NULL}, 541, "tcp"},
{"uucp-rlogin",        {NULL}, 541, "udp"},
{"commerce",           {NULL}, 542, "tcp"},
{"commerce",           {NULL}, 542, "udp"},
{"klogin",             {NULL}, 543, "tcp"},
{"klogin",             {NULL}, 543, "udp"},
{"kshell",             {NULL}, 544, "tcp"},
{"kshell",             {NULL}, 544, "udp"},
{"appleqtcsrvr",       {NULL}, 545, "tcp"},
{"appleqtcsrvr",       {NULL}, 545, "udp"},
{"dhcpv6-client",      {NULL}, 546, "tcp"},
{"dhcpv6-client",      {NULL}, 546, "udp"},
{"dhcpv6-server",      {NULL}, 547, "tcp"},
{"dhcpv6-server",      {NULL}, 547, "udp"},
{"afpovertcp",         {NULL}, 548, "tcp"},
{"afpovertcp",         {NULL}, 548, "udp"},
{"idfp",               {NULL}, 549, "tcp"},
{"idfp",               {NULL}, 549, "udp"},
{"new-rwho",           {NULL}, 550, "tcp"},
{"new-rwho",           {NULL}, 550, "udp"},
{"cybercash",          {NULL}, 551, "tcp"},
{"cybercash",          {NULL}, 551, "udp"},
{"devshr-nts",         {NULL}, 552, "tcp"},
{"devshr-nts",         {NULL}, 552, "udp"},
{"pirp",               {NULL}, 553, "tcp"},
{"pirp",               {NULL}, 553, "udp"},
{"rtsp",               {NULL}, 554, "tcp"},
{"rtsp",               {NULL}, 554, "udp"},
{"dsf",                {NULL}, 555, "tcp"},
{"dsf",                {NULL}, 555, "udp"},
{"remotefs",           {NULL}, 556, "tcp"},
{"remotefs",           {NULL}, 556, "udp"},
{"openvms-sysipc",     {NULL}, 557, "tcp"},
{"openvms-sysipc",     {NULL}, 557, "udp"},
{"sdnskmp",            {NULL}, 558, "tcp"},
{"sdnskmp",            {NULL}, 558, "udp"},
{"teedtap",            {NULL}, 559, "tcp"},
{"teedtap",            {NULL}, 559, "udp"},
{"rmonitor",           {NULL}, 560, "tcp"},
{"rmonitor",           {NULL}, 560, "udp"},
{"monitor",            {NULL}, 561, "tcp"},
{"monitor",            {NULL}, 561, "udp"},
{"chshell",            {NULL}, 562, "tcp"},
{"chshell",            {NULL}, 562, "udp"},
{"nntps",              {NULL}, 563, "tcp"},
{"nntps",              {NULL}, 563, "udp"},
{"9pfs",               {NULL}, 564, "tcp"},
{"9pfs",               {NULL}, 564, "udp"},
{"whoami",             {NULL}, 565, "tcp"},
{"whoami",             {NULL}, 565, "udp"},
{"streettalk",         {NULL}, 566, "tcp"},
{"streettalk",         {NULL}, 566, "udp"},
{"banyan-rpc",         {NULL}, 567, "tcp"},
{"banyan-rpc",         {NULL}, 567, "udp"},
{"ms-shuttle",         {NULL}, 568, "tcp"},
{"ms-shuttle",         {NULL}, 568, "udp"},
{"ms-rome",            {NULL}, 569, "tcp"},
{"ms-rome",            {NULL}, 569, "udp"},
{"meter",              {NULL}, 570, "tcp"},
{"meter",              {NULL}, 570, "udp"},
{"meter",              {NULL}, 571, "tcp"},
{"meter",              {NULL}, 571, "udp"},
{"sonar",              {NULL}, 572, "tcp"},
{"sonar",              {NULL}, 572, "udp"},
{"banyan-vip",         {NULL}, 573, "tcp"},
{"banyan-vip",         {NULL}, 573, "udp"},
{"ftp-agent",          {NULL}, 574, "tcp"},
{"ftp-agent",          {NULL}, 574, "udp"},
{"vemmi",              {NULL}, 575, "tcp"},
{"vemmi",              {NULL}, 575, "udp"},
{"ipcd",               {NULL}, 576, "tcp"},
{"ipcd",               {NULL}, 576, "udp"},
{"vnas",               {NULL}, 577, "tcp"},
{"vnas",               {NULL}, 577, "udp"},
{"ipdd",               {NULL}, 578, "tcp"},
{"ipdd",               {NULL}, 578, "udp"},
{"decbsrv",            {NULL}, 579, "tcp"},
{"decbsrv",            {NULL}, 579, "udp"},
{"sntp-heartbeat",     {NULL}, 580, "tcp"},
{"sntp-heartbeat",     {NULL}, 580, "udp"},
{"bdp",                {NULL}, 581, "tcp"},
{"bdp",                {NULL}, 581, "udp"},
{"scc-security",       {NULL}, 582, "tcp"},
{"scc-security",       {NULL}, 582, "udp"},
{"philips-vc",         {NULL}, 583, "tcp"},
{"philips-vc",         {NULL}, 583, "udp"},
{"keyserver",          {NULL}, 584, "tcp"},
{"keyserver",          {NULL}, 584, "udp"},
{"password-chg",       {NULL}, 586, "tcp"},
{"password-chg",       {NULL}, 586, "udp"},
{"submission",         {NULL}, 587, "tcp"},
{"submission",         {NULL}, 587, "udp"},
{"cal",                {NULL}, 588, "tcp"},
{"cal",                {NULL}, 588, "udp"},
{"eyelink",            {NULL}, 589, "tcp"},
{"eyelink",            {NULL}, 589, "udp"},
{"tns-cml",            {NULL}, 590, "tcp"},
{"tns-cml",            {NULL}, 590, "udp"},
{"http-alt",           {NULL}, 591, "tcp"},
{"http-alt",           {NULL}, 591, "udp"},
{"eudora-set",         {NULL}, 592, "tcp"},
{"eudora-set",         {NULL}, 592, "udp"},
{"http-rpc-epmap",     {NULL}, 593, "tcp"},
{"http-rpc-epmap",     {NULL}, 593, "udp"},
{"tpip",               {NULL}, 594, "tcp"},
{"tpip",               {NULL}, 594, "udp"},
{"cab-protocol",       {NULL}, 595, "tcp"},
{"cab-protocol",       {NULL}, 595, "udp"},
{"smsd",               {NULL}, 596, "tcp"},
{"smsd",               {NULL}, 596, "udp"},
{"ptcnameservice",     {NULL}, 597, "tcp"},
{"ptcnameservice",     {NULL}, 597, "udp"},
{"sco-websrvrmg3",     {NULL}, 598, "tcp"},
{"sco-websrvrmg3",     {NULL}, 598, "udp"},
{"acp",                {NULL}, 599, "tcp"},
{"acp",                {NULL}, 599, "udp"},
{"ipcserver",          {NULL}, 600, "tcp"},
{"ipcserver",          {NULL}, 600, "udp"},
{"syslog-conn",        {NULL}, 601, "tcp"},
{"syslog-conn",        {NULL}, 601, "udp"},
{"xmlrpc-beep",        {NULL}, 602, "tcp"},
{"xmlrpc-beep",        {NULL}, 602, "udp"},
{"idxp",               {NULL}, 603, "tcp"},
{"idxp",               {NULL}, 603, "udp"},
{"tunnel",             {NULL}, 604, "tcp"},
{"tunnel",             {NULL}, 604, "udp"},
{"soap-beep",          {NULL}, 605, "tcp"},
{"soap-beep",          {NULL}, 605, "udp"},
{"urm",                {NULL}, 606, "tcp"},
{"urm",                {NULL}, 606, "udp"},
{"nqs",                {NULL}, 607, "tcp"},
{"nqs",                {NULL}, 607, "udp"},
{"sift-uft",           {NULL}, 608, "tcp"},
{"sift-uft",           {NULL}, 608, "udp"},
{"npmp-trap",          {NULL}, 609, "tcp"},
{"npmp-trap",          {NULL}, 609, "udp"},
{"npmp-local",         {NULL}, 610, "tcp"},
{"npmp-local",         {NULL}, 610, "udp"},
{"npmp-gui",           {NULL}, 611, "tcp"},
{"npmp-gui",           {NULL}, 611, "udp"},
{"hmmp-ind",           {NULL}, 612, "tcp"},
{"hmmp-ind",           {NULL}, 612, "udp"},
{"hmmp-op",            {NULL}, 613, "tcp"},
{"hmmp-op",            {NULL}, 613, "udp"},
{"sshell",             {NULL}, 614, "tcp"},
{"sshell",             {NULL}, 614, "udp"},
{"sco-inetmgr",        {NULL}, 615, "tcp"},
{"sco-inetmgr",        {NULL}, 615, "udp"},
{"sco-sysmgr",         {NULL}, 616, "tcp"},
{"sco-sysmgr",         {NULL}, 616, "udp"},
{"sco-dtmgr",          {NULL}, 617, "tcp"},
{"sco-dtmgr",          {NULL}, 617, "udp"},
{"dei-icda",           {NULL}, 618, "tcp"},
{"dei-icda",           {NULL}, 618, "udp"},
{"compaq-evm",         {NULL}, 619, "tcp"},
{"compaq-evm",         {NULL}, 619, "udp"},
{"sco-websrvrmgr",     {NULL}, 620, "tcp"},
{"sco-websrvrmgr",     {NULL}, 620, "udp"},
{"escp-ip",            {NULL}, 621, "tcp"},
{"escp-ip",            {NULL}, 621, "udp"},
{"collaborator",       {NULL}, 622, "tcp"},
{"collaborator",       {NULL}, 622, "udp"},
{"oob-ws-http",        {NULL}, 623, "tcp"},
{"asf-rmcp",           {NULL}, 623, "udp"},
{"cryptoadmin",        {NULL}, 624, "tcp"},
{"cryptoadmin",        {NULL}, 624, "udp"},
{"dec_dlm",            {NULL}, 625, "tcp"},
{"dec_dlm",            {NULL}, 625, "udp"},
{"asia",               {NULL}, 626, "tcp"},
{"asia",               {NULL}, 626, "udp"},
{"passgo-tivoli",      {NULL}, 627, "tcp"},
{"passgo-tivoli",      {NULL}, 627, "udp"},
{"qmqp",               {NULL}, 628, "tcp"},
{"qmqp",               {NULL}, 628, "udp"},
{"3com-amp3",          {NULL}, 629, "tcp"},
{"3com-amp3",          {NULL}, 629, "udp"},
{"rda",                {NULL}, 630, "tcp"},
{"rda",                {NULL}, 630, "udp"},
{"ipp",                {NULL}, 631, "tcp"},
{"ipp",                {NULL}, 631, "udp"},
{"bmpp",               {NULL}, 632, "tcp"},
{"bmpp",               {NULL}, 632, "udp"},
{"servstat",           {NULL}, 633, "tcp"},
{"servstat",           {NULL}, 633, "udp"},
{"ginad",              {NULL}, 634, "tcp"},
{"ginad",              {NULL}, 634, "udp"},
{"rlzdbase",           {NULL}, 635, "tcp"},
{"rlzdbase",           {NULL}, 635, "udp"},
{"ldaps",              {NULL}, 636, "tcp"},
{"ldaps",              {NULL}, 636, "udp"},
{"lanserver",          {NULL}, 637, "tcp"},
{"lanserver",          {NULL}, 637, "udp"},
{"mcns-sec",           {NULL}, 638, "tcp"},
{"mcns-sec",           {NULL}, 638, "udp"},
{"msdp",               {NULL}, 639, "tcp"},
{"msdp",               {NULL}, 639, "udp"},
{"entrust-sps",        {NULL}, 640, "tcp"},
{"entrust-sps",        {NULL}, 640, "udp"},
{"repcmd",             {NULL}, 641, "tcp"},
{"repcmd",             {NULL}, 641, "udp"},
{"esro-emsdp",         {NULL}, 642, "tcp"},
{"esro-emsdp",         {NULL}, 642, "udp"},
{"sanity",             {NULL}, 643, "tcp"},
{"sanity",             {NULL}, 643, "udp"},
{"dwr",                {NULL}, 644, "tcp"},
{"dwr",                {NULL}, 644, "udp"},
{"pssc",               {NULL}, 645, "tcp"},
{"pssc",               {NULL}, 645, "udp"},
{"ldp",                {NULL}, 646, "tcp"},
{"ldp",                {NULL}, 646, "udp"},
{"dhcp-failover",      {NULL}, 647, "tcp"},
{"dhcp-failover",      {NULL}, 647, "udp"},
{"rrp",                {NULL}, 648, "tcp"},
{"rrp",                {NULL}, 648, "udp"},
{"cadview-3d",         {NULL}, 649, "tcp"},
{"cadview-3d",         {NULL}, 649, "udp"},
{"obex",               {NULL}, 650, "tcp"},
{"obex",               {NULL}, 650, "udp"},
{"ieee-mms",           {NULL}, 651, "tcp"},
{"ieee-mms",           {NULL}, 651, "udp"},
{"hello-port",         {NULL}, 652, "tcp"},
{"hello-port",         {NULL}, 652, "udp"},
{"repscmd",            {NULL}, 653, "tcp"},
{"repscmd",            {NULL}, 653, "udp"},
{"aodv",               {NULL}, 654, "tcp"},
{"aodv",               {NULL}, 654, "udp"},
{"tinc",               {NULL}, 655, "tcp"},
{"tinc",               {NULL}, 655, "udp"},
{"spmp",               {NULL}, 656, "tcp"},
{"spmp",               {NULL}, 656, "udp"},
{"rmc",                {NULL}, 657, "tcp"},
{"rmc",                {NULL}, 657, "udp"},
{"tenfold",            {NULL}, 658, "tcp"},
{"tenfold",            {NULL}, 658, "udp"},
{"mac-srvr-admin",     {NULL}, 660, "tcp"},
{"mac-srvr-admin",     {NULL}, 660, "udp"},
{"hap",                {NULL}, 661, "tcp"},
{"hap",                {NULL}, 661, "udp"},
{"pftp",               {NULL}, 662, "tcp"},
{"pftp",               {NULL}, 662, "udp"},
{"purenoise",          {NULL}, 663, "tcp"},
{"purenoise",          {NULL}, 663, "udp"},
{"oob-ws-https",       {NULL}, 664, "tcp"},
{"asf-secure-rmcp",    {NULL}, 664, "udp"},
{"sun-dr",             {NULL}, 665, "tcp"},
{"sun-dr",             {NULL}, 665, "udp"},
{"mdqs",               {NULL}, 666, "tcp"},
{"mdqs",               {NULL}, 666, "udp"},
{"doom",               {NULL}, 666, "tcp"},
{"doom",               {NULL}, 666, "udp"},
{"disclose",           {NULL}, 667, "tcp"},
{"disclose",           {NULL}, 667, "udp"},
{"mecomm",             {NULL}, 668, "tcp"},
{"mecomm",             {NULL}, 668, "udp"},
{"meregister",         {NULL}, 669, "tcp"},
{"meregister",         {NULL}, 669, "udp"},
{"vacdsm-sws",         {NULL}, 670, "tcp"},
{"vacdsm-sws",         {NULL}, 670, "udp"},
{"vacdsm-app",         {NULL}, 671, "tcp"},
{"vacdsm-app",         {NULL}, 671, "udp"},
{"vpps-qua",           {NULL}, 672, "tcp"},
{"vpps-qua",           {NULL}, 672, "udp"},
{"cimplex",            {NULL}, 673, "tcp"},
{"cimplex",            {NULL}, 673, "udp"},
{"acap",               {NULL}, 674, "tcp"},
{"acap",               {NULL}, 674, "udp"},
{"dctp",               {NULL}, 675, "tcp"},
{"dctp",               {NULL}, 675, "udp"},
{"vpps-via",           {NULL}, 676, "tcp"},
{"vpps-via",           {NULL}, 676, "udp"},
{"vpp",                {NULL}, 677, "tcp"},
{"vpp",                {NULL}, 677, "udp"},
{"ggf-ncp",            {NULL}, 678, "tcp"},
{"ggf-ncp",            {NULL}, 678, "udp"},
{"mrm",                {NULL}, 679, "tcp"},
{"mrm",                {NULL}, 679, "udp"},
{"entrust-aaas",       {NULL}, 680, "tcp"},
{"entrust-aaas",       {NULL}, 680, "udp"},
{"entrust-aams",       {NULL}, 681, "tcp"},
{"entrust-aams",       {NULL}, 681, "udp"},
{"xfr",                {NULL}, 682, "tcp"},
{"xfr",                {NULL}, 682, "udp"},
{"corba-iiop",         {NULL}, 683, "tcp"},
{"corba-iiop",         {NULL}, 683, "udp"},
{"corba-iiop-ssl",     {NULL}, 684, "tcp"},
{"corba-iiop-ssl",     {NULL}, 684, "udp"},
{"mdc-portmapper",     {NULL}, 685, "tcp"},
{"mdc-portmapper",     {NULL}, 685, "udp"},
{"hcp-wismar",         {NULL}, 686, "tcp"},
{"hcp-wismar",         {NULL}, 686, "udp"},
{"asipregistry",       {NULL}, 687, "tcp"},
{"asipregistry",       {NULL}, 687, "udp"},
{"realm-rusd",         {NULL}, 688, "tcp"},
{"realm-rusd",         {NULL}, 688, "udp"},
{"nmap",               {NULL}, 689, "tcp"},
{"nmap",               {NULL}, 689, "udp"},
{"vatp",               {NULL}, 690, "tcp"},
{"vatp",               {NULL}, 690, "udp"},
{"msexch-routing",     {NULL}, 691, "tcp"},
{"msexch-routing",     {NULL}, 691, "udp"},
{"hyperwave-isp",      {NULL}, 692, "tcp"},
{"hyperwave-isp",      {NULL}, 692, "udp"},
{"connendp",           {NULL}, 693, "tcp"},
{"connendp",           {NULL}, 693, "udp"},
{"ha-cluster",         {NULL}, 694, "tcp"},
{"ha-cluster",         {NULL}, 694, "udp"},
{"ieee-mms-ssl",       {NULL}, 695, "tcp"},
{"ieee-mms-ssl",       {NULL}, 695, "udp"},
{"rushd",              {NULL}, 696, "tcp"},
{"rushd",              {NULL}, 696, "udp"},
{"uuidgen",            {NULL}, 697, "tcp"},
{"uuidgen",            {NULL}, 697, "udp"},
{"olsr",               {NULL}, 698, "tcp"},
{"olsr",               {NULL}, 698, "udp"},
{"accessnetwork",      {NULL}, 699, "tcp"},
{"accessnetwork",      {NULL}, 699, "udp"},
{"epp",                {NULL}, 700, "tcp"},
{"epp",                {NULL}, 700, "udp"},
{"lmp",                {NULL}, 701, "tcp"},
{"lmp",                {NULL}, 701, "udp"},
{"iris-beep",          {NULL}, 702, "tcp"},
{"iris-beep",          {NULL}, 702, "udp"},
{"elcsd",              {NULL}, 704, "tcp"},
{"elcsd",              {NULL}, 704, "udp"},
{"agentx",             {NULL}, 705, "tcp"},
{"agentx",             {NULL}, 705, "udp"},
{"silc",               {NULL}, 706, "tcp"},
{"silc",               {NULL}, 706, "udp"},
{"borland-dsj",        {NULL}, 707, "tcp"},
{"borland-dsj",        {NULL}, 707, "udp"},
{"entrust-kmsh",       {NULL}, 709, "tcp"},
{"entrust-kmsh",       {NULL}, 709, "udp"},
{"entrust-ash",        {NULL}, 710, "tcp"},
{"entrust-ash",        {NULL}, 710, "udp"},
{"cisco-tdp",          {NULL}, 711, "tcp"},
{"cisco-tdp",          {NULL}, 711, "udp"},
{"tbrpf",              {NULL}, 712, "tcp"},
{"tbrpf",              {NULL}, 712, "udp"},
{"iris-xpc",           {NULL}, 713, "tcp"},
{"iris-xpc",           {NULL}, 713, "udp"},
{"iris-xpcs",          {NULL}, 714, "tcp"},
{"iris-xpcs",          {NULL}, 714, "udp"},
{"iris-lwz",           {NULL}, 715, "tcp"},
{"iris-lwz",           {NULL}, 715, "udp"},
{"pana",               {NULL}, 716, "udp"},
{"netviewdm1",         {NULL}, 729, "tcp"},
{"netviewdm1",         {NULL}, 729, "udp"},
{"netviewdm2",         {NULL}, 730, "tcp"},
{"netviewdm2",         {NULL}, 730, "udp"},
{"netviewdm3",         {NULL}, 731, "tcp"},
{"netviewdm3",         {NULL}, 731, "udp"},
{"netgw",              {NULL}, 741, "tcp"},
{"netgw",              {NULL}, 741, "udp"},
{"netrcs",             {NULL}, 742, "tcp"},
{"netrcs",             {NULL}, 742, "udp"},
{"flexlm",             {NULL}, 744, "tcp"},
{"flexlm",             {NULL}, 744, "udp"},
{"fujitsu-dev",        {NULL}, 747, "tcp"},
{"fujitsu-dev",        {NULL}, 747, "udp"},
{"ris-cm",             {NULL}, 748, "tcp"},
{"ris-cm",             {NULL}, 748, "udp"},
{"kerberos-adm",       {NULL}, 749, "tcp"},
{"kerberos-adm",       {NULL}, 749, "udp"},
{"rfile",              {NULL}, 750, "tcp"},
{"loadav",             {NULL}, 750, "udp"},
{"kerberos-iv",        {NULL}, 750, "udp"},
{"pump",               {NULL}, 751, "tcp"},
{"pump",               {NULL}, 751, "udp"},
{"qrh",                {NULL}, 752, "tcp"},
{"qrh",                {NULL}, 752, "udp"},
{"rrh",                {NULL}, 753, "tcp"},
{"rrh",                {NULL}, 753, "udp"},
{"tell",               {NULL}, 754, "tcp"},
{"tell",               {NULL}, 754, "udp"},
{"nlogin",             {NULL}, 758, "tcp"},
{"nlogin",             {NULL}, 758, "udp"},
{"con",                {NULL}, 759, "tcp"},
{"con",                {NULL}, 759, "udp"},
{"ns",                 {NULL}, 760, "tcp"},
{"ns",                 {NULL}, 760, "udp"},
{"rxe",                {NULL}, 761, "tcp"},
{"rxe",                {NULL}, 761, "udp"},
{"quotad",             {NULL}, 762, "tcp"},
{"quotad",             {NULL}, 762, "udp"},
{"cycleserv",          {NULL}, 763, "tcp"},
{"cycleserv",          {NULL}, 763, "udp"},
{"omserv",             {NULL}, 764, "tcp"},
{"omserv",             {NULL}, 764, "udp"},
{"webster",            {NULL}, 765, "tcp"},
{"webster",            {NULL}, 765, "udp"},
{"phonebook",          {NULL}, 767, "tcp"},
{"phonebook",          {NULL}, 767, "udp"},
{"vid",                {NULL}, 769, "tcp"},
{"vid",                {NULL}, 769, "udp"},
{"cadlock",            {NULL}, 770, "tcp"},
{"cadlock",            {NULL}, 770, "udp"},
{"rtip",               {NULL}, 771, "tcp"},
{"rtip",               {NULL}, 771, "udp"},
{"cycleserv2",         {NULL}, 772, "tcp"},
{"cycleserv2",         {NULL}, 772, "udp"},
{"submit",             {NULL}, 773, "tcp"},
{"notify",             {NULL}, 773, "udp"},
{"rpasswd",            {NULL}, 774, "tcp"},
{"acmaint_dbd",        {NULL}, 774, "udp"},
{"entomb",             {NULL}, 775, "tcp"},
{"acmaint_transd",     {NULL}, 775, "udp"},
{"wpages",             {NULL}, 776, "tcp"},
{"wpages",             {NULL}, 776, "udp"},
{"multiling-http",     {NULL}, 777, "tcp"},
{"multiling-http",     {NULL}, 777, "udp"},
{"wpgs",               {NULL}, 780, "tcp"},
{"wpgs",               {NULL}, 780, "udp"},
{"mdbs_daemon",        {NULL}, 800, "tcp"},
{"mdbs_daemon",        {NULL}, 800, "udp"},
{"device",             {NULL}, 801, "tcp"},
{"device",             {NULL}, 801, "udp"},
{"fcp-udp",            {NULL}, 810, "tcp"},
{"fcp-udp",            {NULL}, 810, "udp"},
{"itm-mcell-s",        {NULL}, 828, "tcp"},
{"itm-mcell-s",        {NULL}, 828, "udp"},
{"pkix-3-ca-ra",       {NULL}, 829, "tcp"},
{"pkix-3-ca-ra",       {NULL}, 829, "udp"},
{"netconf-ssh",        {NULL}, 830, "tcp"},
{"netconf-ssh",        {NULL}, 830, "udp"},
{"netconf-beep",       {NULL}, 831, "tcp"},
{"netconf-beep",       {NULL}, 831, "udp"},
{"netconfsoaphttp",    {NULL}, 832, "tcp"},
{"netconfsoaphttp",    {NULL}, 832, "udp"},
{"netconfsoapbeep",    {NULL}, 833, "tcp"},
{"netconfsoapbeep",    {NULL}, 833, "udp"},
{"dhcp-failover2",     {NULL}, 847, "tcp"},
{"dhcp-failover2",     {NULL}, 847, "udp"},
{"gdoi",               {NULL}, 848, "tcp"},
{"gdoi",               {NULL}, 848, "udp"},
{"iscsi",              {NULL}, 860, "tcp"},
{"iscsi",              {NULL}, 860, "udp"},
{"owamp-control",      {NULL}, 861, "tcp"},
{"owamp-control",      {NULL}, 861, "udp"},
{"twamp-control",      {NULL}, 862, "tcp"},
{"twamp-control",      {NULL}, 862, "udp"},
{"rsync",              {NULL}, 873, "tcp"},
{"rsync",              {NULL}, 873, "udp"},
{"iclcnet-locate",     {NULL}, 886, "tcp"},
{"iclcnet-locate",     {NULL}, 886, "udp"},
{"iclcnet_svinfo",     {NULL}, 887, "tcp"},
{"iclcnet_svinfo",     {NULL}, 887, "udp"},
{"accessbuilder",      {NULL}, 888, "tcp"},
{"accessbuilder",      {NULL}, 888, "udp"},
{"cddbp",              {NULL}, 888, "tcp"},
{"omginitialrefs",     {NULL}, 900, "tcp"},
{"omginitialrefs",     {NULL}, 900, "udp"},
{"smpnameres",         {NULL}, 901, "tcp"},
{"smpnameres",         {NULL}, 901, "udp"},
{"ideafarm-door",      {NULL}, 902, "tcp"},
{"ideafarm-door",      {NULL}, 902, "udp"},
{"ideafarm-panic",     {NULL}, 903, "tcp"},
{"ideafarm-panic",     {NULL}, 903, "udp"},
{"kink",               {NULL}, 910, "tcp"},
{"kink",               {NULL}, 910, "udp"},
{"xact-backup",        {NULL}, 911, "tcp"},
{"xact-backup",        {NULL}, 911, "udp"},
{"apex-mesh",          {NULL}, 912, "tcp"},
{"apex-mesh",          {NULL}, 912, "udp"},
{"apex-edge",          {NULL}, 913, "tcp"},
{"apex-edge",          {NULL}, 913, "udp"},
{"ftps-data",          {NULL}, 989, "tcp"},
{"ftps-data",          {NULL}, 989, "udp"},
{"ftps",               {NULL}, 990, "tcp"},
{"ftps",               {NULL}, 990, "udp"},
{"nas",                {NULL}, 991, "tcp"},
{"nas",                {NULL}, 991, "udp"},
{"telnets",            {NULL}, 992, "tcp"},
{"telnets",            {NULL}, 992, "udp"},
{"imaps",              {NULL}, 993, "tcp"},
{"imaps",              {NULL}, 993, "udp"},
{"ircs",               {NULL}, 994, "tcp"},
{"ircs",               {NULL}, 994, "udp"},
{"pop3s",              {NULL}, 995, "tcp"},
{"pop3s",              {NULL}, 995, "udp"},
{"vsinet",             {NULL}, 996, "tcp"},
{"vsinet",             {NULL}, 996, "udp"},
{"maitrd",             {NULL}, 997, "tcp"},
{"maitrd",             {NULL}, 997, "udp"},
{"busboy",             {NULL}, 998, "tcp"},
{"puparp",             {NULL}, 998, "udp"},
{"garcon",             {NULL}, 999, "tcp"},
{"applix",             {NULL}, 999, "udp"},
{"puprouter",          {NULL}, 999, "tcp"},
{"puprouter",          {NULL}, 999, "udp"},
{"cadlock2",           {NULL}, 1000, "tcp"},
{"cadlock2",           {NULL}, 1000, "udp"},
{"surf",               {NULL}, 1010, "tcp"},
{"surf",               {NULL}, 1010, "udp"},
{"exp1",               {NULL}, 1021, "tcp"},
{"exp1",               {NULL}, 1021, "udp"},
{"exp2",               {NULL}, 1022, "tcp"},
{"exp2",               {NULL}, 1022, "udp"},
#endif /* USE_IANA_WELL_KNOWN_PORTS */
#ifdef USE_IANA_REGISTERED_PORTS
{"blackjack",          {NULL}, 1025, "tcp"},
{"blackjack",          {NULL}, 1025, "udp"},
{"cap",                {NULL}, 1026, "tcp"},
{"cap",                {NULL}, 1026, "udp"},
{"solid-mux",          {NULL}, 1029, "tcp"},
{"solid-mux",          {NULL}, 1029, "udp"},
{"iad1",               {NULL}, 1030, "tcp"},
{"iad1",               {NULL}, 1030, "udp"},
{"iad2",               {NULL}, 1031, "tcp"},
{"iad2",               {NULL}, 1031, "udp"},
{"iad3",               {NULL}, 1032, "tcp"},
{"iad3",               {NULL}, 1032, "udp"},
{"netinfo-local",      {NULL}, 1033, "tcp"},
{"netinfo-local",      {NULL}, 1033, "udp"},
{"activesync",         {NULL}, 1034, "tcp"},
{"activesync",         {NULL}, 1034, "udp"},
{"mxxrlogin",          {NULL}, 1035, "tcp"},
{"mxxrlogin",          {NULL}, 1035, "udp"},
{"nsstp",              {NULL}, 1036, "tcp"},
{"nsstp",              {NULL}, 1036, "udp"},
{"ams",                {NULL}, 1037, "tcp"},
{"ams",                {NULL}, 1037, "udp"},
{"mtqp",               {NULL}, 1038, "tcp"},
{"mtqp",               {NULL}, 1038, "udp"},
{"sbl",                {NULL}, 1039, "tcp"},
{"sbl",                {NULL}, 1039, "udp"},
{"netarx",             {NULL}, 1040, "tcp"},
{"netarx",             {NULL}, 1040, "udp"},
{"danf-ak2",           {NULL}, 1041, "tcp"},
{"danf-ak2",           {NULL}, 1041, "udp"},
{"afrog",              {NULL}, 1042, "tcp"},
{"afrog",              {NULL}, 1042, "udp"},
{"boinc-client",       {NULL}, 1043, "tcp"},
{"boinc-client",       {NULL}, 1043, "udp"},
{"dcutility",          {NULL}, 1044, "tcp"},
{"dcutility",          {NULL}, 1044, "udp"},
{"fpitp",              {NULL}, 1045, "tcp"},
{"fpitp",              {NULL}, 1045, "udp"},
{"wfremotertm",        {NULL}, 1046, "tcp"},
{"wfremotertm",        {NULL}, 1046, "udp"},
{"neod1",              {NULL}, 1047, "tcp"},
{"neod1",              {NULL}, 1047, "udp"},
{"neod2",              {NULL}, 1048, "tcp"},
{"neod2",              {NULL}, 1048, "udp"},
{"td-postman",         {NULL}, 1049, "tcp"},
{"td-postman",         {NULL}, 1049, "udp"},
{"cma",                {NULL}, 1050, "tcp"},
{"cma",                {NULL}, 1050, "udp"},
{"optima-vnet",        {NULL}, 1051, "tcp"},
{"optima-vnet",        {NULL}, 1051, "udp"},
{"ddt",                {NULL}, 1052, "tcp"},
{"ddt",                {NULL}, 1052, "udp"},
{"remote-as",          {NULL}, 1053, "tcp"},
{"remote-as",          {NULL}, 1053, "udp"},
{"brvread",            {NULL}, 1054, "tcp"},
{"brvread",            {NULL}, 1054, "udp"},
{"ansyslmd",           {NULL}, 1055, "tcp"},
{"ansyslmd",           {NULL}, 1055, "udp"},
{"vfo",                {NULL}, 1056, "tcp"},
{"vfo",                {NULL}, 1056, "udp"},
{"startron",           {NULL}, 1057, "tcp"},
{"startron",           {NULL}, 1057, "udp"},
{"nim",                {NULL}, 1058, "tcp"},
{"nim",                {NULL}, 1058, "udp"},
{"nimreg",             {NULL}, 1059, "tcp"},
{"nimreg",             {NULL}, 1059, "udp"},
{"polestar",           {NULL}, 1060, "tcp"},
{"polestar",           {NULL}, 1060, "udp"},
{"kiosk",              {NULL}, 1061, "tcp"},
{"kiosk",              {NULL}, 1061, "udp"},
{"veracity",           {NULL}, 1062, "tcp"},
{"veracity",           {NULL}, 1062, "udp"},
{"kyoceranetdev",      {NULL}, 1063, "tcp"},
{"kyoceranetdev",      {NULL}, 1063, "udp"},
{"jstel",              {NULL}, 1064, "tcp"},
{"jstel",              {NULL}, 1064, "udp"},
{"syscomlan",          {NULL}, 1065, "tcp"},
{"syscomlan",          {NULL}, 1065, "udp"},
{"fpo-fns",            {NULL}, 1066, "tcp"},
{"fpo-fns",            {NULL}, 1066, "udp"},
{"instl_boots",        {NULL}, 1067, "tcp"},
{"instl_boots",        {NULL}, 1067, "udp"},
{"instl_bootc",        {NULL}, 1068, "tcp"},
{"instl_bootc",        {NULL}, 1068, "udp"},
{"cognex-insight",     {NULL}, 1069, "tcp"},
{"cognex-insight",     {NULL}, 1069, "udp"},
{"gmrupdateserv",      {NULL}, 1070, "tcp"},
{"gmrupdateserv",      {NULL}, 1070, "udp"},
{"bsquare-voip",       {NULL}, 1071, "tcp"},
{"bsquare-voip",       {NULL}, 1071, "udp"},
{"cardax",             {NULL}, 1072, "tcp"},
{"cardax",             {NULL}, 1072, "udp"},
{"bridgecontrol",      {NULL}, 1073, "tcp"},
{"bridgecontrol",      {NULL}, 1073, "udp"},
{"warmspotMgmt",       {NULL}, 1074, "tcp"},
{"warmspotMgmt",       {NULL}, 1074, "udp"},
{"rdrmshc",            {NULL}, 1075, "tcp"},
{"rdrmshc",            {NULL}, 1075, "udp"},
{"dab-sti-c",          {NULL}, 1076, "tcp"},
{"dab-sti-c",          {NULL}, 1076, "udp"},
{"imgames",            {NULL}, 1077, "tcp"},
{"imgames",            {NULL}, 1077, "udp"},
{"avocent-proxy",      {NULL}, 1078, "tcp"},
{"avocent-proxy",      {NULL}, 1078, "udp"},
{"asprovatalk",        {NULL}, 1079, "tcp"},
{"asprovatalk",        {NULL}, 1079, "udp"},
{"socks",              {NULL}, 1080, "tcp"},
{"socks",              {NULL}, 1080, "udp"},
{"pvuniwien",          {NULL}, 1081, "tcp"},
{"pvuniwien",          {NULL}, 1081, "udp"},
{"amt-esd-prot",       {NULL}, 1082, "tcp"},
{"amt-esd-prot",       {NULL}, 1082, "udp"},
{"ansoft-lm-1",        {NULL}, 1083, "tcp"},
{"ansoft-lm-1",        {NULL}, 1083, "udp"},
{"ansoft-lm-2",        {NULL}, 1084, "tcp"},
{"ansoft-lm-2",        {NULL}, 1084, "udp"},
{"webobjects",         {NULL}, 1085, "tcp"},
{"webobjects",         {NULL}, 1085, "udp"},
{"cplscrambler-lg",    {NULL}, 1086, "tcp"},
{"cplscrambler-lg",    {NULL}, 1086, "udp"},
{"cplscrambler-in",    {NULL}, 1087, "tcp"},
{"cplscrambler-in",    {NULL}, 1087, "udp"},
{"cplscrambler-al",    {NULL}, 1088, "tcp"},
{"cplscrambler-al",    {NULL}, 1088, "udp"},
{"ff-annunc",          {NULL}, 1089, "tcp"},
{"ff-annunc",          {NULL}, 1089, "udp"},
{"ff-fms",             {NULL}, 1090, "tcp"},
{"ff-fms",             {NULL}, 1090, "udp"},
{"ff-sm",              {NULL}, 1091, "tcp"},
{"ff-sm",              {NULL}, 1091, "udp"},
{"obrpd",              {NULL}, 1092, "tcp"},
{"obrpd",              {NULL}, 1092, "udp"},
{"proofd",             {NULL}, 1093, "tcp"},
{"proofd",             {NULL}, 1093, "udp"},
{"rootd",              {NULL}, 1094, "tcp"},
{"rootd",              {NULL}, 1094, "udp"},
{"nicelink",           {NULL}, 1095, "tcp"},
{"nicelink",           {NULL}, 1095, "udp"},
{"cnrprotocol",        {NULL}, 1096, "tcp"},
{"cnrprotocol",        {NULL}, 1096, "udp"},
{"sunclustermgr",      {NULL}, 1097, "tcp"},
{"sunclustermgr",      {NULL}, 1097, "udp"},
{"rmiactivation",      {NULL}, 1098, "tcp"},
{"rmiactivation",      {NULL}, 1098, "udp"},
{"rmiregistry",        {NULL}, 1099, "tcp"},
{"rmiregistry",        {NULL}, 1099, "udp"},
{"mctp",               {NULL}, 1100, "tcp"},
{"mctp",               {NULL}, 1100, "udp"},
{"pt2-discover",       {NULL}, 1101, "tcp"},
{"pt2-discover",       {NULL}, 1101, "udp"},
{"adobeserver-1",      {NULL}, 1102, "tcp"},
{"adobeserver-1",      {NULL}, 1102, "udp"},
{"adobeserver-2",      {NULL}, 1103, "tcp"},
{"adobeserver-2",      {NULL}, 1103, "udp"},
{"xrl",                {NULL}, 1104, "tcp"},
{"xrl",                {NULL}, 1104, "udp"},
{"ftranhc",            {NULL}, 1105, "tcp"},
{"ftranhc",            {NULL}, 1105, "udp"},
{"isoipsigport-1",     {NULL}, 1106, "tcp"},
{"isoipsigport-1",     {NULL}, 1106, "udp"},
{"isoipsigport-2",     {NULL}, 1107, "tcp"},
{"isoipsigport-2",     {NULL}, 1107, "udp"},
{"ratio-adp",          {NULL}, 1108, "tcp"},
{"ratio-adp",          {NULL}, 1108, "udp"},
{"webadmstart",        {NULL}, 1110, "tcp"},
{"nfsd-keepalive",     {NULL}, 1110, "udp"},
{"lmsocialserver",     {NULL}, 1111, "tcp"},
{"lmsocialserver",     {NULL}, 1111, "udp"},
{"icp",                {NULL}, 1112, "tcp"},
{"icp",                {NULL}, 1112, "udp"},
{"ltp-deepspace",      {NULL}, 1113, "tcp"},
{"ltp-deepspace",      {NULL}, 1113, "udp"},
{"mini-sql",           {NULL}, 1114, "tcp"},
{"mini-sql",           {NULL}, 1114, "udp"},
{"ardus-trns",         {NULL}, 1115, "tcp"},
{"ardus-trns",         {NULL}, 1115, "udp"},
{"ardus-cntl",         {NULL}, 1116, "tcp"},
{"ardus-cntl",         {NULL}, 1116, "udp"},
{"ardus-mtrns",        {NULL}, 1117, "tcp"},
{"ardus-mtrns",        {NULL}, 1117, "udp"},
{"sacred",             {NULL}, 1118, "tcp"},
{"sacred",             {NULL}, 1118, "udp"},
{"bnetgame",           {NULL}, 1119, "tcp"},
{"bnetgame",           {NULL}, 1119, "udp"},
{"bnetfile",           {NULL}, 1120, "tcp"},
{"bnetfile",           {NULL}, 1120, "udp"},
{"rmpp",               {NULL}, 1121, "tcp"},
{"rmpp",               {NULL}, 1121, "udp"},
{"availant-mgr",       {NULL}, 1122, "tcp"},
{"availant-mgr",       {NULL}, 1122, "udp"},
{"murray",             {NULL}, 1123, "tcp"},
{"murray",             {NULL}, 1123, "udp"},
{"hpvmmcontrol",       {NULL}, 1124, "tcp"},
{"hpvmmcontrol",       {NULL}, 1124, "udp"},
{"hpvmmagent",         {NULL}, 1125, "tcp"},
{"hpvmmagent",         {NULL}, 1125, "udp"},
{"hpvmmdata",          {NULL}, 1126, "tcp"},
{"hpvmmdata",          {NULL}, 1126, "udp"},
{"kwdb-commn",         {NULL}, 1127, "tcp"},
{"kwdb-commn",         {NULL}, 1127, "udp"},
{"saphostctrl",        {NULL}, 1128, "tcp"},
{"saphostctrl",        {NULL}, 1128, "udp"},
{"saphostctrls",       {NULL}, 1129, "tcp"},
{"saphostctrls",       {NULL}, 1129, "udp"},
{"casp",               {NULL}, 1130, "tcp"},
{"casp",               {NULL}, 1130, "udp"},
{"caspssl",            {NULL}, 1131, "tcp"},
{"caspssl",            {NULL}, 1131, "udp"},
{"kvm-via-ip",         {NULL}, 1132, "tcp"},
{"kvm-via-ip",         {NULL}, 1132, "udp"},
{"dfn",                {NULL}, 1133, "tcp"},
{"dfn",                {NULL}, 1133, "udp"},
{"aplx",               {NULL}, 1134, "tcp"},
{"aplx",               {NULL}, 1134, "udp"},
{"omnivision",         {NULL}, 1135, "tcp"},
{"omnivision",         {NULL}, 1135, "udp"},
{"hhb-gateway",        {NULL}, 1136, "tcp"},
{"hhb-gateway",        {NULL}, 1136, "udp"},
{"trim",               {NULL}, 1137, "tcp"},
{"trim",               {NULL}, 1137, "udp"},
{"encrypted_admin",    {NULL}, 1138, "tcp"},
{"encrypted_admin",    {NULL}, 1138, "udp"},
{"evm",                {NULL}, 1139, "tcp"},
{"evm",                {NULL}, 1139, "udp"},
{"autonoc",            {NULL}, 1140, "tcp"},
{"autonoc",            {NULL}, 1140, "udp"},
{"mxomss",             {NULL}, 1141, "tcp"},
{"mxomss",             {NULL}, 1141, "udp"},
{"edtools",            {NULL}, 1142, "tcp"},
{"edtools",            {NULL}, 1142, "udp"},
{"imyx",               {NULL}, 1143, "tcp"},
{"imyx",               {NULL}, 1143, "udp"},
{"fuscript",           {NULL}, 1144, "tcp"},
{"fuscript",           {NULL}, 1144, "udp"},
{"x9-icue",            {NULL}, 1145, "tcp"},
{"x9-icue",            {NULL}, 1145, "udp"},
{"audit-transfer",     {NULL}, 1146, "tcp"},
{"audit-transfer",     {NULL}, 1146, "udp"},
{"capioverlan",        {NULL}, 1147, "tcp"},
{"capioverlan",        {NULL}, 1147, "udp"},
{"elfiq-repl",         {NULL}, 1148, "tcp"},
{"elfiq-repl",         {NULL}, 1148, "udp"},
{"bvtsonar",           {NULL}, 1149, "tcp"},
{"bvtsonar",           {NULL}, 1149, "udp"},
{"blaze",              {NULL}, 1150, "tcp"},
{"blaze",              {NULL}, 1150, "udp"},
{"unizensus",          {NULL}, 1151, "tcp"},
{"unizensus",          {NULL}, 1151, "udp"},
{"winpoplanmess",      {NULL}, 1152, "tcp"},
{"winpoplanmess",      {NULL}, 1152, "udp"},
{"c1222-acse",         {NULL}, 1153, "tcp"},
{"c1222-acse",         {NULL}, 1153, "udp"},
{"resacommunity",      {NULL}, 1154, "tcp"},
{"resacommunity",      {NULL}, 1154, "udp"},
{"nfa",                {NULL}, 1155, "tcp"},
{"nfa",                {NULL}, 1155, "udp"},
{"iascontrol-oms",     {NULL}, 1156, "tcp"},
{"iascontrol-oms",     {NULL}, 1156, "udp"},
{"iascontrol",         {NULL}, 1157, "tcp"},
{"iascontrol",         {NULL}, 1157, "udp"},
{"dbcontrol-oms",      {NULL}, 1158, "tcp"},
{"dbcontrol-oms",      {NULL}, 1158, "udp"},
{"oracle-oms",         {NULL}, 1159, "tcp"},
{"oracle-oms",         {NULL}, 1159, "udp"},
{"olsv",               {NULL}, 1160, "tcp"},
{"olsv",               {NULL}, 1160, "udp"},
{"health-polling",     {NULL}, 1161, "tcp"},
{"health-polling",     {NULL}, 1161, "udp"},
{"health-trap",        {NULL}, 1162, "tcp"},
{"health-trap",        {NULL}, 1162, "udp"},
{"sddp",               {NULL}, 1163, "tcp"},
{"sddp",               {NULL}, 1163, "udp"},
{"qsm-proxy",          {NULL}, 1164, "tcp"},
{"qsm-proxy",          {NULL}, 1164, "udp"},
{"qsm-gui",            {NULL}, 1165, "tcp"},
{"qsm-gui",            {NULL}, 1165, "udp"},
{"qsm-remote",         {NULL}, 1166, "tcp"},
{"qsm-remote",         {NULL}, 1166, "udp"},
{"cisco-ipsla",        {NULL}, 1167, "tcp"},
{"cisco-ipsla",        {NULL}, 1167, "udp"},
{"cisco-ipsla",        {NULL}, 1167, "sctp"},
{"vchat",              {NULL}, 1168, "tcp"},
{"vchat",              {NULL}, 1168, "udp"},
{"tripwire",           {NULL}, 1169, "tcp"},
{"tripwire",           {NULL}, 1169, "udp"},
{"atc-lm",             {NULL}, 1170, "tcp"},
{"atc-lm",             {NULL}, 1170, "udp"},
{"atc-appserver",      {NULL}, 1171, "tcp"},
{"atc-appserver",      {NULL}, 1171, "udp"},
{"dnap",               {NULL}, 1172, "tcp"},
{"dnap",               {NULL}, 1172, "udp"},
{"d-cinema-rrp",       {NULL}, 1173, "tcp"},
{"d-cinema-rrp",       {NULL}, 1173, "udp"},
{"fnet-remote-ui",     {NULL}, 1174, "tcp"},
{"fnet-remote-ui",     {NULL}, 1174, "udp"},
{"dossier",            {NULL}, 1175, "tcp"},
{"dossier",            {NULL}, 1175, "udp"},
{"indigo-server",      {NULL}, 1176, "tcp"},
{"indigo-server",      {NULL}, 1176, "udp"},
{"dkmessenger",        {NULL}, 1177, "tcp"},
{"dkmessenger",        {NULL}, 1177, "udp"},
{"sgi-storman",        {NULL}, 1178, "tcp"},
{"sgi-storman",        {NULL}, 1178, "udp"},
{"b2n",                {NULL}, 1179, "tcp"},
{"b2n",                {NULL}, 1179, "udp"},
{"mc-client",          {NULL}, 1180, "tcp"},
{"mc-client",          {NULL}, 1180, "udp"},
{"3comnetman",         {NULL}, 1181, "tcp"},
{"3comnetman",         {NULL}, 1181, "udp"},
{"accelenet",          {NULL}, 1182, "tcp"},
{"accelenet-data",     {NULL}, 1182, "udp"},
{"llsurfup-http",      {NULL}, 1183, "tcp"},
{"llsurfup-http",      {NULL}, 1183, "udp"},
{"llsurfup-https",     {NULL}, 1184, "tcp"},
{"llsurfup-https",     {NULL}, 1184, "udp"},
{"catchpole",          {NULL}, 1185, "tcp"},
{"catchpole",          {NULL}, 1185, "udp"},
{"mysql-cluster",      {NULL}, 1186, "tcp"},
{"mysql-cluster",      {NULL}, 1186, "udp"},
{"alias",              {NULL}, 1187, "tcp"},
{"alias",              {NULL}, 1187, "udp"},
{"hp-webadmin",        {NULL}, 1188, "tcp"},
{"hp-webadmin",        {NULL}, 1188, "udp"},
{"unet",               {NULL}, 1189, "tcp"},
{"unet",               {NULL}, 1189, "udp"},
{"commlinx-avl",       {NULL}, 1190, "tcp"},
{"commlinx-avl",       {NULL}, 1190, "udp"},
{"gpfs",               {NULL}, 1191, "tcp"},
{"gpfs",               {NULL}, 1191, "udp"},
{"caids-sensor",       {NULL}, 1192, "tcp"},
{"caids-sensor",       {NULL}, 1192, "udp"},
{"fiveacross",         {NULL}, 1193, "tcp"},
{"fiveacross",         {NULL}, 1193, "udp"},
{"openvpn",            {NULL}, 1194, "tcp"},
{"openvpn",            {NULL}, 1194, "udp"},
{"rsf-1",              {NULL}, 1195, "tcp"},
{"rsf-1",              {NULL}, 1195, "udp"},
{"netmagic",           {NULL}, 1196, "tcp"},
{"netmagic",           {NULL}, 1196, "udp"},
{"carrius-rshell",     {NULL}, 1197, "tcp"},
{"carrius-rshell",     {NULL}, 1197, "udp"},
{"cajo-discovery",     {NULL}, 1198, "tcp"},
{"cajo-discovery",     {NULL}, 1198, "udp"},
{"dmidi",              {NULL}, 1199, "tcp"},
{"dmidi",              {NULL}, 1199, "udp"},
{"scol",               {NULL}, 1200, "tcp"},
{"scol",               {NULL}, 1200, "udp"},
{"nucleus-sand",       {NULL}, 1201, "tcp"},
{"nucleus-sand",       {NULL}, 1201, "udp"},
{"caiccipc",           {NULL}, 1202, "tcp"},
{"caiccipc",           {NULL}, 1202, "udp"},
{"ssslic-mgr",         {NULL}, 1203, "tcp"},
{"ssslic-mgr",         {NULL}, 1203, "udp"},
{"ssslog-mgr",         {NULL}, 1204, "tcp"},
{"ssslog-mgr",         {NULL}, 1204, "udp"},
{"accord-mgc",         {NULL}, 1205, "tcp"},
{"accord-mgc",         {NULL}, 1205, "udp"},
{"anthony-data",       {NULL}, 1206, "tcp"},
{"anthony-data",       {NULL}, 1206, "udp"},
{"metasage",           {NULL}, 1207, "tcp"},
{"metasage",           {NULL}, 1207, "udp"},
{"seagull-ais",        {NULL}, 1208, "tcp"},
{"seagull-ais",        {NULL}, 1208, "udp"},
{"ipcd3",              {NULL}, 1209, "tcp"},
{"ipcd3",              {NULL}, 1209, "udp"},
{"eoss",               {NULL}, 1210, "tcp"},
{"eoss",               {NULL}, 1210, "udp"},
{"groove-dpp",         {NULL}, 1211, "tcp"},
{"groove-dpp",         {NULL}, 1211, "udp"},
{"lupa",               {NULL}, 1212, "tcp"},
{"lupa",               {NULL}, 1212, "udp"},
{"mpc-lifenet",        {NULL}, 1213, "tcp"},
{"mpc-lifenet",        {NULL}, 1213, "udp"},
{"kazaa",              {NULL}, 1214, "tcp"},
{"kazaa",              {NULL}, 1214, "udp"},
{"scanstat-1",         {NULL}, 1215, "tcp"},
{"scanstat-1",         {NULL}, 1215, "udp"},
{"etebac5",            {NULL}, 1216, "tcp"},
{"etebac5",            {NULL}, 1216, "udp"},
{"hpss-ndapi",         {NULL}, 1217, "tcp"},
{"hpss-ndapi",         {NULL}, 1217, "udp"},
{"aeroflight-ads",     {NULL}, 1218, "tcp"},
{"aeroflight-ads",     {NULL}, 1218, "udp"},
{"aeroflight-ret",     {NULL}, 1219, "tcp"},
{"aeroflight-ret",     {NULL}, 1219, "udp"},
{"qt-serveradmin",     {NULL}, 1220, "tcp"},
{"qt-serveradmin",     {NULL}, 1220, "udp"},
{"sweetware-apps",     {NULL}, 1221, "tcp"},
{"sweetware-apps",     {NULL}, 1221, "udp"},
{"nerv",               {NULL}, 1222, "tcp"},
{"nerv",               {NULL}, 1222, "udp"},
{"tgp",                {NULL}, 1223, "tcp"},
{"tgp",                {NULL}, 1223, "udp"},
{"vpnz",               {NULL}, 1224, "tcp"},
{"vpnz",               {NULL}, 1224, "udp"},
{"slinkysearch",       {NULL}, 1225, "tcp"},
{"slinkysearch",       {NULL}, 1225, "udp"},
{"stgxfws",            {NULL}, 1226, "tcp"},
{"stgxfws",            {NULL}, 1226, "udp"},
{"dns2go",             {NULL}, 1227, "tcp"},
{"dns2go",             {NULL}, 1227, "udp"},
{"florence",           {NULL}, 1228, "tcp"},
{"florence",           {NULL}, 1228, "udp"},
{"zented",             {NULL}, 1229, "tcp"},
{"zented",             {NULL}, 1229, "udp"},
{"periscope",          {NULL}, 1230, "tcp"},
{"periscope",          {NULL}, 1230, "udp"},
{"menandmice-lpm",     {NULL}, 1231, "tcp"},
{"menandmice-lpm",     {NULL}, 1231, "udp"},
{"univ-appserver",     {NULL}, 1233, "tcp"},
{"univ-appserver",     {NULL}, 1233, "udp"},
{"search-agent",       {NULL}, 1234, "tcp"},
{"search-agent",       {NULL}, 1234, "udp"},
{"mosaicsyssvc1",      {NULL}, 1235, "tcp"},
{"mosaicsyssvc1",      {NULL}, 1235, "udp"},
{"bvcontrol",          {NULL}, 1236, "tcp"},
{"bvcontrol",          {NULL}, 1236, "udp"},
{"tsdos390",           {NULL}, 1237, "tcp"},
{"tsdos390",           {NULL}, 1237, "udp"},
{"hacl-qs",            {NULL}, 1238, "tcp"},
{"hacl-qs",            {NULL}, 1238, "udp"},
{"nmsd",               {NULL}, 1239, "tcp"},
{"nmsd",               {NULL}, 1239, "udp"},
{"instantia",          {NULL}, 1240, "tcp"},
{"instantia",          {NULL}, 1240, "udp"},
{"nessus",             {NULL}, 1241, "tcp"},
{"nessus",             {NULL}, 1241, "udp"},
{"nmasoverip",         {NULL}, 1242, "tcp"},
{"nmasoverip",         {NULL}, 1242, "udp"},
{"serialgateway",      {NULL}, 1243, "tcp"},
{"serialgateway",      {NULL}, 1243, "udp"},
{"isbconference1",     {NULL}, 1244, "tcp"},
{"isbconference1",     {NULL}, 1244, "udp"},
{"isbconference2",     {NULL}, 1245, "tcp"},
{"isbconference2",     {NULL}, 1245, "udp"},
{"payrouter",          {NULL}, 1246, "tcp"},
{"payrouter",          {NULL}, 1246, "udp"},
{"visionpyramid",      {NULL}, 1247, "tcp"},
{"visionpyramid",      {NULL}, 1247, "udp"},
{"hermes",             {NULL}, 1248, "tcp"},
{"hermes",             {NULL}, 1248, "udp"},
{"mesavistaco",        {NULL}, 1249, "tcp"},
{"mesavistaco",        {NULL}, 1249, "udp"},
{"swldy-sias",         {NULL}, 1250, "tcp"},
{"swldy-sias",         {NULL}, 1250, "udp"},
{"servergraph",        {NULL}, 1251, "tcp"},
{"servergraph",        {NULL}, 1251, "udp"},
{"bspne-pcc",          {NULL}, 1252, "tcp"},
{"bspne-pcc",          {NULL}, 1252, "udp"},
{"q55-pcc",            {NULL}, 1253, "tcp"},
{"q55-pcc",            {NULL}, 1253, "udp"},
{"de-noc",             {NULL}, 1254, "tcp"},
{"de-noc",             {NULL}, 1254, "udp"},
{"de-cache-query",     {NULL}, 1255, "tcp"},
{"de-cache-query",     {NULL}, 1255, "udp"},
{"de-server",          {NULL}, 1256, "tcp"},
{"de-server",          {NULL}, 1256, "udp"},
{"shockwave2",         {NULL}, 1257, "tcp"},
{"shockwave2",         {NULL}, 1257, "udp"},
{"opennl",             {NULL}, 1258, "tcp"},
{"opennl",             {NULL}, 1258, "udp"},
{"opennl-voice",       {NULL}, 1259, "tcp"},
{"opennl-voice",       {NULL}, 1259, "udp"},
{"ibm-ssd",            {NULL}, 1260, "tcp"},
{"ibm-ssd",            {NULL}, 1260, "udp"},
{"mpshrsv",            {NULL}, 1261, "tcp"},
{"mpshrsv",            {NULL}, 1261, "udp"},
{"qnts-orb",           {NULL}, 1262, "tcp"},
{"qnts-orb",           {NULL}, 1262, "udp"},
{"dka",                {NULL}, 1263, "tcp"},
{"dka",                {NULL}, 1263, "udp"},
{"prat",               {NULL}, 1264, "tcp"},
{"prat",               {NULL}, 1264, "udp"},
{"dssiapi",            {NULL}, 1265, "tcp"},
{"dssiapi",            {NULL}, 1265, "udp"},
{"dellpwrappks",       {NULL}, 1266, "tcp"},
{"dellpwrappks",       {NULL}, 1266, "udp"},
{"epc",                {NULL}, 1267, "tcp"},
{"epc",                {NULL}, 1267, "udp"},
{"propel-msgsys",      {NULL}, 1268, "tcp"},
{"propel-msgsys",      {NULL}, 1268, "udp"},
{"watilapp",           {NULL}, 1269, "tcp"},
{"watilapp",           {NULL}, 1269, "udp"},
{"opsmgr",             {NULL}, 1270, "tcp"},
{"opsmgr",             {NULL}, 1270, "udp"},
{"excw",               {NULL}, 1271, "tcp"},
{"excw",               {NULL}, 1271, "udp"},
{"cspmlockmgr",        {NULL}, 1272, "tcp"},
{"cspmlockmgr",        {NULL}, 1272, "udp"},
{"emc-gateway",        {NULL}, 1273, "tcp"},
{"emc-gateway",        {NULL}, 1273, "udp"},
{"t1distproc",         {NULL}, 1274, "tcp"},
{"t1distproc",         {NULL}, 1274, "udp"},
{"ivcollector",        {NULL}, 1275, "tcp"},
{"ivcollector",        {NULL}, 1275, "udp"},
{"ivmanager",          {NULL}, 1276, "tcp"},
{"ivmanager",          {NULL}, 1276, "udp"},
{"miva-mqs",           {NULL}, 1277, "tcp"},
{"miva-mqs",           {NULL}, 1277, "udp"},
{"dellwebadmin-1",     {NULL}, 1278, "tcp"},
{"dellwebadmin-1",     {NULL}, 1278, "udp"},
{"dellwebadmin-2",     {NULL}, 1279, "tcp"},
{"dellwebadmin-2",     {NULL}, 1279, "udp"},
{"pictrography",       {NULL}, 1280, "tcp"},
{"pictrography",       {NULL}, 1280, "udp"},
{"healthd",            {NULL}, 1281, "tcp"},
{"healthd",            {NULL}, 1281, "udp"},
{"emperion",           {NULL}, 1282, "tcp"},
{"emperion",           {NULL}, 1282, "udp"},
{"productinfo",        {NULL}, 1283, "tcp"},
{"productinfo",        {NULL}, 1283, "udp"},
{"iee-qfx",            {NULL}, 1284, "tcp"},
{"iee-qfx",            {NULL}, 1284, "udp"},
{"neoiface",           {NULL}, 1285, "tcp"},
{"neoiface",           {NULL}, 1285, "udp"},
{"netuitive",          {NULL}, 1286, "tcp"},
{"netuitive",          {NULL}, 1286, "udp"},
{"routematch",         {NULL}, 1287, "tcp"},
{"routematch",         {NULL}, 1287, "udp"},
{"navbuddy",           {NULL}, 1288, "tcp"},
{"navbuddy",           {NULL}, 1288, "udp"},
{"jwalkserver",        {NULL}, 1289, "tcp"},
{"jwalkserver",        {NULL}, 1289, "udp"},
{"winjaserver",        {NULL}, 1290, "tcp"},
{"winjaserver",        {NULL}, 1290, "udp"},
{"seagulllms",         {NULL}, 1291, "tcp"},
{"seagulllms",         {NULL}, 1291, "udp"},
{"dsdn",               {NULL}, 1292, "tcp"},
{"dsdn",               {NULL}, 1292, "udp"},
{"pkt-krb-ipsec",      {NULL}, 1293, "tcp"},
{"pkt-krb-ipsec",      {NULL}, 1293, "udp"},
{"cmmdriver",          {NULL}, 1294, "tcp"},
{"cmmdriver",          {NULL}, 1294, "udp"},
{"ehtp",               {NULL}, 1295, "tcp"},
{"ehtp",               {NULL}, 1295, "udp"},
{"dproxy",             {NULL}, 1296, "tcp"},
{"dproxy",             {NULL}, 1296, "udp"},
{"sdproxy",            {NULL}, 1297, "tcp"},
{"sdproxy",            {NULL}, 1297, "udp"},
{"lpcp",               {NULL}, 1298, "tcp"},
{"lpcp",               {NULL}, 1298, "udp"},
{"hp-sci",             {NULL}, 1299, "tcp"},
{"hp-sci",             {NULL}, 1299, "udp"},
{"h323hostcallsc",     {NULL}, 1300, "tcp"},
{"h323hostcallsc",     {NULL}, 1300, "udp"},
{"ci3-software-1",     {NULL}, 1301, "tcp"},
{"ci3-software-1",     {NULL}, 1301, "udp"},
{"ci3-software-2",     {NULL}, 1302, "tcp"},
{"ci3-software-2",     {NULL}, 1302, "udp"},
{"sftsrv",             {NULL}, 1303, "tcp"},
{"sftsrv",             {NULL}, 1303, "udp"},
{"boomerang",          {NULL}, 1304, "tcp"},
{"boomerang",          {NULL}, 1304, "udp"},
{"pe-mike",            {NULL}, 1305, "tcp"},
{"pe-mike",            {NULL}, 1305, "udp"},
{"re-conn-proto",      {NULL}, 1306, "tcp"},
{"re-conn-proto",      {NULL}, 1306, "udp"},
{"pacmand",            {NULL}, 1307, "tcp"},
{"pacmand",            {NULL}, 1307, "udp"},
{"odsi",               {NULL}, 1308, "tcp"},
{"odsi",               {NULL}, 1308, "udp"},
{"jtag-server",        {NULL}, 1309, "tcp"},
{"jtag-server",        {NULL}, 1309, "udp"},
{"husky",              {NULL}, 1310, "tcp"},
{"husky",              {NULL}, 1310, "udp"},
{"rxmon",              {NULL}, 1311, "tcp"},
{"rxmon",              {NULL}, 1311, "udp"},
{"sti-envision",       {NULL}, 1312, "tcp"},
{"sti-envision",       {NULL}, 1312, "udp"},
{"bmc_patroldb",       {NULL}, 1313, "tcp"},
{"bmc_patroldb",       {NULL}, 1313, "udp"},
{"pdps",               {NULL}, 1314, "tcp"},
{"pdps",               {NULL}, 1314, "udp"},
{"els",                {NULL}, 1315, "tcp"},
{"els",                {NULL}, 1315, "udp"},
{"exbit-escp",         {NULL}, 1316, "tcp"},
{"exbit-escp",         {NULL}, 1316, "udp"},
{"vrts-ipcserver",     {NULL}, 1317, "tcp"},
{"vrts-ipcserver",     {NULL}, 1317, "udp"},
{"krb5gatekeeper",     {NULL}, 1318, "tcp"},
{"krb5gatekeeper",     {NULL}, 1318, "udp"},
{"amx-icsp",           {NULL}, 1319, "tcp"},
{"amx-icsp",           {NULL}, 1319, "udp"},
{"amx-axbnet",         {NULL}, 1320, "tcp"},
{"amx-axbnet",         {NULL}, 1320, "udp"},
{"pip",                {NULL}, 1321, "tcp"},
{"pip",                {NULL}, 1321, "udp"},
{"novation",           {NULL}, 1322, "tcp"},
{"novation",           {NULL}, 1322, "udp"},
{"brcd",               {NULL}, 1323, "tcp"},
{"brcd",               {NULL}, 1323, "udp"},
{"delta-mcp",          {NULL}, 1324, "tcp"},
{"delta-mcp",          {NULL}, 1324, "udp"},
{"dx-instrument",      {NULL}, 1325, "tcp"},
{"dx-instrument",      {NULL}, 1325, "udp"},
{"wimsic",             {NULL}, 1326, "tcp"},
{"wimsic",             {NULL}, 1326, "udp"},
{"ultrex",             {NULL}, 1327, "tcp"},
{"ultrex",             {NULL}, 1327, "udp"},
{"ewall",              {NULL}, 1328, "tcp"},
{"ewall",              {NULL}, 1328, "udp"},
{"netdb-export",       {NULL}, 1329, "tcp"},
{"netdb-export",       {NULL}, 1329, "udp"},
{"streetperfect",      {NULL}, 1330, "tcp"},
{"streetperfect",      {NULL}, 1330, "udp"},
{"intersan",           {NULL}, 1331, "tcp"},
{"intersan",           {NULL}, 1331, "udp"},
{"pcia-rxp-b",         {NULL}, 1332, "tcp"},
{"pcia-rxp-b",         {NULL}, 1332, "udp"},
{"passwrd-policy",     {NULL}, 1333, "tcp"},
{"passwrd-policy",     {NULL}, 1333, "udp"},
{"writesrv",           {NULL}, 1334, "tcp"},
{"writesrv",           {NULL}, 1334, "udp"},
{"digital-notary",     {NULL}, 1335, "tcp"},
{"digital-notary",     {NULL}, 1335, "udp"},
{"ischat",             {NULL}, 1336, "tcp"},
{"ischat",             {NULL}, 1336, "udp"},
{"menandmice-dns",     {NULL}, 1337, "tcp"},
{"menandmice-dns",     {NULL}, 1337, "udp"},
{"wmc-log-svc",        {NULL}, 1338, "tcp"},
{"wmc-log-svc",        {NULL}, 1338, "udp"},
{"kjtsiteserver",      {NULL}, 1339, "tcp"},
{"kjtsiteserver",      {NULL}, 1339, "udp"},
{"naap",               {NULL}, 1340, "tcp"},
{"naap",               {NULL}, 1340, "udp"},
{"qubes",              {NULL}, 1341, "tcp"},
{"qubes",              {NULL}, 1341, "udp"},
{"esbroker",           {NULL}, 1342, "tcp"},
{"esbroker",           {NULL}, 1342, "udp"},
{"re101",              {NULL}, 1343, "tcp"},
{"re101",              {NULL}, 1343, "udp"},
{"icap",               {NULL}, 1344, "tcp"},
{"icap",               {NULL}, 1344, "udp"},
{"vpjp",               {NULL}, 1345, "tcp"},
{"vpjp",               {NULL}, 1345, "udp"},
{"alta-ana-lm",        {NULL}, 1346, "tcp"},
{"alta-ana-lm",        {NULL}, 1346, "udp"},
{"bbn-mmc",            {NULL}, 1347, "tcp"},
{"bbn-mmc",            {NULL}, 1347, "udp"},
{"bbn-mmx",            {NULL}, 1348, "tcp"},
{"bbn-mmx",            {NULL}, 1348, "udp"},
{"sbook",              {NULL}, 1349, "tcp"},
{"sbook",              {NULL}, 1349, "udp"},
{"editbench",          {NULL}, 1350, "tcp"},
{"editbench",          {NULL}, 1350, "udp"},
{"equationbuilder",    {NULL}, 1351, "tcp"},
{"equationbuilder",    {NULL}, 1351, "udp"},
{"lotusnote",          {NULL}, 1352, "tcp"},
{"lotusnote",          {NULL}, 1352, "udp"},
{"relief",             {NULL}, 1353, "tcp"},
{"relief",             {NULL}, 1353, "udp"},
{"XSIP-network",       {NULL}, 1354, "tcp"},
{"XSIP-network",       {NULL}, 1354, "udp"},
{"intuitive-edge",     {NULL}, 1355, "tcp"},
{"intuitive-edge",     {NULL}, 1355, "udp"},
{"cuillamartin",       {NULL}, 1356, "tcp"},
{"cuillamartin",       {NULL}, 1356, "udp"},
{"pegboard",           {NULL}, 1357, "tcp"},
{"pegboard",           {NULL}, 1357, "udp"},
{"connlcli",           {NULL}, 1358, "tcp"},
{"connlcli",           {NULL}, 1358, "udp"},
{"ftsrv",              {NULL}, 1359, "tcp"},
{"ftsrv",              {NULL}, 1359, "udp"},
{"mimer",              {NULL}, 1360, "tcp"},
{"mimer",              {NULL}, 1360, "udp"},
{"linx",               {NULL}, 1361, "tcp"},
{"linx",               {NULL}, 1361, "udp"},
{"timeflies",          {NULL}, 1362, "tcp"},
{"timeflies",          {NULL}, 1362, "udp"},
{"ndm-requester",      {NULL}, 1363, "tcp"},
{"ndm-requester",      {NULL}, 1363, "udp"},
{"ndm-server",         {NULL}, 1364, "tcp"},
{"ndm-server",         {NULL}, 1364, "udp"},
{"adapt-sna",          {NULL}, 1365, "tcp"},
{"adapt-sna",          {NULL}, 1365, "udp"},
{"netware-csp",        {NULL}, 1366, "tcp"},
{"netware-csp",        {NULL}, 1366, "udp"},
{"dcs",                {NULL}, 1367, "tcp"},
{"dcs",                {NULL}, 1367, "udp"},
{"screencast",         {NULL}, 1368, "tcp"},
{"screencast",         {NULL}, 1368, "udp"},
{"gv-us",              {NULL}, 1369, "tcp"},
{"gv-us",              {NULL}, 1369, "udp"},
{"us-gv",              {NULL}, 1370, "tcp"},
{"us-gv",              {NULL}, 1370, "udp"},
{"fc-cli",             {NULL}, 1371, "tcp"},
{"fc-cli",             {NULL}, 1371, "udp"},
{"fc-ser",             {NULL}, 1372, "tcp"},
{"fc-ser",             {NULL}, 1372, "udp"},
{"chromagrafx",        {NULL}, 1373, "tcp"},
{"chromagrafx",        {NULL}, 1373, "udp"},
{"molly",              {NULL}, 1374, "tcp"},
{"molly",              {NULL}, 1374, "udp"},
{"bytex",              {NULL}, 1375, "tcp"},
{"bytex",              {NULL}, 1375, "udp"},
{"ibm-pps",            {NULL}, 1376, "tcp"},
{"ibm-pps",            {NULL}, 1376, "udp"},
{"cichlid",            {NULL}, 1377, "tcp"},
{"cichlid",            {NULL}, 1377, "udp"},
{"elan",               {NULL}, 1378, "tcp"},
{"elan",               {NULL}, 1378, "udp"},
{"dbreporter",         {NULL}, 1379, "tcp"},
{"dbreporter",         {NULL}, 1379, "udp"},
{"telesis-licman",     {NULL}, 1380, "tcp"},
{"telesis-licman",     {NULL}, 1380, "udp"},
{"apple-licman",       {NULL}, 1381, "tcp"},
{"apple-licman",       {NULL}, 1381, "udp"},
{"udt_os",             {NULL}, 1382, "tcp"},
{"udt_os",             {NULL}, 1382, "udp"},
{"gwha",               {NULL}, 1383, "tcp"},
{"gwha",               {NULL}, 1383, "udp"},
{"os-licman",          {NULL}, 1384, "tcp"},
{"os-licman",          {NULL}, 1384, "udp"},
{"atex_elmd",          {NULL}, 1385, "tcp"},
{"atex_elmd",          {NULL}, 1385, "udp"},
{"checksum",           {NULL}, 1386, "tcp"},
{"checksum",           {NULL}, 1386, "udp"},
{"cadsi-lm",           {NULL}, 1387, "tcp"},
{"cadsi-lm",           {NULL}, 1387, "udp"},
{"objective-dbc",      {NULL}, 1388, "tcp"},
{"objective-dbc",      {NULL}, 1388, "udp"},
{"iclpv-dm",           {NULL}, 1389, "tcp"},
{"iclpv-dm",           {NULL}, 1389, "udp"},
{"iclpv-sc",           {NULL}, 1390, "tcp"},
{"iclpv-sc",           {NULL}, 1390, "udp"},
{"iclpv-sas",          {NULL}, 1391, "tcp"},
{"iclpv-sas",          {NULL}, 1391, "udp"},
{"iclpv-pm",           {NULL}, 1392, "tcp"},
{"iclpv-pm",           {NULL}, 1392, "udp"},
{"iclpv-nls",          {NULL}, 1393, "tcp"},
{"iclpv-nls",          {NULL}, 1393, "udp"},
{"iclpv-nlc",          {NULL}, 1394, "tcp"},
{"iclpv-nlc",          {NULL}, 1394, "udp"},
{"iclpv-wsm",          {NULL}, 1395, "tcp"},
{"iclpv-wsm",          {NULL}, 1395, "udp"},
{"dvl-activemail",     {NULL}, 1396, "tcp"},
{"dvl-activemail",     {NULL}, 1396, "udp"},
{"audio-activmail",    {NULL}, 1397, "tcp"},
{"audio-activmail",    {NULL}, 1397, "udp"},
{"video-activmail",    {NULL}, 1398, "tcp"},
{"video-activmail",    {NULL}, 1398, "udp"},
{"cadkey-licman",      {NULL}, 1399, "tcp"},
{"cadkey-licman",      {NULL}, 1399, "udp"},
{"cadkey-tablet",      {NULL}, 1400, "tcp"},
{"cadkey-tablet",      {NULL}, 1400, "udp"},
{"goldleaf-licman",    {NULL}, 1401, "tcp"},
{"goldleaf-licman",    {NULL}, 1401, "udp"},
{"prm-sm-np",          {NULL}, 1402, "tcp"},
{"prm-sm-np",          {NULL}, 1402, "udp"},
{"prm-nm-np",          {NULL}, 1403, "tcp"},
{"prm-nm-np",          {NULL}, 1403, "udp"},
{"igi-lm",             {NULL}, 1404, "tcp"},
{"igi-lm",             {NULL}, 1404, "udp"},
{"ibm-res",            {NULL}, 1405, "tcp"},
{"ibm-res",            {NULL}, 1405, "udp"},
{"netlabs-lm",         {NULL}, 1406, "tcp"},
{"netlabs-lm",         {NULL}, 1406, "udp"},
{"dbsa-lm",            {NULL}, 1407, "tcp"},
{"dbsa-lm",            {NULL}, 1407, "udp"},
{"sophia-lm",          {NULL}, 1408, "tcp"},
{"sophia-lm",          {NULL}, 1408, "udp"},
{"here-lm",            {NULL}, 1409, "tcp"},
{"here-lm",            {NULL}, 1409, "udp"},
{"hiq",                {NULL}, 1410, "tcp"},
{"hiq",                {NULL}, 1410, "udp"},
{"af",                 {NULL}, 1411, "tcp"},
{"af",                 {NULL}, 1411, "udp"},
{"innosys",            {NULL}, 1412, "tcp"},
{"innosys",            {NULL}, 1412, "udp"},
{"innosys-acl",        {NULL}, 1413, "tcp"},
{"innosys-acl",        {NULL}, 1413, "udp"},
{"ibm-mqseries",       {NULL}, 1414, "tcp"},
{"ibm-mqseries",       {NULL}, 1414, "udp"},
{"dbstar",             {NULL}, 1415, "tcp"},
{"dbstar",             {NULL}, 1415, "udp"},
{"novell-lu6.2",       {NULL}, 1416, "tcp"},
{"novell-lu6.2",       {NULL}, 1416, "udp"},
{"timbuktu-srv1",      {NULL}, 1417, "tcp"},
{"timbuktu-srv1",      {NULL}, 1417, "udp"},
{"timbuktu-srv2",      {NULL}, 1418, "tcp"},
{"timbuktu-srv2",      {NULL}, 1418, "udp"},
{"timbuktu-srv3",      {NULL}, 1419, "tcp"},
{"timbuktu-srv3",      {NULL}, 1419, "udp"},
{"timbuktu-srv4",      {NULL}, 1420, "tcp"},
{"timbuktu-srv4",      {NULL}, 1420, "udp"},
{"gandalf-lm",         {NULL}, 1421, "tcp"},
{"gandalf-lm",         {NULL}, 1421, "udp"},
{"autodesk-lm",        {NULL}, 1422, "tcp"},
{"autodesk-lm",        {NULL}, 1422, "udp"},
{"essbase",            {NULL}, 1423, "tcp"},
{"essbase",            {NULL}, 1423, "udp"},
{"hybrid",             {NULL}, 1424, "tcp"},
{"hybrid",             {NULL}, 1424, "udp"},
{"zion-lm",            {NULL}, 1425, "tcp"},
{"zion-lm",            {NULL}, 1425, "udp"},
{"sais",               {NULL}, 1426, "tcp"},
{"sais",               {NULL}, 1426, "udp"},
{"mloadd",             {NULL}, 1427, "tcp"},
{"mloadd",             {NULL}, 1427, "udp"},
{"informatik-lm",      {NULL}, 1428, "tcp"},
{"informatik-lm",      {NULL}, 1428, "udp"},
{"nms",                {NULL}, 1429, "tcp"},
{"nms",                {NULL}, 1429, "udp"},
{"tpdu",               {NULL}, 1430, "tcp"},
{"tpdu",               {NULL}, 1430, "udp"},
{"rgtp",               {NULL}, 1431, "tcp"},
{"rgtp",               {NULL}, 1431, "udp"},
{"blueberry-lm",       {NULL}, 1432, "tcp"},
{"blueberry-lm",       {NULL}, 1432, "udp"},
{"ms-sql-s",           {NULL}, 1433, "tcp"},
{"ms-sql-s",           {NULL}, 1433, "udp"},
{"ms-sql-m",           {NULL}, 1434, "tcp"},
{"ms-sql-m",           {NULL}, 1434, "udp"},
{"ibm-cics",           {NULL}, 1435, "tcp"},
{"ibm-cics",           {NULL}, 1435, "udp"},
{"saism",              {NULL}, 1436, "tcp"},
{"saism",              {NULL}, 1436, "udp"},
{"tabula",             {NULL}, 1437, "tcp"},
{"tabula",             {NULL}, 1437, "udp"},
{"eicon-server",       {NULL}, 1438, "tcp"},
{"eicon-server",       {NULL}, 1438, "udp"},
{"eicon-x25",          {NULL}, 1439, "tcp"},
{"eicon-x25",          {NULL}, 1439, "udp"},
{"eicon-slp",          {NULL}, 1440, "tcp"},
{"eicon-slp",          {NULL}, 1440, "udp"},
{"cadis-1",            {NULL}, 1441, "tcp"},
{"cadis-1",            {NULL}, 1441, "udp"},
{"cadis-2",            {NULL}, 1442, "tcp"},
{"cadis-2",            {NULL}, 1442, "udp"},
{"ies-lm",             {NULL}, 1443, "tcp"},
{"ies-lm",             {NULL}, 1443, "udp"},
{"marcam-lm",          {NULL}, 1444, "tcp"},
{"marcam-lm",          {NULL}, 1444, "udp"},
{"proxima-lm",         {NULL}, 1445, "tcp"},
{"proxima-lm",         {NULL}, 1445, "udp"},
{"ora-lm",             {NULL}, 1446, "tcp"},
{"ora-lm",             {NULL}, 1446, "udp"},
{"apri-lm",            {NULL}, 1447, "tcp"},
{"apri-lm",            {NULL}, 1447, "udp"},
{"oc-lm",              {NULL}, 1448, "tcp"},
{"oc-lm",              {NULL}, 1448, "udp"},
{"peport",             {NULL}, 1449, "tcp"},
{"peport",             {NULL}, 1449, "udp"},
{"dwf",                {NULL}, 1450, "tcp"},
{"dwf",                {NULL}, 1450, "udp"},
{"infoman",            {NULL}, 1451, "tcp"},
{"infoman",            {NULL}, 1451, "udp"},
{"gtegsc-lm",          {NULL}, 1452, "tcp"},
{"gtegsc-lm",          {NULL}, 1452, "udp"},
{"genie-lm",           {NULL}, 1453, "tcp"},
{"genie-lm",           {NULL}, 1453, "udp"},
{"interhdl_elmd",      {NULL}, 1454, "tcp"},
{"interhdl_elmd",      {NULL}, 1454, "udp"},
{"esl-lm",             {NULL}, 1455, "tcp"},
{"esl-lm",             {NULL}, 1455, "udp"},
{"dca",                {NULL}, 1456, "tcp"},
{"dca",                {NULL}, 1456, "udp"},
{"valisys-lm",         {NULL}, 1457, "tcp"},
{"valisys-lm",         {NULL}, 1457, "udp"},
{"nrcabq-lm",          {NULL}, 1458, "tcp"},
{"nrcabq-lm",          {NULL}, 1458, "udp"},
{"proshare1",          {NULL}, 1459, "tcp"},
{"proshare1",          {NULL}, 1459, "udp"},
{"proshare2",          {NULL}, 1460, "tcp"},
{"proshare2",          {NULL}, 1460, "udp"},
{"ibm_wrless_lan",     {NULL}, 1461, "tcp"},
{"ibm_wrless_lan",     {NULL}, 1461, "udp"},
{"world-lm",           {NULL}, 1462, "tcp"},
{"world-lm",           {NULL}, 1462, "udp"},
{"nucleus",            {NULL}, 1463, "tcp"},
{"nucleus",            {NULL}, 1463, "udp"},
{"msl_lmd",            {NULL}, 1464, "tcp"},
{"msl_lmd",            {NULL}, 1464, "udp"},
{"pipes",              {NULL}, 1465, "tcp"},
{"pipes",              {NULL}, 1465, "udp"},
{"oceansoft-lm",       {NULL}, 1466, "tcp"},
{"oceansoft-lm",       {NULL}, 1466, "udp"},
{"csdmbase",           {NULL}, 1467, "tcp"},
{"csdmbase",           {NULL}, 1467, "udp"},
{"csdm",               {NULL}, 1468, "tcp"},
{"csdm",               {NULL}, 1468, "udp"},
{"aal-lm",             {NULL}, 1469, "tcp"},
{"aal-lm",             {NULL}, 1469, "udp"},
{"uaiact",             {NULL}, 1470, "tcp"},
{"uaiact",             {NULL}, 1470, "udp"},
{"csdmbase",           {NULL}, 1471, "tcp"},
{"csdmbase",           {NULL}, 1471, "udp"},
{"csdm",               {NULL}, 1472, "tcp"},
{"csdm",               {NULL}, 1472, "udp"},
{"openmath",           {NULL}, 1473, "tcp"},
{"openmath",           {NULL}, 1473, "udp"},
{"telefinder",         {NULL}, 1474, "tcp"},
{"telefinder",         {NULL}, 1474, "udp"},
{"taligent-lm",        {NULL}, 1475, "tcp"},
{"taligent-lm",        {NULL}, 1475, "udp"},
{"clvm-cfg",           {NULL}, 1476, "tcp"},
{"clvm-cfg",           {NULL}, 1476, "udp"},
{"ms-sna-server",      {NULL}, 1477, "tcp"},
{"ms-sna-server",      {NULL}, 1477, "udp"},
{"ms-sna-base",        {NULL}, 1478, "tcp"},
{"ms-sna-base",        {NULL}, 1478, "udp"},
{"dberegister",        {NULL}, 1479, "tcp"},
{"dberegister",        {NULL}, 1479, "udp"},
{"pacerforum",         {NULL}, 1480, "tcp"},
{"pacerforum",         {NULL}, 1480, "udp"},
{"airs",               {NULL}, 1481, "tcp"},
{"airs",               {NULL}, 1481, "udp"},
{"miteksys-lm",        {NULL}, 1482, "tcp"},
{"miteksys-lm",        {NULL}, 1482, "udp"},
{"afs",                {NULL}, 1483, "tcp"},
{"afs",                {NULL}, 1483, "udp"},
{"confluent",          {NULL}, 1484, "tcp"},
{"confluent",          {NULL}, 1484, "udp"},
{"lansource",          {NULL}, 1485, "tcp"},
{"lansource",          {NULL}, 1485, "udp"},
{"nms_topo_serv",      {NULL}, 1486, "tcp"},
{"nms_topo_serv",      {NULL}, 1486, "udp"},
{"localinfosrvr",      {NULL}, 1487, "tcp"},
{"localinfosrvr",      {NULL}, 1487, "udp"},
{"docstor",            {NULL}, 1488, "tcp"},
{"docstor",            {NULL}, 1488, "udp"},
{"dmdocbroker",        {NULL}, 1489, "tcp"},
{"dmdocbroker",        {NULL}, 1489, "udp"},
{"insitu-conf",        {NULL}, 1490, "tcp"},
{"insitu-conf",        {NULL}, 1490, "udp"},
{"stone-design-1",     {NULL}, 1492, "tcp"},
{"stone-design-1",     {NULL}, 1492, "udp"},
{"netmap_lm",          {NULL}, 1493, "tcp"},
{"netmap_lm",          {NULL}, 1493, "udp"},
{"ica",                {NULL}, 1494, "tcp"},
{"ica",                {NULL}, 1494, "udp"},
{"cvc",                {NULL}, 1495, "tcp"},
{"cvc",                {NULL}, 1495, "udp"},
{"liberty-lm",         {NULL}, 1496, "tcp"},
{"liberty-lm",         {NULL}, 1496, "udp"},
{"rfx-lm",             {NULL}, 1497, "tcp"},
{"rfx-lm",             {NULL}, 1497, "udp"},
{"sybase-sqlany",      {NULL}, 1498, "tcp"},
{"sybase-sqlany",      {NULL}, 1498, "udp"},
{"fhc",                {NULL}, 1499, "tcp"},
{"fhc",                {NULL}, 1499, "udp"},
{"vlsi-lm",            {NULL}, 1500, "tcp"},
{"vlsi-lm",            {NULL}, 1500, "udp"},
{"saiscm",             {NULL}, 1501, "tcp"},
{"saiscm",             {NULL}, 1501, "udp"},
{"shivadiscovery",     {NULL}, 1502, "tcp"},
{"shivadiscovery",     {NULL}, 1502, "udp"},
{"imtc-mcs",           {NULL}, 1503, "tcp"},
{"imtc-mcs",           {NULL}, 1503, "udp"},
{"evb-elm",            {NULL}, 1504, "tcp"},
{"evb-elm",            {NULL}, 1504, "udp"},
{"funkproxy",          {NULL}, 1505, "tcp"},
{"funkproxy",          {NULL}, 1505, "udp"},
{"utcd",               {NULL}, 1506, "tcp"},
{"utcd",               {NULL}, 1506, "udp"},
{"symplex",            {NULL}, 1507, "tcp"},
{"symplex",            {NULL}, 1507, "udp"},
{"diagmond",           {NULL}, 1508, "tcp"},
{"diagmond",           {NULL}, 1508, "udp"},
{"robcad-lm",          {NULL}, 1509, "tcp"},
{"robcad-lm",          {NULL}, 1509, "udp"},
{"mvx-lm",             {NULL}, 1510, "tcp"},
{"mvx-lm",             {NULL}, 1510, "udp"},
{"3l-l1",              {NULL}, 1511, "tcp"},
{"3l-l1",              {NULL}, 1511, "udp"},
{"wins",               {NULL}, 1512, "tcp"},
{"wins",               {NULL}, 1512, "udp"},
{"fujitsu-dtc",        {NULL}, 1513, "tcp"},
{"fujitsu-dtc",        {NULL}, 1513, "udp"},
{"fujitsu-dtcns",      {NULL}, 1514, "tcp"},
{"fujitsu-dtcns",      {NULL}, 1514, "udp"},
{"ifor-protocol",      {NULL}, 1515, "tcp"},
{"ifor-protocol",      {NULL}, 1515, "udp"},
{"vpad",               {NULL}, 1516, "tcp"},
{"vpad",               {NULL}, 1516, "udp"},
{"vpac",               {NULL}, 1517, "tcp"},
{"vpac",               {NULL}, 1517, "udp"},
{"vpvd",               {NULL}, 1518, "tcp"},
{"vpvd",               {NULL}, 1518, "udp"},
{"vpvc",               {NULL}, 1519, "tcp"},
{"vpvc",               {NULL}, 1519, "udp"},
{"atm-zip-office",     {NULL}, 1520, "tcp"},
{"atm-zip-office",     {NULL}, 1520, "udp"},
{"ncube-lm",           {NULL}, 1521, "tcp"},
{"ncube-lm",           {NULL}, 1521, "udp"},
{"ricardo-lm",         {NULL}, 1522, "tcp"},
{"ricardo-lm",         {NULL}, 1522, "udp"},
{"cichild-lm",         {NULL}, 1523, "tcp"},
{"cichild-lm",         {NULL}, 1523, "udp"},
{"ingreslock",         {NULL}, 1524, "tcp"},
{"ingreslock",         {NULL}, 1524, "udp"},
{"orasrv",             {NULL}, 1525, "tcp"},
{"orasrv",             {NULL}, 1525, "udp"},
{"prospero-np",        {NULL}, 1525, "tcp"},
{"prospero-np",        {NULL}, 1525, "udp"},
{"pdap-np",            {NULL}, 1526, "tcp"},
{"pdap-np",            {NULL}, 1526, "udp"},
{"tlisrv",             {NULL}, 1527, "tcp"},
{"tlisrv",             {NULL}, 1527, "udp"},
{"coauthor",           {NULL}, 1529, "tcp"},
{"coauthor",           {NULL}, 1529, "udp"},
{"rap-service",        {NULL}, 1530, "tcp"},
{"rap-service",        {NULL}, 1530, "udp"},
{"rap-listen",         {NULL}, 1531, "tcp"},
{"rap-listen",         {NULL}, 1531, "udp"},
{"miroconnect",        {NULL}, 1532, "tcp"},
{"miroconnect",        {NULL}, 1532, "udp"},
{"virtual-places",     {NULL}, 1533, "tcp"},
{"virtual-places",     {NULL}, 1533, "udp"},
{"micromuse-lm",       {NULL}, 1534, "tcp"},
{"micromuse-lm",       {NULL}, 1534, "udp"},
{"ampr-info",          {NULL}, 1535, "tcp"},
{"ampr-info",          {NULL}, 1535, "udp"},
{"ampr-inter",         {NULL}, 1536, "tcp"},
{"ampr-inter",         {NULL}, 1536, "udp"},
{"sdsc-lm",            {NULL}, 1537, "tcp"},
{"sdsc-lm",            {NULL}, 1537, "udp"},
{"3ds-lm",             {NULL}, 1538, "tcp"},
{"3ds-lm",             {NULL}, 1538, "udp"},
{"intellistor-lm",     {NULL}, 1539, "tcp"},
{"intellistor-lm",     {NULL}, 1539, "udp"},
{"rds",                {NULL}, 1540, "tcp"},
{"rds",                {NULL}, 1540, "udp"},
{"rds2",               {NULL}, 1541, "tcp"},
{"rds2",               {NULL}, 1541, "udp"},
{"gridgen-elmd",       {NULL}, 1542, "tcp"},
{"gridgen-elmd",       {NULL}, 1542, "udp"},
{"simba-cs",           {NULL}, 1543, "tcp"},
{"simba-cs",           {NULL}, 1543, "udp"},
{"aspeclmd",           {NULL}, 1544, "tcp"},
{"aspeclmd",           {NULL}, 1544, "udp"},
{"vistium-share",      {NULL}, 1545, "tcp"},
{"vistium-share",      {NULL}, 1545, "udp"},
{"abbaccuray",         {NULL}, 1546, "tcp"},
{"abbaccuray",         {NULL}, 1546, "udp"},
{"laplink",            {NULL}, 1547, "tcp"},
{"laplink",            {NULL}, 1547, "udp"},
{"axon-lm",            {NULL}, 1548, "tcp"},
{"axon-lm",            {NULL}, 1548, "udp"},
{"shivahose",          {NULL}, 1549, "tcp"},
{"shivasound",         {NULL}, 1549, "udp"},
{"3m-image-lm",        {NULL}, 1550, "tcp"},
{"3m-image-lm",        {NULL}, 1550, "udp"},
{"hecmtl-db",          {NULL}, 1551, "tcp"},
{"hecmtl-db",          {NULL}, 1551, "udp"},
{"pciarray",           {NULL}, 1552, "tcp"},
{"pciarray",           {NULL}, 1552, "udp"},
{"sna-cs",             {NULL}, 1553, "tcp"},
{"sna-cs",             {NULL}, 1553, "udp"},
{"caci-lm",            {NULL}, 1554, "tcp"},
{"caci-lm",            {NULL}, 1554, "udp"},
{"livelan",            {NULL}, 1555, "tcp"},
{"livelan",            {NULL}, 1555, "udp"},
{"veritas_pbx",        {NULL}, 1556, "tcp"},
{"veritas_pbx",        {NULL}, 1556, "udp"},
{"arbortext-lm",       {NULL}, 1557, "tcp"},
{"arbortext-lm",       {NULL}, 1557, "udp"},
{"xingmpeg",           {NULL}, 1558, "tcp"},
{"xingmpeg",           {NULL}, 1558, "udp"},
{"web2host",           {NULL}, 1559, "tcp"},
{"web2host",           {NULL}, 1559, "udp"},
{"asci-val",           {NULL}, 1560, "tcp"},
{"asci-val",           {NULL}, 1560, "udp"},
{"facilityview",       {NULL}, 1561, "tcp"},
{"facilityview",       {NULL}, 1561, "udp"},
{"pconnectmgr",        {NULL}, 1562, "tcp"},
{"pconnectmgr",        {NULL}, 1562, "udp"},
{"cadabra-lm",         {NULL}, 1563, "tcp"},
{"cadabra-lm",         {NULL}, 1563, "udp"},
{"pay-per-view",       {NULL}, 1564, "tcp"},
{"pay-per-view",       {NULL}, 1564, "udp"},
{"winddlb",            {NULL}, 1565, "tcp"},
{"winddlb",            {NULL}, 1565, "udp"},
{"corelvideo",         {NULL}, 1566, "tcp"},
{"corelvideo",         {NULL}, 1566, "udp"},
{"jlicelmd",           {NULL}, 1567, "tcp"},
{"jlicelmd",           {NULL}, 1567, "udp"},
{"tsspmap",            {NULL}, 1568, "tcp"},
{"tsspmap",            {NULL}, 1568, "udp"},
{"ets",                {NULL}, 1569, "tcp"},
{"ets",                {NULL}, 1569, "udp"},
{"orbixd",             {NULL}, 1570, "tcp"},
{"orbixd",             {NULL}, 1570, "udp"},
{"rdb-dbs-disp",       {NULL}, 1571, "tcp"},
{"rdb-dbs-disp",       {NULL}, 1571, "udp"},
{"chip-lm",            {NULL}, 1572, "tcp"},
{"chip-lm",            {NULL}, 1572, "udp"},
{"itscomm-ns",         {NULL}, 1573, "tcp"},
{"itscomm-ns",         {NULL}, 1573, "udp"},
{"mvel-lm",            {NULL}, 1574, "tcp"},
{"mvel-lm",            {NULL}, 1574, "udp"},
{"oraclenames",        {NULL}, 1575, "tcp"},
{"oraclenames",        {NULL}, 1575, "udp"},
{"moldflow-lm",        {NULL}, 1576, "tcp"},
{"moldflow-lm",        {NULL}, 1576, "udp"},
{"hypercube-lm",       {NULL}, 1577, "tcp"},
{"hypercube-lm",       {NULL}, 1577, "udp"},
{"jacobus-lm",         {NULL}, 1578, "tcp"},
{"jacobus-lm",         {NULL}, 1578, "udp"},
{"ioc-sea-lm",         {NULL}, 1579, "tcp"},
{"ioc-sea-lm",         {NULL}, 1579, "udp"},
{"tn-tl-r1",           {NULL}, 1580, "tcp"},
{"tn-tl-r2",           {NULL}, 1580, "udp"},
{"mil-2045-47001",     {NULL}, 1581, "tcp"},
{"mil-2045-47001",     {NULL}, 1581, "udp"},
{"msims",              {NULL}, 1582, "tcp"},
{"msims",              {NULL}, 1582, "udp"},
{"simbaexpress",       {NULL}, 1583, "tcp"},
{"simbaexpress",       {NULL}, 1583, "udp"},
{"tn-tl-fd2",          {NULL}, 1584, "tcp"},
{"tn-tl-fd2",          {NULL}, 1584, "udp"},
{"intv",               {NULL}, 1585, "tcp"},
{"intv",               {NULL}, 1585, "udp"},
{"ibm-abtact",         {NULL}, 1586, "tcp"},
{"ibm-abtact",         {NULL}, 1586, "udp"},
{"pra_elmd",           {NULL}, 1587, "tcp"},
{"pra_elmd",           {NULL}, 1587, "udp"},
{"triquest-lm",        {NULL}, 1588, "tcp"},
{"triquest-lm",        {NULL}, 1588, "udp"},
{"vqp",                {NULL}, 1589, "tcp"},
{"vqp",                {NULL}, 1589, "udp"},
{"gemini-lm",          {NULL}, 1590, "tcp"},
{"gemini-lm",          {NULL}, 1590, "udp"},
{"ncpm-pm",            {NULL}, 1591, "tcp"},
{"ncpm-pm",            {NULL}, 1591, "udp"},
{"commonspace",        {NULL}, 1592, "tcp"},
{"commonspace",        {NULL}, 1592, "udp"},
{"mainsoft-lm",        {NULL}, 1593, "tcp"},
{"mainsoft-lm",        {NULL}, 1593, "udp"},
{"sixtrak",            {NULL}, 1594, "tcp"},
{"sixtrak",            {NULL}, 1594, "udp"},
{"radio",              {NULL}, 1595, "tcp"},
{"radio",              {NULL}, 1595, "udp"},
{"radio-sm",           {NULL}, 1596, "tcp"},
{"radio-bc",           {NULL}, 1596, "udp"},
{"orbplus-iiop",       {NULL}, 1597, "tcp"},
{"orbplus-iiop",       {NULL}, 1597, "udp"},
{"picknfs",            {NULL}, 1598, "tcp"},
{"picknfs",            {NULL}, 1598, "udp"},
{"simbaservices",      {NULL}, 1599, "tcp"},
{"simbaservices",      {NULL}, 1599, "udp"},
{"issd",               {NULL}, 1600, "tcp"},
{"issd",               {NULL}, 1600, "udp"},
{"aas",                {NULL}, 1601, "tcp"},
{"aas",                {NULL}, 1601, "udp"},
{"inspect",            {NULL}, 1602, "tcp"},
{"inspect",            {NULL}, 1602, "udp"},
{"picodbc",            {NULL}, 1603, "tcp"},
{"picodbc",            {NULL}, 1603, "udp"},
{"icabrowser",         {NULL}, 1604, "tcp"},
{"icabrowser",         {NULL}, 1604, "udp"},
{"slp",                {NULL}, 1605, "tcp"},
{"slp",                {NULL}, 1605, "udp"},
{"slm-api",            {NULL}, 1606, "tcp"},
{"slm-api",            {NULL}, 1606, "udp"},
{"stt",                {NULL}, 1607, "tcp"},
{"stt",                {NULL}, 1607, "udp"},
{"smart-lm",           {NULL}, 1608, "tcp"},
{"smart-lm",           {NULL}, 1608, "udp"},
{"isysg-lm",           {NULL}, 1609, "tcp"},
{"isysg-lm",           {NULL}, 1609, "udp"},
{"taurus-wh",          {NULL}, 1610, "tcp"},
{"taurus-wh",          {NULL}, 1610, "udp"},
{"ill",                {NULL}, 1611, "tcp"},
{"ill",                {NULL}, 1611, "udp"},
{"netbill-trans",      {NULL}, 1612, "tcp"},
{"netbill-trans",      {NULL}, 1612, "udp"},
{"netbill-keyrep",     {NULL}, 1613, "tcp"},
{"netbill-keyrep",     {NULL}, 1613, "udp"},
{"netbill-cred",       {NULL}, 1614, "tcp"},
{"netbill-cred",       {NULL}, 1614, "udp"},
{"netbill-auth",       {NULL}, 1615, "tcp"},
{"netbill-auth",       {NULL}, 1615, "udp"},
{"netbill-prod",       {NULL}, 1616, "tcp"},
{"netbill-prod",       {NULL}, 1616, "udp"},
{"nimrod-agent",       {NULL}, 1617, "tcp"},
{"nimrod-agent",       {NULL}, 1617, "udp"},
{"skytelnet",          {NULL}, 1618, "tcp"},
{"skytelnet",          {NULL}, 1618, "udp"},
{"xs-openstorage",     {NULL}, 1619, "tcp"},
{"xs-openstorage",     {NULL}, 1619, "udp"},
{"faxportwinport",     {NULL}, 1620, "tcp"},
{"faxportwinport",     {NULL}, 1620, "udp"},
{"softdataphone",      {NULL}, 1621, "tcp"},
{"softdataphone",      {NULL}, 1621, "udp"},
{"ontime",             {NULL}, 1622, "tcp"},
{"ontime",             {NULL}, 1622, "udp"},
{"jaleosnd",           {NULL}, 1623, "tcp"},
{"jaleosnd",           {NULL}, 1623, "udp"},
{"udp-sr-port",        {NULL}, 1624, "tcp"},
{"udp-sr-port",        {NULL}, 1624, "udp"},
{"svs-omagent",        {NULL}, 1625, "tcp"},
{"svs-omagent",        {NULL}, 1625, "udp"},
{"shockwave",          {NULL}, 1626, "tcp"},
{"shockwave",          {NULL}, 1626, "udp"},
{"t128-gateway",       {NULL}, 1627, "tcp"},
{"t128-gateway",       {NULL}, 1627, "udp"},
{"lontalk-norm",       {NULL}, 1628, "tcp"},
{"lontalk-norm",       {NULL}, 1628, "udp"},
{"lontalk-urgnt",      {NULL}, 1629, "tcp"},
{"lontalk-urgnt",      {NULL}, 1629, "udp"},
{"oraclenet8cman",     {NULL}, 1630, "tcp"},
{"oraclenet8cman",     {NULL}, 1630, "udp"},
{"visitview",          {NULL}, 1631, "tcp"},
{"visitview",          {NULL}, 1631, "udp"},
{"pammratc",           {NULL}, 1632, "tcp"},
{"pammratc",           {NULL}, 1632, "udp"},
{"pammrpc",            {NULL}, 1633, "tcp"},
{"pammrpc",            {NULL}, 1633, "udp"},
{"loaprobe",           {NULL}, 1634, "tcp"},
{"loaprobe",           {NULL}, 1634, "udp"},
{"edb-server1",        {NULL}, 1635, "tcp"},
{"edb-server1",        {NULL}, 1635, "udp"},
{"isdc",               {NULL}, 1636, "tcp"},
{"isdc",               {NULL}, 1636, "udp"},
{"islc",               {NULL}, 1637, "tcp"},
{"islc",               {NULL}, 1637, "udp"},
{"ismc",               {NULL}, 1638, "tcp"},
{"ismc",               {NULL}, 1638, "udp"},
{"cert-initiator",     {NULL}, 1639, "tcp"},
{"cert-initiator",     {NULL}, 1639, "udp"},
{"cert-responder",     {NULL}, 1640, "tcp"},
{"cert-responder",     {NULL}, 1640, "udp"},
{"invision",           {NULL}, 1641, "tcp"},
{"invision",           {NULL}, 1641, "udp"},
{"isis-am",            {NULL}, 1642, "tcp"},
{"isis-am",            {NULL}, 1642, "udp"},
{"isis-ambc",          {NULL}, 1643, "tcp"},
{"isis-ambc",          {NULL}, 1643, "udp"},
{"saiseh",             {NULL}, 1644, "tcp"},
{"sightline",          {NULL}, 1645, "tcp"},
{"sightline",          {NULL}, 1645, "udp"},
{"sa-msg-port",        {NULL}, 1646, "tcp"},
{"sa-msg-port",        {NULL}, 1646, "udp"},
{"rsap",               {NULL}, 1647, "tcp"},
{"rsap",               {NULL}, 1647, "udp"},
{"concurrent-lm",      {NULL}, 1648, "tcp"},
{"concurrent-lm",      {NULL}, 1648, "udp"},
{"kermit",             {NULL}, 1649, "tcp"},
{"kermit",             {NULL}, 1649, "udp"},
{"nkd",                {NULL}, 1650, "tcp"},
{"nkd",                {NULL}, 1650, "udp"},
{"shiva_confsrvr",     {NULL}, 1651, "tcp"},
{"shiva_confsrvr",     {NULL}, 1651, "udp"},
{"xnmp",               {NULL}, 1652, "tcp"},
{"xnmp",               {NULL}, 1652, "udp"},
{"alphatech-lm",       {NULL}, 1653, "tcp"},
{"alphatech-lm",       {NULL}, 1653, "udp"},
{"stargatealerts",     {NULL}, 1654, "tcp"},
{"stargatealerts",     {NULL}, 1654, "udp"},
{"dec-mbadmin",        {NULL}, 1655, "tcp"},
{"dec-mbadmin",        {NULL}, 1655, "udp"},
{"dec-mbadmin-h",      {NULL}, 1656, "tcp"},
{"dec-mbadmin-h",      {NULL}, 1656, "udp"},
{"fujitsu-mmpdc",      {NULL}, 1657, "tcp"},
{"fujitsu-mmpdc",      {NULL}, 1657, "udp"},
{"sixnetudr",          {NULL}, 1658, "tcp"},
{"sixnetudr",          {NULL}, 1658, "udp"},
{"sg-lm",              {NULL}, 1659, "tcp"},
{"sg-lm",              {NULL}, 1659, "udp"},
{"skip-mc-gikreq",     {NULL}, 1660, "tcp"},
{"skip-mc-gikreq",     {NULL}, 1660, "udp"},
{"netview-aix-1",      {NULL}, 1661, "tcp"},
{"netview-aix-1",      {NULL}, 1661, "udp"},
{"netview-aix-2",      {NULL}, 1662, "tcp"},
{"netview-aix-2",      {NULL}, 1662, "udp"},
{"netview-aix-3",      {NULL}, 1663, "tcp"},
{"netview-aix-3",      {NULL}, 1663, "udp"},
{"netview-aix-4",      {NULL}, 1664, "tcp"},
{"netview-aix-4",      {NULL}, 1664, "udp"},
{"netview-aix-5",      {NULL}, 1665, "tcp"},
{"netview-aix-5",      {NULL}, 1665, "udp"},
{"netview-aix-6",      {NULL}, 1666, "tcp"},
{"netview-aix-6",      {NULL}, 1666, "udp"},
{"netview-aix-7",      {NULL}, 1667, "tcp"},
{"netview-aix-7",      {NULL}, 1667, "udp"},
{"netview-aix-8",      {NULL}, 1668, "tcp"},
{"netview-aix-8",      {NULL}, 1668, "udp"},
{"netview-aix-9",      {NULL}, 1669, "tcp"},
{"netview-aix-9",      {NULL}, 1669, "udp"},
{"netview-aix-10",     {NULL}, 1670, "tcp"},
{"netview-aix-10",     {NULL}, 1670, "udp"},
{"netview-aix-11",     {NULL}, 1671, "tcp"},
{"netview-aix-11",     {NULL}, 1671, "udp"},
{"netview-aix-12",     {NULL}, 1672, "tcp"},
{"netview-aix-12",     {NULL}, 1672, "udp"},
{"proshare-mc-1",      {NULL}, 1673, "tcp"},
{"proshare-mc-1",      {NULL}, 1673, "udp"},
{"proshare-mc-2",      {NULL}, 1674, "tcp"},
{"proshare-mc-2",      {NULL}, 1674, "udp"},
{"pdp",                {NULL}, 1675, "tcp"},
{"pdp",                {NULL}, 1675, "udp"},
{"netcomm1",           {NULL}, 1676, "tcp"},
{"netcomm2",           {NULL}, 1676, "udp"},
{"groupwise",          {NULL}, 1677, "tcp"},
{"groupwise",          {NULL}, 1677, "udp"},
{"prolink",            {NULL}, 1678, "tcp"},
{"prolink",            {NULL}, 1678, "udp"},
{"darcorp-lm",         {NULL}, 1679, "tcp"},
{"darcorp-lm",         {NULL}, 1679, "udp"},
{"microcom-sbp",       {NULL}, 1680, "tcp"},
{"microcom-sbp",       {NULL}, 1680, "udp"},
{"sd-elmd",            {NULL}, 1681, "tcp"},
{"sd-elmd",            {NULL}, 1681, "udp"},
{"lanyon-lantern",     {NULL}, 1682, "tcp"},
{"lanyon-lantern",     {NULL}, 1682, "udp"},
{"ncpm-hip",           {NULL}, 1683, "tcp"},
{"ncpm-hip",           {NULL}, 1683, "udp"},
{"snaresecure",        {NULL}, 1684, "tcp"},
{"snaresecure",        {NULL}, 1684, "udp"},
{"n2nremote",          {NULL}, 1685, "tcp"},
{"n2nremote",          {NULL}, 1685, "udp"},
{"cvmon",              {NULL}, 1686, "tcp"},
{"cvmon",              {NULL}, 1686, "udp"},
{"nsjtp-ctrl",         {NULL}, 1687, "tcp"},
{"nsjtp-ctrl",         {NULL}, 1687, "udp"},
{"nsjtp-data",         {NULL}, 1688, "tcp"},
{"nsjtp-data",         {NULL}, 1688, "udp"},
{"firefox",            {NULL}, 1689, "tcp"},
{"firefox",            {NULL}, 1689, "udp"},
{"ng-umds",            {NULL}, 1690, "tcp"},
{"ng-umds",            {NULL}, 1690, "udp"},
{"empire-empuma",      {NULL}, 1691, "tcp"},
{"empire-empuma",      {NULL}, 1691, "udp"},
{"sstsys-lm",          {NULL}, 1692, "tcp"},
{"sstsys-lm",          {NULL}, 1692, "udp"},
{"rrirtr",             {NULL}, 1693, "tcp"},
{"rrirtr",             {NULL}, 1693, "udp"},
{"rrimwm",             {NULL}, 1694, "tcp"},
{"rrimwm",             {NULL}, 1694, "udp"},
{"rrilwm",             {NULL}, 1695, "tcp"},
{"rrilwm",             {NULL}, 1695, "udp"},
{"rrifmm",             {NULL}, 1696, "tcp"},
{"rrifmm",             {NULL}, 1696, "udp"},
{"rrisat",             {NULL}, 1697, "tcp"},
{"rrisat",             {NULL}, 1697, "udp"},
{"rsvp-encap-1",       {NULL}, 1698, "tcp"},
{"rsvp-encap-1",       {NULL}, 1698, "udp"},
{"rsvp-encap-2",       {NULL}, 1699, "tcp"},
{"rsvp-encap-2",       {NULL}, 1699, "udp"},
{"mps-raft",           {NULL}, 1700, "tcp"},
{"mps-raft",           {NULL}, 1700, "udp"},
{"l2f",                {NULL}, 1701, "tcp"},
{"l2f",                {NULL}, 1701, "udp"},
{"l2tp",               {NULL}, 1701, "tcp"},
{"l2tp",               {NULL}, 1701, "udp"},
{"deskshare",          {NULL}, 1702, "tcp"},
{"deskshare",          {NULL}, 1702, "udp"},
{"hb-engine",          {NULL}, 1703, "tcp"},
{"hb-engine",          {NULL}, 1703, "udp"},
{"bcs-broker",         {NULL}, 1704, "tcp"},
{"bcs-broker",         {NULL}, 1704, "udp"},
{"slingshot",          {NULL}, 1705, "tcp"},
{"slingshot",          {NULL}, 1705, "udp"},
{"jetform",            {NULL}, 1706, "tcp"},
{"jetform",            {NULL}, 1706, "udp"},
{"vdmplay",            {NULL}, 1707, "tcp"},
{"vdmplay",            {NULL}, 1707, "udp"},
{"gat-lmd",            {NULL}, 1708, "tcp"},
{"gat-lmd",            {NULL}, 1708, "udp"},
{"centra",             {NULL}, 1709, "tcp"},
{"centra",             {NULL}, 1709, "udp"},
{"impera",             {NULL}, 1710, "tcp"},
{"impera",             {NULL}, 1710, "udp"},
{"pptconference",      {NULL}, 1711, "tcp"},
{"pptconference",      {NULL}, 1711, "udp"},
{"registrar",          {NULL}, 1712, "tcp"},
{"registrar",          {NULL}, 1712, "udp"},
{"conferencetalk",     {NULL}, 1713, "tcp"},
{"conferencetalk",     {NULL}, 1713, "udp"},
{"sesi-lm",            {NULL}, 1714, "tcp"},
{"sesi-lm",            {NULL}, 1714, "udp"},
{"houdini-lm",         {NULL}, 1715, "tcp"},
{"houdini-lm",         {NULL}, 1715, "udp"},
{"xmsg",               {NULL}, 1716, "tcp"},
{"xmsg",               {NULL}, 1716, "udp"},
{"fj-hdnet",           {NULL}, 1717, "tcp"},
{"fj-hdnet",           {NULL}, 1717, "udp"},
{"h323gatedisc",       {NULL}, 1718, "tcp"},
{"h323gatedisc",       {NULL}, 1718, "udp"},
{"h323gatestat",       {NULL}, 1719, "tcp"},
{"h323gatestat",       {NULL}, 1719, "udp"},
{"h323hostcall",       {NULL}, 1720, "tcp"},
{"h323hostcall",       {NULL}, 1720, "udp"},
{"caicci",             {NULL}, 1721, "tcp"},
{"caicci",             {NULL}, 1721, "udp"},
{"hks-lm",             {NULL}, 1722, "tcp"},
{"hks-lm",             {NULL}, 1722, "udp"},
{"pptp",               {NULL}, 1723, "tcp"},
{"pptp",               {NULL}, 1723, "udp"},
{"csbphonemaster",     {NULL}, 1724, "tcp"},
{"csbphonemaster",     {NULL}, 1724, "udp"},
{"iden-ralp",          {NULL}, 1725, "tcp"},
{"iden-ralp",          {NULL}, 1725, "udp"},
{"iberiagames",        {NULL}, 1726, "tcp"},
{"iberiagames",        {NULL}, 1726, "udp"},
{"winddx",             {NULL}, 1727, "tcp"},
{"winddx",             {NULL}, 1727, "udp"},
{"telindus",           {NULL}, 1728, "tcp"},
{"telindus",           {NULL}, 1728, "udp"},
{"citynl",             {NULL}, 1729, "tcp"},
{"citynl",             {NULL}, 1729, "udp"},
{"roketz",             {NULL}, 1730, "tcp"},
{"roketz",             {NULL}, 1730, "udp"},
{"msiccp",             {NULL}, 1731, "tcp"},
{"msiccp",             {NULL}, 1731, "udp"},
{"proxim",             {NULL}, 1732, "tcp"},
{"proxim",             {NULL}, 1732, "udp"},
{"siipat",             {NULL}, 1733, "tcp"},
{"siipat",             {NULL}, 1733, "udp"},
{"cambertx-lm",        {NULL}, 1734, "tcp"},
{"cambertx-lm",        {NULL}, 1734, "udp"},
{"privatechat",        {NULL}, 1735, "tcp"},
{"privatechat",        {NULL}, 1735, "udp"},
{"street-stream",      {NULL}, 1736, "tcp"},
{"street-stream",      {NULL}, 1736, "udp"},
{"ultimad",            {NULL}, 1737, "tcp"},
{"ultimad",            {NULL}, 1737, "udp"},
{"gamegen1",           {NULL}, 1738, "tcp"},
{"gamegen1",           {NULL}, 1738, "udp"},
{"webaccess",          {NULL}, 1739, "tcp"},
{"webaccess",          {NULL}, 1739, "udp"},
{"encore",             {NULL}, 1740, "tcp"},
{"encore",             {NULL}, 1740, "udp"},
{"cisco-net-mgmt",     {NULL}, 1741, "tcp"},
{"cisco-net-mgmt",     {NULL}, 1741, "udp"},
{"3Com-nsd",           {NULL}, 1742, "tcp"},
{"3Com-nsd",           {NULL}, 1742, "udp"},
{"cinegrfx-lm",        {NULL}, 1743, "tcp"},
{"cinegrfx-lm",        {NULL}, 1743, "udp"},
{"ncpm-ft",            {NULL}, 1744, "tcp"},
{"ncpm-ft",            {NULL}, 1744, "udp"},
{"remote-winsock",     {NULL}, 1745, "tcp"},
{"remote-winsock",     {NULL}, 1745, "udp"},
{"ftrapid-1",          {NULL}, 1746, "tcp"},
{"ftrapid-1",          {NULL}, 1746, "udp"},
{"ftrapid-2",          {NULL}, 1747, "tcp"},
{"ftrapid-2",          {NULL}, 1747, "udp"},
{"oracle-em1",         {NULL}, 1748, "tcp"},
{"oracle-em1",         {NULL}, 1748, "udp"},
{"aspen-services",     {NULL}, 1749, "tcp"},
{"aspen-services",     {NULL}, 1749, "udp"},
{"sslp",               {NULL}, 1750, "tcp"},
{"sslp",               {NULL}, 1750, "udp"},
{"swiftnet",           {NULL}, 1751, "tcp"},
{"swiftnet",           {NULL}, 1751, "udp"},
{"lofr-lm",            {NULL}, 1752, "tcp"},
{"lofr-lm",            {NULL}, 1752, "udp"},
{"oracle-em2",         {NULL}, 1754, "tcp"},
{"oracle-em2",         {NULL}, 1754, "udp"},
{"ms-streaming",       {NULL}, 1755, "tcp"},
{"ms-streaming",       {NULL}, 1755, "udp"},
{"capfast-lmd",        {NULL}, 1756, "tcp"},
{"capfast-lmd",        {NULL}, 1756, "udp"},
{"cnhrp",              {NULL}, 1757, "tcp"},
{"cnhrp",              {NULL}, 1757, "udp"},
{"tftp-mcast",         {NULL}, 1758, "tcp"},
{"tftp-mcast",         {NULL}, 1758, "udp"},
{"spss-lm",            {NULL}, 1759, "tcp"},
{"spss-lm",            {NULL}, 1759, "udp"},
{"www-ldap-gw",        {NULL}, 1760, "tcp"},
{"www-ldap-gw",        {NULL}, 1760, "udp"},
{"cft-0",              {NULL}, 1761, "tcp"},
{"cft-0",              {NULL}, 1761, "udp"},
{"cft-1",              {NULL}, 1762, "tcp"},
{"cft-1",              {NULL}, 1762, "udp"},
{"cft-2",              {NULL}, 1763, "tcp"},
{"cft-2",              {NULL}, 1763, "udp"},
{"cft-3",              {NULL}, 1764, "tcp"},
{"cft-3",              {NULL}, 1764, "udp"},
{"cft-4",              {NULL}, 1765, "tcp"},
{"cft-4",              {NULL}, 1765, "udp"},
{"cft-5",              {NULL}, 1766, "tcp"},
{"cft-5",              {NULL}, 1766, "udp"},
{"cft-6",              {NULL}, 1767, "tcp"},
{"cft-6",              {NULL}, 1767, "udp"},
{"cft-7",              {NULL}, 1768, "tcp"},
{"cft-7",              {NULL}, 1768, "udp"},
{"bmc-net-adm",        {NULL}, 1769, "tcp"},
{"bmc-net-adm",        {NULL}, 1769, "udp"},
{"bmc-net-svc",        {NULL}, 1770, "tcp"},
{"bmc-net-svc",        {NULL}, 1770, "udp"},
{"vaultbase",          {NULL}, 1771, "tcp"},
{"vaultbase",          {NULL}, 1771, "udp"},
{"essweb-gw",          {NULL}, 1772, "tcp"},
{"essweb-gw",          {NULL}, 1772, "udp"},
{"kmscontrol",         {NULL}, 1773, "tcp"},
{"kmscontrol",         {NULL}, 1773, "udp"},
{"global-dtserv",      {NULL}, 1774, "tcp"},
{"global-dtserv",      {NULL}, 1774, "udp"},
{"femis",              {NULL}, 1776, "tcp"},
{"femis",              {NULL}, 1776, "udp"},
{"powerguardian",      {NULL}, 1777, "tcp"},
{"powerguardian",      {NULL}, 1777, "udp"},
{"prodigy-intrnet",    {NULL}, 1778, "tcp"},
{"prodigy-intrnet",    {NULL}, 1778, "udp"},
{"pharmasoft",         {NULL}, 1779, "tcp"},
{"pharmasoft",         {NULL}, 1779, "udp"},
{"dpkeyserv",          {NULL}, 1780, "tcp"},
{"dpkeyserv",          {NULL}, 1780, "udp"},
{"answersoft-lm",      {NULL}, 1781, "tcp"},
{"answersoft-lm",      {NULL}, 1781, "udp"},
{"hp-hcip",            {NULL}, 1782, "tcp"},
{"hp-hcip",            {NULL}, 1782, "udp"},
{"finle-lm",           {NULL}, 1784, "tcp"},
{"finle-lm",           {NULL}, 1784, "udp"},
{"windlm",             {NULL}, 1785, "tcp"},
{"windlm",             {NULL}, 1785, "udp"},
{"funk-logger",        {NULL}, 1786, "tcp"},
{"funk-logger",        {NULL}, 1786, "udp"},
{"funk-license",       {NULL}, 1787, "tcp"},
{"funk-license",       {NULL}, 1787, "udp"},
{"psmond",             {NULL}, 1788, "tcp"},
{"psmond",             {NULL}, 1788, "udp"},
{"hello",              {NULL}, 1789, "tcp"},
{"hello",              {NULL}, 1789, "udp"},
{"nmsp",               {NULL}, 1790, "tcp"},
{"nmsp",               {NULL}, 1790, "udp"},
{"ea1",                {NULL}, 1791, "tcp"},
{"ea1",                {NULL}, 1791, "udp"},
{"ibm-dt-2",           {NULL}, 1792, "tcp"},
{"ibm-dt-2",           {NULL}, 1792, "udp"},
{"rsc-robot",          {NULL}, 1793, "tcp"},
{"rsc-robot",          {NULL}, 1793, "udp"},
{"cera-bcm",           {NULL}, 1794, "tcp"},
{"cera-bcm",           {NULL}, 1794, "udp"},
{"dpi-proxy",          {NULL}, 1795, "tcp"},
{"dpi-proxy",          {NULL}, 1795, "udp"},
{"vocaltec-admin",     {NULL}, 1796, "tcp"},
{"vocaltec-admin",     {NULL}, 1796, "udp"},
{"uma",                {NULL}, 1797, "tcp"},
{"uma",                {NULL}, 1797, "udp"},
{"etp",                {NULL}, 1798, "tcp"},
{"etp",                {NULL}, 1798, "udp"},
{"netrisk",            {NULL}, 1799, "tcp"},
{"netrisk",            {NULL}, 1799, "udp"},
{"ansys-lm",           {NULL}, 1800, "tcp"},
{"ansys-lm",           {NULL}, 1800, "udp"},
{"msmq",               {NULL}, 1801, "tcp"},
{"msmq",               {NULL}, 1801, "udp"},
{"concomp1",           {NULL}, 1802, "tcp"},
{"concomp1",           {NULL}, 1802, "udp"},
{"hp-hcip-gwy",        {NULL}, 1803, "tcp"},
{"hp-hcip-gwy",        {NULL}, 1803, "udp"},
{"enl",                {NULL}, 1804, "tcp"},
{"enl",                {NULL}, 1804, "udp"},
{"enl-name",           {NULL}, 1805, "tcp"},
{"enl-name",           {NULL}, 1805, "udp"},
{"musiconline",        {NULL}, 1806, "tcp"},
{"musiconline",        {NULL}, 1806, "udp"},
{"fhsp",               {NULL}, 1807, "tcp"},
{"fhsp",               {NULL}, 1807, "udp"},
{"oracle-vp2",         {NULL}, 1808, "tcp"},
{"oracle-vp2",         {NULL}, 1808, "udp"},
{"oracle-vp1",         {NULL}, 1809, "tcp"},
{"oracle-vp1",         {NULL}, 1809, "udp"},
{"jerand-lm",          {NULL}, 1810, "tcp"},
{"jerand-lm",          {NULL}, 1810, "udp"},
{"scientia-sdb",       {NULL}, 1811, "tcp"},
{"scientia-sdb",       {NULL}, 1811, "udp"},
{"radius",             {NULL}, 1812, "tcp"},
{"radius",             {NULL}, 1812, "udp"},
{"radius-acct",        {NULL}, 1813, "tcp"},
{"radius-acct",        {NULL}, 1813, "udp"},
{"tdp-suite",          {NULL}, 1814, "tcp"},
{"tdp-suite",          {NULL}, 1814, "udp"},
{"mmpft",              {NULL}, 1815, "tcp"},
{"mmpft",              {NULL}, 1815, "udp"},
{"harp",               {NULL}, 1816, "tcp"},
{"harp",               {NULL}, 1816, "udp"},
{"rkb-oscs",           {NULL}, 1817, "tcp"},
{"rkb-oscs",           {NULL}, 1817, "udp"},
{"etftp",              {NULL}, 1818, "tcp"},
{"etftp",              {NULL}, 1818, "udp"},
{"plato-lm",           {NULL}, 1819, "tcp"},
{"plato-lm",           {NULL}, 1819, "udp"},
{"mcagent",            {NULL}, 1820, "tcp"},
{"mcagent",            {NULL}, 1820, "udp"},
{"donnyworld",         {NULL}, 1821, "tcp"},
{"donnyworld",         {NULL}, 1821, "udp"},
{"es-elmd",            {NULL}, 1822, "tcp"},
{"es-elmd",            {NULL}, 1822, "udp"},
{"unisys-lm",          {NULL}, 1823, "tcp"},
{"unisys-lm",          {NULL}, 1823, "udp"},
{"metrics-pas",        {NULL}, 1824, "tcp"},
{"metrics-pas",        {NULL}, 1824, "udp"},
{"direcpc-video",      {NULL}, 1825, "tcp"},
{"direcpc-video",      {NULL}, 1825, "udp"},
{"ardt",               {NULL}, 1826, "tcp"},
{"ardt",               {NULL}, 1826, "udp"},
{"asi",                {NULL}, 1827, "tcp"},
{"asi",                {NULL}, 1827, "udp"},
{"itm-mcell-u",        {NULL}, 1828, "tcp"},
{"itm-mcell-u",        {NULL}, 1828, "udp"},
{"optika-emedia",      {NULL}, 1829, "tcp"},
{"optika-emedia",      {NULL}, 1829, "udp"},
{"net8-cman",          {NULL}, 1830, "tcp"},
{"net8-cman",          {NULL}, 1830, "udp"},
{"myrtle",             {NULL}, 1831, "tcp"},
{"myrtle",             {NULL}, 1831, "udp"},
{"tht-treasure",       {NULL}, 1832, "tcp"},
{"tht-treasure",       {NULL}, 1832, "udp"},
{"udpradio",           {NULL}, 1833, "tcp"},
{"udpradio",           {NULL}, 1833, "udp"},
{"ardusuni",           {NULL}, 1834, "tcp"},
{"ardusuni",           {NULL}, 1834, "udp"},
{"ardusmul",           {NULL}, 1835, "tcp"},
{"ardusmul",           {NULL}, 1835, "udp"},
{"ste-smsc",           {NULL}, 1836, "tcp"},
{"ste-smsc",           {NULL}, 1836, "udp"},
{"csoft1",             {NULL}, 1837, "tcp"},
{"csoft1",             {NULL}, 1837, "udp"},
{"talnet",             {NULL}, 1838, "tcp"},
{"talnet",             {NULL}, 1838, "udp"},
{"netopia-vo1",        {NULL}, 1839, "tcp"},
{"netopia-vo1",        {NULL}, 1839, "udp"},
{"netopia-vo2",        {NULL}, 1840, "tcp"},
{"netopia-vo2",        {NULL}, 1840, "udp"},
{"netopia-vo3",        {NULL}, 1841, "tcp"},
{"netopia-vo3",        {NULL}, 1841, "udp"},
{"netopia-vo4",        {NULL}, 1842, "tcp"},
{"netopia-vo4",        {NULL}, 1842, "udp"},
{"netopia-vo5",        {NULL}, 1843, "tcp"},
{"netopia-vo5",        {NULL}, 1843, "udp"},
{"direcpc-dll",        {NULL}, 1844, "tcp"},
{"direcpc-dll",        {NULL}, 1844, "udp"},
{"altalink",           {NULL}, 1845, "tcp"},
{"altalink",           {NULL}, 1845, "udp"},
{"tunstall-pnc",       {NULL}, 1846, "tcp"},
{"tunstall-pnc",       {NULL}, 1846, "udp"},
{"slp-notify",         {NULL}, 1847, "tcp"},
{"slp-notify",         {NULL}, 1847, "udp"},
{"fjdocdist",          {NULL}, 1848, "tcp"},
{"fjdocdist",          {NULL}, 1848, "udp"},
{"alpha-sms",          {NULL}, 1849, "tcp"},
{"alpha-sms",          {NULL}, 1849, "udp"},
{"gsi",                {NULL}, 1850, "tcp"},
{"gsi",                {NULL}, 1850, "udp"},
{"ctcd",               {NULL}, 1851, "tcp"},
{"ctcd",               {NULL}, 1851, "udp"},
{"virtual-time",       {NULL}, 1852, "tcp"},
{"virtual-time",       {NULL}, 1852, "udp"},
{"vids-avtp",          {NULL}, 1853, "tcp"},
{"vids-avtp",          {NULL}, 1853, "udp"},
{"buddy-draw",         {NULL}, 1854, "tcp"},
{"buddy-draw",         {NULL}, 1854, "udp"},
{"fiorano-rtrsvc",     {NULL}, 1855, "tcp"},
{"fiorano-rtrsvc",     {NULL}, 1855, "udp"},
{"fiorano-msgsvc",     {NULL}, 1856, "tcp"},
{"fiorano-msgsvc",     {NULL}, 1856, "udp"},
{"datacaptor",         {NULL}, 1857, "tcp"},
{"datacaptor",         {NULL}, 1857, "udp"},
{"privateark",         {NULL}, 1858, "tcp"},
{"privateark",         {NULL}, 1858, "udp"},
{"gammafetchsvr",      {NULL}, 1859, "tcp"},
{"gammafetchsvr",      {NULL}, 1859, "udp"},
{"sunscalar-svc",      {NULL}, 1860, "tcp"},
{"sunscalar-svc",      {NULL}, 1860, "udp"},
{"lecroy-vicp",        {NULL}, 1861, "tcp"},
{"lecroy-vicp",        {NULL}, 1861, "udp"},
{"mysql-cm-agent",     {NULL}, 1862, "tcp"},
{"mysql-cm-agent",     {NULL}, 1862, "udp"},
{"msnp",               {NULL}, 1863, "tcp"},
{"msnp",               {NULL}, 1863, "udp"},
{"paradym-31port",     {NULL}, 1864, "tcp"},
{"paradym-31port",     {NULL}, 1864, "udp"},
{"entp",               {NULL}, 1865, "tcp"},
{"entp",               {NULL}, 1865, "udp"},
{"swrmi",              {NULL}, 1866, "tcp"},
{"swrmi",              {NULL}, 1866, "udp"},
{"udrive",             {NULL}, 1867, "tcp"},
{"udrive",             {NULL}, 1867, "udp"},
{"viziblebrowser",     {NULL}, 1868, "tcp"},
{"viziblebrowser",     {NULL}, 1868, "udp"},
{"transact",           {NULL}, 1869, "tcp"},
{"transact",           {NULL}, 1869, "udp"},
{"sunscalar-dns",      {NULL}, 1870, "tcp"},
{"sunscalar-dns",      {NULL}, 1870, "udp"},
{"canocentral0",       {NULL}, 1871, "tcp"},
{"canocentral0",       {NULL}, 1871, "udp"},
{"canocentral1",       {NULL}, 1872, "tcp"},
{"canocentral1",       {NULL}, 1872, "udp"},
{"fjmpjps",            {NULL}, 1873, "tcp"},
{"fjmpjps",            {NULL}, 1873, "udp"},
{"fjswapsnp",          {NULL}, 1874, "tcp"},
{"fjswapsnp",          {NULL}, 1874, "udp"},
{"westell-stats",      {NULL}, 1875, "tcp"},
{"westell-stats",      {NULL}, 1875, "udp"},
{"ewcappsrv",          {NULL}, 1876, "tcp"},
{"ewcappsrv",          {NULL}, 1876, "udp"},
{"hp-webqosdb",        {NULL}, 1877, "tcp"},
{"hp-webqosdb",        {NULL}, 1877, "udp"},
{"drmsmc",             {NULL}, 1878, "tcp"},
{"drmsmc",             {NULL}, 1878, "udp"},
{"nettgain-nms",       {NULL}, 1879, "tcp"},
{"nettgain-nms",       {NULL}, 1879, "udp"},
{"vsat-control",       {NULL}, 1880, "tcp"},
{"vsat-control",       {NULL}, 1880, "udp"},
{"ibm-mqseries2",      {NULL}, 1881, "tcp"},
{"ibm-mqseries2",      {NULL}, 1881, "udp"},
{"ecsqdmn",            {NULL}, 1882, "tcp"},
{"ecsqdmn",            {NULL}, 1882, "udp"},
{"ibm-mqisdp",         {NULL}, 1883, "tcp"},
{"ibm-mqisdp",         {NULL}, 1883, "udp"},
{"idmaps",             {NULL}, 1884, "tcp"},
{"idmaps",             {NULL}, 1884, "udp"},
{"vrtstrapserver",     {NULL}, 1885, "tcp"},
{"vrtstrapserver",     {NULL}, 1885, "udp"},
{"leoip",              {NULL}, 1886, "tcp"},
{"leoip",              {NULL}, 1886, "udp"},
{"filex-lport",        {NULL}, 1887, "tcp"},
{"filex-lport",        {NULL}, 1887, "udp"},
{"ncconfig",           {NULL}, 1888, "tcp"},
{"ncconfig",           {NULL}, 1888, "udp"},
{"unify-adapter",      {NULL}, 1889, "tcp"},
{"unify-adapter",      {NULL}, 1889, "udp"},
{"wilkenlistener",     {NULL}, 1890, "tcp"},
{"wilkenlistener",     {NULL}, 1890, "udp"},
{"childkey-notif",     {NULL}, 1891, "tcp"},
{"childkey-notif",     {NULL}, 1891, "udp"},
{"childkey-ctrl",      {NULL}, 1892, "tcp"},
{"childkey-ctrl",      {NULL}, 1892, "udp"},
{"elad",               {NULL}, 1893, "tcp"},
{"elad",               {NULL}, 1893, "udp"},
{"o2server-port",      {NULL}, 1894, "tcp"},
{"o2server-port",      {NULL}, 1894, "udp"},
{"b-novative-ls",      {NULL}, 1896, "tcp"},
{"b-novative-ls",      {NULL}, 1896, "udp"},
{"metaagent",          {NULL}, 1897, "tcp"},
{"metaagent",          {NULL}, 1897, "udp"},
{"cymtec-port",        {NULL}, 1898, "tcp"},
{"cymtec-port",        {NULL}, 1898, "udp"},
{"mc2studios",         {NULL}, 1899, "tcp"},
{"mc2studios",         {NULL}, 1899, "udp"},
{"ssdp",               {NULL}, 1900, "tcp"},
{"ssdp",               {NULL}, 1900, "udp"},
{"fjicl-tep-a",        {NULL}, 1901, "tcp"},
{"fjicl-tep-a",        {NULL}, 1901, "udp"},
{"fjicl-tep-b",        {NULL}, 1902, "tcp"},
{"fjicl-tep-b",        {NULL}, 1902, "udp"},
{"linkname",           {NULL}, 1903, "tcp"},
{"linkname",           {NULL}, 1903, "udp"},
{"fjicl-tep-c",        {NULL}, 1904, "tcp"},
{"fjicl-tep-c",        {NULL}, 1904, "udp"},
{"sugp",               {NULL}, 1905, "tcp"},
{"sugp",               {NULL}, 1905, "udp"},
{"tpmd",               {NULL}, 1906, "tcp"},
{"tpmd",               {NULL}, 1906, "udp"},
{"intrastar",          {NULL}, 1907, "tcp"},
{"intrastar",          {NULL}, 1907, "udp"},
{"dawn",               {NULL}, 1908, "tcp"},
{"dawn",               {NULL}, 1908, "udp"},
{"global-wlink",       {NULL}, 1909, "tcp"},
{"global-wlink",       {NULL}, 1909, "udp"},
{"ultrabac",           {NULL}, 1910, "tcp"},
{"ultrabac",           {NULL}, 1910, "udp"},
{"mtp",                {NULL}, 1911, "tcp"},
{"mtp",                {NULL}, 1911, "udp"},
{"rhp-iibp",           {NULL}, 1912, "tcp"},
{"rhp-iibp",           {NULL}, 1912, "udp"},
{"armadp",             {NULL}, 1913, "tcp"},
{"armadp",             {NULL}, 1913, "udp"},
{"elm-momentum",       {NULL}, 1914, "tcp"},
{"elm-momentum",       {NULL}, 1914, "udp"},
{"facelink",           {NULL}, 1915, "tcp"},
{"facelink",           {NULL}, 1915, "udp"},
{"persona",            {NULL}, 1916, "tcp"},
{"persona",            {NULL}, 1916, "udp"},
{"noagent",            {NULL}, 1917, "tcp"},
{"noagent",            {NULL}, 1917, "udp"},
{"can-nds",            {NULL}, 1918, "tcp"},
{"can-nds",            {NULL}, 1918, "udp"},
{"can-dch",            {NULL}, 1919, "tcp"},
{"can-dch",            {NULL}, 1919, "udp"},
{"can-ferret",         {NULL}, 1920, "tcp"},
{"can-ferret",         {NULL}, 1920, "udp"},
{"noadmin",            {NULL}, 1921, "tcp"},
{"noadmin",            {NULL}, 1921, "udp"},
{"tapestry",           {NULL}, 1922, "tcp"},
{"tapestry",           {NULL}, 1922, "udp"},
{"spice",              {NULL}, 1923, "tcp"},
{"spice",              {NULL}, 1923, "udp"},
{"xiip",               {NULL}, 1924, "tcp"},
{"xiip",               {NULL}, 1924, "udp"},
{"discovery-port",     {NULL}, 1925, "tcp"},
{"discovery-port",     {NULL}, 1925, "udp"},
{"egs",                {NULL}, 1926, "tcp"},
{"egs",                {NULL}, 1926, "udp"},
{"videte-cipc",        {NULL}, 1927, "tcp"},
{"videte-cipc",        {NULL}, 1927, "udp"},
{"emsd-port",          {NULL}, 1928, "tcp"},
{"emsd-port",          {NULL}, 1928, "udp"},
{"bandwiz-system",     {NULL}, 1929, "tcp"},
{"bandwiz-system",     {NULL}, 1929, "udp"},
{"driveappserver",     {NULL}, 1930, "tcp"},
{"driveappserver",     {NULL}, 1930, "udp"},
{"amdsched",           {NULL}, 1931, "tcp"},
{"amdsched",           {NULL}, 1931, "udp"},
{"ctt-broker",         {NULL}, 1932, "tcp"},
{"ctt-broker",         {NULL}, 1932, "udp"},
{"xmapi",              {NULL}, 1933, "tcp"},
{"xmapi",              {NULL}, 1933, "udp"},
{"xaapi",              {NULL}, 1934, "tcp"},
{"xaapi",              {NULL}, 1934, "udp"},
{"macromedia-fcs",     {NULL}, 1935, "tcp"},
{"macromedia-fcs",     {NULL}, 1935, "udp"},
{"jetcmeserver",       {NULL}, 1936, "tcp"},
{"jetcmeserver",       {NULL}, 1936, "udp"},
{"jwserver",           {NULL}, 1937, "tcp"},
{"jwserver",           {NULL}, 1937, "udp"},
{"jwclient",           {NULL}, 1938, "tcp"},
{"jwclient",           {NULL}, 1938, "udp"},
{"jvserver",           {NULL}, 1939, "tcp"},
{"jvserver",           {NULL}, 1939, "udp"},
{"jvclient",           {NULL}, 1940, "tcp"},
{"jvclient",           {NULL}, 1940, "udp"},
{"dic-aida",           {NULL}, 1941, "tcp"},
{"dic-aida",           {NULL}, 1941, "udp"},
{"res",                {NULL}, 1942, "tcp"},
{"res",                {NULL}, 1942, "udp"},
{"beeyond-media",      {NULL}, 1943, "tcp"},
{"beeyond-media",      {NULL}, 1943, "udp"},
{"close-combat",       {NULL}, 1944, "tcp"},
{"close-combat",       {NULL}, 1944, "udp"},
{"dialogic-elmd",      {NULL}, 1945, "tcp"},
{"dialogic-elmd",      {NULL}, 1945, "udp"},
{"tekpls",             {NULL}, 1946, "tcp"},
{"tekpls",             {NULL}, 1946, "udp"},
{"sentinelsrm",        {NULL}, 1947, "tcp"},
{"sentinelsrm",        {NULL}, 1947, "udp"},
{"eye2eye",            {NULL}, 1948, "tcp"},
{"eye2eye",            {NULL}, 1948, "udp"},
{"ismaeasdaqlive",     {NULL}, 1949, "tcp"},
{"ismaeasdaqlive",     {NULL}, 1949, "udp"},
{"ismaeasdaqtest",     {NULL}, 1950, "tcp"},
{"ismaeasdaqtest",     {NULL}, 1950, "udp"},
{"bcs-lmserver",       {NULL}, 1951, "tcp"},
{"bcs-lmserver",       {NULL}, 1951, "udp"},
{"mpnjsc",             {NULL}, 1952, "tcp"},
{"mpnjsc",             {NULL}, 1952, "udp"},
{"rapidbase",          {NULL}, 1953, "tcp"},
{"rapidbase",          {NULL}, 1953, "udp"},
{"abr-api",            {NULL}, 1954, "tcp"},
{"abr-api",            {NULL}, 1954, "udp"},
{"abr-secure",         {NULL}, 1955, "tcp"},
{"abr-secure",         {NULL}, 1955, "udp"},
{"vrtl-vmf-ds",        {NULL}, 1956, "tcp"},
{"vrtl-vmf-ds",        {NULL}, 1956, "udp"},
{"unix-status",        {NULL}, 1957, "tcp"},
{"unix-status",        {NULL}, 1957, "udp"},
{"dxadmind",           {NULL}, 1958, "tcp"},
{"dxadmind",           {NULL}, 1958, "udp"},
{"simp-all",           {NULL}, 1959, "tcp"},
{"simp-all",           {NULL}, 1959, "udp"},
{"nasmanager",         {NULL}, 1960, "tcp"},
{"nasmanager",         {NULL}, 1960, "udp"},
{"bts-appserver",      {NULL}, 1961, "tcp"},
{"bts-appserver",      {NULL}, 1961, "udp"},
{"biap-mp",            {NULL}, 1962, "tcp"},
{"biap-mp",            {NULL}, 1962, "udp"},
{"webmachine",         {NULL}, 1963, "tcp"},
{"webmachine",         {NULL}, 1963, "udp"},
{"solid-e-engine",     {NULL}, 1964, "tcp"},
{"solid-e-engine",     {NULL}, 1964, "udp"},
{"tivoli-npm",         {NULL}, 1965, "tcp"},
{"tivoli-npm",         {NULL}, 1965, "udp"},
{"slush",              {NULL}, 1966, "tcp"},
{"slush",              {NULL}, 1966, "udp"},
{"sns-quote",          {NULL}, 1967, "tcp"},
{"sns-quote",          {NULL}, 1967, "udp"},
{"lipsinc",            {NULL}, 1968, "tcp"},
{"lipsinc",            {NULL}, 1968, "udp"},
{"lipsinc1",           {NULL}, 1969, "tcp"},
{"lipsinc1",           {NULL}, 1969, "udp"},
{"netop-rc",           {NULL}, 1970, "tcp"},
{"netop-rc",           {NULL}, 1970, "udp"},
{"netop-school",       {NULL}, 1971, "tcp"},
{"netop-school",       {NULL}, 1971, "udp"},
{"intersys-cache",     {NULL}, 1972, "tcp"},
{"intersys-cache",     {NULL}, 1972, "udp"},
{"dlsrap",             {NULL}, 1973, "tcp"},
{"dlsrap",             {NULL}, 1973, "udp"},
{"drp",                {NULL}, 1974, "tcp"},
{"drp",                {NULL}, 1974, "udp"},
{"tcoflashagent",      {NULL}, 1975, "tcp"},
{"tcoflashagent",      {NULL}, 1975, "udp"},
{"tcoregagent",        {NULL}, 1976, "tcp"},
{"tcoregagent",        {NULL}, 1976, "udp"},
{"tcoaddressbook",     {NULL}, 1977, "tcp"},
{"tcoaddressbook",     {NULL}, 1977, "udp"},
{"unisql",             {NULL}, 1978, "tcp"},
{"unisql",             {NULL}, 1978, "udp"},
{"unisql-java",        {NULL}, 1979, "tcp"},
{"unisql-java",        {NULL}, 1979, "udp"},
{"pearldoc-xact",      {NULL}, 1980, "tcp"},
{"pearldoc-xact",      {NULL}, 1980, "udp"},
{"p2pq",               {NULL}, 1981, "tcp"},
{"p2pq",               {NULL}, 1981, "udp"},
{"estamp",             {NULL}, 1982, "tcp"},
{"estamp",             {NULL}, 1982, "udp"},
{"lhtp",               {NULL}, 1983, "tcp"},
{"lhtp",               {NULL}, 1983, "udp"},
{"bb",                 {NULL}, 1984, "tcp"},
{"bb",                 {NULL}, 1984, "udp"},
{"hsrp",               {NULL}, 1985, "tcp"},
{"hsrp",               {NULL}, 1985, "udp"},
{"licensedaemon",      {NULL}, 1986, "tcp"},
{"licensedaemon",      {NULL}, 1986, "udp"},
{"tr-rsrb-p1",         {NULL}, 1987, "tcp"},
{"tr-rsrb-p1",         {NULL}, 1987, "udp"},
{"tr-rsrb-p2",         {NULL}, 1988, "tcp"},
{"tr-rsrb-p2",         {NULL}, 1988, "udp"},
{"tr-rsrb-p3",         {NULL}, 1989, "tcp"},
{"tr-rsrb-p3",         {NULL}, 1989, "udp"},
{"mshnet",             {NULL}, 1989, "tcp"},
{"mshnet",             {NULL}, 1989, "udp"},
{"stun-p1",            {NULL}, 1990, "tcp"},
{"stun-p1",            {NULL}, 1990, "udp"},
{"stun-p2",            {NULL}, 1991, "tcp"},
{"stun-p2",            {NULL}, 1991, "udp"},
{"stun-p3",            {NULL}, 1992, "tcp"},
{"stun-p3",            {NULL}, 1992, "udp"},
{"ipsendmsg",          {NULL}, 1992, "tcp"},
{"ipsendmsg",          {NULL}, 1992, "udp"},
{"snmp-tcp-port",      {NULL}, 1993, "tcp"},
{"snmp-tcp-port",      {NULL}, 1993, "udp"},
{"stun-port",          {NULL}, 1994, "tcp"},
{"stun-port",          {NULL}, 1994, "udp"},
{"perf-port",          {NULL}, 1995, "tcp"},
{"perf-port",          {NULL}, 1995, "udp"},
{"tr-rsrb-port",       {NULL}, 1996, "tcp"},
{"tr-rsrb-port",       {NULL}, 1996, "udp"},
{"gdp-port",           {NULL}, 1997, "tcp"},
{"gdp-port",           {NULL}, 1997, "udp"},
{"x25-svc-port",       {NULL}, 1998, "tcp"},
{"x25-svc-port",       {NULL}, 1998, "udp"},
{"tcp-id-port",        {NULL}, 1999, "tcp"},
{"tcp-id-port",        {NULL}, 1999, "udp"},
{"cisco-sccp",         {NULL}, 2000, "tcp"},
{"cisco-sccp",         {NULL}, 2000, "udp"},
{"dc",                 {NULL}, 2001, "tcp"},
{"wizard",             {NULL}, 2001, "udp"},
{"globe",              {NULL}, 2002, "tcp"},
{"globe",              {NULL}, 2002, "udp"},
{"brutus",             {NULL}, 2003, "tcp"},
{"brutus",             {NULL}, 2003, "udp"},
{"mailbox",            {NULL}, 2004, "tcp"},
{"emce",               {NULL}, 2004, "udp"},
{"berknet",            {NULL}, 2005, "tcp"},
{"oracle",             {NULL}, 2005, "udp"},
{"invokator",          {NULL}, 2006, "tcp"},
{"raid-cd",            {NULL}, 2006, "udp"},
{"dectalk",            {NULL}, 2007, "tcp"},
{"raid-am",            {NULL}, 2007, "udp"},
{"conf",               {NULL}, 2008, "tcp"},
{"terminaldb",         {NULL}, 2008, "udp"},
{"news",               {NULL}, 2009, "tcp"},
{"whosockami",         {NULL}, 2009, "udp"},
{"search",             {NULL}, 2010, "tcp"},
{"pipe_server",        {NULL}, 2010, "udp"},
{"raid-cc",            {NULL}, 2011, "tcp"},
{"servserv",           {NULL}, 2011, "udp"},
{"ttyinfo",            {NULL}, 2012, "tcp"},
{"raid-ac",            {NULL}, 2012, "udp"},
{"raid-am",            {NULL}, 2013, "tcp"},
{"raid-cd",            {NULL}, 2013, "udp"},
{"troff",              {NULL}, 2014, "tcp"},
{"raid-sf",            {NULL}, 2014, "udp"},
{"cypress",            {NULL}, 2015, "tcp"},
{"raid-cs",            {NULL}, 2015, "udp"},
{"bootserver",         {NULL}, 2016, "tcp"},
{"bootserver",         {NULL}, 2016, "udp"},
{"cypress-stat",       {NULL}, 2017, "tcp"},
{"bootclient",         {NULL}, 2017, "udp"},
{"terminaldb",         {NULL}, 2018, "tcp"},
{"rellpack",           {NULL}, 2018, "udp"},
{"whosockami",         {NULL}, 2019, "tcp"},
{"about",              {NULL}, 2019, "udp"},
{"xinupageserver",     {NULL}, 2020, "tcp"},
{"xinupageserver",     {NULL}, 2020, "udp"},
{"servexec",           {NULL}, 2021, "tcp"},
{"xinuexpansion1",     {NULL}, 2021, "udp"},
{"down",               {NULL}, 2022, "tcp"},
{"xinuexpansion2",     {NULL}, 2022, "udp"},
{"xinuexpansion3",     {NULL}, 2023, "tcp"},
{"xinuexpansion3",     {NULL}, 2023, "udp"},
{"xinuexpansion4",     {NULL}, 2024, "tcp"},
{"xinuexpansion4",     {NULL}, 2024, "udp"},
{"ellpack",            {NULL}, 2025, "tcp"},
{"xribs",              {NULL}, 2025, "udp"},
{"scrabble",           {NULL}, 2026, "tcp"},
{"scrabble",           {NULL}, 2026, "udp"},
{"shadowserver",       {NULL}, 2027, "tcp"},
{"shadowserver",       {NULL}, 2027, "udp"},
{"submitserver",       {NULL}, 2028, "tcp"},
{"submitserver",       {NULL}, 2028, "udp"},
{"hsrpv6",             {NULL}, 2029, "tcp"},
{"hsrpv6",             {NULL}, 2029, "udp"},
{"device2",            {NULL}, 2030, "tcp"},
{"device2",            {NULL}, 2030, "udp"},
{"mobrien-chat",       {NULL}, 2031, "tcp"},
{"mobrien-chat",       {NULL}, 2031, "udp"},
{"blackboard",         {NULL}, 2032, "tcp"},
{"blackboard",         {NULL}, 2032, "udp"},
{"glogger",            {NULL}, 2033, "tcp"},
{"glogger",            {NULL}, 2033, "udp"},
{"scoremgr",           {NULL}, 2034, "tcp"},
{"scoremgr",           {NULL}, 2034, "udp"},
{"imsldoc",            {NULL}, 2035, "tcp"},
{"imsldoc",            {NULL}, 2035, "udp"},
{"e-dpnet",            {NULL}, 2036, "tcp"},
{"e-dpnet",            {NULL}, 2036, "udp"},
{"applus",             {NULL}, 2037, "tcp"},
{"applus",             {NULL}, 2037, "udp"},
{"objectmanager",      {NULL}, 2038, "tcp"},
{"objectmanager",      {NULL}, 2038, "udp"},
{"prizma",             {NULL}, 2039, "tcp"},
{"prizma",             {NULL}, 2039, "udp"},
{"lam",                {NULL}, 2040, "tcp"},
{"lam",                {NULL}, 2040, "udp"},
{"interbase",          {NULL}, 2041, "tcp"},
{"interbase",          {NULL}, 2041, "udp"},
{"isis",               {NULL}, 2042, "tcp"},
{"isis",               {NULL}, 2042, "udp"},
{"isis-bcast",         {NULL}, 2043, "tcp"},
{"isis-bcast",         {NULL}, 2043, "udp"},
{"rimsl",              {NULL}, 2044, "tcp"},
{"rimsl",              {NULL}, 2044, "udp"},
{"cdfunc",             {NULL}, 2045, "tcp"},
{"cdfunc",             {NULL}, 2045, "udp"},
{"sdfunc",             {NULL}, 2046, "tcp"},
{"sdfunc",             {NULL}, 2046, "udp"},
{"dls",                {NULL}, 2047, "tcp"},
{"dls",                {NULL}, 2047, "udp"},
{"dls-monitor",        {NULL}, 2048, "tcp"},
{"dls-monitor",        {NULL}, 2048, "udp"},
{"shilp",              {NULL}, 2049, "tcp"},
{"shilp",              {NULL}, 2049, "udp"},
{"nfs",                {NULL}, 2049, "tcp"},
{"nfs",                {NULL}, 2049, "udp"},
{"nfs",                {NULL}, 2049, "sctp"},
{"av-emb-config",      {NULL}, 2050, "tcp"},
{"av-emb-config",      {NULL}, 2050, "udp"},
{"epnsdp",             {NULL}, 2051, "tcp"},
{"epnsdp",             {NULL}, 2051, "udp"},
{"clearvisn",          {NULL}, 2052, "tcp"},
{"clearvisn",          {NULL}, 2052, "udp"},
{"lot105-ds-upd",      {NULL}, 2053, "tcp"},
{"lot105-ds-upd",      {NULL}, 2053, "udp"},
{"weblogin",           {NULL}, 2054, "tcp"},
{"weblogin",           {NULL}, 2054, "udp"},
{"iop",                {NULL}, 2055, "tcp"},
{"iop",                {NULL}, 2055, "udp"},
{"omnisky",            {NULL}, 2056, "tcp"},
{"omnisky",            {NULL}, 2056, "udp"},
{"rich-cp",            {NULL}, 2057, "tcp"},
{"rich-cp",            {NULL}, 2057, "udp"},
{"newwavesearch",      {NULL}, 2058, "tcp"},
{"newwavesearch",      {NULL}, 2058, "udp"},
{"bmc-messaging",      {NULL}, 2059, "tcp"},
{"bmc-messaging",      {NULL}, 2059, "udp"},
{"teleniumdaemon",     {NULL}, 2060, "tcp"},
{"teleniumdaemon",     {NULL}, 2060, "udp"},
{"netmount",           {NULL}, 2061, "tcp"},
{"netmount",           {NULL}, 2061, "udp"},
{"icg-swp",            {NULL}, 2062, "tcp"},
{"icg-swp",            {NULL}, 2062, "udp"},
{"icg-bridge",         {NULL}, 2063, "tcp"},
{"icg-bridge",         {NULL}, 2063, "udp"},
{"icg-iprelay",        {NULL}, 2064, "tcp"},
{"icg-iprelay",        {NULL}, 2064, "udp"},
{"dlsrpn",             {NULL}, 2065, "tcp"},
{"dlsrpn",             {NULL}, 2065, "udp"},
{"aura",               {NULL}, 2066, "tcp"},
{"aura",               {NULL}, 2066, "udp"},
{"dlswpn",             {NULL}, 2067, "tcp"},
{"dlswpn",             {NULL}, 2067, "udp"},
{"avauthsrvprtcl",     {NULL}, 2068, "tcp"},
{"avauthsrvprtcl",     {NULL}, 2068, "udp"},
{"event-port",         {NULL}, 2069, "tcp"},
{"event-port",         {NULL}, 2069, "udp"},
{"ah-esp-encap",       {NULL}, 2070, "tcp"},
{"ah-esp-encap",       {NULL}, 2070, "udp"},
{"acp-port",           {NULL}, 2071, "tcp"},
{"acp-port",           {NULL}, 2071, "udp"},
{"msync",              {NULL}, 2072, "tcp"},
{"msync",              {NULL}, 2072, "udp"},
{"gxs-data-port",      {NULL}, 2073, "tcp"},
{"gxs-data-port",      {NULL}, 2073, "udp"},
{"vrtl-vmf-sa",        {NULL}, 2074, "tcp"},
{"vrtl-vmf-sa",        {NULL}, 2074, "udp"},
{"newlixengine",       {NULL}, 2075, "tcp"},
{"newlixengine",       {NULL}, 2075, "udp"},
{"newlixconfig",       {NULL}, 2076, "tcp"},
{"newlixconfig",       {NULL}, 2076, "udp"},
{"tsrmagt",            {NULL}, 2077, "tcp"},
{"tsrmagt",            {NULL}, 2077, "udp"},
{"tpcsrvr",            {NULL}, 2078, "tcp"},
{"tpcsrvr",            {NULL}, 2078, "udp"},
{"idware-router",      {NULL}, 2079, "tcp"},
{"idware-router",      {NULL}, 2079, "udp"},
{"autodesk-nlm",       {NULL}, 2080, "tcp"},
{"autodesk-nlm",       {NULL}, 2080, "udp"},
{"kme-trap-port",      {NULL}, 2081, "tcp"},
{"kme-trap-port",      {NULL}, 2081, "udp"},
{"infowave",           {NULL}, 2082, "tcp"},
{"infowave",           {NULL}, 2082, "udp"},
{"radsec",             {NULL}, 2083, "tcp"},
{"radsec",             {NULL}, 2083, "udp"},
{"sunclustergeo",      {NULL}, 2084, "tcp"},
{"sunclustergeo",      {NULL}, 2084, "udp"},
{"ada-cip",            {NULL}, 2085, "tcp"},
{"ada-cip",            {NULL}, 2085, "udp"},
{"gnunet",             {NULL}, 2086, "tcp"},
{"gnunet",             {NULL}, 2086, "udp"},
{"eli",                {NULL}, 2087, "tcp"},
{"eli",                {NULL}, 2087, "udp"},
{"ip-blf",             {NULL}, 2088, "tcp"},
{"ip-blf",             {NULL}, 2088, "udp"},
{"sep",                {NULL}, 2089, "tcp"},
{"sep",                {NULL}, 2089, "udp"},
{"lrp",                {NULL}, 2090, "tcp"},
{"lrp",                {NULL}, 2090, "udp"},
{"prp",                {NULL}, 2091, "tcp"},
{"prp",                {NULL}, 2091, "udp"},
{"descent3",           {NULL}, 2092, "tcp"},
{"descent3",           {NULL}, 2092, "udp"},
{"nbx-cc",             {NULL}, 2093, "tcp"},
{"nbx-cc",             {NULL}, 2093, "udp"},
{"nbx-au",             {NULL}, 2094, "tcp"},
{"nbx-au",             {NULL}, 2094, "udp"},
{"nbx-ser",            {NULL}, 2095, "tcp"},
{"nbx-ser",            {NULL}, 2095, "udp"},
{"nbx-dir",            {NULL}, 2096, "tcp"},
{"nbx-dir",            {NULL}, 2096, "udp"},
{"jetformpreview",     {NULL}, 2097, "tcp"},
{"jetformpreview",     {NULL}, 2097, "udp"},
{"dialog-port",        {NULL}, 2098, "tcp"},
{"dialog-port",        {NULL}, 2098, "udp"},
{"h2250-annex-g",      {NULL}, 2099, "tcp"},
{"h2250-annex-g",      {NULL}, 2099, "udp"},
{"amiganetfs",         {NULL}, 2100, "tcp"},
{"amiganetfs",         {NULL}, 2100, "udp"},
{"rtcm-sc104",         {NULL}, 2101, "tcp"},
{"rtcm-sc104",         {NULL}, 2101, "udp"},
{"zephyr-srv",         {NULL}, 2102, "tcp"},
{"zephyr-srv",         {NULL}, 2102, "udp"},
{"zephyr-clt",         {NULL}, 2103, "tcp"},
{"zephyr-clt",         {NULL}, 2103, "udp"},
{"zephyr-hm",          {NULL}, 2104, "tcp"},
{"zephyr-hm",          {NULL}, 2104, "udp"},
{"minipay",            {NULL}, 2105, "tcp"},
{"minipay",            {NULL}, 2105, "udp"},
{"mzap",               {NULL}, 2106, "tcp"},
{"mzap",               {NULL}, 2106, "udp"},
{"bintec-admin",       {NULL}, 2107, "tcp"},
{"bintec-admin",       {NULL}, 2107, "udp"},
{"comcam",             {NULL}, 2108, "tcp"},
{"comcam",             {NULL}, 2108, "udp"},
{"ergolight",          {NULL}, 2109, "tcp"},
{"ergolight",          {NULL}, 2109, "udp"},
{"umsp",               {NULL}, 2110, "tcp"},
{"umsp",               {NULL}, 2110, "udp"},
{"dsatp",              {NULL}, 2111, "tcp"},
{"dsatp",              {NULL}, 2111, "udp"},
{"idonix-metanet",     {NULL}, 2112, "tcp"},
{"idonix-metanet",     {NULL}, 2112, "udp"},
{"hsl-storm",          {NULL}, 2113, "tcp"},
{"hsl-storm",          {NULL}, 2113, "udp"},
{"newheights",         {NULL}, 2114, "tcp"},
{"newheights",         {NULL}, 2114, "udp"},
{"kdm",                {NULL}, 2115, "tcp"},
{"kdm",                {NULL}, 2115, "udp"},
{"ccowcmr",            {NULL}, 2116, "tcp"},
{"ccowcmr",            {NULL}, 2116, "udp"},
{"mentaclient",        {NULL}, 2117, "tcp"},
{"mentaclient",        {NULL}, 2117, "udp"},
{"mentaserver",        {NULL}, 2118, "tcp"},
{"mentaserver",        {NULL}, 2118, "udp"},
{"gsigatekeeper",      {NULL}, 2119, "tcp"},
{"gsigatekeeper",      {NULL}, 2119, "udp"},
{"qencp",              {NULL}, 2120, "tcp"},
{"qencp",              {NULL}, 2120, "udp"},
{"scientia-ssdb",      {NULL}, 2121, "tcp"},
{"scientia-ssdb",      {NULL}, 2121, "udp"},
{"caupc-remote",       {NULL}, 2122, "tcp"},
{"caupc-remote",       {NULL}, 2122, "udp"},
{"gtp-control",        {NULL}, 2123, "tcp"},
{"gtp-control",        {NULL}, 2123, "udp"},
{"elatelink",          {NULL}, 2124, "tcp"},
{"elatelink",          {NULL}, 2124, "udp"},
{"lockstep",           {NULL}, 2125, "tcp"},
{"lockstep",           {NULL}, 2125, "udp"},
{"pktcable-cops",      {NULL}, 2126, "tcp"},
{"pktcable-cops",      {NULL}, 2126, "udp"},
{"index-pc-wb",        {NULL}, 2127, "tcp"},
{"index-pc-wb",        {NULL}, 2127, "udp"},
{"net-steward",        {NULL}, 2128, "tcp"},
{"net-steward",        {NULL}, 2128, "udp"},
{"cs-live",            {NULL}, 2129, "tcp"},
{"cs-live",            {NULL}, 2129, "udp"},
{"xds",                {NULL}, 2130, "tcp"},
{"xds",                {NULL}, 2130, "udp"},
{"avantageb2b",        {NULL}, 2131, "tcp"},
{"avantageb2b",        {NULL}, 2131, "udp"},
{"solera-epmap",       {NULL}, 2132, "tcp"},
{"solera-epmap",       {NULL}, 2132, "udp"},
{"zymed-zpp",          {NULL}, 2133, "tcp"},
{"zymed-zpp",          {NULL}, 2133, "udp"},
{"avenue",             {NULL}, 2134, "tcp"},
{"avenue",             {NULL}, 2134, "udp"},
{"gris",               {NULL}, 2135, "tcp"},
{"gris",               {NULL}, 2135, "udp"},
{"appworxsrv",         {NULL}, 2136, "tcp"},
{"appworxsrv",         {NULL}, 2136, "udp"},
{"connect",            {NULL}, 2137, "tcp"},
{"connect",            {NULL}, 2137, "udp"},
{"unbind-cluster",     {NULL}, 2138, "tcp"},
{"unbind-cluster",     {NULL}, 2138, "udp"},
{"ias-auth",           {NULL}, 2139, "tcp"},
{"ias-auth",           {NULL}, 2139, "udp"},
{"ias-reg",            {NULL}, 2140, "tcp"},
{"ias-reg",            {NULL}, 2140, "udp"},
{"ias-admind",         {NULL}, 2141, "tcp"},
{"ias-admind",         {NULL}, 2141, "udp"},
{"tdmoip",             {NULL}, 2142, "tcp"},
{"tdmoip",             {NULL}, 2142, "udp"},
{"lv-jc",              {NULL}, 2143, "tcp"},
{"lv-jc",              {NULL}, 2143, "udp"},
{"lv-ffx",             {NULL}, 2144, "tcp"},
{"lv-ffx",             {NULL}, 2144, "udp"},
{"lv-pici",            {NULL}, 2145, "tcp"},
{"lv-pici",            {NULL}, 2145, "udp"},
{"lv-not",             {NULL}, 2146, "tcp"},
{"lv-not",             {NULL}, 2146, "udp"},
{"lv-auth",            {NULL}, 2147, "tcp"},
{"lv-auth",            {NULL}, 2147, "udp"},
{"veritas-ucl",        {NULL}, 2148, "tcp"},
{"veritas-ucl",        {NULL}, 2148, "udp"},
{"acptsys",            {NULL}, 2149, "tcp"},
{"acptsys",            {NULL}, 2149, "udp"},
{"dynamic3d",          {NULL}, 2150, "tcp"},
{"dynamic3d",          {NULL}, 2150, "udp"},
{"docent",             {NULL}, 2151, "tcp"},
{"docent",             {NULL}, 2151, "udp"},
{"gtp-user",           {NULL}, 2152, "tcp"},
{"gtp-user",           {NULL}, 2152, "udp"},
{"ctlptc",             {NULL}, 2153, "tcp"},
{"ctlptc",             {NULL}, 2153, "udp"},
{"stdptc",             {NULL}, 2154, "tcp"},
{"stdptc",             {NULL}, 2154, "udp"},
{"brdptc",             {NULL}, 2155, "tcp"},
{"brdptc",             {NULL}, 2155, "udp"},
{"trp",                {NULL}, 2156, "tcp"},
{"trp",                {NULL}, 2156, "udp"},
{"xnds",               {NULL}, 2157, "tcp"},
{"xnds",               {NULL}, 2157, "udp"},
{"touchnetplus",       {NULL}, 2158, "tcp"},
{"touchnetplus",       {NULL}, 2158, "udp"},
{"gdbremote",          {NULL}, 2159, "tcp"},
{"gdbremote",          {NULL}, 2159, "udp"},
{"apc-2160",           {NULL}, 2160, "tcp"},
{"apc-2160",           {NULL}, 2160, "udp"},
{"apc-2161",           {NULL}, 2161, "tcp"},
{"apc-2161",           {NULL}, 2161, "udp"},
{"navisphere",         {NULL}, 2162, "tcp"},
{"navisphere",         {NULL}, 2162, "udp"},
{"navisphere-sec",     {NULL}, 2163, "tcp"},
{"navisphere-sec",     {NULL}, 2163, "udp"},
{"ddns-v3",            {NULL}, 2164, "tcp"},
{"ddns-v3",            {NULL}, 2164, "udp"},
{"x-bone-api",         {NULL}, 2165, "tcp"},
{"x-bone-api",         {NULL}, 2165, "udp"},
{"iwserver",           {NULL}, 2166, "tcp"},
{"iwserver",           {NULL}, 2166, "udp"},
{"raw-serial",         {NULL}, 2167, "tcp"},
{"raw-serial",         {NULL}, 2167, "udp"},
{"easy-soft-mux",      {NULL}, 2168, "tcp"},
{"easy-soft-mux",      {NULL}, 2168, "udp"},
{"brain",              {NULL}, 2169, "tcp"},
{"brain",              {NULL}, 2169, "udp"},
{"eyetv",              {NULL}, 2170, "tcp"},
{"eyetv",              {NULL}, 2170, "udp"},
{"msfw-storage",       {NULL}, 2171, "tcp"},
{"msfw-storage",       {NULL}, 2171, "udp"},
{"msfw-s-storage",     {NULL}, 2172, "tcp"},
{"msfw-s-storage",     {NULL}, 2172, "udp"},
{"msfw-replica",       {NULL}, 2173, "tcp"},
{"msfw-replica",       {NULL}, 2173, "udp"},
{"msfw-array",         {NULL}, 2174, "tcp"},
{"msfw-array",         {NULL}, 2174, "udp"},
{"airsync",            {NULL}, 2175, "tcp"},
{"airsync",            {NULL}, 2175, "udp"},
{"rapi",               {NULL}, 2176, "tcp"},
{"rapi",               {NULL}, 2176, "udp"},
{"qwave",              {NULL}, 2177, "tcp"},
{"qwave",              {NULL}, 2177, "udp"},
{"bitspeer",           {NULL}, 2178, "tcp"},
{"bitspeer",           {NULL}, 2178, "udp"},
{"vmrdp",              {NULL}, 2179, "tcp"},
{"vmrdp",              {NULL}, 2179, "udp"},
{"mc-gt-srv",          {NULL}, 2180, "tcp"},
{"mc-gt-srv",          {NULL}, 2180, "udp"},
{"eforward",           {NULL}, 2181, "tcp"},
{"eforward",           {NULL}, 2181, "udp"},
{"cgn-stat",           {NULL}, 2182, "tcp"},
{"cgn-stat",           {NULL}, 2182, "udp"},
{"cgn-config",         {NULL}, 2183, "tcp"},
{"cgn-config",         {NULL}, 2183, "udp"},
{"nvd",                {NULL}, 2184, "tcp"},
{"nvd",                {NULL}, 2184, "udp"},
{"onbase-dds",         {NULL}, 2185, "tcp"},
{"onbase-dds",         {NULL}, 2185, "udp"},
{"gtaua",              {NULL}, 2186, "tcp"},
{"gtaua",              {NULL}, 2186, "udp"},
{"ssmc",               {NULL}, 2187, "tcp"},
{"ssmd",               {NULL}, 2187, "udp"},
{"tivoconnect",        {NULL}, 2190, "tcp"},
{"tivoconnect",        {NULL}, 2190, "udp"},
{"tvbus",              {NULL}, 2191, "tcp"},
{"tvbus",              {NULL}, 2191, "udp"},
{"asdis",              {NULL}, 2192, "tcp"},
{"asdis",              {NULL}, 2192, "udp"},
{"drwcs",              {NULL}, 2193, "tcp"},
{"drwcs",              {NULL}, 2193, "udp"},
{"mnp-exchange",       {NULL}, 2197, "tcp"},
{"mnp-exchange",       {NULL}, 2197, "udp"},
{"onehome-remote",     {NULL}, 2198, "tcp"},
{"onehome-remote",     {NULL}, 2198, "udp"},
{"onehome-help",       {NULL}, 2199, "tcp"},
{"onehome-help",       {NULL}, 2199, "udp"},
{"ici",                {NULL}, 2200, "tcp"},
{"ici",                {NULL}, 2200, "udp"},
{"ats",                {NULL}, 2201, "tcp"},
{"ats",                {NULL}, 2201, "udp"},
{"imtc-map",           {NULL}, 2202, "tcp"},
{"imtc-map",           {NULL}, 2202, "udp"},
{"b2-runtime",         {NULL}, 2203, "tcp"},
{"b2-runtime",         {NULL}, 2203, "udp"},
{"b2-license",         {NULL}, 2204, "tcp"},
{"b2-license",         {NULL}, 2204, "udp"},
{"jps",                {NULL}, 2205, "tcp"},
{"jps",                {NULL}, 2205, "udp"},
{"hpocbus",            {NULL}, 2206, "tcp"},
{"hpocbus",            {NULL}, 2206, "udp"},
{"hpssd",              {NULL}, 2207, "tcp"},
{"hpssd",              {NULL}, 2207, "udp"},
{"hpiod",              {NULL}, 2208, "tcp"},
{"hpiod",              {NULL}, 2208, "udp"},
{"rimf-ps",            {NULL}, 2209, "tcp"},
{"rimf-ps",            {NULL}, 2209, "udp"},
{"noaaport",           {NULL}, 2210, "tcp"},
{"noaaport",           {NULL}, 2210, "udp"},
{"emwin",              {NULL}, 2211, "tcp"},
{"emwin",              {NULL}, 2211, "udp"},
{"leecoposserver",     {NULL}, 2212, "tcp"},
{"leecoposserver",     {NULL}, 2212, "udp"},
{"kali",               {NULL}, 2213, "tcp"},
{"kali",               {NULL}, 2213, "udp"},
{"rpi",                {NULL}, 2214, "tcp"},
{"rpi",                {NULL}, 2214, "udp"},
{"ipcore",             {NULL}, 2215, "tcp"},
{"ipcore",             {NULL}, 2215, "udp"},
{"vtu-comms",          {NULL}, 2216, "tcp"},
{"vtu-comms",          {NULL}, 2216, "udp"},
{"gotodevice",         {NULL}, 2217, "tcp"},
{"gotodevice",         {NULL}, 2217, "udp"},
{"bounzza",            {NULL}, 2218, "tcp"},
{"bounzza",            {NULL}, 2218, "udp"},
{"netiq-ncap",         {NULL}, 2219, "tcp"},
{"netiq-ncap",         {NULL}, 2219, "udp"},
{"netiq",              {NULL}, 2220, "tcp"},
{"netiq",              {NULL}, 2220, "udp"},
{"rockwell-csp1",      {NULL}, 2221, "tcp"},
{"rockwell-csp1",      {NULL}, 2221, "udp"},
{"EtherNet/IP-1",      {NULL}, 2222, "tcp"},
{"EtherNet/IP-1",      {NULL}, 2222, "udp"},
{"rockwell-csp2",      {NULL}, 2223, "tcp"},
{"rockwell-csp2",      {NULL}, 2223, "udp"},
{"efi-mg",             {NULL}, 2224, "tcp"},
{"efi-mg",             {NULL}, 2224, "udp"},
{"rcip-itu",           {NULL}, 2225, "tcp"},
{"rcip-itu",           {NULL}, 2225, "sctp"},
{"di-drm",             {NULL}, 2226, "tcp"},
{"di-drm",             {NULL}, 2226, "udp"},
{"di-msg",             {NULL}, 2227, "tcp"},
{"di-msg",             {NULL}, 2227, "udp"},
{"ehome-ms",           {NULL}, 2228, "tcp"},
{"ehome-ms",           {NULL}, 2228, "udp"},
{"datalens",           {NULL}, 2229, "tcp"},
{"datalens",           {NULL}, 2229, "udp"},
{"queueadm",           {NULL}, 2230, "tcp"},
{"queueadm",           {NULL}, 2230, "udp"},
{"wimaxasncp",         {NULL}, 2231, "tcp"},
{"wimaxasncp",         {NULL}, 2231, "udp"},
{"ivs-video",          {NULL}, 2232, "tcp"},
{"ivs-video",          {NULL}, 2232, "udp"},
{"infocrypt",          {NULL}, 2233, "tcp"},
{"infocrypt",          {NULL}, 2233, "udp"},
{"directplay",         {NULL}, 2234, "tcp"},
{"directplay",         {NULL}, 2234, "udp"},
{"sercomm-wlink",      {NULL}, 2235, "tcp"},
{"sercomm-wlink",      {NULL}, 2235, "udp"},
{"nani",               {NULL}, 2236, "tcp"},
{"nani",               {NULL}, 2236, "udp"},
{"optech-port1-lm",    {NULL}, 2237, "tcp"},
{"optech-port1-lm",    {NULL}, 2237, "udp"},
{"aviva-sna",          {NULL}, 2238, "tcp"},
{"aviva-sna",          {NULL}, 2238, "udp"},
{"imagequery",         {NULL}, 2239, "tcp"},
{"imagequery",         {NULL}, 2239, "udp"},
{"recipe",             {NULL}, 2240, "tcp"},
{"recipe",             {NULL}, 2240, "udp"},
{"ivsd",               {NULL}, 2241, "tcp"},
{"ivsd",               {NULL}, 2241, "udp"},
{"foliocorp",          {NULL}, 2242, "tcp"},
{"foliocorp",          {NULL}, 2242, "udp"},
{"magicom",            {NULL}, 2243, "tcp"},
{"magicom",            {NULL}, 2243, "udp"},
{"nmsserver",          {NULL}, 2244, "tcp"},
{"nmsserver",          {NULL}, 2244, "udp"},
{"hao",                {NULL}, 2245, "tcp"},
{"hao",                {NULL}, 2245, "udp"},
{"pc-mta-addrmap",     {NULL}, 2246, "tcp"},
{"pc-mta-addrmap",     {NULL}, 2246, "udp"},
{"antidotemgrsvr",     {NULL}, 2247, "tcp"},
{"antidotemgrsvr",     {NULL}, 2247, "udp"},
{"ums",                {NULL}, 2248, "tcp"},
{"ums",                {NULL}, 2248, "udp"},
{"rfmp",               {NULL}, 2249, "tcp"},
{"rfmp",               {NULL}, 2249, "udp"},
{"remote-collab",      {NULL}, 2250, "tcp"},
{"remote-collab",      {NULL}, 2250, "udp"},
{"dif-port",           {NULL}, 2251, "tcp"},
{"dif-port",           {NULL}, 2251, "udp"},
{"njenet-ssl",         {NULL}, 2252, "tcp"},
{"njenet-ssl",         {NULL}, 2252, "udp"},
{"dtv-chan-req",       {NULL}, 2253, "tcp"},
{"dtv-chan-req",       {NULL}, 2253, "udp"},
{"seispoc",            {NULL}, 2254, "tcp"},
{"seispoc",            {NULL}, 2254, "udp"},
{"vrtp",               {NULL}, 2255, "tcp"},
{"vrtp",               {NULL}, 2255, "udp"},
{"pcc-mfp",            {NULL}, 2256, "tcp"},
{"pcc-mfp",            {NULL}, 2256, "udp"},
{"simple-tx-rx",       {NULL}, 2257, "tcp"},
{"simple-tx-rx",       {NULL}, 2257, "udp"},
{"rcts",               {NULL}, 2258, "tcp"},
{"rcts",               {NULL}, 2258, "udp"},
{"acd-pm",             {NULL}, 2259, "tcp"},
{"acd-pm",             {NULL}, 2259, "udp"},
{"apc-2260",           {NULL}, 2260, "tcp"},
{"apc-2260",           {NULL}, 2260, "udp"},
{"comotionmaster",     {NULL}, 2261, "tcp"},
{"comotionmaster",     {NULL}, 2261, "udp"},
{"comotionback",       {NULL}, 2262, "tcp"},
{"comotionback",       {NULL}, 2262, "udp"},
{"ecwcfg",             {NULL}, 2263, "tcp"},
{"ecwcfg",             {NULL}, 2263, "udp"},
{"apx500api-1",        {NULL}, 2264, "tcp"},
{"apx500api-1",        {NULL}, 2264, "udp"},
{"apx500api-2",        {NULL}, 2265, "tcp"},
{"apx500api-2",        {NULL}, 2265, "udp"},
{"mfserver",           {NULL}, 2266, "tcp"},
{"mfserver",           {NULL}, 2266, "udp"},
{"ontobroker",         {NULL}, 2267, "tcp"},
{"ontobroker",         {NULL}, 2267, "udp"},
{"amt",                {NULL}, 2268, "tcp"},
{"amt",                {NULL}, 2268, "udp"},
{"mikey",              {NULL}, 2269, "tcp"},
{"mikey",              {NULL}, 2269, "udp"},
{"starschool",         {NULL}, 2270, "tcp"},
{"starschool",         {NULL}, 2270, "udp"},
{"mmcals",             {NULL}, 2271, "tcp"},
{"mmcals",             {NULL}, 2271, "udp"},
{"mmcal",              {NULL}, 2272, "tcp"},
{"mmcal",              {NULL}, 2272, "udp"},
{"mysql-im",           {NULL}, 2273, "tcp"},
{"mysql-im",           {NULL}, 2273, "udp"},
{"pcttunnell",         {NULL}, 2274, "tcp"},
{"pcttunnell",         {NULL}, 2274, "udp"},
{"ibridge-data",       {NULL}, 2275, "tcp"},
{"ibridge-data",       {NULL}, 2275, "udp"},
{"ibridge-mgmt",       {NULL}, 2276, "tcp"},
{"ibridge-mgmt",       {NULL}, 2276, "udp"},
{"bluectrlproxy",      {NULL}, 2277, "tcp"},
{"bluectrlproxy",      {NULL}, 2277, "udp"},
{"s3db",               {NULL}, 2278, "tcp"},
{"s3db",               {NULL}, 2278, "udp"},
{"xmquery",            {NULL}, 2279, "tcp"},
{"xmquery",            {NULL}, 2279, "udp"},
{"lnvpoller",          {NULL}, 2280, "tcp"},
{"lnvpoller",          {NULL}, 2280, "udp"},
{"lnvconsole",         {NULL}, 2281, "tcp"},
{"lnvconsole",         {NULL}, 2281, "udp"},
{"lnvalarm",           {NULL}, 2282, "tcp"},
{"lnvalarm",           {NULL}, 2282, "udp"},
{"lnvstatus",          {NULL}, 2283, "tcp"},
{"lnvstatus",          {NULL}, 2283, "udp"},
{"lnvmaps",            {NULL}, 2284, "tcp"},
{"lnvmaps",            {NULL}, 2284, "udp"},
{"lnvmailmon",         {NULL}, 2285, "tcp"},
{"lnvmailmon",         {NULL}, 2285, "udp"},
{"nas-metering",       {NULL}, 2286, "tcp"},
{"nas-metering",       {NULL}, 2286, "udp"},
{"dna",                {NULL}, 2287, "tcp"},
{"dna",                {NULL}, 2287, "udp"},
{"netml",              {NULL}, 2288, "tcp"},
{"netml",              {NULL}, 2288, "udp"},
{"dict-lookup",        {NULL}, 2289, "tcp"},
{"dict-lookup",        {NULL}, 2289, "udp"},
{"sonus-logging",      {NULL}, 2290, "tcp"},
{"sonus-logging",      {NULL}, 2290, "udp"},
{"eapsp",              {NULL}, 2291, "tcp"},
{"eapsp",              {NULL}, 2291, "udp"},
{"mib-streaming",      {NULL}, 2292, "tcp"},
{"mib-streaming",      {NULL}, 2292, "udp"},
{"npdbgmngr",          {NULL}, 2293, "tcp"},
{"npdbgmngr",          {NULL}, 2293, "udp"},
{"konshus-lm",         {NULL}, 2294, "tcp"},
{"konshus-lm",         {NULL}, 2294, "udp"},
{"advant-lm",          {NULL}, 2295, "tcp"},
{"advant-lm",          {NULL}, 2295, "udp"},
{"theta-lm",           {NULL}, 2296, "tcp"},
{"theta-lm",           {NULL}, 2296, "udp"},
{"d2k-datamover1",     {NULL}, 2297, "tcp"},
{"d2k-datamover1",     {NULL}, 2297, "udp"},
{"d2k-datamover2",     {NULL}, 2298, "tcp"},
{"d2k-datamover2",     {NULL}, 2298, "udp"},
{"pc-telecommute",     {NULL}, 2299, "tcp"},
{"pc-telecommute",     {NULL}, 2299, "udp"},
{"cvmmon",             {NULL}, 2300, "tcp"},
{"cvmmon",             {NULL}, 2300, "udp"},
{"cpq-wbem",           {NULL}, 2301, "tcp"},
{"cpq-wbem",           {NULL}, 2301, "udp"},
{"binderysupport",     {NULL}, 2302, "tcp"},
{"binderysupport",     {NULL}, 2302, "udp"},
{"proxy-gateway",      {NULL}, 2303, "tcp"},
{"proxy-gateway",      {NULL}, 2303, "udp"},
{"attachmate-uts",     {NULL}, 2304, "tcp"},
{"attachmate-uts",     {NULL}, 2304, "udp"},
{"mt-scaleserver",     {NULL}, 2305, "tcp"},
{"mt-scaleserver",     {NULL}, 2305, "udp"},
{"tappi-boxnet",       {NULL}, 2306, "tcp"},
{"tappi-boxnet",       {NULL}, 2306, "udp"},
{"pehelp",             {NULL}, 2307, "tcp"},
{"pehelp",             {NULL}, 2307, "udp"},
{"sdhelp",             {NULL}, 2308, "tcp"},
{"sdhelp",             {NULL}, 2308, "udp"},
{"sdserver",           {NULL}, 2309, "tcp"},
{"sdserver",           {NULL}, 2309, "udp"},
{"sdclient",           {NULL}, 2310, "tcp"},
{"sdclient",           {NULL}, 2310, "udp"},
{"messageservice",     {NULL}, 2311, "tcp"},
{"messageservice",     {NULL}, 2311, "udp"},
{"wanscaler",          {NULL}, 2312, "tcp"},
{"wanscaler",          {NULL}, 2312, "udp"},
{"iapp",               {NULL}, 2313, "tcp"},
{"iapp",               {NULL}, 2313, "udp"},
{"cr-websystems",      {NULL}, 2314, "tcp"},
{"cr-websystems",      {NULL}, 2314, "udp"},
{"precise-sft",        {NULL}, 2315, "tcp"},
{"precise-sft",        {NULL}, 2315, "udp"},
{"sent-lm",            {NULL}, 2316, "tcp"},
{"sent-lm",            {NULL}, 2316, "udp"},
{"attachmate-g32",     {NULL}, 2317, "tcp"},
{"attachmate-g32",     {NULL}, 2317, "udp"},
{"cadencecontrol",     {NULL}, 2318, "tcp"},
{"cadencecontrol",     {NULL}, 2318, "udp"},
{"infolibria",         {NULL}, 2319, "tcp"},
{"infolibria",         {NULL}, 2319, "udp"},
{"siebel-ns",          {NULL}, 2320, "tcp"},
{"siebel-ns",          {NULL}, 2320, "udp"},
{"rdlap",              {NULL}, 2321, "tcp"},
{"rdlap",              {NULL}, 2321, "udp"},
{"ofsd",               {NULL}, 2322, "tcp"},
{"ofsd",               {NULL}, 2322, "udp"},
{"3d-nfsd",            {NULL}, 2323, "tcp"},
{"3d-nfsd",            {NULL}, 2323, "udp"},
{"cosmocall",          {NULL}, 2324, "tcp"},
{"cosmocall",          {NULL}, 2324, "udp"},
{"ansysli",            {NULL}, 2325, "tcp"},
{"ansysli",            {NULL}, 2325, "udp"},
{"idcp",               {NULL}, 2326, "tcp"},
{"idcp",               {NULL}, 2326, "udp"},
{"xingcsm",            {NULL}, 2327, "tcp"},
{"xingcsm",            {NULL}, 2327, "udp"},
{"netrix-sftm",        {NULL}, 2328, "tcp"},
{"netrix-sftm",        {NULL}, 2328, "udp"},
{"nvd",                {NULL}, 2329, "tcp"},
{"nvd",                {NULL}, 2329, "udp"},
{"tscchat",            {NULL}, 2330, "tcp"},
{"tscchat",            {NULL}, 2330, "udp"},
{"agentview",          {NULL}, 2331, "tcp"},
{"agentview",          {NULL}, 2331, "udp"},
{"rcc-host",           {NULL}, 2332, "tcp"},
{"rcc-host",           {NULL}, 2332, "udp"},
{"snapp",              {NULL}, 2333, "tcp"},
{"snapp",              {NULL}, 2333, "udp"},
{"ace-client",         {NULL}, 2334, "tcp"},
{"ace-client",         {NULL}, 2334, "udp"},
{"ace-proxy",          {NULL}, 2335, "tcp"},
{"ace-proxy",          {NULL}, 2335, "udp"},
{"appleugcontrol",     {NULL}, 2336, "tcp"},
{"appleugcontrol",     {NULL}, 2336, "udp"},
{"ideesrv",            {NULL}, 2337, "tcp"},
{"ideesrv",            {NULL}, 2337, "udp"},
{"norton-lambert",     {NULL}, 2338, "tcp"},
{"norton-lambert",     {NULL}, 2338, "udp"},
{"3com-webview",       {NULL}, 2339, "tcp"},
{"3com-webview",       {NULL}, 2339, "udp"},
{"wrs_registry",       {NULL}, 2340, "tcp"},
{"wrs_registry",       {NULL}, 2340, "udp"},
{"xiostatus",          {NULL}, 2341, "tcp"},
{"xiostatus",          {NULL}, 2341, "udp"},
{"manage-exec",        {NULL}, 2342, "tcp"},
{"manage-exec",        {NULL}, 2342, "udp"},
{"nati-logos",         {NULL}, 2343, "tcp"},
{"nati-logos",         {NULL}, 2343, "udp"},
{"fcmsys",             {NULL}, 2344, "tcp"},
{"fcmsys",             {NULL}, 2344, "udp"},
{"dbm",                {NULL}, 2345, "tcp"},
{"dbm",                {NULL}, 2345, "udp"},
{"redstorm_join",      {NULL}, 2346, "tcp"},
{"redstorm_join",      {NULL}, 2346, "udp"},
{"redstorm_find",      {NULL}, 2347, "tcp"},
{"redstorm_find",      {NULL}, 2347, "udp"},
{"redstorm_info",      {NULL}, 2348, "tcp"},
{"redstorm_info",      {NULL}, 2348, "udp"},
{"redstorm_diag",      {NULL}, 2349, "tcp"},
{"redstorm_diag",      {NULL}, 2349, "udp"},
{"psbserver",          {NULL}, 2350, "tcp"},
{"psbserver",          {NULL}, 2350, "udp"},
{"psrserver",          {NULL}, 2351, "tcp"},
{"psrserver",          {NULL}, 2351, "udp"},
{"pslserver",          {NULL}, 2352, "tcp"},
{"pslserver",          {NULL}, 2352, "udp"},
{"pspserver",          {NULL}, 2353, "tcp"},
{"pspserver",          {NULL}, 2353, "udp"},
{"psprserver",         {NULL}, 2354, "tcp"},
{"psprserver",         {NULL}, 2354, "udp"},
{"psdbserver",         {NULL}, 2355, "tcp"},
{"psdbserver",         {NULL}, 2355, "udp"},
{"gxtelmd",            {NULL}, 2356, "tcp"},
{"gxtelmd",            {NULL}, 2356, "udp"},
{"unihub-server",      {NULL}, 2357, "tcp"},
{"unihub-server",      {NULL}, 2357, "udp"},
{"futrix",             {NULL}, 2358, "tcp"},
{"futrix",             {NULL}, 2358, "udp"},
{"flukeserver",        {NULL}, 2359, "tcp"},
{"flukeserver",        {NULL}, 2359, "udp"},
{"nexstorindltd",      {NULL}, 2360, "tcp"},
{"nexstorindltd",      {NULL}, 2360, "udp"},
{"tl1",                {NULL}, 2361, "tcp"},
{"tl1",                {NULL}, 2361, "udp"},
{"digiman",            {NULL}, 2362, "tcp"},
{"digiman",            {NULL}, 2362, "udp"},
{"mediacntrlnfsd",     {NULL}, 2363, "tcp"},
{"mediacntrlnfsd",     {NULL}, 2363, "udp"},
{"oi-2000",            {NULL}, 2364, "tcp"},
{"oi-2000",            {NULL}, 2364, "udp"},
{"dbref",              {NULL}, 2365, "tcp"},
{"dbref",              {NULL}, 2365, "udp"},
{"qip-login",          {NULL}, 2366, "tcp"},
{"qip-login",          {NULL}, 2366, "udp"},
{"service-ctrl",       {NULL}, 2367, "tcp"},
{"service-ctrl",       {NULL}, 2367, "udp"},
{"opentable",          {NULL}, 2368, "tcp"},
{"opentable",          {NULL}, 2368, "udp"},
{"l3-hbmon",           {NULL}, 2370, "tcp"},
{"l3-hbmon",           {NULL}, 2370, "udp"},
{"worldwire",          {NULL}, 2371, "tcp"},
{"worldwire",          {NULL}, 2371, "udp"},
{"lanmessenger",       {NULL}, 2372, "tcp"},
{"lanmessenger",       {NULL}, 2372, "udp"},
{"remographlm",        {NULL}, 2373, "tcp"},
{"hydra",              {NULL}, 2374, "tcp"},
{"compaq-https",       {NULL}, 2381, "tcp"},
{"compaq-https",       {NULL}, 2381, "udp"},
{"ms-olap3",           {NULL}, 2382, "tcp"},
{"ms-olap3",           {NULL}, 2382, "udp"},
{"ms-olap4",           {NULL}, 2383, "tcp"},
{"ms-olap4",           {NULL}, 2383, "udp"},
{"sd-request",         {NULL}, 2384, "tcp"},
{"sd-capacity",        {NULL}, 2384, "udp"},
{"sd-data",            {NULL}, 2385, "tcp"},
{"sd-data",            {NULL}, 2385, "udp"},
{"virtualtape",        {NULL}, 2386, "tcp"},
{"virtualtape",        {NULL}, 2386, "udp"},
{"vsamredirector",     {NULL}, 2387, "tcp"},
{"vsamredirector",     {NULL}, 2387, "udp"},
{"mynahautostart",     {NULL}, 2388, "tcp"},
{"mynahautostart",     {NULL}, 2388, "udp"},
{"ovsessionmgr",       {NULL}, 2389, "tcp"},
{"ovsessionmgr",       {NULL}, 2389, "udp"},
{"rsmtp",              {NULL}, 2390, "tcp"},
{"rsmtp",              {NULL}, 2390, "udp"},
{"3com-net-mgmt",      {NULL}, 2391, "tcp"},
{"3com-net-mgmt",      {NULL}, 2391, "udp"},
{"tacticalauth",       {NULL}, 2392, "tcp"},
{"tacticalauth",       {NULL}, 2392, "udp"},
{"ms-olap1",           {NULL}, 2393, "tcp"},
{"ms-olap1",           {NULL}, 2393, "udp"},
{"ms-olap2",           {NULL}, 2394, "tcp"},
{"ms-olap2",           {NULL}, 2394, "udp"},
{"lan900_remote",      {NULL}, 2395, "tcp"},
{"lan900_remote",      {NULL}, 2395, "udp"},
{"wusage",             {NULL}, 2396, "tcp"},
{"wusage",             {NULL}, 2396, "udp"},
{"ncl",                {NULL}, 2397, "tcp"},
{"ncl",                {NULL}, 2397, "udp"},
{"orbiter",            {NULL}, 2398, "tcp"},
{"orbiter",            {NULL}, 2398, "udp"},
{"fmpro-fdal",         {NULL}, 2399, "tcp"},
{"fmpro-fdal",         {NULL}, 2399, "udp"},
{"opequus-server",     {NULL}, 2400, "tcp"},
{"opequus-server",     {NULL}, 2400, "udp"},
{"cvspserver",         {NULL}, 2401, "tcp"},
{"cvspserver",         {NULL}, 2401, "udp"},
{"taskmaster2000",     {NULL}, 2402, "tcp"},
{"taskmaster2000",     {NULL}, 2402, "udp"},
{"taskmaster2000",     {NULL}, 2403, "tcp"},
{"taskmaster2000",     {NULL}, 2403, "udp"},
{"iec-104",            {NULL}, 2404, "tcp"},
{"iec-104",            {NULL}, 2404, "udp"},
{"trc-netpoll",        {NULL}, 2405, "tcp"},
{"trc-netpoll",        {NULL}, 2405, "udp"},
{"jediserver",         {NULL}, 2406, "tcp"},
{"jediserver",         {NULL}, 2406, "udp"},
{"orion",              {NULL}, 2407, "tcp"},
{"orion",              {NULL}, 2407, "udp"},
{"optimanet",          {NULL}, 2408, "tcp"},
{"optimanet",          {NULL}, 2408, "udp"},
{"sns-protocol",       {NULL}, 2409, "tcp"},
{"sns-protocol",       {NULL}, 2409, "udp"},
{"vrts-registry",      {NULL}, 2410, "tcp"},
{"vrts-registry",      {NULL}, 2410, "udp"},
{"netwave-ap-mgmt",    {NULL}, 2411, "tcp"},
{"netwave-ap-mgmt",    {NULL}, 2411, "udp"},
{"cdn",                {NULL}, 2412, "tcp"},
{"cdn",                {NULL}, 2412, "udp"},
{"orion-rmi-reg",      {NULL}, 2413, "tcp"},
{"orion-rmi-reg",      {NULL}, 2413, "udp"},
{"beeyond",            {NULL}, 2414, "tcp"},
{"beeyond",            {NULL}, 2414, "udp"},
{"codima-rtp",         {NULL}, 2415, "tcp"},
{"codima-rtp",         {NULL}, 2415, "udp"},
{"rmtserver",          {NULL}, 2416, "tcp"},
{"rmtserver",          {NULL}, 2416, "udp"},
{"composit-server",    {NULL}, 2417, "tcp"},
{"composit-server",    {NULL}, 2417, "udp"},
{"cas",                {NULL}, 2418, "tcp"},
{"cas",                {NULL}, 2418, "udp"},
{"attachmate-s2s",     {NULL}, 2419, "tcp"},
{"attachmate-s2s",     {NULL}, 2419, "udp"},
{"dslremote-mgmt",     {NULL}, 2420, "tcp"},
{"dslremote-mgmt",     {NULL}, 2420, "udp"},
{"g-talk",             {NULL}, 2421, "tcp"},
{"g-talk",             {NULL}, 2421, "udp"},
{"crmsbits",           {NULL}, 2422, "tcp"},
{"crmsbits",           {NULL}, 2422, "udp"},
{"rnrp",               {NULL}, 2423, "tcp"},
{"rnrp",               {NULL}, 2423, "udp"},
{"kofax-svr",          {NULL}, 2424, "tcp"},
{"kofax-svr",          {NULL}, 2424, "udp"},
{"fjitsuappmgr",       {NULL}, 2425, "tcp"},
{"fjitsuappmgr",       {NULL}, 2425, "udp"},
{"mgcp-gateway",       {NULL}, 2427, "tcp"},
{"mgcp-gateway",       {NULL}, 2427, "udp"},
{"ott",                {NULL}, 2428, "tcp"},
{"ott",                {NULL}, 2428, "udp"},
{"ft-role",            {NULL}, 2429, "tcp"},
{"ft-role",            {NULL}, 2429, "udp"},
{"venus",              {NULL}, 2430, "tcp"},
{"venus",              {NULL}, 2430, "udp"},
{"venus-se",           {NULL}, 2431, "tcp"},
{"venus-se",           {NULL}, 2431, "udp"},
{"codasrv",            {NULL}, 2432, "tcp"},
{"codasrv",            {NULL}, 2432, "udp"},
{"codasrv-se",         {NULL}, 2433, "tcp"},
{"codasrv-se",         {NULL}, 2433, "udp"},
{"pxc-epmap",          {NULL}, 2434, "tcp"},
{"pxc-epmap",          {NULL}, 2434, "udp"},
{"optilogic",          {NULL}, 2435, "tcp"},
{"optilogic",          {NULL}, 2435, "udp"},
{"topx",               {NULL}, 2436, "tcp"},
{"topx",               {NULL}, 2436, "udp"},
{"unicontrol",         {NULL}, 2437, "tcp"},
{"unicontrol",         {NULL}, 2437, "udp"},
{"msp",                {NULL}, 2438, "tcp"},
{"msp",                {NULL}, 2438, "udp"},
{"sybasedbsynch",      {NULL}, 2439, "tcp"},
{"sybasedbsynch",      {NULL}, 2439, "udp"},
{"spearway",           {NULL}, 2440, "tcp"},
{"spearway",           {NULL}, 2440, "udp"},
{"pvsw-inet",          {NULL}, 2441, "tcp"},
{"pvsw-inet",          {NULL}, 2441, "udp"},
{"netangel",           {NULL}, 2442, "tcp"},
{"netangel",           {NULL}, 2442, "udp"},
{"powerclientcsf",     {NULL}, 2443, "tcp"},
{"powerclientcsf",     {NULL}, 2443, "udp"},
{"btpp2sectrans",      {NULL}, 2444, "tcp"},
{"btpp2sectrans",      {NULL}, 2444, "udp"},
{"dtn1",               {NULL}, 2445, "tcp"},
{"dtn1",               {NULL}, 2445, "udp"},
{"bues_service",       {NULL}, 2446, "tcp"},
{"bues_service",       {NULL}, 2446, "udp"},
{"ovwdb",              {NULL}, 2447, "tcp"},
{"ovwdb",              {NULL}, 2447, "udp"},
{"hpppssvr",           {NULL}, 2448, "tcp"},
{"hpppssvr",           {NULL}, 2448, "udp"},
{"ratl",               {NULL}, 2449, "tcp"},
{"ratl",               {NULL}, 2449, "udp"},
{"netadmin",           {NULL}, 2450, "tcp"},
{"netadmin",           {NULL}, 2450, "udp"},
{"netchat",            {NULL}, 2451, "tcp"},
{"netchat",            {NULL}, 2451, "udp"},
{"snifferclient",      {NULL}, 2452, "tcp"},
{"snifferclient",      {NULL}, 2452, "udp"},
{"madge-ltd",          {NULL}, 2453, "tcp"},
{"madge-ltd",          {NULL}, 2453, "udp"},
{"indx-dds",           {NULL}, 2454, "tcp"},
{"indx-dds",           {NULL}, 2454, "udp"},
{"wago-io-system",     {NULL}, 2455, "tcp"},
{"wago-io-system",     {NULL}, 2455, "udp"},
{"altav-remmgt",       {NULL}, 2456, "tcp"},
{"altav-remmgt",       {NULL}, 2456, "udp"},
{"rapido-ip",          {NULL}, 2457, "tcp"},
{"rapido-ip",          {NULL}, 2457, "udp"},
{"griffin",            {NULL}, 2458, "tcp"},
{"griffin",            {NULL}, 2458, "udp"},
{"community",          {NULL}, 2459, "tcp"},
{"community",          {NULL}, 2459, "udp"},
{"ms-theater",         {NULL}, 2460, "tcp"},
{"ms-theater",         {NULL}, 2460, "udp"},
{"qadmifoper",         {NULL}, 2461, "tcp"},
{"qadmifoper",         {NULL}, 2461, "udp"},
{"qadmifevent",        {NULL}, 2462, "tcp"},
{"qadmifevent",        {NULL}, 2462, "udp"},
{"lsi-raid-mgmt",      {NULL}, 2463, "tcp"},
{"lsi-raid-mgmt",      {NULL}, 2463, "udp"},
{"direcpc-si",         {NULL}, 2464, "tcp"},
{"direcpc-si",         {NULL}, 2464, "udp"},
{"lbm",                {NULL}, 2465, "tcp"},
{"lbm",                {NULL}, 2465, "udp"},
{"lbf",                {NULL}, 2466, "tcp"},
{"lbf",                {NULL}, 2466, "udp"},
{"high-criteria",      {NULL}, 2467, "tcp"},
{"high-criteria",      {NULL}, 2467, "udp"},
{"qip-msgd",           {NULL}, 2468, "tcp"},
{"qip-msgd",           {NULL}, 2468, "udp"},
{"mti-tcs-comm",       {NULL}, 2469, "tcp"},
{"mti-tcs-comm",       {NULL}, 2469, "udp"},
{"taskman-port",       {NULL}, 2470, "tcp"},
{"taskman-port",       {NULL}, 2470, "udp"},
{"seaodbc",            {NULL}, 2471, "tcp"},
{"seaodbc",            {NULL}, 2471, "udp"},
{"c3",                 {NULL}, 2472, "tcp"},
{"c3",                 {NULL}, 2472, "udp"},
{"aker-cdp",           {NULL}, 2473, "tcp"},
{"aker-cdp",           {NULL}, 2473, "udp"},
{"vitalanalysis",      {NULL}, 2474, "tcp"},
{"vitalanalysis",      {NULL}, 2474, "udp"},
{"ace-server",         {NULL}, 2475, "tcp"},
{"ace-server",         {NULL}, 2475, "udp"},
{"ace-svr-prop",       {NULL}, 2476, "tcp"},
{"ace-svr-prop",       {NULL}, 2476, "udp"},
{"ssm-cvs",            {NULL}, 2477, "tcp"},
{"ssm-cvs",            {NULL}, 2477, "udp"},
{"ssm-cssps",          {NULL}, 2478, "tcp"},
{"ssm-cssps",          {NULL}, 2478, "udp"},
{"ssm-els",            {NULL}, 2479, "tcp"},
{"ssm-els",            {NULL}, 2479, "udp"},
{"powerexchange",      {NULL}, 2480, "tcp"},
{"powerexchange",      {NULL}, 2480, "udp"},
{"giop",               {NULL}, 2481, "tcp"},
{"giop",               {NULL}, 2481, "udp"},
{"giop-ssl",           {NULL}, 2482, "tcp"},
{"giop-ssl",           {NULL}, 2482, "udp"},
{"ttc",                {NULL}, 2483, "tcp"},
{"ttc",                {NULL}, 2483, "udp"},
{"ttc-ssl",            {NULL}, 2484, "tcp"},
{"ttc-ssl",            {NULL}, 2484, "udp"},
{"netobjects1",        {NULL}, 2485, "tcp"},
{"netobjects1",        {NULL}, 2485, "udp"},
{"netobjects2",        {NULL}, 2486, "tcp"},
{"netobjects2",        {NULL}, 2486, "udp"},
{"pns",                {NULL}, 2487, "tcp"},
{"pns",                {NULL}, 2487, "udp"},
{"moy-corp",           {NULL}, 2488, "tcp"},
{"moy-corp",           {NULL}, 2488, "udp"},
{"tsilb",              {NULL}, 2489, "tcp"},
{"tsilb",              {NULL}, 2489, "udp"},
{"qip-qdhcp",          {NULL}, 2490, "tcp"},
{"qip-qdhcp",          {NULL}, 2490, "udp"},
{"conclave-cpp",       {NULL}, 2491, "tcp"},
{"conclave-cpp",       {NULL}, 2491, "udp"},
{"groove",             {NULL}, 2492, "tcp"},
{"groove",             {NULL}, 2492, "udp"},
{"talarian-mqs",       {NULL}, 2493, "tcp"},
{"talarian-mqs",       {NULL}, 2493, "udp"},
{"bmc-ar",             {NULL}, 2494, "tcp"},
{"bmc-ar",             {NULL}, 2494, "udp"},
{"fast-rem-serv",      {NULL}, 2495, "tcp"},
{"fast-rem-serv",      {NULL}, 2495, "udp"},
{"dirgis",             {NULL}, 2496, "tcp"},
{"dirgis",             {NULL}, 2496, "udp"},
{"quaddb",             {NULL}, 2497, "tcp"},
{"quaddb",             {NULL}, 2497, "udp"},
{"odn-castraq",        {NULL}, 2498, "tcp"},
{"odn-castraq",        {NULL}, 2498, "udp"},
{"unicontrol",         {NULL}, 2499, "tcp"},
{"unicontrol",         {NULL}, 2499, "udp"},
{"rtsserv",            {NULL}, 2500, "tcp"},
{"rtsserv",            {NULL}, 2500, "udp"},
{"rtsclient",          {NULL}, 2501, "tcp"},
{"rtsclient",          {NULL}, 2501, "udp"},
{"kentrox-prot",       {NULL}, 2502, "tcp"},
{"kentrox-prot",       {NULL}, 2502, "udp"},
{"nms-dpnss",          {NULL}, 2503, "tcp"},
{"nms-dpnss",          {NULL}, 2503, "udp"},
{"wlbs",               {NULL}, 2504, "tcp"},
{"wlbs",               {NULL}, 2504, "udp"},
{"ppcontrol",          {NULL}, 2505, "tcp"},
{"ppcontrol",          {NULL}, 2505, "udp"},
{"jbroker",            {NULL}, 2506, "tcp"},
{"jbroker",            {NULL}, 2506, "udp"},
{"spock",              {NULL}, 2507, "tcp"},
{"spock",              {NULL}, 2507, "udp"},
{"jdatastore",         {NULL}, 2508, "tcp"},
{"jdatastore",         {NULL}, 2508, "udp"},
{"fjmpss",             {NULL}, 2509, "tcp"},
{"fjmpss",             {NULL}, 2509, "udp"},
{"fjappmgrbulk",       {NULL}, 2510, "tcp"},
{"fjappmgrbulk",       {NULL}, 2510, "udp"},
{"metastorm",          {NULL}, 2511, "tcp"},
{"metastorm",          {NULL}, 2511, "udp"},
{"citrixima",          {NULL}, 2512, "tcp"},
{"citrixima",          {NULL}, 2512, "udp"},
{"citrixadmin",        {NULL}, 2513, "tcp"},
{"citrixadmin",        {NULL}, 2513, "udp"},
{"facsys-ntp",         {NULL}, 2514, "tcp"},
{"facsys-ntp",         {NULL}, 2514, "udp"},
{"facsys-router",      {NULL}, 2515, "tcp"},
{"facsys-router",      {NULL}, 2515, "udp"},
{"maincontrol",        {NULL}, 2516, "tcp"},
{"maincontrol",        {NULL}, 2516, "udp"},
{"call-sig-trans",     {NULL}, 2517, "tcp"},
{"call-sig-trans",     {NULL}, 2517, "udp"},
{"willy",              {NULL}, 2518, "tcp"},
{"willy",              {NULL}, 2518, "udp"},
{"globmsgsvc",         {NULL}, 2519, "tcp"},
{"globmsgsvc",         {NULL}, 2519, "udp"},
{"pvsw",               {NULL}, 2520, "tcp"},
{"pvsw",               {NULL}, 2520, "udp"},
{"adaptecmgr",         {NULL}, 2521, "tcp"},
{"adaptecmgr",         {NULL}, 2521, "udp"},
{"windb",              {NULL}, 2522, "tcp"},
{"windb",              {NULL}, 2522, "udp"},
{"qke-llc-v3",         {NULL}, 2523, "tcp"},
{"qke-llc-v3",         {NULL}, 2523, "udp"},
{"optiwave-lm",        {NULL}, 2524, "tcp"},
{"optiwave-lm",        {NULL}, 2524, "udp"},
{"ms-v-worlds",        {NULL}, 2525, "tcp"},
{"ms-v-worlds",        {NULL}, 2525, "udp"},
{"ema-sent-lm",        {NULL}, 2526, "tcp"},
{"ema-sent-lm",        {NULL}, 2526, "udp"},
{"iqserver",           {NULL}, 2527, "tcp"},
{"iqserver",           {NULL}, 2527, "udp"},
{"ncr_ccl",            {NULL}, 2528, "tcp"},
{"ncr_ccl",            {NULL}, 2528, "udp"},
{"utsftp",             {NULL}, 2529, "tcp"},
{"utsftp",             {NULL}, 2529, "udp"},
{"vrcommerce",         {NULL}, 2530, "tcp"},
{"vrcommerce",         {NULL}, 2530, "udp"},
{"ito-e-gui",          {NULL}, 2531, "tcp"},
{"ito-e-gui",          {NULL}, 2531, "udp"},
{"ovtopmd",            {NULL}, 2532, "tcp"},
{"ovtopmd",            {NULL}, 2532, "udp"},
{"snifferserver",      {NULL}, 2533, "tcp"},
{"snifferserver",      {NULL}, 2533, "udp"},
{"combox-web-acc",     {NULL}, 2534, "tcp"},
{"combox-web-acc",     {NULL}, 2534, "udp"},
{"madcap",             {NULL}, 2535, "tcp"},
{"madcap",             {NULL}, 2535, "udp"},
{"btpp2audctr1",       {NULL}, 2536, "tcp"},
{"btpp2audctr1",       {NULL}, 2536, "udp"},
{"upgrade",            {NULL}, 2537, "tcp"},
{"upgrade",            {NULL}, 2537, "udp"},
{"vnwk-prapi",         {NULL}, 2538, "tcp"},
{"vnwk-prapi",         {NULL}, 2538, "udp"},
{"vsiadmin",           {NULL}, 2539, "tcp"},
{"vsiadmin",           {NULL}, 2539, "udp"},
{"lonworks",           {NULL}, 2540, "tcp"},
{"lonworks",           {NULL}, 2540, "udp"},
{"lonworks2",          {NULL}, 2541, "tcp"},
{"lonworks2",          {NULL}, 2541, "udp"},
{"udrawgraph",         {NULL}, 2542, "tcp"},
{"udrawgraph",         {NULL}, 2542, "udp"},
{"reftek",             {NULL}, 2543, "tcp"},
{"reftek",             {NULL}, 2543, "udp"},
{"novell-zen",         {NULL}, 2544, "tcp"},
{"novell-zen",         {NULL}, 2544, "udp"},
{"sis-emt",            {NULL}, 2545, "tcp"},
{"sis-emt",            {NULL}, 2545, "udp"},
{"vytalvaultbrtp",     {NULL}, 2546, "tcp"},
{"vytalvaultbrtp",     {NULL}, 2546, "udp"},
{"vytalvaultvsmp",     {NULL}, 2547, "tcp"},
{"vytalvaultvsmp",     {NULL}, 2547, "udp"},
{"vytalvaultpipe",     {NULL}, 2548, "tcp"},
{"vytalvaultpipe",     {NULL}, 2548, "udp"},
{"ipass",              {NULL}, 2549, "tcp"},
{"ipass",              {NULL}, 2549, "udp"},
{"ads",                {NULL}, 2550, "tcp"},
{"ads",                {NULL}, 2550, "udp"},
{"isg-uda-server",     {NULL}, 2551, "tcp"},
{"isg-uda-server",     {NULL}, 2551, "udp"},
{"call-logging",       {NULL}, 2552, "tcp"},
{"call-logging",       {NULL}, 2552, "udp"},
{"efidiningport",      {NULL}, 2553, "tcp"},
{"efidiningport",      {NULL}, 2553, "udp"},
{"vcnet-link-v10",     {NULL}, 2554, "tcp"},
{"vcnet-link-v10",     {NULL}, 2554, "udp"},
{"compaq-wcp",         {NULL}, 2555, "tcp"},
{"compaq-wcp",         {NULL}, 2555, "udp"},
{"nicetec-nmsvc",      {NULL}, 2556, "tcp"},
{"nicetec-nmsvc",      {NULL}, 2556, "udp"},
{"nicetec-mgmt",       {NULL}, 2557, "tcp"},
{"nicetec-mgmt",       {NULL}, 2557, "udp"},
{"pclemultimedia",     {NULL}, 2558, "tcp"},
{"pclemultimedia",     {NULL}, 2558, "udp"},
{"lstp",               {NULL}, 2559, "tcp"},
{"lstp",               {NULL}, 2559, "udp"},
{"labrat",             {NULL}, 2560, "tcp"},
{"labrat",             {NULL}, 2560, "udp"},
{"mosaixcc",           {NULL}, 2561, "tcp"},
{"mosaixcc",           {NULL}, 2561, "udp"},
{"delibo",             {NULL}, 2562, "tcp"},
{"delibo",             {NULL}, 2562, "udp"},
{"cti-redwood",        {NULL}, 2563, "tcp"},
{"cti-redwood",        {NULL}, 2563, "udp"},
{"hp-3000-telnet",     {NULL}, 2564, "tcp"},
{"coord-svr",          {NULL}, 2565, "tcp"},
{"coord-svr",          {NULL}, 2565, "udp"},
{"pcs-pcw",            {NULL}, 2566, "tcp"},
{"pcs-pcw",            {NULL}, 2566, "udp"},
{"clp",                {NULL}, 2567, "tcp"},
{"clp",                {NULL}, 2567, "udp"},
{"spamtrap",           {NULL}, 2568, "tcp"},
{"spamtrap",           {NULL}, 2568, "udp"},
{"sonuscallsig",       {NULL}, 2569, "tcp"},
{"sonuscallsig",       {NULL}, 2569, "udp"},
{"hs-port",            {NULL}, 2570, "tcp"},
{"hs-port",            {NULL}, 2570, "udp"},
{"cecsvc",             {NULL}, 2571, "tcp"},
{"cecsvc",             {NULL}, 2571, "udp"},
{"ibp",                {NULL}, 2572, "tcp"},
{"ibp",                {NULL}, 2572, "udp"},
{"trustestablish",     {NULL}, 2573, "tcp"},
{"trustestablish",     {NULL}, 2573, "udp"},
{"blockade-bpsp",      {NULL}, 2574, "tcp"},
{"blockade-bpsp",      {NULL}, 2574, "udp"},
{"hl7",                {NULL}, 2575, "tcp"},
{"hl7",                {NULL}, 2575, "udp"},
{"tclprodebugger",     {NULL}, 2576, "tcp"},
{"tclprodebugger",     {NULL}, 2576, "udp"},
{"scipticslsrvr",      {NULL}, 2577, "tcp"},
{"scipticslsrvr",      {NULL}, 2577, "udp"},
{"rvs-isdn-dcp",       {NULL}, 2578, "tcp"},
{"rvs-isdn-dcp",       {NULL}, 2578, "udp"},
{"mpfoncl",            {NULL}, 2579, "tcp"},
{"mpfoncl",            {NULL}, 2579, "udp"},
{"tributary",          {NULL}, 2580, "tcp"},
{"tributary",          {NULL}, 2580, "udp"},
{"argis-te",           {NULL}, 2581, "tcp"},
{"argis-te",           {NULL}, 2581, "udp"},
{"argis-ds",           {NULL}, 2582, "tcp"},
{"argis-ds",           {NULL}, 2582, "udp"},
{"mon",                {NULL}, 2583, "tcp"},
{"mon",                {NULL}, 2583, "udp"},
{"cyaserv",            {NULL}, 2584, "tcp"},
{"cyaserv",            {NULL}, 2584, "udp"},
{"netx-server",        {NULL}, 2585, "tcp"},
{"netx-server",        {NULL}, 2585, "udp"},
{"netx-agent",         {NULL}, 2586, "tcp"},
{"netx-agent",         {NULL}, 2586, "udp"},
{"masc",               {NULL}, 2587, "tcp"},
{"masc",               {NULL}, 2587, "udp"},
{"privilege",          {NULL}, 2588, "tcp"},
{"privilege",          {NULL}, 2588, "udp"},
{"quartus-tcl",        {NULL}, 2589, "tcp"},
{"quartus-tcl",        {NULL}, 2589, "udp"},
{"idotdist",           {NULL}, 2590, "tcp"},
{"idotdist",           {NULL}, 2590, "udp"},
{"maytagshuffle",      {NULL}, 2591, "tcp"},
{"maytagshuffle",      {NULL}, 2591, "udp"},
{"netrek",             {NULL}, 2592, "tcp"},
{"netrek",             {NULL}, 2592, "udp"},
{"mns-mail",           {NULL}, 2593, "tcp"},
{"mns-mail",           {NULL}, 2593, "udp"},
{"dts",                {NULL}, 2594, "tcp"},
{"dts",                {NULL}, 2594, "udp"},
{"worldfusion1",       {NULL}, 2595, "tcp"},
{"worldfusion1",       {NULL}, 2595, "udp"},
{"worldfusion2",       {NULL}, 2596, "tcp"},
{"worldfusion2",       {NULL}, 2596, "udp"},
{"homesteadglory",     {NULL}, 2597, "tcp"},
{"homesteadglory",     {NULL}, 2597, "udp"},
{"citriximaclient",    {NULL}, 2598, "tcp"},
{"citriximaclient",    {NULL}, 2598, "udp"},
{"snapd",              {NULL}, 2599, "tcp"},
{"snapd",              {NULL}, 2599, "udp"},
{"hpstgmgr",           {NULL}, 2600, "tcp"},
{"hpstgmgr",           {NULL}, 2600, "udp"},
{"discp-client",       {NULL}, 2601, "tcp"},
{"discp-client",       {NULL}, 2601, "udp"},
{"discp-server",       {NULL}, 2602, "tcp"},
{"discp-server",       {NULL}, 2602, "udp"},
{"servicemeter",       {NULL}, 2603, "tcp"},
{"servicemeter",       {NULL}, 2603, "udp"},
{"nsc-ccs",            {NULL}, 2604, "tcp"},
{"nsc-ccs",            {NULL}, 2604, "udp"},
{"nsc-posa",           {NULL}, 2605, "tcp"},
{"nsc-posa",           {NULL}, 2605, "udp"},
{"netmon",             {NULL}, 2606, "tcp"},
{"netmon",             {NULL}, 2606, "udp"},
{"connection",         {NULL}, 2607, "tcp"},
{"connection",         {NULL}, 2607, "udp"},
{"wag-service",        {NULL}, 2608, "tcp"},
{"wag-service",        {NULL}, 2608, "udp"},
{"system-monitor",     {NULL}, 2609, "tcp"},
{"system-monitor",     {NULL}, 2609, "udp"},
{"versa-tek",          {NULL}, 2610, "tcp"},
{"versa-tek",          {NULL}, 2610, "udp"},
{"lionhead",           {NULL}, 2611, "tcp"},
{"lionhead",           {NULL}, 2611, "udp"},
{"qpasa-agent",        {NULL}, 2612, "tcp"},
{"qpasa-agent",        {NULL}, 2612, "udp"},
{"smntubootstrap",     {NULL}, 2613, "tcp"},
{"smntubootstrap",     {NULL}, 2613, "udp"},
{"neveroffline",       {NULL}, 2614, "tcp"},
{"neveroffline",       {NULL}, 2614, "udp"},
{"firepower",          {NULL}, 2615, "tcp"},
{"firepower",          {NULL}, 2615, "udp"},
{"appswitch-emp",      {NULL}, 2616, "tcp"},
{"appswitch-emp",      {NULL}, 2616, "udp"},
{"cmadmin",            {NULL}, 2617, "tcp"},
{"cmadmin",            {NULL}, 2617, "udp"},
{"priority-e-com",     {NULL}, 2618, "tcp"},
{"priority-e-com",     {NULL}, 2618, "udp"},
{"bruce",              {NULL}, 2619, "tcp"},
{"bruce",              {NULL}, 2619, "udp"},
{"lpsrecommender",     {NULL}, 2620, "tcp"},
{"lpsrecommender",     {NULL}, 2620, "udp"},
{"miles-apart",        {NULL}, 2621, "tcp"},
{"miles-apart",        {NULL}, 2621, "udp"},
{"metricadbc",         {NULL}, 2622, "tcp"},
{"metricadbc",         {NULL}, 2622, "udp"},
{"lmdp",               {NULL}, 2623, "tcp"},
{"lmdp",               {NULL}, 2623, "udp"},
{"aria",               {NULL}, 2624, "tcp"},
{"aria",               {NULL}, 2624, "udp"},
{"blwnkl-port",        {NULL}, 2625, "tcp"},
{"blwnkl-port",        {NULL}, 2625, "udp"},
{"gbjd816",            {NULL}, 2626, "tcp"},
{"gbjd816",            {NULL}, 2626, "udp"},
{"moshebeeri",         {NULL}, 2627, "tcp"},
{"moshebeeri",         {NULL}, 2627, "udp"},
{"dict",               {NULL}, 2628, "tcp"},
{"dict",               {NULL}, 2628, "udp"},
{"sitaraserver",       {NULL}, 2629, "tcp"},
{"sitaraserver",       {NULL}, 2629, "udp"},
{"sitaramgmt",         {NULL}, 2630, "tcp"},
{"sitaramgmt",         {NULL}, 2630, "udp"},
{"sitaradir",          {NULL}, 2631, "tcp"},
{"sitaradir",          {NULL}, 2631, "udp"},
{"irdg-post",          {NULL}, 2632, "tcp"},
{"irdg-post",          {NULL}, 2632, "udp"},
{"interintelli",       {NULL}, 2633, "tcp"},
{"interintelli",       {NULL}, 2633, "udp"},
{"pk-electronics",     {NULL}, 2634, "tcp"},
{"pk-electronics",     {NULL}, 2634, "udp"},
{"backburner",         {NULL}, 2635, "tcp"},
{"backburner",         {NULL}, 2635, "udp"},
{"solve",              {NULL}, 2636, "tcp"},
{"solve",              {NULL}, 2636, "udp"},
{"imdocsvc",           {NULL}, 2637, "tcp"},
{"imdocsvc",           {NULL}, 2637, "udp"},
{"sybaseanywhere",     {NULL}, 2638, "tcp"},
{"sybaseanywhere",     {NULL}, 2638, "udp"},
{"aminet",             {NULL}, 2639, "tcp"},
{"aminet",             {NULL}, 2639, "udp"},
{"sai_sentlm",         {NULL}, 2640, "tcp"},
{"sai_sentlm",         {NULL}, 2640, "udp"},
{"hdl-srv",            {NULL}, 2641, "tcp"},
{"hdl-srv",            {NULL}, 2641, "udp"},
{"tragic",             {NULL}, 2642, "tcp"},
{"tragic",             {NULL}, 2642, "udp"},
{"gte-samp",           {NULL}, 2643, "tcp"},
{"gte-samp",           {NULL}, 2643, "udp"},
{"travsoft-ipx-t",     {NULL}, 2644, "tcp"},
{"travsoft-ipx-t",     {NULL}, 2644, "udp"},
{"novell-ipx-cmd",     {NULL}, 2645, "tcp"},
{"novell-ipx-cmd",     {NULL}, 2645, "udp"},
{"and-lm",             {NULL}, 2646, "tcp"},
{"and-lm",             {NULL}, 2646, "udp"},
{"syncserver",         {NULL}, 2647, "tcp"},
{"syncserver",         {NULL}, 2647, "udp"},
{"upsnotifyprot",      {NULL}, 2648, "tcp"},
{"upsnotifyprot",      {NULL}, 2648, "udp"},
{"vpsipport",          {NULL}, 2649, "tcp"},
{"vpsipport",          {NULL}, 2649, "udp"},
{"eristwoguns",        {NULL}, 2650, "tcp"},
{"eristwoguns",        {NULL}, 2650, "udp"},
{"ebinsite",           {NULL}, 2651, "tcp"},
{"ebinsite",           {NULL}, 2651, "udp"},
{"interpathpanel",     {NULL}, 2652, "tcp"},
{"interpathpanel",     {NULL}, 2652, "udp"},
{"sonus",              {NULL}, 2653, "tcp"},
{"sonus",              {NULL}, 2653, "udp"},
{"corel_vncadmin",     {NULL}, 2654, "tcp"},
{"corel_vncadmin",     {NULL}, 2654, "udp"},
{"unglue",             {NULL}, 2655, "tcp"},
{"unglue",             {NULL}, 2655, "udp"},
{"kana",               {NULL}, 2656, "tcp"},
{"kana",               {NULL}, 2656, "udp"},
{"sns-dispatcher",     {NULL}, 2657, "tcp"},
{"sns-dispatcher",     {NULL}, 2657, "udp"},
{"sns-admin",          {NULL}, 2658, "tcp"},
{"sns-admin",          {NULL}, 2658, "udp"},
{"sns-query",          {NULL}, 2659, "tcp"},
{"sns-query",          {NULL}, 2659, "udp"},
{"gcmonitor",          {NULL}, 2660, "tcp"},
{"gcmonitor",          {NULL}, 2660, "udp"},
{"olhost",             {NULL}, 2661, "tcp"},
{"olhost",             {NULL}, 2661, "udp"},
{"bintec-capi",        {NULL}, 2662, "tcp"},
{"bintec-capi",        {NULL}, 2662, "udp"},
{"bintec-tapi",        {NULL}, 2663, "tcp"},
{"bintec-tapi",        {NULL}, 2663, "udp"},
{"patrol-mq-gm",       {NULL}, 2664, "tcp"},
{"patrol-mq-gm",       {NULL}, 2664, "udp"},
{"patrol-mq-nm",       {NULL}, 2665, "tcp"},
{"patrol-mq-nm",       {NULL}, 2665, "udp"},
{"extensis",           {NULL}, 2666, "tcp"},
{"extensis",           {NULL}, 2666, "udp"},
{"alarm-clock-s",      {NULL}, 2667, "tcp"},
{"alarm-clock-s",      {NULL}, 2667, "udp"},
{"alarm-clock-c",      {NULL}, 2668, "tcp"},
{"alarm-clock-c",      {NULL}, 2668, "udp"},
{"toad",               {NULL}, 2669, "tcp"},
{"toad",               {NULL}, 2669, "udp"},
{"tve-announce",       {NULL}, 2670, "tcp"},
{"tve-announce",       {NULL}, 2670, "udp"},
{"newlixreg",          {NULL}, 2671, "tcp"},
{"newlixreg",          {NULL}, 2671, "udp"},
{"nhserver",           {NULL}, 2672, "tcp"},
{"nhserver",           {NULL}, 2672, "udp"},
{"firstcall42",        {NULL}, 2673, "tcp"},
{"firstcall42",        {NULL}, 2673, "udp"},
{"ewnn",               {NULL}, 2674, "tcp"},
{"ewnn",               {NULL}, 2674, "udp"},
{"ttc-etap",           {NULL}, 2675, "tcp"},
{"ttc-etap",           {NULL}, 2675, "udp"},
{"simslink",           {NULL}, 2676, "tcp"},
{"simslink",           {NULL}, 2676, "udp"},
{"gadgetgate1way",     {NULL}, 2677, "tcp"},
{"gadgetgate1way",     {NULL}, 2677, "udp"},
{"gadgetgate2way",     {NULL}, 2678, "tcp"},
{"gadgetgate2way",     {NULL}, 2678, "udp"},
{"syncserverssl",      {NULL}, 2679, "tcp"},
{"syncserverssl",      {NULL}, 2679, "udp"},
{"pxc-sapxom",         {NULL}, 2680, "tcp"},
{"pxc-sapxom",         {NULL}, 2680, "udp"},
{"mpnjsomb",           {NULL}, 2681, "tcp"},
{"mpnjsomb",           {NULL}, 2681, "udp"},
{"ncdloadbalance",     {NULL}, 2683, "tcp"},
{"ncdloadbalance",     {NULL}, 2683, "udp"},
{"mpnjsosv",           {NULL}, 2684, "tcp"},
{"mpnjsosv",           {NULL}, 2684, "udp"},
{"mpnjsocl",           {NULL}, 2685, "tcp"},
{"mpnjsocl",           {NULL}, 2685, "udp"},
{"mpnjsomg",           {NULL}, 2686, "tcp"},
{"mpnjsomg",           {NULL}, 2686, "udp"},
{"pq-lic-mgmt",        {NULL}, 2687, "tcp"},
{"pq-lic-mgmt",        {NULL}, 2687, "udp"},
{"md-cg-http",         {NULL}, 2688, "tcp"},
{"md-cg-http",         {NULL}, 2688, "udp"},
{"fastlynx",           {NULL}, 2689, "tcp"},
{"fastlynx",           {NULL}, 2689, "udp"},
{"hp-nnm-data",        {NULL}, 2690, "tcp"},
{"hp-nnm-data",        {NULL}, 2690, "udp"},
{"itinternet",         {NULL}, 2691, "tcp"},
{"itinternet",         {NULL}, 2691, "udp"},
{"admins-lms",         {NULL}, 2692, "tcp"},
{"admins-lms",         {NULL}, 2692, "udp"},
{"pwrsevent",          {NULL}, 2694, "tcp"},
{"pwrsevent",          {NULL}, 2694, "udp"},
{"vspread",            {NULL}, 2695, "tcp"},
{"vspread",            {NULL}, 2695, "udp"},
{"unifyadmin",         {NULL}, 2696, "tcp"},
{"unifyadmin",         {NULL}, 2696, "udp"},
{"oce-snmp-trap",      {NULL}, 2697, "tcp"},
{"oce-snmp-trap",      {NULL}, 2697, "udp"},
{"mck-ivpip",          {NULL}, 2698, "tcp"},
{"mck-ivpip",          {NULL}, 2698, "udp"},
{"csoft-plusclnt",     {NULL}, 2699, "tcp"},
{"csoft-plusclnt",     {NULL}, 2699, "udp"},
{"tqdata",             {NULL}, 2700, "tcp"},
{"tqdata",             {NULL}, 2700, "udp"},
{"sms-rcinfo",         {NULL}, 2701, "tcp"},
{"sms-rcinfo",         {NULL}, 2701, "udp"},
{"sms-xfer",           {NULL}, 2702, "tcp"},
{"sms-xfer",           {NULL}, 2702, "udp"},
{"sms-chat",           {NULL}, 2703, "tcp"},
{"sms-chat",           {NULL}, 2703, "udp"},
{"sms-remctrl",        {NULL}, 2704, "tcp"},
{"sms-remctrl",        {NULL}, 2704, "udp"},
{"sds-admin",          {NULL}, 2705, "tcp"},
{"sds-admin",          {NULL}, 2705, "udp"},
{"ncdmirroring",       {NULL}, 2706, "tcp"},
{"ncdmirroring",       {NULL}, 2706, "udp"},
{"emcsymapiport",      {NULL}, 2707, "tcp"},
{"emcsymapiport",      {NULL}, 2707, "udp"},
{"banyan-net",         {NULL}, 2708, "tcp"},
{"banyan-net",         {NULL}, 2708, "udp"},
{"supermon",           {NULL}, 2709, "tcp"},
{"supermon",           {NULL}, 2709, "udp"},
{"sso-service",        {NULL}, 2710, "tcp"},
{"sso-service",        {NULL}, 2710, "udp"},
{"sso-control",        {NULL}, 2711, "tcp"},
{"sso-control",        {NULL}, 2711, "udp"},
{"aocp",               {NULL}, 2712, "tcp"},
{"aocp",               {NULL}, 2712, "udp"},
{"raventbs",           {NULL}, 2713, "tcp"},
{"raventbs",           {NULL}, 2713, "udp"},
{"raventdm",           {NULL}, 2714, "tcp"},
{"raventdm",           {NULL}, 2714, "udp"},
{"hpstgmgr2",          {NULL}, 2715, "tcp"},
{"hpstgmgr2",          {NULL}, 2715, "udp"},
{"inova-ip-disco",     {NULL}, 2716, "tcp"},
{"inova-ip-disco",     {NULL}, 2716, "udp"},
{"pn-requester",       {NULL}, 2717, "tcp"},
{"pn-requester",       {NULL}, 2717, "udp"},
{"pn-requester2",      {NULL}, 2718, "tcp"},
{"pn-requester2",      {NULL}, 2718, "udp"},
{"scan-change",        {NULL}, 2719, "tcp"},
{"scan-change",        {NULL}, 2719, "udp"},
{"wkars",              {NULL}, 2720, "tcp"},
{"wkars",              {NULL}, 2720, "udp"},
{"smart-diagnose",     {NULL}, 2721, "tcp"},
{"smart-diagnose",     {NULL}, 2721, "udp"},
{"proactivesrvr",      {NULL}, 2722, "tcp"},
{"proactivesrvr",      {NULL}, 2722, "udp"},
{"watchdog-nt",        {NULL}, 2723, "tcp"},
{"watchdog-nt",        {NULL}, 2723, "udp"},
{"qotps",              {NULL}, 2724, "tcp"},
{"qotps",              {NULL}, 2724, "udp"},
{"msolap-ptp2",        {NULL}, 2725, "tcp"},
{"msolap-ptp2",        {NULL}, 2725, "udp"},
{"tams",               {NULL}, 2726, "tcp"},
{"tams",               {NULL}, 2726, "udp"},
{"mgcp-callagent",     {NULL}, 2727, "tcp"},
{"mgcp-callagent",     {NULL}, 2727, "udp"},
{"sqdr",               {NULL}, 2728, "tcp"},
{"sqdr",               {NULL}, 2728, "udp"},
{"tcim-control",       {NULL}, 2729, "tcp"},
{"tcim-control",       {NULL}, 2729, "udp"},
{"nec-raidplus",       {NULL}, 2730, "tcp"},
{"nec-raidplus",       {NULL}, 2730, "udp"},
{"fyre-messanger",     {NULL}, 2731, "tcp"},
{"fyre-messanger",     {NULL}, 2731, "udp"},
{"g5m",                {NULL}, 2732, "tcp"},
{"g5m",                {NULL}, 2732, "udp"},
{"signet-ctf",         {NULL}, 2733, "tcp"},
{"signet-ctf",         {NULL}, 2733, "udp"},
{"ccs-software",       {NULL}, 2734, "tcp"},
{"ccs-software",       {NULL}, 2734, "udp"},
{"netiq-mc",           {NULL}, 2735, "tcp"},
{"netiq-mc",           {NULL}, 2735, "udp"},
{"radwiz-nms-srv",     {NULL}, 2736, "tcp"},
{"radwiz-nms-srv",     {NULL}, 2736, "udp"},
{"srp-feedback",       {NULL}, 2737, "tcp"},
{"srp-feedback",       {NULL}, 2737, "udp"},
{"ndl-tcp-ois-gw",     {NULL}, 2738, "tcp"},
{"ndl-tcp-ois-gw",     {NULL}, 2738, "udp"},
{"tn-timing",          {NULL}, 2739, "tcp"},
{"tn-timing",          {NULL}, 2739, "udp"},
{"alarm",              {NULL}, 2740, "tcp"},
{"alarm",              {NULL}, 2740, "udp"},
{"tsb",                {NULL}, 2741, "tcp"},
{"tsb",                {NULL}, 2741, "udp"},
{"tsb2",               {NULL}, 2742, "tcp"},
{"tsb2",               {NULL}, 2742, "udp"},
{"murx",               {NULL}, 2743, "tcp"},
{"murx",               {NULL}, 2743, "udp"},
{"honyaku",            {NULL}, 2744, "tcp"},
{"honyaku",            {NULL}, 2744, "udp"},
{"urbisnet",           {NULL}, 2745, "tcp"},
{"urbisnet",           {NULL}, 2745, "udp"},
{"cpudpencap",         {NULL}, 2746, "tcp"},
{"cpudpencap",         {NULL}, 2746, "udp"},
{"fjippol-swrly",      {NULL}, 2747, "tcp"},
{"fjippol-swrly",      {NULL}, 2747, "udp"},
{"fjippol-polsvr",     {NULL}, 2748, "tcp"},
{"fjippol-polsvr",     {NULL}, 2748, "udp"},
{"fjippol-cnsl",       {NULL}, 2749, "tcp"},
{"fjippol-cnsl",       {NULL}, 2749, "udp"},
{"fjippol-port1",      {NULL}, 2750, "tcp"},
{"fjippol-port1",      {NULL}, 2750, "udp"},
{"fjippol-port2",      {NULL}, 2751, "tcp"},
{"fjippol-port2",      {NULL}, 2751, "udp"},
{"rsisysaccess",       {NULL}, 2752, "tcp"},
{"rsisysaccess",       {NULL}, 2752, "udp"},
{"de-spot",            {NULL}, 2753, "tcp"},
{"de-spot",            {NULL}, 2753, "udp"},
{"apollo-cc",          {NULL}, 2754, "tcp"},
{"apollo-cc",          {NULL}, 2754, "udp"},
{"expresspay",         {NULL}, 2755, "tcp"},
{"expresspay",         {NULL}, 2755, "udp"},
{"simplement-tie",     {NULL}, 2756, "tcp"},
{"simplement-tie",     {NULL}, 2756, "udp"},
{"cnrp",               {NULL}, 2757, "tcp"},
{"cnrp",               {NULL}, 2757, "udp"},
{"apollo-status",      {NULL}, 2758, "tcp"},
{"apollo-status",      {NULL}, 2758, "udp"},
{"apollo-gms",         {NULL}, 2759, "tcp"},
{"apollo-gms",         {NULL}, 2759, "udp"},
{"sabams",             {NULL}, 2760, "tcp"},
{"sabams",             {NULL}, 2760, "udp"},
{"dicom-iscl",         {NULL}, 2761, "tcp"},
{"dicom-iscl",         {NULL}, 2761, "udp"},
{"dicom-tls",          {NULL}, 2762, "tcp"},
{"dicom-tls",          {NULL}, 2762, "udp"},
{"desktop-dna",        {NULL}, 2763, "tcp"},
{"desktop-dna",        {NULL}, 2763, "udp"},
{"data-insurance",     {NULL}, 2764, "tcp"},
{"data-insurance",     {NULL}, 2764, "udp"},
{"qip-audup",          {NULL}, 2765, "tcp"},
{"qip-audup",          {NULL}, 2765, "udp"},
{"compaq-scp",         {NULL}, 2766, "tcp"},
{"compaq-scp",         {NULL}, 2766, "udp"},
{"uadtc",              {NULL}, 2767, "tcp"},
{"uadtc",              {NULL}, 2767, "udp"},
{"uacs",               {NULL}, 2768, "tcp"},
{"uacs",               {NULL}, 2768, "udp"},
{"exce",               {NULL}, 2769, "tcp"},
{"exce",               {NULL}, 2769, "udp"},
{"veronica",           {NULL}, 2770, "tcp"},
{"veronica",           {NULL}, 2770, "udp"},
{"vergencecm",         {NULL}, 2771, "tcp"},
{"vergencecm",         {NULL}, 2771, "udp"},
{"auris",              {NULL}, 2772, "tcp"},
{"auris",              {NULL}, 2772, "udp"},
{"rbakcup1",           {NULL}, 2773, "tcp"},
{"rbakcup1",           {NULL}, 2773, "udp"},
{"rbakcup2",           {NULL}, 2774, "tcp"},
{"rbakcup2",           {NULL}, 2774, "udp"},
{"smpp",               {NULL}, 2775, "tcp"},
{"smpp",               {NULL}, 2775, "udp"},
{"ridgeway1",          {NULL}, 2776, "tcp"},
{"ridgeway1",          {NULL}, 2776, "udp"},
{"ridgeway2",          {NULL}, 2777, "tcp"},
{"ridgeway2",          {NULL}, 2777, "udp"},
{"gwen-sonya",         {NULL}, 2778, "tcp"},
{"gwen-sonya",         {NULL}, 2778, "udp"},
{"lbc-sync",           {NULL}, 2779, "tcp"},
{"lbc-sync",           {NULL}, 2779, "udp"},
{"lbc-control",        {NULL}, 2780, "tcp"},
{"lbc-control",        {NULL}, 2780, "udp"},
{"whosells",           {NULL}, 2781, "tcp"},
{"whosells",           {NULL}, 2781, "udp"},
{"everydayrc",         {NULL}, 2782, "tcp"},
{"everydayrc",         {NULL}, 2782, "udp"},
{"aises",              {NULL}, 2783, "tcp"},
{"aises",              {NULL}, 2783, "udp"},
{"www-dev",            {NULL}, 2784, "tcp"},
{"www-dev",            {NULL}, 2784, "udp"},
{"aic-np",             {NULL}, 2785, "tcp"},
{"aic-np",             {NULL}, 2785, "udp"},
{"aic-oncrpc",         {NULL}, 2786, "tcp"},
{"aic-oncrpc",         {NULL}, 2786, "udp"},
{"piccolo",            {NULL}, 2787, "tcp"},
{"piccolo",            {NULL}, 2787, "udp"},
{"fryeserv",           {NULL}, 2788, "tcp"},
{"fryeserv",           {NULL}, 2788, "udp"},
{"media-agent",        {NULL}, 2789, "tcp"},
{"media-agent",        {NULL}, 2789, "udp"},
{"plgproxy",           {NULL}, 2790, "tcp"},
{"plgproxy",           {NULL}, 2790, "udp"},
{"mtport-regist",      {NULL}, 2791, "tcp"},
{"mtport-regist",      {NULL}, 2791, "udp"},
{"f5-globalsite",      {NULL}, 2792, "tcp"},
{"f5-globalsite",      {NULL}, 2792, "udp"},
{"initlsmsad",         {NULL}, 2793, "tcp"},
{"initlsmsad",         {NULL}, 2793, "udp"},
{"livestats",          {NULL}, 2795, "tcp"},
{"livestats",          {NULL}, 2795, "udp"},
{"ac-tech",            {NULL}, 2796, "tcp"},
{"ac-tech",            {NULL}, 2796, "udp"},
{"esp-encap",          {NULL}, 2797, "tcp"},
{"esp-encap",          {NULL}, 2797, "udp"},
{"tmesis-upshot",      {NULL}, 2798, "tcp"},
{"tmesis-upshot",      {NULL}, 2798, "udp"},
{"icon-discover",      {NULL}, 2799, "tcp"},
{"icon-discover",      {NULL}, 2799, "udp"},
{"acc-raid",           {NULL}, 2800, "tcp"},
{"acc-raid",           {NULL}, 2800, "udp"},
{"igcp",               {NULL}, 2801, "tcp"},
{"igcp",               {NULL}, 2801, "udp"},
{"veritas-tcp1",       {NULL}, 2802, "tcp"},
{"veritas-udp1",       {NULL}, 2802, "udp"},
{"btprjctrl",          {NULL}, 2803, "tcp"},
{"btprjctrl",          {NULL}, 2803, "udp"},
{"dvr-esm",            {NULL}, 2804, "tcp"},
{"dvr-esm",            {NULL}, 2804, "udp"},
{"wta-wsp-s",          {NULL}, 2805, "tcp"},
{"wta-wsp-s",          {NULL}, 2805, "udp"},
{"cspuni",             {NULL}, 2806, "tcp"},
{"cspuni",             {NULL}, 2806, "udp"},
{"cspmulti",           {NULL}, 2807, "tcp"},
{"cspmulti",           {NULL}, 2807, "udp"},
{"j-lan-p",            {NULL}, 2808, "tcp"},
{"j-lan-p",            {NULL}, 2808, "udp"},
{"corbaloc",           {NULL}, 2809, "tcp"},
{"corbaloc",           {NULL}, 2809, "udp"},
{"netsteward",         {NULL}, 2810, "tcp"},
{"netsteward",         {NULL}, 2810, "udp"},
{"gsiftp",             {NULL}, 2811, "tcp"},
{"gsiftp",             {NULL}, 2811, "udp"},
{"atmtcp",             {NULL}, 2812, "tcp"},
{"atmtcp",             {NULL}, 2812, "udp"},
{"llm-pass",           {NULL}, 2813, "tcp"},
{"llm-pass",           {NULL}, 2813, "udp"},
{"llm-csv",            {NULL}, 2814, "tcp"},
{"llm-csv",            {NULL}, 2814, "udp"},
{"lbc-measure",        {NULL}, 2815, "tcp"},
{"lbc-measure",        {NULL}, 2815, "udp"},
{"lbc-watchdog",       {NULL}, 2816, "tcp"},
{"lbc-watchdog",       {NULL}, 2816, "udp"},
{"nmsigport",          {NULL}, 2817, "tcp"},
{"nmsigport",          {NULL}, 2817, "udp"},
{"rmlnk",              {NULL}, 2818, "tcp"},
{"rmlnk",              {NULL}, 2818, "udp"},
{"fc-faultnotify",     {NULL}, 2819, "tcp"},
{"fc-faultnotify",     {NULL}, 2819, "udp"},
{"univision",          {NULL}, 2820, "tcp"},
{"univision",          {NULL}, 2820, "udp"},
{"vrts-at-port",       {NULL}, 2821, "tcp"},
{"vrts-at-port",       {NULL}, 2821, "udp"},
{"ka0wuc",             {NULL}, 2822, "tcp"},
{"ka0wuc",             {NULL}, 2822, "udp"},
{"cqg-netlan",         {NULL}, 2823, "tcp"},
{"cqg-netlan",         {NULL}, 2823, "udp"},
{"cqg-netlan-1",       {NULL}, 2824, "tcp"},
{"cqg-netlan-1",       {NULL}, 2824, "udp"},
{"slc-systemlog",      {NULL}, 2826, "tcp"},
{"slc-systemlog",      {NULL}, 2826, "udp"},
{"slc-ctrlrloops",     {NULL}, 2827, "tcp"},
{"slc-ctrlrloops",     {NULL}, 2827, "udp"},
{"itm-lm",             {NULL}, 2828, "tcp"},
{"itm-lm",             {NULL}, 2828, "udp"},
{"silkp1",             {NULL}, 2829, "tcp"},
{"silkp1",             {NULL}, 2829, "udp"},
{"silkp2",             {NULL}, 2830, "tcp"},
{"silkp2",             {NULL}, 2830, "udp"},
{"silkp3",             {NULL}, 2831, "tcp"},
{"silkp3",             {NULL}, 2831, "udp"},
{"silkp4",             {NULL}, 2832, "tcp"},
{"silkp4",             {NULL}, 2832, "udp"},
{"glishd",             {NULL}, 2833, "tcp"},
{"glishd",             {NULL}, 2833, "udp"},
{"evtp",               {NULL}, 2834, "tcp"},
{"evtp",               {NULL}, 2834, "udp"},
{"evtp-data",          {NULL}, 2835, "tcp"},
{"evtp-data",          {NULL}, 2835, "udp"},
{"catalyst",           {NULL}, 2836, "tcp"},
{"catalyst",           {NULL}, 2836, "udp"},
{"repliweb",           {NULL}, 2837, "tcp"},
{"repliweb",           {NULL}, 2837, "udp"},
{"starbot",            {NULL}, 2838, "tcp"},
{"starbot",            {NULL}, 2838, "udp"},
{"nmsigport",          {NULL}, 2839, "tcp"},
{"nmsigport",          {NULL}, 2839, "udp"},
{"l3-exprt",           {NULL}, 2840, "tcp"},
{"l3-exprt",           {NULL}, 2840, "udp"},
{"l3-ranger",          {NULL}, 2841, "tcp"},
{"l3-ranger",          {NULL}, 2841, "udp"},
{"l3-hawk",            {NULL}, 2842, "tcp"},
{"l3-hawk",            {NULL}, 2842, "udp"},
{"pdnet",              {NULL}, 2843, "tcp"},
{"pdnet",              {NULL}, 2843, "udp"},
{"bpcp-poll",          {NULL}, 2844, "tcp"},
{"bpcp-poll",          {NULL}, 2844, "udp"},
{"bpcp-trap",          {NULL}, 2845, "tcp"},
{"bpcp-trap",          {NULL}, 2845, "udp"},
{"aimpp-hello",        {NULL}, 2846, "tcp"},
{"aimpp-hello",        {NULL}, 2846, "udp"},
{"aimpp-port-req",     {NULL}, 2847, "tcp"},
{"aimpp-port-req",     {NULL}, 2847, "udp"},
{"amt-blc-port",       {NULL}, 2848, "tcp"},
{"amt-blc-port",       {NULL}, 2848, "udp"},
{"fxp",                {NULL}, 2849, "tcp"},
{"fxp",                {NULL}, 2849, "udp"},
{"metaconsole",        {NULL}, 2850, "tcp"},
{"metaconsole",        {NULL}, 2850, "udp"},
{"webemshttp",         {NULL}, 2851, "tcp"},
{"webemshttp",         {NULL}, 2851, "udp"},
{"bears-01",           {NULL}, 2852, "tcp"},
{"bears-01",           {NULL}, 2852, "udp"},
{"ispipes",            {NULL}, 2853, "tcp"},
{"ispipes",            {NULL}, 2853, "udp"},
{"infomover",          {NULL}, 2854, "tcp"},
{"infomover",          {NULL}, 2854, "udp"},
{"msrp",               {NULL}, 2855, "tcp"},
{"msrp",               {NULL}, 2855, "udp"},
{"cesdinv",            {NULL}, 2856, "tcp"},
{"cesdinv",            {NULL}, 2856, "udp"},
{"simctlp",            {NULL}, 2857, "tcp"},
{"simctlp",            {NULL}, 2857, "udp"},
{"ecnp",               {NULL}, 2858, "tcp"},
{"ecnp",               {NULL}, 2858, "udp"},
{"activememory",       {NULL}, 2859, "tcp"},
{"activememory",       {NULL}, 2859, "udp"},
{"dialpad-voice1",     {NULL}, 2860, "tcp"},
{"dialpad-voice1",     {NULL}, 2860, "udp"},
{"dialpad-voice2",     {NULL}, 2861, "tcp"},
{"dialpad-voice2",     {NULL}, 2861, "udp"},
{"ttg-protocol",       {NULL}, 2862, "tcp"},
{"ttg-protocol",       {NULL}, 2862, "udp"},
{"sonardata",          {NULL}, 2863, "tcp"},
{"sonardata",          {NULL}, 2863, "udp"},
{"astromed-main",      {NULL}, 2864, "tcp"},
{"astromed-main",      {NULL}, 2864, "udp"},
{"pit-vpn",            {NULL}, 2865, "tcp"},
{"pit-vpn",            {NULL}, 2865, "udp"},
{"iwlistener",         {NULL}, 2866, "tcp"},
{"iwlistener",         {NULL}, 2866, "udp"},
{"esps-portal",        {NULL}, 2867, "tcp"},
{"esps-portal",        {NULL}, 2867, "udp"},
{"npep-messaging",     {NULL}, 2868, "tcp"},
{"npep-messaging",     {NULL}, 2868, "udp"},
{"icslap",             {NULL}, 2869, "tcp"},
{"icslap",             {NULL}, 2869, "udp"},
{"daishi",             {NULL}, 2870, "tcp"},
{"daishi",             {NULL}, 2870, "udp"},
{"msi-selectplay",     {NULL}, 2871, "tcp"},
{"msi-selectplay",     {NULL}, 2871, "udp"},
{"radix",              {NULL}, 2872, "tcp"},
{"radix",              {NULL}, 2872, "udp"},
{"dxmessagebase1",     {NULL}, 2874, "tcp"},
{"dxmessagebase1",     {NULL}, 2874, "udp"},
{"dxmessagebase2",     {NULL}, 2875, "tcp"},
{"dxmessagebase2",     {NULL}, 2875, "udp"},
{"sps-tunnel",         {NULL}, 2876, "tcp"},
{"sps-tunnel",         {NULL}, 2876, "udp"},
{"bluelance",          {NULL}, 2877, "tcp"},
{"bluelance",          {NULL}, 2877, "udp"},
{"aap",                {NULL}, 2878, "tcp"},
{"aap",                {NULL}, 2878, "udp"},
{"ucentric-ds",        {NULL}, 2879, "tcp"},
{"ucentric-ds",        {NULL}, 2879, "udp"},
{"synapse",            {NULL}, 2880, "tcp"},
{"synapse",            {NULL}, 2880, "udp"},
{"ndsp",               {NULL}, 2881, "tcp"},
{"ndsp",               {NULL}, 2881, "udp"},
{"ndtp",               {NULL}, 2882, "tcp"},
{"ndtp",               {NULL}, 2882, "udp"},
{"ndnp",               {NULL}, 2883, "tcp"},
{"ndnp",               {NULL}, 2883, "udp"},
{"flashmsg",           {NULL}, 2884, "tcp"},
{"flashmsg",           {NULL}, 2884, "udp"},
{"topflow",            {NULL}, 2885, "tcp"},
{"topflow",            {NULL}, 2885, "udp"},
{"responselogic",      {NULL}, 2886, "tcp"},
{"responselogic",      {NULL}, 2886, "udp"},
{"aironetddp",         {NULL}, 2887, "tcp"},
{"aironetddp",         {NULL}, 2887, "udp"},
{"spcsdlobby",         {NULL}, 2888, "tcp"},
{"spcsdlobby",         {NULL}, 2888, "udp"},
{"rsom",               {NULL}, 2889, "tcp"},
{"rsom",               {NULL}, 2889, "udp"},
{"cspclmulti",         {NULL}, 2890, "tcp"},
{"cspclmulti",         {NULL}, 2890, "udp"},
{"cinegrfx-elmd",      {NULL}, 2891, "tcp"},
{"cinegrfx-elmd",      {NULL}, 2891, "udp"},
{"snifferdata",        {NULL}, 2892, "tcp"},
{"snifferdata",        {NULL}, 2892, "udp"},
{"vseconnector",       {NULL}, 2893, "tcp"},
{"vseconnector",       {NULL}, 2893, "udp"},
{"abacus-remote",      {NULL}, 2894, "tcp"},
{"abacus-remote",      {NULL}, 2894, "udp"},
{"natuslink",          {NULL}, 2895, "tcp"},
{"natuslink",          {NULL}, 2895, "udp"},
{"ecovisiong6-1",      {NULL}, 2896, "tcp"},
{"ecovisiong6-1",      {NULL}, 2896, "udp"},
{"citrix-rtmp",        {NULL}, 2897, "tcp"},
{"citrix-rtmp",        {NULL}, 2897, "udp"},
{"appliance-cfg",      {NULL}, 2898, "tcp"},
{"appliance-cfg",      {NULL}, 2898, "udp"},
{"powergemplus",       {NULL}, 2899, "tcp"},
{"powergemplus",       {NULL}, 2899, "udp"},
{"quicksuite",         {NULL}, 2900, "tcp"},
{"quicksuite",         {NULL}, 2900, "udp"},
{"allstorcns",         {NULL}, 2901, "tcp"},
{"allstorcns",         {NULL}, 2901, "udp"},
{"netaspi",            {NULL}, 2902, "tcp"},
{"netaspi",            {NULL}, 2902, "udp"},
{"suitcase",           {NULL}, 2903, "tcp"},
{"suitcase",           {NULL}, 2903, "udp"},
{"m2ua",               {NULL}, 2904, "tcp"},
{"m2ua",               {NULL}, 2904, "udp"},
{"m2ua",               {NULL}, 2904, "sctp"},
{"m3ua",               {NULL}, 2905, "tcp"},
{"m3ua",               {NULL}, 2905, "sctp"},
{"caller9",            {NULL}, 2906, "tcp"},
{"caller9",            {NULL}, 2906, "udp"},
{"webmethods-b2b",     {NULL}, 2907, "tcp"},
{"webmethods-b2b",     {NULL}, 2907, "udp"},
{"mao",                {NULL}, 2908, "tcp"},
{"mao",                {NULL}, 2908, "udp"},
{"funk-dialout",       {NULL}, 2909, "tcp"},
{"funk-dialout",       {NULL}, 2909, "udp"},
{"tdaccess",           {NULL}, 2910, "tcp"},
{"tdaccess",           {NULL}, 2910, "udp"},
{"blockade",           {NULL}, 2911, "tcp"},
{"blockade",           {NULL}, 2911, "udp"},
{"epicon",             {NULL}, 2912, "tcp"},
{"epicon",             {NULL}, 2912, "udp"},
{"boosterware",        {NULL}, 2913, "tcp"},
{"boosterware",        {NULL}, 2913, "udp"},
{"gamelobby",          {NULL}, 2914, "tcp"},
{"gamelobby",          {NULL}, 2914, "udp"},
{"tksocket",           {NULL}, 2915, "tcp"},
{"tksocket",           {NULL}, 2915, "udp"},
{"elvin_server",       {NULL}, 2916, "tcp"},
{"elvin_server",       {NULL}, 2916, "udp"},
{"elvin_client",       {NULL}, 2917, "tcp"},
{"elvin_client",       {NULL}, 2917, "udp"},
{"kastenchasepad",     {NULL}, 2918, "tcp"},
{"kastenchasepad",     {NULL}, 2918, "udp"},
{"roboer",             {NULL}, 2919, "tcp"},
{"roboer",             {NULL}, 2919, "udp"},
{"roboeda",            {NULL}, 2920, "tcp"},
{"roboeda",            {NULL}, 2920, "udp"},
{"cesdcdman",          {NULL}, 2921, "tcp"},
{"cesdcdman",          {NULL}, 2921, "udp"},
{"cesdcdtrn",          {NULL}, 2922, "tcp"},
{"cesdcdtrn",          {NULL}, 2922, "udp"},
{"wta-wsp-wtp-s",      {NULL}, 2923, "tcp"},
{"wta-wsp-wtp-s",      {NULL}, 2923, "udp"},
{"precise-vip",        {NULL}, 2924, "tcp"},
{"precise-vip",        {NULL}, 2924, "udp"},
{"mobile-file-dl",     {NULL}, 2926, "tcp"},
{"mobile-file-dl",     {NULL}, 2926, "udp"},
{"unimobilectrl",      {NULL}, 2927, "tcp"},
{"unimobilectrl",      {NULL}, 2927, "udp"},
{"redstone-cpss",      {NULL}, 2928, "tcp"},
{"redstone-cpss",      {NULL}, 2928, "udp"},
{"amx-webadmin",       {NULL}, 2929, "tcp"},
{"amx-webadmin",       {NULL}, 2929, "udp"},
{"amx-weblinx",        {NULL}, 2930, "tcp"},
{"amx-weblinx",        {NULL}, 2930, "udp"},
{"circle-x",           {NULL}, 2931, "tcp"},
{"circle-x",           {NULL}, 2931, "udp"},
{"incp",               {NULL}, 2932, "tcp"},
{"incp",               {NULL}, 2932, "udp"},
{"4-tieropmgw",        {NULL}, 2933, "tcp"},
{"4-tieropmgw",        {NULL}, 2933, "udp"},
{"4-tieropmcli",       {NULL}, 2934, "tcp"},
{"4-tieropmcli",       {NULL}, 2934, "udp"},
{"qtp",                {NULL}, 2935, "tcp"},
{"qtp",                {NULL}, 2935, "udp"},
{"otpatch",            {NULL}, 2936, "tcp"},
{"otpatch",            {NULL}, 2936, "udp"},
{"pnaconsult-lm",      {NULL}, 2937, "tcp"},
{"pnaconsult-lm",      {NULL}, 2937, "udp"},
{"sm-pas-1",           {NULL}, 2938, "tcp"},
{"sm-pas-1",           {NULL}, 2938, "udp"},
{"sm-pas-2",           {NULL}, 2939, "tcp"},
{"sm-pas-2",           {NULL}, 2939, "udp"},
{"sm-pas-3",           {NULL}, 2940, "tcp"},
{"sm-pas-3",           {NULL}, 2940, "udp"},
{"sm-pas-4",           {NULL}, 2941, "tcp"},
{"sm-pas-4",           {NULL}, 2941, "udp"},
{"sm-pas-5",           {NULL}, 2942, "tcp"},
{"sm-pas-5",           {NULL}, 2942, "udp"},
{"ttnrepository",      {NULL}, 2943, "tcp"},
{"ttnrepository",      {NULL}, 2943, "udp"},
{"megaco-h248",        {NULL}, 2944, "tcp"},
{"megaco-h248",        {NULL}, 2944, "udp"},
{"megaco-h248",        {NULL}, 2944, "sctp"},
{"h248-binary",        {NULL}, 2945, "tcp"},
{"h248-binary",        {NULL}, 2945, "udp"},
{"h248-binary",        {NULL}, 2945, "sctp"},
{"fjsvmpor",           {NULL}, 2946, "tcp"},
{"fjsvmpor",           {NULL}, 2946, "udp"},
{"gpsd",               {NULL}, 2947, "tcp"},
{"gpsd",               {NULL}, 2947, "udp"},
{"wap-push",           {NULL}, 2948, "tcp"},
{"wap-push",           {NULL}, 2948, "udp"},
{"wap-pushsecure",     {NULL}, 2949, "tcp"},
{"wap-pushsecure",     {NULL}, 2949, "udp"},
{"esip",               {NULL}, 2950, "tcp"},
{"esip",               {NULL}, 2950, "udp"},
{"ottp",               {NULL}, 2951, "tcp"},
{"ottp",               {NULL}, 2951, "udp"},
{"mpfwsas",            {NULL}, 2952, "tcp"},
{"mpfwsas",            {NULL}, 2952, "udp"},
{"ovalarmsrv",         {NULL}, 2953, "tcp"},
{"ovalarmsrv",         {NULL}, 2953, "udp"},
{"ovalarmsrv-cmd",     {NULL}, 2954, "tcp"},
{"ovalarmsrv-cmd",     {NULL}, 2954, "udp"},
{"csnotify",           {NULL}, 2955, "tcp"},
{"csnotify",           {NULL}, 2955, "udp"},
{"ovrimosdbman",       {NULL}, 2956, "tcp"},
{"ovrimosdbman",       {NULL}, 2956, "udp"},
{"jmact5",             {NULL}, 2957, "tcp"},
{"jmact5",             {NULL}, 2957, "udp"},
{"jmact6",             {NULL}, 2958, "tcp"},
{"jmact6",             {NULL}, 2958, "udp"},
{"rmopagt",            {NULL}, 2959, "tcp"},
{"rmopagt",            {NULL}, 2959, "udp"},
{"dfoxserver",         {NULL}, 2960, "tcp"},
{"dfoxserver",         {NULL}, 2960, "udp"},
{"boldsoft-lm",        {NULL}, 2961, "tcp"},
{"boldsoft-lm",        {NULL}, 2961, "udp"},
{"iph-policy-cli",     {NULL}, 2962, "tcp"},
{"iph-policy-cli",     {NULL}, 2962, "udp"},
{"iph-policy-adm",     {NULL}, 2963, "tcp"},
{"iph-policy-adm",     {NULL}, 2963, "udp"},
{"bullant-srap",       {NULL}, 2964, "tcp"},
{"bullant-srap",       {NULL}, 2964, "udp"},
{"bullant-rap",        {NULL}, 2965, "tcp"},
{"bullant-rap",        {NULL}, 2965, "udp"},
{"idp-infotrieve",     {NULL}, 2966, "tcp"},
{"idp-infotrieve",     {NULL}, 2966, "udp"},
{"ssc-agent",          {NULL}, 2967, "tcp"},
{"ssc-agent",          {NULL}, 2967, "udp"},
{"enpp",               {NULL}, 2968, "tcp"},
{"enpp",               {NULL}, 2968, "udp"},
{"essp",               {NULL}, 2969, "tcp"},
{"essp",               {NULL}, 2969, "udp"},
{"index-net",          {NULL}, 2970, "tcp"},
{"index-net",          {NULL}, 2970, "udp"},
{"netclip",            {NULL}, 2971, "tcp"},
{"netclip",            {NULL}, 2971, "udp"},
{"pmsm-webrctl",       {NULL}, 2972, "tcp"},
{"pmsm-webrctl",       {NULL}, 2972, "udp"},
{"svnetworks",         {NULL}, 2973, "tcp"},
{"svnetworks",         {NULL}, 2973, "udp"},
{"signal",             {NULL}, 2974, "tcp"},
{"signal",             {NULL}, 2974, "udp"},
{"fjmpcm",             {NULL}, 2975, "tcp"},
{"fjmpcm",             {NULL}, 2975, "udp"},
{"cns-srv-port",       {NULL}, 2976, "tcp"},
{"cns-srv-port",       {NULL}, 2976, "udp"},
{"ttc-etap-ns",        {NULL}, 2977, "tcp"},
{"ttc-etap-ns",        {NULL}, 2977, "udp"},
{"ttc-etap-ds",        {NULL}, 2978, "tcp"},
{"ttc-etap-ds",        {NULL}, 2978, "udp"},
{"h263-video",         {NULL}, 2979, "tcp"},
{"h263-video",         {NULL}, 2979, "udp"},
{"wimd",               {NULL}, 2980, "tcp"},
{"wimd",               {NULL}, 2980, "udp"},
{"mylxamport",         {NULL}, 2981, "tcp"},
{"mylxamport",         {NULL}, 2981, "udp"},
{"iwb-whiteboard",     {NULL}, 2982, "tcp"},
{"iwb-whiteboard",     {NULL}, 2982, "udp"},
{"netplan",            {NULL}, 2983, "tcp"},
{"netplan",            {NULL}, 2983, "udp"},
{"hpidsadmin",         {NULL}, 2984, "tcp"},
{"hpidsadmin",         {NULL}, 2984, "udp"},
{"hpidsagent",         {NULL}, 2985, "tcp"},
{"hpidsagent",         {NULL}, 2985, "udp"},
{"stonefalls",         {NULL}, 2986, "tcp"},
{"stonefalls",         {NULL}, 2986, "udp"},
{"identify",           {NULL}, 2987, "tcp"},
{"identify",           {NULL}, 2987, "udp"},
{"hippad",             {NULL}, 2988, "tcp"},
{"hippad",             {NULL}, 2988, "udp"},
{"zarkov",             {NULL}, 2989, "tcp"},
{"zarkov",             {NULL}, 2989, "udp"},
{"boscap",             {NULL}, 2990, "tcp"},
{"boscap",             {NULL}, 2990, "udp"},
{"wkstn-mon",          {NULL}, 2991, "tcp"},
{"wkstn-mon",          {NULL}, 2991, "udp"},
{"avenyo",             {NULL}, 2992, "tcp"},
{"avenyo",             {NULL}, 2992, "udp"},
{"veritas-vis1",       {NULL}, 2993, "tcp"},
{"veritas-vis1",       {NULL}, 2993, "udp"},
{"veritas-vis2",       {NULL}, 2994, "tcp"},
{"veritas-vis2",       {NULL}, 2994, "udp"},
{"idrs",               {NULL}, 2995, "tcp"},
{"idrs",               {NULL}, 2995, "udp"},
{"vsixml",             {NULL}, 2996, "tcp"},
{"vsixml",             {NULL}, 2996, "udp"},
{"rebol",              {NULL}, 2997, "tcp"},
{"rebol",              {NULL}, 2997, "udp"},
{"realsecure",         {NULL}, 2998, "tcp"},
{"realsecure",         {NULL}, 2998, "udp"},
{"remoteware-un",      {NULL}, 2999, "tcp"},
{"remoteware-un",      {NULL}, 2999, "udp"},
{"hbci",               {NULL}, 3000, "tcp"},
{"hbci",               {NULL}, 3000, "udp"},
{"remoteware-cl",      {NULL}, 3000, "tcp"},
{"remoteware-cl",      {NULL}, 3000, "udp"},
{"exlm-agent",         {NULL}, 3002, "tcp"},
{"exlm-agent",         {NULL}, 3002, "udp"},
{"remoteware-srv",     {NULL}, 3002, "tcp"},
{"remoteware-srv",     {NULL}, 3002, "udp"},
{"cgms",               {NULL}, 3003, "tcp"},
{"cgms",               {NULL}, 3003, "udp"},
{"csoftragent",        {NULL}, 3004, "tcp"},
{"csoftragent",        {NULL}, 3004, "udp"},
{"geniuslm",           {NULL}, 3005, "tcp"},
{"geniuslm",           {NULL}, 3005, "udp"},
{"ii-admin",           {NULL}, 3006, "tcp"},
{"ii-admin",           {NULL}, 3006, "udp"},
{"lotusmtap",          {NULL}, 3007, "tcp"},
{"lotusmtap",          {NULL}, 3007, "udp"},
{"midnight-tech",      {NULL}, 3008, "tcp"},
{"midnight-tech",      {NULL}, 3008, "udp"},
{"pxc-ntfy",           {NULL}, 3009, "tcp"},
{"pxc-ntfy",           {NULL}, 3009, "udp"},
{"gw",                 {NULL}, 3010, "tcp"},
{"ping-pong",          {NULL}, 3010, "udp"},
{"trusted-web",        {NULL}, 3011, "tcp"},
{"trusted-web",        {NULL}, 3011, "udp"},
{"twsdss",             {NULL}, 3012, "tcp"},
{"twsdss",             {NULL}, 3012, "udp"},
{"gilatskysurfer",     {NULL}, 3013, "tcp"},
{"gilatskysurfer",     {NULL}, 3013, "udp"},
{"broker_service",     {NULL}, 3014, "tcp"},
{"broker_service",     {NULL}, 3014, "udp"},
{"nati-dstp",          {NULL}, 3015, "tcp"},
{"nati-dstp",          {NULL}, 3015, "udp"},
{"notify_srvr",        {NULL}, 3016, "tcp"},
{"notify_srvr",        {NULL}, 3016, "udp"},
{"event_listener",     {NULL}, 3017, "tcp"},
{"event_listener",     {NULL}, 3017, "udp"},
{"srvc_registry",      {NULL}, 3018, "tcp"},
{"srvc_registry",      {NULL}, 3018, "udp"},
{"resource_mgr",       {NULL}, 3019, "tcp"},
{"resource_mgr",       {NULL}, 3019, "udp"},
{"cifs",               {NULL}, 3020, "tcp"},
{"cifs",               {NULL}, 3020, "udp"},
{"agriserver",         {NULL}, 3021, "tcp"},
{"agriserver",         {NULL}, 3021, "udp"},
{"csregagent",         {NULL}, 3022, "tcp"},
{"csregagent",         {NULL}, 3022, "udp"},
{"magicnotes",         {NULL}, 3023, "tcp"},
{"magicnotes",         {NULL}, 3023, "udp"},
{"nds_sso",            {NULL}, 3024, "tcp"},
{"nds_sso",            {NULL}, 3024, "udp"},
{"arepa-raft",         {NULL}, 3025, "tcp"},
{"arepa-raft",         {NULL}, 3025, "udp"},
{"agri-gateway",       {NULL}, 3026, "tcp"},
{"agri-gateway",       {NULL}, 3026, "udp"},
{"LiebDevMgmt_C",      {NULL}, 3027, "tcp"},
{"LiebDevMgmt_C",      {NULL}, 3027, "udp"},
{"LiebDevMgmt_DM",     {NULL}, 3028, "tcp"},
{"LiebDevMgmt_DM",     {NULL}, 3028, "udp"},
{"LiebDevMgmt_A",      {NULL}, 3029, "tcp"},
{"LiebDevMgmt_A",      {NULL}, 3029, "udp"},
{"arepa-cas",          {NULL}, 3030, "tcp"},
{"arepa-cas",          {NULL}, 3030, "udp"},
{"eppc",               {NULL}, 3031, "tcp"},
{"eppc",               {NULL}, 3031, "udp"},
{"redwood-chat",       {NULL}, 3032, "tcp"},
{"redwood-chat",       {NULL}, 3032, "udp"},
{"pdb",                {NULL}, 3033, "tcp"},
{"pdb",                {NULL}, 3033, "udp"},
{"osmosis-aeea",       {NULL}, 3034, "tcp"},
{"osmosis-aeea",       {NULL}, 3034, "udp"},
{"fjsv-gssagt",        {NULL}, 3035, "tcp"},
{"fjsv-gssagt",        {NULL}, 3035, "udp"},
{"hagel-dump",         {NULL}, 3036, "tcp"},
{"hagel-dump",         {NULL}, 3036, "udp"},
{"hp-san-mgmt",        {NULL}, 3037, "tcp"},
{"hp-san-mgmt",        {NULL}, 3037, "udp"},
{"santak-ups",         {NULL}, 3038, "tcp"},
{"santak-ups",         {NULL}, 3038, "udp"},
{"cogitate",           {NULL}, 3039, "tcp"},
{"cogitate",           {NULL}, 3039, "udp"},
{"tomato-springs",     {NULL}, 3040, "tcp"},
{"tomato-springs",     {NULL}, 3040, "udp"},
{"di-traceware",       {NULL}, 3041, "tcp"},
{"di-traceware",       {NULL}, 3041, "udp"},
{"journee",            {NULL}, 3042, "tcp"},
{"journee",            {NULL}, 3042, "udp"},
{"brp",                {NULL}, 3043, "tcp"},
{"brp",                {NULL}, 3043, "udp"},
{"epp",                {NULL}, 3044, "tcp"},
{"epp",                {NULL}, 3044, "udp"},
{"responsenet",        {NULL}, 3045, "tcp"},
{"responsenet",        {NULL}, 3045, "udp"},
{"di-ase",             {NULL}, 3046, "tcp"},
{"di-ase",             {NULL}, 3046, "udp"},
{"hlserver",           {NULL}, 3047, "tcp"},
{"hlserver",           {NULL}, 3047, "udp"},
{"pctrader",           {NULL}, 3048, "tcp"},
{"pctrader",           {NULL}, 3048, "udp"},
{"nsws",               {NULL}, 3049, "tcp"},
{"nsws",               {NULL}, 3049, "udp"},
{"gds_db",             {NULL}, 3050, "tcp"},
{"gds_db",             {NULL}, 3050, "udp"},
{"galaxy-server",      {NULL}, 3051, "tcp"},
{"galaxy-server",      {NULL}, 3051, "udp"},
{"apc-3052",           {NULL}, 3052, "tcp"},
{"apc-3052",           {NULL}, 3052, "udp"},
{"dsom-server",        {NULL}, 3053, "tcp"},
{"dsom-server",        {NULL}, 3053, "udp"},
{"amt-cnf-prot",       {NULL}, 3054, "tcp"},
{"amt-cnf-prot",       {NULL}, 3054, "udp"},
{"policyserver",       {NULL}, 3055, "tcp"},
{"policyserver",       {NULL}, 3055, "udp"},
{"cdl-server",         {NULL}, 3056, "tcp"},
{"cdl-server",         {NULL}, 3056, "udp"},
{"goahead-fldup",      {NULL}, 3057, "tcp"},
{"goahead-fldup",      {NULL}, 3057, "udp"},
{"videobeans",         {NULL}, 3058, "tcp"},
{"videobeans",         {NULL}, 3058, "udp"},
{"qsoft",              {NULL}, 3059, "tcp"},
{"qsoft",              {NULL}, 3059, "udp"},
{"interserver",        {NULL}, 3060, "tcp"},
{"interserver",        {NULL}, 3060, "udp"},
{"cautcpd",            {NULL}, 3061, "tcp"},
{"cautcpd",            {NULL}, 3061, "udp"},
{"ncacn-ip-tcp",       {NULL}, 3062, "tcp"},
{"ncacn-ip-tcp",       {NULL}, 3062, "udp"},
{"ncadg-ip-udp",       {NULL}, 3063, "tcp"},
{"ncadg-ip-udp",       {NULL}, 3063, "udp"},
{"rprt",               {NULL}, 3064, "tcp"},
{"rprt",               {NULL}, 3064, "udp"},
{"slinterbase",        {NULL}, 3065, "tcp"},
{"slinterbase",        {NULL}, 3065, "udp"},
{"netattachsdmp",      {NULL}, 3066, "tcp"},
{"netattachsdmp",      {NULL}, 3066, "udp"},
{"fjhpjp",             {NULL}, 3067, "tcp"},
{"fjhpjp",             {NULL}, 3067, "udp"},
{"ls3bcast",           {NULL}, 3068, "tcp"},
{"ls3bcast",           {NULL}, 3068, "udp"},
{"ls3",                {NULL}, 3069, "tcp"},
{"ls3",                {NULL}, 3069, "udp"},
{"mgxswitch",          {NULL}, 3070, "tcp"},
{"mgxswitch",          {NULL}, 3070, "udp"},
{"csd-mgmt-port",      {NULL}, 3071, "tcp"},
{"csd-mgmt-port",      {NULL}, 3071, "udp"},
{"csd-monitor",        {NULL}, 3072, "tcp"},
{"csd-monitor",        {NULL}, 3072, "udp"},
{"vcrp",               {NULL}, 3073, "tcp"},
{"vcrp",               {NULL}, 3073, "udp"},
{"xbox",               {NULL}, 3074, "tcp"},
{"xbox",               {NULL}, 3074, "udp"},
{"orbix-locator",      {NULL}, 3075, "tcp"},
{"orbix-locator",      {NULL}, 3075, "udp"},
{"orbix-config",       {NULL}, 3076, "tcp"},
{"orbix-config",       {NULL}, 3076, "udp"},
{"orbix-loc-ssl",      {NULL}, 3077, "tcp"},
{"orbix-loc-ssl",      {NULL}, 3077, "udp"},
{"orbix-cfg-ssl",      {NULL}, 3078, "tcp"},
{"orbix-cfg-ssl",      {NULL}, 3078, "udp"},
{"lv-frontpanel",      {NULL}, 3079, "tcp"},
{"lv-frontpanel",      {NULL}, 3079, "udp"},
{"stm_pproc",          {NULL}, 3080, "tcp"},
{"stm_pproc",          {NULL}, 3080, "udp"},
{"tl1-lv",             {NULL}, 3081, "tcp"},
{"tl1-lv",             {NULL}, 3081, "udp"},
{"tl1-raw",            {NULL}, 3082, "tcp"},
{"tl1-raw",            {NULL}, 3082, "udp"},
{"tl1-telnet",         {NULL}, 3083, "tcp"},
{"tl1-telnet",         {NULL}, 3083, "udp"},
{"itm-mccs",           {NULL}, 3084, "tcp"},
{"itm-mccs",           {NULL}, 3084, "udp"},
{"pcihreq",            {NULL}, 3085, "tcp"},
{"pcihreq",            {NULL}, 3085, "udp"},
{"jdl-dbkitchen",      {NULL}, 3086, "tcp"},
{"jdl-dbkitchen",      {NULL}, 3086, "udp"},
{"asoki-sma",          {NULL}, 3087, "tcp"},
{"asoki-sma",          {NULL}, 3087, "udp"},
{"xdtp",               {NULL}, 3088, "tcp"},
{"xdtp",               {NULL}, 3088, "udp"},
{"ptk-alink",          {NULL}, 3089, "tcp"},
{"ptk-alink",          {NULL}, 3089, "udp"},
{"stss",               {NULL}, 3090, "tcp"},
{"stss",               {NULL}, 3090, "udp"},
{"1ci-smcs",           {NULL}, 3091, "tcp"},
{"1ci-smcs",           {NULL}, 3091, "udp"},
{"rapidmq-center",     {NULL}, 3093, "tcp"},
{"rapidmq-center",     {NULL}, 3093, "udp"},
{"rapidmq-reg",        {NULL}, 3094, "tcp"},
{"rapidmq-reg",        {NULL}, 3094, "udp"},
{"panasas",            {NULL}, 3095, "tcp"},
{"panasas",            {NULL}, 3095, "udp"},
{"ndl-aps",            {NULL}, 3096, "tcp"},
{"ndl-aps",            {NULL}, 3096, "udp"},
{"itu-bicc-stc",       {NULL}, 3097, "sctp"},
{"umm-port",           {NULL}, 3098, "tcp"},
{"umm-port",           {NULL}, 3098, "udp"},
{"chmd",               {NULL}, 3099, "tcp"},
{"chmd",               {NULL}, 3099, "udp"},
{"opcon-xps",          {NULL}, 3100, "tcp"},
{"opcon-xps",          {NULL}, 3100, "udp"},
{"hp-pxpib",           {NULL}, 3101, "tcp"},
{"hp-pxpib",           {NULL}, 3101, "udp"},
{"slslavemon",         {NULL}, 3102, "tcp"},
{"slslavemon",         {NULL}, 3102, "udp"},
{"autocuesmi",         {NULL}, 3103, "tcp"},
{"autocuesmi",         {NULL}, 3103, "udp"},
{"autocuelog",         {NULL}, 3104, "tcp"},
{"autocuetime",        {NULL}, 3104, "udp"},
{"cardbox",            {NULL}, 3105, "tcp"},
{"cardbox",            {NULL}, 3105, "udp"},
{"cardbox-http",       {NULL}, 3106, "tcp"},
{"cardbox-http",       {NULL}, 3106, "udp"},
{"business",           {NULL}, 3107, "tcp"},
{"business",           {NULL}, 3107, "udp"},
{"geolocate",          {NULL}, 3108, "tcp"},
{"geolocate",          {NULL}, 3108, "udp"},
{"personnel",          {NULL}, 3109, "tcp"},
{"personnel",          {NULL}, 3109, "udp"},
{"sim-control",        {NULL}, 3110, "tcp"},
{"sim-control",        {NULL}, 3110, "udp"},
{"wsynch",             {NULL}, 3111, "tcp"},
{"wsynch",             {NULL}, 3111, "udp"},
{"ksysguard",          {NULL}, 3112, "tcp"},
{"ksysguard",          {NULL}, 3112, "udp"},
{"cs-auth-svr",        {NULL}, 3113, "tcp"},
{"cs-auth-svr",        {NULL}, 3113, "udp"},
{"ccmad",              {NULL}, 3114, "tcp"},
{"ccmad",              {NULL}, 3114, "udp"},
{"mctet-master",       {NULL}, 3115, "tcp"},
{"mctet-master",       {NULL}, 3115, "udp"},
{"mctet-gateway",      {NULL}, 3116, "tcp"},
{"mctet-gateway",      {NULL}, 3116, "udp"},
{"mctet-jserv",        {NULL}, 3117, "tcp"},
{"mctet-jserv",        {NULL}, 3117, "udp"},
{"pkagent",            {NULL}, 3118, "tcp"},
{"pkagent",            {NULL}, 3118, "udp"},
{"d2000kernel",        {NULL}, 3119, "tcp"},
{"d2000kernel",        {NULL}, 3119, "udp"},
{"d2000webserver",     {NULL}, 3120, "tcp"},
{"d2000webserver",     {NULL}, 3120, "udp"},
{"vtr-emulator",       {NULL}, 3122, "tcp"},
{"vtr-emulator",       {NULL}, 3122, "udp"},
{"edix",               {NULL}, 3123, "tcp"},
{"edix",               {NULL}, 3123, "udp"},
{"beacon-port",        {NULL}, 3124, "tcp"},
{"beacon-port",        {NULL}, 3124, "udp"},
{"a13-an",             {NULL}, 3125, "tcp"},
{"a13-an",             {NULL}, 3125, "udp"},
{"ctx-bridge",         {NULL}, 3127, "tcp"},
{"ctx-bridge",         {NULL}, 3127, "udp"},
{"ndl-aas",            {NULL}, 3128, "tcp"},
{"ndl-aas",            {NULL}, 3128, "udp"},
{"netport-id",         {NULL}, 3129, "tcp"},
{"netport-id",         {NULL}, 3129, "udp"},
{"icpv2",              {NULL}, 3130, "tcp"},
{"icpv2",              {NULL}, 3130, "udp"},
{"netbookmark",        {NULL}, 3131, "tcp"},
{"netbookmark",        {NULL}, 3131, "udp"},
{"ms-rule-engine",     {NULL}, 3132, "tcp"},
{"ms-rule-engine",     {NULL}, 3132, "udp"},
{"prism-deploy",       {NULL}, 3133, "tcp"},
{"prism-deploy",       {NULL}, 3133, "udp"},
{"ecp",                {NULL}, 3134, "tcp"},
{"ecp",                {NULL}, 3134, "udp"},
{"peerbook-port",      {NULL}, 3135, "tcp"},
{"peerbook-port",      {NULL}, 3135, "udp"},
{"grubd",              {NULL}, 3136, "tcp"},
{"grubd",              {NULL}, 3136, "udp"},
{"rtnt-1",             {NULL}, 3137, "tcp"},
{"rtnt-1",             {NULL}, 3137, "udp"},
{"rtnt-2",             {NULL}, 3138, "tcp"},
{"rtnt-2",             {NULL}, 3138, "udp"},
{"incognitorv",        {NULL}, 3139, "tcp"},
{"incognitorv",        {NULL}, 3139, "udp"},
{"ariliamulti",        {NULL}, 3140, "tcp"},
{"ariliamulti",        {NULL}, 3140, "udp"},
{"vmodem",             {NULL}, 3141, "tcp"},
{"vmodem",             {NULL}, 3141, "udp"},
{"rdc-wh-eos",         {NULL}, 3142, "tcp"},
{"rdc-wh-eos",         {NULL}, 3142, "udp"},
{"seaview",            {NULL}, 3143, "tcp"},
{"seaview",            {NULL}, 3143, "udp"},
{"tarantella",         {NULL}, 3144, "tcp"},
{"tarantella",         {NULL}, 3144, "udp"},
{"csi-lfap",           {NULL}, 3145, "tcp"},
{"csi-lfap",           {NULL}, 3145, "udp"},
{"bears-02",           {NULL}, 3146, "tcp"},
{"bears-02",           {NULL}, 3146, "udp"},
{"rfio",               {NULL}, 3147, "tcp"},
{"rfio",               {NULL}, 3147, "udp"},
{"nm-game-admin",      {NULL}, 3148, "tcp"},
{"nm-game-admin",      {NULL}, 3148, "udp"},
{"nm-game-server",     {NULL}, 3149, "tcp"},
{"nm-game-server",     {NULL}, 3149, "udp"},
{"nm-asses-admin",     {NULL}, 3150, "tcp"},
{"nm-asses-admin",     {NULL}, 3150, "udp"},
{"nm-assessor",        {NULL}, 3151, "tcp"},
{"nm-assessor",        {NULL}, 3151, "udp"},
{"feitianrockey",      {NULL}, 3152, "tcp"},
{"feitianrockey",      {NULL}, 3152, "udp"},
{"s8-client-port",     {NULL}, 3153, "tcp"},
{"s8-client-port",     {NULL}, 3153, "udp"},
{"ccmrmi",             {NULL}, 3154, "tcp"},
{"ccmrmi",             {NULL}, 3154, "udp"},
{"jpegmpeg",           {NULL}, 3155, "tcp"},
{"jpegmpeg",           {NULL}, 3155, "udp"},
{"indura",             {NULL}, 3156, "tcp"},
{"indura",             {NULL}, 3156, "udp"},
{"e3consultants",      {NULL}, 3157, "tcp"},
{"e3consultants",      {NULL}, 3157, "udp"},
{"stvp",               {NULL}, 3158, "tcp"},
{"stvp",               {NULL}, 3158, "udp"},
{"navegaweb-port",     {NULL}, 3159, "tcp"},
{"navegaweb-port",     {NULL}, 3159, "udp"},
{"tip-app-server",     {NULL}, 3160, "tcp"},
{"tip-app-server",     {NULL}, 3160, "udp"},
{"doc1lm",             {NULL}, 3161, "tcp"},
{"doc1lm",             {NULL}, 3161, "udp"},
{"sflm",               {NULL}, 3162, "tcp"},
{"sflm",               {NULL}, 3162, "udp"},
{"res-sap",            {NULL}, 3163, "tcp"},
{"res-sap",            {NULL}, 3163, "udp"},
{"imprs",              {NULL}, 3164, "tcp"},
{"imprs",              {NULL}, 3164, "udp"},
{"newgenpay",          {NULL}, 3165, "tcp"},
{"newgenpay",          {NULL}, 3165, "udp"},
{"sossecollector",     {NULL}, 3166, "tcp"},
{"sossecollector",     {NULL}, 3166, "udp"},
{"nowcontact",         {NULL}, 3167, "tcp"},
{"nowcontact",         {NULL}, 3167, "udp"},
{"poweronnud",         {NULL}, 3168, "tcp"},
{"poweronnud",         {NULL}, 3168, "udp"},
{"serverview-as",      {NULL}, 3169, "tcp"},
{"serverview-as",      {NULL}, 3169, "udp"},
{"serverview-asn",     {NULL}, 3170, "tcp"},
{"serverview-asn",     {NULL}, 3170, "udp"},
{"serverview-gf",      {NULL}, 3171, "tcp"},
{"serverview-gf",      {NULL}, 3171, "udp"},
{"serverview-rm",      {NULL}, 3172, "tcp"},
{"serverview-rm",      {NULL}, 3172, "udp"},
{"serverview-icc",     {NULL}, 3173, "tcp"},
{"serverview-icc",     {NULL}, 3173, "udp"},
{"armi-server",        {NULL}, 3174, "tcp"},
{"armi-server",        {NULL}, 3174, "udp"},
{"t1-e1-over-ip",      {NULL}, 3175, "tcp"},
{"t1-e1-over-ip",      {NULL}, 3175, "udp"},
{"ars-master",         {NULL}, 3176, "tcp"},
{"ars-master",         {NULL}, 3176, "udp"},
{"phonex-port",        {NULL}, 3177, "tcp"},
{"phonex-port",        {NULL}, 3177, "udp"},
{"radclientport",      {NULL}, 3178, "tcp"},
{"radclientport",      {NULL}, 3178, "udp"},
{"h2gf-w-2m",          {NULL}, 3179, "tcp"},
{"h2gf-w-2m",          {NULL}, 3179, "udp"},
{"mc-brk-srv",         {NULL}, 3180, "tcp"},
{"mc-brk-srv",         {NULL}, 3180, "udp"},
{"bmcpatrolagent",     {NULL}, 3181, "tcp"},
{"bmcpatrolagent",     {NULL}, 3181, "udp"},
{"bmcpatrolrnvu",      {NULL}, 3182, "tcp"},
{"bmcpatrolrnvu",      {NULL}, 3182, "udp"},
{"cops-tls",           {NULL}, 3183, "tcp"},
{"cops-tls",           {NULL}, 3183, "udp"},
{"apogeex-port",       {NULL}, 3184, "tcp"},
{"apogeex-port",       {NULL}, 3184, "udp"},
{"smpppd",             {NULL}, 3185, "tcp"},
{"smpppd",             {NULL}, 3185, "udp"},
{"iiw-port",           {NULL}, 3186, "tcp"},
{"iiw-port",           {NULL}, 3186, "udp"},
{"odi-port",           {NULL}, 3187, "tcp"},
{"odi-port",           {NULL}, 3187, "udp"},
{"brcm-comm-port",     {NULL}, 3188, "tcp"},
{"brcm-comm-port",     {NULL}, 3188, "udp"},
{"pcle-infex",         {NULL}, 3189, "tcp"},
{"pcle-infex",         {NULL}, 3189, "udp"},
{"csvr-proxy",         {NULL}, 3190, "tcp"},
{"csvr-proxy",         {NULL}, 3190, "udp"},
{"csvr-sslproxy",      {NULL}, 3191, "tcp"},
{"csvr-sslproxy",      {NULL}, 3191, "udp"},
{"firemonrcc",         {NULL}, 3192, "tcp"},
{"firemonrcc",         {NULL}, 3192, "udp"},
{"spandataport",       {NULL}, 3193, "tcp"},
{"spandataport",       {NULL}, 3193, "udp"},
{"magbind",            {NULL}, 3194, "tcp"},
{"magbind",            {NULL}, 3194, "udp"},
{"ncu-1",              {NULL}, 3195, "tcp"},
{"ncu-1",              {NULL}, 3195, "udp"},
{"ncu-2",              {NULL}, 3196, "tcp"},
{"ncu-2",              {NULL}, 3196, "udp"},
{"embrace-dp-s",       {NULL}, 3197, "tcp"},
{"embrace-dp-s",       {NULL}, 3197, "udp"},
{"embrace-dp-c",       {NULL}, 3198, "tcp"},
{"embrace-dp-c",       {NULL}, 3198, "udp"},
{"dmod-workspace",     {NULL}, 3199, "tcp"},
{"dmod-workspace",     {NULL}, 3199, "udp"},
{"tick-port",          {NULL}, 3200, "tcp"},
{"tick-port",          {NULL}, 3200, "udp"},
{"cpq-tasksmart",      {NULL}, 3201, "tcp"},
{"cpq-tasksmart",      {NULL}, 3201, "udp"},
{"intraintra",         {NULL}, 3202, "tcp"},
{"intraintra",         {NULL}, 3202, "udp"},
{"netwatcher-mon",     {NULL}, 3203, "tcp"},
{"netwatcher-mon",     {NULL}, 3203, "udp"},
{"netwatcher-db",      {NULL}, 3204, "tcp"},
{"netwatcher-db",      {NULL}, 3204, "udp"},
{"isns",               {NULL}, 3205, "tcp"},
{"isns",               {NULL}, 3205, "udp"},
{"ironmail",           {NULL}, 3206, "tcp"},
{"ironmail",           {NULL}, 3206, "udp"},
{"vx-auth-port",       {NULL}, 3207, "tcp"},
{"vx-auth-port",       {NULL}, 3207, "udp"},
{"pfu-prcallback",     {NULL}, 3208, "tcp"},
{"pfu-prcallback",     {NULL}, 3208, "udp"},
{"netwkpathengine",    {NULL}, 3209, "tcp"},
{"netwkpathengine",    {NULL}, 3209, "udp"},
{"flamenco-proxy",     {NULL}, 3210, "tcp"},
{"flamenco-proxy",     {NULL}, 3210, "udp"},
{"avsecuremgmt",       {NULL}, 3211, "tcp"},
{"avsecuremgmt",       {NULL}, 3211, "udp"},
{"surveyinst",         {NULL}, 3212, "tcp"},
{"surveyinst",         {NULL}, 3212, "udp"},
{"neon24x7",           {NULL}, 3213, "tcp"},
{"neon24x7",           {NULL}, 3213, "udp"},
{"jmq-daemon-1",       {NULL}, 3214, "tcp"},
{"jmq-daemon-1",       {NULL}, 3214, "udp"},
{"jmq-daemon-2",       {NULL}, 3215, "tcp"},
{"jmq-daemon-2",       {NULL}, 3215, "udp"},
{"ferrari-foam",       {NULL}, 3216, "tcp"},
{"ferrari-foam",       {NULL}, 3216, "udp"},
{"unite",              {NULL}, 3217, "tcp"},
{"unite",              {NULL}, 3217, "udp"},
{"smartpackets",       {NULL}, 3218, "tcp"},
{"smartpackets",       {NULL}, 3218, "udp"},
{"wms-messenger",      {NULL}, 3219, "tcp"},
{"wms-messenger",      {NULL}, 3219, "udp"},
{"xnm-ssl",            {NULL}, 3220, "tcp"},
{"xnm-ssl",            {NULL}, 3220, "udp"},
{"xnm-clear-text",     {NULL}, 3221, "tcp"},
{"xnm-clear-text",     {NULL}, 3221, "udp"},
{"glbp",               {NULL}, 3222, "tcp"},
{"glbp",               {NULL}, 3222, "udp"},
{"digivote",           {NULL}, 3223, "tcp"},
{"digivote",           {NULL}, 3223, "udp"},
{"aes-discovery",      {NULL}, 3224, "tcp"},
{"aes-discovery",      {NULL}, 3224, "udp"},
{"fcip-port",          {NULL}, 3225, "tcp"},
{"fcip-port",          {NULL}, 3225, "udp"},
{"isi-irp",            {NULL}, 3226, "tcp"},
{"isi-irp",            {NULL}, 3226, "udp"},
{"dwnmshttp",          {NULL}, 3227, "tcp"},
{"dwnmshttp",          {NULL}, 3227, "udp"},
{"dwmsgserver",        {NULL}, 3228, "tcp"},
{"dwmsgserver",        {NULL}, 3228, "udp"},
{"global-cd-port",     {NULL}, 3229, "tcp"},
{"global-cd-port",     {NULL}, 3229, "udp"},
{"sftdst-port",        {NULL}, 3230, "tcp"},
{"sftdst-port",        {NULL}, 3230, "udp"},
{"vidigo",             {NULL}, 3231, "tcp"},
{"vidigo",             {NULL}, 3231, "udp"},
{"mdtp",               {NULL}, 3232, "tcp"},
{"mdtp",               {NULL}, 3232, "udp"},
{"whisker",            {NULL}, 3233, "tcp"},
{"whisker",            {NULL}, 3233, "udp"},
{"alchemy",            {NULL}, 3234, "tcp"},
{"alchemy",            {NULL}, 3234, "udp"},
{"mdap-port",          {NULL}, 3235, "tcp"},
{"mdap-port",          {NULL}, 3235, "udp"},
{"apparenet-ts",       {NULL}, 3236, "tcp"},
{"apparenet-ts",       {NULL}, 3236, "udp"},
{"apparenet-tps",      {NULL}, 3237, "tcp"},
{"apparenet-tps",      {NULL}, 3237, "udp"},
{"apparenet-as",       {NULL}, 3238, "tcp"},
{"apparenet-as",       {NULL}, 3238, "udp"},
{"apparenet-ui",       {NULL}, 3239, "tcp"},
{"apparenet-ui",       {NULL}, 3239, "udp"},
{"triomotion",         {NULL}, 3240, "tcp"},
{"triomotion",         {NULL}, 3240, "udp"},
{"sysorb",             {NULL}, 3241, "tcp"},
{"sysorb",             {NULL}, 3241, "udp"},
{"sdp-id-port",        {NULL}, 3242, "tcp"},
{"sdp-id-port",        {NULL}, 3242, "udp"},
{"timelot",            {NULL}, 3243, "tcp"},
{"timelot",            {NULL}, 3243, "udp"},
{"onesaf",             {NULL}, 3244, "tcp"},
{"onesaf",             {NULL}, 3244, "udp"},
{"vieo-fe",            {NULL}, 3245, "tcp"},
{"vieo-fe",            {NULL}, 3245, "udp"},
{"dvt-system",         {NULL}, 3246, "tcp"},
{"dvt-system",         {NULL}, 3246, "udp"},
{"dvt-data",           {NULL}, 3247, "tcp"},
{"dvt-data",           {NULL}, 3247, "udp"},
{"procos-lm",          {NULL}, 3248, "tcp"},
{"procos-lm",          {NULL}, 3248, "udp"},
{"ssp",                {NULL}, 3249, "tcp"},
{"ssp",                {NULL}, 3249, "udp"},
{"hicp",               {NULL}, 3250, "tcp"},
{"hicp",               {NULL}, 3250, "udp"},
{"sysscanner",         {NULL}, 3251, "tcp"},
{"sysscanner",         {NULL}, 3251, "udp"},
{"dhe",                {NULL}, 3252, "tcp"},
{"dhe",                {NULL}, 3252, "udp"},
{"pda-data",           {NULL}, 3253, "tcp"},
{"pda-data",           {NULL}, 3253, "udp"},
{"pda-sys",            {NULL}, 3254, "tcp"},
{"pda-sys",            {NULL}, 3254, "udp"},
{"semaphore",          {NULL}, 3255, "tcp"},
{"semaphore",          {NULL}, 3255, "udp"},
{"cpqrpm-agent",       {NULL}, 3256, "tcp"},
{"cpqrpm-agent",       {NULL}, 3256, "udp"},
{"cpqrpm-server",      {NULL}, 3257, "tcp"},
{"cpqrpm-server",      {NULL}, 3257, "udp"},
{"ivecon-port",        {NULL}, 3258, "tcp"},
{"ivecon-port",        {NULL}, 3258, "udp"},
{"epncdp2",            {NULL}, 3259, "tcp"},
{"epncdp2",            {NULL}, 3259, "udp"},
{"iscsi-target",       {NULL}, 3260, "tcp"},
{"iscsi-target",       {NULL}, 3260, "udp"},
{"winshadow",          {NULL}, 3261, "tcp"},
{"winshadow",          {NULL}, 3261, "udp"},
{"necp",               {NULL}, 3262, "tcp"},
{"necp",               {NULL}, 3262, "udp"},
{"ecolor-imager",      {NULL}, 3263, "tcp"},
{"ecolor-imager",      {NULL}, 3263, "udp"},
{"ccmail",             {NULL}, 3264, "tcp"},
{"ccmail",             {NULL}, 3264, "udp"},
{"altav-tunnel",       {NULL}, 3265, "tcp"},
{"altav-tunnel",       {NULL}, 3265, "udp"},
{"ns-cfg-server",      {NULL}, 3266, "tcp"},
{"ns-cfg-server",      {NULL}, 3266, "udp"},
{"ibm-dial-out",       {NULL}, 3267, "tcp"},
{"ibm-dial-out",       {NULL}, 3267, "udp"},
{"msft-gc",            {NULL}, 3268, "tcp"},
{"msft-gc",            {NULL}, 3268, "udp"},
{"msft-gc-ssl",        {NULL}, 3269, "tcp"},
{"msft-gc-ssl",        {NULL}, 3269, "udp"},
{"verismart",          {NULL}, 3270, "tcp"},
{"verismart",          {NULL}, 3270, "udp"},
{"csoft-prev",         {NULL}, 3271, "tcp"},
{"csoft-prev",         {NULL}, 3271, "udp"},
{"user-manager",       {NULL}, 3272, "tcp"},
{"user-manager",       {NULL}, 3272, "udp"},
{"sxmp",               {NULL}, 3273, "tcp"},
{"sxmp",               {NULL}, 3273, "udp"},
{"ordinox-server",     {NULL}, 3274, "tcp"},
{"ordinox-server",     {NULL}, 3274, "udp"},
{"samd",               {NULL}, 3275, "tcp"},
{"samd",               {NULL}, 3275, "udp"},
{"maxim-asics",        {NULL}, 3276, "tcp"},
{"maxim-asics",        {NULL}, 3276, "udp"},
{"awg-proxy",          {NULL}, 3277, "tcp"},
{"awg-proxy",          {NULL}, 3277, "udp"},
{"lkcmserver",         {NULL}, 3278, "tcp"},
{"lkcmserver",         {NULL}, 3278, "udp"},
{"admind",             {NULL}, 3279, "tcp"},
{"admind",             {NULL}, 3279, "udp"},
{"vs-server",          {NULL}, 3280, "tcp"},
{"vs-server",          {NULL}, 3280, "udp"},
{"sysopt",             {NULL}, 3281, "tcp"},
{"sysopt",             {NULL}, 3281, "udp"},
{"datusorb",           {NULL}, 3282, "tcp"},
{"datusorb",           {NULL}, 3282, "udp"},
{"net-assistant",      {NULL}, 3283, "tcp"},
{"net-assistant",      {NULL}, 3283, "udp"},
{"4talk",              {NULL}, 3284, "tcp"},
{"4talk",              {NULL}, 3284, "udp"},
{"plato",              {NULL}, 3285, "tcp"},
{"plato",              {NULL}, 3285, "udp"},
{"e-net",              {NULL}, 3286, "tcp"},
{"e-net",              {NULL}, 3286, "udp"},
{"directvdata",        {NULL}, 3287, "tcp"},
{"directvdata",        {NULL}, 3287, "udp"},
{"cops",               {NULL}, 3288, "tcp"},
{"cops",               {NULL}, 3288, "udp"},
{"enpc",               {NULL}, 3289, "tcp"},
{"enpc",               {NULL}, 3289, "udp"},
{"caps-lm",            {NULL}, 3290, "tcp"},
{"caps-lm",            {NULL}, 3290, "udp"},
{"sah-lm",             {NULL}, 3291, "tcp"},
{"sah-lm",             {NULL}, 3291, "udp"},
{"cart-o-rama",        {NULL}, 3292, "tcp"},
{"cart-o-rama",        {NULL}, 3292, "udp"},
{"fg-fps",             {NULL}, 3293, "tcp"},
{"fg-fps",             {NULL}, 3293, "udp"},
{"fg-gip",             {NULL}, 3294, "tcp"},
{"fg-gip",             {NULL}, 3294, "udp"},
{"dyniplookup",        {NULL}, 3295, "tcp"},
{"dyniplookup",        {NULL}, 3295, "udp"},
{"rib-slm",            {NULL}, 3296, "tcp"},
{"rib-slm",            {NULL}, 3296, "udp"},
{"cytel-lm",           {NULL}, 3297, "tcp"},
{"cytel-lm",           {NULL}, 3297, "udp"},
{"deskview",           {NULL}, 3298, "tcp"},
{"deskview",           {NULL}, 3298, "udp"},
{"pdrncs",             {NULL}, 3299, "tcp"},
{"pdrncs",             {NULL}, 3299, "udp"},
{"mcs-fastmail",       {NULL}, 3302, "tcp"},
{"mcs-fastmail",       {NULL}, 3302, "udp"},
{"opsession-clnt",     {NULL}, 3303, "tcp"},
{"opsession-clnt",     {NULL}, 3303, "udp"},
{"opsession-srvr",     {NULL}, 3304, "tcp"},
{"opsession-srvr",     {NULL}, 3304, "udp"},
{"odette-ftp",         {NULL}, 3305, "tcp"},
{"odette-ftp",         {NULL}, 3305, "udp"},
{"mysql",              {NULL}, 3306, "tcp"},
{"mysql",              {NULL}, 3306, "udp"},
{"opsession-prxy",     {NULL}, 3307, "tcp"},
{"opsession-prxy",     {NULL}, 3307, "udp"},
{"tns-server",         {NULL}, 3308, "tcp"},
{"tns-server",         {NULL}, 3308, "udp"},
{"tns-adv",            {NULL}, 3309, "tcp"},
{"tns-adv",            {NULL}, 3309, "udp"},
{"dyna-access",        {NULL}, 3310, "tcp"},
{"dyna-access",        {NULL}, 3310, "udp"},
{"mcns-tel-ret",       {NULL}, 3311, "tcp"},
{"mcns-tel-ret",       {NULL}, 3311, "udp"},
{"appman-server",      {NULL}, 3312, "tcp"},
{"appman-server",      {NULL}, 3312, "udp"},
{"uorb",               {NULL}, 3313, "tcp"},
{"uorb",               {NULL}, 3313, "udp"},
{"uohost",             {NULL}, 3314, "tcp"},
{"uohost",             {NULL}, 3314, "udp"},
{"cdid",               {NULL}, 3315, "tcp"},
{"cdid",               {NULL}, 3315, "udp"},
{"aicc-cmi",           {NULL}, 3316, "tcp"},
{"aicc-cmi",           {NULL}, 3316, "udp"},
{"vsaiport",           {NULL}, 3317, "tcp"},
{"vsaiport",           {NULL}, 3317, "udp"},
{"ssrip",              {NULL}, 3318, "tcp"},
{"ssrip",              {NULL}, 3318, "udp"},
{"sdt-lmd",            {NULL}, 3319, "tcp"},
{"sdt-lmd",            {NULL}, 3319, "udp"},
{"officelink2000",     {NULL}, 3320, "tcp"},
{"officelink2000",     {NULL}, 3320, "udp"},
{"vnsstr",             {NULL}, 3321, "tcp"},
{"vnsstr",             {NULL}, 3321, "udp"},
{"sftu",               {NULL}, 3326, "tcp"},
{"sftu",               {NULL}, 3326, "udp"},
{"bbars",              {NULL}, 3327, "tcp"},
{"bbars",              {NULL}, 3327, "udp"},
{"egptlm",             {NULL}, 3328, "tcp"},
{"egptlm",             {NULL}, 3328, "udp"},
{"hp-device-disc",     {NULL}, 3329, "tcp"},
{"hp-device-disc",     {NULL}, 3329, "udp"},
{"mcs-calypsoicf",     {NULL}, 3330, "tcp"},
{"mcs-calypsoicf",     {NULL}, 3330, "udp"},
{"mcs-messaging",      {NULL}, 3331, "tcp"},
{"mcs-messaging",      {NULL}, 3331, "udp"},
{"mcs-mailsvr",        {NULL}, 3332, "tcp"},
{"mcs-mailsvr",        {NULL}, 3332, "udp"},
{"dec-notes",          {NULL}, 3333, "tcp"},
{"dec-notes",          {NULL}, 3333, "udp"},
{"directv-web",        {NULL}, 3334, "tcp"},
{"directv-web",        {NULL}, 3334, "udp"},
{"directv-soft",       {NULL}, 3335, "tcp"},
{"directv-soft",       {NULL}, 3335, "udp"},
{"directv-tick",       {NULL}, 3336, "tcp"},
{"directv-tick",       {NULL}, 3336, "udp"},
{"directv-catlg",      {NULL}, 3337, "tcp"},
{"directv-catlg",      {NULL}, 3337, "udp"},
{"anet-b",             {NULL}, 3338, "tcp"},
{"anet-b",             {NULL}, 3338, "udp"},
{"anet-l",             {NULL}, 3339, "tcp"},
{"anet-l",             {NULL}, 3339, "udp"},
{"anet-m",             {NULL}, 3340, "tcp"},
{"anet-m",             {NULL}, 3340, "udp"},
{"anet-h",             {NULL}, 3341, "tcp"},
{"anet-h",             {NULL}, 3341, "udp"},
{"webtie",             {NULL}, 3342, "tcp"},
{"webtie",             {NULL}, 3342, "udp"},
{"ms-cluster-net",     {NULL}, 3343, "tcp"},
{"ms-cluster-net",     {NULL}, 3343, "udp"},
{"bnt-manager",        {NULL}, 3344, "tcp"},
{"bnt-manager",        {NULL}, 3344, "udp"},
{"influence",          {NULL}, 3345, "tcp"},
{"influence",          {NULL}, 3345, "udp"},
{"trnsprntproxy",      {NULL}, 3346, "tcp"},
{"trnsprntproxy",      {NULL}, 3346, "udp"},
{"phoenix-rpc",        {NULL}, 3347, "tcp"},
{"phoenix-rpc",        {NULL}, 3347, "udp"},
{"pangolin-laser",     {NULL}, 3348, "tcp"},
{"pangolin-laser",     {NULL}, 3348, "udp"},
{"chevinservices",     {NULL}, 3349, "tcp"},
{"chevinservices",     {NULL}, 3349, "udp"},
{"findviatv",          {NULL}, 3350, "tcp"},
{"findviatv",          {NULL}, 3350, "udp"},
{"btrieve",            {NULL}, 3351, "tcp"},
{"btrieve",            {NULL}, 3351, "udp"},
{"ssql",               {NULL}, 3352, "tcp"},
{"ssql",               {NULL}, 3352, "udp"},
{"fatpipe",            {NULL}, 3353, "tcp"},
{"fatpipe",            {NULL}, 3353, "udp"},
{"suitjd",             {NULL}, 3354, "tcp"},
{"suitjd",             {NULL}, 3354, "udp"},
{"ordinox-dbase",      {NULL}, 3355, "tcp"},
{"ordinox-dbase",      {NULL}, 3355, "udp"},
{"upnotifyps",         {NULL}, 3356, "tcp"},
{"upnotifyps",         {NULL}, 3356, "udp"},
{"adtech-test",        {NULL}, 3357, "tcp"},
{"adtech-test",        {NULL}, 3357, "udp"},
{"mpsysrmsvr",         {NULL}, 3358, "tcp"},
{"mpsysrmsvr",         {NULL}, 3358, "udp"},
{"wg-netforce",        {NULL}, 3359, "tcp"},
{"wg-netforce",        {NULL}, 3359, "udp"},
{"kv-server",          {NULL}, 3360, "tcp"},
{"kv-server",          {NULL}, 3360, "udp"},
{"kv-agent",           {NULL}, 3361, "tcp"},
{"kv-agent",           {NULL}, 3361, "udp"},
{"dj-ilm",             {NULL}, 3362, "tcp"},
{"dj-ilm",             {NULL}, 3362, "udp"},
{"nati-vi-server",     {NULL}, 3363, "tcp"},
{"nati-vi-server",     {NULL}, 3363, "udp"},
{"creativeserver",     {NULL}, 3364, "tcp"},
{"creativeserver",     {NULL}, 3364, "udp"},
{"contentserver",      {NULL}, 3365, "tcp"},
{"contentserver",      {NULL}, 3365, "udp"},
{"creativepartnr",     {NULL}, 3366, "tcp"},
{"creativepartnr",     {NULL}, 3366, "udp"},
{"tip2",               {NULL}, 3372, "tcp"},
{"tip2",               {NULL}, 3372, "udp"},
{"lavenir-lm",         {NULL}, 3373, "tcp"},
{"lavenir-lm",         {NULL}, 3373, "udp"},
{"cluster-disc",       {NULL}, 3374, "tcp"},
{"cluster-disc",       {NULL}, 3374, "udp"},
{"vsnm-agent",         {NULL}, 3375, "tcp"},
{"vsnm-agent",         {NULL}, 3375, "udp"},
{"cdbroker",           {NULL}, 3376, "tcp"},
{"cdbroker",           {NULL}, 3376, "udp"},
{"cogsys-lm",          {NULL}, 3377, "tcp"},
{"cogsys-lm",          {NULL}, 3377, "udp"},
{"wsicopy",            {NULL}, 3378, "tcp"},
{"wsicopy",            {NULL}, 3378, "udp"},
{"socorfs",            {NULL}, 3379, "tcp"},
{"socorfs",            {NULL}, 3379, "udp"},
{"sns-channels",       {NULL}, 3380, "tcp"},
{"sns-channels",       {NULL}, 3380, "udp"},
{"geneous",            {NULL}, 3381, "tcp"},
{"geneous",            {NULL}, 3381, "udp"},
{"fujitsu-neat",       {NULL}, 3382, "tcp"},
{"fujitsu-neat",       {NULL}, 3382, "udp"},
{"esp-lm",             {NULL}, 3383, "tcp"},
{"esp-lm",             {NULL}, 3383, "udp"},
{"hp-clic",            {NULL}, 3384, "tcp"},
{"hp-clic",            {NULL}, 3384, "udp"},
{"qnxnetman",          {NULL}, 3385, "tcp"},
{"qnxnetman",          {NULL}, 3385, "udp"},
{"gprs-data",          {NULL}, 3386, "tcp"},
{"gprs-sig",           {NULL}, 3386, "udp"},
{"backroomnet",        {NULL}, 3387, "tcp"},
{"backroomnet",        {NULL}, 3387, "udp"},
{"cbserver",           {NULL}, 3388, "tcp"},
{"cbserver",           {NULL}, 3388, "udp"},
{"ms-wbt-server",      {NULL}, 3389, "tcp"},
{"ms-wbt-server",      {NULL}, 3389, "udp"},
{"dsc",                {NULL}, 3390, "tcp"},
{"dsc",                {NULL}, 3390, "udp"},
{"savant",             {NULL}, 3391, "tcp"},
{"savant",             {NULL}, 3391, "udp"},
{"efi-lm",             {NULL}, 3392, "tcp"},
{"efi-lm",             {NULL}, 3392, "udp"},
{"d2k-tapestry1",      {NULL}, 3393, "tcp"},
{"d2k-tapestry1",      {NULL}, 3393, "udp"},
{"d2k-tapestry2",      {NULL}, 3394, "tcp"},
{"d2k-tapestry2",      {NULL}, 3394, "udp"},
{"dyna-lm",            {NULL}, 3395, "tcp"},
{"dyna-lm",            {NULL}, 3395, "udp"},
{"printer_agent",      {NULL}, 3396, "tcp"},
{"printer_agent",      {NULL}, 3396, "udp"},
{"cloanto-lm",         {NULL}, 3397, "tcp"},
{"cloanto-lm",         {NULL}, 3397, "udp"},
{"mercantile",         {NULL}, 3398, "tcp"},
{"mercantile",         {NULL}, 3398, "udp"},
{"csms",               {NULL}, 3399, "tcp"},
{"csms",               {NULL}, 3399, "udp"},
{"csms2",              {NULL}, 3400, "tcp"},
{"csms2",              {NULL}, 3400, "udp"},
{"filecast",           {NULL}, 3401, "tcp"},
{"filecast",           {NULL}, 3401, "udp"},
{"fxaengine-net",      {NULL}, 3402, "tcp"},
{"fxaengine-net",      {NULL}, 3402, "udp"},
{"nokia-ann-ch1",      {NULL}, 3405, "tcp"},
{"nokia-ann-ch1",      {NULL}, 3405, "udp"},
{"nokia-ann-ch2",      {NULL}, 3406, "tcp"},
{"nokia-ann-ch2",      {NULL}, 3406, "udp"},
{"ldap-admin",         {NULL}, 3407, "tcp"},
{"ldap-admin",         {NULL}, 3407, "udp"},
{"BESApi",             {NULL}, 3408, "tcp"},
{"BESApi",             {NULL}, 3408, "udp"},
{"networklens",        {NULL}, 3409, "tcp"},
{"networklens",        {NULL}, 3409, "udp"},
{"networklenss",       {NULL}, 3410, "tcp"},
{"networklenss",       {NULL}, 3410, "udp"},
{"biolink-auth",       {NULL}, 3411, "tcp"},
{"biolink-auth",       {NULL}, 3411, "udp"},
{"xmlblaster",         {NULL}, 3412, "tcp"},
{"xmlblaster",         {NULL}, 3412, "udp"},
{"svnet",              {NULL}, 3413, "tcp"},
{"svnet",              {NULL}, 3413, "udp"},
{"wip-port",           {NULL}, 3414, "tcp"},
{"wip-port",           {NULL}, 3414, "udp"},
{"bcinameservice",     {NULL}, 3415, "tcp"},
{"bcinameservice",     {NULL}, 3415, "udp"},
{"commandport",        {NULL}, 3416, "tcp"},
{"commandport",        {NULL}, 3416, "udp"},
{"csvr",               {NULL}, 3417, "tcp"},
{"csvr",               {NULL}, 3417, "udp"},
{"rnmap",              {NULL}, 3418, "tcp"},
{"rnmap",              {NULL}, 3418, "udp"},
{"softaudit",          {NULL}, 3419, "tcp"},
{"softaudit",          {NULL}, 3419, "udp"},
{"ifcp-port",          {NULL}, 3420, "tcp"},
{"ifcp-port",          {NULL}, 3420, "udp"},
{"bmap",               {NULL}, 3421, "tcp"},
{"bmap",               {NULL}, 3421, "udp"},
{"rusb-sys-port",      {NULL}, 3422, "tcp"},
{"rusb-sys-port",      {NULL}, 3422, "udp"},
{"xtrm",               {NULL}, 3423, "tcp"},
{"xtrm",               {NULL}, 3423, "udp"},
{"xtrms",              {NULL}, 3424, "tcp"},
{"xtrms",              {NULL}, 3424, "udp"},
{"agps-port",          {NULL}, 3425, "tcp"},
{"agps-port",          {NULL}, 3425, "udp"},
{"arkivio",            {NULL}, 3426, "tcp"},
{"arkivio",            {NULL}, 3426, "udp"},
{"websphere-snmp",     {NULL}, 3427, "tcp"},
{"websphere-snmp",     {NULL}, 3427, "udp"},
{"twcss",              {NULL}, 3428, "tcp"},
{"twcss",              {NULL}, 3428, "udp"},
{"gcsp",               {NULL}, 3429, "tcp"},
{"gcsp",               {NULL}, 3429, "udp"},
{"ssdispatch",         {NULL}, 3430, "tcp"},
{"ssdispatch",         {NULL}, 3430, "udp"},
{"ndl-als",            {NULL}, 3431, "tcp"},
{"ndl-als",            {NULL}, 3431, "udp"},
{"osdcp",              {NULL}, 3432, "tcp"},
{"osdcp",              {NULL}, 3432, "udp"},
{"alta-smp",           {NULL}, 3433, "tcp"},
{"alta-smp",           {NULL}, 3433, "udp"},
{"opencm",             {NULL}, 3434, "tcp"},
{"opencm",             {NULL}, 3434, "udp"},
{"pacom",              {NULL}, 3435, "tcp"},
{"pacom",              {NULL}, 3435, "udp"},
{"gc-config",          {NULL}, 3436, "tcp"},
{"gc-config",          {NULL}, 3436, "udp"},
{"autocueds",          {NULL}, 3437, "tcp"},
{"autocueds",          {NULL}, 3437, "udp"},
{"spiral-admin",       {NULL}, 3438, "tcp"},
{"spiral-admin",       {NULL}, 3438, "udp"},
{"hri-port",           {NULL}, 3439, "tcp"},
{"hri-port",           {NULL}, 3439, "udp"},
{"ans-console",        {NULL}, 3440, "tcp"},
{"ans-console",        {NULL}, 3440, "udp"},
{"connect-client",     {NULL}, 3441, "tcp"},
{"connect-client",     {NULL}, 3441, "udp"},
{"connect-server",     {NULL}, 3442, "tcp"},
{"connect-server",     {NULL}, 3442, "udp"},
{"ov-nnm-websrv",      {NULL}, 3443, "tcp"},
{"ov-nnm-websrv",      {NULL}, 3443, "udp"},
{"denali-server",      {NULL}, 3444, "tcp"},
{"denali-server",      {NULL}, 3444, "udp"},
{"monp",               {NULL}, 3445, "tcp"},
{"monp",               {NULL}, 3445, "udp"},
{"3comfaxrpc",         {NULL}, 3446, "tcp"},
{"3comfaxrpc",         {NULL}, 3446, "udp"},
{"directnet",          {NULL}, 3447, "tcp"},
{"directnet",          {NULL}, 3447, "udp"},
{"dnc-port",           {NULL}, 3448, "tcp"},
{"dnc-port",           {NULL}, 3448, "udp"},
{"hotu-chat",          {NULL}, 3449, "tcp"},
{"hotu-chat",          {NULL}, 3449, "udp"},
{"castorproxy",        {NULL}, 3450, "tcp"},
{"castorproxy",        {NULL}, 3450, "udp"},
{"asam",               {NULL}, 3451, "tcp"},
{"asam",               {NULL}, 3451, "udp"},
{"sabp-signal",        {NULL}, 3452, "tcp"},
{"sabp-signal",        {NULL}, 3452, "udp"},
{"pscupd",             {NULL}, 3453, "tcp"},
{"pscupd",             {NULL}, 3453, "udp"},
{"mira",               {NULL}, 3454, "tcp"},
{"prsvp",              {NULL}, 3455, "tcp"},
{"prsvp",              {NULL}, 3455, "udp"},
{"vat",                {NULL}, 3456, "tcp"},
{"vat",                {NULL}, 3456, "udp"},
{"vat-control",        {NULL}, 3457, "tcp"},
{"vat-control",        {NULL}, 3457, "udp"},
{"d3winosfi",          {NULL}, 3458, "tcp"},
{"d3winosfi",          {NULL}, 3458, "udp"},
{"integral",           {NULL}, 3459, "tcp"},
{"integral",           {NULL}, 3459, "udp"},
{"edm-manager",        {NULL}, 3460, "tcp"},
{"edm-manager",        {NULL}, 3460, "udp"},
{"edm-stager",         {NULL}, 3461, "tcp"},
{"edm-stager",         {NULL}, 3461, "udp"},
{"edm-std-notify",     {NULL}, 3462, "tcp"},
{"edm-std-notify",     {NULL}, 3462, "udp"},
{"edm-adm-notify",     {NULL}, 3463, "tcp"},
{"edm-adm-notify",     {NULL}, 3463, "udp"},
{"edm-mgr-sync",       {NULL}, 3464, "tcp"},
{"edm-mgr-sync",       {NULL}, 3464, "udp"},
{"edm-mgr-cntrl",      {NULL}, 3465, "tcp"},
{"edm-mgr-cntrl",      {NULL}, 3465, "udp"},
{"workflow",           {NULL}, 3466, "tcp"},
{"workflow",           {NULL}, 3466, "udp"},
{"rcst",               {NULL}, 3467, "tcp"},
{"rcst",               {NULL}, 3467, "udp"},
{"ttcmremotectrl",     {NULL}, 3468, "tcp"},
{"ttcmremotectrl",     {NULL}, 3468, "udp"},
{"pluribus",           {NULL}, 3469, "tcp"},
{"pluribus",           {NULL}, 3469, "udp"},
{"jt400",              {NULL}, 3470, "tcp"},
{"jt400",              {NULL}, 3470, "udp"},
{"jt400-ssl",          {NULL}, 3471, "tcp"},
{"jt400-ssl",          {NULL}, 3471, "udp"},
{"jaugsremotec-1",     {NULL}, 3472, "tcp"},
{"jaugsremotec-1",     {NULL}, 3472, "udp"},
{"jaugsremotec-2",     {NULL}, 3473, "tcp"},
{"jaugsremotec-2",     {NULL}, 3473, "udp"},
{"ttntspauto",         {NULL}, 3474, "tcp"},
{"ttntspauto",         {NULL}, 3474, "udp"},
{"genisar-port",       {NULL}, 3475, "tcp"},
{"genisar-port",       {NULL}, 3475, "udp"},
{"nppmp",              {NULL}, 3476, "tcp"},
{"nppmp",              {NULL}, 3476, "udp"},
{"ecomm",              {NULL}, 3477, "tcp"},
{"ecomm",              {NULL}, 3477, "udp"},
{"stun",               {NULL}, 3478, "tcp"},
{"stun",               {NULL}, 3478, "udp"},
{"turn",               {NULL}, 3478, "tcp"},
{"turn",               {NULL}, 3478, "udp"},
{"stun-behavior",      {NULL}, 3478, "tcp"},
{"stun-behavior",      {NULL}, 3478, "udp"},
{"twrpc",              {NULL}, 3479, "tcp"},
{"twrpc",              {NULL}, 3479, "udp"},
{"plethora",           {NULL}, 3480, "tcp"},
{"plethora",           {NULL}, 3480, "udp"},
{"cleanerliverc",      {NULL}, 3481, "tcp"},
{"cleanerliverc",      {NULL}, 3481, "udp"},
{"vulture",            {NULL}, 3482, "tcp"},
{"vulture",            {NULL}, 3482, "udp"},
{"slim-devices",       {NULL}, 3483, "tcp"},
{"slim-devices",       {NULL}, 3483, "udp"},
{"gbs-stp",            {NULL}, 3484, "tcp"},
{"gbs-stp",            {NULL}, 3484, "udp"},
{"celatalk",           {NULL}, 3485, "tcp"},
{"celatalk",           {NULL}, 3485, "udp"},
{"ifsf-hb-port",       {NULL}, 3486, "tcp"},
{"ifsf-hb-port",       {NULL}, 3486, "udp"},
{"ltctcp",             {NULL}, 3487, "tcp"},
{"ltcudp",             {NULL}, 3487, "udp"},
{"fs-rh-srv",          {NULL}, 3488, "tcp"},
{"fs-rh-srv",          {NULL}, 3488, "udp"},
{"dtp-dia",            {NULL}, 3489, "tcp"},
{"dtp-dia",            {NULL}, 3489, "udp"},
{"colubris",           {NULL}, 3490, "tcp"},
{"colubris",           {NULL}, 3490, "udp"},
{"swr-port",           {NULL}, 3491, "tcp"},
{"swr-port",           {NULL}, 3491, "udp"},
{"tvdumtray-port",     {NULL}, 3492, "tcp"},
{"tvdumtray-port",     {NULL}, 3492, "udp"},
{"nut",                {NULL}, 3493, "tcp"},
{"nut",                {NULL}, 3493, "udp"},
{"ibm3494",            {NULL}, 3494, "tcp"},
{"ibm3494",            {NULL}, 3494, "udp"},
{"seclayer-tcp",       {NULL}, 3495, "tcp"},
{"seclayer-tcp",       {NULL}, 3495, "udp"},
{"seclayer-tls",       {NULL}, 3496, "tcp"},
{"seclayer-tls",       {NULL}, 3496, "udp"},
{"ipether232port",     {NULL}, 3497, "tcp"},
{"ipether232port",     {NULL}, 3497, "udp"},
{"dashpas-port",       {NULL}, 3498, "tcp"},
{"dashpas-port",       {NULL}, 3498, "udp"},
{"sccip-media",        {NULL}, 3499, "tcp"},
{"sccip-media",        {NULL}, 3499, "udp"},
{"rtmp-port",          {NULL}, 3500, "tcp"},
{"rtmp-port",          {NULL}, 3500, "udp"},
{"isoft-p2p",          {NULL}, 3501, "tcp"},
{"isoft-p2p",          {NULL}, 3501, "udp"},
{"avinstalldisc",      {NULL}, 3502, "tcp"},
{"avinstalldisc",      {NULL}, 3502, "udp"},
{"lsp-ping",           {NULL}, 3503, "tcp"},
{"lsp-ping",           {NULL}, 3503, "udp"},
{"ironstorm",          {NULL}, 3504, "tcp"},
{"ironstorm",          {NULL}, 3504, "udp"},
{"ccmcomm",            {NULL}, 3505, "tcp"},
{"ccmcomm",            {NULL}, 3505, "udp"},
{"apc-3506",           {NULL}, 3506, "tcp"},
{"apc-3506",           {NULL}, 3506, "udp"},
{"nesh-broker",        {NULL}, 3507, "tcp"},
{"nesh-broker",        {NULL}, 3507, "udp"},
{"interactionweb",     {NULL}, 3508, "tcp"},
{"interactionweb",     {NULL}, 3508, "udp"},
{"vt-ssl",             {NULL}, 3509, "tcp"},
{"vt-ssl",             {NULL}, 3509, "udp"},
{"xss-port",           {NULL}, 3510, "tcp"},
{"xss-port",           {NULL}, 3510, "udp"},
{"webmail-2",          {NULL}, 3511, "tcp"},
{"webmail-2",          {NULL}, 3511, "udp"},
{"aztec",              {NULL}, 3512, "tcp"},
{"aztec",              {NULL}, 3512, "udp"},
{"arcpd",              {NULL}, 3513, "tcp"},
{"arcpd",              {NULL}, 3513, "udp"},
{"must-p2p",           {NULL}, 3514, "tcp"},
{"must-p2p",           {NULL}, 3514, "udp"},
{"must-backplane",     {NULL}, 3515, "tcp"},
{"must-backplane",     {NULL}, 3515, "udp"},
{"smartcard-port",     {NULL}, 3516, "tcp"},
{"smartcard-port",     {NULL}, 3516, "udp"},
{"802-11-iapp",        {NULL}, 3517, "tcp"},
{"802-11-iapp",        {NULL}, 3517, "udp"},
{"artifact-msg",       {NULL}, 3518, "tcp"},
{"artifact-msg",       {NULL}, 3518, "udp"},
{"nvmsgd",             {NULL}, 3519, "tcp"},
{"galileo",            {NULL}, 3519, "udp"},
{"galileolog",         {NULL}, 3520, "tcp"},
{"galileolog",         {NULL}, 3520, "udp"},
{"mc3ss",              {NULL}, 3521, "tcp"},
{"mc3ss",              {NULL}, 3521, "udp"},
{"nssocketport",       {NULL}, 3522, "tcp"},
{"nssocketport",       {NULL}, 3522, "udp"},
{"odeumservlink",      {NULL}, 3523, "tcp"},
{"odeumservlink",      {NULL}, 3523, "udp"},
{"ecmport",            {NULL}, 3524, "tcp"},
{"ecmport",            {NULL}, 3524, "udp"},
{"eisport",            {NULL}, 3525, "tcp"},
{"eisport",            {NULL}, 3525, "udp"},
{"starquiz-port",      {NULL}, 3526, "tcp"},
{"starquiz-port",      {NULL}, 3526, "udp"},
{"beserver-msg-q",     {NULL}, 3527, "tcp"},
{"beserver-msg-q",     {NULL}, 3527, "udp"},
{"jboss-iiop",         {NULL}, 3528, "tcp"},
{"jboss-iiop",         {NULL}, 3528, "udp"},
{"jboss-iiop-ssl",     {NULL}, 3529, "tcp"},
{"jboss-iiop-ssl",     {NULL}, 3529, "udp"},
{"gf",                 {NULL}, 3530, "tcp"},
{"gf",                 {NULL}, 3530, "udp"},
{"joltid",             {NULL}, 3531, "tcp"},
{"joltid",             {NULL}, 3531, "udp"},
{"raven-rmp",          {NULL}, 3532, "tcp"},
{"raven-rmp",          {NULL}, 3532, "udp"},
{"raven-rdp",          {NULL}, 3533, "tcp"},
{"raven-rdp",          {NULL}, 3533, "udp"},
{"urld-port",          {NULL}, 3534, "tcp"},
{"urld-port",          {NULL}, 3534, "udp"},
{"ms-la",              {NULL}, 3535, "tcp"},
{"ms-la",              {NULL}, 3535, "udp"},
{"snac",               {NULL}, 3536, "tcp"},
{"snac",               {NULL}, 3536, "udp"},
{"ni-visa-remote",     {NULL}, 3537, "tcp"},
{"ni-visa-remote",     {NULL}, 3537, "udp"},
{"ibm-diradm",         {NULL}, 3538, "tcp"},
{"ibm-diradm",         {NULL}, 3538, "udp"},
{"ibm-diradm-ssl",     {NULL}, 3539, "tcp"},
{"ibm-diradm-ssl",     {NULL}, 3539, "udp"},
{"pnrp-port",          {NULL}, 3540, "tcp"},
{"pnrp-port",          {NULL}, 3540, "udp"},
{"voispeed-port",      {NULL}, 3541, "tcp"},
{"voispeed-port",      {NULL}, 3541, "udp"},
{"hacl-monitor",       {NULL}, 3542, "tcp"},
{"hacl-monitor",       {NULL}, 3542, "udp"},
{"qftest-lookup",      {NULL}, 3543, "tcp"},
{"qftest-lookup",      {NULL}, 3543, "udp"},
{"teredo",             {NULL}, 3544, "tcp"},
{"teredo",             {NULL}, 3544, "udp"},
{"camac",              {NULL}, 3545, "tcp"},
{"camac",              {NULL}, 3545, "udp"},
{"symantec-sim",       {NULL}, 3547, "tcp"},
{"symantec-sim",       {NULL}, 3547, "udp"},
{"interworld",         {NULL}, 3548, "tcp"},
{"interworld",         {NULL}, 3548, "udp"},
{"tellumat-nms",       {NULL}, 3549, "tcp"},
{"tellumat-nms",       {NULL}, 3549, "udp"},
{"ssmpp",              {NULL}, 3550, "tcp"},
{"ssmpp",              {NULL}, 3550, "udp"},
{"apcupsd",            {NULL}, 3551, "tcp"},
{"apcupsd",            {NULL}, 3551, "udp"},
{"taserver",           {NULL}, 3552, "tcp"},
{"taserver",           {NULL}, 3552, "udp"},
{"rbr-discovery",      {NULL}, 3553, "tcp"},
{"rbr-discovery",      {NULL}, 3553, "udp"},
{"questnotify",        {NULL}, 3554, "tcp"},
{"questnotify",        {NULL}, 3554, "udp"},
{"razor",              {NULL}, 3555, "tcp"},
{"razor",              {NULL}, 3555, "udp"},
{"sky-transport",      {NULL}, 3556, "tcp"},
{"sky-transport",      {NULL}, 3556, "udp"},
{"personalos-001",     {NULL}, 3557, "tcp"},
{"personalos-001",     {NULL}, 3557, "udp"},
{"mcp-port",           {NULL}, 3558, "tcp"},
{"mcp-port",           {NULL}, 3558, "udp"},
{"cctv-port",          {NULL}, 3559, "tcp"},
{"cctv-port",          {NULL}, 3559, "udp"},
{"iniserve-port",      {NULL}, 3560, "tcp"},
{"iniserve-port",      {NULL}, 3560, "udp"},
{"bmc-onekey",         {NULL}, 3561, "tcp"},
{"bmc-onekey",         {NULL}, 3561, "udp"},
{"sdbproxy",           {NULL}, 3562, "tcp"},
{"sdbproxy",           {NULL}, 3562, "udp"},
{"watcomdebug",        {NULL}, 3563, "tcp"},
{"watcomdebug",        {NULL}, 3563, "udp"},
{"esimport",           {NULL}, 3564, "tcp"},
{"esimport",           {NULL}, 3564, "udp"},
{"m2pa",               {NULL}, 3565, "tcp"},
{"m2pa",               {NULL}, 3565, "sctp"},
{"quest-data-hub",     {NULL}, 3566, "tcp"},
{"oap",                {NULL}, 3567, "tcp"},
{"oap",                {NULL}, 3567, "udp"},
{"oap-s",              {NULL}, 3568, "tcp"},
{"oap-s",              {NULL}, 3568, "udp"},
{"mbg-ctrl",           {NULL}, 3569, "tcp"},
{"mbg-ctrl",           {NULL}, 3569, "udp"},
{"mccwebsvr-port",     {NULL}, 3570, "tcp"},
{"mccwebsvr-port",     {NULL}, 3570, "udp"},
{"megardsvr-port",     {NULL}, 3571, "tcp"},
{"megardsvr-port",     {NULL}, 3571, "udp"},
{"megaregsvrport",     {NULL}, 3572, "tcp"},
{"megaregsvrport",     {NULL}, 3572, "udp"},
{"tag-ups-1",          {NULL}, 3573, "tcp"},
{"tag-ups-1",          {NULL}, 3573, "udp"},
{"dmaf-server",        {NULL}, 3574, "tcp"},
{"dmaf-caster",        {NULL}, 3574, "udp"},
{"ccm-port",           {NULL}, 3575, "tcp"},
{"ccm-port",           {NULL}, 3575, "udp"},
{"cmc-port",           {NULL}, 3576, "tcp"},
{"cmc-port",           {NULL}, 3576, "udp"},
{"config-port",        {NULL}, 3577, "tcp"},
{"config-port",        {NULL}, 3577, "udp"},
{"data-port",          {NULL}, 3578, "tcp"},
{"data-port",          {NULL}, 3578, "udp"},
{"ttat3lb",            {NULL}, 3579, "tcp"},
{"ttat3lb",            {NULL}, 3579, "udp"},
{"nati-svrloc",        {NULL}, 3580, "tcp"},
{"nati-svrloc",        {NULL}, 3580, "udp"},
{"kfxaclicensing",     {NULL}, 3581, "tcp"},
{"kfxaclicensing",     {NULL}, 3581, "udp"},
{"press",              {NULL}, 3582, "tcp"},
{"press",              {NULL}, 3582, "udp"},
{"canex-watch",        {NULL}, 3583, "tcp"},
{"canex-watch",        {NULL}, 3583, "udp"},
{"u-dbap",             {NULL}, 3584, "tcp"},
{"u-dbap",             {NULL}, 3584, "udp"},
{"emprise-lls",        {NULL}, 3585, "tcp"},
{"emprise-lls",        {NULL}, 3585, "udp"},
{"emprise-lsc",        {NULL}, 3586, "tcp"},
{"emprise-lsc",        {NULL}, 3586, "udp"},
{"p2pgroup",           {NULL}, 3587, "tcp"},
{"p2pgroup",           {NULL}, 3587, "udp"},
{"sentinel",           {NULL}, 3588, "tcp"},
{"sentinel",           {NULL}, 3588, "udp"},
{"isomair",            {NULL}, 3589, "tcp"},
{"isomair",            {NULL}, 3589, "udp"},
{"wv-csp-sms",         {NULL}, 3590, "tcp"},
{"wv-csp-sms",         {NULL}, 3590, "udp"},
{"gtrack-server",      {NULL}, 3591, "tcp"},
{"gtrack-server",      {NULL}, 3591, "udp"},
{"gtrack-ne",          {NULL}, 3592, "tcp"},
{"gtrack-ne",          {NULL}, 3592, "udp"},
{"bpmd",               {NULL}, 3593, "tcp"},
{"bpmd",               {NULL}, 3593, "udp"},
{"mediaspace",         {NULL}, 3594, "tcp"},
{"mediaspace",         {NULL}, 3594, "udp"},
{"shareapp",           {NULL}, 3595, "tcp"},
{"shareapp",           {NULL}, 3595, "udp"},
{"iw-mmogame",         {NULL}, 3596, "tcp"},
{"iw-mmogame",         {NULL}, 3596, "udp"},
{"a14",                {NULL}, 3597, "tcp"},
{"a14",                {NULL}, 3597, "udp"},
{"a15",                {NULL}, 3598, "tcp"},
{"a15",                {NULL}, 3598, "udp"},
{"quasar-server",      {NULL}, 3599, "tcp"},
{"quasar-server",      {NULL}, 3599, "udp"},
{"trap-daemon",        {NULL}, 3600, "tcp"},
{"trap-daemon",        {NULL}, 3600, "udp"},
{"visinet-gui",        {NULL}, 3601, "tcp"},
{"visinet-gui",        {NULL}, 3601, "udp"},
{"infiniswitchcl",     {NULL}, 3602, "tcp"},
{"infiniswitchcl",     {NULL}, 3602, "udp"},
{"int-rcv-cntrl",      {NULL}, 3603, "tcp"},
{"int-rcv-cntrl",      {NULL}, 3603, "udp"},
{"bmc-jmx-port",       {NULL}, 3604, "tcp"},
{"bmc-jmx-port",       {NULL}, 3604, "udp"},
{"comcam-io",          {NULL}, 3605, "tcp"},
{"comcam-io",          {NULL}, 3605, "udp"},
{"splitlock",          {NULL}, 3606, "tcp"},
{"splitlock",          {NULL}, 3606, "udp"},
{"precise-i3",         {NULL}, 3607, "tcp"},
{"precise-i3",         {NULL}, 3607, "udp"},
{"trendchip-dcp",      {NULL}, 3608, "tcp"},
{"trendchip-dcp",      {NULL}, 3608, "udp"},
{"cpdi-pidas-cm",      {NULL}, 3609, "tcp"},
{"cpdi-pidas-cm",      {NULL}, 3609, "udp"},
{"echonet",            {NULL}, 3610, "tcp"},
{"echonet",            {NULL}, 3610, "udp"},
{"six-degrees",        {NULL}, 3611, "tcp"},
{"six-degrees",        {NULL}, 3611, "udp"},
{"hp-dataprotect",     {NULL}, 3612, "tcp"},
{"hp-dataprotect",     {NULL}, 3612, "udp"},
{"alaris-disc",        {NULL}, 3613, "tcp"},
{"alaris-disc",        {NULL}, 3613, "udp"},
{"sigma-port",         {NULL}, 3614, "tcp"},
{"sigma-port",         {NULL}, 3614, "udp"},
{"start-network",      {NULL}, 3615, "tcp"},
{"start-network",      {NULL}, 3615, "udp"},
{"cd3o-protocol",      {NULL}, 3616, "tcp"},
{"cd3o-protocol",      {NULL}, 3616, "udp"},
{"sharp-server",       {NULL}, 3617, "tcp"},
{"sharp-server",       {NULL}, 3617, "udp"},
{"aairnet-1",          {NULL}, 3618, "tcp"},
{"aairnet-1",          {NULL}, 3618, "udp"},
{"aairnet-2",          {NULL}, 3619, "tcp"},
{"aairnet-2",          {NULL}, 3619, "udp"},
{"ep-pcp",             {NULL}, 3620, "tcp"},
{"ep-pcp",             {NULL}, 3620, "udp"},
{"ep-nsp",             {NULL}, 3621, "tcp"},
{"ep-nsp",             {NULL}, 3621, "udp"},
{"ff-lr-port",         {NULL}, 3622, "tcp"},
{"ff-lr-port",         {NULL}, 3622, "udp"},
{"haipe-discover",     {NULL}, 3623, "tcp"},
{"haipe-discover",     {NULL}, 3623, "udp"},
{"dist-upgrade",       {NULL}, 3624, "tcp"},
{"dist-upgrade",       {NULL}, 3624, "udp"},
{"volley",             {NULL}, 3625, "tcp"},
{"volley",             {NULL}, 3625, "udp"},
{"bvcdaemon-port",     {NULL}, 3626, "tcp"},
{"bvcdaemon-port",     {NULL}, 3626, "udp"},
{"jamserverport",      {NULL}, 3627, "tcp"},
{"jamserverport",      {NULL}, 3627, "udp"},
{"ept-machine",        {NULL}, 3628, "tcp"},
{"ept-machine",        {NULL}, 3628, "udp"},
{"escvpnet",           {NULL}, 3629, "tcp"},
{"escvpnet",           {NULL}, 3629, "udp"},
{"cs-remote-db",       {NULL}, 3630, "tcp"},
{"cs-remote-db",       {NULL}, 3630, "udp"},
{"cs-services",        {NULL}, 3631, "tcp"},
{"cs-services",        {NULL}, 3631, "udp"},
{"distcc",             {NULL}, 3632, "tcp"},
{"distcc",             {NULL}, 3632, "udp"},
{"wacp",               {NULL}, 3633, "tcp"},
{"wacp",               {NULL}, 3633, "udp"},
{"hlibmgr",            {NULL}, 3634, "tcp"},
{"hlibmgr",            {NULL}, 3634, "udp"},
{"sdo",                {NULL}, 3635, "tcp"},
{"sdo",                {NULL}, 3635, "udp"},
{"servistaitsm",       {NULL}, 3636, "tcp"},
{"servistaitsm",       {NULL}, 3636, "udp"},
{"scservp",            {NULL}, 3637, "tcp"},
{"scservp",            {NULL}, 3637, "udp"},
{"ehp-backup",         {NULL}, 3638, "tcp"},
{"ehp-backup",         {NULL}, 3638, "udp"},
{"xap-ha",             {NULL}, 3639, "tcp"},
{"xap-ha",             {NULL}, 3639, "udp"},
{"netplay-port1",      {NULL}, 3640, "tcp"},
{"netplay-port1",      {NULL}, 3640, "udp"},
{"netplay-port2",      {NULL}, 3641, "tcp"},
{"netplay-port2",      {NULL}, 3641, "udp"},
{"juxml-port",         {NULL}, 3642, "tcp"},
{"juxml-port",         {NULL}, 3642, "udp"},
{"audiojuggler",       {NULL}, 3643, "tcp"},
{"audiojuggler",       {NULL}, 3643, "udp"},
{"ssowatch",           {NULL}, 3644, "tcp"},
{"ssowatch",           {NULL}, 3644, "udp"},
{"cyc",                {NULL}, 3645, "tcp"},
{"cyc",                {NULL}, 3645, "udp"},
{"xss-srv-port",       {NULL}, 3646, "tcp"},
{"xss-srv-port",       {NULL}, 3646, "udp"},
{"splitlock-gw",       {NULL}, 3647, "tcp"},
{"splitlock-gw",       {NULL}, 3647, "udp"},
{"fjcp",               {NULL}, 3648, "tcp"},
{"fjcp",               {NULL}, 3648, "udp"},
{"nmmp",               {NULL}, 3649, "tcp"},
{"nmmp",               {NULL}, 3649, "udp"},
{"prismiq-plugin",     {NULL}, 3650, "tcp"},
{"prismiq-plugin",     {NULL}, 3650, "udp"},
{"xrpc-registry",      {NULL}, 3651, "tcp"},
{"xrpc-registry",      {NULL}, 3651, "udp"},
{"vxcrnbuport",        {NULL}, 3652, "tcp"},
{"vxcrnbuport",        {NULL}, 3652, "udp"},
{"tsp",                {NULL}, 3653, "tcp"},
{"tsp",                {NULL}, 3653, "udp"},
{"vaprtm",             {NULL}, 3654, "tcp"},
{"vaprtm",             {NULL}, 3654, "udp"},
{"abatemgr",           {NULL}, 3655, "tcp"},
{"abatemgr",           {NULL}, 3655, "udp"},
{"abatjss",            {NULL}, 3656, "tcp"},
{"abatjss",            {NULL}, 3656, "udp"},
{"immedianet-bcn",     {NULL}, 3657, "tcp"},
{"immedianet-bcn",     {NULL}, 3657, "udp"},
{"ps-ams",             {NULL}, 3658, "tcp"},
{"ps-ams",             {NULL}, 3658, "udp"},
{"apple-sasl",         {NULL}, 3659, "tcp"},
{"apple-sasl",         {NULL}, 3659, "udp"},
{"can-nds-ssl",        {NULL}, 3660, "tcp"},
{"can-nds-ssl",        {NULL}, 3660, "udp"},
{"can-ferret-ssl",     {NULL}, 3661, "tcp"},
{"can-ferret-ssl",     {NULL}, 3661, "udp"},
{"pserver",            {NULL}, 3662, "tcp"},
{"pserver",            {NULL}, 3662, "udp"},
{"dtp",                {NULL}, 3663, "tcp"},
{"dtp",                {NULL}, 3663, "udp"},
{"ups-engine",         {NULL}, 3664, "tcp"},
{"ups-engine",         {NULL}, 3664, "udp"},
{"ent-engine",         {NULL}, 3665, "tcp"},
{"ent-engine",         {NULL}, 3665, "udp"},
{"eserver-pap",        {NULL}, 3666, "tcp"},
{"eserver-pap",        {NULL}, 3666, "udp"},
{"infoexch",           {NULL}, 3667, "tcp"},
{"infoexch",           {NULL}, 3667, "udp"},
{"dell-rm-port",       {NULL}, 3668, "tcp"},
{"dell-rm-port",       {NULL}, 3668, "udp"},
{"casanswmgmt",        {NULL}, 3669, "tcp"},
{"casanswmgmt",        {NULL}, 3669, "udp"},
{"smile",              {NULL}, 3670, "tcp"},
{"smile",              {NULL}, 3670, "udp"},
{"efcp",               {NULL}, 3671, "tcp"},
{"efcp",               {NULL}, 3671, "udp"},
{"lispworks-orb",      {NULL}, 3672, "tcp"},
{"lispworks-orb",      {NULL}, 3672, "udp"},
{"mediavault-gui",     {NULL}, 3673, "tcp"},
{"mediavault-gui",     {NULL}, 3673, "udp"},
{"wininstall-ipc",     {NULL}, 3674, "tcp"},
{"wininstall-ipc",     {NULL}, 3674, "udp"},
{"calltrax",           {NULL}, 3675, "tcp"},
{"calltrax",           {NULL}, 3675, "udp"},
{"va-pacbase",         {NULL}, 3676, "tcp"},
{"va-pacbase",         {NULL}, 3676, "udp"},
{"roverlog",           {NULL}, 3677, "tcp"},
{"roverlog",           {NULL}, 3677, "udp"},
{"ipr-dglt",           {NULL}, 3678, "tcp"},
{"ipr-dglt",           {NULL}, 3678, "udp"},
{"newton-dock",        {NULL}, 3679, "tcp"},
{"newton-dock",        {NULL}, 3679, "udp"},
{"npds-tracker",       {NULL}, 3680, "tcp"},
{"npds-tracker",       {NULL}, 3680, "udp"},
{"bts-x73",            {NULL}, 3681, "tcp"},
{"bts-x73",            {NULL}, 3681, "udp"},
{"cas-mapi",           {NULL}, 3682, "tcp"},
{"cas-mapi",           {NULL}, 3682, "udp"},
{"bmc-ea",             {NULL}, 3683, "tcp"},
{"bmc-ea",             {NULL}, 3683, "udp"},
{"faxstfx-port",       {NULL}, 3684, "tcp"},
{"faxstfx-port",       {NULL}, 3684, "udp"},
{"dsx-agent",          {NULL}, 3685, "tcp"},
{"dsx-agent",          {NULL}, 3685, "udp"},
{"tnmpv2",             {NULL}, 3686, "tcp"},
{"tnmpv2",             {NULL}, 3686, "udp"},
{"simple-push",        {NULL}, 3687, "tcp"},
{"simple-push",        {NULL}, 3687, "udp"},
{"simple-push-s",      {NULL}, 3688, "tcp"},
{"simple-push-s",      {NULL}, 3688, "udp"},
{"daap",               {NULL}, 3689, "tcp"},
{"daap",               {NULL}, 3689, "udp"},
{"svn",                {NULL}, 3690, "tcp"},
{"svn",                {NULL}, 3690, "udp"},
{"magaya-network",     {NULL}, 3691, "tcp"},
{"magaya-network",     {NULL}, 3691, "udp"},
{"intelsync",          {NULL}, 3692, "tcp"},
{"intelsync",          {NULL}, 3692, "udp"},
{"bmc-data-coll",      {NULL}, 3695, "tcp"},
{"bmc-data-coll",      {NULL}, 3695, "udp"},
{"telnetcpcd",         {NULL}, 3696, "tcp"},
{"telnetcpcd",         {NULL}, 3696, "udp"},
{"nw-license",         {NULL}, 3697, "tcp"},
{"nw-license",         {NULL}, 3697, "udp"},
{"sagectlpanel",       {NULL}, 3698, "tcp"},
{"sagectlpanel",       {NULL}, 3698, "udp"},
{"kpn-icw",            {NULL}, 3699, "tcp"},
{"kpn-icw",            {NULL}, 3699, "udp"},
{"lrs-paging",         {NULL}, 3700, "tcp"},
{"lrs-paging",         {NULL}, 3700, "udp"},
{"netcelera",          {NULL}, 3701, "tcp"},
{"netcelera",          {NULL}, 3701, "udp"},
{"ws-discovery",       {NULL}, 3702, "tcp"},
{"ws-discovery",       {NULL}, 3702, "udp"},
{"adobeserver-3",      {NULL}, 3703, "tcp"},
{"adobeserver-3",      {NULL}, 3703, "udp"},
{"adobeserver-4",      {NULL}, 3704, "tcp"},
{"adobeserver-4",      {NULL}, 3704, "udp"},
{"adobeserver-5",      {NULL}, 3705, "tcp"},
{"adobeserver-5",      {NULL}, 3705, "udp"},
{"rt-event",           {NULL}, 3706, "tcp"},
{"rt-event",           {NULL}, 3706, "udp"},
{"rt-event-s",         {NULL}, 3707, "tcp"},
{"rt-event-s",         {NULL}, 3707, "udp"},
{"sun-as-iiops",       {NULL}, 3708, "tcp"},
{"sun-as-iiops",       {NULL}, 3708, "udp"},
{"ca-idms",            {NULL}, 3709, "tcp"},
{"ca-idms",            {NULL}, 3709, "udp"},
{"portgate-auth",      {NULL}, 3710, "tcp"},
{"portgate-auth",      {NULL}, 3710, "udp"},
{"edb-server2",        {NULL}, 3711, "tcp"},
{"edb-server2",        {NULL}, 3711, "udp"},
{"sentinel-ent",       {NULL}, 3712, "tcp"},
{"sentinel-ent",       {NULL}, 3712, "udp"},
{"tftps",              {NULL}, 3713, "tcp"},
{"tftps",              {NULL}, 3713, "udp"},
{"delos-dms",          {NULL}, 3714, "tcp"},
{"delos-dms",          {NULL}, 3714, "udp"},
{"anoto-rendezv",      {NULL}, 3715, "tcp"},
{"anoto-rendezv",      {NULL}, 3715, "udp"},
{"wv-csp-sms-cir",     {NULL}, 3716, "tcp"},
{"wv-csp-sms-cir",     {NULL}, 3716, "udp"},
{"wv-csp-udp-cir",     {NULL}, 3717, "tcp"},
{"wv-csp-udp-cir",     {NULL}, 3717, "udp"},
{"opus-services",      {NULL}, 3718, "tcp"},
{"opus-services",      {NULL}, 3718, "udp"},
{"itelserverport",     {NULL}, 3719, "tcp"},
{"itelserverport",     {NULL}, 3719, "udp"},
{"ufastro-instr",      {NULL}, 3720, "tcp"},
{"ufastro-instr",      {NULL}, 3720, "udp"},
{"xsync",              {NULL}, 3721, "tcp"},
{"xsync",              {NULL}, 3721, "udp"},
{"xserveraid",         {NULL}, 3722, "tcp"},
{"xserveraid",         {NULL}, 3722, "udp"},
{"sychrond",           {NULL}, 3723, "tcp"},
{"sychrond",           {NULL}, 3723, "udp"},
{"blizwow",            {NULL}, 3724, "tcp"},
{"blizwow",            {NULL}, 3724, "udp"},
{"na-er-tip",          {NULL}, 3725, "tcp"},
{"na-er-tip",          {NULL}, 3725, "udp"},
{"array-manager",      {NULL}, 3726, "tcp"},
{"array-manager",      {NULL}, 3726, "udp"},
{"e-mdu",              {NULL}, 3727, "tcp"},
{"e-mdu",              {NULL}, 3727, "udp"},
{"e-woa",              {NULL}, 3728, "tcp"},
{"e-woa",              {NULL}, 3728, "udp"},
{"fksp-audit",         {NULL}, 3729, "tcp"},
{"fksp-audit",         {NULL}, 3729, "udp"},
{"client-ctrl",        {NULL}, 3730, "tcp"},
{"client-ctrl",        {NULL}, 3730, "udp"},
{"smap",               {NULL}, 3731, "tcp"},
{"smap",               {NULL}, 3731, "udp"},
{"m-wnn",              {NULL}, 3732, "tcp"},
{"m-wnn",              {NULL}, 3732, "udp"},
{"multip-msg",         {NULL}, 3733, "tcp"},
{"multip-msg",         {NULL}, 3733, "udp"},
{"synel-data",         {NULL}, 3734, "tcp"},
{"synel-data",         {NULL}, 3734, "udp"},
{"pwdis",              {NULL}, 3735, "tcp"},
{"pwdis",              {NULL}, 3735, "udp"},
{"rs-rmi",             {NULL}, 3736, "tcp"},
{"rs-rmi",             {NULL}, 3736, "udp"},
{"xpanel",             {NULL}, 3737, "tcp"},
{"versatalk",          {NULL}, 3738, "tcp"},
{"versatalk",          {NULL}, 3738, "udp"},
{"launchbird-lm",      {NULL}, 3739, "tcp"},
{"launchbird-lm",      {NULL}, 3739, "udp"},
{"heartbeat",          {NULL}, 3740, "tcp"},
{"heartbeat",          {NULL}, 3740, "udp"},
{"wysdma",             {NULL}, 3741, "tcp"},
{"wysdma",             {NULL}, 3741, "udp"},
{"cst-port",           {NULL}, 3742, "tcp"},
{"cst-port",           {NULL}, 3742, "udp"},
{"ipcs-command",       {NULL}, 3743, "tcp"},
{"ipcs-command",       {NULL}, 3743, "udp"},
{"sasg",               {NULL}, 3744, "tcp"},
{"sasg",               {NULL}, 3744, "udp"},
{"gw-call-port",       {NULL}, 3745, "tcp"},
{"gw-call-port",       {NULL}, 3745, "udp"},
{"linktest",           {NULL}, 3746, "tcp"},
{"linktest",           {NULL}, 3746, "udp"},
{"linktest-s",         {NULL}, 3747, "tcp"},
{"linktest-s",         {NULL}, 3747, "udp"},
{"webdata",            {NULL}, 3748, "tcp"},
{"webdata",            {NULL}, 3748, "udp"},
{"cimtrak",            {NULL}, 3749, "tcp"},
{"cimtrak",            {NULL}, 3749, "udp"},
{"cbos-ip-port",       {NULL}, 3750, "tcp"},
{"cbos-ip-port",       {NULL}, 3750, "udp"},
{"gprs-cube",          {NULL}, 3751, "tcp"},
{"gprs-cube",          {NULL}, 3751, "udp"},
{"vipremoteagent",     {NULL}, 3752, "tcp"},
{"vipremoteagent",     {NULL}, 3752, "udp"},
{"nattyserver",        {NULL}, 3753, "tcp"},
{"nattyserver",        {NULL}, 3753, "udp"},
{"timestenbroker",     {NULL}, 3754, "tcp"},
{"timestenbroker",     {NULL}, 3754, "udp"},
{"sas-remote-hlp",     {NULL}, 3755, "tcp"},
{"sas-remote-hlp",     {NULL}, 3755, "udp"},
{"canon-capt",         {NULL}, 3756, "tcp"},
{"canon-capt",         {NULL}, 3756, "udp"},
{"grf-port",           {NULL}, 3757, "tcp"},
{"grf-port",           {NULL}, 3757, "udp"},
{"apw-registry",       {NULL}, 3758, "tcp"},
{"apw-registry",       {NULL}, 3758, "udp"},
{"exapt-lmgr",         {NULL}, 3759, "tcp"},
{"exapt-lmgr",         {NULL}, 3759, "udp"},
{"adtempusclient",     {NULL}, 3760, "tcp"},
{"adtempusclient",     {NULL}, 3760, "udp"},
{"gsakmp",             {NULL}, 3761, "tcp"},
{"gsakmp",             {NULL}, 3761, "udp"},
{"gbs-smp",            {NULL}, 3762, "tcp"},
{"gbs-smp",            {NULL}, 3762, "udp"},
{"xo-wave",            {NULL}, 3763, "tcp"},
{"xo-wave",            {NULL}, 3763, "udp"},
{"mni-prot-rout",      {NULL}, 3764, "tcp"},
{"mni-prot-rout",      {NULL}, 3764, "udp"},
{"rtraceroute",        {NULL}, 3765, "tcp"},
{"rtraceroute",        {NULL}, 3765, "udp"},
{"listmgr-port",       {NULL}, 3767, "tcp"},
{"listmgr-port",       {NULL}, 3767, "udp"},
{"rblcheckd",          {NULL}, 3768, "tcp"},
{"rblcheckd",          {NULL}, 3768, "udp"},
{"haipe-otnk",         {NULL}, 3769, "tcp"},
{"haipe-otnk",         {NULL}, 3769, "udp"},
{"cindycollab",        {NULL}, 3770, "tcp"},
{"cindycollab",        {NULL}, 3770, "udp"},
{"paging-port",        {NULL}, 3771, "tcp"},
{"paging-port",        {NULL}, 3771, "udp"},
{"ctp",                {NULL}, 3772, "tcp"},
{"ctp",                {NULL}, 3772, "udp"},
{"ctdhercules",        {NULL}, 3773, "tcp"},
{"ctdhercules",        {NULL}, 3773, "udp"},
{"zicom",              {NULL}, 3774, "tcp"},
{"zicom",              {NULL}, 3774, "udp"},
{"ispmmgr",            {NULL}, 3775, "tcp"},
{"ispmmgr",            {NULL}, 3775, "udp"},
{"dvcprov-port",       {NULL}, 3776, "tcp"},
{"dvcprov-port",       {NULL}, 3776, "udp"},
{"jibe-eb",            {NULL}, 3777, "tcp"},
{"jibe-eb",            {NULL}, 3777, "udp"},
{"c-h-it-port",        {NULL}, 3778, "tcp"},
{"c-h-it-port",        {NULL}, 3778, "udp"},
{"cognima",            {NULL}, 3779, "tcp"},
{"cognima",            {NULL}, 3779, "udp"},
{"nnp",                {NULL}, 3780, "tcp"},
{"nnp",                {NULL}, 3780, "udp"},
{"abcvoice-port",      {NULL}, 3781, "tcp"},
{"abcvoice-port",      {NULL}, 3781, "udp"},
{"iso-tp0s",           {NULL}, 3782, "tcp"},
{"iso-tp0s",           {NULL}, 3782, "udp"},
{"bim-pem",            {NULL}, 3783, "tcp"},
{"bim-pem",            {NULL}, 3783, "udp"},
{"bfd-control",        {NULL}, 3784, "tcp"},
{"bfd-control",        {NULL}, 3784, "udp"},
{"bfd-echo",           {NULL}, 3785, "tcp"},
{"bfd-echo",           {NULL}, 3785, "udp"},
{"upstriggervsw",      {NULL}, 3786, "tcp"},
{"upstriggervsw",      {NULL}, 3786, "udp"},
{"fintrx",             {NULL}, 3787, "tcp"},
{"fintrx",             {NULL}, 3787, "udp"},
{"isrp-port",          {NULL}, 3788, "tcp"},
{"isrp-port",          {NULL}, 3788, "udp"},
{"remotedeploy",       {NULL}, 3789, "tcp"},
{"remotedeploy",       {NULL}, 3789, "udp"},
{"quickbooksrds",      {NULL}, 3790, "tcp"},
{"quickbooksrds",      {NULL}, 3790, "udp"},
{"tvnetworkvideo",     {NULL}, 3791, "tcp"},
{"tvnetworkvideo",     {NULL}, 3791, "udp"},
{"sitewatch",          {NULL}, 3792, "tcp"},
{"sitewatch",          {NULL}, 3792, "udp"},
{"dcsoftware",         {NULL}, 3793, "tcp"},
{"dcsoftware",         {NULL}, 3793, "udp"},
{"jaus",               {NULL}, 3794, "tcp"},
{"jaus",               {NULL}, 3794, "udp"},
{"myblast",            {NULL}, 3795, "tcp"},
{"myblast",            {NULL}, 3795, "udp"},
{"spw-dialer",         {NULL}, 3796, "tcp"},
{"spw-dialer",         {NULL}, 3796, "udp"},
{"idps",               {NULL}, 3797, "tcp"},
{"idps",               {NULL}, 3797, "udp"},
{"minilock",           {NULL}, 3798, "tcp"},
{"minilock",           {NULL}, 3798, "udp"},
{"radius-dynauth",     {NULL}, 3799, "tcp"},
{"radius-dynauth",     {NULL}, 3799, "udp"},
{"pwgpsi",             {NULL}, 3800, "tcp"},
{"pwgpsi",             {NULL}, 3800, "udp"},
{"ibm-mgr",            {NULL}, 3801, "tcp"},
{"ibm-mgr",            {NULL}, 3801, "udp"},
{"vhd",                {NULL}, 3802, "tcp"},
{"vhd",                {NULL}, 3802, "udp"},
{"soniqsync",          {NULL}, 3803, "tcp"},
{"soniqsync",          {NULL}, 3803, "udp"},
{"iqnet-port",         {NULL}, 3804, "tcp"},
{"iqnet-port",         {NULL}, 3804, "udp"},
{"tcpdataserver",      {NULL}, 3805, "tcp"},
{"tcpdataserver",      {NULL}, 3805, "udp"},
{"wsmlb",              {NULL}, 3806, "tcp"},
{"wsmlb",              {NULL}, 3806, "udp"},
{"spugna",             {NULL}, 3807, "tcp"},
{"spugna",             {NULL}, 3807, "udp"},
{"sun-as-iiops-ca",    {NULL}, 3808, "tcp"},
{"sun-as-iiops-ca",    {NULL}, 3808, "udp"},
{"apocd",              {NULL}, 3809, "tcp"},
{"apocd",              {NULL}, 3809, "udp"},
{"wlanauth",           {NULL}, 3810, "tcp"},
{"wlanauth",           {NULL}, 3810, "udp"},
{"amp",                {NULL}, 3811, "tcp"},
{"amp",                {NULL}, 3811, "udp"},
{"neto-wol-server",    {NULL}, 3812, "tcp"},
{"neto-wol-server",    {NULL}, 3812, "udp"},
{"rap-ip",             {NULL}, 3813, "tcp"},
{"rap-ip",             {NULL}, 3813, "udp"},
{"neto-dcs",           {NULL}, 3814, "tcp"},
{"neto-dcs",           {NULL}, 3814, "udp"},
{"lansurveyorxml",     {NULL}, 3815, "tcp"},
{"lansurveyorxml",     {NULL}, 3815, "udp"},
{"sunlps-http",        {NULL}, 3816, "tcp"},
{"sunlps-http",        {NULL}, 3816, "udp"},
{"tapeware",           {NULL}, 3817, "tcp"},
{"tapeware",           {NULL}, 3817, "udp"},
{"crinis-hb",          {NULL}, 3818, "tcp"},
{"crinis-hb",          {NULL}, 3818, "udp"},
{"epl-slp",            {NULL}, 3819, "tcp"},
{"epl-slp",            {NULL}, 3819, "udp"},
{"scp",                {NULL}, 3820, "tcp"},
{"scp",                {NULL}, 3820, "udp"},
{"pmcp",               {NULL}, 3821, "tcp"},
{"pmcp",               {NULL}, 3821, "udp"},
{"acp-discovery",      {NULL}, 3822, "tcp"},
{"acp-discovery",      {NULL}, 3822, "udp"},
{"acp-conduit",        {NULL}, 3823, "tcp"},
{"acp-conduit",        {NULL}, 3823, "udp"},
{"acp-policy",         {NULL}, 3824, "tcp"},
{"acp-policy",         {NULL}, 3824, "udp"},
{"ffserver",           {NULL}, 3825, "tcp"},
{"ffserver",           {NULL}, 3825, "udp"},
{"wormux",             {NULL}, 3826, "tcp"},
{"wormux",             {NULL}, 3826, "udp"},
{"netmpi",             {NULL}, 3827, "tcp"},
{"netmpi",             {NULL}, 3827, "udp"},
{"neteh",              {NULL}, 3828, "tcp"},
{"neteh",              {NULL}, 3828, "udp"},
{"neteh-ext",          {NULL}, 3829, "tcp"},
{"neteh-ext",          {NULL}, 3829, "udp"},
{"cernsysmgmtagt",     {NULL}, 3830, "tcp"},
{"cernsysmgmtagt",     {NULL}, 3830, "udp"},
{"dvapps",             {NULL}, 3831, "tcp"},
{"dvapps",             {NULL}, 3831, "udp"},
{"xxnetserver",        {NULL}, 3832, "tcp"},
{"xxnetserver",        {NULL}, 3832, "udp"},
{"aipn-auth",          {NULL}, 3833, "tcp"},
{"aipn-auth",          {NULL}, 3833, "udp"},
{"spectardata",        {NULL}, 3834, "tcp"},
{"spectardata",        {NULL}, 3834, "udp"},
{"spectardb",          {NULL}, 3835, "tcp"},
{"spectardb",          {NULL}, 3835, "udp"},
{"markem-dcp",         {NULL}, 3836, "tcp"},
{"markem-dcp",         {NULL}, 3836, "udp"},
{"mkm-discovery",      {NULL}, 3837, "tcp"},
{"mkm-discovery",      {NULL}, 3837, "udp"},
{"sos",                {NULL}, 3838, "tcp"},
{"sos",                {NULL}, 3838, "udp"},
{"amx-rms",            {NULL}, 3839, "tcp"},
{"amx-rms",            {NULL}, 3839, "udp"},
{"flirtmitmir",        {NULL}, 3840, "tcp"},
{"flirtmitmir",        {NULL}, 3840, "udp"},
{"zfirm-shiprush3",    {NULL}, 3841, "tcp"},
{"zfirm-shiprush3",    {NULL}, 3841, "udp"},
{"nhci",               {NULL}, 3842, "tcp"},
{"nhci",               {NULL}, 3842, "udp"},
{"quest-agent",        {NULL}, 3843, "tcp"},
{"quest-agent",        {NULL}, 3843, "udp"},
{"rnm",                {NULL}, 3844, "tcp"},
{"rnm",                {NULL}, 3844, "udp"},
{"v-one-spp",          {NULL}, 3845, "tcp"},
{"v-one-spp",          {NULL}, 3845, "udp"},
{"an-pcp",             {NULL}, 3846, "tcp"},
{"an-pcp",             {NULL}, 3846, "udp"},
{"msfw-control",       {NULL}, 3847, "tcp"},
{"msfw-control",       {NULL}, 3847, "udp"},
{"item",               {NULL}, 3848, "tcp"},
{"item",               {NULL}, 3848, "udp"},
{"spw-dnspreload",     {NULL}, 3849, "tcp"},
{"spw-dnspreload",     {NULL}, 3849, "udp"},
{"qtms-bootstrap",     {NULL}, 3850, "tcp"},
{"qtms-bootstrap",     {NULL}, 3850, "udp"},
{"spectraport",        {NULL}, 3851, "tcp"},
{"spectraport",        {NULL}, 3851, "udp"},
{"sse-app-config",     {NULL}, 3852, "tcp"},
{"sse-app-config",     {NULL}, 3852, "udp"},
{"sscan",              {NULL}, 3853, "tcp"},
{"sscan",              {NULL}, 3853, "udp"},
{"stryker-com",        {NULL}, 3854, "tcp"},
{"stryker-com",        {NULL}, 3854, "udp"},
{"opentrac",           {NULL}, 3855, "tcp"},
{"opentrac",           {NULL}, 3855, "udp"},
{"informer",           {NULL}, 3856, "tcp"},
{"informer",           {NULL}, 3856, "udp"},
{"trap-port",          {NULL}, 3857, "tcp"},
{"trap-port",          {NULL}, 3857, "udp"},
{"trap-port-mom",      {NULL}, 3858, "tcp"},
{"trap-port-mom",      {NULL}, 3858, "udp"},
{"nav-port",           {NULL}, 3859, "tcp"},
{"nav-port",           {NULL}, 3859, "udp"},
{"sasp",               {NULL}, 3860, "tcp"},
{"sasp",               {NULL}, 3860, "udp"},
{"winshadow-hd",       {NULL}, 3861, "tcp"},
{"winshadow-hd",       {NULL}, 3861, "udp"},
{"giga-pocket",        {NULL}, 3862, "tcp"},
{"giga-pocket",        {NULL}, 3862, "udp"},
{"asap-tcp",           {NULL}, 3863, "tcp"},
{"asap-udp",           {NULL}, 3863, "udp"},
{"asap-sctp",          {NULL}, 3863, "sctp"},
{"asap-tcp-tls",       {NULL}, 3864, "tcp"},
{"asap-sctp-tls",      {NULL}, 3864, "sctp"},
{"xpl",                {NULL}, 3865, "tcp"},
{"xpl",                {NULL}, 3865, "udp"},
{"dzdaemon",           {NULL}, 3866, "tcp"},
{"dzdaemon",           {NULL}, 3866, "udp"},
{"dzoglserver",        {NULL}, 3867, "tcp"},
{"dzoglserver",        {NULL}, 3867, "udp"},
{"diameter",           {NULL}, 3868, "tcp"},
{"diameter",           {NULL}, 3868, "sctp"},
{"ovsam-mgmt",         {NULL}, 3869, "tcp"},
{"ovsam-mgmt",         {NULL}, 3869, "udp"},
{"ovsam-d-agent",      {NULL}, 3870, "tcp"},
{"ovsam-d-agent",      {NULL}, 3870, "udp"},
{"avocent-adsap",      {NULL}, 3871, "tcp"},
{"avocent-adsap",      {NULL}, 3871, "udp"},
{"oem-agent",          {NULL}, 3872, "tcp"},
{"oem-agent",          {NULL}, 3872, "udp"},
{"fagordnc",           {NULL}, 3873, "tcp"},
{"fagordnc",           {NULL}, 3873, "udp"},
{"sixxsconfig",        {NULL}, 3874, "tcp"},
{"sixxsconfig",        {NULL}, 3874, "udp"},
{"pnbscada",           {NULL}, 3875, "tcp"},
{"pnbscada",           {NULL}, 3875, "udp"},
{"dl_agent",           {NULL}, 3876, "tcp"},
{"dl_agent",           {NULL}, 3876, "udp"},
{"xmpcr-interface",    {NULL}, 3877, "tcp"},
{"xmpcr-interface",    {NULL}, 3877, "udp"},
{"fotogcad",           {NULL}, 3878, "tcp"},
{"fotogcad",           {NULL}, 3878, "udp"},
{"appss-lm",           {NULL}, 3879, "tcp"},
{"appss-lm",           {NULL}, 3879, "udp"},
{"igrs",               {NULL}, 3880, "tcp"},
{"igrs",               {NULL}, 3880, "udp"},
{"idac",               {NULL}, 3881, "tcp"},
{"idac",               {NULL}, 3881, "udp"},
{"msdts1",             {NULL}, 3882, "tcp"},
{"msdts1",             {NULL}, 3882, "udp"},
{"vrpn",               {NULL}, 3883, "tcp"},
{"vrpn",               {NULL}, 3883, "udp"},
{"softrack-meter",     {NULL}, 3884, "tcp"},
{"softrack-meter",     {NULL}, 3884, "udp"},
{"topflow-ssl",        {NULL}, 3885, "tcp"},
{"topflow-ssl",        {NULL}, 3885, "udp"},
{"nei-management",     {NULL}, 3886, "tcp"},
{"nei-management",     {NULL}, 3886, "udp"},
{"ciphire-data",       {NULL}, 3887, "tcp"},
{"ciphire-data",       {NULL}, 3887, "udp"},
{"ciphire-serv",       {NULL}, 3888, "tcp"},
{"ciphire-serv",       {NULL}, 3888, "udp"},
{"dandv-tester",       {NULL}, 3889, "tcp"},
{"dandv-tester",       {NULL}, 3889, "udp"},
{"ndsconnect",         {NULL}, 3890, "tcp"},
{"ndsconnect",         {NULL}, 3890, "udp"},
{"rtc-pm-port",        {NULL}, 3891, "tcp"},
{"rtc-pm-port",        {NULL}, 3891, "udp"},
{"pcc-image-port",     {NULL}, 3892, "tcp"},
{"pcc-image-port",     {NULL}, 3892, "udp"},
{"cgi-starapi",        {NULL}, 3893, "tcp"},
{"cgi-starapi",        {NULL}, 3893, "udp"},
{"syam-agent",         {NULL}, 3894, "tcp"},
{"syam-agent",         {NULL}, 3894, "udp"},
{"syam-smc",           {NULL}, 3895, "tcp"},
{"syam-smc",           {NULL}, 3895, "udp"},
{"sdo-tls",            {NULL}, 3896, "tcp"},
{"sdo-tls",            {NULL}, 3896, "udp"},
{"sdo-ssh",            {NULL}, 3897, "tcp"},
{"sdo-ssh",            {NULL}, 3897, "udp"},
{"senip",              {NULL}, 3898, "tcp"},
{"senip",              {NULL}, 3898, "udp"},
{"itv-control",        {NULL}, 3899, "tcp"},
{"itv-control",        {NULL}, 3899, "udp"},
{"udt_os",             {NULL}, 3900, "tcp"},
{"udt_os",             {NULL}, 3900, "udp"},
{"nimsh",              {NULL}, 3901, "tcp"},
{"nimsh",              {NULL}, 3901, "udp"},
{"nimaux",             {NULL}, 3902, "tcp"},
{"nimaux",             {NULL}, 3902, "udp"},
{"charsetmgr",         {NULL}, 3903, "tcp"},
{"charsetmgr",         {NULL}, 3903, "udp"},
{"omnilink-port",      {NULL}, 3904, "tcp"},
{"omnilink-port",      {NULL}, 3904, "udp"},
{"mupdate",            {NULL}, 3905, "tcp"},
{"mupdate",            {NULL}, 3905, "udp"},
{"topovista-data",     {NULL}, 3906, "tcp"},
{"topovista-data",     {NULL}, 3906, "udp"},
{"imoguia-port",       {NULL}, 3907, "tcp"},
{"imoguia-port",       {NULL}, 3907, "udp"},
{"hppronetman",        {NULL}, 3908, "tcp"},
{"hppronetman",        {NULL}, 3908, "udp"},
{"surfcontrolcpa",     {NULL}, 3909, "tcp"},
{"surfcontrolcpa",     {NULL}, 3909, "udp"},
{"prnrequest",         {NULL}, 3910, "tcp"},
{"prnrequest",         {NULL}, 3910, "udp"},
{"prnstatus",          {NULL}, 3911, "tcp"},
{"prnstatus",          {NULL}, 3911, "udp"},
{"gbmt-stars",         {NULL}, 3912, "tcp"},
{"gbmt-stars",         {NULL}, 3912, "udp"},
{"listcrt-port",       {NULL}, 3913, "tcp"},
{"listcrt-port",       {NULL}, 3913, "udp"},
{"listcrt-port-2",     {NULL}, 3914, "tcp"},
{"listcrt-port-2",     {NULL}, 3914, "udp"},
{"agcat",              {NULL}, 3915, "tcp"},
{"agcat",              {NULL}, 3915, "udp"},
{"wysdmc",             {NULL}, 3916, "tcp"},
{"wysdmc",             {NULL}, 3916, "udp"},
{"aftmux",             {NULL}, 3917, "tcp"},
{"aftmux",             {NULL}, 3917, "udp"},
{"pktcablemmcops",     {NULL}, 3918, "tcp"},
{"pktcablemmcops",     {NULL}, 3918, "udp"},
{"hyperip",            {NULL}, 3919, "tcp"},
{"hyperip",            {NULL}, 3919, "udp"},
{"exasoftport1",       {NULL}, 3920, "tcp"},
{"exasoftport1",       {NULL}, 3920, "udp"},
{"herodotus-net",      {NULL}, 3921, "tcp"},
{"herodotus-net",      {NULL}, 3921, "udp"},
{"sor-update",         {NULL}, 3922, "tcp"},
{"sor-update",         {NULL}, 3922, "udp"},
{"symb-sb-port",       {NULL}, 3923, "tcp"},
{"symb-sb-port",       {NULL}, 3923, "udp"},
{"mpl-gprs-port",      {NULL}, 3924, "tcp"},
{"mpl-gprs-port",      {NULL}, 3924, "udp"},
{"zmp",                {NULL}, 3925, "tcp"},
{"zmp",                {NULL}, 3925, "udp"},
{"winport",            {NULL}, 3926, "tcp"},
{"winport",            {NULL}, 3926, "udp"},
{"natdataservice",     {NULL}, 3927, "tcp"},
{"natdataservice",     {NULL}, 3927, "udp"},
{"netboot-pxe",        {NULL}, 3928, "tcp"},
{"netboot-pxe",        {NULL}, 3928, "udp"},
{"smauth-port",        {NULL}, 3929, "tcp"},
{"smauth-port",        {NULL}, 3929, "udp"},
{"syam-webserver",     {NULL}, 3930, "tcp"},
{"syam-webserver",     {NULL}, 3930, "udp"},
{"msr-plugin-port",    {NULL}, 3931, "tcp"},
{"msr-plugin-port",    {NULL}, 3931, "udp"},
{"dyn-site",           {NULL}, 3932, "tcp"},
{"dyn-site",           {NULL}, 3932, "udp"},
{"plbserve-port",      {NULL}, 3933, "tcp"},
{"plbserve-port",      {NULL}, 3933, "udp"},
{"sunfm-port",         {NULL}, 3934, "tcp"},
{"sunfm-port",         {NULL}, 3934, "udp"},
{"sdp-portmapper",     {NULL}, 3935, "tcp"},
{"sdp-portmapper",     {NULL}, 3935, "udp"},
{"mailprox",           {NULL}, 3936, "tcp"},
{"mailprox",           {NULL}, 3936, "udp"},
{"dvbservdsc",         {NULL}, 3937, "tcp"},
{"dvbservdsc",         {NULL}, 3937, "udp"},
{"dbcontrol_agent",    {NULL}, 3938, "tcp"},
{"dbcontrol_agent",    {NULL}, 3938, "udp"},
{"aamp",               {NULL}, 3939, "tcp"},
{"aamp",               {NULL}, 3939, "udp"},
{"xecp-node",          {NULL}, 3940, "tcp"},
{"xecp-node",          {NULL}, 3940, "udp"},
{"homeportal-web",     {NULL}, 3941, "tcp"},
{"homeportal-web",     {NULL}, 3941, "udp"},
{"srdp",               {NULL}, 3942, "tcp"},
{"srdp",               {NULL}, 3942, "udp"},
{"tig",                {NULL}, 3943, "tcp"},
{"tig",                {NULL}, 3943, "udp"},
{"sops",               {NULL}, 3944, "tcp"},
{"sops",               {NULL}, 3944, "udp"},
{"emcads",             {NULL}, 3945, "tcp"},
{"emcads",             {NULL}, 3945, "udp"},
{"backupedge",         {NULL}, 3946, "tcp"},
{"backupedge",         {NULL}, 3946, "udp"},
{"ccp",                {NULL}, 3947, "tcp"},
{"ccp",                {NULL}, 3947, "udp"},
{"apdap",              {NULL}, 3948, "tcp"},
{"apdap",              {NULL}, 3948, "udp"},
{"drip",               {NULL}, 3949, "tcp"},
{"drip",               {NULL}, 3949, "udp"},
{"namemunge",          {NULL}, 3950, "tcp"},
{"namemunge",          {NULL}, 3950, "udp"},
{"pwgippfax",          {NULL}, 3951, "tcp"},
{"pwgippfax",          {NULL}, 3951, "udp"},
{"i3-sessionmgr",      {NULL}, 3952, "tcp"},
{"i3-sessionmgr",      {NULL}, 3952, "udp"},
{"xmlink-connect",     {NULL}, 3953, "tcp"},
{"xmlink-connect",     {NULL}, 3953, "udp"},
{"adrep",              {NULL}, 3954, "tcp"},
{"adrep",              {NULL}, 3954, "udp"},
{"p2pcommunity",       {NULL}, 3955, "tcp"},
{"p2pcommunity",       {NULL}, 3955, "udp"},
{"gvcp",               {NULL}, 3956, "tcp"},
{"gvcp",               {NULL}, 3956, "udp"},
{"mqe-broker",         {NULL}, 3957, "tcp"},
{"mqe-broker",         {NULL}, 3957, "udp"},
{"mqe-agent",          {NULL}, 3958, "tcp"},
{"mqe-agent",          {NULL}, 3958, "udp"},
{"treehopper",         {NULL}, 3959, "tcp"},
{"treehopper",         {NULL}, 3959, "udp"},
{"bess",               {NULL}, 3960, "tcp"},
{"bess",               {NULL}, 3960, "udp"},
{"proaxess",           {NULL}, 3961, "tcp"},
{"proaxess",           {NULL}, 3961, "udp"},
{"sbi-agent",          {NULL}, 3962, "tcp"},
{"sbi-agent",          {NULL}, 3962, "udp"},
{"thrp",               {NULL}, 3963, "tcp"},
{"thrp",               {NULL}, 3963, "udp"},
{"sasggprs",           {NULL}, 3964, "tcp"},
{"sasggprs",           {NULL}, 3964, "udp"},
{"ati-ip-to-ncpe",     {NULL}, 3965, "tcp"},
{"ati-ip-to-ncpe",     {NULL}, 3965, "udp"},
{"bflckmgr",           {NULL}, 3966, "tcp"},
{"bflckmgr",           {NULL}, 3966, "udp"},
{"ppsms",              {NULL}, 3967, "tcp"},
{"ppsms",              {NULL}, 3967, "udp"},
{"ianywhere-dbns",     {NULL}, 3968, "tcp"},
{"ianywhere-dbns",     {NULL}, 3968, "udp"},
{"landmarks",          {NULL}, 3969, "tcp"},
{"landmarks",          {NULL}, 3969, "udp"},
{"lanrevagent",        {NULL}, 3970, "tcp"},
{"lanrevagent",        {NULL}, 3970, "udp"},
{"lanrevserver",       {NULL}, 3971, "tcp"},
{"lanrevserver",       {NULL}, 3971, "udp"},
{"iconp",              {NULL}, 3972, "tcp"},
{"iconp",              {NULL}, 3972, "udp"},
{"progistics",         {NULL}, 3973, "tcp"},
{"progistics",         {NULL}, 3973, "udp"},
{"citysearch",         {NULL}, 3974, "tcp"},
{"citysearch",         {NULL}, 3974, "udp"},
{"airshot",            {NULL}, 3975, "tcp"},
{"airshot",            {NULL}, 3975, "udp"},
{"opswagent",          {NULL}, 3976, "tcp"},
{"opswagent",          {NULL}, 3976, "udp"},
{"opswmanager",        {NULL}, 3977, "tcp"},
{"opswmanager",        {NULL}, 3977, "udp"},
{"secure-cfg-svr",     {NULL}, 3978, "tcp"},
{"secure-cfg-svr",     {NULL}, 3978, "udp"},
{"smwan",              {NULL}, 3979, "tcp"},
{"smwan",              {NULL}, 3979, "udp"},
{"acms",               {NULL}, 3980, "tcp"},
{"acms",               {NULL}, 3980, "udp"},
{"starfish",           {NULL}, 3981, "tcp"},
{"starfish",           {NULL}, 3981, "udp"},
{"eis",                {NULL}, 3982, "tcp"},
{"eis",                {NULL}, 3982, "udp"},
{"eisp",               {NULL}, 3983, "tcp"},
{"eisp",               {NULL}, 3983, "udp"},
{"mapper-nodemgr",     {NULL}, 3984, "tcp"},
{"mapper-nodemgr",     {NULL}, 3984, "udp"},
{"mapper-mapethd",     {NULL}, 3985, "tcp"},
{"mapper-mapethd",     {NULL}, 3985, "udp"},
{"mapper-ws_ethd",     {NULL}, 3986, "tcp"},
{"mapper-ws_ethd",     {NULL}, 3986, "udp"},
{"centerline",         {NULL}, 3987, "tcp"},
{"centerline",         {NULL}, 3987, "udp"},
{"dcs-config",         {NULL}, 3988, "tcp"},
{"dcs-config",         {NULL}, 3988, "udp"},
{"bv-queryengine",     {NULL}, 3989, "tcp"},
{"bv-queryengine",     {NULL}, 3989, "udp"},
{"bv-is",              {NULL}, 3990, "tcp"},
{"bv-is",              {NULL}, 3990, "udp"},
{"bv-smcsrv",          {NULL}, 3991, "tcp"},
{"bv-smcsrv",          {NULL}, 3991, "udp"},
{"bv-ds",              {NULL}, 3992, "tcp"},
{"bv-ds",              {NULL}, 3992, "udp"},
{"bv-agent",           {NULL}, 3993, "tcp"},
{"bv-agent",           {NULL}, 3993, "udp"},
{"iss-mgmt-ssl",       {NULL}, 3995, "tcp"},
{"iss-mgmt-ssl",       {NULL}, 3995, "udp"},
{"abcsoftware",        {NULL}, 3996, "tcp"},
{"abcsoftware",        {NULL}, 3996, "udp"},
{"agentsease-db",      {NULL}, 3997, "tcp"},
{"agentsease-db",      {NULL}, 3997, "udp"},
{"dnx",                {NULL}, 3998, "tcp"},
{"dnx",                {NULL}, 3998, "udp"},
{"nvcnet",             {NULL}, 3999, "tcp"},
{"nvcnet",             {NULL}, 3999, "udp"},
{"terabase",           {NULL}, 4000, "tcp"},
{"terabase",           {NULL}, 4000, "udp"},
{"newoak",             {NULL}, 4001, "tcp"},
{"newoak",             {NULL}, 4001, "udp"},
{"pxc-spvr-ft",        {NULL}, 4002, "tcp"},
{"pxc-spvr-ft",        {NULL}, 4002, "udp"},
{"pxc-splr-ft",        {NULL}, 4003, "tcp"},
{"pxc-splr-ft",        {NULL}, 4003, "udp"},
{"pxc-roid",           {NULL}, 4004, "tcp"},
{"pxc-roid",           {NULL}, 4004, "udp"},
{"pxc-pin",            {NULL}, 4005, "tcp"},
{"pxc-pin",            {NULL}, 4005, "udp"},
{"pxc-spvr",           {NULL}, 4006, "tcp"},
{"pxc-spvr",           {NULL}, 4006, "udp"},
{"pxc-splr",           {NULL}, 4007, "tcp"},
{"pxc-splr",           {NULL}, 4007, "udp"},
{"netcheque",          {NULL}, 4008, "tcp"},
{"netcheque",          {NULL}, 4008, "udp"},
{"chimera-hwm",        {NULL}, 4009, "tcp"},
{"chimera-hwm",        {NULL}, 4009, "udp"},
{"samsung-unidex",     {NULL}, 4010, "tcp"},
{"samsung-unidex",     {NULL}, 4010, "udp"},
{"altserviceboot",     {NULL}, 4011, "tcp"},
{"altserviceboot",     {NULL}, 4011, "udp"},
{"pda-gate",           {NULL}, 4012, "tcp"},
{"pda-gate",           {NULL}, 4012, "udp"},
{"acl-manager",        {NULL}, 4013, "tcp"},
{"acl-manager",        {NULL}, 4013, "udp"},
{"taiclock",           {NULL}, 4014, "tcp"},
{"taiclock",           {NULL}, 4014, "udp"},
{"talarian-mcast1",    {NULL}, 4015, "tcp"},
{"talarian-mcast1",    {NULL}, 4015, "udp"},
{"talarian-mcast2",    {NULL}, 4016, "tcp"},
{"talarian-mcast2",    {NULL}, 4016, "udp"},
{"talarian-mcast3",    {NULL}, 4017, "tcp"},
{"talarian-mcast3",    {NULL}, 4017, "udp"},
{"talarian-mcast4",    {NULL}, 4018, "tcp"},
{"talarian-mcast4",    {NULL}, 4018, "udp"},
{"talarian-mcast5",    {NULL}, 4019, "tcp"},
{"talarian-mcast5",    {NULL}, 4019, "udp"},
{"trap",               {NULL}, 4020, "tcp"},
{"trap",               {NULL}, 4020, "udp"},
{"nexus-portal",       {NULL}, 4021, "tcp"},
{"nexus-portal",       {NULL}, 4021, "udp"},
{"dnox",               {NULL}, 4022, "tcp"},
{"dnox",               {NULL}, 4022, "udp"},
{"esnm-zoning",        {NULL}, 4023, "tcp"},
{"esnm-zoning",        {NULL}, 4023, "udp"},
{"tnp1-port",          {NULL}, 4024, "tcp"},
{"tnp1-port",          {NULL}, 4024, "udp"},
{"partimage",          {NULL}, 4025, "tcp"},
{"partimage",          {NULL}, 4025, "udp"},
{"as-debug",           {NULL}, 4026, "tcp"},
{"as-debug",           {NULL}, 4026, "udp"},
{"bxp",                {NULL}, 4027, "tcp"},
{"bxp",                {NULL}, 4027, "udp"},
{"dtserver-port",      {NULL}, 4028, "tcp"},
{"dtserver-port",      {NULL}, 4028, "udp"},
{"ip-qsig",            {NULL}, 4029, "tcp"},
{"ip-qsig",            {NULL}, 4029, "udp"},
{"jdmn-port",          {NULL}, 4030, "tcp"},
{"jdmn-port",          {NULL}, 4030, "udp"},
{"suucp",              {NULL}, 4031, "tcp"},
{"suucp",              {NULL}, 4031, "udp"},
{"vrts-auth-port",     {NULL}, 4032, "tcp"},
{"vrts-auth-port",     {NULL}, 4032, "udp"},
{"sanavigator",        {NULL}, 4033, "tcp"},
{"sanavigator",        {NULL}, 4033, "udp"},
{"ubxd",               {NULL}, 4034, "tcp"},
{"ubxd",               {NULL}, 4034, "udp"},
{"wap-push-http",      {NULL}, 4035, "tcp"},
{"wap-push-http",      {NULL}, 4035, "udp"},
{"wap-push-https",     {NULL}, 4036, "tcp"},
{"wap-push-https",     {NULL}, 4036, "udp"},
{"ravehd",             {NULL}, 4037, "tcp"},
{"ravehd",             {NULL}, 4037, "udp"},
{"fazzt-ptp",          {NULL}, 4038, "tcp"},
{"fazzt-ptp",          {NULL}, 4038, "udp"},
{"fazzt-admin",        {NULL}, 4039, "tcp"},
{"fazzt-admin",        {NULL}, 4039, "udp"},
{"yo-main",            {NULL}, 4040, "tcp"},
{"yo-main",            {NULL}, 4040, "udp"},
{"houston",            {NULL}, 4041, "tcp"},
{"houston",            {NULL}, 4041, "udp"},
{"ldxp",               {NULL}, 4042, "tcp"},
{"ldxp",               {NULL}, 4042, "udp"},
{"nirp",               {NULL}, 4043, "tcp"},
{"nirp",               {NULL}, 4043, "udp"},
{"ltp",                {NULL}, 4044, "tcp"},
{"ltp",                {NULL}, 4044, "udp"},
{"npp",                {NULL}, 4045, "tcp"},
{"npp",                {NULL}, 4045, "udp"},
{"acp-proto",          {NULL}, 4046, "tcp"},
{"acp-proto",          {NULL}, 4046, "udp"},
{"ctp-state",          {NULL}, 4047, "tcp"},
{"ctp-state",          {NULL}, 4047, "udp"},
{"wafs",               {NULL}, 4049, "tcp"},
{"wafs",               {NULL}, 4049, "udp"},
{"cisco-wafs",         {NULL}, 4050, "tcp"},
{"cisco-wafs",         {NULL}, 4050, "udp"},
{"cppdp",              {NULL}, 4051, "tcp"},
{"cppdp",              {NULL}, 4051, "udp"},
{"interact",           {NULL}, 4052, "tcp"},
{"interact",           {NULL}, 4052, "udp"},
{"ccu-comm-1",         {NULL}, 4053, "tcp"},
{"ccu-comm-1",         {NULL}, 4053, "udp"},
{"ccu-comm-2",         {NULL}, 4054, "tcp"},
{"ccu-comm-2",         {NULL}, 4054, "udp"},
{"ccu-comm-3",         {NULL}, 4055, "tcp"},
{"ccu-comm-3",         {NULL}, 4055, "udp"},
{"lms",                {NULL}, 4056, "tcp"},
{"lms",                {NULL}, 4056, "udp"},
{"wfm",                {NULL}, 4057, "tcp"},
{"wfm",                {NULL}, 4057, "udp"},
{"kingfisher",         {NULL}, 4058, "tcp"},
{"kingfisher",         {NULL}, 4058, "udp"},
{"dlms-cosem",         {NULL}, 4059, "tcp"},
{"dlms-cosem",         {NULL}, 4059, "udp"},
{"dsmeter_iatc",       {NULL}, 4060, "tcp"},
{"dsmeter_iatc",       {NULL}, 4060, "udp"},
{"ice-location",       {NULL}, 4061, "tcp"},
{"ice-location",       {NULL}, 4061, "udp"},
{"ice-slocation",      {NULL}, 4062, "tcp"},
{"ice-slocation",      {NULL}, 4062, "udp"},
{"ice-router",         {NULL}, 4063, "tcp"},
{"ice-router",         {NULL}, 4063, "udp"},
{"ice-srouter",        {NULL}, 4064, "tcp"},
{"ice-srouter",        {NULL}, 4064, "udp"},
{"avanti_cdp",         {NULL}, 4065, "tcp"},
{"avanti_cdp",         {NULL}, 4065, "udp"},
{"pmas",               {NULL}, 4066, "tcp"},
{"pmas",               {NULL}, 4066, "udp"},
{"idp",                {NULL}, 4067, "tcp"},
{"idp",                {NULL}, 4067, "udp"},
{"ipfltbcst",          {NULL}, 4068, "tcp"},
{"ipfltbcst",          {NULL}, 4068, "udp"},
{"minger",             {NULL}, 4069, "tcp"},
{"minger",             {NULL}, 4069, "udp"},
{"tripe",              {NULL}, 4070, "tcp"},
{"tripe",              {NULL}, 4070, "udp"},
{"aibkup",             {NULL}, 4071, "tcp"},
{"aibkup",             {NULL}, 4071, "udp"},
{"zieto-sock",         {NULL}, 4072, "tcp"},
{"zieto-sock",         {NULL}, 4072, "udp"},
{"iRAPP",              {NULL}, 4073, "tcp"},
{"iRAPP",              {NULL}, 4073, "udp"},
{"cequint-cityid",     {NULL}, 4074, "tcp"},
{"cequint-cityid",     {NULL}, 4074, "udp"},
{"perimlan",           {NULL}, 4075, "tcp"},
{"perimlan",           {NULL}, 4075, "udp"},
{"seraph",             {NULL}, 4076, "tcp"},
{"seraph",             {NULL}, 4076, "udp"},
{"ascomalarm",         {NULL}, 4077, "udp"},
{"cssp",               {NULL}, 4078, "tcp"},
{"santools",           {NULL}, 4079, "tcp"},
{"santools",           {NULL}, 4079, "udp"},
{"lorica-in",          {NULL}, 4080, "tcp"},
{"lorica-in",          {NULL}, 4080, "udp"},
{"lorica-in-sec",      {NULL}, 4081, "tcp"},
{"lorica-in-sec",      {NULL}, 4081, "udp"},
{"lorica-out",         {NULL}, 4082, "tcp"},
{"lorica-out",         {NULL}, 4082, "udp"},
{"lorica-out-sec",     {NULL}, 4083, "tcp"},
{"lorica-out-sec",     {NULL}, 4083, "udp"},
{"fortisphere-vm",     {NULL}, 4084, "udp"},
{"ezmessagesrv",       {NULL}, 4085, "tcp"},
{"ftsync",             {NULL}, 4086, "udp"},
{"applusservice",      {NULL}, 4087, "tcp"},
{"npsp",               {NULL}, 4088, "tcp"},
{"opencore",           {NULL}, 4089, "tcp"},
{"opencore",           {NULL}, 4089, "udp"},
{"omasgport",          {NULL}, 4090, "tcp"},
{"omasgport",          {NULL}, 4090, "udp"},
{"ewinstaller",        {NULL}, 4091, "tcp"},
{"ewinstaller",        {NULL}, 4091, "udp"},
{"ewdgs",              {NULL}, 4092, "tcp"},
{"ewdgs",              {NULL}, 4092, "udp"},
{"pvxpluscs",          {NULL}, 4093, "tcp"},
{"pvxpluscs",          {NULL}, 4093, "udp"},
{"sysrqd",             {NULL}, 4094, "tcp"},
{"sysrqd",             {NULL}, 4094, "udp"},
{"xtgui",              {NULL}, 4095, "tcp"},
{"xtgui",              {NULL}, 4095, "udp"},
{"bre",                {NULL}, 4096, "tcp"},
{"bre",                {NULL}, 4096, "udp"},
{"patrolview",         {NULL}, 4097, "tcp"},
{"patrolview",         {NULL}, 4097, "udp"},
{"drmsfsd",            {NULL}, 4098, "tcp"},
{"drmsfsd",            {NULL}, 4098, "udp"},
{"dpcp",               {NULL}, 4099, "tcp"},
{"dpcp",               {NULL}, 4099, "udp"},
{"igo-incognito",      {NULL}, 4100, "tcp"},
{"igo-incognito",      {NULL}, 4100, "udp"},
{"brlp-0",             {NULL}, 4101, "tcp"},
{"brlp-0",             {NULL}, 4101, "udp"},
{"brlp-1",             {NULL}, 4102, "tcp"},
{"brlp-1",             {NULL}, 4102, "udp"},
{"brlp-2",             {NULL}, 4103, "tcp"},
{"brlp-2",             {NULL}, 4103, "udp"},
{"brlp-3",             {NULL}, 4104, "tcp"},
{"brlp-3",             {NULL}, 4104, "udp"},
{"shofarplayer",       {NULL}, 4105, "tcp"},
{"shofarplayer",       {NULL}, 4105, "udp"},
{"synchronite",        {NULL}, 4106, "tcp"},
{"synchronite",        {NULL}, 4106, "udp"},
{"j-ac",               {NULL}, 4107, "tcp"},
{"j-ac",               {NULL}, 4107, "udp"},
{"accel",              {NULL}, 4108, "tcp"},
{"accel",              {NULL}, 4108, "udp"},
{"izm",                {NULL}, 4109, "tcp"},
{"izm",                {NULL}, 4109, "udp"},
{"g2tag",              {NULL}, 4110, "tcp"},
{"g2tag",              {NULL}, 4110, "udp"},
{"xgrid",              {NULL}, 4111, "tcp"},
{"xgrid",              {NULL}, 4111, "udp"},
{"apple-vpns-rp",      {NULL}, 4112, "tcp"},
{"apple-vpns-rp",      {NULL}, 4112, "udp"},
{"aipn-reg",           {NULL}, 4113, "tcp"},
{"aipn-reg",           {NULL}, 4113, "udp"},
{"jomamqmonitor",      {NULL}, 4114, "tcp"},
{"jomamqmonitor",      {NULL}, 4114, "udp"},
{"cds",                {NULL}, 4115, "tcp"},
{"cds",                {NULL}, 4115, "udp"},
{"smartcard-tls",      {NULL}, 4116, "tcp"},
{"smartcard-tls",      {NULL}, 4116, "udp"},
{"hillrserv",          {NULL}, 4117, "tcp"},
{"hillrserv",          {NULL}, 4117, "udp"},
{"netscript",          {NULL}, 4118, "tcp"},
{"netscript",          {NULL}, 4118, "udp"},
{"assuria-slm",        {NULL}, 4119, "tcp"},
{"assuria-slm",        {NULL}, 4119, "udp"},
{"e-builder",          {NULL}, 4121, "tcp"},
{"e-builder",          {NULL}, 4121, "udp"},
{"fprams",             {NULL}, 4122, "tcp"},
{"fprams",             {NULL}, 4122, "udp"},
{"z-wave",             {NULL}, 4123, "tcp"},
{"z-wave",             {NULL}, 4123, "udp"},
{"tigv2",              {NULL}, 4124, "tcp"},
{"tigv2",              {NULL}, 4124, "udp"},
{"opsview-envoy",      {NULL}, 4125, "tcp"},
{"opsview-envoy",      {NULL}, 4125, "udp"},
{"ddrepl",             {NULL}, 4126, "tcp"},
{"ddrepl",             {NULL}, 4126, "udp"},
{"unikeypro",          {NULL}, 4127, "tcp"},
{"unikeypro",          {NULL}, 4127, "udp"},
{"nufw",               {NULL}, 4128, "tcp"},
{"nufw",               {NULL}, 4128, "udp"},
{"nuauth",             {NULL}, 4129, "tcp"},
{"nuauth",             {NULL}, 4129, "udp"},
{"fronet",             {NULL}, 4130, "tcp"},
{"fronet",             {NULL}, 4130, "udp"},
{"stars",              {NULL}, 4131, "tcp"},
{"stars",              {NULL}, 4131, "udp"},
{"nuts_dem",           {NULL}, 4132, "tcp"},
{"nuts_dem",           {NULL}, 4132, "udp"},
{"nuts_bootp",         {NULL}, 4133, "tcp"},
{"nuts_bootp",         {NULL}, 4133, "udp"},
{"nifty-hmi",          {NULL}, 4134, "tcp"},
{"nifty-hmi",          {NULL}, 4134, "udp"},
{"cl-db-attach",       {NULL}, 4135, "tcp"},
{"cl-db-attach",       {NULL}, 4135, "udp"},
{"cl-db-request",      {NULL}, 4136, "tcp"},
{"cl-db-request",      {NULL}, 4136, "udp"},
{"cl-db-remote",       {NULL}, 4137, "tcp"},
{"cl-db-remote",       {NULL}, 4137, "udp"},
{"nettest",            {NULL}, 4138, "tcp"},
{"nettest",            {NULL}, 4138, "udp"},
{"thrtx",              {NULL}, 4139, "tcp"},
{"thrtx",              {NULL}, 4139, "udp"},
{"cedros_fds",         {NULL}, 4140, "tcp"},
{"cedros_fds",         {NULL}, 4140, "udp"},
{"oirtgsvc",           {NULL}, 4141, "tcp"},
{"oirtgsvc",           {NULL}, 4141, "udp"},
{"oidocsvc",           {NULL}, 4142, "tcp"},
{"oidocsvc",           {NULL}, 4142, "udp"},
{"oidsr",              {NULL}, 4143, "tcp"},
{"oidsr",              {NULL}, 4143, "udp"},
{"vvr-control",        {NULL}, 4145, "tcp"},
{"vvr-control",        {NULL}, 4145, "udp"},
{"tgcconnect",         {NULL}, 4146, "tcp"},
{"tgcconnect",         {NULL}, 4146, "udp"},
{"vrxpservman",        {NULL}, 4147, "tcp"},
{"vrxpservman",        {NULL}, 4147, "udp"},
{"hhb-handheld",       {NULL}, 4148, "tcp"},
{"hhb-handheld",       {NULL}, 4148, "udp"},
{"agslb",              {NULL}, 4149, "tcp"},
{"agslb",              {NULL}, 4149, "udp"},
{"PowerAlert-nsa",     {NULL}, 4150, "tcp"},
{"PowerAlert-nsa",     {NULL}, 4150, "udp"},
{"menandmice_noh",     {NULL}, 4151, "tcp"},
{"menandmice_noh",     {NULL}, 4151, "udp"},
{"idig_mux",           {NULL}, 4152, "tcp"},
{"idig_mux",           {NULL}, 4152, "udp"},
{"mbl-battd",          {NULL}, 4153, "tcp"},
{"mbl-battd",          {NULL}, 4153, "udp"},
{"atlinks",            {NULL}, 4154, "tcp"},
{"atlinks",            {NULL}, 4154, "udp"},
{"bzr",                {NULL}, 4155, "tcp"},
{"bzr",                {NULL}, 4155, "udp"},
{"stat-results",       {NULL}, 4156, "tcp"},
{"stat-results",       {NULL}, 4156, "udp"},
{"stat-scanner",       {NULL}, 4157, "tcp"},
{"stat-scanner",       {NULL}, 4157, "udp"},
{"stat-cc",            {NULL}, 4158, "tcp"},
{"stat-cc",            {NULL}, 4158, "udp"},
{"nss",                {NULL}, 4159, "tcp"},
{"nss",                {NULL}, 4159, "udp"},
{"jini-discovery",     {NULL}, 4160, "tcp"},
{"jini-discovery",     {NULL}, 4160, "udp"},
{"omscontact",         {NULL}, 4161, "tcp"},
{"omscontact",         {NULL}, 4161, "udp"},
{"omstopology",        {NULL}, 4162, "tcp"},
{"omstopology",        {NULL}, 4162, "udp"},
{"silverpeakpeer",     {NULL}, 4163, "tcp"},
{"silverpeakpeer",     {NULL}, 4163, "udp"},
{"silverpeakcomm",     {NULL}, 4164, "tcp"},
{"silverpeakcomm",     {NULL}, 4164, "udp"},
{"altcp",              {NULL}, 4165, "tcp"},
{"altcp",              {NULL}, 4165, "udp"},
{"joost",              {NULL}, 4166, "tcp"},
{"joost",              {NULL}, 4166, "udp"},
{"ddgn",               {NULL}, 4167, "tcp"},
{"ddgn",               {NULL}, 4167, "udp"},
{"pslicser",           {NULL}, 4168, "tcp"},
{"pslicser",           {NULL}, 4168, "udp"},
{"iadt",               {NULL}, 4169, "tcp"},
{"iadt-disc",          {NULL}, 4169, "udp"},
{"d-cinema-csp",       {NULL}, 4170, "tcp"},
{"ml-svnet",           {NULL}, 4171, "tcp"},
{"pcoip",              {NULL}, 4172, "tcp"},
{"pcoip",              {NULL}, 4172, "udp"},
{"smcluster",          {NULL}, 4174, "tcp"},
{"bccp",               {NULL}, 4175, "tcp"},
{"tl-ipcproxy",        {NULL}, 4176, "tcp"},
{"wello",              {NULL}, 4177, "tcp"},
{"wello",              {NULL}, 4177, "udp"},
{"storman",            {NULL}, 4178, "tcp"},
{"storman",            {NULL}, 4178, "udp"},
{"MaxumSP",            {NULL}, 4179, "tcp"},
{"MaxumSP",            {NULL}, 4179, "udp"},
{"httpx",              {NULL}, 4180, "tcp"},
{"httpx",              {NULL}, 4180, "udp"},
{"macbak",             {NULL}, 4181, "tcp"},
{"macbak",             {NULL}, 4181, "udp"},
{"pcptcpservice",      {NULL}, 4182, "tcp"},
{"pcptcpservice",      {NULL}, 4182, "udp"},
{"gmmp",               {NULL}, 4183, "tcp"},
{"gmmp",               {NULL}, 4183, "udp"},
{"universe_suite",     {NULL}, 4184, "tcp"},
{"universe_suite",     {NULL}, 4184, "udp"},
{"wcpp",               {NULL}, 4185, "tcp"},
{"wcpp",               {NULL}, 4185, "udp"},
{"boxbackupstore",     {NULL}, 4186, "tcp"},
{"csc_proxy",          {NULL}, 4187, "tcp"},
{"vatata",             {NULL}, 4188, "tcp"},
{"vatata",             {NULL}, 4188, "udp"},
{"pcep",               {NULL}, 4189, "tcp"},
{"sieve",              {NULL}, 4190, "tcp"},
{"dsmipv6",            {NULL}, 4191, "udp"},
{"azeti",              {NULL}, 4192, "tcp"},
{"azeti-bd",           {NULL}, 4192, "udp"},
{"pvxplusio",          {NULL}, 4193, "tcp"},
{"eims-admin",         {NULL}, 4199, "tcp"},
{"eims-admin",         {NULL}, 4199, "udp"},
{"corelccam",          {NULL}, 4300, "tcp"},
{"corelccam",          {NULL}, 4300, "udp"},
{"d-data",             {NULL}, 4301, "tcp"},
{"d-data",             {NULL}, 4301, "udp"},
{"d-data-control",     {NULL}, 4302, "tcp"},
{"d-data-control",     {NULL}, 4302, "udp"},
{"srcp",               {NULL}, 4303, "tcp"},
{"srcp",               {NULL}, 4303, "udp"},
{"owserver",           {NULL}, 4304, "tcp"},
{"owserver",           {NULL}, 4304, "udp"},
{"batman",             {NULL}, 4305, "tcp"},
{"batman",             {NULL}, 4305, "udp"},
{"pinghgl",            {NULL}, 4306, "tcp"},
{"pinghgl",            {NULL}, 4306, "udp"},
{"visicron-vs",        {NULL}, 4307, "tcp"},
{"visicron-vs",        {NULL}, 4307, "udp"},
{"compx-lockview",     {NULL}, 4308, "tcp"},
{"compx-lockview",     {NULL}, 4308, "udp"},
{"dserver",            {NULL}, 4309, "tcp"},
{"dserver",            {NULL}, 4309, "udp"},
{"mirrtex",            {NULL}, 4310, "tcp"},
{"mirrtex",            {NULL}, 4310, "udp"},
{"p6ssmc",             {NULL}, 4311, "tcp"},
{"pscl-mgt",           {NULL}, 4312, "tcp"},
{"perrla",             {NULL}, 4313, "tcp"},
{"fdt-rcatp",          {NULL}, 4320, "tcp"},
{"fdt-rcatp",          {NULL}, 4320, "udp"},
{"rwhois",             {NULL}, 4321, "tcp"},
{"rwhois",             {NULL}, 4321, "udp"},
{"trim-event",         {NULL}, 4322, "tcp"},
{"trim-event",         {NULL}, 4322, "udp"},
{"trim-ice",           {NULL}, 4323, "tcp"},
{"trim-ice",           {NULL}, 4323, "udp"},
{"balour",             {NULL}, 4324, "tcp"},
{"balour",             {NULL}, 4324, "udp"},
{"geognosisman",       {NULL}, 4325, "tcp"},
{"geognosisman",       {NULL}, 4325, "udp"},
{"geognosis",          {NULL}, 4326, "tcp"},
{"geognosis",          {NULL}, 4326, "udp"},
{"jaxer-web",          {NULL}, 4327, "tcp"},
{"jaxer-web",          {NULL}, 4327, "udp"},
{"jaxer-manager",      {NULL}, 4328, "tcp"},
{"jaxer-manager",      {NULL}, 4328, "udp"},
{"publiqare-sync",     {NULL}, 4329, "tcp"},
{"gaia",               {NULL}, 4340, "tcp"},
{"gaia",               {NULL}, 4340, "udp"},
{"lisp-data",          {NULL}, 4341, "tcp"},
{"lisp-data",          {NULL}, 4341, "udp"},
{"lisp-cons",          {NULL}, 4342, "tcp"},
{"lisp-control",       {NULL}, 4342, "udp"},
{"unicall",            {NULL}, 4343, "tcp"},
{"unicall",            {NULL}, 4343, "udp"},
{"vinainstall",        {NULL}, 4344, "tcp"},
{"vinainstall",        {NULL}, 4344, "udp"},
{"m4-network-as",      {NULL}, 4345, "tcp"},
{"m4-network-as",      {NULL}, 4345, "udp"},
{"elanlm",             {NULL}, 4346, "tcp"},
{"elanlm",             {NULL}, 4346, "udp"},
{"lansurveyor",        {NULL}, 4347, "tcp"},
{"lansurveyor",        {NULL}, 4347, "udp"},
{"itose",              {NULL}, 4348, "tcp"},
{"itose",              {NULL}, 4348, "udp"},
{"fsportmap",          {NULL}, 4349, "tcp"},
{"fsportmap",          {NULL}, 4349, "udp"},
{"net-device",         {NULL}, 4350, "tcp"},
{"net-device",         {NULL}, 4350, "udp"},
{"plcy-net-svcs",      {NULL}, 4351, "tcp"},
{"plcy-net-svcs",      {NULL}, 4351, "udp"},
{"pjlink",             {NULL}, 4352, "tcp"},
{"pjlink",             {NULL}, 4352, "udp"},
{"f5-iquery",          {NULL}, 4353, "tcp"},
{"f5-iquery",          {NULL}, 4353, "udp"},
{"qsnet-trans",        {NULL}, 4354, "tcp"},
{"qsnet-trans",        {NULL}, 4354, "udp"},
{"qsnet-workst",       {NULL}, 4355, "tcp"},
{"qsnet-workst",       {NULL}, 4355, "udp"},
{"qsnet-assist",       {NULL}, 4356, "tcp"},
{"qsnet-assist",       {NULL}, 4356, "udp"},
{"qsnet-cond",         {NULL}, 4357, "tcp"},
{"qsnet-cond",         {NULL}, 4357, "udp"},
{"qsnet-nucl",         {NULL}, 4358, "tcp"},
{"qsnet-nucl",         {NULL}, 4358, "udp"},
{"omabcastltkm",       {NULL}, 4359, "tcp"},
{"omabcastltkm",       {NULL}, 4359, "udp"},
{"matrix_vnet",        {NULL}, 4360, "tcp"},
{"nacnl",              {NULL}, 4361, "udp"},
{"afore-vdp-disc",     {NULL}, 4362, "udp"},
{"wxbrief",            {NULL}, 4368, "tcp"},
{"wxbrief",            {NULL}, 4368, "udp"},
{"epmd",               {NULL}, 4369, "tcp"},
{"epmd",               {NULL}, 4369, "udp"},
{"elpro_tunnel",       {NULL}, 4370, "tcp"},
{"elpro_tunnel",       {NULL}, 4370, "udp"},
{"l2c-control",        {NULL}, 4371, "tcp"},
{"l2c-disc",           {NULL}, 4371, "udp"},
{"l2c-data",           {NULL}, 4372, "tcp"},
{"l2c-data",           {NULL}, 4372, "udp"},
{"remctl",             {NULL}, 4373, "tcp"},
{"remctl",             {NULL}, 4373, "udp"},
{"psi-ptt",            {NULL}, 4374, "tcp"},
{"tolteces",           {NULL}, 4375, "tcp"},
{"tolteces",           {NULL}, 4375, "udp"},
{"bip",                {NULL}, 4376, "tcp"},
{"bip",                {NULL}, 4376, "udp"},
{"cp-spxsvr",          {NULL}, 4377, "tcp"},
{"cp-spxsvr",          {NULL}, 4377, "udp"},
{"cp-spxdpy",          {NULL}, 4378, "tcp"},
{"cp-spxdpy",          {NULL}, 4378, "udp"},
{"ctdb",               {NULL}, 4379, "tcp"},
{"ctdb",               {NULL}, 4379, "udp"},
{"xandros-cms",        {NULL}, 4389, "tcp"},
{"xandros-cms",        {NULL}, 4389, "udp"},
{"wiegand",            {NULL}, 4390, "tcp"},
{"wiegand",            {NULL}, 4390, "udp"},
{"apwi-imserver",      {NULL}, 4391, "tcp"},
{"apwi-rxserver",      {NULL}, 4392, "tcp"},
{"apwi-rxspooler",     {NULL}, 4393, "tcp"},
{"apwi-disc",          {NULL}, 4394, "udp"},
{"omnivisionesx",      {NULL}, 4395, "tcp"},
{"omnivisionesx",      {NULL}, 4395, "udp"},
{"fly",                {NULL}, 4396, "tcp"},
{"ds-srv",             {NULL}, 4400, "tcp"},
{"ds-srv",             {NULL}, 4400, "udp"},
{"ds-srvr",            {NULL}, 4401, "tcp"},
{"ds-srvr",            {NULL}, 4401, "udp"},
{"ds-clnt",            {NULL}, 4402, "tcp"},
{"ds-clnt",            {NULL}, 4402, "udp"},
{"ds-user",            {NULL}, 4403, "tcp"},
{"ds-user",            {NULL}, 4403, "udp"},
{"ds-admin",           {NULL}, 4404, "tcp"},
{"ds-admin",           {NULL}, 4404, "udp"},
{"ds-mail",            {NULL}, 4405, "tcp"},
{"ds-mail",            {NULL}, 4405, "udp"},
{"ds-slp",             {NULL}, 4406, "tcp"},
{"ds-slp",             {NULL}, 4406, "udp"},
{"nacagent",           {NULL}, 4407, "tcp"},
{"slscc",              {NULL}, 4408, "tcp"},
{"netcabinet-com",     {NULL}, 4409, "tcp"},
{"itwo-server",        {NULL}, 4410, "tcp"},
{"netrockey6",         {NULL}, 4425, "tcp"},
{"netrockey6",         {NULL}, 4425, "udp"},
{"beacon-port-2",      {NULL}, 4426, "tcp"},
{"beacon-port-2",      {NULL}, 4426, "udp"},
{"drizzle",            {NULL}, 4427, "tcp"},
{"omviserver",         {NULL}, 4428, "tcp"},
{"omviagent",          {NULL}, 4429, "tcp"},
{"rsqlserver",         {NULL}, 4430, "tcp"},
{"rsqlserver",         {NULL}, 4430, "udp"},
{"wspipe",             {NULL}, 4431, "tcp"},
{"netblox",            {NULL}, 4441, "udp"},
{"saris",              {NULL}, 4442, "tcp"},
{"saris",              {NULL}, 4442, "udp"},
{"pharos",             {NULL}, 4443, "tcp"},
{"pharos",             {NULL}, 4443, "udp"},
{"krb524",             {NULL}, 4444, "tcp"},
{"krb524",             {NULL}, 4444, "udp"},
{"nv-video",           {NULL}, 4444, "tcp"},
{"nv-video",           {NULL}, 4444, "udp"},
{"upnotifyp",          {NULL}, 4445, "tcp"},
{"upnotifyp",          {NULL}, 4445, "udp"},
{"n1-fwp",             {NULL}, 4446, "tcp"},
{"n1-fwp",             {NULL}, 4446, "udp"},
{"n1-rmgmt",           {NULL}, 4447, "tcp"},
{"n1-rmgmt",           {NULL}, 4447, "udp"},
{"asc-slmd",           {NULL}, 4448, "tcp"},
{"asc-slmd",           {NULL}, 4448, "udp"},
{"privatewire",        {NULL}, 4449, "tcp"},
{"privatewire",        {NULL}, 4449, "udp"},
{"camp",               {NULL}, 4450, "tcp"},
{"camp",               {NULL}, 4450, "udp"},
{"ctisystemmsg",       {NULL}, 4451, "tcp"},
{"ctisystemmsg",       {NULL}, 4451, "udp"},
{"ctiprogramload",     {NULL}, 4452, "tcp"},
{"ctiprogramload",     {NULL}, 4452, "udp"},
{"nssalertmgr",        {NULL}, 4453, "tcp"},
{"nssalertmgr",        {NULL}, 4453, "udp"},
{"nssagentmgr",        {NULL}, 4454, "tcp"},
{"nssagentmgr",        {NULL}, 4454, "udp"},
{"prchat-user",        {NULL}, 4455, "tcp"},
{"prchat-user",        {NULL}, 4455, "udp"},
{"prchat-server",      {NULL}, 4456, "tcp"},
{"prchat-server",      {NULL}, 4456, "udp"},
{"prRegister",         {NULL}, 4457, "tcp"},
{"prRegister",         {NULL}, 4457, "udp"},
{"mcp",                {NULL}, 4458, "tcp"},
{"mcp",                {NULL}, 4458, "udp"},
{"hpssmgmt",           {NULL}, 4484, "tcp"},
{"hpssmgmt",           {NULL}, 4484, "udp"},
{"assyst-dr",          {NULL}, 4485, "tcp"},
{"icms",               {NULL}, 4486, "tcp"},
{"icms",               {NULL}, 4486, "udp"},
{"prex-tcp",           {NULL}, 4487, "tcp"},
{"awacs-ice",          {NULL}, 4488, "tcp"},
{"awacs-ice",          {NULL}, 4488, "udp"},
{"ipsec-nat-t",        {NULL}, 4500, "tcp"},
{"ipsec-nat-t",        {NULL}, 4500, "udp"},
{"ehs",                {NULL}, 4535, "tcp"},
{"ehs",                {NULL}, 4535, "udp"},
{"ehs-ssl",            {NULL}, 4536, "tcp"},
{"ehs-ssl",            {NULL}, 4536, "udp"},
{"wssauthsvc",         {NULL}, 4537, "tcp"},
{"wssauthsvc",         {NULL}, 4537, "udp"},
{"swx-gate",           {NULL}, 4538, "tcp"},
{"swx-gate",           {NULL}, 4538, "udp"},
{"worldscores",        {NULL}, 4545, "tcp"},
{"worldscores",        {NULL}, 4545, "udp"},
{"sf-lm",              {NULL}, 4546, "tcp"},
{"sf-lm",              {NULL}, 4546, "udp"},
{"lanner-lm",          {NULL}, 4547, "tcp"},
{"lanner-lm",          {NULL}, 4547, "udp"},
{"synchromesh",        {NULL}, 4548, "tcp"},
{"synchromesh",        {NULL}, 4548, "udp"},
{"aegate",             {NULL}, 4549, "tcp"},
{"aegate",             {NULL}, 4549, "udp"},
{"gds-adppiw-db",      {NULL}, 4550, "tcp"},
{"gds-adppiw-db",      {NULL}, 4550, "udp"},
{"ieee-mih",           {NULL}, 4551, "tcp"},
{"ieee-mih",           {NULL}, 4551, "udp"},
{"menandmice-mon",     {NULL}, 4552, "tcp"},
{"menandmice-mon",     {NULL}, 4552, "udp"},
{"icshostsvc",         {NULL}, 4553, "tcp"},
{"msfrs",              {NULL}, 4554, "tcp"},
{"msfrs",              {NULL}, 4554, "udp"},
{"rsip",               {NULL}, 4555, "tcp"},
{"rsip",               {NULL}, 4555, "udp"},
{"dtn-bundle-tcp",     {NULL}, 4556, "tcp"},
{"dtn-bundle-udp",     {NULL}, 4556, "udp"},
{"mtcevrunqss",        {NULL}, 4557, "udp"},
{"mtcevrunqman",       {NULL}, 4558, "udp"},
{"hylafax",            {NULL}, 4559, "tcp"},
{"hylafax",            {NULL}, 4559, "udp"},
{"kwtc",               {NULL}, 4566, "tcp"},
{"kwtc",               {NULL}, 4566, "udp"},
{"tram",               {NULL}, 4567, "tcp"},
{"tram",               {NULL}, 4567, "udp"},
{"bmc-reporting",      {NULL}, 4568, "tcp"},
{"bmc-reporting",      {NULL}, 4568, "udp"},
{"iax",                {NULL}, 4569, "tcp"},
{"iax",                {NULL}, 4569, "udp"},
{"rid",                {NULL}, 4590, "tcp"},
{"l3t-at-an",          {NULL}, 4591, "tcp"},
{"l3t-at-an",          {NULL}, 4591, "udp"},
{"hrpd-ith-at-an",     {NULL}, 4592, "udp"},
{"ipt-anri-anri",      {NULL}, 4593, "tcp"},
{"ipt-anri-anri",      {NULL}, 4593, "udp"},
{"ias-session",        {NULL}, 4594, "tcp"},
{"ias-session",        {NULL}, 4594, "udp"},
{"ias-paging",         {NULL}, 4595, "tcp"},
{"ias-paging",         {NULL}, 4595, "udp"},
{"ias-neighbor",       {NULL}, 4596, "tcp"},
{"ias-neighbor",       {NULL}, 4596, "udp"},
{"a21-an-1xbs",        {NULL}, 4597, "tcp"},
{"a21-an-1xbs",        {NULL}, 4597, "udp"},
{"a16-an-an",          {NULL}, 4598, "tcp"},
{"a16-an-an",          {NULL}, 4598, "udp"},
{"a17-an-an",          {NULL}, 4599, "tcp"},
{"a17-an-an",          {NULL}, 4599, "udp"},
{"piranha1",           {NULL}, 4600, "tcp"},
{"piranha1",           {NULL}, 4600, "udp"},
{"piranha2",           {NULL}, 4601, "tcp"},
{"piranha2",           {NULL}, 4601, "udp"},
{"mtsserver",          {NULL}, 4602, "tcp"},
{"menandmice-upg",     {NULL}, 4603, "tcp"},
{"playsta2-app",       {NULL}, 4658, "tcp"},
{"playsta2-app",       {NULL}, 4658, "udp"},
{"playsta2-lob",       {NULL}, 4659, "tcp"},
{"playsta2-lob",       {NULL}, 4659, "udp"},
{"smaclmgr",           {NULL}, 4660, "tcp"},
{"smaclmgr",           {NULL}, 4660, "udp"},
{"kar2ouche",          {NULL}, 4661, "tcp"},
{"kar2ouche",          {NULL}, 4661, "udp"},
{"oms",                {NULL}, 4662, "tcp"},
{"oms",                {NULL}, 4662, "udp"},
{"noteit",             {NULL}, 4663, "tcp"},
{"noteit",             {NULL}, 4663, "udp"},
{"ems",                {NULL}, 4664, "tcp"},
{"ems",                {NULL}, 4664, "udp"},
{"contclientms",       {NULL}, 4665, "tcp"},
{"contclientms",       {NULL}, 4665, "udp"},
{"eportcomm",          {NULL}, 4666, "tcp"},
{"eportcomm",          {NULL}, 4666, "udp"},
{"mmacomm",            {NULL}, 4667, "tcp"},
{"mmacomm",            {NULL}, 4667, "udp"},
{"mmaeds",             {NULL}, 4668, "tcp"},
{"mmaeds",             {NULL}, 4668, "udp"},
{"eportcommdata",      {NULL}, 4669, "tcp"},
{"eportcommdata",      {NULL}, 4669, "udp"},
{"light",              {NULL}, 4670, "tcp"},
{"light",              {NULL}, 4670, "udp"},
{"acter",              {NULL}, 4671, "tcp"},
{"acter",              {NULL}, 4671, "udp"},
{"rfa",                {NULL}, 4672, "tcp"},
{"rfa",                {NULL}, 4672, "udp"},
{"cxws",               {NULL}, 4673, "tcp"},
{"cxws",               {NULL}, 4673, "udp"},
{"appiq-mgmt",         {NULL}, 4674, "tcp"},
{"appiq-mgmt",         {NULL}, 4674, "udp"},
{"dhct-status",        {NULL}, 4675, "tcp"},
{"dhct-status",        {NULL}, 4675, "udp"},
{"dhct-alerts",        {NULL}, 4676, "tcp"},
{"dhct-alerts",        {NULL}, 4676, "udp"},
{"bcs",                {NULL}, 4677, "tcp"},
{"bcs",                {NULL}, 4677, "udp"},
{"traversal",          {NULL}, 4678, "tcp"},
{"traversal",          {NULL}, 4678, "udp"},
{"mgesupervision",     {NULL}, 4679, "tcp"},
{"mgesupervision",     {NULL}, 4679, "udp"},
{"mgemanagement",      {NULL}, 4680, "tcp"},
{"mgemanagement",      {NULL}, 4680, "udp"},
{"parliant",           {NULL}, 4681, "tcp"},
{"parliant",           {NULL}, 4681, "udp"},
{"finisar",            {NULL}, 4682, "tcp"},
{"finisar",            {NULL}, 4682, "udp"},
{"spike",              {NULL}, 4683, "tcp"},
{"spike",              {NULL}, 4683, "udp"},
{"rfid-rp1",           {NULL}, 4684, "tcp"},
{"rfid-rp1",           {NULL}, 4684, "udp"},
{"autopac",            {NULL}, 4685, "tcp"},
{"autopac",            {NULL}, 4685, "udp"},
{"msp-os",             {NULL}, 4686, "tcp"},
{"msp-os",             {NULL}, 4686, "udp"},
{"nst",                {NULL}, 4687, "tcp"},
{"nst",                {NULL}, 4687, "udp"},
{"mobile-p2p",         {NULL}, 4688, "tcp"},
{"mobile-p2p",         {NULL}, 4688, "udp"},
{"altovacentral",      {NULL}, 4689, "tcp"},
{"altovacentral",      {NULL}, 4689, "udp"},
{"prelude",            {NULL}, 4690, "tcp"},
{"prelude",            {NULL}, 4690, "udp"},
{"mtn",                {NULL}, 4691, "tcp"},
{"mtn",                {NULL}, 4691, "udp"},
{"conspiracy",         {NULL}, 4692, "tcp"},
{"conspiracy",         {NULL}, 4692, "udp"},
{"netxms-agent",       {NULL}, 4700, "tcp"},
{"netxms-agent",       {NULL}, 4700, "udp"},
{"netxms-mgmt",        {NULL}, 4701, "tcp"},
{"netxms-mgmt",        {NULL}, 4701, "udp"},
{"netxms-sync",        {NULL}, 4702, "tcp"},
{"netxms-sync",        {NULL}, 4702, "udp"},
{"npqes-test",         {NULL}, 4703, "tcp"},
{"assuria-ins",        {NULL}, 4704, "tcp"},
{"truckstar",          {NULL}, 4725, "tcp"},
{"truckstar",          {NULL}, 4725, "udp"},
{"a26-fap-fgw",        {NULL}, 4726, "udp"},
{"fcis",               {NULL}, 4727, "tcp"},
{"fcis-disc",          {NULL}, 4727, "udp"},
{"capmux",             {NULL}, 4728, "tcp"},
{"capmux",             {NULL}, 4728, "udp"},
{"gsmtap",             {NULL}, 4729, "udp"},
{"gearman",            {NULL}, 4730, "tcp"},
{"gearman",            {NULL}, 4730, "udp"},
{"remcap",             {NULL}, 4731, "tcp"},
{"ohmtrigger",         {NULL}, 4732, "udp"},
{"resorcs",            {NULL}, 4733, "tcp"},
{"ipdr-sp",            {NULL}, 4737, "tcp"},
{"ipdr-sp",            {NULL}, 4737, "udp"},
{"solera-lpn",         {NULL}, 4738, "tcp"},
{"solera-lpn",         {NULL}, 4738, "udp"},
{"ipfix",              {NULL}, 4739, "tcp"},
{"ipfix",              {NULL}, 4739, "udp"},
{"ipfix",              {NULL}, 4739, "sctp"},
{"ipfixs",             {NULL}, 4740, "tcp"},
{"ipfixs",             {NULL}, 4740, "sctp"},
{"ipfixs",             {NULL}, 4740, "udp"},
{"lumimgrd",           {NULL}, 4741, "tcp"},
{"lumimgrd",           {NULL}, 4741, "udp"},
{"sicct",              {NULL}, 4742, "tcp"},
{"sicct-sdp",          {NULL}, 4742, "udp"},
{"openhpid",           {NULL}, 4743, "tcp"},
{"openhpid",           {NULL}, 4743, "udp"},
{"ifsp",               {NULL}, 4744, "tcp"},
{"ifsp",               {NULL}, 4744, "udp"},
{"fmp",                {NULL}, 4745, "tcp"},
{"fmp",                {NULL}, 4745, "udp"},
{"profilemac",         {NULL}, 4749, "tcp"},
{"profilemac",         {NULL}, 4749, "udp"},
{"ssad",               {NULL}, 4750, "tcp"},
{"ssad",               {NULL}, 4750, "udp"},
{"spocp",              {NULL}, 4751, "tcp"},
{"spocp",              {NULL}, 4751, "udp"},
{"snap",               {NULL}, 4752, "tcp"},
{"snap",               {NULL}, 4752, "udp"},
{"bfd-multi-ctl",      {NULL}, 4784, "tcp"},
{"bfd-multi-ctl",      {NULL}, 4784, "udp"},
{"cncp",               {NULL}, 4785, "udp"},
{"smart-install",      {NULL}, 4786, "tcp"},
{"sia-ctrl-plane",     {NULL}, 4787, "tcp"},
{"iims",               {NULL}, 4800, "tcp"},
{"iims",               {NULL}, 4800, "udp"},
{"iwec",               {NULL}, 4801, "tcp"},
{"iwec",               {NULL}, 4801, "udp"},
{"ilss",               {NULL}, 4802, "tcp"},
{"ilss",               {NULL}, 4802, "udp"},
{"notateit",           {NULL}, 4803, "tcp"},
{"notateit-disc",      {NULL}, 4803, "udp"},
{"aja-ntv4-disc",      {NULL}, 4804, "udp"},
{"htcp",               {NULL}, 4827, "tcp"},
{"htcp",               {NULL}, 4827, "udp"},
{"varadero-0",         {NULL}, 4837, "tcp"},
{"varadero-0",         {NULL}, 4837, "udp"},
{"varadero-1",         {NULL}, 4838, "tcp"},
{"varadero-1",         {NULL}, 4838, "udp"},
{"varadero-2",         {NULL}, 4839, "tcp"},
{"varadero-2",         {NULL}, 4839, "udp"},
{"opcua-tcp",          {NULL}, 4840, "tcp"},
{"opcua-udp",          {NULL}, 4840, "udp"},
{"quosa",              {NULL}, 4841, "tcp"},
{"quosa",              {NULL}, 4841, "udp"},
{"gw-asv",             {NULL}, 4842, "tcp"},
{"gw-asv",             {NULL}, 4842, "udp"},
{"opcua-tls",          {NULL}, 4843, "tcp"},
{"opcua-tls",          {NULL}, 4843, "udp"},
{"gw-log",             {NULL}, 4844, "tcp"},
{"gw-log",             {NULL}, 4844, "udp"},
{"wcr-remlib",         {NULL}, 4845, "tcp"},
{"wcr-remlib",         {NULL}, 4845, "udp"},
{"contamac_icm",       {NULL}, 4846, "tcp"},
{"contamac_icm",       {NULL}, 4846, "udp"},
{"wfc",                {NULL}, 4847, "tcp"},
{"wfc",                {NULL}, 4847, "udp"},
{"appserv-http",       {NULL}, 4848, "tcp"},
{"appserv-http",       {NULL}, 4848, "udp"},
{"appserv-https",      {NULL}, 4849, "tcp"},
{"appserv-https",      {NULL}, 4849, "udp"},
{"sun-as-nodeagt",     {NULL}, 4850, "tcp"},
{"sun-as-nodeagt",     {NULL}, 4850, "udp"},
{"derby-repli",        {NULL}, 4851, "tcp"},
{"derby-repli",        {NULL}, 4851, "udp"},
{"unify-debug",        {NULL}, 4867, "tcp"},
{"unify-debug",        {NULL}, 4867, "udp"},
{"phrelay",            {NULL}, 4868, "tcp"},
{"phrelay",            {NULL}, 4868, "udp"},
{"phrelaydbg",         {NULL}, 4869, "tcp"},
{"phrelaydbg",         {NULL}, 4869, "udp"},
{"cc-tracking",        {NULL}, 4870, "tcp"},
{"cc-tracking",        {NULL}, 4870, "udp"},
{"wired",              {NULL}, 4871, "tcp"},
{"wired",              {NULL}, 4871, "udp"},
{"tritium-can",        {NULL}, 4876, "tcp"},
{"tritium-can",        {NULL}, 4876, "udp"},
{"lmcs",               {NULL}, 4877, "tcp"},
{"lmcs",               {NULL}, 4877, "udp"},
{"inst-discovery",     {NULL}, 4878, "udp"},
{"wsdl-event",         {NULL}, 4879, "tcp"},
{"hislip",             {NULL}, 4880, "tcp"},
{"socp-t",             {NULL}, 4881, "udp"},
{"socp-c",             {NULL}, 4882, "udp"},
{"wmlserver",          {NULL}, 4883, "tcp"},
{"hivestor",           {NULL}, 4884, "tcp"},
{"hivestor",           {NULL}, 4884, "udp"},
{"abbs",               {NULL}, 4885, "tcp"},
{"abbs",               {NULL}, 4885, "udp"},
{"lyskom",             {NULL}, 4894, "tcp"},
{"lyskom",             {NULL}, 4894, "udp"},
{"radmin-port",        {NULL}, 4899, "tcp"},
{"radmin-port",        {NULL}, 4899, "udp"},
{"hfcs",               {NULL}, 4900, "tcp"},
{"hfcs",               {NULL}, 4900, "udp"},
{"flr_agent",          {NULL}, 4901, "tcp"},
{"magiccontrol",       {NULL}, 4902, "tcp"},
{"lutap",              {NULL}, 4912, "tcp"},
{"lutcp",              {NULL}, 4913, "tcp"},
{"bones",              {NULL}, 4914, "tcp"},
{"bones",              {NULL}, 4914, "udp"},
{"frcs",               {NULL}, 4915, "tcp"},
{"atsc-mh-ssc",        {NULL}, 4937, "udp"},
{"eq-office-4940",     {NULL}, 4940, "tcp"},
{"eq-office-4940",     {NULL}, 4940, "udp"},
{"eq-office-4941",     {NULL}, 4941, "tcp"},
{"eq-office-4941",     {NULL}, 4941, "udp"},
{"eq-office-4942",     {NULL}, 4942, "tcp"},
{"eq-office-4942",     {NULL}, 4942, "udp"},
{"munin",              {NULL}, 4949, "tcp"},
{"munin",              {NULL}, 4949, "udp"},
{"sybasesrvmon",       {NULL}, 4950, "tcp"},
{"sybasesrvmon",       {NULL}, 4950, "udp"},
{"pwgwims",            {NULL}, 4951, "tcp"},
{"pwgwims",            {NULL}, 4951, "udp"},
{"sagxtsds",           {NULL}, 4952, "tcp"},
{"sagxtsds",           {NULL}, 4952, "udp"},
{"dbsyncarbiter",      {NULL}, 4953, "tcp"},
{"ccss-qmm",           {NULL}, 4969, "tcp"},
{"ccss-qmm",           {NULL}, 4969, "udp"},
{"ccss-qsm",           {NULL}, 4970, "tcp"},
{"ccss-qsm",           {NULL}, 4970, "udp"},
{"webyast",            {NULL}, 4984, "tcp"},
{"gerhcs",             {NULL}, 4985, "tcp"},
{"mrip",               {NULL}, 4986, "tcp"},
{"mrip",               {NULL}, 4986, "udp"},
{"smar-se-port1",      {NULL}, 4987, "tcp"},
{"smar-se-port1",      {NULL}, 4987, "udp"},
{"smar-se-port2",      {NULL}, 4988, "tcp"},
{"smar-se-port2",      {NULL}, 4988, "udp"},
{"parallel",           {NULL}, 4989, "tcp"},
{"parallel",           {NULL}, 4989, "udp"},
{"busycal",            {NULL}, 4990, "tcp"},
{"busycal",            {NULL}, 4990, "udp"},
{"vrt",                {NULL}, 4991, "tcp"},
{"vrt",                {NULL}, 4991, "udp"},
{"hfcs-manager",       {NULL}, 4999, "tcp"},
{"hfcs-manager",       {NULL}, 4999, "udp"},
{"commplex-main",      {NULL}, 5000, "tcp"},
{"commplex-main",      {NULL}, 5000, "udp"},
{"commplex-link",      {NULL}, 5001, "tcp"},
{"commplex-link",      {NULL}, 5001, "udp"},
{"rfe",                {NULL}, 5002, "tcp"},
{"rfe",                {NULL}, 5002, "udp"},
{"fmpro-internal",     {NULL}, 5003, "tcp"},
{"fmpro-internal",     {NULL}, 5003, "udp"},
{"avt-profile-1",      {NULL}, 5004, "tcp"},
{"avt-profile-1",      {NULL}, 5004, "udp"},
{"avt-profile-1",      {NULL}, 5004, "dccp"},
{"avt-profile-2",      {NULL}, 5005, "tcp"},
{"avt-profile-2",      {NULL}, 5005, "udp"},
{"avt-profile-2",      {NULL}, 5005, "dccp"},
{"wsm-server",         {NULL}, 5006, "tcp"},
{"wsm-server",         {NULL}, 5006, "udp"},
{"wsm-server-ssl",     {NULL}, 5007, "tcp"},
{"wsm-server-ssl",     {NULL}, 5007, "udp"},
{"synapsis-edge",      {NULL}, 5008, "tcp"},
{"synapsis-edge",      {NULL}, 5008, "udp"},
{"winfs",              {NULL}, 5009, "tcp"},
{"winfs",              {NULL}, 5009, "udp"},
{"telelpathstart",     {NULL}, 5010, "tcp"},
{"telelpathstart",     {NULL}, 5010, "udp"},
{"telelpathattack",    {NULL}, 5011, "tcp"},
{"telelpathattack",    {NULL}, 5011, "udp"},
{"nsp",                {NULL}, 5012, "tcp"},
{"nsp",                {NULL}, 5012, "udp"},
{"fmpro-v6",           {NULL}, 5013, "tcp"},
{"fmpro-v6",           {NULL}, 5013, "udp"},
{"onpsocket",          {NULL}, 5014, "udp"},
{"fmwp",               {NULL}, 5015, "tcp"},
{"zenginkyo-1",        {NULL}, 5020, "tcp"},
{"zenginkyo-1",        {NULL}, 5020, "udp"},
{"zenginkyo-2",        {NULL}, 5021, "tcp"},
{"zenginkyo-2",        {NULL}, 5021, "udp"},
{"mice",               {NULL}, 5022, "tcp"},
{"mice",               {NULL}, 5022, "udp"},
{"htuilsrv",           {NULL}, 5023, "tcp"},
{"htuilsrv",           {NULL}, 5023, "udp"},
{"scpi-telnet",        {NULL}, 5024, "tcp"},
{"scpi-telnet",        {NULL}, 5024, "udp"},
{"scpi-raw",           {NULL}, 5025, "tcp"},
{"scpi-raw",           {NULL}, 5025, "udp"},
{"strexec-d",          {NULL}, 5026, "tcp"},
{"strexec-d",          {NULL}, 5026, "udp"},
{"strexec-s",          {NULL}, 5027, "tcp"},
{"strexec-s",          {NULL}, 5027, "udp"},
{"qvr",                {NULL}, 5028, "tcp"},
{"infobright",         {NULL}, 5029, "tcp"},
{"infobright",         {NULL}, 5029, "udp"},
{"surfpass",           {NULL}, 5030, "tcp"},
{"surfpass",           {NULL}, 5030, "udp"},
{"dmp",                {NULL}, 5031, "udp"},
{"asnaacceler8db",     {NULL}, 5042, "tcp"},
{"asnaacceler8db",     {NULL}, 5042, "udp"},
{"swxadmin",           {NULL}, 5043, "tcp"},
{"swxadmin",           {NULL}, 5043, "udp"},
{"lxi-evntsvc",        {NULL}, 5044, "tcp"},
{"lxi-evntsvc",        {NULL}, 5044, "udp"},
{"osp",                {NULL}, 5045, "tcp"},
{"vpm-udp",            {NULL}, 5046, "udp"},
{"iscape",             {NULL}, 5047, "udp"},
{"texai",              {NULL}, 5048, "tcp"},
{"ivocalize",          {NULL}, 5049, "tcp"},
{"ivocalize",          {NULL}, 5049, "udp"},
{"mmcc",               {NULL}, 5050, "tcp"},
{"mmcc",               {NULL}, 5050, "udp"},
{"ita-agent",          {NULL}, 5051, "tcp"},
{"ita-agent",          {NULL}, 5051, "udp"},
{"ita-manager",        {NULL}, 5052, "tcp"},
{"ita-manager",        {NULL}, 5052, "udp"},
{"rlm",                {NULL}, 5053, "tcp"},
{"rlm-admin",          {NULL}, 5054, "tcp"},
{"unot",               {NULL}, 5055, "tcp"},
{"unot",               {NULL}, 5055, "udp"},
{"intecom-ps1",        {NULL}, 5056, "tcp"},
{"intecom-ps1",        {NULL}, 5056, "udp"},
{"intecom-ps2",        {NULL}, 5057, "tcp"},
{"intecom-ps2",        {NULL}, 5057, "udp"},
{"locus-disc",         {NULL}, 5058, "udp"},
{"sds",                {NULL}, 5059, "tcp"},
{"sds",                {NULL}, 5059, "udp"},
{"sip",                {NULL}, 5060, "tcp"},
{"sip",                {NULL}, 5060, "udp"},
{"sip-tls",            {NULL}, 5061, "tcp"},
{"sip-tls",            {NULL}, 5061, "udp"},
{"na-localise",        {NULL}, 5062, "tcp"},
{"na-localise",        {NULL}, 5062, "udp"},
{"csrpc",              {NULL}, 5063, "tcp"},
{"ca-1",               {NULL}, 5064, "tcp"},
{"ca-1",               {NULL}, 5064, "udp"},
{"ca-2",               {NULL}, 5065, "tcp"},
{"ca-2",               {NULL}, 5065, "udp"},
{"stanag-5066",        {NULL}, 5066, "tcp"},
{"stanag-5066",        {NULL}, 5066, "udp"},
{"authentx",           {NULL}, 5067, "tcp"},
{"authentx",           {NULL}, 5067, "udp"},
{"bitforestsrv",       {NULL}, 5068, "tcp"},
{"i-net-2000-npr",     {NULL}, 5069, "tcp"},
{"i-net-2000-npr",     {NULL}, 5069, "udp"},
{"vtsas",              {NULL}, 5070, "tcp"},
{"vtsas",              {NULL}, 5070, "udp"},
{"powerschool",        {NULL}, 5071, "tcp"},
{"powerschool",        {NULL}, 5071, "udp"},
{"ayiya",              {NULL}, 5072, "tcp"},
{"ayiya",              {NULL}, 5072, "udp"},
{"tag-pm",             {NULL}, 5073, "tcp"},
{"tag-pm",             {NULL}, 5073, "udp"},
{"alesquery",          {NULL}, 5074, "tcp"},
{"alesquery",          {NULL}, 5074, "udp"},
{"cp-spxrpts",         {NULL}, 5079, "udp"},
{"onscreen",           {NULL}, 5080, "tcp"},
{"onscreen",           {NULL}, 5080, "udp"},
{"sdl-ets",            {NULL}, 5081, "tcp"},
{"sdl-ets",            {NULL}, 5081, "udp"},
{"qcp",                {NULL}, 5082, "tcp"},
{"qcp",                {NULL}, 5082, "udp"},
{"qfp",                {NULL}, 5083, "tcp"},
{"qfp",                {NULL}, 5083, "udp"},
{"llrp",               {NULL}, 5084, "tcp"},
{"llrp",               {NULL}, 5084, "udp"},
{"encrypted-llrp",     {NULL}, 5085, "tcp"},
{"encrypted-llrp",     {NULL}, 5085, "udp"},
{"aprigo-cs",          {NULL}, 5086, "tcp"},
{"car",                {NULL}, 5090, "sctp"},
{"cxtp",               {NULL}, 5091, "sctp"},
{"magpie",             {NULL}, 5092, "udp"},
{"sentinel-lm",        {NULL}, 5093, "tcp"},
{"sentinel-lm",        {NULL}, 5093, "udp"},
{"hart-ip",            {NULL}, 5094, "tcp"},
{"hart-ip",            {NULL}, 5094, "udp"},
{"sentlm-srv2srv",     {NULL}, 5099, "tcp"},
{"sentlm-srv2srv",     {NULL}, 5099, "udp"},
{"socalia",            {NULL}, 5100, "tcp"},
{"socalia",            {NULL}, 5100, "udp"},
{"talarian-tcp",       {NULL}, 5101, "tcp"},
{"talarian-udp",       {NULL}, 5101, "udp"},
{"oms-nonsecure",      {NULL}, 5102, "tcp"},
{"oms-nonsecure",      {NULL}, 5102, "udp"},
{"actifio-c2c",        {NULL}, 5103, "tcp"},
{"tinymessage",        {NULL}, 5104, "udp"},
{"hughes-ap",          {NULL}, 5105, "udp"},
{"taep-as-svc",        {NULL}, 5111, "tcp"},
{"taep-as-svc",        {NULL}, 5111, "udp"},
{"pm-cmdsvr",          {NULL}, 5112, "tcp"},
{"pm-cmdsvr",          {NULL}, 5112, "udp"},
{"ev-services",        {NULL}, 5114, "tcp"},
{"autobuild",          {NULL}, 5115, "tcp"},
{"emb-proj-cmd",       {NULL}, 5116, "udp"},
{"gradecam",           {NULL}, 5117, "tcp"},
{"nbt-pc",             {NULL}, 5133, "tcp"},
{"nbt-pc",             {NULL}, 5133, "udp"},
{"ppactivation",       {NULL}, 5134, "tcp"},
{"erp-scale",          {NULL}, 5135, "tcp"},
{"minotaur-sa",        {NULL}, 5136, "udp"},
{"ctsd",               {NULL}, 5137, "tcp"},
{"ctsd",               {NULL}, 5137, "udp"},
{"rmonitor_secure",    {NULL}, 5145, "tcp"},
{"rmonitor_secure",    {NULL}, 5145, "udp"},
{"social-alarm",       {NULL}, 5146, "tcp"},
{"atmp",               {NULL}, 5150, "tcp"},
{"atmp",               {NULL}, 5150, "udp"},
{"esri_sde",           {NULL}, 5151, "tcp"},
{"esri_sde",           {NULL}, 5151, "udp"},
{"sde-discovery",      {NULL}, 5152, "tcp"},
{"sde-discovery",      {NULL}, 5152, "udp"},
{"toruxserver",        {NULL}, 5153, "tcp"},
{"bzflag",             {NULL}, 5154, "tcp"},
{"bzflag",             {NULL}, 5154, "udp"},
{"asctrl-agent",       {NULL}, 5155, "tcp"},
{"asctrl-agent",       {NULL}, 5155, "udp"},
{"rugameonline",       {NULL}, 5156, "tcp"},
{"mediat",             {NULL}, 5157, "tcp"},
{"snmpssh",            {NULL}, 5161, "tcp"},
{"snmpssh-trap",       {NULL}, 5162, "tcp"},
{"sbackup",            {NULL}, 5163, "tcp"},
{"vpa",                {NULL}, 5164, "tcp"},
{"vpa-disc",           {NULL}, 5164, "udp"},
{"ife_icorp",          {NULL}, 5165, "tcp"},
{"ife_icorp",          {NULL}, 5165, "udp"},
{"winpcs",             {NULL}, 5166, "tcp"},
{"winpcs",             {NULL}, 5166, "udp"},
{"scte104",            {NULL}, 5167, "tcp"},
{"scte104",            {NULL}, 5167, "udp"},
{"scte30",             {NULL}, 5168, "tcp"},
{"scte30",             {NULL}, 5168, "udp"},
{"aol",                {NULL}, 5190, "tcp"},
{"aol",                {NULL}, 5190, "udp"},
{"aol-1",              {NULL}, 5191, "tcp"},
{"aol-1",              {NULL}, 5191, "udp"},
{"aol-2",              {NULL}, 5192, "tcp"},
{"aol-2",              {NULL}, 5192, "udp"},
{"aol-3",              {NULL}, 5193, "tcp"},
{"aol-3",              {NULL}, 5193, "udp"},
{"cpscomm",            {NULL}, 5194, "tcp"},
{"targus-getdata",     {NULL}, 5200, "tcp"},
{"targus-getdata",     {NULL}, 5200, "udp"},
{"targus-getdata1",    {NULL}, 5201, "tcp"},
{"targus-getdata1",    {NULL}, 5201, "udp"},
{"targus-getdata2",    {NULL}, 5202, "tcp"},
{"targus-getdata2",    {NULL}, 5202, "udp"},
{"targus-getdata3",    {NULL}, 5203, "tcp"},
{"targus-getdata3",    {NULL}, 5203, "udp"},
{"3exmp",              {NULL}, 5221, "tcp"},
{"xmpp-client",        {NULL}, 5222, "tcp"},
{"hpvirtgrp",          {NULL}, 5223, "tcp"},
{"hpvirtgrp",          {NULL}, 5223, "udp"},
{"hpvirtctrl",         {NULL}, 5224, "tcp"},
{"hpvirtctrl",         {NULL}, 5224, "udp"},
{"hp-server",          {NULL}, 5225, "tcp"},
{"hp-server",          {NULL}, 5225, "udp"},
{"hp-status",          {NULL}, 5226, "tcp"},
{"hp-status",          {NULL}, 5226, "udp"},
{"perfd",              {NULL}, 5227, "tcp"},
{"perfd",              {NULL}, 5227, "udp"},
{"hpvroom",            {NULL}, 5228, "tcp"},
{"csedaemon",          {NULL}, 5232, "tcp"},
{"enfs",               {NULL}, 5233, "tcp"},
{"eenet",              {NULL}, 5234, "tcp"},
{"eenet",              {NULL}, 5234, "udp"},
{"galaxy-network",     {NULL}, 5235, "tcp"},
{"galaxy-network",     {NULL}, 5235, "udp"},
{"padl2sim",           {NULL}, 5236, "tcp"},
{"padl2sim",           {NULL}, 5236, "udp"},
{"mnet-discovery",     {NULL}, 5237, "tcp"},
{"mnet-discovery",     {NULL}, 5237, "udp"},
{"downtools",          {NULL}, 5245, "tcp"},
{"downtools-disc",     {NULL}, 5245, "udp"},
{"capwap-control",     {NULL}, 5246, "udp"},
{"capwap-data",        {NULL}, 5247, "udp"},
{"caacws",             {NULL}, 5248, "tcp"},
{"caacws",             {NULL}, 5248, "udp"},
{"caaclang2",          {NULL}, 5249, "tcp"},
{"caaclang2",          {NULL}, 5249, "udp"},
{"soagateway",         {NULL}, 5250, "tcp"},
{"soagateway",         {NULL}, 5250, "udp"},
{"caevms",             {NULL}, 5251, "tcp"},
{"caevms",             {NULL}, 5251, "udp"},
{"movaz-ssc",          {NULL}, 5252, "tcp"},
{"movaz-ssc",          {NULL}, 5252, "udp"},
{"kpdp",               {NULL}, 5253, "tcp"},
{"3com-njack-1",       {NULL}, 5264, "tcp"},
{"3com-njack-1",       {NULL}, 5264, "udp"},
{"3com-njack-2",       {NULL}, 5265, "tcp"},
{"3com-njack-2",       {NULL}, 5265, "udp"},
{"xmpp-server",        {NULL}, 5269, "tcp"},
{"xmp",                {NULL}, 5270, "tcp"},
{"xmp",                {NULL}, 5270, "udp"},
{"cuelink",            {NULL}, 5271, "tcp"},
{"cuelink-disc",       {NULL}, 5271, "udp"},
{"pk",                 {NULL}, 5272, "tcp"},
{"pk",                 {NULL}, 5272, "udp"},
{"xmpp-bosh",          {NULL}, 5280, "tcp"},
{"undo-lm",            {NULL}, 5281, "tcp"},
{"transmit-port",      {NULL}, 5282, "tcp"},
{"transmit-port",      {NULL}, 5282, "udp"},
{"presence",           {NULL}, 5298, "tcp"},
{"presence",           {NULL}, 5298, "udp"},
{"nlg-data",           {NULL}, 5299, "tcp"},
{"nlg-data",           {NULL}, 5299, "udp"},
{"hacl-hb",            {NULL}, 5300, "tcp"},
{"hacl-hb",            {NULL}, 5300, "udp"},
{"hacl-gs",            {NULL}, 5301, "tcp"},
{"hacl-gs",            {NULL}, 5301, "udp"},
{"hacl-cfg",           {NULL}, 5302, "tcp"},
{"hacl-cfg",           {NULL}, 5302, "udp"},
{"hacl-probe",         {NULL}, 5303, "tcp"},
{"hacl-probe",         {NULL}, 5303, "udp"},
{"hacl-local",         {NULL}, 5304, "tcp"},
{"hacl-local",         {NULL}, 5304, "udp"},
{"hacl-test",          {NULL}, 5305, "tcp"},
{"hacl-test",          {NULL}, 5305, "udp"},
{"sun-mc-grp",         {NULL}, 5306, "tcp"},
{"sun-mc-grp",         {NULL}, 5306, "udp"},
{"sco-aip",            {NULL}, 5307, "tcp"},
{"sco-aip",            {NULL}, 5307, "udp"},
{"cfengine",           {NULL}, 5308, "tcp"},
{"cfengine",           {NULL}, 5308, "udp"},
{"jprinter",           {NULL}, 5309, "tcp"},
{"jprinter",           {NULL}, 5309, "udp"},
{"outlaws",            {NULL}, 5310, "tcp"},
{"outlaws",            {NULL}, 5310, "udp"},
{"permabit-cs",        {NULL}, 5312, "tcp"},
{"permabit-cs",        {NULL}, 5312, "udp"},
{"rrdp",               {NULL}, 5313, "tcp"},
{"rrdp",               {NULL}, 5313, "udp"},
{"opalis-rbt-ipc",     {NULL}, 5314, "tcp"},
{"opalis-rbt-ipc",     {NULL}, 5314, "udp"},
{"hacl-poll",          {NULL}, 5315, "tcp"},
{"hacl-poll",          {NULL}, 5315, "udp"},
{"hpdevms",            {NULL}, 5316, "tcp"},
{"hpdevms",            {NULL}, 5316, "udp"},
{"bsfserver-zn",       {NULL}, 5320, "tcp"},
{"bsfsvr-zn-ssl",      {NULL}, 5321, "tcp"},
{"kfserver",           {NULL}, 5343, "tcp"},
{"kfserver",           {NULL}, 5343, "udp"},
{"xkotodrcp",          {NULL}, 5344, "tcp"},
{"xkotodrcp",          {NULL}, 5344, "udp"},
{"stuns",              {NULL}, 5349, "tcp"},
{"stuns",              {NULL}, 5349, "udp"},
{"turns",              {NULL}, 5349, "tcp"},
{"turns",              {NULL}, 5349, "udp"},
{"stun-behaviors",     {NULL}, 5349, "tcp"},
{"stun-behaviors",     {NULL}, 5349, "udp"},
{"nat-pmp-status",     {NULL}, 5350, "tcp"},
{"nat-pmp-status",     {NULL}, 5350, "udp"},
{"nat-pmp",            {NULL}, 5351, "tcp"},
{"nat-pmp",            {NULL}, 5351, "udp"},
{"dns-llq",            {NULL}, 5352, "tcp"},
{"dns-llq",            {NULL}, 5352, "udp"},
{"mdns",               {NULL}, 5353, "tcp"},
{"mdns",               {NULL}, 5353, "udp"},
{"mdnsresponder",      {NULL}, 5354, "tcp"},
{"mdnsresponder",      {NULL}, 5354, "udp"},
{"llmnr",              {NULL}, 5355, "tcp"},
{"llmnr",              {NULL}, 5355, "udp"},
{"ms-smlbiz",          {NULL}, 5356, "tcp"},
{"ms-smlbiz",          {NULL}, 5356, "udp"},
{"wsdapi",             {NULL}, 5357, "tcp"},
{"wsdapi",             {NULL}, 5357, "udp"},
{"wsdapi-s",           {NULL}, 5358, "tcp"},
{"wsdapi-s",           {NULL}, 5358, "udp"},
{"ms-alerter",         {NULL}, 5359, "tcp"},
{"ms-alerter",         {NULL}, 5359, "udp"},
{"ms-sideshow",        {NULL}, 5360, "tcp"},
{"ms-sideshow",        {NULL}, 5360, "udp"},
{"ms-s-sideshow",      {NULL}, 5361, "tcp"},
{"ms-s-sideshow",      {NULL}, 5361, "udp"},
{"serverwsd2",         {NULL}, 5362, "tcp"},
{"serverwsd2",         {NULL}, 5362, "udp"},
{"net-projection",     {NULL}, 5363, "tcp"},
{"net-projection",     {NULL}, 5363, "udp"},
{"stresstester",       {NULL}, 5397, "tcp"},
{"stresstester",       {NULL}, 5397, "udp"},
{"elektron-admin",     {NULL}, 5398, "tcp"},
{"elektron-admin",     {NULL}, 5398, "udp"},
{"securitychase",      {NULL}, 5399, "tcp"},
{"securitychase",      {NULL}, 5399, "udp"},
{"excerpt",            {NULL}, 5400, "tcp"},
{"excerpt",            {NULL}, 5400, "udp"},
{"excerpts",           {NULL}, 5401, "tcp"},
{"excerpts",           {NULL}, 5401, "udp"},
{"mftp",               {NULL}, 5402, "tcp"},
{"mftp",               {NULL}, 5402, "udp"},
{"hpoms-ci-lstn",      {NULL}, 5403, "tcp"},
{"hpoms-ci-lstn",      {NULL}, 5403, "udp"},
{"hpoms-dps-lstn",     {NULL}, 5404, "tcp"},
{"hpoms-dps-lstn",     {NULL}, 5404, "udp"},
{"netsupport",         {NULL}, 5405, "tcp"},
{"netsupport",         {NULL}, 5405, "udp"},
{"systemics-sox",      {NULL}, 5406, "tcp"},
{"systemics-sox",      {NULL}, 5406, "udp"},
{"foresyte-clear",     {NULL}, 5407, "tcp"},
{"foresyte-clear",     {NULL}, 5407, "udp"},
{"foresyte-sec",       {NULL}, 5408, "tcp"},
{"foresyte-sec",       {NULL}, 5408, "udp"},
{"salient-dtasrv",     {NULL}, 5409, "tcp"},
{"salient-dtasrv",     {NULL}, 5409, "udp"},
{"salient-usrmgr",     {NULL}, 5410, "tcp"},
{"salient-usrmgr",     {NULL}, 5410, "udp"},
{"actnet",             {NULL}, 5411, "tcp"},
{"actnet",             {NULL}, 5411, "udp"},
{"continuus",          {NULL}, 5412, "tcp"},
{"continuus",          {NULL}, 5412, "udp"},
{"wwiotalk",           {NULL}, 5413, "tcp"},
{"wwiotalk",           {NULL}, 5413, "udp"},
{"statusd",            {NULL}, 5414, "tcp"},
{"statusd",            {NULL}, 5414, "udp"},
{"ns-server",          {NULL}, 5415, "tcp"},
{"ns-server",          {NULL}, 5415, "udp"},
{"sns-gateway",        {NULL}, 5416, "tcp"},
{"sns-gateway",        {NULL}, 5416, "udp"},
{"sns-agent",          {NULL}, 5417, "tcp"},
{"sns-agent",          {NULL}, 5417, "udp"},
{"mcntp",              {NULL}, 5418, "tcp"},
{"mcntp",              {NULL}, 5418, "udp"},
{"dj-ice",             {NULL}, 5419, "tcp"},
{"dj-ice",             {NULL}, 5419, "udp"},
{"cylink-c",           {NULL}, 5420, "tcp"},
{"cylink-c",           {NULL}, 5420, "udp"},
{"netsupport2",        {NULL}, 5421, "tcp"},
{"netsupport2",        {NULL}, 5421, "udp"},
{"salient-mux",        {NULL}, 5422, "tcp"},
{"salient-mux",        {NULL}, 5422, "udp"},
{"virtualuser",        {NULL}, 5423, "tcp"},
{"virtualuser",        {NULL}, 5423, "udp"},
{"beyond-remote",      {NULL}, 5424, "tcp"},
{"beyond-remote",      {NULL}, 5424, "udp"},
{"br-channel",         {NULL}, 5425, "tcp"},
{"br-channel",         {NULL}, 5425, "udp"},
{"devbasic",           {NULL}, 5426, "tcp"},
{"devbasic",           {NULL}, 5426, "udp"},
{"sco-peer-tta",       {NULL}, 5427, "tcp"},
{"sco-peer-tta",       {NULL}, 5427, "udp"},
{"telaconsole",        {NULL}, 5428, "tcp"},
{"telaconsole",        {NULL}, 5428, "udp"},
{"base",               {NULL}, 5429, "tcp"},
{"base",               {NULL}, 5429, "udp"},
{"radec-corp",         {NULL}, 5430, "tcp"},
{"radec-corp",         {NULL}, 5430, "udp"},
{"park-agent",         {NULL}, 5431, "tcp"},
{"park-agent",         {NULL}, 5431, "udp"},
{"postgresql",         {NULL}, 5432, "tcp"},
{"postgresql",         {NULL}, 5432, "udp"},
{"pyrrho",             {NULL}, 5433, "tcp"},
{"pyrrho",             {NULL}, 5433, "udp"},
{"sgi-arrayd",         {NULL}, 5434, "tcp"},
{"sgi-arrayd",         {NULL}, 5434, "udp"},
{"sceanics",           {NULL}, 5435, "tcp"},
{"sceanics",           {NULL}, 5435, "udp"},
{"pmip6-cntl",         {NULL}, 5436, "udp"},
{"pmip6-data",         {NULL}, 5437, "udp"},
{"spss",               {NULL}, 5443, "tcp"},
{"spss",               {NULL}, 5443, "udp"},
{"surebox",            {NULL}, 5453, "tcp"},
{"surebox",            {NULL}, 5453, "udp"},
{"apc-5454",           {NULL}, 5454, "tcp"},
{"apc-5454",           {NULL}, 5454, "udp"},
{"apc-5455",           {NULL}, 5455, "tcp"},
{"apc-5455",           {NULL}, 5455, "udp"},
{"apc-5456",           {NULL}, 5456, "tcp"},
{"apc-5456",           {NULL}, 5456, "udp"},
{"silkmeter",          {NULL}, 5461, "tcp"},
{"silkmeter",          {NULL}, 5461, "udp"},
{"ttl-publisher",      {NULL}, 5462, "tcp"},
{"ttl-publisher",      {NULL}, 5462, "udp"},
{"ttlpriceproxy",      {NULL}, 5463, "tcp"},
{"ttlpriceproxy",      {NULL}, 5463, "udp"},
{"quailnet",           {NULL}, 5464, "tcp"},
{"quailnet",           {NULL}, 5464, "udp"},
{"netops-broker",      {NULL}, 5465, "tcp"},
{"netops-broker",      {NULL}, 5465, "udp"},
{"fcp-addr-srvr1",     {NULL}, 5500, "tcp"},
{"fcp-addr-srvr1",     {NULL}, 5500, "udp"},
{"fcp-addr-srvr2",     {NULL}, 5501, "tcp"},
{"fcp-addr-srvr2",     {NULL}, 5501, "udp"},
{"fcp-srvr-inst1",     {NULL}, 5502, "tcp"},
{"fcp-srvr-inst1",     {NULL}, 5502, "udp"},
{"fcp-srvr-inst2",     {NULL}, 5503, "tcp"},
{"fcp-srvr-inst2",     {NULL}, 5503, "udp"},
{"fcp-cics-gw1",       {NULL}, 5504, "tcp"},
{"fcp-cics-gw1",       {NULL}, 5504, "udp"},
{"checkoutdb",         {NULL}, 5505, "tcp"},
{"checkoutdb",         {NULL}, 5505, "udp"},
{"amc",                {NULL}, 5506, "tcp"},
{"amc",                {NULL}, 5506, "udp"},
{"sgi-eventmond",      {NULL}, 5553, "tcp"},
{"sgi-eventmond",      {NULL}, 5553, "udp"},
{"sgi-esphttp",        {NULL}, 5554, "tcp"},
{"sgi-esphttp",        {NULL}, 5554, "udp"},
{"personal-agent",     {NULL}, 5555, "tcp"},
{"personal-agent",     {NULL}, 5555, "udp"},
{"freeciv",            {NULL}, 5556, "tcp"},
{"freeciv",            {NULL}, 5556, "udp"},
{"farenet",            {NULL}, 5557, "tcp"},
{"westec-connect",     {NULL}, 5566, "tcp"},
{"m-oap",              {NULL}, 5567, "tcp"},
{"m-oap",              {NULL}, 5567, "udp"},
{"sdt",                {NULL}, 5568, "tcp"},
{"sdt",                {NULL}, 5568, "udp"},
{"sdmmp",              {NULL}, 5573, "tcp"},
{"sdmmp",              {NULL}, 5573, "udp"},
{"lsi-bobcat",         {NULL}, 5574, "tcp"},
{"ora-oap",            {NULL}, 5575, "tcp"},
{"fdtracks",           {NULL}, 5579, "tcp"},
{"tmosms0",            {NULL}, 5580, "tcp"},
{"tmosms0",            {NULL}, 5580, "udp"},
{"tmosms1",            {NULL}, 5581, "tcp"},
{"tmosms1",            {NULL}, 5581, "udp"},
{"fac-restore",        {NULL}, 5582, "tcp"},
{"fac-restore",        {NULL}, 5582, "udp"},
{"tmo-icon-sync",      {NULL}, 5583, "tcp"},
{"tmo-icon-sync",      {NULL}, 5583, "udp"},
{"bis-web",            {NULL}, 5584, "tcp"},
{"bis-web",            {NULL}, 5584, "udp"},
{"bis-sync",           {NULL}, 5585, "tcp"},
{"bis-sync",           {NULL}, 5585, "udp"},
{"ininmessaging",      {NULL}, 5597, "tcp"},
{"ininmessaging",      {NULL}, 5597, "udp"},
{"mctfeed",            {NULL}, 5598, "tcp"},
{"mctfeed",            {NULL}, 5598, "udp"},
{"esinstall",          {NULL}, 5599, "tcp"},
{"esinstall",          {NULL}, 5599, "udp"},
{"esmmanager",         {NULL}, 5600, "tcp"},
{"esmmanager",         {NULL}, 5600, "udp"},
{"esmagent",           {NULL}, 5601, "tcp"},
{"esmagent",           {NULL}, 5601, "udp"},
{"a1-msc",             {NULL}, 5602, "tcp"},
{"a1-msc",             {NULL}, 5602, "udp"},
{"a1-bs",              {NULL}, 5603, "tcp"},
{"a1-bs",              {NULL}, 5603, "udp"},
{"a3-sdunode",         {NULL}, 5604, "tcp"},
{"a3-sdunode",         {NULL}, 5604, "udp"},
{"a4-sdunode",         {NULL}, 5605, "tcp"},
{"a4-sdunode",         {NULL}, 5605, "udp"},
{"ninaf",              {NULL}, 5627, "tcp"},
{"ninaf",              {NULL}, 5627, "udp"},
{"htrust",             {NULL}, 5628, "tcp"},
{"htrust",             {NULL}, 5628, "udp"},
{"symantec-sfdb",      {NULL}, 5629, "tcp"},
{"symantec-sfdb",      {NULL}, 5629, "udp"},
{"precise-comm",       {NULL}, 5630, "tcp"},
{"precise-comm",       {NULL}, 5630, "udp"},
{"pcanywheredata",     {NULL}, 5631, "tcp"},
{"pcanywheredata",     {NULL}, 5631, "udp"},
{"pcanywherestat",     {NULL}, 5632, "tcp"},
{"pcanywherestat",     {NULL}, 5632, "udp"},
{"beorl",              {NULL}, 5633, "tcp"},
{"beorl",              {NULL}, 5633, "udp"},
{"xprtld",             {NULL}, 5634, "tcp"},
{"xprtld",             {NULL}, 5634, "udp"},
{"sfmsso",             {NULL}, 5635, "tcp"},
{"sfm-db-server",      {NULL}, 5636, "tcp"},
{"cssc",               {NULL}, 5637, "tcp"},
{"amqps",              {NULL}, 5671, "tcp"},
{"amqps",              {NULL}, 5671, "udp"},
{"amqp",               {NULL}, 5672, "tcp"},
{"amqp",               {NULL}, 5672, "udp"},
{"amqp",               {NULL}, 5672, "sctp"},
{"jms",                {NULL}, 5673, "tcp"},
{"jms",                {NULL}, 5673, "udp"},
{"hyperscsi-port",     {NULL}, 5674, "tcp"},
{"hyperscsi-port",     {NULL}, 5674, "udp"},
{"v5ua",               {NULL}, 5675, "tcp"},
{"v5ua",               {NULL}, 5675, "udp"},
{"v5ua",               {NULL}, 5675, "sctp"},
{"raadmin",            {NULL}, 5676, "tcp"},
{"raadmin",            {NULL}, 5676, "udp"},
{"questdb2-lnchr",     {NULL}, 5677, "tcp"},
{"questdb2-lnchr",     {NULL}, 5677, "udp"},
{"rrac",               {NULL}, 5678, "tcp"},
{"rrac",               {NULL}, 5678, "udp"},
{"dccm",               {NULL}, 5679, "tcp"},
{"dccm",               {NULL}, 5679, "udp"},
{"auriga-router",      {NULL}, 5680, "tcp"},
{"auriga-router",      {NULL}, 5680, "udp"},
{"ncxcp",              {NULL}, 5681, "tcp"},
{"ncxcp",              {NULL}, 5681, "udp"},
{"brightcore",         {NULL}, 5682, "udp"},
{"ggz",                {NULL}, 5688, "tcp"},
{"ggz",                {NULL}, 5688, "udp"},
{"qmvideo",            {NULL}, 5689, "tcp"},
{"qmvideo",            {NULL}, 5689, "udp"},
{"proshareaudio",      {NULL}, 5713, "tcp"},
{"proshareaudio",      {NULL}, 5713, "udp"},
{"prosharevideo",      {NULL}, 5714, "tcp"},
{"prosharevideo",      {NULL}, 5714, "udp"},
{"prosharedata",       {NULL}, 5715, "tcp"},
{"prosharedata",       {NULL}, 5715, "udp"},
{"prosharerequest",    {NULL}, 5716, "tcp"},
{"prosharerequest",    {NULL}, 5716, "udp"},
{"prosharenotify",     {NULL}, 5717, "tcp"},
{"prosharenotify",     {NULL}, 5717, "udp"},
{"dpm",                {NULL}, 5718, "tcp"},
{"dpm",                {NULL}, 5718, "udp"},
{"dpm-agent",          {NULL}, 5719, "tcp"},
{"dpm-agent",          {NULL}, 5719, "udp"},
{"ms-licensing",       {NULL}, 5720, "tcp"},
{"ms-licensing",       {NULL}, 5720, "udp"},
{"dtpt",               {NULL}, 5721, "tcp"},
{"dtpt",               {NULL}, 5721, "udp"},
{"msdfsr",             {NULL}, 5722, "tcp"},
{"msdfsr",             {NULL}, 5722, "udp"},
{"omhs",               {NULL}, 5723, "tcp"},
{"omhs",               {NULL}, 5723, "udp"},
{"omsdk",              {NULL}, 5724, "tcp"},
{"omsdk",              {NULL}, 5724, "udp"},
{"ms-ilm",             {NULL}, 5725, "tcp"},
{"ms-ilm-sts",         {NULL}, 5726, "tcp"},
{"asgenf",             {NULL}, 5727, "tcp"},
{"io-dist-data",       {NULL}, 5728, "tcp"},
{"io-dist-group",      {NULL}, 5728, "udp"},
{"openmail",           {NULL}, 5729, "tcp"},
{"openmail",           {NULL}, 5729, "udp"},
{"unieng",             {NULL}, 5730, "tcp"},
{"unieng",             {NULL}, 5730, "udp"},
{"ida-discover1",      {NULL}, 5741, "tcp"},
{"ida-discover1",      {NULL}, 5741, "udp"},
{"ida-discover2",      {NULL}, 5742, "tcp"},
{"ida-discover2",      {NULL}, 5742, "udp"},
{"watchdoc-pod",       {NULL}, 5743, "tcp"},
{"watchdoc-pod",       {NULL}, 5743, "udp"},
{"watchdoc",           {NULL}, 5744, "tcp"},
{"watchdoc",           {NULL}, 5744, "udp"},
{"fcopy-server",       {NULL}, 5745, "tcp"},
{"fcopy-server",       {NULL}, 5745, "udp"},
{"fcopys-server",      {NULL}, 5746, "tcp"},
{"fcopys-server",      {NULL}, 5746, "udp"},
{"tunatic",            {NULL}, 5747, "tcp"},
{"tunatic",            {NULL}, 5747, "udp"},
{"tunalyzer",          {NULL}, 5748, "tcp"},
{"tunalyzer",          {NULL}, 5748, "udp"},
{"rscd",               {NULL}, 5750, "tcp"},
{"rscd",               {NULL}, 5750, "udp"},
{"openmailg",          {NULL}, 5755, "tcp"},
{"openmailg",          {NULL}, 5755, "udp"},
{"x500ms",             {NULL}, 5757, "tcp"},
{"x500ms",             {NULL}, 5757, "udp"},
{"openmailns",         {NULL}, 5766, "tcp"},
{"openmailns",         {NULL}, 5766, "udp"},
{"s-openmail",         {NULL}, 5767, "tcp"},
{"s-openmail",         {NULL}, 5767, "udp"},
{"openmailpxy",        {NULL}, 5768, "tcp"},
{"openmailpxy",        {NULL}, 5768, "udp"},
{"spramsca",           {NULL}, 5769, "tcp"},
{"spramsca",           {NULL}, 5769, "udp"},
{"spramsd",            {NULL}, 5770, "tcp"},
{"spramsd",            {NULL}, 5770, "udp"},
{"netagent",           {NULL}, 5771, "tcp"},
{"netagent",           {NULL}, 5771, "udp"},
{"dali-port",          {NULL}, 5777, "tcp"},
{"dali-port",          {NULL}, 5777, "udp"},
{"vts-rpc",            {NULL}, 5780, "tcp"},
{"3par-evts",          {NULL}, 5781, "tcp"},
{"3par-evts",          {NULL}, 5781, "udp"},
{"3par-mgmt",          {NULL}, 5782, "tcp"},
{"3par-mgmt",          {NULL}, 5782, "udp"},
{"3par-mgmt-ssl",      {NULL}, 5783, "tcp"},
{"3par-mgmt-ssl",      {NULL}, 5783, "udp"},
{"ibar",               {NULL}, 5784, "udp"},
{"3par-rcopy",         {NULL}, 5785, "tcp"},
{"3par-rcopy",         {NULL}, 5785, "udp"},
{"cisco-redu",         {NULL}, 5786, "udp"},
{"waascluster",        {NULL}, 5787, "udp"},
{"xtreamx",            {NULL}, 5793, "tcp"},
{"xtreamx",            {NULL}, 5793, "udp"},
{"spdp",               {NULL}, 5794, "udp"},
{"icmpd",              {NULL}, 5813, "tcp"},
{"icmpd",              {NULL}, 5813, "udp"},
{"spt-automation",     {NULL}, 5814, "tcp"},
{"spt-automation",     {NULL}, 5814, "udp"},
{"wherehoo",           {NULL}, 5859, "tcp"},
{"wherehoo",           {NULL}, 5859, "udp"},
{"ppsuitemsg",         {NULL}, 5863, "tcp"},
{"ppsuitemsg",         {NULL}, 5863, "udp"},
{"rfb",                {NULL}, 5900, "tcp"},
{"rfb",                {NULL}, 5900, "udp"},
{"cm",                 {NULL}, 5910, "tcp"},
{"cm",                 {NULL}, 5910, "udp"},
{"cpdlc",              {NULL}, 5911, "tcp"},
{"cpdlc",              {NULL}, 5911, "udp"},
{"fis",                {NULL}, 5912, "tcp"},
{"fis",                {NULL}, 5912, "udp"},
{"ads-c",              {NULL}, 5913, "tcp"},
{"ads-c",              {NULL}, 5913, "udp"},
{"indy",               {NULL}, 5963, "tcp"},
{"indy",               {NULL}, 5963, "udp"},
{"mppolicy-v5",        {NULL}, 5968, "tcp"},
{"mppolicy-v5",        {NULL}, 5968, "udp"},
{"mppolicy-mgr",       {NULL}, 5969, "tcp"},
{"mppolicy-mgr",       {NULL}, 5969, "udp"},
{"couchdb",            {NULL}, 5984, "tcp"},
{"couchdb",            {NULL}, 5984, "udp"},
{"wsman",              {NULL}, 5985, "tcp"},
{"wsman",              {NULL}, 5985, "udp"},
{"wsmans",             {NULL}, 5986, "tcp"},
{"wsmans",             {NULL}, 5986, "udp"},
{"wbem-rmi",           {NULL}, 5987, "tcp"},
{"wbem-rmi",           {NULL}, 5987, "udp"},
{"wbem-http",          {NULL}, 5988, "tcp"},
{"wbem-http",          {NULL}, 5988, "udp"},
{"wbem-https",         {NULL}, 5989, "tcp"},
{"wbem-https",         {NULL}, 5989, "udp"},
{"wbem-exp-https",     {NULL}, 5990, "tcp"},
{"wbem-exp-https",     {NULL}, 5990, "udp"},
{"nuxsl",              {NULL}, 5991, "tcp"},
{"nuxsl",              {NULL}, 5991, "udp"},
{"consul-insight",     {NULL}, 5992, "tcp"},
{"consul-insight",     {NULL}, 5992, "udp"},
{"cvsup",              {NULL}, 5999, "tcp"},
{"cvsup",              {NULL}, 5999, "udp"},
{"ndl-ahp-svc",        {NULL}, 6064, "tcp"},
{"ndl-ahp-svc",        {NULL}, 6064, "udp"},
{"winpharaoh",         {NULL}, 6065, "tcp"},
{"winpharaoh",         {NULL}, 6065, "udp"},
{"ewctsp",             {NULL}, 6066, "tcp"},
{"ewctsp",             {NULL}, 6066, "udp"},
{"gsmp",               {NULL}, 6068, "tcp"},
{"gsmp",               {NULL}, 6068, "udp"},
{"trip",               {NULL}, 6069, "tcp"},
{"trip",               {NULL}, 6069, "udp"},
{"messageasap",        {NULL}, 6070, "tcp"},
{"messageasap",        {NULL}, 6070, "udp"},
{"ssdtp",              {NULL}, 6071, "tcp"},
{"ssdtp",              {NULL}, 6071, "udp"},
{"diagnose-proc",      {NULL}, 6072, "tcp"},
{"diagnose-proc",      {NULL}, 6072, "udp"},
{"directplay8",        {NULL}, 6073, "tcp"},
{"directplay8",        {NULL}, 6073, "udp"},
{"max",                {NULL}, 6074, "tcp"},
{"max",                {NULL}, 6074, "udp"},
{"dpm-acm",            {NULL}, 6075, "tcp"},
{"miami-bcast",        {NULL}, 6083, "udp"},
{"p2p-sip",            {NULL}, 6084, "tcp"},
{"konspire2b",         {NULL}, 6085, "tcp"},
{"konspire2b",         {NULL}, 6085, "udp"},
{"pdtp",               {NULL}, 6086, "tcp"},
{"pdtp",               {NULL}, 6086, "udp"},
{"ldss",               {NULL}, 6087, "tcp"},
{"ldss",               {NULL}, 6087, "udp"},
{"raxa-mgmt",          {NULL}, 6099, "tcp"},
{"synchronet-db",      {NULL}, 6100, "tcp"},
{"synchronet-db",      {NULL}, 6100, "udp"},
{"synchronet-rtc",     {NULL}, 6101, "tcp"},
{"synchronet-rtc",     {NULL}, 6101, "udp"},
{"synchronet-upd",     {NULL}, 6102, "tcp"},
{"synchronet-upd",     {NULL}, 6102, "udp"},
{"rets",               {NULL}, 6103, "tcp"},
{"rets",               {NULL}, 6103, "udp"},
{"dbdb",               {NULL}, 6104, "tcp"},
{"dbdb",               {NULL}, 6104, "udp"},
{"primaserver",        {NULL}, 6105, "tcp"},
{"primaserver",        {NULL}, 6105, "udp"},
{"mpsserver",          {NULL}, 6106, "tcp"},
{"mpsserver",          {NULL}, 6106, "udp"},
{"etc-control",        {NULL}, 6107, "tcp"},
{"etc-control",        {NULL}, 6107, "udp"},
{"sercomm-scadmin",    {NULL}, 6108, "tcp"},
{"sercomm-scadmin",    {NULL}, 6108, "udp"},
{"globecast-id",       {NULL}, 6109, "tcp"},
{"globecast-id",       {NULL}, 6109, "udp"},
{"softcm",             {NULL}, 6110, "tcp"},
{"softcm",             {NULL}, 6110, "udp"},
{"spc",                {NULL}, 6111, "tcp"},
{"spc",                {NULL}, 6111, "udp"},
{"dtspcd",             {NULL}, 6112, "tcp"},
{"dtspcd",             {NULL}, 6112, "udp"},
{"dayliteserver",      {NULL}, 6113, "tcp"},
{"wrspice",            {NULL}, 6114, "tcp"},
{"xic",                {NULL}, 6115, "tcp"},
{"xtlserv",            {NULL}, 6116, "tcp"},
{"daylitetouch",       {NULL}, 6117, "tcp"},
{"spdy",               {NULL}, 6121, "tcp"},
{"bex-webadmin",       {NULL}, 6122, "tcp"},
{"bex-webadmin",       {NULL}, 6122, "udp"},
{"backup-express",     {NULL}, 6123, "tcp"},
{"backup-express",     {NULL}, 6123, "udp"},
{"pnbs",               {NULL}, 6124, "tcp"},
{"pnbs",               {NULL}, 6124, "udp"},
{"nbt-wol",            {NULL}, 6133, "tcp"},
{"nbt-wol",            {NULL}, 6133, "udp"},
{"pulsonixnls",        {NULL}, 6140, "tcp"},
{"pulsonixnls",        {NULL}, 6140, "udp"},
{"meta-corp",          {NULL}, 6141, "tcp"},
{"meta-corp",          {NULL}, 6141, "udp"},
{"aspentec-lm",        {NULL}, 6142, "tcp"},
{"aspentec-lm",        {NULL}, 6142, "udp"},
{"watershed-lm",       {NULL}, 6143, "tcp"},
{"watershed-lm",       {NULL}, 6143, "udp"},
{"statsci1-lm",        {NULL}, 6144, "tcp"},
{"statsci1-lm",        {NULL}, 6144, "udp"},
{"statsci2-lm",        {NULL}, 6145, "tcp"},
{"statsci2-lm",        {NULL}, 6145, "udp"},
{"lonewolf-lm",        {NULL}, 6146, "tcp"},
{"lonewolf-lm",        {NULL}, 6146, "udp"},
{"montage-lm",         {NULL}, 6147, "tcp"},
{"montage-lm",         {NULL}, 6147, "udp"},
{"ricardo-lm",         {NULL}, 6148, "tcp"},
{"ricardo-lm",         {NULL}, 6148, "udp"},
{"tal-pod",            {NULL}, 6149, "tcp"},
{"tal-pod",            {NULL}, 6149, "udp"},
{"efb-aci",            {NULL}, 6159, "tcp"},
{"patrol-ism",         {NULL}, 6161, "tcp"},
{"patrol-ism",         {NULL}, 6161, "udp"},
{"patrol-coll",        {NULL}, 6162, "tcp"},
{"patrol-coll",        {NULL}, 6162, "udp"},
{"pscribe",            {NULL}, 6163, "tcp"},
{"pscribe",            {NULL}, 6163, "udp"},
{"lm-x",               {NULL}, 6200, "tcp"},
{"lm-x",               {NULL}, 6200, "udp"},
{"radmind",            {NULL}, 6222, "tcp"},
{"radmind",            {NULL}, 6222, "udp"},
{"jeol-nsdtp-1",       {NULL}, 6241, "tcp"},
{"jeol-nsddp-1",       {NULL}, 6241, "udp"},
{"jeol-nsdtp-2",       {NULL}, 6242, "tcp"},
{"jeol-nsddp-2",       {NULL}, 6242, "udp"},
{"jeol-nsdtp-3",       {NULL}, 6243, "tcp"},
{"jeol-nsddp-3",       {NULL}, 6243, "udp"},
{"jeol-nsdtp-4",       {NULL}, 6244, "tcp"},
{"jeol-nsddp-4",       {NULL}, 6244, "udp"},
{"tl1-raw-ssl",        {NULL}, 6251, "tcp"},
{"tl1-raw-ssl",        {NULL}, 6251, "udp"},
{"tl1-ssh",            {NULL}, 6252, "tcp"},
{"tl1-ssh",            {NULL}, 6252, "udp"},
{"crip",               {NULL}, 6253, "tcp"},
{"crip",               {NULL}, 6253, "udp"},
{"gld",                {NULL}, 6267, "tcp"},
{"grid",               {NULL}, 6268, "tcp"},
{"grid",               {NULL}, 6268, "udp"},
{"grid-alt",           {NULL}, 6269, "tcp"},
{"grid-alt",           {NULL}, 6269, "udp"},
{"bmc-grx",            {NULL}, 6300, "tcp"},
{"bmc-grx",            {NULL}, 6300, "udp"},
{"bmc_ctd_ldap",       {NULL}, 6301, "tcp"},
{"bmc_ctd_ldap",       {NULL}, 6301, "udp"},
{"ufmp",               {NULL}, 6306, "tcp"},
{"ufmp",               {NULL}, 6306, "udp"},
{"scup",               {NULL}, 6315, "tcp"},
{"scup-disc",          {NULL}, 6315, "udp"},
{"abb-escp",           {NULL}, 6316, "tcp"},
{"abb-escp",           {NULL}, 6316, "udp"},
{"repsvc",             {NULL}, 6320, "tcp"},
{"repsvc",             {NULL}, 6320, "udp"},
{"emp-server1",        {NULL}, 6321, "tcp"},
{"emp-server1",        {NULL}, 6321, "udp"},
{"emp-server2",        {NULL}, 6322, "tcp"},
{"emp-server2",        {NULL}, 6322, "udp"},
{"sflow",              {NULL}, 6343, "tcp"},
{"sflow",              {NULL}, 6343, "udp"},
{"gnutella-svc",       {NULL}, 6346, "tcp"},
{"gnutella-svc",       {NULL}, 6346, "udp"},
{"gnutella-rtr",       {NULL}, 6347, "tcp"},
{"gnutella-rtr",       {NULL}, 6347, "udp"},
{"adap",               {NULL}, 6350, "tcp"},
{"adap",               {NULL}, 6350, "udp"},
{"pmcs",               {NULL}, 6355, "tcp"},
{"pmcs",               {NULL}, 6355, "udp"},
{"metaedit-mu",        {NULL}, 6360, "tcp"},
{"metaedit-mu",        {NULL}, 6360, "udp"},
{"metaedit-se",        {NULL}, 6370, "tcp"},
{"metaedit-se",        {NULL}, 6370, "udp"},
{"metatude-mds",       {NULL}, 6382, "tcp"},
{"metatude-mds",       {NULL}, 6382, "udp"},
{"clariion-evr01",     {NULL}, 6389, "tcp"},
{"clariion-evr01",     {NULL}, 6389, "udp"},
{"metaedit-ws",        {NULL}, 6390, "tcp"},
{"metaedit-ws",        {NULL}, 6390, "udp"},
{"faxcomservice",      {NULL}, 6417, "tcp"},
{"faxcomservice",      {NULL}, 6417, "udp"},
{"syserverremote",     {NULL}, 6418, "tcp"},
{"svdrp",              {NULL}, 6419, "tcp"},
{"nim-vdrshell",       {NULL}, 6420, "tcp"},
{"nim-vdrshell",       {NULL}, 6420, "udp"},
{"nim-wan",            {NULL}, 6421, "tcp"},
{"nim-wan",            {NULL}, 6421, "udp"},
{"pgbouncer",          {NULL}, 6432, "tcp"},
{"sun-sr-https",       {NULL}, 6443, "tcp"},
{"sun-sr-https",       {NULL}, 6443, "udp"},
{"sge_qmaster",        {NULL}, 6444, "tcp"},
{"sge_qmaster",        {NULL}, 6444, "udp"},
{"sge_execd",          {NULL}, 6445, "tcp"},
{"sge_execd",          {NULL}, 6445, "udp"},
{"mysql-proxy",        {NULL}, 6446, "tcp"},
{"mysql-proxy",        {NULL}, 6446, "udp"},
{"skip-cert-recv",     {NULL}, 6455, "tcp"},
{"skip-cert-send",     {NULL}, 6456, "udp"},
{"lvision-lm",         {NULL}, 6471, "tcp"},
{"lvision-lm",         {NULL}, 6471, "udp"},
{"sun-sr-http",        {NULL}, 6480, "tcp"},
{"sun-sr-http",        {NULL}, 6480, "udp"},
{"servicetags",        {NULL}, 6481, "tcp"},
{"servicetags",        {NULL}, 6481, "udp"},
{"ldoms-mgmt",         {NULL}, 6482, "tcp"},
{"ldoms-mgmt",         {NULL}, 6482, "udp"},
{"SunVTS-RMI",         {NULL}, 6483, "tcp"},
{"SunVTS-RMI",         {NULL}, 6483, "udp"},
{"sun-sr-jms",         {NULL}, 6484, "tcp"},
{"sun-sr-jms",         {NULL}, 6484, "udp"},
{"sun-sr-iiop",        {NULL}, 6485, "tcp"},
{"sun-sr-iiop",        {NULL}, 6485, "udp"},
{"sun-sr-iiops",       {NULL}, 6486, "tcp"},
{"sun-sr-iiops",       {NULL}, 6486, "udp"},
{"sun-sr-iiop-aut",    {NULL}, 6487, "tcp"},
{"sun-sr-iiop-aut",    {NULL}, 6487, "udp"},
{"sun-sr-jmx",         {NULL}, 6488, "tcp"},
{"sun-sr-jmx",         {NULL}, 6488, "udp"},
{"sun-sr-admin",       {NULL}, 6489, "tcp"},
{"sun-sr-admin",       {NULL}, 6489, "udp"},
{"boks",               {NULL}, 6500, "tcp"},
{"boks",               {NULL}, 6500, "udp"},
{"boks_servc",         {NULL}, 6501, "tcp"},
{"boks_servc",         {NULL}, 6501, "udp"},
{"boks_servm",         {NULL}, 6502, "tcp"},
{"boks_servm",         {NULL}, 6502, "udp"},
{"boks_clntd",         {NULL}, 6503, "tcp"},
{"boks_clntd",         {NULL}, 6503, "udp"},
{"badm_priv",          {NULL}, 6505, "tcp"},
{"badm_priv",          {NULL}, 6505, "udp"},
{"badm_pub",           {NULL}, 6506, "tcp"},
{"badm_pub",           {NULL}, 6506, "udp"},
{"bdir_priv",          {NULL}, 6507, "tcp"},
{"bdir_priv",          {NULL}, 6507, "udp"},
{"bdir_pub",           {NULL}, 6508, "tcp"},
{"bdir_pub",           {NULL}, 6508, "udp"},
{"mgcs-mfp-port",      {NULL}, 6509, "tcp"},
{"mgcs-mfp-port",      {NULL}, 6509, "udp"},
{"mcer-port",          {NULL}, 6510, "tcp"},
{"mcer-port",          {NULL}, 6510, "udp"},
{"netconf-tls",        {NULL}, 6513, "tcp"},
{"syslog-tls",         {NULL}, 6514, "tcp"},
{"syslog-tls",         {NULL}, 6514, "udp"},
{"syslog-tls",         {NULL}, 6514, "dccp"},
{"elipse-rec",         {NULL}, 6515, "tcp"},
{"elipse-rec",         {NULL}, 6515, "udp"},
{"lds-distrib",        {NULL}, 6543, "tcp"},
{"lds-distrib",        {NULL}, 6543, "udp"},
{"lds-dump",           {NULL}, 6544, "tcp"},
{"lds-dump",           {NULL}, 6544, "udp"},
{"apc-6547",           {NULL}, 6547, "tcp"},
{"apc-6547",           {NULL}, 6547, "udp"},
{"apc-6548",           {NULL}, 6548, "tcp"},
{"apc-6548",           {NULL}, 6548, "udp"},
{"apc-6549",           {NULL}, 6549, "tcp"},
{"apc-6549",           {NULL}, 6549, "udp"},
{"fg-sysupdate",       {NULL}, 6550, "tcp"},
{"fg-sysupdate",       {NULL}, 6550, "udp"},
{"sum",                {NULL}, 6551, "tcp"},
{"sum",                {NULL}, 6551, "udp"},
{"xdsxdm",             {NULL}, 6558, "tcp"},
{"xdsxdm",             {NULL}, 6558, "udp"},
{"sane-port",          {NULL}, 6566, "tcp"},
{"sane-port",          {NULL}, 6566, "udp"},
{"esp",                {NULL}, 6567, "tcp"},
{"esp",                {NULL}, 6567, "udp"},
{"canit_store",        {NULL}, 6568, "tcp"},
{"rp-reputation",      {NULL}, 6568, "udp"},
{"affiliate",          {NULL}, 6579, "tcp"},
{"affiliate",          {NULL}, 6579, "udp"},
{"parsec-master",      {NULL}, 6580, "tcp"},
{"parsec-master",      {NULL}, 6580, "udp"},
{"parsec-peer",        {NULL}, 6581, "tcp"},
{"parsec-peer",        {NULL}, 6581, "udp"},
{"parsec-game",        {NULL}, 6582, "tcp"},
{"parsec-game",        {NULL}, 6582, "udp"},
{"joaJewelSuite",      {NULL}, 6583, "tcp"},
{"joaJewelSuite",      {NULL}, 6583, "udp"},
{"mshvlm",             {NULL}, 6600, "tcp"},
{"mstmg-sstp",         {NULL}, 6601, "tcp"},
{"wsscomfrmwk",        {NULL}, 6602, "tcp"},
{"odette-ftps",        {NULL}, 6619, "tcp"},
{"odette-ftps",        {NULL}, 6619, "udp"},
{"kftp-data",          {NULL}, 6620, "tcp"},
{"kftp-data",          {NULL}, 6620, "udp"},
{"kftp",               {NULL}, 6621, "tcp"},
{"kftp",               {NULL}, 6621, "udp"},
{"mcftp",              {NULL}, 6622, "tcp"},
{"mcftp",              {NULL}, 6622, "udp"},
{"ktelnet",            {NULL}, 6623, "tcp"},
{"ktelnet",            {NULL}, 6623, "udp"},
{"datascaler-db",      {NULL}, 6624, "tcp"},
{"datascaler-ctl",     {NULL}, 6625, "tcp"},
{"wago-service",       {NULL}, 6626, "tcp"},
{"wago-service",       {NULL}, 6626, "udp"},
{"nexgen",             {NULL}, 6627, "tcp"},
{"nexgen",             {NULL}, 6627, "udp"},
{"afesc-mc",           {NULL}, 6628, "tcp"},
{"afesc-mc",           {NULL}, 6628, "udp"},
{"mxodbc-connect",     {NULL}, 6632, "tcp"},
{"pcs-sf-ui-man",      {NULL}, 6655, "tcp"},
{"emgmsg",             {NULL}, 6656, "tcp"},
{"palcom-disc",        {NULL}, 6657, "udp"},
{"vocaltec-gold",      {NULL}, 6670, "tcp"},
{"vocaltec-gold",      {NULL}, 6670, "udp"},
{"p4p-portal",         {NULL}, 6671, "tcp"},
{"p4p-portal",         {NULL}, 6671, "udp"},
{"vision_server",      {NULL}, 6672, "tcp"},
{"vision_server",      {NULL}, 6672, "udp"},
{"vision_elmd",        {NULL}, 6673, "tcp"},
{"vision_elmd",        {NULL}, 6673, "udp"},
{"vfbp",               {NULL}, 6678, "tcp"},
{"vfbp-disc",          {NULL}, 6678, "udp"},
{"osaut",              {NULL}, 6679, "tcp"},
{"osaut",              {NULL}, 6679, "udp"},
{"clever-ctrace",      {NULL}, 6687, "tcp"},
{"clever-tcpip",       {NULL}, 6688, "tcp"},
{"tsa",                {NULL}, 6689, "tcp"},
{"tsa",                {NULL}, 6689, "udp"},
{"babel",              {NULL}, 6697, "udp"},
{"kti-icad-srvr",      {NULL}, 6701, "tcp"},
{"kti-icad-srvr",      {NULL}, 6701, "udp"},
{"e-design-net",       {NULL}, 6702, "tcp"},
{"e-design-net",       {NULL}, 6702, "udp"},
{"e-design-web",       {NULL}, 6703, "tcp"},
{"e-design-web",       {NULL}, 6703, "udp"},
{"frc-hp",             {NULL}, 6704, "sctp"},
{"frc-mp",             {NULL}, 6705, "sctp"},
{"frc-lp",             {NULL}, 6706, "sctp"},
{"ibprotocol",         {NULL}, 6714, "tcp"},
{"ibprotocol",         {NULL}, 6714, "udp"},
{"fibotrader-com",     {NULL}, 6715, "tcp"},
{"fibotrader-com",     {NULL}, 6715, "udp"},
{"bmc-perf-agent",     {NULL}, 6767, "tcp"},
{"bmc-perf-agent",     {NULL}, 6767, "udp"},
{"bmc-perf-mgrd",      {NULL}, 6768, "tcp"},
{"bmc-perf-mgrd",      {NULL}, 6768, "udp"},
{"adi-gxp-srvprt",     {NULL}, 6769, "tcp"},
{"adi-gxp-srvprt",     {NULL}, 6769, "udp"},
{"plysrv-http",        {NULL}, 6770, "tcp"},
{"plysrv-http",        {NULL}, 6770, "udp"},
{"plysrv-https",       {NULL}, 6771, "tcp"},
{"plysrv-https",       {NULL}, 6771, "udp"},
{"dgpf-exchg",         {NULL}, 6785, "tcp"},
{"dgpf-exchg",         {NULL}, 6785, "udp"},
{"smc-jmx",            {NULL}, 6786, "tcp"},
{"smc-jmx",            {NULL}, 6786, "udp"},
{"smc-admin",          {NULL}, 6787, "tcp"},
{"smc-admin",          {NULL}, 6787, "udp"},
{"smc-http",           {NULL}, 6788, "tcp"},
{"smc-http",           {NULL}, 6788, "udp"},
{"smc-https",          {NULL}, 6789, "tcp"},
{"smc-https",          {NULL}, 6789, "udp"},
{"hnmp",               {NULL}, 6790, "tcp"},
{"hnmp",               {NULL}, 6790, "udp"},
{"hnm",                {NULL}, 6791, "tcp"},
{"hnm",                {NULL}, 6791, "udp"},
{"acnet",              {NULL}, 6801, "tcp"},
{"acnet",              {NULL}, 6801, "udp"},
{"pentbox-sim",        {NULL}, 6817, "tcp"},
{"ambit-lm",           {NULL}, 6831, "tcp"},
{"ambit-lm",           {NULL}, 6831, "udp"},
{"netmo-default",      {NULL}, 6841, "tcp"},
{"netmo-default",      {NULL}, 6841, "udp"},
{"netmo-http",         {NULL}, 6842, "tcp"},
{"netmo-http",         {NULL}, 6842, "udp"},
{"iccrushmore",        {NULL}, 6850, "tcp"},
{"iccrushmore",        {NULL}, 6850, "udp"},
{"acctopus-cc",        {NULL}, 6868, "tcp"},
{"acctopus-st",        {NULL}, 6868, "udp"},
{"muse",               {NULL}, 6888, "tcp"},
{"muse",               {NULL}, 6888, "udp"},
{"jetstream",          {NULL}, 6901, "tcp"},
{"xsmsvc",             {NULL}, 6936, "tcp"},
{"xsmsvc",             {NULL}, 6936, "udp"},
{"bioserver",          {NULL}, 6946, "tcp"},
{"bioserver",          {NULL}, 6946, "udp"},
{"otlp",               {NULL}, 6951, "tcp"},
{"otlp",               {NULL}, 6951, "udp"},
{"jmact3",             {NULL}, 6961, "tcp"},
{"jmact3",             {NULL}, 6961, "udp"},
{"jmevt2",             {NULL}, 6962, "tcp"},
{"jmevt2",             {NULL}, 6962, "udp"},
{"swismgr1",           {NULL}, 6963, "tcp"},
{"swismgr1",           {NULL}, 6963, "udp"},
{"swismgr2",           {NULL}, 6964, "tcp"},
{"swismgr2",           {NULL}, 6964, "udp"},
{"swistrap",           {NULL}, 6965, "tcp"},
{"swistrap",           {NULL}, 6965, "udp"},
{"swispol",            {NULL}, 6966, "tcp"},
{"swispol",            {NULL}, 6966, "udp"},
{"acmsoda",            {NULL}, 6969, "tcp"},
{"acmsoda",            {NULL}, 6969, "udp"},
{"MobilitySrv",        {NULL}, 6997, "tcp"},
{"MobilitySrv",        {NULL}, 6997, "udp"},
{"iatp-highpri",       {NULL}, 6998, "tcp"},
{"iatp-highpri",       {NULL}, 6998, "udp"},
{"iatp-normalpri",     {NULL}, 6999, "tcp"},
{"iatp-normalpri",     {NULL}, 6999, "udp"},
{"afs3-fileserver",    {NULL}, 7000, "tcp"},
{"afs3-fileserver",    {NULL}, 7000, "udp"},
{"afs3-callback",      {NULL}, 7001, "tcp"},
{"afs3-callback",      {NULL}, 7001, "udp"},
{"afs3-prserver",      {NULL}, 7002, "tcp"},
{"afs3-prserver",      {NULL}, 7002, "udp"},
{"afs3-vlserver",      {NULL}, 7003, "tcp"},
{"afs3-vlserver",      {NULL}, 7003, "udp"},
{"afs3-kaserver",      {NULL}, 7004, "tcp"},
{"afs3-kaserver",      {NULL}, 7004, "udp"},
{"afs3-volser",        {NULL}, 7005, "tcp"},
{"afs3-volser",        {NULL}, 7005, "udp"},
{"afs3-errors",        {NULL}, 7006, "tcp"},
{"afs3-errors",        {NULL}, 7006, "udp"},
{"afs3-bos",           {NULL}, 7007, "tcp"},
{"afs3-bos",           {NULL}, 7007, "udp"},
{"afs3-update",        {NULL}, 7008, "tcp"},
{"afs3-update",        {NULL}, 7008, "udp"},
{"afs3-rmtsys",        {NULL}, 7009, "tcp"},
{"afs3-rmtsys",        {NULL}, 7009, "udp"},
{"ups-onlinet",        {NULL}, 7010, "tcp"},
{"ups-onlinet",        {NULL}, 7010, "udp"},
{"talon-disc",         {NULL}, 7011, "tcp"},
{"talon-disc",         {NULL}, 7011, "udp"},
{"talon-engine",       {NULL}, 7012, "tcp"},
{"talon-engine",       {NULL}, 7012, "udp"},
{"microtalon-dis",     {NULL}, 7013, "tcp"},
{"microtalon-dis",     {NULL}, 7013, "udp"},
{"microtalon-com",     {NULL}, 7014, "tcp"},
{"microtalon-com",     {NULL}, 7014, "udp"},
{"talon-webserver",    {NULL}, 7015, "tcp"},
{"talon-webserver",    {NULL}, 7015, "udp"},
{"dpserve",            {NULL}, 7020, "tcp"},
{"dpserve",            {NULL}, 7020, "udp"},
{"dpserveadmin",       {NULL}, 7021, "tcp"},
{"dpserveadmin",       {NULL}, 7021, "udp"},
{"ctdp",               {NULL}, 7022, "tcp"},
{"ctdp",               {NULL}, 7022, "udp"},
{"ct2nmcs",            {NULL}, 7023, "tcp"},
{"ct2nmcs",            {NULL}, 7023, "udp"},
{"vmsvc",              {NULL}, 7024, "tcp"},
{"vmsvc",              {NULL}, 7024, "udp"},
{"vmsvc-2",            {NULL}, 7025, "tcp"},
{"vmsvc-2",            {NULL}, 7025, "udp"},
{"op-probe",           {NULL}, 7030, "tcp"},
{"op-probe",           {NULL}, 7030, "udp"},
{"arcp",               {NULL}, 7070, "tcp"},
{"arcp",               {NULL}, 7070, "udp"},
{"iwg1",               {NULL}, 7071, "tcp"},
{"iwg1",               {NULL}, 7071, "udp"},
{"empowerid",          {NULL}, 7080, "tcp"},
{"empowerid",          {NULL}, 7080, "udp"},
{"lazy-ptop",          {NULL}, 7099, "tcp"},
{"lazy-ptop",          {NULL}, 7099, "udp"},
{"font-service",       {NULL}, 7100, "tcp"},
{"font-service",       {NULL}, 7100, "udp"},
{"elcn",               {NULL}, 7101, "tcp"},
{"elcn",               {NULL}, 7101, "udp"},
{"aes-x170",           {NULL}, 7107, "udp"},
{"virprot-lm",         {NULL}, 7121, "tcp"},
{"virprot-lm",         {NULL}, 7121, "udp"},
{"scenidm",            {NULL}, 7128, "tcp"},
{"scenidm",            {NULL}, 7128, "udp"},
{"scenccs",            {NULL}, 7129, "tcp"},
{"scenccs",            {NULL}, 7129, "udp"},
{"cabsm-comm",         {NULL}, 7161, "tcp"},
{"cabsm-comm",         {NULL}, 7161, "udp"},
{"caistoragemgr",      {NULL}, 7162, "tcp"},
{"caistoragemgr",      {NULL}, 7162, "udp"},
{"cacsambroker",       {NULL}, 7163, "tcp"},
{"cacsambroker",       {NULL}, 7163, "udp"},
{"fsr",                {NULL}, 7164, "tcp"},
{"fsr",                {NULL}, 7164, "udp"},
{"doc-server",         {NULL}, 7165, "tcp"},
{"doc-server",         {NULL}, 7165, "udp"},
{"aruba-server",       {NULL}, 7166, "tcp"},
{"aruba-server",       {NULL}, 7166, "udp"},
{"casrmagent",         {NULL}, 7167, "tcp"},
{"cnckadserver",       {NULL}, 7168, "tcp"},
{"ccag-pib",           {NULL}, 7169, "tcp"},
{"ccag-pib",           {NULL}, 7169, "udp"},
{"nsrp",               {NULL}, 7170, "tcp"},
{"nsrp",               {NULL}, 7170, "udp"},
{"drm-production",     {NULL}, 7171, "tcp"},
{"drm-production",     {NULL}, 7171, "udp"},
{"zsecure",            {NULL}, 7173, "tcp"},
{"clutild",            {NULL}, 7174, "tcp"},
{"clutild",            {NULL}, 7174, "udp"},
{"fodms",              {NULL}, 7200, "tcp"},
{"fodms",              {NULL}, 7200, "udp"},
{"dlip",               {NULL}, 7201, "tcp"},
{"dlip",               {NULL}, 7201, "udp"},
{"ramp",               {NULL}, 7227, "tcp"},
{"ramp",               {NULL}, 7227, "udp"},
{"citrixupp",          {NULL}, 7228, "tcp"},
{"citrixuppg",         {NULL}, 7229, "tcp"},
{"pads",               {NULL}, 7237, "tcp"},
{"cnap",               {NULL}, 7262, "tcp"},
{"cnap",               {NULL}, 7262, "udp"},
{"watchme-7272",       {NULL}, 7272, "tcp"},
{"watchme-7272",       {NULL}, 7272, "udp"},
{"oma-rlp",            {NULL}, 7273, "tcp"},
{"oma-rlp",            {NULL}, 7273, "udp"},
{"oma-rlp-s",          {NULL}, 7274, "tcp"},
{"oma-rlp-s",          {NULL}, 7274, "udp"},
{"oma-ulp",            {NULL}, 7275, "tcp"},
{"oma-ulp",            {NULL}, 7275, "udp"},
{"oma-ilp",            {NULL}, 7276, "tcp"},
{"oma-ilp",            {NULL}, 7276, "udp"},
{"oma-ilp-s",          {NULL}, 7277, "tcp"},
{"oma-ilp-s",          {NULL}, 7277, "udp"},
{"oma-dcdocbs",        {NULL}, 7278, "tcp"},
{"oma-dcdocbs",        {NULL}, 7278, "udp"},
{"ctxlic",             {NULL}, 7279, "tcp"},
{"ctxlic",             {NULL}, 7279, "udp"},
{"itactionserver1",    {NULL}, 7280, "tcp"},
{"itactionserver1",    {NULL}, 7280, "udp"},
{"itactionserver2",    {NULL}, 7281, "tcp"},
{"itactionserver2",    {NULL}, 7281, "udp"},
{"mzca-action",        {NULL}, 7282, "tcp"},
{"mzca-alert",         {NULL}, 7282, "udp"},
{"lcm-server",         {NULL}, 7365, "tcp"},
{"lcm-server",         {NULL}, 7365, "udp"},
{"mindfilesys",        {NULL}, 7391, "tcp"},
{"mindfilesys",        {NULL}, 7391, "udp"},
{"mrssrendezvous",     {NULL}, 7392, "tcp"},
{"mrssrendezvous",     {NULL}, 7392, "udp"},
{"nfoldman",           {NULL}, 7393, "tcp"},
{"nfoldman",           {NULL}, 7393, "udp"},
{"fse",                {NULL}, 7394, "tcp"},
{"fse",                {NULL}, 7394, "udp"},
{"winqedit",           {NULL}, 7395, "tcp"},
{"winqedit",           {NULL}, 7395, "udp"},
{"hexarc",             {NULL}, 7397, "tcp"},
{"hexarc",             {NULL}, 7397, "udp"},
{"rtps-discovery",     {NULL}, 7400, "tcp"},
{"rtps-discovery",     {NULL}, 7400, "udp"},
{"rtps-dd-ut",         {NULL}, 7401, "tcp"},
{"rtps-dd-ut",         {NULL}, 7401, "udp"},
{"rtps-dd-mt",         {NULL}, 7402, "tcp"},
{"rtps-dd-mt",         {NULL}, 7402, "udp"},
{"ionixnetmon",        {NULL}, 7410, "tcp"},
{"ionixnetmon",        {NULL}, 7410, "udp"},
{"mtportmon",          {NULL}, 7421, "tcp"},
{"mtportmon",          {NULL}, 7421, "udp"},
{"pmdmgr",             {NULL}, 7426, "tcp"},
{"pmdmgr",             {NULL}, 7426, "udp"},
{"oveadmgr",           {NULL}, 7427, "tcp"},
{"oveadmgr",           {NULL}, 7427, "udp"},
{"ovladmgr",           {NULL}, 7428, "tcp"},
{"ovladmgr",           {NULL}, 7428, "udp"},
{"opi-sock",           {NULL}, 7429, "tcp"},
{"opi-sock",           {NULL}, 7429, "udp"},
{"xmpv7",              {NULL}, 7430, "tcp"},
{"xmpv7",              {NULL}, 7430, "udp"},
{"pmd",                {NULL}, 7431, "tcp"},
{"pmd",                {NULL}, 7431, "udp"},
{"faximum",            {NULL}, 7437, "tcp"},
{"faximum",            {NULL}, 7437, "udp"},
{"oracleas-https",     {NULL}, 7443, "tcp"},
{"oracleas-https",     {NULL}, 7443, "udp"},
{"rise",               {NULL}, 7473, "tcp"},
{"rise",               {NULL}, 7473, "udp"},
{"telops-lmd",         {NULL}, 7491, "tcp"},
{"telops-lmd",         {NULL}, 7491, "udp"},
{"silhouette",         {NULL}, 7500, "tcp"},
{"silhouette",         {NULL}, 7500, "udp"},
{"ovbus",              {NULL}, 7501, "tcp"},
{"ovbus",              {NULL}, 7501, "udp"},
{"acplt",              {NULL}, 7509, "tcp"},
{"ovhpas",             {NULL}, 7510, "tcp"},
{"ovhpas",             {NULL}, 7510, "udp"},
{"pafec-lm",           {NULL}, 7511, "tcp"},
{"pafec-lm",           {NULL}, 7511, "udp"},
{"saratoga",           {NULL}, 7542, "tcp"},
{"saratoga",           {NULL}, 7542, "udp"},
{"atul",               {NULL}, 7543, "tcp"},
{"atul",               {NULL}, 7543, "udp"},
{"nta-ds",             {NULL}, 7544, "tcp"},
{"nta-ds",             {NULL}, 7544, "udp"},
{"nta-us",             {NULL}, 7545, "tcp"},
{"nta-us",             {NULL}, 7545, "udp"},
{"cfs",                {NULL}, 7546, "tcp"},
{"cfs",                {NULL}, 7546, "udp"},
{"cwmp",               {NULL}, 7547, "tcp"},
{"cwmp",               {NULL}, 7547, "udp"},
{"tidp",               {NULL}, 7548, "tcp"},
{"tidp",               {NULL}, 7548, "udp"},
{"nls-tl",             {NULL}, 7549, "tcp"},
{"nls-tl",             {NULL}, 7549, "udp"},
{"sncp",               {NULL}, 7560, "tcp"},
{"sncp",               {NULL}, 7560, "udp"},
{"cfw",                {NULL}, 7563, "tcp"},
{"vsi-omega",          {NULL}, 7566, "tcp"},
{"vsi-omega",          {NULL}, 7566, "udp"},
{"dell-eql-asm",       {NULL}, 7569, "tcp"},
{"aries-kfinder",      {NULL}, 7570, "tcp"},
{"aries-kfinder",      {NULL}, 7570, "udp"},
{"sun-lm",             {NULL}, 7588, "tcp"},
{"sun-lm",             {NULL}, 7588, "udp"},
{"indi",               {NULL}, 7624, "tcp"},
{"indi",               {NULL}, 7624, "udp"},
{"simco",              {NULL}, 7626, "tcp"},
{"simco",              {NULL}, 7626, "sctp"},
{"soap-http",          {NULL}, 7627, "tcp"},
{"soap-http",          {NULL}, 7627, "udp"},
{"zen-pawn",           {NULL}, 7628, "tcp"},
{"zen-pawn",           {NULL}, 7628, "udp"},
{"xdas",               {NULL}, 7629, "tcp"},
{"xdas",               {NULL}, 7629, "udp"},
{"hawk",               {NULL}, 7630, "tcp"},
{"tesla-sys-msg",      {NULL}, 7631, "tcp"},
{"pmdfmgt",            {NULL}, 7633, "tcp"},
{"pmdfmgt",            {NULL}, 7633, "udp"},
{"cuseeme",            {NULL}, 7648, "tcp"},
{"cuseeme",            {NULL}, 7648, "udp"},
{"imqstomp",           {NULL}, 7672, "tcp"},
{"imqstomps",          {NULL}, 7673, "tcp"},
{"imqtunnels",         {NULL}, 7674, "tcp"},
{"imqtunnels",         {NULL}, 7674, "udp"},
{"imqtunnel",          {NULL}, 7675, "tcp"},
{"imqtunnel",          {NULL}, 7675, "udp"},
{"imqbrokerd",         {NULL}, 7676, "tcp"},
{"imqbrokerd",         {NULL}, 7676, "udp"},
{"sun-user-https",     {NULL}, 7677, "tcp"},
{"sun-user-https",     {NULL}, 7677, "udp"},
{"pando-pub",          {NULL}, 7680, "tcp"},
{"pando-pub",          {NULL}, 7680, "udp"},
{"collaber",           {NULL}, 7689, "tcp"},
{"collaber",           {NULL}, 7689, "udp"},
{"klio",               {NULL}, 7697, "tcp"},
{"klio",               {NULL}, 7697, "udp"},
{"em7-secom",          {NULL}, 7700, "tcp"},
{"sync-em7",           {NULL}, 7707, "tcp"},
{"sync-em7",           {NULL}, 7707, "udp"},
{"scinet",             {NULL}, 7708, "tcp"},
{"scinet",             {NULL}, 7708, "udp"},
{"medimageportal",     {NULL}, 7720, "tcp"},
{"medimageportal",     {NULL}, 7720, "udp"},
{"nsdeepfreezectl",    {NULL}, 7724, "tcp"},
{"nsdeepfreezectl",    {NULL}, 7724, "udp"},
{"nitrogen",           {NULL}, 7725, "tcp"},
{"nitrogen",           {NULL}, 7725, "udp"},
{"freezexservice",     {NULL}, 7726, "tcp"},
{"freezexservice",     {NULL}, 7726, "udp"},
{"trident-data",       {NULL}, 7727, "tcp"},
{"trident-data",       {NULL}, 7727, "udp"},
{"smip",               {NULL}, 7734, "tcp"},
{"smip",               {NULL}, 7734, "udp"},
{"aiagent",            {NULL}, 7738, "tcp"},
{"aiagent",            {NULL}, 7738, "udp"},
{"scriptview",         {NULL}, 7741, "tcp"},
{"scriptview",         {NULL}, 7741, "udp"},
{"msss",               {NULL}, 7742, "tcp"},
{"sstp-1",             {NULL}, 7743, "tcp"},
{"sstp-1",             {NULL}, 7743, "udp"},
{"raqmon-pdu",         {NULL}, 7744, "tcp"},
{"raqmon-pdu",         {NULL}, 7744, "udp"},
{"prgp",               {NULL}, 7747, "tcp"},
{"prgp",               {NULL}, 7747, "udp"},
{"cbt",                {NULL}, 7777, "tcp"},
{"cbt",                {NULL}, 7777, "udp"},
{"interwise",          {NULL}, 7778, "tcp"},
{"interwise",          {NULL}, 7778, "udp"},
{"vstat",              {NULL}, 7779, "tcp"},
{"vstat",              {NULL}, 7779, "udp"},
{"accu-lmgr",          {NULL}, 7781, "tcp"},
{"accu-lmgr",          {NULL}, 7781, "udp"},
{"minivend",           {NULL}, 7786, "tcp"},
{"minivend",           {NULL}, 7786, "udp"},
{"popup-reminders",    {NULL}, 7787, "tcp"},
{"popup-reminders",    {NULL}, 7787, "udp"},
{"office-tools",       {NULL}, 7789, "tcp"},
{"office-tools",       {NULL}, 7789, "udp"},
{"q3ade",              {NULL}, 7794, "tcp"},
{"q3ade",              {NULL}, 7794, "udp"},
{"pnet-conn",          {NULL}, 7797, "tcp"},
{"pnet-conn",          {NULL}, 7797, "udp"},
{"pnet-enc",           {NULL}, 7798, "tcp"},
{"pnet-enc",           {NULL}, 7798, "udp"},
{"altbsdp",            {NULL}, 7799, "tcp"},
{"altbsdp",            {NULL}, 7799, "udp"},
{"asr",                {NULL}, 7800, "tcp"},
{"asr",                {NULL}, 7800, "udp"},
{"ssp-client",         {NULL}, 7801, "tcp"},
{"ssp-client",         {NULL}, 7801, "udp"},
{"rbt-wanopt",         {NULL}, 7810, "tcp"},
{"rbt-wanopt",         {NULL}, 7810, "udp"},
{"apc-7845",           {NULL}, 7845, "tcp"},
{"apc-7845",           {NULL}, 7845, "udp"},
{"apc-7846",           {NULL}, 7846, "tcp"},
{"apc-7846",           {NULL}, 7846, "udp"},
{"mobileanalyzer",     {NULL}, 7869, "tcp"},
{"rbt-smc",            {NULL}, 7870, "tcp"},
{"pss",                {NULL}, 7880, "tcp"},
{"pss",                {NULL}, 7880, "udp"},
{"ubroker",            {NULL}, 7887, "tcp"},
{"ubroker",            {NULL}, 7887, "udp"},
{"mevent",             {NULL}, 7900, "tcp"},
{"mevent",             {NULL}, 7900, "udp"},
{"tnos-sp",            {NULL}, 7901, "tcp"},
{"tnos-sp",            {NULL}, 7901, "udp"},
{"tnos-dp",            {NULL}, 7902, "tcp"},
{"tnos-dp",            {NULL}, 7902, "udp"},
{"tnos-dps",           {NULL}, 7903, "tcp"},
{"tnos-dps",           {NULL}, 7903, "udp"},
{"qo-secure",          {NULL}, 7913, "tcp"},
{"qo-secure",          {NULL}, 7913, "udp"},
{"t2-drm",             {NULL}, 7932, "tcp"},
{"t2-drm",             {NULL}, 7932, "udp"},
{"t2-brm",             {NULL}, 7933, "tcp"},
{"t2-brm",             {NULL}, 7933, "udp"},
{"supercell",          {NULL}, 7967, "tcp"},
{"supercell",          {NULL}, 7967, "udp"},
{"micromuse-ncps",     {NULL}, 7979, "tcp"},
{"micromuse-ncps",     {NULL}, 7979, "udp"},
{"quest-vista",        {NULL}, 7980, "tcp"},
{"quest-vista",        {NULL}, 7980, "udp"},
{"sossd-collect",      {NULL}, 7981, "tcp"},
{"sossd-agent",        {NULL}, 7982, "tcp"},
{"sossd-disc",         {NULL}, 7982, "udp"},
{"pushns",             {NULL}, 7997, "tcp"},
{"usicontentpush",     {NULL}, 7998, "udp"},
{"irdmi2",             {NULL}, 7999, "tcp"},
{"irdmi2",             {NULL}, 7999, "udp"},
{"irdmi",              {NULL}, 8000, "tcp"},
{"irdmi",              {NULL}, 8000, "udp"},
{"vcom-tunnel",        {NULL}, 8001, "tcp"},
{"vcom-tunnel",        {NULL}, 8001, "udp"},
{"teradataordbms",     {NULL}, 8002, "tcp"},
{"teradataordbms",     {NULL}, 8002, "udp"},
{"mcreport",           {NULL}, 8003, "tcp"},
{"mcreport",           {NULL}, 8003, "udp"},
{"mxi",                {NULL}, 8005, "tcp"},
{"mxi",                {NULL}, 8005, "udp"},
{"http-alt",           {NULL}, 8008, "tcp"},
{"http-alt",           {NULL}, 8008, "udp"},
{"qbdb",               {NULL}, 8019, "tcp"},
{"qbdb",               {NULL}, 8019, "udp"},
{"intu-ec-svcdisc",    {NULL}, 8020, "tcp"},
{"intu-ec-svcdisc",    {NULL}, 8020, "udp"},
{"intu-ec-client",     {NULL}, 8021, "tcp"},
{"intu-ec-client",     {NULL}, 8021, "udp"},
{"oa-system",          {NULL}, 8022, "tcp"},
{"oa-system",          {NULL}, 8022, "udp"},
{"ca-audit-da",        {NULL}, 8025, "tcp"},
{"ca-audit-da",        {NULL}, 8025, "udp"},
{"ca-audit-ds",        {NULL}, 8026, "tcp"},
{"ca-audit-ds",        {NULL}, 8026, "udp"},
{"pro-ed",             {NULL}, 8032, "tcp"},
{"pro-ed",             {NULL}, 8032, "udp"},
{"mindprint",          {NULL}, 8033, "tcp"},
{"mindprint",          {NULL}, 8033, "udp"},
{"vantronix-mgmt",     {NULL}, 8034, "tcp"},
{"vantronix-mgmt",     {NULL}, 8034, "udp"},
{"ampify",             {NULL}, 8040, "tcp"},
{"ampify",             {NULL}, 8040, "udp"},
{"fs-agent",           {NULL}, 8042, "tcp"},
{"fs-server",          {NULL}, 8043, "tcp"},
{"fs-mgmt",            {NULL}, 8044, "tcp"},
{"senomix01",          {NULL}, 8052, "tcp"},
{"senomix01",          {NULL}, 8052, "udp"},
{"senomix02",          {NULL}, 8053, "tcp"},
{"senomix02",          {NULL}, 8053, "udp"},
{"senomix03",          {NULL}, 8054, "tcp"},
{"senomix03",          {NULL}, 8054, "udp"},
{"senomix04",          {NULL}, 8055, "tcp"},
{"senomix04",          {NULL}, 8055, "udp"},
{"senomix05",          {NULL}, 8056, "tcp"},
{"senomix05",          {NULL}, 8056, "udp"},
{"senomix06",          {NULL}, 8057, "tcp"},
{"senomix06",          {NULL}, 8057, "udp"},
{"senomix07",          {NULL}, 8058, "tcp"},
{"senomix07",          {NULL}, 8058, "udp"},
{"senomix08",          {NULL}, 8059, "tcp"},
{"senomix08",          {NULL}, 8059, "udp"},
{"gadugadu",           {NULL}, 8074, "tcp"},
{"gadugadu",           {NULL}, 8074, "udp"},
{"http-alt",           {NULL}, 8080, "tcp"},
{"http-alt",           {NULL}, 8080, "udp"},
{"sunproxyadmin",      {NULL}, 8081, "tcp"},
{"sunproxyadmin",      {NULL}, 8081, "udp"},
{"us-cli",             {NULL}, 8082, "tcp"},
{"us-cli",             {NULL}, 8082, "udp"},
{"us-srv",             {NULL}, 8083, "tcp"},
{"us-srv",             {NULL}, 8083, "udp"},
{"d-s-n",              {NULL}, 8086, "tcp"},
{"d-s-n",              {NULL}, 8086, "udp"},
{"simplifymedia",      {NULL}, 8087, "tcp"},
{"simplifymedia",      {NULL}, 8087, "udp"},
{"radan-http",         {NULL}, 8088, "tcp"},
{"radan-http",         {NULL}, 8088, "udp"},
{"jamlink",            {NULL}, 8091, "tcp"},
{"sac",                {NULL}, 8097, "tcp"},
{"sac",                {NULL}, 8097, "udp"},
{"xprint-server",      {NULL}, 8100, "tcp"},
{"xprint-server",      {NULL}, 8100, "udp"},
{"ldoms-migr",         {NULL}, 8101, "tcp"},
{"mtl8000-matrix",     {NULL}, 8115, "tcp"},
{"mtl8000-matrix",     {NULL}, 8115, "udp"},
{"cp-cluster",         {NULL}, 8116, "tcp"},
{"cp-cluster",         {NULL}, 8116, "udp"},
{"privoxy",            {NULL}, 8118, "tcp"},
{"privoxy",            {NULL}, 8118, "udp"},
{"apollo-data",        {NULL}, 8121, "tcp"},
{"apollo-data",        {NULL}, 8121, "udp"},
{"apollo-admin",       {NULL}, 8122, "tcp"},
{"apollo-admin",       {NULL}, 8122, "udp"},
{"paycash-online",     {NULL}, 8128, "tcp"},
{"paycash-online",     {NULL}, 8128, "udp"},
{"paycash-wbp",        {NULL}, 8129, "tcp"},
{"paycash-wbp",        {NULL}, 8129, "udp"},
{"indigo-vrmi",        {NULL}, 8130, "tcp"},
{"indigo-vrmi",        {NULL}, 8130, "udp"},
{"indigo-vbcp",        {NULL}, 8131, "tcp"},
{"indigo-vbcp",        {NULL}, 8131, "udp"},
{"dbabble",            {NULL}, 8132, "tcp"},
{"dbabble",            {NULL}, 8132, "udp"},
{"isdd",               {NULL}, 8148, "tcp"},
{"isdd",               {NULL}, 8148, "udp"},
{"patrol",             {NULL}, 8160, "tcp"},
{"patrol",             {NULL}, 8160, "udp"},
{"patrol-snmp",        {NULL}, 8161, "tcp"},
{"patrol-snmp",        {NULL}, 8161, "udp"},
{"vmware-fdm",         {NULL}, 8182, "tcp"},
{"vmware-fdm",         {NULL}, 8182, "udp"},
{"proremote",          {NULL}, 8183, "tcp"},
{"itach",              {NULL}, 8184, "tcp"},
{"itach",              {NULL}, 8184, "udp"},
{"spytechphone",       {NULL}, 8192, "tcp"},
{"spytechphone",       {NULL}, 8192, "udp"},
{"blp1",               {NULL}, 8194, "tcp"},
{"blp1",               {NULL}, 8194, "udp"},
{"blp2",               {NULL}, 8195, "tcp"},
{"blp2",               {NULL}, 8195, "udp"},
{"vvr-data",           {NULL}, 8199, "tcp"},
{"vvr-data",           {NULL}, 8199, "udp"},
{"trivnet1",           {NULL}, 8200, "tcp"},
{"trivnet1",           {NULL}, 8200, "udp"},
{"trivnet2",           {NULL}, 8201, "tcp"},
{"trivnet2",           {NULL}, 8201, "udp"},
{"lm-perfworks",       {NULL}, 8204, "tcp"},
{"lm-perfworks",       {NULL}, 8204, "udp"},
{"lm-instmgr",         {NULL}, 8205, "tcp"},
{"lm-instmgr",         {NULL}, 8205, "udp"},
{"lm-dta",             {NULL}, 8206, "tcp"},
{"lm-dta",             {NULL}, 8206, "udp"},
{"lm-sserver",         {NULL}, 8207, "tcp"},
{"lm-sserver",         {NULL}, 8207, "udp"},
{"lm-webwatcher",      {NULL}, 8208, "tcp"},
{"lm-webwatcher",      {NULL}, 8208, "udp"},
{"rexecj",             {NULL}, 8230, "tcp"},
{"rexecj",             {NULL}, 8230, "udp"},
{"synapse-nhttps",     {NULL}, 8243, "tcp"},
{"synapse-nhttps",     {NULL}, 8243, "udp"},
{"pando-sec",          {NULL}, 8276, "tcp"},
{"pando-sec",          {NULL}, 8276, "udp"},
{"synapse-nhttp",      {NULL}, 8280, "tcp"},
{"synapse-nhttp",      {NULL}, 8280, "udp"},
{"blp3",               {NULL}, 8292, "tcp"},
{"blp3",               {NULL}, 8292, "udp"},
{"hiperscan-id",       {NULL}, 8293, "tcp"},
{"blp4",               {NULL}, 8294, "tcp"},
{"blp4",               {NULL}, 8294, "udp"},
{"tmi",                {NULL}, 8300, "tcp"},
{"tmi",                {NULL}, 8300, "udp"},
{"amberon",            {NULL}, 8301, "tcp"},
{"amberon",            {NULL}, 8301, "udp"},
{"tnp-discover",       {NULL}, 8320, "tcp"},
{"tnp-discover",       {NULL}, 8320, "udp"},
{"tnp",                {NULL}, 8321, "tcp"},
{"tnp",                {NULL}, 8321, "udp"},
{"server-find",        {NULL}, 8351, "tcp"},
{"server-find",        {NULL}, 8351, "udp"},
{"cruise-enum",        {NULL}, 8376, "tcp"},
{"cruise-enum",        {NULL}, 8376, "udp"},
{"cruise-swroute",     {NULL}, 8377, "tcp"},
{"cruise-swroute",     {NULL}, 8377, "udp"},
{"cruise-config",      {NULL}, 8378, "tcp"},
{"cruise-config",      {NULL}, 8378, "udp"},
{"cruise-diags",       {NULL}, 8379, "tcp"},
{"cruise-diags",       {NULL}, 8379, "udp"},
{"cruise-update",      {NULL}, 8380, "tcp"},
{"cruise-update",      {NULL}, 8380, "udp"},
{"m2mservices",        {NULL}, 8383, "tcp"},
{"m2mservices",        {NULL}, 8383, "udp"},
{"cvd",                {NULL}, 8400, "tcp"},
{"cvd",                {NULL}, 8400, "udp"},
{"sabarsd",            {NULL}, 8401, "tcp"},
{"sabarsd",            {NULL}, 8401, "udp"},
{"abarsd",             {NULL}, 8402, "tcp"},
{"abarsd",             {NULL}, 8402, "udp"},
{"admind",             {NULL}, 8403, "tcp"},
{"admind",             {NULL}, 8403, "udp"},
{"svcloud",            {NULL}, 8404, "tcp"},
{"svbackup",           {NULL}, 8405, "tcp"},
{"espeech",            {NULL}, 8416, "tcp"},
{"espeech",            {NULL}, 8416, "udp"},
{"espeech-rtp",        {NULL}, 8417, "tcp"},
{"espeech-rtp",        {NULL}, 8417, "udp"},
{"cybro-a-bus",        {NULL}, 8442, "tcp"},
{"cybro-a-bus",        {NULL}, 8442, "udp"},
{"pcsync-https",       {NULL}, 8443, "tcp"},
{"pcsync-https",       {NULL}, 8443, "udp"},
{"pcsync-http",        {NULL}, 8444, "tcp"},
{"pcsync-http",        {NULL}, 8444, "udp"},
{"npmp",               {NULL}, 8450, "tcp"},
{"npmp",               {NULL}, 8450, "udp"},
{"cisco-avp",          {NULL}, 8470, "tcp"},
{"pim-port",           {NULL}, 8471, "tcp"},
{"pim-port",           {NULL}, 8471, "sctp"},
{"otv",                {NULL}, 8472, "tcp"},
{"otv",                {NULL}, 8472, "udp"},
{"vp2p",               {NULL}, 8473, "tcp"},
{"vp2p",               {NULL}, 8473, "udp"},
{"noteshare",          {NULL}, 8474, "tcp"},
{"noteshare",          {NULL}, 8474, "udp"},
{"fmtp",               {NULL}, 8500, "tcp"},
{"fmtp",               {NULL}, 8500, "udp"},
{"rtsp-alt",           {NULL}, 8554, "tcp"},
{"rtsp-alt",           {NULL}, 8554, "udp"},
{"d-fence",            {NULL}, 8555, "tcp"},
{"d-fence",            {NULL}, 8555, "udp"},
{"oap-admin",          {NULL}, 8567, "tcp"},
{"oap-admin",          {NULL}, 8567, "udp"},
{"asterix",            {NULL}, 8600, "tcp"},
{"asterix",            {NULL}, 8600, "udp"},
{"canon-mfnp",         {NULL}, 8610, "tcp"},
{"canon-mfnp",         {NULL}, 8610, "udp"},
{"canon-bjnp1",        {NULL}, 8611, "tcp"},
{"canon-bjnp1",        {NULL}, 8611, "udp"},
{"canon-bjnp2",        {NULL}, 8612, "tcp"},
{"canon-bjnp2",        {NULL}, 8612, "udp"},
{"canon-bjnp3",        {NULL}, 8613, "tcp"},
{"canon-bjnp3",        {NULL}, 8613, "udp"},
{"canon-bjnp4",        {NULL}, 8614, "tcp"},
{"canon-bjnp4",        {NULL}, 8614, "udp"},
{"sun-as-jmxrmi",      {NULL}, 8686, "tcp"},
{"sun-as-jmxrmi",      {NULL}, 8686, "udp"},
{"vnyx",               {NULL}, 8699, "tcp"},
{"vnyx",               {NULL}, 8699, "udp"},
{"dtp-net",            {NULL}, 8732, "udp"},
{"ibus",               {NULL}, 8733, "tcp"},
{"ibus",               {NULL}, 8733, "udp"},
{"mc-appserver",       {NULL}, 8763, "tcp"},
{"mc-appserver",       {NULL}, 8763, "udp"},
{"openqueue",          {NULL}, 8764, "tcp"},
{"openqueue",          {NULL}, 8764, "udp"},
{"ultraseek-http",     {NULL}, 8765, "tcp"},
{"ultraseek-http",     {NULL}, 8765, "udp"},
{"dpap",               {NULL}, 8770, "tcp"},
{"dpap",               {NULL}, 8770, "udp"},
{"msgclnt",            {NULL}, 8786, "tcp"},
{"msgclnt",            {NULL}, 8786, "udp"},
{"msgsrvr",            {NULL}, 8787, "tcp"},
{"msgsrvr",            {NULL}, 8787, "udp"},
{"sunwebadmin",        {NULL}, 8800, "tcp"},
{"sunwebadmin",        {NULL}, 8800, "udp"},
{"truecm",             {NULL}, 8804, "tcp"},
{"truecm",             {NULL}, 8804, "udp"},
{"dxspider",           {NULL}, 8873, "tcp"},
{"dxspider",           {NULL}, 8873, "udp"},
{"cddbp-alt",          {NULL}, 8880, "tcp"},
{"cddbp-alt",          {NULL}, 8880, "udp"},
{"secure-mqtt",        {NULL}, 8883, "tcp"},
{"secure-mqtt",        {NULL}, 8883, "udp"},
{"ddi-tcp-1",          {NULL}, 8888, "tcp"},
{"ddi-udp-1",          {NULL}, 8888, "udp"},
{"ddi-tcp-2",          {NULL}, 8889, "tcp"},
{"ddi-udp-2",          {NULL}, 8889, "udp"},
{"ddi-tcp-3",          {NULL}, 8890, "tcp"},
{"ddi-udp-3",          {NULL}, 8890, "udp"},
{"ddi-tcp-4",          {NULL}, 8891, "tcp"},
{"ddi-udp-4",          {NULL}, 8891, "udp"},
{"ddi-tcp-5",          {NULL}, 8892, "tcp"},
{"ddi-udp-5",          {NULL}, 8892, "udp"},
{"ddi-tcp-6",          {NULL}, 8893, "tcp"},
{"ddi-udp-6",          {NULL}, 8893, "udp"},
{"ddi-tcp-7",          {NULL}, 8894, "tcp"},
{"ddi-udp-7",          {NULL}, 8894, "udp"},
{"ospf-lite",          {NULL}, 8899, "tcp"},
{"ospf-lite",          {NULL}, 8899, "udp"},
{"jmb-cds1",           {NULL}, 8900, "tcp"},
{"jmb-cds1",           {NULL}, 8900, "udp"},
{"jmb-cds2",           {NULL}, 8901, "tcp"},
{"jmb-cds2",           {NULL}, 8901, "udp"},
{"manyone-http",       {NULL}, 8910, "tcp"},
{"manyone-http",       {NULL}, 8910, "udp"},
{"manyone-xml",        {NULL}, 8911, "tcp"},
{"manyone-xml",        {NULL}, 8911, "udp"},
{"wcbackup",           {NULL}, 8912, "tcp"},
{"wcbackup",           {NULL}, 8912, "udp"},
{"dragonfly",          {NULL}, 8913, "tcp"},
{"dragonfly",          {NULL}, 8913, "udp"},
{"twds",               {NULL}, 8937, "tcp"},
{"cumulus-admin",      {NULL}, 8954, "tcp"},
{"cumulus-admin",      {NULL}, 8954, "udp"},
{"sunwebadmins",       {NULL}, 8989, "tcp"},
{"sunwebadmins",       {NULL}, 8989, "udp"},
{"http-wmap",          {NULL}, 8990, "tcp"},
{"http-wmap",          {NULL}, 8990, "udp"},
{"https-wmap",         {NULL}, 8991, "tcp"},
{"https-wmap",         {NULL}, 8991, "udp"},
{"bctp",               {NULL}, 8999, "tcp"},
{"bctp",               {NULL}, 8999, "udp"},
{"cslistener",         {NULL}, 9000, "tcp"},
{"cslistener",         {NULL}, 9000, "udp"},
{"etlservicemgr",      {NULL}, 9001, "tcp"},
{"etlservicemgr",      {NULL}, 9001, "udp"},
{"dynamid",            {NULL}, 9002, "tcp"},
{"dynamid",            {NULL}, 9002, "udp"},
{"ogs-client",         {NULL}, 9007, "udp"},
{"ogs-server",         {NULL}, 9008, "tcp"},
{"pichat",             {NULL}, 9009, "tcp"},
{"pichat",             {NULL}, 9009, "udp"},
{"sdr",                {NULL}, 9010, "tcp"},
{"tambora",            {NULL}, 9020, "tcp"},
{"tambora",            {NULL}, 9020, "udp"},
{"panagolin-ident",    {NULL}, 9021, "tcp"},
{"panagolin-ident",    {NULL}, 9021, "udp"},
{"paragent",           {NULL}, 9022, "tcp"},
{"paragent",           {NULL}, 9022, "udp"},
{"swa-1",              {NULL}, 9023, "tcp"},
{"swa-1",              {NULL}, 9023, "udp"},
{"swa-2",              {NULL}, 9024, "tcp"},
{"swa-2",              {NULL}, 9024, "udp"},
{"swa-3",              {NULL}, 9025, "tcp"},
{"swa-3",              {NULL}, 9025, "udp"},
{"swa-4",              {NULL}, 9026, "tcp"},
{"swa-4",              {NULL}, 9026, "udp"},
{"versiera",           {NULL}, 9050, "tcp"},
{"fio-cmgmt",          {NULL}, 9051, "tcp"},
{"glrpc",              {NULL}, 9080, "tcp"},
{"glrpc",              {NULL}, 9080, "udp"},
{"lcs-ap",             {NULL}, 9082, "sctp"},
{"emc-pp-mgmtsvc",     {NULL}, 9083, "tcp"},
{"aurora",             {NULL}, 9084, "tcp"},
{"aurora",             {NULL}, 9084, "udp"},
{"aurora",             {NULL}, 9084, "sctp"},
{"ibm-rsyscon",        {NULL}, 9085, "tcp"},
{"ibm-rsyscon",        {NULL}, 9085, "udp"},
{"net2display",        {NULL}, 9086, "tcp"},
{"net2display",        {NULL}, 9086, "udp"},
{"classic",            {NULL}, 9087, "tcp"},
{"classic",            {NULL}, 9087, "udp"},
{"sqlexec",            {NULL}, 9088, "tcp"},
{"sqlexec",            {NULL}, 9088, "udp"},
{"sqlexec-ssl",        {NULL}, 9089, "tcp"},
{"sqlexec-ssl",        {NULL}, 9089, "udp"},
{"websm",              {NULL}, 9090, "tcp"},
{"websm",              {NULL}, 9090, "udp"},
{"xmltec-xmlmail",     {NULL}, 9091, "tcp"},
{"xmltec-xmlmail",     {NULL}, 9091, "udp"},
{"XmlIpcRegSvc",       {NULL}, 9092, "tcp"},
{"XmlIpcRegSvc",       {NULL}, 9092, "udp"},
{"hp-pdl-datastr",     {NULL}, 9100, "tcp"},
{"hp-pdl-datastr",     {NULL}, 9100, "udp"},
{"pdl-datastream",     {NULL}, 9100, "tcp"},
{"pdl-datastream",     {NULL}, 9100, "udp"},
{"bacula-dir",         {NULL}, 9101, "tcp"},
{"bacula-dir",         {NULL}, 9101, "udp"},
{"bacula-fd",          {NULL}, 9102, "tcp"},
{"bacula-fd",          {NULL}, 9102, "udp"},
{"bacula-sd",          {NULL}, 9103, "tcp"},
{"bacula-sd",          {NULL}, 9103, "udp"},
{"peerwire",           {NULL}, 9104, "tcp"},
{"peerwire",           {NULL}, 9104, "udp"},
{"xadmin",             {NULL}, 9105, "tcp"},
{"xadmin",             {NULL}, 9105, "udp"},
{"astergate",          {NULL}, 9106, "tcp"},
{"astergate-disc",     {NULL}, 9106, "udp"},
{"astergatefax",       {NULL}, 9107, "tcp"},
{"mxit",               {NULL}, 9119, "tcp"},
{"mxit",               {NULL}, 9119, "udp"},
{"dddp",               {NULL}, 9131, "tcp"},
{"dddp",               {NULL}, 9131, "udp"},
{"apani1",             {NULL}, 9160, "tcp"},
{"apani1",             {NULL}, 9160, "udp"},
{"apani2",             {NULL}, 9161, "tcp"},
{"apani2",             {NULL}, 9161, "udp"},
{"apani3",             {NULL}, 9162, "tcp"},
{"apani3",             {NULL}, 9162, "udp"},
{"apani4",             {NULL}, 9163, "tcp"},
{"apani4",             {NULL}, 9163, "udp"},
{"apani5",             {NULL}, 9164, "tcp"},
{"apani5",             {NULL}, 9164, "udp"},
{"sun-as-jpda",        {NULL}, 9191, "tcp"},
{"sun-as-jpda",        {NULL}, 9191, "udp"},
{"wap-wsp",            {NULL}, 9200, "tcp"},
{"wap-wsp",            {NULL}, 9200, "udp"},
{"wap-wsp-wtp",        {NULL}, 9201, "tcp"},
{"wap-wsp-wtp",        {NULL}, 9201, "udp"},
{"wap-wsp-s",          {NULL}, 9202, "tcp"},
{"wap-wsp-s",          {NULL}, 9202, "udp"},
{"wap-wsp-wtp-s",      {NULL}, 9203, "tcp"},
{"wap-wsp-wtp-s",      {NULL}, 9203, "udp"},
{"wap-vcard",          {NULL}, 9204, "tcp"},
{"wap-vcard",          {NULL}, 9204, "udp"},
{"wap-vcal",           {NULL}, 9205, "tcp"},
{"wap-vcal",           {NULL}, 9205, "udp"},
{"wap-vcard-s",        {NULL}, 9206, "tcp"},
{"wap-vcard-s",        {NULL}, 9206, "udp"},
{"wap-vcal-s",         {NULL}, 9207, "tcp"},
{"wap-vcal-s",         {NULL}, 9207, "udp"},
{"rjcdb-vcards",       {NULL}, 9208, "tcp"},
{"rjcdb-vcards",       {NULL}, 9208, "udp"},
{"almobile-system",    {NULL}, 9209, "tcp"},
{"almobile-system",    {NULL}, 9209, "udp"},
{"oma-mlp",            {NULL}, 9210, "tcp"},
{"oma-mlp",            {NULL}, 9210, "udp"},
{"oma-mlp-s",          {NULL}, 9211, "tcp"},
{"oma-mlp-s",          {NULL}, 9211, "udp"},
{"serverviewdbms",     {NULL}, 9212, "tcp"},
{"serverviewdbms",     {NULL}, 9212, "udp"},
{"serverstart",        {NULL}, 9213, "tcp"},
{"serverstart",        {NULL}, 9213, "udp"},
{"ipdcesgbs",          {NULL}, 9214, "tcp"},
{"ipdcesgbs",          {NULL}, 9214, "udp"},
{"insis",              {NULL}, 9215, "tcp"},
{"insis",              {NULL}, 9215, "udp"},
{"acme",               {NULL}, 9216, "tcp"},
{"acme",               {NULL}, 9216, "udp"},
{"fsc-port",           {NULL}, 9217, "tcp"},
{"fsc-port",           {NULL}, 9217, "udp"},
{"teamcoherence",      {NULL}, 9222, "tcp"},
{"teamcoherence",      {NULL}, 9222, "udp"},
{"mon",                {NULL}, 9255, "tcp"},
{"mon",                {NULL}, 9255, "udp"},
{"pegasus",            {NULL}, 9278, "tcp"},
{"pegasus",            {NULL}, 9278, "udp"},
{"pegasus-ctl",        {NULL}, 9279, "tcp"},
{"pegasus-ctl",        {NULL}, 9279, "udp"},
{"pgps",               {NULL}, 9280, "tcp"},
{"pgps",               {NULL}, 9280, "udp"},
{"swtp-port1",         {NULL}, 9281, "tcp"},
{"swtp-port1",         {NULL}, 9281, "udp"},
{"swtp-port2",         {NULL}, 9282, "tcp"},
{"swtp-port2",         {NULL}, 9282, "udp"},
{"callwaveiam",        {NULL}, 9283, "tcp"},
{"callwaveiam",        {NULL}, 9283, "udp"},
{"visd",               {NULL}, 9284, "tcp"},
{"visd",               {NULL}, 9284, "udp"},
{"n2h2server",         {NULL}, 9285, "tcp"},
{"n2h2server",         {NULL}, 9285, "udp"},
{"n2receive",          {NULL}, 9286, "udp"},
{"cumulus",            {NULL}, 9287, "tcp"},
{"cumulus",            {NULL}, 9287, "udp"},
{"armtechdaemon",      {NULL}, 9292, "tcp"},
{"armtechdaemon",      {NULL}, 9292, "udp"},
{"storview",           {NULL}, 9293, "tcp"},
{"storview",           {NULL}, 9293, "udp"},
{"armcenterhttp",      {NULL}, 9294, "tcp"},
{"armcenterhttp",      {NULL}, 9294, "udp"},
{"armcenterhttps",     {NULL}, 9295, "tcp"},
{"armcenterhttps",     {NULL}, 9295, "udp"},
{"vrace",              {NULL}, 9300, "tcp"},
{"vrace",              {NULL}, 9300, "udp"},
{"sphinxql",           {NULL}, 9306, "tcp"},
{"sphinxapi",          {NULL}, 9312, "tcp"},
{"secure-ts",          {NULL}, 9318, "tcp"},
{"secure-ts",          {NULL}, 9318, "udp"},
{"guibase",            {NULL}, 9321, "tcp"},
{"guibase",            {NULL}, 9321, "udp"},
{"mpidcmgr",           {NULL}, 9343, "tcp"},
{"mpidcmgr",           {NULL}, 9343, "udp"},
{"mphlpdmc",           {NULL}, 9344, "tcp"},
{"mphlpdmc",           {NULL}, 9344, "udp"},
{"ctechlicensing",     {NULL}, 9346, "tcp"},
{"ctechlicensing",     {NULL}, 9346, "udp"},
{"fjdmimgr",           {NULL}, 9374, "tcp"},
{"fjdmimgr",           {NULL}, 9374, "udp"},
{"boxp",               {NULL}, 9380, "tcp"},
{"boxp",               {NULL}, 9380, "udp"},
{"d2dconfig",          {NULL}, 9387, "tcp"},
{"d2ddatatrans",       {NULL}, 9388, "tcp"},
{"adws",               {NULL}, 9389, "tcp"},
{"otp",                {NULL}, 9390, "tcp"},
{"fjinvmgr",           {NULL}, 9396, "tcp"},
{"fjinvmgr",           {NULL}, 9396, "udp"},
{"mpidcagt",           {NULL}, 9397, "tcp"},
{"mpidcagt",           {NULL}, 9397, "udp"},
{"sec-t4net-srv",      {NULL}, 9400, "tcp"},
{"sec-t4net-srv",      {NULL}, 9400, "udp"},
{"sec-t4net-clt",      {NULL}, 9401, "tcp"},
{"sec-t4net-clt",      {NULL}, 9401, "udp"},
{"sec-pc2fax-srv",     {NULL}, 9402, "tcp"},
{"sec-pc2fax-srv",     {NULL}, 9402, "udp"},
{"git",                {NULL}, 9418, "tcp"},
{"git",                {NULL}, 9418, "udp"},
{"tungsten-https",     {NULL}, 9443, "tcp"},
{"tungsten-https",     {NULL}, 9443, "udp"},
{"wso2esb-console",    {NULL}, 9444, "tcp"},
{"wso2esb-console",    {NULL}, 9444, "udp"},
{"sntlkeyssrvr",       {NULL}, 9450, "tcp"},
{"sntlkeyssrvr",       {NULL}, 9450, "udp"},
{"ismserver",          {NULL}, 9500, "tcp"},
{"ismserver",          {NULL}, 9500, "udp"},
{"sma-spw",            {NULL}, 9522, "udp"},
{"mngsuite",           {NULL}, 9535, "tcp"},
{"mngsuite",           {NULL}, 9535, "udp"},
{"laes-bf",            {NULL}, 9536, "tcp"},
{"laes-bf",            {NULL}, 9536, "udp"},
{"trispen-sra",        {NULL}, 9555, "tcp"},
{"trispen-sra",        {NULL}, 9555, "udp"},
{"ldgateway",          {NULL}, 9592, "tcp"},
{"ldgateway",          {NULL}, 9592, "udp"},
{"cba8",               {NULL}, 9593, "tcp"},
{"cba8",               {NULL}, 9593, "udp"},
{"msgsys",             {NULL}, 9594, "tcp"},
{"msgsys",             {NULL}, 9594, "udp"},
{"pds",                {NULL}, 9595, "tcp"},
{"pds",                {NULL}, 9595, "udp"},
{"mercury-disc",       {NULL}, 9596, "tcp"},
{"mercury-disc",       {NULL}, 9596, "udp"},
{"pd-admin",           {NULL}, 9597, "tcp"},
{"pd-admin",           {NULL}, 9597, "udp"},
{"vscp",               {NULL}, 9598, "tcp"},
{"vscp",               {NULL}, 9598, "udp"},
{"robix",              {NULL}, 9599, "tcp"},
{"robix",              {NULL}, 9599, "udp"},
{"micromuse-ncpw",     {NULL}, 9600, "tcp"},
{"micromuse-ncpw",     {NULL}, 9600, "udp"},
{"streamcomm-ds",      {NULL}, 9612, "tcp"},
{"streamcomm-ds",      {NULL}, 9612, "udp"},
{"iadt-tls",           {NULL}, 9614, "tcp"},
{"erunbook_agent",     {NULL}, 9616, "tcp"},
{"erunbook_server",    {NULL}, 9617, "tcp"},
{"condor",             {NULL}, 9618, "tcp"},
{"condor",             {NULL}, 9618, "udp"},
{"odbcpathway",        {NULL}, 9628, "tcp"},
{"odbcpathway",        {NULL}, 9628, "udp"},
{"uniport",            {NULL}, 9629, "tcp"},
{"uniport",            {NULL}, 9629, "udp"},
{"peoctlr",            {NULL}, 9630, "tcp"},
{"peocoll",            {NULL}, 9631, "tcp"},
{"mc-comm",            {NULL}, 9632, "udp"},
{"pqsflows",           {NULL}, 9640, "tcp"},
{"xmms2",              {NULL}, 9667, "tcp"},
{"xmms2",              {NULL}, 9667, "udp"},
{"tec5-sdctp",         {NULL}, 9668, "tcp"},
{"tec5-sdctp",         {NULL}, 9668, "udp"},
{"client-wakeup",      {NULL}, 9694, "tcp"},
{"client-wakeup",      {NULL}, 9694, "udp"},
{"ccnx",               {NULL}, 9695, "tcp"},
{"ccnx",               {NULL}, 9695, "udp"},
{"board-roar",         {NULL}, 9700, "tcp"},
{"board-roar",         {NULL}, 9700, "udp"},
{"l5nas-parchan",      {NULL}, 9747, "tcp"},
{"l5nas-parchan",      {NULL}, 9747, "udp"},
{"board-voip",         {NULL}, 9750, "tcp"},
{"board-voip",         {NULL}, 9750, "udp"},
{"rasadv",             {NULL}, 9753, "tcp"},
{"rasadv",             {NULL}, 9753, "udp"},
{"tungsten-http",      {NULL}, 9762, "tcp"},
{"tungsten-http",      {NULL}, 9762, "udp"},
{"davsrc",             {NULL}, 9800, "tcp"},
{"davsrc",             {NULL}, 9800, "udp"},
{"sstp-2",             {NULL}, 9801, "tcp"},
{"sstp-2",             {NULL}, 9801, "udp"},
{"davsrcs",            {NULL}, 9802, "tcp"},
{"davsrcs",            {NULL}, 9802, "udp"},
{"sapv1",              {NULL}, 9875, "tcp"},
{"sapv1",              {NULL}, 9875, "udp"},
{"sd",                 {NULL}, 9876, "tcp"},
{"sd",                 {NULL}, 9876, "udp"},
{"cyborg-systems",     {NULL}, 9888, "tcp"},
{"cyborg-systems",     {NULL}, 9888, "udp"},
{"gt-proxy",           {NULL}, 9889, "tcp"},
{"gt-proxy",           {NULL}, 9889, "udp"},
{"monkeycom",          {NULL}, 9898, "tcp"},
{"monkeycom",          {NULL}, 9898, "udp"},
{"sctp-tunneling",     {NULL}, 9899, "tcp"},
{"sctp-tunneling",     {NULL}, 9899, "udp"},
{"iua",                {NULL}, 9900, "tcp"},
{"iua",                {NULL}, 9900, "udp"},
{"iua",                {NULL}, 9900, "sctp"},
{"enrp",               {NULL}, 9901, "udp"},
{"enrp-sctp",          {NULL}, 9901, "sctp"},
{"enrp-sctp-tls",      {NULL}, 9902, "sctp"},
{"domaintime",         {NULL}, 9909, "tcp"},
{"domaintime",         {NULL}, 9909, "udp"},
{"sype-transport",     {NULL}, 9911, "tcp"},
{"sype-transport",     {NULL}, 9911, "udp"},
{"apc-9950",           {NULL}, 9950, "tcp"},
{"apc-9950",           {NULL}, 9950, "udp"},
{"apc-9951",           {NULL}, 9951, "tcp"},
{"apc-9951",           {NULL}, 9951, "udp"},
{"apc-9952",           {NULL}, 9952, "tcp"},
{"apc-9952",           {NULL}, 9952, "udp"},
{"acis",               {NULL}, 9953, "tcp"},
{"acis",               {NULL}, 9953, "udp"},
{"odnsp",              {NULL}, 9966, "tcp"},
{"odnsp",              {NULL}, 9966, "udp"},
{"dsm-scm-target",     {NULL}, 9987, "tcp"},
{"dsm-scm-target",     {NULL}, 9987, "udp"},
{"nsesrvr",            {NULL}, 9988, "tcp"},
{"osm-appsrvr",        {NULL}, 9990, "tcp"},
{"osm-appsrvr",        {NULL}, 9990, "udp"},
{"osm-oev",            {NULL}, 9991, "tcp"},
{"osm-oev",            {NULL}, 9991, "udp"},
{"palace-1",           {NULL}, 9992, "tcp"},
{"palace-1",           {NULL}, 9992, "udp"},
{"palace-2",           {NULL}, 9993, "tcp"},
{"palace-2",           {NULL}, 9993, "udp"},
{"palace-3",           {NULL}, 9994, "tcp"},
{"palace-3",           {NULL}, 9994, "udp"},
{"palace-4",           {NULL}, 9995, "tcp"},
{"palace-4",           {NULL}, 9995, "udp"},
{"palace-5",           {NULL}, 9996, "tcp"},
{"palace-5",           {NULL}, 9996, "udp"},
{"palace-6",           {NULL}, 9997, "tcp"},
{"palace-6",           {NULL}, 9997, "udp"},
{"distinct32",         {NULL}, 9998, "tcp"},
{"distinct32",         {NULL}, 9998, "udp"},
{"distinct",           {NULL}, 9999, "tcp"},
{"distinct",           {NULL}, 9999, "udp"},
{"ndmp",               {NULL}, 10000, "tcp"},
{"ndmp",               {NULL}, 10000, "udp"},
{"scp-config",         {NULL}, 10001, "tcp"},
{"scp-config",         {NULL}, 10001, "udp"},
{"documentum",         {NULL}, 10002, "tcp"},
{"documentum",         {NULL}, 10002, "udp"},
{"documentum_s",       {NULL}, 10003, "tcp"},
{"documentum_s",       {NULL}, 10003, "udp"},
{"emcrmirccd",         {NULL}, 10004, "tcp"},
{"emcrmird",           {NULL}, 10005, "tcp"},
{"mvs-capacity",       {NULL}, 10007, "tcp"},
{"mvs-capacity",       {NULL}, 10007, "udp"},
{"octopus",            {NULL}, 10008, "tcp"},
{"octopus",            {NULL}, 10008, "udp"},
{"swdtp-sv",           {NULL}, 10009, "tcp"},
{"swdtp-sv",           {NULL}, 10009, "udp"},
{"rxapi",              {NULL}, 10010, "tcp"},
{"zabbix-agent",       {NULL}, 10050, "tcp"},
{"zabbix-agent",       {NULL}, 10050, "udp"},
{"zabbix-trapper",     {NULL}, 10051, "tcp"},
{"zabbix-trapper",     {NULL}, 10051, "udp"},
{"qptlmd",             {NULL}, 10055, "tcp"},
{"amanda",             {NULL}, 10080, "tcp"},
{"amanda",             {NULL}, 10080, "udp"},
{"famdc",              {NULL}, 10081, "tcp"},
{"famdc",              {NULL}, 10081, "udp"},
{"itap-ddtp",          {NULL}, 10100, "tcp"},
{"itap-ddtp",          {NULL}, 10100, "udp"},
{"ezmeeting-2",        {NULL}, 10101, "tcp"},
{"ezmeeting-2",        {NULL}, 10101, "udp"},
{"ezproxy-2",          {NULL}, 10102, "tcp"},
{"ezproxy-2",          {NULL}, 10102, "udp"},
{"ezrelay",            {NULL}, 10103, "tcp"},
{"ezrelay",            {NULL}, 10103, "udp"},
{"swdtp",              {NULL}, 10104, "tcp"},
{"swdtp",              {NULL}, 10104, "udp"},
{"bctp-server",        {NULL}, 10107, "tcp"},
{"bctp-server",        {NULL}, 10107, "udp"},
{"nmea-0183",          {NULL}, 10110, "tcp"},
{"nmea-0183",          {NULL}, 10110, "udp"},
{"netiq-endpoint",     {NULL}, 10113, "tcp"},
{"netiq-endpoint",     {NULL}, 10113, "udp"},
{"netiq-qcheck",       {NULL}, 10114, "tcp"},
{"netiq-qcheck",       {NULL}, 10114, "udp"},
{"netiq-endpt",        {NULL}, 10115, "tcp"},
{"netiq-endpt",        {NULL}, 10115, "udp"},
{"netiq-voipa",        {NULL}, 10116, "tcp"},
{"netiq-voipa",        {NULL}, 10116, "udp"},
{"iqrm",               {NULL}, 10117, "tcp"},
{"iqrm",               {NULL}, 10117, "udp"},
{"bmc-perf-sd",        {NULL}, 10128, "tcp"},
{"bmc-perf-sd",        {NULL}, 10128, "udp"},
{"bmc-gms",            {NULL}, 10129, "tcp"},
{"qb-db-server",       {NULL}, 10160, "tcp"},
{"qb-db-server",       {NULL}, 10160, "udp"},
{"snmptls",            {NULL}, 10161, "tcp"},
{"snmpdtls",           {NULL}, 10161, "udp"},
{"snmptls-trap",       {NULL}, 10162, "tcp"},
{"snmpdtls-trap",      {NULL}, 10162, "udp"},
{"trisoap",            {NULL}, 10200, "tcp"},
{"trisoap",            {NULL}, 10200, "udp"},
{"rsms",               {NULL}, 10201, "tcp"},
{"rscs",               {NULL}, 10201, "udp"},
{"apollo-relay",       {NULL}, 10252, "tcp"},
{"apollo-relay",       {NULL}, 10252, "udp"},
{"axis-wimp-port",     {NULL}, 10260, "tcp"},
{"axis-wimp-port",     {NULL}, 10260, "udp"},
{"blocks",             {NULL}, 10288, "tcp"},
{"blocks",             {NULL}, 10288, "udp"},
{"cosir",              {NULL}, 10321, "tcp"},
{"hip-nat-t",          {NULL}, 10500, "udp"},
{"MOS-lower",          {NULL}, 10540, "tcp"},
{"MOS-lower",          {NULL}, 10540, "udp"},
{"MOS-upper",          {NULL}, 10541, "tcp"},
{"MOS-upper",          {NULL}, 10541, "udp"},
{"MOS-aux",            {NULL}, 10542, "tcp"},
{"MOS-aux",            {NULL}, 10542, "udp"},
{"MOS-soap",           {NULL}, 10543, "tcp"},
{"MOS-soap",           {NULL}, 10543, "udp"},
{"MOS-soap-opt",       {NULL}, 10544, "tcp"},
{"MOS-soap-opt",       {NULL}, 10544, "udp"},
{"gap",                {NULL}, 10800, "tcp"},
{"gap",                {NULL}, 10800, "udp"},
{"lpdg",               {NULL}, 10805, "tcp"},
{"lpdg",               {NULL}, 10805, "udp"},
{"nbd",                {NULL}, 10809, "tcp"},
{"nmc-disc",           {NULL}, 10810, "udp"},
{"helix",              {NULL}, 10860, "tcp"},
{"helix",              {NULL}, 10860, "udp"},
{"rmiaux",             {NULL}, 10990, "tcp"},
{"rmiaux",             {NULL}, 10990, "udp"},
{"irisa",              {NULL}, 11000, "tcp"},
{"irisa",              {NULL}, 11000, "udp"},
{"metasys",            {NULL}, 11001, "tcp"},
{"metasys",            {NULL}, 11001, "udp"},
{"netapp-icmgmt",      {NULL}, 11104, "tcp"},
{"netapp-icdata",      {NULL}, 11105, "tcp"},
{"sgi-lk",             {NULL}, 11106, "tcp"},
{"sgi-lk",             {NULL}, 11106, "udp"},
{"vce",                {NULL}, 11111, "tcp"},
{"vce",                {NULL}, 11111, "udp"},
{"dicom",              {NULL}, 11112, "tcp"},
{"dicom",              {NULL}, 11112, "udp"},
{"suncacao-snmp",      {NULL}, 11161, "tcp"},
{"suncacao-snmp",      {NULL}, 11161, "udp"},
{"suncacao-jmxmp",     {NULL}, 11162, "tcp"},
{"suncacao-jmxmp",     {NULL}, 11162, "udp"},
{"suncacao-rmi",       {NULL}, 11163, "tcp"},
{"suncacao-rmi",       {NULL}, 11163, "udp"},
{"suncacao-csa",       {NULL}, 11164, "tcp"},
{"suncacao-csa",       {NULL}, 11164, "udp"},
{"suncacao-websvc",    {NULL}, 11165, "tcp"},
{"suncacao-websvc",    {NULL}, 11165, "udp"},
{"snss",               {NULL}, 11171, "udp"},
{"oemcacao-jmxmp",     {NULL}, 11172, "tcp"},
{"oemcacao-rmi",       {NULL}, 11174, "tcp"},
{"oemcacao-websvc",    {NULL}, 11175, "tcp"},
{"smsqp",              {NULL}, 11201, "tcp"},
{"smsqp",              {NULL}, 11201, "udp"},
{"wifree",             {NULL}, 11208, "tcp"},
{"wifree",             {NULL}, 11208, "udp"},
{"memcache",           {NULL}, 11211, "tcp"},
{"memcache",           {NULL}, 11211, "udp"},
{"imip",               {NULL}, 11319, "tcp"},
{"imip",               {NULL}, 11319, "udp"},
{"imip-channels",      {NULL}, 11320, "tcp"},
{"imip-channels",      {NULL}, 11320, "udp"},
{"arena-server",       {NULL}, 11321, "tcp"},
{"arena-server",       {NULL}, 11321, "udp"},
{"atm-uhas",           {NULL}, 11367, "tcp"},
{"atm-uhas",           {NULL}, 11367, "udp"},
{"hkp",                {NULL}, 11371, "tcp"},
{"hkp",                {NULL}, 11371, "udp"},
{"asgcypresstcps",     {NULL}, 11489, "tcp"},
{"tempest-port",       {NULL}, 11600, "tcp"},
{"tempest-port",       {NULL}, 11600, "udp"},
{"h323callsigalt",     {NULL}, 11720, "tcp"},
{"h323callsigalt",     {NULL}, 11720, "udp"},
{"intrepid-ssl",       {NULL}, 11751, "tcp"},
{"intrepid-ssl",       {NULL}, 11751, "udp"},
{"xoraya",             {NULL}, 11876, "tcp"},
{"xoraya",             {NULL}, 11876, "udp"},
{"x2e-disc",           {NULL}, 11877, "udp"},
{"sysinfo-sp",         {NULL}, 11967, "tcp"},
{"sysinfo-sp",         {NULL}, 11967, "udp"},
{"wmereceiving",       {NULL}, 11997, "sctp"},
{"wmedistribution",    {NULL}, 11998, "sctp"},
{"wmereporting",       {NULL}, 11999, "sctp"},
{"entextxid",          {NULL}, 12000, "tcp"},
{"entextxid",          {NULL}, 12000, "udp"},
{"entextnetwk",        {NULL}, 12001, "tcp"},
{"entextnetwk",        {NULL}, 12001, "udp"},
{"entexthigh",         {NULL}, 12002, "tcp"},
{"entexthigh",         {NULL}, 12002, "udp"},
{"entextmed",          {NULL}, 12003, "tcp"},
{"entextmed",          {NULL}, 12003, "udp"},
{"entextlow",          {NULL}, 12004, "tcp"},
{"entextlow",          {NULL}, 12004, "udp"},
{"dbisamserver1",      {NULL}, 12005, "tcp"},
{"dbisamserver1",      {NULL}, 12005, "udp"},
{"dbisamserver2",      {NULL}, 12006, "tcp"},
{"dbisamserver2",      {NULL}, 12006, "udp"},
{"accuracer",          {NULL}, 12007, "tcp"},
{"accuracer",          {NULL}, 12007, "udp"},
{"accuracer-dbms",     {NULL}, 12008, "tcp"},
{"accuracer-dbms",     {NULL}, 12008, "udp"},
{"edbsrvr",            {NULL}, 12010, "tcp"},
{"vipera",             {NULL}, 12012, "tcp"},
{"vipera",             {NULL}, 12012, "udp"},
{"vipera-ssl",         {NULL}, 12013, "tcp"},
{"vipera-ssl",         {NULL}, 12013, "udp"},
{"rets-ssl",           {NULL}, 12109, "tcp"},
{"rets-ssl",           {NULL}, 12109, "udp"},
{"nupaper-ss",         {NULL}, 12121, "tcp"},
{"nupaper-ss",         {NULL}, 12121, "udp"},
{"cawas",              {NULL}, 12168, "tcp"},
{"cawas",              {NULL}, 12168, "udp"},
{"hivep",              {NULL}, 12172, "tcp"},
{"hivep",              {NULL}, 12172, "udp"},
{"linogridengine",     {NULL}, 12300, "tcp"},
{"linogridengine",     {NULL}, 12300, "udp"},
{"warehouse-sss",      {NULL}, 12321, "tcp"},
{"warehouse-sss",      {NULL}, 12321, "udp"},
{"warehouse",          {NULL}, 12322, "tcp"},
{"warehouse",          {NULL}, 12322, "udp"},
{"italk",              {NULL}, 12345, "tcp"},
{"italk",              {NULL}, 12345, "udp"},
{"tsaf",               {NULL}, 12753, "tcp"},
{"tsaf",               {NULL}, 12753, "udp"},
{"i-zipqd",            {NULL}, 13160, "tcp"},
{"i-zipqd",            {NULL}, 13160, "udp"},
{"bcslogc",            {NULL}, 13216, "tcp"},
{"bcslogc",            {NULL}, 13216, "udp"},
{"rs-pias",            {NULL}, 13217, "tcp"},
{"rs-pias",            {NULL}, 13217, "udp"},
{"emc-vcas-tcp",       {NULL}, 13218, "tcp"},
{"emc-vcas-udp",       {NULL}, 13218, "udp"},
{"powwow-client",      {NULL}, 13223, "tcp"},
{"powwow-client",      {NULL}, 13223, "udp"},
{"powwow-server",      {NULL}, 13224, "tcp"},
{"powwow-server",      {NULL}, 13224, "udp"},
{"doip-data",          {NULL}, 13400, "tcp"},
{"doip-disc",          {NULL}, 13400, "udp"},
{"bprd",               {NULL}, 13720, "tcp"},
{"bprd",               {NULL}, 13720, "udp"},
{"bpdbm",              {NULL}, 13721, "tcp"},
{"bpdbm",              {NULL}, 13721, "udp"},
{"bpjava-msvc",        {NULL}, 13722, "tcp"},
{"bpjava-msvc",        {NULL}, 13722, "udp"},
{"vnetd",              {NULL}, 13724, "tcp"},
{"vnetd",              {NULL}, 13724, "udp"},
{"bpcd",               {NULL}, 13782, "tcp"},
{"bpcd",               {NULL}, 13782, "udp"},
{"vopied",             {NULL}, 13783, "tcp"},
{"vopied",             {NULL}, 13783, "udp"},
{"nbdb",               {NULL}, 13785, "tcp"},
{"nbdb",               {NULL}, 13785, "udp"},
{"nomdb",              {NULL}, 13786, "tcp"},
{"nomdb",              {NULL}, 13786, "udp"},
{"dsmcc-config",       {NULL}, 13818, "tcp"},
{"dsmcc-config",       {NULL}, 13818, "udp"},
{"dsmcc-session",      {NULL}, 13819, "tcp"},
{"dsmcc-session",      {NULL}, 13819, "udp"},
{"dsmcc-passthru",     {NULL}, 13820, "tcp"},
{"dsmcc-passthru",     {NULL}, 13820, "udp"},
{"dsmcc-download",     {NULL}, 13821, "tcp"},
{"dsmcc-download",     {NULL}, 13821, "udp"},
{"dsmcc-ccp",          {NULL}, 13822, "tcp"},
{"dsmcc-ccp",          {NULL}, 13822, "udp"},
{"bmdss",              {NULL}, 13823, "tcp"},
{"dta-systems",        {NULL}, 13929, "tcp"},
{"dta-systems",        {NULL}, 13929, "udp"},
{"medevolve",          {NULL}, 13930, "tcp"},
{"scotty-ft",          {NULL}, 14000, "tcp"},
{"scotty-ft",          {NULL}, 14000, "udp"},
{"sua",                {NULL}, 14001, "tcp"},
{"sua",                {NULL}, 14001, "udp"},
{"sua",                {NULL}, 14001, "sctp"},
{"sage-best-com1",     {NULL}, 14033, "tcp"},
{"sage-best-com1",     {NULL}, 14033, "udp"},
{"sage-best-com2",     {NULL}, 14034, "tcp"},
{"sage-best-com2",     {NULL}, 14034, "udp"},
{"vcs-app",            {NULL}, 14141, "tcp"},
{"vcs-app",            {NULL}, 14141, "udp"},
{"icpp",               {NULL}, 14142, "tcp"},
{"icpp",               {NULL}, 14142, "udp"},
{"gcm-app",            {NULL}, 14145, "tcp"},
{"gcm-app",            {NULL}, 14145, "udp"},
{"vrts-tdd",           {NULL}, 14149, "tcp"},
{"vrts-tdd",           {NULL}, 14149, "udp"},
{"vcscmd",             {NULL}, 14150, "tcp"},
{"vad",                {NULL}, 14154, "tcp"},
{"vad",                {NULL}, 14154, "udp"},
{"cps",                {NULL}, 14250, "tcp"},
{"cps",                {NULL}, 14250, "udp"},
{"ca-web-update",      {NULL}, 14414, "tcp"},
{"ca-web-update",      {NULL}, 14414, "udp"},
{"hde-lcesrvr-1",      {NULL}, 14936, "tcp"},
{"hde-lcesrvr-1",      {NULL}, 14936, "udp"},
{"hde-lcesrvr-2",      {NULL}, 14937, "tcp"},
{"hde-lcesrvr-2",      {NULL}, 14937, "udp"},
{"hydap",              {NULL}, 15000, "tcp"},
{"hydap",              {NULL}, 15000, "udp"},
{"xpilot",             {NULL}, 15345, "tcp"},
{"xpilot",             {NULL}, 15345, "udp"},
{"3link",              {NULL}, 15363, "tcp"},
{"3link",              {NULL}, 15363, "udp"},
{"cisco-snat",         {NULL}, 15555, "tcp"},
{"cisco-snat",         {NULL}, 15555, "udp"},
{"bex-xr",             {NULL}, 15660, "tcp"},
{"bex-xr",             {NULL}, 15660, "udp"},
{"ptp",                {NULL}, 15740, "tcp"},
{"ptp",                {NULL}, 15740, "udp"},
{"2ping",              {NULL}, 15998, "udp"},
{"programmar",         {NULL}, 15999, "tcp"},
{"fmsas",              {NULL}, 16000, "tcp"},
{"fmsascon",           {NULL}, 16001, "tcp"},
{"gsms",               {NULL}, 16002, "tcp"},
{"alfin",              {NULL}, 16003, "udp"},
{"jwpc",               {NULL}, 16020, "tcp"},
{"jwpc-bin",           {NULL}, 16021, "tcp"},
{"sun-sea-port",       {NULL}, 16161, "tcp"},
{"sun-sea-port",       {NULL}, 16161, "udp"},
{"solaris-audit",      {NULL}, 16162, "tcp"},
{"etb4j",              {NULL}, 16309, "tcp"},
{"etb4j",              {NULL}, 16309, "udp"},
{"pduncs",             {NULL}, 16310, "tcp"},
{"pduncs",             {NULL}, 16310, "udp"},
{"pdefmns",            {NULL}, 16311, "tcp"},
{"pdefmns",            {NULL}, 16311, "udp"},
{"netserialext1",      {NULL}, 16360, "tcp"},
{"netserialext1",      {NULL}, 16360, "udp"},
{"netserialext2",      {NULL}, 16361, "tcp"},
{"netserialext2",      {NULL}, 16361, "udp"},
{"netserialext3",      {NULL}, 16367, "tcp"},
{"netserialext3",      {NULL}, 16367, "udp"},
{"netserialext4",      {NULL}, 16368, "tcp"},
{"netserialext4",      {NULL}, 16368, "udp"},
{"connected",          {NULL}, 16384, "tcp"},
{"connected",          {NULL}, 16384, "udp"},
{"xoms",               {NULL}, 16619, "tcp"},
{"newbay-snc-mc",      {NULL}, 16900, "tcp"},
{"newbay-snc-mc",      {NULL}, 16900, "udp"},
{"sgcip",              {NULL}, 16950, "tcp"},
{"sgcip",              {NULL}, 16950, "udp"},
{"intel-rci-mp",       {NULL}, 16991, "tcp"},
{"intel-rci-mp",       {NULL}, 16991, "udp"},
{"amt-soap-http",      {NULL}, 16992, "tcp"},
{"amt-soap-http",      {NULL}, 16992, "udp"},
{"amt-soap-https",     {NULL}, 16993, "tcp"},
{"amt-soap-https",     {NULL}, 16993, "udp"},
{"amt-redir-tcp",      {NULL}, 16994, "tcp"},
{"amt-redir-tcp",      {NULL}, 16994, "udp"},
{"amt-redir-tls",      {NULL}, 16995, "tcp"},
{"amt-redir-tls",      {NULL}, 16995, "udp"},
{"isode-dua",          {NULL}, 17007, "tcp"},
{"isode-dua",          {NULL}, 17007, "udp"},
{"soundsvirtual",      {NULL}, 17185, "tcp"},
{"soundsvirtual",      {NULL}, 17185, "udp"},
{"chipper",            {NULL}, 17219, "tcp"},
{"chipper",            {NULL}, 17219, "udp"},
{"integrius-stp",      {NULL}, 17234, "tcp"},
{"integrius-stp",      {NULL}, 17234, "udp"},
{"ssh-mgmt",           {NULL}, 17235, "tcp"},
{"ssh-mgmt",           {NULL}, 17235, "udp"},
{"db-lsp",             {NULL}, 17500, "tcp"},
{"db-lsp-disc",        {NULL}, 17500, "udp"},
{"ea",                 {NULL}, 17729, "tcp"},
{"ea",                 {NULL}, 17729, "udp"},
{"zep",                {NULL}, 17754, "tcp"},
{"zep",                {NULL}, 17754, "udp"},
{"zigbee-ip",          {NULL}, 17755, "tcp"},
{"zigbee-ip",          {NULL}, 17755, "udp"},
{"zigbee-ips",         {NULL}, 17756, "tcp"},
{"zigbee-ips",         {NULL}, 17756, "udp"},
{"sw-orion",           {NULL}, 17777, "tcp"},
{"biimenu",            {NULL}, 18000, "tcp"},
{"biimenu",            {NULL}, 18000, "udp"},
{"radpdf",             {NULL}, 18104, "tcp"},
{"racf",               {NULL}, 18136, "tcp"},
{"opsec-cvp",          {NULL}, 18181, "tcp"},
{"opsec-cvp",          {NULL}, 18181, "udp"},
{"opsec-ufp",          {NULL}, 18182, "tcp"},
{"opsec-ufp",          {NULL}, 18182, "udp"},
{"opsec-sam",          {NULL}, 18183, "tcp"},
{"opsec-sam",          {NULL}, 18183, "udp"},
{"opsec-lea",          {NULL}, 18184, "tcp"},
{"opsec-lea",          {NULL}, 18184, "udp"},
{"opsec-omi",          {NULL}, 18185, "tcp"},
{"opsec-omi",          {NULL}, 18185, "udp"},
{"ohsc",               {NULL}, 18186, "tcp"},
{"ohsc",               {NULL}, 18186, "udp"},
{"opsec-ela",          {NULL}, 18187, "tcp"},
{"opsec-ela",          {NULL}, 18187, "udp"},
{"checkpoint-rtm",     {NULL}, 18241, "tcp"},
{"checkpoint-rtm",     {NULL}, 18241, "udp"},
{"gv-pf",              {NULL}, 18262, "tcp"},
{"gv-pf",              {NULL}, 18262, "udp"},
{"ac-cluster",         {NULL}, 18463, "tcp"},
{"ac-cluster",         {NULL}, 18463, "udp"},
{"rds-ib",             {NULL}, 18634, "tcp"},
{"rds-ib",             {NULL}, 18634, "udp"},
{"rds-ip",             {NULL}, 18635, "tcp"},
{"rds-ip",             {NULL}, 18635, "udp"},
{"ique",               {NULL}, 18769, "tcp"},
{"ique",               {NULL}, 18769, "udp"},
{"infotos",            {NULL}, 18881, "tcp"},
{"infotos",            {NULL}, 18881, "udp"},
{"apc-necmp",          {NULL}, 18888, "tcp"},
{"apc-necmp",          {NULL}, 18888, "udp"},
{"igrid",              {NULL}, 19000, "tcp"},
{"igrid",              {NULL}, 19000, "udp"},
{"j-link",             {NULL}, 19020, "tcp"},
{"opsec-uaa",          {NULL}, 19191, "tcp"},
{"opsec-uaa",          {NULL}, 19191, "udp"},
{"ua-secureagent",     {NULL}, 19194, "tcp"},
{"ua-secureagent",     {NULL}, 19194, "udp"},
{"keysrvr",            {NULL}, 19283, "tcp"},
{"keysrvr",            {NULL}, 19283, "udp"},
{"keyshadow",          {NULL}, 19315, "tcp"},
{"keyshadow",          {NULL}, 19315, "udp"},
{"mtrgtrans",          {NULL}, 19398, "tcp"},
{"mtrgtrans",          {NULL}, 19398, "udp"},
{"hp-sco",             {NULL}, 19410, "tcp"},
{"hp-sco",             {NULL}, 19410, "udp"},
{"hp-sca",             {NULL}, 19411, "tcp"},
{"hp-sca",             {NULL}, 19411, "udp"},
{"hp-sessmon",         {NULL}, 19412, "tcp"},
{"hp-sessmon",         {NULL}, 19412, "udp"},
{"fxuptp",             {NULL}, 19539, "tcp"},
{"fxuptp",             {NULL}, 19539, "udp"},
{"sxuptp",             {NULL}, 19540, "tcp"},
{"sxuptp",             {NULL}, 19540, "udp"},
{"jcp",                {NULL}, 19541, "tcp"},
{"jcp",                {NULL}, 19541, "udp"},
{"iec-104-sec",        {NULL}, 19998, "tcp"},
{"dnp-sec",            {NULL}, 19999, "tcp"},
{"dnp-sec",            {NULL}, 19999, "udp"},
{"dnp",                {NULL}, 20000, "tcp"},
{"dnp",                {NULL}, 20000, "udp"},
{"microsan",           {NULL}, 20001, "tcp"},
{"microsan",           {NULL}, 20001, "udp"},
{"commtact-http",      {NULL}, 20002, "tcp"},
{"commtact-http",      {NULL}, 20002, "udp"},
{"commtact-https",     {NULL}, 20003, "tcp"},
{"commtact-https",     {NULL}, 20003, "udp"},
{"openwebnet",         {NULL}, 20005, "tcp"},
{"openwebnet",         {NULL}, 20005, "udp"},
{"ss-idi-disc",        {NULL}, 20012, "udp"},
{"ss-idi",             {NULL}, 20013, "tcp"},
{"opendeploy",         {NULL}, 20014, "tcp"},
{"opendeploy",         {NULL}, 20014, "udp"},
{"nburn_id",           {NULL}, 20034, "tcp"},
{"nburn_id",           {NULL}, 20034, "udp"},
{"tmophl7mts",         {NULL}, 20046, "tcp"},
{"tmophl7mts",         {NULL}, 20046, "udp"},
{"mountd",             {NULL}, 20048, "tcp"},
{"mountd",             {NULL}, 20048, "udp"},
{"nfsrdma",            {NULL}, 20049, "tcp"},
{"nfsrdma",            {NULL}, 20049, "udp"},
{"nfsrdma",            {NULL}, 20049, "sctp"},
{"tolfab",             {NULL}, 20167, "tcp"},
{"tolfab",             {NULL}, 20167, "udp"},
{"ipdtp-port",         {NULL}, 20202, "tcp"},
{"ipdtp-port",         {NULL}, 20202, "udp"},
{"ipulse-ics",         {NULL}, 20222, "tcp"},
{"ipulse-ics",         {NULL}, 20222, "udp"},
{"emwavemsg",          {NULL}, 20480, "tcp"},
{"emwavemsg",          {NULL}, 20480, "udp"},
{"track",              {NULL}, 20670, "tcp"},
{"track",              {NULL}, 20670, "udp"},
{"athand-mmp",         {NULL}, 20999, "tcp"},
{"athand-mmp",         {NULL}, 20999, "udp"},
{"irtrans",            {NULL}, 21000, "tcp"},
{"irtrans",            {NULL}, 21000, "udp"},
{"dfserver",           {NULL}, 21554, "tcp"},
{"dfserver",           {NULL}, 21554, "udp"},
{"vofr-gateway",       {NULL}, 21590, "tcp"},
{"vofr-gateway",       {NULL}, 21590, "udp"},
{"tvpm",               {NULL}, 21800, "tcp"},
{"tvpm",               {NULL}, 21800, "udp"},
{"webphone",           {NULL}, 21845, "tcp"},
{"webphone",           {NULL}, 21845, "udp"},
{"netspeak-is",        {NULL}, 21846, "tcp"},
{"netspeak-is",        {NULL}, 21846, "udp"},
{"netspeak-cs",        {NULL}, 21847, "tcp"},
{"netspeak-cs",        {NULL}, 21847, "udp"},
{"netspeak-acd",       {NULL}, 21848, "tcp"},
{"netspeak-acd",       {NULL}, 21848, "udp"},
{"netspeak-cps",       {NULL}, 21849, "tcp"},
{"netspeak-cps",       {NULL}, 21849, "udp"},
{"snapenetio",         {NULL}, 22000, "tcp"},
{"snapenetio",         {NULL}, 22000, "udp"},
{"optocontrol",        {NULL}, 22001, "tcp"},
{"optocontrol",        {NULL}, 22001, "udp"},
{"optohost002",        {NULL}, 22002, "tcp"},
{"optohost002",        {NULL}, 22002, "udp"},
{"optohost003",        {NULL}, 22003, "tcp"},
{"optohost003",        {NULL}, 22003, "udp"},
{"optohost004",        {NULL}, 22004, "tcp"},
{"optohost004",        {NULL}, 22004, "udp"},
{"optohost004",        {NULL}, 22005, "tcp"},
{"optohost004",        {NULL}, 22005, "udp"},
{"dcap",               {NULL}, 22125, "tcp"},
{"gsidcap",            {NULL}, 22128, "tcp"},
{"wnn6",               {NULL}, 22273, "tcp"},
{"wnn6",               {NULL}, 22273, "udp"},
{"cis",                {NULL}, 22305, "tcp"},
{"cis",                {NULL}, 22305, "udp"},
{"cis-secure",         {NULL}, 22343, "tcp"},
{"cis-secure",         {NULL}, 22343, "udp"},
{"WibuKey",            {NULL}, 22347, "tcp"},
{"WibuKey",            {NULL}, 22347, "udp"},
{"CodeMeter",          {NULL}, 22350, "tcp"},
{"CodeMeter",          {NULL}, 22350, "udp"},
{"vocaltec-wconf",     {NULL}, 22555, "tcp"},
{"vocaltec-phone",     {NULL}, 22555, "udp"},
{"talikaserver",       {NULL}, 22763, "tcp"},
{"talikaserver",       {NULL}, 22763, "udp"},
{"aws-brf",            {NULL}, 22800, "tcp"},
{"aws-brf",            {NULL}, 22800, "udp"},
{"brf-gw",             {NULL}, 22951, "tcp"},
{"brf-gw",             {NULL}, 22951, "udp"},
{"inovaport1",         {NULL}, 23000, "tcp"},
{"inovaport1",         {NULL}, 23000, "udp"},
{"inovaport2",         {NULL}, 23001, "tcp"},
{"inovaport2",         {NULL}, 23001, "udp"},
{"inovaport3",         {NULL}, 23002, "tcp"},
{"inovaport3",         {NULL}, 23002, "udp"},
{"inovaport4",         {NULL}, 23003, "tcp"},
{"inovaport4",         {NULL}, 23003, "udp"},
{"inovaport5",         {NULL}, 23004, "tcp"},
{"inovaport5",         {NULL}, 23004, "udp"},
{"inovaport6",         {NULL}, 23005, "tcp"},
{"inovaport6",         {NULL}, 23005, "udp"},
{"s102",               {NULL}, 23272, "udp"},
{"elxmgmt",            {NULL}, 23333, "tcp"},
{"elxmgmt",            {NULL}, 23333, "udp"},
{"novar-dbase",        {NULL}, 23400, "tcp"},
{"novar-dbase",        {NULL}, 23400, "udp"},
{"novar-alarm",        {NULL}, 23401, "tcp"},
{"novar-alarm",        {NULL}, 23401, "udp"},
{"novar-global",       {NULL}, 23402, "tcp"},
{"novar-global",       {NULL}, 23402, "udp"},
{"aequus",             {NULL}, 23456, "tcp"},
{"aequus-alt",         {NULL}, 23457, "tcp"},
{"med-ltp",            {NULL}, 24000, "tcp"},
{"med-ltp",            {NULL}, 24000, "udp"},
{"med-fsp-rx",         {NULL}, 24001, "tcp"},
{"med-fsp-rx",         {NULL}, 24001, "udp"},
{"med-fsp-tx",         {NULL}, 24002, "tcp"},
{"med-fsp-tx",         {NULL}, 24002, "udp"},
{"med-supp",           {NULL}, 24003, "tcp"},
{"med-supp",           {NULL}, 24003, "udp"},
{"med-ovw",            {NULL}, 24004, "tcp"},
{"med-ovw",            {NULL}, 24004, "udp"},
{"med-ci",             {NULL}, 24005, "tcp"},
{"med-ci",             {NULL}, 24005, "udp"},
{"med-net-svc",        {NULL}, 24006, "tcp"},
{"med-net-svc",        {NULL}, 24006, "udp"},
{"filesphere",         {NULL}, 24242, "tcp"},
{"filesphere",         {NULL}, 24242, "udp"},
{"vista-4gl",          {NULL}, 24249, "tcp"},
{"vista-4gl",          {NULL}, 24249, "udp"},
{"ild",                {NULL}, 24321, "tcp"},
{"ild",                {NULL}, 24321, "udp"},
{"intel_rci",          {NULL}, 24386, "tcp"},
{"intel_rci",          {NULL}, 24386, "udp"},
{"tonidods",           {NULL}, 24465, "tcp"},
{"tonidods",           {NULL}, 24465, "udp"},
{"binkp",              {NULL}, 24554, "tcp"},
{"binkp",              {NULL}, 24554, "udp"},
{"canditv",            {NULL}, 24676, "tcp"},
{"canditv",            {NULL}, 24676, "udp"},
{"flashfiler",         {NULL}, 24677, "tcp"},
{"flashfiler",         {NULL}, 24677, "udp"},
{"proactivate",        {NULL}, 24678, "tcp"},
{"proactivate",        {NULL}, 24678, "udp"},
{"tcc-http",           {NULL}, 24680, "tcp"},
{"tcc-http",           {NULL}, 24680, "udp"},
{"cslg",               {NULL}, 24754, "tcp"},
{"find",               {NULL}, 24922, "tcp"},
{"find",               {NULL}, 24922, "udp"},
{"icl-twobase1",       {NULL}, 25000, "tcp"},
{"icl-twobase1",       {NULL}, 25000, "udp"},
{"icl-twobase2",       {NULL}, 25001, "tcp"},
{"icl-twobase2",       {NULL}, 25001, "udp"},
{"icl-twobase3",       {NULL}, 25002, "tcp"},
{"icl-twobase3",       {NULL}, 25002, "udp"},
{"icl-twobase4",       {NULL}, 25003, "tcp"},
{"icl-twobase4",       {NULL}, 25003, "udp"},
{"icl-twobase5",       {NULL}, 25004, "tcp"},
{"icl-twobase5",       {NULL}, 25004, "udp"},
{"icl-twobase6",       {NULL}, 25005, "tcp"},
{"icl-twobase6",       {NULL}, 25005, "udp"},
{"icl-twobase7",       {NULL}, 25006, "tcp"},
{"icl-twobase7",       {NULL}, 25006, "udp"},
{"icl-twobase8",       {NULL}, 25007, "tcp"},
{"icl-twobase8",       {NULL}, 25007, "udp"},
{"icl-twobase9",       {NULL}, 25008, "tcp"},
{"icl-twobase9",       {NULL}, 25008, "udp"},
{"icl-twobase10",      {NULL}, 25009, "tcp"},
{"icl-twobase10",      {NULL}, 25009, "udp"},
{"rna",                {NULL}, 25471, "sctp"},
{"sauterdongle",       {NULL}, 25576, "tcp"},
{"vocaltec-hos",       {NULL}, 25793, "tcp"},
{"vocaltec-hos",       {NULL}, 25793, "udp"},
{"tasp-net",           {NULL}, 25900, "tcp"},
{"tasp-net",           {NULL}, 25900, "udp"},
{"niobserver",         {NULL}, 25901, "tcp"},
{"niobserver",         {NULL}, 25901, "udp"},
{"nilinkanalyst",      {NULL}, 25902, "tcp"},
{"nilinkanalyst",      {NULL}, 25902, "udp"},
{"niprobe",            {NULL}, 25903, "tcp"},
{"niprobe",            {NULL}, 25903, "udp"},
{"quake",              {NULL}, 26000, "tcp"},
{"quake",              {NULL}, 26000, "udp"},
{"scscp",              {NULL}, 26133, "tcp"},
{"scscp",              {NULL}, 26133, "udp"},
{"wnn6-ds",            {NULL}, 26208, "tcp"},
{"wnn6-ds",            {NULL}, 26208, "udp"},
{"ezproxy",            {NULL}, 26260, "tcp"},
{"ezproxy",            {NULL}, 26260, "udp"},
{"ezmeeting",          {NULL}, 26261, "tcp"},
{"ezmeeting",          {NULL}, 26261, "udp"},
{"k3software-svr",     {NULL}, 26262, "tcp"},
{"k3software-svr",     {NULL}, 26262, "udp"},
{"k3software-cli",     {NULL}, 26263, "tcp"},
{"k3software-cli",     {NULL}, 26263, "udp"},
{"exoline-tcp",        {NULL}, 26486, "tcp"},
{"exoline-udp",        {NULL}, 26486, "udp"},
{"exoconfig",          {NULL}, 26487, "tcp"},
{"exoconfig",          {NULL}, 26487, "udp"},
{"exonet",             {NULL}, 26489, "tcp"},
{"exonet",             {NULL}, 26489, "udp"},
{"imagepump",          {NULL}, 27345, "tcp"},
{"imagepump",          {NULL}, 27345, "udp"},
{"jesmsjc",            {NULL}, 27442, "tcp"},
{"jesmsjc",            {NULL}, 27442, "udp"},
{"kopek-httphead",     {NULL}, 27504, "tcp"},
{"kopek-httphead",     {NULL}, 27504, "udp"},
{"ars-vista",          {NULL}, 27782, "tcp"},
{"ars-vista",          {NULL}, 27782, "udp"},
{"tw-auth-key",        {NULL}, 27999, "tcp"},
{"tw-auth-key",        {NULL}, 27999, "udp"},
{"nxlmd",              {NULL}, 28000, "tcp"},
{"nxlmd",              {NULL}, 28000, "udp"},
{"pqsp",               {NULL}, 28001, "tcp"},
{"siemensgsm",         {NULL}, 28240, "tcp"},
{"siemensgsm",         {NULL}, 28240, "udp"},
{"sgsap",              {NULL}, 29118, "sctp"},
{"otmp",               {NULL}, 29167, "tcp"},
{"otmp",               {NULL}, 29167, "udp"},
{"sbcap",              {NULL}, 29168, "sctp"},
{"iuhsctpassoc",       {NULL}, 29169, "sctp"},
{"pago-services1",     {NULL}, 30001, "tcp"},
{"pago-services1",     {NULL}, 30001, "udp"},
{"pago-services2",     {NULL}, 30002, "tcp"},
{"pago-services2",     {NULL}, 30002, "udp"},
{"kingdomsonline",     {NULL}, 30260, "tcp"},
{"kingdomsonline",     {NULL}, 30260, "udp"},
{"ovobs",              {NULL}, 30999, "tcp"},
{"ovobs",              {NULL}, 30999, "udp"},
{"autotrac-acp",       {NULL}, 31020, "tcp"},
{"yawn",               {NULL}, 31029, "udp"},
{"xqosd",              {NULL}, 31416, "tcp"},
{"xqosd",              {NULL}, 31416, "udp"},
{"tetrinet",           {NULL}, 31457, "tcp"},
{"tetrinet",           {NULL}, 31457, "udp"},
{"lm-mon",             {NULL}, 31620, "tcp"},
{"lm-mon",             {NULL}, 31620, "udp"},
{"dsx_monitor",        {NULL}, 31685, "tcp"},
{"gamesmith-port",     {NULL}, 31765, "tcp"},
{"gamesmith-port",     {NULL}, 31765, "udp"},
{"iceedcp_tx",         {NULL}, 31948, "tcp"},
{"iceedcp_tx",         {NULL}, 31948, "udp"},
{"iceedcp_rx",         {NULL}, 31949, "tcp"},
{"iceedcp_rx",         {NULL}, 31949, "udp"},
{"iracinghelper",      {NULL}, 32034, "tcp"},
{"iracinghelper",      {NULL}, 32034, "udp"},
{"t1distproc60",       {NULL}, 32249, "tcp"},
{"t1distproc60",       {NULL}, 32249, "udp"},
{"apm-link",           {NULL}, 32483, "tcp"},
{"apm-link",           {NULL}, 32483, "udp"},
{"sec-ntb-clnt",       {NULL}, 32635, "tcp"},
{"sec-ntb-clnt",       {NULL}, 32635, "udp"},
{"DMExpress",          {NULL}, 32636, "tcp"},
{"DMExpress",          {NULL}, 32636, "udp"},
{"filenet-powsrm",     {NULL}, 32767, "tcp"},
{"filenet-powsrm",     {NULL}, 32767, "udp"},
{"filenet-tms",        {NULL}, 32768, "tcp"},
{"filenet-tms",        {NULL}, 32768, "udp"},
{"filenet-rpc",        {NULL}, 32769, "tcp"},
{"filenet-rpc",        {NULL}, 32769, "udp"},
{"filenet-nch",        {NULL}, 32770, "tcp"},
{"filenet-nch",        {NULL}, 32770, "udp"},
{"filenet-rmi",        {NULL}, 32771, "tcp"},
{"filenet-rmi",        {NULL}, 32771, "udp"},
{"filenet-pa",         {NULL}, 32772, "tcp"},
{"filenet-pa",         {NULL}, 32772, "udp"},
{"filenet-cm",         {NULL}, 32773, "tcp"},
{"filenet-cm",         {NULL}, 32773, "udp"},
{"filenet-re",         {NULL}, 32774, "tcp"},
{"filenet-re",         {NULL}, 32774, "udp"},
{"filenet-pch",        {NULL}, 32775, "tcp"},
{"filenet-pch",        {NULL}, 32775, "udp"},
{"filenet-peior",      {NULL}, 32776, "tcp"},
{"filenet-peior",      {NULL}, 32776, "udp"},
{"filenet-obrok",      {NULL}, 32777, "tcp"},
{"filenet-obrok",      {NULL}, 32777, "udp"},
{"mlsn",               {NULL}, 32801, "tcp"},
{"mlsn",               {NULL}, 32801, "udp"},
{"retp",               {NULL}, 32811, "tcp"},
{"idmgratm",           {NULL}, 32896, "tcp"},
{"idmgratm",           {NULL}, 32896, "udp"},
{"aurora-balaena",     {NULL}, 33123, "tcp"},
{"aurora-balaena",     {NULL}, 33123, "udp"},
{"diamondport",        {NULL}, 33331, "tcp"},
{"diamondport",        {NULL}, 33331, "udp"},
{"dgi-serv",           {NULL}, 33333, "tcp"},
{"traceroute",         {NULL}, 33434, "tcp"},
{"traceroute",         {NULL}, 33434, "udp"},
{"snip-slave",         {NULL}, 33656, "tcp"},
{"snip-slave",         {NULL}, 33656, "udp"},
{"turbonote-2",        {NULL}, 34249, "tcp"},
{"turbonote-2",        {NULL}, 34249, "udp"},
{"p-net-local",        {NULL}, 34378, "tcp"},
{"p-net-local",        {NULL}, 34378, "udp"},
{"p-net-remote",       {NULL}, 34379, "tcp"},
{"p-net-remote",       {NULL}, 34379, "udp"},
{"dhanalakshmi",       {NULL}, 34567, "tcp"},
{"profinet-rt",        {NULL}, 34962, "tcp"},
{"profinet-rt",        {NULL}, 34962, "udp"},
{"profinet-rtm",       {NULL}, 34963, "tcp"},
{"profinet-rtm",       {NULL}, 34963, "udp"},
{"profinet-cm",        {NULL}, 34964, "tcp"},
{"profinet-cm",        {NULL}, 34964, "udp"},
{"ethercat",           {NULL}, 34980, "tcp"},
{"ethercat",           {NULL}, 34980, "udp"},
{"allpeers",           {NULL}, 36001, "tcp"},
{"allpeers",           {NULL}, 36001, "udp"},
{"s1-control",         {NULL}, 36412, "sctp"},
{"x2-control",         {NULL}, 36422, "sctp"},
{"m2ap",               {NULL}, 36443, "sctp"},
{"m3ap",               {NULL}, 36444, "sctp"},
{"kastenxpipe",        {NULL}, 36865, "tcp"},
{"kastenxpipe",        {NULL}, 36865, "udp"},
{"neckar",             {NULL}, 37475, "tcp"},
{"neckar",             {NULL}, 37475, "udp"},
{"unisys-eportal",     {NULL}, 37654, "tcp"},
{"unisys-eportal",     {NULL}, 37654, "udp"},
{"galaxy7-data",       {NULL}, 38201, "tcp"},
{"galaxy7-data",       {NULL}, 38201, "udp"},
{"fairview",           {NULL}, 38202, "tcp"},
{"fairview",           {NULL}, 38202, "udp"},
{"agpolicy",           {NULL}, 38203, "tcp"},
{"agpolicy",           {NULL}, 38203, "udp"},
{"turbonote-1",        {NULL}, 39681, "tcp"},
{"turbonote-1",        {NULL}, 39681, "udp"},
{"safetynetp",         {NULL}, 40000, "tcp"},
{"safetynetp",         {NULL}, 40000, "udp"},
{"cscp",               {NULL}, 40841, "tcp"},
{"cscp",               {NULL}, 40841, "udp"},
{"csccredir",          {NULL}, 40842, "tcp"},
{"csccredir",          {NULL}, 40842, "udp"},
{"csccfirewall",       {NULL}, 40843, "tcp"},
{"csccfirewall",       {NULL}, 40843, "udp"},
{"ortec-disc",         {NULL}, 40853, "udp"},
{"fs-qos",             {NULL}, 41111, "tcp"},
{"fs-qos",             {NULL}, 41111, "udp"},
{"tentacle",           {NULL}, 41121, "tcp"},
{"crestron-cip",       {NULL}, 41794, "tcp"},
{"crestron-cip",       {NULL}, 41794, "udp"},
{"crestron-ctp",       {NULL}, 41795, "tcp"},
{"crestron-ctp",       {NULL}, 41795, "udp"},
{"candp",              {NULL}, 42508, "tcp"},
{"candp",              {NULL}, 42508, "udp"},
{"candrp",             {NULL}, 42509, "tcp"},
{"candrp",             {NULL}, 42509, "udp"},
{"caerpc",             {NULL}, 42510, "tcp"},
{"caerpc",             {NULL}, 42510, "udp"},
{"reachout",           {NULL}, 43188, "tcp"},
{"reachout",           {NULL}, 43188, "udp"},
{"ndm-agent-port",     {NULL}, 43189, "tcp"},
{"ndm-agent-port",     {NULL}, 43189, "udp"},
{"ip-provision",       {NULL}, 43190, "tcp"},
{"ip-provision",       {NULL}, 43190, "udp"},
{"noit-transport",     {NULL}, 43191, "tcp"},
{"ew-mgmt",            {NULL}, 43440, "tcp"},
{"ew-disc-cmd",        {NULL}, 43440, "udp"},
{"ciscocsdb",          {NULL}, 43441, "tcp"},
{"ciscocsdb",          {NULL}, 43441, "udp"},
{"pmcd",               {NULL}, 44321, "tcp"},
{"pmcd",               {NULL}, 44321, "udp"},
{"pmcdproxy",          {NULL}, 44322, "tcp"},
{"pmcdproxy",          {NULL}, 44322, "udp"},
{"pcp",                {NULL}, 44323, "udp"},
{"rbr-debug",          {NULL}, 44553, "tcp"},
{"rbr-debug",          {NULL}, 44553, "udp"},
{"EtherNet/IP-2",      {NULL}, 44818, "tcp"},
{"EtherNet/IP-2",      {NULL}, 44818, "udp"},
{"invision-ag",        {NULL}, 45054, "tcp"},
{"invision-ag",        {NULL}, 45054, "udp"},
{"eba",                {NULL}, 45678, "tcp"},
{"eba",                {NULL}, 45678, "udp"},
{"qdb2service",        {NULL}, 45825, "tcp"},
{"qdb2service",        {NULL}, 45825, "udp"},
{"ssr-servermgr",      {NULL}, 45966, "tcp"},
{"ssr-servermgr",      {NULL}, 45966, "udp"},
{"mediabox",           {NULL}, 46999, "tcp"},
{"mediabox",           {NULL}, 46999, "udp"},
{"mbus",               {NULL}, 47000, "tcp"},
{"mbus",               {NULL}, 47000, "udp"},
{"winrm",              {NULL}, 47001, "tcp"},
{"dbbrowse",           {NULL}, 47557, "tcp"},
{"dbbrowse",           {NULL}, 47557, "udp"},
{"directplaysrvr",     {NULL}, 47624, "tcp"},
{"directplaysrvr",     {NULL}, 47624, "udp"},
{"ap",                 {NULL}, 47806, "tcp"},
{"ap",                 {NULL}, 47806, "udp"},
{"bacnet",             {NULL}, 47808, "tcp"},
{"bacnet",             {NULL}, 47808, "udp"},
{"nimcontroller",      {NULL}, 48000, "tcp"},
{"nimcontroller",      {NULL}, 48000, "udp"},
{"nimspooler",         {NULL}, 48001, "tcp"},
{"nimspooler",         {NULL}, 48001, "udp"},
{"nimhub",             {NULL}, 48002, "tcp"},
{"nimhub",             {NULL}, 48002, "udp"},
{"nimgtw",             {NULL}, 48003, "tcp"},
{"nimgtw",             {NULL}, 48003, "udp"},
{"nimbusdb",           {NULL}, 48004, "tcp"},
{"nimbusdbctrl",       {NULL}, 48005, "tcp"},
{"3gpp-cbsp",          {NULL}, 48049, "tcp"},
{"isnetserv",          {NULL}, 48128, "tcp"},
{"isnetserv",          {NULL}, 48128, "udp"},
{"blp5",               {NULL}, 48129, "tcp"},
{"blp5",               {NULL}, 48129, "udp"},
{"com-bardac-dw",      {NULL}, 48556, "tcp"},
{"com-bardac-dw",      {NULL}, 48556, "udp"},
{"iqobject",           {NULL}, 48619, "tcp"},
{"iqobject",           {NULL}, 48619, "udp"},
#endif /* USE_IANA_REGISTERED_PORTS */
{ NULL,                {NULL}, 0, NULL }
};

struct servent *getservbyport(int port, const char *proto)
{
  unsigned short u_port;
  const char *protocol = NULL;
  int i, error = 0;

  u_port = ntohs((unsigned short)port);

  if (proto)
    {
      switch (strlen(proto)) {
      case 3:
        if (!strncasecmp(proto, "tcp", 3))
          protocol = "tcp";
        else if (!strncasecmp(proto, "udp", 3))
          protocol = "udp";
        else
          error = WSAEFAULT;
        break;
      case 4:
        if (!strncasecmp(proto, "sctp", 4))
          protocol = "sctp";
        else if (!strncasecmp(proto, "dccp", 4))
          protocol = "dccp";
        else
          error = WSAEFAULT;
        break;
      default:
        error = WSAEFAULT;
      }
    }

  if (!error)
    {
      for (i = 0; i < (sizeof(IANAports) / sizeof(IANAports[0])) - 1; i++)
        {
          if (u_port == IANAports[i].s_port)
            {
              if (!protocol || !strcasecmp(protocol, IANAports[i].s_proto))
                return (struct servent *)&IANAports[i];
            }
        }
      error = WSANO_DATA;
    }

  SET_SOCKERRNO(error);
  return NULL;
}

#endif /* _WIN32_WCE */
