# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=tt-ascalon-d8 --iterations=1 < %s | FileCheck %s

fmin.s ft0, fa0, fa1
fmax.s ft1, fa0, fa1
fmin.d ft2, ft4, ft5
fmax.d ft3, ft4, ft5
fmadd.s fs0, fs0, fs8, fs9
fmsub.s fs1, fs1, fs8, fs9
fmul.s fs3, fs3, fs4
fdiv.s fs2, fs3, fs4
fmul.d ft4, ft4, ft5
fdiv.d fs4, fa3, ft5
fsqrt.s ft1, fa2
fsqrt.d ft2, fa3

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      12
# CHECK-NEXT: Total Cycles:      31
# CHECK-NEXT: Total uOps:        12

# CHECK:      Dispatch Width:    8
# CHECK-NEXT: uOps Per Cycle:    0.39
# CHECK-NEXT: IPC:               0.39
# CHECK-NEXT: Block RThroughput: 23.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     0.50                        fmin.s	ft0, fa0, fa1
# CHECK-NEXT:  1      3     0.50                        fmax.s	ft1, fa0, fa1
# CHECK-NEXT:  1      3     0.50                        fmin.d	ft2, ft4, ft5
# CHECK-NEXT:  1      3     0.50                        fmax.d	ft3, ft4, ft5
# CHECK-NEXT:  1      3     0.50                        fmadd.s	fs0, fs0, fs8, fs9
# CHECK-NEXT:  1      3     0.50                        fmsub.s	fs1, fs1, fs8, fs9
# CHECK-NEXT:  1      3     0.50                        fmul.s	fs3, fs3, fs4
# CHECK-NEXT:  1      7     3.50                        fdiv.s	fs2, fs3, fs4
# CHECK-NEXT:  1      3     0.50                        fmul.d	ft4, ft4, ft5
# CHECK-NEXT:  1      12    6.00                        fdiv.d	fs4, fa3, ft5
# CHECK-NEXT:  1      7     3.50                        fsqrt.s	ft1, fa2
# CHECK-NEXT:  1      12    6.00                        fsqrt.d	ft2, fa3

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - AscalonFP
# CHECK-NEXT: [0.1] - AscalonFP
# CHECK-NEXT: [1]   - AscalonFXA
# CHECK-NEXT: [2]   - AscalonFXB
# CHECK-NEXT: [3.0] - AscalonFXC
# CHECK-NEXT: [3.1] - AscalonFXC
# CHECK-NEXT: [4.0] - AscalonFXD
# CHECK-NEXT: [4.1] - AscalonFXD
# CHECK-NEXT: [5.0] - AscalonLS
# CHECK-NEXT: [5.1] - AscalonLS
# CHECK-NEXT: [5.2] - AscalonLS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5.0]  [5.1]  [5.2]
# CHECK-NEXT: 18.00  28.00   -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5.0]  [5.1]  [5.2]  Instructions:
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -     fmin.s	ft0, fa0, fa1
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -     fmax.s	ft1, fa0, fa1
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -     fmin.d	ft2, ft4, ft5
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -     fmax.d	ft3, ft4, ft5
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -     fmadd.s	fs0, fs0, fs8, fs9
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -     fmsub.s	fs1, fs1, fs8, fs9
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -     fmul.s	fs3, fs3, fs4
# CHECK-NEXT: 7.00    -      -      -      -      -      -      -      -      -      -     fdiv.s	fs2, fs3, fs4
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -     fmul.d	ft4, ft4, ft5
# CHECK-NEXT:  -     12.00   -      -      -      -      -      -      -      -      -     fdiv.d	fs4, fa3, ft5
# CHECK-NEXT: 7.00    -      -      -      -      -      -      -      -      -      -     fsqrt.s	ft1, fa2
# CHECK-NEXT:  -     12.00   -      -      -      -      -      -      -      -      -     fsqrt.d	ft2, fa3
