; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=arm64-eabi -aarch64-neon-syntax=apple | FileCheck %s --check-prefix=CHECK-SD
; RUN: llc < %s -mtriple=arm64-eabi -global-isel=1 -aarch64-neon-syntax=apple | FileCheck %s --check-prefix=CHECK-GI

; Extract of an upper half of a vector is an "ext.16b v0, v0, v0, #8" insn.

define <8 x i8> @v8i8(<16 x i8> %a) nounwind {
; CHECK-SD-LABEL: v8i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ext.16b v0, v0, v0, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v8i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0[1]
; CHECK-GI-NEXT:    ret
  %ret = shufflevector <16 x i8> %a, <16 x i8> %a, <8 x i32>  <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i8> %ret
}

define <4 x i16> @v4i16(<8 x i16> %a) nounwind {
; CHECK-SD-LABEL: v4i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ext.16b v0, v0, v0, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v4i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0[1]
; CHECK-GI-NEXT:    ret
  %ret = shufflevector <8 x i16> %a, <8 x i16> %a, <4 x i32>  <i32 4, i32 5, i32 6, i32 7>
  ret <4 x i16> %ret
}

define <2 x i32> @v2i32(<4 x i32> %a) nounwind {
; CHECK-SD-LABEL: v2i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ext.16b v0, v0, v0, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v2i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0[1]
; CHECK-GI-NEXT:    ret
  %ret = shufflevector <4 x i32> %a, <4 x i32> %a, <2 x i32>  <i32 2, i32 3>
  ret <2 x i32> %ret
}

define <1 x i64> @v1i64(<2 x i64> %a) nounwind {
; CHECK-SD-LABEL: v1i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ext.16b v0, v0, v0, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v1i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0[1]
; CHECK-GI-NEXT:    ret
  %ret = shufflevector <2 x i64> %a, <2 x i64> %a, <1 x i32>  <i32 1>
  ret <1 x i64> %ret
}

define <1 x ptr> @v1p0(<2 x ptr> %a) nounwind {
; CHECK-SD-LABEL: v1p0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ext.16b v0, v0, v0, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v1p0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0[1]
; CHECK-GI-NEXT:    ret
  %ret = shufflevector <2 x ptr> %a, <2 x ptr> %a, <1 x i32>  <i32 1>
  ret <1 x ptr> %ret
}

define <2 x float> @v2f32(<4 x float> %a) nounwind {
; CHECK-SD-LABEL: v2f32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ext.16b v0, v0, v0, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v2f32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0[1]
; CHECK-GI-NEXT:    ret
  %ret = shufflevector <4 x float> %a, <4 x float> %a, <2 x i32>  <i32 2, i32 3>
  ret <2 x float> %ret
}

define <1 x double> @v1f64(<2 x double> %a) nounwind {
; CHECK-SD-LABEL: v1f64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ext.16b v0, v0, v0, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v1f64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0[1]
; CHECK-GI-NEXT:    ret
  %ret = shufflevector <2 x double> %a, <2 x double> %a, <1 x i32>  <i32 1>
  ret <1 x double> %ret
}
