/* UserUtils.c generated by valac 0.34.6, the Vala compiler
 * generated from UserUtils.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <rest/rest-proxy.h>
#include <string.h>


#define TYPE_CURSOR (cursor_get_type ())
typedef struct _Cursor Cursor;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _UserUtilsLoadFriendshipData UserUtilsLoadFriendshipData;
#define _cursor_free0(var) ((var == NULL) ? NULL : (var = (cursor_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _UserUtilsLoadFollowersData UserUtilsLoadFollowersData;
typedef struct _UserUtilsLoadFollowingData UserUtilsLoadFollowingData;
typedef struct _UserUtilsMuteUserData UserUtilsMuteUserData;

struct _Cursor {
	gint64 next_cursor;
	gboolean full;
	JsonNode* json_object;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _UserUtilsLoadFriendshipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	gint64 user_id;
	guint result;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	Account* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RestProxyCall* _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	JsonNode* root;
	JsonNode* _tmp14_;
	RestProxyCall* _tmp15_;
	JsonNode* _tmp16_;
	JsonNode* _tmp17_;
	GError* e;
	GError* _tmp18_;
	const gchar* _tmp19_;
	JsonObject* relationship;
	JsonNode* _tmp20_;
	JsonObject* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp23_;
	JsonObject* target;
	JsonObject* _tmp24_;
	JsonObject* _tmp25_;
	JsonObject* _tmp26_;
	JsonObject* source;
	JsonObject* _tmp27_;
	JsonObject* _tmp28_;
	JsonObject* _tmp29_;
	guint friendship;
	JsonObject* _tmp30_;
	gboolean _tmp31_;
	guint _tmp32_;
	JsonObject* _tmp33_;
	gboolean _tmp34_;
	guint _tmp35_;
	JsonObject* _tmp36_;
	gboolean _tmp37_;
	guint _tmp38_;
	JsonObject* _tmp39_;
	gboolean _tmp40_;
	guint _tmp41_;
	JsonObject* _tmp42_;
	gboolean _tmp43_;
	guint _tmp44_;
	GError * _inner_error_;
};

struct _UserUtilsLoadFollowersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	gint64 user_id;
	Cursor* old_cursor;
	Cursor* result;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	gint64 _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	RestProxyCall* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	RestProxyCall* _tmp12_;
	RestProxyCall* _tmp13_;
	Cursor* _tmp14_;
	RestProxyCall* _tmp15_;
	Cursor* _tmp16_;
	gint64 _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	JsonNode* root;
	JsonNode* _tmp20_;
	RestProxyCall* _tmp21_;
	JsonNode* _tmp22_;
	JsonNode* _tmp23_;
	GError* e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	JsonObject* root_obj;
	JsonNode* _tmp26_;
	JsonObject* _tmp27_;
	JsonObject* _tmp28_;
	JsonArray* user_array;
	JsonObject* _tmp29_;
	JsonArray* _tmp30_;
	JsonArray* _tmp31_;
	Cursor cursor;
	JsonObject* _tmp32_;
	gint64 _tmp33_;
	JsonArray* _tmp34_;
	guint _tmp35_;
	JsonObject* _tmp36_;
	JsonNode* _tmp37_;
	JsonNode* _tmp38_;
	Cursor _tmp39_;
	Cursor* _tmp40_;
	Cursor* _tmp41_;
	GError * _inner_error_;
};

struct _UserUtilsLoadFollowingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	gint64 user_id;
	Cursor* old_cursor;
	Cursor* result;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	gint64 _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	RestProxyCall* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	RestProxyCall* _tmp12_;
	RestProxyCall* _tmp13_;
	Cursor* _tmp14_;
	RestProxyCall* _tmp15_;
	Cursor* _tmp16_;
	gint64 _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	JsonNode* root;
	JsonNode* _tmp20_;
	RestProxyCall* _tmp21_;
	JsonNode* _tmp22_;
	JsonNode* _tmp23_;
	GError* e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	JsonObject* root_obj;
	JsonNode* _tmp26_;
	JsonObject* _tmp27_;
	JsonObject* _tmp28_;
	JsonArray* user_array;
	JsonObject* _tmp29_;
	JsonArray* _tmp30_;
	JsonArray* _tmp31_;
	Cursor cursor;
	JsonObject* _tmp32_;
	gint64 _tmp33_;
	JsonArray* _tmp34_;
	guint _tmp35_;
	JsonObject* _tmp36_;
	JsonNode* _tmp37_;
	JsonNode* _tmp38_;
	Cursor _tmp39_;
	Cursor* _tmp40_;
	Cursor* _tmp41_;
	GError * _inner_error_;
};

struct _UserUtilsMuteUserData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	gint64 to_block;
	gboolean setting;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	gboolean _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	gint64 _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	RestProxyCall* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError * _inner_error_;
};



#define FRIENDSHIP_FOLLOWED_BY ((guint) (1 << 0))
#define FRIENDSHIP_FOLLOWING ((guint) (1 << 1))
#define FRIENDSHIP_WANT_RETWEETS ((guint) (1 << 2))
#define FRIENDSHIP_BLOCKING ((guint) (1 << 3))
#define FRIENDSHIP_CAN_DM ((guint) (1 << 4))
GType cursor_get_type (void) G_GNUC_CONST;
Cursor* cursor_dup (const Cursor* self);
void cursor_free (Cursor* self);
void cursor_copy (const Cursor* self, Cursor* dest);
void cursor_destroy (Cursor* self);
static void _vala_JsonNode_free (JsonNode* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void user_utils_load_friendship_data_free (gpointer _data);
GType account_get_type (void) G_GNUC_CONST;
void user_utils_load_friendship (Account* account, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint user_utils_load_friendship_finish (GAsyncResult* _res_);
static gboolean user_utils_load_friendship_co (UserUtilsLoadFriendshipData* _data_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void tweet_utils_load_threaded (RestProxyCall* call, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void user_utils_load_friendship_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void user_utils_load_followers_data_free (gpointer _data);
void user_utils_load_followers (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_);
Cursor* user_utils_load_followers_finish (GAsyncResult* _res_);
static gboolean user_utils_load_followers_co (UserUtilsLoadFollowersData* _data_);
static void user_utils_load_followers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void user_utils_load_following_data_free (gpointer _data);
void user_utils_load_following (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_);
Cursor* user_utils_load_following_finish (GAsyncResult* _res_);
static gboolean user_utils_load_following_co (UserUtilsLoadFollowingData* _data_);
static void user_utils_load_following_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void user_utils_mute_user_data_free (gpointer _data);
void user_utils_mute_user (Account* account, gint64 to_block, gboolean setting, GAsyncReadyCallback _callback_, gpointer _user_data_);
void user_utils_mute_user_finish (GAsyncResult* _res_);
static gboolean user_utils_mute_user_co (UserUtilsMuteUserData* _data_);
static void user_utils_mute_user_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


void cursor_copy (const Cursor* self, Cursor* dest) {
	gint64 _tmp0_ = 0LL;
	gboolean _tmp1_ = FALSE;
	JsonNode* _tmp2_ = NULL;
	JsonNode* _tmp3_ = NULL;
	_tmp0_ = (*self).next_cursor;
	(*dest).next_cursor = _tmp0_;
	_tmp1_ = (*self).full;
	(*dest).full = _tmp1_;
	_tmp2_ = (*self).json_object;
	_tmp3_ = __vala_JsonNode_copy0 (_tmp2_);
	__vala_JsonNode_free0 ((*dest).json_object);
	(*dest).json_object = _tmp3_;
}


void cursor_destroy (Cursor* self) {
	__vala_JsonNode_free0 ((*self).json_object);
}


Cursor* cursor_dup (const Cursor* self) {
	Cursor* dup;
	dup = g_new0 (Cursor, 1);
	cursor_copy (self, dup);
	return dup;
}


void cursor_free (Cursor* self) {
	cursor_destroy (self);
	g_free (self);
}


GType cursor_get_type (void) {
	static volatile gsize cursor_type_id__volatile = 0;
	if (g_once_init_enter (&cursor_type_id__volatile)) {
		GType cursor_type_id;
		cursor_type_id = g_boxed_type_register_static ("Cursor", (GBoxedCopyFunc) cursor_dup, (GBoxedFreeFunc) cursor_free);
		g_once_init_leave (&cursor_type_id__volatile, cursor_type_id);
	}
	return cursor_type_id__volatile;
}


static void user_utils_load_friendship_data_free (gpointer _data) {
	UserUtilsLoadFriendshipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (UserUtilsLoadFriendshipData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void user_utils_load_friendship (Account* account, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UserUtilsLoadFriendshipData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	_data_ = g_slice_new0 (UserUtilsLoadFriendshipData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, user_utils_load_friendship);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, user_utils_load_friendship_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = user_id;
	_data_->user_id = _tmp2_;
	user_utils_load_friendship_co (_data_);
}


guint user_utils_load_friendship_finish (GAsyncResult* _res_) {
	guint result;
	UserUtilsLoadFriendshipData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void user_utils_load_friendship_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UserUtilsLoadFriendshipData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	user_utils_load_friendship_co (_data_);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gboolean user_utils_load_friendship_co (UserUtilsLoadFriendshipData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp3_, "1.1/friendships/show.json");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp4_, "GET");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->account;
	_data_->_tmp7_ = 0LL;
	_data_->_tmp7_ = _data_->_tmp6_->id;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	rest_proxy_call_add_param (_data_->_tmp5_, "source_id", _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->call;
	_data_->_tmp11_ = 0LL;
	_data_->_tmp11_ = _data_->user_id;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp10_, "target_id", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->root = NULL;
	{
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp15_, NULL, user_utils_load_friendship_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp14_ = _data_->_tmp16_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch69_g_error;
		}
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->_tmp14_;
		_data_->_tmp14_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp17_;
		__vala_JsonNode_free0 (_data_->_tmp14_);
	}
	goto __finally69;
	__catch69_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning ("UserUtils.vala:45: %s", _data_->_tmp19_);
		_data_->result = (guint) 0;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally69:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->root;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = json_node_get_object (_data_->_tmp20_);
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = json_object_get_object_member (_data_->_tmp21_, "relationship");
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _json_object_ref0 (_data_->_tmp22_);
	_data_->relationship = _data_->_tmp23_;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->relationship;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = json_object_get_object_member (_data_->_tmp24_, "target");
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _json_object_ref0 (_data_->_tmp25_);
	_data_->target = _data_->_tmp26_;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->relationship;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = json_object_get_object_member (_data_->_tmp27_, "source");
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _json_object_ref0 (_data_->_tmp28_);
	_data_->source = _data_->_tmp29_;
	_data_->friendship = (guint) 0;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->target;
	_data_->_tmp31_ = FALSE;
	_data_->_tmp31_ = json_object_get_boolean_member (_data_->_tmp30_, "following");
	if (_data_->_tmp31_) {
		_data_->_tmp32_ = 0U;
		_data_->_tmp32_ = _data_->friendship;
		_data_->friendship = _data_->_tmp32_ | FRIENDSHIP_FOLLOWED_BY;
	}
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->target;
	_data_->_tmp34_ = FALSE;
	_data_->_tmp34_ = json_object_get_boolean_member (_data_->_tmp33_, "followed_by");
	if (_data_->_tmp34_) {
		_data_->_tmp35_ = 0U;
		_data_->_tmp35_ = _data_->friendship;
		_data_->friendship = _data_->_tmp35_ | FRIENDSHIP_FOLLOWING;
	}
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->source;
	_data_->_tmp37_ = FALSE;
	_data_->_tmp37_ = json_object_get_boolean_member (_data_->_tmp36_, "want_retweets");
	if (_data_->_tmp37_) {
		_data_->_tmp38_ = 0U;
		_data_->_tmp38_ = _data_->friendship;
		_data_->friendship = _data_->_tmp38_ | FRIENDSHIP_WANT_RETWEETS;
	}
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->source;
	_data_->_tmp40_ = FALSE;
	_data_->_tmp40_ = json_object_get_boolean_member (_data_->_tmp39_, "blocking");
	if (_data_->_tmp40_) {
		_data_->_tmp41_ = 0U;
		_data_->_tmp41_ = _data_->friendship;
		_data_->friendship = _data_->_tmp41_ | FRIENDSHIP_BLOCKING;
	}
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = _data_->source;
	_data_->_tmp43_ = FALSE;
	_data_->_tmp43_ = json_object_get_boolean_member (_data_->_tmp42_, "can_dm");
	if (_data_->_tmp43_) {
		_data_->_tmp44_ = 0U;
		_data_->_tmp44_ = _data_->friendship;
		_data_->friendship = _data_->_tmp44_ | FRIENDSHIP_CAN_DM;
	}
	_data_->result = _data_->friendship;
	_json_object_unref0 (_data_->source);
	_json_object_unref0 (_data_->target);
	_json_object_unref0 (_data_->relationship);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_json_object_unref0 (_data_->source);
	_json_object_unref0 (_data_->target);
	_json_object_unref0 (_data_->relationship);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void user_utils_load_followers_data_free (gpointer _data) {
	UserUtilsLoadFollowersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_cursor_free0 (_data_->old_cursor);
	_cursor_free0 (_data_->result);
	g_slice_free (UserUtilsLoadFollowersData, _data_);
}


static gpointer _cursor_dup0 (gpointer self) {
	return self ? cursor_dup (self) : NULL;
}


void user_utils_load_followers (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UserUtilsLoadFollowersData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	Cursor* _tmp3_ = NULL;
	Cursor* _tmp4_ = NULL;
	_data_ = g_slice_new0 (UserUtilsLoadFollowersData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, user_utils_load_followers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, user_utils_load_followers_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = user_id;
	_data_->user_id = _tmp2_;
	_tmp3_ = old_cursor;
	_tmp4_ = _cursor_dup0 (_tmp3_);
	_cursor_free0 (_data_->old_cursor);
	_data_->old_cursor = _tmp4_;
	user_utils_load_followers_co (_data_);
}


Cursor* user_utils_load_followers_finish (GAsyncResult* _res_) {
	Cursor* result;
	UserUtilsLoadFollowersData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void user_utils_load_followers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UserUtilsLoadFollowersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	user_utils_load_followers_co (_data_);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gboolean user_utils_load_followers_co (UserUtilsLoadFollowersData* _data_) {
	static const gint requested = 25;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp3_, "1.1/followers/list.json");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp4_, "GET");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	_data_->_tmp6_ = 0LL;
	_data_->_tmp6_ = _data_->user_id;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp6_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	rest_proxy_call_add_param (_data_->_tmp5_, "user_id", _data_->_tmp8_);
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->call;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup_printf ("%i", requested);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	rest_proxy_call_add_param (_data_->_tmp9_, "count", _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp12_, "skip_status", "true");
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp13_, "include_user_entities", "false");
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->old_cursor;
	if (_data_->_tmp14_ != NULL) {
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->call;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->old_cursor;
		_data_->_tmp17_ = 0LL;
		_data_->_tmp17_ = (*_data_->_tmp16_).next_cursor;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp17_);
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_;
		rest_proxy_call_add_param (_data_->_tmp15_, "cursor", _data_->_tmp19_);
		_g_free0 (_data_->_tmp19_);
	}
	_data_->root = NULL;
	{
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp21_, NULL, user_utils_load_followers_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp20_ = _data_->_tmp22_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch70_g_error;
		}
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->_tmp20_;
		_data_->_tmp20_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp23_;
		__vala_JsonNode_free0 (_data_->_tmp20_);
	}
	goto __finally70;
	__catch70_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->e;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_warning ("UserUtils.vala:93: %s", _data_->_tmp25_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally70:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->root;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = json_node_get_object (_data_->_tmp26_);
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _json_object_ref0 (_data_->_tmp27_);
	_data_->root_obj = _data_->_tmp28_;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->root_obj;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = json_object_get_array_member (_data_->_tmp29_, "users");
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _json_array_ref0 (_data_->_tmp30_);
	_data_->user_array = _data_->_tmp31_;
	memset (&_data_->cursor, 0, sizeof (Cursor));
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->root_obj;
	_data_->_tmp33_ = 0LL;
	_data_->_tmp33_ = json_object_get_int_member (_data_->_tmp32_, "next_cursor");
	_data_->cursor.next_cursor = _data_->_tmp33_;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->user_array;
	_data_->_tmp35_ = 0U;
	_data_->_tmp35_ = json_array_get_length (_data_->_tmp34_);
	_data_->cursor.full = _data_->_tmp35_ < ((guint) requested);
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->root_obj;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = json_object_get_member (_data_->_tmp36_, "users");
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = __vala_JsonNode_copy0 (_data_->_tmp37_);
	__vala_JsonNode_free0 (_data_->cursor.json_object);
	_data_->cursor.json_object = _data_->_tmp38_;
	memset (&_data_->_tmp39_, 0, sizeof (Cursor));
	_data_->_tmp39_ = _data_->cursor;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _cursor_dup0 (&_data_->_tmp39_);
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = _data_->_tmp40_;
	cursor_destroy (&_data_->_tmp39_);
	_data_->result = _data_->_tmp41_;
	_json_array_unref0 (_data_->user_array);
	_json_object_unref0 (_data_->root_obj);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	cursor_destroy (&_data_->cursor);
	_json_array_unref0 (_data_->user_array);
	_json_object_unref0 (_data_->root_obj);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void user_utils_load_following_data_free (gpointer _data) {
	UserUtilsLoadFollowingData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_cursor_free0 (_data_->old_cursor);
	_cursor_free0 (_data_->result);
	g_slice_free (UserUtilsLoadFollowingData, _data_);
}


void user_utils_load_following (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UserUtilsLoadFollowingData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	Cursor* _tmp3_ = NULL;
	Cursor* _tmp4_ = NULL;
	_data_ = g_slice_new0 (UserUtilsLoadFollowingData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, user_utils_load_following);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, user_utils_load_following_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = user_id;
	_data_->user_id = _tmp2_;
	_tmp3_ = old_cursor;
	_tmp4_ = _cursor_dup0 (_tmp3_);
	_cursor_free0 (_data_->old_cursor);
	_data_->old_cursor = _tmp4_;
	user_utils_load_following_co (_data_);
}


Cursor* user_utils_load_following_finish (GAsyncResult* _res_) {
	Cursor* result;
	UserUtilsLoadFollowingData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void user_utils_load_following_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UserUtilsLoadFollowingData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	user_utils_load_following_co (_data_);
}


static gboolean user_utils_load_following_co (UserUtilsLoadFollowingData* _data_) {
	static const gint requested = 25;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp3_, "1.1/friends/list.json");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp4_, "GET");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	_data_->_tmp6_ = 0LL;
	_data_->_tmp6_ = _data_->user_id;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp6_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	rest_proxy_call_add_param (_data_->_tmp5_, "user_id", _data_->_tmp8_);
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->call;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup_printf ("%i", requested);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	rest_proxy_call_add_param (_data_->_tmp9_, "count", _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp12_, "skip_status", "true");
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp13_, "include_user_entities", "false");
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->old_cursor;
	if (_data_->_tmp14_ != NULL) {
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->call;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->old_cursor;
		_data_->_tmp17_ = 0LL;
		_data_->_tmp17_ = (*_data_->_tmp16_).next_cursor;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp17_);
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_;
		rest_proxy_call_add_param (_data_->_tmp15_, "cursor", _data_->_tmp19_);
		_g_free0 (_data_->_tmp19_);
	}
	_data_->root = NULL;
	{
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp21_, NULL, user_utils_load_following_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp20_ = _data_->_tmp22_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch71_g_error;
		}
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->_tmp20_;
		_data_->_tmp20_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp23_;
		__vala_JsonNode_free0 (_data_->_tmp20_);
	}
	goto __finally71;
	__catch71_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->e;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_warning ("UserUtils.vala:129: %s", _data_->_tmp25_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally71:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->root;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = json_node_get_object (_data_->_tmp26_);
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _json_object_ref0 (_data_->_tmp27_);
	_data_->root_obj = _data_->_tmp28_;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->root_obj;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = json_object_get_array_member (_data_->_tmp29_, "users");
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _json_array_ref0 (_data_->_tmp30_);
	_data_->user_array = _data_->_tmp31_;
	memset (&_data_->cursor, 0, sizeof (Cursor));
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->root_obj;
	_data_->_tmp33_ = 0LL;
	_data_->_tmp33_ = json_object_get_int_member (_data_->_tmp32_, "next_cursor");
	_data_->cursor.next_cursor = _data_->_tmp33_;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->user_array;
	_data_->_tmp35_ = 0U;
	_data_->_tmp35_ = json_array_get_length (_data_->_tmp34_);
	_data_->cursor.full = _data_->_tmp35_ < ((guint) requested);
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->root_obj;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = json_object_get_member (_data_->_tmp36_, "users");
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = __vala_JsonNode_copy0 (_data_->_tmp37_);
	__vala_JsonNode_free0 (_data_->cursor.json_object);
	_data_->cursor.json_object = _data_->_tmp38_;
	memset (&_data_->_tmp39_, 0, sizeof (Cursor));
	_data_->_tmp39_ = _data_->cursor;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _cursor_dup0 (&_data_->_tmp39_);
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = _data_->_tmp40_;
	cursor_destroy (&_data_->_tmp39_);
	_data_->result = _data_->_tmp41_;
	_json_array_unref0 (_data_->user_array);
	_json_object_unref0 (_data_->root_obj);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	cursor_destroy (&_data_->cursor);
	_json_array_unref0 (_data_->user_array);
	_json_object_unref0 (_data_->root_obj);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void user_utils_mute_user_data_free (gpointer _data) {
	UserUtilsMuteUserData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (UserUtilsMuteUserData, _data_);
}


void user_utils_mute_user (Account* account, gint64 to_block, gboolean setting, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UserUtilsMuteUserData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gboolean _tmp3_ = FALSE;
	_data_ = g_slice_new0 (UserUtilsMuteUserData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, user_utils_mute_user);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, user_utils_mute_user_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = to_block;
	_data_->to_block = _tmp2_;
	_tmp3_ = setting;
	_data_->setting = _tmp3_;
	user_utils_mute_user_co (_data_);
}


void user_utils_mute_user_finish (GAsyncResult* _res_) {
	UserUtilsMuteUserData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void user_utils_mute_user_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UserUtilsMuteUserData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	user_utils_mute_user_co (_data_);
}


static gboolean user_utils_mute_user_co (UserUtilsMuteUserData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp3_, "POST");
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = _data_->setting;
	if (_data_->_tmp4_) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->call;
		rest_proxy_call_set_function (_data_->_tmp5_, "1.1/mutes/users/create.json");
	} else {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->call;
		rest_proxy_call_set_function (_data_->_tmp6_, "1.1/mutes/users/destroy.json");
	}
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->call;
	_data_->_tmp8_ = 0LL;
	_data_->_tmp8_ = _data_->to_block;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp8_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_tmp9_;
	rest_proxy_call_add_param (_data_->_tmp7_, "user_id", _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	{
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->call;
		_data_->_state_ = 1;
		rest_proxy_call_invoke_async (_data_->_tmp11_, NULL, user_utils_mute_user_ready, _data_);
		return FALSE;
		_state_1:
		rest_proxy_call_invoke_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch72_g_error;
		}
	}
	goto __finally72;
	__catch72_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_critical ("UserUtils.vala:160: %s", _data_->_tmp13_);
		_g_error_free0 (_data_->e);
	}
	__finally72:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}



