/* DuplicityPlugin.c generated by valac 0.30.0, the Vala compiler
 * generated from DuplicityPlugin.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>


#define TYPE_DUPLICITY_PLUGIN (duplicity_plugin_get_type ())
#define DUPLICITY_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICITY_PLUGIN, DuplicityPlugin))
#define DUPLICITY_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICITY_PLUGIN, DuplicityPluginClass))
#define IS_DUPLICITY_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICITY_PLUGIN))
#define IS_DUPLICITY_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICITY_PLUGIN))
#define DUPLICITY_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICITY_PLUGIN, DuplicityPluginClass))

typedef struct _DuplicityPlugin DuplicityPlugin;
typedef struct _DuplicityPluginClass DuplicityPluginClass;
typedef struct _DuplicityPluginPrivate DuplicityPluginPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DUPLICITY_JOB (duplicity_job_get_type ())
#define DUPLICITY_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICITY_JOB, DuplicityJob))
#define DUPLICITY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICITY_JOB, DuplicityJobClass))
#define IS_DUPLICITY_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICITY_JOB))
#define IS_DUPLICITY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICITY_JOB))
#define DUPLICITY_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICITY_JOB, DuplicityJobClass))

typedef struct _DuplicityJob DuplicityJob;
typedef struct _DuplicityJobClass DuplicityJobClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DuplicityPlugin {
	DejaDupToolPlugin parent_instance;
	DuplicityPluginPrivate * priv;
};

struct _DuplicityPluginClass {
	DejaDupToolPluginClass parent_class;
};

struct _DuplicityPluginPrivate {
	gboolean has_been_setup;
};


static gpointer duplicity_plugin_parent_class = NULL;
static GType duplicity_plugin_type_id = 0;

GType duplicity_plugin_get_type (void) G_GNUC_CONST;
GType duplicity_plugin_register_type (GTypeModule * module);
#define DUPLICITY_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DUPLICITY_PLUGIN, DuplicityPluginPrivate))
enum  {
	DUPLICITY_PLUGIN_DUMMY_PROPERTY
};
#define DUPLICITY_PLUGIN_REQUIRED_MAJOR 0
#define DUPLICITY_PLUGIN_REQUIRED_MINOR 6
#define DUPLICITY_PLUGIN_REQUIRED_MICRO 23
static void duplicity_plugin_do_initial_setup (DuplicityPlugin* self, GError** error);
static DejaDupToolJob* duplicity_plugin_real_create_job (DejaDupToolPlugin* base, GError** error);
DuplicityJob* duplicity_job_new (void);
DuplicityJob* duplicity_job_construct (GType object_type);
GType duplicity_job_get_type (void) G_GNUC_CONST;
GType duplicity_job_register_type (GTypeModule * module);
DuplicityPlugin* duplicity_plugin_new (void);
DuplicityPlugin* duplicity_plugin_construct (GType object_type);
static GObject * duplicity_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void duplicity_plugin_finalize (GObject* obj);
void peas_register_types (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void duplicity_plugin_do_initial_setup (DuplicityPlugin* self, GError** error) {
	gchar* output = NULL;
	gchar* _tmp0_ = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* version_string = NULL;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint major = 0;
	gint minor = 0;
	gint micro = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gboolean _tmp17_ = FALSE;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gboolean _tmp27_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_spawn_command_line_sync ("duplicity --version", &_tmp0_, NULL, NULL, &_inner_error_);
	_g_free0 (output);
	output = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (output);
		return;
	}
	_tmp1_ = output;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	tokens = _tmp3_;
	tokens_length1 = _vala_array_length (_tmp2_);
	_tokens_size_ = tokens_length1;
	_tmp5_ = tokens;
	_tmp5__length1 = tokens_length1;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = tokens;
		_tmp6__length1 = tokens_length1;
		_tmp4_ = _tmp6__length1 < 2;
	}
	if (_tmp4_) {
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		_tmp7_ = _ ("Could not understand duplicity version.");
		_tmp8_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp7_);
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (output);
		return;
	}
	_tmp9_ = tokens;
	_tmp9__length1 = tokens_length1;
	_tmp10_ = tokens;
	_tmp10__length1 = tokens_length1;
	_tmp11_ = _tmp9_[_tmp10__length1 - 1];
	_tmp12_ = string_strip (_tmp11_);
	version_string = _tmp12_;
	_tmp13_ = version_string;
	_tmp17_ = deja_dup_parse_version (_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_);
	major = _tmp14_;
	minor = _tmp15_;
	micro = _tmp16_;
	if (!_tmp17_) {
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		GError* _tmp23_ = NULL;
		_tmp18_ = _ ("Could not understand duplicity version ‘%s’.");
		_tmp19_ = version_string;
		_tmp20_ = g_strdup_printf (_tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_inner_error_ = _tmp23_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (version_string);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (output);
		return;
	}
	_tmp24_ = major;
	_tmp25_ = minor;
	_tmp26_ = micro;
	_tmp27_ = deja_dup_meets_version (_tmp24_, _tmp25_, _tmp26_, DUPLICITY_PLUGIN_REQUIRED_MAJOR, DUPLICITY_PLUGIN_REQUIRED_MINOR, DUPLICITY_PLUGIN_REQUIRED_MICRO);
	if (!_tmp27_) {
		const gchar* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		GError* _tmp34_ = NULL;
		GError* _tmp35_ = NULL;
		_tmp28_ = _ ("Déjà Dup Backup Tool requires at least version %d.%d.%.2d of duplicity" \
", but only found version %d.%d.%.2d");
		_tmp29_ = major;
		_tmp30_ = minor;
		_tmp31_ = micro;
		_tmp32_ = g_strdup_printf (_tmp28_, DUPLICITY_PLUGIN_REQUIRED_MAJOR, DUPLICITY_PLUGIN_REQUIRED_MINOR, DUPLICITY_PLUGIN_REQUIRED_MICRO, _tmp29_, _tmp30_, _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_inner_error_ = _tmp35_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (version_string);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (output);
		return;
	}
	_g_free0 (version_string);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (output);
}


static DejaDupToolJob* duplicity_plugin_real_create_job (DejaDupToolPlugin* base, GError** error) {
	DuplicityPlugin * self;
	DejaDupToolJob* result = NULL;
	gboolean _tmp0_ = FALSE;
	DuplicityJob* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DuplicityPlugin*) base;
	_tmp0_ = self->priv->has_been_setup;
	if (!_tmp0_) {
		duplicity_plugin_do_initial_setup (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		self->priv->has_been_setup = TRUE;
	}
	_tmp1_ = duplicity_job_new ();
	result = (DejaDupToolJob*) _tmp1_;
	return result;
}


DuplicityPlugin* duplicity_plugin_construct (GType object_type) {
	DuplicityPlugin * self = NULL;
	self = (DuplicityPlugin*) deja_dup_tool_plugin_construct (object_type);
	return self;
}


DuplicityPlugin* duplicity_plugin_new (void) {
	return duplicity_plugin_construct (TYPE_DUPLICITY_PLUGIN);
}


static GObject * duplicity_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DuplicityPlugin * self;
	parent_class = G_OBJECT_CLASS (duplicity_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICITY_PLUGIN, DuplicityPlugin);
	deja_dup_tool_plugin_set_name ((DejaDupToolPlugin*) self, "Duplicity");
	return obj;
}


static void duplicity_plugin_class_init (DuplicityPluginClass * klass) {
	duplicity_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DuplicityPluginPrivate));
	((DejaDupToolPluginClass *) klass)->create_job = duplicity_plugin_real_create_job;
	G_OBJECT_CLASS (klass)->constructor = duplicity_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = duplicity_plugin_finalize;
}


static void duplicity_plugin_instance_init (DuplicityPlugin * self) {
	self->priv = DUPLICITY_PLUGIN_GET_PRIVATE (self);
	self->priv->has_been_setup = FALSE;
}


static void duplicity_plugin_finalize (GObject* obj) {
	DuplicityPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICITY_PLUGIN, DuplicityPlugin);
	G_OBJECT_CLASS (duplicity_plugin_parent_class)->finalize (obj);
}


GType duplicity_plugin_get_type (void) {
	return duplicity_plugin_type_id;
}


GType duplicity_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (DuplicityPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) duplicity_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DuplicityPlugin), 0, (GInstanceInitFunc) duplicity_plugin_instance_init, NULL };
	duplicity_plugin_type_id = g_type_module_register_type (module, DEJA_DUP_TYPE_TOOL_PLUGIN, "DuplicityPlugin", &g_define_type_info, 0);
	return duplicity_plugin_type_id;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void peas_register_types (GTypeModule* module) {
	PeasObjectModule* objmodule = NULL;
	GTypeModule* _tmp0_ = NULL;
	PeasObjectModule* _tmp1_ = NULL;
	g_return_if_fail (module != NULL);
	duplicity_instance_register_type (module);
	duplicity_job_register_type (module);
	duplicity_plugin_register_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, peas_object_module_get_type ()) ? ((PeasObjectModule*) _tmp0_) : NULL);
	objmodule = _tmp1_;
	peas_object_module_register_extension_type (objmodule, peas_activatable_get_type (), TYPE_DUPLICITY_PLUGIN);
	_g_object_unref0 (objmodule);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



